// (C) 2005 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#include <tdelocale.h>
#include <tdetoolbar.h>
#include <tqevent.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqslider.h>

#include "../debug.h"
#include "volumeAction.h"

#include "xineEngine.h"


class VolumeSlider : public TQFrame
{
public:
   VolumeSlider( TQWidget *parent )
         : TQFrame( parent )
   {
      slider = new TQSlider( TQt::Vertical, this, "volume" );
      label = new TQLabel( this );

      TQBoxLayout *lay = new TQVBoxLayout( this );
      lay->addWidget( slider, 0, TQt::AlignHCenter );
      lay->addWidget( label, 0, TQt::AlignHCenter );
      lay->setMargin( 4 );

      slider->setRange( 0, 100 );

      setFrameStyle( TQFrame::Plain | TQFrame::Box );
      setSizePolicy( TQSizePolicy::Minimum, TQSizePolicy::Fixed );

      hide();
   }

   TQLabel *label;
   TQSlider *slider;
};


VolumeAction::VolumeAction( TDEToolBar *bar, TDEActionCollection *ac )
      : TDEToggleAction( i18n("Volume"), "volume", TQt::Key_1, 0, 0, ac, "volume" )
      , m_anchor( 0 )
{
   m_widget = new VolumeSlider( bar->topLevelWidget() );

   connect( this, SIGNAL(toggled( bool )), SLOT(toggled( bool )) );
   connect( m_widget->slider, SIGNAL(sliderMoved( int )), SLOT(sliderMoved( int )) );
   connect( m_widget->slider, SIGNAL(sliderMoved( int )), Codeine::engine(), SLOT(setStreamParameter( int )) );
   connect( m_widget->slider, SIGNAL(sliderReleased()), SLOT(sliderReleased()) );
}

int
VolumeAction::plug( TQWidget *bar, int index )
{
   DEBUG_BLOCK

   int const id = TDEAction::plug( bar, index );

   m_anchor = (TQWidget*)bar->child( "toolbutton_volume" ); //TDEAction creates it with this name
   m_anchor->installEventFilter( this ); //so we can keep m_widget anchored

   return id;
}

void
VolumeAction::toggled( bool const b )
{
   DEBUG_BLOCK

   m_widget->raise();
   m_widget->setShown( b );
}

void
VolumeAction::sliderMoved( int v )
{
   v = 100 - v; //TQt sliders are wrong way round when vertical

   TQString const t = TQString::number( v ) + '%';

   setToolTip( i18n( "Volume: %1" ).arg( t ) );
   m_widget->label->setText( t );
}

bool
VolumeAction::eventFilter( TQObject *o, TQEvent *e )
{
   switch (e->type()) {
      case TQEvent::Move:
      case TQEvent::Resize: {
         TQWidget const * const &a = m_anchor;

         m_widget->move( a->mapTo( m_widget->parentWidget(), TQPoint( 0, a->height() ) ) );
         m_widget->resize( a->width(), m_widget->sizeHint().height() );
         return false;
      }

      //TODO one click method, flawed currently in fullscreen mode by palette change in mainwindow.cpp
/*      case TQEvent::MouseButtonPress:
         m_widget->show();
         break;

      case TQEvent::MouseButtonRelease:
         m_widget->hide();
         break;*/

      default:
         return false;
   }
}

#include "volumeAction.moc"
