// (C) 2005 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#include "adjustSizeButton.h"
#include "extern.h"
#include <kpushbutton.h>
#include <tqapplication.h>
#include <tqevent.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include "theStream.h"
#include "xineEngine.h" //videoWindow()


TQString i18n( const char *text );

namespace Codeine
{
   AdjustSizeButton::AdjustSizeButton( TQWidget *parent )
         : TQFrame( parent )
         , m_counter( 0 )
         , m_stage( 1 )
         , m_offset( 0 )
   {
      parent->installEventFilter( this );

      setPalette( TQApplication::palette() ); //videoWindow has different palette
      setFrameStyle( TQFrame::Plain | TQFrame::Box );

      m_preferred = new KPushButton( KGuiItem( i18n("Preferred Scale"), "viewmag" ), this );
      connect( m_preferred, SIGNAL(clicked()), tqApp->mainWidget(), SLOT(adjustSize()) );
      connect( m_preferred, SIGNAL(clicked()), SLOT(deleteLater()) );

      m_oneToOne = new KPushButton( KGuiItem( i18n("Scale 100%"), "viewmag1" ), this );
      connect( m_oneToOne, SIGNAL(clicked()), (TQObject*)videoWindow(), SLOT(resetZoom()) );
      connect( m_oneToOne, SIGNAL(clicked()), SLOT(deleteLater()) );

      TQBoxLayout *hbox = new TQHBoxLayout( this, 8, 6 );
      TQBoxLayout *vbox = new TQVBoxLayout( hbox );
      vbox->addWidget( new TQLabel( i18n( "<b>Adjust video scale?" ), this ) );
      vbox->addWidget( m_preferred );
      vbox->addWidget( m_oneToOne );
      hbox->addWidget( m_thingy = new TQFrame( this ) );

      m_thingy->setFixedWidth( fontMetrics().width( "X" ) );
      m_thingy->setFrameStyle( TQFrame::Plain | TQFrame::Box );
      m_thingy->setPaletteForegroundColor( paletteBackgroundColor().dark() );

      TQEvent e( TQEvent::Resize );
      eventFilter( 0, &e );

      adjustSize();
      show();

      m_timerId = startTimer( 5 );
   }

   void
   AdjustSizeButton::timerEvent( TQTimerEvent* )
   {
      TQFrame *&h = m_thingy;

      switch( m_stage )
      {
      case 1: //raise
         move();
         m_offset++;

         if( m_offset > height() )
            killTimer( m_timerId ),
            m_timerId = startTimer( 40 ),
            m_stage = 2;

         break;

      case 2: //fill in pause timer bar
         if( m_counter < h->height() - 3 )
            TQPainter( h ).fillRect( 2, 2, h->width() - 4, m_counter, palette().active().highlight() );

         if( !hasMouse() )
            m_counter++;

         if( m_counter > h->height() + 5 ) //pause for 360ms before lowering
            m_stage = 3,
            killTimer( m_timerId ),
            m_timerId = startTimer( 6 );

         break;

      case 3: //lower
         if( hasMouse() ) {
            m_stage = 1;
            m_counter = 0;
            m_thingy->repaint();
            break; }

         m_offset--;
         move();

         if( m_offset < 0 )
            deleteLater();
      }
   }

   bool
   AdjustSizeButton::eventFilter( TQObject *o, TQEvent *e )
   {
      if( e->type() == TQEvent::Resize ) {
         const TQSize preferredSize = TheStream::profile()->readSizeEntry( "Preferred Size" );
         const TQSize defaultSize = TheStream::defaultVideoSize();
         const TQSize parentSize = parentWidget()->size();

         m_preferred->setEnabled( preferredSize.isValid() && parentSize != preferredSize && defaultSize != preferredSize );
         m_oneToOne->setEnabled( defaultSize != parentSize );

         move();

         if( !m_preferred->isEnabled() && !m_oneToOne->isEnabled() && m_counter == 0 )
            deleteLater();
      }

      return false;
   }
}
