// File autogenerated

// declaration include
#include "introspectableInterface.h"

// TQt includes
#include <tqdom.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbuserror.h>
#include <tqdbusmessage.h>


namespace org
{
namespace freedesktop
{
namespace DBus
{

void IntrospectableInterface::buildIntrospectionData(TQDomElement& interfaceElement)
{
    interfaceElement.setAttribute("name", "org.freedesktop.DBus.Introspectable");

    TQDomDocument document = interfaceElement.ownerDocument();
    TQDomElement methodElement = document.createElement("method");
    methodElement.setAttribute("name", "Introspect");

    TQDomElement argumentElement = document.createElement("arg");
    argumentElement.setAttribute("name",      "data");
    argumentElement.setAttribute("type",      "s");
    argumentElement.setAttribute("direction", "out");
    methodElement.appendChild(argumentElement);

    interfaceElement.appendChild(methodElement);
}

TQT_DBusMessage IntrospectableInterface::callIntrospect(const TQT_DBusMessage& message)
{
    TQT_DBusError   error;
    TQT_DBusMessage reply;

    TQString _data;

    if (Introspect(_data, error))
    {
        reply = TQT_DBusMessage::methodReply(message);
        reply << TQT_DBusData::fromString(_data);
    }
    else
    {
        if (!error.isValid())
        {
            tqWarning("Call to implementation of org::freedesktop::DBus::IntrospectableInterface::Introspect returned 'false' but error object is not valid!");

            error = TQT_DBusError::stdFailed("org.freedesktop.DBus.Introspectable.Introspect execution failed");
        }

        reply = TQT_DBusMessage::methodError(message, error);
    }

    return reply;
}

bool IntrospectableInterface::handleMethodCall(const TQT_DBusMessage& message)
{
    if (message.interface() != "org.freedesktop.DBus.Introspectable") return false;

    if (message.member() == "Introspect")
    {
        TQT_DBusMessage reply = callIntrospect(message);
        handleMethodReply(reply);

        return true;
    }

    return false; 
}

}; // namespace DBus

}; // namespace freedesktop

}; // namespace org

// End of File

