/*
    kopetefilterchain.h - Kopete Message Filter Chain

    Copyright (c) 2004      by Richard Smith         <kde@metafoo.co.uk>
    Kopete    (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETEFILTERCHAIN_H
#define KOPETEFILTERCHAIN_H

#include <tqobject.h>
#include <tdemacros.h>
#include <ksharedptr.h>
#include "kopetemessage.h"
#include "kopetetask.h"

namespace Kopete
{

class MessageEvent;
class MessageHandler;
class ProcessMessageTask;

/**
 * @brief A chain of message handlers; the processing layer between protocol and chat view
 *
 * This class represents a chain of connected message handlers.
 *
 * This class is the client of the chain of responsibility formed by the
 * MessageHandlers, and acts as a facade for that chain, presenting a
 * more convenient interface.
 * 
 * @author Richard Smith       <kde@metafoo.co.uk>
 */
class MessageHandlerChain : public TQObject, private TDEShared
{
	TQ_OBJECT
  
public:
	friend class TDESharedPtr<MessageHandlerChain>;
	typedef TDESharedPtr<MessageHandlerChain> Ptr;
	
	/**
	 * Create a new MessageHandlerChain object with the appropriate handlers for
	 * processing messages entering @p manager in direction @p direction.
	 */
	static Ptr create( ChatSession *manager, Message::MessageDirection direction );

	ProcessMessageTask *processMessage( const Message &message );
	int capabilities();
	
private:
	MessageHandlerChain();
	~MessageHandlerChain();
	
	friend class ProcessMessageTask;
	class Private;
	Private *d;
};

/**
 * @brief A task for processing a message
 * @author Richard Smith       <kde@metafoo.co.uk>
 */
class ProcessMessageTask : public Task
{
	TQ_OBJECT
  
public:
	MessageEvent *event();
	
private slots:
	void slotStart();
	void slotDone();
	
private:
	ProcessMessageTask(MessageHandlerChain::Ptr, MessageEvent *event);
	~ProcessMessageTask();
	
	friend class MessageHandlerChain;
	class Private;
	Private *d;
};

}

#endif
