// This file is generated by tdeconfig_compiler from kmines.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <defines.h>

#include <tdeconfigskeleton.h>
#include <kdebug.h>

class Settings : public TDEConfigSkeleton
{
  public:
    class EnumLevel
    {
      public:
      enum type { Easy, Normal, Expert, Custom, COUNT };
    };
    class EnumMouseAction
    {
      public:
      enum type { Reveal, AutoReveal, ToggleFlag, ToggleUncertainFlag, None, COUNT };
    };
    class EnumButton
    {
      public:
      enum type { left, mid, right, COUNT };
      static const char* const enumToString[];
    };
    class EnumType
    {
      public:
      enum type { flag, explosion, error, COUNT };
      static const char* const enumToString[];
    };

    static Settings *self();
    ~Settings();

    /**
      Set The size of a square.
    */
    static
    void setCaseSize( int v )
    {
      if (v < 4)
      {
        kdDebug() << "setCaseSize: value " << v << " is less than the minimum value of 4" << endl;
        v = 4;
      }

      if (v > 100)
      {
        kdDebug() << "setCaseSize: value " << v << " is greater than the maximum value of 100" << endl;
        v = 100;
      }

      if (!self()->isImmutable( TQString::fromLatin1( "CaseSize" ) ))
        self()->mCaseSize = v;
    }

    /**
      Get The size of a square.
    */
    static
    int caseSize()
    {
      return self()->mCaseSize;
    }


    /**
      Get The width of the playing field.
    */
    static
    int customWidth()
    {
      return self()->mCustomWidth;
    }


    /**
      Get The height of the playing field.
    */
    static
    int customHeight()
    {
      return self()->mCustomHeight;
    }


    /**
      Get The number of mines in the playing field.
    */
    static
    int customMines()
    {
      return self()->mCustomMines;
    }


    /**
      Get Whether the "uncertain" marker may be used.
    */
    static
    bool uncertainMark()
    {
      return self()->mUncertainMark;
    }


    /**
      Get Whether the game can be played using the keyboard.
    */
    static
    bool keyboardGame()
    {
      return self()->mKeyboardGame;
    }


    /**
      Get Whether the game is paused when the window loses focus.
    */
    static
    bool pauseFocus()
    {
      return self()->mPauseFocus;
    }


    /**
      Get Whether to set flags and reveal squares in trivial situations.
    */
    static
    bool magicReveal()
    {
      return self()->mMagicReveal;
    }

    /**
      Set The difficulty level.
    */
    static
    void setLevel( int v )
    {
      if (!self()->isImmutable( TQString::fromLatin1( "level" ) ))
        self()->mLevel = v;
    }

    /**
      Get The difficulty level.
    */
    static
    int level()
    {
      return self()->mLevel;
    }


    /**
      Get Mouse button actions
    */
    static
    int mouseAction( int i )
    {
      return self()->mMouseAction[i];
    }


    /**
      Get Color
    */
    static
    TQColor color( int i )
    {
      return self()->mColor[i];
    }


    /**
      Get Mine Color
    */
    static
    TQColor mineColor( int i )
    {
      return self()->mMineColor[i];
    }

    /**
      Set Whether the menubar is visible.
    */
    static
    void setMenubarVisible( bool v )
    {
      if (!self()->isImmutable( TQString::fromLatin1( "MenubarVisible" ) ))
        self()->mMenubarVisible = v;
    }

    /**
      Get Whether the menubar is visible.
    */
    static
    bool menubarVisible()
    {
      return self()->mMenubarVisible;
    }

    static
    void writeConfig()
    {
      static_cast<TDEConfigSkeleton*>(self())->writeConfig();
    }
  protected:
    Settings();
    static Settings *mSelf;


    // Options
    int mCaseSize;
    int mCustomWidth;
    int mCustomHeight;
    int mCustomMines;
    bool mUncertainMark;
    bool mKeyboardGame;
    bool mPauseFocus;
    bool mMagicReveal;
    int mLevel;
    int mMouseAction[3];
    TQColor mColor[3];
    TQColor mMineColor[8];
    bool mMenubarVisible;

  private:
    // Include custom additions
    #include "settings_addons.h"
};

#endif

