// File autogenerated

// declaration include
#include "session1Proxy.h"

// TQt includes
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{
namespace obex
{

Session1Proxy::Session1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.obex.Session1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

Session1Proxy::~Session1Proxy()
{
    delete m_baseProxy;
}

void Session1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool Session1Proxy::GetCapabilities(TQString& capabilities, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetCapabilities", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    capabilities = reply.front().toString(&ok);
    if (!ok) return false;

    return true;
}

void Session1Proxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant Session1Proxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQString Session1Proxy::getSource(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Source", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString Session1Proxy::getDestination(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Destination", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

bool Session1Proxy::getChannel(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Channel", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQString Session1Proxy::getTarget(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Target", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString Session1Proxy::getRoot(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Root", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

}; // namespace obex

}; // namespace bluez

}; // namespace org

#include "session1Proxy.moc"

// End of File

