// File autogenerated

// declaration include
#include "client1Proxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>

// TQt D-Bus includes
#include <tqdbusdata.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{
namespace obex
{

Client1Proxy::Client1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.obex.Client1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

}

Client1Proxy::~Client1Proxy()
{
    delete m_baseProxy;
}

void Client1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool Client1Proxy::CreateSession(const TQString& destination, const TQMap< TQString, TQT_DBusVariant >& args, TQT_DBusObjectPath& session, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(destination);
    parameters << TQT_DBusData::fromStringKeyMap(TQT_DBusDataMap< TQString >(args));

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("CreateSession", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    session = reply.front().toObjectPath(&ok);
    if (!ok) return false;

    return true;
}

bool Client1Proxy::RemoveSession(const TQT_DBusObjectPath& session, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromObjectPath(session);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("RemoveSession", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;
    return true;
}

}; // namespace obex

}; // namespace bluez

}; // namespace org

#include "client1Proxy.moc"

// End of File

