#!/usr/bin/env kjscmd
var appID = "kate";
StdDirs.addResourceType("swaptabs", StdDirs.kde_default("data") + "/kate/scripts");

var client = new DCOPClient();
var config = new Config( this, "swaptabsrc" );
var documentIndex = client.call(appID, "KateDocumentManager", "activeDocumentNumber()");
var ui = StdDirs.findResource("swaptabs","swaptabs.ui");
var dlg = Factory.loadui(ui);

// Load prefs
dlg.count.value = config.readNumEntry("Spaces", 8 );
dlg.swap.selectedId = config.readNumEntry("Mode", 0 );

if( dlg.exec() == 1 )
{
	var spaces = dlg.count.value;

	var sourceText;
	var destText;
	if( dlg.selection.checked )
		sourceText = client.call(appID, "SelectionInterface#" + documentIndex, "selection()");
	else
		sourceText = client.call(appID, "EditInterface#" + documentIndex, "text()");

	if( dlg.swap.selectedId == 0 )
		destText = replaceSpaces( spaces, sourceText );
	else
		destText = replaceTabs( spaces, sourceText );

	if( dlg.selection.checked )
	{
		if( client.call(appID, "SelectionInterface#" + documentIndex, "hasSelection()") )
		{
			var startLine = client.call(appID, "SelectionInterfaceExt#" + documentIndex, "selStartLine()");
			var startCol = client.call(appID, "SelectionInterfaceExt#" + documentIndex, "selStartCol()");
			client.call(appID, "SelectionInterface#" + documentIndex, "removeSelectedText()");
			client.call(appID, "SelectionInterface#" + documentIndex, "clearSelection()");
			client.call(appID, "EditInterface#" + documentIndex, "insertText(uint,uint,TQString)", startLine, startCol, destText);
		}
		else
		{
			alert("You must first select text.");
			return false;
		}
	}
	else
		client.call(appID, "EditInterface#" + documentIndex, "setText(TQString)", destText );

	// save prefs
	config.writeNumEntry("Spaces", dlg.count.value );
	config.writeNumEntry("Mode", dlg.swap.selectedId );
}

function replaceSpaces( count, text )
{
	var regExp = new RegExp("[ ]{"+count+","+count+"}", "g");
	regExp.mulitline = true;

	returnText = text.replace( regExp, "\t");
	return returnText;
}

function replaceTabs( count, text )
{
	
	var regExp = new RegExp("[\t]","g");
	regExp.mulitline = true;

	var spaces = "";
	for( var idx = 0; idx < count; ++idx)
		spaces += " ";
	returnText =  text.replace( regExp, spaces);
	return returnText;
}
