// This file is generated by tdeconfig_compiler from taskbar.kcfg.
// All changes you do to this file will be lost.
#ifndef TASKBARSETTINGS_H
#define TASKBARSETTINGS_H

#include <tdeglobal.h>
#include <tdeconfigskeleton.h>
#include <kdebug.h>

class TDE_EXPORT TaskBarSettings : public TDEConfigSkeleton
{
  public:
    enum { DisplayIconsAndText, DisplayTextOnly, DisplayIconsOnly };
    enum { GroupNever, GroupWhenFull, GroupAlways };
    enum { ShowAll, ShowStopped, ShowRunning };
    enum { ShowTaskList, ShowOperationsMenu, ActivateRaiseOrMinimize, Activate, Raise, Lower, Minimize, ToCurrentDesktop, Close };
    enum { LeftButton, MiddleButton, RightButton };
    static const char* const EnumButtonToString[];

    TaskBarSettings( TDESharedConfig::Ptr config = TDEGlobal::sharedConfig() );
    ~TaskBarSettings();

    /**
      Set Use the global taskbar configuration
    */
    void setUseGlobalSettings( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "UseGlobalSettings" ) ))
        mUseGlobalSettings = v;
    }

    /**
      Get Use the global taskbar configuration
    */
    bool useGlobalSettings() const
    {
      return mUseGlobalSettings;
    }

    /**
      Set Allow taskbar items to be rearranged using drag and drop
    */
    void setAllowDragAndDropReArrange( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "AllowDragAndDropReArrange" ) ))
        mAllowDragAndDropReArrange = v;
    }

    /**
      Get Allow taskbar items to be rearranged using drag and drop
    */
    bool allowDragAndDropReArrange() const
    {
      return mAllowDragAndDropReArrange;
    }

    /**
      Set Show windows from all desktops
    */
    void setShowAllWindows( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "ShowAllWindows" ) ))
        mShowAllWindows = v;
    }

    /**
      Get Show windows from all desktops
    */
    bool showAllWindows() const
    {
      return mShowAllWindows;
    }

    /**
      Set Cycle through windows with mouse wheel
    */
    void setCycleWheel( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "CycleWheel" ) ))
        mCycleWheel = v;
    }

    /**
      Get Cycle through windows with mouse wheel
    */
    bool cycleWheel() const
    {
      return mCycleWheel;
    }

    /**
      Set Show only minimized windows
    */
    void setShowOnlyIconified( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "ShowOnlyIconified" ) ))
        mShowOnlyIconified = v;
    }

    /**
      Get Show only minimized windows
    */
    bool showOnlyIconified() const
    {
      return mShowOnlyIconified;
    }

    /**
      Set Display:
    */
    void setDisplayIconsNText( int v )
    {
      if (!isImmutable( TQString::fromLatin1( "DisplayIconsNText" ) ))
        mDisplayIconsNText = v;
    }

    /**
      Get Display:
    */
    int displayIconsNText() const
    {
      return mDisplayIconsNText;
    }

    /**
      Set Group similar tasks:
    */
    void setGroupTasks( int v )
    {
      if (!isImmutable( TQString::fromLatin1( "GroupTasks" ) ))
        mGroupTasks = v;
    }

    /**
      Get Group similar tasks:
    */
    int groupTasks() const
    {
      return mGroupTasks;
    }

    /**
      Set Show tasks with state:
    */
    void setShowTaskStates( int v )
    {
      if (!isImmutable( TQString::fromLatin1( "ShowTaskStates" ) ))
        mShowTaskStates = v;
    }

    /**
      Get Show tasks with state:
    */
    int showTaskStates() const
    {
      return mShowTaskStates;
    }

    /**
      Set Sort windows by desktop
    */
    void setSortByDesktop( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "SortByDesktop" ) ))
        mSortByDesktop = v;
    }

    /**
      Get Sort windows by desktop
    */
    bool sortByDesktop() const
    {
      return mSortByDesktop;
    }

    /**
      Set Sort windows by application
    */
    void setSortByApp( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "SortByApp" ) ))
        mSortByApp = v;
    }

    /**
      Get Sort windows by application
    */
    bool sortByApp() const
    {
      return mSortByApp;
    }

    /**
      Set Maximum Taskbar Button Width
    */
    void setMaximumButtonWidth( int v )
    {
      if (v < 50)
      {
        kdDebug() << "setMaximumButtonWidth: value " << v << " is less than the minimum value of 50" << endl;
        v = 50;
      }

      if (v > 500)
      {
        kdDebug() << "setMaximumButtonWidth: value " << v << " is greater than the maximum value of 500" << endl;
        v = 500;
      }

      if (!isImmutable( TQString::fromLatin1( "MaximumButtonWidth" ) ))
        mMaximumButtonWidth = v;
    }

    /**
      Get Maximum Taskbar Button Width
    */
    int maximumButtonWidth() const
    {
      return mMaximumButtonWidth;
    }

    /**
      Set Minimum Taskbar Button Height
    */
    void setMinimumButtonHeight( int v )
    {
      if (v < 1)
      {
        kdDebug() << "setMinimumButtonHeight: value " << v << " is less than the minimum value of 1" << endl;
        v = 1;
      }
      if (!isImmutable( TQString::fromLatin1( "MinimumButtonHeight" ) ))
        mMinimumButtonHeight = v;
    }

    /**
      Get Minimum Taskbar Button Height
    */
    int minimumButtonHeight() const
    {
      return mMinimumButtonHeight;
    }

    /**
      Set Show windows from all screens
    */
    void setShowCurrentScreenOnly( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "ShowCurrentScreenOnly" ) ))
        mShowCurrentScreenOnly = v;
    }

    /**
      Get Show windows from all screens
    */
    bool showCurrentScreenOnly() const
    {
      return mShowCurrentScreenOnly;
    }

    /**
      Set taskbarFont
    */
    void setTaskbarFont( const TQFont & v )
    {
      if (!isImmutable( TQString::fromLatin1( "taskbarFont" ) ))
        mTaskbarFont = v;
    }

    /**
      Get taskbarFont
    */
    TQFont taskbarFont() const
    {
      return mTaskbarFont;
    }

    /**
      Set Show window list button
    */
    void setShowWindowListBtn( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "ShowWindowListBtn" ) ))
        mShowWindowListBtn = v;
    }

    /**
      Get Show window list button
    */
    bool showWindowListBtn() const
    {
      return mShowWindowListBtn;
    }

    /**
      Set Mouse button actions
    */
    void setAction( int i, int v )
    {
      if (!isImmutable( TQString::fromLatin1( "%1Action" ).arg( TQString::fromLatin1( EnumButtonToString[i] ) ) ))
        mAction[i] = v;
    }

    /**
      Get Mouse button actions
    */
    int action( int i ) const
    {
      return mAction[i];
    }

    /**
      Set The number of times to blink a taskbar button when a window asks for attention. Setting this to 1000 or greater causes the button to blink forever.
    */
    void setAttentionBlinkIterations( int v )
    {
      if (v < 0)
      {
        kdDebug() << "setAttentionBlinkIterations: value " << v << " is less than the minimum value of 0" << endl;
        v = 0;
      }
      if (!isImmutable( TQString::fromLatin1( "AttentionBlinkIterations" ) ))
        mAttentionBlinkIterations = v;
    }

    /**
      Get The number of times to blink a taskbar button when a window asks for attention. Setting this to 1000 or greater causes the button to blink forever.
    */
    int attentionBlinkIterations() const
    {
      return mAttentionBlinkIterations;
    }

    /**
      Set Draw taskbar entries "flat" and not as a button
    */
    void setDrawButtons( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "DrawButtons" ) ))
        mDrawButtons = v;
    }

    /**
      Get Draw taskbar entries "flat" and not as a button
    */
    bool drawButtons() const
    {
      return mDrawButtons;
    }

    /**
      Set Show a visible button frame on the task the cursor is positioned over
    */
    void setShowButtonOnHover( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "ShowButtonOnHover" ) ))
        mShowButtonOnHover = v;
    }

    /**
      Get Show a visible button frame on the task the cursor is positioned over
    */
    bool showButtonOnHover() const
    {
      return mShowButtonOnHover;
    }

    /**
      Set Draw taskbar text with a halo around it
    */
    void setHaloText( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "HaloText" ) ))
        mHaloText = v;
    }

    /**
      Get Draw taskbar text with a halo around it
    */
    bool haloText() const
    {
      return mHaloText;
    }

    /**
      Set Show thumbnails instead of icons in the mouse-over effects
    */
    void setShowThumbnails( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "ShowThumbnails" ) ))
        mShowThumbnails = v;
    }

    /**
      Get Show thumbnails instead of icons in the mouse-over effects
    */
    bool showThumbnails() const
    {
      return mShowThumbnails;
    }

    /**
      Set Maximum width/height of the thumbnail in pixels
    */
    void setThumbnailMaxDimension( uint v )
    {
      if (!isImmutable( TQString::fromLatin1( "ThumbnailMaxDimension" ) ))
        mThumbnailMaxDimension = v;
    }

    /**
      Get Maximum width/height of the thumbnail in pixels
    */
    uint thumbnailMaxDimension() const
    {
      return mThumbnailMaxDimension;
    }

    /**
      Set Use custom colors for taskbar buttons text and background
    */
    void setUseCustomColors( bool v )
    {
      if (!isImmutable( TQString::fromLatin1( "UseCustomColors" ) ))
        mUseCustomColors = v;
    }

    /**
      Get Use custom colors for taskbar buttons text and background
    */
    bool useCustomColors() const
    {
      return mUseCustomColors;
    }

    /**
      Set Color to use for active task button text
    */
    void setActiveTaskTextColor( const TQColor & v )
    {
      if (!isImmutable( TQString::fromLatin1( "ActiveTaskTextColor" ) ))
        mActiveTaskTextColor = v;
    }

    /**
      Get Color to use for active task button text
    */
    TQColor activeTaskTextColor() const
    {
      return mActiveTaskTextColor;
    }

    /**
      Set Color to use for inactive tasks button text
    */
    void setInactiveTaskTextColor( const TQColor & v )
    {
      if (!isImmutable( TQString::fromLatin1( "InactiveTaskTextColor" ) ))
        mInactiveTaskTextColor = v;
    }

    /**
      Get Color to use for inactive tasks button text
    */
    TQColor inactiveTaskTextColor() const
    {
      return mInactiveTaskTextColor;
    }

    /**
      Set Color to use for taskbar buttons background
    */
    void setTaskBackgroundColor( const TQColor & v )
    {
      if (!isImmutable( TQString::fromLatin1( "TaskBackgroundColor" ) ))
        mTaskBackgroundColor = v;
    }

    /**
      Get Color to use for taskbar buttons background
    */
    TQColor taskBackgroundColor() const
    {
      return mTaskBackgroundColor;
    }

    /**
      Set IconSize
    */
    void setIconSize( uint v )
    {
      if (!isImmutable( TQString::fromLatin1( "IconSize" ) ))
        mIconSize = v;
    }

    /**
      Get IconSize
    */
    uint iconSize() const
    {
      return mIconSize;
    }

  protected:

    // General
    bool mUseGlobalSettings;
    bool mAllowDragAndDropReArrange;
    bool mShowAllWindows;
    bool mCycleWheel;
    bool mShowOnlyIconified;
    int mDisplayIconsNText;
    int mGroupTasks;
    int mShowTaskStates;
    bool mSortByDesktop;
    bool mSortByApp;
    int mMaximumButtonWidth;
    int mMinimumButtonHeight;
    bool mShowCurrentScreenOnly;
    TQFont mTaskbarFont;
    bool mShowWindowListBtn;
    int mAction[3];

    // Appearance
    int mAttentionBlinkIterations;
    bool mDrawButtons;
    bool mShowButtonOnHover;
    bool mHaloText;
    bool mShowThumbnails;
    uint mThumbnailMaxDimension;
    bool mUseCustomColors;
    TQColor mActiveTaskTextColor;
    TQColor mInactiveTaskTextColor;
    TQColor mTaskBackgroundColor;
    uint mIconSize;

  private:
};

#endif

