/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 19 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"


/* Add necessary includes here. */
#include <kdebug.h>
#include <tdelocale.h>
#include <tdeglobal.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "result.h"
#include "node.h"
#include "function.h"
#include "valuemanager.h"

extern char *yytext;

extern int gCheckIdents;

int yylex(void);
int yyerror(const char *);


#line 97 "parser.tab.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parser.tab.hh"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_NUM = 3,                        /* NUM  */
  YYSYMBOL_FN = 4,                         /* FN  */
  YYSYMBOL_ID = 5,                         /* ID  */
  YYSYMBOL_POWER = 6,                      /* "**"  */
  YYSYMBOL_SET = 7,                        /* "set"  */
  YYSYMBOL_REMOVE = 8,                     /* "remove"  */
  YYSYMBOL_DERIV = 9,                      /* "deriv"  */
  YYSYMBOL_10_ = 10,                       /* '='  */
  YYSYMBOL_11_ = 11,                       /* '('  */
  YYSYMBOL_12_ = 12,                       /* ')'  */
  YYSYMBOL_13_ = 13,                       /* '+'  */
  YYSYMBOL_14_ = 14,                       /* '-'  */
  YYSYMBOL_15_ = 15,                       /* '*'  */
  YYSYMBOL_16_ = 16,                       /* '/'  */
  YYSYMBOL_17_ = 17,                       /* ','  */
  YYSYMBOL_YYACCEPT = 18,                  /* $accept  */
  YYSYMBOL_FINAL = 19,                     /* FINAL  */
  YYSYMBOL_20_1 = 20,                      /* $@1  */
  YYSYMBOL_S = 21,                         /* S  */
  YYSYMBOL_ASSIGN = 22,                    /* ASSIGN  */
  YYSYMBOL_23_2 = 23,                      /* $@2  */
  YYSYMBOL_TERM = 24,                      /* TERM  */
  YYSYMBOL_EXP = 25,                       /* EXP  */
  YYSYMBOL_FACTOR = 26,                    /* FACTOR  */
  YYSYMBOL_EXPONENT = 27,                  /* EXPONENT  */
  YYSYMBOL_VALUE = 28,                     /* VALUE  */
  YYSYMBOL_NUMBER = 29,                    /* NUMBER  */
  YYSYMBOL_30_3 = 30,                      /* $@3  */
  YYSYMBOL_31_4 = 31,                      /* $@4  */
  YYSYMBOL_IDENT = 32,                     /* IDENT  */
  YYSYMBOL_FUNC = 33                       /* FUNC  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   129

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  18
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  16
/* YYNRULES -- Number of rules.  */
#define YYNRULES  49
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  92

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   264


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      11,    12,    15,    13,    17,    14,     2,    16,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    10,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,    87,    87,    87,    92,    95,   102,   111,   111,   118,
     125,   132,   165,   181,   189,   196,   202,   224,   243,   261,
     267,   273,   278,   283,   288,   297,   298,   299,   301,   302,
     303,   305,   306,   308,   309,   310,   311,   313,   315,   317,
     333,   333,   333,   337,   343,   348,   352,   361,   370,   374
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "NUM", "FN", "ID",
  "\"**\"", "\"set\"", "\"remove\"", "\"deriv\"", "'='", "'('", "')'",
  "'+'", "'-'", "'*'", "'/'", "','", "$accept", "FINAL", "$@1", "S",
  "ASSIGN", "$@2", "TERM", "EXP", "FACTOR", "EXPONENT", "VALUE", "NUMBER",
  "$@3", "$@4", "IDENT", "FUNC", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-12)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
     -12,    10,    54,   -12,     5,   -12,   -12,   -12,    22,    78,
      32,    87,    34,    70,   -12,    41,    56,   106,   -12,   -12,
      40,    61,    75,   -12,   -12,    83,    45,    76,    88,   -12,
      96,   -12,    -8,    13,    92,    87,   -12,   -12,   -12,    87,
     -12,    87,    87,    87,    87,    87,   -12,    87,   -12,   -12,
      87,    87,   -12,   -12,   -12,   -12,   -12,    87,   -12,    87,
      87,    -3,    64,    87,   -12,    99,   -12,   106,   106,   -12,
     -12,   102,   -12,    56,    56,    97,    56,    56,   -12,   108,
     -12,    91,   -12,   -12,   115,   -12,   -12,   118,    87,   -12,
     105,   -12
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       2,     0,     0,     1,    24,    39,    49,    48,     0,     0,
      40,     0,     0,     0,     3,    32,     4,    27,    30,    37,
      38,    47,     0,     5,     9,     0,     0,    16,     0,    10,
       0,    40,     0,    38,    47,     0,    33,    38,    47,     0,
      34,     0,     0,     0,     0,     0,    19,     0,    23,    46,
       0,     0,    20,    22,    21,     6,    43,     0,     7,     0,
       0,     0,     0,     0,    35,     0,    31,    25,    26,    28,
      29,     0,    44,    18,    17,     0,    12,    11,    14,     0,
      13,     0,    36,    45,     0,    15,    41,     0,     0,     8,
       0,    42
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -12,   -12,   -12,   -12,   103,   -12,     3,   -11,    81,    65,
     113,     1,   -12,   -12,    -1,    21
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     1,     2,    14,    59,    75,    15,    16,    17,    18,
      19,    33,    30,    88,    34,    35
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      32,    21,     7,    20,    64,    42,    43,    25,    27,    78,
       3,    38,    38,    37,    37,    23,     5,     6,     7,    49,
      54,    48,    53,    22,    47,    56,     6,     7,    65,    26,
      28,    24,    49,    54,    48,    53,    71,     5,    56,     7,
      73,    50,    29,     5,     6,     7,    74,    41,    76,    77,
      46,    47,    81,    72,    50,     4,    58,     5,     6,     7,
      79,     8,     9,    10,     5,    11,     7,    12,    13,    42,
      43,    51,    52,     5,    84,     7,    80,    90,     5,     6,
       7,    39,     6,     7,    31,    55,    11,    61,    12,    13,
       5,     6,     7,    57,    58,     5,    31,     7,    11,    62,
      12,    13,     7,    52,    42,    43,    66,    63,    86,    69,
      70,    82,    42,    43,    83,    42,    43,    91,    42,    43,
      85,    44,    45,    67,    68,    36,    40,    87,    89,    60
};

static const yytype_int8 yycheck[] =
{
      11,     2,     5,     2,    12,    13,    14,     8,     9,    12,
       0,    12,    13,    12,    13,    10,     3,     4,     5,    20,
      21,    20,    21,     2,    11,    22,     4,     5,    39,     8,
       9,     9,    33,    34,    33,    34,    47,     3,    35,     5,
      51,    20,    10,     3,     4,     5,    57,     6,    59,    60,
      10,    11,    63,    50,    33,     1,    11,     3,     4,     5,
      61,     7,     8,     9,     3,    11,     5,    13,    14,    13,
      14,    10,    11,     3,    75,     5,    12,    88,     3,     4,
       5,    11,     4,     5,     9,    10,    11,    11,    13,    14,
       3,     4,     5,    10,    11,     3,     9,     5,    11,    11,
      13,    14,     5,    11,    13,    14,    41,    11,    17,    44,
      45,    12,    13,    14,    12,    13,    14,    12,    13,    14,
      12,    15,    16,    42,    43,    12,    13,    12,    10,    26
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    19,    20,     0,     1,     3,     4,     5,     7,     8,
       9,    11,    13,    14,    21,    24,    25,    26,    27,    28,
      29,    32,    33,    10,     9,    32,    33,    32,    33,    10,
      30,     9,    25,    29,    32,    33,    28,    29,    32,    11,
      28,     6,    13,    14,    15,    16,    10,    11,    29,    32,
      33,    10,    11,    29,    32,    10,    24,    10,    11,    22,
      22,    11,    11,    11,    12,    25,    27,    26,    26,    27,
      27,    25,    24,    25,    25,    23,    25,    25,    12,    32,
      12,    25,    12,    12,    32,    12,    17,    12,    31,    10,
      25,    12
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    18,    20,    19,    21,    21,    21,    23,    22,    21,
      21,    21,    21,    21,    21,    21,    21,    21,    21,    21,
      24,    24,    24,    24,    21,    25,    25,    25,    26,    26,
      26,    27,    27,    24,    24,    24,    24,    24,    28,    29,
      30,    31,    24,    24,    24,    24,    24,    28,    32,    33
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     2,     2,     0,     5,     2,
       2,     4,     4,     4,     4,     5,     2,     4,     3,     2,
       2,     2,     2,     2,     1,     3,     3,     1,     3,     3,
       1,     3,     1,     2,     2,     3,     4,     1,     1,     1,
       0,     0,     8,     2,     3,     4,     2,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 87 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
       { gCheckIdents = 1; }
#line 1172 "parser.tab.cc"
    break;

  case 3: /* FINAL: $@1 S  */
#line 87 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                               {
    Result::setLastResult(NodePtr((yyvsp[0].node)));
    (yyval.node) = 0;
}
#line 1181 "parser.tab.cc"
    break;

  case 4: /* S: EXP  */
#line 92 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
       { (yyval.node) = (yyvsp[0].node); }
#line 1187 "parser.tab.cc"
    break;

  case 5: /* S: error '='  */
#line 95 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
             {
    Result::setLastResult(i18n("This is an invalid assignment."));

    YYABORT;
}
#line 1197 "parser.tab.cc"
    break;

  case 6: /* S: FUNC '='  */
#line 102 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
            {
    TQString s(i18n("You can't assign to function %1").arg((yyvsp[-1].fn)->name()));
    Result::setLastResult(s);

    YYABORT;
}
#line 1208 "parser.tab.cc"
    break;

  case 7: /* $@2: %empty  */
#line 111 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
            { --gCheckIdents; }
#line 1214 "parser.tab.cc"
    break;

  case 8: /* ASSIGN: '(' $@2 IDENT ')' '='  */
#line 111 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                                              {
    (yyval.ident) = (yyvsp[-2].ident);
}
#line 1222 "parser.tab.cc"
    break;

  case 9: /* S: "set" "deriv"  */
#line 118 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
             {
    TQString s(i18n("Function %1 is built-in and cannot be overridden.").arg("deriv"));
    Result::setLastResult(s);

    YYABORT;
}
#line 1233 "parser.tab.cc"
    break;

  case 10: /* S: "deriv" '='  */
#line 125 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
             {
    TQString s(i18n("Function %1 is built-in and cannot be overridden.").arg("deriv"));
    Result::setLastResult(s);

    YYABORT;
}
#line 1244 "parser.tab.cc"
    break;

  case 11: /* S: "set" FUNC ASSIGN EXP  */
#line 132 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                       {
    ++gCheckIdents;

    // We're trying to reassign an already defined function, make sure it's
    // not a built-in.
    TQString funcName = (yyvsp[-2].fn)->name();
    TQString ident = (yyvsp[-1].ident)->name();
    FunctionManager *manager = FunctionManager::instance();

    if(manager->isFunction(funcName) && !manager->isFunctionUserDefined(funcName)) {
	TQString s(i18n("Function %1 is built-in and cannot be overridden.").arg(funcName));
	Result::setLastResult(s);

	YYABORT;
    }

    if(manager->isFunction(funcName))
	manager->removeFunction(funcName);

    BaseFunction *newFn = new UserDefinedFunction(funcName.ascii(), (yyvsp[0].node));
    if(!manager->addFunction(newFn, ident)) {
	TQString s(i18n("Unable to define function %1 because it is recursive.").arg(funcName));
	Result::setLastResult(s);

	YYABORT;
    }

    Result::setLastResult(Result::Null);
    YYACCEPT;
}
#line 1279 "parser.tab.cc"
    break;

  case 12: /* S: "set" IDENT ASSIGN EXP  */
#line 165 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                        {
    ++gCheckIdents;

    TQString funcName = (yyvsp[-2].ident)->name();
    TQString ident = (yyvsp[-1].ident)->name();

    // No need to check if the function is already defined, because the
    // lexer checked for us before returning the IDENT token.
    BaseFunction *newFn = new UserDefinedFunction(funcName.ascii(), (yyvsp[0].node));
    FunctionManager::instance()->addFunction(newFn, ident);

    Result::setLastResult(Result::Null);
    YYACCEPT;
}
#line 1298 "parser.tab.cc"
    break;

  case 13: /* S: "remove" FUNC '(' ')'  */
#line 181 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                       {
    FunctionManager::instance()->removeFunction((yyvsp[-2].fn)->name());

    Result::setLastResult(Result::Null);
    YYACCEPT;
}
#line 1309 "parser.tab.cc"
    break;

  case 14: /* S: "remove" IDENT '(' ')'  */
#line 189 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                        {
    // This is an error
    Result::setLastResult(Result(i18n("Function %1 is not defined.").arg((yyvsp[-2].ident)->name())));
    YYABORT;
}
#line 1319 "parser.tab.cc"
    break;

  case 15: /* S: "remove" IDENT '(' IDENT ')'  */
#line 196 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                              {
    // This is an error
    Result::setLastResult(Result(i18n("Function %1 is not defined.").arg((yyvsp[-3].ident)->name())));
    YYABORT;
}
#line 1329 "parser.tab.cc"
    break;

  case 16: /* S: "remove" IDENT  */
#line 202 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                {
    ValueManager *manager = ValueManager::instance();
    
    if(manager->isValueSet((yyvsp[0].ident)->name()) && !manager->isValueReadOnly((yyvsp[0].ident)->name())) {
	manager->removeValue((yyvsp[0].ident)->name());

	Result::setLastResult(Result::Null);
	YYACCEPT;
    }
    else {
	TQString s;
	if(manager->isValueSet((yyvsp[0].ident)->name()))
	    s = i18n("Can't remove predefined variable %1.").arg((yyvsp[0].ident)->name());
	else
	    s = i18n("Can't remove undefined variable %1.").arg((yyvsp[0].ident)->name());

	Result::setLastResult(s);

	YYABORT;
    }
}
#line 1355 "parser.tab.cc"
    break;

  case 17: /* S: "set" IDENT '=' EXP  */
#line 224 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                     {
    ValueManager *vm = ValueManager::instance();

    if(vm->isValueReadOnly((yyvsp[-2].ident)->name())) {
	if((yyvsp[-2].ident)->name() == "pi" && (yyvsp[0].node)->value() == Abakus::number_t("3.0"))
	    Result::setLastResult(i18n("This isn't Indiana, you can't just change pi"));
	else
	    Result::setLastResult(i18n("%1 is a constant").arg((yyvsp[-2].ident)->name()));

	YYABORT;
    }

    ValueManager::instance()->setValue((yyvsp[-2].ident)->name(), (yyvsp[0].node)->value());

    Result::setLastResult(Result::Null);
    YYACCEPT;
}
#line 1377 "parser.tab.cc"
    break;

  case 18: /* S: IDENT '=' EXP  */
#line 243 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                 {
    ValueManager *vm = ValueManager::instance();

    if(vm->isValueReadOnly((yyvsp[-2].ident)->name())) {
	if((yyvsp[-2].ident)->name() == "pi" && (yyvsp[0].node)->value() == Abakus::number_t("3.0"))
	    Result::setLastResult(i18n("This isn't Indiana, you can't just change pi"));
	else
	    Result::setLastResult(i18n("%1 is a constant").arg((yyvsp[-2].ident)->name()));

	YYABORT;
    }

    ValueManager::instance()->setValue((yyvsp[-2].ident)->name(), (yyvsp[0].node)->value());

    Result::setLastResult(Result::Null);
    YYACCEPT;
}
#line 1399 "parser.tab.cc"
    break;

  case 19: /* S: NUMBER '='  */
#line 261 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
              {
    Result::setLastResult(i18n("Can't assign to %1").arg((yyvsp[-1].node)->value().toString()));
    YYABORT;
}
#line 1408 "parser.tab.cc"
    break;

  case 20: /* TERM: IDENT '('  */
#line 267 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                {
    Result::setLastResult(i18n("%1 isn't a function (or operator expected)").arg((yyvsp[-1].ident)->name()));
    YYABORT;
}
#line 1417 "parser.tab.cc"
    break;

  case 21: /* TERM: IDENT IDENT  */
#line 273 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                  {
    Result::setLastResult(i18n("Missing operator"));
    YYABORT;
}
#line 1426 "parser.tab.cc"
    break;

  case 22: /* TERM: IDENT NUMBER  */
#line 278 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                   {
    Result::setLastResult(i18n("Missing operator"));
    YYABORT;
}
#line 1435 "parser.tab.cc"
    break;

  case 23: /* TERM: NUMBER NUMBER  */
#line 283 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                    {
    Result::setLastResult(i18n("Missing operator"));
    YYABORT;
}
#line 1444 "parser.tab.cc"
    break;

  case 24: /* S: error  */
#line 288 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
         {
    Result::setLastResult(i18n("Sorry, I can't figure it out."));
    YYABORT;
}
#line 1453 "parser.tab.cc"
    break;

  case 25: /* EXP: EXP '+' FACTOR  */
#line 297 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                    { (yyval.node) = new BinaryOperator(BinaryOperator::Addition, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 1459 "parser.tab.cc"
    break;

  case 26: /* EXP: EXP '-' FACTOR  */
#line 298 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                    { (yyval.node) = new BinaryOperator(BinaryOperator::Subtraction, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 1465 "parser.tab.cc"
    break;

  case 27: /* EXP: FACTOR  */
#line 299 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
            { (yyval.node) = (yyvsp[0].node); }
#line 1471 "parser.tab.cc"
    break;

  case 28: /* FACTOR: FACTOR '*' EXPONENT  */
#line 301 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                            { (yyval.node) = new BinaryOperator(BinaryOperator::Multiplication, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 1477 "parser.tab.cc"
    break;

  case 29: /* FACTOR: FACTOR '/' EXPONENT  */
#line 302 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                            { (yyval.node) = new BinaryOperator(BinaryOperator::Division, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 1483 "parser.tab.cc"
    break;

  case 30: /* FACTOR: EXPONENT  */
#line 303 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                 { (yyval.node) = (yyvsp[0].node); }
#line 1489 "parser.tab.cc"
    break;

  case 31: /* EXPONENT: TERM "**" EXPONENT  */
#line 305 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                              { (yyval.node) = new BinaryOperator(BinaryOperator::Exponentiation, (yyvsp[-2].node), (yyvsp[0].node)); }
#line 1495 "parser.tab.cc"
    break;

  case 32: /* EXPONENT: TERM  */
#line 306 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
               { (yyval.node) = (yyvsp[0].node); }
#line 1501 "parser.tab.cc"
    break;

  case 33: /* TERM: '+' VALUE  */
#line 308 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                { (yyval.node) = (yyvsp[0].node); }
#line 1507 "parser.tab.cc"
    break;

  case 34: /* TERM: '-' VALUE  */
#line 309 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                { (yyval.node) = new UnaryOperator(UnaryOperator::Negation, (yyvsp[0].node)); }
#line 1513 "parser.tab.cc"
    break;

  case 35: /* TERM: '(' EXP ')'  */
#line 310 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                  { (yyval.node) = (yyvsp[-1].node); }
#line 1519 "parser.tab.cc"
    break;

  case 36: /* TERM: '-' '(' EXP ')'  */
#line 311 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                      { (yyval.node) = new UnaryOperator(UnaryOperator::Negation, (yyvsp[-1].node)); }
#line 1525 "parser.tab.cc"
    break;

  case 37: /* TERM: VALUE  */
#line 313 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
            { (yyval.node) = (yyvsp[0].node); }
#line 1531 "parser.tab.cc"
    break;

  case 38: /* VALUE: NUMBER  */
#line 315 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
              { (yyval.node) = (yyvsp[0].node); }
#line 1537 "parser.tab.cc"
    break;

  case 39: /* NUMBER: NUM  */
#line 317 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
            {
    TDELocale *locale = TDEGlobal::locale();
    TQChar decimal = locale->decimalSymbol()[0];

    // Replace current decimal separator with US Decimal separator to be
    // evil.
    unsigned len = strlen(yytext);
    for(unsigned i = 0; i < len; ++i)
	if(yytext[i] == decimal)
	    yytext[i] = '.';

    Abakus::number_t value(yytext);

    (yyval.node) = new NumericValue(value);
}
#line 1557 "parser.tab.cc"
    break;

  case 40: /* $@3: %empty  */
#line 333 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
            { --gCheckIdents; }
#line 1563 "parser.tab.cc"
    break;

  case 41: /* $@4: %empty  */
#line 333 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                                            { ++gCheckIdents; }
#line 1569 "parser.tab.cc"
    break;

  case 42: /* TERM: "deriv" $@3 '(' EXP ',' $@4 EXP ')'  */
#line 333 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                                                                        {
    (yyval.node) = new DerivativeFunction((yyvsp[-4].node), (yyvsp[-1].node));
}
#line 1577 "parser.tab.cc"
    break;

  case 43: /* TERM: FUNC TERM  */
#line 337 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                {
    (yyvsp[-1].fn)->setOperand((yyvsp[0].node));
    (yyval.node) = (yyvsp[-1].fn);
}
#line 1586 "parser.tab.cc"
    break;

  case 44: /* TERM: NUMBER FUNC TERM  */
#line 343 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                       {
    (yyvsp[-1].fn)->setOperand((yyvsp[0].node));
    (yyval.node) = new BinaryOperator(BinaryOperator::Multiplication, (yyvsp[-2].node), (yyvsp[-1].fn));
}
#line 1595 "parser.tab.cc"
    break;

  case 45: /* TERM: NUMBER '(' EXP ')'  */
#line 348 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                         {
    (yyval.node) = new BinaryOperator(BinaryOperator::Multiplication, (yyvsp[-3].node), (yyvsp[-1].node));
}
#line 1603 "parser.tab.cc"
    break;

  case 46: /* TERM: NUMBER IDENT  */
#line 352 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
                   {
    if(gCheckIdents > 0 && !ValueManager::instance()->isValueSet((yyvsp[0].ident)->name())) {
	Result::setLastResult(i18n("Unknown variable %1").arg((yyvsp[0].ident)->name()));
	YYABORT;
    }

    (yyval.node) = new BinaryOperator(BinaryOperator::Multiplication, (yyvsp[-1].node), (yyvsp[0].ident));
}
#line 1616 "parser.tab.cc"
    break;

  case 47: /* VALUE: IDENT  */
#line 361 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
             {
    if(gCheckIdents <= 0 || ValueManager::instance()->isValueSet((yyvsp[0].ident)->name()))
	(yyval.node) = (yyvsp[0].ident);
    else {
	Result::setLastResult(i18n("Unknown variable %1").arg((yyvsp[0].ident)->name()));
	YYABORT;
    }
}
#line 1629 "parser.tab.cc"
    break;

  case 48: /* IDENT: ID  */
#line 370 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
          {
    (yyval.ident) = new Identifier(yytext);
}
#line 1637 "parser.tab.cc"
    break;

  case 49: /* FUNC: FN  */
#line 374 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"
         {
    /* No check necessary, the lexer has already checked for us. */
    (yyval.fn) = new BuiltinFunction(yytext, 0);
}
#line 1646 "parser.tab.cc"
    break;


#line 1650 "parser.tab.cc"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 379 "/tmp/buildd/tde-packaging/arch/tde-extra/tde-abakus/src/abakus-trinity-14.1.5/src/parser.yy"


int gCheckIdents = 0;

int yyerror(const char *)
{
    return 0;
}
