#!/usr/bin/perl
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

sub loadSourceCode()
{
	open (IN, "<custom-shapes.log");

	my %sources;

	while (<IN>)
	{
		if (/==cscode== /)
		{
			if (/shape name: '/)
			{
				chop;
				s/.*shape name: '([^']+)'.*/$1/;
				$name = $_;
			}
			else
			{
				if (/==cscode== begin/)
				{
					$inside = true;
					@code = ();
				}
				else
				{
					if (/==cscode== end/)
					{
						s/^  <\/([^>]+)>/$1/;
						undef $inside;
						$sources{$name} = [ @code ];
						#print "added ", $name, "\n";
					}
				}
			}
		}
		else
		{
			if ($inside)
			{
				push @code, $_;
			}
		}
	}

	close (IN);

	return \%sources;
}

sub startSource
{
	my $count = shift;

	open (OUT, ">customshapepresets" . $count . ".cxx");
	print OUT << "EOS"
// this file was generated by: $0
// please do not edit

#include \"oox/drawingml/customshapeproperties.hxx\"
#include \"oox/token/tokenmap.hxx\"
#include <com/sun/star/awt/Rectangle.hpp>
#include <com/sun/star/awt/Size.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeAdjustmentValue.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeSegment.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeParameterPair.hpp>
#include <com/sun/star/drawing/EnhancedCustomShapeParameterType.hpp>

using rtl::OUString;
using namespace ::com::sun::star;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::drawing;
using namespace ::com::sun::star::uno;

namespace oox { namespace drawingml {

namespace
{
EOS
;

}

sub endSource
{
    my $count = shift;
    my $classes = shift;
    $endBrace > 0 && print OUT "}\n\n";

    print OUT "} // anonymous namespace\n";
    print OUT "void CustomShapeProperties::initializePresetsMap" . $count . "()\n";
    print OUT "{\n";
    for my $class (@{$classes})
    {
	print OUT "    maPresetsMap [ StaticTokenMap::get().getTokenFromUnicode( OUString( RTL_CONSTASCII_USTRINGPARAM( \"", $class, "\" ) ) ) ] = new ShapeC".$class."();\n";
    }
    print OUT "}

} } // oox // drawingml

";
}

sub generateSource
{
    my $sources = shift;
    my $count = 0;
    my $shCount = 0;

    startSource (++$count);

    my @classes = ();
    foreach $shape (keys %$sources)
    {
	push @classes, $shape;
	print OUT "class ShapeC".$shape." : public CustomShapeProvider\n";
	print OUT "{\n";
	print OUT "  virtual PropertyMap getProperties()\n";
	print OUT "  {\n";
	print OUT "    PropertyMap aPropertyMap;\n\n";
	print OUT @{$sources->{$shape}};
	print OUT "    aPropertyMap [ PROP_Type ] <<= OUString(\"ooxml-", $shape, "\");\n\n";
	print OUT "    return aPropertyMap;\n";
	print OUT "  }\n";
	print OUT "};\n";

        $shCount++;

        if ($shCount >= 35) {
            $shCount = 0;

	    endSource ($count, \@classes);
	    close OUT;
	    startSource (++$count);
	    @classes = ();
        }
    }

    endSource ($count, \@classes);

    print OUT << "EOS"

void ::oox::drawingml::CustomShapeProperties::initializePresetsMap()
{
EOS
    ;

    for ($i=1; $i <= $count; $i++) {
         print OUT "initializePresetsMap" . $i . "();\n";
    }

    print OUT "}\n";

    close OUT;
}

generateSource (loadSourceCode ());
