/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.domain.ValidatedRoaPrefix;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Locks;
import net.ripe.rpki.validator3.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ValidatedRpkiObjects {
    private static final Logger log = LoggerFactory.getLogger(ValidatedRpkiObjects.class);
    private final List<Consumer<Collection<RoaPrefixesAndRouterCertificates>>> listeners = new ArrayList();
    private final Map<Long, RoaPrefixesAndRouterCertificates> validatedObjectsByTrustAnchor = new HashMap();
    @Autowired
    private RpkiObjects rpkiObjects;
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private ValidationRuns validationRuns;
    @Autowired
    private Storage storage;
    private final ReentrantReadWriteLock dataLock = new ReentrantReadWriteLock();

    @PostConstruct
    private void initialize() {
        Long t = Time.timed(() -> {
            List trustAnchorList = (List)this.storage.readTx(tx -> this.trustAnchors.findAll(tx));
            trustAnchorList.parallelStream().forEach(ta -> this.storage.readTx0(tx -> {
                TrustAnchorData trustAnchorData = TrustAnchorData.of((Key)ta.getId(), (String)ta.getName());
                Accumulator validatedObjects = new Accumulator();
                this.validationRuns.findLatestSuccessfulCaTreeValidationRun(tx, ta).ifPresent(vr -> {
                    Set associatedPks = this.validationRuns.findAssociatedPks(tx, vr);
                    Stream roaStream = this.streamByType(tx, (Collection)associatedPks, RpkiObject.Type.ROA);
                    Stream routerCertStream = this.streamByType(tx, (Collection)associatedPks, RpkiObject.Type.ROUTER_CER);
                    Stream.concat(roaStream, routerCertStream).forEach(rpkiObject -> {
                        SortedSet locations = this.rpkiObjects.getLocations(tx, rpkiObject.key());
                        if (locations.isEmpty()) {
                            log.warn("RPKI object {} without location, skipping", (Object)rpkiObject.key());
                            return;
                        }
                        Optional maybeObject = rpkiObject.get(CertificateRepositoryObject.class, (String)locations.first());
                        if (!maybeObject.isPresent()) {
                            log.warn("Unparsable RPKI object {}, skipping", (Object)rpkiObject.key());
                            return;
                        }
                        validatedObjects.add(trustAnchorData, rpkiObject.key(), (CertificateRepositoryObject)maybeObject.get(), ImmutableSortedSet.copyOf((Collection)locations));
                    });
                    this.updateByKey(vr.getTrustAnchor(), validatedObjects);
                });
            }));
        });
        log.info("Validated objects cache initialised in {}ms", (Object)t);
    }

    void updateByKey(Ref<TrustAnchor> trustAnchor, Accumulator validatedObjects) {
        Locks.locked((Lock)this.dataLock.writeLock(), () -> {
            log.info("updating validation objects cache for trust anchor {} with {} ROA prefixes and {} router certificates", new Object[]{trustAnchor, validatedObjects.getValidatedRoaPrefixes().size(), validatedObjects.getRouterCertificates().size()});
            this.validatedObjectsByTrustAnchor.put(trustAnchor.key().asLong(), RoaPrefixesAndRouterCertificates.of((ImmutableSet)ImmutableSet.copyOf((Collection)validatedObjects.getValidatedRoaPrefixes()), (ImmutableSet)ImmutableSet.copyOf((Collection)validatedObjects.getRouterCertificates())));
        });
        this.notifyListeners();
    }

    private Stream<RpkiObject> streamByType(Tx.Read tx, Collection<Key> rpkiObjectsKeys, RpkiObject.Type type) {
        Set byType = this.rpkiObjects.getPkByType(tx, type);
        return rpkiObjectsKeys.stream().filter(byType::contains).map(k -> this.rpkiObjects.get(tx, k)).filter(Optional::isPresent).map(Optional::get);
    }

    public void remove(TrustAnchor trustAnchor) {
        long trustAnchorId = trustAnchor.key().asLong();
        Locks.locked((Lock)this.dataLock.writeLock(), () -> (RoaPrefixesAndRouterCertificates)this.validatedObjectsByTrustAnchor.remove(trustAnchorId));
        this.notifyListeners();
    }

    public ValidatedObjects<ValidatedRoaPrefix> findCurrentlyValidatedRoaPrefixes() {
        return this.findCurrentlyValidatedRoaPrefixes(null, null, null);
    }

    public ValidatedObjects<ValidatedRoaPrefix> findCurrentlyValidatedRoaPrefixes(SearchTerm searchTerm, Sorting sorting, Paging paging) {
        if (paging == null) {
            paging = Paging.of((Long)0L, (Long)Long.MAX_VALUE);
        }
        if (sorting == null) {
            sorting = Sorting.of((Sorting.By)Sorting.By.TA, (Sorting.Direction)Sorting.Direction.ASC);
        }
        Sorting finalSorting = sorting;
        Paging finalPaging = paging;
        return (ValidatedObjects)Locks.locked((Lock)this.dataLock.readLock(), () -> ValidatedObjects.of((long)this.countRoaPrefixes(searchTerm), (Stream)this.findRoaPrefixes(searchTerm, finalSorting, finalPaging)));
    }

    public ValidatedObjects<RouterCertificate> findCurrentlyValidatedRouterCertificates() {
        return (ValidatedObjects)Locks.locked((Lock)this.dataLock.readLock(), () -> ValidatedObjects.of((long)this.countRouterCertificates(), (Stream)this.findRouterCertificates()));
    }

    public void addListener(Consumer<Collection<RoaPrefixesAndRouterCertificates>> listener) {
        Locks.locked((Lock)this.dataLock.writeLock(), () -> {
            this.listeners.add(listener);
            listener.accept(this.validatedObjectsByTrustAnchor.values());
        });
    }

    private ImmutableList<RoaPrefixesAndRouterCertificates> validatedObjects() {
        return (ImmutableList)Locks.locked((Lock)this.dataLock.readLock(), () -> ImmutableList.copyOf(this.validatedObjectsByTrustAnchor.values()));
    }

    private int countRouterCertificates() {
        return this.validatedObjects().stream().mapToInt(x -> x.getRouterCertificates().size()).sum();
    }

    private Stream<RouterCertificate> findRouterCertificates() {
        return this.validatedObjects().stream().flatMap(x -> x.getRouterCertificates().stream());
    }

    private long countRoaPrefixes(SearchTerm searchTerm) {
        return this.validatedObjects().stream().flatMap(x -> x.getRoaPrefixes().stream()).filter(prefix -> searchTerm == null || searchTerm.test(prefix)).count();
    }

    private Stream<ValidatedRoaPrefix> findRoaPrefixes(SearchTerm searchTerm, Sorting sorting, Paging paging) {
        return this.validatedObjects().parallelStream().flatMap(x -> x.getRoaPrefixes().stream()).filter(prefix -> searchTerm == null || searchTerm.test(prefix)).sorted(sorting.comparator()).skip(Math.max(0L, paging.getStartFrom())).limit(Math.max(1L, paging.getPageSize()));
    }

    private void notifyListeners() {
        Locks.locked((Lock)this.dataLock.readLock(), () -> this.listeners.forEach(listener -> listener.accept(this.validatedObjectsByTrustAnchor.values())));
    }
}

