/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.config.ValidationConfig;
import net.ripe.rpki.validator3.domain.metrics.TrustAnchorMetricsService;
import net.ripe.rpki.validator3.domain.validation.CertificateTreeValidationService;
import net.ripe.rpki.validator3.domain.validation.TrustAnchorState;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.Settings;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Bench;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CertificateTreeValidationService {
    private static final Logger log = LoggerFactory.getLogger(CertificateTreeValidationService.class);
    public final long LONG_DURATION_WARNING_MS = 60000L;
    private final ValidationConfig validationConfig;
    private final TrustAnchorMetricsService taMetricsService;
    private final RpkiObjects rpkiObjects;
    private final RpkiRepositories rpkiRepositories;
    private final Settings settings;
    private final ValidationScheduler validationScheduler;
    private final ValidationRuns validationRuns;
    private final TrustAnchors trustAnchors;
    private final Storage storage;
    private final ValidatedRpkiObjects validatedRpkiObjects;
    private final TrustAnchorState trustAnchorState;

    @Autowired
    public CertificateTreeValidationService(RpkiObjects rpkiObjects, RpkiRepositories rpkiRepositories, Settings settings, ValidationScheduler validationScheduler, ValidationRuns validationRuns, TrustAnchors trustAnchors, ValidatedRpkiObjects validatedRpkiObjects, Storage storage, TrustAnchorState trustAnchorState, TrustAnchorMetricsService taMetricsService, ValidationConfig validationConfig) {
        this.rpkiObjects = rpkiObjects;
        this.rpkiRepositories = rpkiRepositories;
        this.settings = settings;
        this.validationScheduler = validationScheduler;
        this.validationRuns = validationRuns;
        this.trustAnchors = trustAnchors;
        this.validatedRpkiObjects = validatedRpkiObjects;
        this.storage = storage;
        this.taMetricsService = taMetricsService;
        this.trustAnchorState = trustAnchorState;
        this.validationConfig = validationConfig;
    }

    private void logForDuration(String message, Object o1, long delta) {
        if (delta > 60000L) {
            log.warn(String.format("SLOW: %s", message), o1, (Object)delta);
        } else {
            log.info(message, o1, (Object)delta);
        }
    }

    private void logForDuration(String message, Object o1, Object o2, long delta) {
        if (delta > 60000L) {
            log.warn(String.format("SLOW: %s", message), new Object[]{o1, o2, delta});
        } else {
            log.info(message, new Object[]{o1, o2, delta});
        }
    }

    public void validate(long trustAnchorId) {
        Optional maybeTrustAnchor = (Optional)this.storage.readTx(tx -> this.trustAnchors.get(tx, Key.of((long)trustAnchorId)));
        if (maybeTrustAnchor.isPresent()) {
            TrustAnchor trustAnchor = (TrustAnchor)maybeTrustAnchor.get();
            Bench.mark0((String)("validateTa " + trustAnchor.getName()), () -> this.validateTa(trustAnchor));
        } else {
            log.error("Couldn't find trust anchor {}", (Object)trustAnchorId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTa(TrustAnchor trustAnchor) {
        log.info("Starting tree validation for {}", (Object)trustAnchor.getName());
        long begin = System.currentTimeMillis();
        Map registeredRepositories = this.createRegisteredRepositoryMap(trustAnchor);
        Ref trustAnchorRef = (Ref)this.storage.readTx(tx -> this.trustAnchors.makeRef(tx, trustAnchor.key()));
        CertificateTreeValidationRun validationRun = new CertificateTreeValidationRun(trustAnchorRef);
        String trustAnchorLocation = (String)trustAnchor.getLocations().get(0);
        ValidationResult validationResult = ValidationResult.withLocation((String)trustAnchorLocation);
        try {
            X509ResourceCertificate trustAnchorCertificate = trustAnchor.getCertificate();
            validationResult.rejectIfNull((Object)trustAnchorCertificate, "validator.trust.anchor.certificate.available", new String[0]);
            if (trustAnchorCertificate == null) {
                return;
            }
            CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(URI.create(trustAnchorLocation), trustAnchorCertificate);
            trustAnchorCertificate.validate(trustAnchorLocation, context, null, null, this.validationConfig.validationOptions(), validationResult);
            if (validationResult.hasFailureForCurrentLocation()) {
                return;
            }
            URI locationUri = Optional.ofNullable(trustAnchorCertificate.getRrdpNotifyUri()).orElse(trustAnchorCertificate.getRepositoryUri());
            validationResult.warnIfNull((Object)locationUri, "validator.trust.anchor.certificate.rrdp.notify.uri.or.repository.uri.present", new String[0]);
            if (locationUri == null) {
                return;
            }
            List rpkiObjectsKeys = Collections.synchronizedList(new ArrayList());
            this.validateCertificateAuthority(trustAnchor, registeredRepositories, context, validationResult, rpkiObjectsKeys);
            if (rpkiObjectsKeys.isEmpty() && this.isValidationRunCompleted(validationResult)) {
                log.info("No associated objects, validation run: {}, validation result: {}", (Object)validationRun.key(), (Object)validationResult);
            }
            this.storage.writeTx0(tx -> {
                this.validationRuns.add(tx, (ValidationRun)validationRun);
                Long t = Time.timed(() -> rpkiObjectsKeys.forEach(key -> this.validationRuns.associateRpkiObjectKey(tx, validationRun, key)));
                this.logForDuration("Associated {} objects with the validation run {} in {}ms", (Object)rpkiObjectsKeys.size(), (Object)validationRun.key(), t.longValue());
                this.markTaObjectsReachable(tx, trustAnchorCertificate);
                Long tmr = Time.timed(() -> this.rpkiObjects.markReachable(tx, rpkiObjectsKeys));
                this.logForDuration("Marked {} objects as reachable in {}ms", (Object)rpkiObjectsKeys.size(), tmr.longValue());
                if (this.isValidationRunCompleted(validationResult)) {
                    trustAnchor.markInitialCertificateTreeValidationRunCompleted();
                    this.trustAnchors.update(tx, trustAnchor);
                    if (!this.settings.isInitialValidationRunCompleted((Tx.Read)tx) && this.trustAnchors.allInitialCertificateTreeValidationRunsCompleted((Tx.Read)tx)) {
                        this.settings.markInitialValidationRunCompleted(tx);
                        log.info("All trust anchors have completed their initial certificate tree validation run, validator is now ready");
                    }
                }
            });
            if (!rpkiObjectsKeys.isEmpty()) {
                this.storage.readTx0(tx -> this.validatedRpkiObjects.updateByKey(tx, trustAnchorRef, (Collection)rpkiObjectsKeys));
            }
        }
        finally {
            validationRun.completeWith(validationResult);
            this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
            this.trustAnchorState.setValidatedAfterLastRepositoryUpdate(trustAnchor);
            long delta = System.currentTimeMillis() - begin;
            this.logForDuration("Tree validation {} for {} in {}ms", (Object)validationRun.getStatus().toString().toLowerCase(), (Object)trustAnchor.getName(), delta);
            this.taMetricsService.update(trustAnchor, validationRun, delta);
        }
    }

    private void markTaObjectsReachable(Tx.Write tx, X509ResourceCertificate taCertificate) {
        InstantWithoutNanos now = InstantWithoutNanos.now();
        this.rpkiObjects.findLatestMftByAKI((Tx.Read)tx, taCertificate.getSubjectKeyIdentifier()).ifPresent(manifest -> {
            this.rpkiObjects.markReachable(tx, manifest.key(), now);
            manifest.get(ManifestCms.class, ValidationResult.withLocation((String)"ta-manifest.mft")).ifPresent(manifestCms -> this.rpkiObjects.findObjectsInManifest((Tx.Read)tx, manifestCms).forEach((entry, rpkiObject) -> this.rpkiObjects.markReachable(tx, rpkiObject.key(), now)));
        });
    }

    private boolean isValidationRunCompleted(ValidationResult validationResult) {
        return validationResult.getWarnings().stream().noneMatch(check -> check.getStatus() != ValidationStatus.PASSED && "validator.rpki.repository.pending".equals(check.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCertificateAuthority(TrustAnchor trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context, ValidationResult validationResult, List<Key> validatedObjects) {
        ValidationLocation certificateLocation = validationResult.getCurrentLocation();
        ValidationResult temporary = ValidationResult.withLocation((ValidationLocation)certificateLocation);
        try {
            RpkiRepository rpkiRepository = (RpkiRepository)Bench.mark((String)trustAnchor.getName(), (String)"registerRepository", () -> (RpkiRepository)this.storage.writeTx(tx -> this.registerRepository(tx, trustAnchor, registeredRepositories, context)));
            temporary.warnIfTrue(rpkiRepository.isPending(), "validator.rpki.repository.pending", new String[]{rpkiRepository.getLocationUri()});
            if (rpkiRepository.isPending()) {
                return;
            }
            X509ResourceCertificate certificate = context.getCertificate();
            URI manifestUri = certificate.getManifestUri();
            temporary.setLocation(new ValidationLocation(manifestUri));
            Optional manifestObject = (Optional)Bench.mark((String)trustAnchor.getName(), (String)"findLatestMftByAKI", () -> (Optional)this.storage.readTx(tx -> this.rpkiObjects.findLatestMftByAKI(tx, certificate.getSubjectKeyIdentifier())));
            if (!manifestObject.isPresent()) {
                if (rpkiRepository.getStatus() == RpkiRepository.Status.FAILED) {
                    temporary.error("validator.no.manifest.repository.failed", new String[]{rpkiRepository.getLocationUri()});
                } else {
                    temporary.error("validator.no.local.manifest.no.manifest.in.repository", new String[]{manifestUri.toString(), rpkiRepository.getLocationUri()});
                }
            }
            Optional maybeManifest = manifestObject.flatMap(x -> x.get(ManifestCms.class, temporary));
            temporary.rejectIfTrue(manifestObject.isPresent() && rpkiRepository.getStatus() == RpkiRepository.Status.FAILED && maybeManifest.isPresent() && ((ManifestCms)maybeManifest.get()).isPastValidityTime(), "validator.old.local.manifest.repository.failed", new String[]{rpkiRepository.getLocationUri()});
            if (temporary.hasFailureForCurrentLocation()) {
                return;
            }
            ManifestCms manifest = (ManifestCms)maybeManifest.get();
            List crlEntries = manifest.getFiles().entrySet().stream().filter(entry -> RepositoryObjectType.parse((String)((String)entry.getKey())) == RepositoryObjectType.Crl).collect(Collectors.toList());
            temporary.rejectIfFalse(crlEntries.size() == 1, "validator.manifest.contains.one.crl.entry", new String[]{String.valueOf(crlEntries.size())});
            if (temporary.hasFailureForCurrentLocation()) {
                return;
            }
            Map.Entry crlEntry = (Map.Entry)crlEntries.get(0);
            URI crlUri = manifestUri.resolve((String)crlEntry.getKey());
            Optional crlObject = (Optional)this.storage.readTx(tx -> this.rpkiObjects.findBySha256(tx, (byte[])crlEntry.getValue()));
            temporary.rejectIfFalse(crlObject.isPresent(), "validator.crl.found", new String[]{crlUri.toASCIIString()});
            if (temporary.hasFailureForCurrentLocation()) {
                return;
            }
            temporary.setLocation(new ValidationLocation(crlUri));
            Optional crl = crlObject.flatMap(x -> x.get(X509Crl.class, temporary));
            if (temporary.hasFailureForCurrentLocation()) {
                return;
            }
            X509Crl x509Crl = (X509Crl)crl.get();
            x509Crl.validate(crlUri.toASCIIString(), context, null, this.validationConfig.validationOptions(), temporary);
            if (temporary.hasFailureForCurrentLocation()) {
                return;
            }
            temporary.setLocation(new ValidationLocation(manifestUri));
            manifest.validate(manifestUri.toASCIIString(), context, x509Crl, manifest.getCrlUri(), this.validationConfig.validationOptions(), temporary);
            if (temporary.hasFailureForCurrentLocation()) {
                return;
            }
            validatedObjects.add(((RpkiObject)manifestObject.get()).key());
            manifest.getFiles().entrySet().parallelStream().flatMap(entry -> this.getManifestEntry(manifestUri, entry)).flatMap(tuple -> this.getCertificateRepositoryObjectValidationContext(trustAnchor, context, validatedObjects, crlUri, x509Crl, tuple)).map(tuple -> {
                ValidationResult vr = (ValidationResult)tuple.v2();
                this.validateCertificateAuthority(trustAnchor, registeredRepositories, (CertificateRepositoryObjectValidationContext)tuple.v1(), vr, validatedObjects);
                return vr;
            }).forEachOrdered(arg_0 -> ((ValidationResult)temporary).addAll(arg_0));
        }
        catch (ManifestEntryException e) {
            temporary.addAll(e.getVr());
        }
        catch (Exception e) {
            validationResult.error("unhandled.exception", new String[]{e.toString(), ExceptionUtils.getStackTrace((Throwable)e)});
        }
        finally {
            validationResult.addAll(temporary);
        }
    }

    private Stream<Tuple3<URI, RpkiObject, ValidationResult>> getManifestEntry(URI manifestUri, Map.Entry<String, byte[]> entry) {
        URI location = manifestUri.resolve(entry.getKey());
        ValidationResult temporary = ValidationResult.withLocation((ValidationLocation)new ValidationLocation(location));
        Optional object = (Optional)this.storage.readTx(tx -> this.rpkiObjects.findBySha256(tx, (byte[])entry.getValue()));
        temporary.rejectIfFalse(object.isPresent(), "validator.manifest.entry.found", new String[]{manifestUri.toASCIIString()});
        Optional<Stream> rpkiObject = object.flatMap(obj -> {
            boolean hashMatches = Arrays.equals(obj.getSha256(), (byte[])entry.getValue());
            temporary.rejectIfFalse(hashMatches, "validator.manifest.entry.hash.matches", new String[]{(String)entry.getKey()});
            return hashMatches ? object : Optional.empty();
        });
        if (this.validationConfig.isStrictValidation()) {
            return rpkiObject.map(ro -> Stream.of(new Tuple3((Object)location, ro, (Object)temporary))).orElseThrow(() -> new ManifestEntryException("Failed to get manifest entry " + (String)entry.getKey(), temporary));
        }
        return rpkiObject.map(ro -> Stream.of(new Tuple3((Object)location, ro, (Object)temporary))).orElse(Stream.empty());
    }

    private Stream<Tuple2<CertificateRepositoryObjectValidationContext, ValidationResult>> getCertificateRepositoryObjectValidationContext(TrustAnchor trustAnchor, CertificateRepositoryObjectValidationContext context, List<Key> validatedObjects, URI crlUri, X509Crl crl, Tuple3<URI, RpkiObject, ValidationResult> e) {
        URI location = (URI)e.v1();
        RpkiObject rpkiObject = (RpkiObject)e.v2();
        ValidationResult temporary = (ValidationResult)e.v3();
        Optional maybeCertificateRepositoryObject = (Optional)Bench.mark((String)trustAnchor.getName(), (String)"rpkiObject.get", () -> rpkiObject.get(CertificateRepositoryObject.class, temporary));
        if (!temporary.hasFailureForCurrentLocation() && maybeCertificateRepositoryObject.isPresent()) {
            CertificateRepositoryObject certificateRepositoryObject = (CertificateRepositoryObject)maybeCertificateRepositoryObject.get();
            Bench.mark0((String)trustAnchor.getName(), (String)"certificateRepositoryObject.validate", () -> certificateRepositoryObject.validate(location.toASCIIString(), context, crl, crlUri, this.validationConfig.validationOptions(), temporary));
            if (!temporary.hasFailureForCurrentLocation()) {
                validatedObjects.add(rpkiObject.key());
            }
            if (certificateRepositoryObject instanceof X509ResourceCertificate && ((X509ResourceCertificate)certificateRepositoryObject).isCa() && !temporary.hasFailureForCurrentLocation()) {
                CertificateRepositoryObjectValidationContext childContext = context.createChildContext(location, (X509ResourceCertificate)certificateRepositoryObject);
                return Stream.of(new Tuple2((Object)childContext, (Object)temporary));
            }
        }
        return Stream.empty();
    }

    private RpkiRepository registerRepository(Tx.Write tx, TrustAnchor trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context) {
        if (!this.validationConfig.isRsyncOnly() && context.getRpkiNotifyURI() != null) {
            return registeredRepositories.computeIfAbsent(context.getRpkiNotifyURI(), uri -> {
                Ref trustAnchorRef = this.trustAnchors.makeRef((Tx.Read)tx, trustAnchor.key());
                RpkiRepository r = this.rpkiRepositories.register(tx, trustAnchorRef, uri.toASCIIString(), RpkiRepository.Type.RRDP);
                tx.afterCommit(() -> this.validationScheduler.addRrdpRpkiRepository(r));
                return r;
            });
        }
        return registeredRepositories.computeIfAbsent(context.getRepositoryURI(), uri -> {
            Ref trustAnchorRef = this.trustAnchors.makeRef((Tx.Read)tx, trustAnchor.key());
            return this.rpkiRepositories.register(tx, trustAnchorRef, uri.toASCIIString(), RpkiRepository.Type.RSYNC);
        });
    }

    private Map<URI, RpkiRepository> createRegisteredRepositoryMap(TrustAnchor trustAnchor) {
        ConcurrentHashMap<URI, RpkiRepository> registeredRepositories = new ConcurrentHashMap<URI, RpkiRepository>();
        long t = Time.timed(() -> ((Collection)this.storage.readTx(tx -> this.rpkiRepositories.findByTrustAnchor(tx, trustAnchor.key()))).forEach(r -> {
            if (r.getRrdpNotifyUri() != null) {
                registeredRepositories.put(URI.create(r.getRrdpNotifyUri()), (RpkiRepository)r);
            } else {
                registeredRepositories.put(URI.create(r.getLocationUri()), (RpkiRepository)r);
            }
        }));
        this.logForDuration("Pre-loaded {} repositories in {}ms", (Object)registeredRepositories.size(), t);
        return registeredRepositories;
    }
}

