/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.xodus;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentStatistics;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import net.ripe.rpki.validator3.storage.Bytes;
import net.ripe.rpki.validator3.storage.IxBase;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.MultIxMap;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.CoderFactory;
import net.ripe.rpki.validator3.storage.xodus.Xodus;
import net.ripe.rpki.validator3.storage.xodus.XodusClosedException;
import net.ripe.rpki.validator3.storage.xodus.XodusIxMap;
import net.ripe.rpki.validator3.storage.xodus.XodusMultIxMap;
import net.ripe.rpki.validator3.storage.xodus.XodusTx;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Xodus
implements Storage {
    private static final Logger log = LoggerFactory.getLogger(Xodus.class);
    private static final String METADATA_MAP_NAME = "meta";
    private Gson gson = new Gson();
    private Store metadata;
    private final Map<Long, TxInfo> txs = new ConcurrentHashMap();
    private final Map<String, IxBase<?>> ixMaps = new ConcurrentHashMap();

    protected synchronized Store meta() {
        if (this.metadata == null) {
            this.metadata = (Store)this.getEnv().computeInTransaction(txn -> this.getEnv().openStore(METADATA_MAP_NAME, StoreConfig.WITHOUT_DUPLICATES, txn));
        }
        return this.metadata;
    }

    protected abstract Environment getEnv();

    public <T> T writeTx(Function<Tx.Write, T> f) {
        AtomicReference afterCommitHooks = new AtomicReference(Collections.emptyList());
        Environment env = this.getEnv();
        Object result = env.computeInExclusiveTransaction(txn -> {
            XodusTx.Write tx = XodusTx.fromRWNative((Environment)env, (Transaction)txn);
            this.txs.put(tx.getId(), new TxInfo((XodusTx)tx));
            try {
                Object innerResult = f.apply((Tx.Write)tx);
                afterCommitHooks.set(tx.getAfterCommitHooks());
                Object r = innerResult;
                return r;
            }
            finally {
                this.txs.remove(tx.getId());
            }
        });
        for (Runnable r : afterCommitHooks.get()) {
            try {
                r.run();
            }
            catch (Exception exception) {}
        }
        return (T)result;
    }

    public void writeTx0(Consumer<Tx.Write> c) {
        this.writeTx(tx -> {
            c.accept((Tx.Write)tx);
            return null;
        });
    }

    public <T> T readTx(Function<Tx.Read, T> f) {
        Environment env = this.getEnv();
        return (T)env.computeInReadonlyTransaction(txn -> {
            XodusTx.Read tx = XodusTx.fromRONative((Environment)env, (Transaction)txn);
            this.txs.put(tx.getId(), new TxInfo((XodusTx)tx));
            try {
                Object r = f.apply((Tx.Read)tx);
                return r;
            }
            finally {
                this.txs.remove(tx.getId());
            }
        });
    }

    public void readTx0(Consumer<Tx.Read> c) {
        this.readTx(tx -> {
            c.accept((Tx.Read)tx);
            return null;
        });
    }

    static void checkEnv(Environment env) {
        if (!env.isOpen()) {
            throw new XodusClosedException();
        }
    }

    public String status() {
        EnvironmentStatistics statistics = (EnvironmentStatistics)this.getEnv().getStatistics();
        return Arrays.stream(EnvironmentStatistics.Type.values()).map(k -> k.name() + ":" + statistics.getStatisticsItem((Enum)k).getTotal()).collect(Collectors.joining(","));
    }

    public void gc() {
        this.getEnv().gc();
    }

    public <T extends Serializable> IxMap<T> createIxMap(String name, Map<String, Function<T, Set<Key>>> indexFunctions, Class<T> c) {
        return this.createIxMap(name, indexFunctions, CoderFactory.makeCoder(c));
    }

    public <T extends Serializable> IxMap<T> createIxMap(String name, Map<String, Function<T, Set<Key>>> indexFunctions, Coder<T> c) {
        XodusIxMap ixMap = new XodusIxMap(this, name, c, indexFunctions);
        this.ixMaps.put(name, ixMap);
        return ixMap;
    }

    public <T extends Serializable> MultIxMap<T> createMultIxMap(String name, Coder<T> c) {
        XodusMultIxMap ixMap = new XodusMultIxMap(this, name, c);
        this.ixMaps.put(name, ixMap);
        return ixMap;
    }

    Store createMainMapDb(String name, StoreConfig storeConfig) {
        String dbName = name + "-main";
        Store store = (Store)this.getEnv().computeInTransaction(txn -> this.getEnv().openStore(dbName, storeConfig, txn));
        IxMapInfo mapInfo = new IxMapInfo();
        mapInfo.setName(dbName);
        this.saveDbMeta(mapInfo);
        return store;
    }

    private void saveDbMeta(IxMapInfo mapInfo) {
        Key key = this.dbMetaKey(mapInfo.getName());
        ArrayByteIterable foo = new ArrayByteIterable(this.gson.toJson((Object)mapInfo).getBytes(StandardCharsets.UTF_8));
        this.getEnv().executeInTransaction(arg_0 -> this.lambda$saveDbMeta$7(key, (ByteIterable)foo, arg_0));
    }

    private Key dbMetaKey(String dbName) {
        return Key.of((String)(dbName + "-key"));
    }

    <T extends Serializable> Pair<Map<String, Store>, Boolean> createIndexes(String name, Map<String, Function<T, Set<Key>>> indexFunctions, StoreConfig storeConfigs) {
        Store meta = this.meta();
        IxMapInfo existingIxMapInfo = (IxMapInfo)this.getEnv().computeInReadonlyTransaction(txn -> {
            ByteIterable byteIterable = meta.get(txn, this.dbMetaKey(name).toByteIterable());
            if (byteIterable == null) {
                return null;
            }
            String json = new String(Bytes.toBytes((ByteIterable)byteIterable), StandardCharsets.UTF_8);
            return (IxMapInfo)this.gson.fromJson(json, IxMapInfo.class);
        });
        HashMap indexes = new HashMap();
        boolean reindex = false;
        if (existingIxMapInfo != null) {
            Set existingIndexes = existingIxMapInfo.getIndexes();
            if (existingIndexes != null) {
                if (!existingIndexes.equals(indexFunctions.keySet())) {
                    Sets.difference((Set)existingIndexes, indexFunctions.keySet()).forEach(idx -> this.getEnv().executeInTransaction(txn -> {
                        String idxStoreName = this.idxStoreName(name, idx);
                        if (this.getEnv().storeExists(idxStoreName, txn)) {
                            this.getEnv().removeStore(idxStoreName, txn);
                        }
                    }));
                    existingIxMapInfo.setIndexes(indexFunctions.keySet());
                    this.saveDbMeta(existingIxMapInfo);
                    reindex = true;
                }
            } else {
                existingIxMapInfo.setIndexes(indexFunctions.keySet());
                this.saveDbMeta(existingIxMapInfo);
            }
        } else {
            IxMapInfo mapInfo = new IxMapInfo();
            mapInfo.setName(name);
            mapInfo.setIndexes(indexFunctions.keySet());
            this.saveDbMeta(mapInfo);
        }
        this.getEnv().executeInTransaction(txn -> indexFunctions.forEach((n, idxFun) -> {
            Store store = this.getEnv().openStore(this.idxStoreName(name, n), storeConfigs, txn);
            indexes.put(n, store);
        }));
        return Pair.of(indexes, (Object)reindex);
    }

    private String idxStoreName(String name, String idx) {
        return name + "-idx-" + idx;
    }

    public Stat getStat() {
        return (Stat)this.readTx(tx -> {
            List ixMapStats = this.ixMaps.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> new IxMapStat(this, (String)e.getKey(), ((IxBase)e.getValue()).sizeInfo(tx))).collect(Collectors.toList());
            return new Stat(this, this.getDbStats(), ixMapStats);
        });
    }

    @NotNull
    public Map<String, String> getDbStats() {
        EnvironmentStatistics statistics = (EnvironmentStatistics)this.getEnv().getStatistics();
        return Arrays.stream(EnvironmentStatistics.Type.values()).collect(Collectors.toMap(Enum::name, k -> Long.toString(statistics.getStatisticsItem((Enum)k).getTotal())));
    }

    public Map<Long, TxInfo> getTxs() {
        return this.txs;
    }

    private /* synthetic */ void lambda$saveDbMeta$7(Key key, ByteIterable foo, Transaction tx) {
        this.meta().put(tx, key.toByteIterable(), foo);
    }
}

