/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain;

import com.google.common.collect.ImmutableSortedSet;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.validator3.domain.RoaPrefixDefinition;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;

public final class ValidatedRoaPrefix
implements RoaPrefixDefinition {
    private final ValidatedRpkiObjects.TrustAnchorData trustAnchor;
    private final int asn;
    private final IpRange prefix;
    private final short maximumLength;
    private final long notBefore;
    private final long notAfter;
    private final BigInteger serialNumber;
    private final Object locations;

    public static ValidatedRoaPrefix of(ValidatedRpkiObjects.TrustAnchorData trustAnchor, long asn, IpRange prefix, Integer maximumLength, long notBefore, long notAfter, BigInteger serialNumber, ImmutableSortedSet<String> locations) {
        return new ValidatedRoaPrefix(trustAnchor, (int)asn, prefix, maximumLength == null ? (short)-1 : (short)maximumLength.shortValue(), notBefore, notAfter, serialNumber, locations == null ? ImmutableSortedSet.of() : (locations.size() == 1 ? locations.first() : locations));
    }

    public long getAsn() {
        return Integer.toUnsignedLong(this.asn);
    }

    public Integer getMaximumLength() {
        return this.maximumLength < 0 ? null : Integer.valueOf(this.maximumLength);
    }

    public ImmutableSortedSet<String> getLocations() {
        if (this.locations instanceof String) {
            return ImmutableSortedSet.of((Comparable)((Object)((String)this.locations)));
        }
        return (ImmutableSortedSet)this.locations;
    }

    @ConstructorProperties(value={"trustAnchor", "asn", "prefix", "maximumLength", "notBefore", "notAfter", "serialNumber", "locations"})
    public ValidatedRoaPrefix(ValidatedRpkiObjects.TrustAnchorData trustAnchor, int asn, IpRange prefix, short maximumLength, long notBefore, long notAfter, BigInteger serialNumber, Object locations) {
        this.trustAnchor = trustAnchor;
        this.asn = asn;
        this.prefix = prefix;
        this.maximumLength = maximumLength;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.serialNumber = serialNumber;
        this.locations = locations;
    }

    public ValidatedRpkiObjects.TrustAnchorData getTrustAnchor() {
        return this.trustAnchor;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public long getNotAfter() {
        return this.notAfter;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidatedRoaPrefix)) {
            return false;
        }
        ValidatedRoaPrefix other = (ValidatedRoaPrefix)o;
        ValidatedRpkiObjects.TrustAnchorData this$trustAnchor = this.getTrustAnchor();
        ValidatedRpkiObjects.TrustAnchorData other$trustAnchor = other.getTrustAnchor();
        if (this$trustAnchor == null ? other$trustAnchor != null : !this$trustAnchor.equals(other$trustAnchor)) {
            return false;
        }
        if (this.getAsn() != other.getAsn()) {
            return false;
        }
        IpRange this$prefix = this.getPrefix();
        IpRange other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Integer this$maximumLength = this.getMaximumLength();
        Integer other$maximumLength = other.getMaximumLength();
        if (this$maximumLength == null ? other$maximumLength != null : !((Object)this$maximumLength).equals(other$maximumLength)) {
            return false;
        }
        if (this.getNotBefore() != other.getNotBefore()) {
            return false;
        }
        if (this.getNotAfter() != other.getNotAfter()) {
            return false;
        }
        BigInteger this$serialNumber = this.getSerialNumber();
        BigInteger other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !((Object)this$serialNumber).equals(other$serialNumber)) {
            return false;
        }
        ImmutableSortedSet this$locations = this.getLocations();
        ImmutableSortedSet other$locations = other.getLocations();
        return !(this$locations == null ? other$locations != null : !this$locations.equals(other$locations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValidatedRpkiObjects.TrustAnchorData $trustAnchor = this.getTrustAnchor();
        result = result * 59 + ($trustAnchor == null ? 43 : $trustAnchor.hashCode());
        long $asn = this.getAsn();
        result = result * 59 + (int)($asn >>> 32 ^ $asn);
        IpRange $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Integer $maximumLength = this.getMaximumLength();
        result = result * 59 + ($maximumLength == null ? 43 : ((Object)$maximumLength).hashCode());
        long $notBefore = this.getNotBefore();
        result = result * 59 + (int)($notBefore >>> 32 ^ $notBefore);
        long $notAfter = this.getNotAfter();
        result = result * 59 + (int)($notAfter >>> 32 ^ $notAfter);
        BigInteger $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : ((Object)$serialNumber).hashCode());
        ImmutableSortedSet $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : $locations.hashCode());
        return result;
    }

    public String toString() {
        return "ValidatedRoaPrefix(trustAnchor=" + this.getTrustAnchor() + ", asn=" + this.getAsn() + ", prefix=" + this.getPrefix() + ", maximumLength=" + this.getMaximumLength() + ", notBefore=" + this.getNotBefore() + ", notAfter=" + this.getNotAfter() + ", serialNumber=" + this.getSerialNumber() + ", locations=" + this.getLocations() + ")";
    }
}

