/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.roaprefixassertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.roaprefixassertions.AddRoaPrefixAssertion;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertion;
import net.ripe.rpki.validator3.api.roaprefixassertions.RoaPrefixAssertionsService;
import net.ripe.rpki.validator3.api.slurm.SlurmStore;
import net.ripe.rpki.validator3.api.slurm.dtos.Slurm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Validated
public class RoaPrefixAssertionsService {
    private static final Logger log = LoggerFactory.getLogger(RoaPrefixAssertionsService.class);
    private final Object listenerLock = new Object();
    private final List<Consumer<Collection<RoaPrefixAssertion>>> listeners = new ArrayList();
    private final SlurmStore slurmStore;

    @Autowired
    public RoaPrefixAssertionsService(SlurmStore slurmStore) {
        this.slurmStore = slurmStore;
    }

    public long execute(@Valid AddRoaPrefixAssertion command) {
        Long rpId = (Long)this.slurmStore.updateWith(slurmExt -> {
            Slurm.SlurmPrefixAssertion prefixAssertion = new Slurm.SlurmPrefixAssertion();
            prefixAssertion.setAsn(Long.valueOf(Asn.parse((String)command.getAsn()).longValue()));
            prefixAssertion.setPrefix(IpRange.parse((String)command.getPrefix()));
            prefixAssertion.setComment(command.getComment());
            prefixAssertion.setMaxPrefixLength(command.getMaximumLength());
            long id = this.slurmStore.nextId();
            slurmExt.getPrefixAssertions().put(id, prefixAssertion);
            log.info("added ignore filter '{}'", (Object)prefixAssertion);
            return id;
        });
        this.notifyListeners();
        return rpId;
    }

    public void remove(long roaPrefixAssertionId) {
        boolean notify = (Boolean)this.slurmStore.updateWith(slurmExt -> slurmExt.getPrefixAssertions().remove(roaPrefixAssertionId) != null);
        if (notify) {
            this.notifyListeners();
        }
    }

    public void clear() {
        this.slurmStore.updateWith(slurmExt -> slurmExt.getPrefixAssertions().clear());
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Consumer<Collection<RoaPrefixAssertion>> listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            List assertions = this.all().collect(Collectors.toList());
            listener.accept(assertions);
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object object = this.listenerLock;
        synchronized (object) {
            List assertions = this.all().collect(Collectors.toList());
            this.listeners.forEach(listener -> listener.accept(assertions));
        }
    }

    public Stream<RoaPrefixAssertion> all() {
        return this.slurmStore.read().getPrefixAssertions().entrySet().stream().map(e -> this.makeIgnoreFilter((Long)e.getKey(), (Slurm.SlurmPrefixAssertion)e.getValue()));
    }

    public Stream<RoaPrefixAssertion> find(SearchTerm searchTerm, Sorting sorting, Paging paging) {
        Stream all = this.slurmStore.read().getPrefixAssertions().entrySet().stream();
        all = this.applySearch(searchTerm, all).sorted(this.toOrderSpecifier(sorting));
        if (paging != null) {
            all = paging.apply(all);
        }
        return all.map(e -> this.makeIgnoreFilter((Long)e.getKey(), (Slurm.SlurmPrefixAssertion)e.getValue()));
    }

    private RoaPrefixAssertion makeIgnoreFilter(Long id, Slurm.SlurmPrefixAssertion value) {
        return new RoaPrefixAssertion(id, value.getAsn(), value.getPrefix(), value.getMaxPrefixLength(), value.getComment());
    }

    public Stream<Map.Entry<Long, Slurm.SlurmPrefixAssertion>> applySearch(SearchTerm searchTerm, Stream<Map.Entry<Long, Slurm.SlurmPrefixAssertion>> all) {
        if (searchTerm != null) {
            all = searchTerm.asAsn() != null ? all.filter(pf -> ((Slurm.SlurmPrefixAssertion)pf.getValue()).getAsn().longValue() == searchTerm.asAsn().longValue()) : (searchTerm.asIpRange() != null ? all.filter(pf -> ((Slurm.SlurmPrefixAssertion)pf.getValue()).getPrefix().overlaps((IpResource)searchTerm.asIpRange())) : all.filter(pf -> ((Slurm.SlurmPrefixAssertion)pf.getValue()).getComment().toLowerCase().contains(searchTerm.asString().toLowerCase())));
        }
        return all;
    }

    public long count(SearchTerm searchTerm) {
        return this.applySearch(searchTerm, this.slurmStore.read().getPrefixAssertions().entrySet().stream()).count();
    }

    public RoaPrefixAssertion get(long id) {
        Slurm.SlurmPrefixAssertion prefixAssertion = (Slurm.SlurmPrefixAssertion)this.slurmStore.read().getPrefixAssertions().get(id);
        if (prefixAssertion == null) {
            return null;
        }
        return this.makeIgnoreFilter(Long.valueOf(id), prefixAssertion);
    }

    private Comparator<Map.Entry<Long, Slurm.SlurmPrefixAssertion>> toOrderSpecifier(Sorting sorting) {
        Comparator<Map.Entry<Long, Slurm.SlurmPrefixAssertion>> comparator;
        if (sorting == null) {
            sorting = Sorting.of((Sorting.By)Sorting.By.ASN, (Sorting.Direction)Sorting.Direction.ASC);
        }
        switch (1.$SwitchMap$net$ripe$rpki$validator3$api$Sorting$By[sorting.getBy().ordinal()]) {
            case 1: {
                comparator = Comparator.comparing(e -> ((Slurm.SlurmPrefixAssertion)e.getValue()).getPrefix());
                break;
            }
            case 2: {
                comparator = Comparator.comparing(e -> ((Slurm.SlurmPrefixAssertion)e.getValue()).getMaxPrefixLength());
                break;
            }
            case 3: {
                comparator = Comparator.comparing(e -> ((Slurm.SlurmPrefixAssertion)e.getValue()).getComment());
                break;
            }
            default: {
                comparator = Comparator.comparing(e -> ((Slurm.SlurmPrefixAssertion)e.getValue()).getAsn());
            }
        }
        return sorting.getDirection() == Sorting.Direction.DESC ? comparator.reversed() : comparator;
    }
}

