/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data.validation;

import java.util.ArrayList;
import java.util.List;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ValidationRun
extends Base<ValidationRun> {
    private InstantWithoutNanos completedAt;
    private String status = Status.RUNNING.name();
    private List<ValidationCheck> validationChecks = new ArrayList();

    public abstract String getType();

    public boolean isSucceeded() {
        return Status.SUCCEEDED.name().equals(this.status);
    }

    public boolean isFailed() {
        return Status.FAILED.name().equals(this.status);
    }

    public void setSucceeded() {
        this.completedAt = InstantWithoutNanos.now();
        this.status = Status.SUCCEEDED.name();
    }

    public void setFailed() {
        this.completedAt = InstantWithoutNanos.now();
        this.status = Status.FAILED.name();
    }

    public Status getStatus() {
        return Status.valueOf((String)this.status);
    }

    public void completeWith(ValidationResult validationResult) {
        validationResult.getValidatedLocations().forEach(location -> validationResult.getAllValidationChecksForLocation(location).stream().filter(check -> check.getStatus() != ValidationStatus.PASSED).map(check -> new ValidationCheck(location.getName(), check)).forEachOrdered(arg_0 -> this.addCheck(arg_0)));
        if (!this.isFailed()) {
            this.setSucceeded();
        }
    }

    public void addCheck(ValidationCheck validationCheck) {
        this.validationChecks.add(validationCheck);
    }

    public void addChecks(ValidationResult validationResult) {
        validationResult.getAllValidationChecksForCurrentLocation().forEach(c -> {
            if (c.getStatus() != ValidationStatus.PASSED) {
                ValidationCheck.Status status = ValidationCheck.mapStatus((ValidationStatus)c.getStatus());
                this.addCheck(new ValidationCheck(validationResult.getCurrentLocation().getName(), status, c.getKey(), c.getParams()));
            }
        });
    }

    public abstract void visit(Visitor var1);

    public InstantWithoutNanos getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(InstantWithoutNanos completedAt) {
        this.completedAt = completedAt;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<ValidationCheck> getValidationChecks() {
        return this.validationChecks;
    }

    public void setValidationChecks(List<ValidationCheck> validationChecks) {
        this.validationChecks = validationChecks;
    }
}

