/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.xodus;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.zip.CRC32;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import net.ripe.rpki.validator3.storage.Bytes;
import net.ripe.rpki.validator3.storage.IxBase;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.xodus.Xodus;
import net.ripe.rpki.validator3.storage.xodus.XodusTx;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class XodusIxBase<T extends Serializable>
implements IxBase<T> {
    protected final Environment env;
    private final String name;
    private final Store mainDb;
    final Coder<T> coder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XodusIxBase(Xodus xodus, String name, Coder<T> coder) {
        this.env = xodus.getEnv();
        this.name = name;
        this.coder = coder;
        Xodus xodus2 = xodus;
        synchronized (xodus2) {
            this.mainDb = xodus.createMainMapDb(name, this.getStoreConfig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XodusIxBase(Xodus xodus, String name, Coder<T> coder, StoreConfig storeConfig) {
        this.env = xodus.getEnv();
        this.name = name;
        this.coder = coder;
        Xodus xodus2 = xodus;
        synchronized (xodus2) {
            this.mainDb = xodus.createMainMapDb(name, storeConfig);
        }
    }

    protected abstract StoreConfig getStoreConfig();

    static void checkNotNull(Object v, String s) {
        if (v == null) {
            throw new NullPointerException(s);
        }
    }

    public Tx.Read readTx() {
        return XodusTx.read((Environment)this.env);
    }

    public XodusTx.Write writeTx() {
        return XodusTx.write((Environment)this.env);
    }

    protected void verifyKey(Key k) {
        XodusIxBase.checkNotNull((Object)k, (String)"Key is null");
    }

    void checkKeyAndValue(Key primaryKey, T value) {
        this.verifyKey(primaryKey);
        XodusIxBase.checkNotNull(value, (String)"Value is null");
    }

    public boolean exists(Tx.Read tx, Key key) {
        return this.getMainDb().get(XodusIxBase.castTxn((Tx.Read)tx), key.toByteIterable()) != null;
    }

    Store getMainDb() {
        this.checkEnv();
        return this.mainDb;
    }

    void checkEnv() {
        Xodus.checkEnv((Environment)this.env);
    }

    protected ByteIterable valueWithChecksum(T value) {
        byte[] valueBytes = this.coder.toBytes(value);
        CRC32 checksum = new CRC32();
        checksum.update(valueBytes);
        byte[] stored = new byte[8 + valueBytes.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(stored);
        byteBuffer.putLong(checksum.getValue());
        byteBuffer.put(valueBytes);
        byteBuffer.flip();
        return new ArrayByteIterable(stored);
    }

    protected T getValue(Key k, byte[] b) {
        ByteBuffer bb = ByteBuffer.wrap(b);
        long crc32 = bb.getLong();
        byte[] valueBytes = Bytes.toBytes((ByteBuffer)bb);
        CRC32 checksum = new CRC32();
        checksum.update(valueBytes);
        if (checksum.getValue() != crc32) {
            throw new RuntimeException("Data for the key " + k + " is corrupted");
        }
        return (T)((Serializable)this.coder.fromBytes(valueBytes));
    }

    public Set<Key> keys(Tx.Read tx) {
        HashSet<Key> result = new HashSet<Key>();
        this.forEach(tx, (k, v) -> result.add((Key)k));
        return result;
    }

    public List<T> values(Tx.Read tx) {
        ArrayList result = new ArrayList();
        this.forEach(tx, (k, v) -> result.add(this.getValue(k, v)));
        return result;
    }

    public Map<Key, T> all(Tx.Read tx) {
        HashMap result = new HashMap();
        this.forEach(tx, (k, v) -> result.put(k, this.getValue(k, v)));
        return result;
    }

    public void clear(Tx.Write tx) {
        XodusIxBase.truncate((Tx.Write)tx, (Store)this.getMainDb());
    }

    protected static void truncate(Tx.Write tx, Store mainDb) {
        try (Cursor c = mainDb.openCursor(XodusIxBase.castTxn((Tx.Read)tx));){
            while (c.getNext()) {
                c.deleteCurrent();
            }
        }
    }

    public T toValue(ByteIterable bi) {
        return (T)this.getValue(null, Bytes.toBytes((ByteIterable)bi));
    }

    public void forEach(Tx.Read tx, BiConsumer<Key, byte[]> c) {
        try (Cursor ci = this.getMainDb().openCursor(XodusIxBase.castTxn((Tx.Read)tx));){
            while (ci.getNext()) {
                c.accept(new Key(ci.getKey()), Bytes.toBytes((ByteIterable)ci.getValue()));
            }
        }
    }

    public long size(Tx.Read tx) {
        AtomicLong s = new AtomicLong();
        this.forEach(tx, (k, v) -> s.getAndIncrement());
        return s.get();
    }

    static Transaction castTxn(Tx.Read tx) {
        return (Transaction)tx.txn();
    }

    public IxBase.Sizes sizeInfo(Tx.Read tx) {
        AtomicInteger count = new AtomicInteger();
        AtomicInteger size = new AtomicInteger();
        this.forEach(tx, (k, v) -> {
            count.getAndIncrement();
            size.addAndGet(k.size() + ((byte[])v).length);
        });
        return new IxBase.Sizes(count.get(), (long)size.get());
    }

    public String getName() {
        return this.name;
    }
}

