/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.stores.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.validator3.storage.IxMap;
import net.ripe.rpki.validator3.storage.MultIxMap;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.encoding.CoderFactory;
import net.ripe.rpki.validator3.storage.stores.GenericStoreImpl;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.util.Bench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RpkiObjectStore
extends GenericStoreImpl<RpkiObject>
implements RpkiObjects {
    private static final Logger log = LoggerFactory.getLogger(RpkiObjectStore.class);
    private static final String RPKI_OBJECTS = "rpki-objects";
    private static final String REACHABLE_MAP = "rpki-objects-reachable";
    private static final String LOCATION_MAP = "rpki-objects-location";
    private static final String BY_AKI_MFT_INDEX = "by-aki-mft";
    private static final String BY_TYPE_INDEX = "by-type";
    private final IxMap<RpkiObject> ixMap;
    private final IxMap<Long> reachableMap;
    private final MultIxMap<String> locationMap;
    private final Storage storage;

    private Set<Key> akiMftKey(RpkiObject rpkiObject) {
        byte[] authorityKeyIdentifier = rpkiObject.getAuthorityKeyIdentifier();
        return rpkiObject.getType() == RpkiObject.Type.MFT && authorityKeyIdentifier != null ? Key.keys((Key)Key.of((byte[])authorityKeyIdentifier)) : Collections.emptySet();
    }

    private Set<Key> typeKey(RpkiObject rpkiObject) {
        return Key.keys((Key)Key.of((String)rpkiObject.getType().toString()));
    }

    @Autowired
    public RpkiObjectStore(Storage storage) {
        this.storage = storage;
        this.ixMap = storage.createIxMap(RPKI_OBJECTS, (Map)ImmutableMap.of((Object)BY_AKI_MFT_INDEX, arg_0 -> this.akiMftKey(arg_0), (Object)BY_TYPE_INDEX, arg_0 -> this.typeKey(arg_0)), CoderFactory.makeCoder(RpkiObject.class));
        this.reachableMap = storage.createIxMap(REACHABLE_MAP, (Map)ImmutableMap.of(), CoderFactory.longCoder());
        this.locationMap = storage.createMultIxMap(LOCATION_MAP, CoderFactory.stringCoder());
        this.ixMap.onDelete((tx, k) -> {
            this.reachableMap.delete(tx, k);
            this.locationMap.delete(tx, k);
        });
    }

    public void put(Tx.Write tx, RpkiObject o) {
        this.ixMap.put(tx, o.key(), (Serializable)o);
        this.markReachable(tx, o.key(), o.getCreatedAt());
    }

    public void put(Tx.Write tx, RpkiObject o, String location) {
        this.put(tx, o);
        this.addLocation(tx, o.key(), location);
    }

    public void delete(Tx.Write tx, RpkiObject o) {
        this.ixMap.delete(tx, o.key());
    }

    public void markReachable(Tx.Write tx, Key pk, Instant i) {
        this.reachableMap.put(tx, pk, (Serializable)Long.valueOf(i.toEpochMilli()));
    }

    public void addLocation(Tx.Write tx, Key pk, String location) {
        if (!this.locationMap.exists((Tx.Read)tx, pk, (Serializable)((Object)location))) {
            this.locationMap.put(tx, pk, (Serializable)((Object)location));
        }
    }

    public SortedSet<String> getLocations(Tx.Read tx, Key pk) {
        return new TreeSet<String>(this.locationMap.get(tx, pk));
    }

    public void deleteLocation(Tx.Write tx, Key key, String uri) {
        this.locationMap.delete(tx, key, (Serializable)((Object)uri));
    }

    public Optional<RpkiObject> get(Tx.Read tx, Key key) {
        return this.ixMap.get(tx, key);
    }

    public Optional<RpkiObject> findBySha256(Tx.Read tx, byte[] sha256) {
        return (Optional)Bench.mark((String)"findBySha256", () -> this.get(tx, Key.of((byte[])sha256)));
    }

    public Optional<RpkiObject> findLatestMftByAKI(Tx.Read tx, byte[] authorityKeyIdentifier) {
        return this.ixMap.getByIndex(BY_AKI_MFT_INDEX, tx, Key.of((byte[])authorityKeyIdentifier)).values().stream().max(Comparator.comparing(RpkiObject::getSigningTime).thenComparing(RpkiObject::getSerialNumber));
    }

    public long deleteUnreachableObjects(Instant unreachableSince) {
        ArrayList toDelete = new ArrayList();
        this.storage.readTx0(tx -> this.reachableMap.forEach(tx, (k, bytes) -> {
            if ((Long)this.reachableMap.toValue(bytes) < unreachableSince.toEpochMilli()) {
                toDelete.add(k);
            }
        }));
        Lists.partition(toDelete, (int)1000).forEach(chunk -> this.storage.writeTx0(tx -> chunk.forEach(pk -> this.ixMap.delete(tx, pk))));
        return toDelete.size();
    }

    public Map<String, RpkiObject> findObjectsInManifest(Tx.Read tx, ManifestCms manifestCms) {
        TreeMap hashes = new TreeMap(UnsignedBytes.lexicographicalComparator());
        manifestCms.getFiles().forEach((name, hash) -> hashes.put(hash, name));
        return hashes.keySet().stream().map(sha256 -> this.findBySha256(tx, sha256)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(x -> (String)hashes.get(x.getSha256()), x -> x));
    }

    public Stream<byte[]> streamObjects(Tx.Read tx, RpkiObject.Type type) {
        ArrayList objectBytes = new ArrayList();
        this.getPkByType(tx, type).forEach(pk -> this.ixMap.get(tx, pk).ifPresent(ro -> objectBytes.add(ro.getEncoded())));
        return objectBytes.stream();
    }

    public Set<Key> getPkByType(Tx.Read tx, RpkiObject.Type type) {
        return this.ixMap.getPkByIndex(BY_TYPE_INDEX, tx, Key.of((String)type.toString()));
    }

    public void markReachable(Tx.Write tx, List<Key> rpkiObjectsKeys) {
        Instant now = Instant.now();
        rpkiObjectsKeys.forEach(pk -> this.markReachable(tx, pk, now));
    }

    protected IxMap<RpkiObject> ixMap() {
        return this.ixMap;
    }
}

