/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.ignorefilters;

import java.util.List;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilter;
import net.ripe.rpki.validator3.api.roas.ObjectController;

public final class IgnoreFilterDto {
    private final long id;
    private final String asn;
    private final String prefix;
    private final String comment;
    private final List<ObjectController.RoaPrefix> affectedRoas;

    public IgnoreFilterDto(IgnoreFilter ignoreFilter) {
        this.id = ignoreFilter.getId();
        this.asn = ignoreFilter.getAsn().toString();
        this.prefix = ignoreFilter.getPrefix().toString();
        this.comment = ignoreFilter.getComment();
        this.affectedRoas = ignoreFilter.getAffectedRoas();
    }

    public IgnoreFilterDto(IgnoreFilter ignoreFilter, List<ObjectController.RoaPrefix> affectedRoas) {
        this.id = ignoreFilter.getId();
        this.asn = ignoreFilter.getAsn().toString();
        this.prefix = ignoreFilter.getPrefix().toString();
        this.comment = ignoreFilter.getComment();
        this.affectedRoas = affectedRoas;
    }

    private IgnoreFilterDto() {
        this.id = 0L;
        this.asn = null;
        this.prefix = null;
        this.comment = null;
        this.affectedRoas = null;
    }

    public long getId() {
        return this.id;
    }

    public String getAsn() {
        return this.asn;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getComment() {
        return this.comment;
    }

    public List<ObjectController.RoaPrefix> getAffectedRoas() {
        return this.affectedRoas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IgnoreFilterDto)) {
            return false;
        }
        IgnoreFilterDto other = (IgnoreFilterDto)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$asn = this.getAsn();
        String other$asn = other.getAsn();
        if (this$asn == null ? other$asn != null : !this$asn.equals(other$asn)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List this$affectedRoas = this.getAffectedRoas();
        List other$affectedRoas = other.getAffectedRoas();
        return !(this$affectedRoas == null ? other$affectedRoas != null : !((Object)this$affectedRoas).equals(other$affectedRoas));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $asn = this.getAsn();
        result = result * 59 + ($asn == null ? 43 : $asn.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List $affectedRoas = this.getAffectedRoas();
        result = result * 59 + ($affectedRoas == null ? 43 : ((Object)$affectedRoas).hashCode());
        return result;
    }

    public String toString() {
        return "IgnoreFilterDto(id=" + this.getId() + ", asn=" + this.getAsn() + ", prefix=" + this.getPrefix() + ", comment=" + this.getComment() + ", affectedRoas=" + this.getAffectedRoas() + ")";
    }
}

