/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain;

import java.time.Instant;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.ripe.rpki.rtr.domain.RtrClient;
import net.ripe.rpki.rtr.domain.SerialNumber;
import net.ripe.rpki.rtr.util.Locks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RtrClients {
    private static final Logger log = LoggerFactory.getLogger(RtrClients.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<RtrClient> clients = new HashSet();

    public void register(RtrClient client) {
        boolean added = (Boolean)Locks.locked((Lock)this.lock.writeLock(), () -> this.clients.add(client));
        if (added) {
            log.info("registered client {}", (Object)client);
        }
    }

    public void clear() {
        Locks.locked((Lock)this.lock.writeLock(), this.clients::clear);
    }

    public void unregister(RtrClient client) {
        boolean removed = (Boolean)Locks.locked((Lock)this.lock.writeLock(), () -> this.clients.remove(client));
        if (removed) {
            log.info("unregistered client {}", (Object)client);
        }
    }

    public Set<RtrClient> list() {
        return (Set)Locks.locked((Lock)this.lock.readLock(), () -> new HashSet(this.clients));
    }

    public void cacheUpdated(short sessionId, SerialNumber updatedSerialNumber) {
        Locks.locked((Lock)this.lock.readLock(), () -> this.clients.forEach(client -> client.cacheUpdated(sessionId, updatedSerialNumber)));
    }

    public Optional<SerialNumber> getLowestSerialNumber() {
        return (Optional)Locks.locked((Lock)this.lock.readLock(), () -> this.clients.stream().map(RtrClient::getClientSerialNumber).min(Comparator.naturalOrder()));
    }

    public int disconnectInactive(Instant now) {
        return (Integer)Locks.locked((Lock)this.lock.writeLock(), () -> {
            int before = this.clients.size();
            this.clients.removeIf(client -> client.disconnectIfInactive(now));
            return before - this.clients.size();
        });
    }
}

