// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT
// This file is automatically generated by the compile_shaders.py script

#ifndef MEDIA_GPU_CHROMEOS_SHADERS_SHADERS_H_
#define MEDIA_GPU_CHROMEOS_SHADERS_SHADERS_H_

#include <stdint.h>

namespace {

constexpr uint32_t kCropRotateShaderFrag[] = {
    0x07230203, 0x00010000, 0x0008000b, 0x00000014, 0x00000000, 0x00020011,
    0x00000001, 0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e,
    0x00000000, 0x0003000e, 0x00000000, 0x00000001, 0x0007000f, 0x00000004,
    0x00000004, 0x6e69616d, 0x00000000, 0x00000009, 0x00000011, 0x00030010,
    0x00000004, 0x00000007, 0x00030003, 0x00000002, 0x000001c2, 0x00040005,
    0x00000004, 0x6e69616d, 0x00000000, 0x00050005, 0x00000009, 0x4374756f,
    0x726f6c6f, 0x00000000, 0x00050005, 0x0000000d, 0x65546e69, 0x72757478,
    0x00000065, 0x00050005, 0x00000011, 0x43786574, 0x64726f6f, 0x00000000,
    0x00040047, 0x00000009, 0x0000001e, 0x00000000, 0x00040047, 0x0000000d,
    0x00000022, 0x00000000, 0x00040047, 0x0000000d, 0x00000021, 0x00000000,
    0x00040047, 0x00000011, 0x0000001e, 0x00000000, 0x00020013, 0x00000002,
    0x00030021, 0x00000003, 0x00000002, 0x00030016, 0x00000006, 0x00000020,
    0x00040017, 0x00000007, 0x00000006, 0x00000004, 0x00040020, 0x00000008,
    0x00000003, 0x00000007, 0x0004003b, 0x00000008, 0x00000009, 0x00000003,
    0x00090019, 0x0000000a, 0x00000006, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000001, 0x00000000, 0x0003001b, 0x0000000b, 0x0000000a,
    0x00040020, 0x0000000c, 0x00000000, 0x0000000b, 0x0004003b, 0x0000000c,
    0x0000000d, 0x00000000, 0x00040017, 0x0000000f, 0x00000006, 0x00000002,
    0x00040020, 0x00000010, 0x00000001, 0x0000000f, 0x0004003b, 0x00000010,
    0x00000011, 0x00000001, 0x00050036, 0x00000002, 0x00000004, 0x00000000,
    0x00000003, 0x000200f8, 0x00000005, 0x0004003d, 0x0000000b, 0x0000000e,
    0x0000000d, 0x0004003d, 0x0000000f, 0x00000012, 0x00000011, 0x00050057,
    0x00000007, 0x00000013, 0x0000000e, 0x00000012, 0x0003003e, 0x00000009,
    0x00000013, 0x000100fd, 0x00010038,
};
// clang-format off
/***
CropRotateShader.frag source:
// Simple fragment shader for scaling, rotate, and crop.
// All of the logic is in the corresponding vertex shader.

#version 450

layout(binding = 0) uniform sampler2D inTexture;

layout(location = 0) in vec2 texCoord;

layout(location = 0) out vec4 outColor;

void main() {
  outColor = texture(inTexture, texCoord);
}
***/
// clang-format on

constexpr uint32_t kCropRotateShaderVert[] = {
    0x07230203, 0x00010000, 0x0008000b, 0x00000035, 0x00000000, 0x00020011,
    0x00000001, 0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e,
    0x00000000, 0x0003000e, 0x00000000, 0x00000001, 0x0008000f, 0x00000000,
    0x00000004, 0x6e69616d, 0x00000000, 0x00000019, 0x00000021, 0x0000002c,
    0x00030003, 0x00000002, 0x000001c2, 0x00040005, 0x00000004, 0x6e69616d,
    0x00000000, 0x00050005, 0x0000000c, 0x43786574, 0x64726f6f, 0x00000073,
    0x00060005, 0x00000017, 0x505f6c67, 0x65567265, 0x78657472, 0x00000000,
    0x00060006, 0x00000017, 0x00000000, 0x505f6c67, 0x7469736f, 0x006e6f69,
    0x00070006, 0x00000017, 0x00000001, 0x505f6c67, 0x746e696f, 0x657a6953,
    0x00000000, 0x00070006, 0x00000017, 0x00000002, 0x435f6c67, 0x4470696c,
    0x61747369, 0x0065636e, 0x00070006, 0x00000017, 0x00000003, 0x435f6c67,
    0x446c6c75, 0x61747369, 0x0065636e, 0x00030005, 0x00000019, 0x00000000,
    0x00050005, 0x0000001d, 0x736e6f63, 0x746e6174, 0x00000073, 0x00060006,
    0x0000001d, 0x00000000, 0x74726576, 0x73656369, 0x00000000, 0x00070006,
    0x0000001d, 0x00000001, 0x69736976, 0x53656c62, 0x656c6163, 0x00000000,
    0x00060005, 0x0000001f, 0x68737570, 0x736e6f43, 0x746e6174, 0x00000073,
    0x00060005, 0x00000021, 0x565f6c67, 0x65747265, 0x646e4978, 0x00007865,
    0x00050005, 0x0000002c, 0x5474756f, 0x6f437865, 0x0064726f, 0x00050048,
    0x00000017, 0x00000000, 0x0000000b, 0x00000000, 0x00050048, 0x00000017,
    0x00000001, 0x0000000b, 0x00000001, 0x00050048, 0x00000017, 0x00000002,
    0x0000000b, 0x00000003, 0x00050048, 0x00000017, 0x00000003, 0x0000000b,
    0x00000004, 0x00030047, 0x00000017, 0x00000002, 0x00040047, 0x0000001c,
    0x00000006, 0x00000008, 0x00050048, 0x0000001d, 0x00000000, 0x00000023,
    0x00000000, 0x00050048, 0x0000001d, 0x00000001, 0x00000023, 0x00000030,
    0x00030047, 0x0000001d, 0x00000002, 0x00040047, 0x00000021, 0x0000000b,
    0x0000002a, 0x00040047, 0x0000002c, 0x0000001e, 0x00000000, 0x00020013,
    0x00000002, 0x00030021, 0x00000003, 0x00000002, 0x00030016, 0x00000006,
    0x00000020, 0x00040017, 0x00000007, 0x00000006, 0x00000002, 0x00040015,
    0x00000008, 0x00000020, 0x00000000, 0x0004002b, 0x00000008, 0x00000009,
    0x00000006, 0x0004001c, 0x0000000a, 0x00000007, 0x00000009, 0x00040020,
    0x0000000b, 0x00000006, 0x0000000a, 0x0004003b, 0x0000000b, 0x0000000c,
    0x00000006, 0x0004002b, 0x00000006, 0x0000000d, 0x3f800000, 0x0004002b,
    0x00000006, 0x0000000e, 0x00000000, 0x0005002c, 0x00000007, 0x0000000f,
    0x0000000d, 0x0000000e, 0x0005002c, 0x00000007, 0x00000010, 0x0000000d,
    0x0000000d, 0x0005002c, 0x00000007, 0x00000011, 0x0000000e, 0x0000000e,
    0x0005002c, 0x00000007, 0x00000012, 0x0000000e, 0x0000000d, 0x0009002c,
    0x0000000a, 0x00000013, 0x0000000f, 0x00000010, 0x00000011, 0x00000011,
    0x00000010, 0x00000012, 0x00040017, 0x00000014, 0x00000006, 0x00000004,
    0x0004002b, 0x00000008, 0x00000015, 0x00000001, 0x0004001c, 0x00000016,
    0x00000006, 0x00000015, 0x0006001e, 0x00000017, 0x00000014, 0x00000006,
    0x00000016, 0x00000016, 0x00040020, 0x00000018, 0x00000003, 0x00000017,
    0x0004003b, 0x00000018, 0x00000019, 0x00000003, 0x00040015, 0x0000001a,
    0x00000020, 0x00000001, 0x0004002b, 0x0000001a, 0x0000001b, 0x00000000,
    0x0004001c, 0x0000001c, 0x00000007, 0x00000009, 0x0004001e, 0x0000001d,
    0x0000001c, 0x00000007, 0x00040020, 0x0000001e, 0x00000009, 0x0000001d,
    0x0004003b, 0x0000001e, 0x0000001f, 0x00000009, 0x00040020, 0x00000020,
    0x00000001, 0x0000001a, 0x0004003b, 0x00000020, 0x00000021, 0x00000001,
    0x00040020, 0x00000023, 0x00000009, 0x00000007, 0x00040020, 0x00000029,
    0x00000003, 0x00000014, 0x00040020, 0x0000002b, 0x00000003, 0x00000007,
    0x0004003b, 0x0000002b, 0x0000002c, 0x00000003, 0x00040020, 0x0000002e,
    0x00000006, 0x00000007, 0x0004002b, 0x0000001a, 0x00000031, 0x00000001,
    0x00050036, 0x00000002, 0x00000004, 0x00000000, 0x00000003, 0x000200f8,
    0x00000005, 0x0003003e, 0x0000000c, 0x00000013, 0x0004003d, 0x0000001a,
    0x00000022, 0x00000021, 0x00060041, 0x00000023, 0x00000024, 0x0000001f,
    0x0000001b, 0x00000022, 0x0004003d, 0x00000007, 0x00000025, 0x00000024,
    0x00050051, 0x00000006, 0x00000026, 0x00000025, 0x00000000, 0x00050051,
    0x00000006, 0x00000027, 0x00000025, 0x00000001, 0x00070050, 0x00000014,
    0x00000028, 0x00000026, 0x00000027, 0x0000000e, 0x0000000d, 0x00050041,
    0x00000029, 0x0000002a, 0x00000019, 0x0000001b, 0x0003003e, 0x0000002a,
    0x00000028, 0x0004003d, 0x0000001a, 0x0000002d, 0x00000021, 0x00050041,
    0x0000002e, 0x0000002f, 0x0000000c, 0x0000002d, 0x0004003d, 0x00000007,
    0x00000030, 0x0000002f, 0x00050041, 0x00000023, 0x00000032, 0x0000001f,
    0x00000031, 0x0004003d, 0x00000007, 0x00000033, 0x00000032, 0x00050085,
    0x00000007, 0x00000034, 0x00000030, 0x00000033, 0x0003003e, 0x0000002c,
    0x00000034, 0x000100fd, 0x00010038,
};
// clang-format off
/***
CropRotateShader.vert source:
// Vertex shader for scaling, rotate, and crop.

#version 450

layout(location = 0) out vec2 outTexCoord;

layout( push_constant ) uniform constants {
  vec2 vertices[6];
  vec2 visibleScale;
} pushConstants;

// Texture coordinates are always fixed.
vec2 texCoords[6] = vec2[6](
  vec2(1.0, 0.0),
  vec2(1.0, 1.0),
  vec2(0.0, 0.0),
  vec2(0.0, 0.0),
  vec2(1.0, 1.0),
  vec2(0.0, 1.0)
);

void main() {
  // Adjust the gl_Position according to scaling, rotate, and crop parameters.
  gl_Position = vec4(pushConstants.vertices[gl_VertexIndex], 0.0, 1.0);

  // We over-allocate the pivot buffer, so we need to scale texture coordinates
  // accordingly.
  outTexCoord = texCoords[gl_VertexIndex] * pushConstants.visibleScale;
}
***/
// clang-format on

constexpr uint32_t kMM21ShaderFrag[] = {
    0x07230203, 0x00010000, 0x0008000b, 0x00000079, 0x00000000, 0x00020011,
    0x00000001, 0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e,
    0x00000000, 0x0003000e, 0x00000000, 0x00000001, 0x000a000f, 0x00000004,
    0x00000004, 0x6e69616d, 0x00000000, 0x0000000b, 0x00000012, 0x00000016,
    0x0000002c, 0x00000066, 0x00030010, 0x00000004, 0x00000007, 0x00030003,
    0x00000002, 0x000001c2, 0x000b0004, 0x455f4c47, 0x735f5458, 0x6c706d61,
    0x656c7265, 0x745f7373, 0x75747865, 0x665f6572, 0x74636e75, 0x736e6f69,
    0x00000000, 0x00040005, 0x00000004, 0x6e69616d, 0x00000000, 0x00050005,
    0x00000009, 0x656e696c, 0x64497261, 0x00000078, 0x00050005, 0x0000000b,
    0x72746e69, 0x6c695461, 0x00005965, 0x00050005, 0x00000012, 0x72746e69,
    0x6c695461, 0x00005865, 0x00040005, 0x00000016, 0x66664f78, 0x00746573,
    0x00050005, 0x00000019, 0x69746564, 0x5964656c, 0x00000000, 0x00050005,
    0x0000001b, 0x736e6f63, 0x746e6174, 0x00000073, 0x00070006, 0x0000001b,
    0x00000000, 0x6e616c70, 0x72745365, 0x73656469, 0x00000000, 0x00060005,
    0x0000001d, 0x68737570, 0x736e6f43, 0x746e6174, 0x00000073, 0x00050005,
    0x00000025, 0x69746564, 0x5864656c, 0x00000000, 0x00040005, 0x0000002c,
    0x66664f79, 0x00746573, 0x00030005, 0x00000032, 0x00767579, 0x00050005,
    0x00000035, 0x616d756c, 0x74786554, 0x00657275, 0x00060005, 0x00000046,
    0x6f726863, 0x6554616d, 0x72757478, 0x00000065, 0x00050005, 0x00000066,
    0x4374756f, 0x726f6c6f, 0x00000000, 0x00030047, 0x00000009, 0x00000000,
    0x00030047, 0x0000000b, 0x00000000, 0x00040047, 0x0000000b, 0x0000001e,
    0x00000001, 0x00030047, 0x0000000c, 0x00000000, 0x00030047, 0x0000000d,
    0x00000000, 0x00030047, 0x00000011, 0x00000000, 0x00030047, 0x00000012,
    0x00000000, 0x00040047, 0x00000012, 0x0000001e, 0x00000000, 0x00030047,
    0x00000013, 0x00000000, 0x00030047, 0x00000014, 0x00000000, 0x00030047,
    0x00000015, 0x00000000, 0x00030047, 0x00000016, 0x0000000e, 0x00040047,
    0x00000016, 0x0000001e, 0x00000003, 0x00030047, 0x0000001a, 0x00000000,
    0x00040048, 0x0000001b, 0x00000000, 0x00000000, 0x00050048, 0x0000001b,
    0x00000000, 0x00000023, 0x00000018, 0x00030047, 0x0000001b, 0x00000002,
    0x00030047, 0x00000022, 0x00000000, 0x00030047, 0x00000023, 0x00000000,
    0x00030047, 0x00000024, 0x00000000, 0x00030047, 0x00000026, 0x00000000,
    0x00030047, 0x00000029, 0x00000000, 0x00030047, 0x0000002c, 0x0000000e,
    0x00040047, 0x0000002c, 0x0000001e, 0x00000002, 0x00030047, 0x00000032,
    0x00000000, 0x00040047, 0x00000035, 0x00000022, 0x00000000, 0x00040047,
    0x00000035, 0x00000021, 0x00000000, 0x00040047, 0x00000046, 0x00000022,
    0x00000000, 0x00040047, 0x00000046, 0x00000021, 0x00000001, 0x00030047,
    0x00000059, 0x00000000, 0x00030047, 0x0000005a, 0x00000000, 0x00030047,
    0x0000005e, 0x00000000, 0x00030047, 0x0000005f, 0x00000000, 0x00030047,
    0x00000060, 0x00000000, 0x00030047, 0x00000066, 0x00000000, 0x00040047,
    0x00000066, 0x0000001e, 0x00000000, 0x00030047, 0x00000072, 0x00000000,
    0x00030047, 0x00000073, 0x00000000, 0x00030047, 0x00000075, 0x00000000,
    0x00030047, 0x00000076, 0x00000000, 0x00030047, 0x00000077, 0x00000000,
    0x00030047, 0x00000078, 0x00000000, 0x00030047, 0x00000071, 0x00000000,
    0x00020013, 0x00000002, 0x00030021, 0x00000003, 0x00000002, 0x00030016,
    0x00000006, 0x00000020, 0x00040017, 0x00000007, 0x00000006, 0x00000002,
    0x00040020, 0x00000008, 0x00000007, 0x00000007, 0x00040020, 0x0000000a,
    0x00000001, 0x00000007, 0x0004003b, 0x0000000a, 0x0000000b, 0x00000001,
    0x0004002b, 0x00000006, 0x0000000e, 0x41800000, 0x0004002b, 0x00000006,
    0x0000000f, 0x41000000, 0x0005002c, 0x00000007, 0x00000010, 0x0000000e,
    0x0000000f, 0x0004003b, 0x0000000a, 0x00000012, 0x00000001, 0x0004003b,
    0x0000000a, 0x00000016, 0x00000001, 0x0003001e, 0x0000001b, 0x00000007,
    0x00040020, 0x0000001c, 0x00000009, 0x0000001b, 0x0004003b, 0x0000001c,
    0x0000001d, 0x00000009, 0x00040015, 0x0000001e, 0x00000020, 0x00000001,
    0x0004002b, 0x0000001e, 0x0000001f, 0x00000000, 0x00040020, 0x00000020,
    0x00000009, 0x00000007, 0x0004003b, 0x0000000a, 0x0000002c, 0x00000001,
    0x00040017, 0x00000030, 0x00000006, 0x00000003, 0x00040020, 0x00000031,
    0x00000007, 0x00000030, 0x00090019, 0x00000033, 0x00000006, 0x00000001,
    0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00040020,
    0x00000034, 0x00000000, 0x00000033, 0x0004003b, 0x00000034, 0x00000035,
    0x00000000, 0x00040015, 0x00000037, 0x00000020, 0x00000000, 0x0004002b,
    0x00000037, 0x00000038, 0x00000000, 0x00040020, 0x00000039, 0x00000007,
    0x00000006, 0x00040017, 0x00000040, 0x0000001e, 0x00000002, 0x00040017,
    0x00000042, 0x00000006, 0x00000004, 0x0004003b, 0x00000034, 0x00000046,
    0x00000000, 0x0004002b, 0x00000037, 0x00000048, 0x00000001, 0x0004002b,
    0x00000037, 0x00000054, 0x00000002, 0x0004002b, 0x00000006, 0x00000057,
    0x3d808081, 0x0004002b, 0x00000006, 0x0000005c, 0x3f000000, 0x0005002c,
    0x00000007, 0x0000005d, 0x0000005c, 0x0000005c, 0x00040020, 0x00000065,
    0x00000003, 0x00000042, 0x0004003b, 0x00000065, 0x00000066, 0x00000003,
    0x00040018, 0x00000067, 0x00000030, 0x00000003, 0x0004002b, 0x00000006,
    0x00000068, 0x3f94fdf4, 0x0006002c, 0x00000030, 0x00000069, 0x00000068,
    0x00000068, 0x00000068, 0x0004002b, 0x00000006, 0x0000006a, 0x00000000,
    0x0004002b, 0x00000006, 0x0000006b, 0xbec83127, 0x0004002b, 0x00000006,
    0x0000006c, 0x400126e9, 0x0006002c, 0x00000030, 0x0000006d, 0x0000006a,
    0x0000006b, 0x0000006c, 0x0004002b, 0x00000006, 0x0000006e, 0x3fcc49ba,
    0x0004002b, 0x00000006, 0x0000006f, 0xbf5020c5, 0x0006002c, 0x00000030,
    0x00000070, 0x0000006e, 0x0000006f, 0x0000006a, 0x0006002c, 0x00000067,
    0x00000071, 0x00000069, 0x0000006d, 0x00000070, 0x0004002b, 0x00000006,
    0x00000074, 0x3f800000, 0x00050036, 0x00000002, 0x00000004, 0x00000000,
    0x00000003, 0x000200f8, 0x00000005, 0x0004003b, 0x00000008, 0x00000009,
    0x00000007, 0x0004003b, 0x00000008, 0x00000019, 0x00000007, 0x0004003b,
    0x00000008, 0x00000025, 0x00000007, 0x0004003b, 0x00000031, 0x00000032,
    0x00000007, 0x0004003d, 0x00000007, 0x0000000c, 0x0000000b, 0x0006000c,
    0x00000007, 0x0000000d, 0x00000001, 0x00000008, 0x0000000c, 0x00050085,
    0x00000007, 0x00000011, 0x0000000d, 0x00000010, 0x0004003d, 0x00000007,
    0x00000013, 0x00000012, 0x0006000c, 0x00000007, 0x00000014, 0x00000001,
    0x00000008, 0x00000013, 0x00050081, 0x00000007, 0x00000015, 0x00000011,
    0x00000014, 0x0004003d, 0x00000007, 0x00000017, 0x00000016, 0x00050081,
    0x00000007, 0x00000018, 0x00000015, 0x00000017, 0x0003003e, 0x00000009,
    0x00000018, 0x0004003d, 0x00000007, 0x0000001a, 0x00000009, 0x00050041,
    0x00000020, 0x00000021, 0x0000001d, 0x0000001f, 0x0004003d, 0x00000007,
    0x00000022, 0x00000021, 0x00050088, 0x00000007, 0x00000023, 0x0000001a,
    0x00000022, 0x0006000c, 0x00000007, 0x00000024, 0x00000001, 0x00000008,
    0x00000023, 0x0003003e, 0x00000019, 0x00000024, 0x0004003d, 0x00000007,
    0x00000026, 0x00000009, 0x0004003d, 0x00000007, 0x00000027, 0x00000019,
    0x00050041, 0x00000020, 0x00000028, 0x0000001d, 0x0000001f, 0x0004003d,
    0x00000007, 0x00000029, 0x00000028, 0x00050085, 0x00000007, 0x0000002a,
    0x00000027, 0x00000029, 0x00050083, 0x00000007, 0x0000002b, 0x00000026,
    0x0000002a, 0x0003003e, 0x00000025, 0x0000002b, 0x0004003d, 0x00000007,
    0x0000002d, 0x0000002c, 0x0004003d, 0x00000007, 0x0000002e, 0x00000019,
    0x00050081, 0x00000007, 0x0000002f, 0x0000002e, 0x0000002d, 0x0003003e,
    0x00000019, 0x0000002f, 0x0004003d, 0x00000033, 0x00000036, 0x00000035,
    0x00050041, 0x00000039, 0x0000003a, 0x00000025, 0x00000038, 0x0004003d,
    0x00000006, 0x0000003b, 0x0000003a, 0x0004006e, 0x0000001e, 0x0000003c,
    0x0000003b, 0x00050041, 0x00000039, 0x0000003d, 0x00000019, 0x00000038,
    0x0004003d, 0x00000006, 0x0000003e, 0x0000003d, 0x0004006e, 0x0000001e,
    0x0000003f, 0x0000003e, 0x00050050, 0x00000040, 0x00000041, 0x0000003c,
    0x0000003f, 0x0007005f, 0x00000042, 0x00000043, 0x00000036, 0x00000041,
    0x00000002, 0x0000001f, 0x00050051, 0x00000006, 0x00000044, 0x00000043,
    0x00000000, 0x00050041, 0x00000039, 0x00000045, 0x00000032, 0x00000038,
    0x0003003e, 0x00000045, 0x00000044, 0x0004003d, 0x00000033, 0x00000047,
    0x00000046, 0x00050041, 0x00000039, 0x00000049, 0x00000025, 0x00000048,
    0x0004003d, 0x00000006, 0x0000004a, 0x00000049, 0x0004006e, 0x0000001e,
    0x0000004b, 0x0000004a, 0x00050041, 0x00000039, 0x0000004c, 0x00000019,
    0x00000048, 0x0004003d, 0x00000006, 0x0000004d, 0x0000004c, 0x0004006e,
    0x0000001e, 0x0000004e, 0x0000004d, 0x00050050, 0x00000040, 0x0000004f,
    0x0000004b, 0x0000004e, 0x0007005f, 0x00000042, 0x00000050, 0x00000047,
    0x0000004f, 0x00000002, 0x0000001f, 0x0007004f, 0x00000007, 0x00000051,
    0x00000050, 0x00000050, 0x00000000, 0x00000001, 0x00050041, 0x00000039,
    0x00000052, 0x00000032, 0x00000048, 0x00050051, 0x00000006, 0x00000053,
    0x00000051, 0x00000000, 0x0003003e, 0x00000052, 0x00000053, 0x00050041,
    0x00000039, 0x00000055, 0x00000032, 0x00000054, 0x00050051, 0x00000006,
    0x00000056, 0x00000051, 0x00000001, 0x0003003e, 0x00000055, 0x00000056,
    0x00050041, 0x00000039, 0x00000058, 0x00000032, 0x00000038, 0x0004003d,
    0x00000006, 0x00000059, 0x00000058, 0x00050083, 0x00000006, 0x0000005a,
    0x00000059, 0x00000057, 0x00050041, 0x00000039, 0x0000005b, 0x00000032,
    0x00000038, 0x0003003e, 0x0000005b, 0x0000005a, 0x0004003d, 0x00000030,
    0x0000005e, 0x00000032, 0x0007004f, 0x00000007, 0x0000005f, 0x0000005e,
    0x0000005e, 0x00000001, 0x00000002, 0x00050083, 0x00000007, 0x00000060,
    0x0000005f, 0x0000005d, 0x00050041, 0x00000039, 0x00000061, 0x00000032,
    0x00000048, 0x00050051, 0x00000006, 0x00000062, 0x00000060, 0x00000000,
    0x0003003e, 0x00000061, 0x00000062, 0x00050041, 0x00000039, 0x00000063,
    0x00000032, 0x00000054, 0x00050051, 0x00000006, 0x00000064, 0x00000060,
    0x00000001, 0x0003003e, 0x00000063, 0x00000064, 0x0004003d, 0x00000030,
    0x00000072, 0x00000032, 0x00050091, 0x00000030, 0x00000073, 0x00000071,
    0x00000072, 0x00050051, 0x00000006, 0x00000075, 0x00000073, 0x00000000,
    0x00050051, 0x00000006, 0x00000076, 0x00000073, 0x00000001, 0x00050051,
    0x00000006, 0x00000077, 0x00000073, 0x00000002, 0x00070050, 0x00000042,
    0x00000078, 0x00000075, 0x00000076, 0x00000077, 0x00000074, 0x0003003e,
    0x00000066, 0x00000078, 0x000100fd, 0x00010038,
};
// clang-format off
/***
MM21Shader.frag source:
// Frag shader for MM21->ARGB conversion.

#version 450
#extension GL_EXT_samplerless_texture_functions : require

precision mediump float;
precision mediump int;

layout(location = 0) in mediump vec2 intraTileX;
layout(location = 1) in mediump vec2 intraTileY;

layout(location = 2) in flat highp vec2 yOffset;
layout(location = 3) in flat highp vec2 xOffset;

layout(location = 0) out vec4 outColor;

layout( push_constant ) uniform constants {
  layout(offset = 24) vec2 planeStrides;
} pushConstants;

// Ideally we would just use a 1D texture, but Vulkan has very tight limits
// on how large those can be, so we use 2D arrays instead and reinterpret our
// address as texture coordinates.
// TODO(b/304781371): Since the dimensions of these textures are arbitrary,
// investigate if there are some dimensions which are more efficient than
// others. For example, powers of 2 might make the division faster, or a
// width of 16*32 might eliminate the need to do any division at all.
layout(binding = 0) uniform texture2D lumaTexture;
layout(binding = 1) uniform texture2D chromaTexture;

const mat3 colorConversion = mat3(1.164, 1.164, 1.164,
          0.0, -0.391, 2.018,
          1.596, -0.813, 0.0);

void main() {
  vec2 linearIdx = (floor(intraTileY) * vec2(16, 8)) +
                   floor(intraTileX) + xOffset;
  // Like in the corresponding vertex shader, we really wanted integer
  // division and modulo, but floating point is faster.
  highp vec2 detiledY = floor(linearIdx / pushConstants.planeStrides);
  highp vec2 detiledX = linearIdx - (detiledY * pushConstants.planeStrides);
  detiledY += yOffset;

  vec3 yuv;
  yuv.r = texelFetch(lumaTexture, ivec2(detiledX[0], detiledY[0]), 0).r;
  yuv.gb = texelFetch(chromaTexture, ivec2(detiledX[1], detiledY[1]), 0).rg;

  // Standard BT.601 YUV->RGB color conversion.
  yuv.r -= 16.0/255.0;
  yuv.gb -= vec2(0.5, 0.5);
  outColor = vec4(colorConversion * yuv, 1.0);
}
***/
// clang-format on

constexpr uint32_t kMM21ShaderVert[] = {
    0x07230203, 0x00010000, 0x0008000b, 0x00000091, 0x00000000, 0x00020011,
    0x00000001, 0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e,
    0x00000000, 0x0003000e, 0x00000000, 0x00000001, 0x000b000f, 0x00000000,
    0x00000004, 0x6e69616d, 0x00000000, 0x0000000b, 0x0000005b, 0x0000006c,
    0x00000073, 0x0000008b, 0x0000008e, 0x00030003, 0x00000002, 0x000001c2,
    0x00040005, 0x00000004, 0x6e69616d, 0x00000000, 0x00040005, 0x00000008,
    0x656c6974, 0x00786449, 0x00060005, 0x0000000b, 0x565f6c67, 0x65747265,
    0x646e4978, 0x00007865, 0x00060005, 0x00000011, 0x63657270, 0x54657369,
    0x49656c69, 0x00007864, 0x00050005, 0x00000018, 0x656c6974, 0x74726556,
    0x00786449, 0x00050005, 0x00000022, 0x656c6974, 0x726f6f43, 0x00007364,
    0x00050005, 0x00000024, 0x736e6f63, 0x746e6174, 0x00000073, 0x00060006,
    0x00000024, 0x00000000, 0x656c6974, 0x72655073, 0x00776f52, 0x00050006,
    0x00000024, 0x00000001, 0x736d6964, 0x00000000, 0x00070006, 0x00000024,
    0x00000002, 0x6e616c70, 0x72745365, 0x73656469, 0x00000000, 0x00060005,
    0x00000026, 0x68737570, 0x736e6f43, 0x746e6174, 0x00000073, 0x00030005,
    0x00000039, 0x00736f70, 0x00050005, 0x00000048, 0x65646e69, 0x6c626178,
    0x00000065, 0x00060005, 0x00000059, 0x505f6c67, 0x65567265, 0x78657472,
    0x00000000, 0x00060006, 0x00000059, 0x00000000, 0x505f6c67, 0x7469736f,
    0x006e6f69, 0x00070006, 0x00000059, 0x00000001, 0x505f6c67, 0x746e696f,
    0x657a6953, 0x00000000, 0x00070006, 0x00000059, 0x00000002, 0x435f6c67,
    0x4470696c, 0x61747369, 0x0065636e, 0x00070006, 0x00000059, 0x00000003,
    0x435f6c67, 0x446c6c75, 0x61747369, 0x0065636e, 0x00030005, 0x0000005b,
    0x00000000, 0x00050005, 0x00000062, 0x656e696c, 0x61427261, 0x00006573,
    0x00040005, 0x0000006c, 0x66664f79, 0x00746573, 0x00040005, 0x00000073,
    0x66664f78, 0x00746573, 0x00060005, 0x0000007b, 0x72746e69, 0x6c695461,
    0x6f6f4365, 0x00006472, 0x00050005, 0x0000007d, 0x65646e69, 0x6c626178,
    0x00000065, 0x00050005, 0x00000081, 0x65646e69, 0x6c626178, 0x00000065,
    0x00050005, 0x0000008b, 0x72746e69, 0x6c695461, 0x00005865, 0x00050005,
    0x0000008e, 0x72746e69, 0x6c695461, 0x00005965, 0x00040047, 0x0000000b,
    0x0000000b, 0x0000002a, 0x00050048, 0x00000024, 0x00000000, 0x00000023,
    0x00000000, 0x00050048, 0x00000024, 0x00000001, 0x00000023, 0x00000008,
    0x00050048, 0x00000024, 0x00000002, 0x00000023, 0x00000010, 0x00030047,
    0x00000024, 0x00000002, 0x00050048, 0x00000059, 0x00000000, 0x0000000b,
    0x00000000, 0x00050048, 0x00000059, 0x00000001, 0x0000000b, 0x00000001,
    0x00050048, 0x00000059, 0x00000002, 0x0000000b, 0x00000003, 0x00050048,
    0x00000059, 0x00000003, 0x0000000b, 0x00000004, 0x00030047, 0x00000059,
    0x00000002, 0x00030047, 0x0000006c, 0x0000000e, 0x00040047, 0x0000006c,
    0x0000001e, 0x00000002, 0x00030047, 0x00000073, 0x0000000e, 0x00040047,
    0x00000073, 0x0000001e, 0x00000003, 0x00030047, 0x0000008b, 0x00000000,
    0x00040047, 0x0000008b, 0x0000001e, 0x00000000, 0x00030047, 0x0000008e,
    0x00000000, 0x00040047, 0x0000008e, 0x0000001e, 0x00000001, 0x00020013,
    0x00000002, 0x00030021, 0x00000003, 0x00000002, 0x00030016, 0x00000006,
    0x00000020, 0x00040020, 0x00000007, 0x00000007, 0x00000006, 0x00040015,
    0x00000009, 0x00000020, 0x00000001, 0x00040020, 0x0000000a, 0x00000001,
    0x00000009, 0x0004003b, 0x0000000a, 0x0000000b, 0x00000001, 0x0004002b,
    0x00000006, 0x0000000e, 0x3e2aaaab, 0x0004002b, 0x00000006, 0x00000013,
    0x3dcccccd, 0x00040015, 0x00000016, 0x00000020, 0x00000000, 0x00040020,
    0x00000017, 0x00000007, 0x00000016, 0x0004002b, 0x00000006, 0x0000001c,
    0x40c00000, 0x00040017, 0x00000020, 0x00000006, 0x00000002, 0x00040020,
    0x00000021, 0x00000007, 0x00000020, 0x0005001e, 0x00000024, 0x00000020,
    0x00000020, 0x00000020, 0x00040020, 0x00000025, 0x00000009, 0x00000024,
    0x0004003b, 0x00000025, 0x00000026, 0x00000009, 0x0004002b, 0x00000009,
    0x00000027, 0x00000000, 0x0004002b, 0x00000016, 0x00000028, 0x00000000,
    0x00040020, 0x00000029, 0x00000009, 0x00000006, 0x0004002b, 0x00000016,
    0x0000002e, 0x00000001, 0x0004002b, 0x00000006, 0x0000003b, 0x41800000,
    0x0004002b, 0x00000006, 0x0000003c, 0x42000000, 0x0005002c, 0x00000020,
    0x0000003d, 0x0000003b, 0x0000003c, 0x0004002b, 0x00000016, 0x0000003f,
    0x00000006, 0x0004001c, 0x00000040, 0x00000020, 0x0000003f, 0x0004002b,
    0x00000006, 0x00000041, 0x00000000, 0x0005002c, 0x00000020, 0x00000042,
    0x0000003b, 0x00000041, 0x0005002c, 0x00000020, 0x00000043, 0x00000041,
    0x00000041, 0x0005002c, 0x00000020, 0x00000044, 0x00000041, 0x0000003c,
    0x0009002c, 0x00000040, 0x00000045, 0x00000042, 0x0000003d, 0x00000043,
    0x00000043, 0x0000003d, 0x00000044, 0x00040020, 0x00000047, 0x00000007,
    0x00000040, 0x0004002b, 0x00000006, 0x0000004d, 0x40000000, 0x0004002b,
    0x00000009, 0x0000004f, 0x00000001, 0x00040020, 0x00000050, 0x00000009,
    0x00000020, 0x0004002b, 0x00000006, 0x00000054, 0x3f800000, 0x0005002c,
    0x00000020, 0x00000055, 0x00000054, 0x00000054, 0x00040017, 0x00000057,
    0x00000006, 0x00000004, 0x0004001c, 0x00000058, 0x00000006, 0x0000002e,
    0x0006001e, 0x00000059, 0x00000057, 0x00000006, 0x00000058, 0x00000058,
    0x00040020, 0x0000005a, 0x00000003, 0x00000059, 0x0004003b, 0x0000005a,
    0x0000005b, 0x00000003, 0x00040020, 0x00000060, 0x00000003, 0x00000057,
    0x0004002b, 0x00000006, 0x00000064, 0x44000000, 0x0004002b, 0x00000006,
    0x00000065, 0x43000000, 0x0005002c, 0x00000020, 0x00000066, 0x00000064,
    0x00000065, 0x00040020, 0x0000006b, 0x00000003, 0x00000020, 0x0004003b,
    0x0000006b, 0x0000006c, 0x00000003, 0x0004002b, 0x00000009, 0x0000006e,
    0x00000002, 0x0004003b, 0x0000006b, 0x00000073, 0x00000003, 0x00040020,
    0x0000007a, 0x00000007, 0x00000057, 0x0004003b, 0x0000006b, 0x0000008b,
    0x00000003, 0x0004003b, 0x0000006b, 0x0000008e, 0x00000003, 0x00050036,
    0x00000002, 0x00000004, 0x00000000, 0x00000003, 0x000200f8, 0x00000005,
    0x0004003b, 0x00000007, 0x00000008, 0x00000007, 0x0004003b, 0x00000007,
    0x00000011, 0x00000007, 0x0004003b, 0x00000017, 0x00000018, 0x00000007,
    0x0004003b, 0x00000021, 0x00000022, 0x00000007, 0x0004003b, 0x00000021,
    0x00000039, 0x00000007, 0x0004003b, 0x00000047, 0x00000048, 0x00000007,
    0x0004003b, 0x00000021, 0x00000062, 0x00000007, 0x0004003b, 0x0000007a,
    0x0000007b, 0x00000007, 0x0004003b, 0x00000047, 0x0000007d, 0x00000007,
    0x0004003b, 0x00000047, 0x00000081, 0x00000007, 0x0004003d, 0x00000009,
    0x0000000c, 0x0000000b, 0x0004006f, 0x00000006, 0x0000000d, 0x0000000c,
    0x00050085, 0x00000006, 0x0000000f, 0x0000000d, 0x0000000e, 0x0006000c,
    0x00000006, 0x00000010, 0x00000001, 0x00000008, 0x0000000f, 0x0003003e,
    0x00000008, 0x00000010, 0x0004003d, 0x00000006, 0x00000012, 0x00000008,
    0x0003003e, 0x00000011, 0x00000012, 0x0004003d, 0x00000006, 0x00000014,
    0x00000008, 0x00050081, 0x00000006, 0x00000015, 0x00000014, 0x00000013,
    0x0003003e, 0x00000008, 0x00000015, 0x0004003d, 0x00000009, 0x00000019,
    0x0000000b, 0x0004007c, 0x00000016, 0x0000001a, 0x00000019, 0x0004003d,
    0x00000006, 0x0000001b, 0x00000008, 0x00050085, 0x00000006, 0x0000001d,
    0x0000001b, 0x0000001c, 0x0004006d, 0x00000016, 0x0000001e, 0x0000001d,
    0x00050082, 0x00000016, 0x0000001f, 0x0000001a, 0x0000001e, 0x0003003e,
    0x00000018, 0x0000001f, 0x0004003d, 0x00000006, 0x00000023, 0x00000008,
    0x00060041, 0x00000029, 0x0000002a, 0x00000026, 0x00000027, 0x00000028,
    0x0004003d, 0x00000006, 0x0000002b, 0x0000002a, 0x00050088, 0x00000006,
    0x0000002c, 0x00000023, 0x0000002b, 0x0006000c, 0x00000006, 0x0000002d,
    0x00000001, 0x00000008, 0x0000002c, 0x00050041, 0x00000007, 0x0000002f,
    0x00000022, 0x0000002e, 0x0003003e, 0x0000002f, 0x0000002d, 0x0004003d,
    0x00000006, 0x00000030, 0x00000008, 0x00050041, 0x00000007, 0x00000031,
    0x00000022, 0x0000002e, 0x0004003d, 0x00000006, 0x00000032, 0x00000031,
    0x00060041, 0x00000029, 0x00000033, 0x00000026, 0x00000027, 0x00000028,
    0x0004003d, 0x00000006, 0x00000034, 0x00000033, 0x00050085, 0x00000006,
    0x00000035, 0x00000032, 0x00000034, 0x00050083, 0x00000006, 0x00000036,
    0x00000030, 0x00000035, 0x0006000c, 0x00000006, 0x00000037, 0x00000001,
    0x00000008, 0x00000036, 0x00050041, 0x00000007, 0x00000038, 0x00000022,
    0x00000028, 0x0003003e, 0x00000038, 0x00000037, 0x0004003d, 0x00000020,
    0x0000003a, 0x00000022, 0x00050085, 0x00000020, 0x0000003e, 0x0000003a,
    0x0000003d, 0x0004003d, 0x00000016, 0x00000046, 0x00000018, 0x0003003e,
    0x00000048, 0x00000045, 0x00050041, 0x00000021, 0x00000049, 0x00000048,
    0x00000046, 0x0004003d, 0x00000020, 0x0000004a, 0x00000049, 0x00050081,
    0x00000020, 0x0000004b, 0x0000003e, 0x0000004a, 0x0003003e, 0x00000039,
    0x0000004b, 0x0004003d, 0x00000020, 0x0000004c, 0x00000039, 0x0005008e,
    0x00000020, 0x0000004e, 0x0000004c, 0x0000004d, 0x00050041, 0x00000050,
    0x00000051, 0x00000026, 0x0000004f, 0x0004003d, 0x00000020, 0x00000052,
    0x00000051, 0x00050088, 0x00000020, 0x00000053, 0x0000004e, 0x00000052,
    0x00050083, 0x00000020, 0x00000056, 0x00000053, 0x00000055, 0x0003003e,
    0x00000039, 0x00000056, 0x0004003d, 0x00000020, 0x0000005c, 0x00000039,
    0x00050051, 0x00000006, 0x0000005d, 0x0000005c, 0x00000000, 0x00050051,
    0x00000006, 0x0000005e, 0x0000005c, 0x00000001, 0x00070050, 0x00000057,
    0x0000005f, 0x0000005d, 0x0000005e, 0x00000041, 0x00000054, 0x00050041,
    0x00000060, 0x00000061, 0x0000005b, 0x00000027, 0x0003003e, 0x00000061,
    0x0000005f, 0x0004003d, 0x00000006, 0x00000063, 0x00000011, 0x0005008e,
    0x00000020, 0x00000067, 0x00000066, 0x00000063, 0x0003003e, 0x00000062,
    0x00000067, 0x0004003d, 0x00000020, 0x00000068, 0x00000062, 0x00050050,
    0x00000020, 0x00000069, 0x00000013, 0x00000013, 0x00050081, 0x00000020,
    0x0000006a, 0x00000068, 0x00000069, 0x0003003e, 0x00000062, 0x0000006a,
    0x0004003d, 0x00000020, 0x0000006d, 0x00000062, 0x00050041, 0x00000050,
    0x0000006f, 0x00000026, 0x0000006e, 0x0004003d, 0x00000020, 0x00000070,
    0x0000006f, 0x00050088, 0x00000020, 0x00000071, 0x0000006d, 0x00000070,
    0x0006000c, 0x00000020, 0x00000072, 0x00000001, 0x00000008, 0x00000071,
    0x0003003e, 0x0000006c, 0x00000072, 0x0004003d, 0x00000020, 0x00000074,
    0x00000062, 0x0004003d, 0x00000020, 0x00000075, 0x0000006c, 0x00050041,
    0x00000050, 0x00000076, 0x00000026, 0x0000006e, 0x0004003d, 0x00000020,
    0x00000077, 0x00000076, 0x00050085, 0x00000020, 0x00000078, 0x00000075,
    0x00000077, 0x00050083, 0x00000020, 0x00000079, 0x00000074, 0x00000078,
    0x0003003e, 0x00000073, 0x00000079, 0x0004003d, 0x00000016, 0x0000007c,
    0x00000018, 0x0003003e, 0x0000007d, 0x00000045, 0x00050041, 0x00000021,
    0x0000007e, 0x0000007d, 0x0000007c, 0x0004003d, 0x00000020, 0x0000007f,
    0x0000007e, 0x0004003d, 0x00000016, 0x00000080, 0x00000018, 0x0003003e,
    0x00000081, 0x00000045, 0x00050041, 0x00000021, 0x00000082, 0x00000081,
    0x00000080, 0x0004003d, 0x00000020, 0x00000083, 0x00000082, 0x00050050,
    0x00000020, 0x00000084, 0x0000004d, 0x0000004d, 0x00050088, 0x00000020,
    0x00000085, 0x00000083, 0x00000084, 0x00050051, 0x00000006, 0x00000086,
    0x0000007f, 0x00000000, 0x00050051, 0x00000006, 0x00000087, 0x0000007f,
    0x00000001, 0x00050051, 0x00000006, 0x00000088, 0x00000085, 0x00000000,
    0x00050051, 0x00000006, 0x00000089, 0x00000085, 0x00000001, 0x00070050,
    0x00000057, 0x0000008a, 0x00000086, 0x00000087, 0x00000088, 0x00000089,
    0x0003003e, 0x0000007b, 0x0000008a, 0x0004003d, 0x00000057, 0x0000008c,
    0x0000007b, 0x0007004f, 0x00000020, 0x0000008d, 0x0000008c, 0x0000008c,
    0x00000000, 0x00000002, 0x0003003e, 0x0000008b, 0x0000008d, 0x0004003d,
    0x00000057, 0x0000008f, 0x0000007b, 0x0007004f, 0x00000020, 0x00000090,
    0x0000008f, 0x0000008f, 0x00000001, 0x00000003, 0x0003003e, 0x0000008e,
    0x00000090, 0x000100fd, 0x00010038,
};
// clang-format off
/***
MM21Shader.vert source:
// Vertex shader for MM21->ARGB conversion.
// We produce 2 right triangles for each MM21 tile. This allows us to
// compute a few important values in the vertex shader instead of the
// fragment shader. This is desirable because the vertex shader only runs
// 6 times (once for each vertex) per tile, which means the cost is amortized
// over 16*32/6 ~= 85 pixels.

#version 450

precision highp float;
precision highp int;

// We can actually exploit the rasterizer to figure out the intra tile
// coordinates for us.
layout(location = 0) out mediump vec2 intraTileX;
layout(location = 1) out mediump vec2 intraTileY;

layout(location = 2) flat out highp vec2 yOffset;
layout(location = 3) flat out highp vec2 xOffset;

layout( push_constant ) uniform constants {
  // Vulkan push constants have interesting alignment rules, so we use a vec2
  // when we could get away with a float just to make things simple.
  vec2 tilesPerRow;
  vec2 dims;
  vec2 planeStrides;
} pushConstants;

const vec2 kLumaTileDims = vec2(16.0, 32.0);
const vec2 kTileSize = vec2(512.0, 128.0);

const vec2 intraTileCoords[6] = vec2[6](
  vec2(16.0, 0.0),
  vec2(16.0, 32.0),
  vec2(0.0, 0.0),
  vec2(0.0, 0.0),
  vec2(16.0, 32.0),
  vec2(0.0, 32.0)
);

void main() {
  // We really want something like:
  // int tileIdx = gl_VertexIndex / 6;
  // int tileVertIdx = gl_VertexIndex % 6;
  // But integer division and modulo are *very* expensive on mobile GPUs, so
  // we use floating point multiplication, subtraction, and flooring to
  // approximate these operations.
  // 0.1 is a fudge factor to counteract floating point rounding errors.
  // Note that we multiply this value by 6, so using 0.5 like we do in the frag
  // shader isn't appropriate because that will genuinely change the integer
  // answer.
  float tileIdx = floor(float(gl_VertexIndex) * (1.0 / 6.0));
  float preciseTileIdx = tileIdx;
  tileIdx += 0.1;
  uint tileVertIdx = gl_VertexIndex - uint(tileIdx * 6.0);
  vec2 tileCoords;
  tileCoords.g = floor(tileIdx / pushConstants.tilesPerRow.x);
  tileCoords.r = floor(tileIdx - (tileCoords.g * pushConstants.tilesPerRow.x));
  vec2 pos = tileCoords * kLumaTileDims + intraTileCoords[tileVertIdx];
  pos = pos * 2.0 / pushConstants.dims - vec2(1.0, 1.0);
  gl_Position = vec4(pos, 0.0, 1.0);

  // Compute the base address for the whole tile.
  vec2 linearBase = preciseTileIdx * kTileSize;
  linearBase += 0.1;
  yOffset = floor(linearBase / pushConstants.planeStrides);
  xOffset = linearBase - (yOffset * pushConstants.planeStrides);

  vec4 intraTileCoord = vec4(intraTileCoords[tileVertIdx],
  			     intraTileCoords[tileVertIdx] / 2.0);
  intraTileX = intraTileCoord.rb;
  intraTileY = intraTileCoord.ga;
}
***/
// clang-format on

constexpr uint32_t kMT2TShaderFrag[] = {
    0x07230203, 0x00010000, 0x0008000b, 0x000000df, 0x00000000, 0x00020011,
    0x00000001, 0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e,
    0x00000000, 0x0003000e, 0x00000000, 0x00000001, 0x000a000f, 0x00000004,
    0x00000004, 0x6e69616d, 0x00000000, 0x0000000b, 0x0000001d, 0x00000021,
    0x0000005c, 0x000000cd, 0x00030010, 0x00000004, 0x00000007, 0x00030003,
    0x00000002, 0x000001c2, 0x000b0004, 0x455f4c47, 0x735f5458, 0x6c706d61,
    0x656c7265, 0x745f7373, 0x75747865, 0x665f6572, 0x74636e75, 0x736e6f69,
    0x00000000, 0x00040005, 0x00000004, 0x6e69616d, 0x00000000, 0x00050005,
    0x00000009, 0x636f6c62, 0x7864496b, 0x00000000, 0x00050005, 0x0000000b,
    0x72746e69, 0x6c695461, 0x00005965, 0x00050005, 0x00000011, 0x636f6c62,
    0x776f526b, 0x00786449, 0x00060005, 0x00000016, 0x4c62736d, 0x61656e69,
    0x78644972, 0x00000000, 0x00050005, 0x0000001d, 0x72746e69, 0x6c695461,
    0x00005865, 0x00040005, 0x00000021, 0x66664f78, 0x00746573, 0x00060005,
    0x0000002b, 0x4c62736c, 0x61656e69, 0x78644972, 0x00000000, 0x00050005,
    0x00000039, 0x656e696c, 0x64497261, 0x00000078, 0x00040005, 0x00000041,
    0x69727473, 0x00736564, 0x00050005, 0x00000042, 0x736e6f63, 0x746e6174,
    0x00000073, 0x00070006, 0x00000042, 0x00000000, 0x6e616c70, 0x72745365,
    0x73656469, 0x00000000, 0x00060005, 0x00000044, 0x68737570, 0x736e6f43,
    0x746e6174, 0x00000073, 0x00050005, 0x00000051, 0x69746564, 0x5964656c,
    0x00000000, 0x00050005, 0x00000056, 0x69746564, 0x5864656c, 0x00000000,
    0x00040005, 0x0000005c, 0x66664f79, 0x00746573, 0x00030005, 0x00000068,
    0x00767579, 0x00050005, 0x0000006b, 0x616d756c, 0x74786554, 0x00657275,
    0x00060005, 0x0000007b, 0x6f726863, 0x6554616d, 0x72757478, 0x00000065,
    0x00040005, 0x0000008c, 0x4c767579, 0x00006273, 0x00040005, 0x000000a7,
    0x66696873, 0x00000074, 0x00050005, 0x000000cd, 0x4374756f, 0x726f6c6f,
    0x00000000, 0x00030047, 0x00000009, 0x00000000, 0x00030047, 0x0000000b,
    0x00000000, 0x00040047, 0x0000000b, 0x0000001e, 0x00000001, 0x00030047,
    0x0000000c, 0x00000000, 0x00030047, 0x0000000e, 0x00000000, 0x00030047,
    0x0000000f, 0x00000000, 0x00030047, 0x00000010, 0x00000000, 0x00030047,
    0x00000011, 0x00000000, 0x00030047, 0x00000012, 0x00000000, 0x00030047,
    0x00000013, 0x00000000, 0x00030047, 0x00000014, 0x00000000, 0x00030047,
    0x00000015, 0x00000000, 0x00030047, 0x00000017, 0x00000000, 0x00030047,
    0x00000018, 0x00000000, 0x00030047, 0x0000001c, 0x00000000, 0x00030047,
    0x0000001d, 0x00000000, 0x00040047, 0x0000001d, 0x0000001e, 0x00000000,
    0x00030047, 0x0000001e, 0x00000000, 0x00030047, 0x0000001f, 0x00000000,
    0x00030047, 0x00000020, 0x00000000, 0x00030047, 0x00000021, 0x0000000e,
    0x00040047, 0x00000021, 0x0000001e, 0x00000003, 0x00030047, 0x00000024,
    0x00000000, 0x00030047, 0x00000026, 0x00000000, 0x00030047, 0x00000027,
    0x00000000, 0x00030047, 0x00000028, 0x00000000, 0x00030047, 0x0000002c,
    0x00000000, 0x00030047, 0x00000030, 0x00000000, 0x00030047, 0x00000033,
    0x00000000, 0x00030047, 0x00000034, 0x00000000, 0x00050048, 0x00000042,
    0x00000000, 0x00000023, 0x00000018, 0x00030047, 0x00000042, 0x00000002,
    0x00030047, 0x0000005c, 0x0000000e, 0x00040047, 0x0000005c, 0x0000001e,
    0x00000002, 0x00030047, 0x00000068, 0x00000000, 0x00040047, 0x0000006b,
    0x00000022, 0x00000000, 0x00040047, 0x0000006b, 0x00000021, 0x00000000,
    0x00040047, 0x0000007b, 0x00000022, 0x00000000, 0x00040047, 0x0000007b,
    0x00000021, 0x00000001, 0x00030047, 0x0000008c, 0x00000000, 0x00030047,
    0x000000a7, 0x00000000, 0x00030047, 0x000000ac, 0x00000000, 0x00030047,
    0x000000ad, 0x00000000, 0x00030047, 0x000000ae, 0x00000000, 0x00030047,
    0x000000af, 0x00000000, 0x00030047, 0x000000b0, 0x00000000, 0x00030047,
    0x000000b3, 0x00000000, 0x00030047, 0x000000b4, 0x00000000, 0x00030047,
    0x000000b5, 0x00000000, 0x00030047, 0x000000b6, 0x00000000, 0x00030047,
    0x000000b7, 0x00000000, 0x00030047, 0x000000b9, 0x00000000, 0x00030047,
    0x000000ba, 0x00000000, 0x00030047, 0x000000bb, 0x00000000, 0x00030047,
    0x000000bc, 0x00000000, 0x00030047, 0x000000bd, 0x00000000, 0x00030047,
    0x000000c0, 0x00000000, 0x00030047, 0x000000c1, 0x00000000, 0x00030047,
    0x000000c5, 0x00000000, 0x00030047, 0x000000c6, 0x00000000, 0x00030047,
    0x000000c7, 0x00000000, 0x00030047, 0x000000cd, 0x00000000, 0x00040047,
    0x000000cd, 0x0000001e, 0x00000000, 0x00030047, 0x000000d9, 0x00000000,
    0x00030047, 0x000000da, 0x00000000, 0x00030047, 0x000000db, 0x00000000,
    0x00030047, 0x000000dc, 0x00000000, 0x00030047, 0x000000dd, 0x00000000,
    0x00030047, 0x000000de, 0x00000000, 0x00030047, 0x000000d8, 0x00000000,
    0x00020013, 0x00000002, 0x00030021, 0x00000003, 0x00000002, 0x00030016,
    0x00000006, 0x00000020, 0x00040017, 0x00000007, 0x00000006, 0x00000002,
    0x00040020, 0x00000008, 0x00000007, 0x00000007, 0x00040020, 0x0000000a,
    0x00000001, 0x00000007, 0x0004003b, 0x0000000a, 0x0000000b, 0x00000001,
    0x0004002b, 0x00000006, 0x0000000d, 0x40800000, 0x0004002b, 0x00000006,
    0x00000019, 0x41800000, 0x0004002b, 0x00000006, 0x0000001a, 0x41000000,
    0x0005002c, 0x00000007, 0x0000001b, 0x00000019, 0x0000001a, 0x0004003b,
    0x0000000a, 0x0000001d, 0x00000001, 0x0004003b, 0x0000000a, 0x00000021,
    0x00000001, 0x0004002b, 0x00000006, 0x00000025, 0x3f800000, 0x0004002b,
    0x00000006, 0x0000002d, 0x42a00000, 0x0004002b, 0x00000006, 0x0000002e,
    0x42200000, 0x0005002c, 0x00000007, 0x0000002f, 0x0000002d, 0x0000002e,
    0x00040017, 0x00000037, 0x00000006, 0x00000004, 0x00040020, 0x00000038,
    0x00000007, 0x00000037, 0x0003001e, 0x00000042, 0x00000007, 0x00040020,
    0x00000043, 0x00000009, 0x00000042, 0x0004003b, 0x00000043, 0x00000044,
    0x00000009, 0x00040015, 0x00000045, 0x00000020, 0x00000001, 0x0004002b,
    0x00000045, 0x00000046, 0x00000000, 0x00040020, 0x00000047, 0x00000009,
    0x00000007, 0x0004003b, 0x0000000a, 0x0000005c, 0x00000001, 0x00040017,
    0x00000066, 0x00000006, 0x00000003, 0x00040020, 0x00000067, 0x00000007,
    0x00000066, 0x00090019, 0x00000069, 0x00000006, 0x00000001, 0x00000000,
    0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00040020, 0x0000006a,
    0x00000000, 0x00000069, 0x0004003b, 0x0000006a, 0x0000006b, 0x00000000,
    0x00040015, 0x0000006d, 0x00000020, 0x00000000, 0x0004002b, 0x0000006d,
    0x0000006e, 0x00000000, 0x00040020, 0x0000006f, 0x00000007, 0x00000006,
    0x00040017, 0x00000076, 0x00000045, 0x00000002, 0x0004003b, 0x0000006a,
    0x0000007b, 0x00000000, 0x0004002b, 0x0000006d, 0x0000007d, 0x00000001,
    0x0004002b, 0x0000006d, 0x00000089, 0x00000002, 0x0004002b, 0x0000006d,
    0x00000099, 0x00000003, 0x0004002b, 0x00000006, 0x000000a8, 0x3f7f0000,
    0x0005002c, 0x00000007, 0x000000a9, 0x000000a8, 0x000000a8, 0x0004002b,
    0x00000006, 0x000000aa, 0x40000000, 0x0004002b, 0x00000006, 0x000000ab,
    0x40400000, 0x0004002b, 0x00000006, 0x000000b8, 0x3b802008, 0x0004002b,
    0x00000006, 0x000000be, 0x3d808081, 0x0004002b, 0x00000006, 0x000000c3,
    0x3f000000, 0x0005002c, 0x00000007, 0x000000c4, 0x000000c3, 0x000000c3,
    0x00040020, 0x000000cc, 0x00000003, 0x00000037, 0x0004003b, 0x000000cc,
    0x000000cd, 0x00000003, 0x00040018, 0x000000ce, 0x00000066, 0x00000003,
    0x0004002b, 0x00000006, 0x000000cf, 0x3f94fdf4, 0x0006002c, 0x00000066,
    0x000000d0, 0x000000cf, 0x000000cf, 0x000000cf, 0x0004002b, 0x00000006,
    0x000000d1, 0x00000000, 0x0004002b, 0x00000006, 0x000000d2, 0xbec83127,
    0x0004002b, 0x00000006, 0x000000d3, 0x400126e9, 0x0006002c, 0x00000066,
    0x000000d4, 0x000000d1, 0x000000d2, 0x000000d3, 0x0004002b, 0x00000006,
    0x000000d5, 0x3fcc49ba, 0x0004002b, 0x00000006, 0x000000d6, 0xbf5020c5,
    0x0006002c, 0x00000066, 0x000000d7, 0x000000d5, 0x000000d6, 0x000000d1,
    0x0006002c, 0x000000ce, 0x000000d8, 0x000000d0, 0x000000d4, 0x000000d7,
    0x00050036, 0x00000002, 0x00000004, 0x00000000, 0x00000003, 0x000200f8,
    0x00000005, 0x0004003b, 0x00000008, 0x00000009, 0x00000007, 0x0004003b,
    0x00000008, 0x00000011, 0x00000007, 0x0004003b, 0x00000008, 0x00000016,
    0x00000007, 0x0004003b, 0x00000008, 0x0000002b, 0x00000007, 0x0004003b,
    0x00000038, 0x00000039, 0x00000007, 0x0004003b, 0x00000038, 0x00000041,
    0x00000007, 0x0004003b, 0x00000038, 0x00000051, 0x00000007, 0x0004003b,
    0x00000038, 0x00000056, 0x00000007, 0x0004003b, 0x00000067, 0x00000068,
    0x00000007, 0x0004003b, 0x00000067, 0x0000008c, 0x00000007, 0x0004003b,
    0x00000067, 0x000000a7, 0x00000007, 0x0004003d, 0x00000007, 0x0000000c,
    0x0000000b, 0x00050050, 0x00000007, 0x0000000e, 0x0000000d, 0x0000000d,
    0x00050088, 0x00000007, 0x0000000f, 0x0000000c, 0x0000000e, 0x0006000c,
    0x00000007, 0x00000010, 0x00000001, 0x00000008, 0x0000000f, 0x0003003e,
    0x00000009, 0x00000010, 0x0004003d, 0x00000007, 0x00000012, 0x0000000b,
    0x0004003d, 0x00000007, 0x00000013, 0x00000009, 0x0005008e, 0x00000007,
    0x00000014, 0x00000013, 0x0000000d, 0x00050083, 0x00000007, 0x00000015,
    0x00000012, 0x00000014, 0x0003003e, 0x00000011, 0x00000015, 0x0004003d,
    0x00000007, 0x00000017, 0x0000000b, 0x0006000c, 0x00000007, 0x00000018,
    0x00000001, 0x00000008, 0x00000017, 0x00050085, 0x00000007, 0x0000001c,
    0x00000018, 0x0000001b, 0x0004003d, 0x00000007, 0x0000001e, 0x0000001d,
    0x0006000c, 0x00000007, 0x0000001f, 0x00000001, 0x00000008, 0x0000001e,
    0x00050081, 0x00000007, 0x00000020, 0x0000001c, 0x0000001f, 0x0004003d,
    0x00000007, 0x00000022, 0x00000021, 0x00050081, 0x00000007, 0x00000023,
    0x00000020, 0x00000022, 0x0003003e, 0x00000016, 0x00000023, 0x0004003d,
    0x00000007, 0x00000024, 0x00000009, 0x00050050, 0x00000007, 0x00000026,
    0x00000025, 0x00000025, 0x00050081, 0x00000007, 0x00000027, 0x00000024,
    0x00000026, 0x00050085, 0x00000007, 0x00000028, 0x00000027, 0x0000001b,
    0x0004003d, 0x00000007, 0x00000029, 0x00000016, 0x00050081, 0x00000007,
    0x0000002a, 0x00000029, 0x00000028, 0x0003003e, 0x00000016, 0x0000002a,
    0x0004003d, 0x00000007, 0x0000002c, 0x00000009, 0x00050085, 0x00000007,
    0x00000030, 0x0000002c, 0x0000002f, 0x0004003d, 0x00000007, 0x00000031,
    0x00000021, 0x00050081, 0x00000007, 0x00000032, 0x00000030, 0x00000031,
    0x0003003e, 0x0000002b, 0x00000032, 0x0004003d, 0x00000007, 0x00000033,
    0x0000001d, 0x0006000c, 0x00000007, 0x00000034, 0x00000001, 0x00000008,
    0x00000033, 0x0004003d, 0x00000007, 0x00000035, 0x0000002b, 0x00050081,
    0x00000007, 0x00000036, 0x00000035, 0x00000034, 0x0003003e, 0x0000002b,
    0x00000036, 0x0004003d, 0x00000007, 0x0000003a, 0x00000016, 0x0004003d,
    0x00000007, 0x0000003b, 0x0000002b, 0x00050051, 0x00000006, 0x0000003c,
    0x0000003a, 0x00000000, 0x00050051, 0x00000006, 0x0000003d, 0x0000003a,
    0x00000001, 0x00050051, 0x00000006, 0x0000003e, 0x0000003b, 0x00000000,
    0x00050051, 0x00000006, 0x0000003f, 0x0000003b, 0x00000001, 0x00070050,
    0x00000037, 0x00000040, 0x0000003c, 0x0000003d, 0x0000003e, 0x0000003f,
    0x0003003e, 0x00000039, 0x00000040, 0x00050041, 0x00000047, 0x00000048,
    0x00000044, 0x00000046, 0x0004003d, 0x00000007, 0x00000049, 0x00000048,
    0x00050041, 0x00000047, 0x0000004a, 0x00000044, 0x00000046, 0x0004003d,
    0x00000007, 0x0000004b, 0x0000004a, 0x00050051, 0x00000006, 0x0000004c,
    0x00000049, 0x00000000, 0x00050051, 0x00000006, 0x0000004d, 0x00000049,
    0x00000001, 0x00050051, 0x00000006, 0x0000004e, 0x0000004b, 0x00000000,
    0x00050051, 0x00000006, 0x0000004f, 0x0000004b, 0x00000001, 0x00070050,
    0x00000037, 0x00000050, 0x0000004c, 0x0000004d, 0x0000004e, 0x0000004f,
    0x0003003e, 0x00000041, 0x00000050, 0x0004003d, 0x00000037, 0x00000052,
    0x00000039, 0x0004003d, 0x00000037, 0x00000053, 0x00000041, 0x00050088,
    0x00000037, 0x00000054, 0x00000052, 0x00000053, 0x0006000c, 0x00000037,
    0x00000055, 0x00000001, 0x00000008, 0x00000054, 0x0003003e, 0x00000051,
    0x00000055, 0x0004003d, 0x00000037, 0x00000057, 0x00000039, 0x0004003d,
    0x00000037, 0x00000058, 0x00000051, 0x0004003d, 0x00000037, 0x00000059,
    0x00000041, 0x00050085, 0x00000037, 0x0000005a, 0x00000058, 0x00000059,
    0x00050083, 0x00000037, 0x0000005b, 0x00000057, 0x0000005a, 0x0003003e,
    0x00000056, 0x0000005b, 0x0004003d, 0x00000007, 0x0000005d, 0x0000005c,
    0x0004003d, 0x00000007, 0x0000005e, 0x0000005c, 0x00050051, 0x00000006,
    0x0000005f, 0x0000005d, 0x00000000, 0x00050051, 0x00000006, 0x00000060,
    0x0000005d, 0x00000001, 0x00050051, 0x00000006, 0x00000061, 0x0000005e,
    0x00000000, 0x00050051, 0x00000006, 0x00000062, 0x0000005e, 0x00000001,
    0x00070050, 0x00000037, 0x00000063, 0x0000005f, 0x00000060, 0x00000061,
    0x00000062, 0x0004003d, 0x00000037, 0x00000064, 0x00000051, 0x00050081,
    0x00000037, 0x00000065, 0x00000064, 0x00000063, 0x0003003e, 0x00000051,
    0x00000065, 0x0004003d, 0x00000069, 0x0000006c, 0x0000006b, 0x00050041,
    0x0000006f, 0x00000070, 0x00000056, 0x0000006e, 0x0004003d, 0x00000006,
    0x00000071, 0x00000070, 0x0004006e, 0x00000045, 0x00000072, 0x00000071,
    0x00050041, 0x0000006f, 0x00000073, 0x00000051, 0x0000006e, 0x0004003d,
    0x00000006, 0x00000074, 0x00000073, 0x0004006e, 0x00000045, 0x00000075,
    0x00000074, 0x00050050, 0x00000076, 0x00000077, 0x00000072, 0x00000075,
    0x0007005f, 0x00000037, 0x00000078, 0x0000006c, 0x00000077, 0x00000002,
    0x00000046, 0x00050051, 0x00000006, 0x00000079, 0x00000078, 0x00000000,
    0x00050041, 0x0000006f, 0x0000007a, 0x00000068, 0x0000006e, 0x0003003e,
    0x0000007a, 0x00000079, 0x0004003d, 0x00000069, 0x0000007c, 0x0000007b,
    0x00050041, 0x0000006f, 0x0000007e, 0x00000056, 0x0000007d, 0x0004003d,
    0x00000006, 0x0000007f, 0x0000007e, 0x0004006e, 0x00000045, 0x00000080,
    0x0000007f, 0x00050041, 0x0000006f, 0x00000081, 0x00000051, 0x0000007d,
    0x0004003d, 0x00000006, 0x00000082, 0x00000081, 0x0004006e, 0x00000045,
    0x00000083, 0x00000082, 0x00050050, 0x00000076, 0x00000084, 0x00000080,
    0x00000083, 0x0007005f, 0x00000037, 0x00000085, 0x0000007c, 0x00000084,
    0x00000002, 0x00000046, 0x0007004f, 0x00000007, 0x00000086, 0x00000085,
    0x00000085, 0x00000000, 0x00000001, 0x00050041, 0x0000006f, 0x00000087,
    0x00000068, 0x0000007d, 0x00050051, 0x00000006, 0x00000088, 0x00000086,
    0x00000000, 0x0003003e, 0x00000087, 0x00000088, 0x00050041, 0x0000006f,
    0x0000008a, 0x00000068, 0x00000089, 0x00050051, 0x00000006, 0x0000008b,
    0x00000086, 0x00000001, 0x0003003e, 0x0000008a, 0x0000008b, 0x0004003d,
    0x00000069, 0x0000008d, 0x0000006b, 0x00050041, 0x0000006f, 0x0000008e,
    0x00000056, 0x00000089, 0x0004003d, 0x00000006, 0x0000008f, 0x0000008e,
    0x0004006e, 0x00000045, 0x00000090, 0x0000008f, 0x00050041, 0x0000006f,
    0x00000091, 0x00000051, 0x00000089, 0x0004003d, 0x00000006, 0x00000092,
    0x00000091, 0x0004006e, 0x00000045, 0x00000093, 0x00000092, 0x00050050,
    0x00000076, 0x00000094, 0x00000090, 0x00000093, 0x0007005f, 0x00000037,
    0x00000095, 0x0000008d, 0x00000094, 0x00000002, 0x00000046, 0x00050051,
    0x00000006, 0x00000096, 0x00000095, 0x00000000, 0x00050041, 0x0000006f,
    0x00000097, 0x0000008c, 0x0000006e, 0x0003003e, 0x00000097, 0x00000096,
    0x0004003d, 0x00000069, 0x00000098, 0x0000007b, 0x00050041, 0x0000006f,
    0x0000009a, 0x00000056, 0x00000099, 0x0004003d, 0x00000006, 0x0000009b,
    0x0000009a, 0x0004006e, 0x00000045, 0x0000009c, 0x0000009b, 0x00050041,
    0x0000006f, 0x0000009d, 0x00000051, 0x00000099, 0x0004003d, 0x00000006,
    0x0000009e, 0x0000009d, 0x0004006e, 0x00000045, 0x0000009f, 0x0000009e,
    0x00050050, 0x00000076, 0x000000a0, 0x0000009c, 0x0000009f, 0x0007005f,
    0x00000037, 0x000000a1, 0x00000098, 0x000000a0, 0x00000002, 0x00000046,
    0x0007004f, 0x00000007, 0x000000a2, 0x000000a1, 0x000000a1, 0x00000000,
    0x00000001, 0x00050041, 0x0000006f, 0x000000a3, 0x0000008c, 0x0000007d,
    0x00050051, 0x00000006, 0x000000a4, 0x000000a2, 0x00000000, 0x0003003e,
    0x000000a3, 0x000000a4, 0x00050041, 0x0000006f, 0x000000a5, 0x0000008c,
    0x00000089, 0x00050051, 0x00000006, 0x000000a6, 0x000000a2, 0x00000001,
    0x0003003e, 0x000000a5, 0x000000a6, 0x0004003d, 0x00000007, 0x000000ac,
    0x00000011, 0x00050050, 0x00000007, 0x000000ad, 0x000000ab, 0x000000ab,
    0x00050083, 0x00000007, 0x000000ae, 0x000000ad, 0x000000ac, 0x0005008e,
    0x00000007, 0x000000af, 0x000000ae, 0x000000aa, 0x0004006e, 0x00000076,
    0x000000b0, 0x000000af, 0x0007000c, 0x00000007, 0x000000b1, 0x00000001,
    0x00000035, 0x000000a9, 0x000000b0, 0x0008004f, 0x00000066, 0x000000b2,
    0x000000b1, 0x000000b1, 0x00000000, 0x00000001, 0x00000001, 0x0003003e,
    0x000000a7, 0x000000b2, 0x0004003d, 0x00000066, 0x000000b3, 0x000000a7,
    0x0004003d, 0x00000066, 0x000000b4, 0x0000008c, 0x00050085, 0x00000066,
    0x000000b5, 0x000000b4, 0x000000b3, 0x0003003e, 0x0000008c, 0x000000b5,
    0x0004003d, 0x00000066, 0x000000b6, 0x0000008c, 0x0006000c, 0x00000066,
    0x000000b7, 0x00000001, 0x0000000a, 0x000000b6, 0x0003003e, 0x0000008c,
    0x000000b7, 0x0004003d, 0x00000066, 0x000000b9, 0x0000008c, 0x0005008e,
    0x00000066, 0x000000ba, 0x000000b9, 0x000000b8, 0x0003003e, 0x0000008c,
    0x000000ba, 0x0004003d, 0x00000066, 0x000000bb, 0x0000008c, 0x0004003d,
    0x00000066, 0x000000bc, 0x00000068, 0x00050081, 0x00000066, 0x000000bd,
    0x000000bc, 0x000000bb, 0x0003003e, 0x00000068, 0x000000bd, 0x00050041,
    0x0000006f, 0x000000bf, 0x00000068, 0x0000006e, 0x0004003d, 0x00000006,
    0x000000c0, 0x000000bf, 0x00050083, 0x00000006, 0x000000c1, 0x000000c0,
    0x000000be, 0x00050041, 0x0000006f, 0x000000c2, 0x00000068, 0x0000006e,
    0x0003003e, 0x000000c2, 0x000000c1, 0x0004003d, 0x00000066, 0x000000c5,
    0x00000068, 0x0007004f, 0x00000007, 0x000000c6, 0x000000c5, 0x000000c5,
    0x00000001, 0x00000002, 0x00050083, 0x00000007, 0x000000c7, 0x000000c6,
    0x000000c4, 0x00050041, 0x0000006f, 0x000000c8, 0x00000068, 0x0000007d,
    0x00050051, 0x00000006, 0x000000c9, 0x000000c7, 0x00000000, 0x0003003e,
    0x000000c8, 0x000000c9, 0x00050041, 0x0000006f, 0x000000ca, 0x00000068,
    0x00000089, 0x00050051, 0x00000006, 0x000000cb, 0x000000c7, 0x00000001,
    0x0003003e, 0x000000ca, 0x000000cb, 0x0004003d, 0x00000066, 0x000000d9,
    0x00000068, 0x00050091, 0x00000066, 0x000000da, 0x000000d8, 0x000000d9,
    0x00050051, 0x00000006, 0x000000db, 0x000000da, 0x00000000, 0x00050051,
    0x00000006, 0x000000dc, 0x000000da, 0x00000001, 0x00050051, 0x00000006,
    0x000000dd, 0x000000da, 0x00000002, 0x00070050, 0x00000037, 0x000000de,
    0x000000db, 0x000000dc, 0x000000dd, 0x00000025, 0x0003003e, 0x000000cd,
    0x000000de, 0x000100fd, 0x00010038,
};
// clang-format off
/***
MT2TShader.frag source:
// Frag shader for MT2T->AR30 conversion.

#version 450
#extension GL_EXT_samplerless_texture_functions : require

precision mediump float;
precision mediump int;

layout(location = 0) in vec2 intraTileX;
layout(location = 1) in vec2 intraTileY;

layout(location = 2) in flat highp vec2 yOffset;
layout(location = 3) in flat highp vec2 xOffset;

layout(location = 0) out vec4 outColor;

layout( push_constant ) uniform constants {
  layout(offset = 24) highp vec2 planeStrides;
} pushConstants;

layout(binding = 0) uniform texture2D lumaTexture;
layout(binding = 1) uniform texture2D chromaTexture;

const mat3 colorConversion = mat3(1.164, 1.164, 1.164,
          0.0, -0.391, 2.018,
          1.596, -0.813, 0.0);

void main() {
  vec2 blockIdx = floor(intraTileY / 4.0);
  vec2 blockRowIdx = intraTileY - (blockIdx * 4.0);

  // MSB indices need to be adjusted by how many LSB bytes are serialized
  // before the current MSB. Every 64 pixel block starts with 16 bytes of LSB
  // data.
  highp vec2 msbLinearIdx = (floor(intraTileY) * vec2(16, 8)) +
                      floor(intraTileX) + xOffset;
  msbLinearIdx += (blockIdx + 1.0) * vec2(16, 8);

  // Likewise, we need to find the address of our LSB byte. Since each LSB byte
  // encodes the LSBs for a 1x4 mini-tile, we can compute a base address using
  // blockIdx * 16 bytes, and then offset it by the intra tile X coordinate.
  highp vec2 lsbLinearIdx = blockIdx * vec2(80, 40) + xOffset;
  lsbLinearIdx += floor(intraTileX);

  // 0.5 is a floating point issue fudge factor.
  highp vec4 linearIdx = vec4(msbLinearIdx, lsbLinearIdx);

  highp vec4 strides = vec4(pushConstants.planeStrides,
                            pushConstants.planeStrides);
  highp vec4 detiledY = floor(linearIdx / strides);
  highp vec4 detiledX = linearIdx - (detiledY * strides);
  detiledY += vec4(yOffset, yOffset);

  vec3 yuv;
  yuv.r = texelFetch(lumaTexture, ivec2(detiledX.r, detiledY.r), 0).r;
  yuv.gb = texelFetch(chromaTexture, ivec2(detiledX.g, detiledY.g), 0).rg;

  vec3 yuvLsb;
  yuvLsb.r = texelFetch(lumaTexture, ivec2(detiledX.b, detiledY.b), 0).r;
  yuvLsb.gb = texelFetch(chromaTexture, ivec2(detiledX.a, detiledY.a), 0).rg;

  // LSBs are packed into their corresponding byte with the top of the tile
  // packed into the least significant 2 bits of the byte first. So ideally,
  // we would bit shift the LSB byte based on what row within the block the
  // current pixel is in, mask all but the lower two bits, and then shift those
  // bits into where they need to go. But, because both texelFetch and outColor
  // are floating points, this requires integer conversions, which can be quite
  // slow. So instead, we use a multiplication to emulate a left shift, then
  // fract() to emulate discarding the bits that were shifted too high for
  // the register, and then division (multiplication by the reciprocal) to
  // emulate a right shift. The left shift constant should be
  // 2^(2*(3-blockRowIdx)), and the right shift constant should be 2^-8 in
  // order for this to work. The one hitch is that the floating point color
  // values range from 0.0 to 1.0, but baked into our bit shifting trick is
  // the assumption that the colors range from 0.0 to 255.0/256.0 and 0.0 to
  // 1023.0/1024.0 respectively. We can fix this by factoring into our shift
  // multiplication constants the conversion terms 255.0/256.0 and
  // 1024.0/1023.0.
  //
  // Note that the nature of floating point division means we don't emulate
  // discarding bits that are shifted too low, we just keep them as a tiny
  // fractional component. This means this approach is only approximately
  // correct. But, it is guaranteed to be correct within 1/1024, which is
  // all we need for 10-bit color accuracy.
  vec3 shift = ldexp(vec2((255.0/256.0)), ivec2(2.0 * (3.0 - blockRowIdx))).rgg;
  yuvLsb *= shift;
  yuvLsb = fract(yuvLsb);
  yuvLsb *= (1.0 / 256.0 * 1024.0 / 1023.0);
  yuv += yuvLsb;

  yuv.r -= 16.0/255.0;
  yuv.gb -= vec2(0.5, 0.5);
  outColor = vec4(colorConversion * yuv, 1.0);
}
***/
// clang-format on

constexpr uint32_t kMT2TShaderVert[] = {
    0x07230203, 0x00010000, 0x0008000b, 0x0000008e, 0x00000000, 0x00020011,
    0x00000001, 0x0006000b, 0x00000001, 0x4c534c47, 0x6474732e, 0x3035342e,
    0x00000000, 0x0003000e, 0x00000000, 0x00000001, 0x000b000f, 0x00000000,
    0x00000004, 0x6e69616d, 0x00000000, 0x0000000b, 0x0000005b, 0x00000069,
    0x00000070, 0x00000088, 0x0000008b, 0x00030003, 0x00000002, 0x000001c2,
    0x00040005, 0x00000004, 0x6e69616d, 0x00000000, 0x00040005, 0x00000008,
    0x656c6974, 0x00786449, 0x00060005, 0x0000000b, 0x565f6c67, 0x65747265,
    0x646e4978, 0x00007865, 0x00060005, 0x00000011, 0x63657270, 0x54657369,
    0x49656c69, 0x00007864, 0x00050005, 0x00000018, 0x656c6974, 0x74726556,
    0x00786449, 0x00050005, 0x00000022, 0x656c6974, 0x726f6f43, 0x00007364,
    0x00050005, 0x00000024, 0x736e6f63, 0x746e6174, 0x00000073, 0x00060006,
    0x00000024, 0x00000000, 0x656c6974, 0x72655073, 0x00776f52, 0x00050006,
    0x00000024, 0x00000001, 0x736d6964, 0x00000000, 0x00070006, 0x00000024,
    0x00000002, 0x6e616c70, 0x72745365, 0x73656469, 0x00000000, 0x00060005,
    0x00000026, 0x68737570, 0x736e6f43, 0x746e6174, 0x00000073, 0x00030005,
    0x00000039, 0x00736f70, 0x00050005, 0x00000048, 0x65646e69, 0x6c626178,
    0x00000065, 0x00060005, 0x00000059, 0x505f6c67, 0x65567265, 0x78657472,
    0x00000000, 0x00060006, 0x00000059, 0x00000000, 0x505f6c67, 0x7469736f,
    0x006e6f69, 0x00070006, 0x00000059, 0x00000001, 0x505f6c67, 0x746e696f,
    0x657a6953, 0x00000000, 0x00070006, 0x00000059, 0x00000002, 0x435f6c67,
    0x4470696c, 0x61747369, 0x0065636e, 0x00070006, 0x00000059, 0x00000003,
    0x435f6c67, 0x446c6c75, 0x61747369, 0x0065636e, 0x00030005, 0x0000005b,
    0x00000000, 0x00050005, 0x00000062, 0x656e696c, 0x61427261, 0x00006573,
    0x00040005, 0x00000069, 0x66664f79, 0x00746573, 0x00040005, 0x00000070,
    0x66664f78, 0x00746573, 0x00060005, 0x00000078, 0x72746e69, 0x6c695461,
    0x6f6f4365, 0x00006472, 0x00050005, 0x0000007a, 0x65646e69, 0x6c626178,
    0x00000065, 0x00050005, 0x0000007e, 0x65646e69, 0x6c626178, 0x00000065,
    0x00050005, 0x00000088, 0x72746e69, 0x6c695461, 0x00005865, 0x00050005,
    0x0000008b, 0x72746e69, 0x6c695461, 0x00005965, 0x00040047, 0x0000000b,
    0x0000000b, 0x0000002a, 0x00050048, 0x00000024, 0x00000000, 0x00000023,
    0x00000000, 0x00050048, 0x00000024, 0x00000001, 0x00000023, 0x00000008,
    0x00050048, 0x00000024, 0x00000002, 0x00000023, 0x00000010, 0x00030047,
    0x00000024, 0x00000002, 0x00050048, 0x00000059, 0x00000000, 0x0000000b,
    0x00000000, 0x00050048, 0x00000059, 0x00000001, 0x0000000b, 0x00000001,
    0x00050048, 0x00000059, 0x00000002, 0x0000000b, 0x00000003, 0x00050048,
    0x00000059, 0x00000003, 0x0000000b, 0x00000004, 0x00030047, 0x00000059,
    0x00000002, 0x00030047, 0x00000069, 0x0000000e, 0x00040047, 0x00000069,
    0x0000001e, 0x00000002, 0x00030047, 0x00000070, 0x0000000e, 0x00040047,
    0x00000070, 0x0000001e, 0x00000003, 0x00030047, 0x00000088, 0x00000000,
    0x00040047, 0x00000088, 0x0000001e, 0x00000000, 0x00030047, 0x0000008b,
    0x00000000, 0x00040047, 0x0000008b, 0x0000001e, 0x00000001, 0x00020013,
    0x00000002, 0x00030021, 0x00000003, 0x00000002, 0x00030016, 0x00000006,
    0x00000020, 0x00040020, 0x00000007, 0x00000007, 0x00000006, 0x00040015,
    0x00000009, 0x00000020, 0x00000001, 0x00040020, 0x0000000a, 0x00000001,
    0x00000009, 0x0004003b, 0x0000000a, 0x0000000b, 0x00000001, 0x0004002b,
    0x00000006, 0x0000000e, 0x3e2aaaab, 0x0004002b, 0x00000006, 0x00000013,
    0x3dcccccd, 0x00040015, 0x00000016, 0x00000020, 0x00000000, 0x00040020,
    0x00000017, 0x00000007, 0x00000016, 0x0004002b, 0x00000006, 0x0000001c,
    0x40c00000, 0x00040017, 0x00000020, 0x00000006, 0x00000002, 0x00040020,
    0x00000021, 0x00000007, 0x00000020, 0x0005001e, 0x00000024, 0x00000020,
    0x00000020, 0x00000020, 0x00040020, 0x00000025, 0x00000009, 0x00000024,
    0x0004003b, 0x00000025, 0x00000026, 0x00000009, 0x0004002b, 0x00000009,
    0x00000027, 0x00000000, 0x0004002b, 0x00000016, 0x00000028, 0x00000000,
    0x00040020, 0x00000029, 0x00000009, 0x00000006, 0x0004002b, 0x00000016,
    0x0000002e, 0x00000001, 0x0004002b, 0x00000006, 0x0000003b, 0x41800000,
    0x0004002b, 0x00000006, 0x0000003c, 0x42000000, 0x0005002c, 0x00000020,
    0x0000003d, 0x0000003b, 0x0000003c, 0x0004002b, 0x00000016, 0x0000003f,
    0x00000006, 0x0004001c, 0x00000040, 0x00000020, 0x0000003f, 0x0004002b,
    0x00000006, 0x00000041, 0x00000000, 0x0005002c, 0x00000020, 0x00000042,
    0x0000003b, 0x00000041, 0x0005002c, 0x00000020, 0x00000043, 0x00000041,
    0x00000041, 0x0005002c, 0x00000020, 0x00000044, 0x00000041, 0x0000003c,
    0x0009002c, 0x00000040, 0x00000045, 0x00000042, 0x0000003d, 0x00000043,
    0x00000043, 0x0000003d, 0x00000044, 0x00040020, 0x00000047, 0x00000007,
    0x00000040, 0x0004002b, 0x00000006, 0x0000004d, 0x40000000, 0x0004002b,
    0x00000009, 0x0000004f, 0x00000001, 0x00040020, 0x00000050, 0x00000009,
    0x00000020, 0x0004002b, 0x00000006, 0x00000054, 0x3f800000, 0x0005002c,
    0x00000020, 0x00000055, 0x00000054, 0x00000054, 0x00040017, 0x00000057,
    0x00000006, 0x00000004, 0x0004001c, 0x00000058, 0x00000006, 0x0000002e,
    0x0006001e, 0x00000059, 0x00000057, 0x00000006, 0x00000058, 0x00000058,
    0x00040020, 0x0000005a, 0x00000003, 0x00000059, 0x0004003b, 0x0000005a,
    0x0000005b, 0x00000003, 0x00040020, 0x00000060, 0x00000003, 0x00000057,
    0x0004002b, 0x00000006, 0x00000064, 0x44200000, 0x0004002b, 0x00000006,
    0x00000065, 0x43200000, 0x0005002c, 0x00000020, 0x00000066, 0x00000064,
    0x00000065, 0x00040020, 0x00000068, 0x00000003, 0x00000020, 0x0004003b,
    0x00000068, 0x00000069, 0x00000003, 0x0004002b, 0x00000009, 0x0000006b,
    0x00000002, 0x0004003b, 0x00000068, 0x00000070, 0x00000003, 0x00040020,
    0x00000077, 0x00000007, 0x00000057, 0x0004003b, 0x00000068, 0x00000088,
    0x00000003, 0x0004003b, 0x00000068, 0x0000008b, 0x00000003, 0x00050036,
    0x00000002, 0x00000004, 0x00000000, 0x00000003, 0x000200f8, 0x00000005,
    0x0004003b, 0x00000007, 0x00000008, 0x00000007, 0x0004003b, 0x00000007,
    0x00000011, 0x00000007, 0x0004003b, 0x00000017, 0x00000018, 0x00000007,
    0x0004003b, 0x00000021, 0x00000022, 0x00000007, 0x0004003b, 0x00000021,
    0x00000039, 0x00000007, 0x0004003b, 0x00000047, 0x00000048, 0x00000007,
    0x0004003b, 0x00000021, 0x00000062, 0x00000007, 0x0004003b, 0x00000077,
    0x00000078, 0x00000007, 0x0004003b, 0x00000047, 0x0000007a, 0x00000007,
    0x0004003b, 0x00000047, 0x0000007e, 0x00000007, 0x0004003d, 0x00000009,
    0x0000000c, 0x0000000b, 0x0004006f, 0x00000006, 0x0000000d, 0x0000000c,
    0x00050085, 0x00000006, 0x0000000f, 0x0000000d, 0x0000000e, 0x0006000c,
    0x00000006, 0x00000010, 0x00000001, 0x00000008, 0x0000000f, 0x0003003e,
    0x00000008, 0x00000010, 0x0004003d, 0x00000006, 0x00000012, 0x00000008,
    0x0003003e, 0x00000011, 0x00000012, 0x0004003d, 0x00000006, 0x00000014,
    0x00000008, 0x00050081, 0x00000006, 0x00000015, 0x00000014, 0x00000013,
    0x0003003e, 0x00000008, 0x00000015, 0x0004003d, 0x00000009, 0x00000019,
    0x0000000b, 0x0004007c, 0x00000016, 0x0000001a, 0x00000019, 0x0004003d,
    0x00000006, 0x0000001b, 0x00000008, 0x00050085, 0x00000006, 0x0000001d,
    0x0000001b, 0x0000001c, 0x0004006d, 0x00000016, 0x0000001e, 0x0000001d,
    0x00050082, 0x00000016, 0x0000001f, 0x0000001a, 0x0000001e, 0x0003003e,
    0x00000018, 0x0000001f, 0x0004003d, 0x00000006, 0x00000023, 0x00000008,
    0x00060041, 0x00000029, 0x0000002a, 0x00000026, 0x00000027, 0x00000028,
    0x0004003d, 0x00000006, 0x0000002b, 0x0000002a, 0x00050088, 0x00000006,
    0x0000002c, 0x00000023, 0x0000002b, 0x0006000c, 0x00000006, 0x0000002d,
    0x00000001, 0x00000008, 0x0000002c, 0x00050041, 0x00000007, 0x0000002f,
    0x00000022, 0x0000002e, 0x0003003e, 0x0000002f, 0x0000002d, 0x0004003d,
    0x00000006, 0x00000030, 0x00000008, 0x00050041, 0x00000007, 0x00000031,
    0x00000022, 0x0000002e, 0x0004003d, 0x00000006, 0x00000032, 0x00000031,
    0x00060041, 0x00000029, 0x00000033, 0x00000026, 0x00000027, 0x00000028,
    0x0004003d, 0x00000006, 0x00000034, 0x00000033, 0x00050085, 0x00000006,
    0x00000035, 0x00000032, 0x00000034, 0x00050083, 0x00000006, 0x00000036,
    0x00000030, 0x00000035, 0x0006000c, 0x00000006, 0x00000037, 0x00000001,
    0x00000008, 0x00000036, 0x00050041, 0x00000007, 0x00000038, 0x00000022,
    0x00000028, 0x0003003e, 0x00000038, 0x00000037, 0x0004003d, 0x00000020,
    0x0000003a, 0x00000022, 0x00050085, 0x00000020, 0x0000003e, 0x0000003a,
    0x0000003d, 0x0004003d, 0x00000016, 0x00000046, 0x00000018, 0x0003003e,
    0x00000048, 0x00000045, 0x00050041, 0x00000021, 0x00000049, 0x00000048,
    0x00000046, 0x0004003d, 0x00000020, 0x0000004a, 0x00000049, 0x00050081,
    0x00000020, 0x0000004b, 0x0000003e, 0x0000004a, 0x0003003e, 0x00000039,
    0x0000004b, 0x0004003d, 0x00000020, 0x0000004c, 0x00000039, 0x0005008e,
    0x00000020, 0x0000004e, 0x0000004c, 0x0000004d, 0x00050041, 0x00000050,
    0x00000051, 0x00000026, 0x0000004f, 0x0004003d, 0x00000020, 0x00000052,
    0x00000051, 0x00050088, 0x00000020, 0x00000053, 0x0000004e, 0x00000052,
    0x00050083, 0x00000020, 0x00000056, 0x00000053, 0x00000055, 0x0003003e,
    0x00000039, 0x00000056, 0x0004003d, 0x00000020, 0x0000005c, 0x00000039,
    0x00050051, 0x00000006, 0x0000005d, 0x0000005c, 0x00000000, 0x00050051,
    0x00000006, 0x0000005e, 0x0000005c, 0x00000001, 0x00070050, 0x00000057,
    0x0000005f, 0x0000005d, 0x0000005e, 0x00000041, 0x00000054, 0x00050041,
    0x00000060, 0x00000061, 0x0000005b, 0x00000027, 0x0003003e, 0x00000061,
    0x0000005f, 0x0004003d, 0x00000006, 0x00000063, 0x00000011, 0x0005008e,
    0x00000020, 0x00000067, 0x00000066, 0x00000063, 0x0003003e, 0x00000062,
    0x00000067, 0x0004003d, 0x00000020, 0x0000006a, 0x00000062, 0x00050041,
    0x00000050, 0x0000006c, 0x00000026, 0x0000006b, 0x0004003d, 0x00000020,
    0x0000006d, 0x0000006c, 0x00050088, 0x00000020, 0x0000006e, 0x0000006a,
    0x0000006d, 0x0006000c, 0x00000020, 0x0000006f, 0x00000001, 0x00000008,
    0x0000006e, 0x0003003e, 0x00000069, 0x0000006f, 0x0004003d, 0x00000020,
    0x00000071, 0x00000062, 0x0004003d, 0x00000020, 0x00000072, 0x00000069,
    0x00050041, 0x00000050, 0x00000073, 0x00000026, 0x0000006b, 0x0004003d,
    0x00000020, 0x00000074, 0x00000073, 0x00050085, 0x00000020, 0x00000075,
    0x00000072, 0x00000074, 0x00050083, 0x00000020, 0x00000076, 0x00000071,
    0x00000075, 0x0003003e, 0x00000070, 0x00000076, 0x0004003d, 0x00000016,
    0x00000079, 0x00000018, 0x0003003e, 0x0000007a, 0x00000045, 0x00050041,
    0x00000021, 0x0000007b, 0x0000007a, 0x00000079, 0x0004003d, 0x00000020,
    0x0000007c, 0x0000007b, 0x0004003d, 0x00000016, 0x0000007d, 0x00000018,
    0x0003003e, 0x0000007e, 0x00000045, 0x00050041, 0x00000021, 0x0000007f,
    0x0000007e, 0x0000007d, 0x0004003d, 0x00000020, 0x00000080, 0x0000007f,
    0x00050050, 0x00000020, 0x00000081, 0x0000004d, 0x0000004d, 0x00050088,
    0x00000020, 0x00000082, 0x00000080, 0x00000081, 0x00050051, 0x00000006,
    0x00000083, 0x0000007c, 0x00000000, 0x00050051, 0x00000006, 0x00000084,
    0x0000007c, 0x00000001, 0x00050051, 0x00000006, 0x00000085, 0x00000082,
    0x00000000, 0x00050051, 0x00000006, 0x00000086, 0x00000082, 0x00000001,
    0x00070050, 0x00000057, 0x00000087, 0x00000083, 0x00000084, 0x00000085,
    0x00000086, 0x0003003e, 0x00000078, 0x00000087, 0x0004003d, 0x00000057,
    0x00000089, 0x00000078, 0x0007004f, 0x00000020, 0x0000008a, 0x00000089,
    0x00000089, 0x00000000, 0x00000002, 0x0003003e, 0x00000088, 0x0000008a,
    0x0004003d, 0x00000057, 0x0000008c, 0x00000078, 0x0007004f, 0x00000020,
    0x0000008d, 0x0000008c, 0x0000008c, 0x00000001, 0x00000003, 0x0003003e,
    0x0000008b, 0x0000008d, 0x000100fd, 0x00010038,
};
// clang-format off
/***
MT2TShader.vert source:
// Vertex shader for MT2T->AR30 conversion.
// This shader is very similar to its MM21 counterpart, with the important
// difference being that the linear base address needs to take into account the
// packed LSB data, so we multiply it by 10/8=5/4.

#version 450

precision highp float;
precision highp int;

// We can actually exploit the rasterizer to figure out the intra tile
// coordinates for us.
layout(location = 0) out mediump vec2 intraTileX;
layout(location = 1) out mediump vec2 intraTileY;

layout(location = 2) flat out vec2 yOffset;
layout(location = 3) flat out vec2 xOffset;

layout( push_constant ) uniform constants {
  // Vulkan push constants have interesting alignment rules, so we use a vec2
  // when we could get away with a float just to make things simple.
  vec2 tilesPerRow;
  vec2 dims;
  vec2 planeStrides;
} pushConstants;

const vec2 kLumaTileDims = vec2(16.0, 32.0);
const vec2 kTileSize = vec2(640.0, 160.0);

const vec2 intraTileCoords[6] = vec2[6](
  vec2(16.0, 0.0),
  vec2(16.0, 32.0),
  vec2(0.0, 0.0),
  vec2(0.0, 0.0),
  vec2(16.0, 32.0),
  vec2(0.0, 32.0)
);

void main() {
  // We really want something like:
  // int tileIdx = gl_VertexIndex / 6;
  // int tileVertIdx = gl_VertexIndex % 6;
  // But integer division and modulo are *very* expensive on mobile GPUs, so
  // we use floating point multiplication, subtraction, and flooring to
  // approximate these operations.
  // 0.1 is a fudge factor to counteract floating point rounding errors.
  // Note that we multiply this value by 6, so using 0.5 like we do in the frag
  // shader isn't appropriate because that will genuinely change the integer
  // answer.
  float tileIdx = floor(float(gl_VertexIndex) * (1.0 / 6.0));
  float preciseTileIdx = tileIdx;
  tileIdx += 0.1;
  uint tileVertIdx = gl_VertexIndex - uint(tileIdx * 6.0);
  vec2 tileCoords;
  tileCoords.g = floor(tileIdx / pushConstants.tilesPerRow.x);
  tileCoords.r = floor(tileIdx - (tileCoords.g * pushConstants.tilesPerRow.x));
  vec2 pos = tileCoords * kLumaTileDims + intraTileCoords[tileVertIdx];
  pos = pos * 2.0 / pushConstants.dims - vec2(1.0, 1.0);
  gl_Position = vec4(pos, 0.0, 1.0);

  // Compute the base address for the whole tile.
  vec2 linearBase = preciseTileIdx * kTileSize;
  yOffset = floor(linearBase / pushConstants.planeStrides);
  xOffset = linearBase - (yOffset * pushConstants.planeStrides);

  vec4 intraTileCoord = vec4(intraTileCoords[tileVertIdx],
  			     intraTileCoords[tileVertIdx] / 2.0);
  intraTileX = intraTileCoord.rb;
  intraTileY = intraTileCoord.ga;
}
***/
// clang-format on

}  // namespace

#endif
