export const description = `
Test the result of reading textures through texture views with various options.

All x= every possible view read method: {
  - {unfiltered, filtered (if valid), comparison (if valid)} sampling
  - storage read {vertex, fragment, compute}
  - no-op render pass that loads and then stores
  - depth comparison
  - stencil comparison
}
TODO: Write helper for this if not already available (see resource_init, buffer_sync_test for related code).
`;

import { makeTestGroup } from '../../../../common/framework/test_group.js';
import { GPUTest } from '../../../gpu_test.js';

export const g = makeTestGroup(GPUTest);

g.test('format')
  .desc(
    `Views of every allowed format.

- x= every texture format
- x= every valid view format (including same)
- x= sampleCount {1, 4} if valid
- x= every possible view read method (see above)
`
  )
  .unimplemented();

g.test('dimension')
  .desc(
    `Views of every allowed dimension.

- x= a representative subset of formats
- x= {every texture dimension} x {every valid view dimension}
  (per gpuweb#79 no dimension-count reinterpretations, like 2d-array <-> 3d, are possible)
- x= sampleCount {1, 4} if valid
- x= every possible view read method (see above)
`
  )
  .unimplemented();

g.test('aspect')
  .desc(
    `Views of every allowed aspect of depth/stencil textures.

- x= every depth/stencil format
- x= {"all", "stencil-only", "depth-only"} where valid for the format
- x= sampleCount {1, 4} if valid
- x= every possible view read method (see above)
`
  )
  .unimplemented();
