/*
 * Responses Test
 *
 * This specification is intended for testing purposes. It demonstrates different response media types.
 *
 * API version: 1.0.0
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package openapi

import (
	"net/http"

	"github.com/gin-gonic/gin"
)

// Route is the information for every URI.
type Route struct {
	// Name is the name of this Route.
	Name string
	// Method is the string for the HTTP method. ex) GET, POST etc..
	Method string
	// Pattern is the pattern of the URI.
	Pattern string
	// HandlerFunc is the handler function of this route.
	HandlerFunc gin.HandlerFunc
}

// NewRouter returns a new router.
func NewRouter(handleFunctions ApiHandleFunctions) *gin.Engine {
	return NewRouterWithGinEngine(gin.Default(), handleFunctions)
}

// NewRouter add routes to existing gin engine.
func NewRouterWithGinEngine(router *gin.Engine, handleFunctions ApiHandleFunctions) *gin.Engine {
	for _, route := range getRoutes(handleFunctions) {
		if route.HandlerFunc == nil {
			route.HandlerFunc = DefaultHandleFunc
		}
		switch route.Method {
		case http.MethodGet:
			router.GET(route.Pattern, route.HandlerFunc)
		case http.MethodPost:
			router.POST(route.Pattern, route.HandlerFunc)
		case http.MethodPut:
			router.PUT(route.Pattern, route.HandlerFunc)
		case http.MethodPatch:
			router.PATCH(route.Pattern, route.HandlerFunc)
		case http.MethodDelete:
			router.DELETE(route.Pattern, route.HandlerFunc)
		}
	}

	return router
}

// Default handler for not yet implemented routes
func DefaultHandleFunc(c *gin.Context) {
	c.String(http.StatusNotImplemented, "501 not implemented")
}

type ApiHandleFunctions struct {

	// Routes for the TestAPI part of the API
	TestAPI TestAPI
}

func getRoutes(handleFunctions ApiHandleFunctions) []Route {
	return []Route{
		{
			"ApplicationJsonEncodedObjectResponse",
			http.MethodGet,
			"/v2/response/application/json/object",
			handleFunctions.TestAPI.ApplicationJsonEncodedObjectResponse,
		},
		{
			"ApplicationJsonStringResponse",
			http.MethodGet,
			"/v2/response/application/json/string",
			handleFunctions.TestAPI.ApplicationJsonStringResponse,
		},
		{
			"ApplicationJsonArrayResponse",
			http.MethodGet,
			"/v2/response/application/json/array",
			handleFunctions.TestAPI.ApplicationJsonArrayResponse,
		},
		{
			"ApplicationJsonMapResponse",
			http.MethodGet,
			"/v2/response/application/json/map",
			handleFunctions.TestAPI.ApplicationJsonMapResponse,
		},
		{
			"TextPlainStringResponse",
			http.MethodGet,
			"/v2/response/text/plain/string",
			handleFunctions.TestAPI.TextPlainStringResponse,
		},
		{
			"ApplicationPdfInlineResponse",
			http.MethodGet,
			"/v2/response/application/pdf/inline/:fileId",
			handleFunctions.TestAPI.ApplicationPdfInlineResponse,
		},
		{
			"ApplicationPdfSaveResponse",
			http.MethodGet,
			"/v2/response/application/pdf/save/:fileId",
			handleFunctions.TestAPI.ApplicationPdfSaveResponse,
		},
		{
			"ApplicationEncodedPdfSaveResponse",
			http.MethodGet,
			"/v2/response/application/pdf/save/encoded/:fileId",
			handleFunctions.TestAPI.ApplicationEncodedPdfSaveResponse,
		},
		{
			"InlineImageResponse",
			http.MethodGet,
			"/v2/response/image/inline/:imageId",
			handleFunctions.TestAPI.InlineImageResponse,
		},
		{
			"SaveImageResponse",
			http.MethodGet,
			"/v2/response/image/save/:imageId",
			handleFunctions.TestAPI.SaveImageResponse,
		},
		{
			"ApplicationOctetStreamResponse",
			http.MethodGet,
			"/v2/response/application/octet-stream/:fileId",
			handleFunctions.TestAPI.ApplicationOctetStreamResponse,
		},
		{
			"EmptyResponse",
			http.MethodGet,
			"/v2/response/empty",
			handleFunctions.TestAPI.EmptyResponse,
		},
	}
}
