// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

pragma ComponentBehavior: Bound

import QtQuick
import QtQuick3D

ToyCustom {
    id: root

    bodyRigged {
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
    }
    toyNodeModel {
        source: "meshes/skin_sloth.mesh"
        skin: skin
        materials: duoToneSloth
    }
    universalArmature {
        x: -0.0012664840323850513
        y: 0.011565704829990864
        z: 0.004971697460860014
        rotation: Qt.quaternion(0.997986, -0.0290157, -0.0246449, 0.0507453)
    }
    universalRigged {
        x: -1.0186340659856796e-10
        y: 1.2951204553246498e-09
        z: 3.41970007866621e-10
        rotation: Qt.quaternion(0.707107, 5.39183e-08, 0.707107, -5.49885e-08)
    }
    universalRiggedPelvis {
        x: -5.922629497945309e-09
        y: -0.010523475706577301
        z: -0.1347365826368332
        rotation: Qt.quaternion(0.707106, -0.00123974, 0.707106, -0.00122761)
    }
    universalRiggedLThigh {
        x: -0.012414590455591679
        y: 0.00680693332105875
        z: 0.06434483826160431
        rotation: Qt.quaternion(-0.0164644, -0.0243565, 0.999568, -0.00033351)
    }
    universalRiggedLCalf {
        x: 0.05875241756439209
        y: -4.958128556609154e-07
        z: 3.4319236874580383e-07
        rotation: Qt.quaternion(0.989259, 0.0154112, -0.0247383, -0.143236)
    }
    universalRiggedLFoot {
        x: 0.05307980626821518
        y: -1.7031561583280563e-07
        z: 3.070454113185406e-08
        rotation: Qt.quaternion(0.674376, -0.00462269, 0.0147114, 0.738227)
    }
    universalRiggedRThigh {
        x: -0.012414581142365932
        y: 0.006806946359574795
        z: -0.06434483826160431
        rotation: Qt.quaternion(0.0164537, -0.024393, 0.999567, 0.000334035)
    }
    universalRiggedRCalf {
        x: 0.05875237286090851
        y: -4.461035132408142e-07
        z: -3.611203283071518e-07
        rotation: Qt.quaternion(0.98929, -0.0154181, 0.024642, -0.143043)
    }
    universalRiggedRFoot {
        x: 0.05307982489466667
        y: 1.555308699607849e-07
        z: -1.2078089639544487e-08
        rotation: Qt.quaternion(0.674507, 0.00466852, -0.0146408, 0.738109)
    }
    universalRiggedSpine1 {
        x: 0.006677897181361914
        y: -0.0005109388148412108
        z: -2.1245796233415604e-09
        rotation: Qt.quaternion(0.99049, -1.53498e-07, -2.71501e-08, 0.137586)
    }
    universalRiggedSpine2 {
        x: 0.09655272960662842
        y: 2.60770320892334e-08
        z: -1.0433723218739033e-08
        rotation: Qt.quaternion(0.985061, 1.21159e-06, -1.42053e-07, -0.172207)
    }
    universalRiggedSpine3 {
        x: 0.08225015550851822
        y: -3.1548552215099335e-08
        z: -1.0419171303510666e-08
        rotation: Qt.quaternion(0.997682, -1.23839e-06, -1.21353e-08, -0.068047)
    }
    universalRiggedRibcage {
        x: 0.08838807046413422
        y: -4.6566128730773926e-08
        z: 1.9266735762357712e-08
        rotation: Qt.quaternion(0.994504, 1.69735e-07, -3.02714e-07, 0.104698)
    }
    universalRiggedLCollarbone {
        x: -0.00253615016117692
        y: 0.0148304533213377
        z: 0.004399856552481651
        rotation: Qt.quaternion(0.671309, 0.00376807, -0.730239, -0.126811)
    }
    universalRiggedLUpperarm {
        x: 0.14280031621456146
        y: -7.450580596923828e-08
        z: -7.613562047481537e-08
        rotation: Qt.quaternion(0.941044, 0.206179, -0.240757, 0.118159)
    }
    universalRiggedLForearm {
        x: 0.10050942748785019
        y: -1.6065314412117004e-08
        z: 7.89295881986618e-08
        rotation: Qt.quaternion(0.995913, 0.0540124, -0.0201404, 0.0695285)
    }
    universalRiggedLPalm {
        x: 0.11251094192266464
        y: -1.4901161193847656e-08
        z: -1.9837170839309692e-07
        rotation: Qt.quaternion(0.693424, -0.718796, -0.0476581, -0.0149871)
    }
    accessoryHolderHandLeft {
        x: -0.008436787873506546
        y: -0.2557981610298157
        z: -0.12775936722755432
        rotation: Qt.quaternion(0.103318, 0.429085, 0.865849, -0.235621)
    }
    modelMetalBraceletLeft {
        x: 0.158
        y: 0.048
        z: -0.24153
        rotation: Qt.quaternion(0.707972, 0.0986974, 0.0879475, 0.693758)
    }
    universalRiggedRCollarbone {
        x: -0.002536127809435129
        y: 0.014830454252660275
        z: -0.004399869590997696
        rotation: Qt.quaternion(0.671308, -0.00376816, 0.73024, -0.126811)
    }
    universalRiggedRUpperarm {
        x: 0.14280030131340027
        y: -1.862645149230957e-08
        z: -6.52798917144537e-08
        rotation: Qt.quaternion(0.941044, -0.206179, 0.240757, 0.118159)
    }
    universalRiggedRForearm {
        x: 0.10050933808088303
        y: 1.4901161193847656e-08
        z: 1.7229467630386353e-08
        rotation: Qt.quaternion(0.995913, -0.0540127, 0.0201401, 0.0695281)
    }
    universalRiggedRPalm {
        x: 0.11251107603311539
        y: 3.725290298461914e-08
        z: -3.67872416973114e-08
        rotation: Qt.quaternion(0.693424, 0.718796, 0.0476583, -0.0149872)
    }
    accessoryHolderHandRight {
        x: -0.20556066930294037
        y: -0.35123521089553833
        z: 0.061212554574012756
        rotation: Qt.quaternion(0.568684, 0.349602, 0.211173, -0.713991)
        scale.x: 0.999999
        scale.y: 1
        scale.z: 0.999999
    }
    modelMetalBraceletRight {
        x: -0.19480888545513153
        y: 0.04038756340742111
        z: -0.3259944021701813
        rotation: Qt.quaternion(-0.0889828, 0.909527, -0.323377, 0.2455)
    }
    universalRiggedNeck {
        x: 0.0001160837709903717
        y: -0.0005109547637403011
        z: -9.851646609604359e-09
        rotation: Qt.quaternion(0.999372, -4.15573e-07, 2.12591e-07, -0.0354308)
    }
    universalRiggedHead {
        x: 0.12408043444156647
        y: 4.0512531995773315e-08
        z: -3.768946044147015e-09
        rotation: Qt.quaternion(0.999372, 4.27221e-07, -2.21328e-07, 0.035431)
    }
    universalRiggedEar_L {
        x: 0.4717787802219391
        y: -1.1548399925231934e-07
        z: 0.17517535388469696
        rotation: Qt.quaternion(0.984193, -0.0126966, -0.157936, 0.0791197)
    }
    universalRiggedEar_R {
        x: 0.4717785120010376
        y: -1.1734664440155029e-07
        z: -0.17517589032649994
        rotation: Qt.quaternion(0.984193, 0.0126967, 0.157936, 0.0791197)
    }
    accessoryHolderEyes {
        x: 0.189010888338089
        y: 0.3424994647502899
        z: -0.004048074129968882
        rotation: Qt.quaternion(0.718825, -0.136648, -0.681451, -0.0155715)
    }
    modelAnnoyedEyes {
        x: -0.00034831929951906204
        y: -0.025516895577311516
        z: -0.012772896327078342
        rotation: Qt.quaternion(0.98654, 0.14128, -0.0284962, -0.0772424)
        scale.x: 0.0396735
        scale.y: 0.0396734
        scale.z: 0.0396735
    }
    modelAnnoyedEyebrows {
        x: 0.0007751286029815674
        y: -2.0784425735473633
        z: -4.479308605194092
        scale.x: 6.43903
        scale.y: 6.43903
        scale.z: 6.43903
    }
    modelAnnoyedMouth {
        position: Qt.vector3d(2.75, -2, 2.5)
        scale.x: 6.43903
        scale.y: 6.43903
        scale.z: 6.43903
    }
    modelConfusedEyes {
        x: 0.0028726072050631046
        y: 0.00681449007242918
        z: -0.03231813758611679
        rotation: Qt.quaternion(0.987609, 0.137125, -0.0128826, -0.0752226)
        scale.x: 0.344056
        scale.y: 0.344056
        scale.z: 0.344056
    }
    accessoryConfusedMouth {
        position: Qt.vector3d(0.05, -0.06, 0.64)
        rotation: Qt.quaternion(0.984932, 0.28, -0.0472723, 0.0225496)
        scale: Qt.vector3d(0.6, 1, 0.4)
    }
    modelCuteEyes {
        x: 0.0026265867054462433
        y: -0.003271660301834345
        z: -0.0378231480717659
        rotation: Qt.quaternion(0.985714, 0.144845, -0.0113874, -0.0851951)
        scale.x: 0.0396735
        scale.y: 0.0396734
        scale.z: 0.0396735
    }
    modelCuteEyebrows {
        x: 0.1717393398284912
        y: -3.7152318954467773
        z: -5.253484725952148
        rotation: Qt.quaternion(0.999837, 6.87772e-05, -0.0180035, 0.00130179)
        scale.x: 6.43903
        scale.y: 6.43903
        scale.z: 6.43903
    }
    modelCuteMouth {
        position: Qt.vector3d(2.75, -2.1, 3)
        scale: Qt.vector3d(6.43903, 6.43903, 6.43903)
    }
    modelPowerpuffEyes {
        x: -0.004002168774604797
        y: -0.043277718126773834
        z: -0.04446713626384735
        rotation: Qt.quaternion(0.776248, -0.624027, 0.0418585, -0.0792301)
    }
    modelPowerpuffEyebrows {
        y: 0.1913602352142334
        z: -0.0812026709318161
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.255459
        scale.y: 0.255459
        scale.z: 0.255459
    }
    modelPowerpuffMouth {
        position: Qt.vector3d(0, -0.25, 0)
        rotation: Qt.quaternion(0.509354, 0.860515, 0.00848538, 0.00068334)
        scale: Qt.vector3d(0.022, 0.022, 0.022)
    }
    modelSmallEyes {
        x: 0.011692008003592491
        y: 0.008686021901667118
        z: -0.0014777095057070255
        rotation: Qt.quaternion(0.710811, -0.696372, 0.0550266, -0.0823777)
        scale: Qt.vector3d(1.43903, 1.43903, 1.43903)
    }
    modelSmallEyebrows {
        x: -0.003959750756621361
        y: 0.16850993037223816
        z: -0.08624144643545151
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.255459
        scale.y: 0.255458
        scale.z: 0.255459
    }
    modelSmallMouth {
        position: Qt.vector3d(0, -0.13, -0.065)
        eulerRotation.z: 0.50494
        eulerRotation.y: -1.40204
        eulerRotation.x: -45.97882
        scale: Qt.vector3d(0.02, 0.02, 0.02)
    }
    modelSurprisedEyes {
        x: 0.0008958335965871811
        y: -0.022206073626875877
        z: -0.06325387954711914
        rotation: Qt.quaternion(0.995711, 0.0301848, -0.0157461, -0.086022)
        scale.x: 0.0396735
        scale.y: 0.0396734
        scale.z: 0.0396735
    }
    modelSurprisedEyebrows {
        y: -2.889866828918457
        z: -6.205254554748535
        scale.x: 6.43903
        scale.y: 6.43903
        scale.z: 6.43903
    }
    modelSurprisedMouth {
        position: Qt.vector3d(0.1, -1.2, 6.3)
        eulerRotation: Qt.vector3d(50.74624, 1.26713, 1.21353)
        scale: Qt.vector3d(0.7, 0.7, 0.7)
    }
    modelWideEyes {
        x: -0.013
        y: -0.093
        z: 0.005
        rotation: Qt.quaternion(0.989466, 0.11526, -0.00849353, -0.0871826)
        scale.x: 0.213261
        scale.y: 0.213261
        scale.z: 0.213261
    }
    modelWideEyes_1 {
        y: -0.19275003671646118
        z: 1.4294737577438354
    }
    modelWideEyes_2 {
        y: -0.23832271993160248
        z: 1.4294739961624146
    }
    modelWideEyes_3 {
        x: 0.0047806501388549805
        y: 0.39956870675086975
        z: -0.13168272376060486
        scale.x: 0.303691
        scale.y: 0.303691
        scale.z: 0.303691
    }
    modelWideMouth {
        position: Qt.vector3d(-0.012318873777985573, 0.2, 0.8320723414421082)
        rotation: Qt.quaternion(0.951707, 0.303758, 0.0211012, 0.0392338)
        scale.x: 0.15
        scale.y: 0.15
        scale.z: 0.15
    }
    accessoryHolderEyewear {
        x: 0.19979211688041687
        y: 0.3617419898509979
        z: 0.026170935481786728
        rotation: Qt.quaternion(0.676818, -0.0683734, -0.726353, -0.0982528)
    }
    modelEyePatch {
        x: -0.13067705929279327
        y: -0.13895738124847412
        z: -0.026907149702310562
        rotation: Qt.quaternion(0.981983, 0.0887153, 0.126944, 0.108274)
        scale.x: 0.12576
        scale.y: 0.125759
        scale.z: 0.125759
    }
    modelIncognito {
        x: -0.0330355204641819
        y: -0.0005110804340802133
        z: -0.006781560368835926
        rotation: Qt.quaternion(0.730921, 0.107435, -0.0349893, 0.673044)
        scale.x: 0.205174
        scale.y: 0.205174
        scale.z: 0.205174
    }
    modelMonocle {
        x: -0.21734198927879333
        y: -0.01033180020749569
        z: 0.030987516045570374
        rotation: Qt.quaternion(0.619253, -0.452281, -0.434292, -0.472607)
        scale.x: 0.0103497
        scale.y: 0.0103497
        scale.z: 0.0103497
    }
    modelNVGoggles {
        x: -0.02781829796731472
        y: 0.08119115233421326
        z: -0.008172246627509594
        rotation: Qt.quaternion(0.993711, 0.104748, 0.0372885, 0.0132723)
        scale.x: 0.0613698
        scale.y: 0.0613698
        scale.z: 0.0613698
    }
    modelRoundGlasses {
        x: -0.028860123828053474
        y: -0.000948253320530057
        z: -0.022175507619976997
        rotation: Qt.quaternion(0.992192, 0.117822, 0.0350279, 0.0211196)
        scale.x: 0.236699
        scale.y: 0.236699
        scale.z: 0.236699
    }
    modelSunglasses {
        x: -0.15279579162597656
        y: -0.0003664400428533554
        z: -0.01976967044174671
        rotation: Qt.quaternion(0.991817, 0.121886, 0.0273882, 0.0263249)
        scale.x: -0.0557833
        scale.y: -0.0557833
        scale.z: -0.0557833
    }
    accessoryHolderHeadwear {
        x: 0.4897215664386749
        y: -0.1153830736875534
        z: 0.0317189060151577
        rotation: Qt.quaternion(0.676818, -0.0683734, -0.726353, -0.0982528)
    }
    modelBandana {
        x: -0.02493593841791153
        y: 0.054058559238910675
        z: 0.20184841752052307
        rotation: Qt.quaternion(0.712502, -0.698243, 0.0671324, 0.0170576)
        scale.x: 0.391202
        scale.y: 0.405009
        scale.z: 0.349713
    }
    modelBeanie {
        x: -0.01518290676176548
        y: 0.08178307861089706
        z: 0.1975589543581009
        rotation: Qt.quaternion(0.372753, 0.114828, -0.0645995, 0.91853)
        scale.x: 0.161593
        scale.y: 0.161593
        scale.z: 0.161593
    }
    modelCap {
        x: -0.029357653111219406
        y: 0.14411550760269165
        z: 0.04530174657702446
        rotation: Qt.quaternion(0.771718, -0.61766, -0.108644, 0.105566)
        scale.x: 0.127482
        scale.y: 0.127482
        scale.z: 0.127482
    }
    modelConeHat {
        x: -0.08551103621721268
        y: 0.1563655585050583
        z: -0.17683182656764984
        rotation: Qt.quaternion(0.770705, -0.62816, 0.0945508, 0.0498881)
        scale.x: 0.135254
        scale.y: 0.227668
        scale.z: 0.135254
    }
    modelHeadphones {
        x: -0.016500122845172882
        y: 0.1085328459739685
        z: 0.3195188641548157
        eulerRotation.z: 84.21141
        eulerRotation.y: -170.87213
        eulerRotation.x: -63.68304
    }
    modelWizardHat {
        x: -0.013
        y: 0.201
        z: -0.11959
        rotation: Qt.quaternion(0.817492, -0.573833, -0.0348424, 0.0347799)
    }
    accessoryHolderHead {
        x: -0.5211950540542603
        y: 0.02129729650914669
        z: 0.03457566723227501
        rotation: Qt.quaternion(0.747446, 0.0335625, -0.661407, -0.0523321)
    }
    modelWhiskers {
        x: -0.019133012741804123
        y: 0.006638761144131422
        z: 0.01981741562485695
        rotation: Qt.quaternion(0.706654, -0.703127, -0.0784762, 0.00970848)
    }
    accessoryHolderBody {
        x: -0.09632175415754318
        y: -0.024348465725779533
        z: -0.007334607653319836
        rotation: Qt.quaternion(0.726334, 0.0632633, -0.68237, 0.0529958)
    }
    modelAngelWings {
        x: 0.013663120567798615
        y: -0.17130792140960693
        z: -0.01612933911383152
        rotation: Qt.quaternion(0.993938, 0.105207, -0.0291857, 0.0129278)
        scale.x: 0.133827
        scale.y: 0.133827
        scale.z: 0.133827
    }
    modelBackpack {
        y: -0.21760517358779907
        z: -0.05233892798423767
        rotation: Qt.quaternion(0.741539, -0.670845, 0.00898391, 0.00246629)
        scale.x: 0.176869
        scale.y: 0.176869
        scale.z: 0.0940099
    }
    modelBowTie {
        x: 0.025913089513778687
        y: 0.09789018332958221
        z: -0.18778866529464722
        rotation: Qt.quaternion(0.728906, -0.684532, -0.00655214, -0.00834157)
        scale.x: 0.0515167
        scale.y: 0.0515167
        scale.z: 0.0515167
    }
    modelButterflyWings {
        x: 0.005243896972388029
        y: -0.19553649425506592
        z: -0.07103119045495987
        rotation: Qt.quaternion(0.999687, 0.0103407, -0.0220312, 0.00574802)
        scale.x: 0.629903
        scale.y: 0.629903
        scale.z: 0.629903
    }
    modelNecktie {
        x: 0.01815732754766941
        y: 0.005497889593243599
        z: -0.21858450770378113
        rotation: Qt.quaternion(0.709103, -0.0177479, -0.0227379, 0.704515)
        scale.x: 0.195457
        scale.y: 0.23
        scale.z: 0.195457
    }
    universalRiggedTail {
        x: 0.0038796490989625454
        y: -0.12033336609601974
        z: 1.714215613901615e-08
        rotation: Qt.quaternion(0.573576, 5.51413e-08, -3.18342e-08, -0.819152)
    }
    universalRiggedLPlatform {
        x: 0.06558699160814285
        y: 0.0031835290137678385
        z: 3.4924596548080444e-10
        rotation: Qt.quaternion(0.707107, 1.77807e-08, 0.707107, -3.14455e-08)
    }
    universalRiggedRPlatform {
        x: -0.06558700650930405
        y: 0.003183548804372549
        z: 7.8580342233181e-10
        rotation: Qt.quaternion(0.707107, 1.77807e-08, 0.707107, -3.14455e-08)
    }

    Skin {
        id: skin
        joints: [
            root.universalRigged,
            root.universalRiggedPelvis,
            root.universalRiggedLThigh,
            root.universalRiggedLCalf,
            root.universalRiggedLFoot,
            root.universalRiggedRThigh,
            root.universalRiggedRCalf,
            root.universalRiggedRFoot,
            root.universalRiggedSpine1,
            root.universalRiggedSpine2,
            root.universalRiggedSpine3,
            root.universalRiggedRibcage,
            root.universalRiggedLCollarbone,
            root.universalRiggedLUpperarm,
            root.universalRiggedLForearm,
            root.universalRiggedLPalm,
            root.universalRiggedRCollarbone,
            root.universalRiggedRUpperarm,
            root.universalRiggedRForearm,
            root.universalRiggedRPalm,
            root.universalRiggedNeck,
            root.universalRiggedHead,
            root.universalRiggedEar_L,
            root.universalRiggedEar_R,
            root.universalRiggedTail,
            root.universalRiggedLPlatform,
            root.universalRiggedRPlatform
        ]
        inverseBindPoses: [
            Qt.matrix4x4(0.0521354, 0.997101, -0.0554131, 0.00566421, -0.0998558, 0.0604155, 0.993166, -0.0113128, 0.993635, -0.0462458, 0.102716, -0.000159482, 0, 0, 0, 1),
            Qt.matrix4x4(0.0524837, 0.996885, -0.0588782, -0.129069, -0.0996906, 0.0638952, 0.992965, -0.00123965, 0.993634, -0.0462449, 0.102733, -0.00015946, 0, 0, 0, 1),
            Qt.matrix4x4(-0.0148187, -0.999795, 0.0138209, 0.11472, -0.101994, 0.0152618, 0.994668, -0.00236435, -0.994675, 0.0133301, -0.102199, 0.0683189, 0, 0, 0, 1),
            Qt.matrix4x4(-0.0295033, -0.961289, -0.273957, 0.0573166, -0.139327, -0.267446, 0.953447, 0.0161199, -0.989807, 0.0662993, -0.126043, 0.0652713, 0, 0, 0, 1),
            Qt.matrix4x4(-0.109644, -0.181131, 0.977328, 0.0139247, 0.0265916, 0.982369, 0.185049, -0.00465917, -0.993615, 0.0462783, -0.102895, 0.0657461, 0, 0, 0, 1),
            Qt.matrix4x4(-0.0802324, -0.996752, 0.00698451, 0.114732, -0.102266, 0.0152015, 0.99464, -0.00235578, -0.991516, 0.0790881, -0.103153, -0.0679977, 0, 0, 0, 1),
            Qt.matrix4x4(-0.00386155, -0.962573, -0.270995, 0.0573048, -0.0834417, -0.269742, 0.95931, 0.0160968, -0.996506, 0.0263168, -0.0792772, -0.0649614, 0, 0, 0, 1),
            Qt.matrix4x4(-0.109275, -0.181181, 0.977359, 0.0139144, 0.026588, 0.982364, 0.185081, -0.00465573, -0.993656, 0.0462107, -0.10253, -0.0654343, 0, 0, 0, 1),
            Qt.matrix4x4(0.0233255, 0.976558, 0.213989, -0.130806, -0.110221, -0.21023, 0.971419, 0.0362973, 0.993634, -0.0462449, 0.102734, -0.000159445, 0, 0, 0, 1),
            Qt.matrix4x4(0.0593366, 0.989962, -0.128276, -0.226188, -0.0957679, 0.133555, 0.986403, -0.0429914, 0.993634, -0.0462451, 0.102731, -0.000159361, 0, 0, 0, 1),
            Qt.matrix4x4(0.0717905, 0.96266, -0.261021, -0.299745, -0.0868268, 0.266734, 0.959851, -0.0844726, 0.993634, -0.0462447, 0.102734, -0.000159497, 0, 0, 0, 1),
            Qt.matrix4x4(0.052136, 0.997101, -0.0554134, -0.397215, -0.0998731, 0.0604167, 0.993164, -0.00179365, 0.993634, -0.0462453, 0.102733, -0.000159269, 0, 0, 0, 1),
            Qt.matrix4x4(0.985651, -0.15429, -0.0684685, 0.0373958, 0.100984, 0.213951, 0.971611, -0.081982, -0.135261, -0.964583, 0.226462, 0.384641, 0, 0, 0, 1),
            Qt.matrix4x4(0.788415, -0.589832, 0.174643, 0.0926977, -0.272261, -0.0800077, 0.958892, 0.0885573, -0.551612, -0.803553, -0.223668, 0.386452, 0, 0, 0, 1),
            Qt.matrix4x4(0.716768, -0.632828, 0.292869, 0.0227472, -0.436741, -0.0799974, 0.896023, 0.128777, -0.5436, -0.770149, -0.333722, 0.374363, 0, 0, 0, 1),
            Qt.matrix4x4(0.644705, -0.700983, 0.304926, -0.0503604, 0.619877, 0.712823, 0.328077, -0.385019, -0.447335, -0.0224966, 0.894084, 0.118375, 0, 0, 0, 1),
            Qt.matrix4x4(-0.96083, -0.0636989, -0.269718, 0.0377081, -0.277121, 0.231549, 0.932518, -0.0819213, 0.00305259, 0.970736, -0.240131, -0.38462, 0, 0, 0, 1),
            Qt.matrix4x4(-0.858261, -0.513195, 0.00439038, 0.0929622, 0.0622307, -0.0955749, 0.993475, 0.0885033, -0.509427, 0.852934, 0.113965, -0.386281, 0, 0, 0, 1),
            Qt.matrix4x4(-0.816522, -0.561467, 0.134339, 0.0229932, 0.235371, -0.111279, 0.965514, 0.128669, -0.527155, 0.819983, 0.223014, -0.374191, 0, 0, 0, 1),
            Qt.matrix4x4(-0.755012, -0.635839, 0.160206, -0.0501357, -0.605613, 0.769859, 0.201372, -0.384822, -0.251376, 0.0550157, -0.966325, -0.118263, 0, 0, 0, 1),
            Qt.matrix4x4(0.0590774, 0.990319, -0.125607, -0.396243, -0.0959311, 0.130877, 0.986747, -0.0294173, 0.993634, -0.0462448, 0.102734, -0.000159438, 0, 0, 0, 1),
            Qt.matrix4x4(0.052136, 0.997101, -0.055413, -0.5211, -0.0998731, 0.0604163, 0.993165, 0.00750447, 0.993634, -0.0462453, 0.102733, -0.000159192, 0, 0, 0, 1),
            Qt.matrix4x4(0.339831, 0.930243, 0.138433, -0.983872, -0.156166, -0.0893358, 0.983683, 0.166819, 0.92743, -0.355904, 0.114913, 0.144129, 0, 0, 0, 1),
            Qt.matrix4x4(-0.273977, 0.95881, 0.0749705, -0.983774, -0.0568354, -0.0939588, 0.993953, 0.166803, 0.960056, 0.268059, 0.0802368, -0.144432, 0, 0, 0, 1),
            Qt.matrix4x4(0.0757279, -0.400997, -0.912944, -0.0664403, 0.0834149, 0.914912, -0.394942, -0.165663, 0.993634, -0.046245, 0.102733, -0.000159459, 0, 0, 0, 1),
            Qt.matrix4x4(0.0521356, 0.997101, -0.0554131, 0.00566419, -0.0998559, 0.0604155, 0.993166, -0.0144963, 0.993635, -0.046246, 0.102716, -0.0657465, 0, 0, 0, 1),
            Qt.matrix4x4(0.0521356, 0.997101, -0.0554131, 0.00566423, -0.0998559, 0.0604155, 0.993166, -0.0144963, 0.993635, -0.046246, 0.102716, 0.0654275, 0, 0, 0, 1)
        ]
    }

    PrincipledMaterial {
        id: duoToneSloth
        roughness: 0.80424
        cullMode: Material.NoCulling
        alphaMode: PrincipledMaterial.Opaque
        baseColorMap: Texture { source: "images/Sloth_BaseColor.png" }
        normalMap: Texture { source: "images/Sloth_NormalMap.png" }
    }
}
