// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_CHROMEOS_AUDIO_AUDIO_HANDLER_H_
#define CHROME_BROWSER_UI_WEBUI_CHROMEOS_AUDIO_AUDIO_HANDLER_H_

#include <tuple>

#include "ash/components/audio/audio_device.h"
#include "ash/components/audio/cras_audio_handler.h"
#include "base/scoped_observation.h"
#include "chrome/browser/ui/webui/chromeos/audio/audio.mojom.h"
#include "mojo/public/cpp/bindings/pending_receiver.h"
#include "mojo/public/cpp/bindings/pending_remote.h"
#include "mojo/public/cpp/bindings/receiver.h"
#include "mojo/public/cpp/bindings/remote.h"

namespace chromeos {

class AudioHandler : public audio::mojom::PageHandler,
                     public ash::CrasAudioHandler::AudioObserver {
 public:
  AudioHandler(mojo::PendingReceiver<audio::mojom::PageHandler> receiver,
               mojo::PendingRemote<audio::mojom::Page> page);
  AudioHandler(const AudioHandler&) = delete;
  AudioHandler& operator=(const AudioHandler&) = delete;
  ~AudioHandler() override;

  void GetAudioDeviceInfo() override;

  void GetActiveOutputDeviceName(
      GetActiveOutputDeviceNameCallback callback) override;

  void GetActiveInputDeviceName(
      GetActiveInputDeviceNameCallback callback) override;

  void OpenFeedbackDialog() override;

  void OnAudioNodesChanged() override;

  void OnOutputNodeVolumeChanged(uint64_t node_id, int volume) override;

  void OnInputNodeGainChanged(uint64_t node_id, int gain) override;

  void OnOutputMuteChanged(bool mute) override;

  void OnInputMuteChanged(bool mute) override;

  void OnInputMutedByMicrophoneMuteSwitchChanged(bool mute) override;

  void OnActiveOutputNodeChanged() override;

  void OnActiveInputNodeChanged() override;

 private:
  void UpdateAudioDeviceInfo();

  base::ScopedObservation<ash::CrasAudioHandler,
                          AudioObserver,
                          &ash::CrasAudioHandler::AddAudioObserver,
                          &ash::CrasAudioHandler::RemoveAudioObserver>
      observation_{this};

  audio::mojom::DeviceDataPtr CreateDeviceData(
      const ash::AudioDevice* item) const;

  std::tuple<int, bool> GetDeviceVolGain(uint64_t id, bool is_input) const;

  mojo::Remote<audio::mojom::Page> page_;
  mojo::Receiver<audio::mojom::PageHandler> receiver_;
};

}  // namespace chromeos

#endif  // CHROME_BROWSER_UI_WEBUI_CHROMEOS_AUDIO_AUDIO_HANDLER_H_
