/****************************************************************************
**
** Copyright (C) 2017 Ford Motor Company
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtRemoteObjects module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "../../../../shared/testutils.h"

#include <QtTest/QtTest>
#include <QMetaType>
#include <QProcess>

typedef QLatin1String _;
class tst_Signature: public QObject
{
    Q_OBJECT

private slots:
    void initTestCase()
    {
        QVERIFY(TestUtils::init("signatureTests"));
        QLoggingCategory::setFilterRules("qt.remoteobjects.warning=false");
    }

    void cleanup()
    {
        // wait for delivery of RemoveObject events to the source
        QTest::qWait(200);
    }

    void testRun()
    {
#ifdef Q_OS_ANDROID
        QSKIP("QProcess doesn't support running user bundled binaries on Android");
#endif
        qDebug() << "Starting signatureServer process";
        QProcess serverProc;
        serverProc.setProcessChannelMode(QProcess::ForwardedChannels);
        serverProc.start(TestUtils::findExecutable("signatureServer", "/signatureServer"),
                         QStringList());
        QVERIFY(serverProc.waitForStarted());

        // wait for server start
        QTest::qWait(200);

        const QLatin1String tests[] = {
            _("differentGlobalEnum"),
            _("differentClassEnum"),
            _("differentPropertyCount"),
            _("differentPropertyCountChild"),
            _("differentPropertyType"),
            _("scrambledProperties"),
            _("differentSlotCount"),
            _("differentSlotType"),
            _("differentSlotParamCount"),
            _("differentSlotParamType"),
            _("scrambledSlots"),
            _("differentSignalCount"),
            _("differentSignalParamCount"),
            _("differentSignalParamType"),
            _("scrambledSignals"),
            _("state"),
            _("matchAndQuit"), // matchAndQuit should be the last one
        };

        for (const auto &test : tests) {
            qDebug() << "Starting" << test << "process";
            QProcess testProc;
            testProc.setProcessChannelMode(QProcess::ForwardedChannels);
            testProc.start(TestUtils::findExecutable(test, "/" + test ),
                           QStringList());
            QVERIFY(testProc.waitForStarted());
            QVERIFY(testProc.waitForFinished());
            QCOMPARE(testProc.exitCode(), 0);
        }

        QVERIFY(serverProc.waitForFinished());
        QCOMPARE(serverProc.exitCode(), 0);
    }
};

QTEST_MAIN(tst_Signature)

#include "tst_signature.moc"
