/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain.pdus;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.ripe.rpki.rtr.domain.pdus.ErrorCode;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;

public final class ErrorPdu
implements Pdu {
    public static final int PDU_TYPE = 10;
    private final ProtocolVersion protocolVersion;
    private final ErrorCode errorCode;
    private final byte[] causingPdu;
    private final byte[] errorText;

    public static ErrorPdu of(ProtocolVersion protocolVersion, ErrorCode errorCode, byte[] causingPdu, String errorText) {
        return new ErrorPdu(protocolVersion, errorCode, causingPdu, errorText.getBytes(StandardCharsets.UTF_8));
    }

    public int length() {
        return 12 + this.causingPdu.length + 4 + this.errorText.length;
    }

    public void write(ByteBuf out) {
        out.writeByte((int)this.protocolVersion.getValue()).writeByte(10).writeShort(this.errorCode.getCode()).writeInt(this.length()).writeInt(this.causingPdu.length).writeBytes(this.causingPdu).writeInt(this.errorText.length).writeBytes(this.errorText);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public byte[] getCausingPdu() {
        return this.causingPdu;
    }

    public byte[] getErrorText() {
        return this.errorText;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorPdu)) {
            return false;
        }
        ErrorPdu other = (ErrorPdu)o;
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        ErrorCode this$errorCode = this.getErrorCode();
        ErrorCode other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        if (!Arrays.equals(this.getCausingPdu(), other.getCausingPdu())) {
            return false;
        }
        return Arrays.equals(this.getErrorText(), other.getErrorText());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        ErrorCode $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        result = result * 59 + Arrays.hashCode(this.getCausingPdu());
        result = result * 59 + Arrays.hashCode(this.getErrorText());
        return result;
    }

    public String toString() {
        return "ErrorPdu(protocolVersion=" + this.getProtocolVersion() + ", errorCode=" + this.getErrorCode() + ", causingPdu=" + Arrays.toString(this.getCausingPdu()) + ", errorText=" + Arrays.toString(this.getErrorText()) + ")";
    }

    @ConstructorProperties(value={"protocolVersion", "errorCode", "causingPdu", "errorText"})
    private ErrorPdu(ProtocolVersion protocolVersion, ErrorCode errorCode, byte[] causingPdu, byte[] errorText) {
        this.protocolVersion = protocolVersion;
        this.errorCode = errorCode;
        this.causingPdu = causingPdu;
        this.errorText = errorText;
    }
}

