/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.background;

import java.util.Optional;
import java.util.function.Consumer;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class CertificateTreeObjectExpirationValidationJob
implements Job {
    @Autowired
    private Storage storage;
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private ValidationRuns validationRuns;
    @Autowired
    private ValidationScheduler validationScheduler;
    Consumer<TrustAnchor> triggerCertificateTreeValidation = ta -> this.validationScheduler.triggerCertificateTreeValidation(ta);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.storage.readTx0(tx -> this.trustAnchors.findAll(tx).stream().filter(ta -> {
            Optional maybeVr = this.validationRuns.findLatestCompletedCaTreeValidationRun(tx, ta);
            if (!maybeVr.isPresent()) {
                return false;
            }
            CertificateTreeValidationRun vr = (CertificateTreeValidationRun)maybeVr.get();
            InstantWithoutNanos earliestObjectExpiration = vr.getEarliestObjectExpiration();
            return earliestObjectExpiration != null && earliestObjectExpiration.isBefore(InstantWithoutNanos.now());
        }).forEach(this.triggerCertificateTreeValidation));
    }
}

