/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.xodus;

import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Transaction;
import net.ripe.rpki.validator3.storage.xodus.Xodus;
import net.ripe.rpki.validator3.storage.xodus.XodusTx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XodusTx
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(XodusTx.class);
    protected final Environment env;
    protected final Transaction txn;
    private final long threadId = Thread.currentThread().getId();
    private final long id;
    private boolean aborted = false;
    private static AtomicLong idseq = new AtomicLong(1L);

    private XodusTx(Environment env) {
        this.env = env;
        this.id = idseq.getAndIncrement();
        this.txn = this.makeTxn();
    }

    private XodusTx(Environment env, Transaction txn) {
        this.env = env;
        this.id = idseq.getAndIncrement();
        this.txn = txn;
    }

    static Read fromRONative(Environment env, Transaction txn) {
        return new Read(env, txn);
    }

    static Write fromRWNative(Environment env, Transaction txn) {
        return new Write(env, txn);
    }

    protected abstract Transaction makeTxn();

    public static Read read(Environment e) {
        return new Read(e);
    }

    public static Write write(Environment e) {
        return new Write(e);
    }

    public Transaction txn() {
        this.verifyState();
        return this.txn;
    }

    private void verifyState() {
        if (this.aborted) {
            throw new RuntimeException("Transaction " + this.txn.getHighAddress() + " was aborted.");
        }
        if (Thread.currentThread().getId() != this.threadId) {
            throw new RuntimeException("This transaction was created in another thread and cannot be used in the thread " + Thread.currentThread());
        }
        this.checkEnv();
    }

    void checkEnv() {
        Xodus.checkEnv((Environment)this.env);
    }

    public void abort() {
        this.checkEnv();
        this.txn.abort();
        this.aborted = true;
    }

    @Override
    public void close() {
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getId() {
        return this.id;
    }
}

