/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.constraints;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.validator3.api.roaprefixassertions.AddRoaPrefixAssertion;
import net.ripe.rpki.validator3.domain.constraints.ValidAddRoaPrefixAssertion;

public class AddRoaPrefixAssertionValidator
implements ConstraintValidator<ValidAddRoaPrefixAssertion, AddRoaPrefixAssertion> {
    private final int MAX_LENGTH_IPV4 = 32;
    private final int MAX_LENGTH_IPV6 = 128;

    public boolean isValid(AddRoaPrefixAssertion value, ConstraintValidatorContext context) {
        if (value.getAsn() == null && value.getPrefix() == null) {
            return false;
        }
        if (value.getPrefix() != null && value.getMaximumLength() != null) {
            IpRange ipRange;
            try {
                ipRange = IpRange.parse((String)value.getPrefix());
            }
            catch (Exception e) {
                return false;
            }
            if (IpResourceType.IPv4.equals((Object)ipRange.getType()) && value.getMaximumLength() > 32) {
                this.setReturnMessage(context, "MAX_LENGTH_LONGER_32");
                return false;
            }
            if (IpResourceType.IPv6.equals((Object)ipRange.getType()) && value.getMaximumLength() > 128) {
                this.setReturnMessage(context, "MAX_LENGTH_LONGER_128");
                return false;
            }
            if (value.getMaximumLength() < ipRange.getPrefixLength()) {
                this.setReturnMessage(context, "MAX_LENGTH_LONGER_PREFIX_LENGTH");
                return false;
            }
        }
        return true;
    }

    private void setReturnMessage(ConstraintValidatorContext context, String message) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

