/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding;

import java.util.HashMap;
import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RrdpRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RsyncRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.TrustAnchorValidationRun;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.GsonCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.RefCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.RpkiObjectCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.RpkiRepositoryCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.TrustAnchorCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.validation.CTValidationRunCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.validation.RRValidationRunCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.validation.RSValidationRunCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.validation.TAValidationRunCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CoderFactory {
    private static final Logger log = LoggerFactory.getLogger(CoderFactory.class);
    private static Map<Class<?>, Coder<?>> customCoders = CoderFactory.registerCustomCoder();

    public static <T> Coder<T> makeCoder(Class<T> c) {
        Coder cc = CoderFactory.Coder(c);
        if (cc == null) {
            GsonCoder gsonCoder = new GsonCoder(c);
            log.warn("There's no custom coder for the type {}, using a {}", c, gsonCoder.getClass());
            return gsonCoder;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static Map<Class<?>, Coder<?>> registerCustomCoder() {
        HashMap cc = new HashMap();
        cc.put(Ref.class, (Coder<?>)new RefCoder());
        cc.put(RpkiObject.class, (Coder<?>)new RpkiObjectCoder());
        cc.put(RpkiRepository.class, (Coder<?>)new RpkiRepositoryCoder());
        cc.put(TrustAnchor.class, (Coder<?>)new TrustAnchorCoder());
        cc.put(CertificateTreeValidationRun.class, (Coder<?>)new CTValidationRunCoder());
        cc.put(TrustAnchorValidationRun.class, (Coder<?>)new TAValidationRunCoder());
        cc.put(RsyncRepositoryValidationRun.class, (Coder<?>)new RSValidationRunCoder());
        cc.put(RrdpRepositoryValidationRun.class, (Coder<?>)new RRValidationRunCoder());
        return cc;
    }

    private static <T> Coder<T> Coder(Class<T> c) {
        return (Coder)customCoders.get(c);
    }

    public static Coder<Key> keyCoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Coder<Long> longCoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Coder<String> stringCoder() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

