/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import fj.data.Either;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.ripe.rpki.commons.rsync.Rsync;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.domain.metrics.RsyncMetricsService;
import net.ripe.rpki.validator3.domain.validation.TrustAnchorState;
import net.ripe.rpki.validator3.rrdp.RrdpService;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.RpkiRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RrdpRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.RsyncRepositoryValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Hex;
import net.ripe.rpki.validator3.util.RsyncFactory;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RpkiRepositoryValidationService {
    private static final Logger log = LoggerFactory.getLogger(RpkiRepositoryValidationService.class);
    private final RrdpService rrdpService;
    private final File rsyncLocalStorageDirectory;
    private final ValidationRuns validationRuns;
    private final RpkiRepositories rpkiRepositories;
    private final RpkiObjects rpkiObjects;
    private final TrustAnchors trustAnchors;
    private final ValidationScheduler validationScheduler;
    private final Storage storage;
    private final TrustAnchorState trustAnchorState;
    private final RsyncFactory rsyncFactory;
    private final RsyncMetricsService rsyncMetrics;
    private ExecutorCompletionService<Either<ValidationResult, Pair<String, RpkiObject>>> asyncCreateObjects = new ExecutorCompletionService(Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() - 1)));

    @Autowired
    public RpkiRepositoryValidationService(ValidationRuns validationRuns, RpkiRepositories rpkiRepositories, RpkiObjects rpkiObjects, RrdpService rrdpService, TrustAnchors trustAnchors, Storage storage, @Value(value="${rpki.validator.rsync.local.storage.directory}") File rsyncLocalStorageDirectory, TrustAnchorState trustAnchorState, ValidationScheduler validationScheduler, RsyncFactory rsyncFactory, RsyncMetricsService rsyncMetrics) {
        this.validationRuns = validationRuns;
        this.rpkiRepositories = rpkiRepositories;
        this.rpkiObjects = rpkiObjects;
        this.rrdpService = rrdpService;
        this.trustAnchors = trustAnchors;
        this.rsyncLocalStorageDirectory = rsyncLocalStorageDirectory;
        this.storage = storage;
        this.trustAnchorState = trustAnchorState;
        this.validationScheduler = validationScheduler;
        this.rsyncFactory = rsyncFactory;
        this.rsyncMetrics = rsyncMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateRrdpRpkiRepository(long rpkiRepositoryId) {
        Key key = Key.of((long)rpkiRepositoryId);
        RpkiRepository rpkiRepository = (RpkiRepository)this.storage.readTx(tx -> this.rpkiRepositories.get(tx, key).orElse(null));
        if (rpkiRepository == null) {
            log.info("RPKI repository with key {} doesn't exist ", (Object)rpkiRepositoryId);
            return;
        }
        log.info("Starting RPKI repository validation for " + rpkiRepository);
        ValidationResult validationResult = ValidationResult.withLocation((String)rpkiRepository.getRrdpNotifyUri());
        RpkiRepositoryValidationRun validationRun = (RpkiRepositoryValidationRun)this.storage.writeTx(tx -> {
            Ref rpkiRepositoryRef = this.rpkiRepositories.makeRef((Tx.Read)tx, rpkiRepository.key());
            RrdpRepositoryValidationRun newVR = (RrdpRepositoryValidationRun)this.validationRuns.add(tx, (ValidationRun)new RrdpRepositoryValidationRun(rpkiRepositoryRef));
            this.validationRuns.associate(tx, (RpkiRepositoryValidationRun)newVR, rpkiRepository);
            return newVR;
        });
        boolean triggerCaTreeAfter = false;
        boolean changedAtLeastOneObject = false;
        try {
            String uri = rpkiRepository.getRrdpNotifyUri();
            if (this.isRrdpUri(uri)) {
                changedAtLeastOneObject = this.rrdpService.storeRepository(rpkiRepository, validationRun);
                if (validationRun.isFailed()) {
                    rpkiRepository.setFailed();
                } else {
                    rpkiRepository.setDownloaded();
                }
            } else if (this.isRsyncUri(uri)) {
                validationResult.error("rsync.repository.not.supported", new String[0]);
            } else {
                log.error("Unsupported type of the URI " + uri);
            }
            if (validationResult.hasFailures()) {
                validationRun.setFailed();
            } else {
                validationRun.setSucceeded();
                triggerCaTreeAfter = true;
            }
        }
        catch (Exception e) {
            log.error("Error validating repository " + rpkiRepository, (Throwable)e);
            validationRun.setFailed();
        }
        finally {
            if (triggerCaTreeAfter && changedAtLeastOneObject) {
                this.storage.readTx0(tx -> rpkiRepository.getTrustAnchors().forEach(taRef -> this.trustAnchors.get(tx, taRef.key()).ifPresent(arg_0 -> ((TrustAnchorState)this.trustAnchorState).setUnknown(arg_0))));
            }
            this.storage.writeTx0(tx -> {
                this.rpkiRepositories.update(tx, rpkiRepository);
                this.validationRuns.update(tx, (ValidationRun)validationRun);
            });
            if (triggerCaTreeAfter && changedAtLeastOneObject) {
                this.storage.readTx0(tx -> rpkiRepository.getTrustAnchors().forEach(taRef -> this.trustAnchors.get(tx, taRef.key()).ifPresent(arg_0 -> ((ValidationScheduler)this.validationScheduler).triggerCertificateTreeValidation(arg_0))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateRsyncRepositories() {
        InstantWithoutNanos cutoffTime = InstantWithoutNanos.now().minus((TemporalAmount)this.validationScheduler.getRsyncRepositoryDownloadInterval());
        log.info("updating all rsync repositories that have not been downloaded since {}", (Object)cutoffTime);
        HashSet affectedTrustAnchors = new HashSet();
        RsyncRepositoryValidationRun validationRun = this.makeAndStoreRsyncValidationRun();
        HashSet existingObjectKeys = new HashSet();
        HashMap fetchedLocations = new HashMap();
        try {
            Stream<RpkiRepository> repositoriesNeedingUpdate = ((Stream)this.storage.readTx(arg_0 -> ((RpkiRepositories)this.rpkiRepositories).findRsyncRepositories(arg_0))).filter(repository -> {
                boolean needsUpdate;
                boolean bl = needsUpdate = repository.isPending() || repository.getLastDownloadedAt() == null || repository.getLastDownloadedAt().isBefore(cutoffTime);
                if (!needsUpdate) {
                    fetchedLocations.put(URI.create(repository.getRsyncRepositoryUri()), repository);
                }
                return needsUpdate;
            });
            ValidationResult results = repositoriesNeedingUpdate.map(repository -> {
                this.storage.writeTx0(tx -> this.validationRuns.associate(tx, (RpkiRepositoryValidationRun)validationRun, repository));
                return this.processRsyncRepository(affectedTrustAnchors, validationRun, fetchedLocations, existingObjectKeys, repository);
            }).collect(() -> ValidationResult.withLocation((String)"placeholder"), ValidationResult::addAll, ValidationResult::addAll);
            validationRun.completeWith(results);
            affectedTrustAnchors.forEach(ta -> {
                log.info("The following trust anchor was affected, validation will be triggered {}", ta);
                this.validationScheduler.triggerCertificateTreeValidation(ta);
            });
        }
        catch (Exception e) {
            validationRun.setFailed();
        }
        finally {
            this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<TrustAnchor> prefetchRepository(RpkiRepository repository) {
        HashSet<TrustAnchor> affectedTrustAnchors = new HashSet<TrustAnchor>();
        if (repository.isPending() && repository.getType() == RpkiRepository.Type.RSYNC_PREFETCH) {
            log.info("Processing rsync-prefetch repository {}", (Object)repository);
            RsyncRepositoryValidationRun validationRun = this.makeAndStoreRsyncValidationRun();
            ValidationResult validationResult = ValidationResult.withLocation((URI)URI.create(repository.getRsyncRepositoryUri()));
            this.storage.writeTx0(tx -> this.validationRuns.associate(tx, (RpkiRepositoryValidationRun)validationRun, repository));
            HashSet existingObjectsBySha256 = new HashSet();
            try {
                File targetDirectory = net.ripe.rpki.validator3.util.Rsync.localFileFromRsyncUri((File)this.rsyncLocalStorageDirectory, (URI)URI.create(repository.getRsyncRepositoryUri()));
                this.fetchRsyncRepository(repository, targetDirectory, validationResult);
                log.info("Storing objects downloaded for {}", (Object)repository.getLocationUri());
                Long t = Time.timed(() -> this.storeObjects(targetDirectory, validationRun, validationResult, existingObjectsBySha256, repository));
                log.info("Stored {} objects from the repository {} in {}ms", new Object[]{existingObjectsBySha256.size(), repository, t});
                repository.setDownloaded();
            }
            catch (IOException e) {
                repository.setFailed();
                validationResult.error("rsync.repository.io", new String[]{e.toString(), ExceptionUtils.getStackTrace((Throwable)e)});
            }
            finally {
                this.storage.writeTx0(tx -> {
                    this.rpkiRepositories.update(tx, repository);
                    this.validationRuns.add(tx, (ValidationRun)validationRun);
                });
            }
            this.storage.readTx0(tx -> repository.getTrustAnchors().forEach(taRef -> this.trustAnchors.get(tx, taRef.key()).ifPresent(affectedTrustAnchors::add)));
        }
        return affectedTrustAnchors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult processRsyncRepository(Set<TrustAnchor> affectedTrustAnchors, RsyncRepositoryValidationRun validationRun, Map<URI, RpkiRepository> fetchedLocations, Set<String> existingObjectsSha256, RpkiRepository repository) {
        ValidationResult validationResult = ValidationResult.withLocation((URI)URI.create(repository.getRsyncRepositoryUri()));
        try {
            File targetDirectory = net.ripe.rpki.validator3.util.Rsync.localFileFromRsyncUri((File)this.rsyncLocalStorageDirectory, (URI)URI.create(repository.getRsyncRepositoryUri()));
            RpkiRepository parentRepository = this.findDownloadedParentRepository(fetchedLocations, repository);
            if (parentRepository == null) {
                this.fetchRsyncRepository(repository, targetDirectory, validationResult);
                if (validationResult.hasFailureForCurrentLocation()) {
                    ValidationResult validationResult2 = validationResult;
                    return validationResult2;
                }
            }
            if (repository.getType() == RpkiRepository.Type.RSYNC_PREFETCH || repository.getType() == RpkiRepository.Type.RSYNC && (parentRepository == null || parentRepository.getType() == RpkiRepository.Type.RSYNC_PREFETCH)) {
                log.info("Storing objects downloaded for {}", (Object)repository.getLocationUri());
                Long t = Time.timed(() -> this.storeObjects(targetDirectory, validationRun, validationResult, existingObjectsSha256, repository));
                log.info("Stored {} objects from the repository {} in {}ms", new Object[]{existingObjectsSha256.size(), repository, t});
                repository.setDownloaded();
            }
        }
        catch (IOException e) {
            repository.setFailed();
            validationResult.error("rsync.repository.io", new String[]{e.toString(), ExceptionUtils.getStackTrace((Throwable)e)});
        }
        finally {
            this.storage.writeTx0(tx -> this.rpkiRepositories.update(tx, repository));
        }
        this.storage.readTx0(tx -> repository.getTrustAnchors().forEach(taRef -> this.trustAnchors.get(tx, taRef.key()).ifPresent(ta -> {
            this.trustAnchorState.setUnknown(ta);
            affectedTrustAnchors.add((TrustAnchor)ta);
        })));
        fetchedLocations.put(URI.create(repository.getRsyncRepositoryUri()), repository);
        return validationResult;
    }

    private RpkiRepository findDownloadedParentRepository(Map<URI, RpkiRepository> fetchedLocations, RpkiRepository repository) {
        URI location = URI.create(repository.getRsyncRepositoryUri());
        for (URI parentLocation : net.ripe.rpki.validator3.util.Rsync.generateCandidateParentUris((URI)location)) {
            RpkiRepository parentRepository = fetchedLocations.get(parentLocation);
            if (parentRepository == null) continue;
            Ref rpkiRepositoryRef = (Ref)this.storage.readTx(tx -> this.rpkiRepositories.makeRef(tx, parentRepository.key()));
            repository.setParentRepository(rpkiRepositoryRef);
            if (!parentRepository.isDownloaded()) continue;
            log.debug("Already fetched {} as part of {}, skipping", (Object)repository.getLocationUri(), (Object)parentRepository.getLocationUri());
            repository.setDownloaded(parentRepository.getLastDownloadedAt());
            return parentRepository;
        }
        return null;
    }

    private void storeObjects(File targetDirectory, RsyncRepositoryValidationRun validationRun, ValidationResult validationResult, Set<String> existingObjectsKeys, RpkiRepository repository) {
        this.storage.writeTx0(tx -> {
            try {
                this.traverseFSandStore(tx, targetDirectory, validationRun, validationResult, existingObjectsKeys, repository);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void traverseFSandStore(Tx.Write tx, File targetDirectory, RsyncRepositoryValidationRun validationRun, ValidationResult validationResult, Set<String> existingObjectsKeys, RpkiRepository repository) throws IOException {
        AtomicInteger workCounter = new AtomicInteger(0);
        int threshold = 10;
        Files.walkFileTree(targetDirectory.toPath(), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
        while (workCounter.getAndDecrement() > 0) {
            this.storeObject(tx, (RpkiRepositoryValidationRun)validationRun, existingObjectsKeys);
        }
    }

    private void storeObject(Tx.Write tx, RpkiRepositoryValidationRun validationRun, Set<String> existingObjectsKeys) {
        try {
            Either maybeRpkiObject = (Either)this.asyncCreateObjects.take().get();
            if (maybeRpkiObject.isLeft()) {
                ValidationResult value = (ValidationResult)maybeRpkiObject.left().value();
                validationRun.addChecks(value);
                log.debug("parsing {} failed: {}", (Object)value.getCurrentLocation().getName(), (Object)value);
            } else {
                Pair p = (Pair)maybeRpkiObject.right().value();
                RpkiObject object = (RpkiObject)p.getRight();
                String key = Hex.format((byte[])object.getSha256());
                String location = (String)p.getLeft();
                if (existingObjectsKeys.contains(key)) {
                    this.rpkiObjects.addLocation(tx, Key.of((String)key), location);
                } else {
                    this.rpkiObjects.put(tx, object, location);
                    existingObjectsKeys.add(key);
                }
            }
        }
        catch (Exception e) {
            log.error("Something strange happened here", (Throwable)e);
        }
    }

    private RsyncRepositoryValidationRun makeAndStoreRsyncValidationRun() {
        return (RsyncRepositoryValidationRun)this.storage.writeTx(tx -> (RsyncRepositoryValidationRun)this.validationRuns.add(tx, (ValidationRun)new RsyncRepositoryValidationRun()));
    }

    private boolean isRrdpUri(String uri) {
        return uri.toLowerCase(Locale.ROOT).startsWith("https://") || uri.toLowerCase(Locale.ROOT).startsWith("http://");
    }

    private boolean isRsyncUri(String uri) {
        return uri.toLowerCase(Locale.ROOT).startsWith("rsync://");
    }

    private void fetchRsyncRepository(RpkiRepository rpkiRepository, File targetDirectory, ValidationResult validationResult) throws IOException {
        if (targetDirectory.mkdirs()) {
            log.info("created local rsync storage directory {} for repository {}", (Object)targetDirectory, (Object)rpkiRepository);
        }
        long t0 = System.currentTimeMillis();
        Rsync rsync = this.rsyncFactory.rsyncDirectory(rpkiRepository.getLocationUri(), targetDirectory.getPath());
        int exitStatus = rsync.execute();
        this.rsyncMetrics.update(rpkiRepository.getLocationUri(), exitStatus, System.currentTimeMillis() - t0);
        validationResult.rejectIfTrue(exitStatus != 0, "rsync.fetch", new String[]{String.valueOf(exitStatus), ArrayUtils.toString((Object)rsync.getErrorLines())});
        if (validationResult.hasFailureForCurrentLocation()) {
            rpkiRepository.setFailed();
        } else {
            log.info("Downloaded repository {} to {}", (Object)rpkiRepository.getRsyncRepositoryUri(), (Object)targetDirectory);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(RpkiRepositoryValidationService x0, Tx.Write x1, RpkiRepositoryValidationRun x2, Set x3) {
        x0.storeObject(x1, x2, x3);
    }

    static /* synthetic */ ExecutorCompletionService access$200(RpkiRepositoryValidationService x0) {
        return x0.asyncCreateObjects;
    }

    static /* synthetic */ RpkiObjects access$300(RpkiRepositoryValidationService x0) {
        return x0.rpkiObjects;
    }
}

