/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.domain.constraints.ValidLocationURI;
import net.ripe.rpki.validator3.domain.constraints.ValidPublicKeyInfo;
import net.ripe.rpki.validator3.storage.Binary;
import net.ripe.rpki.validator3.storage.data.Base;

@Binary
public class TrustAnchor
extends Base<TrustAnchor> {
    public static final String TYPE = "trust-anchor";
    private boolean preconfigured;
    private boolean initialCertificateTreeValidationRunCompleted;
    @NotNull
    @Size(min=1, max=1000)
    private @NotNull @Size(min=1, max=1000) String name;
    private List<@NotNull @ValidLocationURI String> locations = new ArrayList();
    @NotNull
    @ValidPublicKeyInfo
    private String subjectPublicKeyInfo;
    @ValidLocationURI
    private String rsyncPrefetchUri;
    @Size(max=0xA00000)
    private @Size(max=0xA00000) byte[] encodedCertificate;

    public TrustAnchor() {
    }

    public TrustAnchor(boolean preconfigured) {
        this.preconfigured = preconfigured;
        this.initialCertificateTreeValidationRunCompleted = false;
    }

    public void setCertificate(X509ResourceCertificate certificate) {
        this.encodedCertificate = certificate.getEncoded();
    }

    public X509ResourceCertificate getCertificate() {
        if (this.encodedCertificate == null) {
            return null;
        }
        return (X509ResourceCertificate)CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])this.encodedCertificate, (ValidationResult)ValidationResult.withLocation((String)((String)this.locations.get(0))));
    }

    public void markInitialCertificateTreeValidationRunCompleted() {
        this.initialCertificateTreeValidationRunCompleted = true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustAnchor)) {
            return false;
        }
        TrustAnchor other = (TrustAnchor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPreconfigured() != other.isPreconfigured()) {
            return false;
        }
        if (this.isInitialCertificateTreeValidationRunCompleted() != other.isInitialCertificateTreeValidationRunCompleted()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$locations = this.getLocations();
        List other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
            return false;
        }
        String this$subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        String other$subjectPublicKeyInfo = other.getSubjectPublicKeyInfo();
        if (this$subjectPublicKeyInfo == null ? other$subjectPublicKeyInfo != null : !this$subjectPublicKeyInfo.equals(other$subjectPublicKeyInfo)) {
            return false;
        }
        String this$rsyncPrefetchUri = this.getRsyncPrefetchUri();
        String other$rsyncPrefetchUri = other.getRsyncPrefetchUri();
        if (this$rsyncPrefetchUri == null ? other$rsyncPrefetchUri != null : !this$rsyncPrefetchUri.equals(other$rsyncPrefetchUri)) {
            return false;
        }
        return Arrays.equals(this.getEncodedCertificate(), other.getEncodedCertificate());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrustAnchor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPreconfigured() ? 79 : 97);
        result = result * 59 + (this.isInitialCertificateTreeValidationRunCompleted() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        String $subjectPublicKeyInfo = this.getSubjectPublicKeyInfo();
        result = result * 59 + ($subjectPublicKeyInfo == null ? 43 : $subjectPublicKeyInfo.hashCode());
        String $rsyncPrefetchUri = this.getRsyncPrefetchUri();
        result = result * 59 + ($rsyncPrefetchUri == null ? 43 : $rsyncPrefetchUri.hashCode());
        result = result * 59 + Arrays.hashCode(this.getEncodedCertificate());
        return result;
    }

    public String toString() {
        return "TrustAnchor(preconfigured=" + this.isPreconfigured() + ", initialCertificateTreeValidationRunCompleted=" + this.isInitialCertificateTreeValidationRunCompleted() + ", name=" + this.getName() + ", locations=" + this.getLocations() + ", rsyncPrefetchUri=" + this.getRsyncPrefetchUri() + ")";
    }

    public boolean isPreconfigured() {
        return this.preconfigured;
    }

    public boolean isInitialCertificateTreeValidationRunCompleted() {
        return this.initialCertificateTreeValidationRunCompleted;
    }

    public String getName() {
        return this.name;
    }

    public List<@NotNull @ValidLocationURI String> getLocations() {
        return this.locations;
    }

    public String getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public String getRsyncPrefetchUri() {
        return this.rsyncPrefetchUri;
    }

    public byte[] getEncodedCertificate() {
        return this.encodedCertificate;
    }

    public void setPreconfigured(boolean preconfigured) {
        this.preconfigured = preconfigured;
    }

    public void setInitialCertificateTreeValidationRunCompleted(boolean initialCertificateTreeValidationRunCompleted) {
        this.initialCertificateTreeValidationRunCompleted = initialCertificateTreeValidationRunCompleted;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocations(List<@NotNull @ValidLocationURI String> locations) {
        this.locations = locations;
    }

    public void setSubjectPublicKeyInfo(String subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public void setRsyncPrefetchUri(String rsyncPrefetchUri) {
        this.rsyncPrefetchUri = rsyncPrefetchUri;
    }

    public void setEncodedCertificate(byte[] encodedCertificate) {
        this.encodedCertificate = encodedCertificate;
    }
}

