/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import net.ripe.ipresource.IpRange;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateUtil;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Locks;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ValidatedRpkiObjects {
    private static final Logger log = LoggerFactory.getLogger(ValidatedRpkiObjects.class);
    private final List<Consumer<Collection<RoaPrefixesAndRouterCertificates>>> listeners = new ArrayList();
    private Map<Long, RoaPrefixesAndRouterCertificates> validatedObjectsByTrustAnchor = new HashMap();
    @Autowired
    private RpkiObjects rpkiObjects;
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private ValidationRuns validationRuns;
    @Autowired
    private Storage storage;
    private ReentrantReadWriteLock dataLock = new ReentrantReadWriteLock();

    @PostConstruct
    private void initialize() {
        Long t = Time.timed(() -> {
            List trustAnchorList = (List)this.storage.readTx(tx -> this.trustAnchors.findAll(tx));
            trustAnchorList.parallelStream().forEach(ta -> this.storage.readTx0(tx -> this.validationRuns.findLatestSuccessfulCaTreeValidationRun(tx, ta).ifPresent(vr -> {
                Set associatedPks = this.validationRuns.findAssociatedPks(tx, vr);
                this.updateByKey(tx, vr.getTrustAnchor(), (Collection)associatedPks);
            })));
        });
        log.info("Validated objects cache initialised in {}ms", (Object)t);
    }

    void updateByKey(Tx.Read tx, Ref<TrustAnchor> trustAnchor, Collection<Key> rpkiObjectsKeys) {
        Long t = Time.timed(() -> this.trustAnchors.get(tx, trustAnchor.key()).map(ta -> {
            TrustAnchorData trustAnchorData = TrustAnchorData.of((long)trustAnchor.key().asLong(), (String)ta.getName());
            Stream roaStream = this.streamByType(tx, rpkiObjectsKeys, RpkiObject.Type.ROA);
            Stream routerCertStream = this.streamByType(tx, rpkiObjectsKeys, RpkiObject.Type.ROUTER_CER);
            return RoaPrefixesAndRouterCertificates.of((ImmutableSet)this.toRoaPrefixes(tx, trustAnchorData, roaStream), (ImmutableSet)this.toRouterCertificates(trustAnchorData, routerCertStream));
        }).ifPresent(roaPrefixesAndRouterCertificates -> {
            log.info("updating validation objects cache for trust anchor {} with {} ROA prefixes and {} router certificates", new Object[]{trustAnchor, roaPrefixesAndRouterCertificates.getRoaPrefixes().size(), roaPrefixesAndRouterCertificates.getRouterCertificates().size()});
            Locks.locked((Lock)this.dataLock.writeLock(), () -> this.validatedObjectsByTrustAnchor.put(trustAnchor.key().asLong(), roaPrefixesAndRouterCertificates));
            this.notifyListeners();
        }));
        log.info("Updated validated roas in {}ms", (Object)t);
    }

    private Stream<RpkiObject> streamByType(Tx.Read tx, Collection<Key> rpkiObjectsKeys, RpkiObject.Type type) {
        Set byType = this.rpkiObjects.getPkByType(tx, type);
        return rpkiObjectsKeys.stream().filter(byType::contains).map(k -> this.rpkiObjects.get(tx, k)).filter(Optional::isPresent).map(Optional::get);
    }

    public void remove(TrustAnchor trustAnchor) {
        long trustAnchorId = trustAnchor.key().asLong();
        Locks.locked((Lock)this.dataLock.writeLock(), () -> (RoaPrefixesAndRouterCertificates)this.validatedObjectsByTrustAnchor.remove(trustAnchorId));
        this.notifyListeners();
    }

    public ValidatedObjects<RoaPrefix> findCurrentlyValidatedRoaPrefixes() {
        return this.findCurrentlyValidatedRoaPrefixes(null, null, null);
    }

    public ValidatedObjects<RoaPrefix> findCurrentlyValidatedRoaPrefixes(SearchTerm searchTerm, Sorting sorting, Paging paging) {
        if (paging == null) {
            paging = Paging.of((Long)0L, (Long)Long.MAX_VALUE);
        }
        if (sorting == null) {
            sorting = Sorting.of((Sorting.By)Sorting.By.TA, (Sorting.Direction)Sorting.Direction.ASC);
        }
        Sorting finalSorting = sorting;
        Paging finalPaging = paging;
        return (ValidatedObjects)Locks.locked((Lock)this.dataLock.readLock(), () -> ValidatedObjects.of((long)this.countRoaPrefixes(searchTerm), (Stream)this.findRoaPrefixes(searchTerm, finalSorting, finalPaging)));
    }

    public ValidatedObjects<RouterCertificate> findCurrentlyValidatedRouterCertificates() {
        return (ValidatedObjects)Locks.locked((Lock)this.dataLock.readLock(), () -> ValidatedObjects.of((long)this.countRouterCertificates(), (Stream)this.findRouterCertificates()));
    }

    public void addListener(Consumer<Collection<RoaPrefixesAndRouterCertificates>> listener) {
        Locks.locked((Lock)this.dataLock.writeLock(), () -> {
            this.listeners.add(listener);
            listener.accept(this.validatedObjectsByTrustAnchor.values());
        });
    }

    private ImmutableSet<RouterCertificate> toRouterCertificates(TrustAnchorData trustAnchor, Stream<RpkiObject> roaCertStream) {
        Base64.Encoder encoder = Base64.getEncoder();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        roaCertStream.map(object -> object.get(X509RouterCertificate.class, ValidationResult.withLocation((String)"temporary"))).filter(Optional::isPresent).map(Optional::get).forEach(certificate -> {
            ImmutableList asns = ImmutableList.copyOf((Collection)X509CertificateUtil.getAsns((X509Certificate)certificate.getCertificate()));
            String ski = encoder.encodeToString(X509CertificateUtil.getSubjectKeyIdentifier((X509Extension)certificate.getCertificate()));
            String pkInfo = X509CertificateUtil.getEncodedSubjectPublicKeyInfo((X509Certificate)certificate.getCertificate());
            builder.add((Object)RouterCertificate.of((TrustAnchorData)trustAnchor, (ImmutableList)asns, (String)ski, (String)pkInfo));
        });
        return builder.build();
    }

    private ImmutableSet<RoaPrefix> toRoaPrefixes(Tx.Read tx, TrustAnchorData trustAnchor, Stream<RpkiObject> roaStream) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        roaStream.flatMap(object -> {
            ImmutableSortedSet locations = ImmutableSortedSet.copyOf((Collection)this.rpkiObjects.getLocations(tx, object.key()));
            return object.getRoaPrefixes().stream().map(prefix -> Pair.of((Object)locations, (Object)prefix));
        }).forEach(data -> {
            net.ripe.rpki.validator3.storage.data.RoaPrefix prefix = (net.ripe.rpki.validator3.storage.data.RoaPrefix)data.getRight();
            builder.add((Object)RoaPrefix.of((TrustAnchorData)trustAnchor, (long)prefix.getAsn(), (IpRange)prefix.getPrefix(), (Integer)prefix.getMaximumLength(), (int)prefix.getEffectiveLength(), (ImmutableSortedSet)((ImmutableSortedSet)data.getLeft())));
        });
        return builder.build();
    }

    private ImmutableList<RoaPrefixesAndRouterCertificates> validatedObjects() {
        return (ImmutableList)Locks.locked((Lock)this.dataLock.readLock(), () -> ImmutableList.copyOf(this.validatedObjectsByTrustAnchor.values()));
    }

    private int countRouterCertificates() {
        return this.validatedObjects().stream().mapToInt(x -> x.getRouterCertificates().size()).sum();
    }

    private Stream<RouterCertificate> findRouterCertificates() {
        return this.validatedObjects().stream().flatMap(x -> x.getRouterCertificates().stream());
    }

    private long countRoaPrefixes(SearchTerm searchTerm) {
        return this.validatedObjects().stream().flatMap(x -> x.getRoaPrefixes().stream()).filter(prefix -> searchTerm == null || searchTerm.test(prefix)).count();
    }

    private Stream<RoaPrefix> findRoaPrefixes(SearchTerm searchTerm, Sorting sorting, Paging paging) {
        return this.validatedObjects().parallelStream().flatMap(x -> x.getRoaPrefixes().stream()).filter(prefix -> searchTerm == null || searchTerm.test(prefix)).sorted(sorting.comparator()).skip(Math.max(0L, paging.getStartFrom())).limit(Math.max(1L, paging.getPageSize()));
    }

    private void notifyListeners() {
        Locks.locked((Lock)this.dataLock.readLock(), () -> this.listeners.forEach(listener -> listener.accept(this.validatedObjectsByTrustAnchor.values())));
    }
}

