/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.slurm;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.slurm.dtos.Slurm;
import net.ripe.rpki.validator3.api.slurm.dtos.SlurmExt;
import net.ripe.rpki.validator3.storage.encoding.GsonCoder;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlurmStore {
    private static final Logger log = LoggerFactory.getLogger(SlurmStore.class);
    private final String slurmFileName;
    private final Gson gson;
    private SlurmExt slurmExt;
    private final AtomicLong idSeq = new AtomicLong(0L);

    public SlurmStore(String path) {
        File slurmFile = new File(path, "slurm.json");
        this.slurmFileName = slurmFile.getAbsolutePath();
        this.gson = GsonCoder.getPrettyGson();
        if (slurmFile.exists()) {
            log.info("SLURM file {} already exists, reading it", (Object)this.slurmFileName);
            this.setIdSequenceStartValue(this.read());
        } else {
            if (!new File(path).isDirectory()) {
                throw new RuntimeException("Cannot write to the SLURM file, probably the path " + path + " doesn't exist");
            }
            log.info("SLURM file {} doesn't exist, creating a new one", (Object)slurmFile.getAbsolutePath());
            this.save(new SlurmExt());
            this.setIdSequenceStartValue(this.read());
        }
    }

    public synchronized void save(SlurmExt slurm) {
        this.slurmExt = slurm.copy();
        String tmp = this.slurmFileName + ".tmp";
        try {
            byte[] bytes = this.gson.toJson((Object)this.slurmExt.toSlurm()).getBytes(StandardCharsets.UTF_8);
            try (FileOutputStream fos = new FileOutputStream(tmp);){
                fos.write(bytes);
                new File(this.slurmFileName).delete();
                Files.move(Paths.get(tmp, new String[0]), Paths.get(this.slurmFileName, new String[0]), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            new File(tmp).delete();
        }
    }

    public synchronized SlurmExt read() {
        if (this.slurmExt != null) {
            return this.slurmExt;
        }
        try {
            Slurm slurm = (Slurm)this.gson.fromJson((Reader)new FileReader(new File(this.slurmFileName)), Slurm.class);
            this.slurmExt = SlurmExt.fromSlurm((Slurm)slurm, (AtomicLong)this.idSeq);
            return this.slurmExt;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized <T> T updateWith(Function<SlurmExt, T> f) {
        SlurmExt s = this.read();
        T t = f.apply(s);
        this.save(s);
        return t;
    }

    public synchronized void updateWith(Consumer<SlurmExt> c) {
        SlurmExt s = this.read();
        c.accept(s);
        this.save(s);
    }

    private void setIdSequenceStartValue(SlurmExt s) {
        long maxId = Stream.of(s.getBgpsecAssertions(), s.getBgpsecFilters(), s.getPrefixAssertions(), s.getPrefixFilters()).map(s1 -> s1.keySet().stream().max(Long::compareTo).orElse(0L)).max(Long::compareTo).orElse(0L);
        this.idSeq.set(maxId + 1L);
    }

    public long nextId() {
        return this.idSeq.getAndIncrement();
    }

    synchronized void importSlurm(Slurm slurm) {
        this.save(SlurmExt.fromSlurm((Slurm)slurm, (AtomicLong)this.idSeq));
    }

    void writeTo(OutputStream out) throws IOException {
        IOUtils.copy((InputStream)new FileInputStream(new File(this.slurmFileName)), (OutputStream)out);
    }

    public AtomicLong getIdSeq() {
        return this.idSeq;
    }
}

