/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain.pdus;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;

public final class CacheResponsePdu
implements Pdu {
    public static final int PDU_TYPE = 3;
    public static final int PDU_LENGTH = 8;
    private final ProtocolVersion protocolVersion;
    private final short sessionId;

    public int length() {
        return 8;
    }

    public void write(ByteBuf out) {
        out.writeByte((int)this.protocolVersion.getValue()).writeByte(3).writeShort((int)this.sessionId).writeInt(this.length());
    }

    @ConstructorProperties(value={"protocolVersion", "sessionId"})
    private CacheResponsePdu(ProtocolVersion protocolVersion, short sessionId) {
        this.protocolVersion = protocolVersion;
        this.sessionId = sessionId;
    }

    public static CacheResponsePdu of(ProtocolVersion protocolVersion, short sessionId) {
        return new CacheResponsePdu(protocolVersion, sessionId);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public short getSessionId() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheResponsePdu)) {
            return false;
        }
        CacheResponsePdu other = (CacheResponsePdu)o;
        if (this.getSessionId() != other.getSessionId()) {
            return false;
        }
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        return !(this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSessionId();
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        return result;
    }

    public String toString() {
        return "CacheResponsePdu(protocolVersion=" + this.getProtocolVersion() + ", sessionId=" + this.getSessionId() + ")";
    }
}

