#include <registers_types.h>

const char *RegisterTypeNames[MAX_UNITS] = {
    [PMC] = "Core-local general purpose counters",
    [IPMC] = "Core-local general purpose counters (Icestorm)",
    [FPMC] = "Core-local general purpose counters (Firestorm)",
    [FIXED] = "Fixed counters",
    [PERF] = "Perf counters",
    [THERMAL] = "Thermal",
    [VOLTAGE] = "Voltage of hardware thread",
    [METRICS] = "Performance metrics provided by Intel systems starting with Intel Icelake",
    [POWER] = "Energy/Power counters (RAPL)",
    [UNCORE] = "Socket-local general/fixed purpose counters",
    [MBOX0] = "Memory Controller 0 Channel 0",
    [MBOX1] = "Memory Controller 0 Channel 1",
    [MBOX2] = "Memory Controller 0 Channel 2",
    [MBOX3] = "Memory Controller 0 Channel 3",
    [MBOX4] = "Memory Controller 1 Channel 0",
    [MBOX5] = "Memory Controller 1 Channel 1",
    [MBOX6] = "Memory Controller 1 Channel 2",
    [MBOX7] = "Memory Controller 1 Channel 3",
    [MBOX0FIX] = "Memory Controller 0 Channel 0 Fixed Counter",
    [MBOX1FIX] = "Memory Controller 0 Channel 1 Fixed Counter",
    [MBOX2FIX] = "Memory Controller 0 Channel 2 Fixed Counter",
    [MBOX3FIX] = "Memory Controller 0 Channel 3 Fixed Counter",
    [MBOX4FIX] = "Memory Controller 1 Channel 0 Fixed Counter",
    [MBOX5FIX] = "Memory Controller 1 Channel 1 Fixed Counter",
    [MBOX6FIX] = "Memory Controller 1 Channel 2 Fixed Counter",
    [MBOX7FIX] = "Memory Controller 1 Channel 3 Fixed Counter",
    [MBOX0TMP] = "PP0/PP1 Temperature Sensor",
#ifdef _ARCH_PPC
    [BBOX0] = "Memory controller synchronous (port 0 & 1)",
    [BBOX1] = "Memory controller synchronous (port 2 & 3)",
#else
    [BBOX0] = "Home Agent box 0",
    [BBOX1] = "Home Agent box 1",
#endif
    [RBOX0] = "Routing box 0",
    [RBOX1] = "Routing box 1",
    [RBOX2] = "Routing box 2",
    [WBOX] = "Power control box",
    [WBOX0FIX] = "Power control box fixed counter 0",
    [WBOX1FIX] = "Power control box fixed counter 1",
    [WBOX2FIX] = "Power control box fixed counter 2",
    [WBOX3FIX] = "Power control box fixed counter 3",
#ifdef _ARCH_PPC
    [SBOX0] = "PowerBus",
#else
    [SBOX0] = "QPI Link Layer box 0",
#endif
    [SBOX1] = "QPI Link Layer box 1",
    [SBOX2] = "QPI Link Layer box 2",
    [SBOX3] = "QPI Link Layer box 3",
    [SBOX0FIX] = "QPI Link Layer box fixed 0",
    [SBOX1FIX] = "QPI Link Layer box fixed 1",
    [SBOX2FIX] = "QPI Link Layer box fixed 2",
    [SBOX3FIX] = "QPI Link Layer box fixed 3",
    [CBOX0] = "Caching Agent box 0",
    [CBOX1] = "Caching Agent box 1",
    [CBOX2] = "Caching Agent box 2",
    [CBOX3] = "Caching Agent box 3",
    [CBOX4] = "Caching Agent box 4",
    [CBOX5] = "Caching Agent box 5",
    [CBOX6] = "Caching Agent box 6",
    [CBOX7] = "Caching Agent box 7",
    [CBOX8] = "Caching Agent box 8",
    [CBOX9] = "Caching Agent box 9",
    [CBOX10] = "Caching Agent box 10",
    [CBOX11] = "Caching Agent box 11",
    [CBOX12] = "Caching Agent box 12",
    [CBOX13] = "Caching Agent box 13",
    [CBOX14] = "Caching Agent box 14",
    [CBOX15] = "Caching Agent box 15",
    [CBOX16] = "Caching Agent box 16",
    [CBOX17] = "Caching Agent box 17",
    [CBOX18] = "Caching Agent box 18",
    [CBOX19] = "Caching Agent box 19",
    [CBOX20] = "Caching Agent box 20",
    [CBOX21] = "Caching Agent box 21",
    [CBOX22] = "Caching Agent box 22",
    [CBOX23] = "Caching Agent box 23",
    [CBOX24] = "Caching Agent box 24",
    [CBOX25] = "Caching Agent box 25",
    [CBOX26] = "Caching Agent box 26",
    [CBOX27] = "Caching Agent box 27",
    [CBOX28] = "Caching Agent box 28",
    [CBOX29] = "Caching Agent box 29",
    [CBOX30] = "Caching Agent box 30",
    [CBOX31] = "Caching Agent box 31",
    [CBOX32] = "Caching Agent box 32",
    [CBOX33] = "Caching Agent box 33",
    [CBOX34] = "Caching Agent box 34",
    [CBOX35] = "Caching Agent box 35",
    [CBOX36] = "Caching Agent box 36",
    [CBOX37] = "Caching Agent box 37",
    [CBOX38] = "Caching Agent box 38",
    [CBOX39] = "Caching Agent box 39",
    [CBOX40] = "Caching Agent box 40",
    [CBOX41] = "Caching Agent box 41",
    [CBOX42] = "Caching Agent box 42",
    [CBOX43] = "Caching Agent box 43",
    [CBOX44] = "Caching Agent box 44",
    [CBOX45] = "Caching Agent box 45",
    [CBOX46] = "Caching Agent box 46",
    [CBOX47] = "Caching Agent box 47",
    [CBOX48] = "Caching Agent box 48",
    [CBOX49] = "Caching Agent box 49",
    [CBOX50] = "Caching Agent box 50",
    [CBOX51] = "Caching Agent box 51",
    [CBOX52] = "Caching Agent box 52",
    [CBOX53] = "Caching Agent box 53",
    [CBOX54] = "Caching Agent box 54",
    [CBOX55] = "Caching Agent box 55",
    [CBOX56] = "Caching Agent box 56",
    [CBOX57] = "Caching Agent box 57",
    [CBOX58] = "Caching Agent box 58",
    [CBOX59] = "Caching Agent box 59",
    [PBOX] = "Physical Layer box 0",
    [PBOX1] = "Physical Layer box 1",
    [PBOX2] = "Physical Layer box 2",
    [PBOX3] = "Physical Layer box 3",
    [PBOX4] = "Physical Layer box 4",
    [PBOX5] = "Physical Layer box 5",
    [UBOX] = "System Configuration box",
    [UBOXFIX] = "System Configuration box fixed counter",
    [IBOX0] = "Coherency Maintainer for IIO traffic",
    [IBOX1] = "Coherency Maintainer for IIO traffic",
    [IBOX2] = "Coherency Maintainer for IIO traffic",
    [IBOX3] = "Coherency Maintainer for IIO traffic",
    [IBOX4] = "Coherency Maintainer for IIO traffic",
    [IBOX5] = "Coherency Maintainer for IIO traffic",
#ifdef _ARCH_PPC
    [QBOX0] = "Xlink 0",
    [QBOX1] = "Xlink 1",
    [QBOX2] = "Xlink 2",
#else
    [QBOX0] = "QPI Link Layer 0",
    [QBOX1] = "QPI Link Layer 1",
    [QBOX2] = "QPI Link Layer 2",
    [QBOX3] = "QPI Link Layer 3",
#endif
    [QBOX0FIX] = "QPI Link Layer rate status 0",
    [QBOX1FIX] = "QPI Link Layer rate status 1",
    [EUBOX0] = "Embedded DRAM controller 0",
    [EUBOX1] = "Embedded DRAM controller 1",
    [EUBOX2] = "Embedded DRAM controller 2",
    [EUBOX3] = "Embedded DRAM controller 3",
    [EUBOX4] = "Embedded DRAM controller 4",
    [EUBOX5] = "Embedded DRAM controller 5",
    [EUBOX6] = "Embedded DRAM controller 6",
    [EUBOX7] = "Embedded DRAM controller 7",
    [EUBOX0FIX] = "Embedded DRAM controller 0 fixed counter",
    [EUBOX1FIX] = "Embedded DRAM controller 1 fixed counter",
    [EUBOX2FIX] = "Embedded DRAM controller 2 fixed counter",
    [EUBOX3FIX] = "Embedded DRAM controller 3 fixed counter",
    [EUBOX4FIX] = "Embedded DRAM controller 4 fixed counter",
    [EUBOX5FIX] = "Embedded DRAM controller 5 fixed counter",
    [EUBOX6FIX] = "Embedded DRAM controller 6 fixed counter",
    [EUBOX7FIX] = "Embedded DRAM controller 7 fixed counter",
    [EDBOX0] = "Embedded DRAM controller 0",
    [EDBOX1] = "Embedded DRAM controller 1",
    [EDBOX2] = "Embedded DRAM controller 2",
    [EDBOX3] = "Embedded DRAM controller 3",
    [EDBOX4] = "Embedded DRAM controller 4",
    [EDBOX5] = "Embedded DRAM controller 5",
    [EDBOX6] = "Embedded DRAM controller 6",
    [EDBOX7] = "Embedded DRAM controller 7",
    [EDBOX0FIX] = "Embedded DRAM controller 0 fixed counter",
    [EDBOX1FIX] = "Embedded DRAM controller 1 fixed counter",
    [EDBOX2FIX] = "Embedded DRAM controller 2 fixed counter",
    [EDBOX3FIX] = "Embedded DRAM controller 3 fixed counter",
    [EDBOX4FIX] = "Embedded DRAM controller 4 fixed counter",
    [EDBOX5FIX] = "Embedded DRAM controller 5 fixed counter",
    [EDBOX6FIX] = "Embedded DRAM controller 6 fixed counter",
    [EDBOX7FIX] = "Embedded DRAM controller 7 fixed counter",
    [NUM_UNITS] = "Maximally usable register types",
    [NOTYPE] = "No Type, used for skipping unavailable counters"
};
