// Persistence of Vision Ray Tracer Scene Description File
// File: rf_office_phone.inc
// Vers: 3.6
// Desc: Office Telephone
// Date: Nov 12, 2006 
// Auth: Rob Fitzel
// Unit: feet


// based on the Aastra 9417 CW (Nortel Networks) phone
#declare office_phone_button_long = Round_Box_Merge (<0,0,0>,<0.75,0.1,0.25>,0.05);
#declare office_phone_button_small_square = Round_Box_Merge(<0,0,0>,<0.5,0.1,0.5>,0.05);
#declare office_phone_button_small_long   = Round_Box_Merge(<0,0,0>,<0.5,0.1,0.25>,0.05); 

#declare t_light_slider = 
texture {
 pigment {
   gradient x
   pigment_map {
     [0   rgb 0.5]
     [0.5 rgb 0.5]
     [0.5 rgb <0.722,0.341,0.392>]
     [1.0 rgb <0.722,0.341,0.392>] 
   }
 }
 scale 4
}


#declare t_office_phone_body = texture {pigment {rgb 0.1} };

#declare t_office_phone_cord = 
texture {
      pigment {
          radial color_map{[0.5 rgb 0][0.9 rgb 0.5]}
          frequency 50
        }
};


#declare office_phone = 

union {
  Round_Box_Merge(<1,0,0>,<8,1,8>,0.5) // mainbody
  Round_Box_Merge(<3,0,0.5>,<6.5,1.1,6.25>,0.05) // raised body

  // raised body buttons
  union {
    // numbers
    #local i=0;
    #while (i<3)
      #local j=0;      
      #while (j<4)      
        object {office_phone_button_small_square translate <3.2+0.7*i,0,1.5+0.7*j>}
        #local j=j+1;
      #end
      #local i=i+1;
    #end 
    
    // volume bar
    object {office_phone_button_small_square scale <4,1,1> translate <3.2,0,0.75>} 
               
    // hold
    object {office_phone_button_long translate <3.2,0,4.5> pigment {rgb <0.9,0.5,0.2>} }
    
    //release
    object {office_phone_button_small_long translate <4.6,0,4.5> pigment {rgb <0.9,0.3,0.2>} } 
    
    // side buttons on raised body
    #local i=0;
    #while (i<8)
      object {office_phone_button_long translate <5.5,0,0.75 + 0.52*i>
        #if (i<3)
          #pigment {rgb <0.541,0.788,0.749>}
        #end
      }
      #local i=i+1;
    #end
    
    // light and slider
    box {<3,0,5>,<6.5,0.1,5.5> texture {t_light_slider rotate <0,45,0> translate <2.5,0,0>} }
    
    // scroll buttons
    object {office_phone_button_long translate <3.2,0,5.75>}
    object {office_phone_button_long translate <5.5,0,5.75>}
    
    pigment {rgb 0.8}
    translate <0,1.1,0>
  }
  
  // side buttons
  #local i=0;
  #while (i<12)
    object {office_phone_button_long translate <6.7,1.0,0.75 + 0.52*i> pigment {rgb 0.8}}
    #local i=i+1;
  #end
    
  // screen
  difference {
    box {<0,0,0>,<3.5,1,1.5> texture {t_office_phone_body}}
    Round_Box_Merge(<0.25,0.9,0.25>,<3.25,1.1,1.25>,0.1)
    rotate <-35,0,0> 
    translate <3,0,6.25>
    texture {pigment {rgb <0.659,0.69,0.18>}}
  } 
  
  // receiver
  cylinder {<0.2,0,0>,<1.75,0,0> 3.5  scale  <1,0.25,1>  translate <1,1,4> clipped_by {plane {-y,1} } }
  
  // cord
  torus {5,0.5  texture {t_office_phone_cord} scale <0.2,0.5,1> rotate <20,0,0> rotate <-180,0,0> translate <1,0.25,2> }  
  
  rotate <-20,0,0>
  texture {t_office_phone_body} 
  

  
}; 
