// Persistence of Vision Ray Tracer Scene Description File
// File: rf_wfcr_textures.inc
// Vers: 3.6
// Desc: Textures for the Mission Control Center
// Date: Nov 12, 2006 
// Auth: Rob Fitzel
// Unit: feet


#declare included_rf_mcc_textures = 1;

#declare first_computer_screen_index = 23; // dependent on mcc_img.pov
#declare last_computer_screen_index  = 80; // dependent on mcc_img.pov 

#macro get_random_screen() 
    #local img_idx = int(RRand(first_computer_screen_index,last_computer_screen_index,msd)); 
    #local t_screen_img = concat("mcc_img",str(global_img_idx,0,0),".png"); 

    #local t_screen = texture{pigment{image_map{png t_screen_img  }scale <-1,1,1> } };
    t_screen
#end

#macro randbozo (col, sd, sc)
   pigment {
     bozo
     color_map {
       [0    rgb col*0.9 ]
       [0.5  rgb col*1.0 ]
       [1    rgb col*0.85]
     }
     scale sc
   }    
 
#end


// more contrast
#macro randbozo2 (col, sd, sc)
   pigment {
     bozo
     color_map {
       [0    rgb col*0.45 ]
       [0.5  rgb col*1.0 ]
       [1    rgb col*0.6]
     }
     scale sc
   }    
#end 

#macro randbozo3 (col, sd, sc) // less contrast
   pigment {
     bozo
     color_map {
       [0    rgb col*0.97 ]
       [0.5  rgb col*1.0 ]
       [1    rgb col*0.95]
     }
     scale sc
   }    
#end

#declare t_carpet = texture {randbozo2(<0.388,0.373,0.357>*1.3,1,0.01) finish {ambient 0 } normal {bumps scale 0.02}};  
#declare t_front_wall_black = texture {pigment {rgb 0.09}};
#declare t_white_wall = texture {pigment {rgb <0.745,0.702,0.694>}};

#declare t_logo_nasa = texture{pigment{image_map{png "mcc_img04.png"}}};
#declare t_logo_csa  = texture{pigment{image_map{png "mcc_img05.png"}}};
#declare t_logo_mcc  = texture{pigment{image_map{png "mcc_img06.png"}}};
#declare t_logo_mcc2 = texture{pigment{image_map{png "mcc_img07.png"}}}; 
#declare t_logo_esa  = texture{pigment{image_map{png "mcc_img08.png"}}};
#declare t_logo_rsa  = texture{pigment{image_map{png "mcc_img09.png"}}};      
#declare t_logo_jaxa = texture{pigment{image_map{png "mcc_img10.png"}}}; 
#declare t_status1   = texture{pigment{image_map{png "mcc_img21.png"}}};
#declare t_status2   = texture{pigment{image_map{png "mcc_img22.png"}}};


// projected logos on front wall
// TODO: play with ambient/diffuse settings once radiosity settings ready
#declare display_nasa_logo  = box {<0,0,-0.00001>,<1,1,1> texture {t_logo_nasa  finish {ambient rgb 0.5}} };
#declare display_csa_logo   = box {<0,0,-0.00001>,<1,1,1> texture {t_logo_csa   finish {ambient rgb 0.5}} };
#declare display_mcc_logo   = box {<0,0,-0.00001>,<1,1,1> texture {t_logo_mcc   finish {ambient rgb 0.5}} };
#declare display_mcc2_logo  = box {<0,0,-0.00001>,<1,1,1> texture {t_logo_mcc2  finish {ambient rgb 0.5}} };
#declare display_esa_logo   = box {<0,0,-0.00001>,<1,1,1> texture {t_logo_esa   finish {ambient rgb 0.5}} };
#declare display_rsa_logo   = box {<0,0,-0.00001>,<1,1,1> texture {t_logo_rsa   finish {ambient rgb 0.5}} };
#declare display_jaxa_logo  = box {<0,0,-0.00001>,<1,1,1> texture {t_logo_jaxa  finish {ambient rgb 0.5}} };
#declare display_status1    = box {<0,0,-0.00001>,<1,1,0> texture {t_status1    finish {ambient rgb 0.5}} };
#declare display_status2    = box {<0,0,-0.00001>,<1,1,0> texture {t_status2    finish {ambient rgb 0.5}} };

#declare t_status_board_text  = texture {pigment {rgb <1.0,0.973,0.435>} finish {ambient rgb 1}};
#declare t_big_front_display1 = texture {pigment {image_map{png "mcc_img12.png" interpolate 2}} finish {ambient rgb 0.8}};
#declare t_big_front_display2 = texture {pigment {image_map{png "mcc_img13.png" interpolate 2}} finish {ambient rgb 0.8}};
#declare t_big_front_display3 = texture {pigment {image_map{png "mcc_img14.png" interpolate 2}} finish {ambient rgb 0.8}};
 
#declare t_intercom_buttons = texture {pigment{image_map{png "mcc_img16.png" interpolate 2}} finish {ambient rgb 0.8}};
#declare t_logo_mission_operations = texture {pigment {image_map{png "mcc_img11.png"}}};
  
#declare t_print_earthrise = texture {pigment {image_map{png "mcc_img17.png" interpolate 2 }} finish {ambient rgb 0.9}};

#ifndef (draw_shuttle_print)
  #declare draw_shuttle_print = 0;
#end

#if (draw_shuttle_print)
  #declare t_print_shuttle   = texture {pigment {image_map{jpeg "print_shuttle.jpg"}} };
#end

#declare t_seal_cloth = texture {
  pigment {
    gradient y
    color_map {
      [0.02  rgb  <0.263,0.22,0.118>]
      [0.02  rgb   <0.196,0.122,0.18>]
    }
    scale 8
  }
};

// imagemaps generated by mcc_img.pov
#declare FlagCanada = "mcc_img01.png";
#declare FlagUSA    = "mcc_img02.png";
#declare NASASeal   = "mcc_img03.png";
#declare NASALogo   = "mcc_img04.png";
#declare FlagChile  = "mcc_img18.png";


// temporary
#declare t_flatscreen_img = texture {pigment {image_map{png "mcc_img11.png"}} finish {ambient 0.9}};



#declare t_pod_blue_light  =  texture {
                                //randbozo(<0.271,0.376,0.639>,1,0.1)
                                  randbozo(<0.337,0.404,0.561>,1,0.1)
                                // pigment {rgb <0.271,0.376,0.639>} 
                                //finish {ambient rgb 0 diffuse 0.5 specular 0.9 roughness 0.0001 metallic 
                             //   finish {ambient rgb 0 diffuse 0.5 specular 1 roughness 0.0005 metallic brilliance 1
                                  finish {ambient rgb 0.1 diffuse 0.5 specular 1 roughness 0.05 metallic brilliance 1
                                } 
                                }; 
#declare t_pod_blue_grill  =  texture {
                              //randbozo(<0.271,0.376,0.639>*0.8,1,0.1)
                                randbozo(<0.337,0.404,0.561>*0.8,1,0.1)
                              //pigment {rgb <0.271,0.376,0.639>*0.8} 
                              finish {ambient rgb 0.1 diffuse 0.5 specular 1 roughness 0.05 metallic brilliance 1
                               }
                              }; 

#declare t_pod_blue_dark  = texture { 
                            randbozo(<0.322,0.298,0.478>*0.8,1,0.1)
                           // pigment {rgb <0.322,0.298,0.478>} 
                            //finish {ambient rgb 0 diffuse 0.5 specular 0.5 roughness 0.001 metallic}
                             finish {ambient rgb 0.1 diffuse 0.5 specular 1 roughness 0.05 metallic brilliance 1
                             }
                            }; 
#declare t_pod_intercom_blue = texture {pigment {rgb <0.271,0.376,0.639>*0.7} finish {phong 1 phong_size 100}};  // slightly darker than t_pod_blue_light
#declare t_pod_intercom_gray = texture {pigment {rgb 0.3} finish{specular 0.5 roughness 0.001}};
#declare t_pod_intercom_black= texture {pigment {rgb 0} finish {phong 1 phong_size 60}};

#declare t_pod_black = texture {pigment {rgb 0} finish {phong 1 phong_size 100}};
/*
#declare t_pod_blue_grill = // gradient produces a moire pattern
  texture {
    gradient z
    texture_map {
      [0.7  t_pod_blue_light]
      [0.7  t_pod_blue_dark]
      }
    scale 0.1
  };
   
#declare t_pod_blue_grill = texture {t_pod_blue_dark};  
*/  
                                                
#declare t_pod_desktop_white = texture {pigment {rgb <0.69,0.714,0.686>}};
#declare t_pod_desktop =
  texture {
    gradient y
    texture_map {
      [0    t_pod_desktop_white]
      [0.1  t_pod_black]
      [0.9  t_pod_black]
      [0.9  t_pod_desktop_white]
    }
  };            

#declare t_computer_screen_frame = texture {pigment {rgb 0.5}};

#declare t_binder_cover = texture {pigment {rgb <0.682,0.663,0.494>}};
#declare t_white_paper = texture {pigment {rgb 0.9}};
#declare t_blue_paper  = texture {pigment {rgb <0.663,0.792,0.816>*0.9} };
                                                                                                 // orig 0.5
#declare t_white_paper = texture {pigment {image_map {png "mcc_img19.png"}} finish {ambient 0 diffuse 0.6} rotate x*90 scale <8.5,1,11>};
 
#declare t_blue_paper  = texture {pigment {image_map {png "mcc_img20.png"}} finish {ambient 0 diffuse 0.5} rotate x*90 scale <8.5,1,11>};

#declare t_page_text1  = texture {pigment {dents color_map {[0.2 rgb 0.2][0.2 rgb 0.9]}} scale 0.2};
#declare t_page_clear  = texture {pigment {rgbt 1}};   
#declare t_page_text  = texture {dents texture_map {[0.2 t_page_text1][0.2 t_page_clear]} scale 0.5};

#declare t_page_lines_of_text  =
texture {
  gradient z
  texture_map {
    [0.4  t_page_clear]
    [0.4  t_page_text]
  } 
  scale 0.02
}; 

#declare t_page_block_of_text = 
texture {
  gradient z
  texture_map {
    [0.1  t_page_clear] // top border
    [0.1  t_page_lines_of_text] 
    
    [0.3  t_page_lines_of_text]  // blank line to denote paragraph
    [0.3  t_page_clear]
    [0.32 t_page_clear]
    [0.32 t_page_lines_of_text]
    
    
    [0.5  t_page_lines_of_text]  // blank line to denote paragraph
    [0.5  t_page_clear]
    [0.52 t_page_clear]
    [0.52 t_page_lines_of_text] 
    
    [0.6  t_page_lines_of_text]  // blank line to denote paragraph
    [0.6  t_page_clear]
    [0.62 t_page_clear]
    [0.62 t_page_lines_of_text] 

    [0.8  t_page_lines_of_text]  // blank line to denote paragraph
    [0.8  t_page_clear]
    [0.82 t_page_clear]
    [0.82 t_page_lines_of_text] 
    
    [0.9  t_page_lines_of_text]
    [0.9  t_page_clear]
  } 

};  

#declare t_paper_text = 
texture {
  gradient x
  texture_map {
    [0.08  t_page_clear] // top border
    [0.08  t_page_block_of_text]
    [0.92  t_page_block_of_text]
    [0.92  t_page_clear]
  }
  scale <9,1,1> 
}; 

// override 
/*
#declare t_paper_text = 
texture {
  gradient z
    texture_map {
    [0.1 t_page_clear]
    [0.1 t_page_text1]
    [0.9 t_page_text1]
    [1.0 t_page_clear]
    }
  };
*/  


/*
#declare t_blue_paper_text = 
texture {
  gradient x
  texture_map {
    [0.08  t_page_blue] // top border
    [0.08  t_page_block_of_text]
    [0.92  t_page_block_of_text]
    [0.92  t_page_blue]
  }
  scale <9,1,1> 
}; 
*/

