// Persistence of Vision Ray Tracer Scene Description File
// File: rf_flat_panel_monitor.inc
// Vers: 3.6
// Desc: Computer Keyboard
// Date: Nov 18, 2006
// Auth: Rob Fitzel
// Units: inches
// Macros: flatscreen(img,xfrm)

#include "shapes.inc"
#include "metals.inc" 

#declare t_screen_off = texture{pigment{rgb 0}}; // use this texture if you don't want to display an image

#declare t_flatscreen_black = texture {pigment {rgb 0.15} finish {specular 1 roughness 0.01}};
#macro flatscreen(txt,xfrm)
  union {
    cylinder {<-3,0,0>,<3,0,0> 1.5 scale <1,0.2,1>}
    box {<-1.8,0,0>,<1.8,2,-0.5>}
    
    union { // monitor
      difference {
        object {Round_Box_Merge(<-6,0,0>,<6,9.3,-0.5>,0.2) texture {t_flatscreen_black} }
        box {<0,0,0>,<1,1,0.2> scale <11,7.7,1> translate <-5.5,1.3,-0.1>} 
        texture {t_screen_off}
        }
    //    box {<0,0,0>,<1,1,0.001> texture {txt rotate y*180 finish {specular 1 roughness 0.01} } scale <11,7.7,1> translate <-5.5,1.3,-0.09> }
     box {<0,0,0>,<1,1,0.001> texture {txt rotate y*180 finish {specular 1 roughness 0.01} } scale <10.5,7.5,1> translate <-5.25,1.4,-0.09> }
      // buttons
      union {  
        cylinder {< 0,0,0>,< 0,0,0.1> 0.15 }  
        cylinder {< 1,0,0>,< 1,0,0.1> 0.1 }  
        cylinder {< 2,0,0>,< 2,0,0.1> 0.1 }  
        cylinder {<-1,0,0>,<-1,0,0.1> 0.1 }  
        cylinder {<-2,0,0>,<-2,0,0.1> 0.1 }  
        texture {T_Chrome_1A} 
        translate y*0.7
        }
      box {<-2,0,-0.5>,<2,3,-1>} // back of screen
      translate <0,2,1> 
      rotate -x*10
    }
    
    texture {t_flatscreen_black}
    transform {xfrm}
  }
#end


