// Persistence of Vision Ray Tracer Scene Description File
// File: rf_binder.pov
// Vers: 3.6
// Desc: Template scene
// Date: May 20, 2006 
// Auth: Rob Fitzel
// Units: feet

#declare included_rf_binders =1;

 
#ifndef (Metals_Inc_Temp)
  #include "metals.inc"
#end 

#declare binder_spine = // inches  // cover untextured
union { 
  
  // covers
  box {<0,0,0>,<1,11.5,0.2> } // spine
  box {<0,0,0>,<0.1,11.5,8> }
  box {<1,0,0>,<0.9,11.5,8> }
  
  // create a TrueType text shape
  text {
    ttf             // font type (only TrueType format for now)
    "arial.ttf",  // Microsoft Windows-format TrueType font file name
    " S0007",      // the string to create
    0.001,              // the extrusion depth
    0               // inter-character spacing  
    scale 0.6
    rotate z*270 
    translate <0.3,7,-0.001>
    texture {pigment {rgb 0}}
  }

  
  
  // paper
  box {<0.1,0.25,0.4>,<0.9,11.25,8> texture {pigment {rgb 1}}}
  
  cylinder {<0.5,2,0>,<0.5,2,-0.01> 0.2 texture {T_Chrome_2A}}
  cylinder {<0.5,9.5,0>,<0.5,9.5,-0.01> 0.2 texture {T_Chrome_2A}}
}; 


#declare binder = // note: no texture - closed
union {
  box {<0,0,0>,<10,0.05,11.5>}
  box {<0,0,0>,<0.05,2,11.5>}
  box {<0,0,0>,<10,0.05,11.5> rotate <0,0,-10> translate <0,2,0>} // top cover
  box {<0.1,0,0.5>,<1.9,0.05,11> texture {T_Chrome_2A} }
  box {<1,0.2,0.25>,<9,0.4,10.25> texture {pigment {rgb 1}} }   
  
  cylinder {<0,1,2>,<-0.1,1,2> 0.2 texture {T_Chrome_2A}}
  cylinder {<0,1,9.5>,<-0.1,1,9.5> 0.2 texture {T_Chrome_2A}}

  
  // rings
  torus {0.8,0.1 rotate <90,0,0> translate <1,0.8,1.5> texture {T_Chrome_2A} } 
  torus {0.8,0.1 rotate <90,0,0> translate <1,0.8,5.75> texture {T_Chrome_2A} }
  torus {0.8,0.1 rotate <90,0,0> translate <1,0.8,10> texture {T_Chrome_2A} }

}; 

#declare binder_all =0;
#declare binder_left = 1;
#declare binder_right = 2;

// ctxt - cover texture, ptxt - paper texture, lp/rp left/right paper percentage of full, br = draw right side, bl = draw left half xfrm - transform
#macro binder_open(ctxt,ptxt,lp,rp,br,bl,xfrm)  // cover untextured

      
  
  union { 
     
    union { 
      #if (br)
        box {< 1,0,0>,<11,0.05,11.5>} // covers
      #end
      #if (bl)
        box {<-1,0,0>,<-11,0.1,11.5>}
      #end
      box {<-1,0,0>,<1,0.05,11.5>} // spine 
      box {<-0.8,0.05,0.5>,<0.8,0.06,11> texture {T_Chrome_4A} }// ring holder
      texture {ctxt}
      }
    // rings
    torus {0.8,0.1 rotate <90,0,0> translate <0,0.8,1.5> texture {T_Chrome_4A} } 
    torus {0.8,0.1 rotate <90,0,0> translate <0,0.8,5.75> texture {T_Chrome_4A} }
    torus {0.8,0.1 rotate <90,0,0> translate <0,0.8,10> texture {T_Chrome_4A} }
    
    // paper
      #if (bl)
        box {<-0.4,0.05,0.25>,<-8.9,1.5*lp,11.25> texture {ptxt}} // left side
      #end
      #if (br)
        box {< 0.4,0.05,0.25>,< 8.9,1.5*rp,11.25> texture {ptxt}} // right side
      #end
    transform {xfrm}
  }
#end 
