#ifdef(ChessPieces_Inc_Temp)
// do nothing
#else
#declare ChessPieces_Inc_Temp = version;

#ifdef(View_POV_Include_Stack)
#   debug "including chesspieces.inc\n"
#end
                    
#include "colors.inc"         
#include "stones.inc"
#include "Woods.inc"
#include "textures.inc"
     
#declare Base1 = object {
  lathe {
    cubic_spline
//    quadratic_spline
//    linear_spline
    9      
    <0.00, 0.00>
    <0.75, 0.00>
    <0.75, 0.25>
    <0.35, 0.50>
    <0.35, 0.80>  
    <0.60, 0.85>
    <0.60, 0.95>
    <0.35, 1.00>
    <0.00, 1.00>
    }   
  }                
                
#declare Base2 = object{
  lathe {
    cubic_spline
    10
    <0.00, 0.00>
    <0.65, 0.00>
    <0.65, 0.25>
    <0.25, 0.50>
    <0.25, 0.60>
    <0.50, 0.65>
    <0.50, 0.75>
    <0.25, 0.80>
    <0.15, 0.85>
    <0.00, 0.85>
    }
  }       
                                
#declare Base3 = object {
  lathe {
    cubic_spline
//    linear_spline
    9      
    <0.0, 0.0>
    <0.5, 0.0>
    <0.5, 0.25>
    <0.15, 0.5>
    <0.15, 0.75>
    <0.25, 0.75>
    <0.35, 0.80>
    <0.25, 0.85>
    <0.0,  0.85>
    }   
  }

#declare Black_Pigment =
  pigment {
    Blood_Marble
    scale 0.5
    }

#declare White_Pigment =
  pigment {
    White_Marble
    scale 0.5
    }

#declare Black_Finish =
  finish {
    ambient 0.1
    diffuse 0.6
    phong 0.6
    phong_size 7
    reflection 0.2
    }

#declare White_Finish =
  finish {
    ambient 0.2
    diffuse .5
    phong 0.6
    phong_size 7
    reflection 0.1
    }
        
#declare Pawn = union{
  object {Base3}
  sphere {
    <0, 1.05, 0>, 0.3
    }     
  }

#declare White_Pawn = object {
  Pawn
  pigment {White_Pigment}
  finish {White_Finish}
  }
  
#declare Black_Pawn = object {
  Pawn
  pigment {Black_Pigment}
  finish {Black_Finish}
  }
                
#declare Rook_Wall = object {
  box {         
    <0.45, 1.50, 0.10> 
    <0.60, 1.65,-0.10>
    }            
  }
        
#declare Rook = union{
  object {Base1}        
  lathe {
    linear_spline
//    cubic_spline
    6
    <0.00, 1.00>
    <0.35, 1.00>
    <0.35, 1.10>
    <0.65, 1.20>
    <0.65, 1.50>
    <0.00, 1.50>
    }
  object {Rook_Wall rotate <0,   0, 0>}
  object {Rook_Wall rotate <0,  30, 0>}
  object {Rook_Wall rotate <0,  60, 0>}
  object {Rook_Wall rotate <0,  90, 0>}
  object {Rook_Wall rotate <0, 120, 0>}
  object {Rook_Wall rotate <0, 150, 0>}
  object {Rook_Wall rotate <0, 180, 0>}
  object {Rook_Wall rotate <0, 210, 0>}
  object {Rook_Wall rotate <0, 240, 0>}
  object {Rook_Wall rotate <0, 270, 0>}
  object {Rook_Wall rotate <0, 300, 0>}
  object {Rook_Wall rotate <0, 330, 0>}
  }
                        

#declare White_Rook = object {
  Rook
  pigment {White_Pigment}
  finish {White_Finish}
  }

#declare Black_Rook = object {
  Rook
  pigment {Black_Pigment}
  finish {Black_Finish}
  }

#declare King = union{
  object {Base1}
  lathe {
//    linear_spline
    cubic_spline
    8
    <0.00, 1.00>
    <0.35, 1.00>
    <0.25, 1.05>
    <0.15, 1.50>
    <0.30, 1.55>
    <0.30, 1.65>
    <0.00, 1.65>
    <0.05, 1.66>
    }
  box {
    <-0.10, 1.65, -0.10>
    < 0.10, 1.95,  0.10>
    }
  box {
    <-0.20, 1.80, -0.10>
    < 0.20, 1.90,  0.10>
    }
  }

#declare White_King = object {
  King
  pigment {White_Pigment}
  finish {White_Finish}
  }

#declare Black_King = object {
  King
  pigment {Black_Pigment}
  finish {Black_Finish}
  }
                                
#declare Queen = union{
  object {Base1}
  lathe {
//    linear_spline
    cubic_spline
    10
    <0.00, 1.00>
    <0.35, 1.00>
    <0.25, 1.05>
    <0.15, 1.50>
    <0.30, 1.55>
    <0.30, 1.65>
    <0.15, 1.65>
    <0.40, 1.85>
    <0.00, 1.85>
    <0.05, 1.86>
    }
  sphere {
    <0.40, 1.90, 0>, 0.05
    }
  sphere {
    <-0.40, 1.90, 0>, 0.05
    }
  sphere {
    <0, 1.90, 0.40>, 0.05
    }
  sphere {
    <0, 1.90, -0.40>, 0.05
    }                 
  sphere {
    <0.283, 1.90, 0.283>, 0.05
    }
  sphere {
    <-0.283, 1.90, 0.283>, 0.05
    }
  sphere {
    <0.283, 1.90, -0.283>, 0.05
    }
  sphere {
    <-0.283, 1.90, -0.283>, 0.05
    }       
  sphere {
    <0, 1.95, 0>, 0.10
    }
  }

#declare White_Queen = object {
  Queen
  pigment {White_Pigment}
  finish {White_Finish}
  }

#declare Black_Queen = object {
  Queen
  pigment {Black_Pigment}
  finish {Black_Finish}
  }
       
#declare Bishop = union{
  object {Base2}
  sphere {
    <0, 0, 0>, 0.20
    scale <1, 2, 1>
    translate <0, 1.1, 0>
    }             
  sphere {
    <0, 1.55, 0>, 0.075
    } 
  }                                

#declare White_Bishop = object {
  Bishop
  pigment {White_Pigment}
  finish {White_Finish}
  }

#declare Black_Bishop = object {
  Bishop
  pigment {Black_Pigment}
  finish {Black_Finish}
  }                             
  
#local KE_Point1 = <0.00, 0.00, 0.00>; // outside bottom back
#local KE_Point2 = <0.02, 0.00, 0.02>; // inside bottom back   
#local KE_Point3 = <0.00, 0.00, 0.10>; // bottom left   
#local KE_Point4 = <0.10, 0.00, 0.00>; // bottom right             
#local KE_Point5 = <0.00, 0.20, 0.00>; // top 

#declare Knight_Ear = mesh {
  // bottom side
  triangle { KE_Point1 KE_Point3 KE_Point2}
  triangle { KE_Point1 KE_Point4 KE_Point2}
  // back side
  triangle { KE_Point1 KE_Point5 KE_Point4}
  // left side
  triangle { KE_Point1 KE_Point5 KE_Point3}
  // front side
  triangle { KE_Point5 KE_Point4 KE_Point2}
  triangle { KE_Point5 KE_Point3 KE_Point2}
  }
                          
//#local KH_Point1 =  < 0.00, 0.00, 0.60> // front bottom center 
//#local KH_Point2 =  <-0.20, 0.00, 0.60> // front bottom right     
//#local KH_Point3 =  <-0.20, 0.15, 0.60> // front middle right
//#local KH_Point4 =  <-0.10, 0.35, 0.60> // front top right  
//#local KH_Point5 =  < 0.10, 0.35, 0.60> // front top left     
//#local KH_Point6 =  < 0.20, 0.15, 0.60> // front middle left
//#local KH_Point7 =  < 0.20, 0.00, 0.60> // front bottom left
//#local KH_Point8 =  <-0.20, 0.00,-0.30> // back bottom right     
//#local KH_Point9 =  <-0.20, 0.35,-0.30> // back top right 
//#local KH_Point10 = < 0.20, 0.35,-0.30> // back top left
//#local KH_Point11 = < 0.20, 0.00,-0.30> // back bottom left
//#local KH_Point12 = <-0.20, 0.35,-0.10> // top center right
//#local KH_Point13 = < 0.20, 0.35,-0.10> // top center left

#local KH_Point1 =  < 0.00, 0.00, 0.60>; // front bottom center 
#local KH_Point2 =  <-0.15, 0.00, 0.60>; // front bottom right     
#local KH_Point3 =  <-0.15, 0.15, 0.60>; // front middle right
#local KH_Point4 =  <-0.10, 0.25, 0.60>; // front top right  
#local KH_Point5 =  < 0.10, 0.25, 0.60>; // front top left     
#local KH_Point6 =  < 0.15, 0.15, 0.60>; // front middle left
#local KH_Point7 =  < 0.15, 0.00, 0.60>; // front bottom left
#local KH_Point8 =  <-0.20, 0.00,-0.30>; // back bottom right     
#local KH_Point9 =  <-0.20, 0.35,-0.30>; // back top right 
#local KH_Point10 = < 0.20, 0.35,-0.30>; // back top left
#local KH_Point11 = < 0.20, 0.00,-0.30>; // back bottom left
#local KH_Point12 = <-0.20, 0.35,-0.10>; // top center right
#local KH_Point13 = < 0.20, 0.35,-0.10>; // top center left
               
#declare Knight_Head = union{
  mesh {
    //front side
    triangle {KH_Point1 KH_Point2 KH_Point3}
    triangle {KH_Point1 KH_Point3 KH_Point4}
    triangle {KH_Point1 KH_Point4 KH_Point5}
    triangle {KH_Point1 KH_Point5 KH_Point6}
    triangle {KH_Point1 KH_Point6 KH_Point7}
    //back side
    triangle {KH_Point8 KH_Point9 KH_Point10}
    triangle {KH_Point8 KH_Point11 KH_Point10}   
    //bottom side
    triangle {KH_Point8 KH_Point11 KH_Point2}
    triangle {KH_Point7 KH_Point11 KH_Point2} 
    //top side
    triangle {KH_Point9 KH_Point10 KH_Point12}
    triangle {KH_Point13 KH_Point10 KH_Point12}
    //top-front side
    triangle {KH_Point5 KH_Point4 KH_Point12}
    triangle {KH_Point5 KH_Point12 KH_Point13}
    //left side
    triangle {KH_Point7 KH_Point6 KH_Point13}
    triangle {KH_Point7 KH_Point13 KH_Point10}
    triangle {KH_Point7 KH_Point10 KH_Point11}
    //left-top side
    triangle {KH_Point6 KH_Point5 KH_Point13}
    //right side
    triangle {KH_Point2 KH_Point3 KH_Point12}
    triangle {KH_Point2 KH_Point12 KH_Point9}
    triangle {KH_Point2 KH_Point9 KH_Point8}
    //right-top side
    triangle {KH_Point3 KH_Point4 KH_Point12}   
    }
  object {
    Knight_Ear
    translate <-0.20, 0.35, -0.30>
    }                  
  object {
    Knight_Ear
    rotate <0, 270, 0>
    translate < 0.20, 0.35, -0.30>
    }
  }               
                                
#declare Knight = union{
  object {Base2}
  // thoat
  cone {
    <0, 0.78, 0>, 0.15
    <0, 1.00, 0>, 0.15
    scale <1, 1, 2>
    translate <0, 0, 0.1>
    } 
  // head             
  object {
    Knight_Head
    translate <0.00,1.00,0.00>
    }
  }                                

#declare White_Knight = object {
  Knight
  pigment {White_Pigment}
  finish {White_Finish}
  }

#declare Black_Knight = object {
  Knight
  pigment {Black_Pigment}
  finish {Black_Finish}
  rotate <0, 180, 0>
  }
           
#declare BLANK = 0;
#declare B_PAWN = 1;
#declare W_PAWN = 2;
#declare B_BISHOP = 3;
#declare W_BISHOP = 4;
#declare B_KNIGHT = 5;
#declare W_KNIGHT = 6;
#declare B_QUEEN = 7;
#declare W_QUEEN = 8;
#declare B_ROOK = 9;
#declare W_ROOK = 10;
#declare B_KING = 11;
#declare W_KING = 12;
                                
                                
#version ChessPieces_Inc_Temp;
#end
                                