//chairs.inc

// This file defines various types of chairs

#include "Woods.inc"
#include "Metals.inc"

#local front_leg = union
  {
  box 
    {
    <1,0,1><-1,-3,-1>
    }
  
  lathe
    {
    cubic_spline
    // quadratic_spline
    // linear_spline   
    11
    <0.00,   0.00>
    <0.75,   0.00>
    <1.00, -5.00>
    <0.50, -8.00>
    <1.00, -8.50>
    <0.50, -9.00> 
    <0.80, -11.00>
    <0.50, -13.00>
    <0.70, -14.50>
    <0.25, -15.00>
    <0.00, -15.00>    
    }       
    
  cone
    {
    <0.00, -15.00, 0.00> 0.75
    <0.00, -14.00, 0.00> 0.50
    }
  
  texture {
    T_Wood13
    scale 1.0
    }    
  }
            
#local back_leg = union
  {       
  mesh
    {                                              
    // top
    triangle {< 1, 0, 1><-1, 0, 1>< 1, 0,-1>}
    triangle {<-1, 0,-1><-1, 0, 1>< 1, 0,-1>}
    // bottom
    triangle {< 1,-15, 1><-1,-15, 1>< 1,-15, 0>}
    triangle {<-1,-15, 0><-1,-15, 1>< 1,-15, 0>}
    // front
    triangle {< 1, 0,-1>< 1, -7,-1><-1,  0,-1>}
    triangle {<-1,-7,-1>< 1, -7,-1><-1,  0,-1>}
    triangle {< 1,-7,-1>< 1,-15, 0><-1,-15, 0>}
    triangle {< 1,-7,-1><-1, -7,-1><-1,-15, 0>}
    
    // back
    triangle {< 1, 0, 1>< 1,-15, 1><-1,-15, 1>}
    triangle {< 1, 0, 1><-1,  0, 1><-1,-15, 1>}
                                                      
    // right side
    triangle {< 1,  0, 1><1,  0,-1><1, -7, -1>}
    triangle {< 1,  0, 1><1, -7, 1><1, -7, -1>}                                                      
    triangle {< 1, -7, 1><1, -7,-1><1,-15,  1>}
    triangle {< 1, -7,-1><1,-15, 0><1,-15,  1>}

    // left side
    triangle {< -1,  0, 1><-1,  0,-1><-1, -7, -1>}
    triangle {< -1,  0, 1><-1, -7, 1><-1, -7, -1>}                                                      
    triangle {< -1, -7, 1><-1, -7,-1><-1,-15,  1>}
    triangle {< -1, -7,-1><-1,-15, 0><-1,-15,  1>}
    }
              
  texture {
    T_Wood13
    scale 1.0
    }    
  }            
      
#local front_legs = union
  { 
  // left leg
  object 
    {
    front_leg
    translate <-8,0,0>
    }        
  // right leg
  object
    {
    front_leg
    translate <8,0,0>
    }
  // top brace
  box 
    {
    <8,0,0.25><-8,-2,-0.25>
    texture 
      {
      T_Wood13
      scale 1.0
      rotate <0,90,0>
      }          
    }            
  // foot brace
  cone
    {
    < 8,-11,0> 0.15
    <-8,-11,0> 0.15
    texture 
      {
      T_Wood13
      scale 1.0
      rotate <0,90,0>
      }          
    }            
  }      
  
#local back_legs = union
  {
  // left leg
  object 
    {
    back_leg
    translate <-8,0,0>
    }        
  // right leg
  object
    {
    back_leg
    translate <8,0,0>
    }
  // top brace
  box 
    {
    <8,0,0.25><-8,-2,-0.25>
    texture 
      {
      T_Wood13
      scale 1.0
      rotate <0,90,0>
      }          
    }            
  // foot brace
  cone
    {
    < 8,-11,0> 0.15
    <-8,-11,0> 0.15
    texture 
      {
      T_Wood13
      scale 1.0
      rotate <0,90,0>
      }          
    }            
  }  
      
#local legs = union
  {  
  object
    {
    front_legs
    translate <0,0,-8>
    }
  object
    {
    back_legs
    translate <0,0,8>
    }      
  cone
    {
    <0,-11,-8> 0.10
    <0,-11, 8> 0.10
    texture
      {
      T_Wood13
      scale 1.0
      rotate <90,0,0>
      }
    }  
  box
    {
    <8.25,0,-8><7.75,-2,8>
    texture
      {
      T_Wood13
      scale 1.0
      rotate <90,0,0>
      }
    }
  box
    {
    <-8.25,0,-8><-7.75,-2,8>
    texture
      {
      T_Wood13
      scale 1.0
      rotate <90,0,0>
      }
    }
  }      
    
    
#local back_spindle = lathe
  {    
  cubic_spline
  7
  <0.00,  4.00>
  <0.15,  4.00>
  <0.15,  5.00>
  <0.25,  12.25>
  <0.15,  20.50>
  <0.15,  12.50>
  <0.00,  12.50>
  texture
    {
    T_Wood13
    scale 1.0
    rotate <0,0,90>
    }                
  }    
    
#local back = union
  {
  box 
    {
    <1,0,1><-1,22,-1>
    texture
      {
      T_Wood13
      scale 1.0
      rotate <0,0,90>
      }                
    translate<-8,0,8>
    }
  box 
    {
    <1,0,1><-1,22,-1>
    texture
      {
      T_Wood13
      scale 1.0
      rotate <0,0,90>
      }                
    translate<8,0,8>
    }             
  sphere
    {
    <0,22.5,0> 1.0
    texture
      {
      T_Wood13
      scale 1.0
      rotate <0,0,90>
      }                
    translate<8,0,8>    
    }
  sphere
    {
    <0,22.5,0> 1.0
    texture
      {
      T_Wood13
      scale 1.0
      rotate <0,0,90>
      }                
    translate<-8,0,8>    
    }         
    
  // top slat
  box
    {
    <-8,22,0.25><8,20.5,-0.25>
    texture
      {
      T_Wood13
      scale 1.0
      rotate <0,90,0>
      }                
    translate<0,0,8>    
    }  
  // bottom slat
  box
    {
    <-8,5,0.25><8,3.5,-0.25>
    texture
      {
      T_Wood13
      scale 1.0
      rotate <0,90,0>
      }                
    translate<0,0,8>    
    }              
    
  object 
    {
    back_spindle
    translate<-7,0,8>
    }
  object 
    {
    back_spindle
    translate<-6,0,8>
    }
  object 
    {
    back_spindle
    translate<-5,0,8>
    }
  object 
    {
    back_spindle
    translate<-4,0,8>
    }
  object 
    {
    back_spindle
    translate<-3,0,8>
    }
  object 
    {
    back_spindle
    translate<-2,0,8>
    }
  object 
    {
    back_spindle
    translate<-1,0,8>
    }
  object 
    {
    back_spindle
    translate<0,0,8>
    }
  object 
    {
    back_spindle
    translate<1,0,8>
    }
  object 
    {
    back_spindle
    translate<2,0,8>
    }
  object 
    {
    back_spindle
    translate<3,0,8>
    }
  object 
    {
    back_spindle
    translate<4,0,8>
    }
  object 
    {
    back_spindle
    translate<5,0,8>
    }
  object 
    {
    back_spindle
    translate<6,0,8>
    }
  object 
    {
    back_spindle
    translate<7,0,8>
    }
  }
            
#local wood_seat = union
  {
  box
    {
    <-8,0,0><8,1,-17>
    }                
  cone
    {
    <-8,0,0> 1
    <-8,0,-17> 1
    }
  cone
    {
    <8,0,0> 1
    <8,0,-17> 1
    }
  cone
    {
    <-8,0,-17> 1
    < 8,0,-17> 1
    }
  
  sphere
    {
    <-8,0,-17> 1
    }
  sphere
    {
    <8,0,-17> 1
    }
  
  texture
    {
    T_Wood13
    scale 1.0
    rotate <0,0,0>
    }                

  }            
                      
#declare wood_chair = union
  {      
  object 
    {
    legs    
    translate <0,15,0>
    }                         
    
  object
    {
    back        
    matrix <1,0,0,
            0,1,0.1,
            0,0,1,
            0,0,0>
    translate <0,15,0>
    }           
    
  object
    {
    wood_seat       
    translate <0,15,8>
    }
  }                      
                      
                      
// Folding Chair


