// books and shelves

#include "Woods.inc"   
#include "Colors.inc"             
  
#declare T_PAPER = texture
  {                
  pigment {color White}
  } 
  
#declare T_RED_COVER = texture
  {
  pigment {color Red}
  } 
  
#macro Book(b_width, b_height, b_length, p_texture, b_texture)
  box
    {
    <0.1,0.1,0.1> <b_width - 0.1, b_height - 0.1, b_length - 0.2>
    texture {p_texture}
    }               
    
  box                              
    {
    <0,0,0> <0.1,b_height,b_length>
    texture {b_texture}
    }
    
  box
    {
    <b_width,0,0> <b_width - 0.1,b_height,b_length>
    texture {b_texture}
    }
    
  box
    {
    <0,0,0><b_width,b_height,0.1>
    texture {b_texture}
    }

#end               

/* ------------------------------------------------------------------------
   -
   -    USAGE: Book2(w, h, l, P, C, S)
   -
   -                    w -- Width
   -                    h -- Height
   -                    l -- Length
   -                    P -- Texture for Paper
   -                    C -- Texture for Cover
   -                    S -- Texture for Spine
   ------------------------------------------------------------------------ */
#macro Book2(b_width, b_height, b_length, p_texture, b_texture, s_texture)
  // paper
  box
    {
    <0.1,0.1,0.1> <b_width - 0.1, b_height - 0.1, b_length - 0.2>
    texture {p_texture}
    }               
          
  // front cover        
  box                              
    {
    <0,0,0> <0.1,b_height,b_length>
    texture {b_texture}
    }
                                
  // back cover                
  box
    {
    <b_width,0,0> <b_width - 0.1,b_height,b_length>
    texture {b_texture}
    }
  
  // spine     
  intersection
    {
    box {<0,0,-1.0><b_width,b_height,0.1>}   
    object 
      {   
      difference
        {
        cone 
          {
          <0,0,2 * b_width> (2 * b_width) + 0.3
          <0,b_height,2 * b_width> (2 * b_width) + 0.3
          }
        cone 
          {
          <0,0,2 * b_width> (2 * b_width) + 0.2
          <0,b_height,3 * b_width> (3 * b_width) + 0.2
          }
        }
      }
    texture {s_texture}
    }  

#end               


#macro BookPile (x1,y1,z1,x2,y2,z2, s)
  #local r = seed(s);
  #local Current_X = x1;
  #local w = (rand(r) + rand(r)) * 2;
  #local h = (rand(r) * 4) + 6;
  #local l = (rand(r) * 2) + 4;
  #local Current_X = Current_X + w;
  
  #while (Current_X < x2)
    
    union 
      {
      Book(w,h,l + 1,T_PAPER, texture {pigment {rgb <rand(r),rand(r),rand(r)>} normal {bumps 0.01 scale 0.01}})
      translate <Current_X,y1,z1>
      }                          
      
    #local Current_X = Current_X + w;
    #local w = (rand(r) + rand(r)) * 2;
    #local h = (rand(r) * 4) + 6;
    #local l = (rand(r) * 2) + 4;
  #end
#end  

#declare BookShelf = union
  {
  // back
  box
    {
    <0,0,0> <36,72,-0.5>
    texture {T_Wood11}
    }                 
    
  // left side
  box
    {
    <0,0,0> <0.5,72,-24>
    texture {T_Wood13}
    }

  // right side
  box
    {
    <35.5,0,0> <36,72,-24>
    texture {T_Wood13}
    }             
    
  // bottom shelf
  box
    {
    <0,0,0><36,0.5,-24>
    texture {T_Wood13}
    }                 
    
  // shelf
  box
    {
    <0,15,0><36,15.5,-24>
    texture {T_Wood13}
    }                 

  // shelf
  box
    {
    <0,30,0><36,30.5,-24>
    texture {T_Wood13}
    }                 
    
  // shelf
  box
    {
    <0,45,0><36,45.5,-24>
    texture {T_Wood13}
    }                 

  // top shelf
  box
    {
    <0,71.5,0><36,72,-24>
    texture {T_Wood13}
    }      
  }                  
  
