// THE DRUNKING BIRD
// 2004, Maarten Dinger

#include "colors.inc"
#include "metals.inc"
#include "finish.inc"
#include "woods.inc"
#include "textures.inc"
#include "glass.inc"

#declare use_photons=1;
#declare use_focal=0;

global_settings{ 
  ambient_light 0
  assumed_gamma 1.8
  radiosity{ pretrace_start 0.08 pretrace_end 0.02 count 50 nearest_count 8 error_bound 0.02 recursion_limit 1 normal on}
  #if (use_photons)
     photons{ spacing .0035 autostop 0 }
  #end
  max_trace_level 64
}

light_source {<-5, 15, 10> color rgb < 1 1 0.9 >*1.5 area_light <1, 0, 0>, <0, 0, 1>, 3, 3 adaptive 1 jitter }   

camera {
	direction < 0, 0, 1.072253>
	location < -1.179623, 3.522748, 5.000000 >
	up < 0.000000, 1.000000, 0.000000>
	right < -1.330000, 0.000000, 0.000000>
	look_at < -1.179623, 3.522748, 0.000000 >
        #if (use_focal)
        focal_point <-0.0457078, 5.26894, 1.5> 
        aperture 0.05
        blur_samples 40 
        #end
}
 
#declare Curtain = texture { pigment { color rgb < 0.3 0.3 0.6 >} finish { ambient 0.15 } normal {quilted control0 0.7 control1 0.7 scale 0.075 }}
#declare Gloss_paint = texture { pigment { color rgb < 1 1 0.90 >} finish { Shiny } } 
#declare Walls = texture { pigment { color rgb < 1 1 0.95 >} finish { ambient 0.1 specular 0.05 roughness 0.1} }
#declare phonebook = finish { Shiny ambient 0.2}
#declare painting = finish { Shiny }
#declare FrameTop = texture { T_Wood16 scale 1 finish { Shiny } }   
#declare FrameSides = texture { T_Wood16 scale 1 rotate 90*x finish { Shiny } }   
#declare WineCork = texture { Cork scale 0.6 normal {bumps 0.2 scale 0.005 } finish {ambient 0.15 } }
#declare foil = texture { pigment { color rgb < 0.266667 0.266667 0.266667 >} finish { ambient 0.2 specular 0.5 roughness 0.08} }
#declare tail = texture { pigment { color rgb < 1 0.466667 0 >} finish { ambient 0.4 specular 0.5 roughness 0.08} }
#declare WhitePlastic = texture { pigment { color rgb < 1 1 1 >} finish { ambient 0.45 specular 0.5 roughness 0.05} }
#declare RedPlastic = texture { pigment { color rgb < 1 0 0 >} finish { ambient 0.3 specular 0.5 roughness 0.05} }
#declare BluePlastic = texture { pigment { color rgb < 0 0 1 >} finish { ambient 0.3 specular 0.5 roughness 0.05} } 
#declare carpet = normal { bumps 0.25 scale 0.1 }
#declare Black = texture { pigment { color rgb < 0 0 0 >} finish { ambient 0.2 specular 0.5 roughness 0.05} }

// Ceiling
plane { <0, 1, 0>, 16
    pigment {color rgbf < 1 1 1 0>} finish { ambient 0.3 roughness 0.08} 
}

// CD Case material
#declare CD_Case=
material{
 texture {
    pigment { color rgbf <0.97, 0.98, 0.97, 0.8> }
    finish{reflection{0.1,0.4 fresnel} conserve_energy}
    }
    interior{ ior 1.4 } 
} 

// CD Side material
#declare CD_Sides=
material{
 texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 0.3> }
    normal {planar 1 scale 3.2 frequency 256 rotate 90*z translate <-2.4,0,0>}
    finish{ reflection 0 conserve_energy}
    }
    interior{ ior 1.0 } 
} 

// Wineglass material
#declare m_glass=
material{
 texture {
    pigment { color rgbf <0.98, 0.98, 0.98, 1> }
    finish { F_Glass7 }   
    }
    interior{ ior 1.5 } 
} 

// Wine material
#declare wine=
  material{
   texture{
    pigment{color rgbf <1,1,0.8,1> }
    normal{ripples 0.4 scale 0.2}
    finish{reflection{.1,1 fresnel} conserve_energy} 
   }
   interior { ior 1.33 media { scattering { 2 <0.5, 0.65, 0.4> extinction 1 } } }
}

// Winebottle material
#declare winebottle=
material{
 texture {
    pigment { color rgbf <0.5, 0.75, 0.5, 0.35>*1.2 }
    finish { F_Glass7 ambient 0.0}
}
    interior{ ior 1.5 }
} 

// Blue liquid material
#declare BlueLiquid=
  material{
   texture{
    pigment{color rgbf <0,0,1,1> }
    normal{ripples 0.2 scale 0.2}
    finish{reflection{.1,1 fresnel} conserve_energy}
   }
   interior { ior 1.3 media { scattering { 2 <0.5, 0.65, 0.4> extinction 1 } } }
}

//Rimu Wood 
#declare M_Rimu = 
color_map { 
    [0.0, 0.1 color rgb <0.40, 0.16, 0.10 >* 0.5
              color rgb <0.40, 0.16, 0.10>* 0.5]
    [0.1, 0.9 color rgb <0.40, 0.20, 0.13>* 0.5
              color rgb <0.50, 0.26, 0.15>* 0.5]
    [0.9, 1.0 color rgb <0.50, 0.26, 0.15>* 0.5
              color rgb <0.40, 0.16, 0.10>* 0.5]
}
#declare M_Rimu = 
color_map { 
    [0.0, 0.1 color rgbt <0.85, 0.45, 0.15, 0.080>*0.65 
              color rgbt <0.85, 0.45, 0.15, 0.350>*0.65]
    [0.1, 0.9 color rgbt <0.85, 0.45, 0.15, 0.450>*0.85
              color rgbt <0.85, 0.40, 0.10, 0.775>*0.85]
    [0.9, 1.0 color rgbt <0.85, 0.40, 0.10, 0.775>*0.75
              color rgbt <0.85, 0.45, 0.15, 0.000>*0.75]
}

#declare RimuTop   =
    texture { pigment { P_WoodGrain2A  color_map { M_Rimu } }  finish {specular 1 roughness 0.01 reflection 0.03 ambient 0.4} rotate 90*y scale 0.6}
    texture { pigment { P_WoodGrain2B  color_map { M_Rimu } }  finish {specular 1 roughness 0.01 reflection 0.03 ambient 0.4} rotate 90*y scale 0.6}

#declare RimuLegs   =
    texture { pigment { P_WoodGrain2A  color_map { M_Rimu } } finish {specular 1 roughness 0.01 reflection 0.03 ambient 0.4} rotate 90*x scale 0.6}
    texture { pigment { P_WoodGrain2B  color_map { M_Rimu } } finish {specular 1 roughness 0.01 reflection 0.03 ambient 0.4} rotate 90*x scale 0.6}

union {

// object phonebook cover
mesh2 {
vertex_vectors {
6,
<-1.447648,4.717500,1.198333>, <1.099152,4.717500,-1.094247>, <0.630299,4.717500,1.564733>,
<1.099152,4.717500,-1.094247>, <-1.447648,4.717500,1.198333>, <-0.978795,4.717500,-1.460647>
}
normal_vectors {
6,
<-0.000000,-1.000000,0.000000>, <-0.000000,-1.000000,0.000000>, <-0.000000,-1.000000,0.000000> ,
<-0.000000,-1.000000,0.000000>, <-0.000000,-1.000000,0.000000>, <-0.000000,-1.000000,0.000000> 
}
uv_vectors {
6,
<0.000000,1.000000>, <1.000000,0.000000>, <0.000000,0.000000>,
<1.000000,0.000000>, <0.000000,1.000000>, <1.000000,1.000000>
}
face_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_mapping
texture { pigment {image_map {  "Phonebook Back.bmp" interpolate 2 }} finish {phonebook} }
}


// object rect
mesh2 {
vertex_vectors {
6,
<0.629921,4.215720,1.574816>, <1.100507,4.715720,-1.094004>, <0.629921,4.715720,1.574816>,
<1.100507,4.715720,-1.094004>, <0.629921,4.215720,1.574816>, <1.100507,4.215720,-1.094004>
}
normal_vectors {
6,
<0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649> ,
<0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649> 
}
uv_vectors {
6,
<1.000000,1.000000>, <0.000000,0.000000>, <1.000000,0.000000>,
<0.000000,0.000000>, <1.000000,1.000000>, <0.000000,1.000000>
}
face_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_mapping
texture { pigment {image_map {  "Phonebook Side.bmp" interpolate 2 }} }
}


// object phonebook spine
mesh2 {
vertex_vectors {
6,
<-1.444914,4.215720,1.208967>, <-0.974326,4.715720,-1.459853>, <-1.444914,4.715720,1.208967>,
<-0.974326,4.715720,-1.459853>, <-1.444914,4.215720,1.208967>, <-0.974326,4.215720,-1.459853>
}
normal_vectors {
6,
<0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649> ,
<0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649>, <0.984808,0.000000,0.173649> 
}
uv_vectors {
6,
<0.000000,1.000000>, <1.000000,0.000000>, <0.000000,0.000000>,
<1.000000,0.000000>, <0.000000,1.000000>, <1.000000,1.000000>
}
face_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_mapping
texture { pigment {image_map {  "Phonebook Spine.bmp" interpolate 2 }} finish {phonebook} }
}


// object rect
mesh2 {
vertex_vectors {
6,
<-0.974995,4.715383,-1.455364>, <1.101205,4.215717,-1.089276>, <1.101205,4.715383,-1.089276>,
<1.101205,4.215717,-1.089276>, <-0.974995,4.715383,-1.455364>, <-0.974995,4.215717,-1.455364>
}
normal_vectors {
6,
<-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808> ,
<-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808> 
}
uv_vectors {
6,
<1.000000,0.000000>, <0.000000,1.000000>, <0.000000,0.000000>,
<0.000000,1.000000>, <1.000000,0.000000>, <1.000000,1.000000>
}
face_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_mapping
texture { pigment {image_map {  "Phonebook Side.bmp" interpolate 2 }} finish {ambient 0.3}}
}


// object phonebook side1
mesh2 {
vertex_vectors {
6,
<-1.443735,4.715383,1.203636>, <0.632465,4.215717,1.569724>, <0.632465,4.715383,1.569724>,
<0.632465,4.215717,1.569724>, <-1.443735,4.715383,1.203636>, <-1.443735,4.215717,1.203636>
}
normal_vectors {
6,
<-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808> ,
<-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808>, <-0.173647,0.000000,0.984808> 
}
uv_vectors {
6,
<1.000000,0.000000>, <0.000000,1.000000>, <0.000000,0.000000>,
<0.000000,1.000000>, <1.000000,0.000000>, <1.000000,1.000000>
}
face_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_indices {
2,
<0,1,2>,
<3,4,5>
}
uv_mapping
texture { pigment {image_map {  "Phonebook Side.bmp" interpolate 2 }} }
}


// object wineliquid
union {
	smooth_triangle { <-0.242074, 5.42981, -1.67515>, <-0.760357, -0.616725, -0.203732>, <-0.254684, 5.44312, -1.61029>, <-0.956327, -0.2923, 1.67084e-006>, <-0.246005, 5.44312, -1.67621> , <-0.923741, -0.292302, -0.24751> }
	smooth_triangle { <-0.254684, 5.44312, -1.61029>, <-0.956327, -0.2923, 1.67084e-006>, <-0.242074, 5.42981, -1.67515>, <-0.760357, -0.616725, -0.203732>, <-0.250613, 5.42981, -1.61029> , <-0.78718, -0.616724, 4.91367e-007> }
	smooth_triangle { <-0.250613, 5.42981, -1.61029>, <-0.78718, -0.616724, 4.91367e-007>, <-0.235945, 5.426, -1.67351>, <-0.255116, -0.964491, -0.0683564>, <-0.244268, 5.426, -1.61029> , <-0.264115, -0.964491, -3.88958e-007> }
	smooth_triangle { <-0.235945, 5.426, -1.67351>, <-0.255116, -0.964491, -0.0683564>, <-0.250613, 5.42981, -1.61029>, <-0.78718, -0.616724, 4.91367e-007>, <-0.242074, 5.42981, -1.67515> , <-0.760357, -0.616725, -0.203732> }
	smooth_triangle { <-0.244268, 5.426, -1.61029>, <-0.264115, -0.964491, -3.88958e-007>, <-0.000612844, 5.42727, -1.61045>, <0.00503062, -0.999986, 0.00134756>, <-0.000634464, 5.42727, -1.61029> , <0.00520804, -0.999986, -3.20142e-009> }
	smooth_triangle { <-0.000612844, 5.42727, -1.61045>, <0.00503062, -0.999986, 0.00134756>, <-0.244268, 5.426, -1.61029>, <-0.264115, -0.964491, -3.88958e-007>, <-0.235945, 5.426, -1.67351> , <-0.255116, -0.964491, -0.0683564> }
	smooth_triangle { <-0.263906, 5.29486, -1.681>, <-0.959942, 0.111143, -0.257213>, <-0.265803, 5.3584, -1.61029>, <-0.993266, 0.11586, 5.2598e-008>, <-0.256747, 5.3584, -1.67908> , <-0.959423, 0.115861, -0.257069> }
	smooth_triangle { <-0.265803, 5.3584, -1.61029>, <-0.993266, 0.11586, 5.2598e-008>, <-0.263906, 5.29486, -1.681>, <-0.959942, 0.111143, -0.257213>, <-0.273215, 5.29486, -1.61029> , <-0.993805, 0.111142, 3.00566e-008> }
	smooth_triangle { <-0.274646, 5.19097, -1.68388>, <-0.962528, 0.0837995, -0.25791>, <-0.273215, 5.29486, -1.61029>, <-0.993805, 0.111142, 3.00566e-008>, <-0.263906, 5.29486, -1.681> , <-0.959942, 0.111143, -0.257213> }
	smooth_triangle { <-0.273215, 5.29486, -1.61029>, <-0.993805, 0.111142, 3.00566e-008>, <-0.274646, 5.19097, -1.68388>, <-0.962528, 0.0837995, -0.25791>, <-0.284334, 5.19097, -1.61029> , <-0.996483, 0.083799, 1.54085e-007> }
	smooth_triangle { <-0.280613, 5.09012, -1.68548>, <-0.965908, 0.00603413, -0.258815>, <-0.284334, 5.19097, -1.61029>, <-0.996483, 0.083799, 1.54085e-007>, <-0.274646, 5.19097, -1.68388> , <-0.962528, 0.0837995, -0.25791> }
	smooth_triangle { <-0.284334, 5.19097, -1.61029>, <-0.996483, 0.083799, 1.54085e-007>, <-0.280613, 5.09012, -1.68548>, <-0.965908, 0.00603413, -0.258815>, <-0.290511, 5.09012, -1.61029> , <-0.999982, 0.00603373, 2.25783e-007> }
	smooth_triangle { <-0.276495, 5.00337, -1.68438>, <-0.951718, -0.170882, -0.255014>, <-0.290511, 5.09012, -1.61029>, <-0.999982, 0.00603373, 2.25783e-007>, <-0.280613, 5.09012, -1.68548> , <-0.965908, 0.00603413, -0.258815> }
	smooth_triangle { <-0.290511, 5.09012, -1.61029>, <-0.999982, 0.00603373, 2.25783e-007>, <-0.276495, 5.00337, -1.68438>, <-0.951718, -0.170882, -0.255014>, <-0.286249, 5.00337, -1.61029> , <-0.985291, -0.170883, 1.13534e-008> }
	smooth_triangle { <-0.258376, 4.94148, -1.67952>, <-0.885773, -0.398843, -0.237342>, <-0.286249, 5.00337, -1.61029>, <-0.985291, -0.170883, 1.13534e-008>, <-0.276495, 5.00337, -1.68438> , <-0.951718, -0.170882, -0.255014> }
	smooth_triangle { <-0.286249, 5.00337, -1.61029>, <-0.985291, -0.170883, 1.13534e-008>, <-0.258376, 4.94148, -1.67952>, <-0.885773, -0.398843, -0.237342>, <-0.267492, 4.94148, -1.61029> , <-0.917019, -0.398843, 6.04383e-007> }
	smooth_triangle { <-0.237653, 4.90453, -1.67397>, <-0.802015, -0.557305, -0.214903>, <-0.267492, 4.94148, -1.61029>, <-0.917019, -0.398843, 6.04383e-007>, <-0.258376, 4.94148, -1.67952> , <-0.885773, -0.398843, -0.237342> }
	smooth_triangle { <-0.267492, 4.94148, -1.61029>, <-0.917019, -0.398843, 6.04383e-007>, <-0.237653, 4.90453, -1.67397>, <-0.802015, -0.557305, -0.214903>, <-0.246036, 4.90453, -1.61029> , <-0.830308, -0.557305, 2.89163e-007> }
	smooth_triangle { <-0.2114, 4.86923, -1.66693>, <-0.692605, -0.697033, -0.185587>, <-0.246036, 4.90453, -1.61029>, <-0.830308, -0.557305, 2.89163e-007>, <-0.237653, 4.90453, -1.67397> , <-0.802015, -0.557305, -0.214903> }
	smooth_triangle { <-0.246036, 4.90453, -1.61029>, <-0.830308, -0.557305, 2.89163e-007>, <-0.2114, 4.86923, -1.66693>, <-0.692605, -0.697033, -0.185587>, <-0.218858, 4.86923, -1.61029> , <-0.717038, -0.697034, -1.22419e-007> }
	smooth_triangle { <-0.218858, 4.86923, -1.61029>, <-0.717038, -0.697034, -1.22419e-007>, <-0.181567, 4.84402, -1.65894>, <-0.574842, -0.803636, -0.154029>, <-0.187972, 4.84402, -1.61029> , <-0.59512, -0.803637, 4.67612e-008> }
	smooth_triangle { <-0.181567, 4.84402, -1.65894>, <-0.574842, -0.803636, -0.154029>, <-0.218858, 4.86923, -1.61029>, <-0.717038, -0.697034, -1.22419e-007>, <-0.2114, 4.86923, -1.66693> , <-0.692605, -0.697033, -0.185587> }
	smooth_triangle { <-0.187972, 4.84402, -1.61029>, <-0.59512, -0.803637, 4.67612e-008>, <-0.135027, 4.81174, -1.64647>, <-0.438354, -0.891094, -0.117459>, <-0.139791, 4.81174, -1.61029> , <-0.453817, -0.891095, 5.92014e-008> }
	smooth_triangle { <-0.135027, 4.81174, -1.64647>, <-0.438354, -0.891094, -0.117459>, <-0.187972, 4.84402, -1.61029>, <-0.59512, -0.803637, 4.67612e-008>, <-0.181567, 4.84402, -1.65894> , <-0.574842, -0.803636, -0.154029> }
	smooth_triangle { <-0.139791, 4.81174, -1.61029>, <-0.453817, -0.891095, 5.92014e-008>, <-0.0872945, 4.79359, -1.63368>, <-0.333085, -0.938663, -0.0892494>, <-0.0903739, 4.79359, -1.61029> , <-0.344835, -0.938663, 5.23942e-007> }
	smooth_triangle { <-0.0872945, 4.79359, -1.63368>, <-0.333085, -0.938663, -0.0892494>, <-0.139791, 4.81174, -1.61029>, <-0.453817, -0.891095, 5.92014e-008>, <-0.135027, 4.81174, -1.64647> , <-0.438354, -0.891094, -0.117459> }
	smooth_triangle { <-0.256747, 5.3584, -1.67908>, <-0.957712, 0.130135, -0.256617>, <-0.254684, 5.44312, -1.61029>, <-0.991496, 0.130136, -4.05744e-007>, <-0.246005, 5.44312, -1.67621> , <-0.957712, 0.130135, -0.256617> }
	smooth_triangle { <-0.254684, 5.44312, -1.61029>, <-0.991496, 0.130136, -4.05744e-007>, <-0.256747, 5.3584, -1.67908>, <-0.957712, 0.130135, -0.256617>, <-0.265803, 5.3584, -1.61029> , <-0.991496, 0.130136, -4.05744e-007> }
	smooth_triangle { <-0.0903739, 4.79359, -1.61029>, <-0.142781, -0.989754, -1.49038e-008>, <-0.00419277, 4.78118, -1.61141>, <-0.137917, -0.989754, -0.036954>, <-0.00434068, 4.78118, -1.61029> , <-0.142781, -0.989754, -1.49038e-008> }
	smooth_triangle { <-0.00419277, 4.78118, -1.61141>, <-0.137917, -0.989754, -0.036954>, <-0.0903739, 4.79359, -1.61029>, <-0.142781, -0.989754, -1.49038e-008>, <-0.0872945, 4.79359, -1.63368> , <-0.137917, -0.989754, -0.036954> }
	smooth_triangle { <-0.217038, 5.42981, -1.7356>, <-0.681721, -0.61672, -0.39359>, <-0.246005, 5.44312, -1.67621>, <-0.923741, -0.292302, -0.24751>, <-0.220563, 5.44312, -1.73763> , <-0.82821, -0.292277, -0.478166> }
	smooth_triangle { <-0.246005, 5.44312, -1.67621>, <-0.923741, -0.292302, -0.24751>, <-0.217038, 5.42981, -1.7356>, <-0.681721, -0.61672, -0.39359>, <-0.242074, 5.42981, -1.67515> , <-0.760357, -0.616725, -0.203732> }
	smooth_triangle { <-0.242074, 5.42981, -1.67515>, <-0.760357, -0.616725, -0.203732>, <-0.211543, 5.426, -1.73242>, <-0.228726, -0.964493, -0.132053>, <-0.235945, 5.426, -1.67351> , <-0.255116, -0.964491, -0.0683564> }
	smooth_triangle { <-0.211543, 5.426, -1.73242>, <-0.228726, -0.964493, -0.132053>, <-0.242074, 5.42981, -1.67515>, <-0.760357, -0.616725, -0.203732>, <-0.217038, 5.42981, -1.7356> , <-0.681721, -0.61672, -0.39359> }
	smooth_triangle { <-0.235945, 5.426, -1.67351>, <-0.255116, -0.964491, -0.0683564>, <-0.000549461, 5.42727, -1.61061>, <0.00451018, -0.999986, 0.00260401>, <-0.000612844, 5.42727, -1.61045> , <0.00503062, -0.999986, 0.00134756> }
	smooth_triangle { <-0.000549461, 5.42727, -1.61061>, <0.00451018, -0.999986, 0.00260401>, <-0.235945, 5.426, -1.67351>, <-0.255116, -0.964491, -0.0683564>, <-0.211543, 5.426, -1.73242> , <-0.228726, -0.964493, -0.132053> }
	smooth_triangle { <-0.236612, 5.29486, -1.7469>, <-0.860657, 0.111143, -0.496908>, <-0.256747, 5.3584, -1.67908>, <-0.959423, 0.115861, -0.257069>, <-0.230192, 5.3584, -1.74319> , <-0.86019, 0.115867, -0.496637> }
	smooth_triangle { <-0.256747, 5.3584, -1.67908>, <-0.959423, 0.115861, -0.257069>, <-0.236612, 5.29486, -1.7469>, <-0.860657, 0.111143, -0.496908>, <-0.263906, 5.29486, -1.681> , <-0.959942, 0.111143, -0.257213> }
	smooth_triangle { <-0.24624, 5.19097, -1.75246>, <-0.862977, 0.0837962, -0.498246>, <-0.263906, 5.29486, -1.681>, <-0.959942, 0.111143, -0.257213>, <-0.236612, 5.29486, -1.7469> , <-0.860657, 0.111143, -0.496908> }
	smooth_triangle { <-0.263906, 5.29486, -1.681>, <-0.959942, 0.111143, -0.257213>, <-0.24624, 5.19097, -1.75246>, <-0.862977, 0.0837962, -0.498246>, <-0.274646, 5.19097, -1.68388> , <-0.962528, 0.0837995, -0.25791> }
	smooth_triangle { <-0.25159, 5.09012, -1.75555>, <-0.866008, 0.00603445, -0.499994>, <-0.274646, 5.19097, -1.68388>, <-0.962528, 0.0837995, -0.25791>, <-0.24624, 5.19097, -1.75246> , <-0.862977, 0.0837962, -0.498246> }
	smooth_triangle { <-0.274646, 5.19097, -1.68388>, <-0.962528, 0.0837995, -0.25791>, <-0.25159, 5.09012, -1.75555>, <-0.866008, 0.00603445, -0.499994>, <-0.280613, 5.09012, -1.68548> , <-0.965908, 0.00603413, -0.258815> }
	smooth_triangle { <-0.247899, 5.00337, -1.75341>, <-0.853288, -0.170883, -0.492644>, <-0.280613, 5.09012, -1.68548>, <-0.965908, 0.00603413, -0.258815>, <-0.25159, 5.09012, -1.75555> , <-0.866008, 0.00603445, -0.499994> }
	smooth_triangle { <-0.280613, 5.09012, -1.68548>, <-0.965908, 0.00603413, -0.258815>, <-0.247899, 5.00337, -1.75341>, <-0.853288, -0.170883, -0.492644>, <-0.276495, 5.00337, -1.68438> , <-0.951718, -0.170882, -0.255014> }
	smooth_triangle { <-0.231655, 4.94148, -1.74404>, <-0.794168, -0.39884, -0.458503>, <-0.276495, 5.00337, -1.68438>, <-0.951718, -0.170882, -0.255014>, <-0.247899, 5.00337, -1.75341> , <-0.853288, -0.170883, -0.492644> }
	smooth_triangle { <-0.276495, 5.00337, -1.68438>, <-0.951718, -0.170882, -0.255014>, <-0.231655, 4.94148, -1.74404>, <-0.794168, -0.39884, -0.458503>, <-0.258376, 4.94148, -1.67952> , <-0.885773, -0.398843, -0.237342> }
	smooth_triangle { <-0.213074, 4.90453, -1.73331>, <-0.71907, -0.557307, -0.415148>, <-0.258376, 4.94148, -1.67952>, <-0.885773, -0.398843, -0.237342>, <-0.231655, 4.94148, -1.74404> , <-0.794168, -0.39884, -0.458503> }
	smooth_triangle { <-0.258376, 4.94148, -1.67952>, <-0.885773, -0.398843, -0.237342>, <-0.213074, 4.90453, -1.73331>, <-0.71907, -0.557307, -0.415148>, <-0.237653, 4.90453, -1.67397> , <-0.802015, -0.557305, -0.214903> }
	smooth_triangle { <-0.189535, 4.86923, -1.71972>, <-0.620973, -0.697034, -0.358519>, <-0.237653, 4.90453, -1.67397>, <-0.802015, -0.557305, -0.214903>, <-0.213074, 4.90453, -1.73331> , <-0.71907, -0.557307, -0.415148> }
	smooth_triangle { <-0.237653, 4.90453, -1.67397>, <-0.802015, -0.557305, -0.214903>, <-0.189535, 4.86923, -1.71972>, <-0.620973, -0.697034, -0.358519>, <-0.2114, 4.86923, -1.66693> , <-0.692605, -0.697033, -0.185587> }
	smooth_triangle { <-0.2114, 4.86923, -1.66693>, <-0.692605, -0.697033, -0.185587>, <-0.162789, 4.84402, -1.70428>, <-0.515391, -0.803634, -0.297563>, <-0.181567, 4.84402, -1.65894> , <-0.574842, -0.803636, -0.154029> }
	smooth_triangle { <-0.162789, 4.84402, -1.70428>, <-0.515391, -0.803634, -0.297563>, <-0.2114, 4.86923, -1.66693>, <-0.692605, -0.697033, -0.185587>, <-0.189535, 4.86923, -1.71972> , <-0.620973, -0.697034, -0.358519> }
	smooth_triangle { <-0.181567, 4.84402, -1.65894>, <-0.574842, -0.803636, -0.154029>, <-0.121062, 4.81174, -1.68019>, <-0.393017, -0.891095, -0.226908>, <-0.135027, 4.81174, -1.64647> , <-0.438354, -0.891094, -0.117459> }
	smooth_triangle { <-0.121062, 4.81174, -1.68019>, <-0.393017, -0.891095, -0.226908>, <-0.181567, 4.84402, -1.65894>, <-0.574842, -0.803636, -0.154029>, <-0.162789, 4.84402, -1.70428> , <-0.515391, -0.803634, -0.297563> }
	smooth_triangle { <-0.135027, 4.81174, -1.64647>, <-0.438354, -0.891094, -0.117459>, <-0.0782662, 4.79359, -1.65548>, <-0.298638, -0.938663, -0.172419>, <-0.0872945, 4.79359, -1.63368> , <-0.333085, -0.938663, -0.0892494> }
	smooth_triangle { <-0.0782662, 4.79359, -1.65548>, <-0.298638, -0.938663, -0.172419>, <-0.135027, 4.81174, -1.64647>, <-0.438354, -0.891094, -0.117459>, <-0.121062, 4.81174, -1.68019> , <-0.393017, -0.891095, -0.226908> }
	smooth_triangle { <-0.230192, 5.3584, -1.74319>, <-0.858659, 0.130135, -0.495752>, <-0.246005, 5.44312, -1.67621>, <-0.957712, 0.130135, -0.256617>, <-0.220563, 5.44312, -1.73763> , <-0.858659, 0.130135, -0.495752> }
	smooth_triangle { <-0.246005, 5.44312, -1.67621>, <-0.957712, 0.130135, -0.256617>, <-0.230192, 5.3584, -1.74319>, <-0.858659, 0.130135, -0.495752>, <-0.256747, 5.3584, -1.67908> , <-0.957712, 0.130135, -0.256617> }
	smooth_triangle { <-0.0872945, 4.79359, -1.63368>, <-0.137917, -0.989754, -0.036954>, <-0.00375915, 4.78118, -1.61246>, <-0.123659, -0.989754, -0.0713791>, <-0.00419277, 4.78118, -1.61141> , <-0.137917, -0.989754, -0.036954> }
	smooth_triangle { <-0.00375915, 4.78118, -1.61246>, <-0.123659, -0.989754, -0.0713791>, <-0.0872945, 4.79359, -1.63368>, <-0.137917, -0.989754, -0.036954>, <-0.0782662, 4.79359, -1.65548> , <-0.123659, -0.989754, -0.0713791> }
	smooth_triangle { <-0.17721, 5.42981, -1.7875>, <-0.556614, -0.616729, -0.55662>, <-0.220563, 5.44312, -1.73763>, <-0.82821, -0.292277, -0.478166>, <-0.180089, 5.44312, -1.79038> , <-0.676219, -0.292306, -0.676229> }
	smooth_triangle { <-0.220563, 5.44312, -1.73763>, <-0.82821, -0.292277, -0.478166>, <-0.17721, 5.42981, -1.7875>, <-0.556614, -0.616729, -0.55662>, <-0.217038, 5.42981, -1.7356> , <-0.681721, -0.61672, -0.39359> }
	smooth_triangle { <-0.217038, 5.42981, -1.7356>, <-0.681721, -0.61672, -0.39359>, <-0.172724, 5.426, -1.78301>, <-0.186755, -0.964492, -0.186756>, <-0.211543, 5.426, -1.73242> , <-0.228726, -0.964493, -0.132053> }
	smooth_triangle { <-0.172724, 5.426, -1.78301>, <-0.186755, -0.964492, -0.186756>, <-0.217038, 5.42981, -1.7356>, <-0.681721, -0.61672, -0.39359>, <-0.17721, 5.42981, -1.7875> , <-0.556614, -0.616729, -0.55662> }
	smooth_triangle { <-0.211543, 5.426, -1.73242>, <-0.228726, -0.964493, -0.132053>, <-0.000448634, 5.42727, -1.61074>, <0.00368266, -0.999986, 0.00368268>, <-0.000549461, 5.42727, -1.61061> , <0.00451018, -0.999986, 0.00260401> }
	smooth_triangle { <-0.000448634, 5.42727, -1.61074>, <0.00368266, -0.999986, 0.00368268>, <-0.211543, 5.426, -1.73242>, <-0.228726, -0.964493, -0.132053>, <-0.172724, 5.426, -1.78301> , <-0.186755, -0.964492, -0.186756> }
	smooth_triangle { <-0.193192, 5.29486, -1.80348>, <-0.702724, 0.111139, -0.702728>, <-0.230192, 5.3584, -1.74319>, <-0.86019, 0.115867, -0.496637>, <-0.187951, 5.3584, -1.79824> , <-0.702341, 0.115862, -0.702349> }
	smooth_triangle { <-0.230192, 5.3584, -1.74319>, <-0.86019, 0.115867, -0.496637>, <-0.193192, 5.29486, -1.80348>, <-0.702724, 0.111139, -0.702728>, <-0.236612, 5.29486, -1.7469> , <-0.860657, 0.111143, -0.496908> }
	smooth_triangle { <-0.201054, 5.19097, -1.81134>, <-0.704622, 0.0837966, -0.704618>, <-0.236612, 5.29486, -1.7469>, <-0.860657, 0.111143, -0.496908>, <-0.193192, 5.29486, -1.80348> , <-0.702724, 0.111139, -0.702728> }
	smooth_triangle { <-0.236612, 5.29486, -1.7469>, <-0.860657, 0.111143, -0.496908>, <-0.201054, 5.19097, -1.81134>, <-0.704622, 0.0837966, -0.704618>, <-0.24624, 5.19097, -1.75246> , <-0.862977, 0.0837962, -0.498246> }
	smooth_triangle { <-0.205423, 5.09012, -1.81571>, <-0.707099, 0.00603549, -0.707089>, <-0.24624, 5.19097, -1.75246>, <-0.862977, 0.0837962, -0.498246>, <-0.201054, 5.19097, -1.81134> , <-0.704622, 0.0837966, -0.704618> }
	smooth_triangle { <-0.24624, 5.19097, -1.75246>, <-0.862977, 0.0837962, -0.498246>, <-0.205423, 5.09012, -1.81571>, <-0.707099, 0.00603549, -0.707089>, <-0.25159, 5.09012, -1.75555> , <-0.866008, 0.00603445, -0.499994> }
	smooth_triangle { <-0.202408, 5.00337, -1.8127>, <-0.696713, -0.170878, -0.696701>, <-0.25159, 5.09012, -1.75555>, <-0.866008, 0.00603445, -0.499994>, <-0.205423, 5.09012, -1.81571> , <-0.707099, 0.00603549, -0.707089> }
	smooth_triangle { <-0.25159, 5.09012, -1.75555>, <-0.866008, 0.00603445, -0.499994>, <-0.202408, 5.00337, -1.8127>, <-0.696713, -0.170878, -0.696701>, <-0.247899, 5.00337, -1.75341> , <-0.853288, -0.170883, -0.492644> }
	smooth_triangle { <-0.189146, 4.94148, -1.79943>, <-0.648436, -0.398832, -0.648432>, <-0.247899, 5.00337, -1.75341>, <-0.853288, -0.170883, -0.492644>, <-0.202408, 5.00337, -1.8127> , <-0.696713, -0.170878, -0.696701> }
	smooth_triangle { <-0.247899, 5.00337, -1.75341>, <-0.853288, -0.170883, -0.492644>, <-0.189146, 4.94148, -1.79943>, <-0.648436, -0.398832, -0.648432>, <-0.231655, 4.94148, -1.74404> , <-0.794168, -0.39884, -0.458503> }
	smooth_triangle { <-0.173975, 4.90453, -1.78427>, <-0.587116, -0.557308, -0.587113>, <-0.231655, 4.94148, -1.74404>, <-0.794168, -0.39884, -0.458503>, <-0.189146, 4.94148, -1.79943> , <-0.648436, -0.398832, -0.648432> }
	smooth_triangle { <-0.231655, 4.94148, -1.74404>, <-0.794168, -0.39884, -0.458503>, <-0.173975, 4.90453, -1.78427>, <-0.587116, -0.557308, -0.587113>, <-0.213074, 4.90453, -1.73331> , <-0.71907, -0.557307, -0.415148> }
	smooth_triangle { <-0.154756, 4.86923, -1.76505>, <-0.507021, -0.697039, -0.507016>, <-0.213074, 4.90453, -1.73331>, <-0.71907, -0.557307, -0.415148>, <-0.173975, 4.90453, -1.78427> , <-0.587116, -0.557308, -0.587113> }
	smooth_triangle { <-0.213074, 4.90453, -1.73331>, <-0.71907, -0.557307, -0.415148>, <-0.154756, 4.86923, -1.76505>, <-0.507021, -0.697039, -0.507016>, <-0.189535, 4.86923, -1.71972> , <-0.620973, -0.697034, -0.358519> }
	smooth_triangle { <-0.189535, 4.86923, -1.71972>, <-0.620973, -0.697034, -0.358519>, <-0.132916, 4.84402, -1.74321>, <-0.420815, -0.803635, -0.420814>, <-0.162789, 4.84402, -1.70428> , <-0.515391, -0.803634, -0.297563> }
	smooth_triangle { <-0.132916, 4.84402, -1.74321>, <-0.420815, -0.803635, -0.420814>, <-0.189535, 4.86923, -1.71972>, <-0.620973, -0.697034, -0.358519>, <-0.154756, 4.86923, -1.76505> , <-0.507021, -0.697039, -0.507016> }
	smooth_triangle { <-0.162789, 4.84402, -1.70428>, <-0.515391, -0.803634, -0.297563>, <-0.0988468, 4.81174, -1.70914>, <-0.320897, -0.891095, -0.320898>, <-0.121062, 4.81174, -1.68019> , <-0.393017, -0.891095, -0.226908> }
	smooth_triangle { <-0.0988468, 4.81174, -1.70914>, <-0.320897, -0.891095, -0.320898>, <-0.162789, 4.84402, -1.70428>, <-0.515391, -0.803634, -0.297563>, <-0.132916, 4.84402, -1.74321> , <-0.420815, -0.803635, -0.420814> }
	smooth_triangle { <-0.121062, 4.81174, -1.68019>, <-0.393017, -0.891095, -0.226908>, <-0.063904, 4.79359, -1.67419>, <-0.243836, -0.938662, -0.243837>, <-0.0782662, 4.79359, -1.65548> , <-0.298638, -0.938663, -0.172419> }
	smooth_triangle { <-0.063904, 4.79359, -1.67419>, <-0.243836, -0.938662, -0.243837>, <-0.121062, 4.81174, -1.68019>, <-0.393017, -0.891095, -0.226908>, <-0.0988468, 4.81174, -1.70914> , <-0.320897, -0.891095, -0.320898> }
	smooth_triangle { <-0.187951, 5.3584, -1.79824>, <-0.701093, 0.130128, -0.701096>, <-0.220563, 5.44312, -1.73763>, <-0.858659, 0.130135, -0.495752>, <-0.180089, 5.44312, -1.79038> , <-0.701093, 0.130128, -0.701096> }
	smooth_triangle { <-0.220563, 5.44312, -1.73763>, <-0.858659, 0.130135, -0.495752>, <-0.187951, 5.3584, -1.79824>, <-0.701093, 0.130128, -0.701096>, <-0.230192, 5.3584, -1.74319> , <-0.858659, 0.130135, -0.495752> }
	smooth_triangle { <-0.0782662, 4.79359, -1.65548>, <-0.123659, -0.989754, -0.0713791>, <-0.00306932, 4.78118, -1.61336>, <-0.100957, -0.989755, -0.100962>, <-0.00375915, 4.78118, -1.61246> , <-0.123659, -0.989754, -0.0713791> }
	smooth_triangle { <-0.00306932, 4.78118, -1.61336>, <-0.100957, -0.989755, -0.100962>, <-0.0782662, 4.79359, -1.65548>, <-0.123659, -0.989754, -0.0713791>, <-0.063904, 4.79359, -1.67419> , <-0.100957, -0.989755, -0.100962> }
	smooth_triangle { <-0.17721, 5.42981, -1.7875>, <-0.556614, -0.616729, -0.55662>, <-0.127342, 5.44312, -1.83085>, <-0.478161, -0.292308, -0.828202>, <-0.125307, 5.42981, -1.82733> , <-0.393591, -0.616715, -0.681725> }
	smooth_triangle { <-0.127342, 5.44312, -1.83085>, <-0.478161, -0.292308, -0.828202>, <-0.17721, 5.42981, -1.7875>, <-0.556614, -0.616729, -0.55662>, <-0.180089, 5.44312, -1.79038> , <-0.676219, -0.292306, -0.676229> }
	smooth_triangle { <-0.17721, 5.42981, -1.7875>, <-0.556614, -0.616729, -0.55662>, <-0.122134, 5.426, -1.82183>, <-0.132064, -0.964487, -0.228743>, <-0.172724, 5.426, -1.78301> , <-0.186755, -0.964492, -0.186756> }
	smooth_triangle { <-0.122134, 5.426, -1.82183>, <-0.132064, -0.964487, -0.228743>, <-0.17721, 5.42981, -1.7875>, <-0.556614, -0.616729, -0.55662>, <-0.125307, 5.42981, -1.82733> , <-0.393591, -0.616715, -0.681725> }
	smooth_triangle { <-0.172724, 5.426, -1.78301>, <-0.186755, -0.964492, -0.186756>, <-0.000317232, 5.42727, -1.61084>, <0.00260161, -0.999986, 0.00451155>, <-0.000448634, 5.42727, -1.61074> , <0.00368266, -0.999986, 0.00368268> }
	smooth_triangle { <-0.000317232, 5.42727, -1.61084>, <0.00260161, -0.999986, 0.00451155>, <-0.172724, 5.426, -1.78301>, <-0.186755, -0.964492, -0.186756>, <-0.122134, 5.426, -1.82183> , <-0.132064, -0.964487, -0.228743> }
	smooth_triangle { <-0.136608, 5.29486, -1.8469>, <-0.496909, 0.111139, -0.860656>, <-0.187951, 5.3584, -1.79824>, <-0.702341, 0.115862, -0.702349>, <-0.132902, 5.3584, -1.84048> , <-0.496639, 0.115857, -0.86019> }
	smooth_triangle { <-0.187951, 5.3584, -1.79824>, <-0.702341, 0.115862, -0.702349>, <-0.136608, 5.29486, -1.8469>, <-0.496909, 0.111139, -0.860656>, <-0.193192, 5.29486, -1.80348> , <-0.702724, 0.111139, -0.702728> }
	smooth_triangle { <-0.142167, 5.19097, -1.85653>, <-0.498244, 0.0838001, -0.862978>, <-0.193192, 5.29486, -1.80348>, <-0.702724, 0.111139, -0.702728>, <-0.136608, 5.29486, -1.8469> , <-0.496909, 0.111139, -0.860656> }
	smooth_triangle { <-0.193192, 5.29486, -1.80348>, <-0.702724, 0.111139, -0.702728>, <-0.142167, 5.19097, -1.85653>, <-0.498244, 0.0838001, -0.862978>, <-0.201054, 5.19097, -1.81134> , <-0.704622, 0.0837966, -0.704618> }
	smooth_triangle { <-0.145256, 5.09012, -1.86188>, <-0.499992, 0.00603957, -0.866009>, <-0.201054, 5.19097, -1.81134>, <-0.704622, 0.0837966, -0.704618>, <-0.142167, 5.19097, -1.85653> , <-0.498244, 0.0838001, -0.862978> }
	smooth_triangle { <-0.201054, 5.19097, -1.81134>, <-0.704622, 0.0837966, -0.704618>, <-0.145256, 5.09012, -1.86188>, <-0.499992, 0.00603957, -0.866009>, <-0.205423, 5.09012, -1.81571> , <-0.707099, 0.00603549, -0.707089> }
	smooth_triangle { <-0.202408, 5.00337, -1.8127>, <-0.696713, -0.170878, -0.696701>, <-0.145256, 5.09012, -1.86188>, <-0.499992, 0.00603957, -0.866009>, <-0.143125, 5.00337, -1.85819> , <-0.492646, -0.170879, -0.853288> }
	smooth_triangle { <-0.145256, 5.09012, -1.86188>, <-0.499992, 0.00603957, -0.866009>, <-0.202408, 5.00337, -1.8127>, <-0.696713, -0.170878, -0.696701>, <-0.205423, 5.09012, -1.81571> , <-0.707099, 0.00603549, -0.707089> }
	smooth_triangle { <-0.189146, 4.94148, -1.79943>, <-0.648436, -0.398832, -0.648432>, <-0.143125, 5.00337, -1.85819>, <-0.492646, -0.170879, -0.853288>, <-0.133746, 4.94148, -1.84195> , <-0.458506, -0.398837, -0.794167> }
	smooth_triangle { <-0.143125, 5.00337, -1.85819>, <-0.492646, -0.170879, -0.853288>, <-0.189146, 4.94148, -1.79943>, <-0.648436, -0.398832, -0.648432>, <-0.202408, 5.00337, -1.8127> , <-0.696713, -0.170878, -0.696701> }
	smooth_triangle { <-0.173975, 4.90453, -1.78427>, <-0.587116, -0.557308, -0.587113>, <-0.133746, 4.94148, -1.84195>, <-0.458506, -0.398837, -0.794167>, <-0.123018, 4.90453, -1.82336> , <-0.415148, -0.557306, -0.71907> }
	smooth_triangle { <-0.133746, 4.94148, -1.84195>, <-0.458506, -0.398837, -0.794167>, <-0.173975, 4.90453, -1.78427>, <-0.587116, -0.557308, -0.587113>, <-0.189146, 4.94148, -1.79943> , <-0.648436, -0.398832, -0.648432> }
	smooth_triangle { <-0.154756, 4.86923, -1.76505>, <-0.507021, -0.697039, -0.507016>, <-0.123018, 4.90453, -1.82336>, <-0.415148, -0.557306, -0.71907>, <-0.109429, 4.86923, -1.79983> , <-0.358515, -0.697039, -0.62097> }
	smooth_triangle { <-0.123018, 4.90453, -1.82336>, <-0.415148, -0.557306, -0.71907>, <-0.154756, 4.86923, -1.76505>, <-0.507021, -0.697039, -0.507016>, <-0.173975, 4.90453, -1.78427> , <-0.587116, -0.557308, -0.587113> }
	smooth_triangle { <-0.154756, 4.86923, -1.76505>, <-0.507021, -0.697039, -0.507016>, <-0.0939859, 4.84402, -1.77308>, <-0.29756, -0.803638, -0.515388>, <-0.132916, 4.84402, -1.74321> , <-0.420815, -0.803635, -0.420814> }
	smooth_triangle { <-0.0939859, 4.84402, -1.77308>, <-0.29756, -0.803638, -0.515388>, <-0.154756, 4.86923, -1.76505>, <-0.507021, -0.697039, -0.507016>, <-0.109429, 4.86923, -1.79983> , <-0.358515, -0.697039, -0.62097> }
	smooth_triangle { <-0.132916, 4.84402, -1.74321>, <-0.420815, -0.803635, -0.420814>, <-0.0698953, 4.81174, -1.73135>, <-0.226909, -0.891095, -0.393017>, <-0.0988468, 4.81174, -1.70914> , <-0.320897, -0.891095, -0.320898> }
	smooth_triangle { <-0.0698953, 4.81174, -1.73135>, <-0.226909, -0.891095, -0.393017>, <-0.132916, 4.84402, -1.74321>, <-0.420815, -0.803635, -0.420814>, <-0.0939859, 4.84402, -1.77308> , <-0.29756, -0.803638, -0.515388> }
	smooth_triangle { <-0.0988468, 4.81174, -1.70914>, <-0.320897, -0.891095, -0.320898>, <-0.0451869, 4.79359, -1.68856>, <-0.172419, -0.938663, -0.298637>, <-0.063904, 4.79359, -1.67419> , <-0.243836, -0.938662, -0.243837> }
	smooth_triangle { <-0.0451869, 4.79359, -1.68856>, <-0.172419, -0.938663, -0.298637>, <-0.0988468, 4.81174, -1.70914>, <-0.320897, -0.891095, -0.320898>, <-0.0698953, 4.81174, -1.73135> , <-0.226909, -0.891095, -0.393017> }
	smooth_triangle { <-0.132902, 5.3584, -1.84048>, <-0.495751, 0.130132, -0.85866>, <-0.180089, 5.44312, -1.79038>, <-0.701093, 0.130128, -0.701096>, <-0.127342, 5.44312, -1.83085> , <-0.495751, 0.130132, -0.85866> }
	smooth_triangle { <-0.180089, 5.44312, -1.79038>, <-0.701093, 0.130128, -0.701096>, <-0.132902, 5.3584, -1.84048>, <-0.495751, 0.130132, -0.85866>, <-0.187951, 5.3584, -1.79824> , <-0.701093, 0.130128, -0.701096> }
	smooth_triangle { <-0.063904, 4.79359, -1.67419>, <-0.100957, -0.989755, -0.100962>, <-0.00217035, 4.78118, -1.61405>, <-0.0713946, -0.989754, -0.123655>, <-0.00306932, 4.78118, -1.61336> , <-0.100957, -0.989755, -0.100962> }
	smooth_triangle { <-0.00217035, 4.78118, -1.61405>, <-0.0713946, -0.989754, -0.123655>, <-0.063904, 4.79359, -1.67419>, <-0.100957, -0.989755, -0.100962>, <-0.0451869, 4.79359, -1.68856> , <-0.0713946, -0.989754, -0.123655> }
	smooth_triangle { <-0.125307, 5.42981, -1.82733>, <-0.393591, -0.616715, -0.681725>, <-0.0659171, 5.44312, -1.8563>, <-0.247515, -0.29231, -0.923738>, <-0.0648634, 5.42981, -1.85236> , <-0.203739, -0.616719, -0.760361> }
	smooth_triangle { <-0.0659171, 5.44312, -1.8563>, <-0.247515, -0.29231, -0.923738>, <-0.125307, 5.42981, -1.82733>, <-0.393591, -0.616715, -0.681725>, <-0.127342, 5.44312, -1.83085> , <-0.478161, -0.292308, -0.828202> }
	smooth_triangle { <-0.125307, 5.42981, -1.82733>, <-0.393591, -0.616715, -0.681725>, <-0.0632214, 5.426, -1.84624>, <-0.0683621, -0.964488, -0.255126>, <-0.122134, 5.426, -1.82183> , <-0.132064, -0.964487, -0.228743> }
	smooth_triangle { <-0.0632214, 5.426, -1.84624>, <-0.0683621, -0.964488, -0.255126>, <-0.125307, 5.42981, -1.82733>, <-0.393591, -0.616715, -0.681725>, <-0.0648634, 5.42981, -1.85236> , <-0.203739, -0.616719, -0.760361> }
	smooth_triangle { <-0.122134, 5.426, -1.82183>, <-0.132064, -0.964487, -0.228743>, <-0.000164211, 5.42727, -1.6109>, <0.00134652, -0.999986, 0.00503172>, <-0.000317232, 5.42727, -1.61084> , <0.00260161, -0.999986, 0.00451155> }
	smooth_triangle { <-0.000164211, 5.42727, -1.6109>, <0.00134652, -0.999986, 0.00503172>, <-0.122134, 5.426, -1.82183>, <-0.132064, -0.964487, -0.228743>, <-0.0632214, 5.426, -1.84624> , <-0.0683621, -0.964488, -0.255126> }
	smooth_triangle { <-0.0707134, 5.29486, -1.8742>, <-0.257216, 0.111142, -0.959941>, <-0.132902, 5.3584, -1.84048>, <-0.496639, 0.115857, -0.86019>, <-0.0687949, 5.3584, -1.86704> , <-0.257076, 0.115861, -0.959421> }
	smooth_triangle { <-0.132902, 5.3584, -1.84048>, <-0.496639, 0.115857, -0.86019>, <-0.0707134, 5.29486, -1.8742>, <-0.257216, 0.111142, -0.959941>, <-0.136608, 5.29486, -1.8469> , <-0.496909, 0.111139, -0.860656> }
	smooth_triangle { <-0.073591, 5.19097, -1.88494>, <-0.257909, 0.0837972, -0.962528>, <-0.136608, 5.29486, -1.8469>, <-0.496909, 0.111139, -0.860656>, <-0.0707134, 5.29486, -1.8742> , <-0.257216, 0.111142, -0.959941> }
	smooth_triangle { <-0.136608, 5.29486, -1.8469>, <-0.496909, 0.111139, -0.860656>, <-0.073591, 5.19097, -1.88494>, <-0.257909, 0.0837972, -0.962528>, <-0.142167, 5.19097, -1.85653> , <-0.498244, 0.0838001, -0.862978> }
	smooth_triangle { <-0.0751897, 5.09012, -1.8909>, <-0.25881, 0.0060384, -0.965909>, <-0.142167, 5.19097, -1.85653>, <-0.498244, 0.0838001, -0.862978>, <-0.073591, 5.19097, -1.88494> , <-0.257909, 0.0837972, -0.962528> }
	smooth_triangle { <-0.142167, 5.19097, -1.85653>, <-0.498244, 0.0838001, -0.862978>, <-0.0751897, 5.09012, -1.8909>, <-0.25881, 0.0060384, -0.965909>, <-0.145256, 5.09012, -1.86188> , <-0.499992, 0.00603957, -0.866009> }
	smooth_triangle { <-0.143125, 5.00337, -1.85819>, <-0.492646, -0.170879, -0.853288>, <-0.0751897, 5.09012, -1.8909>, <-0.25881, 0.0060384, -0.965909>, <-0.0740867, 5.00337, -1.88679> , <-0.255008, -0.17088, -0.95172> }
	smooth_triangle { <-0.0751897, 5.09012, -1.8909>, <-0.25881, 0.0060384, -0.965909>, <-0.143125, 5.00337, -1.85819>, <-0.492646, -0.170879, -0.853288>, <-0.145256, 5.09012, -1.86188> , <-0.499992, 0.00603957, -0.866009> }
	smooth_triangle { <-0.133746, 4.94148, -1.84195>, <-0.458506, -0.398837, -0.794167>, <-0.0740867, 5.00337, -1.88679>, <-0.255008, -0.17088, -0.95172>, <-0.0692318, 4.94148, -1.86867> , <-0.237343, -0.398844, -0.885772> }
	smooth_triangle { <-0.0740867, 5.00337, -1.88679>, <-0.255008, -0.17088, -0.95172>, <-0.133746, 4.94148, -1.84195>, <-0.458506, -0.398837, -0.794167>, <-0.143125, 5.00337, -1.85819> , <-0.492646, -0.170879, -0.853288> }
	smooth_triangle { <-0.123018, 4.90453, -1.82336>, <-0.415148, -0.557306, -0.71907>, <-0.0692318, 4.94148, -1.86867>, <-0.237343, -0.398844, -0.885772>, <-0.0636789, 4.90453, -1.84794> , <-0.214902, -0.557307, -0.802014> }
	smooth_triangle { <-0.0692318, 4.94148, -1.86867>, <-0.237343, -0.398844, -0.885772>, <-0.123018, 4.90453, -1.82336>, <-0.415148, -0.557306, -0.71907>, <-0.133746, 4.94148, -1.84195> , <-0.458506, -0.398837, -0.794167> }
	smooth_triangle { <-0.109429, 4.86923, -1.79983>, <-0.358515, -0.697039, -0.62097>, <-0.0636789, 4.90453, -1.84794>, <-0.214902, -0.557307, -0.802014>, <-0.0566444, 4.86923, -1.82169> , <-0.185584, -0.697034, -0.692605> }
	smooth_triangle { <-0.0636789, 4.90453, -1.84794>, <-0.214902, -0.557307, -0.802014>, <-0.109429, 4.86923, -1.79983>, <-0.358515, -0.697039, -0.62097>, <-0.123018, 4.90453, -1.82336> , <-0.415148, -0.557306, -0.71907> }
	smooth_triangle { <-0.109429, 4.86923, -1.79983>, <-0.358515, -0.697039, -0.62097>, <-0.0486508, 4.84402, -1.79186>, <-0.15403, -0.803636, -0.574843>, <-0.0939859, 4.84402, -1.77308> , <-0.29756, -0.803638, -0.515388> }
	smooth_triangle { <-0.0486508, 4.84402, -1.79186>, <-0.15403, -0.803636, -0.574843>, <-0.109429, 4.86923, -1.79983>, <-0.358515, -0.697039, -0.62097>, <-0.0566444, 4.86923, -1.82169> , <-0.185584, -0.697034, -0.692605> }
	smooth_triangle { <-0.0939859, 4.84402, -1.77308>, <-0.29756, -0.803638, -0.515388>, <-0.0361805, 4.81174, -1.74532>, <-0.117459, -0.891095, -0.438352>, <-0.0698953, 4.81174, -1.73135> , <-0.226909, -0.891095, -0.393017> }
	smooth_triangle { <-0.0361805, 4.81174, -1.74532>, <-0.117459, -0.891095, -0.438352>, <-0.0939859, 4.84402, -1.77308>, <-0.29756, -0.803638, -0.515388>, <-0.0486508, 4.84402, -1.79186> , <-0.15403, -0.803636, -0.574843> }
	smooth_triangle { <-0.0698953, 4.81174, -1.73135>, <-0.226909, -0.891095, -0.393017>, <-0.0233905, 4.79359, -1.69758>, <-0.0892507, -0.938662, -0.333087>, <-0.0451869, 4.79359, -1.68856> , <-0.172419, -0.938663, -0.298637> }
	smooth_triangle { <-0.0233905, 4.79359, -1.69758>, <-0.0892507, -0.938662, -0.333087>, <-0.0698953, 4.81174, -1.73135>, <-0.226909, -0.891095, -0.393017>, <-0.0361805, 4.81174, -1.74532> , <-0.117459, -0.891095, -0.438352> }
	smooth_triangle { <-0.0687949, 5.3584, -1.86704>, <-0.256618, 0.130135, -0.957712>, <-0.127342, 5.44312, -1.83085>, <-0.495751, 0.130132, -0.85866>, <-0.0659171, 5.44312, -1.8563> , <-0.256618, 0.130135, -0.957712> }
	smooth_triangle { <-0.127342, 5.44312, -1.83085>, <-0.495751, 0.130132, -0.85866>, <-0.0687949, 5.3584, -1.86704>, <-0.256618, 0.130135, -0.957712>, <-0.132902, 5.3584, -1.84048> , <-0.495751, 0.130132, -0.85866> }
	smooth_triangle { <-0.0451869, 4.79359, -1.68856>, <-0.0713946, -0.989754, -0.123655>, <-0.00112345, 4.78118, -1.61448>, <-0.0369492, -0.989755, -0.137914>, <-0.00217035, 4.78118, -1.61405> , <-0.0713946, -0.989754, -0.123655> }
	smooth_triangle { <-0.00112345, 4.78118, -1.61448>, <-0.0369492, -0.989755, -0.137914>, <-0.0451869, 4.79359, -1.68856>, <-0.0713946, -0.989754, -0.123655>, <-0.0233905, 4.79359, -1.69758> , <-0.0369492, -0.989755, -0.137914> }
	smooth_triangle { <-0.0648634, 5.42981, -1.85236>, <-0.203739, -0.616719, -0.760361>, <-3.03708e-009, 5.44312, -1.86497>, <-3.7547e-007, -0.292333, -0.956317>, <-2.98853e-009, 5.42981, -1.8609> , <1.88523e-007, -0.616738, -0.787169> }
	smooth_triangle { <-3.03708e-009, 5.44312, -1.86497>, <-3.7547e-007, -0.292333, -0.956317>, <-0.0648634, 5.42981, -1.85236>, <-0.203739, -0.616719, -0.760361>, <-0.0659171, 5.44312, -1.8563> , <-0.247515, -0.29231, -0.923738> }
	smooth_triangle { <-0.0648634, 5.42981, -1.85236>, <-0.203739, -0.616719, -0.760361>, <-2.91287e-009, 5.426, -1.85456>, <3.54087e-007, -0.964491, -0.264115>, <-0.0632214, 5.426, -1.84624> , <-0.0683621, -0.964488, -0.255126> }
	smooth_triangle { <-2.91287e-009, 5.426, -1.85456>, <3.54087e-007, -0.964491, -0.264115>, <-0.0648634, 5.42981, -1.85236>, <-0.203739, -0.616719, -0.760361>, <-2.98853e-009, 5.42981, -1.8609> , <1.88523e-007, -0.616738, -0.787169> }
	smooth_triangle { <-0.0632214, 5.426, -1.84624>, <-0.0683621, -0.964488, -0.255126>, <-7.5659e-012, 5.42727, -1.61092>, <-4.24334e-008, -0.999986, 0.00520769>, <-0.000164211, 5.42727, -1.6109> , <0.00134652, -0.999986, 0.00503172> }
	smooth_triangle { <-7.5659e-012, 5.42727, -1.61092>, <-4.24334e-008, -0.999986, 0.00520769>, <-0.0632214, 5.426, -1.84624>, <-0.0683621, -0.964488, -0.255126>, <-2.91287e-009, 5.426, -1.85456> , <3.54087e-007, -0.964491, -0.264115> }
	smooth_triangle { <-3.25806e-009, 5.29486, -1.88351>, <-4.13279e-008, 0.111142, -0.993804>, <-0.0687949, 5.3584, -1.86704>, <-0.257076, 0.115861, -0.959421>, <-3.16968e-009, 5.3584, -1.87609> , <-6.7626e-008, 0.115861, -0.993265> }
	smooth_triangle { <-0.0687949, 5.3584, -1.86704>, <-0.257076, 0.115861, -0.959421>, <-3.25806e-009, 5.29486, -1.88351>, <-4.13279e-008, 0.111142, -0.993804>, <-0.0707134, 5.29486, -1.8742> , <-0.257216, 0.111142, -0.959941> }
	smooth_triangle { <-3.39064e-009, 5.19097, -1.89462>, <-1.87908e-008, 0.0837964, -0.996483>, <-0.0707134, 5.29486, -1.8742>, <-0.257216, 0.111142, -0.959941>, <-3.25806e-009, 5.29486, -1.88351> , <-4.13279e-008, 0.111142, -0.993804> }
	smooth_triangle { <-0.0707134, 5.29486, -1.8742>, <-0.257216, 0.111142, -0.959941>, <-3.39064e-009, 5.19097, -1.89462>, <-1.87908e-008, 0.0837964, -0.996483>, <-0.073591, 5.19097, -1.88494> , <-0.257909, 0.0837972, -0.962528> }
	smooth_triangle { <-3.46432e-009, 5.09012, -1.9008>, <-1.12892e-008, 0.00603423, -0.999982>, <-0.073591, 5.19097, -1.88494>, <-0.257909, 0.0837972, -0.962529>, <-3.39064e-009, 5.19097, -1.89462> , <-1.87908e-008, 0.0837964, -0.996483> }
	smooth_triangle { <-0.073591, 5.19097, -1.88494>, <-0.257909, 0.0837972, -0.962529>, <-3.46432e-009, 5.09012, -1.9008>, <-1.12892e-008, 0.00603423, -0.999982>, <-0.0751897, 5.09012, -1.8909> , <-0.25881, 0.0060384, -0.965909> }
	smooth_triangle { <-0.0740867, 5.00337, -1.88679>, <-0.255008, -0.17088, -0.95172>, <-3.46432e-009, 5.09012, -1.9008>, <-1.12892e-008, 0.00603423, -0.999982>, <-3.41349e-009, 5.00337, -1.89654> , <1.77869e-007, -0.17088, -0.985292> }
	smooth_triangle { <-3.46432e-009, 5.09012, -1.9008>, <-1.12892e-008, 0.00603423, -0.999982>, <-0.0740867, 5.00337, -1.88679>, <-0.255008, -0.17088, -0.95172>, <-0.0751897, 5.09012, -1.8909> , <-0.25881, 0.0060384, -0.965909> }
	smooth_triangle { <-0.0692318, 4.94148, -1.86867>, <-0.237343, -0.398844, -0.885772>, <-3.41349e-009, 5.00337, -1.89654>, <1.77869e-007, -0.17088, -0.985292>, <-3.1898e-009, 4.94148, -1.87778> , <-1.51096e-007, -0.398839, -0.917021> }
	smooth_triangle { <-3.41349e-009, 5.00337, -1.89654>, <1.77869e-007, -0.17088, -0.985292>, <-0.0692318, 4.94148, -1.86867>, <-0.237343, -0.398844, -0.885772>, <-0.0740867, 5.00337, -1.88679> , <-0.255008, -0.17088, -0.95172> }
	smooth_triangle { <-0.0636789, 4.90453, -1.84794>, <-0.214902, -0.557307, -0.802014>, <-3.1898e-009, 4.94148, -1.87778>, <-1.51096e-007, -0.398839, -0.917021>, <-2.93395e-009, 4.90453, -1.85633> , <-2.64754e-007, -0.557305, -0.830308> }
	smooth_triangle { <-3.1898e-009, 4.94148, -1.87778>, <-1.51096e-007, -0.398839, -0.917021>, <-0.0636789, 4.90453, -1.84794>, <-0.214902, -0.557307, -0.802014>, <-0.0692318, 4.94148, -1.86867> , <-0.237343, -0.398844, -0.885772> }
	smooth_triangle { <-0.0566444, 4.86923, -1.82169>, <-0.185584, -0.697034, -0.692605>, <-2.93395e-009, 4.90453, -1.85633>, <-2.64754e-007, -0.557305, -0.830308>, <-2.60985e-009, 4.86923, -1.82915> , <-1.88336e-007, -0.697037, -0.717035> }
	smooth_triangle { <-2.93395e-009, 4.90453, -1.85633>, <-2.64754e-007, -0.557305, -0.830308>, <-0.0566444, 4.86923, -1.82169>, <-0.185584, -0.697034, -0.692605>, <-0.0636789, 4.90453, -1.84794> , <-0.214902, -0.557307, -0.802014> }
	smooth_triangle { <-0.0566444, 4.86923, -1.82169>, <-0.185584, -0.697034, -0.692605>, <-2.24154e-009, 4.84402, -1.79826>, <3.7409e-009, -0.803637, -0.59512>, <-0.0486508, 4.84402, -1.79186> , <-0.15403, -0.803636, -0.574843> }
	smooth_triangle { <-2.24154e-009, 4.84402, -1.79826>, <3.7409e-009, -0.803637, -0.59512>, <-0.0566444, 4.86923, -1.82169>, <-0.185584, -0.697034, -0.692605>, <-2.60985e-009, 4.86923, -1.82915> , <-1.88336e-007, -0.697037, -0.717035> }
	smooth_triangle { <-0.0486508, 4.84402, -1.79186>, <-0.15403, -0.803636, -0.574843>, <-1.66698e-009, 4.81174, -1.75008>, <1.04307e-007, -0.891095, -0.453817>, <-0.0361805, 4.81174, -1.74532> , <-0.117459, -0.891095, -0.438352> }
	smooth_triangle { <-1.66698e-009, 4.81174, -1.75008>, <1.04307e-007, -0.891095, -0.453817>, <-0.0486508, 4.84402, -1.79186>, <-0.15403, -0.803636, -0.574843>, <-2.24154e-009, 4.84402, -1.79826> , <3.7409e-009, -0.803637, -0.59512> }
	smooth_triangle { <-0.0361805, 4.81174, -1.74532>, <-0.117459, -0.891095, -0.438352>, <-1.0777e-009, 4.79359, -1.70066>, <-2.90872e-007, -0.938663, -0.344836>, <-0.0233905, 4.79359, -1.69758> , <-0.0892507, -0.938662, -0.333087> }
	smooth_triangle { <-1.0777e-009, 4.79359, -1.70066>, <-2.90872e-007, -0.938663, -0.344836>, <-0.0361805, 4.81174, -1.74532>, <-0.117459, -0.891095, -0.438352>, <-1.66698e-009, 4.81174, -1.75008> , <1.04307e-007, -0.891095, -0.453817> }
	smooth_triangle { <-3.16968e-009, 5.3584, -1.87609>, <7.51377e-008, 0.13013, -0.991497>, <-0.0659171, 5.44312, -1.8563>, <-0.256618, 0.130135, -0.957712>, <-3.03708e-009, 5.44312, -1.86497> , <7.51377e-008, 0.13013, -0.991497> }
	smooth_triangle { <-0.0659171, 5.44312, -1.8563>, <-0.256618, 0.130135, -0.957712>, <-3.16968e-009, 5.3584, -1.87609>, <7.51377e-008, 0.13013, -0.991497>, <-0.0687949, 5.3584, -1.86704> , <-0.256618, 0.130135, -0.957712> }
	smooth_triangle { <-0.0233905, 4.79359, -1.69758>, <-0.0369492, -0.989755, -0.137914>, <-5.17621e-011, 4.78118, -1.61463>, <-7.20039e-007, -0.989753, -0.142787>, <-0.00112345, 4.78118, -1.61448> , <-0.0369492, -0.989755, -0.137914> }
	smooth_triangle { <-5.17621e-011, 4.78118, -1.61463>, <-7.20039e-007, -0.989753, -0.142787>, <-0.0233905, 4.79359, -1.69758>, <-0.0369492, -0.989755, -0.137914>, <-1.0777e-009, 4.79359, -1.70066> , <-7.20039e-007, -0.989753, -0.142787> }
	smooth_triangle { <-2.98853e-009, 5.42981, -1.8609>, <1.88523e-007, -0.616738, -0.787169>, <0.0659171, 5.44312, -1.8563>, <0.247513, -0.292334, -0.92373>, <0.0648634, 5.42981, -1.85236> , <0.203732, -0.616739, -0.760346> }
	smooth_triangle { <0.0659171, 5.44312, -1.8563>, <0.247513, -0.292334, -0.92373>, <-2.98853e-009, 5.42981, -1.8609>, <1.88523e-007, -0.616738, -0.787169>, <-3.03708e-009, 5.44312, -1.86497> , <-3.7547e-007, -0.292333, -0.956317> }
	smooth_triangle { <-2.91287e-009, 5.426, -1.85456>, <3.53603e-007, -0.964491, -0.264115>, <0.0648634, 5.42981, -1.85236>, <0.203732, -0.616739, -0.760346>, <0.0632212, 5.426, -1.84624> , <0.0683568, -0.964491, -0.255115> }
	smooth_triangle { <0.0648634, 5.42981, -1.85236>, <0.203732, -0.616739, -0.760346>, <-2.91287e-009, 5.426, -1.85456>, <3.53603e-007, -0.964491, -0.264115>, <-2.98853e-009, 5.42981, -1.8609> , <1.88523e-007, -0.616738, -0.787169> }
	smooth_triangle { <-7.5659e-012, 5.42727, -1.61092>, <-4.24334e-008, -0.999986, 0.00520769>, <0.0632212, 5.426, -1.84624>, <0.0683568, -0.964491, -0.255115>, <0.000164211, 5.42727, -1.6109> , <-0.00134627, -0.999986, 0.00503133> }
	smooth_triangle { <0.0632212, 5.426, -1.84624>, <0.0683568, -0.964491, -0.255115>, <-7.5659e-012, 5.42727, -1.61092>, <-4.24334e-008, -0.999986, 0.00520769>, <-2.91287e-009, 5.426, -1.85456> , <3.5436e-007, -0.964491, -0.264115> }
	smooth_triangle { <0.0707134, 5.29486, -1.8742>, <0.257216, 0.111143, -0.959941>, <-3.16968e-009, 5.3584, -1.87609>, <-6.7626e-008, 0.115861, -0.993265>, <0.0687949, 5.3584, -1.86704> , <0.257076, 0.115861, -0.959421> }
	smooth_triangle { <-3.16968e-009, 5.3584, -1.87609>, <-6.7626e-008, 0.115861, -0.993265>, <0.0707134, 5.29486, -1.8742>, <0.257216, 0.111143, -0.959941>, <-3.25806e-009, 5.29486, -1.88351> , <-4.13279e-008, 0.111142, -0.993804> }
	smooth_triangle { <0.073591, 5.19097, -1.88494>, <0.257909, 0.0837965, -0.962529>, <-3.25806e-009, 5.29486, -1.88351>, <-4.13279e-008, 0.111142, -0.993804>, <0.0707134, 5.29486, -1.8742> , <0.257216, 0.111143, -0.959941> }
	smooth_triangle { <-3.25806e-009, 5.29486, -1.88351>, <-4.13279e-008, 0.111142, -0.993804>, <0.073591, 5.19097, -1.88494>, <0.257909, 0.0837965, -0.962529>, <-3.39064e-009, 5.19097, -1.89462> , <-2.2549e-008, 0.0837964, -0.996483> }
	smooth_triangle { <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <-3.39064e-009, 5.19097, -1.89462>, <-2.2549e-008, 0.0837965, -0.996483>, <0.073591, 5.19097, -1.88494> , <0.257909, 0.0837965, -0.962529> }
	smooth_triangle { <-3.39064e-009, 5.19097, -1.89462>, <-2.2549e-008, 0.0837965, -0.996483>, <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <-3.46432e-009, 5.09012, -1.9008> , <-1.12892e-008, 0.00603423, -0.999982> }
	smooth_triangle { <-3.41349e-009, 5.00337, -1.89654>, <1.77869e-007, -0.17088, -0.985292>, <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <0.0740867, 5.00337, -1.88679> , <0.255008, -0.170879, -0.95172> }
	smooth_triangle { <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <-3.41349e-009, 5.00337, -1.89654>, <1.77869e-007, -0.17088, -0.985292>, <-3.46432e-009, 5.09012, -1.9008> , <-1.12892e-008, 0.00603423, -0.999982> }
	smooth_triangle { <-3.1898e-009, 4.94148, -1.87778>, <-1.51096e-007, -0.398839, -0.917021>, <0.0740867, 5.00337, -1.88679>, <0.255008, -0.170879, -0.95172>, <0.0692318, 4.94148, -1.86867> , <0.237344, -0.398838, -0.885774> }
	smooth_triangle { <0.0740867, 5.00337, -1.88679>, <0.255008, -0.170879, -0.95172>, <-3.1898e-009, 4.94148, -1.87778>, <-1.51096e-007, -0.398839, -0.917021>, <-3.41349e-009, 5.00337, -1.89654> , <1.77869e-007, -0.17088, -0.985292> }
	smooth_triangle { <-2.93395e-009, 4.90453, -1.85633>, <-2.66631e-007, -0.557305, -0.830308>, <0.0692318, 4.94148, -1.86867>, <0.237344, -0.398838, -0.885774>, <0.0636789, 4.90453, -1.84794> , <0.214903, -0.557304, -0.802015> }
	smooth_triangle { <0.0692318, 4.94148, -1.86867>, <0.237344, -0.398838, -0.885774>, <-2.93395e-009, 4.90453, -1.85633>, <-2.66631e-007, -0.557305, -0.830308>, <-3.1898e-009, 4.94148, -1.87778> , <-1.51096e-007, -0.398839, -0.917021> }
	smooth_triangle { <-2.60985e-009, 4.86923, -1.82915>, <-1.88336e-007, -0.697037, -0.717035>, <0.0636789, 4.90453, -1.84794>, <0.214903, -0.557304, -0.802015>, <0.0566444, 4.86923, -1.82169> , <0.185583, -0.697037, -0.692603> }
	smooth_triangle { <0.0636789, 4.90453, -1.84794>, <0.214903, -0.557304, -0.802015>, <-2.60985e-009, 4.86923, -1.82915>, <-1.88336e-007, -0.697037, -0.717035>, <-2.93395e-009, 4.90453, -1.85633> , <-2.66631e-007, -0.557305, -0.830308> }
	smooth_triangle { <-2.24154e-009, 4.84402, -1.79826>, <5.61135e-009, -0.803637, -0.59512>, <0.0566444, 4.86923, -1.82169>, <0.185583, -0.697037, -0.692603>, <0.0486508, 4.84402, -1.79186> , <0.154029, -0.803636, -0.574842> }
	smooth_triangle { <0.0566444, 4.86923, -1.82169>, <0.185583, -0.697037, -0.692603>, <-2.24154e-009, 4.84402, -1.79826>, <5.61135e-009, -0.803637, -0.59512>, <-2.60985e-009, 4.86923, -1.82915> , <-1.88336e-007, -0.697037, -0.717035> }
	smooth_triangle { <-1.66698e-009, 4.81174, -1.75008>, <1.03368e-007, -0.891095, -0.453817>, <0.0486508, 4.84402, -1.79186>, <0.154029, -0.803636, -0.574842>, <0.0361805, 4.81174, -1.74532> , <0.117459, -0.891094, -0.438354> }
	smooth_triangle { <0.0486508, 4.84402, -1.79186>, <0.154029, -0.803636, -0.574842>, <-1.66698e-009, 4.81174, -1.75008>, <1.03368e-007, -0.891095, -0.453817>, <-2.24154e-009, 4.84402, -1.79826> , <5.61135e-009, -0.803637, -0.59512> }
	smooth_triangle { <-1.0777e-009, 4.79359, -1.70066>, <-2.90872e-007, -0.938663, -0.344836>, <0.0361805, 4.81174, -1.74532>, <0.117459, -0.891094, -0.438354>, <0.0233905, 4.79359, -1.69758> , <0.0892507, -0.938663, -0.333085> }
	smooth_triangle { <0.0361805, 4.81174, -1.74532>, <0.117459, -0.891094, -0.438354>, <-1.0777e-009, 4.79359, -1.70066>, <-2.90872e-007, -0.938663, -0.344836>, <-1.66698e-009, 4.81174, -1.75008> , <1.03368e-007, -0.891095, -0.453817> }
	smooth_triangle { <0.0687949, 5.3584, -1.86704>, <0.256618, 0.13013, -0.957713>, <-3.03708e-009, 5.44312, -1.86497>, <7.51377e-008, 0.13013, -0.991497>, <0.0659171, 5.44312, -1.8563> , <0.256618, 0.13013, -0.957713> }
	smooth_triangle { <-3.03708e-009, 5.44312, -1.86497>, <7.51377e-008, 0.13013, -0.991497>, <0.0687949, 5.3584, -1.86704>, <0.256618, 0.13013, -0.957713>, <-3.16968e-009, 5.3584, -1.87609> , <7.51377e-008, 0.13013, -0.991497> }
	smooth_triangle { <-5.17621e-011, 4.78118, -1.61463>, <-7.20039e-007, -0.989753, -0.142787>, <0.0233905, 4.79359, -1.69758>, <0.0369502, -0.989755, -0.137912>, <0.00112345, 4.78118, -1.61448> , <0.0369502, -0.989755, -0.137912> }
	smooth_triangle { <0.0233905, 4.79359, -1.69758>, <0.0369502, -0.989755, -0.137912>, <-5.17621e-011, 4.78118, -1.61463>, <-7.20039e-007, -0.989753, -0.142787>, <-1.0777e-009, 4.79359, -1.70066> , <-7.20039e-007, -0.989753, -0.142787> }
	smooth_triangle { <0.125307, 5.42981, -1.82733>, <0.393591, -0.616722, -0.681719>, <0.0659171, 5.44312, -1.8563>, <0.247513, -0.292334, -0.92373>, <0.127342, 5.44312, -1.83085> , <0.478162, -0.292309, -0.828201> }
	smooth_triangle { <0.0659171, 5.44312, -1.8563>, <0.247513, -0.292334, -0.92373>, <0.125307, 5.42981, -1.82733>, <0.393591, -0.616722, -0.681719>, <0.0648634, 5.42981, -1.85236> , <0.203732, -0.616739, -0.760346> }
	smooth_triangle { <0.0632212, 5.426, -1.84624>, <0.0683568, -0.964491, -0.255115>, <0.125307, 5.42981, -1.82733>, <0.393591, -0.616722, -0.681719>, <0.122134, 5.426, -1.82183> , <0.132063, -0.964489, -0.228736> }
	smooth_triangle { <0.125307, 5.42981, -1.82733>, <0.393591, -0.616722, -0.681719>, <0.0632212, 5.426, -1.84624>, <0.0683568, -0.964491, -0.255115>, <0.0648634, 5.42981, -1.85236> , <0.203732, -0.616739, -0.760346> }
	smooth_triangle { <0.000164211, 5.42727, -1.6109>, <-0.00134627, -0.999986, 0.00503133>, <0.122134, 5.426, -1.82183>, <0.132063, -0.964489, -0.228736>, <0.000317232, 5.42727, -1.61084> , <-0.00260136, -0.999986, 0.00451089> }
	smooth_triangle { <0.122134, 5.426, -1.82183>, <0.132063, -0.964489, -0.228736>, <0.000164211, 5.42727, -1.6109>, <-0.00134627, -0.999986, 0.00503133>, <0.0632212, 5.426, -1.84624> , <0.0683568, -0.964491, -0.255115> }
	smooth_triangle { <0.0707134, 5.29486, -1.8742>, <0.257216, 0.111143, -0.959941>, <0.132902, 5.3584, -1.84048>, <0.496638, 0.115861, -0.86019>, <0.136608, 5.29486, -1.8469> , <0.496909, 0.111142, -0.860656> }
	smooth_triangle { <0.132902, 5.3584, -1.84048>, <0.496638, 0.115861, -0.86019>, <0.0707134, 5.29486, -1.8742>, <0.257216, 0.111143, -0.959941>, <0.0687949, 5.3584, -1.86704> , <0.257076, 0.115861, -0.959421> }
	smooth_triangle { <0.073591, 5.19097, -1.88494>, <0.257909, 0.0837965, -0.962529>, <0.136608, 5.29486, -1.8469>, <0.496909, 0.111142, -0.860656>, <0.142167, 5.19097, -1.85653> , <0.498244, 0.083797, -0.862978> }
	smooth_triangle { <0.136608, 5.29486, -1.8469>, <0.496909, 0.111142, -0.860656>, <0.073591, 5.19097, -1.88494>, <0.257909, 0.0837965, -0.962529>, <0.0707134, 5.29486, -1.8742> , <0.257216, 0.111143, -0.959941> }
	smooth_triangle { <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <0.142167, 5.19097, -1.85653>, <0.498244, 0.083797, -0.862978>, <0.145256, 5.09012, -1.86188> , <0.499992, 0.00603833, -0.866009> }
	smooth_triangle { <0.142167, 5.19097, -1.85653>, <0.498244, 0.083797, -0.862978>, <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <0.073591, 5.19097, -1.88494> , <0.257909, 0.0837965, -0.962529> }
	smooth_triangle { <0.143125, 5.00337, -1.85819>, <0.492644, -0.170881, -0.853288>, <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <0.145256, 5.09012, -1.86188> , <0.499992, 0.00603833, -0.866009> }
	smooth_triangle { <0.0751897, 5.09012, -1.8909>, <0.25881, 0.00603439, -0.965909>, <0.143125, 5.00337, -1.85819>, <0.492644, -0.170881, -0.853288>, <0.0740867, 5.00337, -1.88679> , <0.255008, -0.170879, -0.95172> }
	smooth_triangle { <0.133746, 4.94148, -1.84195>, <0.458501, -0.398845, -0.794165>, <0.0740867, 5.00337, -1.88679>, <0.255008, -0.170879, -0.95172>, <0.143125, 5.00337, -1.85819> , <0.492644, -0.170881, -0.853288> }
	smooth_triangle { <0.0740867, 5.00337, -1.88679>, <0.255008, -0.170879, -0.95172>, <0.133746, 4.94148, -1.84195>, <0.458501, -0.398845, -0.794165>, <0.0692318, 4.94148, -1.86867> , <0.237344, -0.398838, -0.885774> }
	smooth_triangle { <0.123018, 4.90453, -1.82336>, <0.415147, -0.557307, -0.71907>, <0.0692318, 4.94148, -1.86867>, <0.237344, -0.398838, -0.885774>, <0.133746, 4.94148, -1.84195> , <0.458501, -0.398845, -0.794165> }
	smooth_triangle { <0.0692318, 4.94148, -1.86867>, <0.237344, -0.398838, -0.885774>, <0.123018, 4.90453, -1.82336>, <0.415147, -0.557307, -0.71907>, <0.0636789, 4.90453, -1.84794> , <0.214903, -0.557304, -0.802015> }
	smooth_triangle { <0.109429, 4.86923, -1.79983>, <0.358518, -0.697034, -0.620973>, <0.0636789, 4.90453, -1.84794>, <0.214903, -0.557304, -0.802015>, <0.123018, 4.90453, -1.82336> , <0.415147, -0.557307, -0.71907> }
	smooth_triangle { <0.0636789, 4.90453, -1.84794>, <0.214903, -0.557304, -0.802015>, <0.109429, 4.86923, -1.79983>, <0.358518, -0.697034, -0.620973>, <0.0566444, 4.86923, -1.82169> , <0.185583, -0.697037, -0.692603> }
	smooth_triangle { <0.0486508, 4.84402, -1.79186>, <0.154029, -0.803636, -0.574842>, <0.109429, 4.86923, -1.79983>, <0.358518, -0.697034, -0.620973>, <0.0939859, 4.84402, -1.77308> , <0.297561, -0.803636, -0.515389> }
	smooth_triangle { <0.109429, 4.86923, -1.79983>, <0.358518, -0.697034, -0.620973>, <0.0486508, 4.84402, -1.79186>, <0.154029, -0.803636, -0.574842>, <0.0566444, 4.86923, -1.82169> , <0.185583, -0.697037, -0.692603> }
	smooth_triangle { <0.0361805, 4.81174, -1.74532>, <0.117459, -0.891094, -0.438354>, <0.0939859, 4.84402, -1.77308>, <0.297561, -0.803636, -0.515389>, <0.0698953, 4.81174, -1.73135> , <0.226908, -0.891095, -0.393017> }
	smooth_triangle { <0.0939859, 4.84402, -1.77308>, <0.297561, -0.803636, -0.515389>, <0.0361805, 4.81174, -1.74532>, <0.117459, -0.891094, -0.438354>, <0.0486508, 4.84402, -1.79186> , <0.154029, -0.803636, -0.574842> }
	smooth_triangle { <0.0233905, 4.79359, -1.69758>, <0.0892507, -0.938663, -0.333085>, <0.0698953, 4.81174, -1.73135>, <0.226908, -0.891095, -0.393017>, <0.0451869, 4.79359, -1.68856> , <0.172419, -0.938663, -0.298638> }
	smooth_triangle { <0.0698953, 4.81174, -1.73135>, <0.226908, -0.891095, -0.393017>, <0.0233905, 4.79359, -1.69758>, <0.0892507, -0.938663, -0.333085>, <0.0361805, 4.81174, -1.74532> , <0.117459, -0.891094, -0.438354> }
	smooth_triangle { <0.0687949, 5.3584, -1.86704>, <0.256618, 0.13013, -0.957713>, <0.127342, 5.44312, -1.83085>, <0.495751, 0.130134, -0.85866>, <0.132902, 5.3584, -1.84048> , <0.495751, 0.130134, -0.85866> }
	smooth_triangle { <0.127342, 5.44312, -1.83085>, <0.495751, 0.130134, -0.85866>, <0.0687949, 5.3584, -1.86704>, <0.256618, 0.13013, -0.957713>, <0.0659171, 5.44312, -1.8563> , <0.256618, 0.13013, -0.957713> }
	smooth_triangle { <0.00112345, 4.78118, -1.61448>, <0.0369502, -0.989755, -0.137912>, <0.0451869, 4.79359, -1.68856>, <0.0713938, -0.989754, -0.123656>, <0.00217035, 4.78118, -1.61405> , <0.0713938, -0.989754, -0.123656> }
	smooth_triangle { <0.0451869, 4.79359, -1.68856>, <0.0713938, -0.989754, -0.123656>, <0.00112345, 4.78118, -1.61448>, <0.0369502, -0.989755, -0.137912>, <0.0233905, 4.79359, -1.69758> , <0.0369502, -0.989755, -0.137912> }
	smooth_triangle { <0.17721, 5.42981, -1.7875>, <0.55662, -0.616718, -0.556627>, <0.127342, 5.44312, -1.83085>, <0.478162, -0.292309, -0.828201>, <0.180089, 5.44312, -1.79038> , <0.676216, -0.292313, -0.676228> }
	smooth_triangle { <0.127342, 5.44312, -1.83085>, <0.478162, -0.292309, -0.828201>, <0.17721, 5.42981, -1.7875>, <0.55662, -0.616718, -0.556627>, <0.125307, 5.42981, -1.82733> , <0.393591, -0.616722, -0.681719> }
	smooth_triangle { <0.122134, 5.426, -1.82183>, <0.132063, -0.964489, -0.228736>, <0.17721, 5.42981, -1.7875>, <0.55662, -0.616718, -0.556627>, <0.172724, 5.426, -1.78301> , <0.186767, -0.964487, -0.186768> }
	smooth_triangle { <0.17721, 5.42981, -1.7875>, <0.55662, -0.616718, -0.556627>, <0.122134, 5.426, -1.82183>, <0.132063, -0.964489, -0.228736>, <0.125307, 5.42981, -1.82733> , <0.393591, -0.616722, -0.681719> }
	smooth_triangle { <0.000317232, 5.42727, -1.61084>, <-0.00260136, -0.999986, 0.00451089>, <0.172724, 5.426, -1.78301>, <0.186767, -0.964487, -0.186768>, <0.000448634, 5.42727, -1.61074> , <-0.00368265, -0.999986, 0.00368269> }
	smooth_triangle { <0.172724, 5.426, -1.78301>, <0.186767, -0.964487, -0.186768>, <0.000317232, 5.42727, -1.61084>, <-0.00260136, -0.999986, 0.00451089>, <0.122134, 5.426, -1.82183> , <0.132063, -0.964489, -0.228736> }
	smooth_triangle { <0.136608, 5.29486, -1.8469>, <0.496909, 0.111142, -0.860656>, <0.187951, 5.3584, -1.79824>, <0.702345, 0.115858, -0.702345>, <0.193192, 5.29486, -1.80348> , <0.702726, 0.111139, -0.702726> }
	smooth_triangle { <0.187951, 5.3584, -1.79824>, <0.702345, 0.115858, -0.702345>, <0.136608, 5.29486, -1.8469>, <0.496909, 0.111142, -0.860656>, <0.132902, 5.3584, -1.84048> , <0.496638, 0.115861, -0.86019> }
	smooth_triangle { <0.142167, 5.19097, -1.85653>, <0.498244, 0.083797, -0.862978>, <0.193192, 5.29486, -1.80348>, <0.702726, 0.111139, -0.702726>, <0.201054, 5.19097, -1.81134> , <0.704621, 0.0838004, -0.704618> }
	smooth_triangle { <0.193192, 5.29486, -1.80348>, <0.702726, 0.111139, -0.702726>, <0.142167, 5.19097, -1.85653>, <0.498244, 0.083797, -0.862978>, <0.136608, 5.29486, -1.8469> , <0.496909, 0.111142, -0.860656> }
	smooth_triangle { <0.145256, 5.09012, -1.86188>, <0.499992, 0.00603833, -0.866009>, <0.201054, 5.19097, -1.81134>, <0.704621, 0.0838004, -0.704618>, <0.205423, 5.09012, -1.81571> , <0.707098, 0.00603922, -0.70709> }
	smooth_triangle { <0.201054, 5.19097, -1.81134>, <0.704621, 0.0838004, -0.704618>, <0.145256, 5.09012, -1.86188>, <0.499992, 0.00603833, -0.866009>, <0.142167, 5.19097, -1.85653> , <0.498244, 0.083797, -0.862978> }
	smooth_triangle { <0.202408, 5.00337, -1.8127>, <0.69671, -0.170879, -0.696704>, <0.145256, 5.09012, -1.86188>, <0.499992, 0.00603833, -0.866009>, <0.205423, 5.09012, -1.81571> , <0.707098, 0.00603922, -0.70709> }
	smooth_triangle { <0.145256, 5.09012, -1.86188>, <0.499992, 0.00603833, -0.866009>, <0.202408, 5.00337, -1.8127>, <0.69671, -0.170879, -0.696704>, <0.143125, 5.00337, -1.85819> , <0.492644, -0.170881, -0.853288> }
	smooth_triangle { <0.189144, 4.94148, -1.79944>, <0.648434, -0.398838, -0.648431>, <0.143125, 5.00337, -1.85819>, <0.492644, -0.170881, -0.853288>, <0.202408, 5.00337, -1.8127> , <0.69671, -0.170879, -0.696704> }
	smooth_triangle { <0.143125, 5.00337, -1.85819>, <0.492644, -0.170881, -0.853288>, <0.189144, 4.94148, -1.79944>, <0.648434, -0.398838, -0.648431>, <0.133746, 4.94148, -1.84195> , <0.458501, -0.398845, -0.794165> }
	smooth_triangle { <0.173975, 4.90453, -1.78427>, <0.587117, -0.557308, -0.587113>, <0.133746, 4.94148, -1.84195>, <0.458501, -0.398845, -0.794165>, <0.189144, 4.94148, -1.79944> , <0.648434, -0.398838, -0.648431> }
	smooth_triangle { <0.133746, 4.94148, -1.84195>, <0.458501, -0.398845, -0.794165>, <0.173975, 4.90453, -1.78427>, <0.587117, -0.557308, -0.587113>, <0.123018, 4.90453, -1.82336> , <0.415147, -0.557307, -0.71907> }
	smooth_triangle { <0.154756, 4.86923, -1.76505>, <0.507022, -0.697039, -0.507016>, <0.123018, 4.90453, -1.82336>, <0.415147, -0.557307, -0.71907>, <0.173975, 4.90453, -1.78427> , <0.587117, -0.557308, -0.587113> }
	smooth_triangle { <0.123018, 4.90453, -1.82336>, <0.415147, -0.557307, -0.71907>, <0.154756, 4.86923, -1.76505>, <0.507022, -0.697039, -0.507016>, <0.109429, 4.86923, -1.79983> , <0.358518, -0.697034, -0.620973> }
	smooth_triangle { <0.0939859, 4.84402, -1.77308>, <0.297561, -0.803636, -0.515389>, <0.154756, 4.86923, -1.76505>, <0.507022, -0.697039, -0.507016>, <0.132916, 4.84402, -1.74321> , <0.420815, -0.803637, -0.420811> }
	smooth_triangle { <0.154756, 4.86923, -1.76505>, <0.507022, -0.697039, -0.507016>, <0.0939859, 4.84402, -1.77308>, <0.297561, -0.803636, -0.515389>, <0.109429, 4.86923, -1.79983> , <0.358518, -0.697034, -0.620973> }
	smooth_triangle { <0.0698953, 4.81174, -1.73135>, <0.226908, -0.891095, -0.393017>, <0.132916, 4.84402, -1.74321>, <0.420815, -0.803637, -0.420811>, <0.0988468, 4.81174, -1.70914> , <0.320898, -0.891095, -0.320897> }
	smooth_triangle { <0.132916, 4.84402, -1.74321>, <0.420815, -0.803637, -0.420811>, <0.0698953, 4.81174, -1.73135>, <0.226908, -0.891095, -0.393017>, <0.0939859, 4.84402, -1.77308> , <0.297561, -0.803636, -0.515389> }
	smooth_triangle { <0.0451869, 4.79359, -1.68856>, <0.172419, -0.938663, -0.298638>, <0.0988468, 4.81174, -1.70914>, <0.320898, -0.891095, -0.320897>, <0.063904, 4.79359, -1.67419> , <0.243836, -0.938663, -0.243836> }
	smooth_triangle { <0.0988468, 4.81174, -1.70914>, <0.320898, -0.891095, -0.320897>, <0.0451869, 4.79359, -1.68856>, <0.172419, -0.938663, -0.298638>, <0.0698953, 4.81174, -1.73135> , <0.226908, -0.891095, -0.393017> }
	smooth_triangle { <0.132902, 5.3584, -1.84048>, <0.495751, 0.130134, -0.85866>, <0.180089, 5.44312, -1.79038>, <0.701093, 0.130131, -0.701095>, <0.187951, 5.3584, -1.79824> , <0.701093, 0.130131, -0.701095> }
	smooth_triangle { <0.180089, 5.44312, -1.79038>, <0.701093, 0.130131, -0.701095>, <0.132902, 5.3584, -1.84048>, <0.495751, 0.130134, -0.85866>, <0.127342, 5.44312, -1.83085> , <0.495751, 0.130134, -0.85866> }
	smooth_triangle { <0.00217035, 4.78118, -1.61405>, <0.0713938, -0.989754, -0.123656>, <0.063904, 4.79359, -1.67419>, <0.100958, -0.989755, -0.10096>, <0.00306932, 4.78118, -1.61336> , <0.100958, -0.989755, -0.10096> }
	smooth_triangle { <0.063904, 4.79359, -1.67419>, <0.100958, -0.989755, -0.10096>, <0.00217035, 4.78118, -1.61405>, <0.0713938, -0.989754, -0.123656>, <0.0451869, 4.79359, -1.68856> , <0.0713938, -0.989754, -0.123656> }
	smooth_triangle { <0.217038, 5.42981, -1.7356>, <0.681715, -0.616728, -0.393588>, <0.180089, 5.44312, -1.79038>, <0.676216, -0.292313, -0.676228>, <0.220563, 5.44312, -1.73763> , <0.8282, -0.292314, -0.47816> }
	smooth_triangle { <0.180089, 5.44312, -1.79038>, <0.676216, -0.292313, -0.676228>, <0.217038, 5.42981, -1.7356>, <0.681715, -0.616728, -0.393588>, <0.17721, 5.42981, -1.7875> , <0.55662, -0.616718, -0.556627> }
	smooth_triangle { <0.172724, 5.426, -1.78301>, <0.186767, -0.964487, -0.186768>, <0.217038, 5.42981, -1.7356>, <0.681715, -0.616728, -0.393588>, <0.211543, 5.426, -1.73242> , <0.228732, -0.964491, -0.132059> }
	smooth_triangle { <0.217038, 5.42981, -1.7356>, <0.681715, -0.616728, -0.393588>, <0.172724, 5.426, -1.78301>, <0.186767, -0.964487, -0.186768>, <0.17721, 5.42981, -1.7875> , <0.55662, -0.616718, -0.556627> }
	smooth_triangle { <0.000448634, 5.42727, -1.61074>, <-0.00368265, -0.999986, 0.00368269>, <0.211543, 5.426, -1.73242>, <0.228732, -0.964491, -0.132059>, <0.000549461, 5.42727, -1.61061> , <-0.00451018, -0.999986, 0.00260398> }
	smooth_triangle { <0.211543, 5.426, -1.73242>, <0.228732, -0.964491, -0.132059>, <0.000448634, 5.42727, -1.61074>, <-0.00368265, -0.999986, 0.00368269>, <0.172724, 5.426, -1.78301> , <0.186767, -0.964487, -0.186768> }
	smooth_triangle { <0.236611, 5.29486, -1.7469>, <0.860656, 0.111139, -0.496909>, <0.187951, 5.3584, -1.79824>, <0.702345, 0.115858, -0.702345>, <0.230192, 5.3584, -1.74319> , <0.86019, 0.115858, -0.496639> }
	smooth_triangle { <0.187951, 5.3584, -1.79824>, <0.702345, 0.115858, -0.702345>, <0.236611, 5.29486, -1.7469>, <0.860656, 0.111139, -0.496909>, <0.193192, 5.29486, -1.80348> , <0.702726, 0.111139, -0.702726> }
	smooth_triangle { <0.24624, 5.19097, -1.75246>, <0.862977, 0.0837995, -0.498246>, <0.193192, 5.29486, -1.80348>, <0.702726, 0.111139, -0.702726>, <0.236611, 5.29486, -1.7469> , <0.860656, 0.111139, -0.496909> }
	smooth_triangle { <0.193192, 5.29486, -1.80348>, <0.702726, 0.111139, -0.702726>, <0.24624, 5.19097, -1.75246>, <0.862977, 0.0837995, -0.498246>, <0.201054, 5.19097, -1.81134> , <0.704622, 0.0838004, -0.704618> }
	smooth_triangle { <0.25159, 5.09012, -1.75555>, <0.866008, 0.00603708, -0.499994>, <0.201054, 5.19097, -1.81134>, <0.704622, 0.0838004, -0.704618>, <0.24624, 5.19097, -1.75246> , <0.862977, 0.0837995, -0.498246> }
	smooth_triangle { <0.201054, 5.19097, -1.81134>, <0.704622, 0.0838004, -0.704618>, <0.25159, 5.09012, -1.75555>, <0.866008, 0.00603708, -0.499994>, <0.205423, 5.09012, -1.81571> , <0.707098, 0.00603922, -0.70709> }
	smooth_triangle { <0.247899, 5.00337, -1.75342>, <0.853287, -0.170881, -0.492647>, <0.205423, 5.09012, -1.81571>, <0.707098, 0.00603922, -0.70709>, <0.25159, 5.09012, -1.75555> , <0.866008, 0.00603708, -0.499994> }
	smooth_triangle { <0.205423, 5.09012, -1.81571>, <0.707098, 0.00603922, -0.70709>, <0.247899, 5.00337, -1.75342>, <0.853287, -0.170881, -0.492647>, <0.202408, 5.00337, -1.8127> , <0.69671, -0.170879, -0.696704> }
	smooth_triangle { <0.231654, 4.94148, -1.74404>, <0.794169, -0.398833, -0.458507>, <0.202408, 5.00337, -1.8127>, <0.69671, -0.170879, -0.696704>, <0.247899, 5.00337, -1.75342> , <0.853287, -0.170881, -0.492647> }
	smooth_triangle { <0.202408, 5.00337, -1.8127>, <0.69671, -0.170879, -0.696704>, <0.231654, 4.94148, -1.74404>, <0.794169, -0.398833, -0.458507>, <0.189144, 4.94148, -1.79944> , <0.648434, -0.398838, -0.648431> }
	smooth_triangle { <0.213074, 4.90453, -1.73331>, <0.71907, -0.557306, -0.415149>, <0.189144, 4.94148, -1.79944>, <0.648434, -0.398838, -0.648431>, <0.231654, 4.94148, -1.74404> , <0.794169, -0.398833, -0.458507> }
	smooth_triangle { <0.189144, 4.94148, -1.79944>, <0.648434, -0.398838, -0.648431>, <0.213074, 4.90453, -1.73331>, <0.71907, -0.557306, -0.415149>, <0.173975, 4.90453, -1.78427> , <0.587117, -0.557308, -0.587113> }
	smooth_triangle { <0.189535, 4.86923, -1.71972>, <0.620967, -0.697041, -0.358515>, <0.173975, 4.90453, -1.78427>, <0.587117, -0.557308, -0.587113>, <0.213074, 4.90453, -1.73331> , <0.71907, -0.557306, -0.415149> }
	smooth_triangle { <0.173975, 4.90453, -1.78427>, <0.587117, -0.557308, -0.587113>, <0.189535, 4.86923, -1.71972>, <0.620967, -0.697041, -0.358515>, <0.154756, 4.86923, -1.76505> , <0.507022, -0.697039, -0.507016> }
	smooth_triangle { <0.132916, 4.84402, -1.74321>, <0.420815, -0.803637, -0.420811>, <0.189535, 4.86923, -1.71972>, <0.620967, -0.697041, -0.358515>, <0.162788, 4.84402, -1.70428> , <0.515389, -0.803636, -0.297562> }
	smooth_triangle { <0.189535, 4.86923, -1.71972>, <0.620967, -0.697041, -0.358515>, <0.132916, 4.84402, -1.74321>, <0.420815, -0.803637, -0.420811>, <0.154756, 4.86923, -1.76505> , <0.507022, -0.697039, -0.507016> }
	smooth_triangle { <0.0988468, 4.81174, -1.70914>, <0.320898, -0.891095, -0.320897>, <0.162788, 4.84402, -1.70428>, <0.515389, -0.803636, -0.297562>, <0.121062, 4.81174, -1.68019> , <0.393019, -0.891094, -0.226909> }
	smooth_triangle { <0.162788, 4.84402, -1.70428>, <0.515389, -0.803636, -0.297562>, <0.0988468, 4.81174, -1.70914>, <0.320898, -0.891095, -0.320897>, <0.132916, 4.84402, -1.74321> , <0.420815, -0.803637, -0.420811> }
	smooth_triangle { <0.063904, 4.79359, -1.67419>, <0.243836, -0.938663, -0.243836>, <0.121062, 4.81174, -1.68019>, <0.393019, -0.891094, -0.226909>, <0.078266, 4.79359, -1.65548> , <0.298637, -0.938663, -0.172418> }
	smooth_triangle { <0.121062, 4.81174, -1.68019>, <0.393019, -0.891094, -0.226909>, <0.063904, 4.79359, -1.67419>, <0.243836, -0.938663, -0.243836>, <0.0988468, 4.81174, -1.70914> , <0.320898, -0.891095, -0.320897> }
	smooth_triangle { <0.230192, 5.3584, -1.74319>, <0.85866, 0.130126, -0.495752>, <0.180089, 5.44312, -1.79038>, <0.701093, 0.130131, -0.701095>, <0.220563, 5.44312, -1.73763> , <0.85866, 0.130126, -0.495752> }
	smooth_triangle { <0.180089, 5.44312, -1.79038>, <0.701093, 0.130131, -0.701095>, <0.230192, 5.3584, -1.74319>, <0.85866, 0.130126, -0.495752>, <0.187951, 5.3584, -1.79824> , <0.701093, 0.130131, -0.701095> }
	smooth_triangle { <0.00306932, 4.78118, -1.61336>, <0.100958, -0.989755, -0.10096>, <0.078266, 4.79359, -1.65548>, <0.123662, -0.989754, -0.0713816>, <0.00375913, 4.78118, -1.61246> , <0.123662, -0.989754, -0.0713816> }
	smooth_triangle { <0.078266, 4.79359, -1.65548>, <0.123662, -0.989754, -0.0713816>, <0.00306932, 4.78118, -1.61336>, <0.100958, -0.989755, -0.10096>, <0.063904, 4.79359, -1.67419> , <0.100958, -0.989755, -0.10096> }
	smooth_triangle { <0.242074, 5.42981, -1.67515>, <0.760364, -0.616717, -0.203733>, <0.220563, 5.44312, -1.73763>, <0.8282, -0.292314, -0.47816>, <0.246005, 5.44312, -1.67621> , <0.92375, -0.292275, -0.24751> }
	smooth_triangle { <0.220563, 5.44312, -1.73763>, <0.8282, -0.292314, -0.47816>, <0.242074, 5.42981, -1.67515>, <0.760364, -0.616717, -0.203733>, <0.217038, 5.42981, -1.7356> , <0.681715, -0.616728, -0.393588> }
	smooth_triangle { <0.211543, 5.426, -1.73242>, <0.228732, -0.964491, -0.132059>, <0.242074, 5.42981, -1.67515>, <0.760364, -0.616717, -0.203733>, <0.235945, 5.426, -1.67351> , <0.255112, -0.964492, -0.0683558> }
	smooth_triangle { <0.242074, 5.42981, -1.67515>, <0.760364, -0.616717, -0.203733>, <0.211543, 5.426, -1.73242>, <0.228732, -0.964491, -0.132059>, <0.217038, 5.42981, -1.7356> , <0.681715, -0.616728, -0.393588> }
	smooth_triangle { <0.000549461, 5.42727, -1.61061>, <-0.00451018, -0.999986, 0.00260398>, <0.235945, 5.426, -1.67351>, <0.255112, -0.964492, -0.0683558>, <0.000612844, 5.42727, -1.61045> , <-0.00503071, -0.999986, 0.00134759> }
	smooth_triangle { <0.235945, 5.426, -1.67351>, <0.255112, -0.964492, -0.0683558>, <0.000549461, 5.42727, -1.61061>, <-0.00451018, -0.999986, 0.00260398>, <0.211543, 5.426, -1.73242> , <0.228732, -0.964491, -0.132059> }
	smooth_triangle { <0.263906, 5.29486, -1.681>, <0.959941, 0.111142, -0.257217>, <0.230192, 5.3584, -1.74319>, <0.86019, 0.115858, -0.496639>, <0.256747, 5.3584, -1.67908> , <0.959421, 0.115861, -0.257076> }
	smooth_triangle { <0.230192, 5.3584, -1.74319>, <0.86019, 0.115858, -0.496639>, <0.263906, 5.29486, -1.681>, <0.959941, 0.111142, -0.257217>, <0.236611, 5.29486, -1.7469> , <0.860656, 0.111139, -0.496909> }
	smooth_triangle { <0.274646, 5.19097, -1.68388>, <0.962528, 0.0837989, -0.25791>, <0.236611, 5.29486, -1.7469>, <0.860656, 0.111139, -0.496909>, <0.263906, 5.29486, -1.681> , <0.959941, 0.111142, -0.257217> }
	smooth_triangle { <0.236611, 5.29486, -1.7469>, <0.860656, 0.111139, -0.496909>, <0.274646, 5.19097, -1.68388>, <0.962528, 0.0837989, -0.25791>, <0.24624, 5.19097, -1.75246> , <0.862977, 0.0837995, -0.498246> }
	smooth_triangle { <0.280613, 5.09012, -1.68548>, <0.965908, 0.00603578, -0.258814>, <0.24624, 5.19097, -1.75246>, <0.862977, 0.0837995, -0.498246>, <0.274646, 5.19097, -1.68388> , <0.962528, 0.0837989, -0.25791> }
	smooth_triangle { <0.24624, 5.19097, -1.75246>, <0.862977, 0.0837995, -0.498246>, <0.280613, 5.09012, -1.68548>, <0.965908, 0.00603578, -0.258814>, <0.25159, 5.09012, -1.75555> , <0.866008, 0.00603708, -0.499994> }
	smooth_triangle { <0.276495, 5.00337, -1.68438>, <0.951717, -0.170885, -0.255014>, <0.25159, 5.09012, -1.75555>, <0.866008, 0.00603708, -0.499994>, <0.280613, 5.09012, -1.68548> , <0.965908, 0.00603578, -0.258814> }
	smooth_triangle { <0.25159, 5.09012, -1.75555>, <0.866008, 0.00603708, -0.499994>, <0.276495, 5.00337, -1.68438>, <0.951717, -0.170885, -0.255014>, <0.247899, 5.00337, -1.75342> , <0.853287, -0.170881, -0.492647> }
	smooth_triangle { <0.258376, 4.94148, -1.67952>, <0.885774, -0.39884, -0.237343>, <0.247899, 5.00337, -1.75342>, <0.853287, -0.170881, -0.492647>, <0.276495, 5.00337, -1.68438> , <0.951717, -0.170885, -0.255014> }
	smooth_triangle { <0.247899, 5.00337, -1.75342>, <0.853287, -0.170881, -0.492647>, <0.258376, 4.94148, -1.67952>, <0.885774, -0.39884, -0.237343>, <0.231654, 4.94148, -1.74404> , <0.794169, -0.398833, -0.458507> }
	smooth_triangle { <0.237653, 4.90453, -1.67397>, <0.802014, -0.557307, -0.214902>, <0.231654, 4.94148, -1.74404>, <0.794169, -0.398833, -0.458507>, <0.258376, 4.94148, -1.67952> , <0.885774, -0.39884, -0.237343> }
	smooth_triangle { <0.231654, 4.94148, -1.74404>, <0.794169, -0.398833, -0.458507>, <0.237653, 4.90453, -1.67397>, <0.802014, -0.557307, -0.214902>, <0.213074, 4.90453, -1.73331> , <0.71907, -0.557306, -0.415149> }
	smooth_triangle { <0.2114, 4.86923, -1.66693>, <0.692601, -0.697038, -0.185589>, <0.213074, 4.90453, -1.73331>, <0.71907, -0.557306, -0.415149>, <0.237653, 4.90453, -1.67397> , <0.802014, -0.557307, -0.214902> }
	smooth_triangle { <0.213074, 4.90453, -1.73331>, <0.71907, -0.557306, -0.415149>, <0.2114, 4.86923, -1.66693>, <0.692601, -0.697038, -0.185589>, <0.189535, 4.86923, -1.71972> , <0.620967, -0.697041, -0.358515> }
	smooth_triangle { <0.162788, 4.84402, -1.70428>, <0.515389, -0.803636, -0.297562>, <0.2114, 4.86923, -1.66693>, <0.692601, -0.697038, -0.185589>, <0.181567, 4.84402, -1.65894> , <0.574843, -0.803635, -0.154034> }
	smooth_triangle { <0.2114, 4.86923, -1.66693>, <0.692601, -0.697038, -0.185589>, <0.162788, 4.84402, -1.70428>, <0.515389, -0.803636, -0.297562>, <0.189535, 4.86923, -1.71972> , <0.620967, -0.697041, -0.358515> }
	smooth_triangle { <0.121062, 4.81174, -1.68019>, <0.393019, -0.891094, -0.226909>, <0.181567, 4.84402, -1.65894>, <0.574843, -0.803635, -0.154034>, <0.135027, 4.81174, -1.64647> , <0.438354, -0.891095, -0.11746> }
	smooth_triangle { <0.181567, 4.84402, -1.65894>, <0.574843, -0.803635, -0.154034>, <0.121062, 4.81174, -1.68019>, <0.393019, -0.891094, -0.226909>, <0.162788, 4.84402, -1.70428> , <0.515389, -0.803636, -0.297562> }
	smooth_triangle { <0.078266, 4.79359, -1.65548>, <0.298637, -0.938663, -0.172418>, <0.135027, 4.81174, -1.64647>, <0.438354, -0.891095, -0.11746>, <0.0872945, 4.79359, -1.63368> , <0.333086, -0.938663, -0.0892508> }
	smooth_triangle { <0.135027, 4.81174, -1.64647>, <0.438354, -0.891095, -0.11746>, <0.078266, 4.79359, -1.65548>, <0.298637, -0.938663, -0.172418>, <0.121062, 4.81174, -1.68019> , <0.393019, -0.891094, -0.22691> }
	smooth_triangle { <0.256747, 5.3584, -1.67908>, <0.957712, 0.130135, -0.256617>, <0.220563, 5.44312, -1.73763>, <0.85866, 0.130126, -0.495752>, <0.246005, 5.44312, -1.67621> , <0.957712, 0.130135, -0.256617> }
	smooth_triangle { <0.220563, 5.44312, -1.73763>, <0.85866, 0.130126, -0.495752>, <0.256747, 5.3584, -1.67908>, <0.957712, 0.130135, -0.256617>, <0.230192, 5.3584, -1.74319> , <0.85866, 0.130126, -0.495752> }
	smooth_triangle { <0.00375913, 4.78118, -1.61246>, <0.123662, -0.989754, -0.0713816>, <0.0872945, 4.79359, -1.63368>, <0.137916, -0.989754, -0.0369551>, <0.00419277, 4.78118, -1.61141> , <0.137916, -0.989754, -0.0369551> }
	smooth_triangle { <0.0872945, 4.79359, -1.63368>, <0.137916, -0.989754, -0.0369551>, <0.00375913, 4.78118, -1.61246>, <0.123662, -0.989754, -0.0713816>, <0.078266, 4.79359, -1.65548> , <0.123662, -0.989754, -0.0713816> }
	smooth_triangle { <0.250613, 5.42981, -1.61029>, <0.78718, -0.616723, -5.01395e-007>, <0.246005, 5.44312, -1.67621>, <0.92375, -0.292275, -0.24751>, <0.254684, 5.44312, -1.61029> , <0.956327, -0.292299, -1.68961e-006> }
	smooth_triangle { <0.246005, 5.44312, -1.67621>, <0.92375, -0.292275, -0.24751>, <0.250613, 5.42981, -1.61029>, <0.78718, -0.616723, -5.01395e-007>, <0.242074, 5.42981, -1.67515> , <0.760364, -0.616717, -0.203733> }
	smooth_triangle { <0.235945, 5.426, -1.67351>, <0.255112, -0.964492, -0.0683558>, <0.250613, 5.42981, -1.61029>, <0.78718, -0.616723, -5.01395e-007>, <0.244268, 5.426, -1.61029> , <0.264115, -0.964491, 3.892e-007> }
	smooth_triangle { <0.250613, 5.42981, -1.61029>, <0.78718, -0.616723, -5.01395e-007>, <0.235945, 5.426, -1.67351>, <0.255112, -0.964492, -0.0683558>, <0.242074, 5.42981, -1.67515> , <0.760364, -0.616717, -0.203733> }
	smooth_triangle { <0.000612844, 5.42727, -1.61045>, <-0.00503071, -0.999986, 0.00134759>, <0.244268, 5.426, -1.61029>, <0.264115, -0.964491, 3.892e-007>, <0.000634464, 5.42727, -1.61029> , <-0.00520804, -0.999986, 3.20142e-009> }
	smooth_triangle { <0.244268, 5.426, -1.61029>, <0.264115, -0.964491, 3.892e-007>, <0.000612844, 5.42727, -1.61045>, <-0.00503071, -0.999986, 0.00134759>, <0.235945, 5.426, -1.67351> , <0.255112, -0.964492, -0.0683558> }
	smooth_triangle { <0.273215, 5.29486, -1.61029>, <0.993805, 0.111142, 8.26557e-008>, <0.256747, 5.3584, -1.67908>, <0.959421, 0.115861, -0.257076>, <0.265803, 5.3584, -1.61029> , <0.993266, 0.11586, 1.65308e-007> }
	smooth_triangle { <0.256747, 5.3584, -1.67908>, <0.959421, 0.115861, -0.257076>, <0.273215, 5.29486, -1.61029>, <0.993805, 0.111142, 8.26557e-008>, <0.263906, 5.29486, -1.681> , <0.959941, 0.111142, -0.257217> }
	smooth_triangle { <0.284334, 5.19097, -1.61029>, <0.996483, 0.0837991, 1.57843e-007>, <0.263906, 5.29486, -1.681>, <0.959941, 0.111142, -0.257217>, <0.273215, 5.29486, -1.61029> , <0.993805, 0.111142, 8.26557e-008> }
	smooth_triangle { <0.263906, 5.29486, -1.681>, <0.959941, 0.111142, -0.257217>, <0.284334, 5.19097, -1.61029>, <0.996483, 0.0837991, 1.57843e-007>, <0.274646, 5.19097, -1.68388> , <0.962528, 0.0837989, -0.25791> }
	smooth_triangle { <0.290511, 5.09012, -1.61029>, <0.999982, 0.0060338, 2.93518e-007>, <0.274646, 5.19097, -1.68388>, <0.962528, 0.0837989, -0.25791>, <0.284334, 5.19097, -1.61029> , <0.996483, 0.0837991, 1.57843e-007> }
	smooth_triangle { <0.274646, 5.19097, -1.68388>, <0.962528, 0.0837989, -0.25791>, <0.290511, 5.09012, -1.61029>, <0.999982, 0.0060338, 2.93518e-007>, <0.280613, 5.09012, -1.68548> , <0.965908, 0.00603578, -0.258814> }
	smooth_triangle { <0.286249, 5.00337, -1.61029>, <0.985291, -0.170883, 4.04936e-007>, <0.280613, 5.09012, -1.68548>, <0.965908, 0.00603578, -0.258814>, <0.290511, 5.09012, -1.61029> , <0.999982, 0.0060338, 2.93518e-007> }
	smooth_triangle { <0.280613, 5.09012, -1.68548>, <0.965908, 0.00603578, -0.258814>, <0.286249, 5.00337, -1.61029>, <0.985291, -0.170883, 4.04936e-007>, <0.276495, 5.00337, -1.68438> , <0.951717, -0.170885, -0.255014> }
	smooth_triangle { <0.267492, 4.94148, -1.61029>, <0.917019, -0.398843, -3.79628e-007>, <0.276495, 5.00337, -1.68438>, <0.951717, -0.170885, -0.255014>, <0.286249, 5.00337, -1.61029> , <0.985291, -0.170883, 4.04936e-007> }
	smooth_triangle { <0.276495, 5.00337, -1.68438>, <0.951717, -0.170885, -0.255014>, <0.267492, 4.94148, -1.61029>, <0.917019, -0.398843, -3.79628e-007>, <0.258376, 4.94148, -1.67952> , <0.885774, -0.39884, -0.237343> }
	smooth_triangle { <0.246036, 4.90453, -1.61029>, <0.830308, -0.557305, -1.76502e-007>, <0.258376, 4.94148, -1.67952>, <0.885774, -0.39884, -0.237343>, <0.267492, 4.94148, -1.61029> , <0.917019, -0.398843, -3.79628e-007> }
	smooth_triangle { <0.258376, 4.94148, -1.67952>, <0.885774, -0.39884, -0.237343>, <0.246036, 4.90453, -1.61029>, <0.830308, -0.557305, -1.76502e-007>, <0.237653, 4.90453, -1.67397> , <0.802014, -0.557307, -0.214902> }
	smooth_triangle { <0.218858, 4.86923, -1.61029>, <0.717038, -0.697034, 3.18288e-007>, <0.237653, 4.90453, -1.67397>, <0.802014, -0.557307, -0.214902>, <0.246036, 4.90453, -1.61029> , <0.830308, -0.557305, -1.76502e-007> }
	smooth_triangle { <0.237653, 4.90453, -1.67397>, <0.802014, -0.557307, -0.214902>, <0.218858, 4.86923, -1.61029>, <0.717038, -0.697034, 3.18288e-007>, <0.2114, 4.86923, -1.66693> , <0.692601, -0.697038, -0.185589> }
	smooth_triangle { <0.181567, 4.84402, -1.65894>, <0.574843, -0.803635, -0.154034>, <0.218858, 4.86923, -1.61029>, <0.717038, -0.697034, 3.18288e-007>, <0.187972, 4.84402, -1.61029> , <0.59512, -0.803637, 2.74956e-007> }
	smooth_triangle { <0.218858, 4.86923, -1.61029>, <0.717038, -0.697034, 3.18288e-007>, <0.181567, 4.84402, -1.65894>, <0.574843, -0.803635, -0.154034>, <0.2114, 4.86923, -1.66693> , <0.692601, -0.697038, -0.185589> }
	smooth_triangle { <0.135027, 4.81174, -1.64647>, <0.438354, -0.891095, -0.11746>, <0.187972, 4.84402, -1.61029>, <0.59512, -0.803637, 2.74956e-007>, <0.139791, 4.81174, -1.61029> , <0.453817, -0.891095, 4.05952e-007> }
	smooth_triangle { <0.187972, 4.84402, -1.61029>, <0.59512, -0.803637, 2.74956e-007>, <0.135027, 4.81174, -1.64647>, <0.438354, -0.891095, -0.11746>, <0.181567, 4.84402, -1.65894> , <0.574843, -0.803635, -0.154034> }
	smooth_triangle { <0.0872945, 4.79359, -1.63368>, <0.333086, -0.938663, -0.0892508>, <0.139791, 4.81174, -1.61029>, <0.453817, -0.891095, 4.05952e-007>, <0.0903739, 4.79359, -1.61029> , <0.344835, -0.938663, -6.33952e-008> }
	smooth_triangle { <0.139791, 4.81174, -1.61029>, <0.453817, -0.891095, 4.05952e-007>, <0.0872945, 4.79359, -1.63368>, <0.333086, -0.938663, -0.0892508>, <0.135027, 4.81174, -1.64647> , <0.438354, -0.891095, -0.11746> }
	smooth_triangle { <0.265803, 5.3584, -1.61029>, <0.991496, 0.130136, -4.50826e-008>, <0.246005, 5.44312, -1.67621>, <0.957712, 0.130135, -0.256617>, <0.254684, 5.44312, -1.61029> , <0.991496, 0.130136, -4.50826e-008> }
	smooth_triangle { <0.246005, 5.44312, -1.67621>, <0.957712, 0.130135, -0.256617>, <0.265803, 5.3584, -1.61029>, <0.991496, 0.130136, -4.50826e-008>, <0.256747, 5.3584, -1.67908> , <0.957712, 0.130135, -0.256617> }
	smooth_triangle { <0.00419277, 4.78118, -1.61141>, <0.137916, -0.989754, -0.0369551>, <0.0903739, 4.79359, -1.61029>, <0.142781, -0.989754, 1.86297e-008>, <0.00434068, 4.78118, -1.61029> , <0.142781, -0.989754, 1.86297e-008> }
	smooth_triangle { <0.0903739, 4.79359, -1.61029>, <0.142781, -0.989754, 1.86297e-008>, <0.00419277, 4.78118, -1.61141>, <0.137916, -0.989754, -0.0369551>, <0.0872945, 4.79359, -1.63368> , <0.137916, -0.989754, -0.0369551> }
	smooth_triangle { <0.242074, 5.42981, -1.54543>, <0.760357, -0.616726, 0.203732>, <0.254684, 5.44312, -1.61029>, <0.956327, -0.292299, -1.68961e-006>, <0.246005, 5.44312, -1.54437> , <0.923741, -0.292304, 0.24751> }
	smooth_triangle { <0.254684, 5.44312, -1.61029>, <0.956327, -0.292299, -1.68961e-006>, <0.242074, 5.42981, -1.54543>, <0.760357, -0.616726, 0.203732>, <0.250613, 5.42981, -1.61029> , <0.78718, -0.616723, -5.01395e-007> }
	smooth_triangle { <0.244268, 5.426, -1.61029>, <0.264115, -0.964491, 3.88942e-007>, <0.242074, 5.42981, -1.54543>, <0.760357, -0.616726, 0.203732>, <0.235945, 5.426, -1.54707> , <0.255116, -0.964491, 0.0683564> }
	smooth_triangle { <0.242074, 5.42981, -1.54543>, <0.760357, -0.616726, 0.203732>, <0.244268, 5.426, -1.61029>, <0.264115, -0.964491, 3.88942e-007>, <0.250613, 5.42981, -1.61029> , <0.78718, -0.616723, -5.01395e-007> }
	smooth_triangle { <0.000634464, 5.42727, -1.61029>, <-0.00520804, -0.999986, 3.20142e-009>, <0.235945, 5.426, -1.54707>, <0.255116, -0.964491, 0.0683564>, <0.000612844, 5.42727, -1.61013> , <-0.00503062, -0.999986, -0.00134756> }
	smooth_triangle { <0.235945, 5.426, -1.54707>, <0.255116, -0.964491, 0.0683564>, <0.000634464, 5.42727, -1.61029>, <-0.00520804, -0.999986, 3.20142e-009>, <0.244268, 5.426, -1.61029> , <0.264115, -0.964491, 3.89215e-007> }
	smooth_triangle { <0.263906, 5.29486, -1.53958>, <0.959941, 0.111143, 0.257216>, <0.265803, 5.3584, -1.61029>, <0.993266, 0.11586, 1.65308e-007>, <0.256747, 5.3584, -1.5415> , <0.959421, 0.11586, 0.257075> }
	smooth_triangle { <0.265803, 5.3584, -1.61029>, <0.993266, 0.11586, 1.65308e-007>, <0.263906, 5.29486, -1.53958>, <0.959941, 0.111143, 0.257216>, <0.273215, 5.29486, -1.61029> , <0.993805, 0.111142, 7.88987e-008> }
	smooth_triangle { <0.274646, 5.19097, -1.5367>, <0.962528, 0.0837991, 0.25791>, <0.273215, 5.29486, -1.61029>, <0.993805, 0.111142, 7.88987e-008>, <0.263906, 5.29486, -1.53958> , <0.959941, 0.111143, 0.257216> }
	smooth_triangle { <0.273215, 5.29486, -1.61029>, <0.993805, 0.111142, 7.88987e-008>, <0.274646, 5.19097, -1.5367>, <0.962528, 0.0837991, 0.25791>, <0.284334, 5.19097, -1.61029> , <0.996483, 0.0837991, 1.61601e-007> }
	smooth_triangle { <0.280613, 5.09012, -1.5351>, <0.965908, 0.00603391, 0.258814>, <0.284334, 5.19097, -1.61029>, <0.996483, 0.0837991, 1.61601e-007>, <0.274646, 5.19097, -1.5367> , <0.962528, 0.0837991, 0.25791> }
	smooth_triangle { <0.284334, 5.19097, -1.61029>, <0.996483, 0.0837991, 1.61601e-007>, <0.280613, 5.09012, -1.5351>, <0.965908, 0.00603391, 0.258814>, <0.290511, 5.09012, -1.61029> , <0.999982, 0.0060338, 2.93518e-007> }
	smooth_triangle { <0.276495, 5.00337, -1.5362>, <0.951718, -0.170882, 0.255014>, <0.290511, 5.09012, -1.61029>, <0.999982, 0.0060338, 2.93518e-007>, <0.280613, 5.09012, -1.5351> , <0.965908, 0.00603391, 0.258814> }
	smooth_triangle { <0.290511, 5.09012, -1.61029>, <0.999982, 0.0060338, 2.93518e-007>, <0.276495, 5.00337, -1.5362>, <0.951718, -0.170882, 0.255014>, <0.286249, 5.00337, -1.61029> , <0.985291, -0.170883, 4.08721e-007> }
	smooth_triangle { <0.258376, 4.94148, -1.54106>, <0.885772, -0.398843, 0.237344>, <0.286249, 5.00337, -1.61029>, <0.985291, -0.170883, 4.08721e-007>, <0.276495, 5.00337, -1.5362> , <0.951718, -0.170882, 0.255014> }
	smooth_triangle { <0.286249, 5.00337, -1.61029>, <0.985291, -0.170883, 4.08721e-007>, <0.258376, 4.94148, -1.54106>, <0.885772, -0.398843, 0.237344>, <0.267492, 4.94148, -1.61029> , <0.917019, -0.398843, -3.79628e-007> }
	smooth_triangle { <0.237653, 4.90453, -1.54661>, <0.802015, -0.557305, 0.214903>, <0.267492, 4.94148, -1.61029>, <0.917019, -0.398843, -3.7774e-007>, <0.258376, 4.94148, -1.54106> , <0.885772, -0.398843, 0.237344> }
	smooth_triangle { <0.267492, 4.94148, -1.61029>, <0.917019, -0.398843, -3.7774e-007>, <0.237653, 4.90453, -1.54661>, <0.802015, -0.557305, 0.214903>, <0.246036, 4.90453, -1.61029> , <0.830308, -0.557305, -1.76502e-007> }
	smooth_triangle { <0.2114, 4.86923, -1.55365>, <0.692605, -0.697033, 0.18559>, <0.246036, 4.90453, -1.61029>, <0.830308, -0.557305, -1.76502e-007>, <0.237653, 4.90453, -1.54661> , <0.802015, -0.557305, 0.214903> }
	smooth_triangle { <0.246036, 4.90453, -1.61029>, <0.830308, -0.557305, -1.76502e-007>, <0.2114, 4.86923, -1.55365>, <0.692605, -0.697033, 0.18559>, <0.218858, 4.86923, -1.61029> , <0.717038, -0.697034, 3.18288e-007> }
	smooth_triangle { <0.187972, 4.84402, -1.61029>, <0.59512, -0.803637, 2.74956e-007>, <0.2114, 4.86923, -1.55365>, <0.692605, -0.697033, 0.18559>, <0.181567, 4.84402, -1.56164> , <0.574841, -0.803636, 0.154033> }
	smooth_triangle { <0.2114, 4.86923, -1.55365>, <0.692605, -0.697033, 0.18559>, <0.187972, 4.84402, -1.61029>, <0.59512, -0.803637, 2.74956e-007>, <0.218858, 4.86923, -1.61029> , <0.717039, -0.697034, 3.18288e-007> }
	smooth_triangle { <0.139791, 4.81174, -1.61029>, <0.453817, -0.891095, 4.05952e-007>, <0.181567, 4.84402, -1.56164>, <0.574841, -0.803636, 0.154033>, <0.135027, 4.81174, -1.57411> , <0.438354, -0.891094, 0.117459> }
	smooth_triangle { <0.181567, 4.84402, -1.56164>, <0.574841, -0.803636, 0.154033>, <0.139791, 4.81174, -1.61029>, <0.453817, -0.891095, 4.05952e-007>, <0.187972, 4.84402, -1.61029> , <0.59512, -0.803637, 2.74956e-007> }
	smooth_triangle { <0.0903739, 4.79359, -1.61029>, <0.344835, -0.938663, -6.33952e-008>, <0.135027, 4.81174, -1.57411>, <0.438354, -0.891094, 0.117459>, <0.0872945, 4.79359, -1.5869> , <0.333085, -0.938663, 0.0892503> }
	smooth_triangle { <0.135027, 4.81174, -1.57411>, <0.438354, -0.891094, 0.117459>, <0.0903739, 4.79359, -1.61029>, <0.344835, -0.938663, -6.33952e-008>, <0.139791, 4.81174, -1.61029> , <0.453817, -0.891095, 4.05952e-007> }
	smooth_triangle { <0.256747, 5.3584, -1.5415>, <0.957712, 0.130135, 0.256617>, <0.254684, 5.44312, -1.61029>, <0.991496, 0.130136, -4.50826e-008>, <0.246005, 5.44312, -1.54437> , <0.957712, 0.130135, 0.256617> }
	smooth_triangle { <0.254684, 5.44312, -1.61029>, <0.991496, 0.130136, -4.50826e-008>, <0.256747, 5.3584, -1.5415>, <0.957712, 0.130135, 0.256617>, <0.265803, 5.3584, -1.61029> , <0.991496, 0.130136, -4.50826e-008> }
	smooth_triangle { <0.00434068, 4.78118, -1.61029>, <0.142781, -0.989754, 1.86297e-008>, <0.0872945, 4.79359, -1.5869>, <0.137916, -0.989754, 0.0369552>, <0.00419277, 4.78118, -1.60917> , <0.137916, -0.989754, 0.0369552> }
	smooth_triangle { <0.0872945, 4.79359, -1.5869>, <0.137916, -0.989754, 0.0369552>, <0.00434068, 4.78118, -1.61029>, <0.142781, -0.989754, 1.86297e-008>, <0.0903739, 4.79359, -1.61029> , <0.142781, -0.989754, 1.86297e-008> }
	smooth_triangle { <0.217038, 5.42981, -1.48498>, <0.681719, -0.616721, 0.393592>, <0.246005, 5.44312, -1.54437>, <0.923741, -0.292304, 0.24751>, <0.220563, 5.44312, -1.48295> , <0.828207, -0.292278, 0.47817> }
	smooth_triangle { <0.246005, 5.44312, -1.54437>, <0.923741, -0.292304, 0.24751>, <0.217038, 5.42981, -1.48498>, <0.681719, -0.616721, 0.393592>, <0.242074, 5.42981, -1.54543> , <0.760357, -0.616726, 0.203732> }
	smooth_triangle { <0.211543, 5.426, -1.48816>, <0.228726, -0.964493, 0.132053>, <0.242074, 5.42981, -1.54543>, <0.760357, -0.616726, 0.203732>, <0.217038, 5.42981, -1.48498> , <0.681719, -0.616721, 0.393592> }
	smooth_triangle { <0.242074, 5.42981, -1.54543>, <0.760357, -0.616726, 0.203732>, <0.211543, 5.426, -1.48816>, <0.228726, -0.964493, 0.132053>, <0.235945, 5.426, -1.54707> , <0.255116, -0.964491, 0.0683564> }
	smooth_triangle { <0.000549461, 5.42727, -1.60997>, <-0.00451018, -0.999986, -0.00260401>, <0.235945, 5.426, -1.54707>, <0.255116, -0.964491, 0.0683564>, <0.211543, 5.426, -1.48816> , <0.228726, -0.964493, 0.132053> }
	smooth_triangle { <0.235945, 5.426, -1.54707>, <0.255116, -0.964491, 0.0683564>, <0.000549461, 5.42727, -1.60997>, <-0.00451018, -0.999986, -0.00260401>, <0.000612844, 5.42727, -1.61013> , <-0.00503062, -0.999986, -0.00134756> }
	smooth_triangle { <0.236611, 5.29486, -1.47368>, <0.860656, 0.111141, 0.496908>, <0.256747, 5.3584, -1.5415>, <0.959421, 0.11586, 0.257075>, <0.230192, 5.3584, -1.47739> , <0.86019, 0.11586, 0.496638> }
	smooth_triangle { <0.256747, 5.3584, -1.5415>, <0.959421, 0.11586, 0.257075>, <0.236611, 5.29486, -1.47368>, <0.860656, 0.111141, 0.496908>, <0.263906, 5.29486, -1.53958> , <0.959941, 0.111143, 0.257216> }
	smooth_triangle { <0.24624, 5.19097, -1.46812>, <0.862978, 0.0837978, 0.498244>, <0.263906, 5.29486, -1.53958>, <0.959941, 0.111143, 0.257216>, <0.236611, 5.29486, -1.47368> , <0.860656, 0.111141, 0.496908> }
	smooth_triangle { <0.263906, 5.29486, -1.53958>, <0.959941, 0.111143, 0.257216>, <0.24624, 5.19097, -1.46812>, <0.862978, 0.0837978, 0.498244>, <0.274646, 5.19097, -1.5367> , <0.962528, 0.0837991, 0.25791> }
	smooth_triangle { <0.25159, 5.09012, -1.46504>, <0.866009, 0.00603616, 0.499992>, <0.274646, 5.19097, -1.5367>, <0.962528, 0.0837991, 0.25791>, <0.24624, 5.19097, -1.46812> , <0.862978, 0.0837978, 0.498244> }
	smooth_triangle { <0.274646, 5.19097, -1.5367>, <0.962528, 0.0837991, 0.25791>, <0.25159, 5.09012, -1.46504>, <0.866009, 0.00603616, 0.499992>, <0.280613, 5.09012, -1.5351> , <0.965908, 0.00603391, 0.258814> }
	smooth_triangle { <0.247899, 5.00337, -1.46716>, <0.853285, -0.170884, 0.49265>, <0.280613, 5.09012, -1.5351>, <0.965909, 0.00603391, 0.258814>, <0.25159, 5.09012, -1.46504> , <0.866009, 0.00603616, 0.499992> }
	smooth_triangle { <0.280613, 5.09012, -1.5351>, <0.965909, 0.00603391, 0.258814>, <0.247899, 5.00337, -1.46716>, <0.853285, -0.170884, 0.49265>, <0.276495, 5.00337, -1.5362> , <0.951718, -0.170882, 0.255014> }
	smooth_triangle { <0.231654, 4.94148, -1.47654>, <0.794164, -0.398841, 0.458508>, <0.276495, 5.00337, -1.5362>, <0.951718, -0.170882, 0.255014>, <0.247899, 5.00337, -1.46716> , <0.853285, -0.170884, 0.49265> }
	smooth_triangle { <0.276495, 5.00337, -1.5362>, <0.951718, -0.170882, 0.255014>, <0.231654, 4.94148, -1.47654>, <0.794164, -0.398841, 0.458508>, <0.258376, 4.94148, -1.54106> , <0.885772, -0.398843, 0.237344> }
	smooth_triangle { <0.213074, 4.90453, -1.48727>, <0.719069, -0.557306, 0.41515>, <0.258376, 4.94148, -1.54106>, <0.885772, -0.398842, 0.237344>, <0.231654, 4.94148, -1.47654> , <0.794164, -0.398841, 0.458508> }
	smooth_triangle { <0.258376, 4.94148, -1.54106>, <0.885772, -0.398842, 0.237344>, <0.213074, 4.90453, -1.48727>, <0.719069, -0.557306, 0.41515>, <0.237653, 4.90453, -1.54661> , <0.802015, -0.557305, 0.214903> }
	smooth_triangle { <0.189535, 4.86923, -1.50086>, <0.620971, -0.697036, 0.358519>, <0.237653, 4.90453, -1.54661>, <0.802015, -0.557305, 0.214903>, <0.213074, 4.90453, -1.48727> , <0.719069, -0.557306, 0.41515> }
	smooth_triangle { <0.237653, 4.90453, -1.54661>, <0.802015, -0.557305, 0.214903>, <0.189535, 4.86923, -1.50086>, <0.620971, -0.697036, 0.358519>, <0.2114, 4.86923, -1.55365> , <0.692605, -0.697033, 0.18559> }
	smooth_triangle { <0.162788, 4.84402, -1.5163>, <0.515391, -0.803635, 0.297562>, <0.2114, 4.86923, -1.55365>, <0.692605, -0.697033, 0.18559>, <0.189535, 4.86923, -1.50086> , <0.620971, -0.697036, 0.358519> }
	smooth_triangle { <0.2114, 4.86923, -1.55365>, <0.692605, -0.697033, 0.18559>, <0.162788, 4.84402, -1.5163>, <0.515391, -0.803635, 0.297562>, <0.181567, 4.84402, -1.56164> , <0.574841, -0.803636, 0.154033> }
	smooth_triangle { <0.121062, 4.81174, -1.54039>, <0.393018, -0.891095, 0.226908>, <0.181567, 4.84402, -1.56164>, <0.574841, -0.803636, 0.154033>, <0.162788, 4.84402, -1.5163> , <0.515391, -0.803635, 0.297562> }
	smooth_triangle { <0.181567, 4.84402, -1.56164>, <0.574841, -0.803636, 0.154033>, <0.121062, 4.81174, -1.54039>, <0.393018, -0.891095, 0.226908>, <0.135027, 4.81174, -1.57411> , <0.438354, -0.891094, 0.117459> }
	smooth_triangle { <0.078266, 4.79359, -1.5651>, <0.298638, -0.938663, 0.172418>, <0.135027, 4.81174, -1.57411>, <0.438354, -0.891094, 0.117459>, <0.121062, 4.81174, -1.54039> , <0.393018, -0.891095, 0.226908> }
	smooth_triangle { <0.135027, 4.81174, -1.57411>, <0.438354, -0.891094, 0.117459>, <0.078266, 4.79359, -1.5651>, <0.298638, -0.938663, 0.172418>, <0.0872945, 4.79359, -1.5869> , <0.333085, -0.938663, 0.0892503> }
	smooth_triangle { <0.230192, 5.3584, -1.47739>, <0.858659, 0.130135, 0.495752>, <0.246005, 5.44312, -1.54437>, <0.957712, 0.130135, 0.256617>, <0.220563, 5.44312, -1.48295> , <0.858659, 0.130135, 0.495752> }
	smooth_triangle { <0.246005, 5.44312, -1.54437>, <0.957712, 0.130135, 0.256617>, <0.230192, 5.3584, -1.47739>, <0.858659, 0.130135, 0.495752>, <0.256747, 5.3584, -1.5415> , <0.957712, 0.130135, 0.256617> }
	smooth_triangle { <0.00375913, 4.78118, -1.60812>, <0.123659, -0.989754, 0.0713795>, <0.0872945, 4.79359, -1.5869>, <0.137916, -0.989754, 0.0369552>, <0.078266, 4.79359, -1.5651> , <0.123659, -0.989754, 0.0713795> }
	smooth_triangle { <0.0872945, 4.79359, -1.5869>, <0.137916, -0.989754, 0.0369552>, <0.00375913, 4.78118, -1.60812>, <0.123659, -0.989754, 0.0713795>, <0.00419277, 4.78118, -1.60917> , <0.137916, -0.989754, 0.0369552> }
	smooth_triangle { <0.17721, 5.42981, -1.43308>, <0.556616, -0.616728, 0.556619>, <0.220563, 5.44312, -1.48295>, <0.828207, -0.292278, 0.47817>, <0.180089, 5.44312, -1.4302> , <0.676219, -0.292334, 0.676216> }
	smooth_triangle { <0.220563, 5.44312, -1.48295>, <0.828207, -0.292278, 0.47817>, <0.17721, 5.42981, -1.43308>, <0.556616, -0.616728, 0.556619>, <0.217038, 5.42981, -1.48498> , <0.681719, -0.616721, 0.393592> }
	smooth_triangle { <0.172724, 5.426, -1.43757>, <0.186764, -0.964488, 0.186767>, <0.217038, 5.42981, -1.48498>, <0.681719, -0.616721, 0.393592>, <0.17721, 5.42981, -1.43308> , <0.556616, -0.616728, 0.556619> }
	smooth_triangle { <0.217038, 5.42981, -1.48498>, <0.681719, -0.616721, 0.393592>, <0.172724, 5.426, -1.43757>, <0.186764, -0.964488, 0.186767>, <0.211543, 5.426, -1.48816> , <0.228726, -0.964493, 0.132053> }
	smooth_triangle { <0.000448634, 5.42727, -1.60984>, <-0.00368266, -0.999986, -0.00368268>, <0.211543, 5.426, -1.48816>, <0.228726, -0.964493, 0.132053>, <0.172724, 5.426, -1.43757> , <0.186764, -0.964488, 0.186767> }
	smooth_triangle { <0.211543, 5.426, -1.48816>, <0.228726, -0.964493, 0.132053>, <0.000448634, 5.42727, -1.60984>, <-0.00368266, -0.999986, -0.00368268>, <0.000549461, 5.42727, -1.60997> , <-0.00451018, -0.999986, -0.00260401> }
	smooth_triangle { <0.193192, 5.29486, -1.4171>, <0.702726, 0.111138, 0.702726>, <0.230192, 5.3584, -1.47739>, <0.86019, 0.11586, 0.496638>, <0.187951, 5.3584, -1.42234> , <0.702345, 0.115856, 0.702345> }
	smooth_triangle { <0.230192, 5.3584, -1.47739>, <0.86019, 0.11586, 0.496638>, <0.193192, 5.29486, -1.4171>, <0.702726, 0.111138, 0.702726>, <0.236611, 5.29486, -1.47368> , <0.860657, 0.111141, 0.496909> }
	smooth_triangle { <0.201054, 5.19097, -1.40924>, <0.704621, 0.0838004, 0.704618>, <0.236611, 5.29486, -1.47368>, <0.860656, 0.111141, 0.496908>, <0.193192, 5.29486, -1.4171> , <0.702726, 0.111138, 0.702726> }
	smooth_triangle { <0.236611, 5.29486, -1.47368>, <0.860656, 0.111141, 0.496908>, <0.201054, 5.19097, -1.40924>, <0.704621, 0.0838004, 0.704618>, <0.24624, 5.19097, -1.46812> , <0.862978, 0.0837978, 0.498244> }
	smooth_triangle { <0.205423, 5.09012, -1.40487>, <0.707097, 0.00603709, 0.707091>, <0.24624, 5.19097, -1.46812>, <0.862978, 0.0837978, 0.498244>, <0.201054, 5.19097, -1.40924> , <0.704621, 0.0838004, 0.704618> }
	smooth_triangle { <0.24624, 5.19097, -1.46812>, <0.862978, 0.0837978, 0.498244>, <0.205423, 5.09012, -1.40487>, <0.707097, 0.00603709, 0.707091>, <0.25159, 5.09012, -1.46504> , <0.866009, 0.00603616, 0.499992> }
	smooth_triangle { <0.202408, 5.00337, -1.40788>, <0.696708, -0.170886, 0.696704>, <0.25159, 5.09012, -1.46504>, <0.866009, 0.00603616, 0.499992>, <0.205423, 5.09012, -1.40487> , <0.707097, 0.00603709, 0.707091> }
	smooth_triangle { <0.25159, 5.09012, -1.46504>, <0.866009, 0.00603616, 0.499992>, <0.202408, 5.00337, -1.40788>, <0.696708, -0.170886, 0.696704>, <0.247899, 5.00337, -1.46716> , <0.853285, -0.170884, 0.49265> }
	smooth_triangle { <0.189144, 4.94148, -1.42115>, <0.648433, -0.398832, 0.648435>, <0.247899, 5.00337, -1.46716>, <0.853285, -0.170884, 0.49265>, <0.202408, 5.00337, -1.40788> , <0.696708, -0.170886, 0.696704> }
	smooth_triangle { <0.247899, 5.00337, -1.46716>, <0.853285, -0.170884, 0.49265>, <0.189144, 4.94148, -1.42115>, <0.648433, -0.398832, 0.648435>, <0.231654, 4.94148, -1.47654> , <0.794164, -0.398841, 0.458508> }
	smooth_triangle { <0.173975, 4.90453, -1.43632>, <0.587116, -0.557305, 0.587116>, <0.231654, 4.94148, -1.47654>, <0.794164, -0.398841, 0.458508>, <0.189144, 4.94148, -1.42115> , <0.648433, -0.398832, 0.648435> }
	smooth_triangle { <0.231654, 4.94148, -1.47654>, <0.794164, -0.398841, 0.458508>, <0.173975, 4.90453, -1.43632>, <0.587116, -0.557305, 0.587116>, <0.213074, 4.90453, -1.48727> , <0.719069, -0.557306, 0.41515> }
	smooth_triangle { <0.154756, 4.86923, -1.45554>, <0.507018, -0.697042, 0.507016>, <0.213074, 4.90453, -1.48727>, <0.719069, -0.557306, 0.41515>, <0.173975, 4.90453, -1.43632> , <0.587116, -0.557305, 0.587116> }
	smooth_triangle { <0.213074, 4.90453, -1.48727>, <0.719069, -0.557306, 0.41515>, <0.154756, 4.86923, -1.45554>, <0.507018, -0.697042, 0.507016>, <0.189535, 4.86923, -1.50086> , <0.620971, -0.697036, 0.358519> }
	smooth_triangle { <0.132916, 4.84402, -1.47737>, <0.420816, -0.803635, 0.420815>, <0.189535, 4.86923, -1.50086>, <0.620971, -0.697036, 0.358519>, <0.154756, 4.86923, -1.45554> , <0.507018, -0.697042, 0.507016> }
	smooth_triangle { <0.189535, 4.86923, -1.50086>, <0.620971, -0.697036, 0.358519>, <0.132916, 4.84402, -1.47737>, <0.420816, -0.803635, 0.420815>, <0.162788, 4.84402, -1.5163> , <0.515391, -0.803635, 0.297562> }
	smooth_triangle { <0.0988468, 4.81174, -1.51144>, <0.320899, -0.891094, 0.320898>, <0.162788, 4.84402, -1.5163>, <0.515391, -0.803635, 0.297562>, <0.132916, 4.84402, -1.47737> , <0.420816, -0.803635, 0.420815> }
	smooth_triangle { <0.162788, 4.84402, -1.5163>, <0.515391, -0.803635, 0.297562>, <0.0988468, 4.81174, -1.51144>, <0.320899, -0.891094, 0.320898>, <0.121062, 4.81174, -1.54039> , <0.393018, -0.891095, 0.226908> }
	smooth_triangle { <0.063904, 4.79359, -1.54639>, <0.243836, -0.938663, 0.243836>, <0.121062, 4.81174, -1.54039>, <0.393018, -0.891095, 0.226908>, <0.0988468, 4.81174, -1.51144> , <0.320899, -0.891094, 0.320898> }
	smooth_triangle { <0.121062, 4.81174, -1.54039>, <0.393018, -0.891095, 0.226908>, <0.063904, 4.79359, -1.54639>, <0.243836, -0.938663, 0.243836>, <0.078266, 4.79359, -1.5651> , <0.298638, -0.938663, 0.172418> }
	smooth_triangle { <0.187951, 5.3584, -1.42234>, <0.701093, 0.130128, 0.701096>, <0.220563, 5.44312, -1.48295>, <0.858659, 0.130135, 0.495752>, <0.180089, 5.44312, -1.4302> , <0.701093, 0.130128, 0.701096> }
	smooth_triangle { <0.220563, 5.44312, -1.48295>, <0.858659, 0.130135, 0.495752>, <0.187951, 5.3584, -1.42234>, <0.701093, 0.130128, 0.701096>, <0.230192, 5.3584, -1.47739> , <0.858659, 0.130135, 0.495752> }
	smooth_triangle { <0.00306932, 4.78118, -1.60722>, <0.100958, -0.989755, 0.100961>, <0.078266, 4.79359, -1.5651>, <0.123659, -0.989754, 0.0713795>, <0.063904, 4.79359, -1.54639> , <0.100958, -0.989755, 0.100961> }
	smooth_triangle { <0.078266, 4.79359, -1.5651>, <0.123659, -0.989754, 0.0713795>, <0.00306932, 4.78118, -1.60722>, <0.100958, -0.989755, 0.100961>, <0.00375913, 4.78118, -1.60812> , <0.123659, -0.989754, 0.0713795> }
	smooth_triangle { <0.127342, 5.44312, -1.38973>, <0.478161, -0.292333, 0.828193>, <0.17721, 5.42981, -1.43308>, <0.556616, -0.616728, 0.556619>, <0.180089, 5.44312, -1.4302> , <0.676219, -0.292334, 0.676216> }
	smooth_triangle { <0.17721, 5.42981, -1.43308>, <0.556616, -0.616728, 0.556619>, <0.127342, 5.44312, -1.38973>, <0.478161, -0.292333, 0.828193>, <0.125307, 5.42981, -1.39325> , <0.393591, -0.616728, 0.681713> }
	smooth_triangle { <0.122134, 5.426, -1.39875>, <0.132066, -0.964488, 0.228739>, <0.17721, 5.42981, -1.43308>, <0.556616, -0.616728, 0.556619>, <0.125307, 5.42981, -1.39325> , <0.393591, -0.616728, 0.681713> }
	smooth_triangle { <0.17721, 5.42981, -1.43308>, <0.556616, -0.616728, 0.556619>, <0.122134, 5.426, -1.39875>, <0.132066, -0.964488, 0.228739>, <0.172724, 5.426, -1.43757> , <0.186764, -0.964488, 0.186767> }
	smooth_triangle { <0.000317232, 5.42727, -1.60974>, <-0.00260161, -0.999986, -0.00451155>, <0.172724, 5.426, -1.43757>, <0.186764, -0.964488, 0.186767>, <0.122134, 5.426, -1.39875> , <0.132066, -0.964488, 0.228739> }
	smooth_triangle { <0.172724, 5.426, -1.43757>, <0.186764, -0.964488, 0.186767>, <0.000317232, 5.42727, -1.60974>, <-0.00260161, -0.999986, -0.00451155>, <0.000448634, 5.42727, -1.60984> , <-0.00368266, -0.999986, -0.00368268> }
	smooth_triangle { <0.187951, 5.3584, -1.42234>, <0.702345, 0.115856, 0.702345>, <0.136608, 5.29486, -1.37368>, <0.496909, 0.111139, 0.860656>, <0.193192, 5.29486, -1.4171> , <0.702726, 0.111138, 0.702726> }
	smooth_triangle { <0.136608, 5.29486, -1.37368>, <0.496909, 0.111139, 0.860656>, <0.187951, 5.3584, -1.42234>, <0.702345, 0.115856, 0.702345>, <0.132902, 5.3584, -1.3801> , <0.496639, 0.115857, 0.86019> }
	smooth_triangle { <0.193192, 5.29486, -1.4171>, <0.702726, 0.111138, 0.702726>, <0.142167, 5.19097, -1.36405>, <0.498245, 0.0838019, 0.862977>, <0.201054, 5.19097, -1.40924> , <0.704621, 0.0838004, 0.704618> }
	smooth_triangle { <0.142167, 5.19097, -1.36405>, <0.498245, 0.0838019, 0.862977>, <0.193192, 5.29486, -1.4171>, <0.702726, 0.111138, 0.702726>, <0.136608, 5.29486, -1.37368> , <0.496909, 0.111139, 0.860656> }
	smooth_triangle { <0.201054, 5.19097, -1.40924>, <0.704621, 0.0838004, 0.704618>, <0.145256, 5.09012, -1.3587>, <0.499992, 0.00603926, 0.866009>, <0.205423, 5.09012, -1.40487> , <0.707097, 0.00603709, 0.707091> }
	smooth_triangle { <0.145256, 5.09012, -1.3587>, <0.499992, 0.00603926, 0.866009>, <0.201054, 5.19097, -1.40924>, <0.704621, 0.0838004, 0.704618>, <0.142167, 5.19097, -1.36405> , <0.498245, 0.0838019, 0.862977> }
	smooth_triangle { <0.145256, 5.09012, -1.3587>, <0.499992, 0.00603926, 0.866009>, <0.202408, 5.00337, -1.40788>, <0.696708, -0.170886, 0.696704>, <0.205423, 5.09012, -1.40487> , <0.707097, 0.00603709, 0.707091> }
	smooth_triangle { <0.202408, 5.00337, -1.40788>, <0.696708, -0.170886, 0.696704>, <0.145256, 5.09012, -1.3587>, <0.499992, 0.00603926, 0.866009>, <0.143125, 5.00337, -1.36239> , <0.492649, -0.170889, 0.853284> }
	smooth_triangle { <0.143125, 5.00337, -1.36239>, <0.492649, -0.170889, 0.853284>, <0.189144, 4.94148, -1.42115>, <0.648433, -0.398832, 0.648435>, <0.202408, 5.00337, -1.40788> , <0.696708, -0.170886, 0.696704> }
	smooth_triangle { <0.189144, 4.94148, -1.42115>, <0.648433, -0.398832, 0.648435>, <0.143125, 5.00337, -1.36239>, <0.492649, -0.170889, 0.853284>, <0.133746, 4.94148, -1.37864> , <0.45851, -0.398835, 0.794166> }
	smooth_triangle { <0.133746, 4.94148, -1.37864>, <0.45851, -0.398835, 0.794166>, <0.173975, 4.90453, -1.43632>, <0.587116, -0.557305, 0.587116>, <0.189144, 4.94148, -1.42115> , <0.648433, -0.398832, 0.648434> }
	smooth_triangle { <0.173975, 4.90453, -1.43632>, <0.587116, -0.557305, 0.587116>, <0.133746, 4.94148, -1.37864>, <0.45851, -0.398835, 0.794166>, <0.123018, 4.90453, -1.39722> , <0.415152, -0.557304, 0.71907> }
	smooth_triangle { <0.123018, 4.90453, -1.39722>, <0.415152, -0.557304, 0.71907>, <0.154756, 4.86923, -1.45554>, <0.507018, -0.697042, 0.507016>, <0.173975, 4.90453, -1.43632> , <0.587116, -0.557305, 0.587116> }
	smooth_triangle { <0.154756, 4.86923, -1.45554>, <0.507018, -0.697042, 0.507016>, <0.123018, 4.90453, -1.39722>, <0.415152, -0.557304, 0.71907>, <0.109429, 4.86923, -1.42076> , <0.358517, -0.697042, 0.620965> }
	smooth_triangle { <0.0939859, 4.84402, -1.4475>, <0.297562, -0.803634, 0.515392>, <0.154756, 4.86923, -1.45554>, <0.507018, -0.697042, 0.507016>, <0.109429, 4.86923, -1.42076> , <0.358517, -0.697042, 0.620965> }
	smooth_triangle { <0.154756, 4.86923, -1.45554>, <0.507018, -0.697042, 0.507016>, <0.0939859, 4.84402, -1.4475>, <0.297562, -0.803634, 0.515392>, <0.132916, 4.84402, -1.47737> , <0.420816, -0.803635, 0.420815> }
	smooth_triangle { <0.0698953, 4.81174, -1.48923>, <0.226909, -0.891094, 0.393019>, <0.132916, 4.84402, -1.47737>, <0.420816, -0.803635, 0.420815>, <0.0939859, 4.84402, -1.4475> , <0.297562, -0.803634, 0.515392> }
	smooth_triangle { <0.132916, 4.84402, -1.47737>, <0.420816, -0.803635, 0.420815>, <0.0698953, 4.81174, -1.48923>, <0.226909, -0.891094, 0.393019>, <0.0988468, 4.81174, -1.51144> , <0.320899, -0.891094, 0.320898> }
	smooth_triangle { <0.0451869, 4.79359, -1.53202>, <0.172419, -0.938663, 0.298637>, <0.0988468, 4.81174, -1.51144>, <0.320899, -0.891094, 0.320898>, <0.0698953, 4.81174, -1.48923> , <0.226909, -0.891094, 0.393019> }
	smooth_triangle { <0.0988468, 4.81174, -1.51144>, <0.320899, -0.891094, 0.320898>, <0.0451869, 4.79359, -1.53202>, <0.172419, -0.938663, 0.298637>, <0.063904, 4.79359, -1.54639> , <0.243836, -0.938663, 0.243836> }
	smooth_triangle { <0.180089, 5.44312, -1.4302>, <0.701093, 0.130128, 0.701096>, <0.132902, 5.3584, -1.3801>, <0.495751, 0.130126, 0.85866>, <0.187951, 5.3584, -1.42234> , <0.701093, 0.130128, 0.701096> }
	smooth_triangle { <0.132902, 5.3584, -1.3801>, <0.495751, 0.130126, 0.85866>, <0.180089, 5.44312, -1.4302>, <0.701093, 0.130128, 0.701096>, <0.127342, 5.44312, -1.38973> , <0.495751, 0.130126, 0.85866> }
	smooth_triangle { <0.00217035, 4.78118, -1.60653>, <0.0713946, -0.989754, 0.123655>, <0.063904, 4.79359, -1.54639>, <0.100958, -0.989755, 0.100961>, <0.0451869, 4.79359, -1.53202> , <0.0713946, -0.989754, 0.123655> }
	smooth_triangle { <0.063904, 4.79359, -1.54639>, <0.100958, -0.989755, 0.100961>, <0.00217035, 4.78118, -1.60653>, <0.0713946, -0.989754, 0.123655>, <0.00306932, 4.78118, -1.60722> , <0.100958, -0.989755, 0.100961> }
	smooth_triangle { <0.0659171, 5.44312, -1.36428>, <0.24751, -0.292274, 0.92375>, <0.125307, 5.42981, -1.39325>, <0.393591, -0.616728, 0.681713>, <0.127342, 5.44312, -1.38973> , <0.478161, -0.292333, 0.828193> }
	smooth_triangle { <0.125307, 5.42981, -1.39325>, <0.393591, -0.616728, 0.681713>, <0.0659171, 5.44312, -1.36428>, <0.24751, -0.292274, 0.92375>, <0.0648635, 5.42981, -1.36822> , <0.203733, -0.616718, 0.760363> }
	smooth_triangle { <0.0632214, 5.426, -1.37435>, <0.0683558, -0.964493, 0.25511>, <0.125307, 5.42981, -1.39325>, <0.393591, -0.616728, 0.681713>, <0.0648635, 5.42981, -1.36822> , <0.203733, -0.616718, 0.760363> }
	smooth_triangle { <0.125307, 5.42981, -1.39325>, <0.393591, -0.616728, 0.681713>, <0.0632214, 5.426, -1.37435>, <0.0683558, -0.964493, 0.25511>, <0.122134, 5.426, -1.39875> , <0.132066, -0.964488, 0.228739> }
	smooth_triangle { <0.000164211, 5.42727, -1.60968>, <-0.00134652, -0.999986, -0.00503172>, <0.122134, 5.426, -1.39875>, <0.132066, -0.964488, 0.228739>, <0.0632214, 5.426, -1.37435> , <0.0683558, -0.964493, 0.25511> }
	smooth_triangle { <0.122134, 5.426, -1.39875>, <0.132066, -0.964488, 0.228739>, <0.000164211, 5.42727, -1.60968>, <-0.00134652, -0.999986, -0.00503172>, <0.000317232, 5.42727, -1.60974> , <-0.00260161, -0.999986, -0.00451155> }
	smooth_triangle { <0.132902, 5.3584, -1.3801>, <0.496639, 0.115857, 0.86019>, <0.0707134, 5.29486, -1.34638>, <0.257216, 0.111142, 0.959941>, <0.136608, 5.29486, -1.37368> , <0.496909, 0.111139, 0.860656> }
	smooth_triangle { <0.0707134, 5.29486, -1.34638>, <0.257216, 0.111142, 0.959941>, <0.132902, 5.3584, -1.3801>, <0.496639, 0.115857, 0.86019>, <0.0687949, 5.3584, -1.35354> , <0.257076, 0.115861, 0.959421> }
	smooth_triangle { <0.136608, 5.29486, -1.37368>, <0.496909, 0.111139, 0.860656>, <0.073591, 5.19097, -1.33564>, <0.257909, 0.0837997, 0.962528>, <0.142167, 5.19097, -1.36405> , <0.498245, 0.0838019, 0.862977> }
	smooth_triangle { <0.073591, 5.19097, -1.33564>, <0.257909, 0.0837997, 0.962528>, <0.136608, 5.29486, -1.37368>, <0.496909, 0.111139, 0.860656>, <0.0707134, 5.29486, -1.34638> , <0.257216, 0.111142, 0.959941> }
	smooth_triangle { <0.142167, 5.19097, -1.36405>, <0.498245, 0.0838019, 0.862977>, <0.0751899, 5.09012, -1.32968>, <0.25881, 0.00603801, 0.965909>, <0.145256, 5.09012, -1.3587> , <0.499992, 0.00603926, 0.866009> }
	smooth_triangle { <0.0751899, 5.09012, -1.32968>, <0.25881, 0.00603801, 0.965909>, <0.142167, 5.19097, -1.36405>, <0.498245, 0.0838019, 0.862977>, <0.073591, 5.19097, -1.33564> , <0.257909, 0.0837997, 0.962528> }
	smooth_triangle { <0.0751899, 5.09012, -1.32968>, <0.25881, 0.00603801, 0.965909>, <0.143125, 5.00337, -1.36239>, <0.492649, -0.170889, 0.853284>, <0.145256, 5.09012, -1.3587> , <0.499992, 0.00603926, 0.866009> }
	smooth_triangle { <0.143125, 5.00337, -1.36239>, <0.492649, -0.170889, 0.853284>, <0.0751899, 5.09012, -1.32968>, <0.25881, 0.00603801, 0.965909>, <0.0740867, 5.00337, -1.3338> , <0.255011, -0.170887, 0.951718> }
	smooth_triangle { <0.0740867, 5.00337, -1.3338>, <0.255011, -0.170887, 0.951718>, <0.133746, 4.94148, -1.37864>, <0.45851, -0.398835, 0.794166>, <0.143125, 5.00337, -1.36239> , <0.492649, -0.170889, 0.853284> }
	smooth_triangle { <0.133746, 4.94148, -1.37864>, <0.45851, -0.398835, 0.794166>, <0.0740867, 5.00337, -1.3338>, <0.255011, -0.170887, 0.951718>, <0.0692318, 4.94148, -1.35191> , <0.237346, -0.398843, 0.885771> }
	smooth_triangle { <0.0692318, 4.94148, -1.35191>, <0.237346, -0.398843, 0.885771>, <0.123018, 4.90453, -1.39722>, <0.415152, -0.557304, 0.71907>, <0.133746, 4.94148, -1.37864> , <0.45851, -0.398835, 0.794166> }
	smooth_triangle { <0.123018, 4.90453, -1.39722>, <0.415152, -0.557304, 0.71907>, <0.0692318, 4.94148, -1.35191>, <0.237346, -0.398843, 0.885771>, <0.0636789, 4.90453, -1.37264> , <0.214905, -0.557307, 0.802013> }
	smooth_triangle { <0.0636789, 4.90453, -1.37264>, <0.214905, -0.557307, 0.802013>, <0.109429, 4.86923, -1.42076>, <0.358517, -0.697042, 0.620965>, <0.123018, 4.90453, -1.39722> , <0.415152, -0.557304, 0.71907> }
	smooth_triangle { <0.109429, 4.86923, -1.42076>, <0.358517, -0.697042, 0.620965>, <0.0636789, 4.90453, -1.37264>, <0.214905, -0.557307, 0.802013>, <0.0566444, 4.86923, -1.39889> , <0.185588, -0.697038, 0.692601> }
	smooth_triangle { <0.0486508, 4.84402, -1.42872>, <0.154033, -0.803635, 0.574844>, <0.109429, 4.86923, -1.42076>, <0.358517, -0.697042, 0.620965>, <0.0566444, 4.86923, -1.39889> , <0.185588, -0.697038, 0.692601> }
	smooth_triangle { <0.109429, 4.86923, -1.42076>, <0.358517, -0.697042, 0.620965>, <0.0486508, 4.84402, -1.42872>, <0.154033, -0.803635, 0.574844>, <0.0939859, 4.84402, -1.4475> , <0.297562, -0.803634, 0.515392> }
	smooth_triangle { <0.0361805, 4.81174, -1.47526>, <0.117459, -0.891094, 0.438354>, <0.0939859, 4.84402, -1.4475>, <0.297562, -0.803634, 0.515392>, <0.0486508, 4.84402, -1.42872> , <0.154033, -0.803635, 0.574844> }
	smooth_triangle { <0.0939859, 4.84402, -1.4475>, <0.297562, -0.803634, 0.515392>, <0.0361805, 4.81174, -1.47526>, <0.117459, -0.891094, 0.438354>, <0.0698953, 4.81174, -1.48923> , <0.226909, -0.891094, 0.393019> }
	smooth_triangle { <0.0233905, 4.79359, -1.523>, <0.0892505, -0.938663, 0.333086>, <0.0698953, 4.81174, -1.48923>, <0.226909, -0.891094, 0.393019>, <0.0361805, 4.81174, -1.47526> , <0.117459, -0.891094, 0.438354> }
	smooth_triangle { <0.0698953, 4.81174, -1.48923>, <0.226909, -0.891094, 0.393019>, <0.0233905, 4.79359, -1.523>, <0.0892505, -0.938663, 0.333086>, <0.0451869, 4.79359, -1.53202> , <0.172419, -0.938663, 0.298637> }
	smooth_triangle { <0.127342, 5.44312, -1.38973>, <0.495751, 0.130126, 0.85866>, <0.0687949, 5.3584, -1.35354>, <0.256618, 0.130135, 0.957712>, <0.132902, 5.3584, -1.3801> , <0.495751, 0.130126, 0.85866> }
	smooth_triangle { <0.0687949, 5.3584, -1.35354>, <0.256618, 0.130135, 0.957712>, <0.127342, 5.44312, -1.38973>, <0.495751, 0.130126, 0.85866>, <0.0659171, 5.44312, -1.36428> , <0.256618, 0.130135, 0.957712> }
	smooth_triangle { <0.00112345, 4.78118, -1.6061>, <0.0369492, -0.989755, 0.137914>, <0.0451869, 4.79359, -1.53202>, <0.0713946, -0.989754, 0.123655>, <0.0233905, 4.79359, -1.523> , <0.0369492, -0.989755, 0.137914> }
	smooth_triangle { <0.0451869, 4.79359, -1.53202>, <0.0713946, -0.989754, 0.123655>, <0.00112345, 4.78118, -1.6061>, <0.0369492, -0.989755, 0.137914>, <0.00217035, 4.78118, -1.60653> , <0.0713946, -0.989754, 0.123655> }
	smooth_triangle { <1.11326e-008, 5.44312, -1.35561>, <1.54694e-006, -0.292301, 0.956326>, <0.0648635, 5.42981, -1.36822>, <0.203733, -0.616718, 0.760363>, <0.0659171, 5.44312, -1.36428> , <0.24751, -0.292274, 0.92375> }
	smooth_triangle { <0.0648635, 5.42981, -1.36822>, <0.203733, -0.616718, 0.760363>, <1.11326e-008, 5.44312, -1.35561>, <1.54694e-006, -0.292301, 0.956326>, <1.09547e-008, 5.42981, -1.35968> , <4.71311e-007, -0.616725, 0.787179> }
	smooth_triangle { <1.06773e-008, 5.426, -1.36602>, <-3.21199e-007, -0.964491, 0.264114>, <0.0648635, 5.42981, -1.36822>, <0.203733, -0.616718, 0.760363>, <1.09547e-008, 5.42981, -1.35968> , <4.71311e-007, -0.616725, 0.787179> }
	smooth_triangle { <0.0648635, 5.42981, -1.36822>, <0.203733, -0.616718, 0.760363>, <1.06773e-008, 5.426, -1.36602>, <-3.21199e-007, -0.964491, 0.264114>, <0.0632214, 5.426, -1.37435> , <0.0683558, -0.964493, 0.25511> }
	smooth_triangle { <2.77332e-011, 5.42727, -1.60966>, <4.23461e-008, -0.999986, -0.00520769>, <0.0632214, 5.426, -1.37435>, <0.0683558, -0.964493, 0.25511>, <1.06773e-008, 5.426, -1.36602> , <-3.21199e-007, -0.964491, 0.264114> }
	smooth_triangle { <0.0632214, 5.426, -1.37435>, <0.0683558, -0.964493, 0.25511>, <2.77332e-011, 5.42727, -1.60966>, <4.23461e-008, -0.999986, -0.00520769>, <0.000164211, 5.42727, -1.60968> , <-0.00134652, -0.999986, -0.00503172> }
	smooth_triangle { <0.0687949, 5.3584, -1.35354>, <0.257076, 0.115861, 0.959421>, <1.19426e-008, 5.29486, -1.33707>, <5.63562e-008, 0.111142, 0.993804>, <0.0707134, 5.29486, -1.34638> , <0.257216, 0.111142, 0.959941> }
	smooth_triangle { <1.19426e-008, 5.29486, -1.33707>, <5.63562e-008, 0.111142, 0.993804>, <0.0687949, 5.3584, -1.35354>, <0.257076, 0.115861, 0.959421>, <1.16186e-008, 5.3584, -1.34449> , <8.2654e-008, 0.115861, 0.993265> }
	smooth_triangle { <0.0707134, 5.29486, -1.34638>, <0.257216, 0.111142, 0.959941>, <1.24286e-008, 5.19097, -1.32596>, <-6.76469e-008, 0.0837988, 0.996483>, <0.073591, 5.19097, -1.33564> , <0.257909, 0.0837997, 0.962528> }
	smooth_triangle { <1.24286e-008, 5.19097, -1.32596>, <-6.76469e-008, 0.0837988, 0.996483>, <0.0707134, 5.29486, -1.34638>, <0.257216, 0.111142, 0.959941>, <1.19426e-008, 5.29486, -1.33707> , <5.63562e-008, 0.111142, 0.993804> }
	smooth_triangle { <0.073591, 5.19097, -1.33564>, <0.257909, 0.0837997, 0.962528>, <1.26986e-008, 5.09012, -1.31978>, <-9.03133e-008, 0.00603382, 0.999982>, <0.0751899, 5.09012, -1.32968> , <0.25881, 0.00603801, 0.965909> }
	smooth_triangle { <1.26986e-008, 5.09012, -1.31978>, <-9.03133e-008, 0.00603382, 0.999982>, <0.073591, 5.19097, -1.33564>, <0.257909, 0.0837997, 0.962528>, <1.24286e-008, 5.19097, -1.32596> , <-6.76469e-008, 0.0837988, 0.996483> }
	smooth_triangle { <1.26986e-008, 5.09012, -1.31978>, <-9.03133e-008, 0.00603382, 0.999982>, <0.0740867, 5.00337, -1.3338>, <0.255011, -0.170887, 0.951718>, <0.0751899, 5.09012, -1.32968> , <0.25881, 0.00603801, 0.965909> }
	smooth_triangle { <0.0740867, 5.00337, -1.3338>, <0.255011, -0.170887, 0.951718>, <1.26986e-008, 5.09012, -1.31978>, <-9.03133e-008, 0.00603382, 0.999982>, <1.25123e-008, 5.00337, -1.32404> , <-1.77869e-007, -0.170882, 0.985291> }
	smooth_triangle { <1.25123e-008, 5.00337, -1.32404>, <-1.77869e-007, -0.170882, 0.985291>, <0.0692318, 4.94148, -1.35191>, <0.237346, -0.398843, 0.885771>, <0.0740867, 5.00337, -1.3338> , <0.255011, -0.170887, 0.951718> }
	smooth_triangle { <0.0692318, 4.94148, -1.35191>, <0.237346, -0.398843, 0.885771>, <1.25123e-008, 5.00337, -1.32404>, <-1.77869e-007, -0.170882, 0.985291>, <1.16924e-008, 4.94148, -1.3428> , <1.64317e-007, -0.398839, 0.917021> }
	smooth_triangle { <1.16924e-008, 4.94148, -1.3428>, <1.64317e-007, -0.398839, 0.917021>, <0.0636789, 4.90453, -1.37264>, <0.214905, -0.557307, 0.802013>, <0.0692318, 4.94148, -1.35191> , <0.237346, -0.398843, 0.885771> }
	smooth_triangle { <0.0636789, 4.90453, -1.37264>, <0.214905, -0.557307, 0.802013>, <1.16924e-008, 4.94148, -1.3428>, <1.64317e-007, -0.398839, 0.917021>, <1.07546e-008, 4.90453, -1.36425> , <2.7602e-007, -0.557305, 0.830308> }
	smooth_triangle { <1.07546e-008, 4.90453, -1.36425>, <2.7602e-007, -0.557305, 0.830308>, <0.0566444, 4.86923, -1.39889>, <0.185588, -0.697038, 0.692601>, <0.0636789, 4.90453, -1.37264> , <0.214905, -0.557307, 0.802013> }
	smooth_triangle { <0.0566444, 4.86923, -1.39889>, <0.185588, -0.697038, 0.692601>, <1.07546e-008, 4.90453, -1.36425>, <2.7602e-007, -0.557305, 0.830308>, <9.56654e-009, 4.86923, -1.39143> , <2.0152e-007, -0.697037, 0.717035> }
	smooth_triangle { <8.21652e-009, 4.84402, -1.42232>, <3.7409e-009, -0.803637, 0.59512>, <0.0566444, 4.86923, -1.39889>, <0.185588, -0.697038, 0.692601>, <9.56654e-009, 4.86923, -1.39143> , <2.0152e-007, -0.697037, 0.717035> }
	smooth_triangle { <0.0566444, 4.86923, -1.39889>, <0.185588, -0.697038, 0.692601>, <8.21652e-009, 4.84402, -1.42232>, <3.7409e-009, -0.803637, 0.59512>, <0.0486508, 4.84402, -1.42872> , <0.154033, -0.803635, 0.574844> }
	smooth_triangle { <6.11043e-009, 4.81174, -1.4705>, <-5.7322e-008, -0.891095, 0.453817>, <0.0486508, 4.84402, -1.42872>, <0.154033, -0.803635, 0.574844>, <8.21652e-009, 4.84402, -1.42232> , <3.7409e-009, -0.803637, 0.59512> }
	smooth_triangle { <0.0486508, 4.84402, -1.42872>, <0.154033, -0.803635, 0.574844>, <6.11043e-009, 4.81174, -1.4705>, <-5.7322e-008, -0.891095, 0.453817>, <0.0361805, 4.81174, -1.47526> , <0.117459, -0.891094, 0.438354> }
	smooth_triangle { <3.95036e-009, 4.79359, -1.51992>, <3.71048e-007, -0.938663, 0.344835>, <0.0361805, 4.81174, -1.47526>, <0.117459, -0.891094, 0.438354>, <6.11043e-009, 4.81174, -1.4705> , <-5.7322e-008, -0.891095, 0.453817> }
	smooth_triangle { <0.0361805, 4.81174, -1.47526>, <0.117459, -0.891094, 0.438354>, <3.95036e-009, 4.79359, -1.51992>, <3.71048e-007, -0.938663, 0.344835>, <0.0233905, 4.79359, -1.523> , <0.0892505, -0.938663, 0.333086> }
	smooth_triangle { <0.0659171, 5.44312, -1.36428>, <0.256618, 0.130135, 0.957712>, <1.16186e-008, 5.3584, -1.34449>, <-1.50275e-007, 0.130135, 0.991496>, <0.0687949, 5.3584, -1.35354> , <0.256618, 0.130135, 0.957712> }
	smooth_triangle { <1.16186e-008, 5.3584, -1.34449>, <-1.50275e-007, 0.130135, 0.991496>, <0.0659171, 5.44312, -1.36428>, <0.256618, 0.130135, 0.957712>, <1.11326e-008, 5.44312, -1.35561> , <-1.50275e-007, 0.130135, 0.991496> }
	smooth_triangle { <1.89738e-010, 4.78118, -1.60595>, <7.09793e-007, -0.989753, 0.142787>, <0.0233905, 4.79359, -1.523>, <0.0369492, -0.989755, 0.137914>, <3.95036e-009, 4.79359, -1.51992> , <7.09793e-007, -0.989753, 0.142787> }
	smooth_triangle { <0.0233905, 4.79359, -1.523>, <0.0369492, -0.989755, 0.137914>, <1.89738e-010, 4.78118, -1.60595>, <7.09793e-007, -0.989753, 0.142787>, <0.00112345, 4.78118, -1.6061> , <0.0369492, -0.989755, 0.137914> }
	smooth_triangle { <1.11326e-008, 5.44312, -1.35561>, <1.54694e-006, -0.292301, 0.956326>, <-0.0648634, 5.42981, -1.36822>, <-0.203732, -0.616726, 0.760357>, <1.09547e-008, 5.42981, -1.35968> , <4.71311e-007, -0.616725, 0.787179> }
	smooth_triangle { <-0.0648634, 5.42981, -1.36822>, <-0.203732, -0.616726, 0.760357>, <1.11326e-008, 5.44312, -1.35561>, <1.54694e-006, -0.292301, 0.956326>, <-0.0659171, 5.44312, -1.36428> , <-0.24751, -0.292305, 0.923741> }
	smooth_triangle { <-0.0648634, 5.42981, -1.36822>, <-0.203732, -0.616726, 0.760357>, <1.06773e-008, 5.426, -1.36602>, <-3.2073e-007, -0.964491, 0.264114>, <1.09547e-008, 5.42981, -1.35968> , <4.71311e-007, -0.616725, 0.787179> }
	smooth_triangle { <1.06773e-008, 5.426, -1.36602>, <-3.2073e-007, -0.964491, 0.264114>, <-0.0648634, 5.42981, -1.36822>, <-0.203732, -0.616726, 0.760357>, <-0.0632214, 5.426, -1.37435> , <-0.0683574, -0.964491, 0.255116> }
	smooth_triangle { <-0.0632214, 5.426, -1.37435>, <-0.0683574, -0.964491, 0.255116>, <2.77332e-011, 5.42727, -1.60966>, <4.23461e-008, -0.999986, -0.00520769>, <1.06773e-008, 5.426, -1.36602> , <-3.21441e-007, -0.964491, 0.264114> }
	smooth_triangle { <2.77332e-011, 5.42727, -1.60966>, <4.23461e-008, -0.999986, -0.00520769>, <-0.0632214, 5.426, -1.37435>, <-0.0683574, -0.964491, 0.255116>, <-0.000164211, 5.42727, -1.60968> , <0.00134627, -0.999986, -0.00503133> }
	smooth_triangle { <-0.0687949, 5.3584, -1.35354>, <-0.257076, 0.115861, 0.959421>, <1.19426e-008, 5.29486, -1.33707>, <5.63562e-008, 0.111142, 0.993804>, <1.16186e-008, 5.3584, -1.34449> , <8.2654e-008, 0.115861, 0.993265> }
	smooth_triangle { <1.19426e-008, 5.29486, -1.33707>, <5.63562e-008, 0.111142, 0.993804>, <-0.0687949, 5.3584, -1.35354>, <-0.257076, 0.115861, 0.959421>, <-0.0707134, 5.29486, -1.34638> , <-0.257216, 0.111143, 0.959941> }
	smooth_triangle { <-0.0707134, 5.29486, -1.34638>, <-0.257216, 0.111143, 0.959941>, <1.24286e-008, 5.19097, -1.32596>, <-6.76469e-008, 0.0837988, 0.996483>, <1.19426e-008, 5.29486, -1.33707> , <5.63562e-008, 0.111142, 0.993804> }
	smooth_triangle { <1.24286e-008, 5.19097, -1.32596>, <-6.76469e-008, 0.0837988, 0.996483>, <-0.0707134, 5.29486, -1.34638>, <-0.257216, 0.111143, 0.959941>, <-0.073591, 5.19097, -1.33564> , <-0.257909, 0.0837987, 0.962528> }
	smooth_triangle { <-0.073591, 5.19097, -1.33564>, <-0.257909, 0.0837987, 0.962528>, <1.26986e-008, 5.09012, -1.31978>, <-9.40764e-008, 0.00603382, 0.999982>, <1.24286e-008, 5.19097, -1.32596> , <-6.76469e-008, 0.0837988, 0.996483> }
	smooth_triangle { <1.26986e-008, 5.09012, -1.31978>, <-9.40764e-008, 0.00603382, 0.999982>, <-0.073591, 5.19097, -1.33564>, <-0.257909, 0.0837987, 0.962528>, <-0.0751897, 5.09012, -1.32968> , <-0.258809, 0.00603404, 0.96591> }
	smooth_triangle { <1.26986e-008, 5.09012, -1.31978>, <-9.40764e-008, 0.00603382, 0.999982>, <-0.0740867, 5.00337, -1.3338>, <-0.255008, -0.170881, 0.95172>, <1.25123e-008, 5.00337, -1.32404> , <-1.77869e-007, -0.170882, 0.985291> }
	smooth_triangle { <-0.0740867, 5.00337, -1.3338>, <-0.255008, -0.170881, 0.95172>, <1.26986e-008, 5.09012, -1.31978>, <-9.40764e-008, 0.00603382, 0.999982>, <-0.0751897, 5.09012, -1.32968> , <-0.258809, 0.00603404, 0.96591> }
	smooth_triangle { <1.25123e-008, 5.00337, -1.32404>, <-1.77869e-007, -0.170882, 0.985291>, <-0.0692318, 4.94148, -1.35191>, <-0.237344, -0.398838, 0.885774>, <1.16924e-008, 4.94148, -1.3428> , <1.64317e-007, -0.398839, 0.917021> }
	smooth_triangle { <-0.0692318, 4.94148, -1.35191>, <-0.237344, -0.398838, 0.885774>, <1.25123e-008, 5.00337, -1.32404>, <-1.77869e-007, -0.170882, 0.985291>, <-0.0740867, 5.00337, -1.3338> , <-0.255008, -0.170881, 0.95172> }
	smooth_triangle { <1.16924e-008, 4.94148, -1.3428>, <1.66206e-007, -0.398839, 0.917021>, <-0.0636789, 4.90453, -1.37264>, <-0.214906, -0.557304, 0.802015>, <1.07546e-008, 4.90453, -1.36425> , <2.77897e-007, -0.557305, 0.830308> }
	smooth_triangle { <-0.0636789, 4.90453, -1.37264>, <-0.214906, -0.557304, 0.802015>, <1.16924e-008, 4.94148, -1.3428>, <1.66206e-007, -0.398839, 0.917021>, <-0.0692318, 4.94148, -1.35191> , <-0.237344, -0.398838, 0.885774> }
	smooth_triangle { <1.07546e-008, 4.90453, -1.36425>, <2.77897e-007, -0.557305, 0.830308>, <-0.0566444, 4.86923, -1.39889>, <-0.185586, -0.697037, 0.692602>, <9.56654e-009, 4.86923, -1.39143> , <1.99636e-007, -0.697037, 0.717035> }
	smooth_triangle { <-0.0566444, 4.86923, -1.39889>, <-0.185586, -0.697037, 0.692602>, <1.07546e-008, 4.90453, -1.36425>, <2.77897e-007, -0.557305, 0.830308>, <-0.0636789, 4.90453, -1.37264> , <-0.214906, -0.557304, 0.802015> }
	smooth_triangle { <-0.0566444, 4.86923, -1.39889>, <-0.185586, -0.697037, 0.692602>, <8.21652e-009, 4.84402, -1.42232>, <5.61135e-009, -0.803637, 0.59512>, <9.56654e-009, 4.86923, -1.39143> , <1.99636e-007, -0.697037, 0.717035> }
	smooth_triangle { <8.21652e-009, 4.84402, -1.42232>, <5.61135e-009, -0.803637, 0.59512>, <-0.0566444, 4.86923, -1.39889>, <-0.185586, -0.697037, 0.692602>, <-0.0486508, 4.84402, -1.42872> , <-0.154029, -0.803636, 0.574842> }
	smooth_triangle { <-0.0486508, 4.84402, -1.42872>, <-0.154029, -0.803636, 0.574842>, <6.11043e-009, 4.81174, -1.4705>, <-5.7322e-008, -0.891095, 0.453817>, <8.21652e-009, 4.84402, -1.42232> , <5.61135e-009, -0.803637, 0.59512> }
	smooth_triangle { <6.11043e-009, 4.81174, -1.4705>, <-5.7322e-008, -0.891095, 0.453817>, <-0.0486508, 4.84402, -1.42872>, <-0.154029, -0.803636, 0.574842>, <-0.0361805, 4.81174, -1.47526> , <-0.117459, -0.891094, 0.438354> }
	smooth_triangle { <-0.0361805, 4.81174, -1.47526>, <-0.117459, -0.891094, 0.438354>, <3.95036e-009, 4.79359, -1.51992>, <3.71048e-007, -0.938663, 0.344835>, <6.11043e-009, 4.81174, -1.4705> , <-5.82617e-008, -0.891095, 0.453817> }
	smooth_triangle { <3.95036e-009, 4.79359, -1.51992>, <3.71048e-007, -0.938663, 0.344835>, <-0.0361805, 4.81174, -1.47526>, <-0.117459, -0.891094, 0.438354>, <-0.0233905, 4.79359, -1.523> , <-0.0892506, -0.938663, 0.333085> }
	smooth_triangle { <-0.0659171, 5.44312, -1.36428>, <-0.256617, 0.130135, 0.957712>, <1.16186e-008, 5.3584, -1.34449>, <-1.50275e-007, 0.130135, 0.991496>, <1.11326e-008, 5.44312, -1.35561> , <-1.50275e-007, 0.130135, 0.991496> }
	smooth_triangle { <1.16186e-008, 5.3584, -1.34449>, <-1.50275e-007, 0.130135, 0.991496>, <-0.0659171, 5.44312, -1.36428>, <-0.256617, 0.130135, 0.957712>, <-0.0687949, 5.3584, -1.35354> , <-0.256617, 0.130135, 0.957712> }
	smooth_triangle { <-0.0233905, 4.79359, -1.523>, <-0.0369502, -0.989755, 0.137912>, <1.89738e-010, 4.78118, -1.60595>, <7.09793e-007, -0.989753, 0.142787>, <3.95036e-009, 4.79359, -1.51992> , <7.09793e-007, -0.989753, 0.142787> }
	smooth_triangle { <1.89738e-010, 4.78118, -1.60595>, <7.09793e-007, -0.989753, 0.142787>, <-0.0233905, 4.79359, -1.523>, <-0.0369502, -0.989755, 0.137912>, <-0.00112345, 4.78118, -1.6061> , <-0.0369502, -0.989755, 0.137912> }
	smooth_triangle { <-0.0659171, 5.44312, -1.36428>, <-0.24751, -0.292305, 0.923741>, <-0.125307, 5.42981, -1.39325>, <-0.393592, -0.61672, 0.68172>, <-0.0648634, 5.42981, -1.36822> , <-0.203732, -0.616726, 0.760357> }
	smooth_triangle { <-0.125307, 5.42981, -1.39325>, <-0.393592, -0.61672, 0.68172>, <-0.0659171, 5.44312, -1.36428>, <-0.24751, -0.292305, 0.923741>, <-0.127342, 5.44312, -1.38973> , <-0.478171, -0.292277, 0.828207> }
	smooth_triangle { <-0.125307, 5.42981, -1.39325>, <-0.393592, -0.61672, 0.68172>, <-0.0632214, 5.426, -1.37435>, <-0.0683574, -0.964491, 0.255116>, <-0.0648634, 5.42981, -1.36822> , <-0.203732, -0.616726, 0.760357> }
	smooth_triangle { <-0.0632214, 5.426, -1.37435>, <-0.0683574, -0.964491, 0.255116>, <-0.125307, 5.42981, -1.39325>, <-0.393592, -0.61672, 0.68172>, <-0.122134, 5.426, -1.39875> , <-0.132055, -0.964493, 0.228725> }
	smooth_triangle { <-0.122134, 5.426, -1.39875>, <-0.132055, -0.964493, 0.228725>, <-0.000164211, 5.42727, -1.60968>, <0.00134627, -0.999986, -0.00503133>, <-0.0632214, 5.426, -1.37435> , <-0.0683574, -0.964491, 0.255116> }
	smooth_triangle { <-0.000164211, 5.42727, -1.60968>, <0.00134627, -0.999986, -0.00503133>, <-0.122134, 5.426, -1.39875>, <-0.132055, -0.964493, 0.228725>, <-0.000317232, 5.42727, -1.60974> , <0.00260136, -0.999986, -0.00451089> }
	smooth_triangle { <-0.132902, 5.3584, -1.3801>, <-0.496638, 0.115861, 0.86019>, <-0.0707134, 5.29486, -1.34638>, <-0.257216, 0.111143, 0.959941>, <-0.0687949, 5.3584, -1.35354> , <-0.257076, 0.115861, 0.959421> }
	smooth_triangle { <-0.0707134, 5.29486, -1.34638>, <-0.257216, 0.111143, 0.959941>, <-0.132902, 5.3584, -1.3801>, <-0.496638, 0.115861, 0.86019>, <-0.136608, 5.29486, -1.37368> , <-0.496909, 0.111142, 0.860656> }
	smooth_triangle { <-0.136608, 5.29486, -1.37368>, <-0.496909, 0.111142, 0.860656>, <-0.073591, 5.19097, -1.33564>, <-0.257909, 0.0837987, 0.962528>, <-0.0707134, 5.29486, -1.34638> , <-0.257216, 0.111143, 0.959941> }
	smooth_triangle { <-0.073591, 5.19097, -1.33564>, <-0.257909, 0.0837987, 0.962528>, <-0.136608, 5.29486, -1.37368>, <-0.496909, 0.111142, 0.860656>, <-0.142167, 5.19097, -1.36405> , <-0.498244, 0.0837991, 0.862977> }
	smooth_triangle { <-0.142167, 5.19097, -1.36405>, <-0.498244, 0.0837991, 0.862977>, <-0.0751897, 5.09012, -1.32968>, <-0.258809, 0.00603404, 0.96591>, <-0.073591, 5.19097, -1.33564> , <-0.257909, 0.0837987, 0.962528> }
	smooth_triangle { <-0.0751897, 5.09012, -1.32968>, <-0.258809, 0.00603404, 0.96591>, <-0.142167, 5.19097, -1.36405>, <-0.498244, 0.0837991, 0.862977>, <-0.145256, 5.09012, -1.3587> , <-0.499992, 0.00603796, 0.866009> }
	smooth_triangle { <-0.0751897, 5.09012, -1.32968>, <-0.258809, 0.00603404, 0.96591>, <-0.143125, 5.00337, -1.36239>, <-0.492649, -0.170884, 0.853285>, <-0.0740867, 5.00337, -1.3338> , <-0.255008, -0.170881, 0.95172> }
	smooth_triangle { <-0.143125, 5.00337, -1.36239>, <-0.492649, -0.170884, 0.853285>, <-0.0751897, 5.09012, -1.32968>, <-0.258809, 0.00603404, 0.96591>, <-0.145256, 5.09012, -1.3587> , <-0.499992, 0.00603796, 0.866009> }
	smooth_triangle { <-0.0740867, 5.00337, -1.3338>, <-0.255008, -0.170881, 0.95172>, <-0.133746, 4.94148, -1.37864>, <-0.458506, -0.398846, 0.794163>, <-0.0692318, 4.94148, -1.35191> , <-0.237344, -0.398838, 0.885774> }
	smooth_triangle { <-0.133746, 4.94148, -1.37864>, <-0.458506, -0.398846, 0.794163>, <-0.0740867, 5.00337, -1.3338>, <-0.255008, -0.170881, 0.95172>, <-0.143125, 5.00337, -1.36239> , <-0.492649, -0.170884, 0.853285> }
	smooth_triangle { <-0.0692318, 4.94148, -1.35191>, <-0.237344, -0.398838, 0.885774>, <-0.123018, 4.90453, -1.39722>, <-0.415149, -0.557309, 0.719067>, <-0.0636789, 4.90453, -1.37264> , <-0.214906, -0.557304, 0.802015> }
	smooth_triangle { <-0.123018, 4.90453, -1.39722>, <-0.415149, -0.557309, 0.719067>, <-0.0692318, 4.94148, -1.35191>, <-0.237344, -0.398838, 0.885774>, <-0.133746, 4.94148, -1.37864> , <-0.458506, -0.398846, 0.794163> }
	smooth_triangle { <-0.0636789, 4.90453, -1.37264>, <-0.214906, -0.557304, 0.802015>, <-0.109429, 4.86923, -1.42076>, <-0.358521, -0.697034, 0.620972>, <-0.0566444, 4.86923, -1.39889> , <-0.185586, -0.697037, 0.692602> }
	smooth_triangle { <-0.109429, 4.86923, -1.42076>, <-0.358521, -0.697034, 0.620972>, <-0.0636789, 4.90453, -1.37264>, <-0.214906, -0.557304, 0.802015>, <-0.123018, 4.90453, -1.39722> , <-0.415149, -0.557309, 0.719067> }
	smooth_triangle { <-0.109429, 4.86923, -1.42076>, <-0.358521, -0.697034, 0.620972>, <-0.0486508, 4.84402, -1.42872>, <-0.154029, -0.803636, 0.574842>, <-0.0566444, 4.86923, -1.39889> , <-0.185586, -0.697037, 0.692602> }
	smooth_triangle { <-0.0486508, 4.84402, -1.42872>, <-0.154029, -0.803636, 0.574842>, <-0.109429, 4.86923, -1.42076>, <-0.358521, -0.697034, 0.620972>, <-0.0939859, 4.84402, -1.4475> , <-0.297562, -0.803634, 0.515392> }
	smooth_triangle { <-0.0939859, 4.84402, -1.4475>, <-0.297562, -0.803634, 0.515392>, <-0.0361805, 4.81174, -1.47526>, <-0.117459, -0.891094, 0.438354>, <-0.0486508, 4.84402, -1.42872> , <-0.154029, -0.803636, 0.574842> }
	smooth_triangle { <-0.0361805, 4.81174, -1.47526>, <-0.117459, -0.891094, 0.438354>, <-0.0939859, 4.84402, -1.4475>, <-0.297562, -0.803634, 0.515392>, <-0.0698953, 4.81174, -1.48923> , <-0.226908, -0.891095, 0.393017> }
	smooth_triangle { <-0.0698953, 4.81174, -1.48923>, <-0.226908, -0.891095, 0.393017>, <-0.0233905, 4.79359, -1.523>, <-0.0892506, -0.938663, 0.333085>, <-0.0361805, 4.81174, -1.47526> , <-0.117459, -0.891094, 0.438354> }
	smooth_triangle { <-0.0233905, 4.79359, -1.523>, <-0.0892506, -0.938663, 0.333085>, <-0.0698953, 4.81174, -1.48923>, <-0.226908, -0.891095, 0.393017>, <-0.0451869, 4.79359, -1.53202> , <-0.172419, -0.938663, 0.298637> }
	smooth_triangle { <-0.127342, 5.44312, -1.38973>, <-0.495751, 0.130135, 0.858659>, <-0.0687949, 5.3584, -1.35354>, <-0.256617, 0.130135, 0.957712>, <-0.0659171, 5.44312, -1.36428> , <-0.256617, 0.130135, 0.957712> }
	smooth_triangle { <-0.0687949, 5.3584, -1.35354>, <-0.256617, 0.130135, 0.957712>, <-0.127342, 5.44312, -1.38973>, <-0.495751, 0.130135, 0.858659>, <-0.132902, 5.3584, -1.3801> , <-0.495751, 0.130135, 0.858659> }
	smooth_triangle { <-0.0451869, 4.79359, -1.53202>, <-0.0713938, -0.989754, 0.123656>, <-0.00112345, 4.78118, -1.6061>, <-0.0369502, -0.989755, 0.137912>, <-0.0233905, 4.79359, -1.523> , <-0.0369502, -0.989755, 0.137912> }
	smooth_triangle { <-0.00112345, 4.78118, -1.6061>, <-0.0369502, -0.989755, 0.137912>, <-0.0451869, 4.79359, -1.53202>, <-0.0713938, -0.989754, 0.123656>, <-0.00217035, 4.78118, -1.60653> , <-0.0713938, -0.989754, 0.123656> }
	smooth_triangle { <-0.127342, 5.44312, -1.38973>, <-0.478171, -0.292277, 0.828207>, <-0.17721, 5.42981, -1.43308>, <-0.556619, -0.616728, 0.556616>, <-0.125307, 5.42981, -1.39325> , <-0.393592, -0.61672, 0.68172> }
	smooth_triangle { <-0.17721, 5.42981, -1.43308>, <-0.556619, -0.616728, 0.556616>, <-0.127342, 5.44312, -1.38973>, <-0.478171, -0.292277, 0.828207>, <-0.180089, 5.44312, -1.4302> , <-0.676217, -0.292331, 0.676219> }
	smooth_triangle { <-0.17721, 5.42981, -1.43308>, <-0.556619, -0.616728, 0.556616>, <-0.122134, 5.426, -1.39875>, <-0.132055, -0.964493, 0.228725>, <-0.125307, 5.42981, -1.39325> , <-0.393592, -0.61672, 0.68172> }
	smooth_triangle { <-0.122134, 5.426, -1.39875>, <-0.132055, -0.964493, 0.228725>, <-0.17721, 5.42981, -1.43308>, <-0.556619, -0.616728, 0.556616>, <-0.172724, 5.426, -1.43757> , <-0.186767, -0.964488, 0.186763> }
	smooth_triangle { <-0.172724, 5.426, -1.43757>, <-0.186767, -0.964488, 0.186763>, <-0.000317232, 5.42727, -1.60974>, <0.00260136, -0.999986, -0.00451089>, <-0.122134, 5.426, -1.39875> , <-0.132055, -0.964493, 0.228725> }
	smooth_triangle { <-0.000317232, 5.42727, -1.60974>, <0.00260136, -0.999986, -0.00451089>, <-0.172724, 5.426, -1.43757>, <-0.186767, -0.964488, 0.186763>, <-0.000448634, 5.42727, -1.60984> , <0.00368265, -0.999986, -0.00368269> }
	smooth_triangle { <-0.187951, 5.3584, -1.42234>, <-0.702345, 0.115858, 0.702345>, <-0.136608, 5.29486, -1.37368>, <-0.496909, 0.111142, 0.860656>, <-0.132902, 5.3584, -1.3801> , <-0.496638, 0.115861, 0.86019> }
	smooth_triangle { <-0.136608, 5.29486, -1.37368>, <-0.496909, 0.111142, 0.860656>, <-0.187951, 5.3584, -1.42234>, <-0.702345, 0.115858, 0.702345>, <-0.193192, 5.29486, -1.4171> , <-0.702726, 0.111139, 0.702726> }
	smooth_triangle { <-0.193192, 5.29486, -1.4171>, <-0.702726, 0.111139, 0.702726>, <-0.142167, 5.19097, -1.36405>, <-0.498244, 0.0837991, 0.862977>, <-0.136608, 5.29486, -1.37368> , <-0.496909, 0.111142, 0.860656> }
	smooth_triangle { <-0.142167, 5.19097, -1.36405>, <-0.498244, 0.0837991, 0.862977>, <-0.193192, 5.29486, -1.4171>, <-0.702726, 0.111139, 0.702726>, <-0.201054, 5.19097, -1.40924> , <-0.704621, 0.0838019, 0.704618> }
	smooth_triangle { <-0.201054, 5.19097, -1.40924>, <-0.704621, 0.0838019, 0.704618>, <-0.145256, 5.09012, -1.3587>, <-0.499992, 0.00603796, 0.866009>, <-0.142167, 5.19097, -1.36405> , <-0.498244, 0.0837991, 0.862977> }
	smooth_triangle { <-0.145256, 5.09012, -1.3587>, <-0.499992, 0.00603796, 0.866009>, <-0.201054, 5.19097, -1.40924>, <-0.704621, 0.0838019, 0.704618>, <-0.205423, 5.09012, -1.40487> , <-0.707097, 0.00603899, 0.707091> }
	smooth_triangle { <-0.145256, 5.09012, -1.3587>, <-0.499992, 0.00603796, 0.866009>, <-0.202408, 5.00337, -1.40788>, <-0.69671, -0.170885, 0.696702>, <-0.143125, 5.00337, -1.36239> , <-0.492649, -0.170884, 0.853285> }
	smooth_triangle { <-0.202408, 5.00337, -1.40788>, <-0.69671, -0.170885, 0.696702>, <-0.145256, 5.09012, -1.3587>, <-0.499992, 0.00603796, 0.866009>, <-0.205423, 5.09012, -1.40487> , <-0.707097, 0.00603899, 0.707091> }
	smooth_triangle { <-0.143125, 5.00337, -1.36239>, <-0.492649, -0.170884, 0.853285>, <-0.189144, 4.94148, -1.42115>, <-0.648435, -0.398836, 0.64843>, <-0.133746, 4.94148, -1.37864> , <-0.458506, -0.398846, 0.794163> }
	smooth_triangle { <-0.189144, 4.94148, -1.42115>, <-0.648435, -0.398836, 0.64843>, <-0.143125, 5.00337, -1.36239>, <-0.492649, -0.170884, 0.853285>, <-0.202408, 5.00337, -1.40788> , <-0.69671, -0.170885, 0.696702> }
	smooth_triangle { <-0.133746, 4.94148, -1.37864>, <-0.458506, -0.398846, 0.794163>, <-0.173975, 4.90453, -1.43632>, <-0.587116, -0.557307, 0.587114>, <-0.123018, 4.90453, -1.39722> , <-0.415149, -0.557309, 0.719067> }
	smooth_triangle { <-0.173975, 4.90453, -1.43632>, <-0.587116, -0.557307, 0.587114>, <-0.133746, 4.94148, -1.37864>, <-0.458506, -0.398846, 0.794163>, <-0.189144, 4.94148, -1.42115> , <-0.648435, -0.398836, 0.64843> }
	smooth_triangle { <-0.123018, 4.90453, -1.39722>, <-0.415149, -0.557309, 0.719067>, <-0.154756, 4.86923, -1.45554>, <-0.50702, -0.697039, 0.507017>, <-0.109429, 4.86923, -1.42076> , <-0.358521, -0.697034, 0.620972> }
	smooth_triangle { <-0.154756, 4.86923, -1.45554>, <-0.50702, -0.697039, 0.507017>, <-0.123018, 4.90453, -1.39722>, <-0.415149, -0.557309, 0.719067>, <-0.173975, 4.90453, -1.43632> , <-0.587116, -0.557307, 0.587114> }
	smooth_triangle { <-0.154756, 4.86923, -1.45554>, <-0.50702, -0.697039, 0.507017>, <-0.0939859, 4.84402, -1.4475>, <-0.297562, -0.803634, 0.515392>, <-0.109429, 4.86923, -1.42076> , <-0.358521, -0.697034, 0.620972> }
	smooth_triangle { <-0.0939859, 4.84402, -1.4475>, <-0.297562, -0.803634, 0.515392>, <-0.154756, 4.86923, -1.45554>, <-0.50702, -0.697039, 0.507017>, <-0.132916, 4.84402, -1.47737> , <-0.420818, -0.803634, 0.420814> }
	smooth_triangle { <-0.132916, 4.84402, -1.47737>, <-0.420818, -0.803634, 0.420814>, <-0.0698953, 4.81174, -1.48923>, <-0.226908, -0.891095, 0.393017>, <-0.0939859, 4.84402, -1.4475> , <-0.297562, -0.803634, 0.515391> }
	smooth_triangle { <-0.0698953, 4.81174, -1.48923>, <-0.226908, -0.891095, 0.393017>, <-0.132916, 4.84402, -1.47737>, <-0.420818, -0.803634, 0.420814>, <-0.0988468, 4.81174, -1.51144> , <-0.320898, -0.891095, 0.320897> }
	smooth_triangle { <-0.0988468, 4.81174, -1.51144>, <-0.320898, -0.891095, 0.320897>, <-0.0451869, 4.79359, -1.53202>, <-0.172419, -0.938663, 0.298637>, <-0.0698953, 4.81174, -1.48923> , <-0.226908, -0.891095, 0.393017> }
	smooth_triangle { <-0.0451869, 4.79359, -1.53202>, <-0.172419, -0.938663, 0.298637>, <-0.0988468, 4.81174, -1.51144>, <-0.320898, -0.891095, 0.320897>, <-0.063904, 4.79359, -1.54639> , <-0.243835, -0.938663, 0.243836> }
	smooth_triangle { <-0.180089, 5.44312, -1.4302>, <-0.701093, 0.130127, 0.701096>, <-0.132902, 5.3584, -1.3801>, <-0.495751, 0.130135, 0.858659>, <-0.127342, 5.44312, -1.38973> , <-0.495751, 0.130135, 0.858659> }
	smooth_triangle { <-0.132902, 5.3584, -1.3801>, <-0.495751, 0.130135, 0.858659>, <-0.180089, 5.44312, -1.4302>, <-0.701093, 0.130127, 0.701096>, <-0.187951, 5.3584, -1.42234> , <-0.701093, 0.130127, 0.701096> }
	smooth_triangle { <-0.063904, 4.79359, -1.54639>, <-0.100958, -0.989755, 0.10096>, <-0.00217035, 4.78118, -1.60653>, <-0.0713938, -0.989754, 0.123656>, <-0.0451869, 4.79359, -1.53202> , <-0.0713938, -0.989754, 0.123656> }
	smooth_triangle { <-0.00217035, 4.78118, -1.60653>, <-0.0713938, -0.989754, 0.123656>, <-0.063904, 4.79359, -1.54639>, <-0.100958, -0.989755, 0.10096>, <-0.00306932, 4.78118, -1.60722> , <-0.100958, -0.989755, 0.10096> }
	smooth_triangle { <-0.217038, 5.42981, -1.48498>, <-0.681713, -0.616728, 0.393591>, <-0.180089, 5.44312, -1.4302>, <-0.676217, -0.292331, 0.676219>, <-0.220563, 5.44312, -1.48295> , <-0.828192, -0.292336, 0.47816> }
	smooth_triangle { <-0.180089, 5.44312, -1.4302>, <-0.676217, -0.292331, 0.676219>, <-0.217038, 5.42981, -1.48498>, <-0.681713, -0.616728, 0.393591>, <-0.17721, 5.42981, -1.43308> , <-0.556619, -0.616728, 0.556616> }
	smooth_triangle { <-0.217038, 5.42981, -1.48498>, <-0.681713, -0.616728, 0.393591>, <-0.172724, 5.426, -1.43757>, <-0.186767, -0.964488, 0.186763>, <-0.17721, 5.42981, -1.43308> , <-0.556619, -0.616728, 0.556616> }
	smooth_triangle { <-0.172724, 5.426, -1.43757>, <-0.186767, -0.964488, 0.186763>, <-0.217038, 5.42981, -1.48498>, <-0.681713, -0.616728, 0.393591>, <-0.211543, 5.426, -1.48816> , <-0.228741, -0.964488, 0.132065> }
	smooth_triangle { <-0.211543, 5.426, -1.48816>, <-0.228741, -0.964488, 0.132065>, <-0.000448634, 5.42727, -1.60984>, <0.00368265, -0.999986, -0.00368269>, <-0.172724, 5.426, -1.43757> , <-0.186767, -0.964488, 0.186763> }
	smooth_triangle { <-0.000448634, 5.42727, -1.60984>, <0.00368265, -0.999986, -0.00368269>, <-0.211543, 5.426, -1.48816>, <-0.228741, -0.964488, 0.132065>, <-0.000549461, 5.42727, -1.60997> , <0.00451018, -0.999986, -0.00260398> }
	smooth_triangle { <-0.236611, 5.29486, -1.47368>, <-0.860657, 0.111139, 0.496909>, <-0.187951, 5.3584, -1.42234>, <-0.702345, 0.115858, 0.702345>, <-0.230192, 5.3584, -1.47739> , <-0.86019, 0.115858, 0.496639> }
	smooth_triangle { <-0.187951, 5.3584, -1.42234>, <-0.702345, 0.115858, 0.702345>, <-0.236611, 5.29486, -1.47368>, <-0.860657, 0.111139, 0.496909>, <-0.193192, 5.29486, -1.4171> , <-0.702726, 0.111139, 0.702726> }
	smooth_triangle { <-0.24624, 5.19097, -1.46812>, <-0.862978, 0.0838009, 0.498244>, <-0.193192, 5.29486, -1.4171>, <-0.702726, 0.111139, 0.702726>, <-0.236611, 5.29486, -1.47368> , <-0.860657, 0.111139, 0.496909> }
	smooth_triangle { <-0.193192, 5.29486, -1.4171>, <-0.702726, 0.111139, 0.702726>, <-0.24624, 5.19097, -1.46812>, <-0.862978, 0.0838009, 0.498244>, <-0.201054, 5.19097, -1.40924> , <-0.704621, 0.0838019, 0.704618> }
	smooth_triangle { <-0.25159, 5.09012, -1.46504>, <-0.866009, 0.00603683, 0.499992>, <-0.201054, 5.19097, -1.40924>, <-0.704621, 0.0838019, 0.704618>, <-0.24624, 5.19097, -1.46812> , <-0.862978, 0.0838009, 0.498244> }
	smooth_triangle { <-0.201054, 5.19097, -1.40924>, <-0.704621, 0.0838019, 0.704618>, <-0.25159, 5.09012, -1.46504>, <-0.866009, 0.00603683, 0.499992>, <-0.205423, 5.09012, -1.40487> , <-0.707097, 0.00603899, 0.707091> }
	smooth_triangle { <-0.247899, 5.00337, -1.46716>, <-0.853284, -0.170887, 0.492649>, <-0.205423, 5.09012, -1.40487>, <-0.707097, 0.00603899, 0.707091>, <-0.25159, 5.09012, -1.46504> , <-0.866009, 0.00603683, 0.499992> }
	smooth_triangle { <-0.205423, 5.09012, -1.40487>, <-0.707097, 0.00603899, 0.707091>, <-0.247899, 5.00337, -1.46716>, <-0.853284, -0.170887, 0.492649>, <-0.202408, 5.00337, -1.40788> , <-0.69671, -0.170885, 0.696702> }
	smooth_triangle { <-0.231654, 4.94148, -1.47654>, <-0.794167, -0.398831, 0.458511>, <-0.202408, 5.00337, -1.40788>, <-0.69671, -0.170885, 0.696702>, <-0.247899, 5.00337, -1.46716> , <-0.853284, -0.170887, 0.492649> }
	smooth_triangle { <-0.202408, 5.00337, -1.40788>, <-0.69671, -0.170885, 0.696702>, <-0.231654, 4.94148, -1.47654>, <-0.794167, -0.398831, 0.458511>, <-0.189144, 4.94148, -1.42115> , <-0.648435, -0.398836, 0.64843> }
	smooth_triangle { <-0.213074, 4.90453, -1.48727>, <-0.719071, -0.557303, 0.415152>, <-0.189144, 4.94148, -1.42115>, <-0.648435, -0.398836, 0.64843>, <-0.231654, 4.94148, -1.47654> , <-0.794167, -0.398831, 0.458511> }
	smooth_triangle { <-0.189144, 4.94148, -1.42115>, <-0.648435, -0.398836, 0.64843>, <-0.213074, 4.90453, -1.48727>, <-0.719071, -0.557303, 0.415152>, <-0.173975, 4.90453, -1.43632> , <-0.587116, -0.557307, 0.587114> }
	smooth_triangle { <-0.189535, 4.86923, -1.50086>, <-0.620966, -0.697042, 0.358516>, <-0.173975, 4.90453, -1.43632>, <-0.587116, -0.557307, 0.587114>, <-0.213074, 4.90453, -1.48727> , <-0.719071, -0.557303, 0.415152> }
	smooth_triangle { <-0.173975, 4.90453, -1.43632>, <-0.587116, -0.557307, 0.587114>, <-0.189535, 4.86923, -1.50086>, <-0.620966, -0.697042, 0.358516>, <-0.154756, 4.86923, -1.45554> , <-0.50702, -0.697039, 0.507017> }
	smooth_triangle { <-0.189535, 4.86923, -1.50086>, <-0.620966, -0.697042, 0.358516>, <-0.132916, 4.84402, -1.47737>, <-0.420818, -0.803634, 0.420814>, <-0.154756, 4.86923, -1.45554> , <-0.50702, -0.697039, 0.507017> }
	smooth_triangle { <-0.132916, 4.84402, -1.47737>, <-0.420818, -0.803634, 0.420814>, <-0.189535, 4.86923, -1.50086>, <-0.620966, -0.697042, 0.358516>, <-0.162788, 4.84402, -1.5163> , <-0.515392, -0.803635, 0.297562> }
	smooth_triangle { <-0.162788, 4.84402, -1.5163>, <-0.515392, -0.803635, 0.297562>, <-0.0988468, 4.81174, -1.51144>, <-0.320898, -0.891095, 0.320897>, <-0.132916, 4.84402, -1.47737> , <-0.420818, -0.803634, 0.420814> }
	smooth_triangle { <-0.0988468, 4.81174, -1.51144>, <-0.320898, -0.891095, 0.320897>, <-0.162788, 4.84402, -1.5163>, <-0.515392, -0.803635, 0.297562>, <-0.121062, 4.81174, -1.54039> , <-0.393019, -0.891094, 0.226909> }
	smooth_triangle { <-0.121062, 4.81174, -1.54039>, <-0.393019, -0.891094, 0.226909>, <-0.063904, 4.79359, -1.54639>, <-0.243835, -0.938663, 0.243836>, <-0.0988468, 4.81174, -1.51144> , <-0.320898, -0.891095, 0.320897> }
	smooth_triangle { <-0.063904, 4.79359, -1.54639>, <-0.243835, -0.938663, 0.243836>, <-0.121062, 4.81174, -1.54039>, <-0.393019, -0.891094, 0.226909>, <-0.078266, 4.79359, -1.5651> , <-0.298638, -0.938663, 0.172418> }
	smooth_triangle { <-0.230192, 5.3584, -1.47739>, <-0.85866, 0.130126, 0.495753>, <-0.180089, 5.44312, -1.4302>, <-0.701093, 0.130127, 0.701096>, <-0.220563, 5.44312, -1.48295> , <-0.85866, 0.130126, 0.495753> }
	smooth_triangle { <-0.180089, 5.44312, -1.4302>, <-0.701093, 0.130127, 0.701096>, <-0.230192, 5.3584, -1.47739>, <-0.85866, 0.130126, 0.495753>, <-0.187951, 5.3584, -1.42234> , <-0.701093, 0.130127, 0.701096> }
	smooth_triangle { <-0.078266, 4.79359, -1.5651>, <-0.123662, -0.989754, 0.0713816>, <-0.00306932, 4.78118, -1.60722>, <-0.100958, -0.989755, 0.10096>, <-0.063904, 4.79359, -1.54639> , <-0.100958, -0.989755, 0.10096> }
	smooth_triangle { <-0.00306932, 4.78118, -1.60722>, <-0.100958, -0.989755, 0.10096>, <-0.078266, 4.79359, -1.5651>, <-0.123662, -0.989754, 0.0713816>, <-0.00375913, 4.78118, -1.60812> , <-0.123662, -0.989754, 0.0713816> }
	smooth_triangle { <-0.242074, 5.42981, -1.54543>, <-0.760363, -0.616717, 0.203733>, <-0.220563, 5.44312, -1.48295>, <-0.828192, -0.292336, 0.47816>, <-0.246005, 5.44312, -1.54437> , <-0.92375, -0.292276, 0.24751> }
	smooth_triangle { <-0.220563, 5.44312, -1.48295>, <-0.828192, -0.292336, 0.47816>, <-0.242074, 5.42981, -1.54543>, <-0.760363, -0.616717, 0.203733>, <-0.217038, 5.42981, -1.48498> , <-0.681713, -0.616728, 0.393591> }
	smooth_triangle { <-0.242074, 5.42981, -1.54543>, <-0.760363, -0.616717, 0.203733>, <-0.211543, 5.426, -1.48816>, <-0.228741, -0.964488, 0.132065>, <-0.217038, 5.42981, -1.48498> , <-0.681713, -0.616728, 0.393591> }
	smooth_triangle { <-0.211543, 5.426, -1.48816>, <-0.228741, -0.964488, 0.132065>, <-0.242074, 5.42981, -1.54543>, <-0.760363, -0.616717, 0.203733>, <-0.235945, 5.426, -1.54707> , <-0.255112, -0.964492, 0.0683558> }
	smooth_triangle { <-0.235945, 5.426, -1.54707>, <-0.255112, -0.964492, 0.0683558>, <-0.000549461, 5.42727, -1.60997>, <0.00451018, -0.999986, -0.00260398>, <-0.211543, 5.426, -1.48816> , <-0.228741, -0.964488, 0.132065> }
	smooth_triangle { <-0.000549461, 5.42727, -1.60997>, <0.00451018, -0.999986, -0.00260398>, <-0.235945, 5.426, -1.54707>, <-0.255112, -0.964492, 0.0683558>, <-0.000612844, 5.42727, -1.61013> , <0.00503071, -0.999986, -0.00134759> }
	smooth_triangle { <-0.263906, 5.29486, -1.53958>, <-0.959941, 0.111141, 0.257216>, <-0.230192, 5.3584, -1.47739>, <-0.86019, 0.115858, 0.496639>, <-0.256747, 5.3584, -1.5415> , <-0.959421, 0.11586, 0.257075> }
	smooth_triangle { <-0.230192, 5.3584, -1.47739>, <-0.86019, 0.115858, 0.496639>, <-0.263906, 5.29486, -1.53958>, <-0.959941, 0.111141, 0.257216>, <-0.236611, 5.29486, -1.47368> , <-0.860657, 0.111139, 0.496909> }
	smooth_triangle { <-0.274646, 5.19097, -1.5367>, <-0.962528, 0.0837989, 0.25791>, <-0.236611, 5.29486, -1.47368>, <-0.860657, 0.111139, 0.496909>, <-0.263906, 5.29486, -1.53958> , <-0.959941, 0.111141, 0.257216> }
	smooth_triangle { <-0.236611, 5.29486, -1.47368>, <-0.860657, 0.111139, 0.496909>, <-0.274646, 5.19097, -1.5367>, <-0.962528, 0.0837989, 0.25791>, <-0.24624, 5.19097, -1.46812> , <-0.862978, 0.0838009, 0.498244> }
	smooth_triangle { <-0.280613, 5.09012, -1.5351>, <-0.965909, 0.00603571, 0.258814>, <-0.24624, 5.19097, -1.46812>, <-0.862978, 0.0838009, 0.498244>, <-0.274646, 5.19097, -1.5367> , <-0.962528, 0.0837989, 0.25791> }
	smooth_triangle { <-0.24624, 5.19097, -1.46812>, <-0.862978, 0.0838009, 0.498244>, <-0.280613, 5.09012, -1.5351>, <-0.965909, 0.00603571, 0.258814>, <-0.25159, 5.09012, -1.46504> , <-0.866009, 0.00603683, 0.499992> }
	smooth_triangle { <-0.276495, 5.00337, -1.5362>, <-0.951717, -0.170885, 0.255014>, <-0.25159, 5.09012, -1.46504>, <-0.866009, 0.00603683, 0.499992>, <-0.280613, 5.09012, -1.5351> , <-0.965909, 0.00603571, 0.258814> }
	smooth_triangle { <-0.25159, 5.09012, -1.46504>, <-0.866009, 0.00603683, 0.499992>, <-0.276495, 5.00337, -1.5362>, <-0.951717, -0.170885, 0.255014>, <-0.247899, 5.00337, -1.46716> , <-0.853284, -0.170887, 0.492649> }
	smooth_triangle { <-0.258376, 4.94148, -1.54106>, <-0.885774, -0.39884, 0.237343>, <-0.247899, 5.00337, -1.46716>, <-0.853284, -0.170887, 0.492649>, <-0.276495, 5.00337, -1.5362> , <-0.951717, -0.170885, 0.255014> }
	smooth_triangle { <-0.247899, 5.00337, -1.46716>, <-0.853284, -0.170887, 0.492649>, <-0.258376, 4.94148, -1.54106>, <-0.885774, -0.39884, 0.237343>, <-0.231654, 4.94148, -1.47654> , <-0.794167, -0.398831, 0.458511> }
	smooth_triangle { <-0.237653, 4.90453, -1.54661>, <-0.802014, -0.557307, 0.214902>, <-0.231654, 4.94148, -1.47654>, <-0.794167, -0.398831, 0.458511>, <-0.258376, 4.94148, -1.54106> , <-0.885774, -0.39884, 0.237343> }
	smooth_triangle { <-0.231654, 4.94148, -1.47654>, <-0.794167, -0.398831, 0.458511>, <-0.237653, 4.90453, -1.54661>, <-0.802014, -0.557307, 0.214902>, <-0.213074, 4.90453, -1.48727> , <-0.719071, -0.557303, 0.415152> }
	smooth_triangle { <-0.2114, 4.86923, -1.55365>, <-0.692601, -0.697038, 0.185588>, <-0.213074, 4.90453, -1.48727>, <-0.719071, -0.557303, 0.415152>, <-0.237653, 4.90453, -1.54661> , <-0.802014, -0.557307, 0.214902> }
	smooth_triangle { <-0.213074, 4.90453, -1.48727>, <-0.719071, -0.557303, 0.415152>, <-0.2114, 4.86923, -1.55365>, <-0.692601, -0.697038, 0.185588>, <-0.189535, 4.86923, -1.50086> , <-0.620966, -0.697042, 0.358516> }
	smooth_triangle { <-0.2114, 4.86923, -1.55365>, <-0.692601, -0.697038, 0.185588>, <-0.162788, 4.84402, -1.5163>, <-0.515392, -0.803635, 0.297562>, <-0.189535, 4.86923, -1.50086> , <-0.620966, -0.697042, 0.358516> }
	smooth_triangle { <-0.162788, 4.84402, -1.5163>, <-0.515392, -0.803635, 0.297562>, <-0.2114, 4.86923, -1.55365>, <-0.692601, -0.697038, 0.185588>, <-0.181567, 4.84402, -1.56164> , <-0.574843, -0.803635, 0.154033> }
	smooth_triangle { <-0.181567, 4.84402, -1.56164>, <-0.574843, -0.803635, 0.154033>, <-0.121062, 4.81174, -1.54039>, <-0.393019, -0.891094, 0.226909>, <-0.162788, 4.84402, -1.5163> , <-0.515392, -0.803635, 0.297562> }
	smooth_triangle { <-0.121062, 4.81174, -1.54039>, <-0.393019, -0.891094, 0.226909>, <-0.181567, 4.84402, -1.56164>, <-0.574843, -0.803635, 0.154033>, <-0.135027, 4.81174, -1.57411> , <-0.438354, -0.891094, 0.117459> }
	smooth_triangle { <-0.135027, 4.81174, -1.57411>, <-0.438354, -0.891094, 0.117459>, <-0.078266, 4.79359, -1.5651>, <-0.298638, -0.938663, 0.172418>, <-0.121062, 4.81174, -1.54039> , <-0.393019, -0.891094, 0.226909> }
	smooth_triangle { <-0.078266, 4.79359, -1.5651>, <-0.298638, -0.938663, 0.172418>, <-0.135027, 4.81174, -1.57411>, <-0.438354, -0.891094, 0.117459>, <-0.0872945, 4.79359, -1.5869> , <-0.333087, -0.938663, 0.0892505> }
	smooth_triangle { <-0.256747, 5.3584, -1.5415>, <-0.957712, 0.130136, 0.256618>, <-0.220563, 5.44312, -1.48295>, <-0.85866, 0.130126, 0.495753>, <-0.246005, 5.44312, -1.54437> , <-0.957712, 0.130136, 0.256618> }
	smooth_triangle { <-0.220563, 5.44312, -1.48295>, <-0.85866, 0.130126, 0.495753>, <-0.256747, 5.3584, -1.5415>, <-0.957712, 0.130136, 0.256618>, <-0.230192, 5.3584, -1.47739> , <-0.85866, 0.130126, 0.495753> }
	smooth_triangle { <-0.0872945, 4.79359, -1.5869>, <-0.137916, -0.989754, 0.0369552>, <-0.00375913, 4.78118, -1.60812>, <-0.123662, -0.989754, 0.0713816>, <-0.078266, 4.79359, -1.5651> , <-0.123662, -0.989754, 0.0713816> }
	smooth_triangle { <-0.00375913, 4.78118, -1.60812>, <-0.123662, -0.989754, 0.0713816>, <-0.0872945, 4.79359, -1.5869>, <-0.137916, -0.989754, 0.0369552>, <-0.00419277, 4.78118, -1.60917> , <-0.137916, -0.989754, 0.0369552> }
	smooth_triangle { <-0.0903739, 4.79359, -1.61029>, <-0.142781, -0.989754, -1.49038e-008>, <-0.00419277, 4.78118, -1.60917>, <-0.137916, -0.989754, 0.0369552>, <-0.0872945, 4.79359, -1.5869> , <-0.137916, -0.989754, 0.0369552> }
	smooth_triangle { <-0.00419277, 4.78118, -1.60917>, <-0.137916, -0.989754, 0.0369552>, <-0.0903739, 4.79359, -1.61029>, <-0.142781, -0.989754, -1.49038e-008>, <-0.00434068, 4.78118, -1.61029> , <-0.142781, -0.989754, -1.49038e-008> }
	smooth_triangle { <-0.265803, 5.3584, -1.61029>, <-0.991496, 0.130136, -4.05744e-007>, <-0.246005, 5.44312, -1.54437>, <-0.957712, 0.130136, 0.256618>, <-0.254684, 5.44312, -1.61029> , <-0.991496, 0.130136, -4.05744e-007> }
	smooth_triangle { <-0.246005, 5.44312, -1.54437>, <-0.957712, 0.130136, 0.256618>, <-0.265803, 5.3584, -1.61029>, <-0.991496, 0.130136, -4.05744e-007>, <-0.256747, 5.3584, -1.5415> , <-0.957712, 0.130136, 0.256618> }
	smooth_triangle { <-0.273215, 5.29486, -1.61029>, <-0.993805, 0.111142, 3.00566e-008>, <-0.256747, 5.3584, -1.5415>, <-0.959421, 0.11586, 0.257075>, <-0.265803, 5.3584, -1.61029> , <-0.993266, 0.11586, 5.2598e-008> }
	smooth_triangle { <-0.256747, 5.3584, -1.5415>, <-0.959421, 0.11586, 0.257075>, <-0.273215, 5.29486, -1.61029>, <-0.993805, 0.111142, 3.00566e-008>, <-0.263906, 5.29486, -1.53958> , <-0.959941, 0.111141, 0.257216> }
	smooth_triangle { <-0.284334, 5.19097, -1.61029>, <-0.996483, 0.083799, 1.50326e-007>, <-0.263906, 5.29486, -1.53958>, <-0.959941, 0.111141, 0.257216>, <-0.273215, 5.29486, -1.61029> , <-0.993804, 0.111142, 3.00566e-008> }
	smooth_triangle { <-0.263906, 5.29486, -1.53958>, <-0.959941, 0.111141, 0.257216>, <-0.284334, 5.19097, -1.61029>, <-0.996483, 0.083799, 1.50326e-007>, <-0.274646, 5.19097, -1.5367> , <-0.962528, 0.0837989, 0.25791> }
	smooth_triangle { <-0.290511, 5.09012, -1.61029>, <-0.999982, 0.00603373, 2.29546e-007>, <-0.274646, 5.19097, -1.5367>, <-0.962528, 0.0837989, 0.25791>, <-0.284334, 5.19097, -1.61029> , <-0.996483, 0.0837991, 1.50326e-007> }
	smooth_triangle { <-0.274646, 5.19097, -1.5367>, <-0.962528, 0.0837989, 0.25791>, <-0.290511, 5.09012, -1.61029>, <-0.999982, 0.00603373, 2.29546e-007>, <-0.280613, 5.09012, -1.5351> , <-0.965909, 0.00603571, 0.258814> }
	smooth_triangle { <-0.286249, 5.00337, -1.61029>, <-0.985291, -0.170883, 1.51378e-008>, <-0.280613, 5.09012, -1.5351>, <-0.965909, 0.00603571, 0.258814>, <-0.290511, 5.09012, -1.61029> , <-0.999982, 0.00603373, 2.29546e-007> }
	smooth_triangle { <-0.280613, 5.09012, -1.5351>, <-0.965909, 0.00603571, 0.258814>, <-0.286249, 5.00337, -1.61029>, <-0.985291, -0.170883, 1.51378e-008>, <-0.276495, 5.00337, -1.5362> , <-0.951717, -0.170885, 0.255014> }
	smooth_triangle { <-0.267492, 4.94148, -1.61029>, <-0.917019, -0.398843, 6.02495e-007>, <-0.276495, 5.00337, -1.5362>, <-0.951717, -0.170885, 0.255014>, <-0.286249, 5.00337, -1.61029> , <-0.985291, -0.170883, 1.51378e-008> }
	smooth_triangle { <-0.276495, 5.00337, -1.5362>, <-0.951717, -0.170885, 0.255014>, <-0.267492, 4.94148, -1.61029>, <-0.917019, -0.398843, 6.02495e-007>, <-0.258376, 4.94148, -1.54106> , <-0.885774, -0.39884, 0.237343> }
	smooth_triangle { <-0.246036, 4.90453, -1.61029>, <-0.830308, -0.557305, 2.91041e-007>, <-0.258376, 4.94148, -1.54106>, <-0.885774, -0.39884, 0.237343>, <-0.267492, 4.94148, -1.61029> , <-0.917019, -0.398843, 6.04383e-007> }
	smooth_triangle { <-0.258376, 4.94148, -1.54106>, <-0.885774, -0.39884, 0.237343>, <-0.246036, 4.90453, -1.61029>, <-0.830308, -0.557305, 2.91041e-007>, <-0.237653, 4.90453, -1.54661> , <-0.802014, -0.557307, 0.214902> }
	smooth_triangle { <-0.218858, 4.86923, -1.61029>, <-0.717038, -0.697034, -1.22419e-007>, <-0.237653, 4.90453, -1.54661>, <-0.802014, -0.557307, 0.214902>, <-0.246036, 4.90453, -1.61029> , <-0.830308, -0.557305, 2.91041e-007> }
	smooth_triangle { <-0.237653, 4.90453, -1.54661>, <-0.802014, -0.557307, 0.214902>, <-0.218858, 4.86923, -1.61029>, <-0.717038, -0.697034, -1.22419e-007>, <-0.2114, 4.86923, -1.55365> , <-0.6926, -0.697038, 0.185588> }
	smooth_triangle { <-0.218858, 4.86923, -1.61029>, <-0.717038, -0.697034, -1.22419e-007>, <-0.181567, 4.84402, -1.56164>, <-0.574843, -0.803635, 0.154033>, <-0.2114, 4.86923, -1.55365> , <-0.6926, -0.697038, 0.185588> }
	smooth_triangle { <-0.181567, 4.84402, -1.56164>, <-0.574843, -0.803635, 0.154033>, <-0.218858, 4.86923, -1.61029>, <-0.717038, -0.697034, -1.22419e-007>, <-0.187972, 4.84402, -1.61029> , <-0.59512, -0.803637, 4.86317e-008> }
	smooth_triangle { <-0.187972, 4.84402, -1.61029>, <-0.59512, -0.803637, 4.86317e-008>, <-0.135027, 4.81174, -1.57411>, <-0.438354, -0.891094, 0.117459>, <-0.181567, 4.84402, -1.56164> , <-0.574843, -0.803635, 0.154033> }
	smooth_triangle { <-0.135027, 4.81174, -1.57411>, <-0.438354, -0.891094, 0.117459>, <-0.187972, 4.84402, -1.61029>, <-0.59512, -0.803637, 4.86317e-008>, <-0.139791, 4.81174, -1.61029> , <-0.453817, -0.891095, 5.92014e-008> }
	smooth_triangle { <-0.139791, 4.81174, -1.61029>, <-0.453817, -0.891095, 6.01411e-008>, <-0.0872945, 4.79359, -1.5869>, <-0.333087, -0.938663, 0.0892505>, <-0.135027, 4.81174, -1.57411> , <-0.438354, -0.891094, 0.117459> }
	smooth_triangle { <-0.0872945, 4.79359, -1.5869>, <-0.333087, -0.938663, 0.0892505>, <-0.139791, 4.81174, -1.61029>, <-0.453817, -0.891095, 6.01411e-008>, <-0.0903739, 4.79359, -1.61029> , <-0.344835, -0.938663, 5.23942e-007> }
	smooth_triangle { <-0.250613, 5.42981, -1.61029>, <-0.78718, -0.616724, 4.91367e-007>, <-0.246005, 5.44312, -1.54437>, <-0.92375, -0.292276, 0.24751>, <-0.254684, 5.44312, -1.61029> , <-0.956327, -0.2923, 1.67084e-006> }
	smooth_triangle { <-0.246005, 5.44312, -1.54437>, <-0.92375, -0.292276, 0.24751>, <-0.250613, 5.42981, -1.61029>, <-0.78718, -0.616724, 4.91367e-007>, <-0.242074, 5.42981, -1.54543> , <-0.760363, -0.616717, 0.203733> }
	smooth_triangle { <-0.250613, 5.42981, -1.61029>, <-0.78718, -0.616724, 4.91367e-007>, <-0.235945, 5.426, -1.54707>, <-0.255112, -0.964492, 0.0683558>, <-0.242074, 5.42981, -1.54543> , <-0.760363, -0.616717, 0.203733> }
	smooth_triangle { <-0.235945, 5.426, -1.54707>, <-0.255112, -0.964492, 0.0683558>, <-0.250613, 5.42981, -1.61029>, <-0.78718, -0.616724, 4.91367e-007>, <-0.244268, 5.426, -1.61029> , <-0.264115, -0.964491, -3.88942e-007> }
	smooth_triangle { <-0.244268, 5.426, -1.61029>, <-0.264115, -0.964491, -3.89215e-007>, <-0.000612844, 5.42727, -1.61013>, <0.00503071, -0.999986, -0.00134759>, <-0.235945, 5.426, -1.54707> , <-0.255112, -0.964492, 0.0683558> }
	smooth_triangle { <-0.000612844, 5.42727, -1.61013>, <0.00503071, -0.999986, -0.00134759>, <-0.244268, 5.426, -1.61029>, <-0.264115, -0.964491, -3.89215e-007>, <-0.000634464, 5.42727, -1.61029> , <0.00520804, -0.999986, -3.20142e-009> }
material { wine } 
#if (use_photons)
 photons{
  target
  refraction on
  reflection on
  collect off
 }
#end
}

// object wineglass
union {
	smooth_triangle { <-0.0892096, 4.78708, -1.61029>, <-0.142793, -0.989753, 2.05859e-007>, <-0.0013722, 4.77442, -1.60992>, <-0.137918, -0.989754, 0.0369677>, <-0.0861699, 4.78708, -1.5872> , <-0.137918, -0.989754, 0.0369677> }
	smooth_triangle { <-0.0013722, 4.77442, -1.60992>, <-0.137918, -0.989754, 0.0369677>, <-0.0892096, 4.78708, -1.61029>, <-0.142793, -0.989753, 2.05859e-007>, <-0.0014206, 4.77442, -1.61029> , <-0.142793, -0.989753, 2.05859e-007> }
	smooth_triangle { <-0.26822, 5.36342, -1.61029>, <-0.991498, 0.130123, 7.51381e-009>, <-0.248121, 5.44988, -1.54381>, <-0.95591, 0.14362, 0.256142>, <-0.256873, 5.44988, -1.61029> , <-0.989632, 0.143628, -2.25427e-008> }
	smooth_triangle { <-0.248121, 5.44988, -1.54381>, <-0.95591, 0.14362, 0.256142>, <-0.26822, 5.36342, -1.61029>, <-0.991498, 0.130123, 7.51381e-009>, <-0.259079, 5.36342, -1.54087> , <-0.957711, 0.130115, 0.25663> }
	smooth_triangle { <-0.256873, 5.44988, -1.61029>, <-0.989632, 0.143628, -2.25427e-008>, <-0.235944, 5.52912, -1.54707>, <-0.951674, 0.171154, 0.254996>, <-0.244266, 5.52912, -1.61029> , <-0.985245, 0.171152, -3.94471e-007> }
	smooth_triangle { <-0.235944, 5.52912, -1.54707>, <-0.951674, 0.171154, 0.254996>, <-0.256873, 5.44988, -1.61029>, <-0.989632, 0.143628, -2.25427e-008>, <-0.248121, 5.44988, -1.54381> , <-0.95591, 0.14362, 0.256142> }
	smooth_triangle { <-0.244266, 5.52912, -1.61029>, <-0.985245, 0.171152, -3.94471e-007>, <-0.228638, 5.56926, -1.54903>, <-0.949223, 0.185174, 0.254333>, <-0.236704, 5.56926, -1.61029> , <-0.982708, 0.185162, -7.36241e-007> }
	smooth_triangle { <-0.228638, 5.56926, -1.54903>, <-0.949223, 0.185174, 0.254333>, <-0.244266, 5.52912, -1.61029>, <-0.985245, 0.171152, -3.94471e-007>, <-0.235944, 5.52912, -1.54707> , <-0.951674, 0.171154, 0.254996> }
	smooth_triangle { <-0.2304, 5.56926, -1.61029>, <0.192487, 0.981299, 3.81012e-006>, <-0.228638, 5.56926, -1.54903>, <0, 1, 0>, <-0.22255, 5.56926, -1.55066> , <0.185934, 0.981298, -0.0498262> }
	smooth_triangle { <-0.228638, 5.56926, -1.54903>, <0, 1, 0>, <-0.2304, 5.56926, -1.61029>, <0.192487, 0.981299, 3.81012e-006>, <-0.236704, 5.56926, -1.61029> , <0, 1, 0> }
	smooth_triangle { <-0.225358, 5.5672, -1.61029>, <0.378, 0.925805, 7.48218e-006>, <-0.22255, 5.56926, -1.55066>, <0.185934, 0.981298, -0.0498262>, <-0.217678, 5.5672, -1.55196> , <0.365131, 0.9258, -0.0978468> }
	smooth_triangle { <-0.22255, 5.56926, -1.55066>, <0.185934, 0.981298, -0.0498262>, <-0.225358, 5.5672, -1.61029>, <0.378, 0.925805, 7.48218e-006>, <-0.2304, 5.56926, -1.61029> , <0.192487, 0.981299, 3.81012e-006> }
	smooth_triangle { <-0.21646, 5.55794, -1.55229>, <0.95709, 0.134954, -0.256449>, <-0.225358, 5.5672, -1.61029>, <0.990859, 0.134899, -1.72816e-007>, <-0.217678, 5.5672, -1.55196> , <0.95709, 0.134954, -0.256449> }
	smooth_triangle { <-0.225358, 5.5672, -1.61029>, <0.990859, 0.134899, -1.72816e-007>, <-0.21646, 5.55794, -1.55229>, <0.95709, 0.134954, -0.256449>, <-0.224097, 5.55794, -1.61029> , <0.990859, 0.134899, -1.72816e-007> }
	smooth_triangle { <-0.294073, 4.21572, -1.61029>, <0.0286499, -0.99959, 1.49013e-008>, <-0.00176999, 4.22409, -1.60982>, <0.0276742, -0.99959, -0.00741489>, <-0.284052, 4.21572, -1.53418> , <0.0276742, -0.99959, -0.00741489> }
	smooth_triangle { <-0.00176999, 4.22409, -1.60982>, <0.0276742, -0.99959, -0.00741489>, <-0.294073, 4.21572, -1.61029>, <0.0286499, -0.99959, 1.49013e-008>, <-0.00183244, 4.22409, -1.61029> , <0.0286499, -0.99959, 1.49013e-008> }
	smooth_triangle { <-0.294073, 4.21572, -1.61029>, <-0.996406, 0.0847006, 1.50288e-007>, <-0.282986, 4.2287, -1.53446>, <-0.962457, 0.0846605, 0.257895>, <-0.292969, 4.2287, -1.61029> , <-0.996406, 0.0847006, 1.50288e-007> }
	smooth_triangle { <-0.282986, 4.2287, -1.53446>, <-0.962457, 0.0846605, 0.257895>, <-0.294073, 4.21572, -1.61029>, <-0.996406, 0.0847006, 1.50288e-007>, <-0.284052, 4.21572, -1.53418> , <-0.962457, 0.0846605, 0.257895> }
	smooth_triangle { <-0.255349, 4.24779, -1.61029>, <-0.353193, 0.93555, 5.7213e-008>, <-0.282986, 4.2287, -1.53446>, <-0.437087, 0.891762, 0.117116>, <-0.246648, 4.24779, -1.5442> , <-0.341157, 0.935551, 0.091413> }
	smooth_triangle { <-0.282986, 4.2287, -1.53446>, <-0.437087, 0.891762, 0.117116>, <-0.255349, 4.24779, -1.61029>, <-0.353193, 0.93555, 5.7213e-008>, <-0.292969, 4.2287, -1.61029> , <-0.45251, 0.891759, -7.46379e-009> }
	smooth_triangle { <-0.18136, 4.26688, -1.61029>, <-0.214225, 0.976784, 2.75037e-008>, <-0.246648, 4.24779, -1.5442>, <-0.341157, 0.935551, 0.091413>, <-0.175181, 4.26688, -1.56335> , <-0.206926, 0.976784, 0.0554458> }
	smooth_triangle { <-0.246648, 4.24779, -1.5442>, <-0.341157, 0.935551, 0.091413>, <-0.18136, 4.26688, -1.61029>, <-0.214225, 0.976784, 2.75037e-008>, <-0.255349, 4.24779, -1.61029> , <-0.353193, 0.93555, 5.7213e-008> }
	smooth_triangle { <-0.128691, 4.27643, -1.61029>, <-0.161495, 0.986874, -4.47202e-008>, <-0.175181, 4.26688, -1.56335>, <-0.206926, 0.976784, 0.0554458>, <-0.124306, 4.27643, -1.57698> , <-0.155992, 0.986874, 0.0417968> }
	smooth_triangle { <-0.175181, 4.26688, -1.56335>, <-0.206926, 0.976784, 0.0554458>, <-0.128691, 4.27643, -1.61029>, <-0.161495, 0.986874, -4.47202e-008>, <-0.18136, 4.26688, -1.61029> , <-0.214225, 0.976784, 2.75037e-008> }
	smooth_triangle { <-0.0706433, 4.28491, -1.61029>, <-0.144617, 0.989488, -2.32873e-008>, <-0.124306, 4.27643, -1.57698>, <-0.155992, 0.986874, 0.0417968>, <-0.0682361, 4.28491, -1.59201> , <-0.139689, 0.989488, 0.0374289> }
	smooth_triangle { <-0.124306, 4.27643, -1.57698>, <-0.155992, 0.986874, 0.0417968>, <-0.0706433, 4.28491, -1.61029>, <-0.144617, 0.989488, -2.32873e-008>, <-0.128691, 4.27643, -1.61029> , <-0.161495, 0.986874, -4.47202e-008> }
	smooth_triangle { <-0.0706433, 4.28491, -1.61029>, <-0.810461, 0.585793, 1.72336e-007>, <-0.0608309, 4.29552, -1.59399>, <-0.918877, 0.308296, 0.24621>, <-0.0629768, 4.29552, -1.61029> , <-0.95129, 0.308298, 9.06991e-008> }
	smooth_triangle { <-0.0608309, 4.29552, -1.59399>, <-0.918877, 0.308296, 0.24621>, <-0.0706433, 4.28491, -1.61029>, <-0.810461, 0.585793, 1.72336e-007>, <-0.0682361, 4.28491, -1.59201> , <-0.782848, 0.58579, 0.209763> }
	smooth_triangle { <-0.0629768, 4.29552, -1.61029>, <-0.95129, 0.308298, 9.06991e-008>, <-0.0608309, 4.30188, -1.59399>, <-0.965927, 0, 0.258816>, <-0.0629768, 4.30188, -1.61029> , <-1, 0, 3.75744e-009> }
	smooth_triangle { <-0.0608309, 4.30188, -1.59399>, <-0.965927, 0, 0.258816>, <-0.0629768, 4.29552, -1.61029>, <-0.95129, 0.308298, 9.06991e-008>, <-0.0608309, 4.29552, -1.59399> , <-0.918877, 0.308296, 0.24621> }
	smooth_triangle { <-0.0629768, 4.30188, -1.61029>, <-1, 0, 3.75744e-009>, <-0.0608309, 4.30931, -1.59399>, <-0.913791, 0.324093, 0.244846>, <-0.0629768, 4.30931, -1.61029> , <-0.946025, 0.324093, 1.11012e-007> }
	smooth_triangle { <-0.0608309, 4.30931, -1.59399>, <-0.913791, 0.324093, 0.244846>, <-0.0629768, 4.30188, -1.61029>, <-1, 0, 3.75744e-009>, <-0.0608309, 4.30188, -1.59399> , <-0.965927, 0, 0.258816> }
	smooth_triangle { <-0.0629768, 4.30931, -1.61029>, <-0.946025, 0.324093, 1.11012e-007>, <-0.0544832, 4.31779, -1.59569>, <-0.591098, 0.790897, 0.158382>, <-0.0564051, 4.31779, -1.61029> , <-0.61195, 0.790897, 5.11517e-008> }
	smooth_triangle { <-0.0544832, 4.31779, -1.59569>, <-0.591098, 0.790897, 0.158382>, <-0.0629768, 4.30931, -1.61029>, <-0.946025, 0.324093, 1.11012e-007>, <-0.0608309, 4.30931, -1.59399> , <-0.913791, 0.324093, 0.244846> }
	smooth_triangle { <-0.0465479, 4.32203, -1.61029>, <-0.633819, 0.773481, -2.52924e-008>, <-0.0544832, 4.31779, -1.59569>, <-0.591098, 0.790897, 0.158382>, <-0.0449618, 4.32203, -1.59824> , <-0.612221, 0.773482, 0.164043> }
	smooth_triangle { <-0.0544832, 4.31779, -1.59569>, <-0.591098, 0.790897, 0.158382>, <-0.0465479, 4.32203, -1.61029>, <-0.633819, 0.773481, -2.52924e-008>, <-0.0564051, 4.31779, -1.61029> , <-0.61195, 0.790897, 5.11517e-008> }
	smooth_triangle { <-0.0465479, 4.32203, -1.61029>, <-0.633819, 0.773481, -2.52924e-008>, <-0.0407301, 4.3284, -1.59938>, <-0.884158, 0.402664, 0.23691>, <-0.0421669, 4.3284, -1.61029> , <-0.915349, 0.402663, 8.02038e-008> }
	smooth_triangle { <-0.0407301, 4.3284, -1.59938>, <-0.884158, 0.402664, 0.23691>, <-0.0465479, 4.32203, -1.61029>, <-0.633819, 0.773481, -2.52924e-008>, <-0.0449618, 4.32203, -1.59824> , <-0.612221, 0.773482, 0.164043> }
	smooth_triangle { <-0.0421669, 4.3284, -1.61029>, <-0.915349, 0.402663, 8.02038e-008>, <-0.0386144, 4.33794, -1.59994>, <-0.960584, 0.105022, 0.257389>, <-0.0399765, 4.33794, -1.61029> , <-0.99447, 0.105022, 4.54081e-008> }
	smooth_triangle { <-0.0386144, 4.33794, -1.59994>, <-0.960584, 0.105022, 0.257389>, <-0.0421669, 4.3284, -1.61029>, <-0.915349, 0.402663, 8.02038e-008>, <-0.0407301, 4.3284, -1.59938> , <-0.884158, 0.402664, 0.23691> }
	smooth_triangle { <-0.0399765, 4.33794, -1.61029>, <-0.99447, 0.105022, 4.54081e-008>, <-0.043904, 4.69858, -1.59853>, <-0.962597, -0.0829362, 0.257929>, <-0.0454527, 4.69858, -1.61029> , <-0.996555, -0.082936, 4.1423e-008> }
	smooth_triangle { <-0.043904, 4.69858, -1.59853>, <-0.962597, -0.0829362, 0.257929>, <-0.0399765, 4.33794, -1.61029>, <-0.99447, 0.105022, 4.54081e-008>, <-0.0386144, 4.33794, -1.59994> , <-0.960584, 0.105022, 0.257389> }
	smooth_triangle { <-0.0454527, 4.69858, -1.61029>, <-0.996555, -0.082936, 4.1423e-008>, <-0.0460197, 4.71298, -1.59796>, <-0.943693, -0.213317, 0.252863>, <-0.0476431, 4.71298, -1.61029> , <-0.976983, -0.213316, 4.5163e-008> }
	smooth_triangle { <-0.0460197, 4.71298, -1.59796>, <-0.943693, -0.213317, 0.252863>, <-0.0454527, 4.69858, -1.61029>, <-0.996555, -0.082936, 4.1423e-008>, <-0.043904, 4.69858, -1.59853> , <-0.962597, -0.0829362, 0.257929> }
	smooth_triangle { <-0.0476431, 4.71298, -1.61029>, <-0.976983, -0.213316, 4.5163e-008>, <-0.0534252, 4.73974, -1.59597>, <-0.917862, -0.311517, 0.245939>, <-0.0553099, 4.73974, -1.61029> , <-0.950241, -0.311516, -2.44203e-008> }
	smooth_triangle { <-0.0534252, 4.73974, -1.59597>, <-0.917862, -0.311517, 0.245939>, <-0.0476431, 4.71298, -1.61029>, <-0.976983, -0.213316, 4.5163e-008>, <-0.0460197, 4.71298, -1.59796> , <-0.943693, -0.213317, 0.252863> }
	smooth_triangle { <-0.0553099, 4.73974, -1.61029>, <-0.950241, -0.311516, -2.44203e-008>, <-0.0618888, 4.76341, -1.59371>, <-0.805097, -0.552523, 0.215724>, <-0.064072, 4.76341, -1.61029> , <-0.833497, -0.552524, -5.19581e-008> }
	smooth_triangle { <-0.0618888, 4.76341, -1.59371>, <-0.805097, -0.552523, 0.215724>, <-0.0553099, 4.73974, -1.61029>, <-0.950241, -0.311516, -2.44203e-008>, <-0.0534252, 4.73974, -1.59597> , <-0.917862, -0.311517, 0.245939> }
	smooth_triangle { <-0.0892096, 4.78708, -1.61029>, <-0.525585, -0.850741, 1.35326e-007>, <-0.0618888, 4.76341, -1.59371>, <-0.805097, -0.552523, 0.215724>, <-0.0861699, 4.78708, -1.5872> , <-0.507677, -0.85074, 0.136032> }
	smooth_triangle { <-0.0618888, 4.76341, -1.59371>, <-0.805097, -0.552523, 0.215724>, <-0.0892096, 4.78708, -1.61029>, <-0.525585, -0.850741, 1.35326e-007>, <-0.064072, 4.76341, -1.61029> , <-0.833497, -0.552524, -5.19581e-008> }
	smooth_triangle { <-0.139635, 4.80561, -1.61029>, <-0.453813, -0.891097, -2.33047e-007>, <-0.0861699, 4.78708, -1.5872>, <-0.507677, -0.85074, 0.136032>, <-0.134877, 4.80561, -1.57415> , <-0.438348, -0.891098, 0.117457> }
	smooth_triangle { <-0.0861699, 4.78708, -1.5872>, <-0.507677, -0.85074, 0.136032>, <-0.139635, 4.80561, -1.61029>, <-0.453813, -0.891097, -2.33047e-007>, <-0.0892096, 4.78708, -1.61029> , <-0.525585, -0.850741, 1.35326e-007> }
	smooth_triangle { <-0.188799, 4.83854, -1.61029>, <-0.595128, -0.803631, 1.2532e-007>, <-0.134877, 4.80561, -1.57415>, <-0.438348, -0.891098, 0.117457>, <-0.182367, 4.83854, -1.56143> , <-0.574849, -0.803631, 0.154031> }
	smooth_triangle { <-0.134877, 4.80561, -1.57415>, <-0.438348, -0.891098, 0.117457>, <-0.188799, 4.83854, -1.61029>, <-0.595128, -0.803631, 1.2532e-007>, <-0.139635, 4.80561, -1.61029> , <-0.453813, -0.891097, -2.33047e-007> }
	smooth_triangle { <-0.220315, 4.86427, -1.61029>, <-0.717044, -0.697028, 4.27522e-007>, <-0.182367, 4.83854, -1.56143>, <-0.574849, -0.803631, 0.154031>, <-0.212808, 4.86427, -1.55327> , <-0.692613, -0.697026, 0.185586> }
	smooth_triangle { <-0.182367, 4.83854, -1.56143>, <-0.574849, -0.803631, 0.154031>, <-0.220315, 4.86427, -1.61029>, <-0.717044, -0.697028, 4.27522e-007>, <-0.188799, 4.83854, -1.61029> , <-0.595128, -0.803631, 1.2532e-007> }
	smooth_triangle { <-0.220315, 4.86427, -1.61029>, <-0.717044, -0.697028, 4.27522e-007>, <-0.239597, 4.90029, -1.54609>, <-0.802008, -0.557315, 0.214902>, <-0.248049, 4.90029, -1.61029> , <-0.830302, -0.557314, -9.95172e-008> }
	smooth_triangle { <-0.239597, 4.90029, -1.54609>, <-0.802008, -0.557315, 0.214902>, <-0.220315, 4.86427, -1.61029>, <-0.717044, -0.697028, 4.27522e-007>, <-0.212808, 4.86427, -1.55327> , <-0.692613, -0.697026, 0.185586> }
	smooth_triangle { <-0.248049, 4.90029, -1.61029>, <-0.830302, -0.557314, -9.95172e-008>, <-0.260744, 4.938, -1.54042>, <-0.885769, -0.398849, 0.237346>, <-0.269942, 4.938, -1.61029> , <-0.917019, -0.398843, -8.68801e-008> }
	smooth_triangle { <-0.260744, 4.938, -1.54042>, <-0.885769, -0.398849, 0.237346>, <-0.248049, 4.90029, -1.61029>, <-0.830302, -0.557314, -9.95172e-008>, <-0.239597, 4.90029, -1.54609> , <-0.802008, -0.557315, 0.214902> }
	smooth_triangle { <-0.269942, 4.938, -1.61029>, <-0.917019, -0.398843, -8.68801e-008>, <-0.279232, 5.00115, -1.53547>, <-0.951719, -0.170877, 0.255012>, <-0.289082, 5.00115, -1.61029> , <-0.985293, -0.170873, -1.62731e-007> }
	smooth_triangle { <-0.279232, 5.00115, -1.53547>, <-0.951719, -0.170877, 0.255012>, <-0.269942, 4.938, -1.61029>, <-0.917019, -0.398843, -8.68801e-008>, <-0.260744, 4.938, -1.54042> , <-0.885769, -0.398849, 0.237346> }
	smooth_triangle { <-0.289082, 5.00115, -1.61029>, <-0.985293, -0.170873, -1.62731e-007>, <-0.283432, 5.08966, -1.53434>, <-0.965909, 0.00603948, 0.258811>, <-0.293431, 5.08966, -1.61029> , <-0.999982, 0.00603511, -1.01602e-007> }
	smooth_triangle { <-0.283432, 5.08966, -1.53434>, <-0.965909, 0.00603948, 0.258811>, <-0.289082, 5.00115, -1.61029>, <-0.985293, -0.170873, -1.62731e-007>, <-0.279232, 5.00115, -1.53547> , <-0.951719, -0.170877, 0.255012> }
	smooth_triangle { <-0.293431, 5.08966, -1.61029>, <-0.999982, 0.00603511, -1.01602e-007>, <-0.277344, 5.19258, -1.53598>, <-0.962528, 0.0837984, 0.257911>, <-0.287129, 5.19258, -1.61029> , <-0.996483, 0.083797, -2.63072e-008> }
	smooth_triangle { <-0.277344, 5.19258, -1.53598>, <-0.962528, 0.0837984, 0.257911>, <-0.293431, 5.08966, -1.61029>, <-0.999982, 0.00603511, -1.01602e-007>, <-0.283432, 5.08966, -1.53434> , <-0.965909, 0.00603948, 0.258811> }
	smooth_triangle { <-0.287129, 5.19258, -1.61029>, <-0.996483, 0.083797, -2.63072e-008>, <-0.266385, 5.29859, -1.53891>, <-0.95994, 0.111147, 0.25722>, <-0.275782, 5.29859, -1.61029> , <-0.993804, 0.111143, 3.75709e-009> }
	smooth_triangle { <-0.266385, 5.29859, -1.53891>, <-0.95994, 0.111147, 0.25722>, <-0.287129, 5.19258, -1.61029>, <-0.996483, 0.083797, -2.63072e-008>, <-0.277344, 5.19258, -1.53598> , <-0.962528, 0.0837984, 0.257911> }
	smooth_triangle { <-0.275782, 5.29859, -1.61029>, <-0.993804, 0.111143, 3.75709e-009>, <-0.259079, 5.36342, -1.54087>, <-0.959419, 0.11587, 0.257077>, <-0.26822, 5.36342, -1.61029> , <-0.993266, 0.115858, 2.2542e-008> }
	smooth_triangle { <-0.259079, 5.36342, -1.54087>, <-0.959419, 0.11587, 0.257077>, <-0.275782, 5.29859, -1.61029>, <-0.993804, 0.111143, 3.75709e-009>, <-0.266385, 5.29859, -1.53891> , <-0.95994, 0.111147, 0.25722> }
	smooth_triangle { <-0.284052, 4.21572, -1.53418>, <0.0276742, -0.99959, -0.00741489>, <-0.00158693, 4.22409, -1.60937>, <0.0248129, -0.99959, -0.0143233>, <-0.254674, 4.21572, -1.46325> , <0.0248129, -0.99959, -0.0143233> }
	smooth_triangle { <-0.00158693, 4.22409, -1.60937>, <0.0248129, -0.99959, -0.0143233>, <-0.284052, 4.21572, -1.53418>, <0.0276742, -0.99959, -0.00741489>, <-0.00176999, 4.22409, -1.60982> , <0.0276742, -0.99959, -0.00741489> }
	smooth_triangle { <-0.284052, 4.21572, -1.53418>, <-0.962457, 0.0846605, 0.257895>, <-0.253719, 4.2287, -1.46381>, <-0.862916, 0.0846942, 0.498199>, <-0.282986, 4.2287, -1.53446> , <-0.962457, 0.0846605, 0.257895> }
	smooth_triangle { <-0.253719, 4.2287, -1.46381>, <-0.862916, 0.0846942, 0.498199>, <-0.284052, 4.21572, -1.53418>, <-0.962457, 0.0846605, 0.257895>, <-0.254674, 4.21572, -1.46325> , <-0.862916, 0.0846942, 0.498199> }
	smooth_triangle { <-0.221138, 4.24779, -1.48262>, <-0.305874, 0.935551, 0.176596>, <-0.282986, 4.2287, -1.53446>, <-0.437087, 0.891762, 0.117116>, <-0.253719, 4.2287, -1.46381> , <-0.391882, 0.891761, 0.226254> }
	smooth_triangle { <-0.282986, 4.2287, -1.53446>, <-0.437087, 0.891762, 0.117116>, <-0.221138, 4.24779, -1.48262>, <-0.305874, 0.935551, 0.176596>, <-0.246648, 4.24779, -1.5442> , <-0.341157, 0.935551, 0.091413> }
	smooth_triangle { <-0.157063, 4.26688, -1.51961>, <-0.185525, 0.976784, 0.107113>, <-0.246648, 4.24779, -1.5442>, <-0.341157, 0.935551, 0.091413>, <-0.221138, 4.24779, -1.48262> , <-0.305874, 0.935551, 0.176596> }
	smooth_triangle { <-0.246648, 4.24779, -1.5442>, <-0.341157, 0.935551, 0.091413>, <-0.157063, 4.26688, -1.51961>, <-0.185525, 0.976784, 0.107113>, <-0.175181, 4.26688, -1.56335> , <-0.206926, 0.976784, 0.0554458> }
	smooth_triangle { <-0.11145, 4.27643, -1.54594>, <-0.139858, 0.986874, 0.0807474>, <-0.175181, 4.26688, -1.56335>, <-0.206926, 0.976784, 0.0554458>, <-0.157063, 4.26688, -1.51961> , <-0.185525, 0.976784, 0.107113> }
	smooth_triangle { <-0.175181, 4.26688, -1.56335>, <-0.206926, 0.976784, 0.0554458>, <-0.11145, 4.27643, -1.54594>, <-0.139858, 0.986874, 0.0807474>, <-0.124306, 4.27643, -1.57698> , <-0.155992, 0.986874, 0.0417968> }
	smooth_triangle { <-0.0611789, 4.28491, -1.57497>, <-0.125242, 0.989488, 0.0723079>, <-0.124306, 4.27643, -1.57698>, <-0.155992, 0.986874, 0.0417968>, <-0.11145, 4.27643, -1.54594> , <-0.139858, 0.986874, 0.0807474> }
	smooth_triangle { <-0.124306, 4.27643, -1.57698>, <-0.155992, 0.986874, 0.0417968>, <-0.0611789, 4.28491, -1.57497>, <-0.125242, 0.989488, 0.0723079>, <-0.0682361, 4.28491, -1.59201> , <-0.139689, 0.989488, 0.0374289> }
	smooth_triangle { <-0.0682361, 4.28491, -1.59201>, <-0.782848, 0.58579, 0.209763>, <-0.0545396, 4.29552, -1.5788>, <-0.823845, 0.308295, 0.475641>, <-0.0608309, 4.29552, -1.59399> , <-0.918877, 0.308296, 0.24621> }
	smooth_triangle { <-0.0545396, 4.29552, -1.5788>, <-0.823845, 0.308295, 0.475641>, <-0.0682361, 4.28491, -1.59201>, <-0.782848, 0.58579, 0.209763>, <-0.0611789, 4.28491, -1.57497> , <-0.701885, 0.585788, 0.405229> }
	smooth_triangle { <-0.0608309, 4.29552, -1.59399>, <-0.918877, 0.308296, 0.24621>, <-0.0545396, 4.30188, -1.5788>, <-0.866029, 0, 0.499994>, <-0.0608309, 4.30188, -1.59399> , <-0.965927, 0, 0.258816> }
	smooth_triangle { <-0.0545396, 4.30188, -1.5788>, <-0.866029, 0, 0.499994>, <-0.0608309, 4.29552, -1.59399>, <-0.918877, 0.308296, 0.24621>, <-0.0545396, 4.29552, -1.5788> , <-0.823845, 0.308295, 0.475641> }
	smooth_triangle { <-0.0608309, 4.30188, -1.59399>, <-0.965927, 0, 0.258816>, <-0.0545396, 4.30931, -1.5788>, <-0.819283, 0.324099, 0.473006>, <-0.0608309, 4.30931, -1.59399> , <-0.913791, 0.324093, 0.244846> }
	smooth_triangle { <-0.0545396, 4.30931, -1.5788>, <-0.819283, 0.324099, 0.473006>, <-0.0608309, 4.30188, -1.59399>, <-0.965927, 0, 0.258816>, <-0.0545396, 4.30188, -1.5788> , <-0.866029, 0, 0.499994> }
	smooth_triangle { <-0.0608309, 4.30931, -1.59399>, <-0.913791, 0.324093, 0.244846>, <-0.0488483, 4.31779, -1.58209>, <-0.529961, 0.7909, 0.305971>, <-0.0544832, 4.31779, -1.59569> , <-0.591098, 0.790897, 0.158382> }
	smooth_triangle { <-0.0488483, 4.31779, -1.58209>, <-0.529961, 0.7909, 0.305971>, <-0.0608309, 4.30931, -1.59399>, <-0.913791, 0.324093, 0.244846>, <-0.0545396, 4.30931, -1.5788> , <-0.819283, 0.324099, 0.473006> }
	smooth_triangle { <-0.0403117, 4.32203, -1.58702>, <-0.548901, 0.773483, 0.31691>, <-0.0544832, 4.31779, -1.59569>, <-0.591098, 0.790897, 0.158382>, <-0.0488483, 4.31779, -1.58209> , <-0.529961, 0.7909, 0.305971> }
	smooth_triangle { <-0.0544832, 4.31779, -1.59569>, <-0.591098, 0.790897, 0.158382>, <-0.0403117, 4.32203, -1.58702>, <-0.548901, 0.773483, 0.31691>, <-0.0449618, 4.32203, -1.59824> , <-0.612221, 0.773482, 0.164043> }
	smooth_triangle { <-0.0449618, 4.32203, -1.59824>, <-0.612221, 0.773482, 0.164043>, <-0.0365175, 4.3284, -1.58921>, <-0.792712, 0.402667, 0.457677>, <-0.0407301, 4.3284, -1.59938> , <-0.884158, 0.402664, 0.23691> }
	smooth_triangle { <-0.0365175, 4.3284, -1.58921>, <-0.792712, 0.402667, 0.457677>, <-0.0449618, 4.32203, -1.59824>, <-0.612221, 0.773482, 0.164043>, <-0.0403117, 4.32203, -1.58702> , <-0.548901, 0.773483, 0.31691> }
	smooth_triangle { <-0.0407301, 4.3284, -1.59938>, <-0.884158, 0.402664, 0.23691>, <-0.0346206, 4.33794, -1.5903>, <-0.861233, 0.105024, 0.49724>, <-0.0386144, 4.33794, -1.59994> , <-0.960584, 0.105022, 0.257389> }
	smooth_triangle { <-0.0346206, 4.33794, -1.5903>, <-0.861233, 0.105024, 0.49724>, <-0.0407301, 4.3284, -1.59938>, <-0.884158, 0.402664, 0.23691>, <-0.0365175, 4.3284, -1.58921> , <-0.792712, 0.402667, 0.457677> }
	smooth_triangle { <-0.0386144, 4.33794, -1.59994>, <-0.960584, 0.105022, 0.257389>, <-0.0393632, 4.69858, -1.58756>, <-0.863039, -0.082938, 0.498282>, <-0.043904, 4.69858, -1.59853> , <-0.962597, -0.0829362, 0.257929> }
	smooth_triangle { <-0.0393632, 4.69858, -1.58756>, <-0.863039, -0.082938, 0.498282>, <-0.0386144, 4.33794, -1.59994>, <-0.960584, 0.105022, 0.257389>, <-0.0346206, 4.33794, -1.5903> , <-0.861233, 0.105024, 0.49724> }
	smooth_triangle { <-0.043904, 4.69858, -1.59853>, <-0.962597, -0.0829362, 0.257929>, <-0.0412602, 4.71298, -1.58647>, <-0.846093, -0.213318, 0.48849>, <-0.0460197, 4.71298, -1.59796> , <-0.943693, -0.213317, 0.252863> }
	smooth_triangle { <-0.0412602, 4.71298, -1.58647>, <-0.846093, -0.213318, 0.48849>, <-0.043904, 4.69858, -1.59853>, <-0.962597, -0.0829362, 0.257929>, <-0.0393632, 4.69858, -1.58756> , <-0.863039, -0.082938, 0.498282> }
	smooth_triangle { <-0.0460197, 4.71298, -1.59796>, <-0.943693, -0.213317, 0.252863>, <-0.0478998, 4.73974, -1.58263>, <-0.822934, -0.311517, 0.475118>, <-0.0534252, 4.73974, -1.59597> , <-0.917862, -0.311517, 0.245939> }
	smooth_triangle { <-0.0478998, 4.73974, -1.58263>, <-0.822934, -0.311517, 0.475118>, <-0.0460197, 4.71298, -1.59796>, <-0.943693, -0.213317, 0.252863>, <-0.0412602, 4.71298, -1.58647> , <-0.846093, -0.213318, 0.48849> }
	smooth_triangle { <-0.0534252, 4.73974, -1.59597>, <-0.917862, -0.311516, 0.245939>, <-0.055488, 4.76341, -1.57825>, <-0.721829, -0.552524, 0.416749>, <-0.0618888, 4.76341, -1.59371> , <-0.805097, -0.552523, 0.215724> }
	smooth_triangle { <-0.055488, 4.76341, -1.57825>, <-0.721829, -0.552524, 0.416749>, <-0.0534252, 4.73974, -1.59597>, <-0.917862, -0.311516, 0.245939>, <-0.0478998, 4.73974, -1.58263> , <-0.822934, -0.311517, 0.475118> }
	smooth_triangle { <-0.0861699, 4.78708, -1.5872>, <-0.507677, -0.85074, 0.136032>, <-0.055488, 4.76341, -1.57825>, <-0.721829, -0.552524, 0.416749>, <-0.0772578, 4.78708, -1.56569> , <-0.455172, -0.85074, 0.262793> }
	smooth_triangle { <-0.055488, 4.76341, -1.57825>, <-0.721829, -0.552524, 0.416749>, <-0.0861699, 4.78708, -1.5872>, <-0.507677, -0.85074, 0.136032>, <-0.0618888, 4.76341, -1.59371> , <-0.805097, -0.552523, 0.215724> }
	smooth_triangle { <-0.134877, 4.80561, -1.57415>, <-0.438348, -0.891098, 0.117457>, <-0.0772578, 4.78708, -1.56569>, <-0.455172, -0.85074, 0.262793>, <-0.120927, 4.80561, -1.54047> , <-0.393015, -0.891096, 0.226908> }
	smooth_triangle { <-0.0772578, 4.78708, -1.56569>, <-0.455172, -0.85074, 0.262793>, <-0.134877, 4.80561, -1.57415>, <-0.438348, -0.891098, 0.117457>, <-0.0861699, 4.78708, -1.5872> , <-0.507677, -0.85074, 0.136032> }
	smooth_triangle { <-0.182367, 4.83854, -1.56143>, <-0.574849, -0.803631, 0.154031>, <-0.120927, 4.80561, -1.54047>, <-0.393015, -0.891096, 0.226908>, <-0.163505, 4.83854, -1.51589> , <-0.515394, -0.803631, 0.297567> }
	smooth_triangle { <-0.120927, 4.80561, -1.54047>, <-0.393015, -0.891096, 0.226908>, <-0.182367, 4.83854, -1.56143>, <-0.574849, -0.803631, 0.154031>, <-0.134877, 4.80561, -1.57415> , <-0.438348, -0.891098, 0.117457> }
	smooth_triangle { <-0.212808, 4.86427, -1.55327>, <-0.692613, -0.697026, 0.185586>, <-0.163505, 4.83854, -1.51589>, <-0.515394, -0.803631, 0.297567>, <-0.190798, 4.86427, -1.50013> , <-0.620973, -0.697032, 0.358523> }
	smooth_triangle { <-0.163505, 4.83854, -1.51589>, <-0.515394, -0.803631, 0.297567>, <-0.212808, 4.86427, -1.55327>, <-0.692613, -0.697026, 0.185586>, <-0.182367, 4.83854, -1.56143> , <-0.574849, -0.803631, 0.154031> }
	smooth_triangle { <-0.212808, 4.86427, -1.55327>, <-0.692613, -0.697026, 0.185586>, <-0.214816, 4.90029, -1.48627>, <-0.719067, -0.557309, 0.41515>, <-0.239597, 4.90029, -1.54609> , <-0.802008, -0.557315, 0.214902> }
	smooth_triangle { <-0.214816, 4.90029, -1.48627>, <-0.719067, -0.557309, 0.41515>, <-0.212808, 4.86427, -1.55327>, <-0.692613, -0.697026, 0.185586>, <-0.190798, 4.86427, -1.50013> , <-0.620973, -0.697032, 0.358523> }
	smooth_triangle { <-0.239597, 4.90029, -1.54609>, <-0.802008, -0.557315, 0.214902>, <-0.233776, 4.938, -1.47532>, <-0.794163, -0.398839, 0.458512>, <-0.260744, 4.938, -1.54042> , <-0.885769, -0.398849, 0.237346> }
	smooth_triangle { <-0.233776, 4.938, -1.47532>, <-0.794163, -0.398839, 0.458512>, <-0.239597, 4.90029, -1.54609>, <-0.802008, -0.557315, 0.214902>, <-0.214816, 4.90029, -1.48627> , <-0.719067, -0.557309, 0.41515> }
	smooth_triangle { <-0.260744, 4.938, -1.54042>, <-0.885769, -0.398849, 0.237346>, <-0.250353, 5.00115, -1.46575>, <-0.853283, -0.170886, 0.492651>, <-0.279232, 5.00115, -1.53547> , <-0.951719, -0.170877, 0.255012> }
	smooth_triangle { <-0.250353, 5.00115, -1.46575>, <-0.853283, -0.170886, 0.492651>, <-0.260744, 4.938, -1.54042>, <-0.885769, -0.398849, 0.237346>, <-0.233776, 4.938, -1.47532> , <-0.794163, -0.398839, 0.458512> }
	smooth_triangle { <-0.279232, 5.00115, -1.53547>, <-0.951719, -0.170877, 0.255012>, <-0.254119, 5.08966, -1.46357>, <-0.866011, 0.00603599, 0.499988>, <-0.283432, 5.08966, -1.53434> , <-0.965909, 0.00603948, 0.258811> }
	smooth_triangle { <-0.254119, 5.08966, -1.46357>, <-0.866011, 0.00603599, 0.499988>, <-0.279232, 5.00115, -1.53547>, <-0.951719, -0.170877, 0.255012>, <-0.250353, 5.00115, -1.46575> , <-0.853283, -0.170886, 0.492651> }
	smooth_triangle { <-0.283432, 5.08966, -1.53434>, <-0.965909, 0.00603948, 0.258811>, <-0.24866, 5.19258, -1.46673>, <-0.862982, 0.083801, 0.498236>, <-0.277344, 5.19258, -1.53598> , <-0.962528, 0.0837984, 0.257911> }
	smooth_triangle { <-0.24866, 5.19258, -1.46673>, <-0.862982, 0.083801, 0.498236>, <-0.283432, 5.08966, -1.53434>, <-0.965909, 0.00603948, 0.258811>, <-0.254119, 5.08966, -1.46357> , <-0.866011, 0.00603599, 0.499988> }
	smooth_triangle { <-0.277344, 5.19258, -1.53598>, <-0.962528, 0.0837984, 0.257911>, <-0.238834, 5.29859, -1.4724>, <-0.860661, 0.111146, 0.496899>, <-0.266385, 5.29859, -1.53891> , <-0.95994, 0.111147, 0.25722> }
	smooth_triangle { <-0.238834, 5.29859, -1.4724>, <-0.860661, 0.111146, 0.496899>, <-0.277344, 5.19258, -1.53598>, <-0.962528, 0.0837984, 0.257911>, <-0.24866, 5.19258, -1.46673> , <-0.862982, 0.083801, 0.498236> }
	smooth_triangle { <-0.266385, 5.29859, -1.53891>, <-0.95994, 0.111147, 0.25722>, <-0.232284, 5.36342, -1.47618>, <-0.860195, 0.115872, 0.496627>, <-0.259079, 5.36342, -1.54087> , <-0.959419, 0.11587, 0.257077> }
	smooth_triangle { <-0.232284, 5.36342, -1.47618>, <-0.860195, 0.115872, 0.496627>, <-0.266385, 5.29859, -1.53891>, <-0.95994, 0.111147, 0.25722>, <-0.238834, 5.29859, -1.4724> , <-0.860661, 0.111146, 0.496899> }
	smooth_triangle { <-0.259079, 5.36342, -1.54087>, <-0.957711, 0.130115, 0.25663>, <-0.222458, 5.44988, -1.48185>, <-0.857045, 0.143621, 0.49482>, <-0.248121, 5.44988, -1.54381> , <-0.95591, 0.14362, 0.256142> }
	smooth_triangle { <-0.222458, 5.44988, -1.48185>, <-0.857045, 0.143621, 0.49482>, <-0.259079, 5.36342, -1.54087>, <-0.957711, 0.130115, 0.25663>, <-0.232284, 5.36342, -1.47618> , <-0.858664, 0.130127, 0.495745> }
	smooth_triangle { <-0.248121, 5.44988, -1.54381>, <-0.95591, 0.14362, 0.256142>, <-0.211542, 5.52912, -1.48816>, <-0.853244, 0.171154, 0.492627>, <-0.235944, 5.52912, -1.54707> , <-0.951674, 0.171154, 0.254996> }
	smooth_triangle { <-0.211542, 5.52912, -1.48816>, <-0.853244, 0.171154, 0.492627>, <-0.248121, 5.44988, -1.54381>, <-0.95591, 0.14362, 0.256142>, <-0.222458, 5.44988, -1.48185> , <-0.857045, 0.143621, 0.49482> }
	smooth_triangle { <-0.235944, 5.52912, -1.54707>, <-0.951674, 0.171154, 0.254996>, <-0.204992, 5.56926, -1.49194>, <-0.851047, 0.185185, 0.49135>, <-0.228638, 5.56926, -1.54903> , <-0.949223, 0.185174, 0.254333> }
	smooth_triangle { <-0.204992, 5.56926, -1.49194>, <-0.851047, 0.185185, 0.49135>, <-0.235944, 5.52912, -1.54707>, <-0.951674, 0.171154, 0.254996>, <-0.211542, 5.52912, -1.48816> , <-0.853244, 0.171154, 0.492627> }
	smooth_triangle { <-0.199532, 5.56926, -1.49509>, <0.166738, 0.981291, -0.0962657>, <-0.228638, 5.56926, -1.54903>, <0, 1, 0>, <-0.204992, 5.56926, -1.49194> , <0, 1, 0> }
	smooth_triangle { <-0.228638, 5.56926, -1.54903>, <0, 1, 0>, <-0.199532, 5.56926, -1.49509>, <0.166738, 0.981291, -0.0962657>, <-0.22255, 5.56926, -1.55066> , <0.185934, 0.981298, -0.0498262> }
	smooth_triangle { <-0.195166, 5.5672, -1.49761>, <0.327432, 0.925771, -0.189042>, <-0.22255, 5.56926, -1.55066>, <0.185934, 0.981298, -0.0498262>, <-0.199532, 5.56926, -1.49509> , <0.166738, 0.981291, -0.0962657> }
	smooth_triangle { <-0.22255, 5.56926, -1.55066>, <0.185934, 0.981298, -0.0498262>, <-0.195166, 5.5672, -1.49761>, <0.327432, 0.925771, -0.189042>, <-0.217678, 5.5672, -1.55196> , <0.365131, 0.9258, -0.0978468> }
	smooth_triangle { <-0.194073, 5.55794, -1.49824>, <0.858109, 0.134984, -0.495408>, <-0.217678, 5.5672, -1.55196>, <0.95709, 0.134954, -0.256449>, <-0.195166, 5.5672, -1.49761> , <0.858109, 0.134984, -0.495408> }
	smooth_triangle { <-0.217678, 5.5672, -1.55196>, <0.95709, 0.134954, -0.256449>, <-0.194073, 5.55794, -1.49824>, <0.858109, 0.134984, -0.495408>, <-0.21646, 5.55794, -1.55229> , <0.95709, 0.134954, -0.256449> }
	smooth_triangle { <-0.0861699, 4.78708, -1.5872>, <-0.137918, -0.989754, 0.0369677>, <-0.00123028, 4.77442, -1.60958>, <-0.12365, -0.989753, 0.0714128>, <-0.0772578, 4.78708, -1.56569> , <-0.12365, -0.989753, 0.0714128> }
	smooth_triangle { <-0.00123028, 4.77442, -1.60958>, <-0.12365, -0.989753, 0.0714128>, <-0.0861699, 4.78708, -1.5872>, <-0.137918, -0.989754, 0.0369677>, <-0.0013722, 4.77442, -1.60992> , <-0.137918, -0.989754, 0.0369677> }
	smooth_triangle { <-0.254674, 4.21572, -1.46325>, <0.0248129, -0.99959, -0.0143233>, <-0.00129573, 4.22409, -1.60899>, <0.0202573, -0.99959, -0.020259>, <-0.207941, 4.21572, -1.40235> , <0.0202573, -0.99959, -0.020259> }
	smooth_triangle { <-0.00129573, 4.22409, -1.60899>, <0.0202573, -0.99959, -0.020259>, <-0.254674, 4.21572, -1.46325>, <0.0248129, -0.99959, -0.0143233>, <-0.00158693, 4.22409, -1.60937> , <0.0248129, -0.99959, -0.0143233> }
	smooth_triangle { <-0.254674, 4.21572, -1.46325>, <-0.862916, 0.0846942, 0.498199>, <-0.20716, 4.2287, -1.40313>, <-0.704565, 0.0847009, 0.704566>, <-0.253719, 4.2287, -1.46381> , <-0.862916, 0.0846942, 0.498199> }
	smooth_triangle { <-0.20716, 4.2287, -1.40313>, <-0.704565, 0.0847009, 0.704566>, <-0.254674, 4.21572, -1.46325>, <-0.862916, 0.0846942, 0.498199>, <-0.207941, 4.21572, -1.40235> , <-0.704565, 0.0847009, 0.704566> }
	smooth_triangle { <-0.180559, 4.24779, -1.42973>, <-0.249745, 0.935551, 0.249745>, <-0.253719, 4.2287, -1.46381>, <-0.391882, 0.891761, 0.226254>, <-0.20716, 4.2287, -1.40313> , <-0.319972, 0.89176, 0.319971> }
	smooth_triangle { <-0.253719, 4.2287, -1.46381>, <-0.391882, 0.891761, 0.226254>, <-0.180559, 4.24779, -1.42973>, <-0.249745, 0.935551, 0.249745>, <-0.221138, 4.24779, -1.48262> , <-0.305874, 0.935551, 0.176596> }
	smooth_triangle { <-0.128241, 4.26688, -1.48205>, <-0.15148, 0.976784, 0.15148>, <-0.221138, 4.24779, -1.48262>, <-0.305874, 0.935551, 0.176596>, <-0.180559, 4.24779, -1.42973> , <-0.249745, 0.935551, 0.249745> }
	smooth_triangle { <-0.221138, 4.24779, -1.48262>, <-0.305874, 0.935551, 0.176596>, <-0.128241, 4.26688, -1.48205>, <-0.15148, 0.976784, 0.15148>, <-0.157063, 4.26688, -1.51961> , <-0.185525, 0.976784, 0.107113> }
	smooth_triangle { <-0.0909985, 4.27643, -1.51929>, <-0.114194, 0.986874, 0.114194>, <-0.157063, 4.26688, -1.51961>, <-0.185525, 0.976784, 0.107113>, <-0.128241, 4.26688, -1.48205> , <-0.15148, 0.976784, 0.15148> }
	smooth_triangle { <-0.157063, 4.26688, -1.51961>, <-0.185525, 0.976784, 0.107113>, <-0.0909985, 4.27643, -1.51929>, <-0.114194, 0.986874, 0.114194>, <-0.11145, 4.27643, -1.54594> , <-0.139858, 0.986874, 0.0807474> }
	smooth_triangle { <-0.0499523, 4.28491, -1.56034>, <-0.102259, 0.989488, 0.102259>, <-0.11145, 4.27643, -1.54594>, <-0.139858, 0.986874, 0.0807474>, <-0.0909985, 4.27643, -1.51929> , <-0.114194, 0.986874, 0.114194> }
	smooth_triangle { <-0.11145, 4.27643, -1.54594>, <-0.139858, 0.986874, 0.0807474>, <-0.0499523, 4.28491, -1.56034>, <-0.102259, 0.989488, 0.102259>, <-0.0611789, 4.28491, -1.57497> , <-0.125242, 0.989488, 0.0723079> }
	smooth_triangle { <-0.0611789, 4.28491, -1.57497>, <-0.701885, 0.585788, 0.405229>, <-0.0445314, 4.29552, -1.56576>, <-0.67266, 0.308296, 0.672668>, <-0.0545396, 4.29552, -1.5788> , <-0.823845, 0.308295, 0.475641> }
	smooth_triangle { <-0.0445314, 4.29552, -1.56576>, <-0.67266, 0.308296, 0.672668>, <-0.0611789, 4.28491, -1.57497>, <-0.701885, 0.585788, 0.405229>, <-0.0499523, 4.28491, -1.56034> , <-0.573082, 0.585789, 0.573087> }
	smooth_triangle { <-0.0545396, 4.29552, -1.5788>, <-0.823845, 0.308295, 0.475641>, <-0.0445314, 4.30188, -1.56576>, <-0.707102, 0, 0.707111>, <-0.0545396, 4.30188, -1.5788> , <-0.866029, 0, 0.499994> }
	smooth_triangle { <-0.0445314, 4.30188, -1.56576>, <-0.707102, 0, 0.707111>, <-0.0545396, 4.29552, -1.5788>, <-0.823845, 0.308295, 0.475641>, <-0.0445314, 4.29552, -1.56576> , <-0.67266, 0.308296, 0.672668> }
	smooth_triangle { <-0.0545396, 4.30188, -1.5788>, <-0.866029, 0, 0.499994>, <-0.0445314, 4.30931, -1.56576>, <-0.668935, 0.324097, 0.668944>, <-0.0545396, 4.30931, -1.5788> , <-0.819283, 0.324099, 0.473006> }
	smooth_triangle { <-0.0445314, 4.30931, -1.56576>, <-0.668935, 0.324097, 0.668944>, <-0.0545396, 4.30188, -1.5788>, <-0.866029, 0, 0.499994>, <-0.0445314, 4.30188, -1.56576> , <-0.707102, 0, 0.707111> }
	smooth_triangle { <-0.0545396, 4.30931, -1.5788>, <-0.819283, 0.324099, 0.473006>, <-0.0398843, 4.31779, -1.57041>, <-0.43271, 0.790898, 0.432715>, <-0.0488483, 4.31779, -1.58209> , <-0.529961, 0.7909, 0.305971> }
	smooth_triangle { <-0.0398843, 4.31779, -1.57041>, <-0.43271, 0.790898, 0.432715>, <-0.0545396, 4.30931, -1.5788>, <-0.819283, 0.324099, 0.473006>, <-0.0445314, 4.30931, -1.56576> , <-0.668935, 0.324097, 0.668944> }
	smooth_triangle { <-0.0329144, 4.32203, -1.57738>, <-0.448178, 0.773481, 0.448177>, <-0.0488483, 4.31779, -1.58209>, <-0.529961, 0.7909, 0.305971>, <-0.0398843, 4.31779, -1.57041> , <-0.43271, 0.790898, 0.432715> }
	smooth_triangle { <-0.0488483, 4.31779, -1.58209>, <-0.529961, 0.7909, 0.305971>, <-0.0329144, 4.32203, -1.57738>, <-0.448178, 0.773481, 0.448177>, <-0.0403117, 4.32203, -1.58702> , <-0.548901, 0.773483, 0.31691> }
	smooth_triangle { <-0.0403117, 4.32203, -1.58702>, <-0.548901, 0.773483, 0.31691>, <-0.0298165, 4.3284, -1.58047>, <-0.647248, 0.402669, 0.647246>, <-0.0365175, 4.3284, -1.58921> , <-0.792712, 0.402667, 0.457677> }
	smooth_triangle { <-0.0298165, 4.3284, -1.58047>, <-0.647248, 0.402669, 0.647246>, <-0.0403117, 4.32203, -1.58702>, <-0.548901, 0.773483, 0.31691>, <-0.0329144, 4.32203, -1.57738> , <-0.448178, 0.773481, 0.448177> }
	smooth_triangle { <-0.0365175, 4.3284, -1.58921>, <-0.792712, 0.402667, 0.457677>, <-0.0282676, 4.33794, -1.58202>, <-0.703194, 0.105027, 0.703198>, <-0.0346206, 4.33794, -1.5903> , <-0.861233, 0.105024, 0.49724> }
	smooth_triangle { <-0.0282676, 4.33794, -1.58202>, <-0.703194, 0.105027, 0.703198>, <-0.0365175, 4.3284, -1.58921>, <-0.792712, 0.402667, 0.457677>, <-0.0298165, 4.3284, -1.58047> , <-0.647248, 0.402669, 0.647246> }
	smooth_triangle { <-0.0346206, 4.33794, -1.5903>, <-0.861233, 0.105024, 0.49724>, <-0.0321399, 4.69858, -1.57815>, <-0.704669, -0.0829403, 0.704672>, <-0.0393632, 4.69858, -1.58756> , <-0.863039, -0.082938, 0.498282> }
	smooth_triangle { <-0.0321399, 4.69858, -1.57815>, <-0.704669, -0.0829403, 0.704672>, <-0.0346206, 4.33794, -1.5903>, <-0.861233, 0.105024, 0.49724>, <-0.0282676, 4.33794, -1.58202> , <-0.703194, 0.105027, 0.703198> }
	smooth_triangle { <-0.0393632, 4.69858, -1.58756>, <-0.863039, -0.082938, 0.498282>, <-0.0336888, 4.71298, -1.5766>, <-0.690835, -0.213318, 0.690828>, <-0.0412602, 4.71298, -1.58647> , <-0.846093, -0.213318, 0.48849> }
	smooth_triangle { <-0.0336888, 4.71298, -1.5766>, <-0.690835, -0.213318, 0.690828>, <-0.0393632, 4.69858, -1.58756>, <-0.863039, -0.082938, 0.498282>, <-0.0321399, 4.69858, -1.57815> , <-0.704669, -0.0829403, 0.704672> }
	smooth_triangle { <-0.0412602, 4.71298, -1.58647>, <-0.846093, -0.213318, 0.48849>, <-0.0391099, 4.73974, -1.57118>, <-0.671923, -0.311515, 0.671921>, <-0.0478998, 4.73974, -1.58263> , <-0.822934, -0.311517, 0.475119> }
	smooth_triangle { <-0.0391099, 4.73974, -1.57118>, <-0.671923, -0.311515, 0.671921>, <-0.0412602, 4.71298, -1.58647>, <-0.846093, -0.213318, 0.48849>, <-0.0336888, 4.71298, -1.5766> , <-0.690835, -0.213318, 0.690828> }
	smooth_triangle { <-0.0478998, 4.73974, -1.58263>, <-0.822933, -0.311517, 0.475118>, <-0.0453058, 4.76341, -1.56498>, <-0.589369, -0.552525, 0.589373>, <-0.055488, 4.76341, -1.57825> , <-0.721829, -0.552524, 0.416749> }
	smooth_triangle { <-0.0453058, 4.76341, -1.56498>, <-0.589369, -0.552525, 0.589373>, <-0.0478998, 4.73974, -1.58263>, <-0.822933, -0.311517, 0.475118>, <-0.0391099, 4.73974, -1.57118> , <-0.671923, -0.311515, 0.671921> }
	smooth_triangle { <-0.0772578, 4.78708, -1.56569>, <-0.455172, -0.85074, 0.262793>, <-0.0453058, 4.76341, -1.56498>, <-0.589369, -0.552525, 0.589373>, <-0.0630807, 4.78708, -1.54721> , <-0.371645, -0.85074, 0.371646> }
	smooth_triangle { <-0.0453058, 4.76341, -1.56498>, <-0.589369, -0.552525, 0.589373>, <-0.0772578, 4.78708, -1.56569>, <-0.455172, -0.85074, 0.262793>, <-0.055488, 4.76341, -1.57825> , <-0.721829, -0.552524, 0.416749> }
	smooth_triangle { <-0.120927, 4.80561, -1.54047>, <-0.393015, -0.891096, 0.226908>, <-0.0630807, 4.78708, -1.54721>, <-0.371645, -0.85074, 0.371646>, <-0.0987367, 4.80561, -1.51155> , <-0.320895, -0.891096, 0.320895> }
	smooth_triangle { <-0.0630807, 4.78708, -1.54721>, <-0.371645, -0.85074, 0.371646>, <-0.120927, 4.80561, -1.54047>, <-0.393015, -0.891096, 0.226908>, <-0.0772578, 4.78708, -1.56569> , <-0.455172, -0.85074, 0.262793> }
	smooth_triangle { <-0.163505, 4.83854, -1.51589>, <-0.515394, -0.803631, 0.297567>, <-0.0987367, 4.80561, -1.51155>, <-0.320895, -0.891096, 0.320895>, <-0.133501, 4.83854, -1.47679> , <-0.420817, -0.803633, 0.420818> }
	smooth_triangle { <-0.0987367, 4.80561, -1.51155>, <-0.320895, -0.891096, 0.320895>, <-0.163505, 4.83854, -1.51589>, <-0.515394, -0.803631, 0.297567>, <-0.120927, 4.80561, -1.54047> , <-0.393015, -0.891096, 0.226908> }
	smooth_triangle { <-0.190798, 4.86427, -1.50013>, <-0.620973, -0.697032, 0.358523>, <-0.133501, 4.83854, -1.47679>, <-0.420817, -0.803633, 0.420818>, <-0.155786, 4.86427, -1.4545> , <-0.507025, -0.697032, 0.507023> }
	smooth_triangle { <-0.133501, 4.83854, -1.47679>, <-0.420817, -0.803633, 0.420818>, <-0.190798, 4.86427, -1.50013>, <-0.620973, -0.697032, 0.358523>, <-0.163505, 4.83854, -1.51589> , <-0.515394, -0.803631, 0.297567> }
	smooth_triangle { <-0.190798, 4.86427, -1.50013>, <-0.620973, -0.697032, 0.358523>, <-0.175398, 4.90029, -1.43489>, <-0.587115, -0.557312, 0.587111>, <-0.214816, 4.90029, -1.48627> , <-0.719067, -0.557309, 0.41515> }
	smooth_triangle { <-0.175398, 4.90029, -1.43489>, <-0.587115, -0.557312, 0.587111>, <-0.190798, 4.86427, -1.50013>, <-0.620973, -0.697032, 0.358523>, <-0.155786, 4.86427, -1.4545> , <-0.507025, -0.697032, 0.507023> }
	smooth_triangle { <-0.214816, 4.90029, -1.48627>, <-0.719067, -0.557309, 0.41515>, <-0.190877, 4.938, -1.41941>, <-0.648434, -0.39884, 0.648429>, <-0.233776, 4.938, -1.47532> , <-0.794163, -0.398839, 0.458512> }
	smooth_triangle { <-0.190877, 4.938, -1.41941>, <-0.648434, -0.39884, 0.648429>, <-0.214816, 4.90029, -1.48627>, <-0.719067, -0.557309, 0.41515>, <-0.175398, 4.90029, -1.43489> , <-0.587115, -0.557312, 0.587111> }
	smooth_triangle { <-0.233776, 4.938, -1.47532>, <-0.794163, -0.398838, 0.458512>, <-0.204411, 5.00115, -1.40588>, <-0.696708, -0.170882, 0.696705>, <-0.250353, 5.00115, -1.46575> , <-0.853283, -0.170886, 0.492651> }
	smooth_triangle { <-0.204411, 5.00115, -1.40588>, <-0.696708, -0.170882, 0.696705>, <-0.233776, 4.938, -1.47532>, <-0.794163, -0.398838, 0.458512>, <-0.190877, 4.938, -1.41941> , <-0.648434, -0.39884, 0.648429> }
	smooth_triangle { <-0.250353, 5.00115, -1.46575>, <-0.853283, -0.170886, 0.492651>, <-0.207488, 5.08966, -1.4028>, <-0.707093, 0.00603566, 0.707094>, <-0.254119, 5.08966, -1.46357> , <-0.866011, 0.00603599, 0.499988> }
	smooth_triangle { <-0.207488, 5.08966, -1.4028>, <-0.707093, 0.00603566, 0.707094>, <-0.250353, 5.00115, -1.46575>, <-0.853283, -0.170886, 0.492651>, <-0.204411, 5.00115, -1.40588> , <-0.696708, -0.170882, 0.696705> }
	smooth_triangle { <-0.254119, 5.08966, -1.46357>, <-0.866011, 0.00603599, 0.499988>, <-0.20303, 5.19258, -1.40726>, <-0.70462, 0.0838012, 0.70462>, <-0.24866, 5.19258, -1.46673> , <-0.862982, 0.083801, 0.498236> }
	smooth_triangle { <-0.20303, 5.19258, -1.40726>, <-0.70462, 0.0838012, 0.70462>, <-0.254119, 5.08966, -1.46357>, <-0.866011, 0.00603599, 0.499988>, <-0.207488, 5.08966, -1.4028> , <-0.707093, 0.00603566, 0.707094> }
	smooth_triangle { <-0.24866, 5.19258, -1.46673>, <-0.862982, 0.083801, 0.498236>, <-0.195008, 5.29859, -1.41528>, <-0.702725, 0.111147, 0.702726>, <-0.238834, 5.29859, -1.4724> , <-0.860661, 0.111146, 0.496899> }
	smooth_triangle { <-0.195008, 5.29859, -1.41528>, <-0.702725, 0.111147, 0.702726>, <-0.24866, 5.19258, -1.46673>, <-0.862982, 0.083801, 0.498236>, <-0.20303, 5.19258, -1.40726> , <-0.70462, 0.0838012, 0.70462> }
	smooth_triangle { <-0.238834, 5.29859, -1.4724>, <-0.860661, 0.111146, 0.496899>, <-0.189659, 5.36342, -1.42063>, <-0.702344, 0.115873, 0.702344>, <-0.232284, 5.36342, -1.47618> , <-0.860195, 0.115872, 0.496627> }
	smooth_triangle { <-0.189659, 5.36342, -1.42063>, <-0.702344, 0.115873, 0.702344>, <-0.238834, 5.29859, -1.4724>, <-0.860661, 0.111146, 0.496899>, <-0.195008, 5.29859, -1.41528> , <-0.702725, 0.111147, 0.702726> }
	smooth_triangle { <-0.232284, 5.36342, -1.47618>, <-0.858664, 0.130127, 0.495745>, <-0.181636, 5.44988, -1.42865>, <-0.699774, 0.143621, 0.699778>, <-0.222458, 5.44988, -1.48185> , <-0.857045, 0.143621, 0.49482> }
	smooth_triangle { <-0.181636, 5.44988, -1.42865>, <-0.699774, 0.143621, 0.699778>, <-0.232284, 5.36342, -1.47618>, <-0.858664, 0.130127, 0.495745>, <-0.189659, 5.36342, -1.42063> , <-0.701093, 0.13013, 0.701095> }
	smooth_triangle { <-0.222458, 5.44988, -1.48185>, <-0.857045, 0.143621, 0.49482>, <-0.172723, 5.52912, -1.43757>, <-0.696671, 0.171152, 0.696675>, <-0.211542, 5.52912, -1.48816> , <-0.853244, 0.171154, 0.492627> }
	smooth_triangle { <-0.172723, 5.52912, -1.43757>, <-0.696671, 0.171152, 0.696675>, <-0.222458, 5.44988, -1.48185>, <-0.857045, 0.143621, 0.49482>, <-0.181636, 5.44988, -1.42865> , <-0.699774, 0.143621, 0.699778> }
	smooth_triangle { <-0.211542, 5.52912, -1.48816>, <-0.853244, 0.171154, 0.492627>, <-0.167374, 5.56926, -1.44292>, <-0.694876, 0.185183, 0.694877>, <-0.204992, 5.56926, -1.49194> , <-0.851047, 0.185185, 0.49135> }
	smooth_triangle { <-0.167374, 5.56926, -1.44292>, <-0.694876, 0.185183, 0.694877>, <-0.211542, 5.52912, -1.48816>, <-0.853244, 0.171154, 0.492627>, <-0.172723, 5.52912, -1.43757> , <-0.696671, 0.171152, 0.696675> }
	smooth_triangle { <-0.162918, 5.56926, -1.44737>, <0.136139, 0.981291, -0.136139>, <-0.204992, 5.56926, -1.49194>, <0, 1, 0>, <-0.167374, 5.56926, -1.44292> , <0, 1, 0> }
	smooth_triangle { <-0.204992, 5.56926, -1.49194>, <0, 1, 0>, <-0.162918, 5.56926, -1.44737>, <0.136139, 0.981291, -0.136139>, <-0.199532, 5.56926, -1.49509> , <0.166738, 0.981291, -0.0962657> }
	smooth_triangle { <-0.159353, 5.5672, -1.45094>, <0.267343, 0.925773, -0.267343>, <-0.199532, 5.56926, -1.49509>, <0.166738, 0.981291, -0.0962657>, <-0.162918, 5.56926, -1.44737> , <0.136139, 0.981291, -0.136139> }
	smooth_triangle { <-0.199532, 5.56926, -1.49509>, <0.166738, 0.981291, -0.0962657>, <-0.159353, 5.5672, -1.45094>, <0.267343, 0.925773, -0.267343>, <-0.195166, 5.5672, -1.49761> , <0.327432, 0.925771, -0.189042> }
	smooth_triangle { <-0.158461, 5.55794, -1.45183>, <0.700635, 0.134986, -0.700635>, <-0.195166, 5.5672, -1.49761>, <0.858109, 0.134984, -0.495408>, <-0.159353, 5.5672, -1.45094> , <0.700635, 0.134986, -0.700635> }
	smooth_triangle { <-0.195166, 5.5672, -1.49761>, <0.858109, 0.134984, -0.495408>, <-0.158461, 5.55794, -1.45183>, <0.700635, 0.134986, -0.700635>, <-0.194073, 5.55794, -1.49824> , <0.858109, 0.134984, -0.495408> }
	smooth_triangle { <-0.0772578, 4.78708, -1.56569>, <-0.12365, -0.989753, 0.0714128>, <-0.00100452, 4.77442, -1.60929>, <-0.101002, -0.989751, 0.100949>, <-0.0630807, 4.78708, -1.54721> , <-0.101002, -0.989751, 0.100949> }
	smooth_triangle { <-0.00100452, 4.77442, -1.60929>, <-0.101002, -0.989751, 0.100949>, <-0.0772578, 4.78708, -1.56569>, <-0.12365, -0.989753, 0.0714128>, <-0.00123028, 4.77442, -1.60958> , <-0.12365, -0.989753, 0.0714128> }
	smooth_triangle { <-0.207941, 4.21572, -1.40235>, <0.0202573, -0.99959, -0.020259>, <-0.000916216, 4.22409, -1.6087>, <0.0143241, -0.99959, -0.0248126>, <-0.147036, 4.21572, -1.35562> , <0.0143241, -0.99959, -0.0248126> }
	smooth_triangle { <-0.000916216, 4.22409, -1.6087>, <0.0143241, -0.99959, -0.0248126>, <-0.207941, 4.21572, -1.40235>, <0.0202573, -0.99959, -0.020259>, <-0.00129573, 4.22409, -1.60899> , <0.0202573, -0.99959, -0.020259> }
	smooth_triangle { <-0.20716, 4.2287, -1.40313>, <-0.704565, 0.0847009, 0.704566>, <-0.147036, 4.21572, -1.35562>, <-0.498201, 0.0846679, 0.862918>, <-0.146484, 4.2287, -1.35657> , <-0.498201, 0.0846679, 0.862918> }
	smooth_triangle { <-0.147036, 4.21572, -1.35562>, <-0.498201, 0.0846679, 0.862918>, <-0.20716, 4.2287, -1.40313>, <-0.704565, 0.0847009, 0.704566>, <-0.207941, 4.21572, -1.40235> , <-0.704565, 0.0847009, 0.704566> }
	smooth_triangle { <-0.127674, 4.24779, -1.38915>, <-0.176596, 0.935551, 0.305874>, <-0.20716, 4.2287, -1.40313>, <-0.319972, 0.89176, 0.319971>, <-0.146484, 4.2287, -1.35657> , <-0.226252, 0.891761, 0.391882> }
	smooth_triangle { <-0.20716, 4.2287, -1.40313>, <-0.319972, 0.89176, 0.319971>, <-0.127674, 4.24779, -1.38915>, <-0.176596, 0.935551, 0.305874>, <-0.180559, 4.24779, -1.42973> , <-0.249745, 0.935551, 0.249745> }
	smooth_triangle { <-0.0906801, 4.26688, -1.45323>, <-0.107113, 0.976784, 0.185525>, <-0.180559, 4.24779, -1.42973>, <-0.249745, 0.935551, 0.249745>, <-0.127674, 4.24779, -1.38915> , <-0.176596, 0.935551, 0.305874> }
	smooth_triangle { <-0.180559, 4.24779, -1.42973>, <-0.249745, 0.935551, 0.249745>, <-0.0906801, 4.26688, -1.45323>, <-0.107113, 0.976784, 0.185525>, <-0.128241, 4.26688, -1.48205> , <-0.15148, 0.976784, 0.15148> }
	smooth_triangle { <-0.0643457, 4.27643, -1.49884>, <-0.0807472, 0.986874, 0.139858>, <-0.128241, 4.26688, -1.48205>, <-0.15148, 0.976784, 0.15148>, <-0.0906801, 4.26688, -1.45323> , <-0.107113, 0.976784, 0.185525> }
	smooth_triangle { <-0.128241, 4.26688, -1.48205>, <-0.15148, 0.976784, 0.15148>, <-0.0643457, 4.27643, -1.49884>, <-0.0807472, 0.986874, 0.139858>, <-0.0909985, 4.27643, -1.51929> , <-0.114194, 0.986874, 0.114194> }
	smooth_triangle { <-0.0353216, 4.28491, -1.54911>, <-0.0723078, 0.989488, 0.125242>, <-0.0909985, 4.27643, -1.51929>, <-0.114194, 0.986874, 0.114194>, <-0.0643457, 4.27643, -1.49884> , <-0.0807472, 0.986874, 0.139858> }
	smooth_triangle { <-0.0909985, 4.27643, -1.51929>, <-0.114194, 0.986874, 0.114194>, <-0.0353216, 4.28491, -1.54911>, <-0.0723078, 0.989488, 0.125242>, <-0.0499523, 4.28491, -1.56034> , <-0.102259, 0.989488, 0.102259> }
	smooth_triangle { <-0.0445314, 4.29552, -1.56576>, <-0.67266, 0.308296, 0.672668>, <-0.0353216, 4.28491, -1.54911>, <-0.405232, 0.585792, 0.70188>, <-0.0314883, 4.29552, -1.55575> , <-0.475644, 0.308297, 0.823842> }
	smooth_triangle { <-0.0353216, 4.28491, -1.54911>, <-0.405232, 0.585792, 0.70188>, <-0.0445314, 4.29552, -1.56576>, <-0.67266, 0.308296, 0.672668>, <-0.0499523, 4.28491, -1.56034> , <-0.573082, 0.585789, 0.573087> }
	smooth_triangle { <-0.0445314, 4.30188, -1.56576>, <-0.707102, 0, 0.707111>, <-0.0314883, 4.29552, -1.55575>, <-0.475644, 0.308297, 0.823842>, <-0.0314883, 4.30188, -1.55575> , <-0.499996, 0, 0.866028> }
	smooth_triangle { <-0.0314883, 4.29552, -1.55575>, <-0.475644, 0.308297, 0.823842>, <-0.0445314, 4.30188, -1.56576>, <-0.707102, 0, 0.707111>, <-0.0445314, 4.29552, -1.56576> , <-0.67266, 0.308296, 0.672668> }
	smooth_triangle { <-0.0445314, 4.30931, -1.56576>, <-0.668935, 0.324097, 0.668944>, <-0.0314883, 4.30188, -1.55575>, <-0.499996, 0, 0.866028>, <-0.0314883, 4.30931, -1.55575> , <-0.473009, 0.324092, 0.819284> }
	smooth_triangle { <-0.0314883, 4.30188, -1.55575>, <-0.499996, 0, 0.866028>, <-0.0445314, 4.30931, -1.56576>, <-0.668935, 0.324097, 0.668944>, <-0.0445314, 4.30188, -1.56576> , <-0.707102, 0, 0.707111> }
	smooth_triangle { <-0.0398843, 4.31779, -1.57041>, <-0.43271, 0.790898, 0.432715>, <-0.0314883, 4.30931, -1.55575>, <-0.473009, 0.324092, 0.819284>, <-0.0282025, 4.31779, -1.56144> , <-0.305975, 0.790896, 0.529966> }
	smooth_triangle { <-0.0314883, 4.30931, -1.55575>, <-0.473009, 0.324092, 0.819284>, <-0.0398843, 4.31779, -1.57041>, <-0.43271, 0.790898, 0.432715>, <-0.0445314, 4.30931, -1.56576> , <-0.668935, 0.324097, 0.668944> }
	smooth_triangle { <-0.023274, 4.32203, -1.56998>, <-0.316911, 0.773482, 0.548902>, <-0.0398843, 4.31779, -1.57041>, <-0.43271, 0.790898, 0.432715>, <-0.0282025, 4.31779, -1.56144> , <-0.305975, 0.790896, 0.529966> }
	smooth_triangle { <-0.0398843, 4.31779, -1.57041>, <-0.43271, 0.790898, 0.432715>, <-0.023274, 4.32203, -1.56998>, <-0.316911, 0.773482, 0.548902>, <-0.0329144, 4.32203, -1.57738> , <-0.448178, 0.773481, 0.448177> }
	smooth_triangle { <-0.0298165, 4.3284, -1.58047>, <-0.647248, 0.402669, 0.647246>, <-0.023274, 4.32203, -1.56998>, <-0.316911, 0.773482, 0.548902>, <-0.0210834, 4.3284, -1.57377> , <-0.457676, 0.402668, 0.792711> }
	smooth_triangle { <-0.023274, 4.32203, -1.56998>, <-0.316911, 0.773482, 0.548902>, <-0.0298165, 4.3284, -1.58047>, <-0.647248, 0.402669, 0.647246>, <-0.0329144, 4.32203, -1.57738> , <-0.448178, 0.773482, 0.448177> }
	smooth_triangle { <-0.0282676, 4.33794, -1.58202>, <-0.703194, 0.105027, 0.703198>, <-0.0210834, 4.3284, -1.57377>, <-0.457676, 0.402668, 0.792711>, <-0.0199882, 4.33794, -1.57567> , <-0.497239, 0.105026, 0.861233> }
	smooth_triangle { <-0.0210834, 4.3284, -1.57377>, <-0.457676, 0.402668, 0.792711>, <-0.0282676, 4.33794, -1.58202>, <-0.703194, 0.105027, 0.703198>, <-0.0298165, 4.3284, -1.58047> , <-0.647248, 0.402669, 0.647246> }
	smooth_triangle { <-0.0227263, 4.69858, -1.57093>, <-0.49828, -0.0829396, 0.86304>, <-0.0282676, 4.33794, -1.58202>, <-0.703194, 0.105027, 0.703198>, <-0.0199882, 4.33794, -1.57567> , <-0.497239, 0.105026, 0.861233> }
	smooth_triangle { <-0.0282676, 4.33794, -1.58202>, <-0.703194, 0.105027, 0.703198>, <-0.0227263, 4.69858, -1.57093>, <-0.49828, -0.0829396, 0.86304>, <-0.0321399, 4.69858, -1.57815> , <-0.704669, -0.0829403, 0.704672> }
	smooth_triangle { <-0.0238215, 4.71298, -1.56903>, <-0.488491, -0.213317, 0.846092>, <-0.0321399, 4.69858, -1.57815>, <-0.704669, -0.0829403, 0.704672>, <-0.0227263, 4.69858, -1.57093> , <-0.49828, -0.0829396, 0.86304> }
	smooth_triangle { <-0.0321399, 4.69858, -1.57815>, <-0.704669, -0.0829403, 0.704672>, <-0.0238215, 4.71298, -1.56903>, <-0.488491, -0.213317, 0.846092>, <-0.0336888, 4.71298, -1.5766> , <-0.690835, -0.213318, 0.690828> }
	smooth_triangle { <-0.027655, 4.73974, -1.56239>, <-0.47512, -0.311514, 0.822934>, <-0.0336888, 4.71298, -1.5766>, <-0.690835, -0.213318, 0.690828>, <-0.0238215, 4.71298, -1.56903> , <-0.488491, -0.213317, 0.846092> }
	smooth_triangle { <-0.0336888, 4.71298, -1.5766>, <-0.690835, -0.213318, 0.690828>, <-0.027655, 4.73974, -1.56239>, <-0.47512, -0.311514, 0.822934>, <-0.0391099, 4.73974, -1.57118> , <-0.671923, -0.311515, 0.671921> }
	smooth_triangle { <-0.032036, 4.76341, -1.5548>, <-0.416747, -0.552524, 0.72183>, <-0.0391099, 4.73974, -1.57118>, <-0.671923, -0.311515, 0.671921>, <-0.027655, 4.73974, -1.56239> , <-0.47512, -0.311514, 0.822934> }
	smooth_triangle { <-0.0391099, 4.73974, -1.57118>, <-0.671923, -0.311515, 0.671921>, <-0.032036, 4.76341, -1.5548>, <-0.416747, -0.552524, 0.72183>, <-0.0453058, 4.76341, -1.56498> , <-0.589369, -0.552525, 0.589374> }
	smooth_triangle { <-0.0630807, 4.78708, -1.54721>, <-0.371645, -0.85074, 0.371646>, <-0.032036, 4.76341, -1.5548>, <-0.416747, -0.552524, 0.72183>, <-0.0446049, 4.78708, -1.53303> , <-0.262792, -0.85074, 0.455171> }
	smooth_triangle { <-0.032036, 4.76341, -1.5548>, <-0.416747, -0.552524, 0.72183>, <-0.0630807, 4.78708, -1.54721>, <-0.371645, -0.85074, 0.371646>, <-0.0453058, 4.76341, -1.56498> , <-0.589369, -0.552525, 0.589374> }
	smooth_triangle { <-0.0987367, 4.80561, -1.51155>, <-0.320895, -0.891096, 0.320895>, <-0.0446049, 4.78708, -1.53303>, <-0.262792, -0.85074, 0.455171>, <-0.0698173, 4.80561, -1.48936> , <-0.226907, -0.891097, 0.393013> }
	smooth_triangle { <-0.0446049, 4.78708, -1.53303>, <-0.262792, -0.85074, 0.455171>, <-0.0987367, 4.80561, -1.51155>, <-0.320895, -0.891096, 0.320895>, <-0.0630807, 4.78708, -1.54721> , <-0.371645, -0.85074, 0.371646> }
	smooth_triangle { <-0.133501, 4.83854, -1.47679>, <-0.420817, -0.803633, 0.420818>, <-0.0698173, 4.80561, -1.48936>, <-0.226907, -0.891097, 0.393013>, <-0.0943997, 4.83854, -1.44679> , <-0.297567, -0.803632, 0.515393> }
	smooth_triangle { <-0.0698173, 4.80561, -1.48936>, <-0.226907, -0.891097, 0.393013>, <-0.133501, 4.83854, -1.47679>, <-0.420817, -0.803633, 0.420818>, <-0.0987367, 4.80561, -1.51155> , <-0.320895, -0.891096, 0.320895> }
	smooth_triangle { <-0.155786, 4.86427, -1.4545>, <-0.507025, -0.697032, 0.507023>, <-0.0943997, 4.83854, -1.44679>, <-0.297567, -0.803632, 0.515393>, <-0.110158, 4.86427, -1.41949> , <-0.358528, -0.697025, 0.620978> }
	smooth_triangle { <-0.0943997, 4.83854, -1.44679>, <-0.297567, -0.803632, 0.515393>, <-0.155786, 4.86427, -1.4545>, <-0.507025, -0.697032, 0.507023>, <-0.133501, 4.83854, -1.47679> , <-0.420817, -0.803633, 0.420818> }
	smooth_triangle { <-0.124024, 4.90029, -1.39547>, <-0.415148, -0.557315, 0.719063>, <-0.155786, 4.86427, -1.4545>, <-0.507025, -0.697032, 0.507023>, <-0.110158, 4.86427, -1.41949> , <-0.358528, -0.697025, 0.620978> }
	smooth_triangle { <-0.155786, 4.86427, -1.4545>, <-0.507025, -0.697032, 0.507023>, <-0.124024, 4.90029, -1.39547>, <-0.415148, -0.557315, 0.719063>, <-0.175398, 4.90029, -1.43489> , <-0.587115, -0.557312, 0.587111> }
	smooth_triangle { <-0.134971, 4.938, -1.37651>, <-0.458507, -0.39885, 0.79416>, <-0.175398, 4.90029, -1.43489>, <-0.587115, -0.557312, 0.587111>, <-0.124024, 4.90029, -1.39547> , <-0.415148, -0.557315, 0.719063> }
	smooth_triangle { <-0.175398, 4.90029, -1.43489>, <-0.587115, -0.557312, 0.587111>, <-0.134971, 4.938, -1.37651>, <-0.458507, -0.39885, 0.79416>, <-0.190877, 4.938, -1.41941> , <-0.648434, -0.39884, 0.648429> }
	smooth_triangle { <-0.144541, 5.00115, -1.35994>, <-0.492651, -0.170874, 0.853286>, <-0.190877, 4.938, -1.41941>, <-0.648434, -0.39884, 0.648429>, <-0.134971, 4.938, -1.37651> , <-0.458507, -0.39885, 0.79416> }
	smooth_triangle { <-0.190877, 4.938, -1.41941>, <-0.648434, -0.39884, 0.648429>, <-0.144541, 5.00115, -1.35994>, <-0.492651, -0.170874, 0.853286>, <-0.204411, 5.00115, -1.40588> , <-0.696708, -0.170882, 0.696705> }
	smooth_triangle { <-0.146716, 5.08966, -1.35617>, <-0.499987, 0.00603905, 0.866012>, <-0.204411, 5.00115, -1.40588>, <-0.696708, -0.170882, 0.696705>, <-0.144541, 5.00115, -1.35994> , <-0.492651, -0.170874, 0.853286> }
	smooth_triangle { <-0.204411, 5.00115, -1.40588>, <-0.696708, -0.170882, 0.696705>, <-0.146716, 5.08966, -1.35617>, <-0.499987, 0.00603905, 0.866012>, <-0.207488, 5.08966, -1.4028> , <-0.707093, 0.00603566, 0.707094> }
	smooth_triangle { <-0.20303, 5.19258, -1.40726>, <-0.70462, 0.0838012, 0.70462>, <-0.146716, 5.08966, -1.35617>, <-0.499987, 0.00603905, 0.866012>, <-0.143564, 5.19258, -1.36163> , <-0.498236, 0.0837988, 0.862982> }
	smooth_triangle { <-0.146716, 5.08966, -1.35617>, <-0.499987, 0.00603905, 0.866012>, <-0.20303, 5.19258, -1.40726>, <-0.70462, 0.0838012, 0.70462>, <-0.207488, 5.08966, -1.4028> , <-0.707093, 0.00603566, 0.707094> }
	smooth_triangle { <-0.195008, 5.29859, -1.41528>, <-0.702725, 0.111147, 0.702726>, <-0.143564, 5.19258, -1.36163>, <-0.498236, 0.0837988, 0.862982>, <-0.137891, 5.29859, -1.37146> , <-0.496899, 0.111147, 0.860661> }
	smooth_triangle { <-0.143564, 5.19258, -1.36163>, <-0.498236, 0.0837988, 0.862982>, <-0.195008, 5.29859, -1.41528>, <-0.702725, 0.111147, 0.702726>, <-0.20303, 5.19258, -1.40726> , <-0.70462, 0.0838012, 0.70462> }
	smooth_triangle { <-0.189659, 5.36342, -1.42063>, <-0.702344, 0.115873, 0.702344>, <-0.137891, 5.29859, -1.37146>, <-0.496899, 0.111147, 0.860661>, <-0.134109, 5.36342, -1.37801> , <-0.496627, 0.11587, 0.860195> }
	smooth_triangle { <-0.137891, 5.29859, -1.37146>, <-0.496899, 0.111147, 0.860661>, <-0.189659, 5.36342, -1.42063>, <-0.702344, 0.115873, 0.702344>, <-0.195008, 5.29859, -1.41528> , <-0.702725, 0.111147, 0.702726> }
	smooth_triangle { <-0.181636, 5.44988, -1.42865>, <-0.699774, 0.143621, 0.699778>, <-0.134109, 5.36342, -1.37801>, <-0.495745, 0.130117, 0.858666>, <-0.128436, 5.44988, -1.38783> , <-0.494819, 0.143619, 0.857046> }
	smooth_triangle { <-0.134109, 5.36342, -1.37801>, <-0.495745, 0.130117, 0.858666>, <-0.181636, 5.44988, -1.42865>, <-0.699774, 0.143621, 0.699778>, <-0.189659, 5.36342, -1.42063> , <-0.701093, 0.13013, 0.701095> }
	smooth_triangle { <-0.172723, 5.52912, -1.43757>, <-0.696671, 0.171152, 0.696675>, <-0.128436, 5.44988, -1.38783>, <-0.494819, 0.143619, 0.857046>, <-0.122133, 5.52912, -1.39875> , <-0.492627, 0.171152, 0.853244> }
	smooth_triangle { <-0.128436, 5.44988, -1.38783>, <-0.494819, 0.143619, 0.857046>, <-0.172723, 5.52912, -1.43757>, <-0.696671, 0.171152, 0.696675>, <-0.181636, 5.44988, -1.42865> , <-0.699774, 0.143621, 0.699778> }
	smooth_triangle { <-0.167374, 5.56926, -1.44292>, <-0.694876, 0.185183, 0.694877>, <-0.122133, 5.52912, -1.39875>, <-0.492627, 0.171152, 0.853244>, <-0.118352, 5.56926, -1.4053> , <-0.491352, 0.185174, 0.851049> }
	smooth_triangle { <-0.122133, 5.52912, -1.39875>, <-0.492627, 0.171152, 0.853244>, <-0.167374, 5.56926, -1.44292>, <-0.694876, 0.185183, 0.694877>, <-0.172723, 5.52912, -1.43757> , <-0.696671, 0.171152, 0.696675> }
	smooth_triangle { <-0.1152, 5.56926, -1.41076>, <0.0962506, 0.981298, -0.166702>, <-0.167374, 5.56926, -1.44292>, <0, 1, 0>, <-0.118352, 5.56926, -1.4053> , <0, 1, 0> }
	smooth_triangle { <-0.167374, 5.56926, -1.44292>, <0, 1, 0>, <-0.1152, 5.56926, -1.41076>, <0.0962506, 0.981298, -0.166702>, <-0.162918, 5.56926, -1.44737> , <0.136139, 0.981291, -0.136139> }
	smooth_triangle { <-0.112679, 5.5672, -1.41512>, <0.189013, 0.925801, -0.327363>, <-0.162918, 5.56926, -1.44737>, <0.136139, 0.981291, -0.136139>, <-0.1152, 5.56926, -1.41076> , <0.0962506, 0.981298, -0.166702> }
	smooth_triangle { <-0.162918, 5.56926, -1.44737>, <0.136139, 0.981291, -0.136139>, <-0.112679, 5.5672, -1.41512>, <0.189013, 0.925801, -0.327363>, <-0.159353, 5.5672, -1.45094> , <0.267343, 0.925773, -0.267343> }
	smooth_triangle { <-0.158461, 5.55794, -1.45183>, <0.700635, 0.134986, -0.700635>, <-0.112679, 5.5672, -1.41512>, <0.495408, 0.134952, -0.858113>, <-0.112048, 5.55794, -1.41622> , <0.495408, 0.134952, -0.858113> }
	smooth_triangle { <-0.112679, 5.5672, -1.41512>, <0.495408, 0.134952, -0.858113>, <-0.158461, 5.55794, -1.45183>, <0.700635, 0.134986, -0.700635>, <-0.159353, 5.5672, -1.45094> , <0.700635, 0.134986, -0.700635> }
	smooth_triangle { <-0.0630807, 4.78708, -1.54721>, <-0.101002, -0.989751, 0.100949>, <-0.0007103, 4.77442, -1.60906>, <-0.0713784, -0.989755, 0.123655>, <-0.0446049, 4.78708, -1.53303> , <-0.0713784, -0.989755, 0.123655> }
	smooth_triangle { <-0.0007103, 4.77442, -1.60906>, <-0.0713784, -0.989755, 0.123655>, <-0.0630807, 4.78708, -1.54721>, <-0.101002, -0.989751, 0.100949>, <-0.00100452, 4.77442, -1.60929> , <-0.101002, -0.989751, 0.100949> }
	smooth_triangle { <-0.147036, 4.21572, -1.35562>, <0.0143241, -0.99959, -0.0248126>, <-0.000474268, 4.22409, -1.60852>, <0.0074172, -0.99959, -0.0276735>, <-0.0761115, 4.21572, -1.32624> , <0.0074172, -0.99959, -0.0276735> }
	smooth_triangle { <-0.000474268, 4.22409, -1.60852>, <0.0074172, -0.99959, -0.0276735>, <-0.147036, 4.21572, -1.35562>, <0.0143241, -0.99959, -0.0248126>, <-0.000916216, 4.22409, -1.6087> , <0.0143241, -0.99959, -0.0248126> }
	smooth_triangle { <-0.146484, 4.2287, -1.35657>, <-0.498201, 0.0846679, 0.862918>, <-0.0761115, 4.21572, -1.32624>, <-0.257894, 0.0847015, 0.962453>, <-0.0758259, 4.2287, -1.3273> , <-0.257894, 0.0847015, 0.962453> }
	smooth_triangle { <-0.0761115, 4.21572, -1.32624>, <-0.257894, 0.0847015, 0.962453>, <-0.146484, 4.2287, -1.35657>, <-0.498201, 0.0846679, 0.862918>, <-0.147036, 4.21572, -1.35562> , <-0.498201, 0.0846679, 0.862918> }
	smooth_triangle { <-0.066089, 4.24779, -1.36364>, <-0.0914139, 0.93555, 0.341159>, <-0.146484, 4.2287, -1.35657>, <-0.226252, 0.891761, 0.391882>, <-0.0758259, 4.2287, -1.3273> , <-0.117118, 0.891759, 0.437092> }
	smooth_triangle { <-0.146484, 4.2287, -1.35657>, <-0.226252, 0.891761, 0.391882>, <-0.066089, 4.24779, -1.36364>, <-0.0914139, 0.93555, 0.341159>, <-0.127674, 4.24779, -1.38915> , <-0.176596, 0.935551, 0.305874> }
	smooth_triangle { <-0.0469395, 4.26688, -1.43511>, <-0.0554456, 0.976785, 0.206925>, <-0.127674, 4.24779, -1.38915>, <-0.176596, 0.935551, 0.305874>, <-0.066089, 4.24779, -1.36364> , <-0.0914139, 0.93555, 0.341159> }
	smooth_triangle { <-0.127674, 4.24779, -1.38915>, <-0.176596, 0.935551, 0.305874>, <-0.0469395, 4.26688, -1.43511>, <-0.0554456, 0.976785, 0.206925>, <-0.0906801, 4.26688, -1.45323> , <-0.107113, 0.976784, 0.185525> }
	smooth_triangle { <-0.0333078, 4.27643, -1.48598>, <-0.0417968, 0.986874, 0.155992>, <-0.0906801, 4.26688, -1.45323>, <-0.107113, 0.976784, 0.185525>, <-0.0469395, 4.26688, -1.43511> , <-0.0554456, 0.976785, 0.206925> }
	smooth_triangle { <-0.0906801, 4.26688, -1.45323>, <-0.107113, 0.976784, 0.185525>, <-0.0333078, 4.27643, -1.48598>, <-0.0417968, 0.986874, 0.155992>, <-0.0643457, 4.27643, -1.49884> , <-0.0807472, 0.986874, 0.139858> }
	smooth_triangle { <-0.0182838, 4.28491, -1.54205>, <-0.037429, 0.989488, 0.13969>, <-0.0643457, 4.27643, -1.49884>, <-0.0807472, 0.986874, 0.139858>, <-0.0333078, 4.27643, -1.48598> , <-0.0417968, 0.986874, 0.155992> }
	smooth_triangle { <-0.0643457, 4.27643, -1.49884>, <-0.0807472, 0.986874, 0.139858>, <-0.0182838, 4.28491, -1.54205>, <-0.037429, 0.989488, 0.13969>, <-0.0353216, 4.28491, -1.54911> , <-0.0723078, 0.989488, 0.125242> }
	smooth_triangle { <-0.0314883, 4.29552, -1.55575>, <-0.475644, 0.308297, 0.823842>, <-0.0182838, 4.28491, -1.54205>, <-0.209769, 0.585797, 0.78284>, <-0.0162996, 4.29552, -1.54946> , <-0.246218, 0.3083, 0.918873> }
	smooth_triangle { <-0.0182838, 4.28491, -1.54205>, <-0.209769, 0.585797, 0.78284>, <-0.0314883, 4.29552, -1.55575>, <-0.475644, 0.308297, 0.823842>, <-0.0353216, 4.28491, -1.54911> , <-0.405232, 0.585792, 0.70188> }
	smooth_triangle { <-0.0314883, 4.30188, -1.55575>, <-0.499996, 0, 0.866028>, <-0.0162996, 4.29552, -1.54946>, <-0.246218, 0.3083, 0.918873>, <-0.0162996, 4.30188, -1.54946> , <-0.258823, 0, 0.965925> }
	smooth_triangle { <-0.0162996, 4.29552, -1.54946>, <-0.246218, 0.3083, 0.918873>, <-0.0314883, 4.30188, -1.55575>, <-0.499996, 0, 0.866028>, <-0.0314883, 4.29552, -1.55575> , <-0.475644, 0.308297, 0.823842> }
	smooth_triangle { <-0.0314883, 4.30931, -1.55575>, <-0.473009, 0.324092, 0.819284>, <-0.0162996, 4.30188, -1.54946>, <-0.258823, 0, 0.965925>, <-0.0162996, 4.30931, -1.54946> , <-0.244853, 0.324093, 0.913789> }
	smooth_triangle { <-0.0162996, 4.30188, -1.54946>, <-0.258823, 0, 0.965925>, <-0.0314883, 4.30931, -1.55575>, <-0.473009, 0.324092, 0.819284>, <-0.0314883, 4.30188, -1.55575> , <-0.499996, 0, 0.866028> }
	smooth_triangle { <-0.0282025, 4.31779, -1.56144>, <-0.305975, 0.790896, 0.529966>, <-0.0162996, 4.30931, -1.54946>, <-0.244853, 0.324093, 0.913789>, <-0.0145987, 4.31779, -1.55581> , <-0.158386, 0.790897, 0.591097> }
	smooth_triangle { <-0.0162996, 4.30931, -1.54946>, <-0.244853, 0.324093, 0.913789>, <-0.0282025, 4.31779, -1.56144>, <-0.305975, 0.790896, 0.529966>, <-0.0314883, 4.30931, -1.55575> , <-0.473009, 0.324092, 0.819284> }
	smooth_triangle { <-0.0120475, 4.32203, -1.56533>, <-0.164044, 0.77348, 0.612224>, <-0.0282025, 4.31779, -1.56144>, <-0.305975, 0.790896, 0.529966>, <-0.0145987, 4.31779, -1.55581> , <-0.158386, 0.790897, 0.591097> }
	smooth_triangle { <-0.0282025, 4.31779, -1.56144>, <-0.305975, 0.790896, 0.529966>, <-0.0120475, 4.32203, -1.56533>, <-0.164044, 0.77348, 0.612224>, <-0.023274, 4.32203, -1.56998> , <-0.316911, 0.773482, 0.548902> }
	smooth_triangle { <-0.0210834, 4.3284, -1.57377>, <-0.457676, 0.402668, 0.792711>, <-0.0120475, 4.32203, -1.56533>, <-0.164044, 0.77348, 0.612224>, <-0.0109136, 4.3284, -1.56956> , <-0.23691, 0.402663, 0.884158> }
	smooth_triangle { <-0.0120475, 4.32203, -1.56533>, <-0.164044, 0.77348, 0.612224>, <-0.0210834, 4.3284, -1.57377>, <-0.457676, 0.402668, 0.792711>, <-0.023274, 4.32203, -1.56998> , <-0.316911, 0.773482, 0.548902> }
	smooth_triangle { <-0.0199882, 4.33794, -1.57567>, <-0.497239, 0.105026, 0.861233>, <-0.0109136, 4.3284, -1.56956>, <-0.23691, 0.402663, 0.884158>, <-0.0103467, 4.33794, -1.57168> , <-0.257392, 0.105025, 0.960583> }
	smooth_triangle { <-0.0109136, 4.3284, -1.56956>, <-0.23691, 0.402663, 0.884158>, <-0.0199882, 4.33794, -1.57567>, <-0.497239, 0.105026, 0.861233>, <-0.0210834, 4.3284, -1.57377> , <-0.457676, 0.402668, 0.792711> }
	smooth_triangle { <-0.011764, 4.69858, -1.56639>, <-0.257929, -0.0829348, 0.962598>, <-0.0199882, 4.33794, -1.57567>, <-0.497239, 0.105026, 0.861233>, <-0.0103467, 4.33794, -1.57168> , <-0.257392, 0.105025, 0.960583> }
	smooth_triangle { <-0.0199882, 4.33794, -1.57567>, <-0.497239, 0.105026, 0.861233>, <-0.011764, 4.69858, -1.56639>, <-0.257929, -0.0829348, 0.962598>, <-0.0227263, 4.69858, -1.57093> , <-0.49828, -0.0829396, 0.86304> }
	smooth_triangle { <-0.0123309, 4.71298, -1.56427>, <-0.252854, -0.213314, 0.943696>, <-0.0227263, 4.69858, -1.57093>, <-0.49828, -0.0829396, 0.86304>, <-0.011764, 4.69858, -1.56639> , <-0.257929, -0.0829348, 0.962598> }
	smooth_triangle { <-0.0227263, 4.69858, -1.57093>, <-0.49828, -0.0829396, 0.86304>, <-0.0123309, 4.71298, -1.56427>, <-0.252854, -0.213314, 0.943696>, <-0.0238215, 4.71298, -1.56903> , <-0.488491, -0.213317, 0.846092> }
	smooth_triangle { <-0.0143152, 4.73974, -1.55686>, <-0.245932, -0.311516, 0.917864>, <-0.0238215, 4.71298, -1.56903>, <-0.488491, -0.213317, 0.846092>, <-0.0123309, 4.71298, -1.56427> , <-0.252854, -0.213314, 0.943696> }
	smooth_triangle { <-0.0238215, 4.71298, -1.56903>, <-0.488491, -0.213317, 0.846092>, <-0.0143152, 4.73974, -1.55686>, <-0.245932, -0.311516, 0.917864>, <-0.027655, 4.73974, -1.56239> , <-0.47512, -0.311514, 0.822934> }
	smooth_triangle { <-0.016583, 4.76341, -1.5484>, <-0.215722, -0.552525, 0.805096>, <-0.027655, 4.73974, -1.56239>, <-0.47512, -0.311514, 0.822934>, <-0.0143152, 4.73974, -1.55686> , <-0.245932, -0.311516, 0.917864> }
	smooth_triangle { <-0.027655, 4.73974, -1.56239>, <-0.47512, -0.311514, 0.822934>, <-0.016583, 4.76341, -1.5484>, <-0.215722, -0.552525, 0.805096>, <-0.032036, 4.76341, -1.5548> , <-0.416747, -0.552524, 0.72183> }
	smooth_triangle { <-0.0446049, 4.78708, -1.53303>, <-0.262792, -0.85074, 0.455171>, <-0.016583, 4.76341, -1.5484>, <-0.215722, -0.552525, 0.805096>, <-0.0230892, 4.78708, -1.52412> , <-0.13603, -0.850741, 0.507676> }
	smooth_triangle { <-0.016583, 4.76341, -1.5484>, <-0.215722, -0.552525, 0.805096>, <-0.0446049, 4.78708, -1.53303>, <-0.262792, -0.85074, 0.455171>, <-0.032036, 4.76341, -1.5548> , <-0.416747, -0.552524, 0.72183> }
	smooth_triangle { <-0.0698173, 4.80561, -1.48936>, <-0.226907, -0.891097, 0.393013>, <-0.0230892, 4.78708, -1.52412>, <-0.13603, -0.850741, 0.507676>, <-0.0361402, 4.80561, -1.47541> , <-0.117457, -0.891097, 0.43835> }
	smooth_triangle { <-0.0230892, 4.78708, -1.52412>, <-0.13603, -0.850741, 0.507676>, <-0.0698173, 4.80561, -1.48936>, <-0.226907, -0.891097, 0.393013>, <-0.0446049, 4.78708, -1.53303> , <-0.262792, -0.85074, 0.455171> }
	smooth_triangle { <-0.0943997, 4.83854, -1.44679>, <-0.297567, -0.803632, 0.515393>, <-0.0361402, 4.80561, -1.47541>, <-0.117457, -0.891097, 0.43835>, <-0.0488648, 4.83854, -1.42792> , <-0.154031, -0.803632, 0.574848> }
	smooth_triangle { <-0.0361402, 4.80561, -1.47541>, <-0.117457, -0.891097, 0.43835>, <-0.0943997, 4.83854, -1.44679>, <-0.297567, -0.803632, 0.515393>, <-0.0698173, 4.80561, -1.48936> , <-0.226907, -0.891097, 0.393013> }
	smooth_triangle { <-0.110158, 4.86427, -1.41949>, <-0.358528, -0.697025, 0.620978>, <-0.0488648, 4.83854, -1.42792>, <-0.154031, -0.803632, 0.574848>, <-0.0570217, 4.86427, -1.39748> , <-0.185584, -0.697029, 0.69261> }
	smooth_triangle { <-0.0488648, 4.83854, -1.42792>, <-0.154031, -0.803632, 0.574848>, <-0.110158, 4.86427, -1.41949>, <-0.358528, -0.697025, 0.620978>, <-0.0943997, 4.83854, -1.44679> , <-0.297567, -0.803632, 0.515393> }
	smooth_triangle { <-0.0641997, 4.90029, -1.37069>, <-0.214901, -0.557314, 0.802009>, <-0.110158, 4.86427, -1.41949>, <-0.358528, -0.697025, 0.620978>, <-0.0570217, 4.86427, -1.39748> , <-0.185584, -0.697029, 0.69261> }
	smooth_triangle { <-0.110158, 4.86427, -1.41949>, <-0.358528, -0.697025, 0.620978>, <-0.0641997, 4.90029, -1.37069>, <-0.214901, -0.557314, 0.802009>, <-0.124024, 4.90029, -1.39547> , <-0.415148, -0.557315, 0.719063> }
	smooth_triangle { <-0.069866, 4.938, -1.34955>, <-0.237344, -0.398844, 0.885772>, <-0.124024, 4.90029, -1.39547>, <-0.415148, -0.557315, 0.719063>, <-0.0641997, 4.90029, -1.37069> , <-0.214901, -0.557314, 0.802009> }
	smooth_triangle { <-0.124024, 4.90029, -1.39547>, <-0.415148, -0.557315, 0.719063>, <-0.069866, 4.938, -1.34955>, <-0.237344, -0.398844, 0.885772>, <-0.134971, 4.938, -1.37651> , <-0.458507, -0.39885, 0.79416> }
	smooth_triangle { <-0.0748199, 5.00115, -1.33106>, <-0.25501, -0.170873, 0.951721>, <-0.134971, 4.938, -1.37651>, <-0.458507, -0.39885, 0.79416>, <-0.069866, 4.938, -1.34955> , <-0.237344, -0.398844, 0.885772> }
	smooth_triangle { <-0.134971, 4.938, -1.37651>, <-0.458507, -0.39885, 0.79416>, <-0.0748199, 5.00115, -1.33106>, <-0.25501, -0.170873, 0.951721>, <-0.144541, 5.00115, -1.35994> , <-0.492651, -0.170874, 0.853286> }
	smooth_triangle { <-0.0759456, 5.08966, -1.32686>, <-0.258811, 0.00603508, 0.965909>, <-0.144541, 5.00115, -1.35994>, <-0.492651, -0.170874, 0.853286>, <-0.0748199, 5.00115, -1.33106> , <-0.25501, -0.170873, 0.951721> }
	smooth_triangle { <-0.144541, 5.00115, -1.35994>, <-0.492651, -0.170874, 0.853286>, <-0.0759456, 5.08966, -1.32686>, <-0.258811, 0.00603508, 0.965909>, <-0.146716, 5.08966, -1.35617> , <-0.499987, 0.00603905, 0.866012> }
	smooth_triangle { <-0.143564, 5.19258, -1.36163>, <-0.498236, 0.0837988, 0.862982>, <-0.0759456, 5.08966, -1.32686>, <-0.258811, 0.00603508, 0.965909>, <-0.0743142, 5.19258, -1.33295> , <-0.257911, 0.0837969, 0.962528> }
	smooth_triangle { <-0.0759456, 5.08966, -1.32686>, <-0.258811, 0.00603508, 0.965909>, <-0.143564, 5.19258, -1.36163>, <-0.498236, 0.0837988, 0.862982>, <-0.146716, 5.08966, -1.35617> , <-0.499987, 0.00603905, 0.866012> }
	smooth_triangle { <-0.137891, 5.29859, -1.37146>, <-0.496899, 0.111147, 0.860661>, <-0.0743142, 5.19258, -1.33295>, <-0.257911, 0.0837969, 0.962528>, <-0.0713778, 5.29859, -1.34391> , <-0.25722, 0.111143, 0.95994> }
	smooth_triangle { <-0.0743142, 5.19258, -1.33295>, <-0.257911, 0.0837969, 0.962528>, <-0.137891, 5.29859, -1.37146>, <-0.496899, 0.111147, 0.860661>, <-0.143564, 5.19258, -1.36163> , <-0.498236, 0.0837988, 0.862982> }
	smooth_triangle { <-0.134109, 5.36342, -1.37801>, <-0.496627, 0.11587, 0.860195>, <-0.0713778, 5.29859, -1.34391>, <-0.25722, 0.111143, 0.95994>, <-0.0694202, 5.36342, -1.35121> , <-0.257077, 0.115859, 0.959421> }
	smooth_triangle { <-0.0713778, 5.29859, -1.34391>, <-0.25722, 0.111143, 0.95994>, <-0.134109, 5.36342, -1.37801>, <-0.496627, 0.11587, 0.860195>, <-0.137891, 5.29859, -1.37146> , <-0.496899, 0.111147, 0.860661> }
	smooth_triangle { <-0.128436, 5.44988, -1.38783>, <-0.494819, 0.143619, 0.857046>, <-0.0694202, 5.36342, -1.35121>, <-0.25663, 0.130122, 0.95771>, <-0.0664837, 5.44988, -1.36217> , <-0.256144, 0.143628, 0.955909> }
	smooth_triangle { <-0.0694202, 5.36342, -1.35121>, <-0.25663, 0.130122, 0.95771>, <-0.128436, 5.44988, -1.38783>, <-0.494819, 0.143619, 0.857046>, <-0.134109, 5.36342, -1.37801> , <-0.495745, 0.130117, 0.858666> }
	smooth_triangle { <-0.122133, 5.52912, -1.39875>, <-0.492627, 0.171152, 0.853244>, <-0.0664837, 5.44988, -1.36217>, <-0.256144, 0.143628, 0.955909>, <-0.063221, 5.52912, -1.37435> , <-0.254997, 0.171153, 0.951674> }
	smooth_triangle { <-0.0664837, 5.44988, -1.36217>, <-0.256144, 0.143628, 0.955909>, <-0.122133, 5.52912, -1.39875>, <-0.492627, 0.171152, 0.853244>, <-0.128436, 5.44988, -1.38783> , <-0.494819, 0.143619, 0.857046> }
	smooth_triangle { <-0.118352, 5.56926, -1.4053>, <-0.491352, 0.185174, 0.851049>, <-0.063221, 5.52912, -1.37435>, <-0.254997, 0.171153, 0.951674>, <-0.0612633, 5.56926, -1.38165> , <-0.254333, 0.185165, 0.949225> }
	smooth_triangle { <-0.063221, 5.52912, -1.37435>, <-0.254997, 0.171153, 0.951674>, <-0.118352, 5.56926, -1.4053>, <-0.491352, 0.185174, 0.851049>, <-0.122133, 5.52912, -1.39875> , <-0.492627, 0.171152, 0.853244> }
	smooth_triangle { <-0.059632, 5.56926, -1.38774>, <0.0498156, 0.9813, -0.185929>, <-0.118352, 5.56926, -1.4053>, <0, 1, 0>, <-0.0612633, 5.56926, -1.38165> , <0, 1, 0> }
	smooth_triangle { <-0.118352, 5.56926, -1.4053>, <0, 1, 0>, <-0.059632, 5.56926, -1.38774>, <0.0498156, 0.9813, -0.185929>, <-0.1152, 5.56926, -1.41076> , <0.0962506, 0.981298, -0.166702> }
	smooth_triangle { <-0.0583268, 5.5672, -1.39261>, <0.0978263, 0.925806, -0.365121>, <-0.1152, 5.56926, -1.41076>, <0.0962506, 0.981298, -0.166702>, <-0.059632, 5.56926, -1.38774> , <0.0498156, 0.9813, -0.185929> }
	smooth_triangle { <-0.1152, 5.56926, -1.41076>, <0.0962506, 0.981298, -0.166702>, <-0.0583268, 5.5672, -1.39261>, <0.0978263, 0.925806, -0.365121>, <-0.112679, 5.5672, -1.41512> , <0.189013, 0.925801, -0.327363> }
	smooth_triangle { <-0.112048, 5.55794, -1.41622>, <0.495408, 0.134952, -0.858113>, <-0.0583268, 5.5672, -1.39261>, <0.256452, 0.134894, -0.957098>, <-0.0580006, 5.55794, -1.39383> , <0.256452, 0.134894, -0.957098> }
	smooth_triangle { <-0.0583268, 5.5672, -1.39261>, <0.256452, 0.134894, -0.957098>, <-0.112048, 5.55794, -1.41622>, <0.495408, 0.134952, -0.858113>, <-0.112679, 5.5672, -1.41512> , <0.495408, 0.134952, -0.858113> }
	smooth_triangle { <-0.0446049, 4.78708, -1.53303>, <-0.0713784, -0.989755, 0.123655>, <-0.000367679, 4.77442, -1.60892>, <-0.0369499, -0.989751, 0.137939>, <-0.0230892, 4.78708, -1.52412> , <-0.0369499, -0.989751, 0.137939> }
	smooth_triangle { <-0.000367679, 4.77442, -1.60892>, <-0.0369499, -0.989751, 0.137939>, <-0.0446049, 4.78708, -1.53303>, <-0.0713784, -0.989755, 0.123655>, <-0.0007103, 4.77442, -1.60906> , <-0.0713784, -0.989755, 0.123655> }
	smooth_triangle { <-0.0761115, 4.21572, -1.32624>, <0.0074172, -0.99959, -0.0276735>, <8.00982e-011, 4.22409, -1.60846>, <2.27011e-008, -0.99959, -0.0286498>, <1.28543e-008, 4.21572, -1.31622> , <2.27011e-008, -0.99959, -0.0286498> }
	smooth_triangle { <8.00982e-011, 4.22409, -1.60846>, <2.27011e-008, -0.99959, -0.0286498>, <-0.0761115, 4.21572, -1.32624>, <0.0074172, -0.99959, -0.0276735>, <-0.000474268, 4.22409, -1.60852> , <0.0074172, -0.99959, -0.0276735> }
	smooth_triangle { <-0.0758259, 4.2287, -1.3273>, <-0.257894, 0.0847015, 0.962453>, <1.28543e-008, 4.21572, -1.31622>, <1.42774e-007, 0.0847022, 0.996406>, <1.28061e-008, 4.2287, -1.31732> , <1.42774e-007, 0.0847022, 0.996406> }
	smooth_triangle { <1.28543e-008, 4.21572, -1.31622>, <1.42774e-007, 0.0847022, 0.996406>, <-0.0758259, 4.2287, -1.3273>, <-0.257894, 0.0847015, 0.962453>, <-0.0761115, 4.21572, -1.32624> , <-0.257894, 0.0847015, 0.962453> }
	smooth_triangle { <1.11616e-008, 4.24779, -1.35494>, <1.19116e-007, 0.93555, 0.353193>, <-0.0758259, 4.2287, -1.3273>, <-0.117118, 0.891759, 0.437092>, <1.28061e-008, 4.2287, -1.31732> , <3.5453e-008, 0.891759, 0.45251> }
	smooth_triangle { <-0.0758259, 4.2287, -1.3273>, <-0.117118, 0.891759, 0.437092>, <1.11616e-008, 4.24779, -1.35494>, <1.19116e-007, 0.93555, 0.353193>, <-0.066089, 4.24779, -1.36364> , <-0.0914139, 0.93555, 0.341159> }
	smooth_triangle { <7.9275e-009, 4.26688, -1.42893>, <5.26765e-008, 0.976784, 0.214225>, <-0.066089, 4.24779, -1.36364>, <-0.0914139, 0.93555, 0.341159>, <1.11616e-008, 4.24779, -1.35494> , <1.19116e-007, 0.93555, 0.353193> }
	smooth_triangle { <-0.066089, 4.24779, -1.36364>, <-0.0914139, 0.93555, 0.341159>, <7.9275e-009, 4.26688, -1.42893>, <5.26765e-008, 0.976784, 0.214225>, <-0.0469395, 4.26688, -1.43511> , <-0.0554456, 0.976785, 0.206925> }
	smooth_triangle { <5.62527e-009, 4.27643, -1.4816>, <-5.59003e-008, 0.986874, 0.161495>, <-0.0469395, 4.26688, -1.43511>, <-0.0554456, 0.976785, 0.206925>, <7.9275e-009, 4.26688, -1.42893> , <5.26765e-008, 0.976784, 0.214225> }
	smooth_triangle { <-0.0469395, 4.26688, -1.43511>, <-0.0554456, 0.976785, 0.206925>, <5.62527e-009, 4.27643, -1.4816>, <-5.59003e-008, 0.986874, 0.161495>, <-0.0333078, 4.27643, -1.48598> , <-0.0417968, 0.986874, 0.155992> }
	smooth_triangle { <3.08791e-009, 4.28491, -1.53965>, <-1.58354e-008, 0.989488, 0.144618>, <-0.0333078, 4.27643, -1.48598>, <-0.0417968, 0.986874, 0.155992>, <5.62527e-009, 4.27643, -1.4816> , <-5.59003e-008, 0.986874, 0.161495> }
	smooth_triangle { <-0.0333078, 4.27643, -1.48598>, <-0.0417968, 0.986874, 0.155992>, <3.08791e-009, 4.28491, -1.53965>, <-1.58354e-008, 0.989488, 0.144618>, <-0.0182838, 4.28491, -1.54205> , <-0.037429, 0.989488, 0.13969> }
	smooth_triangle { <-0.0162996, 4.29552, -1.54946>, <-0.246218, 0.3083, 0.918873>, <3.08791e-009, 4.28491, -1.53965>, <1.91068e-007, 0.585797, 0.810458>, <2.75281e-009, 4.29552, -1.54731> , <1.10416e-007, 0.3083, 0.951289> }
	smooth_triangle { <3.08791e-009, 4.28491, -1.53965>, <1.91068e-007, 0.585797, 0.810458>, <-0.0162996, 4.29552, -1.54946>, <-0.246218, 0.3083, 0.918873>, <-0.0182838, 4.28491, -1.54205> , <-0.209769, 0.585797, 0.78284> }
	smooth_triangle { <-0.0162996, 4.30188, -1.54946>, <-0.258823, 0, 0.965925>, <2.75281e-009, 4.29552, -1.54731>, <1.10416e-007, 0.3083, 0.951289>, <2.75281e-009, 4.30188, -1.54731> , <2.25446e-008, 0, 1> }
	smooth_triangle { <2.75281e-009, 4.29552, -1.54731>, <1.10416e-007, 0.3083, 0.951289>, <-0.0162996, 4.30188, -1.54946>, <-0.258823, 0, 0.965925>, <-0.0162996, 4.29552, -1.54946> , <-0.246218, 0.3083, 0.918873> }
	smooth_triangle { <-0.0162996, 4.30931, -1.54946>, <-0.244853, 0.324093, 0.913789>, <2.75281e-009, 4.30188, -1.54731>, <2.25446e-008, 0, 1>, <2.75281e-009, 4.30931, -1.54731> , <-6.34353e-008, 0.324093, 0.946025> }
	smooth_triangle { <2.75281e-009, 4.30188, -1.54731>, <2.25446e-008, 0, 1>, <-0.0162996, 4.30931, -1.54946>, <-0.244853, 0.324093, 0.913789>, <-0.0162996, 4.30188, -1.54946> , <-0.258823, 0, 0.965925> }
	smooth_triangle { <-0.0145987, 4.31779, -1.55581>, <-0.158386, 0.790897, 0.591097>, <2.75281e-009, 4.30931, -1.54731>, <-6.34353e-008, 0.324093, 0.946025>, <2.46555e-009, 4.31779, -1.55388> , <-1.15815e-008, 0.790897, 0.611949> }
	smooth_triangle { <2.75281e-009, 4.30931, -1.54731>, <-6.34353e-008, 0.324093, 0.946025>, <-0.0145987, 4.31779, -1.55581>, <-0.158386, 0.790897, 0.591097>, <-0.0162996, 4.30931, -1.54946> , <-0.244853, 0.324093, 0.913789> }
	smooth_triangle { <2.03467e-009, 4.32203, -1.56374>, <7.78229e-009, 0.77348, 0.63382>, <-0.0145987, 4.31779, -1.55581>, <-0.158386, 0.790897, 0.591097>, <2.46555e-009, 4.31779, -1.55388> , <-1.15815e-008, 0.790897, 0.611949> }
	smooth_triangle { <-0.0145987, 4.31779, -1.55581>, <-0.158386, 0.790897, 0.591097>, <2.03467e-009, 4.32203, -1.56374>, <7.78229e-009, 0.77348, 0.63382>, <-0.0120475, 4.32203, -1.56533> , <-0.164044, 0.77348, 0.612224> }
	smooth_triangle { <-0.0109136, 4.3284, -1.56956>, <-0.23691, 0.402663, 0.884158>, <2.03467e-009, 4.32203, -1.56374>, <7.78229e-009, 0.77348, 0.63382>, <1.84317e-009, 4.3284, -1.56812> , <4.20115e-008, 0.402663, 0.915348> }
	smooth_triangle { <2.03467e-009, 4.32203, -1.56374>, <7.78229e-009, 0.77348, 0.63382>, <-0.0109136, 4.3284, -1.56956>, <-0.23691, 0.402663, 0.884158>, <-0.0120475, 4.32203, -1.56533> , <-0.164044, 0.77348, 0.612224> }
	smooth_triangle { <-0.0103467, 4.33794, -1.57168>, <-0.257392, 0.105025, 0.960583>, <1.84317e-009, 4.3284, -1.56812>, <4.20115e-008, 0.402663, 0.915348>, <1.74742e-009, 4.33794, -1.57031> , <9.46003e-008, 0.105025, 0.99447> }
	smooth_triangle { <1.84317e-009, 4.3284, -1.56812>, <4.20115e-008, 0.402663, 0.915348>, <-0.0103467, 4.33794, -1.57168>, <-0.257392, 0.105025, 0.960583>, <-0.0109136, 4.3284, -1.56956> , <-0.23691, 0.402663, 0.884158> }
	smooth_triangle { <1.98681e-009, 4.69858, -1.56484>, <-2.63601e-008, -0.0829348, 0.996555>, <-0.0103467, 4.33794, -1.57168>, <-0.257392, 0.105025, 0.960583>, <1.74742e-009, 4.33794, -1.57031> , <9.46003e-008, 0.105025, 0.99447> }
	smooth_triangle { <-0.0103467, 4.33794, -1.57168>, <-0.257392, 0.105025, 0.960583>, <1.98681e-009, 4.69858, -1.56484>, <-2.63601e-008, -0.0829348, 0.996555>, <-0.011764, 4.69858, -1.56639> , <-0.257929, -0.0829348, 0.962598> }
	smooth_triangle { <2.08254e-009, 4.71298, -1.56265>, <-2.03233e-007, -0.213314, 0.976984>, <-0.011764, 4.69858, -1.56639>, <-0.257929, -0.0829348, 0.962598>, <1.98681e-009, 4.69858, -1.56484> , <-2.63601e-008, -0.0829348, 0.996555> }
	smooth_triangle { <-0.011764, 4.69858, -1.56639>, <-0.257929, -0.0829348, 0.962598>, <2.08254e-009, 4.71298, -1.56265>, <-2.03233e-007, -0.213314, 0.976984>, <-0.0123309, 4.71298, -1.56427> , <-0.252854, -0.213314, 0.943696> }
	smooth_triangle { <2.41767e-009, 4.73974, -1.55498>, <-1.82213e-007, -0.311515, 0.950241>, <-0.0123309, 4.71298, -1.56427>, <-0.252854, -0.213314, 0.943696>, <2.08254e-009, 4.71298, -1.56265> , <-2.03233e-007, -0.213314, 0.976984> }
	smooth_triangle { <-0.0123309, 4.71298, -1.56427>, <-0.252854, -0.213314, 0.943696>, <2.41767e-009, 4.73974, -1.55498>, <-1.82213e-007, -0.311515, 0.950241>, <-0.0143152, 4.73974, -1.55686> , <-0.245932, -0.311516, 0.917864> }
	smooth_triangle { <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <-0.0143152, 4.73974, -1.55686>, <-0.245932, -0.311516, 0.917864>, <2.41767e-009, 4.73974, -1.55498> , <-1.82213e-007, -0.311515, 0.950241> }
	smooth_triangle { <-0.0143152, 4.73974, -1.55686>, <-0.245932, -0.311516, 0.917864>, <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <-0.016583, 4.76341, -1.5484> , <-0.215722, -0.552525, 0.805096> }
	smooth_triangle { <-0.0230892, 4.78708, -1.52412>, <-0.13603, -0.850741, 0.507676>, <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <3.89948e-009, 4.78708, -1.52108> , <1.15313e-007, -0.850741, 0.525585> }
	smooth_triangle { <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <-0.0230892, 4.78708, -1.52412>, <-0.13603, -0.850741, 0.507676>, <-0.016583, 4.76341, -1.5484> , <-0.215722, -0.552525, 0.805096> }
	smooth_triangle { <-0.0361402, 4.80561, -1.47541>, <-0.117457, -0.891097, 0.43835>, <3.89948e-009, 4.78708, -1.52108>, <1.15313e-007, -0.850741, 0.525585>, <6.10363e-009, 4.80561, -1.47066> , <-3.1762e-007, -0.891097, 0.453813> }
	smooth_triangle { <3.89948e-009, 4.78708, -1.52108>, <1.15313e-007, -0.850741, 0.525585>, <-0.0361402, 4.80561, -1.47541>, <-0.117457, -0.891097, 0.43835>, <-0.0230892, 4.78708, -1.52412> , <-0.13603, -0.850741, 0.507676> }
	smooth_triangle { <-0.0488648, 4.83854, -1.42792>, <-0.154031, -0.803632, 0.574848>, <6.10363e-009, 4.80561, -1.47066>, <-3.1762e-007, -0.891097, 0.453813>, <8.25269e-009, 4.83854, -1.42149> , <1.08486e-007, -0.803631, 0.595128> }
	smooth_triangle { <6.10363e-009, 4.80561, -1.47066>, <-3.1762e-007, -0.891097, 0.453813>, <-0.0488648, 4.83854, -1.42792>, <-0.154031, -0.803632, 0.574848>, <-0.0361402, 4.80561, -1.47541> , <-0.117457, -0.891097, 0.43835> }
	smooth_triangle { <-0.0570217, 4.86427, -1.39748>, <-0.185584, -0.697029, 0.69261>, <8.25269e-009, 4.83854, -1.42149>, <1.08486e-007, -0.803631, 0.595128>, <9.63027e-009, 4.86427, -1.38998> , <4.63306e-007, -0.697028, 0.717044> }
	smooth_triangle { <8.25269e-009, 4.83854, -1.42149>, <1.08486e-007, -0.803631, 0.595128>, <-0.0570217, 4.86427, -1.39748>, <-0.185584, -0.697029, 0.69261>, <-0.0488648, 4.83854, -1.42792> , <-0.154031, -0.803632, 0.574848> }
	smooth_triangle { <1.08426e-008, 4.90029, -1.36224>, <6.00858e-008, -0.557314, 0.830302>, <-0.0570217, 4.86427, -1.39748>, <-0.185584, -0.697029, 0.69261>, <9.63027e-009, 4.86427, -1.38998> , <4.63306e-007, -0.697028, 0.717044> }
	smooth_triangle { <-0.0570217, 4.86427, -1.39748>, <-0.185584, -0.697029, 0.69261>, <1.08426e-008, 4.90029, -1.36224>, <6.00858e-008, -0.557314, 0.830302>, <-0.0641997, 4.90029, -1.37069> , <-0.214901, -0.557314, 0.802009> }
	smooth_triangle { <1.17995e-008, 4.938, -1.34035>, <-3.7774e-009, -0.398844, 0.917019>, <-0.0641997, 4.90029, -1.37069>, <-0.214901, -0.557314, 0.802009>, <1.08426e-008, 4.90029, -1.36224> , <6.00858e-008, -0.557314, 0.830302> }
	smooth_triangle { <-0.0641997, 4.90029, -1.37069>, <-0.214901, -0.557314, 0.802009>, <1.17995e-008, 4.938, -1.34035>, <-3.7774e-009, -0.398844, 0.917019>, <-0.069866, 4.938, -1.34955> , <-0.237344, -0.398844, 0.885772> }
	smooth_triangle { <1.26362e-008, 5.00115, -1.32121>, <3.78445e-009, -0.170873, 0.985293>, <-0.069866, 4.938, -1.34955>, <-0.237344, -0.398844, 0.885772>, <1.17995e-008, 4.938, -1.34035> , <-3.7774e-009, -0.398844, 0.917019> }
	smooth_triangle { <-0.069866, 4.938, -1.34955>, <-0.237344, -0.398844, 0.885772>, <1.26362e-008, 5.00115, -1.32121>, <3.78445e-009, -0.170873, 0.985293>, <-0.0748199, 5.00115, -1.33106> , <-0.25501, -0.170873, 0.951721> }
	smooth_triangle { <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <-0.0748199, 5.00115, -1.33106>, <-0.25501, -0.170873, 0.951721>, <1.26362e-008, 5.00115, -1.32121> , <3.78445e-009, -0.170873, 0.985293> }
	smooth_triangle { <-0.0748199, 5.00115, -1.33106>, <-0.25501, -0.170873, 0.951721>, <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <-0.0759456, 5.08966, -1.32686> , <-0.258811, 0.00603508, 0.965909> }
	smooth_triangle { <-0.0743142, 5.19258, -1.33295>, <-0.257911, 0.0837969, 0.962528>, <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <1.25508e-008, 5.19258, -1.32316> , <7.51634e-009, 0.0837971, 0.996483> }
	smooth_triangle { <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <-0.0743142, 5.19258, -1.33295>, <-0.257911, 0.0837969, 0.962528>, <-0.0759456, 5.08966, -1.32686> , <-0.258811, 0.00603508, 0.965909> }
	smooth_triangle { <-0.0713778, 5.29859, -1.34391>, <-0.25722, 0.111143, 0.95994>, <1.25508e-008, 5.19258, -1.32316>, <7.51634e-009, 0.0837971, 0.996483>, <1.20548e-008, 5.29859, -1.33451> , <-7.13846e-008, 0.111144, 0.993804> }
	smooth_triangle { <1.25508e-008, 5.19258, -1.32316>, <7.51634e-009, 0.0837971, 0.996483>, <-0.0713778, 5.29859, -1.34391>, <-0.25722, 0.111143, 0.95994>, <-0.0743142, 5.19258, -1.33295> , <-0.257911, 0.0837969, 0.962528> }
	smooth_triangle { <-0.0694202, 5.36342, -1.35121>, <-0.257077, 0.115859, 0.959421>, <1.20548e-008, 5.29859, -1.33451>, <-7.13846e-008, 0.111144, 0.993804>, <1.17242e-008, 5.36342, -1.34207> , <-1.72822e-007, 0.115859, 0.993266> }
	smooth_triangle { <1.20548e-008, 5.29859, -1.33451>, <-7.13846e-008, 0.111144, 0.993804>, <-0.0694202, 5.36342, -1.35121>, <-0.257077, 0.115859, 0.959421>, <-0.0713778, 5.29859, -1.34391> , <-0.25722, 0.111143, 0.95994> }
	smooth_triangle { <-0.0664837, 5.44988, -1.36217>, <-0.256144, 0.143628, 0.955909>, <1.17242e-008, 5.36342, -1.34207>, <2.47956e-007, 0.130122, 0.991498>, <1.12283e-008, 5.44988, -1.35342> , <1.6907e-007, 0.143628, 0.989632> }
	smooth_triangle { <1.17242e-008, 5.36342, -1.34207>, <2.47956e-007, 0.130122, 0.991498>, <-0.0664837, 5.44988, -1.36217>, <-0.256144, 0.143628, 0.955909>, <-0.0694202, 5.36342, -1.35121> , <-0.25663, 0.130122, 0.95771> }
	smooth_triangle { <-0.063221, 5.52912, -1.37435>, <-0.254997, 0.171153, 0.951674>, <1.12283e-008, 5.44988, -1.35342>, <1.6907e-007, 0.143628, 0.989632>, <1.06772e-008, 5.52912, -1.36602> , <-2.02871e-007, 0.171153, 0.985245> }
	smooth_triangle { <1.12283e-008, 5.44988, -1.35342>, <1.6907e-007, 0.143628, 0.989632>, <-0.063221, 5.52912, -1.37435>, <-0.254997, 0.171153, 0.951674>, <-0.0664837, 5.44988, -1.36217> , <-0.256144, 0.143628, 0.955909> }
	smooth_triangle { <-0.0612633, 5.56926, -1.38165>, <-0.254333, 0.185165, 0.949225>, <1.06772e-008, 5.52912, -1.36602>, <-2.02871e-007, 0.171153, 0.985245>, <1.03466e-008, 5.56926, -1.37359> , <-4.8081e-007, 0.185164, 0.982708> }
	smooth_triangle { <1.06772e-008, 5.52912, -1.36602>, <-2.02871e-007, 0.171153, 0.985245>, <-0.0612633, 5.56926, -1.38165>, <-0.254333, 0.185165, 0.949225>, <-0.063221, 5.52912, -1.37435> , <-0.254997, 0.171153, 0.951674> }
	smooth_triangle { <1.00711e-008, 5.56926, -1.37989>, <4.17004e-006, 0.9813, -0.192486>, <-0.0612633, 5.56926, -1.38165>, <0, 1, 0>, <1.03466e-008, 5.56926, -1.37359> , <0, 1, 0> }
	smooth_triangle { <-0.0612633, 5.56926, -1.38165>, <0, 1, 0>, <1.00711e-008, 5.56926, -1.37989>, <4.17004e-006, 0.9813, -0.192486>, <-0.059632, 5.56926, -1.38774> , <0.0498156, 0.9813, -0.185929> }
	smooth_triangle { <9.8507e-009, 5.5672, -1.38493>, <8.18899e-006, 0.925806, -0.377998>, <-0.059632, 5.56926, -1.38774>, <0.0498156, 0.9813, -0.185929>, <1.00711e-008, 5.56926, -1.37989> , <4.17004e-006, 0.9813, -0.192486> }
	smooth_triangle { <-0.059632, 5.56926, -1.38774>, <0.0498156, 0.9813, -0.185929>, <9.8507e-009, 5.5672, -1.38493>, <8.18899e-006, 0.925806, -0.377998>, <-0.0583268, 5.5672, -1.39261> , <0.0978263, 0.925806, -0.365121> }
	smooth_triangle { <-0.0580006, 5.55794, -1.39383>, <0.256452, 0.134894, -0.957098>, <9.8507e-009, 5.5672, -1.38493>, <-9.76784e-008, 0.134897, -0.99086>, <9.79558e-009, 5.55794, -1.38619> , <-9.76784e-008, 0.134897, -0.99086> }
	smooth_triangle { <9.8507e-009, 5.5672, -1.38493>, <-9.76784e-008, 0.134897, -0.99086>, <-0.0580006, 5.55794, -1.39383>, <0.256452, 0.134894, -0.957098>, <-0.0583268, 5.5672, -1.39261> , <0.256452, 0.134894, -0.957098> }
	smooth_triangle { <-0.0230892, 4.78708, -1.52412>, <-0.0369499, -0.989751, 0.137939>, <6.20965e-011, 4.77442, -1.60887>, <-1.52019e-006, -0.989754, 0.14278>, <3.89948e-009, 4.78708, -1.52108> , <-1.52019e-006, -0.989754, 0.14278> }
	smooth_triangle { <6.20965e-011, 4.77442, -1.60887>, <-1.52019e-006, -0.989754, 0.14278>, <-0.0230892, 4.78708, -1.52412>, <-0.0369499, -0.989751, 0.137939>, <-0.000367679, 4.77442, -1.60892> , <-0.0369499, -0.989751, 0.137939> }
	smooth_triangle { <8.00982e-011, 4.22409, -1.60846>, <2.27011e-008, -0.99959, -0.0286498>, <0.0761115, 4.21572, -1.32624>, <-0.00741704, -0.99959, -0.027673>, <1.28543e-008, 4.21572, -1.31622> , <2.27011e-008, -0.99959, -0.0286498> }
	smooth_triangle { <0.0761115, 4.21572, -1.32624>, <-0.00741704, -0.99959, -0.027673>, <8.00982e-011, 4.22409, -1.60846>, <2.27011e-008, -0.99959, -0.0286498>, <0.000474268, 4.22409, -1.60852> , <-0.00741704, -0.99959, -0.027673> }
	smooth_triangle { <0.0758259, 4.2287, -1.3273>, <0.257895, 0.0846629, 0.962456>, <1.28543e-008, 4.21572, -1.31622>, <1.42774e-007, 0.0847022, 0.996406>, <0.0761115, 4.21572, -1.32624> , <0.257895, 0.0846629, 0.962456> }
	smooth_triangle { <1.28543e-008, 4.21572, -1.31622>, <1.42774e-007, 0.0847022, 0.996406>, <0.0758259, 4.2287, -1.3273>, <0.257895, 0.0846629, 0.962456>, <1.28061e-008, 4.2287, -1.31732> , <1.42774e-007, 0.0847022, 0.996406> }
	smooth_triangle { <0.0758259, 4.2287, -1.3273>, <0.117116, 0.891761, 0.437087>, <1.11616e-008, 4.24779, -1.35494>, <1.19116e-007, 0.93555, 0.353193>, <1.28061e-008, 4.2287, -1.31732> , <3.5453e-008, 0.891759, 0.45251> }
	smooth_triangle { <1.11616e-008, 4.24779, -1.35494>, <1.19116e-007, 0.93555, 0.353193>, <0.0758259, 4.2287, -1.3273>, <0.117116, 0.891761, 0.437087>, <0.066089, 4.24779, -1.36364> , <0.0914131, 0.935551, 0.341157> }
	smooth_triangle { <0.066089, 4.24779, -1.36364>, <0.0914131, 0.935551, 0.341157>, <7.9275e-009, 4.26688, -1.42893>, <5.31427e-008, 0.976784, 0.214225>, <1.11616e-008, 4.24779, -1.35494> , <1.19116e-007, 0.93555, 0.353193> }
	smooth_triangle { <7.9275e-009, 4.26688, -1.42893>, <5.31427e-008, 0.976784, 0.214225>, <0.066089, 4.24779, -1.36364>, <0.0914131, 0.935551, 0.341157>, <0.0469395, 4.26688, -1.43511> , <0.0554458, 0.976784, 0.206926> }
	smooth_triangle { <0.0469395, 4.26688, -1.43511>, <0.0554458, 0.976784, 0.206926>, <5.62527e-009, 4.27643, -1.4816>, <-5.54344e-008, 0.986874, 0.161495>, <7.9275e-009, 4.26688, -1.42893> , <5.31427e-008, 0.976784, 0.214225> }
	smooth_triangle { <5.62527e-009, 4.27643, -1.4816>, <-5.54344e-008, 0.986874, 0.161495>, <0.0469395, 4.26688, -1.43511>, <0.0554458, 0.976784, 0.206926>, <0.0333078, 4.27643, -1.48598> , <0.0417967, 0.986874, 0.155991> }
	smooth_triangle { <0.0333078, 4.27643, -1.48598>, <0.0417967, 0.986874, 0.155991>, <3.08791e-009, 4.28491, -1.53965>, <-1.58354e-008, 0.989488, 0.144618>, <5.62527e-009, 4.27643, -1.4816> , <-5.54344e-008, 0.986874, 0.161495> }
	smooth_triangle { <3.08791e-009, 4.28491, -1.53965>, <-1.58354e-008, 0.989488, 0.144618>, <0.0333078, 4.27643, -1.48598>, <0.0417967, 0.986874, 0.155991>, <0.0182838, 4.28491, -1.54205> , <0.0374288, 0.989488, 0.139689> }
	smooth_triangle { <0.0162996, 4.29552, -1.54946>, <0.246217, 0.308297, 0.918875>, <3.08791e-009, 4.28491, -1.53965>, <1.91068e-007, 0.585797, 0.810458>, <0.0182838, 4.28491, -1.54205> , <0.20977, 0.585791, 0.782845> }
	smooth_triangle { <3.08791e-009, 4.28491, -1.53965>, <1.91068e-007, 0.585797, 0.810458>, <0.0162996, 4.29552, -1.54946>, <0.246217, 0.308297, 0.918875>, <2.75281e-009, 4.29552, -1.54731> , <1.10416e-007, 0.3083, 0.951289> }
	smooth_triangle { <2.75281e-009, 4.30188, -1.54731>, <2.25446e-008, 0, 1>, <0.0162996, 4.29552, -1.54946>, <0.246217, 0.308297, 0.918875>, <0.0162996, 4.30188, -1.54946> , <0.258821, 0, 0.965925> }
	smooth_triangle { <0.0162996, 4.29552, -1.54946>, <0.246217, 0.308297, 0.918875>, <2.75281e-009, 4.30188, -1.54731>, <2.25446e-008, 0, 1>, <2.75281e-009, 4.29552, -1.54731> , <1.12388e-007, 0.3083, 0.951289> }
	smooth_triangle { <2.75281e-009, 4.30931, -1.54731>, <-6.1453e-008, 0.324093, 0.946025>, <0.0162996, 4.30188, -1.54946>, <0.258821, 0, 0.965925>, <0.0162996, 4.30931, -1.54946> , <0.244851, 0.324094, 0.91379> }
	smooth_triangle { <0.0162996, 4.30188, -1.54946>, <0.258821, 0, 0.965925>, <2.75281e-009, 4.30931, -1.54731>, <-6.1453e-008, 0.324093, 0.946025>, <2.75281e-009, 4.30188, -1.54731> , <2.25446e-008, 0, 1> }
	smooth_triangle { <0.0145987, 4.31779, -1.55581>, <0.158386, 0.790897, 0.591097>, <2.75281e-009, 4.30931, -1.54731>, <-6.34353e-008, 0.324093, 0.946025>, <0.0162996, 4.30931, -1.54946> , <0.244851, 0.324094, 0.91379> }
	smooth_triangle { <2.75281e-009, 4.30931, -1.54731>, <-6.34353e-008, 0.324093, 0.946025>, <0.0145987, 4.31779, -1.55581>, <0.158386, 0.790897, 0.591097>, <2.46555e-009, 4.31779, -1.55388> , <-1.06164e-008, 0.790897, 0.611949> }
	smooth_triangle { <0.0145987, 4.31779, -1.55581>, <0.158386, 0.790897, 0.591097>, <2.03467e-009, 4.32203, -1.56374>, <7.78229e-009, 0.77348, 0.63382>, <2.46555e-009, 4.31779, -1.55388> , <-1.15815e-008, 0.790897, 0.611949> }
	smooth_triangle { <2.03467e-009, 4.32203, -1.56374>, <7.78229e-009, 0.77348, 0.63382>, <0.0145987, 4.31779, -1.55581>, <0.158386, 0.790897, 0.591097>, <0.0120475, 4.32203, -1.56533> , <0.164043, 0.773483, 0.61222> }
	smooth_triangle { <0.0109136, 4.3284, -1.56956>, <0.236911, 0.402668, 0.884156>, <2.03467e-009, 4.32203, -1.56374>, <8.75507e-009, 0.77348, 0.63382>, <0.0120475, 4.32203, -1.56533> , <0.164043, 0.773483, 0.61222> }
	smooth_triangle { <2.03467e-009, 4.32203, -1.56374>, <8.75507e-009, 0.77348, 0.63382>, <0.0109136, 4.3284, -1.56956>, <0.236911, 0.402668, 0.884156>, <1.84317e-009, 4.3284, -1.56812> , <4.20115e-008, 0.402663, 0.915348> }
	smooth_triangle { <0.0103467, 4.33794, -1.57168>, <0.257394, 0.105024, 0.960582>, <1.84317e-009, 4.3284, -1.56812>, <4.01019e-008, 0.402663, 0.915348>, <0.0109136, 4.3284, -1.56956> , <0.236911, 0.402668, 0.884156> }
	smooth_triangle { <1.84317e-009, 4.3284, -1.56812>, <4.01019e-008, 0.402663, 0.915348>, <0.0103467, 4.33794, -1.57168>, <0.257394, 0.105024, 0.960582>, <1.74742e-009, 4.33794, -1.57031> , <9.83843e-008, 0.105025, 0.99447> }
	smooth_triangle { <1.98681e-009, 4.69858, -1.56484>, <-2.63601e-008, -0.0829348, 0.996555>, <0.0103467, 4.33794, -1.57168>, <0.257394, 0.105024, 0.960582>, <0.011764, 4.69858, -1.56639> , <0.257929, -0.0829404, 0.962597> }
	smooth_triangle { <0.0103467, 4.33794, -1.57168>, <0.257394, 0.105024, 0.960582>, <1.98681e-009, 4.69858, -1.56484>, <-2.63601e-008, -0.0829348, 0.996555>, <1.74742e-009, 4.33794, -1.57031> , <9.83843e-008, 0.105025, 0.99447> }
	smooth_triangle { <2.08254e-009, 4.71298, -1.56265>, <-2.03233e-007, -0.213314, 0.976984>, <0.011764, 4.69858, -1.56639>, <0.257929, -0.0829404, 0.962597>, <0.012331, 4.71298, -1.56427> , <0.252855, -0.213317, 0.943695> }
	smooth_triangle { <0.011764, 4.69858, -1.56639>, <0.257929, -0.0829404, 0.962597>, <2.08254e-009, 4.71298, -1.56265>, <-2.03233e-007, -0.213314, 0.976984>, <1.98681e-009, 4.69858, -1.56484> , <-2.63601e-008, -0.0829348, 0.996555> }
	smooth_triangle { <2.41767e-009, 4.73974, -1.55498>, <-1.80334e-007, -0.311515, 0.950241>, <0.012331, 4.71298, -1.56427>, <0.252855, -0.213317, 0.943695>, <0.0143152, 4.73974, -1.55686> , <0.245933, -0.311514, 0.917865> }
	smooth_triangle { <0.012331, 4.71298, -1.56427>, <0.252855, -0.213317, 0.943695>, <2.41767e-009, 4.73974, -1.55498>, <-1.80334e-007, -0.311515, 0.950241>, <2.08254e-009, 4.71298, -1.56265> , <-2.03233e-007, -0.213314, 0.976984> }
	smooth_triangle { <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <0.0143152, 4.73974, -1.55686>, <0.245933, -0.311514, 0.917865>, <0.016583, 4.76341, -1.5484> , <0.215722, -0.552524, 0.805097> }
	smooth_triangle { <0.0143152, 4.73974, -1.55686>, <0.245933, -0.311514, 0.917865>, <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <2.41767e-009, 4.73974, -1.55498> , <-1.80334e-007, -0.311515, 0.950241> }
	smooth_triangle { <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <0.0230892, 4.78708, -1.52412>, <0.136031, -0.85074, 0.507678>, <3.89948e-009, 4.78708, -1.52108> , <1.13407e-007, -0.850741, 0.525585> }
	smooth_triangle { <0.0230892, 4.78708, -1.52412>, <0.136031, -0.85074, 0.507678>, <2.80068e-009, 4.76341, -1.54622>, <1.15462e-007, -0.552525, 0.833497>, <0.016583, 4.76341, -1.5484> , <0.215722, -0.552524, 0.805097> }
	smooth_triangle { <3.89948e-009, 4.78708, -1.52108>, <1.12454e-007, -0.850741, 0.525585>, <0.0361402, 4.80561, -1.47541>, <0.117457, -0.891098, 0.438348>, <6.10363e-009, 4.80561, -1.47066> , <-3.1762e-007, -0.891097, 0.453813> }
	smooth_triangle { <0.0361402, 4.80561, -1.47541>, <0.117457, -0.891098, 0.438348>, <3.89948e-009, 4.78708, -1.52108>, <1.12454e-007, -0.850741, 0.525585>, <0.0230892, 4.78708, -1.52412> , <0.136031, -0.85074, 0.507678> }
	smooth_triangle { <6.10363e-009, 4.80561, -1.47066>, <-3.1856e-007, -0.891097, 0.453813>, <0.048865, 4.83854, -1.42792>, <0.154031, -0.803632, 0.574847>, <8.25269e-009, 4.83854, -1.42149> , <1.10356e-007, -0.803631, 0.595128> }
	smooth_triangle { <0.048865, 4.83854, -1.42792>, <0.154031, -0.803632, 0.574847>, <6.10363e-009, 4.80561, -1.47066>, <-3.1856e-007, -0.891097, 0.453813>, <0.0361402, 4.80561, -1.47541> , <0.117457, -0.891098, 0.438348> }
	smooth_triangle { <8.25269e-009, 4.83854, -1.42149>, <1.10356e-007, -0.803631, 0.595128>, <0.0570217, 4.86427, -1.39748>, <0.185585, -0.697025, 0.692614>, <9.63027e-009, 4.86427, -1.38998> , <4.61422e-007, -0.697028, 0.717044> }
	smooth_triangle { <0.0570217, 4.86427, -1.39748>, <0.185585, -0.697025, 0.692614>, <8.25269e-009, 4.83854, -1.42149>, <1.10356e-007, -0.803631, 0.595128>, <0.048865, 4.83854, -1.42792> , <0.154031, -0.803632, 0.574847> }
	smooth_triangle { <1.08426e-008, 4.90029, -1.36224>, <6.00858e-008, -0.557314, 0.830302>, <0.0570217, 4.86427, -1.39748>, <0.185585, -0.697025, 0.692614>, <0.0641997, 4.90029, -1.37069> , <0.2149, -0.557317, 0.802007> }
	smooth_triangle { <0.0570217, 4.86427, -1.39748>, <0.185585, -0.697025, 0.692614>, <1.08426e-008, 4.90029, -1.36224>, <6.00858e-008, -0.557314, 0.830302>, <9.63027e-009, 4.86427, -1.38998> , <4.61422e-007, -0.697028, 0.717044> }
	smooth_triangle { <1.17995e-008, 4.938, -1.34035>, <-3.7774e-009, -0.398844, 0.917019>, <0.0641997, 4.90029, -1.37069>, <0.2149, -0.557317, 0.802007>, <0.069866, 4.938, -1.34955> , <0.237342, -0.39885, 0.885769> }
	smooth_triangle { <0.0641997, 4.90029, -1.37069>, <0.2149, -0.557317, 0.802007>, <1.17995e-008, 4.938, -1.34035>, <-3.7774e-009, -0.398844, 0.917019>, <1.08426e-008, 4.90029, -1.36224> , <6.00858e-008, -0.557314, 0.830302> }
	smooth_triangle { <1.26362e-008, 5.00115, -1.32121>, <0, -0.170873, 0.985293>, <0.069866, 4.938, -1.34955>, <0.237342, -0.39885, 0.885769>, <0.0748199, 5.00115, -1.33106> , <0.25501, -0.170873, 0.951721> }
	smooth_triangle { <0.069866, 4.938, -1.34955>, <0.237342, -0.39885, 0.885769>, <1.26362e-008, 5.00115, -1.32121>, <0, -0.170873, 0.985293>, <1.17995e-008, 4.938, -1.34035> , <-5.6661e-009, -0.398844, 0.917019> }
	smooth_triangle { <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <0.0748199, 5.00115, -1.33106>, <0.25501, -0.170873, 0.951721>, <0.0759456, 5.08966, -1.32686> , <0.258811, 0.00603943, 0.965909> }
	smooth_triangle { <0.0748199, 5.00115, -1.33106>, <0.25501, -0.170873, 0.951721>, <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <1.26362e-008, 5.00115, -1.32121> , <0, -0.170873, 0.985293> }
	smooth_triangle { <0.0743143, 5.19258, -1.33295>, <0.257911, 0.0837985, 0.962528>, <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <0.0759456, 5.08966, -1.32686> , <0.258811, 0.00603943, 0.965909> }
	smooth_triangle { <1.28263e-008, 5.08966, -1.31686>, <1.88153e-008, 0.00603521, 0.999982>, <0.0743143, 5.19258, -1.33295>, <0.257911, 0.0837985, 0.962528>, <1.25508e-008, 5.19258, -1.32316> , <7.51634e-009, 0.0837971, 0.996483> }
	smooth_triangle { <0.0713778, 5.29859, -1.34391>, <0.25722, 0.111145, 0.95994>, <1.25508e-008, 5.19258, -1.32316>, <7.51634e-009, 0.0837971, 0.996483>, <0.0743143, 5.19258, -1.33295> , <0.257911, 0.0837985, 0.962528> }
	smooth_triangle { <1.25508e-008, 5.19258, -1.32316>, <7.51634e-009, 0.0837971, 0.996483>, <0.0713778, 5.29859, -1.34391>, <0.25722, 0.111145, 0.95994>, <1.20548e-008, 5.29859, -1.33451> , <-7.51417e-008, 0.111144, 0.993804> }
	smooth_triangle { <0.0694202, 5.36342, -1.35121>, <0.257077, 0.115867, 0.95942>, <1.20548e-008, 5.29859, -1.33451>, <-7.51417e-008, 0.111144, 0.993804>, <0.0713778, 5.29859, -1.34391> , <0.25722, 0.111145, 0.95994> }
	smooth_triangle { <1.20548e-008, 5.29859, -1.33451>, <-7.51417e-008, 0.111144, 0.993804>, <0.0694202, 5.36342, -1.35121>, <0.257077, 0.115867, 0.95942>, <1.17242e-008, 5.36342, -1.34207> , <-1.72822e-007, 0.115859, 0.993266> }
	smooth_triangle { <0.0664837, 5.44988, -1.36217>, <0.256141, 0.14362, 0.95591>, <1.17242e-008, 5.36342, -1.34207>, <2.47956e-007, 0.130122, 0.991498>, <0.0694202, 5.36342, -1.35121> , <0.256627, 0.130116, 0.957712> }
	smooth_triangle { <1.17242e-008, 5.36342, -1.34207>, <2.47956e-007, 0.130122, 0.991498>, <0.0664837, 5.44988, -1.36217>, <0.256141, 0.14362, 0.95591>, <1.12283e-008, 5.44988, -1.35342> , <1.65313e-007, 0.143628, 0.989632> }
	smooth_triangle { <0.063221, 5.52912, -1.37435>, <0.254996, 0.171154, 0.951674>, <1.12283e-008, 5.44988, -1.35342>, <1.65313e-007, 0.143628, 0.989632>, <0.0664837, 5.44988, -1.36217> , <0.256141, 0.14362, 0.95591> }
	smooth_triangle { <1.12283e-008, 5.44988, -1.35342>, <1.65313e-007, 0.143628, 0.989632>, <0.063221, 5.52912, -1.37435>, <0.254996, 0.171154, 0.951674>, <1.06772e-008, 5.52912, -1.36602> , <-1.99114e-007, 0.171153, 0.985245> }
	smooth_triangle { <0.0612633, 5.56926, -1.38165>, <0.254333, 0.185175, 0.949223>, <1.06772e-008, 5.52912, -1.36602>, <-1.99114e-007, 0.171153, 0.985245>, <0.063221, 5.52912, -1.37435> , <0.254996, 0.171154, 0.951674> }
	smooth_triangle { <1.06772e-008, 5.52912, -1.36602>, <-1.99114e-007, 0.171153, 0.985245>, <0.0612633, 5.56926, -1.38165>, <0.254333, 0.185175, 0.949223>, <1.03466e-008, 5.56926, -1.37359> , <-4.8081e-007, 0.185164, 0.982708> }
	smooth_triangle { <0.0612633, 5.56926, -1.38165>, <0, 1, 0>, <1.00711e-008, 5.56926, -1.37989>, <4.17004e-006, 0.9813, -0.192486>, <1.03466e-008, 5.56926, -1.37359> , <0, 1, 0> }
	smooth_triangle { <1.00711e-008, 5.56926, -1.37989>, <4.17004e-006, 0.9813, -0.192486>, <0.0612633, 5.56926, -1.38165>, <0, 1, 0>, <0.059632, 5.56926, -1.38774> , <-0.0498257, 0.981299, -0.185932> }
	smooth_triangle { <0.059632, 5.56926, -1.38774>, <-0.0498257, 0.981299, -0.185932>, <9.8507e-009, 5.5672, -1.38493>, <8.18899e-006, 0.925806, -0.377998>, <1.00711e-008, 5.56926, -1.37989> , <4.17004e-006, 0.9813, -0.192486> }
	smooth_triangle { <9.8507e-009, 5.5672, -1.38493>, <8.18899e-006, 0.925806, -0.377998>, <0.059632, 5.56926, -1.38774>, <-0.0498257, 0.981299, -0.185932>, <0.0583268, 5.5672, -1.39261> , <-0.097846, 0.925802, -0.365127> }
	smooth_triangle { <0.0580006, 5.55794, -1.39383>, <-0.256449, 0.134954, -0.95709>, <9.8507e-009, 5.5672, -1.38493>, <-9.76784e-008, 0.134897, -0.99086>, <0.0583268, 5.5672, -1.39261> , <-0.256449, 0.134954, -0.95709> }
	smooth_triangle { <9.8507e-009, 5.5672, -1.38493>, <-9.76784e-008, 0.134897, -0.99086>, <0.0580006, 5.55794, -1.39383>, <-0.256449, 0.134954, -0.95709>, <9.79558e-009, 5.55794, -1.38619> , <-9.76784e-008, 0.134897, -0.99086> }
	smooth_triangle { <6.20965e-011, 4.77442, -1.60887>, <-1.52019e-006, -0.989754, 0.14278>, <0.0230892, 4.78708, -1.52412>, <0.0369538, -0.989751, 0.137941>, <3.89948e-009, 4.78708, -1.52108> , <-1.52019e-006, -0.989754, 0.14278> }
	smooth_triangle { <0.0230892, 4.78708, -1.52412>, <0.0369538, -0.989751, 0.137941>, <6.20965e-011, 4.77442, -1.60887>, <-1.52019e-006, -0.989754, 0.14278>, <0.000367679, 4.77442, -1.60892> , <0.0369538, -0.989751, 0.137941> }
	smooth_triangle { <0.000474268, 4.22409, -1.60852>, <-0.00741704, -0.99959, -0.027673>, <0.147036, 4.21572, -1.35562>, <-0.0143243, -0.99959, -0.0248127>, <0.0761115, 4.21572, -1.32624> , <-0.00741704, -0.99959, -0.027673> }
	smooth_triangle { <0.147036, 4.21572, -1.35562>, <-0.0143243, -0.99959, -0.0248127>, <0.000474268, 4.22409, -1.60852>, <-0.00741704, -0.99959, -0.027673>, <0.000916218, 4.22409, -1.6087> , <-0.0143243, -0.99959, -0.0248127> }
	smooth_triangle { <0.146484, 4.2287, -1.35657>, <0.498199, 0.0846955, 0.862916>, <0.0761115, 4.21572, -1.32624>, <0.257895, 0.0846629, 0.962456>, <0.147036, 4.21572, -1.35562> , <0.498199, 0.0846955, 0.862916> }
	smooth_triangle { <0.0761115, 4.21572, -1.32624>, <0.257895, 0.0846629, 0.962456>, <0.146484, 4.2287, -1.35657>, <0.498199, 0.0846955, 0.862916>, <0.0758259, 4.2287, -1.3273> , <0.257895, 0.0846629, 0.962456> }
	smooth_triangle { <0.146484, 4.2287, -1.35657>, <0.226254, 0.891761, 0.391882>, <0.066089, 4.24779, -1.36364>, <0.0914131, 0.935551, 0.341157>, <0.0758259, 4.2287, -1.3273> , <0.117116, 0.891761, 0.437087> }
	smooth_triangle { <0.066089, 4.24779, -1.36364>, <0.0914131, 0.935551, 0.341157>, <0.146484, 4.2287, -1.35657>, <0.226254, 0.891761, 0.391882>, <0.127674, 4.24779, -1.38915> , <0.176596, 0.935551, 0.305874> }
	smooth_triangle { <0.127674, 4.24779, -1.38915>, <0.176596, 0.935551, 0.305874>, <0.0469395, 4.26688, -1.43511>, <0.0554458, 0.976784, 0.206926>, <0.066089, 4.24779, -1.36364> , <0.0914131, 0.935551, 0.341157> }
	smooth_triangle { <0.0469395, 4.26688, -1.43511>, <0.0554458, 0.976784, 0.206926>, <0.127674, 4.24779, -1.38915>, <0.176596, 0.935551, 0.305874>, <0.0906802, 4.26688, -1.45323> , <0.107113, 0.976784, 0.185525> }
	smooth_triangle { <0.0906802, 4.26688, -1.45323>, <0.107113, 0.976784, 0.185525>, <0.0333078, 4.27643, -1.48598>, <0.0417967, 0.986874, 0.155991>, <0.0469395, 4.26688, -1.43511> , <0.0554458, 0.976784, 0.206926> }
	smooth_triangle { <0.0333078, 4.27643, -1.48598>, <0.0417967, 0.986874, 0.155991>, <0.0906802, 4.26688, -1.45323>, <0.107113, 0.976784, 0.185525>, <0.0643457, 4.27643, -1.49884> , <0.0807474, 0.986874, 0.139858> }
	smooth_triangle { <0.0643457, 4.27643, -1.49884>, <0.0807474, 0.986874, 0.139858>, <0.0182838, 4.28491, -1.54205>, <0.0374288, 0.989488, 0.139689>, <0.0333078, 4.27643, -1.48598> , <0.0417967, 0.986874, 0.155991> }
	smooth_triangle { <0.0182838, 4.28491, -1.54205>, <0.0374288, 0.989488, 0.139689>, <0.0643457, 4.27643, -1.49884>, <0.0807474, 0.986874, 0.139858>, <0.0353216, 4.28491, -1.54911> , <0.0723078, 0.989488, 0.125242> }
	smooth_triangle { <0.0314885, 4.29552, -1.55575>, <0.475645, 0.308293, 0.823843>, <0.0182838, 4.28491, -1.54205>, <0.20977, 0.585791, 0.782845>, <0.0353216, 4.28491, -1.54911> , <0.405234, 0.585785, 0.701884> }
	smooth_triangle { <0.0182838, 4.28491, -1.54205>, <0.20977, 0.585791, 0.782845>, <0.0314885, 4.29552, -1.55575>, <0.475645, 0.308293, 0.823843>, <0.0162996, 4.29552, -1.54946> , <0.246217, 0.308297, 0.918875> }
	smooth_triangle { <0.0162996, 4.30188, -1.54946>, <0.258821, 0, 0.965925>, <0.0314885, 4.29552, -1.55575>, <0.475645, 0.308293, 0.823843>, <0.0314885, 4.30188, -1.55575> , <0.499997, 0, 0.866027> }
	smooth_triangle { <0.0314885, 4.29552, -1.55575>, <0.475645, 0.308293, 0.823843>, <0.0162996, 4.30188, -1.54946>, <0.258821, 0, 0.965925>, <0.0162996, 4.29552, -1.54946> , <0.246217, 0.308297, 0.918875> }
	smooth_triangle { <0.0162996, 4.30931, -1.54946>, <0.244851, 0.324094, 0.91379>, <0.0314885, 4.30188, -1.55575>, <0.499997, 0, 0.866027>, <0.0314885, 4.30931, -1.55575> , <0.473009, 0.324097, 0.819282> }
	smooth_triangle { <0.0314885, 4.30188, -1.55575>, <0.499997, 0, 0.866027>, <0.0162996, 4.30931, -1.54946>, <0.244851, 0.324094, 0.91379>, <0.0162996, 4.30188, -1.54946> , <0.258821, 0, 0.965925> }
	smooth_triangle { <0.0282025, 4.31779, -1.56144>, <0.305972, 0.790899, 0.529962>, <0.0162996, 4.30931, -1.54946>, <0.244851, 0.324094, 0.91379>, <0.0314885, 4.30931, -1.55575> , <0.473009, 0.324097, 0.819282> }
	smooth_triangle { <0.0162996, 4.30931, -1.54946>, <0.244851, 0.324094, 0.91379>, <0.0282025, 4.31779, -1.56144>, <0.305972, 0.790899, 0.529962>, <0.0145987, 4.31779, -1.55581> , <0.158386, 0.790897, 0.591097> }
	smooth_triangle { <0.0282025, 4.31779, -1.56144>, <0.305972, 0.790899, 0.529962>, <0.0120475, 4.32203, -1.56533>, <0.164043, 0.773483, 0.61222>, <0.0145987, 4.31779, -1.55581> , <0.158386, 0.790897, 0.591097> }
	smooth_triangle { <0.0120475, 4.32203, -1.56533>, <0.164043, 0.773483, 0.61222>, <0.0282025, 4.31779, -1.56144>, <0.305972, 0.790899, 0.529962>, <0.023274, 4.32203, -1.56998> , <0.31691, 0.773484, 0.548899> }
	smooth_triangle { <0.0210834, 4.3284, -1.57377>, <0.457677, 0.402668, 0.79271>, <0.0120475, 4.32203, -1.56533>, <0.164043, 0.773483, 0.61222>, <0.023274, 4.32203, -1.56998> , <0.31691, 0.773484, 0.548899> }
	smooth_triangle { <0.0120475, 4.32203, -1.56533>, <0.164043, 0.773483, 0.61222>, <0.0210834, 4.3284, -1.57377>, <0.457677, 0.402668, 0.79271>, <0.0109136, 4.3284, -1.56956> , <0.236911, 0.402668, 0.884156> }
	smooth_triangle { <0.0199882, 4.33794, -1.57567>, <0.49724, 0.105024, 0.861233>, <0.0109136, 4.3284, -1.56956>, <0.236911, 0.402668, 0.884156>, <0.0210834, 4.3284, -1.57377> , <0.457677, 0.402668, 0.79271> }
	smooth_triangle { <0.0109136, 4.3284, -1.56956>, <0.236911, 0.402668, 0.884156>, <0.0199882, 4.33794, -1.57567>, <0.49724, 0.105024, 0.861233>, <0.0103467, 4.33794, -1.57168> , <0.257394, 0.105024, 0.960582> }
	smooth_triangle { <0.011764, 4.69858, -1.56639>, <0.257929, -0.0829404, 0.962597>, <0.0199882, 4.33794, -1.57567>, <0.49724, 0.105024, 0.861233>, <0.0227263, 4.69858, -1.57093> , <0.49828, -0.0829402, 0.86304> }
	smooth_triangle { <0.0199882, 4.33794, -1.57567>, <0.49724, 0.105024, 0.861233>, <0.011764, 4.69858, -1.56639>, <0.257929, -0.0829404, 0.962597>, <0.0103467, 4.33794, -1.57168> , <0.257394, 0.105024, 0.960582> }
	smooth_triangle { <0.012331, 4.71298, -1.56427>, <0.252855, -0.213317, 0.943695>, <0.0227263, 4.69858, -1.57093>, <0.49828, -0.0829402, 0.86304>, <0.0238215, 4.71298, -1.56903> , <0.488492, -0.213318, 0.846092> }
	smooth_triangle { <0.0227263, 4.69858, -1.57093>, <0.49828, -0.0829402, 0.86304>, <0.012331, 4.71298, -1.56427>, <0.252855, -0.213317, 0.943695>, <0.011764, 4.69858, -1.56639> , <0.257929, -0.0829404, 0.962597> }
	smooth_triangle { <0.0143152, 4.73974, -1.55686>, <0.245933, -0.311514, 0.917865>, <0.0238215, 4.71298, -1.56903>, <0.488492, -0.213318, 0.846092>, <0.027655, 4.73974, -1.56239> , <0.47512, -0.311515, 0.822933> }
	smooth_triangle { <0.0238215, 4.71298, -1.56903>, <0.488492, -0.213318, 0.846092>, <0.0143152, 4.73974, -1.55686>, <0.245933, -0.311514, 0.917865>, <0.012331, 4.71298, -1.56427> , <0.252855, -0.213317, 0.943695> }
	smooth_triangle { <0.016583, 4.76341, -1.5484>, <0.215722, -0.552524, 0.805097>, <0.027655, 4.73974, -1.56239>, <0.47512, -0.311515, 0.822933>, <0.032036, 4.76341, -1.5548> , <0.416747, -0.552524, 0.72183> }
	smooth_triangle { <0.027655, 4.73974, -1.56239>, <0.47512, -0.311515, 0.822933>, <0.016583, 4.76341, -1.5484>, <0.215722, -0.552524, 0.805097>, <0.0143152, 4.73974, -1.55686> , <0.245933, -0.311514, 0.917865> }
	smooth_triangle { <0.016583, 4.76341, -1.5484>, <0.215722, -0.552524, 0.805097>, <0.0446049, 4.78708, -1.53303>, <0.262792, -0.85074, 0.455172>, <0.0230892, 4.78708, -1.52412> , <0.136031, -0.85074, 0.507678> }
	smooth_triangle { <0.0446049, 4.78708, -1.53303>, <0.262792, -0.85074, 0.455172>, <0.016583, 4.76341, -1.5484>, <0.215722, -0.552524, 0.805097>, <0.032036, 4.76341, -1.5548> , <0.416747, -0.552524, 0.72183> }
	smooth_triangle { <0.0230892, 4.78708, -1.52412>, <0.136031, -0.85074, 0.507678>, <0.0698173, 4.80561, -1.48936>, <0.226908, -0.891096, 0.393015>, <0.0361402, 4.80561, -1.47541> , <0.117457, -0.891098, 0.438348> }
	smooth_triangle { <0.0698173, 4.80561, -1.48936>, <0.226908, -0.891096, 0.393015>, <0.0230892, 4.78708, -1.52412>, <0.136031, -0.85074, 0.507678>, <0.0446049, 4.78708, -1.53303> , <0.262792, -0.85074, 0.455172> }
	smooth_triangle { <0.0361402, 4.80561, -1.47541>, <0.117457, -0.891098, 0.438348>, <0.0943997, 4.83854, -1.44679>, <0.297567, -0.803632, 0.515392>, <0.048865, 4.83854, -1.42792> , <0.154031, -0.803632, 0.574847> }
	smooth_triangle { <0.0943997, 4.83854, -1.44679>, <0.297567, -0.803632, 0.515392>, <0.0361402, 4.80561, -1.47541>, <0.117457, -0.891098, 0.438348>, <0.0698173, 4.80561, -1.48936> , <0.226908, -0.891096, 0.393015> }
	smooth_triangle { <0.048865, 4.83854, -1.42792>, <0.154031, -0.803632, 0.574847>, <0.110158, 4.86427, -1.41949>, <0.358524, -0.697032, 0.620972>, <0.0570217, 4.86427, -1.39748> , <0.185585, -0.697025, 0.692614> }
	smooth_triangle { <0.110158, 4.86427, -1.41949>, <0.358524, -0.697032, 0.620972>, <0.048865, 4.83854, -1.42792>, <0.154031, -0.803632, 0.574847>, <0.0943997, 4.83854, -1.44679> , <0.297567, -0.803632, 0.515392> }
	smooth_triangle { <0.0641997, 4.90029, -1.37069>, <0.2149, -0.557317, 0.802007>, <0.110158, 4.86427, -1.41949>, <0.358524, -0.697032, 0.620972>, <0.124024, 4.90029, -1.39547> , <0.41515, -0.557311, 0.719065> }
	smooth_triangle { <0.110158, 4.86427, -1.41949>, <0.358524, -0.697032, 0.620972>, <0.0641997, 4.90029, -1.37069>, <0.2149, -0.557317, 0.802007>, <0.0570217, 4.86427, -1.39748> , <0.185585, -0.697025, 0.692614> }
	smooth_triangle { <0.069866, 4.938, -1.34955>, <0.237342, -0.39885, 0.885769>, <0.124024, 4.90029, -1.39547>, <0.41515, -0.557311, 0.719065>, <0.134971, 4.938, -1.37651> , <0.458511, -0.398841, 0.794162> }
	smooth_triangle { <0.124024, 4.90029, -1.39547>, <0.41515, -0.557311, 0.719065>, <0.069866, 4.938, -1.34955>, <0.237342, -0.39885, 0.885769>, <0.0641997, 4.90029, -1.37069> , <0.2149, -0.557317, 0.802007> }
	smooth_triangle { <0.0748199, 5.00115, -1.33106>, <0.25501, -0.170873, 0.951721>, <0.134971, 4.938, -1.37651>, <0.458511, -0.398841, 0.794162>, <0.144541, 5.00115, -1.35994> , <0.49265, -0.170883, 0.853285> }
	smooth_triangle { <0.134971, 4.938, -1.37651>, <0.458511, -0.398841, 0.794162>, <0.0748199, 5.00115, -1.33106>, <0.25501, -0.170873, 0.951721>, <0.069866, 4.938, -1.34955> , <0.237342, -0.39885, 0.885769> }
	smooth_triangle { <0.0759456, 5.08966, -1.32686>, <0.258811, 0.00603942, 0.965909>, <0.144541, 5.00115, -1.35994>, <0.49265, -0.170883, 0.853285>, <0.146716, 5.08966, -1.35617> , <0.499987, 0.00603645, 0.866012> }
	smooth_triangle { <0.144541, 5.00115, -1.35994>, <0.49265, -0.170883, 0.853285>, <0.0759456, 5.08966, -1.32686>, <0.258811, 0.00603942, 0.965909>, <0.0748199, 5.00115, -1.33106> , <0.25501, -0.170873, 0.951721> }
	smooth_triangle { <0.143564, 5.19258, -1.36163>, <0.498236, 0.083801, 0.862982>, <0.0759456, 5.08966, -1.32686>, <0.258811, 0.00603943, 0.965909>, <0.146716, 5.08966, -1.35617> , <0.499987, 0.00603645, 0.866012> }
	smooth_triangle { <0.0759456, 5.08966, -1.32686>, <0.258811, 0.00603943, 0.965909>, <0.143564, 5.19258, -1.36163>, <0.498236, 0.083801, 0.862982>, <0.0743143, 5.19258, -1.33295> , <0.257911, 0.0837985, 0.962528> }
	smooth_triangle { <0.137891, 5.29859, -1.37146>, <0.496899, 0.111144, 0.860661>, <0.0743143, 5.19258, -1.33295>, <0.257911, 0.0837985, 0.962528>, <0.143564, 5.19258, -1.36163> , <0.498236, 0.083801, 0.862982> }
	smooth_triangle { <0.0743143, 5.19258, -1.33295>, <0.257911, 0.0837985, 0.962528>, <0.137891, 5.29859, -1.37146>, <0.496899, 0.111144, 0.860661>, <0.0713778, 5.29859, -1.34391> , <0.25722, 0.111145, 0.95994> }
	smooth_triangle { <0.13411, 5.36342, -1.37801>, <0.496627, 0.115868, 0.860196>, <0.0713778, 5.29859, -1.34391>, <0.25722, 0.111145, 0.95994>, <0.137891, 5.29859, -1.37146> , <0.496899, 0.111144, 0.860661> }
	smooth_triangle { <0.0713778, 5.29859, -1.34391>, <0.25722, 0.111145, 0.95994>, <0.13411, 5.36342, -1.37801>, <0.496627, 0.115868, 0.860196>, <0.0694202, 5.36342, -1.35121> , <0.257077, 0.115867, 0.95942> }
	smooth_triangle { <0.128437, 5.44988, -1.38783>, <0.494821, 0.143622, 0.857045>, <0.0694202, 5.36342, -1.35121>, <0.256627, 0.130116, 0.957712>, <0.13411, 5.36342, -1.37801> , <0.495745, 0.13013, 0.858663> }
	smooth_triangle { <0.0694202, 5.36342, -1.35121>, <0.256627, 0.130116, 0.957712>, <0.128437, 5.44988, -1.38783>, <0.494821, 0.143622, 0.857045>, <0.0664837, 5.44988, -1.36217> , <0.256141, 0.14362, 0.95591> }
	smooth_triangle { <0.122133, 5.52912, -1.39875>, <0.492627, 0.171154, 0.853244>, <0.0664837, 5.44988, -1.36217>, <0.256141, 0.14362, 0.955911>, <0.128437, 5.44988, -1.38783> , <0.494821, 0.143622, 0.857045> }
	smooth_triangle { <0.0664837, 5.44988, -1.36217>, <0.256141, 0.14362, 0.955911>, <0.122133, 5.52912, -1.39875>, <0.492627, 0.171154, 0.853244>, <0.063221, 5.52912, -1.37435> , <0.254996, 0.171154, 0.951674> }
	smooth_triangle { <0.118352, 5.56926, -1.4053>, <0.49135, 0.185185, 0.851047>, <0.063221, 5.52912, -1.37435>, <0.254996, 0.171154, 0.951674>, <0.122133, 5.52912, -1.39875> , <0.492627, 0.171154, 0.853244> }
	smooth_triangle { <0.063221, 5.52912, -1.37435>, <0.254996, 0.171154, 0.951674>, <0.118352, 5.56926, -1.4053>, <0.49135, 0.185185, 0.851047>, <0.0612633, 5.56926, -1.38165> , <0.254333, 0.185175, 0.949223> }
	smooth_triangle { <0.118352, 5.56926, -1.4053>, <0, 1, 0>, <0.059632, 5.56926, -1.38774>, <-0.0498257, 0.981299, -0.185932>, <0.0612633, 5.56926, -1.38165> , <0, 1, 0> }
	smooth_triangle { <0.059632, 5.56926, -1.38774>, <-0.0498257, 0.981299, -0.185932>, <0.118352, 5.56926, -1.4053>, <0, 1, 0>, <0.1152, 5.56926, -1.41076> , <-0.0962657, 0.981291, -0.166738> }
	smooth_triangle { <0.1152, 5.56926, -1.41076>, <-0.0962657, 0.981291, -0.166738>, <0.0583268, 5.5672, -1.39261>, <-0.097846, 0.925802, -0.365127>, <0.059632, 5.56926, -1.38774> , <-0.0498257, 0.981299, -0.185932> }
	smooth_triangle { <0.0583268, 5.5672, -1.39261>, <-0.097846, 0.925802, -0.365127>, <0.1152, 5.56926, -1.41076>, <-0.0962657, 0.981291, -0.166738>, <0.112679, 5.5672, -1.41512> , <-0.189042, 0.925771, -0.327431> }
	smooth_triangle { <0.112048, 5.55794, -1.41622>, <-0.495407, 0.134986, -0.858109>, <0.0583268, 5.5672, -1.39261>, <-0.256449, 0.134954, -0.95709>, <0.112679, 5.5672, -1.41512> , <-0.495407, 0.134986, -0.858109> }
	smooth_triangle { <0.0583268, 5.5672, -1.39261>, <-0.256449, 0.134954, -0.95709>, <0.112048, 5.55794, -1.41622>, <-0.495407, 0.134986, -0.858109>, <0.0580006, 5.55794, -1.39383> , <-0.256449, 0.134954, -0.95709> }
	smooth_triangle { <0.000367679, 4.77442, -1.60892>, <0.0369538, -0.989751, 0.137941>, <0.0446049, 4.78708, -1.53303>, <0.0713774, -0.989754, 0.12366>, <0.0230892, 4.78708, -1.52412> , <0.0369538, -0.989751, 0.137941> }
	smooth_triangle { <0.0446049, 4.78708, -1.53303>, <0.0713774, -0.989754, 0.12366>, <0.000367679, 4.77442, -1.60892>, <0.0369538, -0.989751, 0.137941>, <0.0007103, 4.77442, -1.60906> , <0.0713774, -0.989754, 0.12366> }
	smooth_triangle { <0.000916218, 4.22409, -1.6087>, <-0.0143243, -0.99959, -0.0248127>, <0.207941, 4.21572, -1.40235>, <-0.0202575, -0.99959, -0.0202593>, <0.147036, 4.21572, -1.35562> , <-0.0143243, -0.99959, -0.0248127> }
	smooth_triangle { <0.207941, 4.21572, -1.40235>, <-0.0202575, -0.99959, -0.0202593>, <0.000916218, 4.22409, -1.6087>, <-0.0143243, -0.99959, -0.0248127>, <0.00129573, 4.22409, -1.60899> , <-0.0202575, -0.99959, -0.0202593> }
	smooth_triangle { <0.20716, 4.2287, -1.40313>, <0.704566, 0.0846999, 0.704565>, <0.147036, 4.21572, -1.35562>, <0.498199, 0.0846955, 0.862916>, <0.207941, 4.21572, -1.40235> , <0.704566, 0.0846999, 0.704565> }
	smooth_triangle { <0.147036, 4.21572, -1.35562>, <0.498199, 0.0846955, 0.862916>, <0.20716, 4.2287, -1.40313>, <0.704566, 0.0846999, 0.704565>, <0.146484, 4.2287, -1.35657> , <0.498199, 0.0846955, 0.862916> }
	smooth_triangle { <0.20716, 4.2287, -1.40313>, <0.319971, 0.89176, 0.319972>, <0.127674, 4.24779, -1.38915>, <0.176596, 0.935551, 0.305874>, <0.146484, 4.2287, -1.35657> , <0.226254, 0.891761, 0.391882> }
	smooth_triangle { <0.127674, 4.24779, -1.38915>, <0.176596, 0.935551, 0.305874>, <0.20716, 4.2287, -1.40313>, <0.319971, 0.89176, 0.319972>, <0.180559, 4.24779, -1.42973> , <0.249745, 0.935551, 0.249745> }
	smooth_triangle { <0.180559, 4.24779, -1.42973>, <0.249745, 0.935551, 0.249745>, <0.0906802, 4.26688, -1.45323>, <0.107113, 0.976784, 0.185525>, <0.127674, 4.24779, -1.38915> , <0.176596, 0.935551, 0.305874> }
	smooth_triangle { <0.0906802, 4.26688, -1.45323>, <0.107113, 0.976784, 0.185525>, <0.180559, 4.24779, -1.42973>, <0.249745, 0.935551, 0.249745>, <0.128241, 4.26688, -1.48205> , <0.15148, 0.976784, 0.15148> }
	smooth_triangle { <0.128241, 4.26688, -1.48205>, <0.15148, 0.976784, 0.15148>, <0.0643457, 4.27643, -1.49884>, <0.0807474, 0.986874, 0.139858>, <0.0906802, 4.26688, -1.45323> , <0.107113, 0.976784, 0.185525> }
	smooth_triangle { <0.0643457, 4.27643, -1.49884>, <0.0807474, 0.986874, 0.139858>, <0.128241, 4.26688, -1.48205>, <0.15148, 0.976784, 0.15148>, <0.0909985, 4.27643, -1.51929> , <0.114194, 0.986874, 0.114194> }
	smooth_triangle { <0.0909985, 4.27643, -1.51929>, <0.114194, 0.986874, 0.114194>, <0.0353216, 4.28491, -1.54911>, <0.0723078, 0.989488, 0.125242>, <0.0643457, 4.27643, -1.49884> , <0.0807474, 0.986874, 0.139858> }
	smooth_triangle { <0.0353216, 4.28491, -1.54911>, <0.0723078, 0.989488, 0.125242>, <0.0909985, 4.27643, -1.51929>, <0.114194, 0.986874, 0.114194>, <0.0499523, 4.28491, -1.56034> , <0.102259, 0.989488, 0.102259> }
	smooth_triangle { <0.0445314, 4.29552, -1.56576>, <0.672662, 0.308295, 0.672667>, <0.0353216, 4.28491, -1.54911>, <0.405234, 0.585785, 0.701884>, <0.0499523, 4.28491, -1.56034> , <0.573082, 0.585788, 0.573088> }
	smooth_triangle { <0.0353216, 4.28491, -1.54911>, <0.405234, 0.585785, 0.701884>, <0.0445314, 4.29552, -1.56576>, <0.672662, 0.308295, 0.672667>, <0.0314885, 4.29552, -1.55575> , <0.475645, 0.308293, 0.823843> }
	smooth_triangle { <0.0314885, 4.30188, -1.55575>, <0.499997, 0, 0.866027>, <0.0445314, 4.29552, -1.56576>, <0.672662, 0.308295, 0.672667>, <0.0445314, 4.30188, -1.56576> , <0.707105, 0, 0.707109> }
	smooth_triangle { <0.0445314, 4.29552, -1.56576>, <0.672662, 0.308295, 0.672667>, <0.0314885, 4.30188, -1.55575>, <0.499997, 0, 0.866027>, <0.0314885, 4.29552, -1.55575> , <0.475645, 0.308293, 0.823843> }
	smooth_triangle { <0.0314885, 4.30931, -1.55575>, <0.473009, 0.324097, 0.819282>, <0.0445314, 4.30188, -1.56576>, <0.707105, 0, 0.707109>, <0.0445314, 4.30931, -1.56576> , <0.668938, 0.324099, 0.668941> }
	smooth_triangle { <0.0445314, 4.30188, -1.56576>, <0.707105, 0, 0.707109>, <0.0314885, 4.30931, -1.55575>, <0.473009, 0.324097, 0.819282>, <0.0314885, 4.30188, -1.55575> , <0.499997, 0, 0.866027> }
	smooth_triangle { <0.0398843, 4.31779, -1.57041>, <0.432709, 0.790901, 0.432711>, <0.0314885, 4.30931, -1.55575>, <0.473009, 0.324097, 0.819282>, <0.0445314, 4.30931, -1.56576> , <0.668938, 0.324099, 0.668941> }
	smooth_triangle { <0.0314885, 4.30931, -1.55575>, <0.473009, 0.324097, 0.819282>, <0.0398843, 4.31779, -1.57041>, <0.432709, 0.790901, 0.432711>, <0.0282025, 4.31779, -1.56144> , <0.305972, 0.790899, 0.529962> }
	smooth_triangle { <0.0398843, 4.31779, -1.57041>, <0.432709, 0.790901, 0.432711>, <0.023274, 4.32203, -1.56998>, <0.31691, 0.773484, 0.548899>, <0.0282025, 4.31779, -1.56144> , <0.305972, 0.790899, 0.529962> }
	smooth_triangle { <0.023274, 4.32203, -1.56998>, <0.31691, 0.773484, 0.548899>, <0.0398843, 4.31779, -1.57041>, <0.432709, 0.790901, 0.432711>, <0.0329144, 4.32203, -1.57738> , <0.448178, 0.773481, 0.448177> }
	smooth_triangle { <0.0298165, 4.3284, -1.58047>, <0.647248, 0.402664, 0.647249>, <0.023274, 4.32203, -1.56998>, <0.31691, 0.773484, 0.548899>, <0.0329144, 4.32203, -1.57738> , <0.448178, 0.773481, 0.448177> }
	smooth_triangle { <0.023274, 4.32203, -1.56998>, <0.31691, 0.773484, 0.548899>, <0.0298165, 4.3284, -1.58047>, <0.647248, 0.402664, 0.647249>, <0.0210834, 4.3284, -1.57377> , <0.457677, 0.402668, 0.79271> }
	smooth_triangle { <0.0282676, 4.33794, -1.58202>, <0.703193, 0.105024, 0.7032>, <0.0210834, 4.3284, -1.57377>, <0.457677, 0.402668, 0.79271>, <0.0298165, 4.3284, -1.58047> , <0.647248, 0.402664, 0.647249> }
	smooth_triangle { <0.0210834, 4.3284, -1.57377>, <0.457677, 0.402668, 0.79271>, <0.0282676, 4.33794, -1.58202>, <0.703193, 0.105024, 0.7032>, <0.0199882, 4.33794, -1.57567> , <0.49724, 0.105024, 0.861233> }
	smooth_triangle { <0.0227263, 4.69858, -1.57093>, <0.49828, -0.0829402, 0.86304>, <0.0282676, 4.33794, -1.58202>, <0.703193, 0.105024, 0.7032>, <0.0321399, 4.69858, -1.57815> , <0.704669, -0.082937, 0.704672> }
	smooth_triangle { <0.0282676, 4.33794, -1.58202>, <0.703193, 0.105024, 0.7032>, <0.0227263, 4.69858, -1.57093>, <0.49828, -0.0829402, 0.86304>, <0.0199882, 4.33794, -1.57567> , <0.49724, 0.105024, 0.861233> }
	smooth_triangle { <0.0238215, 4.71298, -1.56903>, <0.488492, -0.213318, 0.846092>, <0.0321399, 4.69858, -1.57815>, <0.704669, -0.082937, 0.704672>, <0.0336888, 4.71298, -1.5766> , <0.690835, -0.213318, 0.690828> }
	smooth_triangle { <0.0321399, 4.69858, -1.57815>, <0.704669, -0.082937, 0.704672>, <0.0238215, 4.71298, -1.56903>, <0.488492, -0.213318, 0.846092>, <0.0227263, 4.69858, -1.57093> , <0.49828, -0.0829401, 0.86304> }
	smooth_triangle { <0.027655, 4.73974, -1.56239>, <0.47512, -0.311515, 0.822933>, <0.0336888, 4.71298, -1.5766>, <0.690835, -0.213318, 0.690828>, <0.0391099, 4.73974, -1.57118> , <0.671923, -0.311517, 0.67192> }
	smooth_triangle { <0.0336888, 4.71298, -1.5766>, <0.690835, -0.213318, 0.690828>, <0.027655, 4.73974, -1.56239>, <0.47512, -0.311515, 0.822933>, <0.0238215, 4.71298, -1.56903> , <0.488492, -0.213318, 0.846092> }
	smooth_triangle { <0.032036, 4.76341, -1.5548>, <0.416747, -0.552524, 0.72183>, <0.0391099, 4.73974, -1.57118>, <0.671923, -0.311517, 0.67192>, <0.0453058, 4.76341, -1.56498> , <0.589369, -0.552523, 0.589374> }
	smooth_triangle { <0.0391099, 4.73974, -1.57118>, <0.671923, -0.311517, 0.67192>, <0.032036, 4.76341, -1.5548>, <0.416747, -0.552524, 0.72183>, <0.027655, 4.73974, -1.56239> , <0.47512, -0.311515, 0.822933> }
	smooth_triangle { <0.032036, 4.76341, -1.5548>, <0.416747, -0.552524, 0.72183>, <0.0630807, 4.78708, -1.54721>, <0.371646, -0.85074, 0.371646>, <0.0446049, 4.78708, -1.53303> , <0.262792, -0.85074, 0.455172> }
	smooth_triangle { <0.0630807, 4.78708, -1.54721>, <0.371646, -0.85074, 0.371646>, <0.032036, 4.76341, -1.5548>, <0.416747, -0.552524, 0.72183>, <0.0453058, 4.76341, -1.56498> , <0.589369, -0.552523, 0.589374> }
	smooth_triangle { <0.0446049, 4.78708, -1.53303>, <0.262792, -0.85074, 0.455172>, <0.0987367, 4.80561, -1.51155>, <0.320895, -0.891096, 0.320895>, <0.0698173, 4.80561, -1.48936> , <0.226908, -0.891096, 0.393015> }
	smooth_triangle { <0.0987367, 4.80561, -1.51155>, <0.320895, -0.891096, 0.320895>, <0.0446049, 4.78708, -1.53303>, <0.262792, -0.85074, 0.455172>, <0.0630807, 4.78708, -1.54721> , <0.371646, -0.85074, 0.371646> }
	smooth_triangle { <0.0698173, 4.80561, -1.48936>, <0.226908, -0.891096, 0.393015>, <0.133501, 4.83854, -1.47679>, <0.420819, -0.803631, 0.420819>, <0.0943997, 4.83854, -1.44679> , <0.297567, -0.803632, 0.515392> }
	smooth_triangle { <0.133501, 4.83854, -1.47679>, <0.420819, -0.803631, 0.420819>, <0.0698173, 4.80561, -1.48936>, <0.226908, -0.891096, 0.393015>, <0.0987367, 4.80561, -1.51155> , <0.320895, -0.891096, 0.320895> }
	smooth_triangle { <0.0943997, 4.83854, -1.44679>, <0.297567, -0.803632, 0.515392>, <0.155786, 4.86427, -1.4545>, <0.507024, -0.697034, 0.507021>, <0.110158, 4.86427, -1.41949> , <0.358524, -0.697032, 0.620972> }
	smooth_triangle { <0.155786, 4.86427, -1.4545>, <0.507024, -0.697034, 0.507021>, <0.0943997, 4.83854, -1.44679>, <0.297567, -0.803632, 0.515392>, <0.133501, 4.83854, -1.47679> , <0.420819, -0.803631, 0.420819> }
	smooth_triangle { <0.124024, 4.90029, -1.39547>, <0.41515, -0.557311, 0.719065>, <0.155786, 4.86427, -1.4545>, <0.507024, -0.697034, 0.507021>, <0.175398, 4.90029, -1.43489> , <0.587113, -0.557311, 0.587114> }
	smooth_triangle { <0.155786, 4.86427, -1.4545>, <0.507024, -0.697034, 0.507021>, <0.124024, 4.90029, -1.39547>, <0.41515, -0.557311, 0.719065>, <0.110158, 4.86427, -1.41949> , <0.358524, -0.697032, 0.620972> }
	smooth_triangle { <0.134971, 4.938, -1.37651>, <0.458511, -0.398841, 0.794162>, <0.175398, 4.90029, -1.43489>, <0.587113, -0.557311, 0.587114>, <0.190877, 4.938, -1.41941> , <0.648432, -0.398837, 0.648432> }
	smooth_triangle { <0.175398, 4.90029, -1.43489>, <0.587113, -0.557311, 0.587114>, <0.134971, 4.938, -1.37651>, <0.458511, -0.398841, 0.794162>, <0.124024, 4.90029, -1.39547> , <0.41515, -0.557311, 0.719065> }
	smooth_triangle { <0.144541, 5.00115, -1.35994>, <0.49265, -0.170883, 0.853285>, <0.190877, 4.938, -1.41941>, <0.648432, -0.398837, 0.648432>, <0.204411, 5.00115, -1.40588> , <0.696707, -0.170886, 0.696704> }
	smooth_triangle { <0.190877, 4.938, -1.41941>, <0.648432, -0.398837, 0.648432>, <0.144541, 5.00115, -1.35994>, <0.49265, -0.170883, 0.853285>, <0.134971, 4.938, -1.37651> , <0.458511, -0.398841, 0.794163> }
	smooth_triangle { <0.146716, 5.08966, -1.35617>, <0.499987, 0.00603645, 0.866012>, <0.204411, 5.00115, -1.40588>, <0.696707, -0.170886, 0.696704>, <0.207488, 5.08966, -1.4028> , <0.707093, 0.00603628, 0.707094> }
	smooth_triangle { <0.204411, 5.00115, -1.40588>, <0.696707, -0.170886, 0.696704>, <0.146716, 5.08966, -1.35617>, <0.499987, 0.00603645, 0.866012>, <0.144541, 5.00115, -1.35994> , <0.49265, -0.170883, 0.853285> }
	smooth_triangle { <0.20303, 5.19258, -1.40726>, <0.70462, 0.0838011, 0.70462>, <0.146716, 5.08966, -1.35617>, <0.499987, 0.00603645, 0.866012>, <0.207488, 5.08966, -1.4028> , <0.707093, 0.00603628, 0.707094> }
	smooth_triangle { <0.146716, 5.08966, -1.35617>, <0.499987, 0.00603645, 0.866012>, <0.20303, 5.19258, -1.40726>, <0.70462, 0.0838011, 0.70462>, <0.143564, 5.19258, -1.36163> , <0.498236, 0.083801, 0.862982> }
	smooth_triangle { <0.195008, 5.29859, -1.41528>, <0.702725, 0.111146, 0.702726>, <0.143564, 5.19258, -1.36163>, <0.498236, 0.083801, 0.862982>, <0.20303, 5.19258, -1.40726> , <0.70462, 0.0838011, 0.70462> }
	smooth_triangle { <0.143564, 5.19258, -1.36163>, <0.498236, 0.083801, 0.862982>, <0.195008, 5.29859, -1.41528>, <0.702725, 0.111146, 0.702726>, <0.137891, 5.29859, -1.37146> , <0.496899, 0.111144, 0.860661> }
	smooth_triangle { <0.189659, 5.36342, -1.42063>, <0.702344, 0.115872, 0.702344>, <0.137891, 5.29859, -1.37146>, <0.496899, 0.111144, 0.860661>, <0.195008, 5.29859, -1.41528> , <0.702725, 0.111146, 0.702726> }
	smooth_triangle { <0.137891, 5.29859, -1.37146>, <0.496899, 0.111144, 0.860661>, <0.189659, 5.36342, -1.42063>, <0.702344, 0.115872, 0.702344>, <0.13411, 5.36342, -1.37801> , <0.496627, 0.115868, 0.860196> }
	smooth_triangle { <0.181636, 5.44988, -1.42865>, <0.699777, 0.143622, 0.699775>, <0.13411, 5.36342, -1.37801>, <0.495745, 0.13013, 0.858663>, <0.189659, 5.36342, -1.42063> , <0.701097, 0.130127, 0.701092> }
	smooth_triangle { <0.13411, 5.36342, -1.37801>, <0.495745, 0.13013, 0.858663>, <0.181636, 5.44988, -1.42865>, <0.699777, 0.143622, 0.699775>, <0.128437, 5.44988, -1.38783> , <0.494821, 0.143622, 0.857045> }
	smooth_triangle { <0.172723, 5.52912, -1.43757>, <0.696673, 0.171154, 0.696673>, <0.128437, 5.44988, -1.38783>, <0.49482, 0.143622, 0.857045>, <0.181636, 5.44988, -1.42865> , <0.699777, 0.143622, 0.699775> }
	smooth_triangle { <0.128437, 5.44988, -1.38783>, <0.49482, 0.143622, 0.857045>, <0.172723, 5.52912, -1.43757>, <0.696673, 0.171154, 0.696673>, <0.122133, 5.52912, -1.39875> , <0.492627, 0.171154, 0.853244> }
	smooth_triangle { <0.167374, 5.56926, -1.44292>, <0.694877, 0.185183, 0.694876>, <0.122133, 5.52912, -1.39875>, <0.492627, 0.171154, 0.853244>, <0.172723, 5.52912, -1.43757> , <0.696673, 0.171154, 0.696673> }
	smooth_triangle { <0.122133, 5.52912, -1.39875>, <0.492627, 0.171154, 0.853244>, <0.167374, 5.56926, -1.44292>, <0.694877, 0.185183, 0.694876>, <0.118352, 5.56926, -1.4053> , <0.49135, 0.185185, 0.851047> }
	smooth_triangle { <0.167374, 5.56926, -1.44292>, <0, 1, 0>, <0.1152, 5.56926, -1.41076>, <-0.0962657, 0.981291, -0.166738>, <0.118352, 5.56926, -1.4053> , <0, 1, 0> }
	smooth_triangle { <0.1152, 5.56926, -1.41076>, <-0.0962657, 0.981291, -0.166738>, <0.167374, 5.56926, -1.44292>, <0, 1, 0>, <0.162918, 5.56926, -1.44737> , <-0.136139, 0.981291, -0.136139> }
	smooth_triangle { <0.162918, 5.56926, -1.44737>, <-0.136139, 0.981291, -0.136139>, <0.112679, 5.5672, -1.41512>, <-0.189042, 0.925771, -0.327431>, <0.1152, 5.56926, -1.41076> , <-0.0962657, 0.981291, -0.166738> }
	smooth_triangle { <0.112679, 5.5672, -1.41512>, <-0.189042, 0.925771, -0.327431>, <0.162918, 5.56926, -1.44737>, <-0.136139, 0.981291, -0.136139>, <0.159353, 5.5672, -1.45094> , <-0.267344, 0.925772, -0.267344> }
	smooth_triangle { <0.158461, 5.55794, -1.45183>, <-0.700635, 0.134984, -0.700636>, <0.112679, 5.5672, -1.41512>, <-0.495407, 0.134986, -0.858109>, <0.159353, 5.5672, -1.45094> , <-0.700635, 0.134984, -0.700636> }
	smooth_triangle { <0.112679, 5.5672, -1.41512>, <-0.495407, 0.134986, -0.858109>, <0.158461, 5.55794, -1.45183>, <-0.700635, 0.134984, -0.700636>, <0.112048, 5.55794, -1.41622> , <-0.495407, 0.134986, -0.858109> }
	smooth_triangle { <0.0007103, 4.77442, -1.60906>, <0.0713774, -0.989754, 0.12366>, <0.0630807, 4.78708, -1.54721>, <0.100996, -0.989753, 0.100941>, <0.0446049, 4.78708, -1.53303> , <0.0713774, -0.989754, 0.12366> }
	smooth_triangle { <0.0630807, 4.78708, -1.54721>, <0.100996, -0.989753, 0.100941>, <0.0007103, 4.77442, -1.60906>, <0.0713774, -0.989754, 0.12366>, <0.00100452, 4.77442, -1.60929> , <0.100996, -0.989753, 0.100941> }
	smooth_triangle { <0.00129573, 4.22409, -1.60899>, <-0.0202575, -0.99959, -0.0202593>, <0.254674, 4.21572, -1.46325>, <-0.0248125, -0.99959, -0.0143231>, <0.207941, 4.21572, -1.40235> , <-0.0202575, -0.99959, -0.0202593> }
	smooth_triangle { <0.254674, 4.21572, -1.46325>, <-0.0248125, -0.99959, -0.0143231>, <0.00129573, 4.22409, -1.60899>, <-0.0202575, -0.99959, -0.0202593>, <0.00158693, 4.22409, -1.60937> , <-0.0248125, -0.99959, -0.0143231> }
	smooth_triangle { <0.207941, 4.21572, -1.40235>, <0.704566, 0.0846999, 0.704565>, <0.253719, 4.2287, -1.46381>, <0.862918, 0.0846665, 0.498201>, <0.20716, 4.2287, -1.40313> , <0.704566, 0.0846999, 0.704565> }
	smooth_triangle { <0.253719, 4.2287, -1.46381>, <0.862918, 0.0846665, 0.498201>, <0.207941, 4.21572, -1.40235>, <0.704566, 0.0846999, 0.704565>, <0.254674, 4.21572, -1.46325> , <0.862918, 0.0846665, 0.498201> }
	smooth_triangle { <0.253719, 4.2287, -1.46381>, <0.391881, 0.891762, 0.226252>, <0.180559, 4.24779, -1.42973>, <0.249745, 0.935551, 0.249745>, <0.20716, 4.2287, -1.40313> , <0.319971, 0.89176, 0.319972> }
	smooth_triangle { <0.180559, 4.24779, -1.42973>, <0.249745, 0.935551, 0.249745>, <0.253719, 4.2287, -1.46381>, <0.391881, 0.891762, 0.226252>, <0.221138, 4.24779, -1.48262> , <0.305874, 0.935551, 0.176596> }
	smooth_triangle { <0.221138, 4.24779, -1.48262>, <0.305874, 0.935551, 0.176596>, <0.128241, 4.26688, -1.48205>, <0.15148, 0.976784, 0.15148>, <0.180559, 4.24779, -1.42973> , <0.249745, 0.935551, 0.249745> }
	smooth_triangle { <0.128241, 4.26688, -1.48205>, <0.15148, 0.976784, 0.15148>, <0.221138, 4.24779, -1.48262>, <0.305874, 0.935551, 0.176596>, <0.157063, 4.26688, -1.51961> , <0.185525, 0.976784, 0.107113> }
	smooth_triangle { <0.157063, 4.26688, -1.51961>, <0.185525, 0.976784, 0.107113>, <0.0909985, 4.27643, -1.51929>, <0.114194, 0.986874, 0.114194>, <0.128241, 4.26688, -1.48205> , <0.15148, 0.976784, 0.15148> }
	smooth_triangle { <0.0909985, 4.27643, -1.51929>, <0.114194, 0.986874, 0.114194>, <0.157063, 4.26688, -1.51961>, <0.185525, 0.976784, 0.107113>, <0.11145, 4.27643, -1.54594> , <0.139858, 0.986874, 0.0807472> }
	smooth_triangle { <0.11145, 4.27643, -1.54594>, <0.139858, 0.986874, 0.0807472>, <0.0499523, 4.28491, -1.56034>, <0.102259, 0.989488, 0.102259>, <0.0909985, 4.27643, -1.51929> , <0.114194, 0.986874, 0.114194> }
	smooth_triangle { <0.0499523, 4.28491, -1.56034>, <0.102259, 0.989488, 0.102259>, <0.11145, 4.27643, -1.54594>, <0.139858, 0.986874, 0.0807472>, <0.0611789, 4.28491, -1.57497> , <0.125242, 0.989488, 0.0723078> }
	smooth_triangle { <0.0499523, 4.28491, -1.56034>, <0.573082, 0.585788, 0.573088>, <0.0545396, 4.29552, -1.5788>, <0.823844, 0.308296, 0.475641>, <0.0445314, 4.29552, -1.56576> , <0.672662, 0.308295, 0.672667> }
	smooth_triangle { <0.0545396, 4.29552, -1.5788>, <0.823844, 0.308296, 0.475641>, <0.0499523, 4.28491, -1.56034>, <0.573082, 0.585788, 0.573088>, <0.0611789, 4.28491, -1.57497> , <0.701883, 0.58579, 0.405229> }
	smooth_triangle { <0.0445314, 4.29552, -1.56576>, <0.672662, 0.308295, 0.672667>, <0.0545396, 4.30188, -1.5788>, <0.866029, 0, 0.499994>, <0.0445314, 4.30188, -1.56576> , <0.707105, 0, 0.707109> }
	smooth_triangle { <0.0545396, 4.30188, -1.5788>, <0.866029, 0, 0.499994>, <0.0445314, 4.29552, -1.56576>, <0.672662, 0.308295, 0.672667>, <0.0545396, 4.29552, -1.5788> , <0.823844, 0.308296, 0.475641> }
	smooth_triangle { <0.0445314, 4.30188, -1.56576>, <0.707105, 0, 0.707109>, <0.0545396, 4.30931, -1.5788>, <0.819285, 0.324094, 0.473007>, <0.0445314, 4.30931, -1.56576> , <0.668938, 0.324099, 0.668941> }
	smooth_triangle { <0.0545396, 4.30931, -1.5788>, <0.819285, 0.324094, 0.473007>, <0.0445314, 4.30188, -1.56576>, <0.707105, 0, 0.707109>, <0.0545396, 4.30188, -1.5788> , <0.866029, 0, 0.499994> }
	smooth_triangle { <0.0445314, 4.30931, -1.56576>, <0.668938, 0.324099, 0.668941>, <0.0488483, 4.31779, -1.58209>, <0.529965, 0.790897, 0.305973>, <0.0398843, 4.31779, -1.57041> , <0.432709, 0.790901, 0.432711> }
	smooth_triangle { <0.0488483, 4.31779, -1.58209>, <0.529965, 0.790897, 0.305973>, <0.0445314, 4.30931, -1.56576>, <0.668938, 0.324099, 0.668941>, <0.0545396, 4.30931, -1.5788> , <0.819285, 0.324094, 0.473007> }
	smooth_triangle { <0.0488483, 4.31779, -1.58209>, <0.529965, 0.790897, 0.305973>, <0.0329144, 4.32203, -1.57738>, <0.448178, 0.773481, 0.448177>, <0.0398843, 4.31779, -1.57041> , <0.432709, 0.790901, 0.432711> }
	smooth_triangle { <0.0329144, 4.32203, -1.57738>, <0.448178, 0.773481, 0.448177>, <0.0488483, 4.31779, -1.58209>, <0.529965, 0.790897, 0.305973>, <0.0403117, 4.32203, -1.58702> , <0.548903, 0.773481, 0.316911> }
	smooth_triangle { <0.0329144, 4.32203, -1.57738>, <0.448178, 0.773481, 0.448177>, <0.0365175, 4.3284, -1.58921>, <0.792713, 0.402664, 0.457677>, <0.0298165, 4.3284, -1.58047> , <0.647248, 0.402664, 0.647249> }
	smooth_triangle { <0.0365175, 4.3284, -1.58921>, <0.792713, 0.402664, 0.457677>, <0.0329144, 4.32203, -1.57738>, <0.448178, 0.773481, 0.448177>, <0.0403117, 4.32203, -1.58702> , <0.548903, 0.773481, 0.316911> }
	smooth_triangle { <0.0298165, 4.3284, -1.58047>, <0.647248, 0.402664, 0.647249>, <0.0346206, 4.33794, -1.5903>, <0.861233, 0.105023, 0.49724>, <0.0282676, 4.33794, -1.58202> , <0.703193, 0.105024, 0.7032> }
	smooth_triangle { <0.0346206, 4.33794, -1.5903>, <0.861233, 0.105023, 0.49724>, <0.0298165, 4.3284, -1.58047>, <0.647248, 0.402664, 0.647249>, <0.0365175, 4.3284, -1.58921> , <0.792713, 0.402664, 0.457677> }
	smooth_triangle { <0.0282676, 4.33794, -1.58202>, <0.703193, 0.105024, 0.7032>, <0.0393632, 4.69858, -1.58756>, <0.86304, -0.0829335, 0.498282>, <0.0321399, 4.69858, -1.57815> , <0.704669, -0.082937, 0.704672> }
	smooth_triangle { <0.0393632, 4.69858, -1.58756>, <0.86304, -0.0829335, 0.498282>, <0.0282676, 4.33794, -1.58202>, <0.703193, 0.105024, 0.7032>, <0.0346206, 4.33794, -1.5903> , <0.861233, 0.105023, 0.49724> }
	smooth_triangle { <0.0321399, 4.69858, -1.57815>, <0.704669, -0.082937, 0.704672>, <0.0412602, 4.71298, -1.58647>, <0.846093, -0.213316, 0.48849>, <0.0336888, 4.71298, -1.5766> , <0.690835, -0.213319, 0.690828> }
	smooth_triangle { <0.0412602, 4.71298, -1.58647>, <0.846093, -0.213316, 0.48849>, <0.0321399, 4.69858, -1.57815>, <0.704669, -0.082937, 0.704672>, <0.0393632, 4.69858, -1.58756> , <0.86304, -0.0829335, 0.498282> }
	smooth_triangle { <0.0336888, 4.71298, -1.5766>, <0.690835, -0.213318, 0.690828>, <0.0478998, 4.73974, -1.58263>, <0.822933, -0.311518, 0.475118>, <0.0391099, 4.73974, -1.57118> , <0.671923, -0.311517, 0.67192> }
	smooth_triangle { <0.0478998, 4.73974, -1.58263>, <0.822933, -0.311518, 0.475118>, <0.0336888, 4.71298, -1.5766>, <0.690835, -0.213318, 0.690828>, <0.0412602, 4.71298, -1.58647> , <0.846093, -0.213316, 0.48849> }
	smooth_triangle { <0.0391099, 4.73974, -1.57118>, <0.671923, -0.311517, 0.67192>, <0.055488, 4.76341, -1.57825>, <0.721829, -0.552524, 0.416749>, <0.0453058, 4.76341, -1.56498> , <0.589369, -0.552523, 0.589374> }
	smooth_triangle { <0.055488, 4.76341, -1.57825>, <0.721829, -0.552524, 0.416749>, <0.0391099, 4.73974, -1.57118>, <0.671923, -0.311517, 0.67192>, <0.0478998, 4.73974, -1.58263> , <0.822933, -0.311518, 0.475118> }
	smooth_triangle { <0.0453058, 4.76341, -1.56498>, <0.589369, -0.552523, 0.589374>, <0.0772578, 4.78708, -1.56569>, <0.455171, -0.85074, 0.262793>, <0.0630807, 4.78708, -1.54721> , <0.371646, -0.85074, 0.371646> }
	smooth_triangle { <0.0772578, 4.78708, -1.56569>, <0.455171, -0.85074, 0.262793>, <0.0453058, 4.76341, -1.56498>, <0.589369, -0.552523, 0.589374>, <0.055488, 4.76341, -1.57825> , <0.721829, -0.552524, 0.416749> }
	smooth_triangle { <0.0630807, 4.78708, -1.54721>, <0.371646, -0.85074, 0.371646>, <0.120927, 4.80561, -1.54047>, <0.393013, -0.891097, 0.226907>, <0.0987367, 4.80561, -1.51155> , <0.320895, -0.891096, 0.320895> }
	smooth_triangle { <0.120927, 4.80561, -1.54047>, <0.393013, -0.891097, 0.226907>, <0.0630807, 4.78708, -1.54721>, <0.371646, -0.85074, 0.371646>, <0.0772578, 4.78708, -1.56569> , <0.455171, -0.85074, 0.262793> }
	smooth_triangle { <0.0987367, 4.80561, -1.51155>, <0.320895, -0.891096, 0.320895>, <0.163505, 4.83854, -1.51589>, <0.515395, -0.80363, 0.297568>, <0.133501, 4.83854, -1.47679> , <0.420819, -0.803631, 0.420819> }
	smooth_triangle { <0.163505, 4.83854, -1.51589>, <0.515395, -0.80363, 0.297568>, <0.0987367, 4.80561, -1.51155>, <0.320895, -0.891096, 0.320895>, <0.120927, 4.80561, -1.54047> , <0.393013, -0.891097, 0.226907> }
	smooth_triangle { <0.133501, 4.83854, -1.47679>, <0.420819, -0.803631, 0.420819>, <0.190798, 4.86427, -1.50013>, <0.620977, -0.697026, 0.358527>, <0.155786, 4.86427, -1.4545> , <0.507024, -0.697034, 0.507021> }
	smooth_triangle { <0.190798, 4.86427, -1.50013>, <0.620977, -0.697026, 0.358527>, <0.133501, 4.83854, -1.47679>, <0.420819, -0.803631, 0.420819>, <0.163505, 4.83854, -1.51589> , <0.515395, -0.80363, 0.297568> }
	smooth_triangle { <0.155786, 4.86427, -1.4545>, <0.507024, -0.697034, 0.507021>, <0.214816, 4.90029, -1.48627>, <0.719064, -0.557314, 0.415149>, <0.175398, 4.90029, -1.43489> , <0.587113, -0.557311, 0.587114> }
	smooth_triangle { <0.214816, 4.90029, -1.48627>, <0.719064, -0.557314, 0.415149>, <0.155786, 4.86427, -1.4545>, <0.507024, -0.697034, 0.507021>, <0.190798, 4.86427, -1.50013> , <0.620977, -0.697026, 0.358527> }
	smooth_triangle { <0.175398, 4.90029, -1.43489>, <0.587113, -0.557311, 0.587114>, <0.233776, 4.938, -1.47532>, <0.79416, -0.398846, 0.45851>, <0.190877, 4.938, -1.41941> , <0.648432, -0.398837, 0.648432> }
	smooth_triangle { <0.233776, 4.938, -1.47532>, <0.79416, -0.398846, 0.45851>, <0.175398, 4.90029, -1.43489>, <0.587113, -0.557311, 0.587114>, <0.214816, 4.90029, -1.48627> , <0.719064, -0.557314, 0.415149> }
	smooth_triangle { <0.190877, 4.938, -1.41941>, <0.648432, -0.398837, 0.648432>, <0.250353, 5.00115, -1.46575>, <0.853285, -0.170877, 0.492652>, <0.204411, 5.00115, -1.40588> , <0.696707, -0.170886, 0.696704> }
	smooth_triangle { <0.250353, 5.00115, -1.46575>, <0.853285, -0.170877, 0.492652>, <0.190877, 4.938, -1.41941>, <0.648432, -0.398837, 0.648432>, <0.233776, 4.938, -1.47532> , <0.79416, -0.398846, 0.45851> }
	smooth_triangle { <0.204411, 5.00115, -1.40588>, <0.696707, -0.170886, 0.696704>, <0.254119, 5.08966, -1.46357>, <0.866011, 0.00603919, 0.499988>, <0.207488, 5.08966, -1.4028> , <0.707093, 0.00603628, 0.707094> }
	smooth_triangle { <0.254119, 5.08966, -1.46357>, <0.866011, 0.00603919, 0.499988>, <0.204411, 5.00115, -1.40588>, <0.696707, -0.170886, 0.696704>, <0.250353, 5.00115, -1.46575> , <0.853285, -0.170877, 0.492652> }
	smooth_triangle { <0.207488, 5.08966, -1.4028>, <0.707093, 0.00603628, 0.707094>, <0.24866, 5.19258, -1.46673>, <0.862982, 0.0837987, 0.498236>, <0.20303, 5.19258, -1.40726> , <0.70462, 0.0838011, 0.70462> }
	smooth_triangle { <0.24866, 5.19258, -1.46673>, <0.862982, 0.0837987, 0.498236>, <0.207488, 5.08966, -1.4028>, <0.707093, 0.00603628, 0.707094>, <0.254119, 5.08966, -1.46357> , <0.866011, 0.00603919, 0.499988> }
	smooth_triangle { <0.20303, 5.19258, -1.40726>, <0.70462, 0.0838011, 0.70462>, <0.238834, 5.29859, -1.4724>, <0.860661, 0.111147, 0.496899>, <0.195008, 5.29859, -1.41528> , <0.702725, 0.111146, 0.702726> }
	smooth_triangle { <0.238834, 5.29859, -1.4724>, <0.860661, 0.111147, 0.496899>, <0.20303, 5.19258, -1.40726>, <0.70462, 0.0838011, 0.70462>, <0.24866, 5.19258, -1.46673> , <0.862982, 0.0837987, 0.498236> }
	smooth_triangle { <0.195008, 5.29859, -1.41528>, <0.702726, 0.111146, 0.702726>, <0.232284, 5.36342, -1.47618>, <0.860195, 0.11587, 0.496627>, <0.189659, 5.36342, -1.42063> , <0.702344, 0.115872, 0.702344> }
	smooth_triangle { <0.232284, 5.36342, -1.47618>, <0.860195, 0.11587, 0.496627>, <0.195008, 5.29859, -1.41528>, <0.702726, 0.111146, 0.702726>, <0.238834, 5.29859, -1.4724> , <0.860661, 0.111147, 0.496899> }
	smooth_triangle { <0.189659, 5.36342, -1.42063>, <0.701097, 0.130127, 0.701092>, <0.222458, 5.44988, -1.48185>, <0.857045, 0.14362, 0.49482>, <0.181636, 5.44988, -1.42865> , <0.699777, 0.143622, 0.699775> }
	smooth_triangle { <0.222458, 5.44988, -1.48185>, <0.857045, 0.14362, 0.49482>, <0.189659, 5.36342, -1.42063>, <0.701097, 0.130127, 0.701092>, <0.232284, 5.36342, -1.47618> , <0.858665, 0.130114, 0.495746> }
	smooth_triangle { <0.181636, 5.44988, -1.42865>, <0.699777, 0.143621, 0.699775>, <0.211542, 5.52912, -1.48816>, <0.853244, 0.171154, 0.492627>, <0.172723, 5.52912, -1.43757> , <0.696673, 0.171154, 0.696673> }
	smooth_triangle { <0.211542, 5.52912, -1.48816>, <0.853244, 0.171154, 0.492627>, <0.181636, 5.44988, -1.42865>, <0.699777, 0.143621, 0.699775>, <0.222458, 5.44988, -1.48185> , <0.857045, 0.14362, 0.49482> }
	smooth_triangle { <0.172723, 5.52912, -1.43757>, <0.696673, 0.171154, 0.696673>, <0.204992, 5.56926, -1.49194>, <0.851049, 0.185173, 0.491351>, <0.167374, 5.56926, -1.44292> , <0.694877, 0.185183, 0.694876> }
	smooth_triangle { <0.204992, 5.56926, -1.49194>, <0.851049, 0.185173, 0.491351>, <0.172723, 5.52912, -1.43757>, <0.696673, 0.171154, 0.696673>, <0.211542, 5.52912, -1.48816> , <0.853244, 0.171154, 0.492627> }
	smooth_triangle { <0.204992, 5.56926, -1.49194>, <0, 1, 0>, <0.162918, 5.56926, -1.44737>, <-0.136139, 0.981291, -0.136139>, <0.167374, 5.56926, -1.44292> , <0, 1, 0> }
	smooth_triangle { <0.162918, 5.56926, -1.44737>, <-0.136139, 0.981291, -0.136139>, <0.204992, 5.56926, -1.49194>, <0, 1, 0>, <0.199532, 5.56926, -1.49509> , <-0.166705, 0.981298, -0.0962518> }
	smooth_triangle { <0.199532, 5.56926, -1.49509>, <-0.166705, 0.981298, -0.0962518>, <0.159353, 5.5672, -1.45094>, <-0.267344, 0.925772, -0.267344>, <0.162918, 5.56926, -1.44737> , <-0.136139, 0.981291, -0.136139> }
	smooth_triangle { <0.159353, 5.5672, -1.45094>, <-0.267344, 0.925772, -0.267344>, <0.199532, 5.56926, -1.49509>, <-0.166705, 0.981298, -0.0962518>, <0.195166, 5.5672, -1.49761> , <-0.327369, 0.925798, -0.189016> }
	smooth_triangle { <0.194073, 5.55794, -1.49824>, <-0.858113, 0.134953, -0.495408>, <0.159353, 5.5672, -1.45094>, <-0.700635, 0.134984, -0.700636>, <0.195166, 5.5672, -1.49761> , <-0.858113, 0.134953, -0.495408> }
	smooth_triangle { <0.159353, 5.5672, -1.45094>, <-0.700635, 0.134984, -0.700636>, <0.194073, 5.55794, -1.49824>, <-0.858113, 0.134953, -0.495408>, <0.158461, 5.55794, -1.45183> , <-0.700635, 0.134984, -0.700636> }
	smooth_triangle { <0.00100452, 4.77442, -1.60929>, <0.100996, -0.989753, 0.100941>, <0.0772578, 4.78708, -1.56569>, <0.123655, -0.989752, 0.0714148>, <0.0630807, 4.78708, -1.54721> , <0.100996, -0.989753, 0.100941> }
	smooth_triangle { <0.0772578, 4.78708, -1.56569>, <0.123655, -0.989752, 0.0714148>, <0.00100452, 4.77442, -1.60929>, <0.100996, -0.989753, 0.100941>, <0.00123028, 4.77442, -1.60958> , <0.123655, -0.989752, 0.0714148> }
	smooth_triangle { <0.00158693, 4.22409, -1.60937>, <-0.0248125, -0.99959, -0.0143231>, <0.284052, 4.21572, -1.53418>, <-0.027674, -0.99959, -0.0074148>, <0.254674, 4.21572, -1.46325> , <-0.0248125, -0.99959, -0.0143231> }
	smooth_triangle { <0.284052, 4.21572, -1.53418>, <-0.027674, -0.99959, -0.0074148>, <0.00158693, 4.22409, -1.60937>, <-0.0248125, -0.99959, -0.0143231>, <0.00176999, 4.22409, -1.60982> , <-0.027674, -0.99959, -0.0074148> }
	smooth_triangle { <0.254674, 4.21572, -1.46325>, <0.862918, 0.0846665, 0.498201>, <0.282986, 4.2287, -1.53446>, <0.962453, 0.0847014, 0.257894>, <0.253719, 4.2287, -1.46381> , <0.862918, 0.0846665, 0.498201> }
	smooth_triangle { <0.282986, 4.2287, -1.53446>, <0.962453, 0.0847014, 0.257894>, <0.254674, 4.21572, -1.46325>, <0.862918, 0.0846665, 0.498201>, <0.284052, 4.21572, -1.53418> , <0.962453, 0.0847014, 0.257894> }
	smooth_triangle { <0.282986, 4.2287, -1.53446>, <0.437092, 0.891759, 0.117118>, <0.221138, 4.24779, -1.48262>, <0.305874, 0.935551, 0.176596>, <0.253719, 4.2287, -1.46381> , <0.391881, 0.891762, 0.226252> }
	smooth_triangle { <0.221138, 4.24779, -1.48262>, <0.305874, 0.935551, 0.176596>, <0.282986, 4.2287, -1.53446>, <0.437092, 0.891759, 0.117118>, <0.246648, 4.24779, -1.5442> , <0.341159, 0.93555, 0.0914137> }
	smooth_triangle { <0.246648, 4.24779, -1.5442>, <0.341159, 0.93555, 0.0914137>, <0.157063, 4.26688, -1.51961>, <0.185525, 0.976784, 0.107113>, <0.221138, 4.24779, -1.48262> , <0.305874, 0.935551, 0.176596> }
	smooth_triangle { <0.157063, 4.26688, -1.51961>, <0.185525, 0.976784, 0.107113>, <0.246648, 4.24779, -1.5442>, <0.341159, 0.93555, 0.0914137>, <0.175181, 4.26688, -1.56335> , <0.206925, 0.976784, 0.0554455> }
	smooth_triangle { <0.175181, 4.26688, -1.56335>, <0.206925, 0.976784, 0.0554455>, <0.11145, 4.27643, -1.54594>, <0.139858, 0.986874, 0.0807472>, <0.157063, 4.26688, -1.51961> , <0.185525, 0.976784, 0.107113> }
	smooth_triangle { <0.11145, 4.27643, -1.54594>, <0.139858, 0.986874, 0.0807472>, <0.175181, 4.26688, -1.56335>, <0.206925, 0.976784, 0.0554455>, <0.124306, 4.27643, -1.57698> , <0.155992, 0.986874, 0.0417968> }
	smooth_triangle { <0.124306, 4.27643, -1.57698>, <0.155992, 0.986874, 0.0417968>, <0.0611789, 4.28491, -1.57497>, <0.125242, 0.989488, 0.0723078>, <0.11145, 4.27643, -1.54594> , <0.139858, 0.986874, 0.0807471> }
	smooth_triangle { <0.0611789, 4.28491, -1.57497>, <0.125242, 0.989488, 0.0723078>, <0.124306, 4.27643, -1.57698>, <0.155992, 0.986874, 0.0417968>, <0.0682361, 4.28491, -1.59201> , <0.139689, 0.989488, 0.0374289> }
	smooth_triangle { <0.0611789, 4.28491, -1.57497>, <0.701883, 0.58579, 0.405229>, <0.0608309, 4.29552, -1.59399>, <0.918876, 0.308297, 0.24621>, <0.0545396, 4.29552, -1.5788> , <0.823844, 0.308296, 0.475641> }
	smooth_triangle { <0.0608309, 4.29552, -1.59399>, <0.918876, 0.308297, 0.24621>, <0.0611789, 4.28491, -1.57497>, <0.701883, 0.58579, 0.405229>, <0.0682361, 4.28491, -1.59201> , <0.782846, 0.585792, 0.209762> }
	smooth_triangle { <0.0545396, 4.29552, -1.5788>, <0.823844, 0.308296, 0.475641>, <0.0608309, 4.30188, -1.59399>, <0.965927, 0, 0.258816>, <0.0545396, 4.30188, -1.5788> , <0.866029, 0, 0.499994> }
	smooth_triangle { <0.0608309, 4.30188, -1.59399>, <0.965927, 0, 0.258816>, <0.0545396, 4.29552, -1.5788>, <0.823844, 0.308296, 0.475641>, <0.0608309, 4.29552, -1.59399> , <0.918876, 0.308297, 0.24621> }
	smooth_triangle { <0.0545396, 4.30188, -1.5788>, <0.866029, 0, 0.499994>, <0.0608309, 4.30931, -1.59399>, <0.913791, 0.324092, 0.244846>, <0.0545396, 4.30931, -1.5788> , <0.819285, 0.324094, 0.473007> }
	smooth_triangle { <0.0608309, 4.30931, -1.59399>, <0.913791, 0.324092, 0.244846>, <0.0545396, 4.30188, -1.5788>, <0.866029, 0, 0.499994>, <0.0608309, 4.30188, -1.59399> , <0.965927, 0, 0.258816> }
	smooth_triangle { <0.0545396, 4.30931, -1.5788>, <0.819285, 0.324094, 0.473007>, <0.0544832, 4.31779, -1.59569>, <0.591099, 0.790896, 0.158383>, <0.0488483, 4.31779, -1.58209> , <0.529965, 0.790897, 0.305973> }
	smooth_triangle { <0.0544832, 4.31779, -1.59569>, <0.591099, 0.790896, 0.158383>, <0.0545396, 4.30931, -1.5788>, <0.819285, 0.324094, 0.473007>, <0.0608309, 4.30931, -1.59399> , <0.913791, 0.324092, 0.244846> }
	smooth_triangle { <0.0544832, 4.31779, -1.59569>, <0.591099, 0.790896, 0.158383>, <0.0403117, 4.32203, -1.58702>, <0.548903, 0.773481, 0.316911>, <0.0488483, 4.31779, -1.58209> , <0.529965, 0.790897, 0.305973> }
	smooth_triangle { <0.0403117, 4.32203, -1.58702>, <0.548903, 0.773481, 0.316911>, <0.0544832, 4.31779, -1.59569>, <0.591099, 0.790896, 0.158383>, <0.0449618, 4.32203, -1.59824> , <0.612223, 0.773481, 0.164044> }
	smooth_triangle { <0.0403117, 4.32203, -1.58702>, <0.548903, 0.773481, 0.316911>, <0.0407301, 4.3284, -1.59938>, <0.884158, 0.402663, 0.23691>, <0.0365175, 4.3284, -1.58921> , <0.792713, 0.402664, 0.457677> }
	smooth_triangle { <0.0407301, 4.3284, -1.59938>, <0.884158, 0.402663, 0.23691>, <0.0403117, 4.32203, -1.58702>, <0.548903, 0.773481, 0.316911>, <0.0449618, 4.32203, -1.59824> , <0.612223, 0.773481, 0.164044> }
	smooth_triangle { <0.0365175, 4.3284, -1.58921>, <0.792713, 0.402664, 0.457677>, <0.0386144, 4.33794, -1.59994>, <0.960584, 0.105023, 0.257389>, <0.0346206, 4.33794, -1.5903> , <0.861233, 0.105023, 0.49724> }
	smooth_triangle { <0.0386144, 4.33794, -1.59994>, <0.960584, 0.105023, 0.257389>, <0.0365175, 4.3284, -1.58921>, <0.792713, 0.402664, 0.457677>, <0.0407301, 4.3284, -1.59938> , <0.884158, 0.402663, 0.23691> }
	smooth_triangle { <0.0346206, 4.33794, -1.5903>, <0.861233, 0.105023, 0.49724>, <0.043904, 4.69858, -1.59853>, <0.962598, -0.0829344, 0.25793>, <0.0393632, 4.69858, -1.58756> , <0.86304, -0.0829335, 0.498282> }
	smooth_triangle { <0.043904, 4.69858, -1.59853>, <0.962598, -0.0829344, 0.25793>, <0.0346206, 4.33794, -1.5903>, <0.861233, 0.105023, 0.49724>, <0.0386144, 4.33794, -1.59994> , <0.960584, 0.105023, 0.257389> }
	smooth_triangle { <0.0393632, 4.69858, -1.58756>, <0.86304, -0.0829335, 0.498282>, <0.0460197, 4.71298, -1.59796>, <0.943693, -0.213315, 0.252863>, <0.0412602, 4.71298, -1.58647> , <0.846093, -0.213316, 0.48849> }
	smooth_triangle { <0.0460197, 4.71298, -1.59796>, <0.943693, -0.213315, 0.252863>, <0.0393632, 4.69858, -1.58756>, <0.86304, -0.0829335, 0.498282>, <0.043904, 4.69858, -1.59853> , <0.962598, -0.0829344, 0.25793> }
	smooth_triangle { <0.0412602, 4.71298, -1.58647>, <0.846093, -0.213316, 0.48849>, <0.0534252, 4.73974, -1.59597>, <0.917862, -0.311517, 0.245939>, <0.0478998, 4.73974, -1.58263> , <0.822933, -0.311518, 0.475118> }
	smooth_triangle { <0.0534252, 4.73974, -1.59597>, <0.917862, -0.311517, 0.245939>, <0.0412602, 4.71298, -1.58647>, <0.846093, -0.213316, 0.48849>, <0.0460197, 4.71298, -1.59796> , <0.943693, -0.213315, 0.252863> }
	smooth_triangle { <0.0478998, 4.73974, -1.58263>, <0.822933, -0.311518, 0.475118>, <0.0618888, 4.76341, -1.59371>, <0.805097, -0.552524, 0.215724>, <0.055488, 4.76341, -1.57825> , <0.721829, -0.552524, 0.416749> }
	smooth_triangle { <0.0618888, 4.76341, -1.59371>, <0.805097, -0.552524, 0.215724>, <0.0478998, 4.73974, -1.58263>, <0.822933, -0.311518, 0.475118>, <0.0534252, 4.73974, -1.59597> , <0.917862, -0.311517, 0.245939> }
	smooth_triangle { <0.055488, 4.76341, -1.57825>, <0.721829, -0.552524, 0.416749>, <0.0861699, 4.78708, -1.5872>, <0.507676, -0.850741, 0.136032>, <0.0772578, 4.78708, -1.56569> , <0.455171, -0.85074, 0.262793> }
	smooth_triangle { <0.0861699, 4.78708, -1.5872>, <0.507676, -0.850741, 0.136032>, <0.055488, 4.76341, -1.57825>, <0.721829, -0.552524, 0.416749>, <0.0618888, 4.76341, -1.59371> , <0.805097, -0.552524, 0.215724> }
	smooth_triangle { <0.0772578, 4.78708, -1.56569>, <0.455171, -0.85074, 0.262793>, <0.134877, 4.80561, -1.57415>, <0.43835, -0.891097, 0.117457>, <0.120927, 4.80561, -1.54047> , <0.393013, -0.891097, 0.226907> }
	smooth_triangle { <0.134877, 4.80561, -1.57415>, <0.43835, -0.891097, 0.117457>, <0.0772578, 4.78708, -1.56569>, <0.455171, -0.85074, 0.262793>, <0.0861699, 4.78708, -1.5872> , <0.507676, -0.850741, 0.136032> }
	smooth_triangle { <0.120927, 4.80561, -1.54047>, <0.393013, -0.891097, 0.226907>, <0.182367, 4.83854, -1.56143>, <0.574848, -0.803632, 0.154031>, <0.163505, 4.83854, -1.51589> , <0.515395, -0.80363, 0.297568> }
	smooth_triangle { <0.182367, 4.83854, -1.56143>, <0.574848, -0.803632, 0.154031>, <0.120927, 4.80561, -1.54047>, <0.393013, -0.891097, 0.226907>, <0.134877, 4.80561, -1.57415> , <0.43835, -0.891097, 0.117457> }
	smooth_triangle { <0.163505, 4.83854, -1.51589>, <0.515395, -0.80363, 0.297568>, <0.212808, 4.86427, -1.55327>, <0.69261, -0.697029, 0.185585>, <0.190798, 4.86427, -1.50013> , <0.620977, -0.697026, 0.358527> }
	smooth_triangle { <0.212808, 4.86427, -1.55327>, <0.69261, -0.697029, 0.185585>, <0.163505, 4.83854, -1.51589>, <0.515395, -0.80363, 0.297568>, <0.182367, 4.83854, -1.56143> , <0.574848, -0.803632, 0.154031> }
	smooth_triangle { <0.190798, 4.86427, -1.50013>, <0.620977, -0.697026, 0.358527>, <0.239597, 4.90029, -1.54609>, <0.802009, -0.557314, 0.214901>, <0.214816, 4.90029, -1.48627> , <0.719064, -0.557314, 0.415149> }
	smooth_triangle { <0.239597, 4.90029, -1.54609>, <0.802009, -0.557314, 0.214901>, <0.190798, 4.86427, -1.50013>, <0.620977, -0.697026, 0.358527>, <0.212808, 4.86427, -1.55327> , <0.69261, -0.697029, 0.185585> }
	smooth_triangle { <0.214816, 4.90029, -1.48627>, <0.719064, -0.557314, 0.415149>, <0.260744, 4.938, -1.54042>, <0.885772, -0.398844, 0.237345>, <0.233776, 4.938, -1.47532> , <0.79416, -0.398846, 0.45851> }
	smooth_triangle { <0.260744, 4.938, -1.54042>, <0.885772, -0.398844, 0.237345>, <0.214816, 4.90029, -1.48627>, <0.719064, -0.557314, 0.415149>, <0.239597, 4.90029, -1.54609> , <0.802009, -0.557314, 0.214901> }
	smooth_triangle { <0.233776, 4.938, -1.47532>, <0.79416, -0.398846, 0.45851>, <0.279232, 5.00115, -1.53547>, <0.95172, -0.170873, 0.255012>, <0.250353, 5.00115, -1.46575> , <0.853285, -0.170877, 0.492652> }
	smooth_triangle { <0.279232, 5.00115, -1.53547>, <0.95172, -0.170873, 0.255012>, <0.233776, 4.938, -1.47532>, <0.79416, -0.398846, 0.45851>, <0.260744, 4.938, -1.54042> , <0.885772, -0.398844, 0.237345> }
	smooth_triangle { <0.250353, 5.00115, -1.46575>, <0.853285, -0.170877, 0.492652>, <0.283432, 5.08966, -1.53434>, <0.965909, 0.00603503, 0.258811>, <0.254119, 5.08966, -1.46357> , <0.866011, 0.00603919, 0.499988> }
	smooth_triangle { <0.283432, 5.08966, -1.53434>, <0.965909, 0.00603503, 0.258811>, <0.250353, 5.00115, -1.46575>, <0.853285, -0.170877, 0.492652>, <0.279232, 5.00115, -1.53547> , <0.95172, -0.170873, 0.255012> }
	smooth_triangle { <0.254119, 5.08966, -1.46357>, <0.866011, 0.00603919, 0.499988>, <0.277344, 5.19258, -1.53598>, <0.962528, 0.0837968, 0.257911>, <0.24866, 5.19258, -1.46673> , <0.862982, 0.0837987, 0.498236> }
	smooth_triangle { <0.277344, 5.19258, -1.53598>, <0.962528, 0.0837968, 0.257911>, <0.254119, 5.08966, -1.46357>, <0.866011, 0.00603919, 0.499988>, <0.283432, 5.08966, -1.53434> , <0.965909, 0.00603503, 0.258811> }
	smooth_triangle { <0.24866, 5.19258, -1.46673>, <0.862982, 0.0837987, 0.498236>, <0.266385, 5.29859, -1.53891>, <0.95994, 0.111143, 0.25722>, <0.238834, 5.29859, -1.4724> , <0.860661, 0.111147, 0.496899> }
	smooth_triangle { <0.266385, 5.29859, -1.53891>, <0.95994, 0.111143, 0.25722>, <0.24866, 5.19258, -1.46673>, <0.862982, 0.0837987, 0.498236>, <0.277344, 5.19258, -1.53598> , <0.962528, 0.0837968, 0.257911> }
	smooth_triangle { <0.238834, 5.29859, -1.4724>, <0.860661, 0.111147, 0.496899>, <0.259079, 5.36342, -1.54087>, <0.959421, 0.115859, 0.257077>, <0.232284, 5.36342, -1.47618> , <0.860195, 0.11587, 0.496627> }
	smooth_triangle { <0.259079, 5.36342, -1.54087>, <0.959421, 0.115859, 0.257077>, <0.238834, 5.29859, -1.4724>, <0.860661, 0.111147, 0.496899>, <0.266385, 5.29859, -1.53891> , <0.95994, 0.111143, 0.25722> }
	smooth_triangle { <0.232284, 5.36342, -1.47618>, <0.858665, 0.130114, 0.495746>, <0.248121, 5.44988, -1.54381>, <0.955909, 0.143628, 0.256142>, <0.222458, 5.44988, -1.48185> , <0.857045, 0.14362, 0.49482> }
	smooth_triangle { <0.248121, 5.44988, -1.54381>, <0.955909, 0.143628, 0.256142>, <0.232284, 5.36342, -1.47618>, <0.858665, 0.130114, 0.495746>, <0.259079, 5.36342, -1.54087> , <0.95771, 0.130122, 0.25663> }
	smooth_triangle { <0.222458, 5.44988, -1.48185>, <0.857045, 0.14362, 0.49482>, <0.235944, 5.52912, -1.54707>, <0.951674, 0.171153, 0.254996>, <0.211542, 5.52912, -1.48816> , <0.853244, 0.171154, 0.492627> }
	smooth_triangle { <0.235944, 5.52912, -1.54707>, <0.951674, 0.171153, 0.254996>, <0.222458, 5.44988, -1.48185>, <0.857045, 0.14362, 0.49482>, <0.248121, 5.44988, -1.54381> , <0.955909, 0.143628, 0.256142> }
	smooth_triangle { <0.211542, 5.52912, -1.48816>, <0.853244, 0.171154, 0.492627>, <0.228638, 5.56926, -1.54903>, <0.949226, 0.185163, 0.254333>, <0.204992, 5.56926, -1.49194> , <0.851049, 0.185173, 0.491351> }
	smooth_triangle { <0.228638, 5.56926, -1.54903>, <0.949226, 0.185163, 0.254333>, <0.211542, 5.52912, -1.48816>, <0.853244, 0.171154, 0.492627>, <0.235944, 5.52912, -1.54707> , <0.951674, 0.171153, 0.254996> }
	smooth_triangle { <0.228638, 5.56926, -1.54903>, <0, 1, 0>, <0.199532, 5.56926, -1.49509>, <-0.166705, 0.981298, -0.0962518>, <0.204992, 5.56926, -1.49194> , <0, 1, 0> }
	smooth_triangle { <0.199532, 5.56926, -1.49509>, <-0.166705, 0.981298, -0.0962518>, <0.228638, 5.56926, -1.54903>, <0, 1, 0>, <0.22255, 5.56926, -1.55066> , <-0.185932, 0.981299, -0.0498168> }
	smooth_triangle { <0.22255, 5.56926, -1.55066>, <-0.185932, 0.981299, -0.0498168>, <0.195166, 5.5672, -1.49761>, <-0.327369, 0.925798, -0.189016>, <0.199532, 5.56926, -1.49509> , <-0.166705, 0.981298, -0.0962518> }
	smooth_triangle { <0.195166, 5.5672, -1.49761>, <-0.327369, 0.925798, -0.189016>, <0.22255, 5.56926, -1.55066>, <-0.185932, 0.981299, -0.0498168>, <0.217678, 5.5672, -1.55196> , <-0.365126, 0.925804, -0.0978285> }
	smooth_triangle { <0.21646, 5.55794, -1.55229>, <-0.957097, 0.134897, -0.256452>, <0.195166, 5.5672, -1.49761>, <-0.858113, 0.134953, -0.495408>, <0.217678, 5.5672, -1.55196> , <-0.957097, 0.134897, -0.256452> }
	smooth_triangle { <0.195166, 5.5672, -1.49761>, <-0.858113, 0.134953, -0.495408>, <0.21646, 5.55794, -1.55229>, <-0.957097, 0.134897, -0.256452>, <0.194073, 5.55794, -1.49824> , <-0.858113, 0.134953, -0.495408> }
	smooth_triangle { <0.00123028, 4.77442, -1.60958>, <0.123655, -0.989752, 0.0714148>, <0.0861699, 4.78708, -1.5872>, <0.137921, -0.989753, 0.0369693>, <0.0772578, 4.78708, -1.56569> , <0.123655, -0.989752, 0.0714148> }
	smooth_triangle { <0.0861699, 4.78708, -1.5872>, <0.137921, -0.989753, 0.0369693>, <0.00123028, 4.77442, -1.60958>, <0.123655, -0.989752, 0.0714148>, <0.0013722, 4.77442, -1.60992> , <0.137921, -0.989753, 0.0369693> }
	smooth_triangle { <0.00183244, 4.22409, -1.61029>, <-0.0286499, -0.99959, -1.49013e-008>, <0.284052, 4.21572, -1.53418>, <-0.027674, -0.99959, -0.0074148>, <0.00176999, 4.22409, -1.60982> , <-0.027674, -0.99959, -0.0074148> }
	smooth_triangle { <0.284052, 4.21572, -1.53418>, <-0.027674, -0.99959, -0.0074148>, <0.00183244, 4.22409, -1.61029>, <-0.0286499, -0.99959, -1.49013e-008>, <0.294073, 4.21572, -1.61029> , <-0.0286499, -0.99959, -1.49013e-008> }
	smooth_triangle { <0.284052, 4.21572, -1.53418>, <0.962453, 0.0847014, 0.257894>, <0.292969, 4.2287, -1.61029>, <0.996406, 0.0847, -1.57803e-007>, <0.282986, 4.2287, -1.53446> , <0.962453, 0.0847014, 0.257894> }
	smooth_triangle { <0.292969, 4.2287, -1.61029>, <0.996406, 0.0847, -1.57803e-007>, <0.284052, 4.21572, -1.53418>, <0.962453, 0.0847014, 0.257894>, <0.294073, 4.21572, -1.61029> , <0.996406, 0.0847, -1.57803e-007> }
	smooth_triangle { <0.292969, 4.2287, -1.61029>, <0.45251, 0.891759, 1.86595e-008>, <0.246648, 4.24779, -1.5442>, <0.341159, 0.93555, 0.0914137>, <0.282986, 4.2287, -1.53446> , <0.437092, 0.891759, 0.117118> }
	smooth_triangle { <0.246648, 4.24779, -1.5442>, <0.341159, 0.93555, 0.0914137>, <0.292969, 4.2287, -1.61029>, <0.45251, 0.891759, 1.86595e-008>, <0.255349, 4.24779, -1.61029> , <0.353193, 0.93555, -6.65922e-008> }
	smooth_triangle { <0.255349, 4.24779, -1.61029>, <0.353193, 0.93555, -6.65922e-008>, <0.175181, 4.26688, -1.56335>, <0.206925, 0.976784, 0.0554455>, <0.246648, 4.24779, -1.5442> , <0.341159, 0.93555, 0.0914137> }
	smooth_triangle { <0.175181, 4.26688, -1.56335>, <0.206925, 0.976784, 0.0554455>, <0.255349, 4.24779, -1.61029>, <0.353193, 0.93555, -6.65922e-008>, <0.18136, 4.26688, -1.61029> , <0.214225, 0.976784, -1.35188e-008> }
	smooth_triangle { <0.18136, 4.26688, -1.61029>, <0.214225, 0.976784, -1.35188e-008>, <0.124306, 4.27643, -1.57698>, <0.155992, 0.986874, 0.0417968>, <0.175181, 4.26688, -1.56335> , <0.206925, 0.976784, 0.0554455> }
	smooth_triangle { <0.124306, 4.27643, -1.57698>, <0.155992, 0.986874, 0.0417968>, <0.18136, 4.26688, -1.61029>, <0.214225, 0.976784, -1.35188e-008>, <0.128691, 4.27643, -1.61029> , <0.161495, 0.986874, 7.49995e-008> }
	smooth_triangle { <0.128691, 4.27643, -1.61029>, <0.161495, 0.986874, 7.49995e-008>, <0.0682361, 4.28491, -1.59201>, <0.139689, 0.989488, 0.0374289>, <0.124306, 4.27643, -1.57698> , <0.155992, 0.986874, 0.0417968> }
	smooth_triangle { <0.0682361, 4.28491, -1.59201>, <0.139689, 0.989488, 0.0374289>, <0.128691, 4.27643, -1.61029>, <0.161495, 0.986874, 7.49995e-008>, <0.0706433, 4.28491, -1.61029> , <0.144617, 0.989488, 2.32873e-008> }
	smooth_triangle { <0.0682361, 4.28491, -1.59201>, <0.782846, 0.585792, 0.209762>, <0.0629768, 4.29552, -1.61029>, <0.95129, 0.308298, -9.06991e-008>, <0.0608309, 4.29552, -1.59399> , <0.918876, 0.308297, 0.24621> }
	smooth_triangle { <0.0629768, 4.29552, -1.61029>, <0.95129, 0.308298, -9.06991e-008>, <0.0682361, 4.28491, -1.59201>, <0.782846, 0.585792, 0.209762>, <0.0706433, 4.28491, -1.61029> , <0.810461, 0.585793, -1.72336e-007> }
	smooth_triangle { <0.0608309, 4.29552, -1.59399>, <0.918876, 0.308297, 0.24621>, <0.0629768, 4.30188, -1.61029>, <1, 0, 3.75744e-009>, <0.0608309, 4.30188, -1.59399> , <0.965927, 0, 0.258816> }
	smooth_triangle { <0.0629768, 4.30188, -1.61029>, <1, 0, 3.75744e-009>, <0.0608309, 4.29552, -1.59399>, <0.918876, 0.308297, 0.24621>, <0.0629768, 4.29552, -1.61029> , <0.95129, 0.308298, -9.06991e-008> }
	smooth_triangle { <0.0608309, 4.30188, -1.59399>, <0.965927, 0, 0.258816>, <0.0629768, 4.30931, -1.61029>, <0.946025, 0.324093, -1.12994e-007>, <0.0608309, 4.30931, -1.59399> , <0.913791, 0.324092, 0.244846> }
	smooth_triangle { <0.0629768, 4.30931, -1.61029>, <0.946025, 0.324093, -1.12994e-007>, <0.0608309, 4.30188, -1.59399>, <0.965927, 0, 0.258816>, <0.0629768, 4.30188, -1.61029> , <1, 0, 3.75744e-009> }
	smooth_triangle { <0.0608309, 4.30931, -1.59399>, <0.913791, 0.324092, 0.244846>, <0.0564051, 4.31779, -1.61029>, <0.61195, 0.790897, -5.11517e-008>, <0.0544832, 4.31779, -1.59569> , <0.591099, 0.790896, 0.158383> }
	smooth_triangle { <0.0564051, 4.31779, -1.61029>, <0.61195, 0.790897, -5.11517e-008>, <0.0608309, 4.30931, -1.59399>, <0.913791, 0.324092, 0.244846>, <0.0629768, 4.30931, -1.61029> , <0.946025, 0.324093, -1.12994e-007> }
	smooth_triangle { <0.0564051, 4.31779, -1.61029>, <0.61195, 0.790897, -5.11517e-008>, <0.0449618, 4.32203, -1.59824>, <0.612223, 0.773481, 0.164044>, <0.0544832, 4.31779, -1.59569> , <0.591099, 0.790896, 0.158383> }
	smooth_triangle { <0.0449618, 4.32203, -1.59824>, <0.612223, 0.773481, 0.164044>, <0.0564051, 4.31779, -1.61029>, <0.61195, 0.790897, -5.11517e-008>, <0.0465479, 4.32203, -1.61029> , <0.633819, 0.773481, 2.14013e-008> }
	smooth_triangle { <0.0449618, 4.32203, -1.59824>, <0.612223, 0.773481, 0.164044>, <0.0421669, 4.3284, -1.61029>, <0.915349, 0.402663, -8.02038e-008>, <0.0407301, 4.3284, -1.59938> , <0.884158, 0.402663, 0.23691> }
	smooth_triangle { <0.0421669, 4.3284, -1.61029>, <0.915349, 0.402663, -8.02038e-008>, <0.0449618, 4.32203, -1.59824>, <0.612223, 0.773481, 0.164044>, <0.0465479, 4.32203, -1.61029> , <0.633819, 0.773481, 2.14013e-008> }
	smooth_triangle { <0.0407301, 4.3284, -1.59938>, <0.884158, 0.402663, 0.23691>, <0.0399765, 4.33794, -1.61029>, <0.99447, 0.105022, -4.54081e-008>, <0.0386144, 4.33794, -1.59994> , <0.960584, 0.105023, 0.257389> }
	smooth_triangle { <0.0399765, 4.33794, -1.61029>, <0.99447, 0.105022, -4.54081e-008>, <0.0407301, 4.3284, -1.59938>, <0.884158, 0.402663, 0.23691>, <0.0421669, 4.3284, -1.61029> , <0.915349, 0.402663, -8.02038e-008> }
	smooth_triangle { <0.0386144, 4.33794, -1.59994>, <0.960584, 0.105023, 0.257389>, <0.0454527, 4.69858, -1.61029>, <0.996555, -0.082936, -3.76573e-008>, <0.043904, 4.69858, -1.59853> , <0.962598, -0.0829344, 0.25793> }
	smooth_triangle { <0.0454527, 4.69858, -1.61029>, <0.996555, -0.082936, -3.76573e-008>, <0.0386144, 4.33794, -1.59994>, <0.960584, 0.105023, 0.257389>, <0.0399765, 4.33794, -1.61029> , <0.99447, 0.105022, -4.54081e-008> }
	smooth_triangle { <0.043904, 4.69858, -1.59853>, <0.962598, -0.0829344, 0.25793>, <0.0476431, 4.71298, -1.61029>, <0.976983, -0.213316, -4.89266e-008>, <0.0460197, 4.71298, -1.59796> , <0.943693, -0.213315, 0.252863> }
	smooth_triangle { <0.0476431, 4.71298, -1.61029>, <0.976983, -0.213316, -4.89266e-008>, <0.043904, 4.69858, -1.59853>, <0.962598, -0.0829344, 0.25793>, <0.0454527, 4.69858, -1.61029> , <0.996555, -0.082936, -3.76573e-008> }
	smooth_triangle { <0.0460197, 4.71298, -1.59796>, <0.943693, -0.213315, 0.252863>, <0.0553099, 4.73974, -1.61029>, <0.950241, -0.311516, 2.06633e-008>, <0.0534252, 4.73974, -1.59597> , <0.917862, -0.311517, 0.245939> }
	smooth_triangle { <0.0553099, 4.73974, -1.61029>, <0.950241, -0.311516, 2.06633e-008>, <0.0460197, 4.71298, -1.59796>, <0.943693, -0.213315, 0.252863>, <0.0476431, 4.71298, -1.61029> , <0.976983, -0.213316, -4.89266e-008> }
	smooth_triangle { <0.0534252, 4.73974, -1.59597>, <0.917862, -0.311517, 0.245939>, <0.064072, 4.76341, -1.61029>, <0.833497, -0.552524, 6.54287e-008>, <0.0618888, 4.76341, -1.59371> , <0.805097, -0.552524, 0.215724> }
	smooth_triangle { <0.064072, 4.76341, -1.61029>, <0.833497, -0.552524, 6.54287e-008>, <0.0534252, 4.73974, -1.59597>, <0.917862, -0.311517, 0.245939>, <0.0553099, 4.73974, -1.61029> , <0.950241, -0.311516, 2.06633e-008> }
	smooth_triangle { <0.064072, 4.76341, -1.61029>, <0.833497, -0.552524, 6.54287e-008>, <0.0861699, 4.78708, -1.5872>, <0.507676, -0.850741, 0.136032>, <0.0618888, 4.76341, -1.59371> , <0.805097, -0.552524, 0.215724> }
	smooth_triangle { <0.0861699, 4.78708, -1.5872>, <0.507676, -0.850741, 0.136032>, <0.064072, 4.76341, -1.61029>, <0.833497, -0.552524, 6.54287e-008>, <0.0892096, 4.78708, -1.61029> , <0.525585, -0.850741, 1.12454e-007> }
	smooth_triangle { <0.0892096, 4.78708, -1.61029>, <0.525585, -0.850741, 1.12454e-007>, <0.134877, 4.80561, -1.57415>, <0.43835, -0.891097, 0.117457>, <0.0861699, 4.78708, -1.5872> , <0.507676, -0.850741, 0.136032> }
	smooth_triangle { <0.134877, 4.80561, -1.57415>, <0.43835, -0.891097, 0.117457>, <0.0892096, 4.78708, -1.61029>, <0.525585, -0.850741, 1.12454e-007>, <0.139635, 4.80561, -1.61029> , <0.453813, -0.891097, 4.56696e-007> }
	smooth_triangle { <0.139635, 4.80561, -1.61029>, <0.453813, -0.891097, 4.56696e-007>, <0.182367, 4.83854, -1.56143>, <0.574848, -0.803632, 0.154031>, <0.134877, 4.80561, -1.57415> , <0.43835, -0.891097, 0.117457> }
	smooth_triangle { <0.182367, 4.83854, -1.56143>, <0.574848, -0.803632, 0.154031>, <0.139635, 4.80561, -1.61029>, <0.453813, -0.891097, 4.56696e-007>, <0.188799, 4.83854, -1.61029> , <0.595128, -0.803631, -1.47765e-007> }
	smooth_triangle { <0.188799, 4.83854, -1.61029>, <0.595128, -0.803631, -1.47765e-007>, <0.212808, 4.86427, -1.55327>, <0.69261, -0.697029, 0.185585>, <0.182367, 4.83854, -1.56143> , <0.574848, -0.803632, 0.154031> }
	smooth_triangle { <0.212808, 4.86427, -1.55327>, <0.69261, -0.697029, 0.185585>, <0.188799, 4.83854, -1.61029>, <0.595128, -0.803631, -1.47765e-007>, <0.220315, 4.86427, -1.61029> , <0.717044, -0.697028, -6.42225e-007> }
	smooth_triangle { <0.212808, 4.86427, -1.55327>, <0.69261, -0.697029, 0.185585>, <0.248049, 4.90029, -1.61029>, <0.830302, -0.557314, -1.12661e-007>, <0.239597, 4.90029, -1.54609> , <0.802009, -0.557314, 0.214901> }
	smooth_triangle { <0.248049, 4.90029, -1.61029>, <0.830302, -0.557314, -1.12661e-007>, <0.212808, 4.86427, -1.55327>, <0.69261, -0.697029, 0.185585>, <0.220315, 4.86427, -1.61029> , <0.717044, -0.697028, -6.42225e-007> }
	smooth_triangle { <0.239597, 4.90029, -1.54609>, <0.802009, -0.557314, 0.214901>, <0.269942, 4.938, -1.61029>, <0.917019, -0.398843, -2.64418e-008>, <0.260744, 4.938, -1.54042> , <0.885772, -0.398844, 0.237345> }
	smooth_triangle { <0.269942, 4.938, -1.61029>, <0.917019, -0.398843, -2.64418e-008>, <0.239597, 4.90029, -1.54609>, <0.802009, -0.557314, 0.214901>, <0.248049, 4.90029, -1.61029> , <0.830302, -0.557314, -1.12661e-007> }
	smooth_triangle { <0.260744, 4.938, -1.54042>, <0.885772, -0.398844, 0.237345>, <0.289082, 5.00115, -1.61029>, <0.985293, -0.170873, -1.47593e-007>, <0.279232, 5.00115, -1.53547> , <0.95172, -0.170873, 0.255012> }
	smooth_triangle { <0.289082, 5.00115, -1.61029>, <0.985293, -0.170873, -1.47593e-007>, <0.260744, 4.938, -1.54042>, <0.885772, -0.398844, 0.237345>, <0.269942, 4.938, -1.61029> , <0.917019, -0.398843, -2.64418e-008> }
	smooth_triangle { <0.279232, 5.00115, -1.53547>, <0.95172, -0.170873, 0.255012>, <0.293431, 5.08966, -1.61029>, <0.999982, 0.00603506, -9.78394e-008>, <0.283432, 5.08966, -1.53434> , <0.965909, 0.00603503, 0.258811> }
	smooth_triangle { <0.293431, 5.08966, -1.61029>, <0.999982, 0.00603506, -9.78394e-008>, <0.279232, 5.00115, -1.53547>, <0.95172, -0.170873, 0.255012>, <0.289082, 5.00115, -1.61029> , <0.985293, -0.170873, -1.47593e-007> }
	smooth_triangle { <0.283432, 5.08966, -1.53434>, <0.965909, 0.00603503, 0.258811>, <0.287129, 5.19258, -1.61029>, <0.996483, 0.0837969, -8.26798e-008>, <0.277344, 5.19258, -1.53598> , <0.962528, 0.0837968, 0.257911> }
	smooth_triangle { <0.287129, 5.19258, -1.61029>, <0.996483, 0.0837969, -8.26798e-008>, <0.283432, 5.08966, -1.53434>, <0.965909, 0.00603503, 0.258811>, <0.293431, 5.08966, -1.61029> , <0.999982, 0.00603506, -9.78394e-008> }
	smooth_triangle { <0.277344, 5.19258, -1.53598>, <0.962528, 0.0837968, 0.257911>, <0.275782, 5.29859, -1.61029>, <0.993804, 0.111143, 1.01441e-007>, <0.266385, 5.29859, -1.53891> , <0.95994, 0.111143, 0.25722> }
	smooth_triangle { <0.275782, 5.29859, -1.61029>, <0.993804, 0.111143, 1.01441e-007>, <0.277344, 5.19258, -1.53598>, <0.962528, 0.0837968, 0.257911>, <0.287129, 5.19258, -1.61029> , <0.996483, 0.0837969, -8.26798e-008> }
	smooth_triangle { <0.266385, 5.29859, -1.53891>, <0.95994, 0.111143, 0.25722>, <0.26822, 5.36342, -1.61029>, <0.993266, 0.115859, 4.13271e-007>, <0.259079, 5.36342, -1.54087> , <0.959421, 0.115859, 0.257077> }
	smooth_triangle { <0.26822, 5.36342, -1.61029>, <0.993266, 0.115859, 4.13271e-007>, <0.266385, 5.29859, -1.53891>, <0.95994, 0.111143, 0.25722>, <0.275782, 5.29859, -1.61029> , <0.993804, 0.111143, 1.01441e-007> }
	smooth_triangle { <0.259079, 5.36342, -1.54087>, <0.95771, 0.130122, 0.25663>, <0.256873, 5.44988, -1.61029>, <0.989632, 0.143628, -8.64138e-008>, <0.248121, 5.44988, -1.54381> , <0.955909, 0.143628, 0.256142> }
	smooth_triangle { <0.256873, 5.44988, -1.61029>, <0.989632, 0.143628, -8.64138e-008>, <0.259079, 5.36342, -1.54087>, <0.95771, 0.130122, 0.25663>, <0.26822, 5.36342, -1.61029> , <0.991498, 0.130123, -2.25414e-007> }
	smooth_triangle { <0.248121, 5.44988, -1.54381>, <0.955909, 0.143628, 0.256142>, <0.244266, 5.52912, -1.61029>, <0.985245, 0.171152, 3.26847e-007>, <0.235944, 5.52912, -1.54707> , <0.951674, 0.171153, 0.254996> }
	smooth_triangle { <0.244266, 5.52912, -1.61029>, <0.985245, 0.171152, 3.26847e-007>, <0.248121, 5.44988, -1.54381>, <0.955909, 0.143628, 0.256142>, <0.256873, 5.44988, -1.61029> , <0.989632, 0.143628, -8.64138e-008> }
	smooth_triangle { <0.235944, 5.52912, -1.54707>, <0.951674, 0.171153, 0.254996>, <0.236704, 5.56926, -1.61029>, <0.982708, 0.185162, 6.08525e-007>, <0.228638, 5.56926, -1.54903> , <0.949226, 0.185163, 0.254333> }
	smooth_triangle { <0.236704, 5.56926, -1.61029>, <0.982708, 0.185162, 6.08525e-007>, <0.235944, 5.52912, -1.54707>, <0.951674, 0.171153, 0.254996>, <0.244266, 5.52912, -1.61029> , <0.985245, 0.171152, 3.26847e-007> }
	smooth_triangle { <0.236704, 5.56926, -1.61029>, <0, 1, 0>, <0.22255, 5.56926, -1.55066>, <-0.185932, 0.981299, -0.0498168>, <0.228638, 5.56926, -1.54903> , <0, 1, 0> }
	smooth_triangle { <0.22255, 5.56926, -1.55066>, <-0.185932, 0.981299, -0.0498168>, <0.236704, 5.56926, -1.61029>, <0, 1, 0>, <0.2304, 5.56926, -1.61029> , <-0.192487, 0.981299, -3.96776e-006> }
	smooth_triangle { <0.2304, 5.56926, -1.61029>, <-0.192487, 0.981299, -3.96776e-006>, <0.217678, 5.5672, -1.55196>, <-0.365126, 0.925804, -0.0978285>, <0.22255, 5.56926, -1.55066> , <-0.185932, 0.981299, -0.0498168> }
	smooth_triangle { <0.217678, 5.5672, -1.55196>, <-0.365126, 0.925804, -0.0978285>, <0.2304, 5.56926, -1.61029>, <-0.192487, 0.981299, -3.96776e-006>, <0.225358, 5.5672, -1.61029> , <-0.378, 0.925806, -7.79176e-006> }
	smooth_triangle { <0.224097, 5.55794, -1.61029>, <-0.990859, 0.1349, -1.05192e-007>, <0.217678, 5.5672, -1.55196>, <-0.957097, 0.134897, -0.256452>, <0.225358, 5.5672, -1.61029> , <-0.990859, 0.1349, -1.05192e-007> }
	smooth_triangle { <0.217678, 5.5672, -1.55196>, <-0.957097, 0.134897, -0.256452>, <0.224097, 5.55794, -1.61029>, <-0.990859, 0.1349, -1.05192e-007>, <0.21646, 5.55794, -1.55229> , <-0.957097, 0.134897, -0.256452> }
	smooth_triangle { <0.0014206, 4.77442, -1.61029>, <0.142793, -0.989753, -2.01201e-007>, <0.0861699, 4.78708, -1.5872>, <0.137921, -0.989753, 0.0369693>, <0.0013722, 4.77442, -1.60992> , <0.137921, -0.989753, 0.0369693> }
	smooth_triangle { <0.0861699, 4.78708, -1.5872>, <0.137921, -0.989753, 0.0369693>, <0.0014206, 4.77442, -1.61029>, <0.142793, -0.989753, -2.01201e-007>, <0.0892096, 4.78708, -1.61029> , <0.142793, -0.989753, -2.01201e-007> }
	smooth_triangle { <0.00176999, 4.22409, -1.61076>, <-0.0276742, -0.99959, 0.00741489>, <0.294073, 4.21572, -1.61029>, <-0.0286499, -0.99959, -1.49013e-008>, <0.00183244, 4.22409, -1.61029> , <-0.0286499, -0.99959, -1.49013e-008> }
	smooth_triangle { <0.294073, 4.21572, -1.61029>, <-0.0286499, -0.99959, -1.49013e-008>, <0.00176999, 4.22409, -1.61076>, <-0.0276742, -0.99959, 0.00741489>, <0.284052, 4.21572, -1.6864> , <-0.0276742, -0.99959, 0.00741489> }
	smooth_triangle { <0.294073, 4.21572, -1.61029>, <0.996406, 0.0847, -1.57803e-007>, <0.282986, 4.2287, -1.68612>, <0.962457, 0.0846599, -0.257895>, <0.292969, 4.2287, -1.61029> , <0.996406, 0.0847, -1.57803e-007> }
	smooth_triangle { <0.282986, 4.2287, -1.68612>, <0.962457, 0.0846599, -0.257895>, <0.294073, 4.21572, -1.61029>, <0.996406, 0.0847, -1.57803e-007>, <0.284052, 4.21572, -1.6864> , <0.962457, 0.0846599, -0.257895> }
	smooth_triangle { <0.292969, 4.2287, -1.61029>, <0.45251, 0.891759, 1.86595e-008>, <0.246648, 4.24779, -1.67638>, <0.341157, 0.935551, -0.091413>, <0.255349, 4.24779, -1.61029> , <0.353193, 0.93555, -6.75301e-008> }
	smooth_triangle { <0.246648, 4.24779, -1.67638>, <0.341157, 0.935551, -0.091413>, <0.292969, 4.2287, -1.61029>, <0.45251, 0.891759, 1.86595e-008>, <0.282986, 4.2287, -1.68612> , <0.437087, 0.891762, -0.117116> }
	smooth_triangle { <0.255349, 4.24779, -1.61029>, <0.353193, 0.93555, -6.75301e-008>, <0.175181, 4.26688, -1.65723>, <0.206926, 0.976784, -0.0554459>, <0.18136, 4.26688, -1.61029> , <0.214225, 0.976784, -1.30526e-008> }
	smooth_triangle { <0.175181, 4.26688, -1.65723>, <0.206926, 0.976784, -0.0554459>, <0.255349, 4.24779, -1.61029>, <0.353193, 0.93555, -6.75301e-008>, <0.246648, 4.24779, -1.67638> , <0.341157, 0.935551, -0.091413> }
	smooth_triangle { <0.18136, 4.26688, -1.61029>, <0.214225, 0.976784, -1.30526e-008>, <0.124306, 4.27643, -1.6436>, <0.155992, 0.986874, -0.0417968>, <0.128691, 4.27643, -1.61029> , <0.161495, 0.986874, 7.49995e-008> }
	smooth_triangle { <0.124306, 4.27643, -1.6436>, <0.155992, 0.986874, -0.0417968>, <0.18136, 4.26688, -1.61029>, <0.214225, 0.976784, -1.30526e-008>, <0.175181, 4.26688, -1.65723> , <0.206926, 0.976784, -0.0554459> }
	smooth_triangle { <0.128691, 4.27643, -1.61029>, <0.161495, 0.986874, 7.49995e-008>, <0.0682361, 4.28491, -1.62857>, <0.139689, 0.989488, -0.0374288>, <0.0706433, 4.28491, -1.61029> , <0.144617, 0.989488, 2.32873e-008> }
	smooth_triangle { <0.0682361, 4.28491, -1.62857>, <0.139689, 0.989488, -0.0374288>, <0.128691, 4.27643, -1.61029>, <0.161495, 0.986874, 7.49995e-008>, <0.124306, 4.27643, -1.6436> , <0.155992, 0.986874, -0.0417968> }
	smooth_triangle { <0.0706433, 4.28491, -1.61029>, <0.810461, 0.585793, -1.72336e-007>, <0.0608309, 4.29552, -1.62659>, <0.918875, 0.308301, -0.24621>, <0.0629768, 4.29552, -1.61029> , <0.95129, 0.308298, -9.06991e-008> }
	smooth_triangle { <0.0608309, 4.29552, -1.62659>, <0.918875, 0.308301, -0.24621>, <0.0706433, 4.28491, -1.61029>, <0.810461, 0.585793, -1.72336e-007>, <0.0682361, 4.28491, -1.62857> , <0.782843, 0.585797, -0.209758> }
	smooth_triangle { <0.0629768, 4.29552, -1.61029>, <0.95129, 0.308298, -9.06991e-008>, <0.0608309, 4.30188, -1.62659>, <0.965925, 0, -0.258821>, <0.0629768, 4.30188, -1.61029> , <1, 0, 0> }
	smooth_triangle { <0.0608309, 4.30188, -1.62659>, <0.965925, 0, -0.258821>, <0.0629768, 4.29552, -1.61029>, <0.95129, 0.308298, -9.06991e-008>, <0.0608309, 4.29552, -1.62659> , <0.918875, 0.308301, -0.24621> }
	smooth_triangle { <0.0629768, 4.30188, -1.61029>, <1, 0, 0>, <0.0608309, 4.30931, -1.62659>, <0.913791, 0.324089, -0.244852>, <0.0629768, 4.30931, -1.61029> , <0.946025, 0.324093, -1.12994e-007> }
	smooth_triangle { <0.0608309, 4.30931, -1.62659>, <0.913791, 0.324089, -0.244852>, <0.0629768, 4.30188, -1.61029>, <1, 0, 0>, <0.0608309, 4.30188, -1.62659> , <0.965925, 0, -0.258821> }
	smooth_triangle { <0.0629768, 4.30931, -1.61029>, <0.946025, 0.324093, -1.14976e-007>, <0.0544832, 4.31779, -1.62489>, <0.591101, 0.790895, -0.158385>, <0.0564051, 4.31779, -1.61029> , <0.61195, 0.790897, -5.21168e-008> }
	smooth_triangle { <0.0544832, 4.31779, -1.62489>, <0.591101, 0.790895, -0.158385>, <0.0629768, 4.30931, -1.61029>, <0.946025, 0.324093, -1.14976e-007>, <0.0608309, 4.30931, -1.62659> , <0.913791, 0.324089, -0.244852> }
	smooth_triangle { <0.0564051, 4.31779, -1.61029>, <0.61195, 0.790897, -5.21168e-008>, <0.0449618, 4.32203, -1.62234>, <0.612221, 0.773483, -0.164042>, <0.0465479, 4.32203, -1.61029> , <0.633819, 0.773481, 2.33468e-008> }
	smooth_triangle { <0.0449618, 4.32203, -1.62234>, <0.612221, 0.773483, -0.164042>, <0.0564051, 4.31779, -1.61029>, <0.61195, 0.790897, -5.21168e-008>, <0.0544832, 4.31779, -1.62489> , <0.591101, 0.790895, -0.158385> }
	smooth_triangle { <0.0465479, 4.32203, -1.61029>, <0.633819, 0.773481, 2.33468e-008>, <0.0407301, 4.3284, -1.6212>, <0.884158, 0.402664, -0.23691>, <0.0421669, 4.3284, -1.61029> , <0.915349, 0.402663, -8.02038e-008> }
	smooth_triangle { <0.0407301, 4.3284, -1.6212>, <0.884158, 0.402664, -0.23691>, <0.0465479, 4.32203, -1.61029>, <0.633819, 0.773481, 2.33468e-008>, <0.0449618, 4.32203, -1.62234> , <0.612221, 0.773483, -0.164042> }
	smooth_triangle { <0.0421669, 4.3284, -1.61029>, <0.915349, 0.402663, -8.02038e-008>, <0.0386144, 4.33794, -1.62064>, <0.960584, 0.105023, -0.257389>, <0.0399765, 4.33794, -1.61029> , <0.99447, 0.105022, -4.54081e-008> }
	smooth_triangle { <0.0386144, 4.33794, -1.62064>, <0.960584, 0.105023, -0.257389>, <0.0421669, 4.3284, -1.61029>, <0.915349, 0.402663, -8.02038e-008>, <0.0407301, 4.3284, -1.6212> , <0.884158, 0.402664, -0.23691> }
	smooth_triangle { <0.0399765, 4.33794, -1.61029>, <0.99447, 0.105022, -4.54081e-008>, <0.043904, 4.69858, -1.62205>, <0.962597, -0.0829378, -0.257931>, <0.0454527, 4.69858, -1.61029> , <0.996555, -0.082936, -4.1423e-008> }
	smooth_triangle { <0.043904, 4.69858, -1.62205>, <0.962597, -0.0829378, -0.257931>, <0.0399765, 4.33794, -1.61029>, <0.99447, 0.105022, -4.54081e-008>, <0.0386144, 4.33794, -1.62064> , <0.960584, 0.105023, -0.257389> }
	smooth_triangle { <0.0454527, 4.69858, -1.61029>, <0.996555, -0.082936, -4.1423e-008>, <0.0460197, 4.71298, -1.62262>, <0.943692, -0.213319, -0.252864>, <0.0476431, 4.71298, -1.61029> , <0.976983, -0.213316, -4.89266e-008> }
	smooth_triangle { <0.0460197, 4.71298, -1.62262>, <0.943692, -0.213319, -0.252864>, <0.0454527, 4.69858, -1.61029>, <0.996555, -0.082936, -4.1423e-008>, <0.043904, 4.69858, -1.62205> , <0.962597, -0.0829378, -0.257931> }
	smooth_triangle { <0.0476431, 4.71298, -1.61029>, <0.976983, -0.213316, -4.89266e-008>, <0.0534252, 4.73974, -1.62461>, <0.917863, -0.311515, -0.245939>, <0.0553099, 4.73974, -1.61029> , <0.950241, -0.311516, 2.25418e-008> }
	smooth_triangle { <0.0534252, 4.73974, -1.62461>, <0.917863, -0.311515, -0.245939>, <0.0476431, 4.71298, -1.61029>, <0.976983, -0.213316, -4.89266e-008>, <0.0460197, 4.71298, -1.62262> , <0.943692, -0.213319, -0.252864> }
	smooth_triangle { <0.0553099, 4.73974, -1.61029>, <0.950241, -0.311516, 2.25418e-008>, <0.0618888, 4.76341, -1.62687>, <0.805096, -0.552524, -0.215726>, <0.064072, 4.76341, -1.61029> , <0.833497, -0.552524, 6.7353e-008> }
	smooth_triangle { <0.0618888, 4.76341, -1.62687>, <0.805096, -0.552524, -0.215726>, <0.0553099, 4.73974, -1.61029>, <0.950241, -0.311516, 2.25418e-008>, <0.0534252, 4.73974, -1.62461> , <0.917863, -0.311515, -0.245939> }
	smooth_triangle { <0.0618888, 4.76341, -1.62687>, <0.805096, -0.552524, -0.215726>, <0.0892096, 4.78708, -1.61029>, <0.525585, -0.850741, 1.11501e-007>, <0.064072, 4.76341, -1.61029> , <0.833497, -0.552524, 6.7353e-008> }
	smooth_triangle { <0.0892096, 4.78708, -1.61029>, <0.525585, -0.850741, 1.11501e-007>, <0.0618888, 4.76341, -1.62687>, <0.805096, -0.552524, -0.215726>, <0.0861699, 4.78708, -1.63338> , <0.507675, -0.850741, -0.136033> }
	smooth_triangle { <0.0861699, 4.78708, -1.63338>, <0.507675, -0.850741, -0.136033>, <0.139635, 4.80561, -1.61029>, <0.453813, -0.891097, 4.56696e-007>, <0.0892096, 4.78708, -1.61029> , <0.525585, -0.850741, 1.12454e-007> }
	smooth_triangle { <0.139635, 4.80561, -1.61029>, <0.453813, -0.891097, 4.56696e-007>, <0.0861699, 4.78708, -1.63338>, <0.507675, -0.850741, -0.136033>, <0.134877, 4.80561, -1.64643> , <0.438348, -0.891097, -0.117457> }
	smooth_triangle { <0.134877, 4.80561, -1.64643>, <0.438348, -0.891097, -0.117457>, <0.188799, 4.83854, -1.61029>, <0.595128, -0.803631, -1.45895e-007>, <0.139635, 4.80561, -1.61029> , <0.453813, -0.891097, 4.57636e-007> }
	smooth_triangle { <0.188799, 4.83854, -1.61029>, <0.595128, -0.803631, -1.45895e-007>, <0.134877, 4.80561, -1.64643>, <0.438348, -0.891097, -0.117457>, <0.182367, 4.83854, -1.65915> , <0.574848, -0.803632, -0.15403> }
	smooth_triangle { <0.182367, 4.83854, -1.65915>, <0.574848, -0.803632, -0.15403>, <0.220315, 4.86427, -1.61029>, <0.717044, -0.697028, -6.44108e-007>, <0.188799, 4.83854, -1.61029> , <0.595128, -0.803631, -1.45895e-007> }
	smooth_triangle { <0.220315, 4.86427, -1.61029>, <0.717044, -0.697028, -6.44108e-007>, <0.182367, 4.83854, -1.65915>, <0.574848, -0.803632, -0.15403>, <0.212808, 4.86427, -1.66731> , <0.692614, -0.697026, -0.185584> }
	smooth_triangle { <0.220315, 4.86427, -1.61029>, <0.717044, -0.697028, -6.44108e-007>, <0.239597, 4.90029, -1.67449>, <0.80201, -0.557313, -0.214901>, <0.248049, 4.90029, -1.61029> , <0.830302, -0.557314, -1.10783e-007> }
	smooth_triangle { <0.239597, 4.90029, -1.67449>, <0.80201, -0.557313, -0.214901>, <0.220315, 4.86427, -1.61029>, <0.717044, -0.697028, -6.44108e-007>, <0.212808, 4.86427, -1.66731> , <0.692614, -0.697026, -0.185584> }
	smooth_triangle { <0.248049, 4.90029, -1.61029>, <0.830302, -0.557314, -1.10783e-007>, <0.260744, 4.938, -1.68016>, <0.885769, -0.398849, -0.237345>, <0.269942, 4.938, -1.61029> , <0.917019, -0.398843, -2.64418e-008> }
	smooth_triangle { <0.260744, 4.938, -1.68016>, <0.885769, -0.398849, -0.237345>, <0.248049, 4.90029, -1.61029>, <0.830302, -0.557314, -1.10783e-007>, <0.239597, 4.90029, -1.67449> , <0.80201, -0.557313, -0.214901> }
	smooth_triangle { <0.269942, 4.938, -1.61029>, <0.917019, -0.398843, -2.83305e-008>, <0.279232, 5.00115, -1.68511>, <0.95172, -0.170877, -0.255012>, <0.289082, 5.00115, -1.61029> , <0.985293, -0.170873, -1.47593e-007> }
	smooth_triangle { <0.279232, 5.00115, -1.68511>, <0.95172, -0.170877, -0.255012>, <0.269942, 4.938, -1.61029>, <0.917019, -0.398843, -2.83305e-008>, <0.260744, 4.938, -1.68016> , <0.885769, -0.398849, -0.237345> }
	smooth_triangle { <0.289082, 5.00115, -1.61029>, <0.985293, -0.170873, -1.47593e-007>, <0.283432, 5.08966, -1.68624>, <0.965909, 0.00603943, -0.258811>, <0.293431, 5.08966, -1.61029> , <0.999982, 0.00603506, -9.78394e-008> }
	smooth_triangle { <0.283432, 5.08966, -1.68624>, <0.965909, 0.00603943, -0.258811>, <0.289082, 5.00115, -1.61029>, <0.985293, -0.170873, -1.47593e-007>, <0.279232, 5.00115, -1.68511> , <0.95172, -0.170877, -0.255012> }
	smooth_triangle { <0.293431, 5.08966, -1.61029>, <0.999982, 0.00603506, -9.78394e-008>, <0.277344, 5.19258, -1.6846>, <0.962528, 0.0837984, -0.257911>, <0.287129, 5.19258, -1.61029> , <0.996483, 0.0837969, -8.26798e-008> }
	smooth_triangle { <0.277344, 5.19258, -1.6846>, <0.962528, 0.0837984, -0.257911>, <0.293431, 5.08966, -1.61029>, <0.999982, 0.00603506, -9.78394e-008>, <0.283432, 5.08966, -1.68624> , <0.965909, 0.00603943, -0.258811> }
	smooth_triangle { <0.287129, 5.19258, -1.61029>, <0.996483, 0.0837969, -8.26798e-008>, <0.266385, 5.29859, -1.68167>, <0.95994, 0.111145, -0.25722>, <0.275782, 5.29859, -1.61029> , <0.993804, 0.111143, 1.05198e-007> }
	smooth_triangle { <0.266385, 5.29859, -1.68167>, <0.95994, 0.111145, -0.25722>, <0.287129, 5.19258, -1.61029>, <0.996483, 0.0837969, -8.26798e-008>, <0.277344, 5.19258, -1.6846> , <0.962528, 0.0837984, -0.257911> }
	smooth_triangle { <0.275782, 5.29859, -1.61029>, <0.993804, 0.111143, 1.05198e-007>, <0.259079, 5.36342, -1.67971>, <0.95942, 0.115867, -0.257078>, <0.26822, 5.36342, -1.61029> , <0.993266, 0.115859, 4.13271e-007> }
	smooth_triangle { <0.259079, 5.36342, -1.67971>, <0.95942, 0.115867, -0.257078>, <0.275782, 5.29859, -1.61029>, <0.993804, 0.111143, 1.05198e-007>, <0.266385, 5.29859, -1.68167> , <0.95994, 0.111145, -0.25722> }
	smooth_triangle { <0.26822, 5.36342, -1.61029>, <0.991498, 0.130123, -2.25414e-007>, <0.248121, 5.44988, -1.67677>, <0.955911, 0.143621, -0.256141>, <0.256873, 5.44988, -1.61029> , <0.989632, 0.143628, -8.64138e-008> }
	smooth_triangle { <0.248121, 5.44988, -1.67677>, <0.955911, 0.143621, -0.256141>, <0.26822, 5.36342, -1.61029>, <0.991498, 0.130123, -2.25414e-007>, <0.259079, 5.36342, -1.67971> , <0.957712, 0.130117, -0.256627> }
	smooth_triangle { <0.256873, 5.44988, -1.61029>, <0.989632, 0.143628, -8.64138e-008>, <0.235944, 5.52912, -1.67351>, <0.951674, 0.171156, -0.254996>, <0.244266, 5.52912, -1.61029> , <0.985245, 0.171152, 3.30604e-007> }
	smooth_triangle { <0.235944, 5.52912, -1.67351>, <0.951674, 0.171156, -0.254996>, <0.256873, 5.44988, -1.61029>, <0.989632, 0.143628, -8.64138e-008>, <0.248121, 5.44988, -1.67677> , <0.955911, 0.143621, -0.256141> }
	smooth_triangle { <0.244266, 5.52912, -1.61029>, <0.985245, 0.171152, 3.30604e-007>, <0.228638, 5.56926, -1.67155>, <0.949223, 0.185179, -0.254333>, <0.236704, 5.56926, -1.61029> , <0.982708, 0.185162, 6.08525e-007> }
	smooth_triangle { <0.228638, 5.56926, -1.67155>, <0.949223, 0.185179, -0.254333>, <0.244266, 5.52912, -1.61029>, <0.985245, 0.171152, 3.30604e-007>, <0.235944, 5.52912, -1.67351> , <0.951674, 0.171156, -0.254996> }
	smooth_triangle { <0.236704, 5.56926, -1.61029>, <0, 1, 0>, <0.22255, 5.56926, -1.66992>, <-0.185934, 0.981298, 0.0498262>, <0.2304, 5.56926, -1.61029> , <-0.192487, 0.981299, -3.96776e-006> }
	smooth_triangle { <0.22255, 5.56926, -1.66992>, <-0.185934, 0.981298, 0.0498262>, <0.236704, 5.56926, -1.61029>, <0, 1, 0>, <0.228638, 5.56926, -1.67155> , <0, 1, 0> }
	smooth_triangle { <0.2304, 5.56926, -1.61029>, <-0.192487, 0.981299, -3.96776e-006>, <0.217678, 5.5672, -1.66862>, <-0.36513, 0.9258, 0.0978469>, <0.225358, 5.5672, -1.61029> , <-0.378, 0.925806, -7.79176e-006> }
	smooth_triangle { <0.217678, 5.5672, -1.66862>, <-0.36513, 0.9258, 0.0978469>, <0.2304, 5.56926, -1.61029>, <-0.192487, 0.981299, -3.96776e-006>, <0.22255, 5.56926, -1.66992> , <-0.185934, 0.981298, 0.0498262> }
	smooth_triangle { <0.21646, 5.55794, -1.66829>, <-0.957092, 0.134936, 0.25645>, <0.225358, 5.5672, -1.61029>, <-0.990859, 0.1349, -1.05192e-007>, <0.217678, 5.5672, -1.66862> , <-0.957092, 0.134936, 0.25645> }
	smooth_triangle { <0.225358, 5.5672, -1.61029>, <-0.990859, 0.1349, -1.05192e-007>, <0.21646, 5.55794, -1.66829>, <-0.957092, 0.134936, 0.25645>, <0.224097, 5.55794, -1.61029> , <-0.990859, 0.1349, -1.05192e-007> }
	smooth_triangle { <0.0013722, 4.77442, -1.61066>, <0.137918, -0.989754, -0.0369676>, <0.0892096, 4.78708, -1.61029>, <0.142793, -0.989753, -2.01201e-007>, <0.0014206, 4.77442, -1.61029> , <0.142793, -0.989753, -2.01201e-007> }
	smooth_triangle { <0.0892096, 4.78708, -1.61029>, <0.142793, -0.989753, -2.01201e-007>, <0.0013722, 4.77442, -1.61066>, <0.137918, -0.989754, -0.0369676>, <0.0861699, 4.78708, -1.63338> , <0.137918, -0.989754, -0.0369676> }
	smooth_triangle { <0.00158693, 4.22409, -1.61121>, <-0.0248129, -0.99959, 0.0143233>, <0.284052, 4.21572, -1.6864>, <-0.0276742, -0.99959, 0.00741489>, <0.00176999, 4.22409, -1.61076> , <-0.0276742, -0.99959, 0.00741489> }
	smooth_triangle { <0.284052, 4.21572, -1.6864>, <-0.0276742, -0.99959, 0.00741489>, <0.00158693, 4.22409, -1.61121>, <-0.0248129, -0.99959, 0.0143233>, <0.254674, 4.21572, -1.75733> , <-0.0248129, -0.99959, 0.0143233> }
	smooth_triangle { <0.284052, 4.21572, -1.6864>, <0.962457, 0.0846599, -0.257895>, <0.253719, 4.2287, -1.75677>, <0.862916, 0.0846942, -0.498199>, <0.282986, 4.2287, -1.68612> , <0.962457, 0.0846599, -0.257895> }
	smooth_triangle { <0.253719, 4.2287, -1.75677>, <0.862916, 0.0846942, -0.498199>, <0.284052, 4.21572, -1.6864>, <0.962457, 0.0846599, -0.257895>, <0.254674, 4.21572, -1.75733> , <0.862916, 0.0846942, -0.498199> }
	smooth_triangle { <0.282986, 4.2287, -1.68612>, <0.437087, 0.891762, -0.117116>, <0.221138, 4.24779, -1.73796>, <0.305874, 0.935551, -0.176596>, <0.246648, 4.24779, -1.67638> , <0.341157, 0.935551, -0.091413> }
	smooth_triangle { <0.221138, 4.24779, -1.73796>, <0.305874, 0.935551, -0.176596>, <0.282986, 4.2287, -1.68612>, <0.437087, 0.891762, -0.117116>, <0.253719, 4.2287, -1.75677> , <0.391882, 0.891761, -0.226254> }
	smooth_triangle { <0.246648, 4.24779, -1.67638>, <0.341157, 0.935551, -0.091413>, <0.157063, 4.26688, -1.70097>, <0.185525, 0.976784, -0.107113>, <0.175181, 4.26688, -1.65723> , <0.206926, 0.976784, -0.0554459> }
	smooth_triangle { <0.157063, 4.26688, -1.70097>, <0.185525, 0.976784, -0.107113>, <0.246648, 4.24779, -1.67638>, <0.341157, 0.935551, -0.091413>, <0.221138, 4.24779, -1.73796> , <0.305874, 0.935551, -0.176596> }
	smooth_triangle { <0.175181, 4.26688, -1.65723>, <0.206926, 0.976784, -0.0554459>, <0.11145, 4.27643, -1.67464>, <0.139858, 0.986874, -0.0807473>, <0.124306, 4.27643, -1.6436> , <0.155992, 0.986874, -0.0417968> }
	smooth_triangle { <0.11145, 4.27643, -1.67464>, <0.139858, 0.986874, -0.0807473>, <0.175181, 4.26688, -1.65723>, <0.206926, 0.976784, -0.0554459>, <0.157063, 4.26688, -1.70097> , <0.185525, 0.976784, -0.107113> }
	smooth_triangle { <0.124306, 4.27643, -1.6436>, <0.155992, 0.986874, -0.0417968>, <0.0611789, 4.28491, -1.64561>, <0.125242, 0.989488, -0.0723072>, <0.0682361, 4.28491, -1.62857> , <0.139689, 0.989488, -0.0374288> }
	smooth_triangle { <0.0611789, 4.28491, -1.64561>, <0.125242, 0.989488, -0.0723072>, <0.124306, 4.27643, -1.6436>, <0.155992, 0.986874, -0.0417968>, <0.11145, 4.27643, -1.67464> , <0.139858, 0.986874, -0.0807473> }
	smooth_triangle { <0.0682361, 4.28491, -1.62857>, <0.782843, 0.585797, -0.209758>, <0.0545394, 4.29552, -1.64178>, <0.823841, 0.3083, -0.475643>, <0.0608309, 4.29552, -1.62659> , <0.918875, 0.308301, -0.24621> }
	smooth_triangle { <0.0545394, 4.29552, -1.64178>, <0.823841, 0.3083, -0.475643>, <0.0682361, 4.28491, -1.62857>, <0.782843, 0.585797, -0.209758>, <0.0611789, 4.28491, -1.64561> , <0.701877, 0.585796, -0.40523> }
	smooth_triangle { <0.0608309, 4.29552, -1.62659>, <0.918875, 0.308301, -0.24621>, <0.0545394, 4.30188, -1.64178>, <0.866027, 0, -0.499997>, <0.0608309, 4.30188, -1.62659> , <0.965925, 0, -0.258821> }
	smooth_triangle { <0.0545394, 4.30188, -1.64178>, <0.866027, 0, -0.499997>, <0.0608309, 4.29552, -1.62659>, <0.918875, 0.308301, -0.24621>, <0.0545394, 4.29552, -1.64178> , <0.823841, 0.3083, -0.475643> }
	smooth_triangle { <0.0608309, 4.30188, -1.62659>, <0.965925, 0, -0.258821>, <0.0545394, 4.30931, -1.64178>, <0.819284, 0.324094, -0.473009>, <0.0608309, 4.30931, -1.62659> , <0.913791, 0.324089, -0.244852> }
	smooth_triangle { <0.0545394, 4.30931, -1.64178>, <0.819284, 0.324094, -0.473009>, <0.0608309, 4.30188, -1.62659>, <0.965925, 0, -0.258821>, <0.0545394, 4.30188, -1.64178> , <0.866027, 0, -0.499997> }
	smooth_triangle { <0.0608309, 4.30931, -1.62659>, <0.913791, 0.324089, -0.244852>, <0.0488483, 4.31779, -1.63849>, <0.529964, 0.790897, -0.305975>, <0.0544832, 4.31779, -1.62489> , <0.591101, 0.790895, -0.158385> }
	smooth_triangle { <0.0488483, 4.31779, -1.63849>, <0.529964, 0.790897, -0.305975>, <0.0608309, 4.30931, -1.62659>, <0.913791, 0.324089, -0.244852>, <0.0545394, 4.30931, -1.64178> , <0.819284, 0.324094, -0.473009> }
	smooth_triangle { <0.0544832, 4.31779, -1.62489>, <0.591101, 0.790895, -0.158385>, <0.0403117, 4.32203, -1.63356>, <0.5489, 0.773484, -0.316908>, <0.0449618, 4.32203, -1.62234> , <0.612221, 0.773483, -0.164042> }
	smooth_triangle { <0.0403117, 4.32203, -1.63356>, <0.5489, 0.773484, -0.316908>, <0.0544832, 4.31779, -1.62489>, <0.591101, 0.790895, -0.158385>, <0.0488483, 4.31779, -1.63849> , <0.529964, 0.790897, -0.305975> }
	smooth_triangle { <0.0449618, 4.32203, -1.62234>, <0.612221, 0.773483, -0.164042>, <0.0365175, 4.3284, -1.63137>, <0.792712, 0.40267, -0.457673>, <0.0407301, 4.3284, -1.6212> , <0.884158, 0.402664, -0.23691> }
	smooth_triangle { <0.0365175, 4.3284, -1.63137>, <0.792712, 0.40267, -0.457673>, <0.0449618, 4.32203, -1.62234>, <0.612221, 0.773483, -0.164042>, <0.0403117, 4.32203, -1.63356> , <0.5489, 0.773484, -0.316908> }
	smooth_triangle { <0.0407301, 4.3284, -1.6212>, <0.884158, 0.402664, -0.23691>, <0.0346206, 4.33794, -1.63028>, <0.861233, 0.105024, -0.49724>, <0.0386144, 4.33794, -1.62064> , <0.960584, 0.105023, -0.257389> }
	smooth_triangle { <0.0346206, 4.33794, -1.63028>, <0.861233, 0.105024, -0.49724>, <0.0407301, 4.3284, -1.6212>, <0.884158, 0.402664, -0.23691>, <0.0365175, 4.3284, -1.63137> , <0.792712, 0.40267, -0.457673> }
	smooth_triangle { <0.0386144, 4.33794, -1.62064>, <0.960584, 0.105022, -0.257389>, <0.0393631, 4.69858, -1.63302>, <0.863039, -0.0829395, -0.498282>, <0.043904, 4.69858, -1.62205> , <0.962597, -0.0829378, -0.257931> }
	smooth_triangle { <0.0393631, 4.69858, -1.63302>, <0.863039, -0.0829395, -0.498282>, <0.0386144, 4.33794, -1.62064>, <0.960584, 0.105022, -0.257389>, <0.0346206, 4.33794, -1.63028> , <0.861233, 0.105024, -0.49724> }
	smooth_triangle { <0.043904, 4.69858, -1.62205>, <0.962597, -0.0829378, -0.257931>, <0.0412602, 4.71298, -1.63411>, <0.846092, -0.213319, -0.48849>, <0.0460197, 4.71298, -1.62262> , <0.943692, -0.213319, -0.252864> }
	smooth_triangle { <0.0412602, 4.71298, -1.63411>, <0.846092, -0.213319, -0.48849>, <0.043904, 4.69858, -1.62205>, <0.962597, -0.0829378, -0.257931>, <0.0393631, 4.69858, -1.63302> , <0.863039, -0.0829395, -0.498282> }
	smooth_triangle { <0.0460197, 4.71298, -1.62262>, <0.943692, -0.213319, -0.252864>, <0.0478998, 4.73974, -1.63795>, <0.822934, -0.311515, -0.47512>, <0.0534252, 4.73974, -1.62461> , <0.917863, -0.311515, -0.245939> }
	smooth_triangle { <0.0478998, 4.73974, -1.63795>, <0.822934, -0.311515, -0.47512>, <0.0460197, 4.71298, -1.62262>, <0.943692, -0.213319, -0.252864>, <0.0412602, 4.71298, -1.63411> , <0.846092, -0.213319, -0.48849> }
	smooth_triangle { <0.0534252, 4.73974, -1.62461>, <0.917863, -0.311515, -0.245939>, <0.0554879, 4.76341, -1.64233>, <0.721829, -0.552523, -0.416751>, <0.0618888, 4.76341, -1.62687> , <0.805096, -0.552524, -0.215726> }
	smooth_triangle { <0.0554879, 4.76341, -1.64233>, <0.721829, -0.552523, -0.416751>, <0.0534252, 4.73974, -1.62461>, <0.917863, -0.311515, -0.245939>, <0.0478998, 4.73974, -1.63795> , <0.822934, -0.311515, -0.47512> }
	smooth_triangle { <0.0554879, 4.76341, -1.64233>, <0.721829, -0.552523, -0.416751>, <0.0861699, 4.78708, -1.63338>, <0.507675, -0.850741, -0.136033>, <0.0618888, 4.76341, -1.62687> , <0.805096, -0.552524, -0.215726> }
	smooth_triangle { <0.0861699, 4.78708, -1.63338>, <0.507675, -0.850741, -0.136033>, <0.0554879, 4.76341, -1.64233>, <0.721829, -0.552523, -0.416751>, <0.0772578, 4.78708, -1.6549> , <0.45517, -0.85074, -0.262794> }
	smooth_triangle { <0.0772578, 4.78708, -1.6549>, <0.45517, -0.85074, -0.262794>, <0.134877, 4.80561, -1.64643>, <0.438348, -0.891097, -0.117457>, <0.0861699, 4.78708, -1.63338> , <0.507675, -0.850741, -0.136033> }
	smooth_triangle { <0.134877, 4.80561, -1.64643>, <0.438348, -0.891097, -0.117457>, <0.0772578, 4.78708, -1.6549>, <0.45517, -0.85074, -0.262794>, <0.120927, 4.80561, -1.68011> , <0.393013, -0.891097, -0.226909> }
	smooth_triangle { <0.120927, 4.80561, -1.68011>, <0.393013, -0.891097, -0.226909>, <0.182367, 4.83854, -1.65915>, <0.574848, -0.803632, -0.15403>, <0.134877, 4.80561, -1.64643> , <0.438348, -0.891097, -0.117457> }
	smooth_triangle { <0.182367, 4.83854, -1.65915>, <0.574848, -0.803632, -0.15403>, <0.120927, 4.80561, -1.68011>, <0.393013, -0.891097, -0.226909>, <0.163505, 4.83854, -1.70469> , <0.515394, -0.803631, -0.297566> }
	smooth_triangle { <0.163505, 4.83854, -1.70469>, <0.515394, -0.803631, -0.297566>, <0.212808, 4.86427, -1.66731>, <0.692614, -0.697026, -0.185584>, <0.182367, 4.83854, -1.65915> , <0.574848, -0.803632, -0.15403> }
	smooth_triangle { <0.212808, 4.86427, -1.66731>, <0.692614, -0.697026, -0.185584>, <0.163505, 4.83854, -1.70469>, <0.515394, -0.803631, -0.297566>, <0.190798, 4.86427, -1.72045> , <0.620978, -0.697026, -0.358526> }
	smooth_triangle { <0.212808, 4.86427, -1.66731>, <0.692614, -0.697025, -0.185584>, <0.214816, 4.90029, -1.73431>, <0.719064, -0.557309, -0.415155>, <0.239597, 4.90029, -1.67449> , <0.80201, -0.557313, -0.214901> }
	smooth_triangle { <0.214816, 4.90029, -1.73431>, <0.719064, -0.557309, -0.415155>, <0.212808, 4.86427, -1.66731>, <0.692614, -0.697025, -0.185584>, <0.190798, 4.86427, -1.72045> , <0.620978, -0.697026, -0.358526> }
	smooth_triangle { <0.239597, 4.90029, -1.67449>, <0.80201, -0.557313, -0.214901>, <0.233776, 4.938, -1.74526>, <0.794158, -0.398846, -0.458514>, <0.260744, 4.938, -1.68016> , <0.885769, -0.398849, -0.237345> }
	smooth_triangle { <0.233776, 4.938, -1.74526>, <0.794158, -0.398846, -0.458514>, <0.239597, 4.90029, -1.67449>, <0.80201, -0.557313, -0.214901>, <0.214816, 4.90029, -1.73431> , <0.719064, -0.557309, -0.415155> }
	smooth_triangle { <0.260744, 4.938, -1.68016>, <0.885769, -0.398849, -0.237345>, <0.250353, 5.00115, -1.75483>, <0.853284, -0.170886, -0.492651>, <0.279232, 5.00115, -1.68511> , <0.95172, -0.170877, -0.255012> }
	smooth_triangle { <0.250353, 5.00115, -1.75483>, <0.853284, -0.170886, -0.492651>, <0.260744, 4.938, -1.68016>, <0.885769, -0.398849, -0.237345>, <0.233776, 4.938, -1.74526> , <0.794158, -0.398846, -0.458514> }
	smooth_triangle { <0.279232, 5.00115, -1.68511>, <0.95172, -0.170877, -0.255012>, <0.254119, 5.08966, -1.75701>, <0.866011, 0.00603599, -0.499988>, <0.283432, 5.08966, -1.68624> , <0.965909, 0.00603943, -0.258811> }
	smooth_triangle { <0.254119, 5.08966, -1.75701>, <0.866011, 0.00603599, -0.499988>, <0.279232, 5.00115, -1.68511>, <0.95172, -0.170877, -0.255012>, <0.250353, 5.00115, -1.75483> , <0.853284, -0.170886, -0.492651> }
	smooth_triangle { <0.283432, 5.08966, -1.68624>, <0.965909, 0.00603943, -0.258811>, <0.24866, 5.19258, -1.75385>, <0.862982, 0.083801, -0.498236>, <0.277344, 5.19258, -1.6846> , <0.962528, 0.0837983, -0.257911> }
	smooth_triangle { <0.24866, 5.19258, -1.75385>, <0.862982, 0.083801, -0.498236>, <0.283432, 5.08966, -1.68624>, <0.965909, 0.00603943, -0.258811>, <0.254119, 5.08966, -1.75701> , <0.866011, 0.00603599, -0.499988> }
	smooth_triangle { <0.277344, 5.19258, -1.6846>, <0.962528, 0.0837983, -0.257911>, <0.238834, 5.29859, -1.74818>, <0.860661, 0.111147, -0.496899>, <0.266385, 5.29859, -1.68167> , <0.95994, 0.111145, -0.25722> }
	smooth_triangle { <0.238834, 5.29859, -1.74818>, <0.860661, 0.111147, -0.496899>, <0.277344, 5.19258, -1.6846>, <0.962528, 0.0837983, -0.257911>, <0.24866, 5.19258, -1.75385> , <0.862982, 0.083801, -0.498236> }
	smooth_triangle { <0.266385, 5.29859, -1.68167>, <0.95994, 0.111145, -0.25722>, <0.232284, 5.36342, -1.7444>, <0.860195, 0.115874, -0.496627>, <0.259079, 5.36342, -1.67971> , <0.95942, 0.115867, -0.257078> }
	smooth_triangle { <0.232284, 5.36342, -1.7444>, <0.860195, 0.115874, -0.496627>, <0.266385, 5.29859, -1.68167>, <0.95994, 0.111145, -0.25722>, <0.238834, 5.29859, -1.74818> , <0.860661, 0.111147, -0.496899> }
	smooth_triangle { <0.259079, 5.36342, -1.67971>, <0.957712, 0.130117, -0.256627>, <0.222458, 5.44988, -1.73873>, <0.857044, 0.14362, -0.494823>, <0.248121, 5.44988, -1.67677> , <0.955911, 0.143621, -0.256141> }
	smooth_triangle { <0.222458, 5.44988, -1.73873>, <0.857044, 0.14362, -0.494823>, <0.259079, 5.36342, -1.67971>, <0.957712, 0.130117, -0.256627>, <0.232284, 5.36342, -1.7444> , <0.858661, 0.130126, -0.49575> }
	smooth_triangle { <0.248121, 5.44988, -1.67677>, <0.955911, 0.143621, -0.256141>, <0.211542, 5.52912, -1.73242>, <0.853243, 0.171156, -0.492627>, <0.235944, 5.52912, -1.67351> , <0.951674, 0.171156, -0.254996> }
	smooth_triangle { <0.211542, 5.52912, -1.73242>, <0.853243, 0.171156, -0.492627>, <0.248121, 5.44988, -1.67677>, <0.955911, 0.143621, -0.256141>, <0.222458, 5.44988, -1.73873> , <0.857044, 0.14362, -0.494823> }
	smooth_triangle { <0.235944, 5.52912, -1.67351>, <0.951674, 0.171156, -0.254996>, <0.204992, 5.56926, -1.72864>, <0.851047, 0.18519, -0.49135>, <0.228638, 5.56926, -1.67155> , <0.949223, 0.185179, -0.254333> }
	smooth_triangle { <0.204992, 5.56926, -1.72864>, <0.851047, 0.18519, -0.49135>, <0.235944, 5.52912, -1.67351>, <0.951674, 0.171156, -0.254996>, <0.211542, 5.52912, -1.73242> , <0.853243, 0.171156, -0.492627> }
	smooth_triangle { <0.228638, 5.56926, -1.67155>, <0, 1, 0>, <0.199532, 5.56926, -1.72549>, <-0.16673, 0.981293, 0.0962598>, <0.22255, 5.56926, -1.66992> , <-0.185934, 0.981298, 0.0498262> }
	smooth_triangle { <0.199532, 5.56926, -1.72549>, <-0.16673, 0.981293, 0.0962598>, <0.228638, 5.56926, -1.67155>, <0, 1, 0>, <0.204992, 5.56926, -1.72864> , <0, 1, 0> }
	smooth_triangle { <0.22255, 5.56926, -1.66992>, <-0.185934, 0.981298, 0.0498262>, <0.195166, 5.5672, -1.72297>, <-0.327416, 0.925779, 0.18903>, <0.217678, 5.5672, -1.66862> , <-0.36513, 0.9258, 0.0978469> }
	smooth_triangle { <0.195166, 5.5672, -1.72297>, <-0.327416, 0.925779, 0.18903>, <0.22255, 5.56926, -1.66992>, <-0.185934, 0.981298, 0.0498262>, <0.199532, 5.56926, -1.72549> , <-0.16673, 0.981293, 0.0962598> }
	smooth_triangle { <0.194073, 5.55794, -1.72234>, <-0.858112, 0.134934, 0.495416>, <0.217678, 5.5672, -1.66862>, <-0.957092, 0.134936, 0.25645>, <0.195166, 5.5672, -1.72297> , <-0.858112, 0.134934, 0.495416> }
	smooth_triangle { <0.217678, 5.5672, -1.66862>, <-0.957092, 0.134936, 0.25645>, <0.194073, 5.55794, -1.72234>, <-0.858112, 0.134934, 0.495416>, <0.21646, 5.55794, -1.66829> , <-0.957092, 0.134936, 0.25645> }
	smooth_triangle { <0.00123028, 4.77442, -1.611>, <0.12365, -0.989753, -0.0714128>, <0.0861699, 4.78708, -1.63338>, <0.137918, -0.989754, -0.0369676>, <0.0013722, 4.77442, -1.61066> , <0.137918, -0.989754, -0.0369676> }
	smooth_triangle { <0.0861699, 4.78708, -1.63338>, <0.137918, -0.989754, -0.0369676>, <0.00123028, 4.77442, -1.611>, <0.12365, -0.989753, -0.0714128>, <0.0772578, 4.78708, -1.6549> , <0.12365, -0.989753, -0.0714128> }
	smooth_triangle { <0.00129573, 4.22409, -1.61159>, <-0.0202573, -0.99959, 0.020259>, <0.254674, 4.21572, -1.75733>, <-0.0248129, -0.99959, 0.0143233>, <0.00158693, 4.22409, -1.61121> , <-0.0248129, -0.99959, 0.0143233> }
	smooth_triangle { <0.254674, 4.21572, -1.75733>, <-0.0248129, -0.99959, 0.0143233>, <0.00129573, 4.22409, -1.61159>, <-0.0202573, -0.99959, 0.020259>, <0.207941, 4.21572, -1.81823> , <-0.0202573, -0.99959, 0.020259> }
	smooth_triangle { <0.254674, 4.21572, -1.75733>, <0.862916, 0.0846942, -0.498199>, <0.20716, 4.2287, -1.81745>, <0.704565, 0.0847009, -0.704566>, <0.253719, 4.2287, -1.75677> , <0.862916, 0.0846942, -0.498199> }
	smooth_triangle { <0.20716, 4.2287, -1.81745>, <0.704565, 0.0847009, -0.704566>, <0.254674, 4.21572, -1.75733>, <0.862916, 0.0846942, -0.498199>, <0.207941, 4.21572, -1.81823> , <0.704565, 0.0847009, -0.704566> }
	smooth_triangle { <0.253719, 4.2287, -1.75677>, <0.391882, 0.891761, -0.226254>, <0.180559, 4.24779, -1.79085>, <0.249745, 0.935551, -0.249745>, <0.221138, 4.24779, -1.73796> , <0.305874, 0.935551, -0.176596> }
	smooth_triangle { <0.180559, 4.24779, -1.79085>, <0.249745, 0.935551, -0.249745>, <0.253719, 4.2287, -1.75677>, <0.391882, 0.891761, -0.226254>, <0.20716, 4.2287, -1.81745> , <0.319972, 0.89176, -0.319971> }
	smooth_triangle { <0.221138, 4.24779, -1.73796>, <0.305873, 0.935551, -0.176596>, <0.128241, 4.26688, -1.73853>, <0.15148, 0.976784, -0.15148>, <0.157063, 4.26688, -1.70097> , <0.185525, 0.976784, -0.107113> }
	smooth_triangle { <0.128241, 4.26688, -1.73853>, <0.15148, 0.976784, -0.15148>, <0.221138, 4.24779, -1.73796>, <0.305873, 0.935551, -0.176596>, <0.180559, 4.24779, -1.79085> , <0.249745, 0.935551, -0.249745> }
	smooth_triangle { <0.157063, 4.26688, -1.70097>, <0.185525, 0.976784, -0.107113>, <0.0909985, 4.27643, -1.70129>, <0.114194, 0.986874, -0.114194>, <0.11145, 4.27643, -1.67464> , <0.139858, 0.986874, -0.0807473> }
	smooth_triangle { <0.0909985, 4.27643, -1.70129>, <0.114194, 0.986874, -0.114194>, <0.157063, 4.26688, -1.70097>, <0.185525, 0.976784, -0.107113>, <0.128241, 4.26688, -1.73853> , <0.15148, 0.976784, -0.15148> }
	smooth_triangle { <0.11145, 4.27643, -1.67464>, <0.139858, 0.986874, -0.0807473>, <0.0499523, 4.28491, -1.66024>, <0.102259, 0.989488, -0.102259>, <0.0611789, 4.28491, -1.64561> , <0.125242, 0.989488, -0.0723072> }
	smooth_triangle { <0.0499523, 4.28491, -1.66024>, <0.102259, 0.989488, -0.102259>, <0.11145, 4.27643, -1.67464>, <0.139858, 0.986874, -0.0807473>, <0.0909985, 4.27643, -1.70129> , <0.114194, 0.986874, -0.114194> }
	smooth_triangle { <0.0611789, 4.28491, -1.64561>, <0.701877, 0.585796, -0.40523>, <0.0445314, 4.29552, -1.65482>, <0.672664, 0.308295, -0.672664>, <0.0545394, 4.29552, -1.64178> , <0.823841, 0.3083, -0.475643> }
	smooth_triangle { <0.0445314, 4.29552, -1.65482>, <0.672664, 0.308295, -0.672664>, <0.0611789, 4.28491, -1.64561>, <0.701877, 0.585796, -0.40523>, <0.0499523, 4.28491, -1.66024> , <0.573082, 0.585788, -0.573088> }
	smooth_triangle { <0.0545394, 4.29552, -1.64178>, <0.823841, 0.3083, -0.475643>, <0.0445314, 4.30188, -1.65482>, <0.70711, 0, -0.707103>, <0.0545394, 4.30188, -1.64178> , <0.866027, 0, -0.499997> }
	smooth_triangle { <0.0445314, 4.30188, -1.65482>, <0.70711, 0, -0.707103>, <0.0545394, 4.29552, -1.64178>, <0.823841, 0.3083, -0.475643>, <0.0445314, 4.29552, -1.65482> , <0.672664, 0.308295, -0.672664> }
	smooth_triangle { <0.0545394, 4.30188, -1.64178>, <0.866027, 0, -0.499997>, <0.0445314, 4.30931, -1.65482>, <0.668943, 0.324098, -0.668937>, <0.0545394, 4.30931, -1.64178> , <0.819284, 0.324094, -0.473009> }
	smooth_triangle { <0.0445314, 4.30931, -1.65482>, <0.668943, 0.324098, -0.668937>, <0.0545394, 4.30188, -1.64178>, <0.866027, 0, -0.499997>, <0.0445314, 4.30188, -1.65482> , <0.70711, 0, -0.707103> }
	smooth_triangle { <0.0545394, 4.30931, -1.64178>, <0.819284, 0.324094, -0.473009>, <0.0398843, 4.31779, -1.65017>, <0.432713, 0.790898, -0.432712>, <0.0488483, 4.31779, -1.63849> , <0.529964, 0.790897, -0.305975> }
	smooth_triangle { <0.0398843, 4.31779, -1.65017>, <0.432713, 0.790898, -0.432712>, <0.0545394, 4.30931, -1.64178>, <0.819284, 0.324094, -0.473009>, <0.0445314, 4.30931, -1.65482> , <0.668943, 0.324098, -0.668937> }
	smooth_triangle { <0.0488483, 4.31779, -1.63849>, <0.529964, 0.790897, -0.305975>, <0.0329144, 4.32203, -1.6432>, <0.448179, 0.773481, -0.448178>, <0.0403117, 4.32203, -1.63356> , <0.5489, 0.773484, -0.316908> }
	smooth_triangle { <0.0329144, 4.32203, -1.6432>, <0.448179, 0.773481, -0.448178>, <0.0488483, 4.31779, -1.63849>, <0.529964, 0.790897, -0.305975>, <0.0398843, 4.31779, -1.65017> , <0.432713, 0.790898, -0.432712> }
	smooth_triangle { <0.0403117, 4.32203, -1.63356>, <0.5489, 0.773484, -0.316908>, <0.0298165, 4.3284, -1.64011>, <0.647251, 0.402668, -0.647244>, <0.0365175, 4.3284, -1.63137> , <0.792712, 0.40267, -0.457673> }
	smooth_triangle { <0.0298165, 4.3284, -1.64011>, <0.647251, 0.402668, -0.647244>, <0.0403117, 4.32203, -1.63356>, <0.5489, 0.773484, -0.316908>, <0.0329144, 4.32203, -1.6432> , <0.448179, 0.773481, -0.448178> }
	smooth_triangle { <0.0365175, 4.3284, -1.63137>, <0.792712, 0.40267, -0.457673>, <0.0282676, 4.33794, -1.63856>, <0.7032, 0.105027, -0.703192>, <0.0346206, 4.33794, -1.63028> , <0.861233, 0.105024, -0.49724> }
	smooth_triangle { <0.0282676, 4.33794, -1.63856>, <0.7032, 0.105027, -0.703192>, <0.0365175, 4.3284, -1.63137>, <0.792712, 0.40267, -0.457673>, <0.0298165, 4.3284, -1.64011> , <0.647251, 0.402668, -0.647244> }
	smooth_triangle { <0.0346206, 4.33794, -1.63028>, <0.861233, 0.105024, -0.49724>, <0.0321399, 4.69858, -1.64243>, <0.704672, -0.0829369, -0.704669>, <0.0393631, 4.69858, -1.63302> , <0.863039, -0.0829395, -0.498282> }
	smooth_triangle { <0.0321399, 4.69858, -1.64243>, <0.704672, -0.0829369, -0.704669>, <0.0346206, 4.33794, -1.63028>, <0.861233, 0.105024, -0.49724>, <0.0282676, 4.33794, -1.63856> , <0.7032, 0.105027, -0.703192> }
	smooth_triangle { <0.0393631, 4.69858, -1.63302>, <0.863039, -0.0829395, -0.498282>, <0.0336888, 4.71298, -1.64398>, <0.690831, -0.213318, -0.690832>, <0.0412602, 4.71298, -1.63411> , <0.846092, -0.213319, -0.48849> }
	smooth_triangle { <0.0336888, 4.71298, -1.64398>, <0.690831, -0.213318, -0.690832>, <0.0393631, 4.69858, -1.63302>, <0.863039, -0.0829395, -0.498282>, <0.0321399, 4.69858, -1.64243> , <0.704672, -0.0829369, -0.704669> }
	smooth_triangle { <0.0412602, 4.71298, -1.63411>, <0.846092, -0.213319, -0.48849>, <0.0391099, 4.73974, -1.6494>, <0.67192, -0.311518, -0.671922>, <0.0478998, 4.73974, -1.63795> , <0.822934, -0.311515, -0.47512> }
	smooth_triangle { <0.0391099, 4.73974, -1.6494>, <0.67192, -0.311518, -0.671922>, <0.0412602, 4.71298, -1.63411>, <0.846092, -0.213319, -0.48849>, <0.0336888, 4.71298, -1.64398> , <0.690831, -0.213318, -0.690832> }
	smooth_triangle { <0.0478998, 4.73974, -1.63795>, <0.822934, -0.311515, -0.47512>, <0.0453058, 4.76341, -1.6556>, <0.589374, -0.552523, -0.58937>, <0.0554879, 4.76341, -1.64233> , <0.721829, -0.552523, -0.416751> }
	smooth_triangle { <0.0453058, 4.76341, -1.6556>, <0.589374, -0.552523, -0.58937>, <0.0478998, 4.73974, -1.63795>, <0.822934, -0.311515, -0.47512>, <0.0391099, 4.73974, -1.6494> , <0.67192, -0.311518, -0.671922> }
	smooth_triangle { <0.0453058, 4.76341, -1.6556>, <0.589374, -0.552523, -0.58937>, <0.0772578, 4.78708, -1.6549>, <0.45517, -0.85074, -0.262794>, <0.0554879, 4.76341, -1.64233> , <0.721829, -0.552523, -0.416751> }
	smooth_triangle { <0.0772578, 4.78708, -1.6549>, <0.45517, -0.85074, -0.262794>, <0.0453058, 4.76341, -1.6556>, <0.589374, -0.552523, -0.58937>, <0.0630807, 4.78708, -1.67337> , <0.371648, -0.85074, -0.371644> }
	smooth_triangle { <0.0630807, 4.78708, -1.67337>, <0.371648, -0.85074, -0.371644>, <0.120927, 4.80561, -1.68011>, <0.393013, -0.891097, -0.226909>, <0.0772578, 4.78708, -1.6549> , <0.45517, -0.85074, -0.262794> }
	smooth_triangle { <0.120927, 4.80561, -1.68011>, <0.393013, -0.891097, -0.226909>, <0.0630807, 4.78708, -1.67337>, <0.371648, -0.85074, -0.371644>, <0.0987366, 4.80561, -1.70903> , <0.320894, -0.891097, -0.320895> }
	smooth_triangle { <0.0987366, 4.80561, -1.70903>, <0.320894, -0.891097, -0.320895>, <0.163505, 4.83854, -1.70469>, <0.515394, -0.803631, -0.297566>, <0.120927, 4.80561, -1.68011> , <0.393013, -0.891097, -0.226909> }
	smooth_triangle { <0.163505, 4.83854, -1.70469>, <0.515394, -0.803631, -0.297566>, <0.0987366, 4.80561, -1.70903>, <0.320894, -0.891097, -0.320895>, <0.133501, 4.83854, -1.74379> , <0.420817, -0.803632, -0.420818> }
	smooth_triangle { <0.133501, 4.83854, -1.74379>, <0.420817, -0.803632, -0.420818>, <0.190798, 4.86427, -1.72045>, <0.620978, -0.697026, -0.358526>, <0.163505, 4.83854, -1.70469> , <0.515394, -0.803631, -0.297566> }
	smooth_triangle { <0.190798, 4.86427, -1.72045>, <0.620978, -0.697026, -0.358526>, <0.133501, 4.83854, -1.74379>, <0.420817, -0.803632, -0.420818>, <0.155786, 4.86427, -1.76608> , <0.507028, -0.697025, -0.507029> }
	smooth_triangle { <0.190798, 4.86427, -1.72045>, <0.620978, -0.697026, -0.358526>, <0.175396, 4.90029, -1.78569>, <0.587114, -0.557309, -0.587115>, <0.214816, 4.90029, -1.73431> , <0.719064, -0.557309, -0.415155> }
	smooth_triangle { <0.175396, 4.90029, -1.78569>, <0.587114, -0.557309, -0.587115>, <0.190798, 4.86427, -1.72045>, <0.620978, -0.697026, -0.358526>, <0.155786, 4.86427, -1.76608> , <0.507028, -0.697025, -0.507029> }
	smooth_triangle { <0.214816, 4.90029, -1.73431>, <0.719064, -0.557309, -0.415155>, <0.190877, 4.938, -1.80117>, <0.648429, -0.398846, -0.64843>, <0.233776, 4.938, -1.74526> , <0.794158, -0.398846, -0.458514> }
	smooth_triangle { <0.190877, 4.938, -1.80117>, <0.648429, -0.398846, -0.64843>, <0.214816, 4.90029, -1.73431>, <0.719064, -0.557309, -0.415155>, <0.175396, 4.90029, -1.78569> , <0.587114, -0.557309, -0.587115> }
	smooth_triangle { <0.233776, 4.938, -1.74526>, <0.794158, -0.398846, -0.458514>, <0.204411, 5.00115, -1.8147>, <0.696705, -0.170886, -0.696706>, <0.250353, 5.00115, -1.75483> , <0.853284, -0.170886, -0.492651> }
	smooth_triangle { <0.204411, 5.00115, -1.8147>, <0.696705, -0.170886, -0.696706>, <0.233776, 4.938, -1.74526>, <0.794158, -0.398846, -0.458514>, <0.190877, 4.938, -1.80117> , <0.648429, -0.398846, -0.64843> }
	smooth_triangle { <0.250353, 5.00115, -1.75483>, <0.853284, -0.170886, -0.492651>, <0.207488, 5.08966, -1.81778>, <0.707093, 0.00603566, -0.707094>, <0.254119, 5.08966, -1.75701> , <0.866011, 0.006036, -0.499988> }
	smooth_triangle { <0.207488, 5.08966, -1.81778>, <0.707093, 0.00603566, -0.707094>, <0.250353, 5.00115, -1.75483>, <0.853284, -0.170886, -0.492651>, <0.204411, 5.00115, -1.8147> , <0.696705, -0.170886, -0.696706> }
	smooth_triangle { <0.254119, 5.08966, -1.75701>, <0.866012, 0.006036, -0.499988>, <0.20303, 5.19258, -1.81332>, <0.70462, 0.0838012, -0.70462>, <0.24866, 5.19258, -1.75385> , <0.862982, 0.083801, -0.498236> }
	smooth_triangle { <0.20303, 5.19258, -1.81332>, <0.70462, 0.0838012, -0.70462>, <0.254119, 5.08966, -1.75701>, <0.866012, 0.006036, -0.499988>, <0.207488, 5.08966, -1.81778> , <0.707093, 0.00603566, -0.707094> }
	smooth_triangle { <0.24866, 5.19258, -1.75385>, <0.862982, 0.083801, -0.498236>, <0.195008, 5.29859, -1.8053>, <0.702725, 0.111149, -0.702725>, <0.238834, 5.29859, -1.74818> , <0.860661, 0.111147, -0.496899> }
	smooth_triangle { <0.195008, 5.29859, -1.8053>, <0.702725, 0.111149, -0.702725>, <0.24866, 5.19258, -1.75385>, <0.862982, 0.083801, -0.498236>, <0.20303, 5.19258, -1.81332> , <0.70462, 0.0838012, -0.70462> }
	smooth_triangle { <0.238834, 5.29859, -1.74818>, <0.860661, 0.111147, -0.496899>, <0.189659, 5.36342, -1.79995>, <0.702343, 0.115878, -0.702344>, <0.232284, 5.36342, -1.7444> , <0.860195, 0.115874, -0.496627> }
	smooth_triangle { <0.189659, 5.36342, -1.79995>, <0.702343, 0.115878, -0.702344>, <0.238834, 5.29859, -1.74818>, <0.860661, 0.111147, -0.496899>, <0.195008, 5.29859, -1.8053> , <0.702725, 0.111149, -0.702725> }
	smooth_triangle { <0.232284, 5.36342, -1.7444>, <0.858661, 0.130126, -0.49575>, <0.181636, 5.44988, -1.79193>, <0.699773, 0.143622, -0.699779>, <0.222458, 5.44988, -1.73873> , <0.857044, 0.14362, -0.494823> }
	smooth_triangle { <0.181636, 5.44988, -1.79193>, <0.699773, 0.143622, -0.699779>, <0.232284, 5.36342, -1.7444>, <0.858661, 0.130126, -0.49575>, <0.189659, 5.36342, -1.79995> , <0.701091, 0.130126, -0.701098> }
	smooth_triangle { <0.222458, 5.44988, -1.73873>, <0.857044, 0.14362, -0.494823>, <0.172723, 5.52912, -1.78301>, <0.696669, 0.17115, -0.696678>, <0.211542, 5.52912, -1.73242> , <0.853243, 0.171156, -0.492627> }
	smooth_triangle { <0.172723, 5.52912, -1.78301>, <0.696669, 0.17115, -0.696678>, <0.222458, 5.44988, -1.73873>, <0.857044, 0.14362, -0.494823>, <0.181636, 5.44988, -1.79193> , <0.699773, 0.143622, -0.699779> }
	smooth_triangle { <0.211542, 5.52912, -1.73242>, <0.853243, 0.171156, -0.492627>, <0.167374, 5.56926, -1.77766>, <0.694873, 0.185173, -0.694883>, <0.204992, 5.56926, -1.72864> , <0.851047, 0.18519, -0.49135> }
	smooth_triangle { <0.167374, 5.56926, -1.77766>, <0.694873, 0.185173, -0.694883>, <0.211542, 5.52912, -1.73242>, <0.853243, 0.171156, -0.492627>, <0.172723, 5.52912, -1.78301> , <0.696669, 0.17115, -0.696678> }
	smooth_triangle { <0.204992, 5.56926, -1.72864>, <0, 1, 0>, <0.162918, 5.56926, -1.77321>, <-0.136131, 0.981293, 0.136133>, <0.199532, 5.56926, -1.72549> , <-0.16673, 0.981293, 0.0962598> }
	smooth_triangle { <0.162918, 5.56926, -1.77321>, <-0.136131, 0.981293, 0.136133>, <0.204992, 5.56926, -1.72864>, <0, 1, 0>, <0.167374, 5.56926, -1.77766> , <0, 1, 0> }
	smooth_triangle { <0.199532, 5.56926, -1.72549>, <-0.16673, 0.981293, 0.0962598>, <0.159353, 5.5672, -1.76964>, <-0.267328, 0.92578, 0.267332>, <0.195166, 5.5672, -1.72297> , <-0.327416, 0.925779, 0.18903> }
	smooth_triangle { <0.159353, 5.5672, -1.76964>, <-0.267328, 0.92578, 0.267332>, <0.199532, 5.56926, -1.72549>, <-0.16673, 0.981293, 0.0962598>, <0.162918, 5.56926, -1.77321> , <-0.136131, 0.981293, 0.136133> }
	smooth_triangle { <0.158461, 5.55794, -1.76875>, <-0.70064, 0.134955, 0.700636>, <0.195166, 5.5672, -1.72297>, <-0.858112, 0.134934, 0.495416>, <0.159353, 5.5672, -1.76964> , <-0.70064, 0.134955, 0.700636> }
	smooth_triangle { <0.195166, 5.5672, -1.72297>, <-0.858112, 0.134934, 0.495416>, <0.158461, 5.55794, -1.76875>, <-0.70064, 0.134955, 0.700636>, <0.194073, 5.55794, -1.72234> , <-0.858112, 0.134934, 0.495416> }
	smooth_triangle { <0.00100452, 4.77442, -1.61129>, <0.101003, -0.989751, -0.100949>, <0.0772578, 4.78708, -1.6549>, <0.12365, -0.989753, -0.0714128>, <0.00123028, 4.77442, -1.611> , <0.12365, -0.989753, -0.0714128> }
	smooth_triangle { <0.0772578, 4.78708, -1.6549>, <0.12365, -0.989753, -0.0714128>, <0.00100452, 4.77442, -1.61129>, <0.101003, -0.989751, -0.100949>, <0.0630807, 4.78708, -1.67337> , <0.101003, -0.989751, -0.100949> }
	smooth_triangle { <0.000916216, 4.22409, -1.61188>, <-0.0143241, -0.99959, 0.0248126>, <0.207941, 4.21572, -1.81823>, <-0.0202573, -0.99959, 0.020259>, <0.00129573, 4.22409, -1.61159> , <-0.0202573, -0.99959, 0.020259> }
	smooth_triangle { <0.207941, 4.21572, -1.81823>, <-0.0202573, -0.99959, 0.020259>, <0.000916216, 4.22409, -1.61188>, <-0.0143241, -0.99959, 0.0248126>, <0.147036, 4.21572, -1.86496> , <-0.0143241, -0.99959, 0.0248126> }
	smooth_triangle { <0.147036, 4.21572, -1.86496>, <0.498201, 0.0846679, -0.862918>, <0.20716, 4.2287, -1.81745>, <0.704565, 0.0847009, -0.704566>, <0.207941, 4.21572, -1.81823> , <0.704565, 0.0847009, -0.704566> }
	smooth_triangle { <0.20716, 4.2287, -1.81745>, <0.704565, 0.0847009, -0.704566>, <0.147036, 4.21572, -1.86496>, <0.498201, 0.0846679, -0.862918>, <0.146484, 4.2287, -1.86401> , <0.498201, 0.0846679, -0.862918> }
	smooth_triangle { <0.20716, 4.2287, -1.81745>, <0.319972, 0.89176, -0.319971>, <0.127674, 4.24779, -1.83143>, <0.176596, 0.935551, -0.305874>, <0.180559, 4.24779, -1.79085> , <0.249745, 0.935551, -0.249745> }
	smooth_triangle { <0.127674, 4.24779, -1.83143>, <0.176596, 0.935551, -0.305874>, <0.20716, 4.2287, -1.81745>, <0.319972, 0.89176, -0.319971>, <0.146484, 4.2287, -1.86401> , <0.226252, 0.891761, -0.391882> }
	smooth_triangle { <0.180559, 4.24779, -1.79085>, <0.249745, 0.935551, -0.249745>, <0.0906801, 4.26688, -1.76735>, <0.107113, 0.976784, -0.185525>, <0.128241, 4.26688, -1.73853> , <0.15148, 0.976784, -0.15148> }
	smooth_triangle { <0.0906801, 4.26688, -1.76735>, <0.107113, 0.976784, -0.185525>, <0.180559, 4.24779, -1.79085>, <0.249745, 0.935551, -0.249745>, <0.127674, 4.24779, -1.83143> , <0.176596, 0.935551, -0.305874> }
	smooth_triangle { <0.128241, 4.26688, -1.73853>, <0.15148, 0.976784, -0.15148>, <0.0643457, 4.27643, -1.72174>, <0.0807468, 0.986874, -0.139858>, <0.0909985, 4.27643, -1.70129> , <0.114194, 0.986874, -0.114194> }
	smooth_triangle { <0.0643457, 4.27643, -1.72174>, <0.0807468, 0.986874, -0.139858>, <0.128241, 4.26688, -1.73853>, <0.15148, 0.976784, -0.15148>, <0.0906801, 4.26688, -1.76735> , <0.107113, 0.976784, -0.185525> }
	smooth_triangle { <0.0909985, 4.27643, -1.70129>, <0.114194, 0.986874, -0.114194>, <0.0353216, 4.28491, -1.67147>, <0.0723071, 0.989488, -0.125242>, <0.0499523, 4.28491, -1.66024> , <0.102259, 0.989488, -0.102259> }
	smooth_triangle { <0.0353216, 4.28491, -1.67147>, <0.0723071, 0.989488, -0.125242>, <0.0909985, 4.27643, -1.70129>, <0.114194, 0.986874, -0.114194>, <0.0643457, 4.27643, -1.72174> , <0.0807468, 0.986874, -0.139858> }
	smooth_triangle { <0.0353216, 4.28491, -1.67147>, <0.405229, 0.585782, -0.701889>, <0.0445314, 4.29552, -1.65482>, <0.672664, 0.308295, -0.672664>, <0.0499523, 4.28491, -1.66024> , <0.573082, 0.585788, -0.573088> }
	smooth_triangle { <0.0445314, 4.29552, -1.65482>, <0.672664, 0.308295, -0.672664>, <0.0353216, 4.28491, -1.67147>, <0.405229, 0.585782, -0.701889>, <0.0314883, 4.29552, -1.66483> , <0.475644, 0.308292, -0.823844> }
	smooth_triangle { <0.0314883, 4.29552, -1.66483>, <0.475644, 0.308292, -0.823844>, <0.0445314, 4.30188, -1.65482>, <0.70711, 0, -0.707103>, <0.0445314, 4.29552, -1.65482> , <0.672664, 0.308295, -0.672664> }
	smooth_triangle { <0.0445314, 4.30188, -1.65482>, <0.70711, 0, -0.707103>, <0.0314883, 4.29552, -1.66483>, <0.475644, 0.308292, -0.823844>, <0.0314883, 4.30188, -1.66483> , <0.500001, 0, -0.866025> }
	smooth_triangle { <0.0314883, 4.30188, -1.66483>, <0.500001, 0, -0.866025>, <0.0445314, 4.30931, -1.65482>, <0.668943, 0.324098, -0.668937>, <0.0445314, 4.30188, -1.65482> , <0.70711, 0, -0.707103> }
	smooth_triangle { <0.0445314, 4.30931, -1.65482>, <0.668943, 0.324098, -0.668937>, <0.0314883, 4.30188, -1.66483>, <0.500001, 0, -0.866025>, <0.0314883, 4.30931, -1.66483> , <0.473013, 0.324096, -0.819281> }
	smooth_triangle { <0.0314883, 4.30931, -1.66483>, <0.473013, 0.324096, -0.819281>, <0.0398843, 4.31779, -1.65017>, <0.432713, 0.790898, -0.432712>, <0.0445314, 4.30931, -1.65482> , <0.668943, 0.324098, -0.668937> }
	smooth_triangle { <0.0398843, 4.31779, -1.65017>, <0.432713, 0.790898, -0.432712>, <0.0314883, 4.30931, -1.66483>, <0.473013, 0.324096, -0.819281>, <0.0282025, 4.31779, -1.65914> , <0.305975, 0.790899, -0.52996> }
	smooth_triangle { <0.0398843, 4.31779, -1.65017>, <0.432713, 0.790898, -0.432712>, <0.0232739, 4.32203, -1.6506>, <0.316906, 0.773484, -0.548901>, <0.0329144, 4.32203, -1.6432> , <0.448179, 0.773481, -0.448178> }
	smooth_triangle { <0.0232739, 4.32203, -1.6506>, <0.316906, 0.773484, -0.548901>, <0.0398843, 4.31779, -1.65017>, <0.432713, 0.790898, -0.432712>, <0.0282025, 4.31779, -1.65914> , <0.305975, 0.790899, -0.52996> }
	smooth_triangle { <0.0232739, 4.32203, -1.6506>, <0.316906, 0.773484, -0.548901>, <0.0298165, 4.3284, -1.64011>, <0.647251, 0.402668, -0.647244>, <0.0329144, 4.32203, -1.6432> , <0.448178, 0.773481, -0.448178> }
	smooth_triangle { <0.0298165, 4.3284, -1.64011>, <0.647251, 0.402668, -0.647244>, <0.0232739, 4.32203, -1.6506>, <0.316906, 0.773484, -0.548901>, <0.0210834, 4.3284, -1.64681> , <0.457665, 0.402666, -0.792719> }
	smooth_triangle { <0.0210834, 4.3284, -1.64681>, <0.457665, 0.402666, -0.792719>, <0.0282676, 4.33794, -1.63856>, <0.7032, 0.105027, -0.703192>, <0.0298165, 4.3284, -1.64011> , <0.647251, 0.402668, -0.647244> }
	smooth_triangle { <0.0282676, 4.33794, -1.63856>, <0.7032, 0.105027, -0.703192>, <0.0210834, 4.3284, -1.64681>, <0.457665, 0.402666, -0.792719>, <0.0199882, 4.33794, -1.64491> , <0.497229, 0.105021, -0.86124> }
	smooth_triangle { <0.0282676, 4.33794, -1.63856>, <0.7032, 0.105027, -0.703192>, <0.0227263, 4.69858, -1.64965>, <0.498278, -0.0829325, -0.863042>, <0.0321399, 4.69858, -1.64243> , <0.704672, -0.0829369, -0.704669> }
	smooth_triangle { <0.0227263, 4.69858, -1.64965>, <0.498278, -0.0829325, -0.863042>, <0.0282676, 4.33794, -1.63856>, <0.7032, 0.105027, -0.703192>, <0.0199882, 4.33794, -1.64491> , <0.497229, 0.105021, -0.86124> }
	smooth_triangle { <0.0321399, 4.69858, -1.64243>, <0.704672, -0.0829369, -0.704669>, <0.0238215, 4.71298, -1.65155>, <0.488489, -0.213316, -0.846094>, <0.0336888, 4.71298, -1.64398> , <0.690831, -0.213318, -0.690832> }
	smooth_triangle { <0.0238215, 4.71298, -1.65155>, <0.488489, -0.213316, -0.846094>, <0.0321399, 4.69858, -1.64243>, <0.704672, -0.0829369, -0.704669>, <0.0227263, 4.69858, -1.64965> , <0.498278, -0.0829325, -0.863042> }
	smooth_triangle { <0.0336888, 4.71298, -1.64398>, <0.690831, -0.213318, -0.690832>, <0.0276549, 4.73974, -1.65819>, <0.475118, -0.31152, -0.822933>, <0.0391099, 4.73974, -1.6494> , <0.67192, -0.311518, -0.671922> }
	smooth_triangle { <0.0276549, 4.73974, -1.65819>, <0.475118, -0.31152, -0.822933>, <0.0336888, 4.71298, -1.64398>, <0.690831, -0.213318, -0.690832>, <0.0238215, 4.71298, -1.65155> , <0.488489, -0.213316, -0.846094> }
	smooth_triangle { <0.0391099, 4.73974, -1.6494>, <0.67192, -0.311518, -0.671922>, <0.032036, 4.76341, -1.66578>, <0.416751, -0.552524, -0.721828>, <0.0453058, 4.76341, -1.6556> , <0.589374, -0.552523, -0.58937> }
	smooth_triangle { <0.032036, 4.76341, -1.66578>, <0.416751, -0.552524, -0.721828>, <0.0391099, 4.73974, -1.6494>, <0.67192, -0.311518, -0.671922>, <0.0276549, 4.73974, -1.65819> , <0.475118, -0.31152, -0.822933> }
	smooth_triangle { <0.032036, 4.76341, -1.66578>, <0.416751, -0.552524, -0.721828>, <0.0630807, 4.78708, -1.67337>, <0.371648, -0.85074, -0.371644>, <0.0453058, 4.76341, -1.6556> , <0.589374, -0.552523, -0.58937> }
	smooth_triangle { <0.0630807, 4.78708, -1.67337>, <0.371648, -0.85074, -0.371644>, <0.032036, 4.76341, -1.66578>, <0.416751, -0.552524, -0.721828>, <0.0446049, 4.78708, -1.68755> , <0.262795, -0.85074, -0.45517> }
	smooth_triangle { <0.0446049, 4.78708, -1.68755>, <0.262795, -0.85074, -0.45517>, <0.0987366, 4.80561, -1.70903>, <0.320894, -0.891097, -0.320895>, <0.0630807, 4.78708, -1.67337> , <0.371648, -0.85074, -0.371644> }
	smooth_triangle { <0.0987366, 4.80561, -1.70903>, <0.320894, -0.891097, -0.320895>, <0.0446049, 4.78708, -1.68755>, <0.262795, -0.85074, -0.45517>, <0.0698173, 4.80561, -1.73122> , <0.226908, -0.891097, -0.393013> }
	smooth_triangle { <0.0698173, 4.80561, -1.73122>, <0.226908, -0.891097, -0.393013>, <0.133501, 4.83854, -1.74379>, <0.420817, -0.803632, -0.420818>, <0.0987366, 4.80561, -1.70903> , <0.320894, -0.891097, -0.320895> }
	smooth_triangle { <0.133501, 4.83854, -1.74379>, <0.420817, -0.803632, -0.420818>, <0.0698173, 4.80561, -1.73122>, <0.226908, -0.891097, -0.393013>, <0.0943997, 4.83854, -1.7738> , <0.297565, -0.803632, -0.515394> }
	smooth_triangle { <0.0943997, 4.83854, -1.7738>, <0.297565, -0.803632, -0.515394>, <0.155786, 4.86427, -1.76608>, <0.507028, -0.697025, -0.507029>, <0.133501, 4.83854, -1.74379> , <0.420817, -0.803632, -0.420818> }
	smooth_triangle { <0.155786, 4.86427, -1.76608>, <0.507028, -0.697025, -0.507029>, <0.0943997, 4.83854, -1.7738>, <0.297565, -0.803632, -0.515394>, <0.110158, 4.86427, -1.80109> , <0.358525, -0.697028, -0.620977> }
	smooth_triangle { <0.155786, 4.86427, -1.76608>, <0.507028, -0.697025, -0.507029>, <0.124024, 4.90029, -1.82511>, <0.415156, -0.557311, -0.719062>, <0.175396, 4.90029, -1.78569> , <0.587114, -0.557309, -0.587115> }
	smooth_triangle { <0.124024, 4.90029, -1.82511>, <0.415156, -0.557311, -0.719062>, <0.155786, 4.86427, -1.76608>, <0.507028, -0.697025, -0.507029>, <0.110158, 4.86427, -1.80109> , <0.358525, -0.697028, -0.620977> }
	smooth_triangle { <0.175396, 4.90029, -1.78569>, <0.587114, -0.557309, -0.587115>, <0.134971, 4.938, -1.84407>, <0.458515, -0.398846, -0.794157>, <0.190877, 4.938, -1.80117> , <0.648429, -0.398846, -0.64843> }
	smooth_triangle { <0.134971, 4.938, -1.84407>, <0.458515, -0.398846, -0.794157>, <0.175396, 4.90029, -1.78569>, <0.587114, -0.557309, -0.587115>, <0.124024, 4.90029, -1.82511> , <0.415156, -0.557311, -0.719062> }
	smooth_triangle { <0.190877, 4.938, -1.80117>, <0.648429, -0.398846, -0.64843>, <0.144541, 5.00115, -1.86064>, <0.492654, -0.170878, -0.853284>, <0.204411, 5.00115, -1.8147> , <0.696705, -0.170886, -0.696706> }
	smooth_triangle { <0.144541, 5.00115, -1.86064>, <0.492654, -0.170878, -0.853284>, <0.190877, 4.938, -1.80117>, <0.648429, -0.398846, -0.64843>, <0.134971, 4.938, -1.84407> , <0.458515, -0.398846, -0.794157> }
	smooth_triangle { <0.204411, 5.00115, -1.8147>, <0.696705, -0.170886, -0.696706>, <0.146716, 5.08966, -1.86441>, <0.49999, 0.00604157, -0.86601>, <0.207488, 5.08966, -1.81778> , <0.707093, 0.00603566, -0.707094> }
	smooth_triangle { <0.146716, 5.08966, -1.86441>, <0.49999, 0.00604157, -0.86601>, <0.204411, 5.00115, -1.8147>, <0.696705, -0.170886, -0.696706>, <0.144541, 5.00115, -1.86064> , <0.492654, -0.170878, -0.853284> }
	smooth_triangle { <0.146716, 5.08966, -1.86441>, <0.49999, 0.00604157, -0.86601>, <0.20303, 5.19258, -1.81332>, <0.70462, 0.0838012, -0.70462>, <0.207488, 5.08966, -1.81778> , <0.707093, 0.00603566, -0.707094> }
	smooth_triangle { <0.20303, 5.19258, -1.81332>, <0.70462, 0.0838012, -0.70462>, <0.146716, 5.08966, -1.86441>, <0.49999, 0.00604157, -0.86601>, <0.143564, 5.19258, -1.85895> , <0.498236, 0.0837989, -0.862982> }
	smooth_triangle { <0.143564, 5.19258, -1.85895>, <0.498236, 0.0837989, -0.862982>, <0.195008, 5.29859, -1.8053>, <0.702725, 0.111149, -0.702725>, <0.20303, 5.19258, -1.81332> , <0.70462, 0.0838012, -0.70462> }
	smooth_triangle { <0.195008, 5.29859, -1.8053>, <0.702725, 0.111149, -0.702725>, <0.143564, 5.19258, -1.85895>, <0.498236, 0.0837989, -0.862982>, <0.137891, 5.29859, -1.84912> , <0.496899, 0.111147, -0.860661> }
	smooth_triangle { <0.137891, 5.29859, -1.84912>, <0.496899, 0.111147, -0.860661>, <0.189659, 5.36342, -1.79995>, <0.702343, 0.115878, -0.702344>, <0.195008, 5.29859, -1.8053> , <0.702725, 0.111149, -0.702725> }
	smooth_triangle { <0.189659, 5.36342, -1.79995>, <0.702343, 0.115878, -0.702344>, <0.137891, 5.29859, -1.84912>, <0.496899, 0.111147, -0.860661>, <0.134109, 5.36342, -1.84257> , <0.496627, 0.11587, -0.860195> }
	smooth_triangle { <0.134109, 5.36342, -1.84257>, <0.495749, 0.130117, -0.858663>, <0.181636, 5.44988, -1.79193>, <0.699773, 0.143622, -0.699779>, <0.189659, 5.36342, -1.79995> , <0.701091, 0.130126, -0.701098> }
	smooth_triangle { <0.181636, 5.44988, -1.79193>, <0.699773, 0.143622, -0.699779>, <0.134109, 5.36342, -1.84257>, <0.495749, 0.130117, -0.858663>, <0.128436, 5.44988, -1.83275> , <0.494821, 0.143622, -0.857044> }
	smooth_triangle { <0.128436, 5.44988, -1.83275>, <0.494821, 0.143622, -0.857044>, <0.172723, 5.52912, -1.78301>, <0.696669, 0.17115, -0.696678>, <0.181636, 5.44988, -1.79193> , <0.699773, 0.143622, -0.699779> }
	smooth_triangle { <0.172723, 5.52912, -1.78301>, <0.696669, 0.17115, -0.696678>, <0.128436, 5.44988, -1.83275>, <0.494821, 0.143622, -0.857044>, <0.122133, 5.52912, -1.82183> , <0.492628, 0.171149, -0.853244> }
	smooth_triangle { <0.122133, 5.52912, -1.82183>, <0.492628, 0.171149, -0.853244>, <0.167374, 5.56926, -1.77766>, <0.694873, 0.185173, -0.694883>, <0.172723, 5.52912, -1.78301> , <0.696669, 0.17115, -0.696678> }
	smooth_triangle { <0.167374, 5.56926, -1.77766>, <0.694873, 0.185173, -0.694883>, <0.122133, 5.52912, -1.82183>, <0.492628, 0.171149, -0.853244>, <0.118352, 5.56926, -1.81528> , <0.491354, 0.185164, -0.85105> }
	smooth_triangle { <0.167374, 5.56926, -1.77766>, <0, 1, 0>, <0.1152, 5.56926, -1.80982>, <-0.0962506, 0.981298, 0.166702>, <0.162918, 5.56926, -1.77321> , <-0.136131, 0.981293, 0.136133> }
	smooth_triangle { <0.1152, 5.56926, -1.80982>, <-0.0962506, 0.981298, 0.166702>, <0.167374, 5.56926, -1.77766>, <0, 1, 0>, <0.118352, 5.56926, -1.81528> , <0, 1, 0> }
	smooth_triangle { <0.162918, 5.56926, -1.77321>, <-0.136131, 0.981293, 0.136133>, <0.112679, 5.5672, -1.80546>, <-0.189013, 0.925801, 0.327363>, <0.159353, 5.5672, -1.76964> , <-0.267328, 0.92578, 0.267332> }
	smooth_triangle { <0.112679, 5.5672, -1.80546>, <-0.189013, 0.925801, 0.327363>, <0.162918, 5.56926, -1.77321>, <-0.136131, 0.981293, 0.136133>, <0.1152, 5.56926, -1.80982> , <-0.0962506, 0.981298, 0.166702> }
	smooth_triangle { <0.112679, 5.5672, -1.80546>, <-0.495414, 0.134952, 0.85811>, <0.158461, 5.55794, -1.76875>, <-0.70064, 0.134955, 0.700636>, <0.159353, 5.5672, -1.76964> , <-0.70064, 0.134955, 0.700636> }
	smooth_triangle { <0.158461, 5.55794, -1.76875>, <-0.70064, 0.134955, 0.700636>, <0.112679, 5.5672, -1.80546>, <-0.495414, 0.134952, 0.85811>, <0.112048, 5.55794, -1.80436> , <-0.495414, 0.134952, 0.85811> }
	smooth_triangle { <0.0007103, 4.77442, -1.61152>, <0.0713783, -0.989755, -0.123655>, <0.0630807, 4.78708, -1.67337>, <0.101003, -0.989751, -0.100949>, <0.00100452, 4.77442, -1.61129> , <0.101003, -0.989751, -0.100949> }
	smooth_triangle { <0.0630807, 4.78708, -1.67337>, <0.101003, -0.989751, -0.100949>, <0.0007103, 4.77442, -1.61152>, <0.0713783, -0.989755, -0.123655>, <0.0446049, 4.78708, -1.68755> , <0.0713783, -0.989755, -0.123655> }
	smooth_triangle { <0.000474268, 4.22409, -1.61206>, <-0.0074172, -0.99959, 0.0276735>, <0.147036, 4.21572, -1.86496>, <-0.0143241, -0.99959, 0.0248126>, <0.000916216, 4.22409, -1.61188> , <-0.0143241, -0.99959, 0.0248126> }
	smooth_triangle { <0.147036, 4.21572, -1.86496>, <-0.0143241, -0.99959, 0.0248126>, <0.000474268, 4.22409, -1.61206>, <-0.0074172, -0.99959, 0.0276735>, <0.0761115, 4.21572, -1.89434> , <-0.0074172, -0.99959, 0.0276735> }
	smooth_triangle { <0.0761115, 4.21572, -1.89434>, <0.257894, 0.0847015, -0.962453>, <0.146484, 4.2287, -1.86401>, <0.498201, 0.0846679, -0.862918>, <0.147036, 4.21572, -1.86496> , <0.498201, 0.0846679, -0.862918> }
	smooth_triangle { <0.146484, 4.2287, -1.86401>, <0.498201, 0.0846679, -0.862918>, <0.0761115, 4.21572, -1.89434>, <0.257894, 0.0847015, -0.962453>, <0.0758259, 4.2287, -1.89328> , <0.257894, 0.0847015, -0.962453> }
	smooth_triangle { <0.146484, 4.2287, -1.86401>, <0.226252, 0.891761, -0.391882>, <0.066089, 4.24779, -1.85694>, <0.0914126, 0.935551, -0.341157>, <0.127674, 4.24779, -1.83143> , <0.176596, 0.935551, -0.305874> }
	smooth_triangle { <0.066089, 4.24779, -1.85694>, <0.0914126, 0.935551, -0.341157>, <0.146484, 4.2287, -1.86401>, <0.226252, 0.891761, -0.391882>, <0.0758259, 4.2287, -1.89328> , <0.117117, 0.891762, -0.437087> }
	smooth_triangle { <0.127674, 4.24779, -1.83143>, <0.176596, 0.935551, -0.305874>, <0.0469395, 4.26688, -1.78547>, <0.0554447, 0.976784, -0.206926>, <0.0906801, 4.26688, -1.76735> , <0.107113, 0.976784, -0.185525> }
	smooth_triangle { <0.0469395, 4.26688, -1.78547>, <0.0554447, 0.976784, -0.206926>, <0.127674, 4.24779, -1.83143>, <0.176596, 0.935551, -0.305874>, <0.066089, 4.24779, -1.85694> , <0.0914126, 0.935551, -0.341157> }
	smooth_triangle { <0.0906801, 4.26688, -1.76735>, <0.107113, 0.976784, -0.185525>, <0.0333078, 4.27643, -1.7346>, <0.0417967, 0.986874, -0.155992>, <0.0643457, 4.27643, -1.72174> , <0.0807468, 0.986874, -0.139858> }
	smooth_triangle { <0.0333078, 4.27643, -1.7346>, <0.0417967, 0.986874, -0.155992>, <0.0906801, 4.26688, -1.76735>, <0.107113, 0.976784, -0.185525>, <0.0469395, 4.26688, -1.78547> , <0.0554447, 0.976784, -0.206926> }
	smooth_triangle { <0.0643457, 4.27643, -1.72174>, <0.0807468, 0.986874, -0.139858>, <0.0182838, 4.28491, -1.67853>, <0.0374288, 0.989488, -0.139689>, <0.0353216, 4.28491, -1.67147> , <0.0723071, 0.989488, -0.125242> }
	smooth_triangle { <0.0182838, 4.28491, -1.67853>, <0.0374288, 0.989488, -0.139689>, <0.0643457, 4.27643, -1.72174>, <0.0807468, 0.986874, -0.139858>, <0.0333078, 4.27643, -1.7346> , <0.0417967, 0.986874, -0.155992> }
	smooth_triangle { <0.0182838, 4.28491, -1.67853>, <0.209764, 0.585779, -0.782855>, <0.0314883, 4.29552, -1.66483>, <0.475644, 0.308292, -0.823844>, <0.0353216, 4.28491, -1.67147> , <0.405229, 0.585782, -0.701889> }
	smooth_triangle { <0.0314883, 4.29552, -1.66483>, <0.475644, 0.308292, -0.823844>, <0.0182838, 4.28491, -1.67853>, <0.209764, 0.585779, -0.782855>, <0.0162996, 4.29552, -1.67112> , <0.24621, 0.30829, -0.918879> }
	smooth_triangle { <0.0162996, 4.29552, -1.67112>, <0.24621, 0.30829, -0.918879>, <0.0314883, 4.30188, -1.66483>, <0.500001, 0, -0.866025>, <0.0314883, 4.29552, -1.66483> , <0.475644, 0.308292, -0.823844> }
	smooth_triangle { <0.0314883, 4.30188, -1.66483>, <0.500001, 0, -0.866025>, <0.0162996, 4.29552, -1.67112>, <0.24621, 0.30829, -0.918879>, <0.0162996, 4.30188, -1.67112> , <0.258816, 0, -0.965926> }
	smooth_triangle { <0.0162996, 4.30188, -1.67112>, <0.258816, 0, -0.965926>, <0.0314883, 4.30931, -1.66483>, <0.473013, 0.324096, -0.819281>, <0.0314883, 4.30188, -1.66483> , <0.500001, 0, -0.866025> }
	smooth_triangle { <0.0314883, 4.30931, -1.66483>, <0.473013, 0.324096, -0.819281>, <0.0162996, 4.30188, -1.67112>, <0.258816, 0, -0.965926>, <0.0162996, 4.30931, -1.67112> , <0.244846, 0.324097, -0.913789> }
	smooth_triangle { <0.0162996, 4.30931, -1.67112>, <0.244846, 0.324097, -0.913789>, <0.0282025, 4.31779, -1.65914>, <0.305975, 0.790899, -0.52996>, <0.0314883, 4.30931, -1.66483> , <0.473013, 0.324096, -0.819281> }
	smooth_triangle { <0.0282025, 4.31779, -1.65914>, <0.305975, 0.790899, -0.52996>, <0.0162996, 4.30931, -1.67112>, <0.244846, 0.324097, -0.913789>, <0.0145987, 4.31779, -1.66477> , <0.158381, 0.790899, -0.591096> }
	smooth_triangle { <0.0282025, 4.31779, -1.65914>, <0.305975, 0.790899, -0.52996>, <0.0120475, 4.32203, -1.65525>, <0.164043, 0.77349, -0.612212>, <0.0232739, 4.32203, -1.6506> , <0.316906, 0.773484, -0.548901> }
	smooth_triangle { <0.0120475, 4.32203, -1.65525>, <0.164043, 0.77349, -0.612212>, <0.0282025, 4.31779, -1.65914>, <0.305975, 0.790899, -0.52996>, <0.0145987, 4.31779, -1.66477> , <0.158381, 0.790899, -0.591096> }
	smooth_triangle { <0.0120475, 4.32203, -1.65525>, <0.164043, 0.77349, -0.612212>, <0.0210834, 4.3284, -1.64681>, <0.457665, 0.402666, -0.792719>, <0.0232739, 4.32203, -1.6506> , <0.316906, 0.773484, -0.548901> }
	smooth_triangle { <0.0210834, 4.3284, -1.64681>, <0.457665, 0.402666, -0.792719>, <0.0120475, 4.32203, -1.65525>, <0.164043, 0.77349, -0.612212>, <0.0109136, 4.3284, -1.65102> , <0.236903, 0.402666, -0.884159> }
	smooth_triangle { <0.0109136, 4.3284, -1.65102>, <0.236903, 0.402666, -0.884159>, <0.0199882, 4.33794, -1.64491>, <0.497229, 0.105021, -0.86124>, <0.0210834, 4.3284, -1.64681> , <0.457665, 0.402666, -0.792719> }
	smooth_triangle { <0.0199882, 4.33794, -1.64491>, <0.497229, 0.105021, -0.86124>, <0.0109136, 4.3284, -1.65102>, <0.236903, 0.402666, -0.884159>, <0.0103467, 4.33794, -1.6489> , <0.257381, 0.10501, -0.960587> }
	smooth_triangle { <0.0199882, 4.33794, -1.64491>, <0.497229, 0.105021, -0.861239>, <0.011764, 4.69858, -1.65419>, <0.257932, -0.0829329, -0.962597>, <0.0227263, 4.69858, -1.64965> , <0.498278, -0.0829325, -0.863042> }
	smooth_triangle { <0.011764, 4.69858, -1.65419>, <0.257932, -0.0829329, -0.962597>, <0.0199882, 4.33794, -1.64491>, <0.497229, 0.105021, -0.861239>, <0.0103467, 4.33794, -1.6489> , <0.257381, 0.10501, -0.960587> }
	smooth_triangle { <0.0227263, 4.69858, -1.64965>, <0.498278, -0.0829325, -0.863042>, <0.0123309, 4.71298, -1.65631>, <0.25287, -0.213315, -0.943691>, <0.0238215, 4.71298, -1.65155> , <0.488489, -0.213316, -0.846094> }
	smooth_triangle { <0.0123309, 4.71298, -1.65631>, <0.25287, -0.213315, -0.943691>, <0.0227263, 4.69858, -1.64965>, <0.498278, -0.0829325, -0.863042>, <0.011764, 4.69858, -1.65419> , <0.257932, -0.0829329, -0.962597> }
	smooth_triangle { <0.0238215, 4.71298, -1.65155>, <0.488489, -0.213316, -0.846094>, <0.0143152, 4.73974, -1.66372>, <0.245944, -0.311516, -0.917861>, <0.0276549, 4.73974, -1.65819> , <0.475118, -0.31152, -0.822933> }
	smooth_triangle { <0.0143152, 4.73974, -1.66372>, <0.245944, -0.311516, -0.917861>, <0.0238215, 4.71298, -1.65155>, <0.488489, -0.213316, -0.846094>, <0.0123309, 4.71298, -1.65631> , <0.25287, -0.213315, -0.943691> }
	smooth_triangle { <0.0276549, 4.73974, -1.65819>, <0.475118, -0.31152, -0.822933>, <0.016583, 4.76341, -1.67218>, <0.215722, -0.552523, -0.805098>, <0.032036, 4.76341, -1.66578> , <0.416751, -0.552524, -0.721828> }
	smooth_triangle { <0.016583, 4.76341, -1.67218>, <0.215722, -0.552523, -0.805098>, <0.0276549, 4.73974, -1.65819>, <0.475118, -0.31152, -0.822933>, <0.0143152, 4.73974, -1.66372> , <0.245944, -0.311516, -0.917861> }
	smooth_triangle { <0.016583, 4.76341, -1.67218>, <0.215722, -0.552523, -0.805098>, <0.0446049, 4.78708, -1.68755>, <0.262795, -0.85074, -0.45517>, <0.032036, 4.76341, -1.66578> , <0.416751, -0.552524, -0.721828> }
	smooth_triangle { <0.0446049, 4.78708, -1.68755>, <0.262795, -0.85074, -0.45517>, <0.016583, 4.76341, -1.67218>, <0.215722, -0.552523, -0.805098>, <0.0230892, 4.78708, -1.69646> , <0.136028, -0.850741, -0.507677> }
	smooth_triangle { <0.0230892, 4.78708, -1.69646>, <0.136028, -0.850741, -0.507677>, <0.0698173, 4.80561, -1.73122>, <0.226908, -0.891097, -0.393013>, <0.0446049, 4.78708, -1.68755> , <0.262795, -0.85074, -0.45517> }
	smooth_triangle { <0.0698173, 4.80561, -1.73122>, <0.226908, -0.891097, -0.393013>, <0.0230892, 4.78708, -1.69646>, <0.136028, -0.850741, -0.507677>, <0.0361401, 4.80561, -1.74517> , <0.117456, -0.891097, -0.43835> }
	smooth_triangle { <0.0361401, 4.80561, -1.74517>, <0.117456, -0.891097, -0.43835>, <0.0943997, 4.83854, -1.7738>, <0.297565, -0.803632, -0.515394>, <0.0698173, 4.80561, -1.73122> , <0.226908, -0.891097, -0.393013> }
	smooth_triangle { <0.0943997, 4.83854, -1.7738>, <0.297565, -0.803632, -0.515394>, <0.0361401, 4.80561, -1.74517>, <0.117456, -0.891097, -0.43835>, <0.0488648, 4.83854, -1.79266> , <0.154031, -0.803632, -0.574848> }
	smooth_triangle { <0.0488648, 4.83854, -1.79266>, <0.154031, -0.803632, -0.574848>, <0.110158, 4.86427, -1.80109>, <0.358525, -0.697028, -0.620977>, <0.0943997, 4.83854, -1.7738> , <0.297565, -0.803632, -0.515394> }
	smooth_triangle { <0.110158, 4.86427, -1.80109>, <0.358525, -0.697028, -0.620977>, <0.0488648, 4.83854, -1.79266>, <0.154031, -0.803632, -0.574848>, <0.0570217, 4.86427, -1.8231> , <0.185583, -0.697032, -0.692607> }
	smooth_triangle { <0.110158, 4.86427, -1.80109>, <0.358525, -0.697028, -0.620977>, <0.0641997, 4.90029, -1.84989>, <0.214901, -0.557318, -0.802007>, <0.124024, 4.90029, -1.82511> , <0.415156, -0.557311, -0.719062> }
	smooth_triangle { <0.0641997, 4.90029, -1.84989>, <0.214901, -0.557318, -0.802007>, <0.110158, 4.86427, -1.80109>, <0.358525, -0.697028, -0.620977>, <0.0570217, 4.86427, -1.8231> , <0.185583, -0.697032, -0.692607> }
	smooth_triangle { <0.124024, 4.90029, -1.82511>, <0.415156, -0.557311, -0.719062>, <0.069866, 4.938, -1.87103>, <0.23735, -0.398843, -0.88577>, <0.134971, 4.938, -1.84407> , <0.458515, -0.398846, -0.794157> }
	smooth_triangle { <0.069866, 4.938, -1.87103>, <0.23735, -0.398843, -0.88577>, <0.124024, 4.90029, -1.82511>, <0.415156, -0.557311, -0.719062>, <0.0641997, 4.90029, -1.84989> , <0.214901, -0.557318, -0.802007> }
	smooth_triangle { <0.134971, 4.938, -1.84407>, <0.458515, -0.398846, -0.794157>, <0.0748199, 5.00115, -1.88952>, <0.255016, -0.17087, -0.95172>, <0.144541, 5.00115, -1.86064> , <0.492654, -0.170878, -0.853284> }
	smooth_triangle { <0.0748199, 5.00115, -1.88952>, <0.255016, -0.17087, -0.95172>, <0.134971, 4.938, -1.84407>, <0.458515, -0.398846, -0.794157>, <0.069866, 4.938, -1.87103> , <0.23735, -0.398843, -0.88577> }
	smooth_triangle { <0.144541, 5.00115, -1.86064>, <0.492654, -0.170878, -0.853284>, <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <0.146716, 5.08966, -1.86441> , <0.49999, 0.00604157, -0.86601> }
	smooth_triangle { <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <0.144541, 5.00115, -1.86064>, <0.492654, -0.170878, -0.853284>, <0.0748199, 5.00115, -1.88952> , <0.255016, -0.17087, -0.95172> }
	smooth_triangle { <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <0.143564, 5.19258, -1.85895>, <0.498236, 0.0837989, -0.862982>, <0.146716, 5.08966, -1.86441> , <0.49999, 0.00604157, -0.86601> }
	smooth_triangle { <0.143564, 5.19258, -1.85895>, <0.498236, 0.0837989, -0.862982>, <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <0.0743142, 5.19258, -1.88763> , <0.257908, 0.0837971, -0.962529> }
	smooth_triangle { <0.0743142, 5.19258, -1.88763>, <0.257908, 0.0837971, -0.962529>, <0.137891, 5.29859, -1.84912>, <0.496899, 0.111147, -0.860661>, <0.143564, 5.19258, -1.85895> , <0.498236, 0.0837989, -0.862982> }
	smooth_triangle { <0.137891, 5.29859, -1.84912>, <0.496899, 0.111147, -0.860661>, <0.0743142, 5.19258, -1.88763>, <0.257908, 0.0837971, -0.962529>, <0.0713777, 5.29859, -1.87668> , <0.257217, 0.111141, -0.959941> }
	smooth_triangle { <0.0713777, 5.29859, -1.87668>, <0.257217, 0.111141, -0.959941>, <0.134109, 5.36342, -1.84257>, <0.496627, 0.11587, -0.860195>, <0.137891, 5.29859, -1.84912> , <0.496899, 0.111147, -0.860661> }
	smooth_triangle { <0.134109, 5.36342, -1.84257>, <0.496627, 0.11587, -0.860195>, <0.0713777, 5.29859, -1.87668>, <0.257217, 0.111141, -0.959941>, <0.0694202, 5.36342, -1.86937> , <0.257077, 0.115859, -0.959421> }
	smooth_triangle { <0.0694202, 5.36342, -1.86937>, <0.25663, 0.130122, -0.95771>, <0.128436, 5.44988, -1.83275>, <0.494821, 0.143622, -0.857044>, <0.134109, 5.36342, -1.84257> , <0.495749, 0.130117, -0.858663> }
	smooth_triangle { <0.128436, 5.44988, -1.83275>, <0.494821, 0.143622, -0.857044>, <0.0694202, 5.36342, -1.86937>, <0.25663, 0.130122, -0.95771>, <0.0664836, 5.44988, -1.85841> , <0.256144, 0.143625, -0.955909> }
	smooth_triangle { <0.0664836, 5.44988, -1.85841>, <0.256144, 0.143625, -0.955909>, <0.122133, 5.52912, -1.82183>, <0.492628, 0.171149, -0.853244>, <0.128436, 5.44988, -1.83275> , <0.494821, 0.143622, -0.857044> }
	smooth_triangle { <0.122133, 5.52912, -1.82183>, <0.492628, 0.171149, -0.853244>, <0.0664836, 5.44988, -1.85841>, <0.256144, 0.143625, -0.955909>, <0.063221, 5.52912, -1.84623> , <0.255004, 0.171156, -0.951671> }
	smooth_triangle { <0.063221, 5.52912, -1.84623>, <0.255004, 0.171156, -0.951671>, <0.118352, 5.56926, -1.81528>, <0.491354, 0.185164, -0.85105>, <0.122133, 5.52912, -1.82183> , <0.492628, 0.171149, -0.853244> }
	smooth_triangle { <0.118352, 5.56926, -1.81528>, <0.491354, 0.185164, -0.85105>, <0.063221, 5.52912, -1.84623>, <0.255004, 0.171156, -0.951671>, <0.0612632, 5.56926, -1.83893> , <0.254347, 0.185176, -0.949219> }
	smooth_triangle { <0.118352, 5.56926, -1.81528>, <0, 1, 0>, <0.059632, 5.56926, -1.83284>, <-0.0498134, 0.981303, 0.185913>, <0.1152, 5.56926, -1.80982> , <-0.0962506, 0.981298, 0.166702> }
	smooth_triangle { <0.059632, 5.56926, -1.83284>, <-0.0498134, 0.981303, 0.185913>, <0.118352, 5.56926, -1.81528>, <0, 1, 0>, <0.0612632, 5.56926, -1.83893> , <0, 1, 0> }
	smooth_triangle { <0.1152, 5.56926, -1.80982>, <-0.0962506, 0.981298, 0.166702>, <0.0583268, 5.5672, -1.82797>, <-0.0978223, 0.925818, 0.365091>, <0.112679, 5.5672, -1.80546> , <-0.189013, 0.925801, 0.327363> }
	smooth_triangle { <0.0583268, 5.5672, -1.82797>, <-0.0978223, 0.925818, 0.365091>, <0.1152, 5.56926, -1.80982>, <-0.0962506, 0.981298, 0.166702>, <0.059632, 5.56926, -1.83284> , <-0.0498134, 0.981303, 0.185913> }
	smooth_triangle { <0.0583268, 5.5672, -1.82797>, <-0.256445, 0.134845, 0.957106>, <0.112048, 5.55794, -1.80436>, <-0.495414, 0.134952, 0.85811>, <0.112679, 5.5672, -1.80546> , <-0.495414, 0.134952, 0.85811> }
	smooth_triangle { <0.112048, 5.55794, -1.80436>, <-0.495414, 0.134952, 0.85811>, <0.0583268, 5.5672, -1.82797>, <-0.256445, 0.134845, 0.957106>, <0.0580006, 5.55794, -1.82675> , <-0.256445, 0.134845, 0.957106> }
	smooth_triangle { <0.000367679, 4.77442, -1.61166>, <0.0369499, -0.989751, -0.137939>, <0.0446049, 4.78708, -1.68755>, <0.0713783, -0.989755, -0.123655>, <0.0007103, 4.77442, -1.61152> , <0.0713783, -0.989755, -0.123655> }
	smooth_triangle { <0.0446049, 4.78708, -1.68755>, <0.0713783, -0.989755, -0.123655>, <0.000367679, 4.77442, -1.61166>, <0.0369499, -0.989751, -0.137939>, <0.0230892, 4.78708, -1.69646> , <0.0369499, -0.989751, -0.137939> }
	smooth_triangle { <-2.18515e-011, 4.22409, -1.61212>, <-2.36325e-008, -0.99959, 0.0286498>, <0.0761115, 4.21572, -1.89434>, <-0.0074172, -0.99959, 0.0276735>, <0.000474268, 4.22409, -1.61206> , <-0.0074172, -0.99959, 0.0276735> }
	smooth_triangle { <0.0761115, 4.21572, -1.89434>, <-0.0074172, -0.99959, 0.0276735>, <-2.18515e-011, 4.22409, -1.61212>, <-2.36325e-008, -0.99959, 0.0286498>, <-3.50677e-009, 4.21572, -1.90436> , <-2.36325e-008, -0.99959, 0.0286498> }
	smooth_triangle { <0.0761115, 4.21572, -1.89434>, <0.257894, 0.0847015, -0.962453>, <-3.49362e-009, 4.2287, -1.90326>, <-1.27745e-007, 0.0847022, -0.996406>, <0.0758259, 4.2287, -1.89328> , <0.257894, 0.0847015, -0.962453> }
	smooth_triangle { <-3.49362e-009, 4.2287, -1.90326>, <-1.27745e-007, 0.0847022, -0.996406>, <0.0761115, 4.21572, -1.89434>, <0.257894, 0.0847015, -0.962453>, <-3.50677e-009, 4.21572, -1.90436> , <-1.27745e-007, 0.0847022, -0.996406> }
	smooth_triangle { <0.0758259, 4.2287, -1.89328>, <0.117117, 0.891762, -0.437087>, <-3.04499e-009, 4.24779, -1.86564>, <-3.72353e-007, 0.935551, -0.353192>, <0.066089, 4.24779, -1.85694> , <0.0914126, 0.935551, -0.341157> }
	smooth_triangle { <-3.04499e-009, 4.24779, -1.86564>, <-3.72353e-007, 0.935551, -0.353192>, <0.0758259, 4.2287, -1.89328>, <0.117117, 0.891762, -0.437087>, <-3.49362e-009, 4.2287, -1.90326> , <-7.01596e-007, 0.891762, -0.452505> }
	smooth_triangle { <0.066089, 4.24779, -1.85694>, <0.0914126, 0.935551, -0.341157>, <-2.1627e-009, 4.26688, -1.79165>, <2.89022e-008, 0.976784, -0.214226>, <0.0469395, 4.26688, -1.78547> , <0.0554447, 0.976784, -0.206926> }
	smooth_triangle { <-2.1627e-009, 4.26688, -1.79165>, <2.89022e-008, 0.976784, -0.214226>, <0.066089, 4.24779, -1.85694>, <0.0914126, 0.935551, -0.341157>, <-3.04499e-009, 4.24779, -1.86564> , <-3.72353e-007, 0.935551, -0.353192> }
	smooth_triangle { <0.0469395, 4.26688, -1.78547>, <0.0554447, 0.976784, -0.206926>, <-1.53462e-009, 4.27643, -1.73898>, <6.70803e-008, 0.986874, -0.161494>, <0.0333078, 4.27643, -1.7346> , <0.0417967, 0.986874, -0.155992> }
	smooth_triangle { <-1.53462e-009, 4.27643, -1.73898>, <6.70803e-008, 0.986874, -0.161494>, <0.0469395, 4.26688, -1.78547>, <0.0554447, 0.976784, -0.206926>, <-2.1627e-009, 4.26688, -1.79165> , <2.89022e-008, 0.976784, -0.214226> }
	smooth_triangle { <0.0333078, 4.27643, -1.7346>, <0.0417967, 0.986874, -0.155992>, <-8.42412e-010, 4.28491, -1.68093>, <3.72597e-008, 0.989488, -0.144617>, <0.0182838, 4.28491, -1.67853> , <0.0374288, 0.989488, -0.139689> }
	smooth_triangle { <-8.42412e-010, 4.28491, -1.68093>, <3.72597e-008, 0.989488, -0.144617>, <0.0333078, 4.27643, -1.7346>, <0.0417967, 0.986874, -0.155992>, <-1.53462e-009, 4.27643, -1.73898> , <6.70803e-008, 0.986874, -0.161494> }
	smooth_triangle { <0.0182838, 4.28491, -1.67853>, <0.209764, 0.585779, -0.782855>, <-7.50991e-010, 4.29552, -1.67327>, <-3.78569e-007, 0.30829, -0.951292>, <0.0162996, 4.29552, -1.67112> , <0.24621, 0.30829, -0.918878> }
	smooth_triangle { <-7.50991e-010, 4.29552, -1.67327>, <-3.78569e-007, 0.30829, -0.951292>, <0.0182838, 4.28491, -1.67853>, <0.209764, 0.585779, -0.782855>, <-8.42412e-010, 4.28491, -1.68093> , <-7.11824e-007, 0.58578, -0.81047> }
	smooth_triangle { <-7.50991e-010, 4.29552, -1.67327>, <-3.78569e-007, 0.30829, -0.951292>, <0.0162996, 4.30188, -1.67112>, <0.258816, 0, -0.965926>, <0.0162996, 4.29552, -1.67112> , <0.24621, 0.30829, -0.918879> }
	smooth_triangle { <0.0162996, 4.30188, -1.67112>, <0.258816, 0, -0.965926>, <-7.50991e-010, 4.29552, -1.67327>, <-3.78569e-007, 0.30829, -0.951292>, <-7.50991e-010, 4.30188, -1.67327> , <0, 0, -1> }
	smooth_triangle { <-7.50991e-010, 4.30188, -1.67327>, <0, 0, -1>, <0.0162996, 4.30931, -1.67112>, <0.244846, 0.324097, -0.913789>, <0.0162996, 4.30188, -1.67112> , <0.258816, 0, -0.965926> }
	smooth_triangle { <0.0162996, 4.30931, -1.67112>, <0.244846, 0.324097, -0.913789>, <-7.50991e-010, 4.30188, -1.67327>, <0, 0, -1>, <-7.50991e-010, 4.30931, -1.67327> , <6.1453e-008, 0.324097, -0.946024> }
	smooth_triangle { <0.0162996, 4.30931, -1.67112>, <0.244846, 0.324097, -0.913789>, <-6.72624e-010, 4.31779, -1.6667>, <5.24062e-007, 0.790898, -0.611947>, <0.0145987, 4.31779, -1.66477> , <0.158381, 0.790899, -0.591096> }
	smooth_triangle { <-6.72624e-010, 4.31779, -1.6667>, <5.24062e-007, 0.790898, -0.611947>, <0.0162996, 4.30931, -1.67112>, <0.244846, 0.324097, -0.913789>, <-7.50991e-010, 4.30931, -1.67327> , <6.1453e-008, 0.324097, -0.946024> }
	smooth_triangle { <0.0145987, 4.31779, -1.66477>, <0.158381, 0.790899, -0.591096>, <-5.55078e-010, 4.32203, -1.65684>, <1.08951e-007, 0.773492, -0.633806>, <0.0120475, 4.32203, -1.65525> , <0.164043, 0.77349, -0.612212> }
	smooth_triangle { <-5.55078e-010, 4.32203, -1.65684>, <1.08951e-007, 0.773492, -0.633806>, <0.0145987, 4.31779, -1.66477>, <0.158381, 0.790899, -0.591096>, <-6.72624e-010, 4.31779, -1.6667> , <5.24062e-007, 0.790898, -0.611947> }
	smooth_triangle { <0.0120475, 4.32203, -1.65525>, <0.164043, 0.77349, -0.612212>, <-5.02835e-010, 4.3284, -1.65246>, <-3.43733e-007, 0.402668, -0.915346>, <0.0109136, 4.3284, -1.65102> , <0.236903, 0.402666, -0.884159> }
	smooth_triangle { <-5.02835e-010, 4.3284, -1.65246>, <-3.43733e-007, 0.402668, -0.915346>, <0.0120475, 4.32203, -1.65525>, <0.164043, 0.77349, -0.612212>, <-5.55078e-010, 4.32203, -1.65684> , <1.08951e-007, 0.773492, -0.633806> }
	smooth_triangle { <0.0109136, 4.3284, -1.65102>, <0.236903, 0.402666, -0.884159>, <-4.76714e-010, 4.33794, -1.65027>, <1.1352e-008, 0.10501, -0.994471>, <0.0103467, 4.33794, -1.6489> , <0.257381, 0.10501, -0.960587> }
	smooth_triangle { <-4.76714e-010, 4.33794, -1.65027>, <1.1352e-008, 0.10501, -0.994471>, <0.0109136, 4.3284, -1.65102>, <0.236903, 0.402666, -0.884159>, <-5.02835e-010, 4.3284, -1.65246> , <-3.43733e-007, 0.402668, -0.915346> }
	smooth_triangle { <-4.76714e-010, 4.33794, -1.65027>, <1.1352e-008, 0.10501, -0.994471>, <0.011764, 4.69858, -1.65419>, <0.257932, -0.0829329, -0.962597>, <0.0103467, 4.33794, -1.6489> , <0.257381, 0.10501, -0.960587> }
	smooth_triangle { <0.011764, 4.69858, -1.65419>, <0.257932, -0.0829329, -0.962597>, <-4.76714e-010, 4.33794, -1.65027>, <1.1352e-008, 0.10501, -0.994471>, <-5.42018e-010, 4.69858, -1.65574> , <-8.28462e-008, -0.0829328, -0.996555> }
	smooth_triangle { <-5.42018e-010, 4.69858, -1.65574>, <-8.28462e-008, -0.0829328, -0.996555>, <0.0123309, 4.71298, -1.65631>, <0.25287, -0.213315, -0.943691>, <0.011764, 4.69858, -1.65419> , <0.257932, -0.0829329, -0.962597> }
	smooth_triangle { <0.0123309, 4.71298, -1.65631>, <0.25287, -0.213315, -0.943691>, <-5.42018e-010, 4.69858, -1.65574>, <-8.28462e-008, -0.0829328, -0.996555>, <-5.68138e-010, 4.71298, -1.65793> , <-2.25815e-008, -0.213315, -0.976983> }
	smooth_triangle { <-5.68138e-010, 4.71298, -1.65793>, <-2.25815e-008, -0.213315, -0.976983>, <0.0143152, 4.73974, -1.66372>, <0.245944, -0.311516, -0.917861>, <0.0123309, 4.71298, -1.65631> , <0.25287, -0.213315, -0.943691> }
	smooth_triangle { <0.0143152, 4.73974, -1.66372>, <0.245944, -0.311516, -0.917861>, <-5.68138e-010, 4.71298, -1.65793>, <-2.25815e-008, -0.213315, -0.976983>, <-6.59564e-010, 4.73974, -1.6656> , <1.8597e-007, -0.311517, -0.950241> }
	smooth_triangle { <-6.59564e-010, 4.73974, -1.6656>, <1.8597e-007, -0.311517, -0.950241>, <0.016583, 4.76341, -1.67218>, <0.215722, -0.552523, -0.805098>, <0.0143152, 4.73974, -1.66372> , <0.245944, -0.311516, -0.917861> }
	smooth_triangle { <0.016583, 4.76341, -1.67218>, <0.215722, -0.552523, -0.805098>, <-6.59564e-010, 4.73974, -1.6656>, <1.8597e-007, -0.311517, -0.950241>, <-7.64051e-010, 4.76341, -1.67436> , <4.42606e-008, -0.552522, -0.833498> }
	smooth_triangle { <-7.64051e-010, 4.76341, -1.67436>, <4.42606e-008, -0.552522, -0.833498>, <0.0230892, 4.78708, -1.69646>, <0.136028, -0.850741, -0.507677>, <0.016583, 4.76341, -1.67218> , <0.215722, -0.552523, -0.805098> }
	smooth_triangle { <0.0230892, 4.78708, -1.69646>, <0.136028, -0.850741, -0.507677>, <-7.64051e-010, 4.76341, -1.67436>, <4.42606e-008, -0.552522, -0.833498>, <-1.06381e-009, 4.78708, -1.6995> , <-1.45809e-007, -0.85074, -0.525586> }
	smooth_triangle { <-1.06381e-009, 4.78708, -1.6995>, <-1.45809e-007, -0.85074, -0.525586>, <0.0361401, 4.80561, -1.74517>, <0.117456, -0.891097, -0.43835>, <0.0230892, 4.78708, -1.69646> , <0.136028, -0.850741, -0.507677> }
	smooth_triangle { <0.0361401, 4.80561, -1.74517>, <0.117456, -0.891097, -0.43835>, <-1.06381e-009, 4.78708, -1.6995>, <-1.45809e-007, -0.85074, -0.525586>, <-1.66512e-009, 4.80561, -1.74993> , <2.48082e-007, -0.891097, -0.453813> }
	smooth_triangle { <-1.66512e-009, 4.80561, -1.74993>, <2.48082e-007, -0.891097, -0.453813>, <0.0488648, 4.83854, -1.79266>, <0.154031, -0.803632, -0.574848>, <0.0361401, 4.80561, -1.74517> , <0.117456, -0.891097, -0.43835> }
	smooth_triangle { <0.0488648, 4.83854, -1.79266>, <0.154031, -0.803632, -0.574848>, <-1.66512e-009, 4.80561, -1.74993>, <2.48082e-007, -0.891097, -0.453813>, <-2.25141e-009, 4.83854, -1.79909> , <-1.77693e-007, -0.803631, -0.595128> }
	smooth_triangle { <-2.25141e-009, 4.83854, -1.79909>, <-1.77693e-007, -0.803631, -0.595128>, <0.0570217, 4.86427, -1.8231>, <0.185583, -0.697032, -0.692607>, <0.0488648, 4.83854, -1.79266> , <0.154031, -0.803632, -0.574848> }
	smooth_triangle { <0.0570217, 4.86427, -1.8231>, <0.185583, -0.697032, -0.692607>, <-2.25141e-009, 4.83854, -1.79909>, <-1.77693e-007, -0.803631, -0.595128>, <-2.62722e-009, 4.86427, -1.83061> , <-1.50668e-007, -0.697031, -0.717041> }
	smooth_triangle { <-2.62722e-009, 4.86427, -1.83061>, <-1.50668e-007, -0.697031, -0.717041>, <0.0641997, 4.90029, -1.84989>, <0.214901, -0.557318, -0.802007>, <0.0570217, 4.86427, -1.8231> , <0.185583, -0.697032, -0.692607> }
	smooth_triangle { <0.0641997, 4.90029, -1.84989>, <0.214901, -0.557318, -0.802007>, <-2.62722e-009, 4.86427, -1.83061>, <-1.50668e-007, -0.697031, -0.717041>, <-2.95796e-009, 4.90029, -1.85834> , <-3.6427e-007, -0.557317, -0.8303> }
	smooth_triangle { <-2.95796e-009, 4.90029, -1.85834>, <-3.6427e-007, -0.557317, -0.8303>, <0.069866, 4.938, -1.87103>, <0.23735, -0.398843, -0.88577>, <0.0641997, 4.90029, -1.84989> , <0.214901, -0.557318, -0.802007> }
	smooth_triangle { <0.069866, 4.938, -1.87103>, <0.23735, -0.398843, -0.88577>, <-2.95796e-009, 4.90029, -1.85834>, <-3.6427e-007, -0.557317, -0.8303>, <-3.21903e-009, 4.938, -1.88023> , <-4.04181e-007, -0.398843, -0.917019> }
	smooth_triangle { <-3.21903e-009, 4.938, -1.88023>, <-4.04181e-007, -0.398843, -0.917019>, <0.0748199, 5.00115, -1.88952>, <0.255016, -0.17087, -0.95172>, <0.069866, 4.938, -1.87103> , <0.23735, -0.398843, -0.88577> }
	smooth_triangle { <0.0748199, 5.00115, -1.88952>, <0.255016, -0.17087, -0.95172>, <-3.21903e-009, 4.938, -1.88023>, <-4.04181e-007, -0.398843, -0.917019>, <-3.44727e-009, 5.00115, -1.89937> , <2.64911e-007, -0.17087, -0.985293> }
	smooth_triangle { <-3.44727e-009, 5.00115, -1.89937>, <2.64911e-007, -0.17087, -0.985293>, <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <0.0748199, 5.00115, -1.88952> , <0.255016, -0.17087, -0.95172> }
	smooth_triangle { <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <-3.44727e-009, 5.00115, -1.89937>, <2.64911e-007, -0.17087, -0.985293>, <-3.49914e-009, 5.08966, -1.90372> , <-4.13936e-008, 0.00604052, -0.999982> }
	smooth_triangle { <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <-3.42397e-009, 5.19258, -1.89742>, <-1.87908e-008, 0.0837971, -0.996483>, <0.0743142, 5.19258, -1.88763> , <0.257908, 0.0837971, -0.962529> }
	smooth_triangle { <-3.42397e-009, 5.19258, -1.89742>, <-1.87908e-008, 0.0837971, -0.996483>, <0.0759456, 5.08966, -1.89372>, <0.258811, 0.00604018, -0.965909>, <-3.49914e-009, 5.08966, -1.90372> , <-4.13936e-008, 0.00604052, -0.999982> }
	smooth_triangle { <0.0743142, 5.19258, -1.88763>, <0.257908, 0.0837971, -0.962529>, <-3.28867e-009, 5.29859, -1.88607>, <1.1647e-007, 0.111141, -0.993805>, <0.0713777, 5.29859, -1.87668> , <0.257217, 0.111141, -0.959941> }
	smooth_triangle { <-3.28867e-009, 5.29859, -1.88607>, <1.1647e-007, 0.111141, -0.993805>, <0.0743142, 5.19258, -1.88763>, <0.257908, 0.0837971, -0.962529>, <-3.42397e-009, 5.19258, -1.89742> , <-1.87908e-008, 0.0837971, -0.996483> }
	smooth_triangle { <0.0713777, 5.29859, -1.87668>, <0.257217, 0.111141, -0.959941>, <-3.19848e-009, 5.36342, -1.87851>, <2.70504e-007, 0.115859, -0.993266>, <0.0694202, 5.36342, -1.86937> , <0.257077, 0.115859, -0.959421> }
	smooth_triangle { <-3.19848e-009, 5.36342, -1.87851>, <2.70504e-007, 0.115859, -0.993266>, <0.0713777, 5.29859, -1.87668>, <0.257217, 0.111141, -0.959941>, <-3.28867e-009, 5.29859, -1.88607> , <1.1647e-007, 0.111141, -0.993805> }
	smooth_triangle { <0.0694202, 5.36342, -1.86937>, <0.25663, 0.130122, -0.95771>, <-3.06318e-009, 5.44988, -1.86716>, <-8.26567e-008, 0.143625, -0.989632>, <0.0664836, 5.44988, -1.85841> , <0.256144, 0.143625, -0.955909> }
	smooth_triangle { <-3.06318e-009, 5.44988, -1.86716>, <-8.26567e-008, 0.143625, -0.989632>, <0.0694202, 5.36342, -1.86937>, <0.25663, 0.130122, -0.95771>, <-3.19848e-009, 5.36342, -1.87851> , <-2.25414e-007, 0.130122, -0.991498> }
	smooth_triangle { <0.0664836, 5.44988, -1.85841>, <0.256144, 0.143625, -0.955909>, <-2.91286e-009, 5.52912, -1.85456>, <1.42761e-007, 0.171156, -0.985244>, <0.063221, 5.52912, -1.84623> , <0.255004, 0.171156, -0.951671> }
	smooth_triangle { <-2.91286e-009, 5.52912, -1.85456>, <1.42761e-007, 0.171156, -0.985244>, <0.0664836, 5.44988, -1.85841>, <0.256144, 0.143625, -0.955909>, <-3.06318e-009, 5.44988, -1.86716> , <-8.26567e-008, 0.143625, -0.989632> }
	smooth_triangle { <0.063221, 5.52912, -1.84623>, <0.255004, 0.171156, -0.951671>, <-2.82266e-009, 5.56926, -1.84699>, <2.32893e-007, 0.185175, -0.982705>, <0.0612632, 5.56926, -1.83893> , <0.254347, 0.185176, -0.949219> }
	smooth_triangle { <-2.82266e-009, 5.56926, -1.84699>, <2.32893e-007, 0.185175, -0.982705>, <0.063221, 5.52912, -1.84623>, <0.255004, 0.171156, -0.951671>, <-2.91286e-009, 5.52912, -1.85456> , <1.42761e-007, 0.171156, -0.985244> }
	smooth_triangle { <0.0612632, 5.56926, -1.83893>, <0, 1, 0>, <-2.74749e-009, 5.56926, -1.84069>, <-2.12348e-006, 0.981303, 0.19247>, <0.059632, 5.56926, -1.83284> , <-0.0498134, 0.981303, 0.185913> }
	smooth_triangle { <-2.74749e-009, 5.56926, -1.84069>, <-2.12348e-006, 0.981303, 0.19247>, <0.0612632, 5.56926, -1.83893>, <0, 1, 0>, <-2.82266e-009, 5.56926, -1.84699> , <0, 1, 0> }
	smooth_triangle { <0.059632, 5.56926, -1.83284>, <-0.0498134, 0.981303, 0.185913>, <-2.68736e-009, 5.5672, -1.83565>, <-4.17003e-006, 0.925819, 0.377968>, <0.0583268, 5.5672, -1.82797> , <-0.0978223, 0.925818, 0.365091> }
	smooth_triangle { <-2.68736e-009, 5.5672, -1.83565>, <-4.17003e-006, 0.925819, 0.377968>, <0.059632, 5.56926, -1.83284>, <-0.0498134, 0.981303, 0.185913>, <-2.74749e-009, 5.56926, -1.84069> , <-2.12348e-006, 0.981303, 0.19247> }
	smooth_triangle { <0.0583268, 5.5672, -1.82797>, <-0.256445, 0.134845, 0.957106>, <-2.67232e-009, 5.55794, -1.83439>, <-7.96453e-007, 0.134847, 0.990866>, <0.0580006, 5.55794, -1.82675> , <-0.256445, 0.134845, 0.957106> }
	smooth_triangle { <-2.67232e-009, 5.55794, -1.83439>, <-7.96453e-007, 0.134847, 0.990866>, <0.0583268, 5.5672, -1.82797>, <-0.256445, 0.134845, 0.957106>, <-2.68736e-009, 5.5672, -1.83565> , <-7.96453e-007, 0.134847, 0.990866> }
	smooth_triangle { <-1.69406e-011, 4.77442, -1.61171>, <1.54627e-006, -0.989754, -0.14278>, <0.0230892, 4.78708, -1.69646>, <0.0369499, -0.989751, -0.137939>, <0.000367679, 4.77442, -1.61166> , <0.0369499, -0.989751, -0.137939> }
	smooth_triangle { <0.0230892, 4.78708, -1.69646>, <0.0369499, -0.989751, -0.137939>, <-1.69406e-011, 4.77442, -1.61171>, <1.54627e-006, -0.989754, -0.14278>, <-1.06381e-009, 4.78708, -1.6995> , <1.54627e-006, -0.989754, -0.14278> }
	smooth_triangle { <-0.0761115, 4.21572, -1.89434>, <0.00741706, -0.99959, 0.027673>, <-2.18515e-011, 4.22409, -1.61212>, <-2.36325e-008, -0.99959, 0.0286498>, <-0.000474268, 4.22409, -1.61206> , <0.00741706, -0.99959, 0.027673> }
	smooth_triangle { <-2.18515e-011, 4.22409, -1.61212>, <-2.36325e-008, -0.99959, 0.0286498>, <-0.0761115, 4.21572, -1.89434>, <0.00741706, -0.99959, 0.027673>, <-3.50677e-009, 4.21572, -1.90436> , <-2.36325e-008, -0.99959, 0.0286498> }
	smooth_triangle { <-3.50677e-009, 4.21572, -1.90436>, <-1.27745e-007, 0.0847022, -0.996406>, <-0.0758259, 4.2287, -1.89328>, <-0.257895, 0.0846629, -0.962456>, <-3.49362e-009, 4.2287, -1.90326> , <-1.27745e-007, 0.0847022, -0.996406> }
	smooth_triangle { <-0.0758259, 4.2287, -1.89328>, <-0.257895, 0.0846629, -0.962456>, <-3.50677e-009, 4.21572, -1.90436>, <-1.27745e-007, 0.0847022, -0.996406>, <-0.0761115, 4.21572, -1.89434> , <-0.257895, 0.0846629, -0.962456> }
	smooth_triangle { <-3.04499e-009, 4.24779, -1.86564>, <-3.72353e-007, 0.935551, -0.353192>, <-0.0758259, 4.2287, -1.89328>, <-0.117116, 0.891761, -0.437087>, <-0.066089, 4.24779, -1.85694> , <-0.0914121, 0.935551, -0.341158> }
	smooth_triangle { <-0.0758259, 4.2287, -1.89328>, <-0.117116, 0.891761, -0.437087>, <-3.04499e-009, 4.24779, -1.86564>, <-3.72353e-007, 0.935551, -0.353192>, <-3.49362e-009, 4.2287, -1.90326> , <-7.01596e-007, 0.891762, -0.452505> }
	smooth_triangle { <-2.1627e-009, 4.26688, -1.79165>, <2.89022e-008, 0.976784, -0.214226>, <-0.066089, 4.24779, -1.85694>, <-0.0914121, 0.935551, -0.341158>, <-0.0469395, 4.26688, -1.78547> , <-0.0554449, 0.976784, -0.206926> }
	smooth_triangle { <-0.066089, 4.24779, -1.85694>, <-0.0914121, 0.935551, -0.341158>, <-2.1627e-009, 4.26688, -1.79165>, <2.89022e-008, 0.976784, -0.214226>, <-3.04499e-009, 4.24779, -1.86564> , <-3.72353e-007, 0.935551, -0.353192> }
	smooth_triangle { <-1.53462e-009, 4.27643, -1.73898>, <6.70803e-008, 0.986874, -0.161494>, <-0.0469395, 4.26688, -1.78547>, <-0.0554449, 0.976784, -0.206926>, <-0.0333078, 4.27643, -1.7346> , <-0.0417968, 0.986874, -0.155991> }
	smooth_triangle { <-0.0469395, 4.26688, -1.78547>, <-0.0554449, 0.976784, -0.206926>, <-1.53462e-009, 4.27643, -1.73898>, <6.70803e-008, 0.986874, -0.161494>, <-2.1627e-009, 4.26688, -1.79165> , <2.89022e-008, 0.976784, -0.214226> }
	smooth_triangle { <-8.42412e-010, 4.28491, -1.68093>, <3.72597e-008, 0.989488, -0.144617>, <-0.0333078, 4.27643, -1.7346>, <-0.0417968, 0.986874, -0.155991>, <-0.0182838, 4.28491, -1.67853> , <-0.0374288, 0.989488, -0.139689> }
	smooth_triangle { <-0.0333078, 4.27643, -1.7346>, <-0.0417968, 0.986874, -0.155991>, <-8.42412e-010, 4.28491, -1.68093>, <3.72597e-008, 0.989488, -0.144617>, <-1.53462e-009, 4.27643, -1.73898> , <6.70803e-008, 0.986874, -0.161494> }
	smooth_triangle { <-8.42412e-010, 4.28491, -1.68093>, <-7.11824e-007, 0.58578, -0.81047>, <-0.0162996, 4.29552, -1.67112>, <-0.24621, 0.30829, -0.918879>, <-7.50991e-010, 4.29552, -1.67327> , <-3.78569e-007, 0.30829, -0.951292> }
	smooth_triangle { <-0.0162996, 4.29552, -1.67112>, <-0.24621, 0.30829, -0.918879>, <-8.42412e-010, 4.28491, -1.68093>, <-7.11824e-007, 0.58578, -0.81047>, <-0.0182838, 4.28491, -1.67853> , <-0.209762, 0.585779, -0.782855> }
	smooth_triangle { <-0.0162996, 4.29552, -1.67112>, <-0.24621, 0.30829, -0.918879>, <-7.50991e-010, 4.30188, -1.67327>, <-3.75743e-009, 0, -1>, <-7.50991e-010, 4.29552, -1.67327> , <-3.78569e-007, 0.30829, -0.951292> }
	smooth_triangle { <-7.50991e-010, 4.30188, -1.67327>, <-3.75743e-009, 0, -1>, <-0.0162996, 4.29552, -1.67112>, <-0.24621, 0.30829, -0.918879>, <-0.0162996, 4.30188, -1.67112> , <-0.258816, 0, -0.965927> }
	smooth_triangle { <-0.0162996, 4.30188, -1.67112>, <-0.258816, 0, -0.965927>, <-7.50991e-010, 4.30931, -1.67327>, <6.1453e-008, 0.324097, -0.946024>, <-7.50991e-010, 4.30188, -1.67327> , <-3.75743e-009, 0, -1> }
	smooth_triangle { <-7.50991e-010, 4.30931, -1.67327>, <6.1453e-008, 0.324097, -0.946024>, <-0.0162996, 4.30188, -1.67112>, <-0.258816, 0, -0.965927>, <-0.0162996, 4.30931, -1.67112> , <-0.244847, 0.324096, -0.91379> }
	smooth_triangle { <-7.50991e-010, 4.30931, -1.67327>, <6.34353e-008, 0.324097, -0.946024>, <-0.0145987, 4.31779, -1.66477>, <-0.158382, 0.790899, -0.591095>, <-6.72624e-010, 4.31779, -1.6667> , <5.25027e-007, 0.790898, -0.611947> }
	smooth_triangle { <-0.0145987, 4.31779, -1.66477>, <-0.158382, 0.790899, -0.591095>, <-7.50991e-010, 4.30931, -1.67327>, <6.34353e-008, 0.324097, -0.946024>, <-0.0162996, 4.30931, -1.67112> , <-0.244847, 0.324096, -0.91379> }
	smooth_triangle { <-5.55078e-010, 4.32203, -1.65684>, <1.08951e-007, 0.773492, -0.633806>, <-0.0145987, 4.31779, -1.66477>, <-0.158382, 0.790899, -0.591095>, <-0.0120475, 4.32203, -1.65525> , <-0.164046, 0.773483, -0.61222> }
	smooth_triangle { <-0.0145987, 4.31779, -1.66477>, <-0.158382, 0.790899, -0.591095>, <-5.55078e-010, 4.32203, -1.65684>, <1.08951e-007, 0.773492, -0.633806>, <-6.72624e-010, 4.31779, -1.6667> , <5.25027e-007, 0.790898, -0.611947> }
	smooth_triangle { <-5.55078e-010, 4.32203, -1.65684>, <1.08951e-007, 0.773492, -0.633806>, <-0.0109136, 4.3284, -1.65102>, <-0.236904, 0.402663, -0.88416>, <-5.02835e-010, 4.3284, -1.65246> , <-3.39914e-007, 0.402668, -0.915346> }
	smooth_triangle { <-0.0109136, 4.3284, -1.65102>, <-0.236904, 0.402663, -0.88416>, <-5.55078e-010, 4.32203, -1.65684>, <1.08951e-007, 0.773492, -0.633806>, <-0.0120475, 4.32203, -1.65525> , <-0.164046, 0.773483, -0.61222> }
	smooth_triangle { <-5.02835e-010, 4.3284, -1.65246>, <-3.41824e-007, 0.402668, -0.915346>, <-0.0103467, 4.33794, -1.6489>, <-0.25738, 0.10502, -0.960586>, <-4.76714e-010, 4.33794, -1.65027> , <1.1352e-008, 0.10501, -0.994471> }
	smooth_triangle { <-0.0103467, 4.33794, -1.6489>, <-0.25738, 0.10502, -0.960586>, <-5.02835e-010, 4.3284, -1.65246>, <-3.41824e-007, 0.402668, -0.915346>, <-0.0109136, 4.3284, -1.65102> , <-0.236904, 0.402663, -0.88416> }
	smooth_triangle { <-0.0103467, 4.33794, -1.6489>, <-0.25738, 0.10502, -0.960586>, <-5.42018e-010, 4.69858, -1.65574>, <-8.28462e-008, -0.0829328, -0.996555>, <-4.76714e-010, 4.33794, -1.65027> , <1.1352e-008, 0.10501, -0.994471> }
	smooth_triangle { <-5.42018e-010, 4.69858, -1.65574>, <-8.28462e-008, -0.0829328, -0.996555>, <-0.0103467, 4.33794, -1.6489>, <-0.25738, 0.10502, -0.960586>, <-0.011764, 4.69858, -1.65419> , <-0.257932, -0.0829322, -0.962597> }
	smooth_triangle { <-0.011764, 4.69858, -1.65419>, <-0.257932, -0.0829322, -0.962597>, <-5.68138e-010, 4.71298, -1.65793>, <-2.25815e-008, -0.213315, -0.976983>, <-5.42018e-010, 4.69858, -1.65574> , <-8.28462e-008, -0.0829328, -0.996555> }
	smooth_triangle { <-5.68138e-010, 4.71298, -1.65793>, <-2.25815e-008, -0.213315, -0.976983>, <-0.011764, 4.69858, -1.65419>, <-0.257932, -0.0829322, -0.962597>, <-0.0123309, 4.71298, -1.65631> , <-0.25287, -0.213317, -0.943691> }
	smooth_triangle { <-0.0123309, 4.71298, -1.65631>, <-0.25287, -0.213317, -0.943691>, <-6.59564e-010, 4.73974, -1.6656>, <1.87849e-007, -0.311517, -0.950241>, <-5.68138e-010, 4.71298, -1.65793> , <-2.25815e-008, -0.213315, -0.976983> }
	smooth_triangle { <-6.59564e-010, 4.73974, -1.6656>, <1.87849e-007, -0.311517, -0.950241>, <-0.0123309, 4.71298, -1.65631>, <-0.25287, -0.213317, -0.943691>, <-0.0143152, 4.73974, -1.66372> , <-0.245943, -0.31152, -0.91786> }
	smooth_triangle { <-0.0143152, 4.73974, -1.66372>, <-0.245943, -0.31152, -0.91786>, <-7.64051e-010, 4.76341, -1.67436>, <4.42606e-008, -0.552522, -0.833498>, <-6.59564e-010, 4.73974, -1.6656> , <1.87849e-007, -0.311517, -0.950241> }
	smooth_triangle { <-7.64051e-010, 4.76341, -1.67436>, <4.42606e-008, -0.552522, -0.833498>, <-0.0143152, 4.73974, -1.66372>, <-0.245943, -0.31152, -0.91786>, <-0.016583, 4.76341, -1.67218> , <-0.215722, -0.552523, -0.805098> }
	smooth_triangle { <-0.0230892, 4.78708, -1.69646>, <-0.136029, -0.85074, -0.507678>, <-7.64051e-010, 4.76341, -1.67436>, <4.42606e-008, -0.552522, -0.833498>, <-0.016583, 4.76341, -1.67218> , <-0.215722, -0.552523, -0.805098> }
	smooth_triangle { <-7.64051e-010, 4.76341, -1.67436>, <4.42606e-008, -0.552522, -0.833498>, <-0.0230892, 4.78708, -1.69646>, <-0.136029, -0.85074, -0.507678>, <-1.06381e-009, 4.78708, -1.6995> , <-1.47715e-007, -0.85074, -0.525586> }
	smooth_triangle { <-0.0361401, 4.80561, -1.74517>, <-0.117457, -0.891097, -0.438349>, <-1.06381e-009, 4.78708, -1.6995>, <-1.48668e-007, -0.85074, -0.525586>, <-0.0230892, 4.78708, -1.69646> , <-0.136029, -0.85074, -0.507678> }
	smooth_triangle { <-1.06381e-009, 4.78708, -1.6995>, <-1.48668e-007, -0.85074, -0.525586>, <-0.0361401, 4.80561, -1.74517>, <-0.117457, -0.891097, -0.438349>, <-1.66512e-009, 4.80561, -1.74993> , <2.48082e-007, -0.891097, -0.453813> }
	smooth_triangle { <-0.0488648, 4.83854, -1.79266>, <-0.15403, -0.803632, -0.574847>, <-1.66512e-009, 4.80561, -1.74993>, <2.47142e-007, -0.891097, -0.453813>, <-0.0361401, 4.80561, -1.74517> , <-0.117457, -0.891097, -0.438349> }
	smooth_triangle { <-1.66512e-009, 4.80561, -1.74993>, <2.47142e-007, -0.891097, -0.453813>, <-0.0488648, 4.83854, -1.79266>, <-0.15403, -0.803632, -0.574847>, <-2.25141e-009, 4.83854, -1.79909> , <-1.75822e-007, -0.803631, -0.595128> }
	smooth_triangle { <-0.0570217, 4.86427, -1.8231>, <-0.185584, -0.697029, -0.692611>, <-2.25141e-009, 4.83854, -1.79909>, <-1.75822e-007, -0.803631, -0.595128>, <-0.0488648, 4.83854, -1.79266> , <-0.15403, -0.803632, -0.574847> }
	smooth_triangle { <-2.25141e-009, 4.83854, -1.79909>, <-1.75822e-007, -0.803631, -0.595128>, <-0.0570217, 4.86427, -1.8231>, <-0.185584, -0.697029, -0.692611>, <-2.62722e-009, 4.86427, -1.83061> , <-1.48785e-007, -0.697031, -0.717041> }
	smooth_triangle { <-0.0570217, 4.86427, -1.8231>, <-0.185584, -0.697029, -0.692611>, <-2.95796e-009, 4.90029, -1.85834>, <-3.6427e-007, -0.557317, -0.8303>, <-2.62722e-009, 4.86427, -1.83061> , <-1.48785e-007, -0.697031, -0.717041> }
	smooth_triangle { <-2.95796e-009, 4.90029, -1.85834>, <-3.6427e-007, -0.557317, -0.8303>, <-0.0570217, 4.86427, -1.8231>, <-0.185584, -0.697029, -0.692611>, <-0.0641997, 4.90029, -1.84989> , <-0.214901, -0.557313, -0.80201> }
	smooth_triangle { <-0.0641997, 4.90029, -1.84989>, <-0.214901, -0.557313, -0.80201>, <-3.21903e-009, 4.938, -1.88023>, <-4.04181e-007, -0.398843, -0.917019>, <-2.95796e-009, 4.90029, -1.85834> , <-3.6427e-007, -0.557317, -0.8303> }
	smooth_triangle { <-3.21903e-009, 4.938, -1.88023>, <-4.04181e-007, -0.398843, -0.917019>, <-0.0641997, 4.90029, -1.84989>, <-0.214901, -0.557313, -0.80201>, <-0.069866, 4.938, -1.87103> , <-0.237349, -0.398848, -0.885768> }
	smooth_triangle { <-0.069866, 4.938, -1.87103>, <-0.237349, -0.398848, -0.885768>, <-3.44727e-009, 5.00115, -1.89937>, <2.68696e-007, -0.17087, -0.985293>, <-3.21903e-009, 4.938, -1.88023> , <-4.02293e-007, -0.398843, -0.917019> }
	smooth_triangle { <-3.44727e-009, 5.00115, -1.89937>, <2.68696e-007, -0.17087, -0.985293>, <-0.069866, 4.938, -1.87103>, <-0.237349, -0.398848, -0.885768>, <-0.0748199, 5.00115, -1.88952> , <-0.255016, -0.170878, -0.951718> }
	smooth_triangle { <-0.0748199, 5.00115, -1.88952>, <-0.255016, -0.170878, -0.951718>, <-3.49914e-009, 5.08966, -1.90372>, <-4.13936e-008, 0.00604052, -0.999982>, <-3.44727e-009, 5.00115, -1.89937> , <2.68696e-007, -0.17087, -0.985294> }
	smooth_triangle { <-3.49914e-009, 5.08966, -1.90372>, <-4.13936e-008, 0.00604052, -0.999982>, <-0.0748199, 5.00115, -1.88952>, <-0.255016, -0.170878, -0.951718>, <-0.0759456, 5.08966, -1.89372> , <-0.258811, 0.00604215, -0.965909> }
	smooth_triangle { <-3.49914e-009, 5.08966, -1.90372>, <-4.13936e-008, 0.00604052, -0.999982>, <-0.0743142, 5.19258, -1.88763>, <-0.257908, 0.0837985, -0.962529>, <-3.42397e-009, 5.19258, -1.89742> , <-2.2549e-008, 0.0837971, -0.996483> }
	smooth_triangle { <-0.0743142, 5.19258, -1.88763>, <-0.257908, 0.0837985, -0.962529>, <-3.49914e-009, 5.08966, -1.90372>, <-4.13936e-008, 0.00604052, -0.999982>, <-0.0759456, 5.08966, -1.89372> , <-0.258811, 0.00604215, -0.965909> }
	smooth_triangle { <-3.42397e-009, 5.19258, -1.89742>, <-2.2549e-008, 0.0837971, -0.996483>, <-0.0713778, 5.29859, -1.87668>, <-0.257217, 0.111147, -0.959941>, <-3.28867e-009, 5.29859, -1.88607> , <1.20227e-007, 0.111141, -0.993805> }
	smooth_triangle { <-0.0713778, 5.29859, -1.87668>, <-0.257217, 0.111147, -0.959941>, <-3.42397e-009, 5.19258, -1.89742>, <-2.2549e-008, 0.0837971, -0.996483>, <-0.0743142, 5.19258, -1.88763> , <-0.257908, 0.0837985, -0.962529> }
	smooth_triangle { <-3.28867e-009, 5.29859, -1.88607>, <1.20227e-007, 0.111141, -0.993805>, <-0.0694202, 5.36342, -1.86937>, <-0.257077, 0.11587, -0.959419>, <-3.19848e-009, 5.36342, -1.87851> , <2.70504e-007, 0.115859, -0.993266> }
	smooth_triangle { <-0.0694202, 5.36342, -1.86937>, <-0.257077, 0.11587, -0.959419>, <-3.28867e-009, 5.29859, -1.88607>, <1.20227e-007, 0.111141, -0.993805>, <-0.0713778, 5.29859, -1.87668> , <-0.257217, 0.111147, -0.959941> }
	smooth_triangle { <-3.19848e-009, 5.36342, -1.87851>, <-2.25414e-007, 0.130122, -0.991498>, <-0.0664836, 5.44988, -1.85841>, <-0.256144, 0.143622, -0.95591>, <-3.06318e-009, 5.44988, -1.86716> , <-8.64138e-008, 0.143625, -0.989632> }
	smooth_triangle { <-0.0664836, 5.44988, -1.85841>, <-0.256144, 0.143622, -0.95591>, <-3.19848e-009, 5.36342, -1.87851>, <-2.25414e-007, 0.130122, -0.991498>, <-0.0694202, 5.36342, -1.86937> , <-0.25663, 0.130117, -0.957711> }
	smooth_triangle { <-3.06318e-009, 5.44988, -1.86716>, <-8.64138e-008, 0.143625, -0.989632>, <-0.063221, 5.52912, -1.84623>, <-0.255005, 0.17115, -0.951672>, <-2.91286e-009, 5.52912, -1.85456> , <1.42761e-007, 0.171156, -0.985244> }
	smooth_triangle { <-0.063221, 5.52912, -1.84623>, <-0.255005, 0.17115, -0.951672>, <-3.06318e-009, 5.44988, -1.86716>, <-8.64138e-008, 0.143625, -0.989632>, <-0.0664836, 5.44988, -1.85841> , <-0.256144, 0.143622, -0.95591> }
	smooth_triangle { <-2.91286e-009, 5.52912, -1.85456>, <1.42761e-007, 0.171156, -0.985244>, <-0.0612633, 5.56926, -1.83893>, <-0.254349, 0.185164, -0.949221>, <-2.82266e-009, 5.56926, -1.84699> , <2.32893e-007, 0.185175, -0.982705> }
	smooth_triangle { <-0.0612633, 5.56926, -1.83893>, <-0.254349, 0.185164, -0.949221>, <-2.91286e-009, 5.52912, -1.85456>, <1.42761e-007, 0.171156, -0.985244>, <-0.063221, 5.52912, -1.84623> , <-0.255005, 0.17115, -0.951672> }
	smooth_triangle { <-2.74749e-009, 5.56926, -1.84069>, <-2.12348e-006, 0.981303, 0.19247>, <-0.0612633, 5.56926, -1.83893>, <0, 1, 0>, <-0.059632, 5.56926, -1.83284> , <0.0498257, 0.981299, 0.185932> }
	smooth_triangle { <-0.0612633, 5.56926, -1.83893>, <0, 1, 0>, <-2.74749e-009, 5.56926, -1.84069>, <-2.12348e-006, 0.981303, 0.19247>, <-2.82266e-009, 5.56926, -1.84699> , <0, 1, 0> }
	smooth_triangle { <-2.68736e-009, 5.5672, -1.83565>, <-4.17003e-006, 0.925819, 0.377968>, <-0.059632, 5.56926, -1.83284>, <0.0498257, 0.981299, 0.185932>, <-0.0583268, 5.5672, -1.82797> , <0.097846, 0.925802, 0.365127> }
	smooth_triangle { <-0.059632, 5.56926, -1.83284>, <0.0498257, 0.981299, 0.185932>, <-2.68736e-009, 5.5672, -1.83565>, <-4.17003e-006, 0.925819, 0.377968>, <-2.74749e-009, 5.56926, -1.84069> , <-2.12348e-006, 0.981303, 0.19247> }
	smooth_triangle { <-2.68736e-009, 5.5672, -1.83565>, <-7.96453e-007, 0.134847, 0.990866>, <-0.0580006, 5.55794, -1.82675>, <0.256441, 0.134954, 0.957092>, <-2.67232e-009, 5.55794, -1.83439> , <-7.96453e-007, 0.134847, 0.990866> }
	smooth_triangle { <-0.0580006, 5.55794, -1.82675>, <0.256441, 0.134954, 0.957092>, <-2.68736e-009, 5.5672, -1.83565>, <-7.96453e-007, 0.134847, 0.990866>, <-0.0583268, 5.5672, -1.82797> , <0.256441, 0.134954, 0.957092> }
	smooth_triangle { <-0.0230892, 4.78708, -1.69646>, <-0.0369537, -0.989751, -0.137941>, <-1.69406e-011, 4.77442, -1.61171>, <1.54627e-006, -0.989754, -0.14278>, <-0.000367679, 4.77442, -1.61166> , <-0.0369537, -0.989751, -0.137941> }
	smooth_triangle { <-1.69406e-011, 4.77442, -1.61171>, <1.54627e-006, -0.989754, -0.14278>, <-0.0230892, 4.78708, -1.69646>, <-0.0369537, -0.989751, -0.137941>, <-1.06381e-009, 4.78708, -1.6995> , <1.54627e-006, -0.989754, -0.14278> }
	smooth_triangle { <-0.147036, 4.21572, -1.86496>, <0.0143243, -0.99959, 0.0248128>, <-0.000474268, 4.22409, -1.61206>, <0.00741706, -0.99959, 0.027673>, <-0.000916216, 4.22409, -1.61188> , <0.0143243, -0.99959, 0.0248128> }
	smooth_triangle { <-0.000474268, 4.22409, -1.61206>, <0.00741706, -0.99959, 0.027673>, <-0.147036, 4.21572, -1.86496>, <0.0143243, -0.99959, 0.0248128>, <-0.0761115, 4.21572, -1.89434> , <0.00741706, -0.99959, 0.027673> }
	smooth_triangle { <-0.0761115, 4.21572, -1.89434>, <-0.257895, 0.0846629, -0.962456>, <-0.146484, 4.2287, -1.86401>, <-0.498199, 0.0846955, -0.862916>, <-0.0758259, 4.2287, -1.89328> , <-0.257895, 0.0846629, -0.962456> }
	smooth_triangle { <-0.146484, 4.2287, -1.86401>, <-0.498199, 0.0846955, -0.862916>, <-0.0761115, 4.21572, -1.89434>, <-0.257895, 0.0846629, -0.962456>, <-0.147036, 4.21572, -1.86496> , <-0.498199, 0.0846955, -0.862916> }
	smooth_triangle { <-0.066089, 4.24779, -1.85694>, <-0.0914121, 0.935551, -0.341158>, <-0.146484, 4.2287, -1.86401>, <-0.226254, 0.891761, -0.391882>, <-0.127674, 4.24779, -1.83143> , <-0.176596, 0.935551, -0.305874> }
	smooth_triangle { <-0.146484, 4.2287, -1.86401>, <-0.226254, 0.891761, -0.391882>, <-0.066089, 4.24779, -1.85694>, <-0.0914121, 0.935551, -0.341158>, <-0.0758259, 4.2287, -1.89328> , <-0.117116, 0.891761, -0.437087> }
	smooth_triangle { <-0.0469395, 4.26688, -1.78547>, <-0.0554449, 0.976784, -0.206926>, <-0.127674, 4.24779, -1.83143>, <-0.176596, 0.935551, -0.305874>, <-0.0906801, 4.26688, -1.76735> , <-0.107113, 0.976784, -0.185525> }
	smooth_triangle { <-0.127674, 4.24779, -1.83143>, <-0.176596, 0.935551, -0.305874>, <-0.0469395, 4.26688, -1.78547>, <-0.0554449, 0.976784, -0.206926>, <-0.066089, 4.24779, -1.85694> , <-0.0914121, 0.935551, -0.341158> }
	smooth_triangle { <-0.0333078, 4.27643, -1.7346>, <-0.0417968, 0.986874, -0.155991>, <-0.0906801, 4.26688, -1.76735>, <-0.107113, 0.976784, -0.185525>, <-0.0643457, 4.27643, -1.72174> , <-0.0807471, 0.986874, -0.139859> }
	smooth_triangle { <-0.0906801, 4.26688, -1.76735>, <-0.107113, 0.976784, -0.185525>, <-0.0333078, 4.27643, -1.7346>, <-0.0417968, 0.986874, -0.155991>, <-0.0469395, 4.26688, -1.78547> , <-0.0554449, 0.976784, -0.206926> }
	smooth_triangle { <-0.0182838, 4.28491, -1.67853>, <-0.0374288, 0.989488, -0.139689>, <-0.0643457, 4.27643, -1.72174>, <-0.0807471, 0.986874, -0.139859>, <-0.0353216, 4.28491, -1.67147> , <-0.0723068, 0.989488, -0.125242> }
	smooth_triangle { <-0.0643457, 4.27643, -1.72174>, <-0.0807471, 0.986874, -0.139859>, <-0.0182838, 4.28491, -1.67853>, <-0.0374288, 0.989488, -0.139689>, <-0.0333078, 4.27643, -1.7346> , <-0.0417968, 0.986874, -0.155991> }
	smooth_triangle { <-0.0182838, 4.28491, -1.67853>, <-0.209762, 0.585779, -0.782855>, <-0.0314883, 4.29552, -1.66483>, <-0.475644, 0.308295, -0.823843>, <-0.0162996, 4.29552, -1.67112> , <-0.24621, 0.30829, -0.918879> }
	smooth_triangle { <-0.0314883, 4.29552, -1.66483>, <-0.475644, 0.308295, -0.823843>, <-0.0182838, 4.28491, -1.67853>, <-0.209762, 0.585779, -0.782855>, <-0.0353216, 4.28491, -1.67147> , <-0.405228, 0.585788, -0.701885> }
	smooth_triangle { <-0.0314883, 4.29552, -1.66483>, <-0.475644, 0.308295, -0.823843>, <-0.0162996, 4.30188, -1.67112>, <-0.258816, 0, -0.965927>, <-0.0162996, 4.29552, -1.67112> , <-0.24621, 0.30829, -0.918879> }
	smooth_triangle { <-0.0162996, 4.30188, -1.67112>, <-0.258816, 0, -0.965927>, <-0.0314883, 4.29552, -1.66483>, <-0.475644, 0.308295, -0.823843>, <-0.0314883, 4.30188, -1.66483> , <-0.500001, 0, -0.866025> }
	smooth_triangle { <-0.0314883, 4.30188, -1.66483>, <-0.500001, 0, -0.866025>, <-0.0162996, 4.30931, -1.67112>, <-0.244847, 0.324096, -0.91379>, <-0.0162996, 4.30188, -1.67112> , <-0.258816, 0, -0.965927> }
	smooth_triangle { <-0.0162996, 4.30931, -1.67112>, <-0.244847, 0.324096, -0.91379>, <-0.0314883, 4.30188, -1.66483>, <-0.500001, 0, -0.866025>, <-0.0314883, 4.30931, -1.66483> , <-0.473013, 0.324096, -0.819281> }
	smooth_triangle { <-0.0162996, 4.30931, -1.67112>, <-0.244847, 0.324096, -0.91379>, <-0.0282025, 4.31779, -1.65914>, <-0.305975, 0.790898, -0.529963>, <-0.0145987, 4.31779, -1.66477> , <-0.158382, 0.790899, -0.591095> }
	smooth_triangle { <-0.0282025, 4.31779, -1.65914>, <-0.305975, 0.790898, -0.529963>, <-0.0162996, 4.30931, -1.67112>, <-0.244847, 0.324096, -0.91379>, <-0.0314883, 4.30931, -1.66483> , <-0.473013, 0.324096, -0.819281> }
	smooth_triangle { <-0.0120475, 4.32203, -1.65525>, <-0.164046, 0.773483, -0.61222>, <-0.0282025, 4.31779, -1.65914>, <-0.305975, 0.790898, -0.529963>, <-0.0232739, 4.32203, -1.6506> , <-0.316905, 0.773482, -0.548905> }
	smooth_triangle { <-0.0282025, 4.31779, -1.65914>, <-0.305975, 0.790898, -0.529963>, <-0.0120475, 4.32203, -1.65525>, <-0.164046, 0.773483, -0.61222>, <-0.0145987, 4.31779, -1.66477> , <-0.158382, 0.790899, -0.591095> }
	smooth_triangle { <-0.0120475, 4.32203, -1.65525>, <-0.164046, 0.773483, -0.61222>, <-0.0210834, 4.3284, -1.64681>, <-0.457664, 0.40267, -0.792718>, <-0.0109136, 4.3284, -1.65102> , <-0.236904, 0.402663, -0.88416> }
	smooth_triangle { <-0.0210834, 4.3284, -1.64681>, <-0.457664, 0.40267, -0.792718>, <-0.0120475, 4.32203, -1.65525>, <-0.164046, 0.773483, -0.61222>, <-0.0232739, 4.32203, -1.6506> , <-0.316905, 0.773482, -0.548905> }
	smooth_triangle { <-0.0109136, 4.3284, -1.65102>, <-0.236904, 0.402663, -0.88416>, <-0.0199882, 4.33794, -1.64491>, <-0.497229, 0.105027, -0.861239>, <-0.0103467, 4.33794, -1.6489> , <-0.25738, 0.10502, -0.960586> }
	smooth_triangle { <-0.0199882, 4.33794, -1.64491>, <-0.497229, 0.105027, -0.861239>, <-0.0109136, 4.3284, -1.65102>, <-0.236904, 0.402663, -0.88416>, <-0.0210834, 4.3284, -1.64681> , <-0.457664, 0.40267, -0.792718> }
	smooth_triangle { <-0.0199882, 4.33794, -1.64491>, <-0.497229, 0.105027, -0.861239>, <-0.011764, 4.69858, -1.65419>, <-0.257932, -0.0829322, -0.962597>, <-0.0103467, 4.33794, -1.6489> , <-0.25738, 0.10502, -0.960586> }
	smooth_triangle { <-0.011764, 4.69858, -1.65419>, <-0.257932, -0.0829322, -0.962597>, <-0.0199882, 4.33794, -1.64491>, <-0.497229, 0.105027, -0.861239>, <-0.0227263, 4.69858, -1.64965> , <-0.498278, -0.0829363, -0.863042> }
	smooth_triangle { <-0.0227263, 4.69858, -1.64965>, <-0.498278, -0.0829363, -0.863042>, <-0.0123309, 4.71298, -1.65631>, <-0.25287, -0.213317, -0.943691>, <-0.011764, 4.69858, -1.65419> , <-0.257932, -0.0829322, -0.962597> }
	smooth_triangle { <-0.0123309, 4.71298, -1.65631>, <-0.25287, -0.213317, -0.943691>, <-0.0227263, 4.69858, -1.64965>, <-0.498278, -0.0829363, -0.863042>, <-0.0238215, 4.71298, -1.65155> , <-0.488489, -0.213318, -0.846093> }
	smooth_triangle { <-0.0238215, 4.71298, -1.65155>, <-0.488489, -0.213318, -0.846093>, <-0.0143152, 4.73974, -1.66372>, <-0.245943, -0.31152, -0.91786>, <-0.0123309, 4.71298, -1.65631> , <-0.25287, -0.213317, -0.943691> }
	smooth_triangle { <-0.0143152, 4.73974, -1.66372>, <-0.245943, -0.31152, -0.91786>, <-0.0238215, 4.71298, -1.65155>, <-0.488489, -0.213318, -0.846093>, <-0.0276549, 4.73974, -1.65819> , <-0.475117, -0.311518, -0.822934> }
	smooth_triangle { <-0.0276549, 4.73974, -1.65819>, <-0.475117, -0.311518, -0.822934>, <-0.016583, 4.76341, -1.67218>, <-0.215722, -0.552523, -0.805098>, <-0.0143152, 4.73974, -1.66372> , <-0.245943, -0.31152, -0.91786> }
	smooth_triangle { <-0.016583, 4.76341, -1.67218>, <-0.215722, -0.552523, -0.805098>, <-0.0276549, 4.73974, -1.65819>, <-0.475117, -0.311518, -0.822934>, <-0.032036, 4.76341, -1.66578> , <-0.416749, -0.552523, -0.72183> }
	smooth_triangle { <-0.0446049, 4.78708, -1.68755>, <-0.262795, -0.85074, -0.455171>, <-0.016583, 4.76341, -1.67218>, <-0.215722, -0.552523, -0.805098>, <-0.032036, 4.76341, -1.66578> , <-0.416749, -0.552523, -0.72183> }
	smooth_triangle { <-0.016583, 4.76341, -1.67218>, <-0.215722, -0.552523, -0.805098>, <-0.0446049, 4.78708, -1.68755>, <-0.262795, -0.85074, -0.455171>, <-0.0230892, 4.78708, -1.69646> , <-0.136029, -0.85074, -0.507678> }
	smooth_triangle { <-0.0698173, 4.80561, -1.73122>, <-0.226909, -0.891096, -0.393014>, <-0.0230892, 4.78708, -1.69646>, <-0.136029, -0.85074, -0.507678>, <-0.0446049, 4.78708, -1.68755> , <-0.262795, -0.85074, -0.455171> }
	smooth_triangle { <-0.0230892, 4.78708, -1.69646>, <-0.136029, -0.85074, -0.507678>, <-0.0698173, 4.80561, -1.73122>, <-0.226909, -0.891096, -0.393014>, <-0.0361401, 4.80561, -1.74517> , <-0.117457, -0.891097, -0.438349> }
	smooth_triangle { <-0.0943997, 4.83854, -1.7738>, <-0.297567, -0.803633, -0.515392>, <-0.0361401, 4.80561, -1.74517>, <-0.117457, -0.891097, -0.438349>, <-0.0698173, 4.80561, -1.73122> , <-0.226909, -0.891096, -0.393014> }
	smooth_triangle { <-0.0361401, 4.80561, -1.74517>, <-0.117457, -0.891097, -0.438349>, <-0.0943997, 4.83854, -1.7738>, <-0.297567, -0.803633, -0.515392>, <-0.0488648, 4.83854, -1.79266> , <-0.15403, -0.803632, -0.574847> }
	smooth_triangle { <-0.110158, 4.86427, -1.80109>, <-0.358527, -0.697027, -0.620976>, <-0.0488648, 4.83854, -1.79266>, <-0.15403, -0.803632, -0.574847>, <-0.0943997, 4.83854, -1.7738> , <-0.297567, -0.803633, -0.515392> }
	smooth_triangle { <-0.0488648, 4.83854, -1.79266>, <-0.15403, -0.803632, -0.574847>, <-0.110158, 4.86427, -1.80109>, <-0.358527, -0.697027, -0.620976>, <-0.0570217, 4.86427, -1.8231> , <-0.185584, -0.697029, -0.692611> }
	smooth_triangle { <-0.110158, 4.86427, -1.80109>, <-0.358527, -0.697027, -0.620976>, <-0.0641997, 4.90029, -1.84989>, <-0.214901, -0.557313, -0.80201>, <-0.0570217, 4.86427, -1.8231> , <-0.185584, -0.697029, -0.692611> }
	smooth_triangle { <-0.0641997, 4.90029, -1.84989>, <-0.214901, -0.557313, -0.80201>, <-0.110158, 4.86427, -1.80109>, <-0.358527, -0.697027, -0.620976>, <-0.124024, 4.90029, -1.82511> , <-0.415158, -0.557309, -0.719062> }
	smooth_triangle { <-0.124024, 4.90029, -1.82511>, <-0.415158, -0.557309, -0.719062>, <-0.069866, 4.938, -1.87103>, <-0.237349, -0.398848, -0.885768>, <-0.0641997, 4.90029, -1.84989> , <-0.214901, -0.557313, -0.80201> }
	smooth_triangle { <-0.069866, 4.938, -1.87103>, <-0.237349, -0.398848, -0.885768>, <-0.124024, 4.90029, -1.82511>, <-0.415158, -0.557309, -0.719062>, <-0.134971, 4.938, -1.84407> , <-0.458517, -0.398847, -0.794156> }
	smooth_triangle { <-0.134971, 4.938, -1.84407>, <-0.458517, -0.398847, -0.794156>, <-0.0748199, 5.00115, -1.88952>, <-0.255016, -0.170878, -0.951718>, <-0.069866, 4.938, -1.87103> , <-0.237349, -0.398848, -0.885768> }
	smooth_triangle { <-0.0748199, 5.00115, -1.88952>, <-0.255016, -0.170878, -0.951718>, <-0.134971, 4.938, -1.84407>, <-0.458517, -0.398847, -0.794156>, <-0.144541, 5.00115, -1.86064> , <-0.492653, -0.170886, -0.853282> }
	smooth_triangle { <-0.144541, 5.00115, -1.86064>, <-0.492653, -0.170886, -0.853282>, <-0.0759456, 5.08966, -1.89372>, <-0.258811, 0.00604215, -0.965909>, <-0.0748199, 5.00115, -1.88952> , <-0.255016, -0.170878, -0.951718> }
	smooth_triangle { <-0.0759456, 5.08966, -1.89372>, <-0.258811, 0.00604215, -0.965909>, <-0.144541, 5.00115, -1.86064>, <-0.492653, -0.170886, -0.853282>, <-0.146716, 5.08966, -1.86441> , <-0.49999, 0.00603642, -0.86601> }
	smooth_triangle { <-0.0759456, 5.08966, -1.89372>, <-0.258811, 0.00604215, -0.965909>, <-0.143564, 5.19258, -1.85895>, <-0.498236, 0.083801, -0.862982>, <-0.0743142, 5.19258, -1.88763> , <-0.257908, 0.0837985, -0.962529> }
	smooth_triangle { <-0.143564, 5.19258, -1.85895>, <-0.498236, 0.083801, -0.862982>, <-0.0759456, 5.08966, -1.89372>, <-0.258811, 0.00604215, -0.965909>, <-0.146716, 5.08966, -1.86441> , <-0.49999, 0.00603642, -0.86601> }
	smooth_triangle { <-0.0743142, 5.19258, -1.88763>, <-0.257908, 0.0837985, -0.962529>, <-0.137891, 5.29859, -1.84912>, <-0.496899, 0.111148, -0.860661>, <-0.0713778, 5.29859, -1.87668> , <-0.257217, 0.111147, -0.959941> }
	smooth_triangle { <-0.137891, 5.29859, -1.84912>, <-0.496899, 0.111148, -0.860661>, <-0.0743142, 5.19258, -1.88763>, <-0.257908, 0.0837985, -0.962529>, <-0.143564, 5.19258, -1.85895> , <-0.498236, 0.083801, -0.862982> }
	smooth_triangle { <-0.0713778, 5.29859, -1.87668>, <-0.257217, 0.111147, -0.959941>, <-0.134109, 5.36342, -1.84257>, <-0.496626, 0.115877, -0.860195>, <-0.0694202, 5.36342, -1.86937> , <-0.257077, 0.11587, -0.959419> }
	smooth_triangle { <-0.134109, 5.36342, -1.84257>, <-0.496626, 0.115877, -0.860195>, <-0.0713778, 5.29859, -1.87668>, <-0.257217, 0.111147, -0.959941>, <-0.137891, 5.29859, -1.84912> , <-0.496899, 0.111148, -0.860661> }
	smooth_triangle { <-0.0694202, 5.36342, -1.86937>, <-0.25663, 0.130117, -0.957711>, <-0.128436, 5.44988, -1.83275>, <-0.494821, 0.143622, -0.857044>, <-0.0664836, 5.44988, -1.85841> , <-0.256144, 0.143622, -0.955909> }
	smooth_triangle { <-0.128436, 5.44988, -1.83275>, <-0.494821, 0.143622, -0.857044>, <-0.0694202, 5.36342, -1.86937>, <-0.25663, 0.130117, -0.957711>, <-0.134109, 5.36342, -1.84257> , <-0.495749, 0.130126, -0.858662> }
	smooth_triangle { <-0.0664836, 5.44988, -1.85841>, <-0.256144, 0.143622, -0.95591>, <-0.122133, 5.52912, -1.82183>, <-0.492627, 0.171149, -0.853245>, <-0.063221, 5.52912, -1.84623> , <-0.255005, 0.17115, -0.951672> }
	smooth_triangle { <-0.122133, 5.52912, -1.82183>, <-0.492627, 0.171149, -0.853245>, <-0.0664836, 5.44988, -1.85841>, <-0.256144, 0.143622, -0.95591>, <-0.128436, 5.44988, -1.83275> , <-0.494821, 0.143622, -0.857044> }
	smooth_triangle { <-0.063221, 5.52912, -1.84623>, <-0.255005, 0.17115, -0.951672>, <-0.118352, 5.56926, -1.81528>, <-0.491352, 0.185173, -0.851049>, <-0.0612633, 5.56926, -1.83893> , <-0.254349, 0.185164, -0.949221> }
	smooth_triangle { <-0.118352, 5.56926, -1.81528>, <-0.491352, 0.185173, -0.851049>, <-0.063221, 5.52912, -1.84623>, <-0.255005, 0.17115, -0.951672>, <-0.122133, 5.52912, -1.82183> , <-0.492627, 0.171149, -0.853245> }
	smooth_triangle { <-0.059632, 5.56926, -1.83284>, <0.0498257, 0.981299, 0.185932>, <-0.118352, 5.56926, -1.81528>, <0, 1, 0>, <-0.1152, 5.56926, -1.80982> , <0.0962578, 0.981293, 0.166727> }
	smooth_triangle { <-0.118352, 5.56926, -1.81528>, <0, 1, 0>, <-0.059632, 5.56926, -1.83284>, <0.0498257, 0.981299, 0.185932>, <-0.0612633, 5.56926, -1.83893> , <0, 1, 0> }
	smooth_triangle { <-0.0583268, 5.5672, -1.82797>, <0.097846, 0.925802, 0.365127>, <-0.1152, 5.56926, -1.80982>, <0.0962578, 0.981293, 0.166727>, <-0.112679, 5.5672, -1.80546> , <0.189027, 0.925781, 0.327411> }
	smooth_triangle { <-0.1152, 5.56926, -1.80982>, <0.0962578, 0.981293, 0.166727>, <-0.0583268, 5.5672, -1.82797>, <0.097846, 0.925802, 0.365127>, <-0.059632, 5.56926, -1.83284> , <0.0498257, 0.981299, 0.185932> }
	smooth_triangle { <-0.0583268, 5.5672, -1.82797>, <0.256441, 0.134954, 0.957092>, <-0.112048, 5.55794, -1.80436>, <0.495416, 0.134946, 0.85811>, <-0.0580006, 5.55794, -1.82675> , <0.256441, 0.134954, 0.957092> }
	smooth_triangle { <-0.112048, 5.55794, -1.80436>, <0.495416, 0.134946, 0.85811>, <-0.0583268, 5.5672, -1.82797>, <0.256441, 0.134954, 0.957092>, <-0.112679, 5.5672, -1.80546> , <0.495416, 0.134946, 0.85811> }
	smooth_triangle { <-0.0446049, 4.78708, -1.68755>, <-0.0713774, -0.989754, -0.12366>, <-0.000367679, 4.77442, -1.61166>, <-0.0369537, -0.989751, -0.137941>, <-0.0007103, 4.77442, -1.61152> , <-0.0713774, -0.989754, -0.12366> }
	smooth_triangle { <-0.000367679, 4.77442, -1.61166>, <-0.0369537, -0.989751, -0.137941>, <-0.0446049, 4.78708, -1.68755>, <-0.0713774, -0.989754, -0.12366>, <-0.0230892, 4.78708, -1.69646> , <-0.0369537, -0.989751, -0.137941> }
	smooth_triangle { <-0.207941, 4.21572, -1.81823>, <0.0202575, -0.99959, 0.0202594>, <-0.000916216, 4.22409, -1.61188>, <0.0143243, -0.99959, 0.0248128>, <-0.00129573, 4.22409, -1.61159> , <0.0202575, -0.99959, 0.0202594> }
	smooth_triangle { <-0.000916216, 4.22409, -1.61188>, <0.0143243, -0.99959, 0.0248128>, <-0.207941, 4.21572, -1.81823>, <0.0202575, -0.99959, 0.0202594>, <-0.147036, 4.21572, -1.86496> , <0.0143243, -0.99959, 0.0248128> }
	smooth_triangle { <-0.147036, 4.21572, -1.86496>, <-0.498199, 0.0846955, -0.862916>, <-0.20716, 4.2287, -1.81745>, <-0.704566, 0.0846999, -0.704565>, <-0.146484, 4.2287, -1.86401> , <-0.498199, 0.0846955, -0.862916> }
	smooth_triangle { <-0.20716, 4.2287, -1.81745>, <-0.704566, 0.0846999, -0.704565>, <-0.147036, 4.21572, -1.86496>, <-0.498199, 0.0846955, -0.862916>, <-0.207941, 4.21572, -1.81823> , <-0.704566, 0.0846999, -0.704565> }
	smooth_triangle { <-0.127674, 4.24779, -1.83143>, <-0.176596, 0.935551, -0.305874>, <-0.20716, 4.2287, -1.81745>, <-0.319971, 0.89176, -0.319972>, <-0.180559, 4.24779, -1.79085> , <-0.249745, 0.935551, -0.249745> }
	smooth_triangle { <-0.20716, 4.2287, -1.81745>, <-0.319971, 0.89176, -0.319972>, <-0.127674, 4.24779, -1.83143>, <-0.176596, 0.935551, -0.305874>, <-0.146484, 4.2287, -1.86401> , <-0.226254, 0.891761, -0.391882> }
	smooth_triangle { <-0.0906801, 4.26688, -1.76735>, <-0.107113, 0.976784, -0.185525>, <-0.180559, 4.24779, -1.79085>, <-0.249745, 0.935551, -0.249745>, <-0.128241, 4.26688, -1.73853> , <-0.151481, 0.976784, -0.15148> }
	smooth_triangle { <-0.180559, 4.24779, -1.79085>, <-0.249745, 0.935551, -0.249745>, <-0.0906801, 4.26688, -1.76735>, <-0.107113, 0.976784, -0.185525>, <-0.127674, 4.24779, -1.83143> , <-0.176596, 0.935551, -0.305874> }
	smooth_triangle { <-0.0643457, 4.27643, -1.72174>, <-0.0807471, 0.986874, -0.139859>, <-0.128241, 4.26688, -1.73853>, <-0.151481, 0.976784, -0.15148>, <-0.0909986, 4.27643, -1.70129> , <-0.114194, 0.986874, -0.114194> }
	smooth_triangle { <-0.128241, 4.26688, -1.73853>, <-0.151481, 0.976784, -0.15148>, <-0.0643457, 4.27643, -1.72174>, <-0.0807471, 0.986874, -0.139859>, <-0.0906801, 4.26688, -1.76735> , <-0.107113, 0.976784, -0.185525> }
	smooth_triangle { <-0.0353216, 4.28491, -1.67147>, <-0.0723068, 0.989488, -0.125242>, <-0.0909986, 4.27643, -1.70129>, <-0.114194, 0.986874, -0.114194>, <-0.0499523, 4.28491, -1.66024> , <-0.102259, 0.989488, -0.102259> }
	smooth_triangle { <-0.0909986, 4.27643, -1.70129>, <-0.114194, 0.986874, -0.114194>, <-0.0353216, 4.28491, -1.67147>, <-0.0723068, 0.989488, -0.125242>, <-0.0643457, 4.27643, -1.72174> , <-0.0807471, 0.986874, -0.139859> }
	smooth_triangle { <-0.0353216, 4.28491, -1.67147>, <-0.405228, 0.585788, -0.701885>, <-0.0445314, 4.29552, -1.65482>, <-0.672663, 0.3083, -0.672663>, <-0.0314883, 4.29552, -1.66483> , <-0.475644, 0.308295, -0.823843> }
	smooth_triangle { <-0.0445314, 4.29552, -1.65482>, <-0.672663, 0.3083, -0.672663>, <-0.0353216, 4.28491, -1.67147>, <-0.405228, 0.585788, -0.701885>, <-0.0499523, 4.28491, -1.66024> , <-0.573077, 0.585796, -0.573084> }
	smooth_triangle { <-0.0445314, 4.29552, -1.65482>, <-0.672663, 0.3083, -0.672663>, <-0.0314883, 4.30188, -1.66483>, <-0.500001, 0, -0.866025>, <-0.0314883, 4.29552, -1.66483> , <-0.475644, 0.308295, -0.823843> }
	smooth_triangle { <-0.0314883, 4.30188, -1.66483>, <-0.500001, 0, -0.866025>, <-0.0445314, 4.29552, -1.65482>, <-0.672663, 0.3083, -0.672663>, <-0.0445314, 4.30188, -1.65482> , <-0.70711, 0, -0.707104> }
	smooth_triangle { <-0.0445314, 4.30188, -1.65482>, <-0.70711, 0, -0.707104>, <-0.0314883, 4.30931, -1.66483>, <-0.473013, 0.324096, -0.819281>, <-0.0314883, 4.30188, -1.66483> , <-0.500001, 0, -0.866025> }
	smooth_triangle { <-0.0314883, 4.30931, -1.66483>, <-0.473013, 0.324096, -0.819281>, <-0.0445314, 4.30188, -1.65482>, <-0.70711, 0, -0.707104>, <-0.0445314, 4.30931, -1.65482> , <-0.668945, 0.324092, -0.668938> }
	smooth_triangle { <-0.0314883, 4.30931, -1.66483>, <-0.473013, 0.324096, -0.819281>, <-0.0398845, 4.31779, -1.65017>, <-0.432715, 0.790897, -0.432713>, <-0.0282025, 4.31779, -1.65914> , <-0.305975, 0.790898, -0.529963> }
	smooth_triangle { <-0.0398845, 4.31779, -1.65017>, <-0.432715, 0.790897, -0.432713>, <-0.0314883, 4.30931, -1.66483>, <-0.473013, 0.324096, -0.819281>, <-0.0445314, 4.30931, -1.65482> , <-0.668945, 0.324092, -0.668938> }
	smooth_triangle { <-0.0232739, 4.32203, -1.6506>, <-0.316905, 0.773482, -0.548905>, <-0.0398845, 4.31779, -1.65017>, <-0.432715, 0.790897, -0.432713>, <-0.0329144, 4.32203, -1.6432> , <-0.448181, 0.773481, -0.448176> }
	smooth_triangle { <-0.0398845, 4.31779, -1.65017>, <-0.432715, 0.790897, -0.432713>, <-0.0232739, 4.32203, -1.6506>, <-0.316905, 0.773482, -0.548905>, <-0.0282025, 4.31779, -1.65914> , <-0.305975, 0.790898, -0.529963> }
	smooth_triangle { <-0.0232739, 4.32203, -1.6506>, <-0.316905, 0.773482, -0.548905>, <-0.0298165, 4.3284, -1.64011>, <-0.647252, 0.402665, -0.647245>, <-0.0210834, 4.3284, -1.64681> , <-0.457664, 0.40267, -0.792718> }
	smooth_triangle { <-0.0298165, 4.3284, -1.64011>, <-0.647252, 0.402665, -0.647245>, <-0.0232739, 4.32203, -1.6506>, <-0.316905, 0.773482, -0.548905>, <-0.0329144, 4.32203, -1.6432> , <-0.448181, 0.773481, -0.448176> }
	smooth_triangle { <-0.0210834, 4.3284, -1.64681>, <-0.457664, 0.40267, -0.792718>, <-0.0282676, 4.33794, -1.63856>, <-0.703197, 0.105027, -0.703195>, <-0.0199882, 4.33794, -1.64491> , <-0.497229, 0.105027, -0.861239> }
	smooth_triangle { <-0.0282676, 4.33794, -1.63856>, <-0.703197, 0.105027, -0.703195>, <-0.0210834, 4.3284, -1.64681>, <-0.457664, 0.40267, -0.792718>, <-0.0298165, 4.3284, -1.64011> , <-0.647252, 0.402665, -0.647245> }
	smooth_triangle { <-0.0282676, 4.33794, -1.63856>, <-0.703197, 0.105027, -0.703195>, <-0.0227263, 4.69858, -1.64965>, <-0.498278, -0.0829363, -0.863042>, <-0.0199882, 4.33794, -1.64491> , <-0.497229, 0.105027, -0.861239> }
	smooth_triangle { <-0.0227263, 4.69858, -1.64965>, <-0.498278, -0.0829363, -0.863042>, <-0.0282676, 4.33794, -1.63856>, <-0.703197, 0.105027, -0.703195>, <-0.0321399, 4.69858, -1.64243> , <-0.704671, -0.0829369, -0.70467> }
	smooth_triangle { <-0.0321399, 4.69858, -1.64243>, <-0.704671, -0.0829369, -0.70467>, <-0.0238215, 4.71298, -1.65155>, <-0.488489, -0.213318, -0.846093>, <-0.0227263, 4.69858, -1.64965> , <-0.498278, -0.0829362, -0.863042> }
	smooth_triangle { <-0.0238215, 4.71298, -1.65155>, <-0.488489, -0.213318, -0.846093>, <-0.0321399, 4.69858, -1.64243>, <-0.704671, -0.0829369, -0.70467>, <-0.0336888, 4.71298, -1.64398> , <-0.690829, -0.213317, -0.690833> }
	smooth_triangle { <-0.0336888, 4.71298, -1.64398>, <-0.690829, -0.213317, -0.690833>, <-0.0276549, 4.73974, -1.65819>, <-0.475117, -0.311518, -0.822934>, <-0.0238215, 4.71298, -1.65155> , <-0.488489, -0.213318, -0.846093> }
	smooth_triangle { <-0.0276549, 4.73974, -1.65819>, <-0.475117, -0.311518, -0.822934>, <-0.0336888, 4.71298, -1.64398>, <-0.690829, -0.213317, -0.690833>, <-0.0391101, 4.73974, -1.6494> , <-0.671923, -0.311516, -0.671921> }
	smooth_triangle { <-0.0391101, 4.73974, -1.6494>, <-0.671923, -0.311516, -0.671921>, <-0.032036, 4.76341, -1.66578>, <-0.416749, -0.552523, -0.72183>, <-0.0276549, 4.73974, -1.65819> , <-0.475117, -0.311518, -0.822934> }
	smooth_triangle { <-0.032036, 4.76341, -1.66578>, <-0.416749, -0.552523, -0.72183>, <-0.0391101, 4.73974, -1.6494>, <-0.671923, -0.311516, -0.671921>, <-0.0453058, 4.76341, -1.6556> , <-0.589375, -0.552523, -0.589369> }
	smooth_triangle { <-0.0630807, 4.78708, -1.67337>, <-0.371647, -0.85074, -0.371644>, <-0.032036, 4.76341, -1.66578>, <-0.416749, -0.552523, -0.72183>, <-0.0453058, 4.76341, -1.6556> , <-0.589375, -0.552523, -0.589369> }
	smooth_triangle { <-0.032036, 4.76341, -1.66578>, <-0.416749, -0.552523, -0.72183>, <-0.0630807, 4.78708, -1.67337>, <-0.371647, -0.85074, -0.371644>, <-0.0446049, 4.78708, -1.68755> , <-0.262795, -0.85074, -0.455171> }
	smooth_triangle { <-0.0987367, 4.80561, -1.70903>, <-0.320895, -0.891096, -0.320895>, <-0.0446049, 4.78708, -1.68755>, <-0.262795, -0.85074, -0.455171>, <-0.0630807, 4.78708, -1.67337> , <-0.371647, -0.85074, -0.371644> }
	smooth_triangle { <-0.0446049, 4.78708, -1.68755>, <-0.262795, -0.85074, -0.455171>, <-0.0987367, 4.80561, -1.70903>, <-0.320895, -0.891096, -0.320895>, <-0.0698173, 4.80561, -1.73122> , <-0.226909, -0.891096, -0.393014> }
	smooth_triangle { <-0.133501, 4.83854, -1.74379>, <-0.420819, -0.803631, -0.420819>, <-0.0698173, 4.80561, -1.73122>, <-0.226909, -0.891096, -0.393014>, <-0.0987367, 4.80561, -1.70903> , <-0.320895, -0.891096, -0.320895> }
	smooth_triangle { <-0.0698173, 4.80561, -1.73122>, <-0.226909, -0.891096, -0.393014>, <-0.133501, 4.83854, -1.74379>, <-0.420819, -0.803631, -0.420819>, <-0.0943997, 4.83854, -1.7738> , <-0.297567, -0.803633, -0.515392> }
	smooth_triangle { <-0.155786, 4.86427, -1.76608>, <-0.507029, -0.697027, -0.507025>, <-0.0943997, 4.83854, -1.7738>, <-0.297567, -0.803633, -0.515392>, <-0.133501, 4.83854, -1.74379> , <-0.420819, -0.803631, -0.420819> }
	smooth_triangle { <-0.0943997, 4.83854, -1.7738>, <-0.297567, -0.803633, -0.515392>, <-0.155786, 4.86427, -1.76608>, <-0.507029, -0.697027, -0.507025>, <-0.110158, 4.86427, -1.80109> , <-0.358527, -0.697027, -0.620976> }
	smooth_triangle { <-0.155786, 4.86427, -1.76608>, <-0.507029, -0.697027, -0.507025>, <-0.124024, 4.90029, -1.82511>, <-0.415158, -0.557309, -0.719062>, <-0.110158, 4.86427, -1.80109> , <-0.358527, -0.697027, -0.620976> }
	smooth_triangle { <-0.124024, 4.90029, -1.82511>, <-0.415158, -0.557309, -0.719062>, <-0.155786, 4.86427, -1.76608>, <-0.507029, -0.697027, -0.507025>, <-0.175398, 4.90029, -1.78569> , <-0.587115, -0.557312, -0.587111> }
	smooth_triangle { <-0.175398, 4.90029, -1.78569>, <-0.587115, -0.557312, -0.587111>, <-0.134971, 4.938, -1.84407>, <-0.458517, -0.398847, -0.794156>, <-0.124024, 4.90029, -1.82511> , <-0.415158, -0.557309, -0.719062> }
	smooth_triangle { <-0.134971, 4.938, -1.84407>, <-0.458517, -0.398847, -0.794156>, <-0.175398, 4.90029, -1.78569>, <-0.587115, -0.557312, -0.587111>, <-0.190877, 4.938, -1.80117> , <-0.64843, -0.398847, -0.648429> }
	smooth_triangle { <-0.190877, 4.938, -1.80117>, <-0.64843, -0.398847, -0.648429>, <-0.144541, 5.00115, -1.86064>, <-0.492653, -0.170886, -0.853282>, <-0.134971, 4.938, -1.84407> , <-0.458517, -0.398847, -0.794156> }
	smooth_triangle { <-0.144541, 5.00115, -1.86064>, <-0.492653, -0.170886, -0.853282>, <-0.190877, 4.938, -1.80117>, <-0.64843, -0.398847, -0.648429>, <-0.204411, 5.00115, -1.8147> , <-0.696705, -0.170886, -0.696706> }
	smooth_triangle { <-0.204411, 5.00115, -1.8147>, <-0.696705, -0.170886, -0.696706>, <-0.146716, 5.08966, -1.86441>, <-0.49999, 0.00603642, -0.86601>, <-0.144541, 5.00115, -1.86064> , <-0.492653, -0.170886, -0.853282> }
	smooth_triangle { <-0.146716, 5.08966, -1.86441>, <-0.49999, 0.00603642, -0.86601>, <-0.204411, 5.00115, -1.8147>, <-0.696705, -0.170886, -0.696706>, <-0.207488, 5.08966, -1.81778> , <-0.707093, 0.00603628, -0.707094> }
	smooth_triangle { <-0.146716, 5.08966, -1.86441>, <-0.49999, 0.00603643, -0.86601>, <-0.20303, 5.19258, -1.81332>, <-0.70462, 0.0838011, -0.70462>, <-0.143564, 5.19258, -1.85895> , <-0.498236, 0.083801, -0.862982> }
	smooth_triangle { <-0.20303, 5.19258, -1.81332>, <-0.70462, 0.0838011, -0.70462>, <-0.146716, 5.08966, -1.86441>, <-0.49999, 0.00603643, -0.86601>, <-0.207488, 5.08966, -1.81778> , <-0.707093, 0.00603628, -0.707094> }
	smooth_triangle { <-0.143564, 5.19258, -1.85895>, <-0.498236, 0.083801, -0.862982>, <-0.195008, 5.29859, -1.8053>, <-0.702725, 0.111149, -0.702725>, <-0.137891, 5.29859, -1.84912> , <-0.496899, 0.111148, -0.860661> }
	smooth_triangle { <-0.195008, 5.29859, -1.8053>, <-0.702725, 0.111149, -0.702725>, <-0.143564, 5.19258, -1.85895>, <-0.498236, 0.083801, -0.862982>, <-0.20303, 5.19258, -1.81332> , <-0.70462, 0.0838011, -0.70462> }
	smooth_triangle { <-0.137891, 5.29859, -1.84912>, <-0.496899, 0.111148, -0.860661>, <-0.189659, 5.36342, -1.79995>, <-0.702343, 0.115878, -0.702343>, <-0.134109, 5.36342, -1.84257> , <-0.496626, 0.115877, -0.860195> }
	smooth_triangle { <-0.189659, 5.36342, -1.79995>, <-0.702343, 0.115878, -0.702343>, <-0.137891, 5.29859, -1.84912>, <-0.496899, 0.111148, -0.860661>, <-0.195008, 5.29859, -1.8053> , <-0.702725, 0.111149, -0.702725> }
	smooth_triangle { <-0.134109, 5.36342, -1.84257>, <-0.495749, 0.130126, -0.858662>, <-0.181636, 5.44988, -1.79193>, <-0.699776, 0.143619, -0.699776>, <-0.128436, 5.44988, -1.83275> , <-0.494821, 0.143622, -0.857044> }
	smooth_triangle { <-0.181636, 5.44988, -1.79193>, <-0.699776, 0.143619, -0.699776>, <-0.134109, 5.36342, -1.84257>, <-0.495749, 0.130126, -0.858662>, <-0.189659, 5.36342, -1.79995> , <-0.701094, 0.130126, -0.701095> }
	smooth_triangle { <-0.128436, 5.44988, -1.83275>, <-0.494821, 0.143622, -0.857044>, <-0.172723, 5.52912, -1.78301>, <-0.69667, 0.171156, -0.696675>, <-0.122133, 5.52912, -1.82183> , <-0.492627, 0.171149, -0.853245> }
	smooth_triangle { <-0.172723, 5.52912, -1.78301>, <-0.69667, 0.171156, -0.696675>, <-0.128436, 5.44988, -1.83275>, <-0.494821, 0.143622, -0.857044>, <-0.181636, 5.44988, -1.79193> , <-0.699776, 0.143619, -0.699776> }
	smooth_triangle { <-0.122133, 5.52912, -1.82183>, <-0.492627, 0.171149, -0.853245>, <-0.167374, 5.56926, -1.77766>, <-0.694871, 0.185191, -0.69488>, <-0.118352, 5.56926, -1.81528> , <-0.491352, 0.185173, -0.851049> }
	smooth_triangle { <-0.167374, 5.56926, -1.77766>, <-0.694871, 0.185191, -0.69488>, <-0.122133, 5.52912, -1.82183>, <-0.492627, 0.171149, -0.853245>, <-0.172723, 5.52912, -1.78301> , <-0.69667, 0.171156, -0.696675> }
	smooth_triangle { <-0.1152, 5.56926, -1.80982>, <0.0962578, 0.981293, 0.166727>, <-0.167374, 5.56926, -1.77766>, <0, 1, 0>, <-0.162918, 5.56926, -1.77321> , <0.136131, 0.981294, 0.136129> }
	smooth_triangle { <-0.167374, 5.56926, -1.77766>, <0, 1, 0>, <-0.1152, 5.56926, -1.80982>, <0.0962578, 0.981293, 0.166727>, <-0.118352, 5.56926, -1.81528> , <0, 1, 0> }
	smooth_triangle { <-0.112679, 5.5672, -1.80546>, <0.189027, 0.925781, 0.327411>, <-0.162918, 5.56926, -1.77321>, <0.136131, 0.981294, 0.136129>, <-0.159353, 5.5672, -1.76964> , <0.267329, 0.925782, 0.267324> }
	smooth_triangle { <-0.162918, 5.56926, -1.77321>, <0.136131, 0.981294, 0.136129>, <-0.112679, 5.5672, -1.80546>, <0.189027, 0.925781, 0.327411>, <-0.1152, 5.56926, -1.80982> , <0.0962578, 0.981293, 0.166727> }
	smooth_triangle { <-0.112679, 5.5672, -1.80546>, <0.495416, 0.134946, 0.85811>, <-0.158461, 5.55794, -1.76875>, <0.700643, 0.134913, 0.700642>, <-0.112048, 5.55794, -1.80436> , <0.495416, 0.134946, 0.85811> }
	smooth_triangle { <-0.158461, 5.55794, -1.76875>, <0.700643, 0.134913, 0.700642>, <-0.112679, 5.5672, -1.80546>, <0.495416, 0.134946, 0.85811>, <-0.159353, 5.5672, -1.76964> , <0.700643, 0.134913, 0.700642> }
	smooth_triangle { <-0.0630807, 4.78708, -1.67337>, <-0.100996, -0.989753, -0.100941>, <-0.0007103, 4.77442, -1.61152>, <-0.0713774, -0.989754, -0.12366>, <-0.00100452, 4.77442, -1.61129> , <-0.100996, -0.989753, -0.100941> }
	smooth_triangle { <-0.0007103, 4.77442, -1.61152>, <-0.0713774, -0.989754, -0.12366>, <-0.0630807, 4.78708, -1.67337>, <-0.100996, -0.989753, -0.100941>, <-0.0446049, 4.78708, -1.68755> , <-0.0713774, -0.989754, -0.12366> }
	smooth_triangle { <-0.254674, 4.21572, -1.75733>, <0.0248125, -0.99959, 0.0143231>, <-0.00129573, 4.22409, -1.61159>, <0.0202575, -0.99959, 0.0202594>, <-0.00158693, 4.22409, -1.61121> , <0.0248125, -0.99959, 0.0143231> }
	smooth_triangle { <-0.00129573, 4.22409, -1.61159>, <0.0202575, -0.99959, 0.0202594>, <-0.254674, 4.21572, -1.75733>, <0.0248125, -0.99959, 0.0143231>, <-0.207941, 4.21572, -1.81823> , <0.0202575, -0.99959, 0.0202594> }
	smooth_triangle { <-0.207941, 4.21572, -1.81823>, <-0.704566, 0.0846999, -0.704565>, <-0.253719, 4.2287, -1.75677>, <-0.862918, 0.0846682, -0.498201>, <-0.20716, 4.2287, -1.81745> , <-0.704566, 0.0846999, -0.704565> }
	smooth_triangle { <-0.253719, 4.2287, -1.75677>, <-0.862918, 0.0846682, -0.498201>, <-0.207941, 4.21572, -1.81823>, <-0.704566, 0.0846999, -0.704565>, <-0.254674, 4.21572, -1.75733> , <-0.862918, 0.0846682, -0.498201> }
	smooth_triangle { <-0.180559, 4.24779, -1.79085>, <-0.249745, 0.935551, -0.249745>, <-0.253719, 4.2287, -1.75677>, <-0.391881, 0.891762, -0.226252>, <-0.221138, 4.24779, -1.73796> , <-0.305874, 0.935551, -0.176595> }
	smooth_triangle { <-0.253719, 4.2287, -1.75677>, <-0.391881, 0.891762, -0.226252>, <-0.180559, 4.24779, -1.79085>, <-0.249745, 0.935551, -0.249745>, <-0.20716, 4.2287, -1.81745> , <-0.319971, 0.89176, -0.319972> }
	smooth_triangle { <-0.128241, 4.26688, -1.73853>, <-0.151481, 0.976784, -0.15148>, <-0.221138, 4.24779, -1.73796>, <-0.305874, 0.935551, -0.176595>, <-0.157063, 4.26688, -1.70097> , <-0.185525, 0.976784, -0.107113> }
	smooth_triangle { <-0.221138, 4.24779, -1.73796>, <-0.305874, 0.935551, -0.176595>, <-0.128241, 4.26688, -1.73853>, <-0.151481, 0.976784, -0.15148>, <-0.180559, 4.24779, -1.79085> , <-0.249745, 0.935551, -0.249745> }
	smooth_triangle { <-0.0909986, 4.27643, -1.70129>, <-0.114194, 0.986874, -0.114194>, <-0.157063, 4.26688, -1.70097>, <-0.185525, 0.976784, -0.107113>, <-0.11145, 4.27643, -1.67464> , <-0.139858, 0.986874, -0.080747> }
	smooth_triangle { <-0.157063, 4.26688, -1.70097>, <-0.185525, 0.976784, -0.107113>, <-0.0909986, 4.27643, -1.70129>, <-0.114194, 0.986874, -0.114194>, <-0.128241, 4.26688, -1.73853> , <-0.151481, 0.976784, -0.15148> }
	smooth_triangle { <-0.0499523, 4.28491, -1.66024>, <-0.102259, 0.989488, -0.102259>, <-0.11145, 4.27643, -1.67464>, <-0.139858, 0.986874, -0.080747>, <-0.0611789, 4.28491, -1.64561> , <-0.125242, 0.989488, -0.0723073> }
	smooth_triangle { <-0.11145, 4.27643, -1.67464>, <-0.139858, 0.986874, -0.080747>, <-0.0499523, 4.28491, -1.66024>, <-0.102259, 0.989488, -0.102259>, <-0.0909986, 4.27643, -1.70129> , <-0.114194, 0.986874, -0.114194> }
	smooth_triangle { <-0.0499523, 4.28491, -1.66024>, <-0.573077, 0.585796, -0.573084>, <-0.0545396, 4.29552, -1.64178>, <-0.823842, 0.308301, -0.475641>, <-0.0445314, 4.29552, -1.65482> , <-0.672663, 0.3083, -0.672663> }
	smooth_triangle { <-0.0545396, 4.29552, -1.64178>, <-0.823842, 0.308301, -0.475641>, <-0.0499523, 4.28491, -1.66024>, <-0.573077, 0.585796, -0.573084>, <-0.0611789, 4.28491, -1.64561> , <-0.701876, 0.585799, -0.405227> }
	smooth_triangle { <-0.0445314, 4.29552, -1.65482>, <-0.672663, 0.3083, -0.672663>, <-0.0545396, 4.30188, -1.64178>, <-0.866028, 0, -0.499995>, <-0.0445314, 4.30188, -1.65482> , <-0.70711, 0, -0.707104> }
	smooth_triangle { <-0.0545396, 4.30188, -1.64178>, <-0.866028, 0, -0.499995>, <-0.0445314, 4.29552, -1.65482>, <-0.672663, 0.3083, -0.672663>, <-0.0545396, 4.29552, -1.64178> , <-0.823842, 0.308301, -0.475641> }
	smooth_triangle { <-0.0445314, 4.30188, -1.65482>, <-0.70711, 0, -0.707104>, <-0.0545396, 4.30931, -1.64178>, <-0.819286, 0.324088, -0.473009>, <-0.0445314, 4.30931, -1.65482> , <-0.668945, 0.324092, -0.668938> }
	smooth_triangle { <-0.0545396, 4.30931, -1.64178>, <-0.819286, 0.324088, -0.473009>, <-0.0445314, 4.30188, -1.65482>, <-0.70711, 0, -0.707104>, <-0.0545396, 4.30188, -1.64178> , <-0.866028, 0, -0.499995> }
	smooth_triangle { <-0.0445314, 4.30931, -1.65482>, <-0.668945, 0.324092, -0.668938>, <-0.0488483, 4.31779, -1.63849>, <-0.529966, 0.790896, -0.305974>, <-0.0398845, 4.31779, -1.65017> , <-0.432715, 0.790897, -0.432713> }
	smooth_triangle { <-0.0488483, 4.31779, -1.63849>, <-0.529966, 0.790896, -0.305974>, <-0.0445314, 4.30931, -1.65482>, <-0.668945, 0.324092, -0.668938>, <-0.0545396, 4.30931, -1.64178> , <-0.819286, 0.324088, -0.473009> }
	smooth_triangle { <-0.0329144, 4.32203, -1.6432>, <-0.448181, 0.773481, -0.448176>, <-0.0488483, 4.31779, -1.63849>, <-0.529966, 0.790896, -0.305974>, <-0.0403117, 4.32203, -1.63356> , <-0.548908, 0.773478, -0.31691> }
	smooth_triangle { <-0.0488483, 4.31779, -1.63849>, <-0.529966, 0.790896, -0.305974>, <-0.0329144, 4.32203, -1.6432>, <-0.448181, 0.773481, -0.448176>, <-0.0398845, 4.31779, -1.65017> , <-0.432715, 0.790897, -0.432713> }
	smooth_triangle { <-0.0329144, 4.32203, -1.6432>, <-0.448181, 0.773481, -0.448176>, <-0.0365177, 4.3284, -1.63137>, <-0.792716, 0.402661, -0.457675>, <-0.0298165, 4.3284, -1.64011> , <-0.647252, 0.402665, -0.647245> }
	smooth_triangle { <-0.0365177, 4.3284, -1.63137>, <-0.792716, 0.402661, -0.457675>, <-0.0329144, 4.32203, -1.6432>, <-0.448181, 0.773481, -0.448176>, <-0.0403117, 4.32203, -1.63356> , <-0.548908, 0.773478, -0.31691> }
	smooth_triangle { <-0.0298165, 4.3284, -1.64011>, <-0.647252, 0.402665, -0.647245>, <-0.0346206, 4.33794, -1.63028>, <-0.861233, 0.105027, -0.497239>, <-0.0282676, 4.33794, -1.63856> , <-0.703197, 0.105027, -0.703195> }
	smooth_triangle { <-0.0346206, 4.33794, -1.63028>, <-0.861233, 0.105027, -0.497239>, <-0.0298165, 4.3284, -1.64011>, <-0.647252, 0.402665, -0.647245>, <-0.0365177, 4.3284, -1.63137> , <-0.792716, 0.402661, -0.457675> }
	smooth_triangle { <-0.0282676, 4.33794, -1.63856>, <-0.703197, 0.105027, -0.703195>, <-0.0393632, 4.69858, -1.63302>, <-0.86304, -0.0829335, -0.498282>, <-0.0321399, 4.69858, -1.64243> , <-0.704671, -0.0829369, -0.70467> }
	smooth_triangle { <-0.0393632, 4.69858, -1.63302>, <-0.86304, -0.0829335, -0.498282>, <-0.0282676, 4.33794, -1.63856>, <-0.703197, 0.105027, -0.703195>, <-0.0346206, 4.33794, -1.63028> , <-0.861233, 0.105027, -0.497239> }
	smooth_triangle { <-0.0321399, 4.69858, -1.64243>, <-0.704671, -0.0829369, -0.704671>, <-0.0412602, 4.71298, -1.63411>, <-0.846093, -0.213315, -0.488491>, <-0.0336888, 4.71298, -1.64398> , <-0.690829, -0.213317, -0.690833> }
	smooth_triangle { <-0.0412602, 4.71298, -1.63411>, <-0.846093, -0.213315, -0.488491>, <-0.0321399, 4.69858, -1.64243>, <-0.704671, -0.0829369, -0.704671>, <-0.0393632, 4.69858, -1.63302> , <-0.86304, -0.0829335, -0.498282> }
	smooth_triangle { <-0.0336888, 4.71298, -1.64398>, <-0.690829, -0.213317, -0.690833>, <-0.0478998, 4.73974, -1.63794>, <-0.822935, -0.311517, -0.475117>, <-0.0391101, 4.73974, -1.6494> , <-0.671923, -0.311516, -0.671921> }
	smooth_triangle { <-0.0478998, 4.73974, -1.63794>, <-0.822935, -0.311517, -0.475117>, <-0.0336888, 4.71298, -1.64398>, <-0.690829, -0.213317, -0.690833>, <-0.0412602, 4.71298, -1.63411> , <-0.846093, -0.213315, -0.488491> }
	smooth_triangle { <-0.0391101, 4.73974, -1.6494>, <-0.671923, -0.311516, -0.671921>, <-0.055488, 4.76341, -1.64233>, <-0.72183, -0.552524, -0.416747>, <-0.0453058, 4.76341, -1.6556> , <-0.589375, -0.552523, -0.589369> }
	smooth_triangle { <-0.055488, 4.76341, -1.64233>, <-0.72183, -0.552524, -0.416747>, <-0.0391101, 4.73974, -1.6494>, <-0.671923, -0.311516, -0.671921>, <-0.0478998, 4.73974, -1.63794> , <-0.822935, -0.311517, -0.475117> }
	smooth_triangle { <-0.0772578, 4.78708, -1.65489>, <-0.45517, -0.850741, -0.262794>, <-0.0453058, 4.76341, -1.6556>, <-0.589375, -0.552523, -0.589369>, <-0.055488, 4.76341, -1.64233> , <-0.72183, -0.552524, -0.416747> }
	smooth_triangle { <-0.0453058, 4.76341, -1.6556>, <-0.589375, -0.552523, -0.589369>, <-0.0772578, 4.78708, -1.65489>, <-0.45517, -0.850741, -0.262794>, <-0.0630807, 4.78708, -1.67337> , <-0.371647, -0.85074, -0.371644> }
	smooth_triangle { <-0.120927, 4.80561, -1.68011>, <-0.393012, -0.891097, -0.226909>, <-0.0630807, 4.78708, -1.67337>, <-0.371647, -0.85074, -0.371644>, <-0.0772578, 4.78708, -1.65489> , <-0.45517, -0.850741, -0.262794> }
	smooth_triangle { <-0.0630807, 4.78708, -1.67337>, <-0.371647, -0.85074, -0.371644>, <-0.120927, 4.80561, -1.68011>, <-0.393012, -0.891097, -0.226909>, <-0.0987367, 4.80561, -1.70903> , <-0.320895, -0.891096, -0.320895> }
	smooth_triangle { <-0.163505, 4.83854, -1.70469>, <-0.515395, -0.80363, -0.297569>, <-0.0987367, 4.80561, -1.70903>, <-0.320895, -0.891096, -0.320895>, <-0.120927, 4.80561, -1.68011> , <-0.393012, -0.891097, -0.226909> }
	smooth_triangle { <-0.0987367, 4.80561, -1.70903>, <-0.320895, -0.891096, -0.320895>, <-0.163505, 4.83854, -1.70469>, <-0.515395, -0.80363, -0.297569>, <-0.133501, 4.83854, -1.74379> , <-0.420819, -0.803631, -0.420819> }
	smooth_triangle { <-0.190798, 4.86427, -1.72045>, <-0.620979, -0.697025, -0.358528>, <-0.133501, 4.83854, -1.74379>, <-0.420819, -0.803631, -0.420819>, <-0.163505, 4.83854, -1.70469> , <-0.515395, -0.80363, -0.297569> }
	smooth_triangle { <-0.133501, 4.83854, -1.74379>, <-0.420819, -0.803631, -0.420819>, <-0.190798, 4.86427, -1.72045>, <-0.620979, -0.697025, -0.358528>, <-0.155786, 4.86427, -1.76608> , <-0.507029, -0.697027, -0.507025> }
	smooth_triangle { <-0.155786, 4.86427, -1.76608>, <-0.507029, -0.697027, -0.507025>, <-0.214816, 4.90029, -1.73431>, <-0.719062, -0.557314, -0.415152>, <-0.175398, 4.90029, -1.78569> , <-0.587115, -0.557311, -0.587111> }
	smooth_triangle { <-0.214816, 4.90029, -1.73431>, <-0.719062, -0.557314, -0.415152>, <-0.155786, 4.86427, -1.76608>, <-0.507029, -0.697027, -0.507025>, <-0.190798, 4.86427, -1.72045> , <-0.620979, -0.697025, -0.358528> }
	smooth_triangle { <-0.175398, 4.90029, -1.78569>, <-0.587115, -0.557311, -0.587111>, <-0.233776, 4.938, -1.74526>, <-0.794158, -0.398848, -0.458512>, <-0.190877, 4.938, -1.80117> , <-0.64843, -0.398847, -0.648429> }
	smooth_triangle { <-0.233776, 4.938, -1.74526>, <-0.794158, -0.398848, -0.458512>, <-0.175398, 4.90029, -1.78569>, <-0.587115, -0.557311, -0.587111>, <-0.214816, 4.90029, -1.73431> , <-0.719062, -0.557314, -0.415152> }
	smooth_triangle { <-0.190877, 4.938, -1.80117>, <-0.64843, -0.398847, -0.648429>, <-0.250353, 5.00115, -1.75483>, <-0.853285, -0.170877, -0.492652>, <-0.204411, 5.00115, -1.8147> , <-0.696705, -0.170886, -0.696706> }
	smooth_triangle { <-0.250353, 5.00115, -1.75483>, <-0.853285, -0.170877, -0.492652>, <-0.190877, 4.938, -1.80117>, <-0.64843, -0.398847, -0.648429>, <-0.233776, 4.938, -1.74526> , <-0.794158, -0.398848, -0.458512> }
	smooth_triangle { <-0.204411, 5.00115, -1.8147>, <-0.696705, -0.170886, -0.696706>, <-0.254119, 5.08966, -1.75701>, <-0.866012, 0.00603904, -0.499988>, <-0.207488, 5.08966, -1.81778> , <-0.707093, 0.00603628, -0.707094> }
	smooth_triangle { <-0.254119, 5.08966, -1.75701>, <-0.866012, 0.00603904, -0.499988>, <-0.204411, 5.00115, -1.8147>, <-0.696705, -0.170886, -0.696706>, <-0.250353, 5.00115, -1.75483> , <-0.853285, -0.170877, -0.492652> }
	smooth_triangle { <-0.207488, 5.08966, -1.81778>, <-0.707093, 0.00603628, -0.707094>, <-0.24866, 5.19258, -1.75385>, <-0.862983, 0.0837985, -0.498236>, <-0.20303, 5.19258, -1.81332> , <-0.70462, 0.0838011, -0.70462> }
	smooth_triangle { <-0.24866, 5.19258, -1.75385>, <-0.862983, 0.0837985, -0.498236>, <-0.207488, 5.08966, -1.81778>, <-0.707093, 0.00603628, -0.707094>, <-0.254119, 5.08966, -1.75701> , <-0.866012, 0.00603904, -0.499988> }
	smooth_triangle { <-0.20303, 5.19258, -1.81332>, <-0.70462, 0.0838011, -0.70462>, <-0.238834, 5.29859, -1.74818>, <-0.860661, 0.111147, -0.496899>, <-0.195008, 5.29859, -1.8053> , <-0.702725, 0.111149, -0.702725> }
	smooth_triangle { <-0.238834, 5.29859, -1.74818>, <-0.860661, 0.111147, -0.496899>, <-0.20303, 5.19258, -1.81332>, <-0.70462, 0.0838011, -0.70462>, <-0.24866, 5.19258, -1.75385> , <-0.862983, 0.0837985, -0.498236> }
	smooth_triangle { <-0.195008, 5.29859, -1.8053>, <-0.702725, 0.111149, -0.702725>, <-0.232284, 5.36342, -1.7444>, <-0.860195, 0.115872, -0.496628>, <-0.189659, 5.36342, -1.79995> , <-0.702343, 0.115878, -0.702343> }
	smooth_triangle { <-0.232284, 5.36342, -1.7444>, <-0.860195, 0.115872, -0.496628>, <-0.195008, 5.29859, -1.8053>, <-0.702725, 0.111149, -0.702725>, <-0.238834, 5.29859, -1.74818> , <-0.860661, 0.111147, -0.496899> }
	smooth_triangle { <-0.189659, 5.36342, -1.79995>, <-0.701094, 0.130126, -0.701095>, <-0.222458, 5.44988, -1.73873>, <-0.857045, 0.14362, -0.494821>, <-0.181636, 5.44988, -1.79193> , <-0.699776, 0.143619, -0.699776> }
	smooth_triangle { <-0.222458, 5.44988, -1.73873>, <-0.857045, 0.14362, -0.494821>, <-0.189659, 5.36342, -1.79995>, <-0.701094, 0.130126, -0.701095>, <-0.232284, 5.36342, -1.7444> , <-0.858663, 0.130117, -0.495748> }
	smooth_triangle { <-0.181636, 5.44988, -1.79193>, <-0.699776, 0.143619, -0.699776>, <-0.211542, 5.52912, -1.73242>, <-0.853244, 0.171155, -0.492626>, <-0.172723, 5.52912, -1.78301> , <-0.69667, 0.171156, -0.696675> }
	smooth_triangle { <-0.211542, 5.52912, -1.73242>, <-0.853244, 0.171155, -0.492626>, <-0.181636, 5.44988, -1.79193>, <-0.699776, 0.143619, -0.699776>, <-0.222458, 5.44988, -1.73873> , <-0.857045, 0.14362, -0.494821> }
	smooth_triangle { <-0.172723, 5.52912, -1.78301>, <-0.69667, 0.171156, -0.696675>, <-0.204992, 5.56926, -1.72864>, <-0.851048, 0.185181, -0.49135>, <-0.167374, 5.56926, -1.77766> , <-0.694871, 0.185191, -0.69488> }
	smooth_triangle { <-0.204992, 5.56926, -1.72864>, <-0.851048, 0.185181, -0.49135>, <-0.172723, 5.52912, -1.78301>, <-0.69667, 0.171156, -0.696675>, <-0.211542, 5.52912, -1.73242> , <-0.853244, 0.171155, -0.492626> }
	smooth_triangle { <-0.162918, 5.56926, -1.77321>, <0.136131, 0.981294, 0.136129>, <-0.204992, 5.56926, -1.72864>, <0, 1, 0>, <-0.199532, 5.56926, -1.72549> , <0.166704, 0.981298, 0.0962514> }
	smooth_triangle { <-0.204992, 5.56926, -1.72864>, <0, 1, 0>, <-0.162918, 5.56926, -1.77321>, <0.136131, 0.981294, 0.136129>, <-0.167374, 5.56926, -1.77766> , <0, 1, 0> }
	smooth_triangle { <-0.159353, 5.5672, -1.76964>, <0.267329, 0.925782, 0.267324>, <-0.199532, 5.56926, -1.72549>, <0.166704, 0.981298, 0.0962514>, <-0.195166, 5.5672, -1.72297> , <0.327366, 0.925799, 0.189015> }
	smooth_triangle { <-0.199532, 5.56926, -1.72549>, <0.166704, 0.981298, 0.0962514>, <-0.159353, 5.5672, -1.76964>, <0.267329, 0.925782, 0.267324>, <-0.162918, 5.56926, -1.77321> , <0.136131, 0.981294, 0.136129> }
	smooth_triangle { <-0.194073, 5.55794, -1.72234>, <0.858113, 0.13493, 0.495415>, <-0.159353, 5.5672, -1.76964>, <0.700643, 0.134913, 0.700642>, <-0.195166, 5.5672, -1.72297> , <0.858113, 0.13493, 0.495415> }
	smooth_triangle { <-0.159353, 5.5672, -1.76964>, <0.700643, 0.134913, 0.700642>, <-0.194073, 5.55794, -1.72234>, <0.858113, 0.13493, 0.495415>, <-0.158461, 5.55794, -1.76875> , <0.700643, 0.134913, 0.700642> }
	smooth_triangle { <-0.0772578, 4.78708, -1.65489>, <-0.123655, -0.989752, -0.0714148>, <-0.00100452, 4.77442, -1.61129>, <-0.100996, -0.989753, -0.100941>, <-0.00123028, 4.77442, -1.611> , <-0.123655, -0.989752, -0.0714148> }
	smooth_triangle { <-0.00100452, 4.77442, -1.61129>, <-0.100996, -0.989753, -0.100941>, <-0.0772578, 4.78708, -1.65489>, <-0.123655, -0.989752, -0.0714148>, <-0.0630807, 4.78708, -1.67337> , <-0.100996, -0.989753, -0.100941> }
	smooth_triangle { <-0.284052, 4.21572, -1.6864>, <0.027674, -0.99959, 0.0074148>, <-0.00158693, 4.22409, -1.61121>, <0.0248125, -0.99959, 0.0143231>, <-0.00176999, 4.22409, -1.61076> , <0.027674, -0.99959, 0.0074148> }
	smooth_triangle { <-0.00158693, 4.22409, -1.61121>, <0.0248125, -0.99959, 0.0143231>, <-0.284052, 4.21572, -1.6864>, <0.027674, -0.99959, 0.0074148>, <-0.254674, 4.21572, -1.75733> , <0.0248125, -0.99959, 0.0143231> }
	smooth_triangle { <-0.254674, 4.21572, -1.75733>, <-0.862918, 0.0846682, -0.498201>, <-0.282986, 4.2287, -1.68612>, <-0.962453, 0.0847032, -0.257894>, <-0.253719, 4.2287, -1.75677> , <-0.862918, 0.0846682, -0.498201> }
	smooth_triangle { <-0.282986, 4.2287, -1.68612>, <-0.962453, 0.0847032, -0.257894>, <-0.254674, 4.21572, -1.75733>, <-0.862918, 0.0846682, -0.498201>, <-0.284052, 4.21572, -1.6864> , <-0.962453, 0.0847032, -0.257894> }
	smooth_triangle { <-0.221138, 4.24779, -1.73796>, <-0.305874, 0.935551, -0.176595>, <-0.282986, 4.2287, -1.68612>, <-0.437092, 0.891759, -0.117118>, <-0.246648, 4.24779, -1.67638> , <-0.341159, 0.93555, -0.0914136> }
	smooth_triangle { <-0.282986, 4.2287, -1.68612>, <-0.437092, 0.891759, -0.117118>, <-0.221138, 4.24779, -1.73796>, <-0.305874, 0.935551, -0.176595>, <-0.253719, 4.2287, -1.75677> , <-0.391881, 0.891762, -0.226252> }
	smooth_triangle { <-0.157063, 4.26688, -1.70097>, <-0.185525, 0.976784, -0.107113>, <-0.246648, 4.24779, -1.67638>, <-0.341159, 0.93555, -0.0914136>, <-0.175181, 4.26688, -1.65723> , <-0.206925, 0.976784, -0.0554457> }
	smooth_triangle { <-0.246648, 4.24779, -1.67638>, <-0.341159, 0.93555, -0.0914136>, <-0.157063, 4.26688, -1.70097>, <-0.185525, 0.976784, -0.107113>, <-0.221138, 4.24779, -1.73796> , <-0.305874, 0.935551, -0.176595> }
	smooth_triangle { <-0.11145, 4.27643, -1.67464>, <-0.139858, 0.986874, -0.080747>, <-0.175181, 4.26688, -1.65723>, <-0.206925, 0.976784, -0.0554457>, <-0.124306, 4.27643, -1.6436> , <-0.155992, 0.986874, -0.0417968> }
	smooth_triangle { <-0.175181, 4.26688, -1.65723>, <-0.206925, 0.976784, -0.0554457>, <-0.11145, 4.27643, -1.67464>, <-0.139858, 0.986874, -0.080747>, <-0.157063, 4.26688, -1.70097> , <-0.185525, 0.976784, -0.107113> }
	smooth_triangle { <-0.0611789, 4.28491, -1.64561>, <-0.125242, 0.989488, -0.0723073>, <-0.124306, 4.27643, -1.6436>, <-0.155992, 0.986874, -0.0417968>, <-0.0682361, 4.28491, -1.62857> , <-0.139689, 0.989488, -0.0374287> }
	smooth_triangle { <-0.124306, 4.27643, -1.6436>, <-0.155992, 0.986874, -0.0417968>, <-0.0611789, 4.28491, -1.64561>, <-0.125242, 0.989488, -0.0723073>, <-0.11145, 4.27643, -1.67464> , <-0.139858, 0.986874, -0.080747> }
	smooth_triangle { <-0.0611789, 4.28491, -1.64561>, <-0.701876, 0.585799, -0.405227>, <-0.0608309, 4.29552, -1.62659>, <-0.918876, 0.308297, -0.24621>, <-0.0545396, 4.29552, -1.64178> , <-0.823842, 0.308301, -0.475641> }
	smooth_triangle { <-0.0608309, 4.29552, -1.62659>, <-0.918876, 0.308297, -0.24621>, <-0.0611789, 4.28491, -1.64561>, <-0.701876, 0.585799, -0.405227>, <-0.0682361, 4.28491, -1.62857> , <-0.782847, 0.585792, -0.209759> }
	smooth_triangle { <-0.0545396, 4.29552, -1.64178>, <-0.823842, 0.308301, -0.475641>, <-0.0608309, 4.30188, -1.62659>, <-0.965926, 0, -0.258818>, <-0.0545396, 4.30188, -1.64178> , <-0.866028, 0, -0.499995> }
	smooth_triangle { <-0.0608309, 4.30188, -1.62659>, <-0.965926, 0, -0.258818>, <-0.0545396, 4.29552, -1.64178>, <-0.823842, 0.308301, -0.475641>, <-0.0608309, 4.29552, -1.62659> , <-0.918876, 0.308297, -0.24621> }
	smooth_triangle { <-0.0545396, 4.30188, -1.64178>, <-0.866028, 0, -0.499995>, <-0.0608309, 4.30931, -1.62659>, <-0.91379, 0.324092, -0.244849>, <-0.0545396, 4.30931, -1.64178> , <-0.819286, 0.324088, -0.473009> }
	smooth_triangle { <-0.0608309, 4.30931, -1.62659>, <-0.91379, 0.324092, -0.244849>, <-0.0545396, 4.30188, -1.64178>, <-0.866028, 0, -0.499995>, <-0.0608309, 4.30188, -1.62659> , <-0.965926, 0, -0.258818> }
	smooth_triangle { <-0.0545396, 4.30931, -1.64178>, <-0.819286, 0.324088, -0.473009>, <-0.0544832, 4.31779, -1.62489>, <-0.591099, 0.790896, -0.158383>, <-0.0488483, 4.31779, -1.63849> , <-0.529966, 0.790896, -0.305974> }
	smooth_triangle { <-0.0544832, 4.31779, -1.62489>, <-0.591099, 0.790896, -0.158383>, <-0.0545396, 4.30931, -1.64178>, <-0.819286, 0.324088, -0.473009>, <-0.0608309, 4.30931, -1.62659> , <-0.91379, 0.324092, -0.244849> }
	smooth_triangle { <-0.0403117, 4.32203, -1.63356>, <-0.548908, 0.773478, -0.31691>, <-0.0544832, 4.31779, -1.62489>, <-0.591099, 0.790896, -0.158383>, <-0.0449618, 4.32203, -1.62234> , <-0.612223, 0.773481, -0.164045> }
	smooth_triangle { <-0.0544832, 4.31779, -1.62489>, <-0.591099, 0.790896, -0.158383>, <-0.0403117, 4.32203, -1.63356>, <-0.548908, 0.773478, -0.31691>, <-0.0488483, 4.31779, -1.63849> , <-0.529966, 0.790896, -0.305974> }
	smooth_triangle { <-0.0403117, 4.32203, -1.63356>, <-0.548908, 0.773478, -0.31691>, <-0.0407301, 4.3284, -1.6212>, <-0.884159, 0.402663, -0.236908>, <-0.0365177, 4.3284, -1.63137> , <-0.792716, 0.402661, -0.457675> }
	smooth_triangle { <-0.0407301, 4.3284, -1.6212>, <-0.884159, 0.402663, -0.236908>, <-0.0403117, 4.32203, -1.63356>, <-0.548908, 0.773478, -0.31691>, <-0.0449618, 4.32203, -1.62234> , <-0.612223, 0.773481, -0.164045> }
	smooth_triangle { <-0.0365177, 4.3284, -1.63137>, <-0.792716, 0.402661, -0.457675>, <-0.0386144, 4.33794, -1.62064>, <-0.960585, 0.105023, -0.257385>, <-0.0346206, 4.33794, -1.63028> , <-0.861233, 0.105027, -0.497239> }
	smooth_triangle { <-0.0386144, 4.33794, -1.62064>, <-0.960585, 0.105023, -0.257385>, <-0.0365177, 4.3284, -1.63137>, <-0.792716, 0.402661, -0.457675>, <-0.0407301, 4.3284, -1.6212> , <-0.884159, 0.402663, -0.236908> }
	smooth_triangle { <-0.0346206, 4.33794, -1.63028>, <-0.861233, 0.105027, -0.497239>, <-0.043904, 4.69858, -1.62205>, <-0.962598, -0.0829344, -0.25793>, <-0.0393632, 4.69858, -1.63302> , <-0.86304, -0.0829335, -0.498282> }
	smooth_triangle { <-0.043904, 4.69858, -1.62205>, <-0.962598, -0.0829344, -0.25793>, <-0.0346206, 4.33794, -1.63028>, <-0.861233, 0.105027, -0.497239>, <-0.0386144, 4.33794, -1.62064> , <-0.960585, 0.105023, -0.257385> }
	smooth_triangle { <-0.0393632, 4.69858, -1.63302>, <-0.86304, -0.0829335, -0.498282>, <-0.0460197, 4.71298, -1.62262>, <-0.943693, -0.213315, -0.252863>, <-0.0412602, 4.71298, -1.63411> , <-0.846093, -0.213315, -0.488491> }
	smooth_triangle { <-0.0460197, 4.71298, -1.62262>, <-0.943693, -0.213315, -0.252863>, <-0.0393632, 4.69858, -1.63302>, <-0.86304, -0.0829335, -0.498282>, <-0.043904, 4.69858, -1.62205> , <-0.962598, -0.0829344, -0.25793> }
	smooth_triangle { <-0.0412602, 4.71298, -1.63411>, <-0.846093, -0.213315, -0.488491>, <-0.0534252, 4.73974, -1.62461>, <-0.917862, -0.311517, -0.24594>, <-0.0478998, 4.73974, -1.63794> , <-0.822935, -0.311517, -0.475117> }
	smooth_triangle { <-0.0534252, 4.73974, -1.62461>, <-0.917862, -0.311517, -0.24594>, <-0.0412602, 4.71298, -1.63411>, <-0.846093, -0.213315, -0.488491>, <-0.0460197, 4.71298, -1.62262> , <-0.943693, -0.213315, -0.252863> }
	smooth_triangle { <-0.0478998, 4.73974, -1.63794>, <-0.822935, -0.311517, -0.475117>, <-0.0618888, 4.76341, -1.62687>, <-0.805096, -0.552524, -0.215726>, <-0.055488, 4.76341, -1.64233> , <-0.72183, -0.552524, -0.416747> }
	smooth_triangle { <-0.0618888, 4.76341, -1.62687>, <-0.805096, -0.552524, -0.215726>, <-0.0478998, 4.73974, -1.63794>, <-0.822935, -0.311517, -0.475117>, <-0.0534252, 4.73974, -1.62461> , <-0.917862, -0.311517, -0.24594> }
	smooth_triangle { <-0.0861699, 4.78708, -1.63338>, <-0.507676, -0.850741, -0.136033>, <-0.055488, 4.76341, -1.64233>, <-0.72183, -0.552524, -0.416747>, <-0.0618888, 4.76341, -1.62687> , <-0.805096, -0.552524, -0.215726> }
	smooth_triangle { <-0.055488, 4.76341, -1.64233>, <-0.72183, -0.552524, -0.416747>, <-0.0861699, 4.78708, -1.63338>, <-0.507676, -0.850741, -0.136033>, <-0.0772578, 4.78708, -1.65489> , <-0.45517, -0.850741, -0.262794> }
	smooth_triangle { <-0.134877, 4.80561, -1.64643>, <-0.43835, -0.891097, -0.117457>, <-0.0772578, 4.78708, -1.65489>, <-0.45517, -0.850741, -0.262794>, <-0.0861699, 4.78708, -1.63338> , <-0.507676, -0.850741, -0.136033> }
	smooth_triangle { <-0.0772578, 4.78708, -1.65489>, <-0.45517, -0.850741, -0.262794>, <-0.134877, 4.80561, -1.64643>, <-0.43835, -0.891097, -0.117457>, <-0.120927, 4.80561, -1.68011> , <-0.393012, -0.891097, -0.226909> }
	smooth_triangle { <-0.182367, 4.83854, -1.65915>, <-0.574848, -0.803632, -0.15403>, <-0.120927, 4.80561, -1.68011>, <-0.393012, -0.891097, -0.226909>, <-0.134877, 4.80561, -1.64643> , <-0.43835, -0.891097, -0.117457> }
	smooth_triangle { <-0.120927, 4.80561, -1.68011>, <-0.393012, -0.891097, -0.226909>, <-0.182367, 4.83854, -1.65915>, <-0.574848, -0.803632, -0.15403>, <-0.163505, 4.83854, -1.70469> , <-0.515395, -0.80363, -0.297569> }
	smooth_triangle { <-0.212808, 4.86427, -1.66731>, <-0.69261, -0.697029, -0.185585>, <-0.163505, 4.83854, -1.70469>, <-0.515395, -0.80363, -0.297569>, <-0.182367, 4.83854, -1.65915> , <-0.574848, -0.803632, -0.15403> }
	smooth_triangle { <-0.163505, 4.83854, -1.70469>, <-0.515395, -0.80363, -0.297569>, <-0.212808, 4.86427, -1.66731>, <-0.69261, -0.697029, -0.185585>, <-0.190798, 4.86427, -1.72045> , <-0.620979, -0.697025, -0.358528> }
	smooth_triangle { <-0.190798, 4.86427, -1.72045>, <-0.620979, -0.697025, -0.358528>, <-0.239597, 4.90029, -1.67449>, <-0.802009, -0.557314, -0.214902>, <-0.214816, 4.90029, -1.73431> , <-0.719062, -0.557314, -0.415152> }
	smooth_triangle { <-0.239597, 4.90029, -1.67449>, <-0.802009, -0.557314, -0.214902>, <-0.190798, 4.86427, -1.72045>, <-0.620979, -0.697025, -0.358528>, <-0.212808, 4.86427, -1.66731> , <-0.69261, -0.697029, -0.185585> }
	smooth_triangle { <-0.214816, 4.90029, -1.73431>, <-0.719062, -0.557314, -0.415152>, <-0.260744, 4.938, -1.68016>, <-0.885771, -0.398843, -0.237346>, <-0.233776, 4.938, -1.74526> , <-0.794158, -0.398848, -0.458512> }
	smooth_triangle { <-0.260744, 4.938, -1.68016>, <-0.885771, -0.398843, -0.237346>, <-0.214816, 4.90029, -1.73431>, <-0.719062, -0.557314, -0.415152>, <-0.239597, 4.90029, -1.67449> , <-0.802009, -0.557314, -0.214902> }
	smooth_triangle { <-0.233776, 4.938, -1.74526>, <-0.794158, -0.398848, -0.458512>, <-0.279232, 5.00115, -1.68511>, <-0.95172, -0.170873, -0.255012>, <-0.250353, 5.00115, -1.75483> , <-0.853285, -0.170877, -0.492652> }
	smooth_triangle { <-0.279232, 5.00115, -1.68511>, <-0.95172, -0.170873, -0.255012>, <-0.233776, 4.938, -1.74526>, <-0.794158, -0.398848, -0.458512>, <-0.260744, 4.938, -1.68016> , <-0.885771, -0.398843, -0.237346> }
	smooth_triangle { <-0.250353, 5.00115, -1.75483>, <-0.853285, -0.170877, -0.492652>, <-0.283432, 5.08966, -1.68624>, <-0.965909, 0.00603488, -0.258811>, <-0.254119, 5.08966, -1.75701> , <-0.866012, 0.00603904, -0.499988> }
	smooth_triangle { <-0.283432, 5.08966, -1.68624>, <-0.965909, 0.00603488, -0.258811>, <-0.250353, 5.00115, -1.75483>, <-0.853285, -0.170877, -0.492652>, <-0.279232, 5.00115, -1.68511> , <-0.95172, -0.170873, -0.255012> }
	smooth_triangle { <-0.254119, 5.08966, -1.75701>, <-0.866011, 0.00603904, -0.499988>, <-0.277344, 5.19258, -1.6846>, <-0.962528, 0.0837966, -0.257911>, <-0.24866, 5.19258, -1.75385> , <-0.862983, 0.0837985, -0.498236> }
	smooth_triangle { <-0.277344, 5.19258, -1.6846>, <-0.962528, 0.0837966, -0.257911>, <-0.254119, 5.08966, -1.75701>, <-0.866011, 0.00603904, -0.499988>, <-0.283432, 5.08966, -1.68624> , <-0.965909, 0.00603488, -0.258811> }
	smooth_triangle { <-0.24866, 5.19258, -1.75385>, <-0.862983, 0.0837985, -0.498236>, <-0.266385, 5.29859, -1.68167>, <-0.95994, 0.111144, -0.25722>, <-0.238834, 5.29859, -1.74818> , <-0.860661, 0.111147, -0.496899> }
	smooth_triangle { <-0.266385, 5.29859, -1.68167>, <-0.95994, 0.111144, -0.25722>, <-0.24866, 5.19258, -1.75385>, <-0.862983, 0.0837985, -0.498236>, <-0.277344, 5.19258, -1.6846> , <-0.962528, 0.0837966, -0.257911> }
	smooth_triangle { <-0.238834, 5.29859, -1.74818>, <-0.860661, 0.111147, -0.496899>, <-0.259079, 5.36342, -1.67971>, <-0.95942, 0.11586, -0.257078>, <-0.232284, 5.36342, -1.7444> , <-0.860195, 0.115872, -0.496628> }
	smooth_triangle { <-0.259079, 5.36342, -1.67971>, <-0.95942, 0.11586, -0.257078>, <-0.238834, 5.29859, -1.74818>, <-0.860661, 0.111147, -0.496899>, <-0.266385, 5.29859, -1.68167> , <-0.95994, 0.111144, -0.25722> }
	smooth_triangle { <-0.232284, 5.36342, -1.7444>, <-0.858663, 0.130117, -0.495748>, <-0.248121, 5.44988, -1.67677>, <-0.955909, 0.143628, -0.256143>, <-0.222458, 5.44988, -1.73873> , <-0.857045, 0.14362, -0.494821> }
	smooth_triangle { <-0.248121, 5.44988, -1.67677>, <-0.955909, 0.143628, -0.256143>, <-0.232284, 5.36342, -1.7444>, <-0.858663, 0.130117, -0.495748>, <-0.259079, 5.36342, -1.67971> , <-0.957711, 0.130122, -0.25663> }
	smooth_triangle { <-0.222458, 5.44988, -1.73873>, <-0.857045, 0.14362, -0.494821>, <-0.235944, 5.52912, -1.67351>, <-0.951674, 0.171153, -0.254997>, <-0.211542, 5.52912, -1.73242> , <-0.853244, 0.171155, -0.492626> }
	smooth_triangle { <-0.235944, 5.52912, -1.67351>, <-0.951674, 0.171153, -0.254997>, <-0.222458, 5.44988, -1.73873>, <-0.857045, 0.14362, -0.494821>, <-0.248121, 5.44988, -1.67677> , <-0.955909, 0.143628, -0.256143> }
	smooth_triangle { <-0.211542, 5.52912, -1.73242>, <-0.853244, 0.171155, -0.492626>, <-0.228638, 5.56926, -1.67155>, <-0.949226, 0.185163, -0.254333>, <-0.204992, 5.56926, -1.72864> , <-0.851048, 0.185181, -0.49135> }
	smooth_triangle { <-0.228638, 5.56926, -1.67155>, <-0.949226, 0.185163, -0.254333>, <-0.211542, 5.52912, -1.73242>, <-0.853244, 0.171155, -0.492626>, <-0.235944, 5.52912, -1.67351> , <-0.951674, 0.171153, -0.254997> }
	smooth_triangle { <-0.199532, 5.56926, -1.72549>, <0.166704, 0.981298, 0.0962514>, <-0.228638, 5.56926, -1.67155>, <0, 1, 0>, <-0.22255, 5.56926, -1.66992> , <0.18593, 0.981299, 0.0498163> }
	smooth_triangle { <-0.228638, 5.56926, -1.67155>, <0, 1, 0>, <-0.199532, 5.56926, -1.72549>, <0.166704, 0.981298, 0.0962514>, <-0.204992, 5.56926, -1.72864> , <0, 1, 0> }
	smooth_triangle { <-0.195166, 5.5672, -1.72297>, <0.327366, 0.925799, 0.189015>, <-0.22255, 5.56926, -1.66992>, <0.18593, 0.981299, 0.0498163>, <-0.217678, 5.5672, -1.66862> , <0.365123, 0.925805, 0.0978276> }
	smooth_triangle { <-0.22255, 5.56926, -1.66992>, <0.18593, 0.981299, 0.0498163>, <-0.195166, 5.5672, -1.72297>, <0.327366, 0.925799, 0.189015>, <-0.199532, 5.56926, -1.72549> , <0.166704, 0.981298, 0.0962514> }
	smooth_triangle { <-0.21646, 5.55794, -1.66829>, <0.957096, 0.134905, 0.256452>, <-0.195166, 5.5672, -1.72297>, <0.858113, 0.13493, 0.495415>, <-0.217678, 5.5672, -1.66862> , <0.957096, 0.134905, 0.256452> }
	smooth_triangle { <-0.195166, 5.5672, -1.72297>, <0.858113, 0.13493, 0.495415>, <-0.21646, 5.55794, -1.66829>, <0.957096, 0.134905, 0.256452>, <-0.194073, 5.55794, -1.72234> , <0.858113, 0.13493, 0.495415> }
	smooth_triangle { <-0.0861699, 4.78708, -1.63338>, <-0.137921, -0.989753, -0.0369693>, <-0.00123028, 4.77442, -1.611>, <-0.123655, -0.989752, -0.0714148>, <-0.0013722, 4.77442, -1.61066> , <-0.137921, -0.989753, -0.0369693> }
	smooth_triangle { <-0.00123028, 4.77442, -1.611>, <-0.123655, -0.989752, -0.0714148>, <-0.0861699, 4.78708, -1.63338>, <-0.137921, -0.989753, -0.0369693>, <-0.0772578, 4.78708, -1.65489> , <-0.123655, -0.989752, -0.0714148> }
	smooth_triangle { <-0.294073, 4.21572, -1.61029>, <0.0286499, -0.99959, 1.49013e-008>, <-0.00176999, 4.22409, -1.61076>, <0.027674, -0.99959, 0.0074148>, <-0.00183244, 4.22409, -1.61029> , <0.0286499, -0.99959, 1.49013e-008> }
	smooth_triangle { <-0.00176999, 4.22409, -1.61076>, <0.027674, -0.99959, 0.0074148>, <-0.294073, 4.21572, -1.61029>, <0.0286499, -0.99959, 1.49013e-008>, <-0.284052, 4.21572, -1.6864> , <0.027674, -0.99959, 0.0074148> }
	smooth_triangle { <-0.284052, 4.21572, -1.6864>, <-0.962453, 0.0847032, -0.257894>, <-0.292969, 4.2287, -1.61029>, <-0.996406, 0.0847006, 1.50288e-007>, <-0.282986, 4.2287, -1.68612> , <-0.962453, 0.0847032, -0.257894> }
	smooth_triangle { <-0.292969, 4.2287, -1.61029>, <-0.996406, 0.0847006, 1.50288e-007>, <-0.284052, 4.21572, -1.6864>, <-0.962453, 0.0847032, -0.257894>, <-0.294073, 4.21572, -1.61029> , <-0.996406, 0.0847006, 1.50288e-007> }
	smooth_triangle { <-0.246648, 4.24779, -1.67638>, <-0.341159, 0.93555, -0.0914136>, <-0.292969, 4.2287, -1.61029>, <-0.45251, 0.891759, -7.46379e-009>, <-0.255349, 4.24779, -1.61029> , <-0.353193, 0.93555, 5.7213e-008> }
	smooth_triangle { <-0.292969, 4.2287, -1.61029>, <-0.45251, 0.891759, -7.46379e-009>, <-0.246648, 4.24779, -1.67638>, <-0.341159, 0.93555, -0.0914136>, <-0.282986, 4.2287, -1.68612> , <-0.437092, 0.891759, -0.117118> }
	smooth_triangle { <-0.175181, 4.26688, -1.65723>, <-0.206925, 0.976784, -0.0554457>, <-0.255349, 4.24779, -1.61029>, <-0.353193, 0.93555, 5.7213e-008>, <-0.18136, 4.26688, -1.61029> , <-0.214225, 0.976784, 2.79698e-008> }
	smooth_triangle { <-0.255349, 4.24779, -1.61029>, <-0.353193, 0.93555, 5.7213e-008>, <-0.175181, 4.26688, -1.65723>, <-0.206925, 0.976784, -0.0554457>, <-0.246648, 4.24779, -1.67638> , <-0.341159, 0.93555, -0.0914136> }
	smooth_triangle { <-0.124306, 4.27643, -1.6436>, <-0.155992, 0.986874, -0.0417968>, <-0.18136, 4.26688, -1.61029>, <-0.214225, 0.976784, 2.79698e-008>, <-0.128691, 4.27643, -1.61029> , <-0.161495, 0.986874, -4.42544e-008> }
	smooth_triangle { <-0.18136, 4.26688, -1.61029>, <-0.214225, 0.976784, 2.79698e-008>, <-0.124306, 4.27643, -1.6436>, <-0.155992, 0.986874, -0.0417968>, <-0.175181, 4.26688, -1.65723> , <-0.206925, 0.976784, -0.0554457> }
	smooth_triangle { <-0.0682361, 4.28491, -1.62857>, <-0.139689, 0.989488, -0.0374287>, <-0.128691, 4.27643, -1.61029>, <-0.161495, 0.986874, -4.42544e-008>, <-0.0706433, 4.28491, -1.61029> , <-0.144617, 0.989488, -2.32873e-008> }
	smooth_triangle { <-0.128691, 4.27643, -1.61029>, <-0.161495, 0.986874, -4.42544e-008>, <-0.0682361, 4.28491, -1.62857>, <-0.139689, 0.989488, -0.0374287>, <-0.124306, 4.27643, -1.6436> , <-0.155992, 0.986874, -0.0417968> }
	smooth_triangle { <-0.0682361, 4.28491, -1.62857>, <-0.782847, 0.585792, -0.209759>, <-0.0629768, 4.29552, -1.61029>, <-0.95129, 0.308298, 9.06991e-008>, <-0.0608309, 4.29552, -1.62659> , <-0.918876, 0.308297, -0.24621> }
	smooth_triangle { <-0.0629768, 4.29552, -1.61029>, <-0.95129, 0.308298, 9.06991e-008>, <-0.0682361, 4.28491, -1.62857>, <-0.782847, 0.585792, -0.209759>, <-0.0706433, 4.28491, -1.61029> , <-0.810461, 0.585793, 1.72336e-007> }
	smooth_triangle { <-0.0608309, 4.29552, -1.62659>, <-0.918876, 0.308297, -0.24621>, <-0.0629768, 4.30188, -1.61029>, <-1, 0, 0>, <-0.0608309, 4.30188, -1.62659> , <-0.965926, 0, -0.258818> }
	smooth_triangle { <-0.0629768, 4.30188, -1.61029>, <-1, 0, 0>, <-0.0608309, 4.29552, -1.62659>, <-0.918876, 0.308297, -0.24621>, <-0.0629768, 4.29552, -1.61029> , <-0.95129, 0.308298, 9.06991e-008> }
	smooth_triangle { <-0.0608309, 4.30188, -1.62659>, <-0.965926, 0, -0.258818>, <-0.0629768, 4.30931, -1.61029>, <-0.946025, 0.324093, 1.12994e-007>, <-0.0608309, 4.30931, -1.62659> , <-0.91379, 0.324092, -0.244849> }
	smooth_triangle { <-0.0629768, 4.30931, -1.61029>, <-0.946025, 0.324093, 1.12994e-007>, <-0.0608309, 4.30188, -1.62659>, <-0.965926, 0, -0.258818>, <-0.0629768, 4.30188, -1.61029> , <-1, 0, 0> }
	smooth_triangle { <-0.0608309, 4.30931, -1.62659>, <-0.91379, 0.324092, -0.244849>, <-0.0564051, 4.31779, -1.61029>, <-0.61195, 0.790897, 5.21168e-008>, <-0.0544832, 4.31779, -1.62489> , <-0.591099, 0.790896, -0.158383> }
	smooth_triangle { <-0.0564051, 4.31779, -1.61029>, <-0.61195, 0.790897, 5.21168e-008>, <-0.0608309, 4.30931, -1.62659>, <-0.91379, 0.324092, -0.244849>, <-0.0629768, 4.30931, -1.61029> , <-0.946025, 0.324093, 1.14976e-007> }
	smooth_triangle { <-0.0449618, 4.32203, -1.62234>, <-0.612223, 0.773481, -0.164045>, <-0.0564051, 4.31779, -1.61029>, <-0.61195, 0.790897, 5.21168e-008>, <-0.0465479, 4.32203, -1.61029> , <-0.633819, 0.773481, -2.33468e-008> }
	smooth_triangle { <-0.0564051, 4.31779, -1.61029>, <-0.61195, 0.790897, 5.21168e-008>, <-0.0449618, 4.32203, -1.62234>, <-0.612223, 0.773481, -0.164045>, <-0.0544832, 4.31779, -1.62489> , <-0.591099, 0.790896, -0.158383> }
	smooth_triangle { <-0.0449618, 4.32203, -1.62234>, <-0.612223, 0.773481, -0.164045>, <-0.0421669, 4.3284, -1.61029>, <-0.915349, 0.402663, 8.02038e-008>, <-0.0407301, 4.3284, -1.6212> , <-0.884159, 0.402663, -0.236908> }
	smooth_triangle { <-0.0421669, 4.3284, -1.61029>, <-0.915349, 0.402663, 8.02038e-008>, <-0.0449618, 4.32203, -1.62234>, <-0.612223, 0.773481, -0.164045>, <-0.0465479, 4.32203, -1.61029> , <-0.633819, 0.773481, -2.33468e-008> }
	smooth_triangle { <-0.0407301, 4.3284, -1.6212>, <-0.884159, 0.402663, -0.236908>, <-0.0399765, 4.33794, -1.61029>, <-0.99447, 0.105022, 4.54081e-008>, <-0.0386144, 4.33794, -1.62064> , <-0.960585, 0.105023, -0.257385> }
	smooth_triangle { <-0.0399765, 4.33794, -1.61029>, <-0.99447, 0.105022, 4.54081e-008>, <-0.0407301, 4.3284, -1.6212>, <-0.884159, 0.402663, -0.236908>, <-0.0421669, 4.3284, -1.61029> , <-0.915349, 0.402663, 8.02038e-008> }
	smooth_triangle { <-0.0386144, 4.33794, -1.62064>, <-0.960585, 0.105023, -0.257385>, <-0.0454527, 4.69858, -1.61029>, <-0.996555, -0.082936, 4.1423e-008>, <-0.043904, 4.69858, -1.62205> , <-0.962598, -0.0829344, -0.25793> }
	smooth_triangle { <-0.0454527, 4.69858, -1.61029>, <-0.996555, -0.082936, 4.1423e-008>, <-0.0386144, 4.33794, -1.62064>, <-0.960585, 0.105023, -0.257385>, <-0.0399765, 4.33794, -1.61029> , <-0.99447, 0.105022, 4.54081e-008> }
	smooth_triangle { <-0.043904, 4.69858, -1.62205>, <-0.962598, -0.0829344, -0.25793>, <-0.0476431, 4.71298, -1.61029>, <-0.976983, -0.213316, 4.89266e-008>, <-0.0460197, 4.71298, -1.62262> , <-0.943693, -0.213315, -0.252863> }
	smooth_triangle { <-0.0476431, 4.71298, -1.61029>, <-0.976983, -0.213316, 4.89266e-008>, <-0.043904, 4.69858, -1.62205>, <-0.962598, -0.0829344, -0.25793>, <-0.0454527, 4.69858, -1.61029> , <-0.996555, -0.082936, 4.1423e-008> }
	smooth_triangle { <-0.0460197, 4.71298, -1.62262>, <-0.943693, -0.213315, -0.252863>, <-0.0553099, 4.73974, -1.61029>, <-0.950241, -0.311516, -2.25418e-008>, <-0.0534252, 4.73974, -1.62461> , <-0.917862, -0.311517, -0.24594> }
	smooth_triangle { <-0.0553099, 4.73974, -1.61029>, <-0.950241, -0.311516, -2.25418e-008>, <-0.0460197, 4.71298, -1.62262>, <-0.943693, -0.213315, -0.252863>, <-0.0476431, 4.71298, -1.61029> , <-0.976983, -0.213316, 4.89266e-008> }
	smooth_triangle { <-0.0534252, 4.73974, -1.62461>, <-0.917862, -0.311517, -0.24594>, <-0.064072, 4.76341, -1.61029>, <-0.833497, -0.552524, -5.19581e-008>, <-0.0618888, 4.76341, -1.62687> , <-0.805096, -0.552524, -0.215726> }
	smooth_triangle { <-0.064072, 4.76341, -1.61029>, <-0.833497, -0.552524, -5.19581e-008>, <-0.0534252, 4.73974, -1.62461>, <-0.917862, -0.311517, -0.24594>, <-0.0553099, 4.73974, -1.61029> , <-0.950241, -0.311516, -2.25418e-008> }
	smooth_triangle { <-0.0892096, 4.78708, -1.61029>, <-0.525585, -0.850741, 1.36279e-007>, <-0.0618888, 4.76341, -1.62687>, <-0.805096, -0.552525, -0.215726>, <-0.064072, 4.76341, -1.61029> , <-0.833497, -0.552524, -5.19581e-008> }
	smooth_triangle { <-0.0618888, 4.76341, -1.62687>, <-0.805096, -0.552525, -0.215726>, <-0.0892096, 4.78708, -1.61029>, <-0.525585, -0.850741, 1.36279e-007>, <-0.0861699, 4.78708, -1.63338> , <-0.507676, -0.850741, -0.136033> }
	smooth_triangle { <-0.139635, 4.80561, -1.61029>, <-0.453813, -0.891097, -2.34926e-007>, <-0.0861699, 4.78708, -1.63338>, <-0.507676, -0.850741, -0.136033>, <-0.0892096, 4.78708, -1.61029> , <-0.525585, -0.850741, 1.37232e-007> }
	smooth_triangle { <-0.0861699, 4.78708, -1.63338>, <-0.507676, -0.850741, -0.136033>, <-0.139635, 4.80561, -1.61029>, <-0.453813, -0.891097, -2.34926e-007>, <-0.134877, 4.80561, -1.64643> , <-0.43835, -0.891097, -0.117457> }
	smooth_triangle { <-0.188799, 4.83854, -1.61029>, <-0.595128, -0.803631, 1.2719e-007>, <-0.134877, 4.80561, -1.64643>, <-0.43835, -0.891097, -0.117457>, <-0.139635, 4.80561, -1.61029> , <-0.453813, -0.891097, -2.33986e-007> }
	smooth_triangle { <-0.134877, 4.80561, -1.64643>, <-0.43835, -0.891097, -0.117457>, <-0.188799, 4.83854, -1.61029>, <-0.595128, -0.803631, 1.2719e-007>, <-0.182367, 4.83854, -1.65915> , <-0.574848, -0.803632, -0.15403> }
	smooth_triangle { <-0.220315, 4.86427, -1.61029>, <-0.717044, -0.697028, 4.25639e-007>, <-0.182367, 4.83854, -1.65915>, <-0.574848, -0.803632, -0.15403>, <-0.188799, 4.83854, -1.61029> , <-0.595128, -0.803631, 1.2719e-007> }
	smooth_triangle { <-0.182367, 4.83854, -1.65915>, <-0.574848, -0.803632, -0.15403>, <-0.220315, 4.86427, -1.61029>, <-0.717044, -0.697028, 4.25639e-007>, <-0.212808, 4.86427, -1.66731> , <-0.69261, -0.697029, -0.185585> }
	smooth_triangle { <-0.212808, 4.86427, -1.66731>, <-0.69261, -0.697029, -0.185585>, <-0.248049, 4.90029, -1.61029>, <-0.830302, -0.557314, -9.95172e-008>, <-0.239597, 4.90029, -1.67449> , <-0.802009, -0.557314, -0.214902> }
	smooth_triangle { <-0.248049, 4.90029, -1.61029>, <-0.830302, -0.557314, -9.95172e-008>, <-0.212808, 4.86427, -1.66731>, <-0.69261, -0.697029, -0.185585>, <-0.220315, 4.86427, -1.61029> , <-0.717044, -0.697028, 4.25639e-007> }
	smooth_triangle { <-0.239597, 4.90029, -1.67449>, <-0.802009, -0.557314, -0.214902>, <-0.269942, 4.938, -1.61029>, <-0.917019, -0.398843, -8.68801e-008>, <-0.260744, 4.938, -1.68016> , <-0.885771, -0.398843, -0.237346> }
	smooth_triangle { <-0.269942, 4.938, -1.61029>, <-0.917019, -0.398843, -8.68801e-008>, <-0.239597, 4.90029, -1.67449>, <-0.802009, -0.557314, -0.214902>, <-0.248049, 4.90029, -1.61029> , <-0.830302, -0.557314, -9.95172e-008> }
	smooth_triangle { <-0.260744, 4.938, -1.68016>, <-0.885771, -0.398843, -0.237346>, <-0.289082, 5.00115, -1.61029>, <-0.985293, -0.170873, -1.66516e-007>, <-0.279232, 5.00115, -1.68511> , <-0.95172, -0.170873, -0.255012> }
	smooth_triangle { <-0.289082, 5.00115, -1.61029>, <-0.985293, -0.170873, -1.66516e-007>, <-0.260744, 4.938, -1.68016>, <-0.885771, -0.398843, -0.237346>, <-0.269942, 4.938, -1.61029> , <-0.917019, -0.398843, -8.68801e-008> }
	smooth_triangle { <-0.279232, 5.00115, -1.68511>, <-0.95172, -0.170873, -0.255012>, <-0.293431, 5.08966, -1.61029>, <-0.999982, 0.00603511, -1.01602e-007>, <-0.283432, 5.08966, -1.68624> , <-0.965909, 0.00603488, -0.258811> }
	smooth_triangle { <-0.293431, 5.08966, -1.61029>, <-0.999982, 0.00603511, -1.01602e-007>, <-0.279232, 5.00115, -1.68511>, <-0.95172, -0.170873, -0.255012>, <-0.289082, 5.00115, -1.61029> , <-0.985293, -0.170873, -1.66516e-007> }
	smooth_triangle { <-0.283432, 5.08966, -1.68624>, <-0.965909, 0.00603488, -0.258811>, <-0.287129, 5.19258, -1.61029>, <-0.996483, 0.083797, -2.63072e-008>, <-0.277344, 5.19258, -1.6846> , <-0.962528, 0.0837966, -0.257911> }
	smooth_triangle { <-0.287129, 5.19258, -1.61029>, <-0.996483, 0.083797, -2.63072e-008>, <-0.283432, 5.08966, -1.68624>, <-0.965909, 0.00603488, -0.258811>, <-0.293431, 5.08966, -1.61029> , <-0.999982, 0.00603511, -1.01602e-007> }
	smooth_triangle { <-0.277344, 5.19258, -1.6846>, <-0.962528, 0.0837966, -0.257911>, <-0.275782, 5.29859, -1.61029>, <-0.993804, 0.111143, 0>, <-0.266385, 5.29859, -1.68167> , <-0.95994, 0.111144, -0.25722> }
	smooth_triangle { <-0.275782, 5.29859, -1.61029>, <-0.993804, 0.111143, 0>, <-0.277344, 5.19258, -1.6846>, <-0.962528, 0.0837966, -0.257911>, <-0.287129, 5.19258, -1.61029> , <-0.996483, 0.083797, -2.63072e-008> }
	smooth_triangle { <-0.266385, 5.29859, -1.68167>, <-0.95994, 0.111144, -0.25722>, <-0.26822, 5.36342, -1.61029>, <-0.993266, 0.115858, 2.2542e-008>, <-0.259079, 5.36342, -1.67971> , <-0.95942, 0.11586, -0.257078> }
	smooth_triangle { <-0.26822, 5.36342, -1.61029>, <-0.993266, 0.115858, 2.2542e-008>, <-0.266385, 5.29859, -1.68167>, <-0.95994, 0.111144, -0.25722>, <-0.275782, 5.29859, -1.61029> , <-0.993804, 0.111143, 0> }
	smooth_triangle { <-0.259079, 5.36342, -1.67971>, <-0.957711, 0.130122, -0.25663>, <-0.256873, 5.44988, -1.61029>, <-0.989632, 0.143628, -1.87856e-008>, <-0.248121, 5.44988, -1.67677> , <-0.955909, 0.143628, -0.256143> }
	smooth_triangle { <-0.256873, 5.44988, -1.61029>, <-0.989632, 0.143628, -1.87856e-008>, <-0.259079, 5.36342, -1.67971>, <-0.957711, 0.130122, -0.25663>, <-0.26822, 5.36342, -1.61029> , <-0.991498, 0.130123, 7.51381e-009> }
	smooth_triangle { <-0.248121, 5.44988, -1.67677>, <-0.955909, 0.143628, -0.256143>, <-0.244266, 5.52912, -1.61029>, <-0.985245, 0.171152, -3.90714e-007>, <-0.235944, 5.52912, -1.67351> , <-0.951674, 0.171153, -0.254997> }
	smooth_triangle { <-0.244266, 5.52912, -1.61029>, <-0.985245, 0.171152, -3.90714e-007>, <-0.248121, 5.44988, -1.67677>, <-0.955909, 0.143628, -0.256143>, <-0.256873, 5.44988, -1.61029> , <-0.989632, 0.143628, -1.87856e-008> }
	smooth_triangle { <-0.235944, 5.52912, -1.67351>, <-0.951674, 0.171153, -0.254997>, <-0.236704, 5.56926, -1.61029>, <-0.982708, 0.185162, -7.36241e-007>, <-0.228638, 5.56926, -1.67155> , <-0.949226, 0.185163, -0.254333> }
	smooth_triangle { <-0.236704, 5.56926, -1.61029>, <-0.982708, 0.185162, -7.36241e-007>, <-0.235944, 5.52912, -1.67351>, <-0.951674, 0.171153, -0.254997>, <-0.244266, 5.52912, -1.61029> , <-0.985245, 0.171152, -3.90714e-007> }
	smooth_triangle { <-0.22255, 5.56926, -1.66992>, <0.18593, 0.981299, 0.0498163>, <-0.236704, 5.56926, -1.61029>, <0, 1, 0>, <-0.2304, 5.56926, -1.61029> , <0.192487, 0.981299, 3.81012e-006> }
	smooth_triangle { <-0.236704, 5.56926, -1.61029>, <0, 1, 0>, <-0.22255, 5.56926, -1.66992>, <0.18593, 0.981299, 0.0498163>, <-0.228638, 5.56926, -1.67155> , <0, 1, 0> }
	smooth_triangle { <-0.217678, 5.5672, -1.66862>, <0.365123, 0.925805, 0.0978276>, <-0.2304, 5.56926, -1.61029>, <0.192487, 0.981299, 3.81012e-006>, <-0.225358, 5.5672, -1.61029> , <0.378, 0.925805, 7.48218e-006> }
	smooth_triangle { <-0.2304, 5.56926, -1.61029>, <0.192487, 0.981299, 3.81012e-006>, <-0.217678, 5.5672, -1.66862>, <0.365123, 0.925805, 0.0978276>, <-0.22255, 5.56926, -1.66992> , <0.18593, 0.981299, 0.0498163> }
	smooth_triangle { <-0.224097, 5.55794, -1.61029>, <0.990859, 0.134899, -1.72816e-007>, <-0.217678, 5.5672, -1.66862>, <0.957096, 0.134905, 0.256452>, <-0.225358, 5.5672, -1.61029> , <0.990859, 0.134899, -1.72816e-007> }
	smooth_triangle { <-0.217678, 5.5672, -1.66862>, <0.957096, 0.134905, 0.256452>, <-0.224097, 5.55794, -1.61029>, <0.990859, 0.134899, -1.72816e-007>, <-0.21646, 5.55794, -1.66829> , <0.957096, 0.134905, 0.256452> }
	smooth_triangle { <-0.0892096, 4.78708, -1.61029>, <-0.142793, -0.989753, 2.05859e-007>, <-0.0013722, 4.77442, -1.61066>, <-0.137921, -0.989753, -0.0369693>, <-0.0014206, 4.77442, -1.61029> , <-0.142793, -0.989753, 2.05859e-007> }
	smooth_triangle { <-0.0013722, 4.77442, -1.61066>, <-0.137921, -0.989753, -0.0369693>, <-0.0892096, 4.78708, -1.61029>, <-0.142793, -0.989753, 2.05859e-007>, <-0.0861699, 4.78708, -1.63338> , <-0.137921, -0.989753, -0.0369693> }
material { m_glass }
#if (use_photons)
 photons{
  target
  refraction on
  reflection on
  collect off
 }
#end
}

// object Feet1
union {
	smooth_triangle { <-0.268712, 5.04227, -0.960345>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.89046, -1.11981>, <0.999994, -0.00310746, -0.001709>, <-0.268987, 5.03903, -1.11538> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.268712, 5.04227, -0.960345>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.87757, -1.12999>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.89046, -1.11981> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.86197, -1.15779>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.85791, -0.948719>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86197, -1.18425> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.86536, -1.14626>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.85791, -0.948719>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86197, -1.15779> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.87757, -1.12999>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.85791, -0.948719>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86536, -1.14626> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.85791, -0.948719>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.87757, -1.12999>, <0.999994, -0.00310746, -0.001709>, <-0.268712, 5.04227, -0.960345> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.89792, -1.27784>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.89995, -1.31583>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.90063, -1.29684> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.89792, -1.27784>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.89521, -1.33617>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.89995, -1.31583> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.89792, -1.27784>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.88503, -1.35381>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.89521, -1.33617> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.89792, -1.27784>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86808, -1.37212>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.88503, -1.35381> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.86197, -1.18425>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86808, -1.37212>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.89792, -1.27784> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.8518, -0.938042>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86197, -1.18425>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.85791, -0.948719> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.8518, -0.938042>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86808, -1.37212>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86197, -1.18425> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.8518, -0.938042>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.85044, -1.38365>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.86808, -1.37212> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.83416, -0.924477>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.85044, -1.38365>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.8518, -0.938042> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.83416, -0.924477>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.83416, -1.38976>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.85044, -1.38365> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.82263, -0.917694>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.83416, -1.38976>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.83416, -0.924477> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.82263, -0.917694>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.80568, -1.3945>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.83416, -1.38976> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.7487, -0.910234>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.80568, -1.3945>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.82263, -0.917694> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.73164, -0.912947>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.80568, -1.3945>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.7487, -0.910234> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.269265, 4.80568, -1.3945>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.73164, -0.912947>, <0.999994, -0.00310746, -0.001709>, <-0.269265, 4.7201, -1.39586> , <0.999994, -0.00310746, -0.001709> }
	smooth_triangle { <-0.253632, 5.04213, -0.949756>, <1, 0, 0>, <-0.253632, 4.89582, -1.1345>, <1, 0, 0>, <-0.253632, 5.03937, -1.12634> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 5.04213, -0.949756>, <1, 0, 0>, <-0.253632, 4.88876, -1.1409>, <1, 0, 0>, <-0.253632, 4.89582, -1.1345> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.87745, -1.16002>, <1, 0, 0>, <-0.253632, 4.8662, -0.935465>, <1, 0, 0>, <-0.253632, 4.87734, -1.1814> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.87934, -1.15327>, <1, 0, 0>, <-0.253632, 4.8662, -0.935465>, <1, 0, 0>, <-0.253632, 4.87745, -1.16002> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.88876, -1.1409>, <1, 0, 0>, <-0.253632, 4.8662, -0.935465>, <1, 0, 0>, <-0.253632, 4.87934, -1.15327> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.8662, -0.935465>, <1, 0, 0>, <-0.253632, 4.88876, -1.1409>, <1, 0, 0>, <-0.253632, 5.04213, -0.949756> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.91305, -1.27391>, <1, 0, 0>, <-0.253632, 4.91545, -1.31789>, <1, 0, 0>, <-0.253632, 4.91624, -1.29601> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.91305, -1.27391>, <1, 0, 0>, <-0.253632, 4.90974, -1.34192>, <1, 0, 0>, <-0.253632, 4.91545, -1.31789> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.91305, -1.27391>, <1, 0, 0>, <-0.253632, 4.89762, -1.36308>, <1, 0, 0>, <-0.253632, 4.90974, -1.34192> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.91305, -1.27391>, <1, 0, 0>, <-0.253632, 4.87817, -1.38406>, <1, 0, 0>, <-0.253632, 4.89762, -1.36308> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.87734, -1.1814>, <1, 0, 0>, <-0.253632, 4.87817, -1.38406>, <1, 0, 0>, <-0.253632, 4.91305, -1.27391> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.8662, -0.935465>, <1, 0, 0>, <-0.253632, 4.87817, -1.38406>, <1, 0, 0>, <-0.253632, 4.87734, -1.1814> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.86358, -0.927763>, <1, 0, 0>, <-0.253632, 4.87817, -1.38406>, <1, 0, 0>, <-0.253632, 4.8662, -0.935465> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.86358, -0.927763>, <1, 0, 0>, <-0.253632, 4.85751, -1.3976>, <1, 0, 0>, <-0.253632, 4.87817, -1.38406> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.84291, -0.91152>, <1, 0, 0>, <-0.253632, 4.85751, -1.3976>, <1, 0, 0>, <-0.253632, 4.86358, -0.927763> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.84291, -0.91152>, <1, 0, 0>, <-0.253632, 4.83821, -1.40486>, <1, 0, 0>, <-0.253632, 4.85751, -1.3976> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.82749, -0.902837>, <1, 0, 0>, <-0.253632, 4.83821, -1.40486>, <1, 0, 0>, <-0.253632, 4.84291, -0.91152> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.82749, -0.902837>, <1, 0, 0>, <-0.253632, 4.80711, -1.41007>, <1, 0, 0>, <-0.253632, 4.83821, -1.40486> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.74546, -0.894943>, <1, 0, 0>, <-0.253632, 4.80711, -1.41007>, <1, 0, 0>, <-0.253632, 4.82749, -0.902837> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.73053, -0.90494>, <1, 0, 0>, <-0.253632, 4.80711, -1.41007>, <1, 0, 0>, <-0.253632, 4.74546, -0.894943> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 4.80711, -1.41007>, <1, 0, 0>, <-0.253632, 4.73053, -0.90494>, <1, 0, 0>, <-0.253632, 4.72134, -1.40688> , <1, 0, 0> }
	smooth_triangle { <-0.253632, 5.04213, -0.949756>, <0.0235742, 0.999503, -0.020925>, <-0.268987, 5.03903, -1.11538>, <0.0235742, 0.999503, -0.020925>, <-0.268712, 5.04227, -0.960345> , <0.0235742, 0.999503, -0.020925> }
	smooth_triangle { <-0.268987, 5.03903, -1.11538>, <0.0235742, 0.999503, -0.020925>, <-0.253632, 5.04213, -0.949756>, <0.0235742, 0.999503, -0.020925>, <-0.253632, 5.03937, -1.12634> , <0.0235742, 0.999503, -0.020925> }
	smooth_triangle { <-0.268712, 5.04227, -0.960345>, <-0.66095, 0.0492051, 0.748815>, <-0.253632, 4.8662, -0.935465>, <-0.725668, 0.356591, 0.588428>, <-0.253632, 5.04213, -0.949756> , <-0.66095, 0.0492051, 0.748815> }
	smooth_triangle { <-0.253632, 4.8662, -0.935465>, <-0.725668, 0.356591, 0.588428>, <-0.268712, 5.04227, -0.960345>, <-0.66095, 0.0492051, 0.748815>, <-0.269265, 4.85791, -0.948719> , <-0.725668, 0.356591, 0.588428> }
	smooth_triangle { <-0.269265, 4.85791, -0.948719>, <-0.725668, 0.356591, 0.588428>, <-0.253632, 4.86358, -0.927763>, <-0.710212, 0.530783, 0.462459>, <-0.253632, 4.8662, -0.935465> , <-0.725668, 0.356591, 0.588428> }
	smooth_triangle { <-0.253632, 4.86358, -0.927763>, <-0.710212, 0.530783, 0.462459>, <-0.269265, 4.85791, -0.948719>, <-0.725668, 0.356591, 0.588428>, <-0.269265, 4.8518, -0.938042> , <-0.710212, 0.530783, 0.462459> }
	smooth_triangle { <-0.269265, 4.8518, -0.938042>, <-0.710212, 0.530783, 0.462459>, <-0.253632, 4.84291, -0.91152>, <-0.703273, 0.397532, 0.589386>, <-0.253632, 4.86358, -0.927763> , <-0.710212, 0.530783, 0.462459> }
	smooth_triangle { <-0.253632, 4.84291, -0.91152>, <-0.703273, 0.397532, 0.589386>, <-0.269265, 4.8518, -0.938042>, <-0.710212, 0.530783, 0.462459>, <-0.269265, 4.83416, -0.924477> , <-0.703273, 0.397532, 0.589386> }
	smooth_triangle { <-0.269265, 4.83416, -0.924477>, <-0.703273, 0.397532, 0.589386>, <-0.253632, 4.82749, -0.902837>, <-0.702586, 0.220344, 0.676625>, <-0.253632, 4.84291, -0.91152> , <-0.703273, 0.397532, 0.589386> }
	smooth_triangle { <-0.253632, 4.82749, -0.902837>, <-0.702586, 0.220344, 0.676625>, <-0.269265, 4.83416, -0.924477>, <-0.703273, 0.397532, 0.589386>, <-0.269265, 4.82263, -0.917694> , <-0.702586, 0.220344, 0.676625> }
	smooth_triangle { <-0.269265, 4.82263, -0.917694>, <-0.702586, 0.220344, 0.676625>, <-0.253632, 4.74546, -0.894943>, <-0.583437, -0.0338937, 0.811451>, <-0.253632, 4.82749, -0.902837> , <-0.702586, 0.220344, 0.676625> }
	smooth_triangle { <-0.253632, 4.74546, -0.894943>, <-0.583437, -0.0338937, 0.811451>, <-0.269265, 4.82263, -0.917694>, <-0.702586, 0.220344, 0.676625>, <-0.269265, 4.7487, -0.910234> , <-0.583437, -0.0338937, 0.811451> }
	smooth_triangle { <-0.269265, 4.73164, -0.912947>, <-0.459204, -0.139443, 0.877318>, <-0.253632, 4.74546, -0.894943>, <-0.583437, -0.0338937, 0.811451>, <-0.269265, 4.7487, -0.910234> , <-0.583437, -0.0338937, 0.811451> }
	smooth_triangle { <-0.253632, 4.74546, -0.894943>, <-0.583437, -0.0338937, 0.811451>, <-0.269265, 4.73164, -0.912947>, <-0.459204, -0.139443, 0.877318>, <-0.253632, 4.73053, -0.90494> , <-0.459204, -0.139443, 0.877318> }
	smooth_triangle { <-0.269265, 4.7201, -1.39586>, <0.0956131, -0.995135, 0.0237616>, <-0.253632, 4.73053, -0.90494>, <0.0956131, -0.995135, 0.0237616>, <-0.269265, 4.73164, -0.912947> , <0.0956131, -0.995135, 0.0237616> }
	smooth_triangle { <-0.253632, 4.73053, -0.90494>, <0.0956131, -0.995135, 0.0237616>, <-0.269265, 4.7201, -1.39586>, <0.0956131, -0.995135, 0.0237616>, <-0.253632, 4.72134, -1.40688> , <0.0956131, -0.995135, 0.0237616> }
	smooth_triangle { <-0.269265, 4.7201, -1.39586>, <-0.70608, 0.0112276, -0.708043>, <-0.253632, 4.80711, -1.41007>, <-0.706743, 0.0639563, -0.704574>, <-0.253632, 4.72134, -1.40688> , <-0.70608, 0.0112276, -0.708043> }
	smooth_triangle { <-0.253632, 4.80711, -1.41007>, <-0.706743, 0.0639563, -0.704574>, <-0.269265, 4.7201, -1.39586>, <-0.70608, 0.0112276, -0.708043>, <-0.269265, 4.80568, -1.3945> , <-0.706743, 0.0639563, -0.704574> }
	smooth_triangle { <-0.253632, 4.80711, -1.41007>, <-0.706743, 0.0639563, -0.704574>, <-0.269265, 4.83416, -1.38976>, <-0.706839, 0.183207, -0.683238>, <-0.253632, 4.83821, -1.40486> , <-0.706839, 0.183207, -0.683238> }
	smooth_triangle { <-0.269265, 4.83416, -1.38976>, <-0.706839, 0.183207, -0.683238>, <-0.253632, 4.80711, -1.41007>, <-0.706743, 0.0639563, -0.704574>, <-0.269265, 4.80568, -1.3945> , <-0.706743, 0.0639563, -0.704574> }
	smooth_triangle { <-0.253632, 4.83821, -1.40486>, <-0.706839, 0.183207, -0.683238>, <-0.269265, 4.85044, -1.38365>, <-0.70684, 0.319705, -0.631004>, <-0.253632, 4.85751, -1.3976> , <-0.70684, 0.319705, -0.631004> }
	smooth_triangle { <-0.269265, 4.85044, -1.38365>, <-0.70684, 0.319705, -0.631004>, <-0.253632, 4.83821, -1.40486>, <-0.706839, 0.183207, -0.683238>, <-0.269265, 4.83416, -1.38976> , <-0.706839, 0.183207, -0.683238> }
	smooth_triangle { <-0.253632, 4.85751, -1.3976>, <-0.70684, 0.319705, -0.631004>, <-0.269265, 4.86808, -1.37212>, <-0.707316, 0.456164, -0.540018>, <-0.253632, 4.87817, -1.38406> , <-0.707316, 0.456164, -0.540018> }
	smooth_triangle { <-0.269265, 4.86808, -1.37212>, <-0.707316, 0.456164, -0.540018>, <-0.253632, 4.85751, -1.3976>, <-0.70684, 0.319705, -0.631004>, <-0.269265, 4.85044, -1.38365> , <-0.70684, 0.319705, -0.631004> }
	smooth_triangle { <-0.253632, 4.87817, -1.38406>, <-0.707316, 0.456164, -0.540018>, <-0.269265, 4.88503, -1.35381>, <-0.706278, 0.569947, -0.419919>, <-0.253632, 4.89762, -1.36308> , <-0.706278, 0.569947, -0.419919> }
	smooth_triangle { <-0.269265, 4.88503, -1.35381>, <-0.706278, 0.569947, -0.419919>, <-0.253632, 4.87817, -1.38406>, <-0.707316, 0.456164, -0.540018>, <-0.269265, 4.86808, -1.37212> , <-0.707316, 0.456164, -0.540018> }
	smooth_triangle { <-0.253632, 4.89762, -1.36308>, <-0.706278, 0.569947, -0.419919>, <-0.269265, 4.89521, -1.33617>, <-0.708163, 0.656598, -0.259585>, <-0.253632, 4.90974, -1.34192> , <-0.708163, 0.656598, -0.259585> }
	smooth_triangle { <-0.269265, 4.89521, -1.33617>, <-0.708163, 0.656598, -0.259585>, <-0.253632, 4.89762, -1.36308>, <-0.706278, 0.569947, -0.419919>, <-0.269265, 4.88503, -1.35381> , <-0.706278, 0.569947, -0.419919> }
	smooth_triangle { <-0.253632, 4.90974, -1.34192>, <-0.708163, 0.656598, -0.259585>, <-0.269265, 4.89995, -1.31583>, <-0.707211, 0.700808, -0.0933834>, <-0.253632, 4.91545, -1.31789> , <-0.707211, 0.700808, -0.0933834> }
	smooth_triangle { <-0.269265, 4.89995, -1.31583>, <-0.707211, 0.700808, -0.0933834>, <-0.253632, 4.90974, -1.34192>, <-0.708163, 0.656598, -0.259585>, <-0.269265, 4.89521, -1.33617> , <-0.708163, 0.656598, -0.259585> }
	smooth_triangle { <-0.253632, 4.91624, -1.29601>, <-0.706666, 0.706547, 0.0376035>, <-0.269265, 4.89995, -1.31583>, <-0.707211, 0.700808, -0.0933834>, <-0.269265, 4.90063, -1.29684> , <-0.706666, 0.706547, 0.0376035> }
	smooth_triangle { <-0.269265, 4.89995, -1.31583>, <-0.707211, 0.700808, -0.0933834>, <-0.253632, 4.91624, -1.29601>, <-0.706666, 0.706547, 0.0376035>, <-0.253632, 4.91545, -1.31789> , <-0.707211, 0.700808, -0.0933834> }
	smooth_triangle { <-0.269265, 4.90063, -1.29684>, <-0.706666, 0.706547, 0.0376035>, <-0.253632, 4.91305, -1.27391>, <-0.705219, 0.686141, 0.17854>, <-0.253632, 4.91624, -1.29601> , <-0.706666, 0.706547, 0.0376035> }
	smooth_triangle { <-0.253632, 4.91305, -1.27391>, <-0.705219, 0.686141, 0.17854>, <-0.269265, 4.90063, -1.29684>, <-0.706666, 0.706547, 0.0376035>, <-0.269265, 4.89792, -1.27784> , <-0.705219, 0.686141, 0.17854> }
	smooth_triangle { <-0.269265, 4.89792, -1.27784>, <-0.705219, 0.686141, 0.17854>, <-0.253632, 4.87734, -1.1814>, <-0.708266, 0.694074, 0.128918>, <-0.253632, 4.91305, -1.27391> , <-0.705219, 0.686141, 0.17854> }
	smooth_triangle { <-0.253632, 4.87734, -1.1814>, <-0.708266, 0.694074, 0.128918>, <-0.269265, 4.89792, -1.27784>, <-0.705219, 0.686141, 0.17854>, <-0.269265, 4.86197, -1.18425> , <-0.708266, 0.694074, 0.128918> }
	smooth_triangle { <-0.253632, 4.87734, -1.1814>, <-0.708266, 0.694074, 0.128918>, <-0.269265, 4.86197, -1.15779>, <-0.706068, 0.700895, -0.101068>, <-0.253632, 4.87745, -1.16002> , <-0.706068, 0.700895, -0.101068> }
	smooth_triangle { <-0.269265, 4.86197, -1.15779>, <-0.706068, 0.700895, -0.101068>, <-0.253632, 4.87734, -1.1814>, <-0.708266, 0.694074, 0.128918>, <-0.269265, 4.86197, -1.18425> , <-0.708266, 0.694074, 0.128918> }
	smooth_triangle { <-0.253632, 4.87745, -1.16002>, <-0.706068, 0.700895, -0.101068>, <-0.269265, 4.86536, -1.14626>, <-0.708437, 0.631014, -0.316131>, <-0.253632, 4.87934, -1.15327> , <-0.708437, 0.631014, -0.316131> }
	smooth_triangle { <-0.269265, 4.86536, -1.14626>, <-0.708437, 0.631014, -0.316131>, <-0.253632, 4.87745, -1.16002>, <-0.706068, 0.700895, -0.101068>, <-0.269265, 4.86197, -1.15779> , <-0.706068, 0.700895, -0.101068> }
	smooth_triangle { <-0.253632, 4.87934, -1.15327>, <-0.708437, 0.631014, -0.316131>, <-0.269265, 4.87757, -1.12999>, <-0.699434, 0.510918, -0.499755>, <-0.253632, 4.88876, -1.1409> , <-0.699434, 0.510918, -0.499755> }
	smooth_triangle { <-0.269265, 4.87757, -1.12999>, <-0.699434, 0.510918, -0.499755>, <-0.253632, 4.87934, -1.15327>, <-0.708437, 0.631014, -0.316131>, <-0.269265, 4.86536, -1.14626> , <-0.708437, 0.631014, -0.316131> }
	smooth_triangle { <-0.253632, 4.88876, -1.1409>, <-0.699434, 0.510918, -0.499755>, <-0.269265, 4.89046, -1.11981>, <-0.655838, 0.245162, -0.713983>, <-0.253632, 4.89582, -1.1345> , <-0.655838, 0.245162, -0.713983> }
	smooth_triangle { <-0.269265, 4.89046, -1.11981>, <-0.655838, 0.245162, -0.713983>, <-0.253632, 4.88876, -1.1409>, <-0.699434, 0.510918, -0.499755>, <-0.269265, 4.87757, -1.12999> , <-0.699434, 0.510918, -0.499755> }
	smooth_triangle { <-0.253632, 4.89582, -1.1345>, <-0.655838, 0.245162, -0.713983>, <-0.268987, 5.03903, -1.11538>, <-0.581184, 0.0253757, -0.813376>, <-0.253632, 5.03937, -1.12634> , <-0.581184, 0.0253757, -0.813376> }
	smooth_triangle { <-0.268987, 5.03903, -1.11538>, <-0.581184, 0.0253757, -0.813376>, <-0.253632, 4.89582, -1.1345>, <-0.655838, 0.245162, -0.713983>, <-0.269265, 4.89046, -1.11981> , <-0.655838, 0.245162, -0.713983> }
	smooth_triangle { <0.243762, 5.03561, -1.12868>, <-0.581158, -0.0253748, 0.813395>, <0.259395, 4.8867, -1.12216>, <-0.65582, -0.245168, 0.713998>, <0.259118, 5.03528, -1.11772> , <-0.581158, -0.0253748, 0.813395> }
	smooth_triangle { <0.259395, 4.8867, -1.12216>, <-0.65582, -0.245168, 0.713998>, <0.243762, 5.03561, -1.12868>, <-0.581158, -0.0253748, 0.813395>, <0.243762, 4.89207, -1.13684> , <-0.65582, -0.245168, 0.713998> }
	smooth_triangle { <0.243762, 4.88501, -1.14325>, <-0.699423, -0.510918, 0.49977>, <0.259395, 4.8867, -1.12216>, <-0.65582, -0.245168, 0.713998>, <0.243762, 4.89207, -1.13684> , <-0.65582, -0.245168, 0.713998> }
	smooth_triangle { <0.259395, 4.8867, -1.12216>, <-0.65582, -0.245168, 0.713998>, <0.243762, 4.88501, -1.14325>, <-0.699423, -0.510918, 0.49977>, <0.259395, 4.87382, -1.13233> , <-0.699423, -0.510918, 0.49977> }
	smooth_triangle { <0.243762, 4.87558, -1.15562>, <-0.70844, -0.630998, 0.316155>, <0.259395, 4.87382, -1.13233>, <-0.699423, -0.510918, 0.49977>, <0.243762, 4.88501, -1.14325> , <-0.699423, -0.510918, 0.49977> }
	smooth_triangle { <0.259395, 4.87382, -1.13233>, <-0.699423, -0.510918, 0.49977>, <0.243762, 4.87558, -1.15562>, <-0.70844, -0.630998, 0.316155>, <0.259395, 4.86161, -1.14861> , <-0.70844, -0.630998, 0.316155> }
	smooth_triangle { <0.243762, 4.87369, -1.16237>, <-0.706081, -0.70088, 0.10108>, <0.259395, 4.86161, -1.14861>, <-0.70844, -0.630998, 0.316155>, <0.243762, 4.87558, -1.15562> , <-0.70844, -0.630998, 0.316155> }
	smooth_triangle { <0.259395, 4.86161, -1.14861>, <-0.70844, -0.630998, 0.316155>, <0.243762, 4.87369, -1.16237>, <-0.706081, -0.70088, 0.10108>, <0.259395, 4.85822, -1.16014> , <-0.706081, -0.70088, 0.10108> }
	smooth_triangle { <0.243762, 4.87359, -1.18374>, <-0.708282, -0.694058, -0.128918>, <0.259395, 4.85822, -1.16014>, <-0.706081, -0.70088, 0.10108>, <0.243762, 4.87369, -1.16237> , <-0.706081, -0.70088, 0.10108> }
	smooth_triangle { <0.259395, 4.85822, -1.16014>, <-0.706081, -0.70088, 0.10108>, <0.243762, 4.87359, -1.18374>, <-0.708282, -0.694058, -0.128918>, <0.259395, 4.85822, -1.18659> , <-0.708282, -0.694058, -0.128918> }
	smooth_triangle { <0.259395, 4.89417, -1.28019>, <-0.705219, -0.686143, -0.178536>, <0.243762, 4.87359, -1.18374>, <-0.708282, -0.694058, -0.128918>, <0.243762, 4.90929, -1.27626> , <-0.705219, -0.686143, -0.178536> }
	smooth_triangle { <0.243762, 4.87359, -1.18374>, <-0.708282, -0.694058, -0.128918>, <0.259395, 4.89417, -1.28019>, <-0.705219, -0.686143, -0.178536>, <0.259395, 4.85822, -1.18659> , <-0.708282, -0.694058, -0.128918> }
	smooth_triangle { <0.259395, 4.89688, -1.29918>, <-0.706655, -0.706559, -0.0375902>, <0.243762, 4.90929, -1.27626>, <-0.705219, -0.686143, -0.178536>, <0.243762, 4.91249, -1.29835> , <-0.706655, -0.706559, -0.0375902> }
	smooth_triangle { <0.243762, 4.90929, -1.27626>, <-0.705219, -0.686143, -0.178536>, <0.259395, 4.89688, -1.29918>, <-0.706655, -0.706559, -0.0375902>, <0.259395, 4.89417, -1.28019> , <-0.705219, -0.686143, -0.178536> }
	smooth_triangle { <0.243762, 4.91249, -1.29835>, <-0.706655, -0.706559, -0.0375902>, <0.259395, 4.8962, -1.31817>, <-0.70721, -0.700809, 0.0933844>, <0.259395, 4.89688, -1.29918> , <-0.706655, -0.706559, -0.0375902> }
	smooth_triangle { <0.259395, 4.8962, -1.31817>, <-0.70721, -0.700809, 0.0933844>, <0.243762, 4.91249, -1.29835>, <-0.706655, -0.706559, -0.0375902>, <0.243762, 4.91169, -1.32024> , <-0.70721, -0.700809, 0.0933844> }
	smooth_triangle { <0.243762, 4.90599, -1.34426>, <-0.708171, -0.656588, 0.259588>, <0.259395, 4.8962, -1.31817>, <-0.70721, -0.700809, 0.0933844>, <0.243762, 4.91169, -1.32024> , <-0.70721, -0.700809, 0.0933844> }
	smooth_triangle { <0.259395, 4.8962, -1.31817>, <-0.70721, -0.700809, 0.0933844>, <0.243762, 4.90599, -1.34426>, <-0.708171, -0.656588, 0.259588>, <0.259395, 4.89145, -1.33852> , <-0.708171, -0.656588, 0.259588> }
	smooth_triangle { <0.243762, 4.89386, -1.36543>, <-0.706287, -0.56994, 0.419914>, <0.259395, 4.89145, -1.33852>, <-0.708171, -0.656588, 0.259588>, <0.243762, 4.90599, -1.34426> , <-0.708171, -0.656588, 0.259588> }
	smooth_triangle { <0.259395, 4.89145, -1.33852>, <-0.708171, -0.656588, 0.259588>, <0.243762, 4.89386, -1.36543>, <-0.706287, -0.56994, 0.419914>, <0.259395, 4.88128, -1.35615> , <-0.706287, -0.56994, 0.419914> }
	smooth_triangle { <0.243762, 4.87441, -1.38641>, <-0.707309, -0.456175, 0.540018>, <0.259395, 4.88128, -1.35615>, <-0.706287, -0.56994, 0.419914>, <0.243762, 4.89386, -1.36543> , <-0.706287, -0.56994, 0.419914> }
	smooth_triangle { <0.259395, 4.88128, -1.35615>, <-0.706287, -0.56994, 0.419914>, <0.243762, 4.87441, -1.38641>, <-0.707309, -0.456175, 0.540018>, <0.259395, 4.86432, -1.37447> , <-0.707309, -0.456175, 0.540018> }
	smooth_triangle { <0.243762, 4.85375, -1.39994>, <-0.706835, -0.3197, 0.631012>, <0.259395, 4.86432, -1.37447>, <-0.707309, -0.456175, 0.540018>, <0.243762, 4.87441, -1.38641> , <-0.707309, -0.456175, 0.540018> }
	smooth_triangle { <0.259395, 4.86432, -1.37447>, <-0.707309, -0.456175, 0.540018>, <0.243762, 4.85375, -1.39994>, <-0.706835, -0.3197, 0.631012>, <0.259395, 4.84669, -1.386> , <-0.706835, -0.3197, 0.631012> }
	smooth_triangle { <0.243762, 4.83446, -1.4072>, <-0.706858, -0.183207, 0.683218>, <0.259395, 4.84669, -1.386>, <-0.706835, -0.3197, 0.631012>, <0.243762, 4.85375, -1.39994> , <-0.706835, -0.3197, 0.631012> }
	smooth_triangle { <0.259395, 4.84669, -1.386>, <-0.706835, -0.3197, 0.631012>, <0.243762, 4.83446, -1.4072>, <-0.706858, -0.183207, 0.683218>, <0.259395, 4.83041, -1.3921> , <-0.706858, -0.183207, 0.683218> }
	smooth_triangle { <0.243762, 4.80336, -1.41242>, <-0.706756, -0.0639618, 0.70456>, <0.259395, 4.83041, -1.3921>, <-0.706858, -0.183207, 0.683218>, <0.243762, 4.83446, -1.4072> , <-0.706858, -0.183207, 0.683218> }
	smooth_triangle { <0.259395, 4.83041, -1.3921>, <-0.706858, -0.183207, 0.683218>, <0.243762, 4.80336, -1.41242>, <-0.706756, -0.0639618, 0.70456>, <0.259395, 4.80192, -1.39685> , <-0.706756, -0.0639618, 0.70456> }
	smooth_triangle { <0.243762, 4.80336, -1.41242>, <-0.706756, -0.0639618, 0.70456>, <0.259395, 4.71635, -1.39821>, <-0.70608, -0.0112198, 0.708043>, <0.259395, 4.80192, -1.39685> , <-0.706756, -0.0639618, 0.70456> }
	smooth_triangle { <0.259395, 4.71635, -1.39821>, <-0.70608, -0.0112198, 0.708043>, <0.243762, 4.80336, -1.41242>, <-0.706756, -0.0639618, 0.70456>, <0.243762, 4.71759, -1.40923> , <-0.70608, -0.0112198, 0.708043> }
	smooth_triangle { <0.259395, 4.71635, -1.39821>, <0.0956433, 0.995132, -0.0237595>, <0.243762, 4.72678, -0.907287>, <0.0956433, 0.995132, -0.0237595>, <0.259395, 4.72788, -0.915293> , <0.0956433, 0.995132, -0.0237595> }
	smooth_triangle { <0.243762, 4.72678, -0.907287>, <0.0956433, 0.995132, -0.0237595>, <0.259395, 4.71635, -1.39821>, <0.0956433, 0.995132, -0.0237595>, <0.243762, 4.71759, -1.40923> , <0.0956433, 0.995132, -0.0237595> }
	smooth_triangle { <0.259395, 4.72788, -0.915293>, <-0.459153, 0.139388, -0.877354>, <0.243762, 4.7417, -0.89729>, <-0.583411, 0.0338653, -0.811471>, <0.259395, 4.74495, -0.912581> , <-0.583411, 0.0338653, -0.811471> }
	smooth_triangle { <0.243762, 4.7417, -0.89729>, <-0.583411, 0.0338653, -0.811471>, <0.259395, 4.72788, -0.915293>, <-0.459153, 0.139388, -0.877354>, <0.243762, 4.72678, -0.907287> , <-0.459153, 0.139388, -0.877354> }
	smooth_triangle { <0.243762, 4.7417, -0.89729>, <-0.583411, 0.0338653, -0.811471>, <0.259395, 4.81888, -0.920041>, <-0.702587, -0.220327, -0.676629>, <0.259395, 4.74495, -0.912581> , <-0.583411, 0.0338653, -0.811471> }
	smooth_triangle { <0.259395, 4.81888, -0.920041>, <-0.702587, -0.220327, -0.676629>, <0.243762, 4.7417, -0.89729>, <-0.583411, 0.0338653, -0.811471>, <0.243762, 4.82374, -0.905184> , <-0.702587, -0.220327, -0.676629> }
	smooth_triangle { <0.259395, 4.83041, -0.926823>, <-0.703268, -0.397513, -0.589404>, <0.243762, 4.82374, -0.905184>, <-0.702587, -0.220327, -0.676629>, <0.243762, 4.83915, -0.913867> , <-0.703268, -0.397513, -0.589404> }
	smooth_triangle { <0.243762, 4.82374, -0.905184>, <-0.702587, -0.220327, -0.676629>, <0.259395, 4.83041, -0.926823>, <-0.703268, -0.397513, -0.589404>, <0.259395, 4.81888, -0.920041> , <-0.702587, -0.220327, -0.676629> }
	smooth_triangle { <0.259395, 4.84804, -0.940388>, <-0.710193, -0.530817, -0.462449>, <0.243762, 4.83915, -0.913867>, <-0.703268, -0.397513, -0.589404>, <0.243762, 4.85982, -0.93011> , <-0.710193, -0.530817, -0.462449> }
	smooth_triangle { <0.243762, 4.83915, -0.913867>, <-0.703268, -0.397513, -0.589404>, <0.259395, 4.84804, -0.940388>, <-0.710193, -0.530817, -0.462449>, <0.259395, 4.83041, -0.926823> , <-0.703268, -0.397513, -0.589404> }
	smooth_triangle { <0.259395, 4.85416, -0.951066>, <-0.725666, -0.35663, -0.588408>, <0.243762, 4.85982, -0.93011>, <-0.710193, -0.530817, -0.462449>, <0.243762, 4.86245, -0.937812> , <-0.725666, -0.35663, -0.588408> }
	smooth_triangle { <0.243762, 4.85982, -0.93011>, <-0.710193, -0.530817, -0.462449>, <0.259395, 4.85416, -0.951066>, <-0.725666, -0.35663, -0.588408>, <0.259395, 4.84804, -0.940388> , <-0.710193, -0.530817, -0.462449> }
	smooth_triangle { <0.243762, 4.86245, -0.937812>, <-0.725666, -0.35663, -0.588408>, <0.258842, 5.03851, -0.962692>, <-0.660952, -0.0492051, -0.748813>, <0.259395, 4.85416, -0.951066> , <-0.725666, -0.35663, -0.588408> }
	smooth_triangle { <0.258842, 5.03851, -0.962692>, <-0.660952, -0.0492051, -0.748813>, <0.243762, 4.86245, -0.937812>, <-0.725666, -0.35663, -0.588408>, <0.243762, 5.03838, -0.952103> , <-0.660952, -0.0492051, -0.748813> }
	smooth_triangle { <0.243762, 5.03838, -0.952103>, <0.0235658, -0.999504, 0.020913>, <0.259118, 5.03528, -1.11772>, <0.0235658, -0.999504, 0.020913>, <0.258842, 5.03851, -0.962692> , <0.0235658, -0.999504, 0.020913> }
	smooth_triangle { <0.259118, 5.03528, -1.11772>, <0.0235658, -0.999504, 0.020913>, <0.243762, 5.03838, -0.952103>, <0.0235658, -0.999504, 0.020913>, <0.243762, 5.03561, -1.12868> , <0.0235658, -0.999504, 0.020913> }
	smooth_triangle { <0.243762, 5.03838, -0.952103>, <1, 0, 0>, <0.243762, 4.89207, -1.13684>, <1, 0, 0>, <0.243762, 5.03561, -1.12868> , <1, 0, 0> }
	smooth_triangle { <0.243762, 5.03838, -0.952103>, <1, 0, 0>, <0.243762, 4.88501, -1.14325>, <1, 0, 0>, <0.243762, 4.89207, -1.13684> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.87369, -1.16237>, <1, 0, 0>, <0.243762, 4.86245, -0.937812>, <1, 0, 0>, <0.243762, 4.87359, -1.18374> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.87558, -1.15562>, <1, 0, 0>, <0.243762, 4.86245, -0.937812>, <1, 0, 0>, <0.243762, 4.87369, -1.16237> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.88501, -1.14325>, <1, 0, 0>, <0.243762, 4.86245, -0.937812>, <1, 0, 0>, <0.243762, 4.87558, -1.15562> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.86245, -0.937812>, <1, 0, 0>, <0.243762, 4.88501, -1.14325>, <1, 0, 0>, <0.243762, 5.03838, -0.952103> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.90929, -1.27626>, <1, 0, 0>, <0.243762, 4.91169, -1.32024>, <1, 0, 0>, <0.243762, 4.91249, -1.29835> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.90929, -1.27626>, <1, 0, 0>, <0.243762, 4.90599, -1.34426>, <1, 0, 0>, <0.243762, 4.91169, -1.32024> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.90929, -1.27626>, <1, 0, 0>, <0.243762, 4.89386, -1.36543>, <1, 0, 0>, <0.243762, 4.90599, -1.34426> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.90929, -1.27626>, <1, 0, 0>, <0.243762, 4.87441, -1.38641>, <1, 0, 0>, <0.243762, 4.89386, -1.36543> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.87359, -1.18374>, <1, 0, 0>, <0.243762, 4.87441, -1.38641>, <1, 0, 0>, <0.243762, 4.90929, -1.27626> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.86245, -0.937812>, <1, 0, 0>, <0.243762, 4.87441, -1.38641>, <1, 0, 0>, <0.243762, 4.87359, -1.18374> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.85982, -0.93011>, <1, 0, 0>, <0.243762, 4.87441, -1.38641>, <1, 0, 0>, <0.243762, 4.86245, -0.937812> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.85982, -0.93011>, <1, 0, 0>, <0.243762, 4.85375, -1.39994>, <1, 0, 0>, <0.243762, 4.87441, -1.38641> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.83915, -0.913867>, <1, 0, 0>, <0.243762, 4.85375, -1.39994>, <1, 0, 0>, <0.243762, 4.85982, -0.93011> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.83915, -0.913867>, <1, 0, 0>, <0.243762, 4.83446, -1.4072>, <1, 0, 0>, <0.243762, 4.85375, -1.39994> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.82374, -0.905184>, <1, 0, 0>, <0.243762, 4.83446, -1.4072>, <1, 0, 0>, <0.243762, 4.83915, -0.913867> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.82374, -0.905184>, <1, 0, 0>, <0.243762, 4.80336, -1.41242>, <1, 0, 0>, <0.243762, 4.83446, -1.4072> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.7417, -0.89729>, <1, 0, 0>, <0.243762, 4.80336, -1.41242>, <1, 0, 0>, <0.243762, 4.82374, -0.905184> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.72678, -0.907287>, <1, 0, 0>, <0.243762, 4.80336, -1.41242>, <1, 0, 0>, <0.243762, 4.7417, -0.89729> , <1, 0, 0> }
	smooth_triangle { <0.243762, 4.80336, -1.41242>, <1, 0, 0>, <0.243762, 4.72678, -0.907287>, <1, 0, 0>, <0.243762, 4.71759, -1.40923> , <1, 0, 0> }
	smooth_triangle { <0.258842, 5.03851, -0.962692>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.8867, -1.12216>, <0.999994, 0.00310787, 0.00171538>, <0.259118, 5.03528, -1.11772> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.258842, 5.03851, -0.962692>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.87382, -1.13233>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.8867, -1.12216> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.85822, -1.16014>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85416, -0.951066>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85822, -1.18659> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.86161, -1.14861>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85416, -0.951066>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85822, -1.16014> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.87382, -1.13233>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85416, -0.951066>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.86161, -1.14861> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.85416, -0.951066>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.87382, -1.13233>, <0.999994, 0.00310787, 0.00171538>, <0.258842, 5.03851, -0.962692> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.89417, -1.28019>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.8962, -1.31817>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.89688, -1.29918> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.89417, -1.28019>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.89145, -1.33852>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.8962, -1.31817> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.89417, -1.28019>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.88128, -1.35615>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.89145, -1.33852> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.89417, -1.28019>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.86432, -1.37447>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.88128, -1.35615> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.85822, -1.18659>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.86432, -1.37447>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.89417, -1.28019> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.84804, -0.940388>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85822, -1.18659>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85416, -0.951066> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.84804, -0.940388>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.86432, -1.37447>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.85822, -1.18659> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.84804, -0.940388>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.84669, -1.386>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.86432, -1.37447> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.83041, -0.926823>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.84669, -1.386>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.84804, -0.940388> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.83041, -0.926823>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.83041, -1.3921>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.84669, -1.386> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.81888, -0.920041>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.83041, -1.3921>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.83041, -0.926823> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.81888, -0.920041>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.80192, -1.39685>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.83041, -1.3921> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.74495, -0.912581>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.80192, -1.39685>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.81888, -0.920041> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.72788, -0.915293>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.80192, -1.39685>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.74495, -0.912581> , <0.999994, 0.00310787, 0.00171538> }
	smooth_triangle { <0.259395, 4.80192, -1.39685>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.72788, -0.915293>, <0.999994, 0.00310787, 0.00171538>, <0.259395, 4.71635, -1.39821> , <0.999994, 0.00310787, 0.00171538> }
texture { RedPlastic }
}

// object Head1
union {
	smooth_triangle { <-0.0393501, 5.75684, -1.46207>, <-1, 4.32861e-006, 1.14321e-006>, <-0.0380941, 5.74878, -1.36148>, <-0.965931, 0.254869, 0.0449394>, <-0.0380941, 5.76623, -1.46042> , <-0.965931, 0.254869, 0.0449394> }
	smooth_triangle { <-0.0380941, 5.74878, -1.36148>, <-0.965931, 0.254869, 0.0449394>, <-0.0393501, 5.75684, -1.46207>, <-1, 4.32861e-006, 1.14321e-006>, <-0.0393501, 5.73939, -1.36313> , <-1, 4.32861e-006, 1.14321e-006> }
	smooth_triangle { <-0.0539385, 5.77112, -1.46372>, <-0.351167, -0.0690955, 0.93376>, <-0.0393501, 5.75684, -1.46207>, <-0.242558, -0.168509, 0.95539>, <-0.0380941, 5.76623, -1.46042> , <-0.23429, -0.106629, 0.966301> }
	smooth_triangle { <-0.0393501, 5.75684, -1.46207>, <-0.242558, -0.168509, 0.95539>, <-0.0539385, 5.77112, -1.46372>, <-0.351167, -0.0690955, 0.93376>, <-0.0557528, 5.75755, -1.46611> , <-0.363544, -0.161784, 0.917421> }
	smooth_triangle { <-0.0757234, 5.779, -1.47482>, <-0.552538, 0.00338332, 0.833481>, <-0.0557528, 5.75755, -1.46611>, <-0.363544, -0.161784, 0.917421>, <-0.0539385, 5.77112, -1.46372> , <-0.351167, -0.0690955, 0.93376> }
	smooth_triangle { <-0.0557528, 5.75755, -1.46611>, <-0.363544, -0.161784, 0.917421>, <-0.0757234, 5.779, -1.47482>, <-0.552538, 0.00338332, 0.833481>, <-0.078307, 5.75968, -1.47822> , <-0.572033, -0.142426, 0.80777> }
	smooth_triangle { <-0.0915677, 5.78568, -1.48821>, <-0.708186, 0.068791, 0.702667>, <-0.078307, 5.75968, -1.47822>, <-0.572033, -0.142426, 0.80777>, <-0.0757234, 5.779, -1.47482> , <-0.552538, 0.00338332, 0.833481> }
	smooth_triangle { <-0.078307, 5.75968, -1.47822>, <-0.572033, -0.142426, 0.80777>, <-0.0915677, 5.78568, -1.48821>, <-0.708186, 0.068791, 0.702667>, <-0.0947091, 5.76218, -1.49236> , <-0.733168, -0.118092, 0.669715> }
	smooth_triangle { <-0.107012, 5.76502, -1.50851>, <-0.816342, -0.100298, 0.568793>, <-0.0915677, 5.78568, -1.48821>, <-0.708186, 0.068791, 0.702667>, <-0.103451, 5.79166, -1.50382> , <-0.78853, 0.10778, 0.605478> }
	smooth_triangle { <-0.0915677, 5.78568, -1.48821>, <-0.708186, 0.068791, 0.702667>, <-0.107012, 5.76502, -1.50851>, <-0.816342, -0.100298, 0.568793>, <-0.0947091, 5.76218, -1.49236> , <-0.733168, -0.118092, 0.669715> }
	smooth_triangle { <-0.123414, 5.7693, -1.53274>, <-0.892251, -0.0784097, 0.44468>, <-0.103451, 5.79166, -1.50382>, <-0.78853, 0.10778, 0.605478>, <-0.119294, 5.80011, -1.52731> , <-0.861847, 0.149015, 0.484783> }
	smooth_triangle { <-0.103451, 5.79166, -1.50382>, <-0.78853, 0.10778, 0.605478>, <-0.123414, 5.7693, -1.53274>, <-0.892251, -0.0784097, 0.44468>, <-0.107012, 5.76502, -1.50851> , <-0.816342, -0.100298, 0.568793> }
	smooth_triangle { <-0.131616, 5.77321, -1.55495>, <-0.976753, -0.0372233, 0.21111>, <-0.119294, 5.80011, -1.52731>, <-0.861847, 0.149015, 0.484783>, <-0.127217, 5.80612, -1.54915> , <-0.943475, 0.211738, 0.254996> }
	smooth_triangle { <-0.119294, 5.80011, -1.52731>, <-0.861847, 0.149015, 0.484783>, <-0.131616, 5.77321, -1.55495>, <-0.976753, -0.0372233, 0.21111>, <-0.123414, 5.7693, -1.53274> , <-0.892251, -0.0784097, 0.44468> }
	smooth_triangle { <-0.133667, 5.77749, -1.57918>, <-0.999136, -0.00721707, 0.040934>, <-0.127217, 5.80612, -1.54915>, <-0.943475, 0.211738, 0.254996>, <-0.129197, 5.81092, -1.57329> , <-0.965089, 0.247455, 0.085839> }
	smooth_triangle { <-0.127217, 5.80612, -1.54915>, <-0.943475, 0.211738, 0.254996>, <-0.133667, 5.77749, -1.57918>, <-0.999136, -0.00721707, 0.040934>, <-0.131616, 5.77321, -1.55495> , <-0.976753, -0.0372233, 0.21111> }
	smooth_triangle { <-0.133667, 5.78211, -1.60543>, <-0.997483, 0.0123115, -0.0698319>, <-0.129197, 5.81092, -1.57329>, <-0.965089, 0.247455, 0.085839>, <-0.129197, 5.81555, -1.59954> , <-0.963494, 0.266564, -0.0249781> }
	smooth_triangle { <-0.129197, 5.81092, -1.57329>, <-0.965089, 0.247455, 0.085839>, <-0.133667, 5.78211, -1.60543>, <-0.997483, 0.0123115, -0.0698319>, <-0.133667, 5.77749, -1.57918> , <-0.999136, -0.00721707, 0.040934> }
	smooth_triangle { <-0.129565, 5.7871, -1.6337>, <-0.979243, 0.035196, -0.199612>, <-0.129197, 5.81555, -1.59954>, <-0.963494, 0.266564, -0.0249781>, <-0.125236, 5.81948, -1.62799> , <-0.94588, 0.284779, -0.155604> }
	smooth_triangle { <-0.129197, 5.81555, -1.59954>, <-0.963494, 0.266564, -0.0249781>, <-0.129565, 5.7871, -1.6337>, <-0.979243, 0.035196, -0.199612>, <-0.133667, 5.78211, -1.60543> , <-0.997483, 0.0123115, -0.0698319> }
	smooth_triangle { <-0.123414, 5.79102, -1.65591>, <-0.919721, 0.0681708, -0.386609>, <-0.125236, 5.81948, -1.62799>, <-0.94588, 0.284779, -0.155604>, <-0.119294, 5.82183, -1.65048> , <-0.888376, 0.302576, -0.345306> }
	smooth_triangle { <-0.125236, 5.81948, -1.62799>, <-0.94588, 0.284779, -0.155604>, <-0.123414, 5.79102, -1.65591>, <-0.919721, 0.0681708, -0.386609>, <-0.129565, 5.7871, -1.6337> , <-0.979243, 0.035196, -0.199612> }
	smooth_triangle { <-0.111113, 5.79458, -1.67611>, <-0.769676, 0.110856, -0.628737>, <-0.119294, 5.82183, -1.65048>, <-0.888376, 0.302576, -0.345306>, <-0.107412, 5.82226, -1.67122> , <-0.743443, 0.307045, -0.594152> }
	smooth_triangle { <-0.119294, 5.82183, -1.65048>, <-0.888376, 0.302576, -0.345306>, <-0.111113, 5.79458, -1.67611>, <-0.769676, 0.110856, -0.628737>, <-0.123414, 5.79102, -1.65591> , <-0.919721, 0.0681708, -0.386609> }
	smooth_triangle { <-0.0926593, 5.79742, -1.69226>, <-0.664349, 0.129773, -0.73607>, <-0.107412, 5.82226, -1.67122>, <-0.743443, 0.307045, -0.594152>, <-0.0895869, 5.8204, -1.68821> , <-0.641713, 0.299135, -0.706203> }
	smooth_triangle { <-0.107412, 5.82226, -1.67122>, <-0.743443, 0.307045, -0.594152>, <-0.0926593, 5.79742, -1.69226>, <-0.664349, 0.129773, -0.73607>, <-0.111113, 5.79458, -1.67611> , <-0.769676, 0.110856, -0.628737> }
	smooth_triangle { <-0.0380941, 5.76623, -1.46042>, <-0.965931, 0.254869, 0.0449394>, <-0.0344145, 5.75753, -1.35993>, <-0.866048, 0.492366, 0.0868155>, <-0.0344145, 5.77498, -1.45887> , <-0.866048, 0.492366, 0.0868155> }
	smooth_triangle { <-0.0344145, 5.75753, -1.35993>, <-0.866048, 0.492366, 0.0868155>, <-0.0380941, 5.76623, -1.46042>, <-0.965931, 0.254869, 0.0449394>, <-0.0380941, 5.74878, -1.36148> , <-0.965931, 0.254869, 0.0449394> }
	smooth_triangle { <-0.0486195, 5.78376, -1.46149>, <-0.314852, 0.0172288, 0.948984>, <-0.0380941, 5.76623, -1.46042>, <-0.23429, -0.106629, 0.966301>, <-0.0344145, 5.77498, -1.45887> , <-0.210057, -0.0490422, 0.976458> }
	smooth_triangle { <-0.0380941, 5.76623, -1.46042>, <-0.23429, -0.106629, 0.966301>, <-0.0486195, 5.78376, -1.46149>, <-0.314852, 0.0172288, 0.948984>, <-0.0539385, 5.77112, -1.46372> , <-0.351167, -0.0690955, 0.93376> }
	smooth_triangle { <-0.0681514, 5.79701, -1.47164>, <-0.495408, 0.139219, 0.857432>, <-0.0539385, 5.77112, -1.46372>, <-0.351167, -0.0690955, 0.93376>, <-0.0486195, 5.78376, -1.46149> , <-0.314852, 0.0172288, 0.948984> }
	smooth_triangle { <-0.0539385, 5.77112, -1.46372>, <-0.351167, -0.0690955, 0.93376>, <-0.0681514, 5.79701, -1.47164>, <-0.495408, 0.139219, 0.857432>, <-0.0757234, 5.779, -1.47482> , <-0.552538, 0.00338332, 0.833481> }
	smooth_triangle { <-0.0823571, 5.80758, -1.48435>, <-0.634948, 0.242913, 0.733372>, <-0.0757234, 5.779, -1.47482>, <-0.552538, 0.00338332, 0.833481>, <-0.0681514, 5.79701, -1.47164> , <-0.495408, 0.139219, 0.857432> }
	smooth_triangle { <-0.0757234, 5.779, -1.47482>, <-0.552538, 0.00338332, 0.833481>, <-0.0823571, 5.80758, -1.48435>, <-0.634948, 0.242913, 0.733372>, <-0.0915677, 5.78568, -1.48821> , <-0.708186, 0.068791, 0.702667> }
	smooth_triangle { <-0.103451, 5.79166, -1.50382>, <-0.78853, 0.10778, 0.605478>, <-0.0823571, 5.80758, -1.48435>, <-0.634948, 0.242913, 0.733372>, <-0.0930109, 5.81648, -1.49944> , <-0.706982, 0.301667, 0.639666> }
	smooth_triangle { <-0.0823571, 5.80758, -1.48435>, <-0.634948, 0.242913, 0.733372>, <-0.103451, 5.79166, -1.50382>, <-0.78853, 0.10778, 0.605478>, <-0.0915677, 5.78568, -1.48821> , <-0.708186, 0.068791, 0.702667> }
	smooth_triangle { <-0.119294, 5.80011, -1.52731>, <-0.861847, 0.149015, 0.484783>, <-0.0930109, 5.81648, -1.49944>, <-0.706982, 0.301667, 0.639666>, <-0.107216, 5.82883, -1.52225> , <-0.772717, 0.360931, 0.522146> }
	smooth_triangle { <-0.0930109, 5.81648, -1.49944>, <-0.706982, 0.301667, 0.639666>, <-0.119294, 5.80011, -1.52731>, <-0.861847, 0.149015, 0.484783>, <-0.103451, 5.79166, -1.50382> , <-0.78853, 0.10778, 0.605478> }
	smooth_triangle { <-0.127217, 5.80612, -1.54915>, <-0.943475, 0.211738, 0.254996>, <-0.107216, 5.82883, -1.52225>, <-0.772717, 0.360931, 0.522146>, <-0.114319, 5.83678, -1.54374> , <-0.845901, 0.443729, 0.295898> }
	smooth_triangle { <-0.107216, 5.82883, -1.52225>, <-0.772717, 0.360931, 0.522146>, <-0.127217, 5.80612, -1.54915>, <-0.943475, 0.211738, 0.254996>, <-0.119294, 5.80011, -1.52731> , <-0.861847, 0.149015, 0.484783> }
	smooth_triangle { <-0.129197, 5.81092, -1.57329>, <-0.965089, 0.247455, 0.085839>, <-0.114319, 5.83678, -1.54374>, <-0.845901, 0.443729, 0.295898>, <-0.116095, 5.84207, -1.5678> , <-0.865283, 0.484753, 0.127673> }
	smooth_triangle { <-0.114319, 5.83678, -1.54374>, <-0.845901, 0.443729, 0.295898>, <-0.129197, 5.81092, -1.57329>, <-0.965089, 0.247455, 0.085839>, <-0.127217, 5.80612, -1.54915> , <-0.943474, 0.211738, 0.254996> }
	smooth_triangle { <-0.129197, 5.81555, -1.59954>, <-0.963494, 0.266564, -0.0249781>, <-0.116095, 5.84207, -1.5678>, <-0.865283, 0.484753, 0.127673>, <-0.116095, 5.8467, -1.59405> , <-0.863847, 0.503474, 0.0167954> }
	smooth_triangle { <-0.116095, 5.84207, -1.5678>, <-0.865283, 0.484753, 0.127673>, <-0.129197, 5.81555, -1.59954>, <-0.963494, 0.266564, -0.0249781>, <-0.129197, 5.81092, -1.57329> , <-0.965089, 0.247455, 0.085839> }
	smooth_triangle { <-0.125236, 5.81948, -1.62799>, <-0.94588, 0.284779, -0.155604>, <-0.116095, 5.8467, -1.59405>, <-0.863847, 0.503474, 0.0167954>, <-0.112544, 5.84966, -1.62267> , <-0.848049, 0.51738, -0.114591> }
	smooth_triangle { <-0.116095, 5.8467, -1.59405>, <-0.863847, 0.503474, 0.0167954>, <-0.125236, 5.81948, -1.62799>, <-0.94588, 0.284779, -0.155604>, <-0.129197, 5.81555, -1.59954> , <-0.963494, 0.266564, -0.0249781> }
	smooth_triangle { <-0.119294, 5.82183, -1.65048>, <-0.888376, 0.302576, -0.345306>, <-0.112544, 5.84966, -1.62267>, <-0.848049, 0.51738, -0.114591>, <-0.107216, 5.85055, -1.64542> , <-0.796491, 0.52104, -0.30679> }
	smooth_triangle { <-0.112544, 5.84966, -1.62267>, <-0.848049, 0.51738, -0.114591>, <-0.119294, 5.82183, -1.65048>, <-0.888376, 0.302576, -0.345306>, <-0.125236, 5.81948, -1.62799> , <-0.94588, 0.284779, -0.155604> }
	smooth_triangle { <-0.107412, 5.82226, -1.67122>, <-0.743442, 0.307045, -0.594152>, <-0.107216, 5.85055, -1.64542>, <-0.796491, 0.52104, -0.30679>, <-0.0965617, 5.84805, -1.66668> , <-0.666556, 0.489856, -0.561912> }
	smooth_triangle { <-0.107216, 5.85055, -1.64542>, <-0.796491, 0.52104, -0.30679>, <-0.107412, 5.82226, -1.67122>, <-0.743442, 0.307045, -0.594152>, <-0.119294, 5.82183, -1.65048> , <-0.888376, 0.302576, -0.345306> }
	smooth_triangle { <-0.0895869, 5.8204, -1.68821>, <-0.641713, 0.299135, -0.706203>, <-0.0965617, 5.84805, -1.66668>, <-0.666556, 0.489856, -0.561912>, <-0.0805806, 5.84181, -1.68443> , <-0.575356, 0.456928, -0.678367> }
	smooth_triangle { <-0.0965617, 5.84805, -1.66668>, <-0.666556, 0.489856, -0.561912>, <-0.0895869, 5.8204, -1.68821>, <-0.641713, 0.299135, -0.706203>, <-0.107412, 5.82226, -1.67122> , <-0.743443, 0.307045, -0.594152> }
	smooth_triangle { <-0.0344145, 5.77498, -1.45887>, <-0.866048, 0.492366, 0.0868155>, <-0.0285597, 5.76504, -1.35861>, <-0.70708, 0.696391, 0.122792>, <-0.0285597, 5.78249, -1.45755> , <-0.70708, 0.696391, 0.122792> }
	smooth_triangle { <-0.0285597, 5.76504, -1.35861>, <-0.70708, 0.696391, 0.122792>, <-0.0344145, 5.77498, -1.45887>, <-0.866048, 0.492366, 0.0868155>, <-0.0344145, 5.75753, -1.35993> , <-0.866048, 0.492366, 0.0868155> }
	smooth_triangle { <-0.0401584, 5.79462, -1.45957>, <-0.257059, 0.0913854, 0.962065>, <-0.0344145, 5.77498, -1.45887>, <-0.210057, -0.0490422, 0.976458>, <-0.0285597, 5.78249, -1.45755> , <-0.171499, 0.000434578, 0.985184> }
	smooth_triangle { <-0.0344145, 5.77498, -1.45887>, <-0.210057, -0.0490422, 0.976458>, <-0.0401584, 5.79462, -1.45957>, <-0.257059, 0.0913854, 0.962065>, <-0.0486195, 5.78376, -1.46149> , <-0.314852, 0.0172288, 0.948984> }
	smooth_triangle { <-0.0561059, 5.81247, -1.46892>, <-0.404498, 0.255894, 0.878009>, <-0.0486195, 5.78376, -1.46149>, <-0.314852, 0.0172288, 0.948984>, <-0.0401584, 5.79462, -1.45957> , <-0.257059, 0.0913854, 0.962065> }
	smooth_triangle { <-0.0486195, 5.78376, -1.46149>, <-0.314852, 0.0172288, 0.948984>, <-0.0561059, 5.81247, -1.46892>, <-0.404498, 0.255894, 0.878009>, <-0.0681514, 5.79701, -1.47164> , <-0.495408, 0.139219, 0.857432> }
	smooth_triangle { <-0.0677045, 5.82638, -1.48104>, <-0.518447, 0.392454, 0.759732>, <-0.0681514, 5.79701, -1.47164>, <-0.495408, 0.139219, 0.857432>, <-0.0561059, 5.81247, -1.46892> , <-0.404498, 0.255894, 0.878009> }
	smooth_triangle { <-0.0681514, 5.79701, -1.47164>, <-0.495408, 0.139219, 0.857432>, <-0.0677045, 5.82638, -1.48104>, <-0.518447, 0.392454, 0.759732>, <-0.0823571, 5.80758, -1.48435> , <-0.634948, 0.242913, 0.733372> }
	smooth_triangle { <-0.0764039, 5.8378, -1.49568>, <-0.577248, 0.468182, 0.669022>, <-0.0823571, 5.80758, -1.48435>, <-0.634948, 0.242913, 0.733372>, <-0.0677045, 5.82638, -1.48104> , <-0.518447, 0.392454, 0.759732> }
	smooth_triangle { <-0.0823571, 5.80758, -1.48435>, <-0.634948, 0.242913, 0.733372>, <-0.0764039, 5.8378, -1.49568>, <-0.577248, 0.468182, 0.669022>, <-0.0930109, 5.81648, -1.49944> , <-0.706982, 0.301667, 0.639666> }
	smooth_triangle { <-0.107216, 5.82883, -1.52225>, <-0.772717, 0.360931, 0.522146>, <-0.0764039, 5.8378, -1.49568>, <-0.577248, 0.468182, 0.669022>, <-0.0880017, 5.85349, -1.5179> , <-0.630912, 0.542926, 0.55424> }
	smooth_triangle { <-0.0764039, 5.8378, -1.49568>, <-0.577248, 0.468182, 0.669022>, <-0.107216, 5.82883, -1.52225>, <-0.772717, 0.360931, 0.522146>, <-0.0930109, 5.81648, -1.49944> , <-0.706983, 0.301667, 0.639666> }
	smooth_triangle { <-0.114319, 5.83678, -1.54374>, <-0.845901, 0.443729, 0.295898>, <-0.0880017, 5.85349, -1.5179>, <-0.630912, 0.542926, 0.55424>, <-0.0938015, 5.86312, -1.5391> , <-0.690672, 0.64296, 0.331021> }
	smooth_triangle { <-0.0880017, 5.85349, -1.5179>, <-0.630912, 0.542926, 0.55424>, <-0.114319, 5.83678, -1.54374>, <-0.845901, 0.443729, 0.295898>, <-0.107216, 5.82883, -1.52225> , <-0.772717, 0.360931, 0.522146> }
	smooth_triangle { <-0.116095, 5.84207, -1.5678>, <-0.865283, 0.484753, 0.127673>, <-0.0938015, 5.86312, -1.5391>, <-0.690672, 0.64296, 0.331021>, <-0.095251, 5.86882, -1.56308> , <-0.706498, 0.688548, 0.163595> }
	smooth_triangle { <-0.0938015, 5.86312, -1.5391>, <-0.690672, 0.64296, 0.331021>, <-0.116095, 5.84207, -1.5678>, <-0.865283, 0.484753, 0.127673>, <-0.114319, 5.83678, -1.54374> , <-0.845901, 0.443729, 0.295898> }
	smooth_triangle { <-0.116095, 5.8467, -1.59405>, <-0.863847, 0.503474, 0.0167954>, <-0.095251, 5.86882, -1.56308>, <-0.706498, 0.688548, 0.163595>, <-0.095251, 5.87345, -1.58933> , <-0.705323, 0.706926, 0.0526704> }
	smooth_triangle { <-0.095251, 5.86882, -1.56308>, <-0.706498, 0.688548, 0.163595>, <-0.116095, 5.8467, -1.59405>, <-0.863847, 0.503474, 0.0167954>, <-0.116095, 5.84207, -1.5678> , <-0.865283, 0.484753, 0.127673> }
	smooth_triangle { <-0.112544, 5.84966, -1.62267>, <-0.848049, 0.51738, -0.114591>, <-0.095251, 5.87345, -1.58933>, <-0.705323, 0.706926, 0.0526704>, <-0.0923506, 5.87558, -1.6181> , <-0.692423, 0.717114, -0.0793625> }
	smooth_triangle { <-0.095251, 5.87345, -1.58933>, <-0.705323, 0.706926, 0.0526704>, <-0.112544, 5.84966, -1.62267>, <-0.848049, 0.51738, -0.114591>, <-0.116095, 5.8467, -1.59405> , <-0.863847, 0.503474, 0.0167954> }
	smooth_triangle { <-0.107216, 5.85055, -1.64542>, <-0.796491, 0.52104, -0.30679>, <-0.0923506, 5.87558, -1.6181>, <-0.692423, 0.717114, -0.0793625>, <-0.0880017, 5.87521, -1.64107> , <-0.650328, 0.70863, -0.27371> }
	smooth_triangle { <-0.0923506, 5.87558, -1.6181>, <-0.692423, 0.717114, -0.0793625>, <-0.107216, 5.85055, -1.64542>, <-0.796491, 0.52104, -0.30679>, <-0.112544, 5.84966, -1.62267> , <-0.848049, 0.51738, -0.114591> }
	smooth_triangle { <-0.0793034, 5.8702, -1.66277>, <-0.544238, 0.646838, -0.534233>, <-0.107216, 5.85055, -1.64542>, <-0.796491, 0.52104, -0.30679>, <-0.0880017, 5.87521, -1.64107> , <-0.650328, 0.70863, -0.27371> }
	smooth_triangle { <-0.107216, 5.85055, -1.64542>, <-0.796491, 0.52104, -0.30679>, <-0.0793034, 5.8702, -1.66277>, <-0.544238, 0.646838, -0.534233>, <-0.0965617, 5.84805, -1.66668> , <-0.666556, 0.489856, -0.561912> }
	smooth_triangle { <-0.0805806, 5.84181, -1.68443>, <-0.575356, 0.456928, -0.678367>, <-0.0793034, 5.8702, -1.66277>, <-0.544238, 0.646838, -0.534233>, <-0.0662547, 5.8602, -1.68119> , <-0.469776, 0.592437, -0.654468> }
	smooth_triangle { <-0.0793034, 5.8702, -1.66277>, <-0.544238, 0.646838, -0.534233>, <-0.0805806, 5.84181, -1.68443>, <-0.575356, 0.456928, -0.678367>, <-0.0965617, 5.84805, -1.66668> , <-0.666556, 0.489856, -0.561912> }
	smooth_triangle { <-0.0209298, 5.78826, -1.45653>, <-0.499971, 0.852885, 0.150386>, <-0.0285597, 5.76504, -1.35861>, <-0.70708, 0.696391, 0.122792>, <-0.0209298, 5.77081, -1.35759> , <-0.499971, 0.852885, 0.150386> }
	smooth_triangle { <-0.0285597, 5.76504, -1.35861>, <-0.70708, 0.696391, 0.122792>, <-0.0209298, 5.78826, -1.45653>, <-0.499971, 0.852885, 0.150386>, <-0.0285597, 5.78249, -1.45755> , <-0.70708, 0.696391, 0.122792> }
	smooth_triangle { <-0.0291312, 5.80296, -1.4581>, <-0.181769, 0.148291, 0.972096>, <-0.0285597, 5.78249, -1.45755>, <-0.171499, 0.000434578, 0.985184>, <-0.0209298, 5.78826, -1.45653> , <-0.121291, 0.0384033, 0.991874> }
	smooth_triangle { <-0.0285597, 5.78249, -1.45755>, <-0.171499, 0.000434578, 0.985184>, <-0.0291312, 5.80296, -1.4581>, <-0.181769, 0.148291, 0.972096>, <-0.0401584, 5.79462, -1.45957> , <-0.257059, 0.0913854, 0.962065> }
	smooth_triangle { <-0.0404082, 5.82433, -1.46683>, <-0.285999, 0.345437, 0.8938>, <-0.0401584, 5.79462, -1.45957>, <-0.257059, 0.0913854, 0.962065>, <-0.0291312, 5.80296, -1.4581> , <-0.181769, 0.148291, 0.972096> }
	smooth_triangle { <-0.0401584, 5.79462, -1.45957>, <-0.257059, 0.0913854, 0.962065>, <-0.0404082, 5.82433, -1.46683>, <-0.285999, 0.345437, 0.8938>, <-0.0561059, 5.81247, -1.46892> , <-0.404498, 0.255894, 0.878009> }
	smooth_triangle { <-0.0486098, 5.84081, -1.47849>, <-0.366577, 0.507224, 0.779965>, <-0.0561059, 5.81247, -1.46892>, <-0.404498, 0.255894, 0.878009>, <-0.0404082, 5.82433, -1.46683> , <-0.285999, 0.345437, 0.8938> }
	smooth_triangle { <-0.0561059, 5.81247, -1.46892>, <-0.404498, 0.255894, 0.878009>, <-0.0486098, 5.84081, -1.47849>, <-0.366577, 0.507224, 0.779965>, <-0.0677045, 5.82638, -1.48104> , <-0.518447, 0.392454, 0.759732> }
	smooth_triangle { <-0.0547605, 5.85415, -1.4928>, <-0.408153, 0.595955, 0.691555>, <-0.0677045, 5.82638, -1.48104>, <-0.518447, 0.392454, 0.759732>, <-0.0486098, 5.84081, -1.47849> , <-0.366577, 0.507224, 0.779965> }
	smooth_triangle { <-0.0677045, 5.82638, -1.48104>, <-0.518447, 0.392454, 0.759732>, <-0.0547605, 5.85415, -1.4928>, <-0.408153, 0.595955, 0.691555>, <-0.0764039, 5.8378, -1.49568> , <-0.577248, 0.468182, 0.669022> }
	smooth_triangle { <-0.062962, 5.87241, -1.51456>, <-0.446112, 0.682571, 0.578861>, <-0.0764039, 5.8378, -1.49568>, <-0.577248, 0.468182, 0.669022>, <-0.0547605, 5.85415, -1.4928> , <-0.408153, 0.595955, 0.691555> }
	smooth_triangle { <-0.0764039, 5.8378, -1.49568>, <-0.577248, 0.468182, 0.669022>, <-0.062962, 5.87241, -1.51456>, <-0.446112, 0.682571, 0.578861>, <-0.0880017, 5.85349, -1.5179> , <-0.630912, 0.542926, 0.55424> }
	smooth_triangle { <-0.067063, 5.88332, -1.53554>, <-0.488368, 0.795828, 0.357986>, <-0.0880017, 5.85349, -1.5179>, <-0.630912, 0.542926, 0.55424>, <-0.062962, 5.87241, -1.51456> , <-0.446112, 0.682571, 0.578861> }
	smooth_triangle { <-0.0880017, 5.85349, -1.5179>, <-0.630912, 0.542926, 0.55424>, <-0.067063, 5.88332, -1.53554>, <-0.488368, 0.795828, 0.357986>, <-0.0938015, 5.86312, -1.5391> , <-0.690672, 0.64296, 0.331021> }
	smooth_triangle { <-0.0680875, 5.88934, -1.55946>, <-0.499565, 0.844914, 0.191192>, <-0.0938015, 5.86312, -1.5391>, <-0.690672, 0.64296, 0.331021>, <-0.067063, 5.88332, -1.53554> , <-0.488368, 0.795828, 0.357986> }
	smooth_triangle { <-0.0938015, 5.86312, -1.5391>, <-0.690672, 0.64296, 0.331021>, <-0.0680875, 5.88934, -1.55946>, <-0.499565, 0.844914, 0.191192>, <-0.095251, 5.86882, -1.56308> , <-0.706498, 0.688548, 0.163595> }
	smooth_triangle { <-0.0680875, 5.89397, -1.58571>, <-0.498755, 0.863025, 0.0801931>, <-0.095251, 5.86882, -1.56308>, <-0.706498, 0.688548, 0.163595>, <-0.0680875, 5.88934, -1.55946> , <-0.499565, 0.844914, 0.191192> }
	smooth_triangle { <-0.095251, 5.86882, -1.56308>, <-0.706498, 0.688548, 0.163595>, <-0.0680875, 5.89397, -1.58571>, <-0.498755, 0.863025, 0.0801931>, <-0.095251, 5.87345, -1.58933> , <-0.705323, 0.706926, 0.0526704> }
	smooth_triangle { <-0.066037, 5.89546, -1.6146>, <-0.489629, 0.870358, -0.0523505>, <-0.095251, 5.87345, -1.58933>, <-0.705323, 0.706926, 0.0526704>, <-0.0680875, 5.89397, -1.58571> , <-0.498755, 0.863025, 0.0801931> }
	smooth_triangle { <-0.095251, 5.87345, -1.58933>, <-0.705323, 0.706926, 0.0526704>, <-0.066037, 5.89546, -1.6146>, <-0.489629, 0.870358, -0.0523505>, <-0.0923506, 5.87558, -1.6181> , <-0.692423, 0.717114, -0.0793625> }
	smooth_triangle { <-0.062962, 5.89413, -1.63773>, <-0.459854, 0.852561, -0.248342>, <-0.0923506, 5.87558, -1.6181>, <-0.692423, 0.717114, -0.0793625>, <-0.066037, 5.89546, -1.6146> , <-0.489629, 0.870358, -0.0523505> }
	smooth_triangle { <-0.0923506, 5.87558, -1.6181>, <-0.692423, 0.717114, -0.0793625>, <-0.062962, 5.89413, -1.63773>, <-0.459854, 0.852561, -0.248342>, <-0.0880017, 5.87521, -1.64107> , <-0.650328, 0.70863, -0.27371> }
	smooth_triangle { <-0.0568102, 5.8872, -1.65977>, <-0.384831, 0.767294, -0.512996>, <-0.0880017, 5.87521, -1.64107>, <-0.650328, 0.70863, -0.27371>, <-0.062962, 5.89413, -1.63773> , <-0.459854, 0.852561, -0.248342> }
	smooth_triangle { <-0.0880017, 5.87521, -1.64107>, <-0.650328, 0.70863, -0.27371>, <-0.0568102, 5.8872, -1.65977>, <-0.384831, 0.767294, -0.512996>, <-0.0793034, 5.8702, -1.66277> , <-0.544238, 0.646838, -0.534233> }
	smooth_triangle { <-0.0475838, 5.87431, -1.6787>, <-0.332178, 0.696412, -0.636136>, <-0.0793034, 5.8702, -1.66277>, <-0.544238, 0.646838, -0.534233>, <-0.0568102, 5.8872, -1.65977> , <-0.384831, 0.767294, -0.512996> }
	smooth_triangle { <-0.0793034, 5.8702, -1.66277>, <-0.544238, 0.646838, -0.534233>, <-0.0475838, 5.87431, -1.6787>, <-0.332178, 0.696412, -0.636136>, <-0.0662547, 5.8602, -1.68119> , <-0.469776, 0.592437, -0.654468> }
	smooth_triangle { <-0.0120448, 5.79188, -1.45589>, <-0.258864, 0.95124, 0.167725>, <-0.0209298, 5.77081, -1.35759>, <-0.499971, 0.852885, 0.150386>, <-0.0120448, 5.77443, -1.35695> , <-0.258864, 0.95124, 0.167725> }
	smooth_triangle { <-0.0209298, 5.77081, -1.35759>, <-0.499971, 0.852885, 0.150386>, <-0.0120448, 5.79188, -1.45589>, <-0.258864, 0.95124, 0.167725>, <-0.0209298, 5.78826, -1.45653> , <-0.499971, 0.852885, 0.150386> }
	smooth_triangle { <-0.0162904, 5.80819, -1.45718>, <-0.0940769, 0.184043, 0.978406>, <-0.0209298, 5.78826, -1.45653>, <-0.121291, 0.0384033, 0.991874>, <-0.0120448, 5.79188, -1.45589> , <-0.062729, 0.0622265, 0.996089> }
	smooth_triangle { <-0.0209298, 5.78826, -1.45653>, <-0.121291, 0.0384033, 0.991874>, <-0.0162904, 5.80819, -1.45718>, <-0.0940769, 0.184043, 0.978406>, <-0.0291312, 5.80296, -1.4581> , <-0.181769, 0.148291, 0.972096> }
	smooth_triangle { <-0.0221273, 5.83179, -1.46551>, <-0.148056, 0.401722, 0.903714>, <-0.0291312, 5.80296, -1.4581>, <-0.181769, 0.148291, 0.972096>, <-0.0162904, 5.80819, -1.45718> , <-0.0940769, 0.184043, 0.978406> }
	smooth_triangle { <-0.0291312, 5.80296, -1.4581>, <-0.181769, 0.148291, 0.972096>, <-0.0221273, 5.83179, -1.46551>, <-0.148056, 0.401722, 0.903714>, <-0.0404082, 5.82433, -1.46683> , <-0.285999, 0.345437, 0.8938> }
	smooth_triangle { <-0.0263722, 5.84988, -1.47689>, <-0.189751, 0.579356, 0.79268>, <-0.0404082, 5.82433, -1.46683>, <-0.285999, 0.345437, 0.8938>, <-0.0221273, 5.83179, -1.46551> , <-0.148056, 0.401722, 0.903714> }
	smooth_triangle { <-0.0404082, 5.82433, -1.46683>, <-0.285999, 0.345437, 0.8938>, <-0.0263722, 5.84988, -1.47689>, <-0.189751, 0.579356, 0.79268>, <-0.0486098, 5.84081, -1.47849> , <-0.366577, 0.507224, 0.779965> }
	smooth_triangle { <-0.0295561, 5.86443, -1.49098>, <-0.211277, 0.676253, 0.705722>, <-0.0486098, 5.84081, -1.47849>, <-0.366577, 0.507224, 0.779965>, <-0.0263722, 5.84988, -1.47689> , <-0.189751, 0.579356, 0.79268> }
	smooth_triangle { <-0.0486098, 5.84081, -1.47849>, <-0.366577, 0.507224, 0.779965>, <-0.0295561, 5.86443, -1.49098>, <-0.211277, 0.676253, 0.705722>, <-0.0547605, 5.85415, -1.4928> , <-0.408153, 0.595955, 0.691555> }
	smooth_triangle { <-0.0338017, 5.88431, -1.51246>, <-0.230939, 0.770348, 0.594332>, <-0.0547605, 5.85415, -1.4928>, <-0.408153, 0.595955, 0.691555>, <-0.0295561, 5.86443, -1.49098> , <-0.211277, 0.676253, 0.705722> }
	smooth_triangle { <-0.0547605, 5.85415, -1.4928>, <-0.408153, 0.595955, 0.691555>, <-0.0338017, 5.88431, -1.51246>, <-0.230939, 0.770348, 0.594332>, <-0.062962, 5.87241, -1.51456> , <-0.446112, 0.682571, 0.578861> }
	smooth_triangle { <-0.0359251, 5.89602, -1.5333>, <-0.252807, 0.891918, 0.374927>, <-0.062962, 5.87241, -1.51456>, <-0.446112, 0.682571, 0.578861>, <-0.0338017, 5.88431, -1.51246> , <-0.230939, 0.770348, 0.594332> }
	smooth_triangle { <-0.062962, 5.87241, -1.51456>, <-0.446112, 0.682571, 0.578861>, <-0.0359251, 5.89602, -1.5333>, <-0.252807, 0.891918, 0.374927>, <-0.067063, 5.88332, -1.53554> , <-0.488368, 0.795828, 0.357986> }
	smooth_triangle { <-0.0364553, 5.90225, -1.55719>, <-0.258597, 0.943207, 0.208536>, <-0.067063, 5.88332, -1.53554>, <-0.488368, 0.795828, 0.357986>, <-0.0359251, 5.89602, -1.5333> , <-0.252807, 0.891918, 0.374927> }
	smooth_triangle { <-0.067063, 5.88332, -1.53554>, <-0.488368, 0.795828, 0.357986>, <-0.0364553, 5.90225, -1.55719>, <-0.258597, 0.943207, 0.208536>, <-0.0680875, 5.88934, -1.55946> , <-0.499565, 0.844914, 0.191192> }
	smooth_triangle { <-0.0364553, 5.90688, -1.58344>, <-0.258175, 0.961168, 0.0974787>, <-0.0680875, 5.88934, -1.55946>, <-0.499565, 0.844914, 0.191192>, <-0.0364553, 5.90225, -1.55719> , <-0.258597, 0.943207, 0.208536> }
	smooth_triangle { <-0.0680875, 5.88934, -1.55946>, <-0.499565, 0.844914, 0.191192>, <-0.0364553, 5.90688, -1.58344>, <-0.258175, 0.961168, 0.0974787>, <-0.0680875, 5.89397, -1.58571> , <-0.498755, 0.863025, 0.0801931> }
	smooth_triangle { <-0.0353936, 5.90796, -1.61239>, <-0.253436, 0.966706, -0.0353547>, <-0.0680875, 5.89397, -1.58571>, <-0.498755, 0.863025, 0.0801931>, <-0.0364553, 5.90688, -1.58344> , <-0.258175, 0.961168, 0.0974787> }
	smooth_triangle { <-0.0680875, 5.89397, -1.58571>, <-0.498755, 0.863025, 0.0801931>, <-0.0353936, 5.90796, -1.61239>, <-0.253436, 0.966706, -0.0353547>, <-0.066037, 5.89546, -1.6146> , <-0.489629, 0.870358, -0.0523505> }
	smooth_triangle { <-0.0338017, 5.90603, -1.63563>, <-0.238032, 0.943053, -0.232361>, <-0.066037, 5.89546, -1.6146>, <-0.489629, 0.870358, -0.0523505>, <-0.0353936, 5.90796, -1.61239> , <-0.253436, 0.966706, -0.0353547> }
	smooth_triangle { <-0.066037, 5.89546, -1.6146>, <-0.489629, 0.870358, -0.0523505>, <-0.0338017, 5.90603, -1.63563>, <-0.238032, 0.943053, -0.232361>, <-0.062962, 5.89413, -1.63773> , <-0.459854, 0.852561, -0.248342> }
	smooth_triangle { <-0.0306178, 5.89788, -1.65789>, <-0.199217, 0.843012, -0.499643>, <-0.062962, 5.89413, -1.63773>, <-0.459854, 0.852561, -0.248342>, <-0.0338017, 5.90603, -1.63563> , <-0.238032, 0.943053, -0.232361> }
	smooth_triangle { <-0.062962, 5.89413, -1.63773>, <-0.459854, 0.852561, -0.248342>, <-0.0306178, 5.89788, -1.65789>, <-0.199217, 0.843012, -0.499643>, <-0.0568102, 5.8872, -1.65977> , <-0.384831, 0.767294, -0.512996> }
	smooth_triangle { <-0.025842, 5.88318, -1.67714>, <-0.171962, 0.761766, -0.624614>, <-0.0568102, 5.8872, -1.65977>, <-0.384831, 0.767294, -0.512996>, <-0.0306178, 5.89788, -1.65789> , <-0.199217, 0.843012, -0.499643> }
	smooth_triangle { <-0.0568102, 5.8872, -1.65977>, <-0.384831, 0.767294, -0.512996>, <-0.025842, 5.88318, -1.67714>, <-0.171962, 0.761766, -0.624614>, <-0.0475838, 5.87431, -1.6787> , <-0.332178, 0.696412, -0.636136> }
	smooth_triangle { <-0.0025097, 5.79312, -1.45567>, <2.02905e-007, 0.984808, 0.173644>, <-0.0120448, 5.77443, -1.35695>, <-0.258864, 0.95124, 0.167725>, <-0.0025097, 5.77567, -1.35673> , <2.02905e-007, 0.984808, 0.173644> }
	smooth_triangle { <-0.0120448, 5.77443, -1.35695>, <-0.258864, 0.95124, 0.167725>, <-0.0025097, 5.79312, -1.45567>, <2.02905e-007, 0.984808, 0.173644>, <-0.0120448, 5.79188, -1.45589> , <-0.258864, 0.95124, 0.167725> }
	smooth_triangle { <-0.0025097, 5.80998, -1.45686>, <4.07241e-006, 0.196249, 0.980554>, <-0.0120448, 5.79188, -1.45589>, <-0.062729, 0.0622265, 0.996089>, <-0.0025097, 5.79312, -1.45567> , <9.13902e-006, 0.0703941, 0.997519> }
	smooth_triangle { <-0.0120448, 5.79188, -1.45589>, <-0.062729, 0.0622265, 0.996089>, <-0.0025097, 5.80998, -1.45686>, <4.07241e-006, 0.196249, 0.980554>, <-0.0162904, 5.80819, -1.45718> , <-0.0940769, 0.184043, 0.978406> }
	smooth_triangle { <-0.0025097, 5.83433, -1.46506>, <-1.10127e-006, 0.420905, 0.907105>, <-0.0162904, 5.80819, -1.45718>, <-0.0940769, 0.184043, 0.978406>, <-0.0025097, 5.80998, -1.45686> , <4.07241e-006, 0.196249, 0.980554> }
	smooth_triangle { <-0.0162904, 5.80819, -1.45718>, <-0.0940769, 0.184043, 0.978406>, <-0.0025097, 5.83433, -1.46506>, <-1.10127e-006, 0.420905, 0.907105>, <-0.0221273, 5.83179, -1.46551> , <-0.148056, 0.401722, 0.903714> }
	smooth_triangle { <-0.0025097, 5.85297, -1.47635>, <-1.84576e-006, 0.603951, 0.797021>, <-0.0221273, 5.83179, -1.46551>, <-0.148056, 0.401722, 0.903714>, <-0.0025097, 5.83433, -1.46506> , <-1.10127e-006, 0.420905, 0.907105> }
	smooth_triangle { <-0.0221273, 5.83179, -1.46551>, <-0.148056, 0.401722, 0.903714>, <-0.0025097, 5.85297, -1.47635>, <-1.84576e-006, 0.603951, 0.797021>, <-0.0263722, 5.84988, -1.47689> , <-0.189751, 0.579356, 0.79268> }
	smooth_triangle { <-0.0025097, 5.86794, -1.49037>, <-1.41869e-006, 0.703644, 0.710553>, <-0.0263722, 5.84988, -1.47689>, <-0.189751, 0.579356, 0.79268>, <-0.0025097, 5.85297, -1.47635> , <-1.84576e-006, 0.603951, 0.797021> }
	smooth_triangle { <-0.0263722, 5.84988, -1.47689>, <-0.189751, 0.579356, 0.79268>, <-0.0025097, 5.86794, -1.49037>, <-1.41869e-006, 0.703644, 0.710553>, <-0.0295561, 5.86443, -1.49098> , <-0.211277, 0.676253, 0.705722> }
	smooth_triangle { <-0.0025097, 5.88837, -1.51175>, <-3.90986e-007, 0.800292, 0.599611>, <-0.0295561, 5.86443, -1.49098>, <-0.211277, 0.676253, 0.705722>, <-0.0025097, 5.86794, -1.49037> , <-1.41869e-006, 0.703644, 0.710553> }
	smooth_triangle { <-0.0295561, 5.86443, -1.49098>, <-0.211277, 0.676253, 0.705722>, <-0.0025097, 5.88837, -1.51175>, <-3.90986e-007, 0.800292, 0.599611>, <-0.0338017, 5.88431, -1.51246> , <-0.230939, 0.770348, 0.594332> }
	smooth_triangle { <-0.0025097, 5.90036, -1.53254>, <-5.07701e-007, 0.924695, 0.380708>, <-0.0338017, 5.88431, -1.51246>, <-0.230939, 0.770348, 0.594332>, <-0.0025097, 5.88837, -1.51175> , <-3.90986e-007, 0.800292, 0.599611> }
	smooth_triangle { <-0.0338017, 5.88431, -1.51246>, <-0.230939, 0.770348, 0.594332>, <-0.0025097, 5.90036, -1.53254>, <-5.07701e-007, 0.924695, 0.380708>, <-0.0359251, 5.89602, -1.5333> , <-0.252807, 0.891918, 0.374927> }
	smooth_triangle { <-0.0025097, 5.90665, -1.55641>, <-2.67001e-007, 0.976735, 0.21445>, <-0.0359251, 5.89602, -1.5333>, <-0.252807, 0.891918, 0.374927>, <-0.0025097, 5.90036, -1.53254> , <-5.07701e-007, 0.924695, 0.380708> }
	smooth_triangle { <-0.0359251, 5.89602, -1.5333>, <-0.252807, 0.891918, 0.374927>, <-0.0025097, 5.90665, -1.55641>, <-2.67001e-007, 0.976735, 0.21445>, <-0.0364553, 5.90225, -1.55719> , <-0.258597, 0.943207, 0.208536> }
	smooth_triangle { <-0.0025097, 5.91128, -1.58266>, <1.73263e-007, 0.994642, 0.103382>, <-0.0364553, 5.90225, -1.55719>, <-0.258597, 0.943207, 0.208536>, <-0.0025097, 5.90665, -1.55641> , <-2.67001e-007, 0.976735, 0.21445> }
	smooth_triangle { <-0.0364553, 5.90225, -1.55719>, <-0.258597, 0.943207, 0.208536>, <-0.0025097, 5.91128, -1.58266>, <1.73263e-007, 0.994642, 0.103382>, <-0.0364553, 5.90688, -1.58344> , <-0.258175, 0.961168, 0.0974787> }
	smooth_triangle { <-0.0025097, 5.91222, -1.61164>, <-6.73624e-007, 0.999563, -0.0295596>, <-0.0364553, 5.90688, -1.58344>, <-0.258175, 0.961168, 0.0974786>, <-0.0025097, 5.91128, -1.58266> , <1.73263e-007, 0.994642, 0.103382> }
	smooth_triangle { <-0.0364553, 5.90688, -1.58344>, <-0.258175, 0.961168, 0.0974786>, <-0.0025097, 5.91222, -1.61164>, <-6.73624e-007, 0.999563, -0.0295596>, <-0.0353936, 5.90796, -1.61239> , <-0.253436, 0.966706, -0.0353547> }
	smooth_triangle { <-0.0025097, 5.91008, -1.63492>, <-2.65133e-007, 0.973913, -0.22692>, <-0.0353936, 5.90796, -1.61239>, <-0.253436, 0.966706, -0.0353547>, <-0.0025097, 5.91222, -1.61164> , <-6.73624e-007, 0.999563, -0.0295596> }
	smooth_triangle { <-0.0353936, 5.90796, -1.61239>, <-0.253436, 0.966706, -0.0353547>, <-0.0025097, 5.91008, -1.63492>, <-2.65133e-007, 0.973913, -0.22692>, <-0.0338017, 5.90603, -1.63563> , <-0.238032, 0.943053, -0.232361> }
	smooth_triangle { <-0.0025097, 5.90153, -1.65725>, <4.92418e-007, 0.868841, -0.495091>, <-0.0338017, 5.90603, -1.63563>, <-0.238032, 0.943053, -0.232361>, <-0.0025097, 5.91008, -1.63492> , <-2.65133e-007, 0.973913, -0.22692> }
	smooth_triangle { <-0.0338017, 5.90603, -1.63563>, <-0.238032, 0.943053, -0.232361>, <-0.0025097, 5.90153, -1.65725>, <4.92418e-007, 0.868841, -0.495091>, <-0.0306178, 5.89788, -1.65789> , <-0.199217, 0.843012, -0.499643> }
	smooth_triangle { <-0.0025097, 5.8862, -1.67661>, <-1.83236e-007, 0.78406, -0.620685>, <-0.0306178, 5.89788, -1.65789>, <-0.199217, 0.843012, -0.499643>, <-0.0025097, 5.90153, -1.65725> , <4.92418e-007, 0.868841, -0.495091> }
	smooth_triangle { <-0.0306178, 5.89788, -1.65789>, <-0.199217, 0.843012, -0.499643>, <-0.0025097, 5.8862, -1.67661>, <-1.83236e-007, 0.78406, -0.620685>, <-0.025842, 5.88318, -1.67714> , <-0.171962, 0.761766, -0.624614> }
	smooth_triangle { <0.00702537, 5.77443, -1.35695>, <0.258862, 0.95124, 0.167729>, <-0.0025097, 5.79312, -1.45567>, <2.02905e-007, 0.984808, 0.173644>, <-0.0025097, 5.77567, -1.35673> , <2.02905e-007, 0.984808, 0.173644> }
	smooth_triangle { <-0.0025097, 5.79312, -1.45567>, <2.02905e-007, 0.984808, 0.173644>, <0.00702537, 5.77443, -1.35695>, <0.258862, 0.95124, 0.167729>, <0.00702537, 5.79188, -1.45589> , <0.258862, 0.95124, 0.167729> }
	smooth_triangle { <-0.0025097, 5.80998, -1.45686>, <4.07429e-006, 0.196249, 0.980554>, <0.00702537, 5.79188, -1.45589>, <0.0627277, 0.0622731, 0.996086>, <0.011271, 5.80819, -1.45718> , <0.0940735, 0.184057, 0.978403> }
	smooth_triangle { <0.00702537, 5.79188, -1.45589>, <0.0627277, 0.0622731, 0.996086>, <-0.0025097, 5.80998, -1.45686>, <4.07429e-006, 0.196249, 0.980554>, <-0.0025097, 5.79312, -1.45567> , <9.13902e-006, 0.0703941, 0.997519> }
	smooth_triangle { <-0.0025097, 5.83433, -1.46506>, <-1.10127e-006, 0.420905, 0.907105>, <0.011271, 5.80819, -1.45718>, <0.0940735, 0.184057, 0.978403>, <0.0171079, 5.83179, -1.46551> , <0.148055, 0.401713, 0.903718> }
	smooth_triangle { <0.011271, 5.80819, -1.45718>, <0.0940735, 0.184057, 0.978403>, <-0.0025097, 5.83433, -1.46506>, <-1.10127e-006, 0.420905, 0.907105>, <-0.0025097, 5.80998, -1.45686> , <4.07429e-006, 0.196249, 0.980554> }
	smooth_triangle { <-0.0025097, 5.85297, -1.47635>, <-1.84388e-006, 0.603951, 0.797021>, <0.0171079, 5.83179, -1.46551>, <0.148055, 0.401713, 0.903718>, <0.0213535, 5.84988, -1.47689> , <0.189755, 0.579359, 0.792677> }
	smooth_triangle { <0.0171079, 5.83179, -1.46551>, <0.148055, 0.401713, 0.903718>, <-0.0025097, 5.85297, -1.47635>, <-1.84388e-006, 0.603951, 0.797021>, <-0.0025097, 5.83433, -1.46506> , <-1.10127e-006, 0.420905, 0.907105> }
	smooth_triangle { <-0.0025097, 5.86794, -1.49037>, <-1.41869e-006, 0.703644, 0.710553>, <0.0213535, 5.84988, -1.47689>, <0.189755, 0.579359, 0.792677>, <0.0245373, 5.86443, -1.49098> , <0.211283, 0.676262, 0.705712> }
	smooth_triangle { <0.0213535, 5.84988, -1.47689>, <0.189755, 0.579359, 0.792677>, <-0.0025097, 5.86794, -1.49037>, <-1.41869e-006, 0.703644, 0.710553>, <-0.0025097, 5.85297, -1.47635> , <-1.84388e-006, 0.603951, 0.797021> }
	smooth_triangle { <0.0245373, 5.86443, -1.49098>, <0.211283, 0.676262, 0.705712>, <-0.0025097, 5.88837, -1.51175>, <-3.92875e-007, 0.800292, 0.599611>, <-0.0025097, 5.86794, -1.49037> , <-1.41869e-006, 0.703644, 0.710553> }
	smooth_triangle { <-0.0025097, 5.88837, -1.51175>, <-3.92875e-007, 0.800292, 0.599611>, <0.0245373, 5.86443, -1.49098>, <0.211283, 0.676262, 0.705712>, <0.0287823, 5.88431, -1.51246> , <0.230939, 0.770346, 0.594335> }
	smooth_triangle { <0.0287823, 5.88431, -1.51246>, <0.230939, 0.770346, 0.594335>, <-0.0025097, 5.90036, -1.53254>, <-5.11489e-007, 0.924695, 0.380708>, <-0.0025097, 5.88837, -1.51175> , <-3.92875e-007, 0.800292, 0.599611> }
	smooth_triangle { <-0.0025097, 5.90036, -1.53254>, <-5.11489e-007, 0.924695, 0.380708>, <0.0287823, 5.88431, -1.51246>, <0.230939, 0.770346, 0.594335>, <0.0309058, 5.89602, -1.5333> , <0.252808, 0.891917, 0.37493> }
	smooth_triangle { <0.0309058, 5.89602, -1.5333>, <0.252808, 0.891917, 0.37493>, <-0.0025097, 5.90665, -1.55641>, <-2.6324e-007, 0.976735, 0.21445>, <-0.0025097, 5.90036, -1.53254> , <-5.11489e-007, 0.924695, 0.380708> }
	smooth_triangle { <-0.0025097, 5.90665, -1.55641>, <-2.6324e-007, 0.976735, 0.21445>, <0.0309058, 5.89602, -1.5333>, <0.252808, 0.891917, 0.37493>, <0.0314359, 5.90225, -1.55719> , <0.258598, 0.943209, 0.208528> }
	smooth_triangle { <0.0314359, 5.90225, -1.55719>, <0.258598, 0.943209, 0.208528>, <-0.0025097, 5.91128, -1.58266>, <1.69496e-007, 0.994642, 0.103382>, <-0.0025097, 5.90665, -1.55641> , <-2.6324e-007, 0.976735, 0.21445> }
	smooth_triangle { <-0.0025097, 5.91128, -1.58266>, <1.69496e-007, 0.994642, 0.103382>, <0.0314359, 5.90225, -1.55719>, <0.258598, 0.943209, 0.208528>, <0.0314359, 5.90688, -1.58344> , <0.258175, 0.961166, 0.0974999> }
	smooth_triangle { <0.0314359, 5.90688, -1.58344>, <0.258175, 0.961166, 0.0974999>, <-0.0025097, 5.91222, -1.61164>, <-6.73624e-007, 0.999563, -0.0295596>, <-0.0025097, 5.91128, -1.58266> , <1.69496e-007, 0.994642, 0.103382> }
	smooth_triangle { <-0.0025097, 5.91222, -1.61164>, <-6.73624e-007, 0.999563, -0.0295596>, <0.0314359, 5.90688, -1.58344>, <0.258175, 0.961166, 0.0974999>, <0.0303742, 5.90796, -1.61239> , <0.253436, 0.966706, -0.0353644> }
	smooth_triangle { <0.0303742, 5.90796, -1.61239>, <0.253436, 0.966706, -0.0353644>, <-0.0025097, 5.91008, -1.63492>, <-2.63239e-007, 0.973913, -0.22692>, <-0.0025097, 5.91222, -1.61164> , <-6.73624e-007, 0.999563, -0.0295596> }
	smooth_triangle { <-0.0025097, 5.91008, -1.63492>, <-2.63239e-007, 0.973913, -0.22692>, <0.0303742, 5.90796, -1.61239>, <0.253436, 0.966706, -0.0353644>, <0.0287823, 5.90603, -1.63563> , <0.238029, 0.943047, -0.232389> }
	smooth_triangle { <0.0287823, 5.90603, -1.63563>, <0.238029, 0.943047, -0.232389>, <-0.0025097, 5.90153, -1.65725>, <4.92418e-007, 0.868841, -0.495091>, <-0.0025097, 5.91008, -1.63492> , <-2.65133e-007, 0.973913, -0.22692> }
	smooth_triangle { <-0.0025097, 5.90153, -1.65725>, <4.92418e-007, 0.868841, -0.495091>, <0.0287823, 5.90603, -1.63563>, <0.238029, 0.943047, -0.232389>, <0.0255984, 5.89788, -1.65789> , <0.199216, 0.843012, -0.499643> }
	smooth_triangle { <0.0255984, 5.89788, -1.65789>, <0.199216, 0.843012, -0.499643>, <-0.0025097, 5.8862, -1.67661>, <-1.83236e-007, 0.78406, -0.620685>, <-0.0025097, 5.90153, -1.65725> , <4.92418e-007, 0.868841, -0.495091> }
	smooth_triangle { <-0.0025097, 5.8862, -1.67661>, <-1.83236e-007, 0.78406, -0.620685>, <0.0255984, 5.89788, -1.65789>, <0.199216, 0.843012, -0.499643>, <0.0208226, 5.88318, -1.67714> , <0.171962, 0.761767, -0.624612> }
	smooth_triangle { <0.0159105, 5.77081, -1.35759>, <0.499971, 0.852885, 0.150386>, <0.00702537, 5.79188, -1.45589>, <0.258862, 0.95124, 0.167729>, <0.00702537, 5.77443, -1.35695> , <0.258862, 0.95124, 0.167729> }
	smooth_triangle { <0.00702537, 5.79188, -1.45589>, <0.258862, 0.95124, 0.167729>, <0.0159105, 5.77081, -1.35759>, <0.499971, 0.852885, 0.150386>, <0.0159105, 5.78826, -1.45653> , <0.499971, 0.852885, 0.150386> }
	smooth_triangle { <0.011271, 5.80819, -1.45718>, <0.0940735, 0.184057, 0.978403>, <0.0159105, 5.78826, -1.45653>, <0.121289, 0.0383888, 0.991875>, <0.0241118, 5.80296, -1.4581> , <0.181768, 0.148281, 0.972097> }
	smooth_triangle { <0.0159105, 5.78826, -1.45653>, <0.121289, 0.0383888, 0.991875>, <0.011271, 5.80819, -1.45718>, <0.0940735, 0.184057, 0.978403>, <0.00702537, 5.79188, -1.45589> , <0.0627277, 0.0622731, 0.996086> }
	smooth_triangle { <0.0171079, 5.83179, -1.46551>, <0.148055, 0.401713, 0.903718>, <0.0241118, 5.80296, -1.4581>, <0.181768, 0.148281, 0.972097>, <0.0353888, 5.82433, -1.46683> , <0.285996, 0.345439, 0.8938> }
	smooth_triangle { <0.0241118, 5.80296, -1.4581>, <0.181768, 0.148281, 0.972097>, <0.0171079, 5.83179, -1.46551>, <0.148055, 0.401713, 0.903718>, <0.011271, 5.80819, -1.45718> , <0.0940735, 0.184057, 0.978403> }
	smooth_triangle { <0.0213535, 5.84988, -1.47689>, <0.189755, 0.579359, 0.792677>, <0.0353888, 5.82433, -1.46683>, <0.285996, 0.345439, 0.8938>, <0.0435904, 5.84081, -1.47849> , <0.366571, 0.507224, 0.779968> }
	smooth_triangle { <0.0353888, 5.82433, -1.46683>, <0.285996, 0.345439, 0.8938>, <0.0213535, 5.84988, -1.47689>, <0.189755, 0.579359, 0.792677>, <0.0171079, 5.83179, -1.46551> , <0.148055, 0.401713, 0.903718> }
	smooth_triangle { <0.0245373, 5.86443, -1.49098>, <0.211283, 0.676262, 0.705712>, <0.0435904, 5.84081, -1.47849>, <0.366571, 0.507224, 0.779968>, <0.0497411, 5.85415, -1.4928> , <0.408157, 0.59596, 0.691549> }
	smooth_triangle { <0.0435904, 5.84081, -1.47849>, <0.366571, 0.507224, 0.779968>, <0.0245373, 5.86443, -1.49098>, <0.211283, 0.676262, 0.705712>, <0.0213535, 5.84988, -1.47689> , <0.189755, 0.579359, 0.792677> }
	smooth_triangle { <0.0287823, 5.88431, -1.51246>, <0.230939, 0.770346, 0.594335>, <0.0497411, 5.85415, -1.4928>, <0.408157, 0.59596, 0.691549>, <0.0579426, 5.87241, -1.51456> , <0.446114, 0.68257, 0.578862> }
	smooth_triangle { <0.0497411, 5.85415, -1.4928>, <0.408157, 0.59596, 0.691549>, <0.0287823, 5.88431, -1.51246>, <0.230939, 0.770346, 0.594335>, <0.0245373, 5.86443, -1.49098> , <0.211283, 0.676262, 0.705712> }
	smooth_triangle { <0.0579426, 5.87241, -1.51456>, <0.446114, 0.68257, 0.578862>, <0.0309058, 5.89602, -1.5333>, <0.252808, 0.891917, 0.37493>, <0.0287823, 5.88431, -1.51246> , <0.230939, 0.770346, 0.594335> }
	smooth_triangle { <0.0309058, 5.89602, -1.5333>, <0.252808, 0.891917, 0.37493>, <0.0579426, 5.87241, -1.51456>, <0.446114, 0.68257, 0.578862>, <0.0620436, 5.88332, -1.53554> , <0.488369, 0.795832, 0.357977> }
	smooth_triangle { <0.0620436, 5.88332, -1.53554>, <0.488369, 0.795832, 0.357977>, <0.0314359, 5.90225, -1.55719>, <0.258598, 0.943209, 0.208528>, <0.0309058, 5.89602, -1.5333> , <0.252808, 0.891917, 0.37493> }
	smooth_triangle { <0.0314359, 5.90225, -1.55719>, <0.258598, 0.943209, 0.208528>, <0.0620436, 5.88332, -1.53554>, <0.488369, 0.795832, 0.357977>, <0.0630682, 5.88934, -1.55946> , <0.499565, 0.84492, 0.191167> }
	smooth_triangle { <0.0630682, 5.88934, -1.55946>, <0.499565, 0.84492, 0.191167>, <0.0314359, 5.90688, -1.58344>, <0.258175, 0.961166, 0.0974999>, <0.0314359, 5.90225, -1.55719> , <0.258598, 0.943209, 0.208528> }
	smooth_triangle { <0.0314359, 5.90688, -1.58344>, <0.258175, 0.961166, 0.0974999>, <0.0630682, 5.88934, -1.55946>, <0.499565, 0.84492, 0.191167>, <0.0630682, 5.89397, -1.58571> , <0.498755, 0.863024, 0.0802071> }
	smooth_triangle { <0.0630682, 5.89397, -1.58571>, <0.498755, 0.863024, 0.0802071>, <0.0303742, 5.90796, -1.61239>, <0.253436, 0.966706, -0.0353644>, <0.0314359, 5.90688, -1.58344> , <0.258175, 0.961166, 0.0974999> }
	smooth_triangle { <0.0303742, 5.90796, -1.61239>, <0.253436, 0.966706, -0.0353644>, <0.0630682, 5.89397, -1.58571>, <0.498755, 0.863024, 0.0802071>, <0.0610176, 5.89546, -1.6146> , <0.489624, 0.870361, -0.0523451> }
	smooth_triangle { <0.0610176, 5.89546, -1.6146>, <0.489624, 0.870361, -0.0523451>, <0.0287823, 5.90603, -1.63563>, <0.238029, 0.943047, -0.232389>, <0.0303742, 5.90796, -1.61239> , <0.253436, 0.966706, -0.0353644> }
	smooth_triangle { <0.0287823, 5.90603, -1.63563>, <0.238029, 0.943047, -0.232389>, <0.0610176, 5.89546, -1.6146>, <0.489624, 0.870361, -0.0523451>, <0.0579426, 5.89413, -1.63773> , <0.459848, 0.852563, -0.248345> }
	smooth_triangle { <0.0579426, 5.89413, -1.63773>, <0.459848, 0.852563, -0.248345>, <0.0255984, 5.89788, -1.65789>, <0.199216, 0.843012, -0.499643>, <0.0287823, 5.90603, -1.63563> , <0.238029, 0.943047, -0.232389> }
	smooth_triangle { <0.0255984, 5.89788, -1.65789>, <0.199216, 0.843012, -0.499643>, <0.0579426, 5.89413, -1.63773>, <0.459848, 0.852563, -0.248345>, <0.0517909, 5.8872, -1.65977> , <0.384836, 0.767298, -0.512986> }
	smooth_triangle { <0.0517909, 5.8872, -1.65977>, <0.384836, 0.767298, -0.512986>, <0.0208226, 5.88318, -1.67714>, <0.171962, 0.761767, -0.624612>, <0.0255984, 5.89788, -1.65789> , <0.199216, 0.843012, -0.499643> }
	smooth_triangle { <0.0208226, 5.88318, -1.67714>, <0.171962, 0.761767, -0.624612>, <0.0517909, 5.8872, -1.65977>, <0.384836, 0.767298, -0.512986>, <0.0425651, 5.87431, -1.6787> , <0.332184, 0.69642, -0.636123> }
	smooth_triangle { <0.0235403, 5.76504, -1.35861>, <0.707082, 0.696389, 0.122789>, <0.0159105, 5.78826, -1.45653>, <0.499971, 0.852885, 0.150386>, <0.0159105, 5.77081, -1.35759> , <0.499971, 0.852885, 0.150386> }
	smooth_triangle { <0.0159105, 5.78826, -1.45653>, <0.499971, 0.852885, 0.150386>, <0.0235403, 5.76504, -1.35861>, <0.707082, 0.696389, 0.122789>, <0.0235403, 5.78249, -1.45755> , <0.707082, 0.696389, 0.122789> }
	smooth_triangle { <0.0241118, 5.80296, -1.4581>, <0.181768, 0.148281, 0.972097>, <0.0235403, 5.78249, -1.45755>, <0.171498, 0.000437526, 0.985184>, <0.035139, 5.79462, -1.45957> , <0.257062, 0.0913941, 0.962064> }
	smooth_triangle { <0.0235403, 5.78249, -1.45755>, <0.171498, 0.000437526, 0.985184>, <0.0241118, 5.80296, -1.4581>, <0.181768, 0.148281, 0.972097>, <0.0159105, 5.78826, -1.45653> , <0.121289, 0.0383888, 0.991875> }
	smooth_triangle { <0.0353888, 5.82433, -1.46683>, <0.285996, 0.345439, 0.8938>, <0.035139, 5.79462, -1.45957>, <0.257062, 0.0913941, 0.962064>, <0.0510873, 5.81247, -1.46892> , <0.404497, 0.2559, 0.878008> }
	smooth_triangle { <0.035139, 5.79462, -1.45957>, <0.257062, 0.0913941, 0.962064>, <0.0353888, 5.82433, -1.46683>, <0.285996, 0.345439, 0.8938>, <0.0241118, 5.80296, -1.4581> , <0.181768, 0.148281, 0.972097> }
	smooth_triangle { <0.0435904, 5.84081, -1.47849>, <0.366571, 0.507224, 0.779968>, <0.0510873, 5.81247, -1.46892>, <0.404497, 0.2559, 0.878008>, <0.0626851, 5.82638, -1.48104> , <0.518444, 0.392451, 0.759736> }
	smooth_triangle { <0.0510873, 5.81247, -1.46892>, <0.404497, 0.2559, 0.878008>, <0.0435904, 5.84081, -1.47849>, <0.366571, 0.507224, 0.779968>, <0.0353888, 5.82433, -1.46683> , <0.285996, 0.345439, 0.8938> }
	smooth_triangle { <0.0497411, 5.85415, -1.4928>, <0.408157, 0.59596, 0.691549>, <0.0626851, 5.82638, -1.48104>, <0.518444, 0.392451, 0.759736>, <0.0713845, 5.8378, -1.49568> , <0.577247, 0.468174, 0.669028> }
	smooth_triangle { <0.0626851, 5.82638, -1.48104>, <0.518444, 0.392451, 0.759736>, <0.0497411, 5.85415, -1.4928>, <0.408157, 0.59596, 0.691549>, <0.0435904, 5.84081, -1.47849> , <0.366571, 0.507224, 0.779968> }
	smooth_triangle { <0.0579426, 5.87241, -1.51456>, <0.446114, 0.68257, 0.578862>, <0.0713845, 5.8378, -1.49568>, <0.577247, 0.468174, 0.669028>, <0.0829823, 5.85349, -1.5179> , <0.630914, 0.542924, 0.55424> }
	smooth_triangle { <0.0713845, 5.8378, -1.49568>, <0.577247, 0.468174, 0.669028>, <0.0579426, 5.87241, -1.51456>, <0.446114, 0.68257, 0.578862>, <0.0497411, 5.85415, -1.4928> , <0.408157, 0.59596, 0.691549> }
	smooth_triangle { <0.0829823, 5.85349, -1.5179>, <0.630914, 0.542924, 0.55424>, <0.0620436, 5.88332, -1.53554>, <0.488369, 0.795832, 0.357977>, <0.0579426, 5.87241, -1.51456> , <0.446114, 0.68257, 0.578862> }
	smooth_triangle { <0.0620436, 5.88332, -1.53554>, <0.488369, 0.795832, 0.357977>, <0.0829823, 5.85349, -1.5179>, <0.630914, 0.542924, 0.55424>, <0.0887822, 5.86312, -1.5391> , <0.690672, 0.642959, 0.331022> }
	smooth_triangle { <0.0887822, 5.86312, -1.5391>, <0.690672, 0.642959, 0.331022>, <0.0630682, 5.88934, -1.55946>, <0.499565, 0.84492, 0.191167>, <0.0620436, 5.88332, -1.53554> , <0.488369, 0.795832, 0.357977> }
	smooth_triangle { <0.0630682, 5.88934, -1.55946>, <0.499565, 0.84492, 0.191167>, <0.0887822, 5.86312, -1.5391>, <0.690672, 0.642959, 0.331022>, <0.0902316, 5.86882, -1.56308> , <0.706498, 0.688545, 0.163607> }
	smooth_triangle { <0.0902316, 5.86882, -1.56308>, <0.706498, 0.688545, 0.163607>, <0.0630682, 5.89397, -1.58571>, <0.498755, 0.863024, 0.0802071>, <0.0630682, 5.88934, -1.55946> , <0.499565, 0.84492, 0.191167> }
	smooth_triangle { <0.0630682, 5.89397, -1.58571>, <0.498755, 0.863024, 0.0802071>, <0.0902316, 5.86882, -1.56308>, <0.706498, 0.688545, 0.163607>, <0.0902316, 5.87345, -1.58933> , <0.705325, 0.706924, 0.0526835> }
	smooth_triangle { <0.0902316, 5.87345, -1.58933>, <0.705325, 0.706924, 0.0526835>, <0.0610176, 5.89546, -1.6146>, <0.489624, 0.870361, -0.0523451>, <0.0630682, 5.89397, -1.58571> , <0.498755, 0.863024, 0.0802071> }
	smooth_triangle { <0.0610176, 5.89546, -1.6146>, <0.489624, 0.870361, -0.0523451>, <0.0902316, 5.87345, -1.58933>, <0.705325, 0.706924, 0.0526835>, <0.0873327, 5.87558, -1.6181> , <0.692422, 0.717113, -0.0793745> }
	smooth_triangle { <0.0873327, 5.87558, -1.6181>, <0.692422, 0.717113, -0.0793745>, <0.0579426, 5.89413, -1.63773>, <0.459848, 0.852563, -0.248345>, <0.0610176, 5.89546, -1.6146> , <0.489624, 0.870361, -0.0523451> }
	smooth_triangle { <0.0579426, 5.89413, -1.63773>, <0.459848, 0.852563, -0.248345>, <0.0873327, 5.87558, -1.6181>, <0.692422, 0.717113, -0.0793745>, <0.0829823, 5.87521, -1.64107> , <0.650324, 0.708628, -0.273724> }
	smooth_triangle { <0.0829823, 5.87521, -1.64107>, <0.650324, 0.708628, -0.273724>, <0.0517909, 5.8872, -1.65977>, <0.384836, 0.767298, -0.512986>, <0.0579426, 5.89413, -1.63773> , <0.459848, 0.852563, -0.248344> }
	smooth_triangle { <0.0517909, 5.8872, -1.65977>, <0.384836, 0.767298, -0.512986>, <0.0829823, 5.87521, -1.64107>, <0.650324, 0.708628, -0.273724>, <0.0742841, 5.8702, -1.66277> , <0.544242, 0.646843, -0.534223> }
	smooth_triangle { <0.0742841, 5.8702, -1.66277>, <0.544242, 0.646843, -0.534223>, <0.0425651, 5.87431, -1.6787>, <0.332184, 0.69642, -0.636123>, <0.0517909, 5.8872, -1.65977> , <0.384836, 0.767298, -0.512986> }
	smooth_triangle { <0.0425651, 5.87431, -1.6787>, <0.332184, 0.69642, -0.636123>, <0.0742841, 5.8702, -1.66277>, <0.544242, 0.646843, -0.534223>, <0.0612357, 5.8602, -1.68119> , <0.469778, 0.592441, -0.654463> }
	smooth_triangle { <0.0235403, 5.76504, -1.35861>, <0.707082, 0.696389, 0.122789>, <0.0293951, 5.77498, -1.45887>, <0.866031, 0.492395, 0.0868215>, <0.0235403, 5.78249, -1.45755> , <0.707082, 0.696389, 0.122789> }
	smooth_triangle { <0.0293951, 5.77498, -1.45887>, <0.866031, 0.492395, 0.0868215>, <0.0235403, 5.76504, -1.35861>, <0.707082, 0.696389, 0.122789>, <0.0293951, 5.75753, -1.35993> , <0.866031, 0.492395, 0.0868215> }
	smooth_triangle { <0.035139, 5.79462, -1.45957>, <0.257062, 0.0913941, 0.962064>, <0.0293951, 5.77498, -1.45887>, <0.210069, -0.0490308, 0.976456>, <0.0436005, 5.78376, -1.46149> , <0.314854, 0.0172329, 0.948984> }
	smooth_triangle { <0.0293951, 5.77498, -1.45887>, <0.210069, -0.0490308, 0.976456>, <0.035139, 5.79462, -1.45957>, <0.257062, 0.0913941, 0.962064>, <0.0235403, 5.78249, -1.45755> , <0.171498, 0.000437526, 0.985184> }
	smooth_triangle { <0.0510873, 5.81247, -1.46892>, <0.404497, 0.2559, 0.878008>, <0.0436005, 5.78376, -1.46149>, <0.314854, 0.0172329, 0.948984>, <0.0631327, 5.79701, -1.47164> , <0.495404, 0.139211, 0.857435> }
	smooth_triangle { <0.0436005, 5.78376, -1.46149>, <0.314854, 0.0172329, 0.948984>, <0.0510873, 5.81247, -1.46892>, <0.404497, 0.2559, 0.878008>, <0.035139, 5.79462, -1.45957> , <0.257062, 0.0913941, 0.962064> }
	smooth_triangle { <0.0626851, 5.82638, -1.48104>, <0.518444, 0.392451, 0.759736>, <0.0631327, 5.79701, -1.47164>, <0.495404, 0.139211, 0.857435>, <0.0773377, 5.80758, -1.48435> , <0.634956, 0.242913, 0.733365> }
	smooth_triangle { <0.0631327, 5.79701, -1.47164>, <0.495404, 0.139211, 0.857435>, <0.0626851, 5.82638, -1.48104>, <0.518444, 0.392451, 0.759736>, <0.0510873, 5.81247, -1.46892> , <0.404497, 0.2559, 0.878008> }
	smooth_triangle { <0.0713845, 5.8378, -1.49568>, <0.577247, 0.468174, 0.669028>, <0.0773377, 5.80758, -1.48435>, <0.634956, 0.242913, 0.733365>, <0.0879909, 5.81648, -1.49944> , <0.706982, 0.301667, 0.639666> }
	smooth_triangle { <0.0773377, 5.80758, -1.48435>, <0.634956, 0.242913, 0.733365>, <0.0713845, 5.8378, -1.49568>, <0.577247, 0.468174, 0.669028>, <0.0626851, 5.82638, -1.48104> , <0.518444, 0.392451, 0.759736> }
	smooth_triangle { <0.0713845, 5.8378, -1.49568>, <0.577247, 0.468174, 0.669028>, <0.102196, 5.82883, -1.52225>, <0.772717, 0.360931, 0.522147>, <0.0829823, 5.85349, -1.5179> , <0.630914, 0.542924, 0.55424> }
	smooth_triangle { <0.102196, 5.82883, -1.52225>, <0.772717, 0.360931, 0.522147>, <0.0713845, 5.8378, -1.49568>, <0.577247, 0.468174, 0.669028>, <0.0879909, 5.81648, -1.49944> , <0.706982, 0.301667, 0.639666> }
	smooth_triangle { <0.0829823, 5.85349, -1.5179>, <0.630914, 0.542924, 0.55424>, <0.109299, 5.83678, -1.54374>, <0.845901, 0.44373, 0.295896>, <0.0887822, 5.86312, -1.5391> , <0.690672, 0.642959, 0.331022> }
	smooth_triangle { <0.109299, 5.83678, -1.54374>, <0.845901, 0.44373, 0.295896>, <0.0829823, 5.85349, -1.5179>, <0.630914, 0.542924, 0.55424>, <0.102196, 5.82883, -1.52225> , <0.772717, 0.360931, 0.522147> }
	smooth_triangle { <0.0887822, 5.86312, -1.5391>, <0.690672, 0.642959, 0.331022>, <0.111075, 5.84207, -1.5678>, <0.865282, 0.484749, 0.127688>, <0.0902316, 5.86882, -1.56308> , <0.706498, 0.688545, 0.163607> }
	smooth_triangle { <0.111075, 5.84207, -1.5678>, <0.865282, 0.484749, 0.127688>, <0.0887822, 5.86312, -1.5391>, <0.690672, 0.642959, 0.331022>, <0.109299, 5.83678, -1.54374> , <0.845901, 0.44373, 0.295896> }
	smooth_triangle { <0.0902316, 5.86882, -1.56308>, <0.706498, 0.688545, 0.163607>, <0.111075, 5.8467, -1.59405>, <0.863847, 0.503474, 0.0167971>, <0.0902316, 5.87345, -1.58933> , <0.705325, 0.706924, 0.0526835> }
	smooth_triangle { <0.111075, 5.8467, -1.59405>, <0.863847, 0.503474, 0.0167971>, <0.0902316, 5.86882, -1.56308>, <0.706498, 0.688545, 0.163607>, <0.111075, 5.84207, -1.5678> , <0.865282, 0.484749, 0.127688> }
	smooth_triangle { <0.0902316, 5.87345, -1.58933>, <0.705325, 0.706924, 0.0526835>, <0.107524, 5.84966, -1.62267>, <0.848053, 0.517372, -0.114596>, <0.0873327, 5.87558, -1.6181> , <0.692422, 0.717113, -0.0793745> }
	smooth_triangle { <0.107524, 5.84966, -1.62267>, <0.848053, 0.517372, -0.114596>, <0.0902316, 5.87345, -1.58933>, <0.705325, 0.706924, 0.0526835>, <0.111075, 5.8467, -1.59405> , <0.863847, 0.503474, 0.0167971> }
	smooth_triangle { <0.0873327, 5.87558, -1.6181>, <0.692422, 0.717113, -0.0793745>, <0.102196, 5.85055, -1.64542>, <0.796498, 0.521031, -0.306786>, <0.0829823, 5.87521, -1.64107> , <0.650324, 0.708628, -0.273724> }
	smooth_triangle { <0.102196, 5.85055, -1.64542>, <0.796498, 0.521031, -0.306786>, <0.0873327, 5.87558, -1.6181>, <0.692422, 0.717113, -0.0793745>, <0.107524, 5.84966, -1.62267> , <0.848053, 0.517372, -0.114596> }
	smooth_triangle { <0.102196, 5.85055, -1.64542>, <0.796498, 0.521031, -0.306786>, <0.0742841, 5.8702, -1.66277>, <0.544242, 0.646843, -0.534223>, <0.0829823, 5.87521, -1.64107> , <0.650324, 0.708628, -0.273724> }
	smooth_triangle { <0.0742841, 5.8702, -1.66277>, <0.544242, 0.646843, -0.534223>, <0.102196, 5.85055, -1.64542>, <0.796498, 0.521031, -0.306786>, <0.0915424, 5.84805, -1.66668> , <0.666558, 0.489854, -0.56191> }
	smooth_triangle { <0.075562, 5.84181, -1.68443>, <0.575355, 0.456925, -0.67837>, <0.0742841, 5.8702, -1.66277>, <0.544242, 0.646843, -0.534223>, <0.0915424, 5.84805, -1.66668> , <0.666558, 0.489854, -0.56191> }
	smooth_triangle { <0.0742841, 5.8702, -1.66277>, <0.544242, 0.646843, -0.534223>, <0.075562, 5.84181, -1.68443>, <0.575355, 0.456925, -0.67837>, <0.0612357, 5.8602, -1.68119> , <0.469778, 0.592441, -0.654463> }
	smooth_triangle { <0.0293951, 5.75753, -1.35993>, <0.866031, 0.492395, 0.0868215>, <0.0330754, 5.76623, -1.46042>, <0.965931, 0.254867, 0.0449405>, <0.0293951, 5.77498, -1.45887> , <0.866031, 0.492395, 0.0868215> }
	smooth_triangle { <0.0330754, 5.76623, -1.46042>, <0.965931, 0.254867, 0.0449405>, <0.0293951, 5.75753, -1.35993>, <0.866031, 0.492395, 0.0868215>, <0.0330754, 5.74878, -1.36148> , <0.965931, 0.254867, 0.0449405> }
	smooth_triangle { <0.0436005, 5.78376, -1.46149>, <0.314854, 0.0172329, 0.948984>, <0.0330754, 5.76623, -1.46042>, <0.234301, -0.106622, 0.9663>, <0.0489191, 5.77112, -1.46372> , <0.351166, -0.0690971, 0.93376> }
	smooth_triangle { <0.0330754, 5.76623, -1.46042>, <0.234301, -0.106622, 0.9663>, <0.0436005, 5.78376, -1.46149>, <0.314854, 0.0172329, 0.948984>, <0.0293951, 5.77498, -1.45887> , <0.210069, -0.0490308, 0.976456> }
	smooth_triangle { <0.0631327, 5.79701, -1.47164>, <0.495404, 0.139211, 0.857435>, <0.0489191, 5.77112, -1.46372>, <0.351166, -0.0690971, 0.93376>, <0.070704, 5.779, -1.47482> , <0.55255, 0.00337706, 0.833473> }
	smooth_triangle { <0.0489191, 5.77112, -1.46372>, <0.351166, -0.0690971, 0.93376>, <0.0631327, 5.79701, -1.47164>, <0.495404, 0.139211, 0.857435>, <0.0436005, 5.78376, -1.46149> , <0.314854, 0.0172329, 0.948984> }
	smooth_triangle { <0.0773377, 5.80758, -1.48435>, <0.634956, 0.242913, 0.733365>, <0.070704, 5.779, -1.47482>, <0.55255, 0.00337706, 0.833473>, <0.0865483, 5.78568, -1.48821> , <0.70819, 0.0687859, 0.702663> }
	smooth_triangle { <0.070704, 5.779, -1.47482>, <0.55255, 0.00337706, 0.833473>, <0.0773377, 5.80758, -1.48435>, <0.634956, 0.242913, 0.733365>, <0.0631327, 5.79701, -1.47164> , <0.495404, 0.139211, 0.857435> }
	smooth_triangle { <0.0773377, 5.80758, -1.48435>, <0.634956, 0.242913, 0.733365>, <0.0984313, 5.79166, -1.50382>, <0.788519, 0.10778, 0.605493>, <0.0879909, 5.81648, -1.49944> , <0.706982, 0.301667, 0.639666> }
	smooth_triangle { <0.0984313, 5.79166, -1.50382>, <0.788519, 0.10778, 0.605493>, <0.0773377, 5.80758, -1.48435>, <0.634956, 0.242913, 0.733365>, <0.0865483, 5.78568, -1.48821> , <0.70819, 0.0687859, 0.702663> }
	smooth_triangle { <0.0879909, 5.81648, -1.49944>, <0.706982, 0.301667, 0.639666>, <0.114274, 5.80011, -1.52731>, <0.861847, 0.149029, 0.484778>, <0.102196, 5.82883, -1.52225> , <0.772717, 0.360931, 0.522147> }
	smooth_triangle { <0.114274, 5.80011, -1.52731>, <0.861847, 0.149029, 0.484778>, <0.0879909, 5.81648, -1.49944>, <0.706982, 0.301667, 0.639666>, <0.0984313, 5.79166, -1.50382> , <0.788519, 0.10778, 0.605493> }
	smooth_triangle { <0.102196, 5.82883, -1.52225>, <0.772717, 0.360931, 0.522147>, <0.122197, 5.80612, -1.54915>, <0.943473, 0.211744, 0.254998>, <0.109299, 5.83678, -1.54374> , <0.845901, 0.44373, 0.295896> }
	smooth_triangle { <0.122197, 5.80612, -1.54915>, <0.943473, 0.211744, 0.254998>, <0.102196, 5.82883, -1.52225>, <0.772717, 0.360931, 0.522147>, <0.114274, 5.80011, -1.52731> , <0.861847, 0.149029, 0.484778> }
	smooth_triangle { <0.109299, 5.83678, -1.54374>, <0.845901, 0.44373, 0.295896>, <0.124177, 5.81092, -1.57329>, <0.965089, 0.247454, 0.085844>, <0.111075, 5.84207, -1.5678> , <0.865282, 0.484749, 0.127688> }
	smooth_triangle { <0.124177, 5.81092, -1.57329>, <0.965089, 0.247454, 0.085844>, <0.109299, 5.83678, -1.54374>, <0.845901, 0.44373, 0.295896>, <0.122197, 5.80612, -1.54915> , <0.943473, 0.211744, 0.254998> }
	smooth_triangle { <0.111075, 5.84207, -1.5678>, <0.865282, 0.484749, 0.127688>, <0.124177, 5.81555, -1.59954>, <0.963493, 0.266566, -0.0249942>, <0.111075, 5.8467, -1.59405> , <0.863847, 0.503474, 0.0167971> }
	smooth_triangle { <0.124177, 5.81555, -1.59954>, <0.963493, 0.266566, -0.0249942>, <0.111075, 5.84207, -1.5678>, <0.865282, 0.484749, 0.127688>, <0.124177, 5.81092, -1.57329> , <0.965089, 0.247454, 0.085844> }
	smooth_triangle { <0.111075, 5.8467, -1.59405>, <0.863847, 0.503474, 0.0167971>, <0.120216, 5.81948, -1.62799>, <0.94588, 0.284785, -0.155593>, <0.107524, 5.84966, -1.62267> , <0.848053, 0.517372, -0.114596> }
	smooth_triangle { <0.120216, 5.81948, -1.62799>, <0.94588, 0.284785, -0.155593>, <0.111075, 5.8467, -1.59405>, <0.863847, 0.503474, 0.0167971>, <0.124177, 5.81555, -1.59954> , <0.963493, 0.266566, -0.0249942> }
	smooth_triangle { <0.107524, 5.84966, -1.62267>, <0.848053, 0.517372, -0.114596>, <0.114274, 5.82183, -1.65048>, <0.888379, 0.30259, -0.345285>, <0.102196, 5.85055, -1.64542> , <0.796498, 0.521031, -0.306786> }
	smooth_triangle { <0.114274, 5.82183, -1.65048>, <0.888379, 0.30259, -0.345285>, <0.107524, 5.84966, -1.62267>, <0.848053, 0.517372, -0.114596>, <0.120216, 5.81948, -1.62799> , <0.94588, 0.284785, -0.155593> }
	smooth_triangle { <0.102196, 5.85055, -1.64542>, <0.796498, 0.521031, -0.306786>, <0.102392, 5.82226, -1.67122>, <0.743443, 0.307047, -0.59415>, <0.0915424, 5.84805, -1.66668> , <0.666558, 0.489854, -0.56191> }
	smooth_triangle { <0.102392, 5.82226, -1.67122>, <0.743443, 0.307047, -0.59415>, <0.102196, 5.85055, -1.64542>, <0.796498, 0.521031, -0.306786>, <0.114274, 5.82183, -1.65048> , <0.888379, 0.30259, -0.345285> }
	smooth_triangle { <0.0845675, 5.8204, -1.68821>, <0.641719, 0.299123, -0.706202>, <0.0915424, 5.84805, -1.66668>, <0.666558, 0.489854, -0.56191>, <0.102392, 5.82226, -1.67122> , <0.743443, 0.307047, -0.59415> }
	smooth_triangle { <0.0915424, 5.84805, -1.66668>, <0.666558, 0.489854, -0.56191>, <0.0845675, 5.8204, -1.68821>, <0.641719, 0.299123, -0.706202>, <0.075562, 5.84181, -1.68443> , <0.575355, 0.456925, -0.67837> }
	smooth_triangle { <0.0330754, 5.74878, -1.36148>, <0.965931, 0.254867, 0.0449405>, <0.0343307, 5.75684, -1.46207>, <1, 4.36614e-006, 8.52939e-007>, <0.0330754, 5.76623, -1.46042> , <0.965931, 0.254867, 0.0449405> }
	smooth_triangle { <0.0343307, 5.75684, -1.46207>, <1, 4.36614e-006, 8.52939e-007>, <0.0330754, 5.74878, -1.36148>, <0.965931, 0.254867, 0.0449405>, <0.0343307, 5.73939, -1.36313> , <1, 4.36614e-006, 8.52939e-007> }
	smooth_triangle { <0.0489191, 5.77112, -1.46372>, <0.351166, -0.0690971, 0.93376>, <0.0343307, 5.75684, -1.46207>, <0.242515, -0.168508, 0.955401>, <0.0507335, 5.75755, -1.46611> , <0.363528, -0.161784, 0.917427> }
	smooth_triangle { <0.0343307, 5.75684, -1.46207>, <0.242515, -0.168508, 0.955401>, <0.0489191, 5.77112, -1.46372>, <0.351166, -0.0690971, 0.93376>, <0.0330754, 5.76623, -1.46042> , <0.234301, -0.106622, 0.9663> }
	smooth_triangle { <0.070704, 5.779, -1.47482>, <0.55255, 0.00337706, 0.833473>, <0.0507335, 5.75755, -1.46611>, <0.363528, -0.161784, 0.917427>, <0.0732877, 5.75968, -1.47822> , <0.572041, -0.142425, 0.807765> }
	smooth_triangle { <0.0507335, 5.75755, -1.46611>, <0.363528, -0.161784, 0.917427>, <0.070704, 5.779, -1.47482>, <0.55255, 0.00337706, 0.833473>, <0.0489191, 5.77112, -1.46372> , <0.351166, -0.0690971, 0.93376> }
	smooth_triangle { <0.0865483, 5.78568, -1.48821>, <0.70819, 0.068786, 0.702663>, <0.0732877, 5.75968, -1.47822>, <0.572041, -0.142425, 0.807765>, <0.0896897, 5.76218, -1.49236> , <0.733167, -0.118093, 0.669717> }
	smooth_triangle { <0.0732877, 5.75968, -1.47822>, <0.572041, -0.142425, 0.807765>, <0.0865483, 5.78568, -1.48821>, <0.70819, 0.068786, 0.702663>, <0.070704, 5.779, -1.47482> , <0.55255, 0.00337706, 0.833473> }
	smooth_triangle { <0.0865483, 5.78568, -1.48821>, <0.70819, 0.068786, 0.702663>, <0.101992, 5.76502, -1.50851>, <0.816334, -0.1003, 0.568804>, <0.0984313, 5.79166, -1.50382> , <0.788519, 0.10778, 0.605493> }
	smooth_triangle { <0.101992, 5.76502, -1.50851>, <0.816334, -0.1003, 0.568804>, <0.0865483, 5.78568, -1.48821>, <0.70819, 0.068786, 0.702663>, <0.0896897, 5.76218, -1.49236> , <0.733167, -0.118093, 0.669717> }
	smooth_triangle { <0.0984313, 5.79166, -1.50382>, <0.788519, 0.10778, 0.605493>, <0.118395, 5.7693, -1.53274>, <0.892251, -0.0784079, 0.444679>, <0.114274, 5.80011, -1.52731> , <0.861847, 0.149029, 0.484778> }
	smooth_triangle { <0.118395, 5.7693, -1.53274>, <0.892251, -0.0784079, 0.444679>, <0.0984313, 5.79166, -1.50382>, <0.788519, 0.10778, 0.605493>, <0.101992, 5.76502, -1.50851> , <0.816334, -0.1003, 0.568804> }
	smooth_triangle { <0.114274, 5.80011, -1.52731>, <0.861847, 0.149029, 0.484778>, <0.126596, 5.77321, -1.55495>, <0.976755, -0.0372212, 0.211101>, <0.122197, 5.80612, -1.54915> , <0.943473, 0.211744, 0.254998> }
	smooth_triangle { <0.126596, 5.77321, -1.55495>, <0.976755, -0.0372212, 0.211101>, <0.114274, 5.80011, -1.52731>, <0.861847, 0.149029, 0.484778>, <0.118395, 5.7693, -1.53274> , <0.892251, -0.0784079, 0.444679> }
	smooth_triangle { <0.122197, 5.80612, -1.54915>, <0.943473, 0.211744, 0.254998>, <0.128647, 5.77749, -1.57918>, <0.999136, -0.00721669, 0.0409307>, <0.124177, 5.81092, -1.57329> , <0.965089, 0.247454, 0.085844> }
	smooth_triangle { <0.128647, 5.77749, -1.57918>, <0.999136, -0.00721669, 0.0409307>, <0.122197, 5.80612, -1.54915>, <0.943473, 0.211744, 0.254998>, <0.126596, 5.77321, -1.55495> , <0.976755, -0.0372212, 0.211101> }
	smooth_triangle { <0.124177, 5.81092, -1.57329>, <0.965089, 0.247454, 0.085844>, <0.128647, 5.78211, -1.60543>, <0.997483, 0.0123099, -0.0698241>, <0.124177, 5.81555, -1.59954> , <0.963493, 0.266566, -0.0249942> }
	smooth_triangle { <0.128647, 5.78211, -1.60543>, <0.997483, 0.0123099, -0.0698241>, <0.124177, 5.81092, -1.57329>, <0.965089, 0.247454, 0.085844>, <0.128647, 5.77749, -1.57918> , <0.999136, -0.00721669, 0.0409307> }
	smooth_triangle { <0.124177, 5.81555, -1.59954>, <0.963493, 0.266566, -0.0249942>, <0.124546, 5.7871, -1.6337>, <0.979245, 0.0351943, -0.199603>, <0.120216, 5.81948, -1.62799> , <0.94588, 0.284785, -0.155593> }
	smooth_triangle { <0.124546, 5.7871, -1.6337>, <0.979245, 0.0351943, -0.199603>, <0.124177, 5.81555, -1.59954>, <0.963493, 0.266566, -0.0249942>, <0.128647, 5.78211, -1.60543> , <0.997483, 0.0123099, -0.0698241> }
	smooth_triangle { <0.120216, 5.81948, -1.62799>, <0.94588, 0.284785, -0.155593>, <0.118395, 5.79102, -1.65591>, <0.91971, 0.0681757, -0.386634>, <0.114274, 5.82183, -1.65048> , <0.888379, 0.30259, -0.345285> }
	smooth_triangle { <0.118395, 5.79102, -1.65591>, <0.91971, 0.0681757, -0.386634>, <0.120216, 5.81948, -1.62799>, <0.94588, 0.284785, -0.155593>, <0.124546, 5.7871, -1.6337> , <0.979245, 0.0351943, -0.199603> }
	smooth_triangle { <0.114274, 5.82183, -1.65048>, <0.888379, 0.30259, -0.345285>, <0.106092, 5.79458, -1.67611>, <0.769666, 0.110857, -0.628749>, <0.102392, 5.82226, -1.67122> , <0.743443, 0.307047, -0.594151> }
	smooth_triangle { <0.106092, 5.79458, -1.67611>, <0.769666, 0.110857, -0.628749>, <0.114274, 5.82183, -1.65048>, <0.888379, 0.30259, -0.345285>, <0.118395, 5.79102, -1.65591> , <0.91971, 0.0681757, -0.386634> }
	smooth_triangle { <0.0876399, 5.79742, -1.69226>, <0.664367, 0.129769, -0.736055>, <0.102392, 5.82226, -1.67122>, <0.743443, 0.307047, -0.594151>, <0.106092, 5.79458, -1.67611> , <0.769666, 0.110857, -0.628749> }
	smooth_triangle { <0.102392, 5.82226, -1.67122>, <0.743443, 0.307047, -0.594151>, <0.0876399, 5.79742, -1.69226>, <0.664367, 0.129769, -0.736055>, <0.0845675, 5.8204, -1.68821> , <0.641719, 0.299123, -0.706202> }
	smooth_triangle { <0.0343307, 5.73939, -1.36313>, <1, 4.36614e-006, 8.52939e-007>, <0.0330754, 5.74745, -1.46373>, <0.965924, -0.254893, -0.0449417>, <0.0343307, 5.75684, -1.46207> , <1, 4.36614e-006, 8.52939e-007> }
	smooth_triangle { <0.0330754, 5.74745, -1.46373>, <0.965924, -0.254893, -0.0449417>, <0.0343307, 5.73939, -1.36313>, <1, 4.36614e-006, 8.52939e-007>, <0.0330754, 5.73, -1.36479> , <0.965924, -0.254893, -0.0449417> }
	smooth_triangle { <0.0343307, 5.75684, -1.46207>, <0.242515, -0.168508, 0.955401>, <0.0489191, 5.74398, -1.4685>, <0.351141, -0.254447, 0.901086>, <0.0507335, 5.75755, -1.46611> , <0.363528, -0.161784, 0.917427> }
	smooth_triangle { <0.0489191, 5.74398, -1.4685>, <0.351141, -0.254447, 0.901086>, <0.0343307, 5.75684, -1.46207>, <0.242515, -0.168508, 0.955401>, <0.0330754, 5.74745, -1.46373> , <0.234234, -0.230314, 0.944505> }
	smooth_triangle { <0.0507335, 5.75755, -1.46611>, <0.363528, -0.161784, 0.917427>, <0.070704, 5.74036, -1.48163>, <0.552545, -0.288246, 0.782054>, <0.0732877, 5.75968, -1.47822> , <0.572041, -0.142425, 0.807765> }
	smooth_triangle { <0.070704, 5.74036, -1.48163>, <0.552545, -0.288246, 0.782054>, <0.0507335, 5.75755, -1.46611>, <0.363528, -0.161784, 0.917427>, <0.0489191, 5.74398, -1.4685> , <0.351141, -0.254447, 0.901086> }
	smooth_triangle { <0.0732877, 5.75968, -1.47822>, <0.572041, -0.142425, 0.807765>, <0.0865483, 5.73868, -1.4965>, <0.708188, -0.304965, 0.636762>, <0.0896897, 5.76218, -1.49236> , <0.733167, -0.118093, 0.669717> }
	smooth_triangle { <0.0865483, 5.73868, -1.4965>, <0.708188, -0.304965, 0.636762>, <0.0732877, 5.75968, -1.47822>, <0.572041, -0.142425, 0.807765>, <0.070704, 5.74036, -1.48163> , <0.552545, -0.288246, 0.782054> }
	smooth_triangle { <0.0865483, 5.73868, -1.4965>, <0.708188, -0.304965, 0.636762>, <0.101992, 5.76502, -1.50851>, <0.816334, -0.1003, 0.568804>, <0.0896897, 5.76218, -1.49236> , <0.733167, -0.118093, 0.669717> }
	smooth_triangle { <0.101992, 5.76502, -1.50851>, <0.816334, -0.1003, 0.568804>, <0.0865483, 5.73868, -1.4965>, <0.708188, -0.304965, 0.636762>, <0.0984313, 5.73839, -1.51321> , <0.788526, -0.308368, 0.532105> }
	smooth_triangle { <0.101992, 5.76502, -1.50851>, <0.816334, -0.1003, 0.568804>, <0.114274, 5.73848, -1.53818>, <0.861843, -0.305842, 0.404584>, <0.118395, 5.7693, -1.53274> , <0.892251, -0.0784079, 0.444679> }
	smooth_triangle { <0.114274, 5.73848, -1.53818>, <0.861843, -0.305842, 0.404584>, <0.101992, 5.76502, -1.50851>, <0.816334, -0.1003, 0.568804>, <0.0984313, 5.73839, -1.51321> , <0.788526, -0.308368, 0.532105> }
	smooth_triangle { <0.118395, 5.7693, -1.53274>, <0.892251, -0.078408, 0.444679>, <0.122197, 5.74031, -1.56076>, <0.943474, -0.286184, 0.1672>, <0.126596, 5.77321, -1.55495> , <0.976755, -0.0372212, 0.211101> }
	smooth_triangle { <0.122197, 5.74031, -1.56076>, <0.943474, -0.286184, 0.1672>, <0.118395, 5.7693, -1.53274>, <0.892251, -0.078408, 0.444679>, <0.114274, 5.73848, -1.53818> , <0.861843, -0.305842, 0.404584> }
	smooth_triangle { <0.126596, 5.77321, -1.55495>, <0.976755, -0.0372212, 0.211101>, <0.124177, 5.74406, -1.58508>, <0.965091, -0.261886, -0.00398068>, <0.128647, 5.77749, -1.57918> , <0.999136, -0.00721669, 0.0409307> }
	smooth_triangle { <0.124177, 5.74406, -1.58508>, <0.965091, -0.261886, -0.00398068>, <0.126596, 5.77321, -1.55495>, <0.976755, -0.0372212, 0.211101>, <0.122197, 5.74031, -1.56076> , <0.943474, -0.286184, 0.1672> }
	smooth_triangle { <0.128647, 5.77749, -1.57918>, <0.999136, -0.00721669, 0.0409307>, <0.124177, 5.74869, -1.61133>, <0.963493, -0.241944, -0.114646>, <0.128647, 5.78211, -1.60543> , <0.997483, 0.0123099, -0.0698241> }
	smooth_triangle { <0.124177, 5.74869, -1.61133>, <0.963493, -0.241944, -0.114646>, <0.128647, 5.77749, -1.57918>, <0.999136, -0.00721669, 0.0409307>, <0.124177, 5.74406, -1.58508> , <0.965091, -0.261886, -0.00398068> }
	smooth_triangle { <0.128647, 5.78211, -1.60543>, <0.997483, 0.0123099, -0.0698241>, <0.120216, 5.75471, -1.63941>, <0.945877, -0.214402, -0.243615>, <0.124546, 5.7871, -1.6337> , <0.979245, 0.0351943, -0.199603> }
	smooth_triangle { <0.120216, 5.75471, -1.63941>, <0.945877, -0.214402, -0.243615>, <0.128647, 5.78211, -1.60543>, <0.997483, 0.0123099, -0.0698241>, <0.124177, 5.74869, -1.61133> , <0.963493, -0.241944, -0.114646> }
	smooth_triangle { <0.124546, 5.7871, -1.6337>, <0.979245, 0.0351943, -0.199603>, <0.114274, 5.7602, -1.66135>, <0.888368, -0.166244, -0.427979>, <0.118395, 5.79102, -1.65591> , <0.91971, 0.0681757, -0.386634> }
	smooth_triangle { <0.114274, 5.7602, -1.66135>, <0.888368, -0.166244, -0.427979>, <0.124546, 5.7871, -1.6337>, <0.979245, 0.0351943, -0.199603>, <0.120216, 5.75471, -1.63941> , <0.945877, -0.214402, -0.243615> }
	smooth_triangle { <0.118395, 5.79102, -1.65591>, <0.91971, 0.0681757, -0.386634>, <0.102392, 5.76689, -1.68099>, <0.743445, -0.0853188, -0.663332>, <0.106092, 5.79458, -1.67611> , <0.769666, 0.110857, -0.628749> }
	smooth_triangle { <0.102392, 5.76689, -1.68099>, <0.743445, -0.0853188, -0.663332>, <0.118395, 5.79102, -1.65591>, <0.91971, 0.0681757, -0.386634>, <0.114274, 5.7602, -1.66135> , <0.888368, -0.166244, -0.427979> }
	smooth_triangle { <0.102392, 5.76689, -1.68099>, <0.743445, -0.0853188, -0.663332>, <0.0876399, 5.79742, -1.69226>, <0.664367, 0.129769, -0.736055>, <0.106092, 5.79458, -1.67611> , <0.769666, 0.110857, -0.628749> }
	smooth_triangle { <0.0876399, 5.79742, -1.69226>, <0.664367, 0.129769, -0.736055>, <0.102392, 5.76689, -1.68099>, <0.743445, -0.0853188, -0.663332>, <0.0845675, 5.77445, -1.69631> , <0.641741, -0.0395618, -0.7659> }
	smooth_triangle { <0.0330754, 5.73, -1.36479>, <0.965924, -0.254893, -0.0449417>, <0.0293951, 5.7387, -1.46527>, <0.866045, -0.492371, -0.0868179>, <0.0330754, 5.74745, -1.46373> , <0.965924, -0.254893, -0.0449417> }
	smooth_triangle { <0.0293951, 5.7387, -1.46527>, <0.866045, -0.492371, -0.0868179>, <0.0330754, 5.73, -1.36479>, <0.965924, -0.254893, -0.0449417>, <0.0293951, 5.72125, -1.36633> , <0.866045, -0.492371, -0.0868179> }
	smooth_triangle { <0.0330754, 5.74745, -1.46373>, <0.234234, -0.230314, 0.944505>, <0.0436005, 5.73133, -1.47073>, <0.314823, -0.340776, 0.885866>, <0.0489191, 5.74398, -1.4685> , <0.351141, -0.254447, 0.901086> }
	smooth_triangle { <0.0436005, 5.73133, -1.47073>, <0.314823, -0.340776, 0.885866>, <0.0330754, 5.74745, -1.46373>, <0.234234, -0.230314, 0.944505>, <0.0293951, 5.7387, -1.46527> , <0.21005, -0.287878, 0.934347> }
	smooth_triangle { <0.0489191, 5.74398, -1.4685>, <0.351141, -0.254447, 0.901086>, <0.0631327, 5.72236, -1.48481>, <0.495386, -0.424106, 0.758108>, <0.070704, 5.74036, -1.48163> , <0.552545, -0.288246, 0.782054> }
	smooth_triangle { <0.0631327, 5.72236, -1.48481>, <0.495386, -0.424106, 0.758108>, <0.0489191, 5.74398, -1.4685>, <0.351141, -0.254447, 0.901086>, <0.0436005, 5.73133, -1.47073> , <0.314823, -0.340776, 0.885866> }
	smooth_triangle { <0.070704, 5.74036, -1.48163>, <0.552545, -0.288246, 0.782054>, <0.0773377, 5.71678, -1.50036>, <0.634948, -0.479097, 0.606059>, <0.0865483, 5.73868, -1.4965> , <0.708188, -0.304965, 0.636762> }
	smooth_triangle { <0.0773377, 5.71678, -1.50036>, <0.634948, -0.479097, 0.606059>, <0.070704, 5.74036, -1.48163>, <0.552545, -0.288246, 0.782054>, <0.0631327, 5.72236, -1.48481> , <0.495386, -0.424106, 0.758108> }
	smooth_triangle { <0.0773377, 5.71678, -1.50036>, <0.634948, -0.479097, 0.606059>, <0.0984313, 5.73839, -1.51321>, <0.788526, -0.308368, 0.532105>, <0.0865483, 5.73868, -1.4965> , <0.708188, -0.304965, 0.636762> }
	smooth_triangle { <0.0984313, 5.73839, -1.51321>, <0.788526, -0.308368, 0.532105>, <0.0773377, 5.71678, -1.50036>, <0.634948, -0.479097, 0.606059>, <0.0879909, 5.71357, -1.51759> , <0.706969, -0.50226, 0.497925> }
	smooth_triangle { <0.0879909, 5.71357, -1.51759>, <0.706969, -0.50226, 0.497925>, <0.114274, 5.73848, -1.53818>, <0.861843, -0.305842, 0.404584>, <0.0984313, 5.73839, -1.51321> , <0.788526, -0.308368, 0.532105> }
	smooth_triangle { <0.114274, 5.73848, -1.53818>, <0.861843, -0.305842, 0.404584>, <0.0879909, 5.71357, -1.51759>, <0.706969, -0.50226, 0.497925>, <0.102196, 5.70976, -1.54324> , <0.772718, -0.517751, 0.367206> }
	smooth_triangle { <0.102196, 5.70976, -1.54324>, <0.772718, -0.517751, 0.367206>, <0.122197, 5.74031, -1.56076>, <0.943474, -0.286184, 0.1672>, <0.114274, 5.73848, -1.53818> , <0.861843, -0.305842, 0.404584> }
	smooth_triangle { <0.122197, 5.74031, -1.56076>, <0.943474, -0.286184, 0.1672>, <0.102196, 5.70976, -1.54324>, <0.772718, -0.517751, 0.367206>, <0.109299, 5.70964, -1.56616> , <0.8459, -0.518177, 0.126279> }
	smooth_triangle { <0.122197, 5.74031, -1.56076>, <0.943474, -0.286184, 0.1672>, <0.111075, 5.7129, -1.59057>, <0.865274, -0.499201, -0.0458196>, <0.124177, 5.74406, -1.58508> , <0.965091, -0.261886, -0.00398068> }
	smooth_triangle { <0.111075, 5.7129, -1.59057>, <0.865274, -0.499201, -0.0458196>, <0.122197, 5.74031, -1.56076>, <0.943474, -0.286184, 0.1672>, <0.109299, 5.70964, -1.56616> , <0.8459, -0.518177, 0.126279> }
	smooth_triangle { <0.124177, 5.74406, -1.58508>, <0.965091, -0.261886, -0.00398068>, <0.111075, 5.71753, -1.61682>, <0.863847, -0.478857, -0.156412>, <0.124177, 5.74869, -1.61133> , <0.963493, -0.241944, -0.114646> }
	smooth_triangle { <0.111075, 5.71753, -1.61682>, <0.863847, -0.478857, -0.156412>, <0.124177, 5.74406, -1.58508>, <0.965091, -0.261886, -0.00398068>, <0.111075, 5.7129, -1.59057> , <0.865274, -0.499201, -0.0458196> }
	smooth_triangle { <0.124177, 5.74869, -1.61133>, <0.963493, -0.241944, -0.114646>, <0.107524, 5.72454, -1.64473>, <0.848054, -0.446985, -0.284621>, <0.120216, 5.75471, -1.63941> , <0.945877, -0.214402, -0.243615> }
	smooth_triangle { <0.107524, 5.72454, -1.64473>, <0.848054, -0.446985, -0.284621>, <0.124177, 5.74869, -1.61133>, <0.963493, -0.241944, -0.114646>, <0.111075, 5.71753, -1.61682> , <0.863847, -0.478857, -0.156412> }
	smooth_triangle { <0.120216, 5.75471, -1.63941>, <0.945877, -0.214402, -0.243615>, <0.102196, 5.73148, -1.66641>, <0.796489, -0.384684, -0.466502>, <0.114274, 5.7602, -1.66135> , <0.888367, -0.166244, -0.427979> }
	smooth_triangle { <0.102196, 5.73148, -1.66641>, <0.796489, -0.384684, -0.466502>, <0.120216, 5.75471, -1.63941>, <0.945877, -0.214402, -0.243615>, <0.107524, 5.72454, -1.64473> , <0.848054, -0.446985, -0.284621> }
	smooth_triangle { <0.114274, 5.7602, -1.66135>, <0.888368, -0.166244, -0.427979>, <0.0915424, 5.7411, -1.68553>, <0.666556, -0.268127, -0.695565>, <0.102392, 5.76689, -1.68099> , <0.743445, -0.0853188, -0.663332> }
	smooth_triangle { <0.0915424, 5.7411, -1.68553>, <0.666556, -0.268127, -0.695565>, <0.114274, 5.7602, -1.66135>, <0.888368, -0.166244, -0.427979>, <0.102196, 5.73148, -1.66641> , <0.796489, -0.384684, -0.466502> }
	smooth_triangle { <0.0915424, 5.7411, -1.68553>, <0.666556, -0.268127, -0.695565>, <0.0845675, 5.77445, -1.69631>, <0.641741, -0.0395618, -0.7659>, <0.102392, 5.76689, -1.68099> , <0.743445, -0.0853188, -0.663332> }
	smooth_triangle { <0.0845675, 5.77445, -1.69631>, <0.641741, -0.0395618, -0.7659>, <0.0915424, 5.7411, -1.68553>, <0.666556, -0.268127, -0.695565>, <0.075562, 5.75303, -1.70009> , <0.575375, -0.197366, -0.793719> }
	smooth_triangle { <0.0293951, 5.72125, -1.36633>, <0.866045, -0.492371, -0.0868179>, <0.0235403, 5.73118, -1.46659>, <0.707121, -0.69635, -0.122789>, <0.0293951, 5.7387, -1.46527> , <0.866045, -0.492371, -0.0868179> }
	smooth_triangle { <0.0235403, 5.73118, -1.46659>, <0.707121, -0.69635, -0.122789>, <0.0293951, 5.72125, -1.36633>, <0.866045, -0.492371, -0.0868179>, <0.0235403, 5.71374, -1.36765> , <0.707121, -0.69635, -0.122789> }
	smooth_triangle { <0.0293951, 5.7387, -1.46527>, <0.21005, -0.287878, 0.934347>, <0.035139, 5.72047, -1.47265>, <0.257077, -0.414927, 0.872781>, <0.0436005, 5.73133, -1.47073> , <0.314823, -0.340776, 0.885866> }
	smooth_triangle { <0.035139, 5.72047, -1.47265>, <0.257077, -0.414927, 0.872781>, <0.0293951, 5.7387, -1.46527>, <0.21005, -0.287878, 0.934347>, <0.0235403, 5.73118, -1.46659> , <0.171516, -0.337351, 0.925622> }
	smooth_triangle { <0.0436005, 5.73133, -1.47073>, <0.314823, -0.340776, 0.885866>, <0.0510873, 5.7069, -1.48753>, <0.40448, -0.540785, 0.737528>, <0.0631327, 5.72236, -1.48481> , <0.495386, -0.424106, 0.758108> }
	smooth_triangle { <0.0510873, 5.7069, -1.48753>, <0.40448, -0.540785, 0.737528>, <0.0436005, 5.73133, -1.47073>, <0.314823, -0.340776, 0.885866>, <0.035139, 5.72047, -1.47265> , <0.257077, -0.414927, 0.872781> }
	smooth_triangle { <0.0631327, 5.72236, -1.48481>, <0.495386, -0.424106, 0.758108>, <0.0626851, 5.69797, -1.50368>, <0.5184, -0.628647, 0.57971>, <0.0773377, 5.71678, -1.50036> , <0.634948, -0.479097, 0.606059> }
	smooth_triangle { <0.0626851, 5.69797, -1.50368>, <0.5184, -0.628647, 0.57971>, <0.0631327, 5.72236, -1.48481>, <0.495386, -0.424106, 0.758108>, <0.0510873, 5.7069, -1.48753> , <0.40448, -0.540785, 0.737528> }
	smooth_triangle { <0.0626851, 5.69797, -1.50368>, <0.5184, -0.628647, 0.57971>, <0.0879909, 5.71357, -1.51759>, <0.706969, -0.50226, 0.497925>, <0.0773377, 5.71678, -1.50036> , <0.634948, -0.479097, 0.606059> }
	smooth_triangle { <0.0879909, 5.71357, -1.51759>, <0.706969, -0.50226, 0.497925>, <0.0626851, 5.69797, -1.50368>, <0.5184, -0.628647, 0.57971>, <0.0713845, 5.69225, -1.52134> , <0.57723, -0.66876, 0.468578> }
	smooth_triangle { <0.0713845, 5.69225, -1.52134>, <0.57723, -0.66876, 0.468578>, <0.102196, 5.70976, -1.54324>, <0.772718, -0.517751, 0.367206>, <0.0879909, 5.71357, -1.51759> , <0.706969, -0.50226, 0.497925> }
	smooth_triangle { <0.102196, 5.70976, -1.54324>, <0.772718, -0.517751, 0.367206>, <0.0713845, 5.69225, -1.52134>, <0.57723, -0.66876, 0.468578>, <0.0829823, 5.6851, -1.54759> , <0.630929, -0.699739, 0.335103> }
	smooth_triangle { <0.0829823, 5.6851, -1.54759>, <0.630929, -0.699739, 0.335103>, <0.109299, 5.70964, -1.56616>, <0.8459, -0.518177, 0.126279>, <0.102196, 5.70976, -1.54324> , <0.772718, -0.517751, 0.367206> }
	smooth_triangle { <0.109299, 5.70964, -1.56616>, <0.8459, -0.518177, 0.126279>, <0.0829823, 5.6851, -1.54759>, <0.630929, -0.699739, 0.335103>, <0.0887822, 5.68331, -1.57081> , <0.690672, -0.717402, 0.0911401> }
	smooth_triangle { <0.109299, 5.70964, -1.56616>, <0.8459, -0.518177, 0.126279>, <0.0902316, 5.68615, -1.59529>, <0.706492, -0.702983, -0.0817495>, <0.111075, 5.7129, -1.59057> , <0.865274, -0.499201, -0.0458196> }
	smooth_triangle { <0.0902316, 5.68615, -1.59529>, <0.706492, -0.702983, -0.0817495>, <0.109299, 5.70964, -1.56616>, <0.8459, -0.518177, 0.126279>, <0.0887822, 5.68331, -1.57081> , <0.690672, -0.717402, 0.0911401> }
	smooth_triangle { <0.111075, 5.7129, -1.59057>, <0.865274, -0.499201, -0.0458196>, <0.0902316, 5.69078, -1.62154>, <0.705326, -0.682304, -0.192295>, <0.111075, 5.71753, -1.61682> , <0.863847, -0.478857, -0.156412> }
	smooth_triangle { <0.0902316, 5.69078, -1.62154>, <0.705326, -0.682304, -0.192295>, <0.111075, 5.7129, -1.59057>, <0.865274, -0.499201, -0.0458196>, <0.0902316, 5.68615, -1.59529> , <0.706492, -0.702983, -0.0817495> }
	smooth_triangle { <0.111075, 5.71753, -1.61682>, <0.863847, -0.478857, -0.156412>, <0.0873327, 5.69862, -1.6493>, <0.692423, -0.646725, -0.31984>, <0.107524, 5.72454, -1.64473> , <0.848054, -0.446985, -0.284621> }
	smooth_triangle { <0.0873327, 5.69862, -1.6493>, <0.692423, -0.646725, -0.31984>, <0.111075, 5.71753, -1.61682>, <0.863847, -0.478857, -0.156412>, <0.0902316, 5.69078, -1.62154> , <0.705326, -0.682304, -0.192295> }
	smooth_triangle { <0.107524, 5.72454, -1.64473>, <0.848054, -0.446985, -0.284621>, <0.0829823, 5.70682, -1.67076>, <0.650321, -0.572287, -0.49957>, <0.102196, 5.73148, -1.66641> , <0.796489, -0.384684, -0.466502> }
	smooth_triangle { <0.0829823, 5.70682, -1.67076>, <0.650321, -0.572287, -0.49957>, <0.107524, 5.72454, -1.64473>, <0.848054, -0.446985, -0.284621>, <0.0873327, 5.69862, -1.6493> , <0.692423, -0.646725, -0.31984> }
	smooth_triangle { <0.102196, 5.73148, -1.66641>, <0.796489, -0.384684, -0.466502>, <0.0742841, 5.71895, -1.68944>, <0.544234, -0.425107, -0.723252>, <0.0915424, 5.7411, -1.68553> , <0.666556, -0.268127, -0.695565> }
	smooth_triangle { <0.0742841, 5.71895, -1.68944>, <0.544234, -0.425107, -0.723252>, <0.102196, 5.73148, -1.66641>, <0.796489, -0.384684, -0.466502>, <0.0829823, 5.70682, -1.67076> , <0.650321, -0.572287, -0.49957> }
	smooth_triangle { <0.0742841, 5.71895, -1.68944>, <0.544234, -0.425107, -0.723252>, <0.075562, 5.75303, -1.70009>, <0.575375, -0.197366, -0.793719>, <0.0915424, 5.7411, -1.68553> , <0.666556, -0.268127, -0.695565> }
	smooth_triangle { <0.075562, 5.75303, -1.70009>, <0.575375, -0.197366, -0.793719>, <0.0742841, 5.71895, -1.68944>, <0.544234, -0.425107, -0.723252>, <0.0612357, 5.73465, -1.70333> , <0.469782, -0.33286, -0.817624> }
	smooth_triangle { <0.0159105, 5.70797, -1.36867>, <0.500019, -0.852857, -0.150385>, <0.0235403, 5.73118, -1.46659>, <0.707121, -0.69635, -0.122789>, <0.0235403, 5.71374, -1.36765> , <0.707121, -0.69635, -0.122789> }
	smooth_triangle { <0.0235403, 5.73118, -1.46659>, <0.707121, -0.69635, -0.122789>, <0.0159105, 5.70797, -1.36867>, <0.500019, -0.852857, -0.150385>, <0.0159105, 5.72542, -1.46761> , <0.500019, -0.852857, -0.150385> }
	smooth_triangle { <0.0235403, 5.73118, -1.46659>, <0.171516, -0.337351, 0.925622>, <0.0241118, 5.71214, -1.47412>, <0.181818, -0.471812, 0.862749>, <0.035139, 5.72047, -1.47265> , <0.257077, -0.414927, 0.872781> }
	smooth_triangle { <0.0241118, 5.71214, -1.47412>, <0.181818, -0.471812, 0.862749>, <0.0235403, 5.73118, -1.46659>, <0.171516, -0.337351, 0.925622>, <0.0159105, 5.72542, -1.46761> , <0.121308, -0.375301, 0.91893> }
	smooth_triangle { <0.035139, 5.72047, -1.47265>, <0.257077, -0.414927, 0.872781>, <0.0353888, 5.69504, -1.48962>, <0.286049, -0.630305, 0.721728>, <0.0510873, 5.7069, -1.48753> , <0.40448, -0.540785, 0.737528> }
	smooth_triangle { <0.0353888, 5.69504, -1.48962>, <0.286049, -0.630305, 0.721728>, <0.035139, 5.72047, -1.47265>, <0.257077, -0.414927, 0.872781>, <0.0241118, 5.71214, -1.47412> , <0.181818, -0.471812, 0.862749> }
	smooth_triangle { <0.0510873, 5.7069, -1.48753>, <0.40448, -0.540785, 0.737528>, <0.0435904, 5.68354, -1.50622>, <0.366574, -0.743389, 0.559461>, <0.0626851, 5.69797, -1.50368> , <0.5184, -0.628647, 0.57971> }
	smooth_triangle { <0.0435904, 5.68354, -1.50622>, <0.366574, -0.743389, 0.559461>, <0.0510873, 5.7069, -1.48753>, <0.40448, -0.540785, 0.737528>, <0.0353888, 5.69504, -1.48962> , <0.286049, -0.630305, 0.721728> }
	smooth_triangle { <0.0435904, 5.68354, -1.50622>, <0.366574, -0.743389, 0.559461>, <0.0713845, 5.69225, -1.52134>, <0.57723, -0.66876, 0.468578>, <0.0626851, 5.69797, -1.50368> , <0.5184, -0.628647, 0.57971> }
	smooth_triangle { <0.0713845, 5.69225, -1.52134>, <0.57723, -0.66876, 0.468578>, <0.0435904, 5.68354, -1.50622>, <0.366574, -0.743389, 0.559461>, <0.0497411, 5.6759, -1.52423> , <0.408141, -0.796529, 0.446052> }
	smooth_triangle { <0.0497411, 5.6759, -1.52423>, <0.408141, -0.796529, 0.446052>, <0.0829823, 5.6851, -1.54759>, <0.630929, -0.699739, 0.335103>, <0.0713845, 5.69225, -1.52134> , <0.57723, -0.66876, 0.468578> }
	smooth_triangle { <0.0829823, 5.6851, -1.54759>, <0.630929, -0.699739, 0.335103>, <0.0497411, 5.6759, -1.52423>, <0.408141, -0.796529, 0.446052>, <0.0579426, 5.66618, -1.55092> , <0.446104, -0.839392, 0.310503> }
	smooth_triangle { <0.0579426, 5.66618, -1.55092>, <0.446104, -0.839392, 0.310503>, <0.0887822, 5.68331, -1.57081>, <0.690672, -0.717402, 0.0911401>, <0.0829823, 5.6851, -1.54759> , <0.630929, -0.699739, 0.335103> }
	smooth_triangle { <0.0887822, 5.68331, -1.57081>, <0.690672, -0.717402, 0.0911401>, <0.0579426, 5.66618, -1.55092>, <0.446104, -0.839392, 0.310503>, <0.0620436, 5.6631, -1.57437> , <0.488381, -0.870266, 0.064201> }
	smooth_triangle { <0.0620436, 5.6631, -1.57437>, <0.488381, -0.870266, 0.064201>, <0.0902316, 5.68615, -1.59529>, <0.706492, -0.702983, -0.0817495>, <0.0887822, 5.68331, -1.57081> , <0.690672, -0.717402, 0.0911401> }
	smooth_triangle { <0.0902316, 5.68615, -1.59529>, <0.706492, -0.702983, -0.0817495>, <0.0620436, 5.6631, -1.57437>, <0.488381, -0.870266, 0.064201>, <0.0630682, 5.66563, -1.59891> , <0.49958, -0.859341, -0.109326> }
	smooth_triangle { <0.0630682, 5.66563, -1.59891>, <0.49958, -0.859341, -0.109326>, <0.0902316, 5.69078, -1.62154>, <0.705326, -0.682304, -0.192295>, <0.0902316, 5.68615, -1.59529> , <0.706492, -0.702983, -0.0817495> }
	smooth_triangle { <0.0902316, 5.69078, -1.62154>, <0.705326, -0.682304, -0.192295>, <0.0630682, 5.66563, -1.59891>, <0.49958, -0.859341, -0.109326>, <0.0630682, 5.67026, -1.62516> , <0.498747, -0.838407, -0.219829> }
	smooth_triangle { <0.0630682, 5.67026, -1.62516>, <0.498747, -0.838407, -0.219829>, <0.0873327, 5.69862, -1.6493>, <0.692423, -0.646725, -0.31984>, <0.0902316, 5.69078, -1.62154> , <0.705326, -0.682304, -0.192295> }
	smooth_triangle { <0.0873327, 5.69862, -1.6493>, <0.692423, -0.646725, -0.31984>, <0.0630682, 5.67026, -1.62516>, <0.498747, -0.838407, -0.219829>, <0.0610176, 5.67874, -1.65281> , <0.489621, -0.799971, -0.346869> }
	smooth_triangle { <0.0610176, 5.67874, -1.65281>, <0.489621, -0.799971, -0.346869>, <0.0829823, 5.70682, -1.67076>, <0.650321, -0.572287, -0.49957>, <0.0873327, 5.69862, -1.6493> , <0.692423, -0.646725, -0.31984> }
	smooth_triangle { <0.0829823, 5.70682, -1.67076>, <0.650321, -0.572287, -0.49957>, <0.0610176, 5.67874, -1.65281>, <0.489621, -0.799971, -0.346869>, <0.0579426, 5.6879, -1.6741> , <0.459848, -0.716225, -0.524939> }
	smooth_triangle { <0.0579426, 5.6879, -1.6741>, <0.459848, -0.716225, -0.524939>, <0.0742841, 5.71895, -1.68944>, <0.544234, -0.425107, -0.723252>, <0.0829823, 5.70682, -1.67076> , <0.650321, -0.572287, -0.49957> }
	smooth_triangle { <0.0742841, 5.71895, -1.68944>, <0.544234, -0.425107, -0.723252>, <0.0579426, 5.6879, -1.6741>, <0.459848, -0.716225, -0.524939>, <0.0517909, 5.70195, -1.69244> , <0.38483, -0.545563, -0.744491> }
	smooth_triangle { <0.0517909, 5.70195, -1.69244>, <0.38483, -0.545563, -0.744491>, <0.0612357, 5.73465, -1.70333>, <0.469782, -0.33286, -0.817624>, <0.0742841, 5.71895, -1.68944> , <0.544234, -0.425107, -0.723252> }
	smooth_triangle { <0.0612357, 5.73465, -1.70333>, <0.469782, -0.33286, -0.817624>, <0.0517909, 5.70195, -1.69244>, <0.38483, -0.545563, -0.744491>, <0.0425651, 5.72054, -1.70582> , <0.332181, -0.436823, -0.835968> }
	smooth_triangle { <0.00702537, 5.70434, -1.36931>, <0.258794, -0.951258, -0.167733>, <0.0159105, 5.72542, -1.46761>, <0.500019, -0.852857, -0.150385>, <0.0159105, 5.70797, -1.36867> , <0.500019, -0.852857, -0.150385> }
	smooth_triangle { <0.0159105, 5.72542, -1.46761>, <0.500019, -0.852857, -0.150385>, <0.00702537, 5.70434, -1.36931>, <0.258794, -0.951258, -0.167733>, <0.00702537, 5.72179, -1.46825> , <0.258794, -0.951258, -0.167733> }
	smooth_triangle { <0.0159105, 5.72542, -1.46761>, <0.121308, -0.375301, 0.91893>, <0.011271, 5.7069, -1.47504>, <0.0940895, -0.507586, 0.856449>, <0.0241118, 5.71214, -1.47412> , <0.181818, -0.471812, 0.862749> }
	smooth_triangle { <0.011271, 5.7069, -1.47504>, <0.0940895, -0.507586, 0.856449>, <0.0159105, 5.72542, -1.46761>, <0.121308, -0.375301, 0.91893>, <0.00702537, 5.72179, -1.46825> , <0.0627637, -0.399158, 0.914731> }
	smooth_triangle { <0.0241118, 5.71214, -1.47412>, <0.181818, -0.471812, 0.862749>, <0.0171079, 5.68758, -1.49094>, <0.148075, -0.686597, 0.711799>, <0.0353888, 5.69504, -1.48962> , <0.286049, -0.630305, 0.721728> }
	smooth_triangle { <0.0171079, 5.68758, -1.49094>, <0.148075, -0.686597, 0.711799>, <0.0241118, 5.71214, -1.47412>, <0.181818, -0.471812, 0.862749>, <0.011271, 5.7069, -1.47504> , <0.0940895, -0.507586, 0.856449> }
	smooth_triangle { <0.0171079, 5.68758, -1.49094>, <0.148075, -0.686597, 0.711799>, <0.0435904, 5.68354, -1.50622>, <0.366574, -0.743389, 0.559461>, <0.0353888, 5.69504, -1.48962> , <0.286049, -0.630305, 0.721728> }
	smooth_triangle { <0.0435904, 5.68354, -1.50622>, <0.366574, -0.743389, 0.559461>, <0.0171079, 5.68758, -1.49094>, <0.148075, -0.686597, 0.711799>, <0.0213535, 5.67447, -1.50782> , <0.189772, -0.815522, 0.546727> }
	smooth_triangle { <0.0213535, 5.67447, -1.50782>, <0.189772, -0.815522, 0.546727>, <0.0497411, 5.6759, -1.52423>, <0.408141, -0.796529, 0.446052>, <0.0435904, 5.68354, -1.50622> , <0.366574, -0.743389, 0.559461> }
	smooth_triangle { <0.0497411, 5.6759, -1.52423>, <0.408141, -0.796529, 0.446052>, <0.0213535, 5.67447, -1.50782>, <0.189772, -0.815522, 0.546727>, <0.0245373, 5.66562, -1.52604> , <0.21127, -0.876832, 0.431891> }
	smooth_triangle { <0.0245373, 5.66562, -1.52604>, <0.21127, -0.876832, 0.431891>, <0.0579426, 5.66618, -1.55092>, <0.446104, -0.839392, 0.310503>, <0.0497411, 5.6759, -1.52423> , <0.408141, -0.796529, 0.446052> }
	smooth_triangle { <0.0579426, 5.66618, -1.55092>, <0.446104, -0.839392, 0.310503>, <0.0245373, 5.66562, -1.52604>, <0.21127, -0.876832, 0.431891>, <0.0287823, 5.65429, -1.55302> , <0.230924, -0.927162, 0.295033> }
	smooth_triangle { <0.0287823, 5.65429, -1.55302>, <0.230924, -0.927162, 0.295033>, <0.0620436, 5.6631, -1.57437>, <0.488381, -0.870266, 0.064201>, <0.0579426, 5.66618, -1.55092> , <0.446104, -0.839392, 0.310503> }
	smooth_triangle { <0.0620436, 5.6631, -1.57437>, <0.488381, -0.870266, 0.064201>, <0.0287823, 5.65429, -1.55302>, <0.230924, -0.927162, 0.295033>, <0.0309058, 5.6504, -1.57661> , <0.252811, -0.966361, 0.0472473> }
	smooth_triangle { <0.0309058, 5.6504, -1.57661>, <0.252811, -0.966361, 0.0472473>, <0.0630682, 5.66563, -1.59891>, <0.49958, -0.859341, -0.109326>, <0.0620436, 5.6631, -1.57437> , <0.488381, -0.870266, 0.064201> }
	smooth_triangle { <0.0630682, 5.66563, -1.59891>, <0.49958, -0.859341, -0.109326>, <0.0309058, 5.6504, -1.57661>, <0.252811, -0.966361, 0.0472473>, <0.0314359, 5.65272, -1.60118> , <0.258596, -0.957644, -0.12667> }
	smooth_triangle { <0.0314359, 5.65272, -1.60118>, <0.258596, -0.957644, -0.12667>, <0.0630682, 5.67026, -1.62516>, <0.498747, -0.838407, -0.219829>, <0.0630682, 5.66563, -1.59891> , <0.49958, -0.859341, -0.109326> }
	smooth_triangle { <0.0630682, 5.67026, -1.62516>, <0.498747, -0.838407, -0.219829>, <0.0314359, 5.65272, -1.60118>, <0.258596, -0.957644, -0.12667>, <0.0314359, 5.65735, -1.62743> , <0.258159, -0.936549, -0.237128> }
	smooth_triangle { <0.0314359, 5.65735, -1.62743>, <0.258159, -0.936549, -0.237128>, <0.0610176, 5.67874, -1.65281>, <0.489621, -0.799971, -0.346869>, <0.0630682, 5.67026, -1.62516> , <0.498747, -0.838407, -0.219829> }
	smooth_triangle { <0.0610176, 5.67874, -1.65281>, <0.489621, -0.799971, -0.346869>, <0.0314359, 5.65735, -1.62743>, <0.258159, -0.936549, -0.237128>, <0.0303742, 5.66624, -1.65501> , <0.253444, -0.896315, -0.363849> }
	smooth_triangle { <0.0303742, 5.66624, -1.65501>, <0.253444, -0.896315, -0.363849>, <0.0579426, 5.6879, -1.6741>, <0.459848, -0.716225, -0.524939>, <0.0610176, 5.67874, -1.65281> , <0.489621, -0.799971, -0.346869> }
	smooth_triangle { <0.0579426, 5.6879, -1.6741>, <0.459848, -0.716225, -0.524939>, <0.0303742, 5.66624, -1.65501>, <0.253444, -0.896315, -0.363849>, <0.0287823, 5.676, -1.67619> , <0.238044, -0.806705, -0.540891> }
	smooth_triangle { <0.0287823, 5.676, -1.67619>, <0.238044, -0.806705, -0.540891>, <0.0517909, 5.70195, -1.69244>, <0.38483, -0.545563, -0.744491>, <0.0579426, 5.6879, -1.6741> , <0.459848, -0.716225, -0.524939> }
	smooth_triangle { <0.0517909, 5.70195, -1.69244>, <0.38483, -0.545563, -0.744491>, <0.0287823, 5.676, -1.67619>, <0.238044, -0.806705, -0.540891>, <0.0255984, 5.69127, -1.69432> , <0.199213, -0.621287, -0.757837> }
	smooth_triangle { <0.0255984, 5.69127, -1.69432>, <0.199213, -0.621287, -0.757837>, <0.0425651, 5.72054, -1.70582>, <0.332181, -0.436823, -0.835968>, <0.0517909, 5.70195, -1.69244> , <0.38483, -0.545563, -0.744491> }
	smooth_triangle { <0.0425651, 5.72054, -1.70582>, <0.332181, -0.436823, -0.835968>, <0.0255984, 5.69127, -1.69432>, <0.199213, -0.621287, -0.757837>, <0.0208226, 5.71167, -1.70738> , <0.171958, -0.502191, -0.847487> }
	smooth_triangle { <-0.0025097, 5.70311, -1.36953>, <2.10412e-007, -0.984808, -0.173649>, <0.00702537, 5.72179, -1.46825>, <0.258794, -0.951258, -0.167733>, <0.00702537, 5.70434, -1.36931> , <0.258794, -0.951258, -0.167733> }
	smooth_triangle { <0.00702537, 5.72179, -1.46825>, <0.258794, -0.951258, -0.167733>, <-0.0025097, 5.70311, -1.36953>, <2.10412e-007, -0.984808, -0.173649>, <-0.0025097, 5.72056, -1.46847> , <2.10412e-007, -0.984808, -0.173649> }
	smooth_triangle { <-0.0025097, 5.72056, -1.46847>, <-6.0138e-006, -0.407317, 0.913287>, <0.011271, 5.7069, -1.47504>, <0.0940895, -0.507586, 0.856449>, <0.00702537, 5.72179, -1.46825> , <0.0627637, -0.399158, 0.914731> }
	smooth_triangle { <0.011271, 5.7069, -1.47504>, <0.0940895, -0.507586, 0.856449>, <-0.0025097, 5.72056, -1.46847>, <-6.0138e-006, -0.407317, 0.913287>, <-0.0025097, 5.70511, -1.47536> , <-2.06441e-006, -0.519792, 0.854293> }
	smooth_triangle { <-0.0025097, 5.70511, -1.47536>, <-2.06441e-006, -0.519792, 0.854293>, <0.0171079, 5.68758, -1.49094>, <0.148075, -0.686597, 0.711799>, <0.011271, 5.7069, -1.47504> , <0.0940895, -0.507586, 0.856449> }
	smooth_triangle { <0.0171079, 5.68758, -1.49094>, <0.148075, -0.686597, 0.711799>, <-0.0025097, 5.70511, -1.47536>, <-2.06441e-006, -0.519792, 0.854293>, <-0.0025097, 5.68504, -1.49139> , <-3.4579e-007, -0.7058, 0.708412> }
	smooth_triangle { <-0.0025097, 5.68504, -1.49139>, <-3.4579e-007, -0.7058, 0.708412>, <0.0213535, 5.67447, -1.50782>, <0.189772, -0.815522, 0.546727>, <0.0171079, 5.68758, -1.49094> , <0.148075, -0.686597, 0.711799> }
	smooth_triangle { <0.0213535, 5.67447, -1.50782>, <0.189772, -0.815522, 0.546727>, <-0.0025097, 5.68504, -1.49139>, <-3.4579e-007, -0.7058, 0.708412>, <-0.0025097, 5.67138, -1.50837> , <-1.94923e-006, -0.840129, 0.542387> }
	smooth_triangle { <-0.0025097, 5.67138, -1.50837>, <-1.94923e-006, -0.840129, 0.542387>, <0.0245373, 5.66562, -1.52604>, <0.21127, -0.876832, 0.431891>, <0.0213535, 5.67447, -1.50782> , <0.189772, -0.815522, 0.546727> }
	smooth_triangle { <0.0245373, 5.66562, -1.52604>, <0.21127, -0.876832, 0.431891>, <-0.0025097, 5.67138, -1.50837>, <-1.94923e-006, -0.840129, 0.542387>, <-0.0025097, 5.66211, -1.52666> , <-1.64545e-006, -0.90422, 0.427067> }
	smooth_triangle { <-0.0025097, 5.66211, -1.52666>, <-1.64545e-006, -0.90422, 0.427067>, <0.0287823, 5.65429, -1.55302>, <0.230924, -0.927162, 0.295033>, <0.0245373, 5.66562, -1.52604> , <0.21127, -0.876832, 0.431891> }
	smooth_triangle { <0.0287823, 5.65429, -1.55302>, <0.230924, -0.927162, 0.295033>, <-0.0025097, 5.66211, -1.52666>, <-1.64545e-006, -0.90422, 0.427067>, <-0.0025097, 5.65023, -1.55374> , <-1.30329e-007, -0.9571, 0.289758> }
	smooth_triangle { <-0.0025097, 5.65023, -1.55374>, <-1.30329e-007, -0.9571, 0.289758>, <0.0309058, 5.6504, -1.57661>, <0.252811, -0.966361, 0.0472473>, <0.0287823, 5.65429, -1.55302> , <0.230924, -0.927162, 0.295033> }
	smooth_triangle { <0.0309058, 5.6504, -1.57661>, <0.252811, -0.966361, 0.0472473>, <-0.0025097, 5.65023, -1.55374>, <-1.30329e-007, -0.9571, 0.289758>, <-0.0025097, 5.64607, -1.57737> , <8.44911e-007, -0.99914, 0.0414686> }
	smooth_triangle { <-0.0025097, 5.64607, -1.57737>, <8.44911e-007, -0.99914, 0.0414686>, <0.0314359, 5.65272, -1.60118>, <0.258596, -0.957644, -0.12667>, <0.0309058, 5.6504, -1.57661> , <0.252811, -0.966361, 0.0472473> }
	smooth_triangle { <0.0314359, 5.65272, -1.60118>, <0.258596, -0.957644, -0.12667>, <-0.0025097, 5.64607, -1.57737>, <8.44911e-007, -0.99914, 0.0414686>, <-0.0025097, 5.64832, -1.60196> , <-5.26479e-008, -0.991172, -0.13258> }
	smooth_triangle { <-0.0025097, 5.64832, -1.60196>, <-5.26479e-008, -0.991172, -0.13258>, <0.0314359, 5.65735, -1.62743>, <0.258159, -0.936549, -0.237128>, <0.0314359, 5.65272, -1.60118> , <0.258596, -0.957644, -0.12667> }
	smooth_triangle { <0.0314359, 5.65735, -1.62743>, <0.258159, -0.936549, -0.237128>, <-0.0025097, 5.64832, -1.60196>, <-5.26479e-008, -0.991172, -0.13258>, <-0.0025097, 5.65295, -1.62821> , <5.64987e-008, -0.970019, -0.243028> }
	smooth_triangle { <-0.0025097, 5.65295, -1.62821>, <5.64987e-008, -0.970019, -0.243028>, <0.0303742, 5.66624, -1.65501>, <0.253444, -0.896315, -0.363849>, <0.0314359, 5.65735, -1.62743> , <0.258159, -0.936549, -0.237128> }
	smooth_triangle { <0.0303742, 5.66624, -1.65501>, <0.253444, -0.896315, -0.363849>, <-0.0025097, 5.65295, -1.62821>, <5.64987e-008, -0.970019, -0.243028>, <-0.0025097, 5.66197, -1.65577> , <2.2956e-007, -0.929174, -0.369642> }
	smooth_triangle { <-0.0025097, 5.66197, -1.65577>, <2.2956e-007, -0.929174, -0.369642>, <0.0287823, 5.676, -1.67619>, <0.238044, -0.806705, -0.540891>, <0.0303742, 5.66624, -1.65501> , <0.253444, -0.896315, -0.363849> }
	smooth_triangle { <0.0287823, 5.676, -1.67619>, <0.238044, -0.806705, -0.540891>, <-0.0025097, 5.66197, -1.65577>, <2.2956e-007, -0.929174, -0.369642>, <-0.0025097, 5.67195, -1.67691> , <-2.42407e-007, -0.837568, -0.546333> }
	smooth_triangle { <-0.0025097, 5.67195, -1.67691>, <-2.42407e-007, -0.837568, -0.546333>, <0.0255984, 5.69127, -1.69432>, <0.199213, -0.621287, -0.757837>, <0.0287823, 5.676, -1.67619> , <0.238044, -0.806705, -0.540891> }
	smooth_triangle { <0.0255984, 5.69127, -1.69432>, <0.199213, -0.621287, -0.757837>, <-0.0025097, 5.67195, -1.67691>, <-2.42407e-007, -0.837568, -0.546333>, <-0.0025097, 5.68762, -1.69496> , <-3.16284e-007, -0.647113, -0.762394> }
	smooth_triangle { <-0.0025097, 5.68762, -1.69496>, <-3.16284e-007, -0.647113, -0.762394>, <0.0208226, 5.71167, -1.70738>, <0.171958, -0.502191, -0.847487>, <0.0255984, 5.69127, -1.69432> , <0.199213, -0.621287, -0.757837> }
	smooth_triangle { <0.0208226, 5.71167, -1.70738>, <0.171958, -0.502191, -0.847487>, <-0.0025097, 5.68762, -1.69496>, <-3.16284e-007, -0.647113, -0.762394>, <-0.0025097, 5.70864, -1.70791> , <2.01934e-007, -0.524483, -0.851421> }
	smooth_triangle { <-0.0120448, 5.72179, -1.46825>, <-0.258796, -0.951257, -0.167736>, <-0.0025097, 5.70311, -1.36953>, <2.10412e-007, -0.984808, -0.173649>, <-0.0120448, 5.70434, -1.36931> , <-0.258796, -0.951257, -0.167736> }
	smooth_triangle { <-0.0025097, 5.70311, -1.36953>, <2.10412e-007, -0.984808, -0.173649>, <-0.0120448, 5.72179, -1.46825>, <-0.258796, -0.951257, -0.167736>, <-0.0025097, 5.72056, -1.46847> , <2.10412e-007, -0.984808, -0.173649> }
	smooth_triangle { <-0.0120448, 5.72179, -1.46825>, <-0.0627563, -0.39917, 0.914727>, <-0.0025097, 5.70511, -1.47536>, <-2.06441e-006, -0.519792, 0.854293>, <-0.0025097, 5.72056, -1.46847> , <-6.0138e-006, -0.407317, 0.913287> }
	smooth_triangle { <-0.0025097, 5.70511, -1.47536>, <-2.06441e-006, -0.519792, 0.854293>, <-0.0120448, 5.72179, -1.46825>, <-0.0627563, -0.39917, 0.914727>, <-0.0162904, 5.7069, -1.47504> , <-0.0940907, -0.507597, 0.856441> }
	smooth_triangle { <-0.0162904, 5.7069, -1.47504>, <-0.0940907, -0.507597, 0.856441>, <-0.0025097, 5.68504, -1.49139>, <-3.47669e-007, -0.7058, 0.708412>, <-0.0025097, 5.70511, -1.47536> , <-2.06535e-006, -0.519792, 0.854293> }
	smooth_triangle { <-0.0025097, 5.68504, -1.49139>, <-3.47669e-007, -0.7058, 0.708412>, <-0.0162904, 5.7069, -1.47504>, <-0.0940907, -0.507597, 0.856441>, <-0.0221273, 5.68758, -1.49094> , <-0.148071, -0.686592, 0.711805> }
	smooth_triangle { <-0.0263722, 5.67447, -1.50782>, <-0.189762, -0.81551, 0.546748>, <-0.0025097, 5.68504, -1.49139>, <-3.47669e-007, -0.7058, 0.708412>, <-0.0221273, 5.68758, -1.49094> , <-0.148071, -0.686592, 0.711805> }
	smooth_triangle { <-0.0025097, 5.68504, -1.49139>, <-3.47669e-007, -0.7058, 0.708412>, <-0.0263722, 5.67447, -1.50782>, <-0.189762, -0.81551, 0.546748>, <-0.0025097, 5.67138, -1.50837> , <-1.95111e-006, -0.840129, 0.542387> }
	smooth_triangle { <-0.0295561, 5.66562, -1.52604>, <-0.211267, -0.876834, 0.431889>, <-0.0025097, 5.67138, -1.50837>, <-1.95111e-006, -0.840129, 0.542387>, <-0.0263722, 5.67447, -1.50782> , <-0.189762, -0.81551, 0.546748> }
	smooth_triangle { <-0.0025097, 5.67138, -1.50837>, <-1.95111e-006, -0.840129, 0.542387>, <-0.0295561, 5.66562, -1.52604>, <-0.211267, -0.876834, 0.431889>, <-0.0025097, 5.66211, -1.52666> , <-1.64545e-006, -0.90422, 0.427067> }
	smooth_triangle { <-0.0338017, 5.65429, -1.55302>, <-0.230926, -0.927166, 0.295019>, <-0.0025097, 5.66211, -1.52666>, <-1.64545e-006, -0.90422, 0.427067>, <-0.0295561, 5.66562, -1.52604> , <-0.211267, -0.876834, 0.431889> }
	smooth_triangle { <-0.0025097, 5.66211, -1.52666>, <-1.64545e-006, -0.90422, 0.427067>, <-0.0338017, 5.65429, -1.55302>, <-0.230926, -0.927166, 0.295019>, <-0.0025097, 5.65023, -1.55374> , <-1.30329e-007, -0.9571, 0.289758> }
	smooth_triangle { <-0.0359251, 5.6504, -1.57661>, <-0.252812, -0.966361, 0.047256>, <-0.0025097, 5.65023, -1.55374>, <-1.30329e-007, -0.9571, 0.289758>, <-0.0338017, 5.65429, -1.55302> , <-0.230926, -0.927166, 0.295019> }
	smooth_triangle { <-0.0025097, 5.65023, -1.55374>, <-1.30329e-007, -0.9571, 0.289758>, <-0.0359251, 5.6504, -1.57661>, <-0.252812, -0.966361, 0.047256>, <-0.0025097, 5.64607, -1.57737> , <8.44911e-007, -0.99914, 0.0414686> }
	smooth_triangle { <-0.0364553, 5.65272, -1.60118>, <-0.258596, -0.957646, -0.126656>, <-0.0025097, 5.64607, -1.57737>, <8.44911e-007, -0.99914, 0.0414686>, <-0.0359251, 5.6504, -1.57661> , <-0.252812, -0.966361, 0.047256> }
	smooth_triangle { <-0.0025097, 5.64607, -1.57737>, <8.44911e-007, -0.99914, 0.0414686>, <-0.0364553, 5.65272, -1.60118>, <-0.258596, -0.957646, -0.126656>, <-0.0025097, 5.64832, -1.60196> , <-5.26479e-008, -0.991172, -0.13258> }
	smooth_triangle { <-0.0364553, 5.65735, -1.62743>, <-0.258159, -0.936548, -0.237133>, <-0.0025097, 5.64832, -1.60196>, <-5.26479e-008, -0.991172, -0.13258>, <-0.0364553, 5.65272, -1.60118> , <-0.258596, -0.957646, -0.126656> }
	smooth_triangle { <-0.0025097, 5.64832, -1.60196>, <-5.26479e-008, -0.991172, -0.13258>, <-0.0364553, 5.65735, -1.62743>, <-0.258159, -0.936548, -0.237133>, <-0.0025097, 5.65295, -1.62821> , <5.27321e-008, -0.970019, -0.243028> }
	smooth_triangle { <-0.0353936, 5.66624, -1.65501>, <-0.253444, -0.896311, -0.363858>, <-0.0025097, 5.65295, -1.62821>, <5.27321e-008, -0.970019, -0.243028>, <-0.0364553, 5.65735, -1.62743> , <-0.258159, -0.936548, -0.237133> }
	smooth_triangle { <-0.0025097, 5.65295, -1.62821>, <5.27321e-008, -0.970019, -0.243028>, <-0.0353936, 5.66624, -1.65501>, <-0.253444, -0.896311, -0.363858>, <-0.0025097, 5.66197, -1.65577> , <2.33323e-007, -0.929174, -0.369642> }
	smooth_triangle { <-0.0338017, 5.676, -1.67619>, <-0.238043, -0.806703, -0.540894>, <-0.0025097, 5.66197, -1.65577>, <2.33323e-007, -0.929174, -0.369642>, <-0.0353936, 5.66624, -1.65501> , <-0.253444, -0.896311, -0.363858> }
	smooth_triangle { <-0.0025097, 5.66197, -1.65577>, <2.33323e-007, -0.929174, -0.369642>, <-0.0338017, 5.676, -1.67619>, <-0.238043, -0.806703, -0.540894>, <-0.0025097, 5.67195, -1.67691> , <-2.40513e-007, -0.837568, -0.546333> }
	smooth_triangle { <-0.0306178, 5.69127, -1.69432>, <-0.19921, -0.62128, -0.757843>, <-0.0025097, 5.67195, -1.67691>, <-2.38619e-007, -0.837568, -0.546333>, <-0.0338017, 5.676, -1.67619> , <-0.238043, -0.806703, -0.540894> }
	smooth_triangle { <-0.0025097, 5.67195, -1.67691>, <-2.38619e-007, -0.837568, -0.546333>, <-0.0306178, 5.69127, -1.69432>, <-0.19921, -0.62128, -0.757843>, <-0.0025097, 5.68762, -1.69496> , <-3.16284e-007, -0.647113, -0.762394> }
	smooth_triangle { <-0.0025097, 5.68762, -1.69496>, <-3.16284e-007, -0.647113, -0.762394>, <-0.025842, 5.71167, -1.70738>, <-0.171954, -0.502177, -0.847497>, <-0.0025097, 5.70864, -1.70791> , <2.01934e-007, -0.524483, -0.851421> }
	smooth_triangle { <-0.025842, 5.71167, -1.70738>, <-0.171954, -0.502177, -0.847497>, <-0.0025097, 5.68762, -1.69496>, <-3.16284e-007, -0.647113, -0.762394>, <-0.0306178, 5.69127, -1.69432> , <-0.19921, -0.62128, -0.757843> }
	smooth_triangle { <-0.0209298, 5.72542, -1.46761>, <-0.500018, -0.852857, -0.150386>, <-0.0120448, 5.70434, -1.36931>, <-0.258796, -0.951257, -0.167736>, <-0.0209298, 5.70797, -1.36867> , <-0.500018, -0.852857, -0.150386> }
	smooth_triangle { <-0.0120448, 5.70434, -1.36931>, <-0.258796, -0.951257, -0.167736>, <-0.0209298, 5.72542, -1.46761>, <-0.500018, -0.852857, -0.150386>, <-0.0120448, 5.72179, -1.46825> , <-0.258796, -0.951257, -0.167736> }
	smooth_triangle { <-0.0209298, 5.72542, -1.46761>, <-0.121312, -0.375292, 0.918934>, <-0.0162904, 5.7069, -1.47504>, <-0.0940907, -0.507597, 0.856441>, <-0.0120448, 5.72179, -1.46825> , <-0.0627563, -0.39917, 0.914727> }
	smooth_triangle { <-0.0162904, 5.7069, -1.47504>, <-0.0940907, -0.507597, 0.856441>, <-0.0209298, 5.72542, -1.46761>, <-0.121312, -0.375292, 0.918934>, <-0.0291312, 5.71214, -1.47412> , <-0.181809, -0.4718, 0.862758> }
	smooth_triangle { <-0.0291312, 5.71214, -1.47412>, <-0.181809, -0.4718, 0.862758>, <-0.0221273, 5.68758, -1.49094>, <-0.148071, -0.686592, 0.711805>, <-0.0162904, 5.7069, -1.47504> , <-0.0940907, -0.507597, 0.856441> }
	smooth_triangle { <-0.0221273, 5.68758, -1.49094>, <-0.148071, -0.686592, 0.711805>, <-0.0291312, 5.71214, -1.47412>, <-0.181809, -0.4718, 0.862758>, <-0.0404082, 5.69504, -1.48962> , <-0.286035, -0.630289, 0.721747> }
	smooth_triangle { <-0.0486098, 5.68354, -1.50622>, <-0.366569, -0.743379, 0.559477>, <-0.0221273, 5.68758, -1.49094>, <-0.148071, -0.686592, 0.711805>, <-0.0404082, 5.69504, -1.48962> , <-0.286035, -0.630289, 0.721747> }
	smooth_triangle { <-0.0221273, 5.68758, -1.49094>, <-0.148071, -0.686592, 0.711805>, <-0.0486098, 5.68354, -1.50622>, <-0.366569, -0.743379, 0.559477>, <-0.0263722, 5.67447, -1.50782> , <-0.189762, -0.81551, 0.546748> }
	smooth_triangle { <-0.0547605, 5.6759, -1.52423>, <-0.408138, -0.796532, 0.44605>, <-0.0263722, 5.67447, -1.50782>, <-0.189762, -0.815511, 0.546748>, <-0.0486098, 5.68354, -1.50622> , <-0.366569, -0.743379, 0.559477> }
	smooth_triangle { <-0.0263722, 5.67447, -1.50782>, <-0.189762, -0.815511, 0.546748>, <-0.0547605, 5.6759, -1.52423>, <-0.408138, -0.796532, 0.44605>, <-0.0295561, 5.66562, -1.52604> , <-0.211267, -0.876834, 0.431889> }
	smooth_triangle { <-0.062962, 5.66618, -1.55092>, <-0.44611, -0.839401, 0.310471>, <-0.0295561, 5.66562, -1.52604>, <-0.211267, -0.876834, 0.431889>, <-0.0547605, 5.6759, -1.52423> , <-0.408138, -0.796532, 0.44605> }
	smooth_triangle { <-0.0295561, 5.66562, -1.52604>, <-0.211267, -0.876834, 0.431889>, <-0.062962, 5.66618, -1.55092>, <-0.44611, -0.839401, 0.310471>, <-0.0338017, 5.65429, -1.55302> , <-0.230926, -0.927166, 0.295019> }
	smooth_triangle { <-0.067063, 5.6631, -1.57437>, <-0.488382, -0.870266, 0.0641839>, <-0.0338017, 5.65429, -1.55302>, <-0.230926, -0.927166, 0.295019>, <-0.062962, 5.66618, -1.55092> , <-0.44611, -0.839401, 0.310471> }
	smooth_triangle { <-0.0338017, 5.65429, -1.55302>, <-0.230926, -0.927166, 0.295019>, <-0.067063, 5.6631, -1.57437>, <-0.488382, -0.870266, 0.0641839>, <-0.0359251, 5.6504, -1.57661> , <-0.252812, -0.966361, 0.047256> }
	smooth_triangle { <-0.0680875, 5.66563, -1.59891>, <-0.49958, -0.859343, -0.109315>, <-0.0359251, 5.6504, -1.57661>, <-0.252812, -0.966361, 0.047256>, <-0.067063, 5.6631, -1.57437> , <-0.488382, -0.870266, 0.0641839> }
	smooth_triangle { <-0.0359251, 5.6504, -1.57661>, <-0.252812, -0.966361, 0.047256>, <-0.0680875, 5.66563, -1.59891>, <-0.49958, -0.859343, -0.109315>, <-0.0364553, 5.65272, -1.60118> , <-0.258596, -0.957646, -0.126656> }
	smooth_triangle { <-0.0680875, 5.67026, -1.62516>, <-0.498747, -0.838408, -0.219828>, <-0.0364553, 5.65272, -1.60118>, <-0.258596, -0.957646, -0.126656>, <-0.0680875, 5.66563, -1.59891> , <-0.49958, -0.859343, -0.109315> }
	smooth_triangle { <-0.0364553, 5.65272, -1.60118>, <-0.258596, -0.957646, -0.126656>, <-0.0680875, 5.67026, -1.62516>, <-0.498747, -0.838408, -0.219828>, <-0.0364553, 5.65735, -1.62743> , <-0.258159, -0.936548, -0.237133> }
	smooth_triangle { <-0.066037, 5.67874, -1.65281>, <-0.489628, -0.799971, -0.346859>, <-0.0364553, 5.65735, -1.62743>, <-0.258159, -0.936548, -0.237133>, <-0.0680875, 5.67026, -1.62516> , <-0.498747, -0.838408, -0.219828> }
	smooth_triangle { <-0.0364553, 5.65735, -1.62743>, <-0.258159, -0.936548, -0.237133>, <-0.066037, 5.67874, -1.65281>, <-0.489628, -0.799971, -0.346859>, <-0.0353936, 5.66624, -1.65501> , <-0.253444, -0.896311, -0.363858> }
	smooth_triangle { <-0.062962, 5.6879, -1.6741>, <-0.459854, -0.716221, -0.52494>, <-0.0353936, 5.66624, -1.65501>, <-0.253444, -0.896311, -0.363858>, <-0.066037, 5.67874, -1.65281> , <-0.489628, -0.799971, -0.346859> }
	smooth_triangle { <-0.0353936, 5.66624, -1.65501>, <-0.253444, -0.896311, -0.363858>, <-0.062962, 5.6879, -1.6741>, <-0.459854, -0.716221, -0.52494>, <-0.0338017, 5.676, -1.67619> , <-0.238043, -0.806703, -0.540894> }
	smooth_triangle { <-0.0568102, 5.70195, -1.69244>, <-0.38483, -0.545558, -0.744495>, <-0.0338017, 5.676, -1.67619>, <-0.238043, -0.806703, -0.540894>, <-0.062962, 5.6879, -1.6741> , <-0.459854, -0.716221, -0.52494> }
	smooth_triangle { <-0.0338017, 5.676, -1.67619>, <-0.238043, -0.806703, -0.540894>, <-0.0568102, 5.70195, -1.69244>, <-0.38483, -0.545558, -0.744495>, <-0.0306178, 5.69127, -1.69432> , <-0.19921, -0.62128, -0.757843> }
	smooth_triangle { <-0.0306178, 5.69127, -1.69432>, <-0.19921, -0.62128, -0.757844>, <-0.0475838, 5.72054, -1.70582>, <-0.332188, -0.436827, -0.835963>, <-0.025842, 5.71167, -1.70738> , <-0.171954, -0.502177, -0.847497> }
	smooth_triangle { <-0.0475838, 5.72054, -1.70582>, <-0.332188, -0.436827, -0.835963>, <-0.0306178, 5.69127, -1.69432>, <-0.19921, -0.62128, -0.757844>, <-0.0568102, 5.70195, -1.69244> , <-0.38483, -0.545558, -0.744495> }
	smooth_triangle { <-0.0285597, 5.73118, -1.46659>, <-0.707119, -0.696353, -0.122784>, <-0.0209298, 5.70797, -1.36867>, <-0.500018, -0.852857, -0.150386>, <-0.0285597, 5.71374, -1.36765> , <-0.707119, -0.696353, -0.122784> }
	smooth_triangle { <-0.0209298, 5.70797, -1.36867>, <-0.500018, -0.852857, -0.150386>, <-0.0285597, 5.73118, -1.46659>, <-0.707119, -0.696353, -0.122784>, <-0.0209298, 5.72542, -1.46761> , <-0.500018, -0.852857, -0.150386> }
	smooth_triangle { <-0.0285597, 5.73118, -1.46659>, <-0.171505, -0.337353, 0.925623>, <-0.0291312, 5.71214, -1.47412>, <-0.181809, -0.4718, 0.862758>, <-0.0209298, 5.72542, -1.46761> , <-0.121312, -0.375292, 0.918934> }
	smooth_triangle { <-0.0291312, 5.71214, -1.47412>, <-0.181809, -0.4718, 0.862758>, <-0.0285597, 5.73118, -1.46659>, <-0.171505, -0.337353, 0.925623>, <-0.0401584, 5.72047, -1.47265> , <-0.257078, -0.41492, 0.872784> }
	smooth_triangle { <-0.0401584, 5.72047, -1.47265>, <-0.257078, -0.41492, 0.872784>, <-0.0404082, 5.69504, -1.48962>, <-0.286035, -0.630289, 0.721747>, <-0.0291312, 5.71214, -1.47412> , <-0.181809, -0.4718, 0.862758> }
	smooth_triangle { <-0.0404082, 5.69504, -1.48962>, <-0.286035, -0.630289, 0.721747>, <-0.0401584, 5.72047, -1.47265>, <-0.257078, -0.41492, 0.872784>, <-0.0561066, 5.7069, -1.48753> , <-0.404489, -0.540763, 0.737539> }
	smooth_triangle { <-0.0561066, 5.7069, -1.48753>, <-0.404489, -0.540763, 0.737539>, <-0.0486098, 5.68354, -1.50622>, <-0.366569, -0.743379, 0.559477>, <-0.0404082, 5.69504, -1.48962> , <-0.286035, -0.630289, 0.721747> }
	smooth_triangle { <-0.0486098, 5.68354, -1.50622>, <-0.366569, -0.743379, 0.559477>, <-0.0561066, 5.7069, -1.48753>, <-0.404489, -0.540763, 0.737539>, <-0.0677045, 5.69797, -1.50368> , <-0.518413, -0.628639, 0.579707> }
	smooth_triangle { <-0.0764039, 5.69225, -1.52134>, <-0.577233, -0.668765, 0.468567>, <-0.0486098, 5.68354, -1.50622>, <-0.366569, -0.743379, 0.559477>, <-0.0677045, 5.69797, -1.50368> , <-0.518413, -0.628639, 0.579707> }
	smooth_triangle { <-0.0486098, 5.68354, -1.50622>, <-0.366569, -0.743379, 0.559477>, <-0.0764039, 5.69225, -1.52134>, <-0.577233, -0.668765, 0.468567>, <-0.0547605, 5.6759, -1.52423> , <-0.408138, -0.796532, 0.44605> }
	smooth_triangle { <-0.0880017, 5.6851, -1.54759>, <-0.630922, -0.699741, 0.335111>, <-0.0547605, 5.6759, -1.52423>, <-0.408138, -0.796532, 0.44605>, <-0.0764039, 5.69225, -1.52134> , <-0.577233, -0.668765, 0.468567> }
	smooth_triangle { <-0.0547605, 5.6759, -1.52423>, <-0.408138, -0.796532, 0.44605>, <-0.0880017, 5.6851, -1.54759>, <-0.630922, -0.699741, 0.335111>, <-0.062962, 5.66618, -1.55092> , <-0.44611, -0.839401, 0.310471> }
	smooth_triangle { <-0.0938015, 5.68331, -1.57081>, <-0.690671, -0.717402, 0.0911445>, <-0.062962, 5.66618, -1.55092>, <-0.44611, -0.839401, 0.310471>, <-0.0880017, 5.6851, -1.54759> , <-0.630922, -0.699741, 0.335111> }
	smooth_triangle { <-0.062962, 5.66618, -1.55092>, <-0.44611, -0.839401, 0.310471>, <-0.0938015, 5.68331, -1.57081>, <-0.690671, -0.717402, 0.0911445>, <-0.067063, 5.6631, -1.57437> , <-0.488382, -0.870266, 0.0641839> }
	smooth_triangle { <-0.095251, 5.68615, -1.59529>, <-0.706492, -0.702984, -0.0817512>, <-0.067063, 5.6631, -1.57437>, <-0.488382, -0.870266, 0.0641839>, <-0.0938015, 5.68331, -1.57081> , <-0.690671, -0.717402, 0.0911445> }
	smooth_triangle { <-0.067063, 5.6631, -1.57437>, <-0.488382, -0.870266, 0.0641839>, <-0.095251, 5.68615, -1.59529>, <-0.706492, -0.702984, -0.0817512>, <-0.0680875, 5.66563, -1.59891> , <-0.49958, -0.859343, -0.109315> }
	smooth_triangle { <-0.095251, 5.69078, -1.62154>, <-0.705325, -0.682305, -0.192292>, <-0.0680875, 5.66563, -1.59891>, <-0.49958, -0.859343, -0.109315>, <-0.095251, 5.68615, -1.59529> , <-0.706492, -0.702984, -0.0817512> }
	smooth_triangle { <-0.0680875, 5.66563, -1.59891>, <-0.49958, -0.859343, -0.109315>, <-0.095251, 5.69078, -1.62154>, <-0.705325, -0.682305, -0.192292>, <-0.0680875, 5.67026, -1.62516> , <-0.498747, -0.838408, -0.219828> }
	smooth_triangle { <-0.0923506, 5.69862, -1.6493>, <-0.692422, -0.646728, -0.319836>, <-0.0680875, 5.67026, -1.62516>, <-0.498747, -0.838408, -0.219828>, <-0.095251, 5.69078, -1.62154> , <-0.705325, -0.682305, -0.192292> }
	smooth_triangle { <-0.0680875, 5.67026, -1.62516>, <-0.498747, -0.838408, -0.219828>, <-0.0923506, 5.69862, -1.6493>, <-0.692422, -0.646728, -0.319836>, <-0.066037, 5.67874, -1.65281> , <-0.489628, -0.799971, -0.346859> }
	smooth_triangle { <-0.0880017, 5.70682, -1.67076>, <-0.650319, -0.572288, -0.499572>, <-0.066037, 5.67874, -1.65281>, <-0.489628, -0.799971, -0.346859>, <-0.0923506, 5.69862, -1.6493> , <-0.692422, -0.646728, -0.319836> }
	smooth_triangle { <-0.066037, 5.67874, -1.65281>, <-0.489628, -0.799971, -0.346859>, <-0.0880017, 5.70682, -1.67076>, <-0.650319, -0.572288, -0.499572>, <-0.062962, 5.6879, -1.6741> , <-0.459853, -0.716221, -0.52494> }
	smooth_triangle { <-0.062962, 5.6879, -1.6741>, <-0.459854, -0.716221, -0.52494>, <-0.0793034, 5.71895, -1.68944>, <-0.544234, -0.42511, -0.72325>, <-0.0568102, 5.70195, -1.69244> , <-0.38483, -0.545558, -0.744495> }
	smooth_triangle { <-0.0793034, 5.71895, -1.68944>, <-0.544234, -0.42511, -0.72325>, <-0.062962, 5.6879, -1.6741>, <-0.459854, -0.716221, -0.52494>, <-0.0880017, 5.70682, -1.67076> , <-0.650319, -0.572288, -0.499572> }
	smooth_triangle { <-0.0568102, 5.70195, -1.69244>, <-0.38483, -0.545558, -0.744495>, <-0.0662547, 5.73465, -1.70333>, <-0.469785, -0.33287, -0.817618>, <-0.0475838, 5.72054, -1.70582> , <-0.332188, -0.436827, -0.835963> }
	smooth_triangle { <-0.0662547, 5.73465, -1.70333>, <-0.469785, -0.33287, -0.817618>, <-0.0568102, 5.70195, -1.69244>, <-0.38483, -0.545558, -0.744495>, <-0.0793034, 5.71895, -1.68944> , <-0.544234, -0.42511, -0.72325> }
	smooth_triangle { <-0.0285597, 5.73118, -1.46659>, <-0.707119, -0.696353, -0.122784>, <-0.0344145, 5.72125, -1.36633>, <-0.866062, -0.492343, -0.0868085>, <-0.0344145, 5.7387, -1.46527> , <-0.866062, -0.492343, -0.0868085> }
	smooth_triangle { <-0.0344145, 5.72125, -1.36633>, <-0.866062, -0.492343, -0.0868085>, <-0.0285597, 5.73118, -1.46659>, <-0.707119, -0.696353, -0.122784>, <-0.0285597, 5.71374, -1.36765> , <-0.707119, -0.696353, -0.122784> }
	smooth_triangle { <-0.0344145, 5.7387, -1.46527>, <-0.210019, -0.287849, 0.934364>, <-0.0401584, 5.72047, -1.47265>, <-0.257078, -0.41492, 0.872784>, <-0.0285597, 5.73118, -1.46659> , <-0.171505, -0.337353, 0.925623> }
	smooth_triangle { <-0.0401584, 5.72047, -1.47265>, <-0.257078, -0.41492, 0.872784>, <-0.0344145, 5.7387, -1.46527>, <-0.210019, -0.287849, 0.934364>, <-0.0486195, 5.73133, -1.47073> , <-0.314827, -0.340776, 0.885864> }
	smooth_triangle { <-0.0486195, 5.73133, -1.47073>, <-0.314827, -0.340776, 0.885864>, <-0.0561066, 5.7069, -1.48753>, <-0.404489, -0.540763, 0.737539>, <-0.0401584, 5.72047, -1.47265> , <-0.257078, -0.41492, 0.872784> }
	smooth_triangle { <-0.0561066, 5.7069, -1.48753>, <-0.404489, -0.540763, 0.737539>, <-0.0486195, 5.73133, -1.47073>, <-0.314827, -0.340776, 0.885864>, <-0.0681514, 5.72236, -1.48481> , <-0.495393, -0.424107, 0.758102> }
	smooth_triangle { <-0.0681514, 5.72236, -1.48481>, <-0.495393, -0.424107, 0.758102>, <-0.0677045, 5.69797, -1.50368>, <-0.518413, -0.628639, 0.579707>, <-0.0561066, 5.7069, -1.48753> , <-0.404489, -0.540763, 0.737539> }
	smooth_triangle { <-0.0677045, 5.69797, -1.50368>, <-0.518413, -0.628639, 0.579707>, <-0.0681514, 5.72236, -1.48481>, <-0.495393, -0.424107, 0.758102>, <-0.0823571, 5.71678, -1.50036> , <-0.634939, -0.47909, 0.606074> }
	smooth_triangle { <-0.0930109, 5.71357, -1.51759>, <-0.706975, -0.502256, 0.49792>, <-0.0677045, 5.69797, -1.50368>, <-0.518413, -0.628639, 0.579707>, <-0.0823571, 5.71678, -1.50036> , <-0.634939, -0.47909, 0.606074> }
	smooth_triangle { <-0.0677045, 5.69797, -1.50368>, <-0.518413, -0.628639, 0.579707>, <-0.0930109, 5.71357, -1.51759>, <-0.706975, -0.502256, 0.49792>, <-0.0764039, 5.69225, -1.52134> , <-0.577233, -0.668765, 0.468567> }
	smooth_triangle { <-0.107216, 5.70976, -1.54324>, <-0.772717, -0.517744, 0.367217>, <-0.0764039, 5.69225, -1.52134>, <-0.577233, -0.668765, 0.468567>, <-0.0930109, 5.71357, -1.51759> , <-0.706975, -0.502256, 0.49792> }
	smooth_triangle { <-0.0764039, 5.69225, -1.52134>, <-0.577233, -0.668765, 0.468567>, <-0.107216, 5.70976, -1.54324>, <-0.772717, -0.517744, 0.367217>, <-0.0880017, 5.6851, -1.54759> , <-0.630922, -0.699741, 0.335111> }
	smooth_triangle { <-0.114319, 5.70964, -1.56616>, <-0.845897, -0.518179, 0.126294>, <-0.0880017, 5.6851, -1.54759>, <-0.630922, -0.699741, 0.335111>, <-0.107216, 5.70976, -1.54324> , <-0.772717, -0.517744, 0.367217> }
	smooth_triangle { <-0.0880017, 5.6851, -1.54759>, <-0.630922, -0.699741, 0.335111>, <-0.114319, 5.70964, -1.56616>, <-0.845897, -0.518179, 0.126294>, <-0.0938015, 5.68331, -1.57081> , <-0.690671, -0.717402, 0.0911445> }
	smooth_triangle { <-0.095251, 5.68615, -1.59529>, <-0.706492, -0.702983, -0.0817512>, <-0.114319, 5.70964, -1.56616>, <-0.845897, -0.518179, 0.126294>, <-0.116095, 5.7129, -1.59057> , <-0.865274, -0.499201, -0.0458268> }
	smooth_triangle { <-0.114319, 5.70964, -1.56616>, <-0.845897, -0.518179, 0.126294>, <-0.095251, 5.68615, -1.59529>, <-0.706492, -0.702983, -0.0817512>, <-0.0938015, 5.68331, -1.57081> , <-0.690671, -0.717402, 0.0911445> }
	smooth_triangle { <-0.095251, 5.69078, -1.62154>, <-0.705325, -0.682305, -0.192292>, <-0.116095, 5.7129, -1.59057>, <-0.865274, -0.499201, -0.0458268>, <-0.116095, 5.71753, -1.61682> , <-0.863846, -0.478855, -0.15642> }
	smooth_triangle { <-0.116095, 5.7129, -1.59057>, <-0.865274, -0.499201, -0.0458268>, <-0.095251, 5.69078, -1.62154>, <-0.705325, -0.682305, -0.192292>, <-0.095251, 5.68615, -1.59529> , <-0.706492, -0.702984, -0.0817512> }
	smooth_triangle { <-0.0923506, 5.69862, -1.6493>, <-0.692422, -0.646728, -0.319836>, <-0.116095, 5.71753, -1.61682>, <-0.863846, -0.478855, -0.15642>, <-0.112544, 5.72454, -1.64473> , <-0.848049, -0.446991, -0.284625> }
	smooth_triangle { <-0.116095, 5.71753, -1.61682>, <-0.863846, -0.478855, -0.15642>, <-0.0923506, 5.69862, -1.6493>, <-0.692422, -0.646728, -0.319836>, <-0.095251, 5.69078, -1.62154> , <-0.705325, -0.682305, -0.192292> }
	smooth_triangle { <-0.0880017, 5.70682, -1.67076>, <-0.650319, -0.572288, -0.499572>, <-0.112544, 5.72454, -1.64473>, <-0.848049, -0.446991, -0.284625>, <-0.107216, 5.73148, -1.66641> , <-0.796486, -0.384693, -0.4665> }
	smooth_triangle { <-0.112544, 5.72454, -1.64473>, <-0.848049, -0.446991, -0.284625>, <-0.0880017, 5.70682, -1.67076>, <-0.650319, -0.572288, -0.499572>, <-0.0923506, 5.69862, -1.6493> , <-0.692422, -0.646728, -0.319836> }
	smooth_triangle { <-0.0793034, 5.71895, -1.68944>, <-0.544234, -0.42511, -0.72325>, <-0.107216, 5.73148, -1.66641>, <-0.796486, -0.384693, -0.4665>, <-0.0965617, 5.7411, -1.68553> , <-0.666552, -0.268123, -0.695571> }
	smooth_triangle { <-0.107216, 5.73148, -1.66641>, <-0.796486, -0.384693, -0.4665>, <-0.0793034, 5.71895, -1.68944>, <-0.544234, -0.42511, -0.72325>, <-0.0880017, 5.70682, -1.67076> , <-0.650319, -0.572288, -0.499572> }
	smooth_triangle { <-0.0793034, 5.71895, -1.68944>, <-0.544234, -0.42511, -0.72325>, <-0.0805806, 5.75303, -1.70009>, <-0.575361, -0.197356, -0.793732>, <-0.0662547, 5.73465, -1.70333> , <-0.469785, -0.33287, -0.817618> }
	smooth_triangle { <-0.0805806, 5.75303, -1.70009>, <-0.575361, -0.197356, -0.793732>, <-0.0793034, 5.71895, -1.68944>, <-0.544234, -0.42511, -0.72325>, <-0.0965617, 5.7411, -1.68553> , <-0.666552, -0.268123, -0.695571> }
	smooth_triangle { <-0.0344145, 5.7387, -1.46527>, <-0.866062, -0.492343, -0.0868085>, <-0.0380941, 5.73, -1.36479>, <-0.965924, -0.254895, -0.0449442>, <-0.0380941, 5.74745, -1.46373> , <-0.965924, -0.254895, -0.0449442> }
	smooth_triangle { <-0.0380941, 5.73, -1.36479>, <-0.965924, -0.254895, -0.0449442>, <-0.0344145, 5.7387, -1.46527>, <-0.866062, -0.492343, -0.0868085>, <-0.0344145, 5.72125, -1.36633> , <-0.866062, -0.492343, -0.0868085> }
	smooth_triangle { <-0.0380941, 5.74745, -1.46373>, <-0.234263, -0.230315, 0.944498>, <-0.0486195, 5.73133, -1.47073>, <-0.314827, -0.340776, 0.885864>, <-0.0344145, 5.7387, -1.46527> , <-0.210019, -0.287849, 0.934364> }
	smooth_triangle { <-0.0486195, 5.73133, -1.47073>, <-0.314827, -0.340776, 0.885864>, <-0.0380941, 5.74745, -1.46373>, <-0.234263, -0.230315, 0.944498>, <-0.0539385, 5.74398, -1.4685> , <-0.351147, -0.254448, 0.901084> }
	smooth_triangle { <-0.0539385, 5.74398, -1.4685>, <-0.351147, -0.254448, 0.901084>, <-0.0681514, 5.72236, -1.48481>, <-0.495393, -0.424107, 0.758102>, <-0.0486195, 5.73133, -1.47073> , <-0.314827, -0.340776, 0.885864> }
	smooth_triangle { <-0.0681514, 5.72236, -1.48481>, <-0.495393, -0.424107, 0.758102>, <-0.0539385, 5.74398, -1.4685>, <-0.351147, -0.254448, 0.901084>, <-0.0757234, 5.74037, -1.48163> , <-0.552549, -0.288259, 0.782046> }
	smooth_triangle { <-0.0757234, 5.74037, -1.48163>, <-0.552549, -0.288259, 0.782046>, <-0.0823571, 5.71678, -1.50036>, <-0.634939, -0.47909, 0.606074>, <-0.0681514, 5.72236, -1.48481> , <-0.495393, -0.424107, 0.758102> }
	smooth_triangle { <-0.0823571, 5.71678, -1.50036>, <-0.634939, -0.47909, 0.606074>, <-0.0757234, 5.74037, -1.48163>, <-0.552549, -0.288259, 0.782046>, <-0.0915677, 5.73868, -1.4965> , <-0.708185, -0.304974, 0.636761> }
	smooth_triangle { <-0.103451, 5.73839, -1.51321>, <-0.788525, -0.308361, 0.53211>, <-0.0823571, 5.71678, -1.50036>, <-0.634939, -0.47909, 0.606074>, <-0.0915677, 5.73868, -1.4965> , <-0.708185, -0.304974, 0.636761> }
	smooth_triangle { <-0.0823571, 5.71678, -1.50036>, <-0.634939, -0.47909, 0.606074>, <-0.103451, 5.73839, -1.51321>, <-0.788525, -0.308361, 0.53211>, <-0.0930109, 5.71357, -1.51759> , <-0.706975, -0.502256, 0.49792> }
	smooth_triangle { <-0.119294, 5.73848, -1.53818>, <-0.861851, -0.305827, 0.404578>, <-0.0930109, 5.71357, -1.51759>, <-0.706975, -0.502256, 0.49792>, <-0.103451, 5.73839, -1.51321> , <-0.788525, -0.308361, 0.53211> }
	smooth_triangle { <-0.0930109, 5.71357, -1.51759>, <-0.706975, -0.502256, 0.49792>, <-0.119294, 5.73848, -1.53818>, <-0.861851, -0.305827, 0.404578>, <-0.107216, 5.70976, -1.54324> , <-0.772717, -0.517744, 0.367217> }
	smooth_triangle { <-0.127217, 5.74031, -1.56076>, <-0.943473, -0.286178, 0.167216>, <-0.107216, 5.70976, -1.54324>, <-0.772717, -0.517744, 0.367217>, <-0.119294, 5.73848, -1.53818> , <-0.861851, -0.305827, 0.404578> }
	smooth_triangle { <-0.107216, 5.70976, -1.54324>, <-0.772717, -0.517744, 0.367217>, <-0.127217, 5.74031, -1.56076>, <-0.943473, -0.286178, 0.167216>, <-0.114319, 5.70964, -1.56616> , <-0.845897, -0.518179, 0.126294> }
	smooth_triangle { <-0.116095, 5.7129, -1.59057>, <-0.865274, -0.499201, -0.0458268>, <-0.127217, 5.74031, -1.56076>, <-0.943473, -0.286178, 0.167216>, <-0.129197, 5.74406, -1.58508> , <-0.96509, -0.261887, -0.00397314> }
	smooth_triangle { <-0.127217, 5.74031, -1.56076>, <-0.943473, -0.286178, 0.167216>, <-0.116095, 5.7129, -1.59057>, <-0.865274, -0.499201, -0.0458268>, <-0.114319, 5.70964, -1.56616> , <-0.845896, -0.518179, 0.126294> }
	smooth_triangle { <-0.116095, 5.71753, -1.61682>, <-0.863846, -0.478855, -0.15642>, <-0.129197, 5.74406, -1.58508>, <-0.96509, -0.261887, -0.00397314>, <-0.129197, 5.74869, -1.61133> , <-0.963492, -0.241941, -0.114663> }
	smooth_triangle { <-0.129197, 5.74406, -1.58508>, <-0.96509, -0.261887, -0.00397314>, <-0.116095, 5.71753, -1.61682>, <-0.863846, -0.478855, -0.15642>, <-0.116095, 5.7129, -1.59057> , <-0.865274, -0.499201, -0.0458268> }
	smooth_triangle { <-0.112544, 5.72454, -1.64473>, <-0.848049, -0.446991, -0.284625>, <-0.129197, 5.74869, -1.61133>, <-0.963492, -0.241941, -0.114663>, <-0.125236, 5.75471, -1.63941> , <-0.945878, -0.214395, -0.243617> }
	smooth_triangle { <-0.129197, 5.74869, -1.61133>, <-0.963492, -0.241941, -0.114663>, <-0.112544, 5.72454, -1.64473>, <-0.848049, -0.446991, -0.284625>, <-0.116095, 5.71753, -1.61682> , <-0.863846, -0.478855, -0.15642> }
	smooth_triangle { <-0.107216, 5.73148, -1.66641>, <-0.796486, -0.384693, -0.4665>, <-0.125236, 5.75471, -1.63941>, <-0.945878, -0.214395, -0.243617>, <-0.119294, 5.7602, -1.66135> , <-0.888381, -0.166237, -0.427953> }
	smooth_triangle { <-0.125236, 5.75471, -1.63941>, <-0.945878, -0.214395, -0.243617>, <-0.107216, 5.73148, -1.66641>, <-0.796486, -0.384693, -0.4665>, <-0.112544, 5.72454, -1.64473> , <-0.848049, -0.446991, -0.284625> }
	smooth_triangle { <-0.0965617, 5.7411, -1.68553>, <-0.666552, -0.268123, -0.695571>, <-0.119294, 5.7602, -1.66135>, <-0.888381, -0.166237, -0.427953>, <-0.107412, 5.76689, -1.68099> , <-0.743447, -0.085319, -0.66333> }
	smooth_triangle { <-0.119294, 5.7602, -1.66135>, <-0.888381, -0.166237, -0.427953>, <-0.0965617, 5.7411, -1.68553>, <-0.666552, -0.268123, -0.695571>, <-0.107216, 5.73148, -1.66641> , <-0.796486, -0.384693, -0.4665> }
	smooth_triangle { <-0.0965617, 5.7411, -1.68553>, <-0.666552, -0.268123, -0.695571>, <-0.0895869, 5.77445, -1.69631>, <-0.641719, -0.0395671, -0.765918>, <-0.0805806, 5.75303, -1.70009> , <-0.575361, -0.197356, -0.793732> }
	smooth_triangle { <-0.0895869, 5.77445, -1.69631>, <-0.641719, -0.0395671, -0.765918>, <-0.0965617, 5.7411, -1.68553>, <-0.666552, -0.268123, -0.695571>, <-0.107412, 5.76689, -1.68099> , <-0.743447, -0.085319, -0.66333> }
	smooth_triangle { <-0.0380941, 5.74745, -1.46373>, <-0.965924, -0.254895, -0.0449442>, <-0.0393501, 5.73939, -1.36313>, <-1, 4.32861e-006, 1.14321e-006>, <-0.0393501, 5.75684, -1.46207> , <-1, 4.32861e-006, 1.14321e-006> }
	smooth_triangle { <-0.0393501, 5.73939, -1.36313>, <-1, 4.32861e-006, 1.14321e-006>, <-0.0380941, 5.74745, -1.46373>, <-0.965924, -0.254895, -0.0449442>, <-0.0380941, 5.73, -1.36479> , <-0.965924, -0.254895, -0.0449442> }
	smooth_triangle { <-0.0393501, 5.75684, -1.46207>, <-0.242558, -0.168509, 0.95539>, <-0.0539385, 5.74398, -1.4685>, <-0.351147, -0.254448, 0.901084>, <-0.0380941, 5.74745, -1.46373> , <-0.234263, -0.230315, 0.944498> }
	smooth_triangle { <-0.0539385, 5.74398, -1.4685>, <-0.351147, -0.254448, 0.901084>, <-0.0393501, 5.75684, -1.46207>, <-0.242558, -0.168509, 0.95539>, <-0.0557528, 5.75755, -1.46611> , <-0.363544, -0.161784, 0.917421> }
	smooth_triangle { <-0.0557528, 5.75755, -1.46611>, <-0.363544, -0.161784, 0.917421>, <-0.0757234, 5.74037, -1.48163>, <-0.552549, -0.288259, 0.782046>, <-0.0539385, 5.74398, -1.4685> , <-0.351147, -0.254448, 0.901084> }
	smooth_triangle { <-0.0757234, 5.74037, -1.48163>, <-0.552549, -0.288259, 0.782046>, <-0.0557528, 5.75755, -1.46611>, <-0.363544, -0.161784, 0.917421>, <-0.078307, 5.75968, -1.47822> , <-0.572033, -0.142426, 0.80777> }
	smooth_triangle { <-0.078307, 5.75968, -1.47822>, <-0.572033, -0.142426, 0.80777>, <-0.0915677, 5.73868, -1.4965>, <-0.708185, -0.304974, 0.636761>, <-0.0757234, 5.74037, -1.48163> , <-0.552549, -0.288259, 0.782046> }
	smooth_triangle { <-0.0915677, 5.73868, -1.4965>, <-0.708185, -0.304974, 0.636761>, <-0.078307, 5.75968, -1.47822>, <-0.572033, -0.142426, 0.80777>, <-0.0947091, 5.76218, -1.49236> , <-0.733168, -0.118092, 0.669715> }
	smooth_triangle { <-0.107012, 5.76502, -1.50851>, <-0.816342, -0.100298, 0.568793>, <-0.0915677, 5.73868, -1.4965>, <-0.708185, -0.304974, 0.636761>, <-0.0947091, 5.76218, -1.49236> , <-0.733168, -0.118092, 0.669715> }
	smooth_triangle { <-0.0915677, 5.73868, -1.4965>, <-0.708185, -0.304974, 0.636761>, <-0.107012, 5.76502, -1.50851>, <-0.816342, -0.100298, 0.568793>, <-0.103451, 5.73839, -1.51321> , <-0.788525, -0.308361, 0.53211> }
	smooth_triangle { <-0.119294, 5.73848, -1.53818>, <-0.861851, -0.305827, 0.404578>, <-0.107012, 5.76502, -1.50851>, <-0.816342, -0.100298, 0.568793>, <-0.123414, 5.7693, -1.53274> , <-0.892251, -0.0784097, 0.44468> }
	smooth_triangle { <-0.107012, 5.76502, -1.50851>, <-0.816342, -0.100298, 0.568793>, <-0.119294, 5.73848, -1.53818>, <-0.861851, -0.305827, 0.404578>, <-0.103451, 5.73839, -1.51321> , <-0.788525, -0.308361, 0.53211> }
	smooth_triangle { <-0.127217, 5.74031, -1.56076>, <-0.943473, -0.286178, 0.167216>, <-0.123414, 5.7693, -1.53274>, <-0.892251, -0.0784097, 0.44468>, <-0.131616, 5.77321, -1.55495> , <-0.976753, -0.0372233, 0.21111> }
	smooth_triangle { <-0.123414, 5.7693, -1.53274>, <-0.892251, -0.0784097, 0.44468>, <-0.127217, 5.74031, -1.56076>, <-0.943473, -0.286178, 0.167216>, <-0.119294, 5.73848, -1.53818> , <-0.861851, -0.305827, 0.404578> }
	smooth_triangle { <-0.129197, 5.74406, -1.58508>, <-0.96509, -0.261887, -0.00397314>, <-0.131616, 5.77321, -1.55495>, <-0.976753, -0.0372233, 0.21111>, <-0.133667, 5.77749, -1.57918> , <-0.999136, -0.00721707, 0.040934> }
	smooth_triangle { <-0.131616, 5.77321, -1.55495>, <-0.976753, -0.0372233, 0.21111>, <-0.129197, 5.74406, -1.58508>, <-0.96509, -0.261887, -0.00397314>, <-0.127217, 5.74031, -1.56076> , <-0.943473, -0.286178, 0.167216> }
	smooth_triangle { <-0.129197, 5.74869, -1.61133>, <-0.963492, -0.241941, -0.114663>, <-0.133667, 5.77749, -1.57918>, <-0.999136, -0.00721707, 0.040934>, <-0.133667, 5.78211, -1.60543> , <-0.997483, 0.0123115, -0.0698319> }
	smooth_triangle { <-0.133667, 5.77749, -1.57918>, <-0.999136, -0.00721707, 0.040934>, <-0.129197, 5.74869, -1.61133>, <-0.963492, -0.241941, -0.114663>, <-0.129197, 5.74406, -1.58508> , <-0.96509, -0.261887, -0.00397314> }
	smooth_triangle { <-0.125236, 5.75471, -1.63941>, <-0.945878, -0.214395, -0.243617>, <-0.133667, 5.78211, -1.60543>, <-0.997483, 0.0123115, -0.0698318>, <-0.129565, 5.7871, -1.6337> , <-0.979243, 0.035196, -0.199612> }
	smooth_triangle { <-0.133667, 5.78211, -1.60543>, <-0.997483, 0.0123115, -0.0698318>, <-0.125236, 5.75471, -1.63941>, <-0.945878, -0.214395, -0.243617>, <-0.129197, 5.74869, -1.61133> , <-0.963492, -0.241941, -0.114663> }
	smooth_triangle { <-0.119294, 5.7602, -1.66135>, <-0.888381, -0.166237, -0.427953>, <-0.129565, 5.7871, -1.6337>, <-0.979243, 0.035196, -0.199612>, <-0.123414, 5.79102, -1.65591> , <-0.919721, 0.0681708, -0.386609> }
	smooth_triangle { <-0.129565, 5.7871, -1.6337>, <-0.979243, 0.035196, -0.199612>, <-0.119294, 5.7602, -1.66135>, <-0.888381, -0.166237, -0.427953>, <-0.125236, 5.75471, -1.63941> , <-0.945878, -0.214395, -0.243617> }
	smooth_triangle { <-0.107412, 5.76689, -1.68099>, <-0.743447, -0.085319, -0.66333>, <-0.123414, 5.79102, -1.65591>, <-0.919721, 0.0681708, -0.386609>, <-0.111113, 5.79458, -1.67611> , <-0.769676, 0.110856, -0.628737> }
	smooth_triangle { <-0.123414, 5.79102, -1.65591>, <-0.919721, 0.0681708, -0.386609>, <-0.107412, 5.76689, -1.68099>, <-0.743447, -0.085319, -0.66333>, <-0.119294, 5.7602, -1.66135> , <-0.888381, -0.166237, -0.427953> }
	smooth_triangle { <-0.107412, 5.76689, -1.68099>, <-0.743447, -0.085319, -0.66333>, <-0.0926593, 5.79742, -1.69226>, <-0.664349, 0.129773, -0.73607>, <-0.0895869, 5.77445, -1.69631> , <-0.641719, -0.0395671, -0.765918> }
	smooth_triangle { <-0.0926593, 5.79742, -1.69226>, <-0.664349, 0.129773, -0.73607>, <-0.107412, 5.76689, -1.68099>, <-0.743447, -0.085319, -0.66333>, <-0.111113, 5.79458, -1.67611> , <-0.769676, 0.110856, -0.628737> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <0.0169061, 5.64444, -1.56533>, <0.18201, 0.170797, -0.96835>, <0.0154498, 5.63626, -1.56677> , <0.168285, 0.110271, -0.979551> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <0.0154498, 5.63626, -1.56677>, <0.168285, 0.110271, -0.979551>, <0.0113006, 5.62932, -1.56799> , <0.129002, 0.0589469, -0.989891> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.37507e-007, 0.173652, -0.984807>, <0.0113006, 5.62932, -1.56799>, <0.129002, 0.0589469, -0.989891>, <0.00509123, 5.62469, -1.56881> , <0.0699375, 0.0245334, -0.99725> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.37507e-007, 0.173652, -0.984807>, <0.00509123, 5.62469, -1.56881>, <0.0699375, 0.0245334, -0.99725>, <-0.00223293, 5.62306, -1.56909> , <3.7754e-006, 0.0124308, -0.999923> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.37507e-007, 0.173652, -0.984807>, <-0.00223293, 5.62306, -1.56909>, <3.7754e-006, 0.0124308, -0.999923>, <-0.00955771, 5.62469, -1.56881> , <-0.0699416, 0.0245325, -0.997249> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <-0.00955771, 5.62469, -1.56881>, <-0.0699416, 0.0245325, -0.997249>, <-0.0157671, 5.62932, -1.56799> , <-0.12901, 0.0589431, -0.98989> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <-0.0157671, 5.62932, -1.56799>, <-0.12901, 0.0589431, -0.98989>, <-0.0199156, 5.63626, -1.56677> , <-0.16828, 0.110271, -0.979552> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <-0.0199156, 5.63626, -1.56677>, <-0.16828, 0.110271, -0.979552>, <-0.0213726, 5.64444, -1.56533> , <-0.181979, 0.170794, -0.968356> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <-0.0213726, 5.64444, -1.56533>, <-0.181979, 0.170794, -0.968356>, <-0.0199156, 5.65261, -1.56388> , <-0.1683, 0.231416, -0.958187> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.37507e-007, 0.173652, -0.984807>, <-0.0199156, 5.65261, -1.56388>, <-0.1683, 0.231416, -0.958187>, <-0.0157671, 5.65955, -1.56266> , <-0.129081, 0.28313, -0.950356> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <-0.0157671, 5.65955, -1.56266>, <-0.129081, 0.28313, -0.950356>, <-0.00955771, 5.66418, -1.56184> , <-0.0699205, 0.318028, -0.945499> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.38442e-007, 0.173652, -0.984807>, <-0.00955771, 5.66418, -1.56184>, <-0.0699205, 0.318028, -0.945499>, <-0.00223293, 5.66581, -1.56156> , <5.17725e-006, 0.33034, -0.943862> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.36572e-007, 0.173652, -0.984807>, <-0.00223293, 5.66581, -1.56156>, <5.17725e-006, 0.33034, -0.943862>, <0.00509123, 5.66418, -1.56184> , <0.0699207, 0.318037, -0.945496> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.38442e-007, 0.173652, -0.984807>, <0.00509123, 5.66418, -1.56184>, <0.0699207, 0.318037, -0.945496>, <0.0113006, 5.65955, -1.56266> , <0.129049, 0.283116, -0.950364> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.38442e-007, 0.173652, -0.984807>, <0.0113006, 5.65955, -1.56266>, <0.129049, 0.283116, -0.950364>, <0.0154498, 5.65261, -1.56388> , <0.168299, 0.231405, -0.958189> }
	smooth_triangle { <-0.00223293, 5.64474, -1.56705>, <3.39377e-007, 0.173652, -0.984807>, <0.0154498, 5.65261, -1.56388>, <0.168299, 0.231405, -0.958189>, <0.0169061, 5.64444, -1.56533> , <0.18201, 0.170797, -0.96835> }
	smooth_triangle { <0.0324522, 5.62749, -1.56304>, <0.333002, 0.0423942, -0.941973>, <0.0169061, 5.64444, -1.56533>, <0.18201, 0.170797, -0.96835>, <0.0353105, 5.64353, -1.56021> , <0.359658, 0.16205, -0.918905> }
	smooth_triangle { <0.0169061, 5.64444, -1.56533>, <0.18201, 0.170797, -0.96835>, <0.0324522, 5.62749, -1.56304>, <0.333002, 0.0423942, -0.941973>, <0.0154498, 5.63626, -1.56677> , <0.168285, 0.110271, -0.979551> }
	smooth_triangle { <0.0243142, 5.61389, -1.56544>, <0.256217, -0.0596489, -0.964777>, <0.0154498, 5.63626, -1.56677>, <0.168285, 0.110271, -0.979551>, <0.0324522, 5.62749, -1.56304> , <0.333002, 0.0423942, -0.941973> }
	smooth_triangle { <0.0154498, 5.63626, -1.56677>, <0.168285, 0.110271, -0.979551>, <0.0243142, 5.61389, -1.56544>, <0.256217, -0.0596489, -0.964777>, <0.0113006, 5.62932, -1.56799> , <0.129002, 0.0589469, -0.989891> }
	smooth_triangle { <0.0121344, 5.6048, -1.56704>, <0.1394, -0.128686, -0.981839>, <0.0113006, 5.62932, -1.56799>, <0.129002, 0.0589469, -0.989891>, <0.0243142, 5.61389, -1.56544> , <0.256217, -0.0596489, -0.964777> }
	smooth_triangle { <0.0113006, 5.62932, -1.56799>, <0.129002, 0.0589469, -0.989891>, <0.0121344, 5.6048, -1.56704>, <0.1394, -0.128686, -0.981839>, <0.00509123, 5.62469, -1.56881> , <0.0699375, 0.0245334, -0.99725> }
	smooth_triangle { <-0.00223293, 5.60161, -1.56761>, <2.61686e-006, -0.153156, -0.988202>, <0.00509123, 5.62469, -1.56881>, <0.0699375, 0.0245334, -0.99725>, <0.0121344, 5.6048, -1.56704> , <0.1394, -0.128686, -0.981839> }
	smooth_triangle { <0.00509123, 5.62469, -1.56881>, <0.0699375, 0.0245334, -0.99725>, <-0.00223293, 5.60161, -1.56761>, <2.61686e-006, -0.153156, -0.988202>, <-0.00223293, 5.62306, -1.56909> , <3.77634e-006, 0.0124308, -0.999923> }
	smooth_triangle { <-0.00223293, 5.60161, -1.56761>, <2.61686e-006, -0.153156, -0.988202>, <-0.00955771, 5.62469, -1.56881>, <-0.0699416, 0.0245325, -0.997249>, <-0.00223293, 5.62306, -1.56909> , <3.7754e-006, 0.0124308, -0.999923> }
	smooth_triangle { <-0.00955771, 5.62469, -1.56881>, <-0.0699416, 0.0245325, -0.997249>, <-0.00223293, 5.60161, -1.56761>, <2.61686e-006, -0.153156, -0.988202>, <-0.0166002, 5.6048, -1.56704> , <-0.139395, -0.12868, -0.98184> }
	smooth_triangle { <-0.0166002, 5.6048, -1.56704>, <-0.139395, -0.12868, -0.98184>, <-0.0157671, 5.62932, -1.56799>, <-0.12901, 0.0589431, -0.98989>, <-0.00955771, 5.62469, -1.56881> , <-0.0699416, 0.0245325, -0.997249> }
	smooth_triangle { <-0.0157671, 5.62932, -1.56799>, <-0.12901, 0.0589431, -0.98989>, <-0.0166002, 5.6048, -1.56704>, <-0.139395, -0.12868, -0.98184>, <-0.0287807, 5.61389, -1.56544> , <-0.256211, -0.0596421, -0.964779> }
	smooth_triangle { <-0.0287807, 5.61389, -1.56544>, <-0.256211, -0.0596421, -0.964779>, <-0.0199156, 5.63626, -1.56677>, <-0.16828, 0.110271, -0.979552>, <-0.0157671, 5.62932, -1.56799> , <-0.12901, 0.0589431, -0.98989> }
	smooth_triangle { <-0.0199156, 5.63626, -1.56677>, <-0.16828, 0.110271, -0.979552>, <-0.0287807, 5.61389, -1.56544>, <-0.256211, -0.0596421, -0.964779>, <-0.0369187, 5.62749, -1.56304> , <-0.333002, 0.042397, -0.941973> }
	smooth_triangle { <-0.0369187, 5.62749, -1.56304>, <-0.333002, 0.042397, -0.941973>, <-0.0213726, 5.64444, -1.56533>, <-0.181979, 0.170794, -0.968356>, <-0.0199156, 5.63626, -1.56677> , <-0.16828, 0.110271, -0.979552> }
	smooth_triangle { <-0.0213726, 5.64444, -1.56533>, <-0.181979, 0.170794, -0.968356>, <-0.0369187, 5.62749, -1.56304>, <-0.333002, 0.042397, -0.941973>, <-0.0397768, 5.64353, -1.56021> , <-0.359637, 0.162046, -0.918914> }
	smooth_triangle { <-0.0213726, 5.64444, -1.56533>, <-0.181979, 0.170794, -0.968356>, <-0.0369187, 5.65958, -1.55739>, <-0.333016, 0.28234, -0.899658>, <-0.0199156, 5.65261, -1.56388> , <-0.1683, 0.231416, -0.958187> }
	smooth_triangle { <-0.0369187, 5.65958, -1.55739>, <-0.333016, 0.28234, -0.899658>, <-0.0213726, 5.64444, -1.56533>, <-0.181979, 0.170794, -0.968356>, <-0.0397768, 5.64353, -1.56021> , <-0.359637, 0.162046, -0.918914> }
	smooth_triangle { <-0.0199156, 5.65261, -1.56388>, <-0.1683, 0.231416, -0.958187>, <-0.0287807, 5.67318, -1.55499>, <-0.25625, 0.386013, -0.886188>, <-0.0157671, 5.65955, -1.56266> , <-0.129081, 0.28313, -0.950356> }
	smooth_triangle { <-0.0287807, 5.67318, -1.55499>, <-0.25625, 0.386013, -0.886188>, <-0.0199156, 5.65261, -1.56388>, <-0.1683, 0.231416, -0.958187>, <-0.0369187, 5.65958, -1.55739> , <-0.333016, 0.28234, -0.899658> }
	smooth_triangle { <-0.0157671, 5.65955, -1.56266>, <-0.129081, 0.28313, -0.950355>, <-0.0166002, 5.68226, -1.55338>, <-0.139384, 0.456736, -0.878615>, <-0.00955771, 5.66418, -1.56184> , <-0.0699205, 0.318028, -0.945499> }
	smooth_triangle { <-0.0166002, 5.68226, -1.55338>, <-0.139384, 0.456736, -0.878615>, <-0.0157671, 5.65955, -1.56266>, <-0.129081, 0.28313, -0.950355>, <-0.0287807, 5.67318, -1.55499> , <-0.25625, 0.386013, -0.886188> }
	smooth_triangle { <-0.00955771, 5.66418, -1.56184>, <-0.0699205, 0.318028, -0.945499>, <-0.00223293, 5.68545, -1.55282>, <2.35817e-006, 0.481907, -0.876222>, <-0.00223293, 5.66581, -1.56156> , <5.17725e-006, 0.33034, -0.943862> }
	smooth_triangle { <-0.00223293, 5.68545, -1.55282>, <2.35817e-006, 0.481907, -0.876222>, <-0.00955771, 5.66418, -1.56184>, <-0.0699205, 0.318028, -0.945499>, <-0.0166002, 5.68226, -1.55338> , <-0.139384, 0.456736, -0.878615> }
	smooth_triangle { <-0.00223293, 5.66581, -1.56156>, <5.17725e-006, 0.33034, -0.943862>, <0.0121344, 5.68226, -1.55338>, <0.139395, 0.456746, -0.878608>, <0.00509123, 5.66418, -1.56184> , <0.0699207, 0.318037, -0.945496> }
	smooth_triangle { <0.0121344, 5.68226, -1.55338>, <0.139395, 0.456746, -0.878608>, <-0.00223293, 5.66581, -1.56156>, <5.17725e-006, 0.33034, -0.943862>, <-0.00223293, 5.68545, -1.55282> , <2.35817e-006, 0.481907, -0.876222> }
	smooth_triangle { <0.0113006, 5.65955, -1.56266>, <0.129049, 0.283116, -0.950364>, <0.0121344, 5.68226, -1.55338>, <0.139395, 0.456746, -0.878608>, <0.0243142, 5.67318, -1.55499> , <0.256219, 0.386004, -0.886201> }
	smooth_triangle { <0.0121344, 5.68226, -1.55338>, <0.139395, 0.456746, -0.878608>, <0.0113006, 5.65955, -1.56266>, <0.129049, 0.283116, -0.950364>, <0.00509123, 5.66418, -1.56184> , <0.0699207, 0.318037, -0.945496> }
	smooth_triangle { <0.0154498, 5.65261, -1.56388>, <0.168299, 0.231405, -0.958189>, <0.0243142, 5.67318, -1.55499>, <0.256219, 0.386004, -0.886201>, <0.0324522, 5.65958, -1.55739> , <0.333002, 0.282324, -0.899668> }
	smooth_triangle { <0.0243142, 5.67318, -1.55499>, <0.256219, 0.386004, -0.886201>, <0.0154498, 5.65261, -1.56388>, <0.168299, 0.231405, -0.958189>, <0.0113006, 5.65955, -1.56266> , <0.129049, 0.283116, -0.950364> }
	smooth_triangle { <0.0169061, 5.64444, -1.56533>, <0.18201, 0.170797, -0.96835>, <0.0324522, 5.65958, -1.55739>, <0.333002, 0.282324, -0.899668>, <0.0353105, 5.64353, -1.56021> , <0.359658, 0.16205, -0.918905> }
	smooth_triangle { <0.0324522, 5.65958, -1.55739>, <0.333002, 0.282324, -0.899668>, <0.0169061, 5.64444, -1.56533>, <0.18201, 0.170797, -0.96835>, <0.0154498, 5.65261, -1.56388> , <0.168299, 0.231405, -0.958189> }
	smooth_triangle { <0.0481231, 5.61878, -1.55602>, <0.489995, -0.0286311, -0.871255>, <0.0353105, 5.64353, -1.56021>, <0.359658, 0.16205, -0.918905>, <0.0522724, 5.64207, -1.55191> , <0.528038, 0.14746, -0.83632> }
	smooth_triangle { <0.0353105, 5.64353, -1.56021>, <0.359658, 0.16205, -0.918905>, <0.0481231, 5.61878, -1.55602>, <0.489995, -0.0286311, -0.871255>, <0.0324522, 5.62749, -1.56304> , <0.333002, 0.0423942, -0.941973> }
	smooth_triangle { <0.0363076, 5.59904, -1.5595>, <0.3791, -0.180387, -0.907603>, <0.0324522, 5.62749, -1.56304>, <0.333002, 0.0423942, -0.941973>, <0.0481231, 5.61878, -1.55602> , <0.489995, -0.0286311, -0.871255> }
	smooth_triangle { <0.0324522, 5.62749, -1.56304>, <0.333002, 0.0423942, -0.941973>, <0.0363076, 5.59904, -1.5595>, <0.3791, -0.180387, -0.907603>, <0.0243142, 5.61389, -1.56544> , <0.256217, -0.0596489, -0.964777> }
	smooth_triangle { <0.0186247, 5.58584, -1.56183>, <0.207429, -0.284693, -0.935908>, <0.0243142, 5.61389, -1.56544>, <0.256217, -0.0596489, -0.964777>, <0.0363076, 5.59904, -1.5595> , <0.3791, -0.180387, -0.907603> }
	smooth_triangle { <0.0243142, 5.61389, -1.56544>, <0.256217, -0.0596489, -0.964777>, <0.0186247, 5.58584, -1.56183>, <0.207429, -0.284693, -0.935908>, <0.0121344, 5.6048, -1.56704> , <0.1394, -0.128686, -0.981839> }
	smooth_triangle { <-0.00223293, 5.58121, -1.56264>, <-2.33851e-006, -0.32211, -0.946702>, <0.0121344, 5.6048, -1.56704>, <0.1394, -0.128686, -0.981839>, <0.0186247, 5.58584, -1.56183> , <0.207429, -0.284693, -0.935908> }
	smooth_triangle { <0.0121344, 5.6048, -1.56704>, <0.1394, -0.128686, -0.981839>, <-0.00223293, 5.58121, -1.56264>, <-2.33851e-006, -0.32211, -0.946702>, <-0.00223293, 5.60161, -1.56761> , <2.61686e-006, -0.153156, -0.988202> }
	smooth_triangle { <-0.00223293, 5.58121, -1.56264>, <-2.33851e-006, -0.32211, -0.946702>, <-0.0166002, 5.6048, -1.56704>, <-0.139395, -0.12868, -0.98184>, <-0.00223293, 5.60161, -1.56761> , <2.61686e-006, -0.153156, -0.988202> }
	smooth_triangle { <-0.0166002, 5.6048, -1.56704>, <-0.139395, -0.12868, -0.98184>, <-0.00223293, 5.58121, -1.56264>, <-2.33851e-006, -0.32211, -0.946702>, <-0.0230905, 5.58584, -1.56183> , <-0.207422, -0.2847, -0.935907> }
	smooth_triangle { <-0.0230905, 5.58584, -1.56183>, <-0.207422, -0.2847, -0.935907>, <-0.0287807, 5.61389, -1.56544>, <-0.256211, -0.0596421, -0.964779>, <-0.0166002, 5.6048, -1.56704> , <-0.139395, -0.12868, -0.98184> }
	smooth_triangle { <-0.0287807, 5.61389, -1.56544>, <-0.256211, -0.0596421, -0.964779>, <-0.0230905, 5.58584, -1.56183>, <-0.207422, -0.2847, -0.935907>, <-0.0407739, 5.59904, -1.5595> , <-0.379093, -0.180384, -0.907607> }
	smooth_triangle { <-0.0407739, 5.59904, -1.5595>, <-0.379093, -0.180384, -0.907607>, <-0.0369187, 5.62749, -1.56304>, <-0.333002, 0.042397, -0.941973>, <-0.0287807, 5.61389, -1.56544> , <-0.256211, -0.0596421, -0.964779> }
	smooth_triangle { <-0.0369187, 5.62749, -1.56304>, <-0.333002, 0.042397, -0.941973>, <-0.0407739, 5.59904, -1.5595>, <-0.379093, -0.180384, -0.907607>, <-0.0525894, 5.61878, -1.55602> , <-0.490002, -0.0286323, -0.871251> }
	smooth_triangle { <-0.0525894, 5.61878, -1.55602>, <-0.490002, -0.0286323, -0.871251>, <-0.0397768, 5.64353, -1.56021>, <-0.359637, 0.162046, -0.918914>, <-0.0369187, 5.62749, -1.56304> , <-0.333002, 0.042397, -0.941972> }
	smooth_triangle { <-0.0397768, 5.64353, -1.56021>, <-0.359637, 0.162046, -0.918914>, <-0.0525894, 5.61878, -1.55602>, <-0.490002, -0.0286323, -0.871251>, <-0.0567388, 5.64207, -1.55191> , <-0.528045, 0.147458, -0.836316> }
	smooth_triangle { <-0.0397768, 5.64353, -1.56021>, <-0.359637, 0.162046, -0.918914>, <-0.0525894, 5.66536, -1.54781>, <-0.489983, 0.324893, -0.808926>, <-0.0369187, 5.65958, -1.55739> , <-0.333016, 0.28234, -0.899658> }
	smooth_triangle { <-0.0525894, 5.66536, -1.54781>, <-0.489983, 0.324893, -0.808926>, <-0.0397768, 5.64353, -1.56021>, <-0.359637, 0.162046, -0.918914>, <-0.0567388, 5.64207, -1.55191> , <-0.528045, 0.147458, -0.836316> }
	smooth_triangle { <-0.0369187, 5.65958, -1.55739>, <-0.333016, 0.282339, -0.899658>, <-0.0407739, 5.6851, -1.54433>, <-0.379083, 0.479935, -0.791175>, <-0.0287807, 5.67318, -1.55499> , <-0.25625, 0.386013, -0.886188> }
	smooth_triangle { <-0.0407739, 5.6851, -1.54433>, <-0.379083, 0.479935, -0.791175>, <-0.0369187, 5.65958, -1.55739>, <-0.333016, 0.282339, -0.899658>, <-0.0525894, 5.66536, -1.54781> , <-0.489983, 0.324893, -0.808926> }
	smooth_triangle { <-0.0287807, 5.67318, -1.55499>, <-0.25625, 0.386013, -0.886188>, <-0.0230912, 5.6983, -1.542>, <-0.207435, 0.587621, -0.782095>, <-0.0166002, 5.68226, -1.55338> , <-0.139384, 0.456736, -0.878615> }
	smooth_triangle { <-0.0230912, 5.6983, -1.542>, <-0.207435, 0.587621, -0.782095>, <-0.0287807, 5.67318, -1.55499>, <-0.25625, 0.386013, -0.886188>, <-0.0407739, 5.6851, -1.54433> , <-0.379083, 0.479935, -0.791175> }
	smooth_triangle { <-0.0166002, 5.68226, -1.55338>, <-0.139384, 0.456736, -0.878615>, <-0.00223293, 5.70293, -1.54118>, <3.47673e-006, 0.626473, -0.779443>, <-0.00223293, 5.68545, -1.55282> , <2.35817e-006, 0.481907, -0.876222> }
	smooth_triangle { <-0.00223293, 5.70293, -1.54118>, <3.47673e-006, 0.626473, -0.779443>, <-0.0166002, 5.68226, -1.55338>, <-0.139384, 0.456736, -0.878615>, <-0.0230912, 5.6983, -1.542> , <-0.207435, 0.587621, -0.782095> }
	smooth_triangle { <-0.00223293, 5.68545, -1.55282>, <2.35817e-006, 0.481907, -0.876222>, <0.0186247, 5.6983, -1.542>, <0.20743, 0.587617, -0.782099>, <0.0121344, 5.68226, -1.55338> , <0.139395, 0.456746, -0.878608> }
	smooth_triangle { <0.0186247, 5.6983, -1.542>, <0.20743, 0.587617, -0.782099>, <-0.00223293, 5.68545, -1.55282>, <2.35817e-006, 0.481907, -0.876222>, <-0.00223293, 5.70293, -1.54118> , <3.47673e-006, 0.626473, -0.779443> }
	smooth_triangle { <0.0243142, 5.67318, -1.55499>, <0.256219, 0.386004, -0.886201>, <0.0186247, 5.6983, -1.542>, <0.20743, 0.587617, -0.782099>, <0.0363076, 5.6851, -1.54433> , <0.379079, 0.479924, -0.791184> }
	smooth_triangle { <0.0186247, 5.6983, -1.542>, <0.20743, 0.587617, -0.782099>, <0.0243142, 5.67318, -1.55499>, <0.256219, 0.386004, -0.886201>, <0.0121344, 5.68226, -1.55338> , <0.139395, 0.456746, -0.878608> }
	smooth_triangle { <0.0324522, 5.65958, -1.55739>, <0.333002, 0.282324, -0.899668>, <0.0363076, 5.6851, -1.54433>, <0.379079, 0.479924, -0.791184>, <0.0481231, 5.66536, -1.54781> , <0.48999, 0.324896, -0.80892> }
	smooth_triangle { <0.0363076, 5.6851, -1.54433>, <0.379079, 0.479924, -0.791184>, <0.0324522, 5.65958, -1.55739>, <0.333002, 0.282324, -0.899668>, <0.0243142, 5.67318, -1.55499> , <0.256219, 0.386004, -0.886201> }
	smooth_triangle { <0.0353105, 5.64353, -1.56021>, <0.359658, 0.16205, -0.918905>, <0.0481231, 5.66536, -1.54781>, <0.48999, 0.324896, -0.80892>, <0.0522724, 5.64207, -1.55191> , <0.528038, 0.14746, -0.83632> }
	smooth_triangle { <0.0481231, 5.66536, -1.54781>, <0.48999, 0.324896, -0.80892>, <0.0353105, 5.64353, -1.56021>, <0.359658, 0.16205, -0.918905>, <0.0324522, 5.65958, -1.55739> , <0.333002, 0.282324, -0.899668> }
	smooth_triangle { <0.0618577, 5.61046, -1.54597>, <0.633943, -0.100961, -0.766762>, <0.0522724, 5.64207, -1.55191>, <0.528038, 0.14746, -0.83632>, <0.0671388, 5.6401, -1.54075> , <0.681257, 0.127115, -0.720923> }
	smooth_triangle { <0.0522724, 5.64207, -1.55191>, <0.528038, 0.14746, -0.83632>, <0.0618577, 5.61046, -1.54597>, <0.633943, -0.100961, -0.766762>, <0.0481231, 5.61878, -1.55602> , <0.489995, -0.0286311, -0.871255> }
	smooth_triangle { <0.0468202, 5.58533, -1.5504>, <0.493895, -0.300388, -0.815987>, <0.0481231, 5.61878, -1.55602>, <0.489995, -0.0286311, -0.871255>, <0.0618577, 5.61046, -1.54597> , <0.633943, -0.100961, -0.766762> }
	smooth_triangle { <0.0481231, 5.61878, -1.55602>, <0.489995, -0.0286311, -0.871255>, <0.0468202, 5.58533, -1.5504>, <0.493895, -0.300388, -0.815987>, <0.0363076, 5.59904, -1.5595> , <0.3791, -0.180387, -0.907603> }
	smooth_triangle { <0.0243142, 5.56854, -1.55336>, <0.272247, -0.440459, -0.855498>, <0.0363076, 5.59904, -1.5595>, <0.379101, -0.180387, -0.907603>, <0.0468202, 5.58533, -1.5504> , <0.493895, -0.300388, -0.815987> }
	smooth_triangle { <0.0363076, 5.59904, -1.5595>, <0.379101, -0.180387, -0.907603>, <0.0243142, 5.56854, -1.55336>, <0.272247, -0.440459, -0.855498>, <0.0186247, 5.58584, -1.56183> , <0.207429, -0.284693, -0.935908> }
	smooth_triangle { <-0.00223293, 5.56264, -1.5544>, <-3.81883e-007, -0.491504, -0.870875>, <0.0186247, 5.58584, -1.56183>, <0.207429, -0.284693, -0.935908>, <0.0243142, 5.56854, -1.55336> , <0.272247, -0.440459, -0.855498> }
	smooth_triangle { <0.0186247, 5.58584, -1.56183>, <0.207429, -0.284693, -0.935908>, <-0.00223293, 5.56264, -1.5544>, <-3.81883e-007, -0.491504, -0.870875>, <-0.00223293, 5.58121, -1.56264> , <-2.33663e-006, -0.32211, -0.946702> }
	smooth_triangle { <-0.00223293, 5.56264, -1.5544>, <-3.81883e-007, -0.491504, -0.870875>, <-0.0230905, 5.58584, -1.56183>, <-0.207422, -0.2847, -0.935907>, <-0.00223293, 5.58121, -1.56264> , <-2.33851e-006, -0.32211, -0.946702> }
	smooth_triangle { <-0.0230905, 5.58584, -1.56183>, <-0.207422, -0.2847, -0.935907>, <-0.00223293, 5.56264, -1.5544>, <-3.81883e-007, -0.491504, -0.870875>, <-0.0287807, 5.56854, -1.55336> , <-0.272249, -0.440467, -0.855494> }
	smooth_triangle { <-0.0287807, 5.56854, -1.55336>, <-0.272249, -0.440467, -0.855494>, <-0.0407739, 5.59904, -1.5595>, <-0.379093, -0.180384, -0.907607>, <-0.0230905, 5.58584, -1.56183> , <-0.207422, -0.2847, -0.935907> }
	smooth_triangle { <-0.0407739, 5.59904, -1.5595>, <-0.379093, -0.180384, -0.907607>, <-0.0287807, 5.56854, -1.55336>, <-0.272249, -0.440467, -0.855494>, <-0.0512862, 5.58533, -1.5504> , <-0.493906, -0.3004, -0.815976> }
	smooth_triangle { <-0.0512862, 5.58533, -1.5504>, <-0.493906, -0.3004, -0.815976>, <-0.0525894, 5.61878, -1.55602>, <-0.490002, -0.0286323, -0.871251>, <-0.0407739, 5.59904, -1.5595> , <-0.379093, -0.180384, -0.907607> }
	smooth_triangle { <-0.0525894, 5.61878, -1.55602>, <-0.490002, -0.0286323, -0.871251>, <-0.0512862, 5.58533, -1.5504>, <-0.493906, -0.3004, -0.815976>, <-0.066324, 5.61046, -1.54597> , <-0.633951, -0.100968, -0.766754> }
	smooth_triangle { <-0.066324, 5.61046, -1.54597>, <-0.633951, -0.100968, -0.766754>, <-0.0567388, 5.64207, -1.55191>, <-0.528045, 0.147458, -0.836316>, <-0.0525894, 5.61878, -1.55602> , <-0.490002, -0.0286323, -0.871251> }
	smooth_triangle { <-0.0567388, 5.64207, -1.55191>, <-0.528045, 0.147458, -0.836316>, <-0.066324, 5.61046, -1.54597>, <-0.633951, -0.100968, -0.766754>, <-0.0716047, 5.6401, -1.54075> , <-0.681256, 0.127116, -0.720924> }
	smooth_triangle { <-0.0567388, 5.64207, -1.55191>, <-0.528045, 0.147458, -0.836316>, <-0.066324, 5.66974, -1.53552>, <-0.633933, 0.357121, -0.685998>, <-0.0525894, 5.66536, -1.54781> , <-0.489983, 0.324893, -0.808926> }
	smooth_triangle { <-0.066324, 5.66974, -1.53552>, <-0.633933, 0.357121, -0.685998>, <-0.0567388, 5.64207, -1.55191>, <-0.528045, 0.147458, -0.836316>, <-0.0716047, 5.6401, -1.54075> , <-0.681256, 0.127116, -0.720924> }
	smooth_triangle { <-0.0525894, 5.66536, -1.54781>, <-0.489983, 0.324893, -0.808926>, <-0.0512862, 5.69487, -1.53109>, <-0.493886, 0.561363, -0.664039>, <-0.0407739, 5.6851, -1.54433> , <-0.379083, 0.479935, -0.791175> }
	smooth_triangle { <-0.0512862, 5.69487, -1.53109>, <-0.493886, 0.561363, -0.664039>, <-0.0525894, 5.66536, -1.54781>, <-0.489983, 0.324893, -0.808926>, <-0.066324, 5.66974, -1.53552> , <-0.633933, 0.357121, -0.685998> }
	smooth_triangle { <-0.0407739, 5.6851, -1.54433>, <-0.379083, 0.479935, -0.791175>, <-0.0287807, 5.71166, -1.52813>, <-0.272259, 0.706505, -0.653242>, <-0.0230912, 5.6983, -1.542> , <-0.207435, 0.587621, -0.782095> }
	smooth_triangle { <-0.0287807, 5.71166, -1.52813>, <-0.272259, 0.706505, -0.653242>, <-0.0407739, 5.6851, -1.54433>, <-0.379083, 0.479935, -0.791175>, <-0.0512862, 5.69487, -1.53109> , <-0.493886, 0.561363, -0.664039> }
	smooth_triangle { <-0.0230912, 5.6983, -1.542>, <-0.207435, 0.587621, -0.782095>, <-0.00223293, 5.71756, -1.52709>, <1.14943e-006, 0.759731, -0.650238>, <-0.00223293, 5.70293, -1.54118> , <3.47673e-006, 0.626473, -0.779443> }
	smooth_triangle { <-0.00223293, 5.71756, -1.52709>, <1.14943e-006, 0.759731, -0.650238>, <-0.0230912, 5.6983, -1.542>, <-0.207435, 0.587621, -0.782095>, <-0.0287807, 5.71166, -1.52813> , <-0.272259, 0.706505, -0.653242> }
	smooth_triangle { <-0.00223293, 5.70293, -1.54118>, <3.47673e-006, 0.626474, -0.779443>, <0.0243142, 5.71166, -1.52813>, <0.27224, 0.706485, -0.653272>, <0.0186247, 5.6983, -1.542> , <0.20743, 0.587617, -0.782099> }
	smooth_triangle { <0.0243142, 5.71166, -1.52813>, <0.27224, 0.706485, -0.653272>, <-0.00223293, 5.70293, -1.54118>, <3.47673e-006, 0.626474, -0.779443>, <-0.00223293, 5.71756, -1.52709> , <1.14943e-006, 0.759731, -0.650238> }
	smooth_triangle { <0.0363076, 5.6851, -1.54433>, <0.379079, 0.479924, -0.791184>, <0.0243142, 5.71166, -1.52813>, <0.27224, 0.706485, -0.653272>, <0.0468202, 5.69487, -1.53109> , <0.493893, 0.561356, -0.66404> }
	smooth_triangle { <0.0243142, 5.71166, -1.52813>, <0.27224, 0.706485, -0.653272>, <0.0363076, 5.6851, -1.54433>, <0.379079, 0.479924, -0.791184>, <0.0186247, 5.6983, -1.542> , <0.20743, 0.587617, -0.782099> }
	smooth_triangle { <0.0481231, 5.66536, -1.54781>, <0.48999, 0.324896, -0.80892>, <0.0468202, 5.69487, -1.53109>, <0.493893, 0.561356, -0.66404>, <0.0618577, 5.66974, -1.53552> , <0.633955, 0.35713, -0.685974> }
	smooth_triangle { <0.0468202, 5.69487, -1.53109>, <0.493893, 0.561356, -0.66404>, <0.0481231, 5.66536, -1.54781>, <0.48999, 0.324896, -0.80892>, <0.0363076, 5.6851, -1.54433> , <0.379079, 0.479924, -0.791184> }
	smooth_triangle { <0.0522724, 5.64207, -1.55191>, <0.528038, 0.14746, -0.83632>, <0.0618577, 5.66974, -1.53552>, <0.633955, 0.35713, -0.685974>, <0.0671388, 5.6401, -1.54075> , <0.681257, 0.127115, -0.720923> }
	smooth_triangle { <0.0618577, 5.66974, -1.53552>, <0.633955, 0.35713, -0.685974>, <0.0522724, 5.64207, -1.55191>, <0.528038, 0.14746, -0.83632>, <0.0481231, 5.66536, -1.54781> , <0.48999, 0.324896, -0.80892> }
	smooth_triangle { <0.0793391, 5.6377, -1.52714>, <0.812307, 0.101277, -0.574369>, <0.0618577, 5.61046, -1.54597>, <0.633943, -0.100961, -0.766762>, <0.0671388, 5.6401, -1.54075> , <0.681257, 0.127115, -0.720923> }
	smooth_triangle { <0.0618577, 5.61046, -1.54597>, <0.633943, -0.100961, -0.766762>, <0.0793391, 5.6377, -1.52714>, <0.812307, 0.101277, -0.574369>, <0.0731299, 5.60285, -1.53328> , <0.758174, -0.171997, -0.628959> }
	smooth_triangle { <0.0554478, 5.5733, -1.53849>, <0.595218, -0.415041, -0.688082>, <0.0618577, 5.61046, -1.54597>, <0.633943, -0.100961, -0.766762>, <0.0731299, 5.60285, -1.53328> , <0.758174, -0.171997, -0.628959> }
	smooth_triangle { <0.0618577, 5.61046, -1.54597>, <0.633943, -0.100961, -0.766762>, <0.0554478, 5.5733, -1.53849>, <0.595218, -0.415041, -0.688082>, <0.0468202, 5.58533, -1.5504> , <0.493895, -0.300388, -0.815987> }
	smooth_triangle { <0.0289833, 5.55355, -1.54197>, <0.330803, -0.590046, -0.736489>, <0.0468202, 5.58533, -1.5504>, <0.493895, -0.300388, -0.815987>, <0.0554478, 5.5733, -1.53849> , <0.595218, -0.415041, -0.688082> }
	smooth_triangle { <0.0468202, 5.58533, -1.5504>, <0.493895, -0.300388, -0.815987>, <0.0289833, 5.55355, -1.54197>, <0.330803, -0.590046, -0.736489>, <0.0243142, 5.56854, -1.55336> , <0.272247, -0.440459, -0.855498> }
	smooth_triangle { <-0.00223293, 5.54662, -1.5432>, <1.00762e-006, -0.654998, -0.755631>, <0.0243142, 5.56854, -1.55336>, <0.272247, -0.440459, -0.855498>, <0.0289833, 5.55355, -1.54197> , <0.330803, -0.590046, -0.736489> }
	smooth_triangle { <0.0243142, 5.56854, -1.55336>, <0.272247, -0.440459, -0.855498>, <-0.00223293, 5.54662, -1.5432>, <1.00762e-006, -0.654998, -0.755631>, <-0.00223293, 5.56264, -1.5544> , <-3.85664e-007, -0.491504, -0.870875> }
	smooth_triangle { <-0.00223293, 5.54662, -1.5432>, <1.00762e-006, -0.654998, -0.755631>, <-0.0287807, 5.56854, -1.55336>, <-0.272249, -0.440467, -0.855494>, <-0.00223293, 5.56264, -1.5544> , <-3.85664e-007, -0.491504, -0.870875> }
	smooth_triangle { <-0.0287807, 5.56854, -1.55336>, <-0.272249, -0.440467, -0.855494>, <-0.00223293, 5.54662, -1.5432>, <1.00762e-006, -0.654998, -0.755631>, <-0.0334491, 5.55355, -1.54197> , <-0.330802, -0.590037, -0.736496> }
	smooth_triangle { <-0.0334491, 5.55355, -1.54197>, <-0.330802, -0.590037, -0.736496>, <-0.0512862, 5.58533, -1.5504>, <-0.493906, -0.3004, -0.815976>, <-0.0287807, 5.56854, -1.55336> , <-0.272249, -0.440467, -0.855494> }
	smooth_triangle { <-0.0512862, 5.58533, -1.5504>, <-0.493906, -0.3004, -0.815976>, <-0.0334491, 5.55355, -1.54197>, <-0.330802, -0.590037, -0.736496>, <-0.059913, 5.5733, -1.53849> , <-0.595215, -0.41504, -0.688085> }
	smooth_triangle { <-0.059913, 5.5733, -1.53849>, <-0.595215, -0.41504, -0.688085>, <-0.066324, 5.61046, -1.54597>, <-0.633951, -0.100968, -0.766754>, <-0.0512862, 5.58533, -1.5504> , <-0.493906, -0.3004, -0.815976> }
	smooth_triangle { <-0.066324, 5.61046, -1.54597>, <-0.633951, -0.100968, -0.766754>, <-0.059913, 5.5733, -1.53849>, <-0.595215, -0.41504, -0.688085>, <-0.0775962, 5.60285, -1.53328> , <-0.758181, -0.172009, -0.628947> }
	smooth_triangle { <-0.066324, 5.61046, -1.54597>, <-0.633951, -0.100968, -0.766754>, <-0.0838058, 5.6377, -1.52714>, <-0.812316, 0.101274, -0.574357>, <-0.0716047, 5.6401, -1.54075> , <-0.681256, 0.127116, -0.720924> }
	smooth_triangle { <-0.0838058, 5.6377, -1.52714>, <-0.812316, 0.101274, -0.574357>, <-0.066324, 5.61046, -1.54597>, <-0.633951, -0.100968, -0.766754>, <-0.0775962, 5.60285, -1.53328> , <-0.758181, -0.172009, -0.628947> }
	smooth_triangle { <-0.0716047, 5.6401, -1.54075>, <-0.681256, 0.127116, -0.720924>, <-0.0775962, 5.67256, -1.52099>, <-0.758187, 0.376738, -0.532185>, <-0.066324, 5.66974, -1.53552> , <-0.633933, 0.357121, -0.685998> }
	smooth_triangle { <-0.0775962, 5.67256, -1.52099>, <-0.758187, 0.376738, -0.532185>, <-0.0716047, 5.6401, -1.54075>, <-0.681256, 0.127116, -0.720924>, <-0.0838058, 5.6377, -1.52714> , <-0.812316, 0.101274, -0.574357> }
	smooth_triangle { <-0.0512862, 5.69487, -1.53109>, <-0.493886, 0.561363, -0.664039>, <-0.0775962, 5.67256, -1.52099>, <-0.758187, 0.376738, -0.532185>, <-0.059913, 5.70211, -1.51578> , <-0.595206, 0.625355, -0.504639> }
	smooth_triangle { <-0.0775962, 5.67256, -1.52099>, <-0.758187, 0.376738, -0.532185>, <-0.0512862, 5.69487, -1.53109>, <-0.493886, 0.561363, -0.664039>, <-0.066324, 5.66974, -1.53552> , <-0.633933, 0.357121, -0.685998> }
	smooth_triangle { <-0.0287807, 5.71166, -1.52813>, <-0.272259, 0.706505, -0.653242>, <-0.059913, 5.70211, -1.51578>, <-0.595206, 0.625355, -0.504639>, <-0.0334491, 5.72185, -1.5123> , <-0.330779, 0.80636, -0.490275> }
	smooth_triangle { <-0.059913, 5.70211, -1.51578>, <-0.595206, 0.625355, -0.504639>, <-0.0287807, 5.71166, -1.52813>, <-0.272259, 0.706505, -0.653242>, <-0.0512862, 5.69487, -1.53109> , <-0.493886, 0.561363, -0.664039> }
	smooth_triangle { <-0.00223293, 5.71756, -1.52709>, <1.14943e-006, 0.759731, -0.650238>, <-0.0334491, 5.72185, -1.5123>, <-0.330779, 0.80636, -0.490275>, <-0.00223293, 5.72878, -1.51108> , <-8.36508e-007, 0.873934, -0.486045> }
	smooth_triangle { <-0.0334491, 5.72185, -1.5123>, <-0.330779, 0.80636, -0.490275>, <-0.00223293, 5.71756, -1.52709>, <1.14943e-006, 0.759731, -0.650238>, <-0.0287807, 5.71166, -1.52813> , <-0.272259, 0.706505, -0.653242> }
	smooth_triangle { <0.0289833, 5.72185, -1.5123>, <0.330782, 0.806365, -0.490264>, <-0.00223293, 5.71756, -1.52709>, <1.14943e-006, 0.759731, -0.650238>, <-0.00223293, 5.72878, -1.51108> , <-8.36508e-007, 0.873934, -0.486045> }
	smooth_triangle { <-0.00223293, 5.71756, -1.52709>, <1.14943e-006, 0.759731, -0.650238>, <0.0289833, 5.72185, -1.5123>, <0.330782, 0.806365, -0.490264>, <0.0243142, 5.71166, -1.52813> , <0.27224, 0.706485, -0.653272> }
	smooth_triangle { <0.0554478, 5.70211, -1.51578>, <0.595212, 0.625357, -0.50463>, <0.0243142, 5.71166, -1.52813>, <0.27224, 0.706485, -0.653272>, <0.0289833, 5.72185, -1.5123> , <0.330782, 0.806365, -0.490264> }
	smooth_triangle { <0.0243142, 5.71166, -1.52813>, <0.27224, 0.706485, -0.653272>, <0.0554478, 5.70211, -1.51578>, <0.595212, 0.625357, -0.50463>, <0.0468202, 5.69487, -1.53109> , <0.493893, 0.561356, -0.66404> }
	smooth_triangle { <0.0731299, 5.67256, -1.52099>, <0.758188, 0.376731, -0.532189>, <0.0468202, 5.69487, -1.53109>, <0.493893, 0.561356, -0.66404>, <0.0554478, 5.70211, -1.51578> , <0.595212, 0.625357, -0.50463> }
	smooth_triangle { <0.0468202, 5.69487, -1.53109>, <0.493893, 0.561356, -0.66404>, <0.0731299, 5.67256, -1.52099>, <0.758188, 0.376731, -0.532189>, <0.0618577, 5.66974, -1.53552> , <0.633955, 0.35713, -0.685974> }
	smooth_triangle { <0.0731299, 5.67256, -1.52099>, <0.758188, 0.376731, -0.532189>, <0.0671388, 5.6401, -1.54075>, <0.681257, 0.127115, -0.720923>, <0.0618577, 5.66974, -1.53552> , <0.633955, 0.35713, -0.685974> }
	smooth_triangle { <0.0671388, 5.6401, -1.54075>, <0.681257, 0.127115, -0.720923>, <0.0731299, 5.67256, -1.52099>, <0.758188, 0.376731, -0.532189>, <0.0793391, 5.6377, -1.52714> , <0.812307, 0.101277, -0.574369> }
	smooth_triangle { <0.0884053, 5.63496, -1.51161>, <0.91359, 0.0706124, -0.400458>, <0.0731299, 5.60285, -1.53328>, <0.758174, -0.171997, -0.628959>, <0.0793391, 5.6377, -1.52714> , <0.812307, 0.101277, -0.574369> }
	smooth_triangle { <0.0731299, 5.60285, -1.53328>, <0.758174, -0.171997, -0.628959>, <0.0884053, 5.63496, -1.51161>, <0.91359, 0.0706124, -0.400458>, <0.0815062, 5.59623, -1.51844> , <0.855024, -0.238285, -0.460602> }
	smooth_triangle { <0.0815062, 5.59623, -1.51844>, <0.855024, -0.238285, -0.460602>, <0.0554478, 5.5733, -1.53849>, <0.595218, -0.415041, -0.688082>, <0.0731299, 5.60285, -1.53328> , <0.758174, -0.171997, -0.628959> }
	smooth_triangle { <0.0554478, 5.5733, -1.53849>, <0.595218, -0.415041, -0.688082>, <0.0815062, 5.59623, -1.51844>, <0.855024, -0.238285, -0.460602>, <0.0618577, 5.5634, -1.52423> , <0.675964, -0.517659, -0.524502> }
	smooth_triangle { <0.0324522, 5.54146, -1.52809>, <0.378595, -0.723747, -0.576937>, <0.0554478, 5.5733, -1.53849>, <0.595218, -0.415041, -0.688082>, <0.0618577, 5.5634, -1.52423> , <0.675964, -0.517659, -0.524502> }
	smooth_triangle { <0.0554478, 5.5733, -1.53849>, <0.595218, -0.415041, -0.688082>, <0.0324522, 5.54146, -1.52809>, <0.378595, -0.723747, -0.576937>, <0.0289833, 5.55355, -1.54197> , <0.330803, -0.590046, -0.736489> }
	smooth_triangle { <-0.00223293, 5.53376, -1.52945>, <3.31479e-006, -0.801614, -0.597842>, <0.0289833, 5.55355, -1.54197>, <0.330803, -0.590046, -0.736489>, <0.0324522, 5.54146, -1.52809> , <0.378595, -0.723747, -0.576937> }
	smooth_triangle { <0.0289833, 5.55355, -1.54197>, <0.330803, -0.590046, -0.736489>, <-0.00223293, 5.53376, -1.52945>, <3.31479e-006, -0.801614, -0.597842>, <-0.00223293, 5.54662, -1.5432> , <1.00762e-006, -0.654998, -0.755631> }
	smooth_triangle { <-0.0334491, 5.55355, -1.54197>, <-0.330802, -0.590037, -0.736496>, <-0.00223293, 5.53376, -1.52945>, <3.31479e-006, -0.801614, -0.597842>, <-0.0369187, 5.54146, -1.52809> , <-0.378591, -0.723722, -0.576971> }
	smooth_triangle { <-0.00223293, 5.53376, -1.52945>, <3.31479e-006, -0.801614, -0.597842>, <-0.0334491, 5.55355, -1.54197>, <-0.330802, -0.590037, -0.736496>, <-0.00223293, 5.54662, -1.5432> , <1.00762e-006, -0.654998, -0.755631> }
	smooth_triangle { <-0.0369187, 5.54146, -1.52809>, <-0.378591, -0.723722, -0.576971>, <-0.059913, 5.5733, -1.53849>, <-0.595215, -0.41504, -0.688085>, <-0.0334491, 5.55355, -1.54197> , <-0.330802, -0.590037, -0.736496> }
	smooth_triangle { <-0.059913, 5.5733, -1.53849>, <-0.595215, -0.41504, -0.688085>, <-0.0369187, 5.54146, -1.52809>, <-0.378591, -0.723722, -0.576971>, <-0.066324, 5.5634, -1.52423> , <-0.67596, -0.517652, -0.524514> }
	smooth_triangle { <-0.059913, 5.5733, -1.53849>, <-0.595215, -0.41504, -0.688085>, <-0.0859718, 5.59623, -1.51844>, <-0.855027, -0.238292, -0.460592>, <-0.0775962, 5.60285, -1.53328> , <-0.758181, -0.172009, -0.628947> }
	smooth_triangle { <-0.0859718, 5.59623, -1.51844>, <-0.855027, -0.238292, -0.460592>, <-0.059913, 5.5733, -1.53849>, <-0.595215, -0.41504, -0.688085>, <-0.066324, 5.5634, -1.52423> , <-0.67596, -0.517652, -0.524514> }
	smooth_triangle { <-0.0775962, 5.60285, -1.53328>, <-0.758181, -0.172009, -0.628947>, <-0.0928712, 5.63496, -1.51161>, <-0.913596, 0.0706087, -0.400446>, <-0.0838058, 5.6377, -1.52714> , <-0.812316, 0.101274, -0.574357> }
	smooth_triangle { <-0.0928712, 5.63496, -1.51161>, <-0.913596, 0.0706087, -0.400446>, <-0.0775962, 5.60285, -1.53328>, <-0.758181, -0.172009, -0.628947>, <-0.0859718, 5.59623, -1.51844> , <-0.855027, -0.238292, -0.460592> }
	smooth_triangle { <-0.0838058, 5.6377, -1.52714>, <-0.812316, 0.101274, -0.574357>, <-0.0859718, 5.67369, -1.50478>, <-0.855033, 0.381448, -0.351307>, <-0.0775962, 5.67256, -1.52099> , <-0.758187, 0.376738, -0.532185> }
	smooth_triangle { <-0.0859718, 5.67369, -1.50478>, <-0.855033, 0.381448, -0.351307>, <-0.0838058, 5.6377, -1.52714>, <-0.812316, 0.101274, -0.574357>, <-0.0928712, 5.63496, -1.51161> , <-0.913596, 0.0706087, -0.400446> }
	smooth_triangle { <-0.059913, 5.70211, -1.51578>, <-0.595206, 0.625355, -0.504639>, <-0.0859718, 5.67369, -1.50478>, <-0.855033, 0.381448, -0.351307>, <-0.066324, 5.70653, -1.49899> , <-0.675968, 0.665832, -0.315809> }
	smooth_triangle { <-0.0859718, 5.67369, -1.50478>, <-0.855033, 0.381448, -0.351307>, <-0.059913, 5.70211, -1.51578>, <-0.595206, 0.625355, -0.504639>, <-0.0775962, 5.67256, -1.52099> , <-0.758187, 0.376737, -0.532185> }
	smooth_triangle { <-0.0334491, 5.72185, -1.5123>, <-0.330779, 0.80636, -0.490275>, <-0.066324, 5.70653, -1.49899>, <-0.675968, 0.665832, -0.315809>, <-0.0369187, 5.72846, -1.49512> , <-0.378574, 0.877419, -0.294647> }
	smooth_triangle { <-0.066324, 5.70653, -1.49899>, <-0.675968, 0.665832, -0.315809>, <-0.0334491, 5.72185, -1.5123>, <-0.330779, 0.80636, -0.490275>, <-0.059913, 5.70211, -1.51578> , <-0.595206, 0.625355, -0.504639> }
	smooth_triangle { <-0.00223293, 5.72878, -1.51108>, <-8.32706e-007, 0.873934, -0.486045>, <-0.0369187, 5.72846, -1.49512>, <-0.378574, 0.877419, -0.294647>, <-0.00223293, 5.73617, -1.49376> , <2.25955e-006, 0.957732, -0.287661> }
	smooth_triangle { <-0.0369187, 5.72846, -1.49512>, <-0.378574, 0.877419, -0.294647>, <-0.00223293, 5.72878, -1.51108>, <-8.32706e-007, 0.873934, -0.486045>, <-0.0334491, 5.72185, -1.5123> , <-0.330779, 0.80636, -0.490275> }
	smooth_triangle { <0.0324522, 5.72846, -1.49512>, <0.378579, 0.877428, -0.294616>, <-0.00223293, 5.72878, -1.51108>, <-8.36508e-007, 0.873934, -0.486045>, <-0.00223293, 5.73617, -1.49376> , <2.25955e-006, 0.957732, -0.287661> }
	smooth_triangle { <-0.00223293, 5.72878, -1.51108>, <-8.36508e-007, 0.873934, -0.486045>, <0.0324522, 5.72846, -1.49512>, <0.378579, 0.877428, -0.294616>, <0.0289833, 5.72185, -1.5123> , <0.330782, 0.806365, -0.490264> }
	smooth_triangle { <0.0618577, 5.70653, -1.49899>, <0.675969, 0.665837, -0.315796>, <0.0289833, 5.72185, -1.5123>, <0.330782, 0.806365, -0.490264>, <0.0324522, 5.72846, -1.49512> , <0.378579, 0.877428, -0.294616> }
	smooth_triangle { <0.0289833, 5.72185, -1.5123>, <0.330782, 0.806365, -0.490264>, <0.0618577, 5.70653, -1.49899>, <0.675969, 0.665837, -0.315796>, <0.0554478, 5.70211, -1.51578> , <0.595212, 0.625357, -0.50463> }
	smooth_triangle { <0.0815062, 5.67369, -1.50478>, <0.855029, 0.381441, -0.351323>, <0.0554478, 5.70211, -1.51578>, <0.595212, 0.625357, -0.50463>, <0.0618577, 5.70653, -1.49899> , <0.675969, 0.665837, -0.315796> }
	smooth_triangle { <0.0554478, 5.70211, -1.51578>, <0.595212, 0.625357, -0.50463>, <0.0815062, 5.67369, -1.50478>, <0.855029, 0.381441, -0.351323>, <0.0731299, 5.67256, -1.52099> , <0.758188, 0.376731, -0.532189> }
	smooth_triangle { <0.0815062, 5.67369, -1.50478>, <0.855029, 0.381441, -0.351323>, <0.0793391, 5.6377, -1.52714>, <0.812307, 0.101277, -0.574369>, <0.0731299, 5.67256, -1.52099> , <0.758188, 0.376731, -0.532189> }
	smooth_triangle { <0.0793391, 5.6377, -1.52714>, <0.812307, 0.101277, -0.574369>, <0.0815062, 5.67369, -1.50478>, <0.855029, 0.381441, -0.351323>, <0.0884053, 5.63496, -1.51161> , <0.91359, 0.0706124, -0.400458> }
	smooth_triangle { <0.0939882, 5.63199, -1.49476>, <0.977914, 0.0362947, -0.205833>, <0.0815062, 5.59623, -1.51844>, <0.855024, -0.238285, -0.460602>, <0.0884053, 5.63496, -1.51161> , <0.91359, 0.0706124, -0.400458> }
	smooth_triangle { <0.0815062, 5.59623, -1.51844>, <0.855024, -0.238285, -0.460602>, <0.0939882, 5.63199, -1.49476>, <0.977914, 0.0362947, -0.205833>, <0.0866642, 5.59088, -1.50201> , <0.916967, -0.295784, -0.267738> }
	smooth_triangle { <0.0866642, 5.59088, -1.50201>, <0.916967, -0.295784, -0.267738>, <0.0618577, 5.5634, -1.52423>, <0.675964, -0.517659, -0.524502>, <0.0815062, 5.59623, -1.51844> , <0.855024, -0.238285, -0.460602> }
	smooth_triangle { <0.0618577, 5.5634, -1.52423>, <0.675964, -0.517659, -0.524502>, <0.0866642, 5.59088, -1.50201>, <0.916967, -0.295784, -0.267738>, <0.0658059, 5.55602, -1.50816> , <0.728549, -0.600163, -0.330184> }
	smooth_triangle { <0.0345896, 5.53273, -1.51226>, <0.410322, -0.828866, -0.380284>, <0.0618577, 5.5634, -1.52423>, <0.675964, -0.517659, -0.524502>, <0.0658059, 5.55602, -1.50816> , <0.728549, -0.600163, -0.330184> }
	smooth_triangle { <0.0618577, 5.5634, -1.52423>, <0.675964, -0.517659, -0.524502>, <0.0345896, 5.53273, -1.51226>, <0.410322, -0.828866, -0.380284>, <0.0324522, 5.54146, -1.52809> , <0.378595, -0.723747, -0.576937> }
	smooth_triangle { <-0.00223293, 5.52456, -1.5137>, <3.17871e-006, -0.916457, -0.400133>, <0.0324522, 5.54146, -1.52809>, <0.378595, -0.723747, -0.576937>, <0.0345896, 5.53273, -1.51226> , <0.410322, -0.828866, -0.380284> }
	smooth_triangle { <0.0324522, 5.54146, -1.52809>, <0.378595, -0.723747, -0.576937>, <-0.00223293, 5.52456, -1.5137>, <3.17871e-006, -0.916457, -0.400133>, <-0.00223293, 5.53376, -1.52945> , <3.31097e-006, -0.801614, -0.597842> }
	smooth_triangle { <-0.0369187, 5.54146, -1.52809>, <-0.378591, -0.723722, -0.576971>, <-0.00223293, 5.52456, -1.5137>, <3.17871e-006, -0.916457, -0.400133>, <-0.0390552, 5.53273, -1.51226> , <-0.410325, -0.828864, -0.380287> }
	smooth_triangle { <-0.00223293, 5.52456, -1.5137>, <3.17871e-006, -0.916457, -0.400133>, <-0.0369187, 5.54146, -1.52809>, <-0.378591, -0.723722, -0.576971>, <-0.00223293, 5.53376, -1.52945> , <3.31479e-006, -0.801614, -0.597842> }
	smooth_triangle { <-0.066324, 5.5634, -1.52423>, <-0.67596, -0.517652, -0.524514>, <-0.0390552, 5.53273, -1.51226>, <-0.410325, -0.828864, -0.380287>, <-0.0702715, 5.55602, -1.50816> , <-0.728555, -0.600174, -0.33015> }
	smooth_triangle { <-0.0390552, 5.53273, -1.51226>, <-0.410325, -0.828864, -0.380287>, <-0.066324, 5.5634, -1.52423>, <-0.67596, -0.517652, -0.524514>, <-0.0369187, 5.54146, -1.52809> , <-0.378591, -0.723722, -0.576971> }
	smooth_triangle { <-0.066324, 5.5634, -1.52423>, <-0.67596, -0.517652, -0.524514>, <-0.0911305, 5.59088, -1.50201>, <-0.916963, -0.295779, -0.267755>, <-0.0859718, 5.59623, -1.51844> , <-0.855027, -0.238292, -0.460592> }
	smooth_triangle { <-0.0911305, 5.59088, -1.50201>, <-0.916963, -0.295779, -0.267755>, <-0.066324, 5.5634, -1.52423>, <-0.67596, -0.517652, -0.524514>, <-0.0702715, 5.55602, -1.50816> , <-0.728555, -0.600174, -0.33015> }
	smooth_triangle { <-0.0859718, 5.59623, -1.51844>, <-0.855027, -0.238292, -0.460592>, <-0.0984541, 5.63199, -1.49476>, <-0.977911, 0.0362975, -0.205847>, <-0.0928712, 5.63496, -1.51161> , <-0.913596, 0.0706087, -0.400446> }
	smooth_triangle { <-0.0984541, 5.63199, -1.49476>, <-0.977911, 0.0362975, -0.205847>, <-0.0859718, 5.59623, -1.51844>, <-0.855027, -0.238292, -0.460592>, <-0.0911305, 5.59088, -1.50201> , <-0.916963, -0.295779, -0.267755> }
	smooth_triangle { <-0.0928712, 5.63496, -1.51161>, <-0.913596, 0.0706087, -0.400446>, <-0.0911305, 5.67311, -1.48751>, <-0.916965, 0.369523, -0.150428>, <-0.0859718, 5.67369, -1.50478> , <-0.855033, 0.381448, -0.351307> }
	smooth_triangle { <-0.0911305, 5.67311, -1.48751>, <-0.916965, 0.369523, -0.150428>, <-0.0928712, 5.63496, -1.51161>, <-0.913596, 0.0706087, -0.400446>, <-0.0984541, 5.63199, -1.49476> , <-0.977911, 0.0362975, -0.205847> }
	smooth_triangle { <-0.0859718, 5.67369, -1.50478>, <-0.855033, 0.381448, -0.351307>, <-0.0702715, 5.70796, -1.48137>, <-0.728555, 0.676892, -0.104999>, <-0.066324, 5.70653, -1.49899> , <-0.675968, 0.665832, -0.315809> }
	smooth_triangle { <-0.0702715, 5.70796, -1.48137>, <-0.728555, 0.676892, -0.104999>, <-0.0859718, 5.67369, -1.50478>, <-0.855033, 0.381448, -0.351307>, <-0.0911305, 5.67311, -1.48751> , <-0.916965, 0.369523, -0.150428> }
	smooth_triangle { <-0.0369187, 5.72846, -1.49512>, <-0.378574, 0.877419, -0.294647>, <-0.0702715, 5.70796, -1.48137>, <-0.728555, 0.676892, -0.104999>, <-0.0390552, 5.73125, -1.47726> , <-0.410338, 0.908937, -0.0738742> }
	smooth_triangle { <-0.0702715, 5.70796, -1.48137>, <-0.728555, 0.676892, -0.104999>, <-0.0369187, 5.72846, -1.49512>, <-0.378574, 0.877419, -0.294647>, <-0.066324, 5.70653, -1.49899> , <-0.675968, 0.665832, -0.315809> }
	smooth_triangle { <-0.00223293, 5.73617, -1.49376>, <2.25573e-006, 0.957732, -0.287661>, <-0.0390552, 5.73125, -1.47726>, <-0.410338, 0.908937, -0.0738742>, <-0.00223293, 5.73943, -1.47582> , <-1.78132e-006, 0.998041, -0.0625682> }
	smooth_triangle { <-0.0390552, 5.73125, -1.47726>, <-0.410338, 0.908937, -0.0738742>, <-0.00223293, 5.73617, -1.49376>, <2.25573e-006, 0.957732, -0.287661>, <-0.0369187, 5.72846, -1.49512> , <-0.378574, 0.877419, -0.294647> }
	smooth_triangle { <0.0345896, 5.73125, -1.47726>, <0.410342, 0.908935, -0.0738704>, <-0.00223293, 5.73617, -1.49376>, <2.25955e-006, 0.957732, -0.287661>, <-0.00223293, 5.73943, -1.47582> , <-1.78132e-006, 0.998041, -0.0625682> }
	smooth_triangle { <-0.00223293, 5.73617, -1.49376>, <2.25955e-006, 0.957732, -0.287661>, <0.0345896, 5.73125, -1.47726>, <0.410342, 0.908935, -0.0738704>, <0.0324522, 5.72846, -1.49512> , <0.378579, 0.877428, -0.294616> }
	smooth_triangle { <0.0658059, 5.70796, -1.48137>, <0.728557, 0.676894, -0.104975>, <0.0324522, 5.72846, -1.49512>, <0.378579, 0.877428, -0.294616>, <0.0345896, 5.73125, -1.47726> , <0.410342, 0.908935, -0.0738704> }
	smooth_triangle { <0.0324522, 5.72846, -1.49512>, <0.378579, 0.877428, -0.294616>, <0.0658059, 5.70796, -1.48137>, <0.728557, 0.676894, -0.104975>, <0.0618577, 5.70653, -1.49899> , <0.675969, 0.665837, -0.315796> }
	smooth_triangle { <0.0658059, 5.70796, -1.48137>, <0.728557, 0.676894, -0.104975>, <0.0815062, 5.67369, -1.50478>, <0.855029, 0.381441, -0.351323>, <0.0618577, 5.70653, -1.49899> , <0.675969, 0.665837, -0.315796> }
	smooth_triangle { <0.0815062, 5.67369, -1.50478>, <0.855029, 0.381441, -0.351323>, <0.0658059, 5.70796, -1.48137>, <0.728557, 0.676894, -0.104975>, <0.0866642, 5.67311, -1.48751> , <0.916963, 0.369524, -0.150436> }
	smooth_triangle { <0.0866642, 5.67311, -1.48751>, <0.916963, 0.369524, -0.150436>, <0.0884053, 5.63496, -1.51161>, <0.91359, 0.0706124, -0.400458>, <0.0815062, 5.67369, -1.50478> , <0.855029, 0.381441, -0.351323> }
	smooth_triangle { <0.0884053, 5.63496, -1.51161>, <0.91359, 0.0706124, -0.400458>, <0.0866642, 5.67311, -1.48751>, <0.916963, 0.369524, -0.150436>, <0.0939882, 5.63199, -1.49476> , <0.977914, 0.0362947, -0.205833> }
	smooth_triangle { <0.0958737, 5.6289, -1.47724>, <1, -3.18668e-006, 2.81401e-006>, <0.0866642, 5.59088, -1.50201>, <0.916967, -0.295784, -0.267738>, <0.0939882, 5.63199, -1.49476> , <0.977914, 0.0362947, -0.205833> }
	smooth_triangle { <0.0866642, 5.59088, -1.50201>, <0.916967, -0.295784, -0.267738>, <0.0958737, 5.6289, -1.47724>, <1, -3.18668e-006, 2.81401e-006>, <0.0884053, 5.58698, -1.48463> , <0.938316, -0.340526, -0.0600359> }
	smooth_triangle { <0.0884053, 5.58698, -1.48463>, <0.938316, -0.340526, -0.0600359>, <0.0658059, 5.55602, -1.50816>, <0.728549, -0.600163, -0.330184>, <0.0866642, 5.59088, -1.50201> , <0.916967, -0.295784, -0.267738> }
	smooth_triangle { <0.0658059, 5.55602, -1.50816>, <0.728549, -0.600163, -0.330184>, <0.0884053, 5.58698, -1.48463>, <0.938316, -0.340526, -0.0600359>, <0.0671388, 5.55145, -1.4909> , <0.746883, -0.654855, -0.115457> }
	smooth_triangle { <0.0353105, 5.5277, -1.49508>, <0.421509, -0.893043, -0.157492>, <0.0658059, 5.55602, -1.50816>, <0.728549, -0.600163, -0.330184>, <0.0671388, 5.55145, -1.4909> , <0.746883, -0.654855, -0.115457> }
	smooth_triangle { <0.0658059, 5.55602, -1.50816>, <0.728549, -0.600163, -0.330184>, <0.0353105, 5.5277, -1.49508>, <0.421509, -0.893043, -0.157492>, <0.0345896, 5.53273, -1.51226> , <0.410322, -0.828866, -0.380284> }
	smooth_triangle { <-0.00223293, 5.51936, -1.49655>, <1.16118e-006, -0.984804, -0.173671>, <0.0345896, 5.53273, -1.51226>, <0.410322, -0.828866, -0.380284>, <0.0353105, 5.5277, -1.49508> , <0.421509, -0.893043, -0.157492> }
	smooth_triangle { <0.0345896, 5.53273, -1.51226>, <0.410322, -0.828866, -0.380284>, <-0.00223293, 5.51936, -1.49655>, <1.16118e-006, -0.984804, -0.173671>, <-0.00223293, 5.52456, -1.5137> , <3.17871e-006, -0.916457, -0.400133> }
	smooth_triangle { <-0.0390552, 5.53273, -1.51226>, <-0.410325, -0.828864, -0.380287>, <-0.00223293, 5.51936, -1.49655>, <1.16118e-006, -0.984804, -0.173671>, <-0.0397768, 5.5277, -1.49508> , <-0.421513, -0.893049, -0.157451> }
	smooth_triangle { <-0.00223293, 5.51936, -1.49655>, <1.16118e-006, -0.984804, -0.173671>, <-0.0390552, 5.53273, -1.51226>, <-0.410325, -0.828864, -0.380287>, <-0.00223293, 5.52456, -1.5137> , <3.17871e-006, -0.916457, -0.400133> }
	smooth_triangle { <-0.0702715, 5.55602, -1.50816>, <-0.728555, -0.600174, -0.33015>, <-0.0397768, 5.5277, -1.49508>, <-0.421513, -0.893049, -0.157451>, <-0.0716047, 5.55145, -1.4909> , <-0.746881, -0.654858, -0.115457> }
	smooth_triangle { <-0.0397768, 5.5277, -1.49508>, <-0.421513, -0.893049, -0.157451>, <-0.0702715, 5.55602, -1.50816>, <-0.728555, -0.600174, -0.33015>, <-0.0390552, 5.53273, -1.51226> , <-0.410325, -0.828864, -0.380287> }
	smooth_triangle { <-0.0702715, 5.55602, -1.50816>, <-0.728555, -0.600174, -0.33015>, <-0.0928712, 5.58698, -1.48463>, <-0.938315, -0.340529, -0.060044>, <-0.0911305, 5.59088, -1.50201> , <-0.916963, -0.295779, -0.267755> }
	smooth_triangle { <-0.0928712, 5.58698, -1.48463>, <-0.938315, -0.340529, -0.060044>, <-0.0702715, 5.55602, -1.50816>, <-0.728555, -0.600174, -0.33015>, <-0.0716047, 5.55145, -1.4909> , <-0.746881, -0.654858, -0.115457> }
	smooth_triangle { <-0.0911305, 5.59088, -1.50201>, <-0.916963, -0.295779, -0.267755>, <-0.10034, 5.6289, -1.47724>, <-1, -1.29673e-006, -4.183e-008>, <-0.0984541, 5.63199, -1.49476> , <-0.977911, 0.0362975, -0.205847> }
	smooth_triangle { <-0.10034, 5.6289, -1.47724>, <-1, -1.29673e-006, -4.183e-008>, <-0.0911305, 5.59088, -1.50201>, <-0.916963, -0.295779, -0.267755>, <-0.0928712, 5.58698, -1.48463> , <-0.938315, -0.340529, -0.060044> }
	smooth_triangle { <-0.0984541, 5.63199, -1.49476>, <-0.977911, 0.0362975, -0.205847>, <-0.0928712, 5.67082, -1.46985>, <-0.938314, 0.340532, 0.0600449>, <-0.0911305, 5.67311, -1.48751> , <-0.916965, 0.369523, -0.150428> }
	smooth_triangle { <-0.0928712, 5.67082, -1.46985>, <-0.938314, 0.340532, 0.0600449>, <-0.0984541, 5.63199, -1.49476>, <-0.977911, 0.0362975, -0.205847>, <-0.10034, 5.6289, -1.47724> , <-1, -1.29673e-006, -4.183e-008> }
	smooth_triangle { <-0.0911305, 5.67311, -1.48751>, <-0.916965, 0.369523, -0.150428>, <-0.0716047, 5.70636, -1.46358>, <-0.74688, 0.654856, 0.115472>, <-0.0702715, 5.70796, -1.48137> , <-0.728555, 0.676892, -0.104999> }
	smooth_triangle { <-0.0716047, 5.70636, -1.46358>, <-0.74688, 0.654856, 0.115472>, <-0.0911305, 5.67311, -1.48751>, <-0.916965, 0.369523, -0.150428>, <-0.0928712, 5.67082, -1.46985> , <-0.938314, 0.340532, 0.0600449> }
	smooth_triangle { <-0.0390552, 5.73125, -1.47726>, <-0.410338, 0.908937, -0.0738742>, <-0.0716047, 5.70636, -1.46358>, <-0.74688, 0.654856, 0.115472>, <-0.0397768, 5.73011, -1.45939> , <-0.421534, 0.893035, 0.157474> }
	smooth_triangle { <-0.0716047, 5.70636, -1.46358>, <-0.74688, 0.654856, 0.115472>, <-0.0390552, 5.73125, -1.47726>, <-0.410338, 0.908937, -0.0738742>, <-0.0702715, 5.70796, -1.48137> , <-0.728555, 0.676892, -0.104999> }
	smooth_triangle { <-0.00223293, 5.73943, -1.47582>, <-1.78516e-006, 0.998041, -0.0625682>, <-0.0397768, 5.73011, -1.45939>, <-0.421534, 0.893035, 0.157474>, <-0.00223293, 5.73845, -1.45792> , <-7.45933e-007, 0.984806, 0.173659> }
	smooth_triangle { <-0.0397768, 5.73011, -1.45939>, <-0.421534, 0.893035, 0.157474>, <-0.00223293, 5.73943, -1.47582>, <-1.78516e-006, 0.998041, -0.0625682>, <-0.0390552, 5.73125, -1.47726> , <-0.410338, 0.908937, -0.0738742> }
	smooth_triangle { <0.0353105, 5.73011, -1.45939>, <0.421532, 0.893036, 0.157473>, <-0.00223293, 5.73943, -1.47582>, <-1.78132e-006, 0.998041, -0.0625682>, <-0.00223293, 5.73845, -1.45792> , <-7.45933e-007, 0.984806, 0.173659> }
	smooth_triangle { <-0.00223293, 5.73943, -1.47582>, <-1.78132e-006, 0.998041, -0.0625682>, <0.0353105, 5.73011, -1.45939>, <0.421532, 0.893036, 0.157473>, <0.0345896, 5.73125, -1.47726> , <0.410342, 0.908935, -0.0738704> }
	smooth_triangle { <0.0671388, 5.70636, -1.46358>, <0.746883, 0.654854, 0.115464>, <0.0345896, 5.73125, -1.47726>, <0.410342, 0.908935, -0.0738704>, <0.0353105, 5.73011, -1.45939> , <0.421532, 0.893036, 0.157473> }
	smooth_triangle { <0.0345896, 5.73125, -1.47726>, <0.410342, 0.908935, -0.0738704>, <0.0671388, 5.70636, -1.46358>, <0.746883, 0.654854, 0.115464>, <0.0658059, 5.70796, -1.48137> , <0.728557, 0.676894, -0.104975> }
	smooth_triangle { <0.0671388, 5.70636, -1.46358>, <0.746883, 0.654854, 0.115464>, <0.0866642, 5.67311, -1.48751>, <0.916963, 0.369524, -0.150436>, <0.0658059, 5.70796, -1.48137> , <0.728557, 0.676894, -0.104975> }
	smooth_triangle { <0.0866642, 5.67311, -1.48751>, <0.916963, 0.369524, -0.150436>, <0.0671388, 5.70636, -1.46358>, <0.746883, 0.654854, 0.115464>, <0.0884053, 5.67082, -1.46985> , <0.938315, 0.34053, 0.0600412> }
	smooth_triangle { <0.0884053, 5.67082, -1.46985>, <0.938315, 0.34053, 0.0600412>, <0.0939882, 5.63199, -1.49476>, <0.977914, 0.0362947, -0.205833>, <0.0866642, 5.67311, -1.48751> , <0.916963, 0.369524, -0.150436> }
	smooth_triangle { <0.0939882, 5.63199, -1.49476>, <0.977914, 0.0362947, -0.205833>, <0.0884053, 5.67082, -1.46985>, <0.938315, 0.34053, 0.0600412>, <0.0958737, 5.6289, -1.47724> , <1, -3.18668e-006, 2.81401e-006> }
	smooth_triangle { <0.0939882, 5.62581, -1.45972>, <0.994435, -0.0183019, 0.103752>, <0.0884053, 5.58698, -1.48463>, <0.938316, -0.340526, -0.0600359>, <0.0958737, 5.6289, -1.47724> , <1, -3.18668e-006, 2.81401e-006> }
	smooth_triangle { <0.0884053, 5.58698, -1.48463>, <0.938316, -0.340526, -0.0600359>, <0.0939882, 5.62581, -1.45972>, <0.994435, -0.0183019, 0.103752>, <0.0866642, 5.5847, -1.46697> , <0.932917, -0.357171, 0.0457632> }
	smooth_triangle { <0.0866642, 5.5847, -1.46697>, <0.932917, -0.357171, 0.0457632>, <0.0671388, 5.55145, -1.4909>, <0.746883, -0.654855, -0.115457>, <0.0884053, 5.58698, -1.48463> , <0.938316, -0.340526, -0.0600359> }
	smooth_triangle { <0.0671388, 5.55145, -1.4909>, <0.746883, -0.654855, -0.115457>, <0.0866642, 5.5847, -1.46697>, <0.932917, -0.357171, 0.0457632>, <0.0658059, 5.54984, -1.47311> , <0.742215, -0.670145, -0.00468721> }
	smooth_triangle { <0.0345896, 5.52655, -1.47722>, <0.418632, -0.90722, -0.0412155>, <0.0671388, 5.55145, -1.4909>, <0.746883, -0.654855, -0.115457>, <0.0658059, 5.54984, -1.47311> , <0.742215, -0.670145, -0.00468721> }
	smooth_triangle { <0.0671388, 5.55145, -1.4909>, <0.746883, -0.654855, -0.115457>, <0.0345896, 5.52655, -1.47722>, <0.418632, -0.90722, -0.0412155>, <0.0353105, 5.5277, -1.49508> , <0.421509, -0.893043, -0.157492> }
	smooth_triangle { <-0.00223293, 5.51837, -1.47866>, <2.97002e-006, -0.998491, -0.0549106>, <0.0353105, 5.5277, -1.49508>, <0.421509, -0.893043, -0.157492>, <0.0345896, 5.52655, -1.47722> , <0.418632, -0.90722, -0.0412155> }
	smooth_triangle { <0.0353105, 5.5277, -1.49508>, <0.421509, -0.893043, -0.157492>, <-0.00223293, 5.51837, -1.47866>, <2.97002e-006, -0.998491, -0.0549106>, <-0.00223293, 5.51936, -1.49655> , <1.16118e-006, -0.984804, -0.173671> }
	smooth_triangle { <-0.0397768, 5.5277, -1.49508>, <-0.421513, -0.893049, -0.157451>, <-0.00223293, 5.51837, -1.47866>, <2.97002e-006, -0.998491, -0.0549106>, <-0.0390552, 5.52655, -1.47722> , <-0.418636, -0.907219, -0.0412016> }
	smooth_triangle { <-0.00223293, 5.51837, -1.47866>, <2.97002e-006, -0.998491, -0.0549106>, <-0.0397768, 5.5277, -1.49508>, <-0.421513, -0.893049, -0.157451>, <-0.00223293, 5.51936, -1.49655> , <1.16118e-006, -0.984804, -0.173671> }
	smooth_triangle { <-0.0716047, 5.55145, -1.4909>, <-0.746881, -0.654858, -0.115457>, <-0.0390552, 5.52655, -1.47722>, <-0.418636, -0.907219, -0.0412016>, <-0.0702715, 5.54984, -1.47311> , <-0.742223, -0.670136, -0.00475887> }
	smooth_triangle { <-0.0390552, 5.52655, -1.47722>, <-0.418636, -0.907219, -0.0412016>, <-0.0716047, 5.55145, -1.4909>, <-0.746881, -0.654858, -0.115457>, <-0.0397768, 5.5277, -1.49508> , <-0.421512, -0.893049, -0.157451> }
	smooth_triangle { <-0.0716047, 5.55145, -1.4909>, <-0.746881, -0.654858, -0.115457>, <-0.0911305, 5.5847, -1.46697>, <-0.932912, -0.35718, 0.0457906>, <-0.0928712, 5.58698, -1.48463> , <-0.938315, -0.340529, -0.060044> }
	smooth_triangle { <-0.0911305, 5.5847, -1.46697>, <-0.932912, -0.35718, 0.0457906>, <-0.0716047, 5.55145, -1.4909>, <-0.746881, -0.654858, -0.115457>, <-0.0702715, 5.54984, -1.47311> , <-0.742223, -0.670136, -0.00475887> }
	smooth_triangle { <-0.0928712, 5.58698, -1.48463>, <-0.938315, -0.340529, -0.060044>, <-0.0984541, 5.62581, -1.45972>, <-0.994433, -0.018303, 0.103767>, <-0.10034, 5.6289, -1.47724> , <-1, -1.29293e-006, -4.183e-008> }
	smooth_triangle { <-0.0984541, 5.62581, -1.45972>, <-0.994433, -0.018303, 0.103767>, <-0.0928712, 5.58698, -1.48463>, <-0.938315, -0.340529, -0.060044>, <-0.0911305, 5.5847, -1.46697> , <-0.932912, -0.35718, 0.0457906> }
	smooth_triangle { <-0.10034, 5.6289, -1.47724>, <-1, -1.29673e-006, -3.99287e-008>, <-0.0911305, 5.66693, -1.45247>, <-0.932914, 0.319972, 0.165195>, <-0.0928712, 5.67082, -1.46985> , <-0.938314, 0.340532, 0.0600449> }
	smooth_triangle { <-0.0911305, 5.66693, -1.45247>, <-0.932914, 0.319972, 0.165195>, <-0.10034, 5.6289, -1.47724>, <-1, -1.29673e-006, -3.99287e-008>, <-0.0984541, 5.62581, -1.45972> , <-0.994433, -0.018303, 0.103767> }
	smooth_triangle { <-0.0928712, 5.67082, -1.46985>, <-0.938314, 0.340531, 0.0600449>, <-0.0702715, 5.70178, -1.44632>, <-0.742201, 0.631342, 0.224823>, <-0.0716047, 5.70636, -1.46358> , <-0.74688, 0.654856, 0.115472> }
	smooth_triangle { <-0.0702715, 5.70178, -1.44632>, <-0.742201, 0.631342, 0.224823>, <-0.0928712, 5.67082, -1.46985>, <-0.938314, 0.340531, 0.0600449>, <-0.0911305, 5.66693, -1.45247> , <-0.932914, 0.319972, 0.165195> }
	smooth_triangle { <-0.0397768, 5.73011, -1.45939>, <-0.421534, 0.893035, 0.157474>, <-0.0702715, 5.70178, -1.44632>, <-0.742201, 0.631342, 0.224823>, <-0.0390552, 5.72507, -1.44222> , <-0.418642, 0.866585, 0.271605> }
	smooth_triangle { <-0.0702715, 5.70178, -1.44632>, <-0.742201, 0.631342, 0.224823>, <-0.0397768, 5.73011, -1.45939>, <-0.421534, 0.893035, 0.157474>, <-0.0716047, 5.70636, -1.46358> , <-0.74688, 0.654856, 0.115472> }
	smooth_triangle { <-0.00223293, 5.73845, -1.45792>, <-7.45933e-007, 0.984806, 0.173659>, <-0.0390552, 5.72507, -1.44222>, <-0.418642, 0.866585, 0.271605>, <-0.00223293, 5.73325, -1.44077> , <-1.45067e-006, 0.957044, 0.289941> }
	smooth_triangle { <-0.0390552, 5.72507, -1.44222>, <-0.418642, 0.866585, 0.271605>, <-0.00223293, 5.73845, -1.45792>, <-7.45933e-007, 0.984806, 0.173659>, <-0.0397768, 5.73011, -1.45939> , <-0.421534, 0.893035, 0.157474> }
	smooth_triangle { <0.0345896, 5.72507, -1.44222>, <0.41864, 0.866593, 0.271582>, <-0.00223293, 5.73845, -1.45792>, <-7.45933e-007, 0.984806, 0.173659>, <-0.00223293, 5.73325, -1.44077> , <-1.45067e-006, 0.957044, 0.289941> }
	smooth_triangle { <-0.00223293, 5.73845, -1.45792>, <-7.45933e-007, 0.984806, 0.173659>, <0.0345896, 5.72507, -1.44222>, <0.41864, 0.866593, 0.271582>, <0.0353105, 5.73011, -1.45939> , <0.421532, 0.893036, 0.157473> }
	smooth_triangle { <0.0658059, 5.70178, -1.44632>, <0.742204, 0.631348, 0.224796>, <0.0353105, 5.73011, -1.45939>, <0.421532, 0.893036, 0.157473>, <0.0345896, 5.72507, -1.44222> , <0.41864, 0.866593, 0.271582> }
	smooth_triangle { <0.0353105, 5.73011, -1.45939>, <0.421532, 0.893036, 0.157473>, <0.0658059, 5.70178, -1.44632>, <0.742204, 0.631348, 0.224796>, <0.0671388, 5.70636, -1.46358> , <0.746883, 0.654854, 0.115464> }
	smooth_triangle { <0.0658059, 5.70178, -1.44632>, <0.742204, 0.631348, 0.224796>, <0.0884053, 5.67082, -1.46985>, <0.938315, 0.34053, 0.0600412>, <0.0671388, 5.70636, -1.46358> , <0.746883, 0.654854, 0.115464> }
	smooth_triangle { <0.0884053, 5.67082, -1.46985>, <0.938315, 0.34053, 0.0600412>, <0.0658059, 5.70178, -1.44632>, <0.742204, 0.631348, 0.224796>, <0.0866642, 5.66693, -1.45247> , <0.932915, 0.319969, 0.165195> }
	smooth_triangle { <0.0866642, 5.66693, -1.45247>, <0.932915, 0.319969, 0.165195>, <0.0958737, 5.6289, -1.47724>, <1, -3.18668e-006, 2.81401e-006>, <0.0884053, 5.67082, -1.46985> , <0.938315, 0.34053, 0.0600412> }
	smooth_triangle { <0.0958737, 5.6289, -1.47724>, <1, -3.18668e-006, 2.81401e-006>, <0.0866642, 5.66693, -1.45247>, <0.932915, 0.319969, 0.165195>, <0.0939882, 5.62581, -1.45972> , <0.994435, -0.0183019, 0.103752> }
	smooth_triangle { <0.0866642, 5.66693, -1.45247>, <7.12137e-005, -0.173618, 0.984813>, <0.0866642, 5.5847, -1.46697>, <7.12137e-005, -0.173618, 0.984813>, <0.0939882, 5.62581, -1.45972> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <0.0658059, 5.70178, -1.44632>, <7.12137e-005, -0.173618, 0.984813>, <0.0866642, 5.5847, -1.46697>, <7.12137e-005, -0.173618, 0.984813>, <0.0866642, 5.66693, -1.45247> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <0.0658059, 5.70178, -1.44632>, <7.12137e-005, -0.173618, 0.984813>, <0.0658059, 5.54984, -1.47311>, <7.12137e-005, -0.173618, 0.984813>, <0.0866642, 5.5847, -1.46697> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <0.0345896, 5.72507, -1.44222>, <7.12137e-005, -0.173618, 0.984813>, <0.0658059, 5.54984, -1.47311>, <7.12137e-005, -0.173618, 0.984813>, <0.0658059, 5.70178, -1.44632> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <0.0345896, 5.72507, -1.44222>, <7.12137e-005, -0.173618, 0.984813>, <0.0345896, 5.52655, -1.47722>, <7.12137e-005, -0.173618, 0.984813>, <0.0658059, 5.54984, -1.47311> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.00223293, 5.73325, -1.44077>, <7.12137e-005, -0.173618, 0.984813>, <0.0345896, 5.52655, -1.47722>, <7.12137e-005, -0.173618, 0.984813>, <0.0345896, 5.72507, -1.44222> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.00223293, 5.73325, -1.44077>, <7.12137e-005, -0.173618, 0.984813>, <-0.00223293, 5.51837, -1.47866>, <7.12137e-005, -0.173618, 0.984813>, <0.0345896, 5.52655, -1.47722> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.0390552, 5.72507, -1.44222>, <7.12137e-005, -0.173618, 0.984813>, <-0.00223293, 5.51837, -1.47866>, <7.12137e-005, -0.173618, 0.984813>, <-0.00223293, 5.73325, -1.44077> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.0390552, 5.72507, -1.44222>, <7.12137e-005, -0.173618, 0.984813>, <-0.0390552, 5.52655, -1.47722>, <7.12137e-005, -0.173618, 0.984813>, <-0.00223293, 5.51837, -1.47866> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.0702715, 5.70178, -1.44632>, <7.12137e-005, -0.173618, 0.984813>, <-0.0390552, 5.52655, -1.47722>, <7.12137e-005, -0.173618, 0.984813>, <-0.0390552, 5.72507, -1.44222> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.0702715, 5.70178, -1.44632>, <7.12137e-005, -0.173618, 0.984813>, <-0.0702715, 5.54984, -1.47311>, <7.12137e-005, -0.173618, 0.984813>, <-0.0390552, 5.52655, -1.47722> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.0911305, 5.66693, -1.45247>, <7.12137e-005, -0.173618, 0.984813>, <-0.0702715, 5.54984, -1.47311>, <7.12137e-005, -0.173618, 0.984813>, <-0.0702715, 5.70178, -1.44632> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.0911305, 5.66693, -1.45247>, <7.12137e-005, -0.173618, 0.984813>, <-0.0911305, 5.5847, -1.46697>, <7.12137e-005, -0.173618, 0.984813>, <-0.0702715, 5.54984, -1.47311> , <7.12137e-005, -0.173618, 0.984813> }
	smooth_triangle { <-0.0911305, 5.5847, -1.46697>, <7.12137e-005, -0.173618, 0.984813>, <-0.0911305, 5.66693, -1.45247>, <7.12137e-005, -0.173618, 0.984813>, <-0.0984541, 5.62581, -1.45972> , <7.12137e-005, -0.173618, 0.984813> }
texture { RedPlastic }
}

// object Legs1
union {
	smooth_triangle { <-0.2685, 5.74051, -1.0942>, <-1, 0, 0>, <-0.2685, 5.74306, -1.06216>, <-1, 0, 0>, <-0.2685, 5.74347, -1.07427> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.74051, -1.0942>, <-1, 0, 0>, <-0.2685, 5.73966, -1.04801>, <-1, 0, 0>, <-0.2685, 5.74306, -1.06216> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.73373, -1.10655>, <-1, 0, 0>, <-0.2685, 5.73966, -1.04801>, <-1, 0, 0>, <-0.2685, 5.74051, -1.0942> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.73373, -1.10655>, <-1, 0, 0>, <-0.2685, 5.7293, -1.03204>, <-1, 0, 0>, <-0.2685, 5.73966, -1.04801> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.71763, -1.12636>, <-1, 0, 0>, <-0.2685, 5.7293, -1.03204>, <-1, 0, 0>, <-0.2685, 5.73373, -1.10655> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.71763, -1.12636>, <-1, 0, 0>, <-0.2685, 5.71662, -1.01983>, <-1, 0, 0>, <-0.2685, 5.7293, -1.03204> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.71763, -1.12636>, <-1, 0, 0>, <-0.2685, 5.69686, -1.00705>, <-1, 0, 0>, <-0.2685, 5.71662, -1.01983> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.69647, -1.14006>, <-1, 0, 0>, <-0.2685, 5.69686, -1.00705>, <-1, 0, 0>, <-0.2685, 5.71763, -1.12636> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.69647, -1.14006>, <-1, 0, 0>, <-0.2685, 5.67579, -0.999724>, <-1, 0, 0>, <-0.2685, 5.69686, -1.00705> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.67125, -1.15216>, <-1, 0, 0>, <-0.2685, 5.67579, -0.999724>, <-1, 0, 0>, <-0.2685, 5.69647, -1.14006> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.67125, -1.15216>, <-1, 0, 0>, <-0.2685, 5.65963, -0.998551>, <-1, 0, 0>, <-0.2685, 5.67579, -0.999724> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.64899, -1.159>, <-1, 0, 0>, <-0.2685, 5.65963, -0.998551>, <-1, 0, 0>, <-0.2685, 5.67125, -1.15216> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.64899, -1.159>, <-1, 0, 0>, <-0.2685, 5.63053, -0.999956>, <-1, 0, 0>, <-0.2685, 5.65963, -0.998551> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.62333, -1.16355>, <-1, 0, 0>, <-0.2685, 5.63053, -0.999956>, <-1, 0, 0>, <-0.2685, 5.64899, -1.159> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.59663, -1.16603>, <-1, 0, 0>, <-0.2685, 5.63053, -0.999956>, <-1, 0, 0>, <-0.2685, 5.62333, -1.16355> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.59663, -1.16603>, <-1, 0, 0>, <-0.2685, 5.58129, -1.00925>, <-1, 0, 0>, <-0.2685, 5.63053, -0.999956> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.56969, -1.16492>, <-1, 0, 0>, <-0.2685, 5.58129, -1.00925>, <-1, 0, 0>, <-0.2685, 5.59663, -1.16603> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.54441, -1.16382>, <-1, 0, 0>, <-0.2685, 5.58129, -1.00925>, <-1, 0, 0>, <-0.2685, 5.56969, -1.16492> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.54441, -1.16382>, <-1, 0, 0>, <-0.2685, 5.54258, -1.0193>, <-1, 0, 0>, <-0.2685, 5.58129, -1.00925> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.52348, -1.16176>, <-1, 0, 0>, <-0.2685, 5.54258, -1.0193>, <-1, 0, 0>, <-0.2685, 5.54441, -1.16382> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.50159, -1.15653>, <-1, 0, 0>, <-0.2685, 5.54258, -1.0193>, <-1, 0, 0>, <-0.2685, 5.52348, -1.16176> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.50159, -1.15653>, <-1, 0, 0>, <-0.2685, 5.49783, -1.02796>, <-1, 0, 0>, <-0.2685, 5.54258, -1.0193> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.50159, -1.15653>, <-1, 0, 0>, <-0.2685, 5.46075, -1.03514>, <-1, 0, 0>, <-0.2685, 5.49783, -1.02796> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.43987, -1.13645>, <-1, 0, 0>, <-0.2685, 5.46075, -1.03514>, <-1, 0, 0>, <-0.2685, 5.50159, -1.15653> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.43987, -1.13645>, <-1, 0, 0>, <-0.2685, 5.42103, -1.03831>, <-1, 0, 0>, <-0.2685, 5.46075, -1.03514> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.4005, -1.11893>, <-1, 0, 0>, <-0.2685, 5.42103, -1.03831>, <-1, 0, 0>, <-0.2685, 5.43987, -1.13645> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.4005, -1.11893>, <-1, 0, 0>, <-0.2685, 5.39428, -1.03668>, <-1, 0, 0>, <-0.2685, 5.42103, -1.03831> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.4005, -1.11893>, <-1, 0, 0>, <-0.2685, 5.37438, -1.03294>, <-1, 0, 0>, <-0.2685, 5.39428, -1.03668> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.35571, -1.09748>, <-1, 0, 0>, <-0.2685, 5.37438, -1.03294>, <-1, 0, 0>, <-0.2685, 5.4005, -1.11893> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.35571, -1.09748>, <-1, 0, 0>, <-0.2685, 5.35543, -1.02841>, <-1, 0, 0>, <-0.2685, 5.37438, -1.03294> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.35571, -1.09748>, <-1, 0, 0>, <-0.2685, 5.3318, -1.01745>, <-1, 0, 0>, <-0.2685, 5.35543, -1.02841> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.35571, -1.09748>, <-1, 0, 0>, <-0.2685, 5.30251, -0.995241>, <-1, 0, 0>, <-0.2685, 5.3318, -1.01745> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.29871, -1.06007>, <-1, 0, 0>, <-0.2685, 5.30251, -0.995241>, <-1, 0, 0>, <-0.2685, 5.35571, -1.09748> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.29871, -1.06007>, <-1, 0, 0>, <-0.2685, 5.29114, -0.989357>, <-1, 0, 0>, <-0.2685, 5.30251, -0.995241> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.29871, -1.06007>, <-1, 0, 0>, <-0.2685, 5.28205, -0.988489>, <-1, 0, 0>, <-0.2685, 5.29114, -0.989357> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.26139, -1.03164>, <-1, 0, 0>, <-0.2685, 5.28205, -0.988489>, <-1, 0, 0>, <-0.2685, 5.29871, -1.06007> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.19736, -1.03375>, <-1, 0, 0>, <-0.2685, 5.28205, -0.988489>, <-1, 0, 0>, <-0.2685, 5.26139, -1.03164> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.15172, -1.03726>, <-1, 0, 0>, <-0.2685, 5.28205, -0.988489>, <-1, 0, 0>, <-0.2685, 5.19736, -1.03375> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.15172, -1.03726>, <-1, 0, 0>, <-0.2685, 5.09672, -1.00895>, <-1, 0, 0>, <-0.2685, 5.28205, -0.988489> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.08969, -1.04592>, <-1, 0, 0>, <-0.2685, 5.09672, -1.00895>, <-1, 0, 0>, <-0.2685, 5.15172, -1.03726> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.08969, -1.04592>, <-1, 0, 0>, <-0.2685, 5.08481, -0.995053>, <-1, 0, 0>, <-0.2685, 5.09672, -1.00895> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.08177, -1.06767>, <-1, 0, 0>, <-0.2685, 5.08481, -0.995053>, <-1, 0, 0>, <-0.2685, 5.08969, -1.04592> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.08177, -1.06767>, <-1, 0, 0>, <-0.268765, 5.07915, -0.991091>, <-1, 0, 0>, <-0.2685, 5.08481, -0.995053> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.07762, -1.07509>, <-1, 0, 0>, <-0.268765, 5.07915, -0.991091>, <-1, 0, 0>, <-0.2685, 5.08177, -1.06767> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.07762, -1.07509>, <-1, 0, 0>, <-0.268587, 5.06326, -0.988465>, <-1, 0, 0>, <-0.268765, 5.07915, -0.991091> , <-1, 0, 0> }
	smooth_triangle { <-0.2685, 5.07762, -1.07509>, <-1, 0, 0>, <-0.268637, 5.04377, -0.988346>, <-1, 0, 0>, <-0.268587, 5.06326, -0.988465> , <-1, 0, 0> }
	smooth_triangle { <-0.268637, 5.04377, -0.988346>, <-1, 0, 0>, <-0.2685, 5.07762, -1.07509>, <-1, 0, 0>, <-0.2685, 5.04375, -1.07965> , <-1, 0, 0> }
	smooth_triangle { <-0.252867, 5.75855, -1.06006>, <-0.705438, 0.702309, 0.0954999>, <-0.2685, 5.74347, -1.07427>, <-0.706918, 0.706156, -0.040135>, <-0.2685, 5.74306, -1.06216> , <-0.705438, 0.702309, 0.0954999> }
	smooth_triangle { <-0.2685, 5.74347, -1.07427>, <-0.706918, 0.706156, -0.040135>, <-0.252867, 5.75855, -1.06006>, <-0.705438, 0.702309, 0.0954999>, <-0.252867, 5.75908, -1.07516> , <-0.706918, 0.706156, -0.040135> }
	smooth_triangle { <-0.252867, 5.75533, -1.09919>, <-0.709137, 0.668106, -0.225299>, <-0.2685, 5.74347, -1.07427>, <-0.706918, 0.706156, -0.040135>, <-0.252867, 5.75908, -1.07516> , <-0.706918, 0.706156, -0.040135> }
	smooth_triangle { <-0.2685, 5.74347, -1.07427>, <-0.706918, 0.706156, -0.040135>, <-0.252867, 5.75533, -1.09919>, <-0.709137, 0.668106, -0.225299>, <-0.2685, 5.74051, -1.0942> , <-0.709137, 0.668106, -0.225299> }
	smooth_triangle { <-0.252867, 5.7467, -1.11528>, <-0.704981, 0.588471, -0.395857>, <-0.2685, 5.74051, -1.0942>, <-0.709137, 0.668106, -0.225299>, <-0.252867, 5.75533, -1.09919> , <-0.709137, 0.668106, -0.225299> }
	smooth_triangle { <-0.2685, 5.74051, -1.0942>, <-0.709137, 0.668106, -0.225299>, <-0.252867, 5.7467, -1.11528>, <-0.704981, 0.588471, -0.395857>, <-0.2685, 5.73373, -1.10655> , <-0.704981, 0.588471, -0.395857> }
	smooth_triangle { <-0.252867, 5.72807, -1.13799>, <-0.708538, 0.471182, -0.525321>, <-0.2685, 5.73373, -1.10655>, <-0.704981, 0.588471, -0.395857>, <-0.252867, 5.7467, -1.11528> , <-0.704981, 0.588471, -0.395857> }
	smooth_triangle { <-0.2685, 5.73373, -1.10655>, <-0.704981, 0.588471, -0.395857>, <-0.252867, 5.72807, -1.13799>, <-0.708538, 0.471182, -0.525321>, <-0.2685, 5.71763, -1.12636> , <-0.708538, 0.471182, -0.525321> }
	smooth_triangle { <-0.252867, 5.70412, -1.1537>, <-0.705279, 0.346862, -0.618279>, <-0.2685, 5.71763, -1.12636>, <-0.708538, 0.471182, -0.525321>, <-0.252867, 5.72807, -1.13799> , <-0.708538, 0.471182, -0.525321> }
	smooth_triangle { <-0.2685, 5.71763, -1.12636>, <-0.708538, 0.471182, -0.525321>, <-0.252867, 5.70412, -1.1537>, <-0.705279, 0.346862, -0.618279>, <-0.2685, 5.69647, -1.14006> , <-0.705279, 0.346862, -0.618279> }
	smooth_triangle { <-0.252867, 5.67693, -1.16672>, <-0.70721, 0.257351, -0.658502>, <-0.2685, 5.69647, -1.14006>, <-0.705279, 0.346862, -0.618279>, <-0.252867, 5.70412, -1.1537> , <-0.705279, 0.346862, -0.618279> }
	smooth_triangle { <-0.2685, 5.69647, -1.14006>, <-0.705279, 0.346862, -0.618279>, <-0.252867, 5.67693, -1.16672>, <-0.70721, 0.257351, -0.658502>, <-0.2685, 5.67125, -1.15216> , <-0.70721, 0.257351, -0.658502> }
	smooth_triangle { <-0.252867, 5.65265, -1.17419>, <-0.706902, 0.165911, -0.687578>, <-0.2685, 5.67125, -1.15216>, <-0.70721, 0.257351, -0.658502>, <-0.252867, 5.67693, -1.16672> , <-0.70721, 0.257351, -0.658502> }
	smooth_triangle { <-0.2685, 5.67125, -1.15216>, <-0.70721, 0.257351, -0.658502>, <-0.252867, 5.65265, -1.17419>, <-0.706902, 0.165911, -0.687578>, <-0.2685, 5.64899, -1.159> , <-0.706902, 0.165911, -0.687578> }
	smooth_triangle { <-0.252867, 5.62542, -1.17904>, <-0.7069, 0.0945692, -0.700963>, <-0.2685, 5.64899, -1.159>, <-0.706902, 0.165911, -0.687578>, <-0.252867, 5.65265, -1.17419> , <-0.706902, 0.165911, -0.687578> }
	smooth_triangle { <-0.2685, 5.64899, -1.159>, <-0.706902, 0.165911, -0.687578>, <-0.252867, 5.62542, -1.17904>, <-0.7069, 0.0945692, -0.700963>, <-0.2685, 5.62333, -1.16355> , <-0.7069, 0.0945692, -0.700963> }
	smooth_triangle { <-0.252867, 5.59704, -1.18166>, <-0.707331, 0.0181125, -0.706651>, <-0.2685, 5.62333, -1.16355>, <-0.7069, 0.0945692, -0.700963>, <-0.252867, 5.62542, -1.17904> , <-0.7069, 0.0945692, -0.700963> }
	smooth_triangle { <-0.2685, 5.62333, -1.16355>, <-0.7069, 0.0945692, -0.700963>, <-0.252867, 5.59704, -1.18166>, <-0.707331, 0.0181125, -0.706651>, <-0.2685, 5.59663, -1.16603> , <-0.707331, 0.0181125, -0.706651> }
	smooth_triangle { <-0.252867, 5.59704, -1.18166>, <-0.707331, 0.0181125, -0.706651>, <-0.2685, 5.56969, -1.16492>, <-0.706692, -0.0298591, -0.706891>, <-0.2685, 5.59663, -1.16603> , <-0.707331, 0.0181125, -0.706651> }
	smooth_triangle { <-0.2685, 5.56969, -1.16492>, <-0.706692, -0.0298591, -0.706891>, <-0.252867, 5.59704, -1.18166>, <-0.707331, 0.0181125, -0.706651>, <-0.252867, 5.56903, -1.18053> , <-0.706692, -0.0298591, -0.706891> }
	smooth_triangle { <-0.252867, 5.56903, -1.18053>, <-0.706692, -0.0298591, -0.706891>, <-0.2685, 5.54441, -1.16382>, <-0.707146, -0.0499619, -0.7053>, <-0.2685, 5.56969, -1.16492> , <-0.706692, -0.0298591, -0.706891> }
	smooth_triangle { <-0.2685, 5.54441, -1.16382>, <-0.707146, -0.0499619, -0.7053>, <-0.252867, 5.56903, -1.18053>, <-0.706692, -0.0298591, -0.706891>, <-0.252867, 5.54331, -1.17942> , <-0.707146, -0.0499619, -0.7053> }
	smooth_triangle { <-0.252867, 5.54331, -1.17942>, <-0.707146, -0.0499619, -0.7053>, <-0.2685, 5.52348, -1.16176>, <-0.707416, -0.117147, -0.697022>, <-0.2685, 5.54441, -1.16382> , <-0.707146, -0.0499619, -0.7053> }
	smooth_triangle { <-0.2685, 5.52348, -1.16176>, <-0.707416, -0.117147, -0.697022>, <-0.252867, 5.54331, -1.17942>, <-0.707146, -0.0499619, -0.7053>, <-0.252867, 5.52089, -1.17718> , <-0.707416, -0.117147, -0.697022> }
	smooth_triangle { <-0.252867, 5.52089, -1.17718>, <-0.707416, -0.117147, -0.697022>, <-0.2685, 5.50159, -1.15653>, <-0.70679, -0.191835, -0.680917>, <-0.2685, 5.52348, -1.16176> , <-0.707416, -0.117147, -0.697022> }
	smooth_triangle { <-0.2685, 5.50159, -1.15653>, <-0.70679, -0.191835, -0.680917>, <-0.252867, 5.52089, -1.17718>, <-0.707416, -0.117147, -0.697022>, <-0.252867, 5.49735, -1.17157> , <-0.70679, -0.191835, -0.680917> }
	smooth_triangle { <-0.252867, 5.49735, -1.17157>, <-0.70679, -0.191835, -0.680917>, <-0.2685, 5.43987, -1.13645>, <-0.707178, -0.253439, -0.660052>, <-0.2685, 5.50159, -1.15653> , <-0.70679, -0.191835, -0.680917> }
	smooth_triangle { <-0.2685, 5.43987, -1.13645>, <-0.707178, -0.253439, -0.660052>, <-0.252867, 5.49735, -1.17157>, <-0.70679, -0.191835, -0.680917>, <-0.252867, 5.43426, -1.15104> , <-0.707178, -0.253439, -0.660052> }
	smooth_triangle { <-0.252867, 5.43426, -1.15104>, <-0.707178, -0.253439, -0.660052>, <-0.2685, 5.4005, -1.11893>, <-0.706876, -0.296558, -0.642168>, <-0.2685, 5.43987, -1.13645> , <-0.707178, -0.253439, -0.660052> }
	smooth_triangle { <-0.2685, 5.4005, -1.11893>, <-0.706876, -0.296558, -0.642168>, <-0.252867, 5.43426, -1.15104>, <-0.707178, -0.253439, -0.660052>, <-0.252867, 5.39395, -1.13312> , <-0.706876, -0.296558, -0.642168> }
	smooth_triangle { <-0.252867, 5.39395, -1.13312>, <-0.706876, -0.296558, -0.642168>, <-0.2685, 5.35571, -1.09748>, <-0.707479, -0.347305, -0.615509>, <-0.2685, 5.4005, -1.11893> , <-0.706876, -0.296558, -0.642168> }
	smooth_triangle { <-0.2685, 5.35571, -1.09748>, <-0.707479, -0.347305, -0.615509>, <-0.252867, 5.39395, -1.13312>, <-0.706876, -0.296558, -0.642168>, <-0.252867, 5.34803, -1.1111> , <-0.707479, -0.347305, -0.615509> }
	smooth_triangle { <-0.252867, 5.34803, -1.1111>, <-0.707479, -0.347305, -0.615509>, <-0.2685, 5.29871, -1.06007>, <-0.706807, -0.408674, -0.577416>, <-0.2685, 5.35571, -1.09748> , <-0.707479, -0.347305, -0.615509> }
	smooth_triangle { <-0.2685, 5.29871, -1.06007>, <-0.706807, -0.408674, -0.577416>, <-0.252867, 5.34803, -1.1111>, <-0.707479, -0.347305, -0.615509>, <-0.252867, 5.28968, -1.07283> , <-0.706807, -0.408674, -0.577416> }
	smooth_triangle { <-0.252867, 5.28968, -1.07283>, <-0.706807, -0.408674, -0.577416>, <-0.2685, 5.26139, -1.03164>, <-0.717454, -0.208497, -0.664672>, <-0.2685, 5.29871, -1.06007> , <-0.706807, -0.408674, -0.577416> }
	smooth_triangle { <-0.2685, 5.26139, -1.03164>, <-0.717454, -0.208497, -0.664672>, <-0.252867, 5.28968, -1.07283>, <-0.706807, -0.408674, -0.577416>, <-0.252867, 5.25664, -1.04653> , <-0.717454, -0.208497, -0.664672> }
	smooth_triangle { <-0.252867, 5.19822, -1.04936>, <-0.696514, 0.0390878, -0.716478>, <-0.2685, 5.26139, -1.03164>, <-0.717454, -0.208497, -0.664672>, <-0.252867, 5.25664, -1.04653> , <-0.717454, -0.208497, -0.664672> }
	smooth_triangle { <-0.2685, 5.26139, -1.03164>, <-0.717454, -0.208497, -0.664672>, <-0.252867, 5.19822, -1.04936>, <-0.696514, 0.0390878, -0.716478>, <-0.2685, 5.19736, -1.03375> , <-0.696514, 0.0390878, -0.716478> }
	smooth_triangle { <-0.252867, 5.1534, -1.0528>, <-0.707132, 0.0760266, -0.702982>, <-0.2685, 5.19736, -1.03375>, <-0.696514, 0.0390878, -0.716478>, <-0.252867, 5.19822, -1.04936> , <-0.696514, 0.0390878, -0.716478> }
	smooth_triangle { <-0.2685, 5.19736, -1.03375>, <-0.696514, 0.0390878, -0.716478>, <-0.252867, 5.1534, -1.0528>, <-0.707132, 0.0760266, -0.702982>, <-0.2685, 5.15172, -1.03726> , <-0.707132, 0.0760266, -0.702982> }
	smooth_triangle { <-0.252867, 5.09952, -1.05807>, <-0.733753, 0.43857, -0.518905>, <-0.2685, 5.15172, -1.03726>, <-0.707132, 0.0760266, -0.702982>, <-0.252867, 5.1534, -1.0528> , <-0.707132, 0.0760266, -0.702982> }
	smooth_triangle { <-0.2685, 5.15172, -1.03726>, <-0.707132, 0.0760266, -0.702982>, <-0.252867, 5.09952, -1.05807>, <-0.733753, 0.43857, -0.518905>, <-0.2685, 5.08969, -1.04592> , <-0.733753, 0.43857, -0.518905> }
	smooth_triangle { <-0.252867, 5.09598, -1.07418>, <-0.679974, 0.667452, -0.303551>, <-0.2685, 5.08969, -1.04592>, <-0.733753, 0.43857, -0.518905>, <-0.252867, 5.09952, -1.05807> , <-0.733753, 0.43857, -0.518905> }
	smooth_triangle { <-0.2685, 5.08969, -1.04592>, <-0.733753, 0.43857, -0.518905>, <-0.252867, 5.09598, -1.07418>, <-0.679974, 0.667452, -0.303551>, <-0.2685, 5.08177, -1.06767> , <-0.679974, 0.667452, -0.303551> }
	smooth_triangle { <-0.252867, 5.08673, -1.08779>, <-0.723692, 0.379885, -0.576157>, <-0.2685, 5.08177, -1.06767>, <-0.679974, 0.667452, -0.303551>, <-0.252867, 5.09598, -1.07418> , <-0.679974, 0.667452, -0.303551> }
	smooth_triangle { <-0.2685, 5.08177, -1.06767>, <-0.679974, 0.667452, -0.303551>, <-0.252867, 5.08673, -1.08779>, <-0.723692, 0.379885, -0.576157>, <-0.2685, 5.07762, -1.07509> , <-0.723692, 0.379885, -0.576157> }
	smooth_triangle { <-0.2685, 5.04375, -1.07965>, <-0.661864, 0.0999735, -0.742928>, <-0.252867, 5.08673, -1.08779>, <-0.723692, 0.379885, -0.576157>, <-0.252853, 5.04318, -1.09167> , <-0.661864, 0.0999735, -0.742928> }
	smooth_triangle { <-0.252867, 5.08673, -1.08779>, <-0.723692, 0.379885, -0.576157>, <-0.2685, 5.04375, -1.07965>, <-0.661864, 0.0999735, -0.742928>, <-0.2685, 5.07762, -1.07509> , <-0.723692, 0.379885, -0.576157> }
	smooth_triangle { <-0.2685, 5.04375, -1.07965>, <-0.03635, -0.999339, 0.000175102>, <-0.253076, 5.0422, -0.977227>, <-0.03635, -0.999339, 0.000175102>, <-0.268637, 5.04377, -0.988346> , <-0.03635, -0.999339, 0.000175102> }
	smooth_triangle { <-0.253076, 5.0422, -0.977227>, <-0.03635, -0.999339, 0.000175102>, <-0.2685, 5.04375, -1.07965>, <-0.03635, -0.999339, 0.000175102>, <-0.252853, 5.04318, -1.09167> , <-0.03635, -0.999339, 0.000175102> }
	smooth_triangle { <-0.268587, 5.06326, -0.988465>, <-0.626529, 0.0604229, 0.777053>, <-0.253076, 5.0422, -0.977227>, <-0.580951, 0.00643385, 0.813913>, <-0.251312, 5.06462, -0.972979> , <-0.626529, 0.0604229, 0.777053> }
	smooth_triangle { <-0.253076, 5.0422, -0.977227>, <-0.580951, 0.00643385, 0.813913>, <-0.268587, 5.06326, -0.988465>, <-0.626529, 0.0604229, 0.777053>, <-0.268637, 5.04377, -0.988346> , <-0.580951, 0.00643385, 0.813913> }
	smooth_triangle { <-0.253111, 5.08417, -0.976714>, <-0.685039, 0.282647, 0.67144>, <-0.268587, 5.06326, -0.988465>, <-0.626529, 0.0604229, 0.777053>, <-0.251312, 5.06462, -0.972979> , <-0.626529, 0.0604229, 0.777053> }
	smooth_triangle { <-0.268587, 5.06326, -0.988465>, <-0.626529, 0.0604229, 0.777053>, <-0.253111, 5.08417, -0.976714>, <-0.685039, 0.282647, 0.67144>, <-0.268765, 5.07915, -0.991091> , <-0.685039, 0.282647, 0.67144> }
	smooth_triangle { <-0.2685, 5.08481, -0.995053>, <-0.675451, 0.505483, 0.536893>, <-0.253111, 5.08417, -0.976714>, <-0.685039, 0.282647, 0.67144>, <-0.251384, 5.09515, -0.983576> , <-0.675451, 0.505483, 0.536893> }
	smooth_triangle { <-0.253111, 5.08417, -0.976714>, <-0.685039, 0.282647, 0.67144>, <-0.2685, 5.08481, -0.995053>, <-0.675451, 0.505483, 0.536893>, <-0.268765, 5.07915, -0.991091> , <-0.685039, 0.282647, 0.67144> }
	smooth_triangle { <-0.2685, 5.09672, -1.00895>, <-0.709336, 0.257977, 0.655965>, <-0.251384, 5.09515, -0.983576>, <-0.675451, 0.505483, 0.536893>, <-0.252867, 5.10246, -0.994415> , <-0.709336, 0.257977, 0.655965> }
	smooth_triangle { <-0.251384, 5.09515, -0.983576>, <-0.675451, 0.505483, 0.536893>, <-0.2685, 5.09672, -1.00895>, <-0.709336, 0.257977, 0.655965>, <-0.2685, 5.08481, -0.995053> , <-0.675451, 0.505483, 0.536893> }
	smooth_triangle { <-0.2685, 5.28205, -0.988489>, <-0.685989, -0.00745059, 0.727574>, <-0.252867, 5.10246, -0.994415>, <-0.709336, 0.257977, 0.655965>, <-0.252867, 5.28194, -0.972858> , <-0.685989, -0.00745059, 0.727574> }
	smooth_triangle { <-0.252867, 5.10246, -0.994415>, <-0.709336, 0.257977, 0.655965>, <-0.2685, 5.28205, -0.988489>, <-0.685989, -0.00745059, 0.727574>, <-0.2685, 5.09672, -1.00895> , <-0.709336, 0.257977, 0.655965> }
	smooth_triangle { <-0.2685, 5.29114, -0.989357>, <-0.709416, 0.199604, 0.675934>, <-0.252867, 5.28194, -0.972858>, <-0.685989, -0.00745059, 0.727574>, <-0.252867, 5.29556, -0.974361> , <-0.709416, 0.199604, 0.675934> }
	smooth_triangle { <-0.252867, 5.28194, -0.972858>, <-0.685989, -0.00745059, 0.727574>, <-0.2685, 5.29114, -0.989357>, <-0.709416, 0.199604, 0.675934>, <-0.2685, 5.28205, -0.988489> , <-0.685989, -0.00745059, 0.727574> }
	smooth_triangle { <-0.2685, 5.30251, -0.995241>, <-0.70449, 0.37875, 0.600203>, <-0.252867, 5.29556, -0.974361>, <-0.709416, 0.199604, 0.675934>, <-0.252867, 5.31085, -0.982024> , <-0.70449, 0.37875, 0.600203> }
	smooth_triangle { <-0.252867, 5.29556, -0.974361>, <-0.709416, 0.199604, 0.675934>, <-0.2685, 5.30251, -0.995241>, <-0.70449, 0.37875, 0.600203>, <-0.2685, 5.29114, -0.989357> , <-0.709416, 0.199604, 0.675934> }
	smooth_triangle { <-0.2685, 5.3318, -1.01745>, <-0.707458, 0.364199, 0.605692>, <-0.252867, 5.31085, -0.982024>, <-0.70449, 0.37875, 0.600203>, <-0.252867, 5.33986, -1.00405> , <-0.707458, 0.364199, 0.605692> }
	smooth_triangle { <-0.252867, 5.31085, -0.982024>, <-0.70449, 0.37875, 0.600203>, <-0.2685, 5.3318, -1.01745>, <-0.707458, 0.364199, 0.605692>, <-0.2685, 5.30251, -0.995241> , <-0.70449, 0.37875, 0.600203> }
	smooth_triangle { <-0.2685, 5.35543, -1.02841>, <-0.706945, 0.232216, 0.66806>, <-0.252867, 5.33986, -1.00405>, <-0.707458, 0.364199, 0.605692>, <-0.252867, 5.36056, -1.01364> , <-0.706945, 0.232216, 0.66806> }
	smooth_triangle { <-0.252867, 5.33986, -1.00405>, <-0.707458, 0.364199, 0.605692>, <-0.2685, 5.35543, -1.02841>, <-0.706945, 0.232216, 0.66806>, <-0.2685, 5.3318, -1.01745> , <-0.707458, 0.364199, 0.605692> }
	smooth_triangle { <-0.2685, 5.37438, -1.03294>, <-0.706262, 0.147745, 0.692363>, <-0.252867, 5.36056, -1.01364>, <-0.706945, 0.232216, 0.66806>, <-0.252867, 5.37764, -1.01765> , <-0.706262, 0.147745, 0.692363> }
	smooth_triangle { <-0.252867, 5.36056, -1.01364>, <-0.706945, 0.232216, 0.66806>, <-0.2685, 5.37438, -1.03294>, <-0.706262, 0.147745, 0.692363>, <-0.2685, 5.35543, -1.02841> , <-0.706945, 0.232216, 0.66806> }
	smooth_triangle { <-0.2685, 5.39428, -1.03668>, <-0.707381, 0.0868935, 0.701471>, <-0.252867, 5.37764, -1.01765>, <-0.706262, 0.147745, 0.692363>, <-0.252867, 5.3962, -1.02116> , <-0.707381, 0.0868935, 0.701471> }
	smooth_triangle { <-0.252867, 5.37764, -1.01765>, <-0.706262, 0.147745, 0.692363>, <-0.2685, 5.39428, -1.03668>, <-0.707381, 0.0868935, 0.701471>, <-0.2685, 5.37438, -1.03294> , <-0.706262, 0.147745, 0.692363> }
	smooth_triangle { <-0.2685, 5.42103, -1.03831>, <-0.707183, -0.00657774, 0.706999>, <-0.252867, 5.3962, -1.02116>, <-0.707381, 0.0868935, 0.701471>, <-0.252867, 5.42088, -1.02267> , <-0.707183, -0.00657774, 0.706999> }
	smooth_triangle { <-0.252867, 5.3962, -1.02116>, <-0.707381, 0.0868935, 0.701471>, <-0.2685, 5.42103, -1.03831>, <-0.707183, -0.00657774, 0.706999>, <-0.2685, 5.39428, -1.03668> , <-0.707381, 0.0868935, 0.701471> }
	smooth_triangle { <-0.2685, 5.42103, -1.03831>, <-0.707183, -0.00657774, 0.706999>, <-0.252867, 5.45864, -1.01965>, <-0.706932, -0.0954997, 0.700805>, <-0.2685, 5.46075, -1.03514> , <-0.706932, -0.0954997, 0.700805> }
	smooth_triangle { <-0.252867, 5.45864, -1.01965>, <-0.706932, -0.0954997, 0.700805>, <-0.2685, 5.42103, -1.03831>, <-0.707183, -0.00657774, 0.706999>, <-0.252867, 5.42088, -1.02267> , <-0.707183, -0.00657774, 0.706999> }
	smooth_triangle { <-0.2685, 5.46075, -1.03514>, <-0.706932, -0.0954997, 0.700805>, <-0.252867, 5.49486, -1.01261>, <-0.706815, -0.134436, 0.694506>, <-0.2685, 5.49783, -1.02796> , <-0.706815, -0.134436, 0.694506> }
	smooth_triangle { <-0.252867, 5.49486, -1.01261>, <-0.706815, -0.134436, 0.694506>, <-0.2685, 5.46075, -1.03514>, <-0.706932, -0.0954997, 0.700805>, <-0.252867, 5.45864, -1.01965> , <-0.706932, -0.0954997, 0.700805> }
	smooth_triangle { <-0.2685, 5.49783, -1.02796>, <-0.706815, -0.134436, 0.694506>, <-0.252867, 5.53913, -1.00406>, <-0.707178, -0.156082, 0.689592>, <-0.2685, 5.54258, -1.0193> , <-0.707178, -0.156082, 0.689592> }
	smooth_triangle { <-0.252867, 5.53913, -1.00406>, <-0.707178, -0.156082, 0.689592>, <-0.2685, 5.49783, -1.02796>, <-0.706815, -0.134436, 0.694506>, <-0.252867, 5.49486, -1.01261> , <-0.706815, -0.134436, 0.694506> }
	smooth_triangle { <-0.2685, 5.54258, -1.0193>, <-0.707178, -0.156082, 0.689592>, <-0.252867, 5.57787, -0.993994>, <-0.707091, -0.154549, 0.690027>, <-0.2685, 5.58129, -1.00925> , <-0.707091, -0.154549, 0.690027> }
	smooth_triangle { <-0.252867, 5.57787, -0.993994>, <-0.707091, -0.154549, 0.690027>, <-0.2685, 5.54258, -1.0193>, <-0.707178, -0.156082, 0.689592>, <-0.252867, 5.53913, -1.00406> , <-0.707178, -0.156082, 0.689592> }
	smooth_triangle { <-0.2685, 5.58129, -1.00925>, <-0.707091, -0.154549, 0.690027>, <-0.252867, 5.6287, -0.984431>, <-0.707399, -0.0827523, 0.701953>, <-0.2685, 5.63053, -0.999956> , <-0.707399, -0.0827523, 0.701953> }
	smooth_triangle { <-0.252867, 5.6287, -0.984431>, <-0.707399, -0.0827523, 0.701953>, <-0.2685, 5.58129, -1.00925>, <-0.707091, -0.154549, 0.690027>, <-0.252867, 5.57787, -0.993994> , <-0.707091, -0.154549, 0.690027> }
	smooth_triangle { <-0.2685, 5.65963, -0.998551>, <-0.706978, 0.00855937, 0.707183>, <-0.252867, 5.6287, -0.984431>, <-0.707399, -0.0827523, 0.701953>, <-0.252867, 5.65981, -0.982921> , <-0.706978, 0.00855937, 0.707183> }
	smooth_triangle { <-0.252867, 5.6287, -0.984431>, <-0.707399, -0.0827523, 0.701953>, <-0.2685, 5.65963, -0.998551>, <-0.706978, 0.00855937, 0.707183>, <-0.2685, 5.63053, -0.999956> , <-0.707399, -0.0827523, 0.701953> }
	smooth_triangle { <-0.2685, 5.67579, -0.999724>, <-0.708289, 0.142822, 0.691323>, <-0.252867, 5.65981, -0.982921>, <-0.706978, 0.00855937, 0.707183>, <-0.252867, 5.67895, -0.984414> , <-0.708289, 0.142822, 0.691323> }
	smooth_triangle { <-0.252867, 5.65981, -0.982921>, <-0.706978, 0.00855937, 0.707183>, <-0.2685, 5.67579, -0.999724>, <-0.708289, 0.142822, 0.691323>, <-0.2685, 5.65963, -0.998551> , <-0.706978, 0.00855937, 0.707183> }
	smooth_triangle { <-0.2685, 5.69686, -1.00705>, <-0.706854, 0.310378, 0.635628>, <-0.252867, 5.67895, -0.984414>, <-0.708289, 0.142822, 0.691323>, <-0.252867, 5.70372, -0.993001> , <-0.706854, 0.310378, 0.635628> }
	smooth_triangle { <-0.252867, 5.67895, -0.984414>, <-0.708289, 0.142822, 0.691323>, <-0.2685, 5.69686, -1.00705>, <-0.706854, 0.310378, 0.635628>, <-0.2685, 5.67579, -0.999724> , <-0.708289, 0.142822, 0.691323> }
	smooth_triangle { <-0.2685, 5.71662, -1.01983>, <-0.706644, 0.439517, 0.554509>, <-0.252867, 5.70372, -0.993001>, <-0.706854, 0.310378, 0.635628>, <-0.252867, 5.72633, -1.00758> , <-0.706644, 0.439517, 0.554509> }
	smooth_triangle { <-0.252867, 5.70372, -0.993001>, <-0.706854, 0.310378, 0.635628>, <-0.2685, 5.71662, -1.01983>, <-0.706644, 0.439517, 0.554509>, <-0.2685, 5.69686, -1.00705> , <-0.706854, 0.310378, 0.635628> }
	smooth_triangle { <-0.2685, 5.7293, -1.03204>, <-0.707434, 0.545171, 0.449806>, <-0.252867, 5.72633, -1.00758>, <-0.706644, 0.439517, 0.554509>, <-0.252867, 5.74135, -1.02209> , <-0.707434, 0.545171, 0.449806> }
	smooth_triangle { <-0.252867, 5.72633, -1.00758>, <-0.706644, 0.439517, 0.554509>, <-0.2685, 5.7293, -1.03204>, <-0.707434, 0.545171, 0.449806>, <-0.2685, 5.71662, -1.01983> , <-0.706644, 0.439517, 0.554509> }
	smooth_triangle { <-0.2685, 5.73966, -1.04801>, <-0.708504, 0.648489, 0.278358>, <-0.252867, 5.74135, -1.02209>, <-0.707434, 0.545171, 0.449806>, <-0.252867, 5.75402, -1.04184> , <-0.708504, 0.648489, 0.278358> }
	smooth_triangle { <-0.252867, 5.74135, -1.02209>, <-0.707434, 0.545171, 0.449806>, <-0.2685, 5.73966, -1.04801>, <-0.708504, 0.648489, 0.278358>, <-0.2685, 5.7293, -1.03204> , <-0.707434, 0.545171, 0.449806> }
	smooth_triangle { <-0.2685, 5.74306, -1.06216>, <-0.705438, 0.702309, 0.0954999>, <-0.252867, 5.75402, -1.04184>, <-0.708504, 0.648489, 0.278358>, <-0.252867, 5.75855, -1.06006> , <-0.705438, 0.702309, 0.0954999> }
	smooth_triangle { <-0.252867, 5.75402, -1.04184>, <-0.708504, 0.648489, 0.278358>, <-0.2685, 5.74306, -1.06216>, <-0.705438, 0.702309, 0.0954999>, <-0.2685, 5.73966, -1.04801> , <-0.708504, 0.648489, 0.278358> }
	smooth_triangle { <-0.252867, 5.75855, -1.06006>, <1, 0, 0>, <-0.252867, 5.75533, -1.09919>, <1, 0, 0>, <-0.252867, 5.75908, -1.07516> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.75402, -1.04184>, <1, 0, 0>, <-0.252867, 5.75533, -1.09919>, <1, 0, 0>, <-0.252867, 5.75855, -1.06006> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.75402, -1.04184>, <1, 0, 0>, <-0.252867, 5.7467, -1.11528>, <1, 0, 0>, <-0.252867, 5.75533, -1.09919> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.74135, -1.02209>, <1, 0, 0>, <-0.252867, 5.7467, -1.11528>, <1, 0, 0>, <-0.252867, 5.75402, -1.04184> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.74135, -1.02209>, <1, 0, 0>, <-0.252867, 5.72807, -1.13799>, <1, 0, 0>, <-0.252867, 5.7467, -1.11528> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.72633, -1.00758>, <1, 0, 0>, <-0.252867, 5.72807, -1.13799>, <1, 0, 0>, <-0.252867, 5.74135, -1.02209> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.72633, -1.00758>, <1, 0, 0>, <-0.252867, 5.70412, -1.1537>, <1, 0, 0>, <-0.252867, 5.72807, -1.13799> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.70372, -0.993001>, <1, 0, 0>, <-0.252867, 5.70412, -1.1537>, <1, 0, 0>, <-0.252867, 5.72633, -1.00758> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.67895, -0.984414>, <1, 0, 0>, <-0.252867, 5.70412, -1.1537>, <1, 0, 0>, <-0.252867, 5.70372, -0.993001> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.67895, -0.984414>, <1, 0, 0>, <-0.252867, 5.67693, -1.16672>, <1, 0, 0>, <-0.252867, 5.70412, -1.1537> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.65981, -0.982921>, <1, 0, 0>, <-0.252867, 5.67693, -1.16672>, <1, 0, 0>, <-0.252867, 5.67895, -0.984414> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.65981, -0.982921>, <1, 0, 0>, <-0.252867, 5.65265, -1.17419>, <1, 0, 0>, <-0.252867, 5.67693, -1.16672> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.6287, -0.984431>, <1, 0, 0>, <-0.252867, 5.65265, -1.17419>, <1, 0, 0>, <-0.252867, 5.65981, -0.982921> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.6287, -0.984431>, <1, 0, 0>, <-0.252867, 5.62542, -1.17904>, <1, 0, 0>, <-0.252867, 5.65265, -1.17419> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.6287, -0.984431>, <1, 0, 0>, <-0.252867, 5.59704, -1.18166>, <1, 0, 0>, <-0.252867, 5.62542, -1.17904> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.57787, -0.993994>, <1, 0, 0>, <-0.252867, 5.59704, -1.18166>, <1, 0, 0>, <-0.252867, 5.6287, -0.984431> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.57787, -0.993994>, <1, 0, 0>, <-0.252867, 5.56903, -1.18053>, <1, 0, 0>, <-0.252867, 5.59704, -1.18166> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.57787, -0.993994>, <1, 0, 0>, <-0.252867, 5.54331, -1.17942>, <1, 0, 0>, <-0.252867, 5.56903, -1.18053> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.53913, -1.00406>, <1, 0, 0>, <-0.252867, 5.54331, -1.17942>, <1, 0, 0>, <-0.252867, 5.57787, -0.993994> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.53913, -1.00406>, <1, 0, 0>, <-0.252867, 5.52089, -1.17718>, <1, 0, 0>, <-0.252867, 5.54331, -1.17942> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.53913, -1.00406>, <1, 0, 0>, <-0.252867, 5.49735, -1.17157>, <1, 0, 0>, <-0.252867, 5.52089, -1.17718> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.49486, -1.01261>, <1, 0, 0>, <-0.252867, 5.49735, -1.17157>, <1, 0, 0>, <-0.252867, 5.53913, -1.00406> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.45864, -1.01965>, <1, 0, 0>, <-0.252867, 5.49735, -1.17157>, <1, 0, 0>, <-0.252867, 5.49486, -1.01261> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.45864, -1.01965>, <1, 0, 0>, <-0.252867, 5.43426, -1.15104>, <1, 0, 0>, <-0.252867, 5.49735, -1.17157> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.42088, -1.02267>, <1, 0, 0>, <-0.252867, 5.43426, -1.15104>, <1, 0, 0>, <-0.252867, 5.45864, -1.01965> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.3962, -1.02116>, <1, 0, 0>, <-0.252867, 5.43426, -1.15104>, <1, 0, 0>, <-0.252867, 5.42088, -1.02267> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.3962, -1.02116>, <1, 0, 0>, <-0.252867, 5.39395, -1.13312>, <1, 0, 0>, <-0.252867, 5.43426, -1.15104> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.37764, -1.01765>, <1, 0, 0>, <-0.252867, 5.39395, -1.13312>, <1, 0, 0>, <-0.252867, 5.3962, -1.02116> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.36056, -1.01364>, <1, 0, 0>, <-0.252867, 5.39395, -1.13312>, <1, 0, 0>, <-0.252867, 5.37764, -1.01765> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.36056, -1.01364>, <1, 0, 0>, <-0.252867, 5.34803, -1.1111>, <1, 0, 0>, <-0.252867, 5.39395, -1.13312> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.33986, -1.00405>, <1, 0, 0>, <-0.252867, 5.34803, -1.1111>, <1, 0, 0>, <-0.252867, 5.36056, -1.01364> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.31085, -0.982024>, <1, 0, 0>, <-0.252867, 5.34803, -1.1111>, <1, 0, 0>, <-0.252867, 5.33986, -1.00405> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.29556, -0.974361>, <1, 0, 0>, <-0.252867, 5.34803, -1.1111>, <1, 0, 0>, <-0.252867, 5.31085, -0.982024> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.29556, -0.974361>, <1, 0, 0>, <-0.252867, 5.28968, -1.07283>, <1, 0, 0>, <-0.252867, 5.34803, -1.1111> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.28194, -0.972858>, <1, 0, 0>, <-0.252867, 5.28968, -1.07283>, <1, 0, 0>, <-0.252867, 5.29556, -0.974361> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.28194, -0.972858>, <1, 0, 0>, <-0.252867, 5.25664, -1.04653>, <1, 0, 0>, <-0.252867, 5.28968, -1.07283> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.28194, -0.972858>, <1, 0, 0>, <-0.252867, 5.19822, -1.04936>, <1, 0, 0>, <-0.252867, 5.25664, -1.04653> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.28194, -0.972858>, <1, 0, 0>, <-0.252867, 5.1534, -1.0528>, <1, 0, 0>, <-0.252867, 5.19822, -1.04936> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.10246, -0.994415>, <1, 0, 0>, <-0.252867, 5.1534, -1.0528>, <1, 0, 0>, <-0.252867, 5.28194, -0.972858> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.10246, -0.994415>, <1, 0, 0>, <-0.252867, 5.09952, -1.05807>, <1, 0, 0>, <-0.252867, 5.1534, -1.0528> , <1, 0, 0> }
	smooth_triangle { <-0.252867, 5.10246, -0.994415>, <1, 0, 0>, <-0.252867, 5.09598, -1.07418>, <1, 0, 0>, <-0.252867, 5.09952, -1.05807> , <1, 0, 0> }
	smooth_triangle { <-0.251384, 5.09515, -0.983576>, <1, 0, 0>, <-0.252867, 5.09598, -1.07418>, <1, 0, 0>, <-0.252867, 5.10246, -0.994415> , <1, 0, 0> }
	smooth_triangle { <-0.251384, 5.09515, -0.983576>, <1, 0, 0>, <-0.252867, 5.08673, -1.08779>, <1, 0, 0>, <-0.252867, 5.09598, -1.07418> , <1, 0, 0> }
	smooth_triangle { <-0.253111, 5.08417, -0.976714>, <1, 0, 0>, <-0.252867, 5.08673, -1.08779>, <1, 0, 0>, <-0.251384, 5.09515, -0.983576> , <1, 0, 0> }
	smooth_triangle { <-0.251312, 5.06462, -0.972979>, <1, 0, 0>, <-0.252867, 5.08673, -1.08779>, <1, 0, 0>, <-0.253111, 5.08417, -0.976714> , <1, 0, 0> }
	smooth_triangle { <-0.251312, 5.06462, -0.972979>, <1, 0, 0>, <-0.252853, 5.04318, -1.09167>, <1, 0, 0>, <-0.252867, 5.08673, -1.08779> , <1, 0, 0> }
	smooth_triangle { <-0.252853, 5.04318, -1.09167>, <1, 0, 0>, <-0.251312, 5.06462, -0.972979>, <1, 0, 0>, <-0.253076, 5.0422, -0.977227> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.75487, -1.06241>, <1, 0, 0>, <0.243001, 5.75164, -1.10154>, <1, 0, 0>, <0.243001, 5.7554, -1.0775> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.75034, -1.04419>, <1, 0, 0>, <0.243001, 5.75164, -1.10154>, <1, 0, 0>, <0.243001, 5.75487, -1.06241> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.75034, -1.04419>, <1, 0, 0>, <0.243001, 5.74302, -1.11763>, <1, 0, 0>, <0.243001, 5.75164, -1.10154> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.73767, -1.02443>, <1, 0, 0>, <0.243001, 5.74302, -1.11763>, <1, 0, 0>, <0.243001, 5.75034, -1.04419> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.73767, -1.02443>, <1, 0, 0>, <0.243001, 5.72438, -1.14034>, <1, 0, 0>, <0.243001, 5.74302, -1.11763> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.72264, -1.00992>, <1, 0, 0>, <0.243001, 5.72438, -1.14034>, <1, 0, 0>, <0.243001, 5.73767, -1.02443> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.72264, -1.00992>, <1, 0, 0>, <0.243001, 5.70044, -1.15604>, <1, 0, 0>, <0.243001, 5.72438, -1.14034> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.70003, -0.995348>, <1, 0, 0>, <0.243001, 5.70044, -1.15604>, <1, 0, 0>, <0.243001, 5.72264, -1.00992> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.67526, -0.98676>, <1, 0, 0>, <0.243001, 5.70044, -1.15604>, <1, 0, 0>, <0.243001, 5.70003, -0.995348> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.67526, -0.98676>, <1, 0, 0>, <0.243001, 5.67325, -1.16907>, <1, 0, 0>, <0.243001, 5.70044, -1.15604> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.65613, -0.985267>, <1, 0, 0>, <0.243001, 5.67325, -1.16907>, <1, 0, 0>, <0.243001, 5.67526, -0.98676> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.65613, -0.985267>, <1, 0, 0>, <0.243001, 5.64897, -1.17654>, <1, 0, 0>, <0.243001, 5.67325, -1.16907> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.62502, -0.986778>, <1, 0, 0>, <0.243001, 5.64897, -1.17654>, <1, 0, 0>, <0.243001, 5.65613, -0.985267> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.62502, -0.986778>, <1, 0, 0>, <0.243001, 5.62174, -1.18139>, <1, 0, 0>, <0.243001, 5.64897, -1.17654> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.62502, -0.986778>, <1, 0, 0>, <0.243001, 5.59335, -1.184>, <1, 0, 0>, <0.243001, 5.62174, -1.18139> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.57419, -0.996341>, <1, 0, 0>, <0.243001, 5.59335, -1.184>, <1, 0, 0>, <0.243001, 5.62502, -0.986778> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.57419, -0.996341>, <1, 0, 0>, <0.243001, 5.56534, -1.18288>, <1, 0, 0>, <0.243001, 5.59335, -1.184> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.57419, -0.996341>, <1, 0, 0>, <0.243001, 5.53963, -1.18176>, <1, 0, 0>, <0.243001, 5.56534, -1.18288> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.53545, -1.0064>, <1, 0, 0>, <0.243001, 5.53963, -1.18176>, <1, 0, 0>, <0.243001, 5.57419, -0.996341> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.53545, -1.0064>, <1, 0, 0>, <0.243001, 5.51721, -1.17952>, <1, 0, 0>, <0.243001, 5.53963, -1.18176> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.53545, -1.0064>, <1, 0, 0>, <0.243001, 5.49367, -1.17392>, <1, 0, 0>, <0.243001, 5.51721, -1.17952> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.49118, -1.01496>, <1, 0, 0>, <0.243001, 5.49367, -1.17392>, <1, 0, 0>, <0.243001, 5.53545, -1.0064> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.45495, -1.022>, <1, 0, 0>, <0.243001, 5.49367, -1.17392>, <1, 0, 0>, <0.243001, 5.49118, -1.01496> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.45495, -1.022>, <1, 0, 0>, <0.243001, 5.43058, -1.15339>, <1, 0, 0>, <0.243001, 5.49367, -1.17392> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.4172, -1.02502>, <1, 0, 0>, <0.243001, 5.43058, -1.15339>, <1, 0, 0>, <0.243001, 5.45495, -1.022> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.39251, -1.02351>, <1, 0, 0>, <0.243001, 5.43058, -1.15339>, <1, 0, 0>, <0.243001, 5.4172, -1.02502> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.39251, -1.02351>, <1, 0, 0>, <0.243001, 5.39027, -1.13547>, <1, 0, 0>, <0.243001, 5.43058, -1.15339> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.37396, -1.02>, <1, 0, 0>, <0.243001, 5.39027, -1.13547>, <1, 0, 0>, <0.243001, 5.39251, -1.02351> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.35688, -1.01599>, <1, 0, 0>, <0.243001, 5.39027, -1.13547>, <1, 0, 0>, <0.243001, 5.37396, -1.02> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.35688, -1.01599>, <1, 0, 0>, <0.243001, 5.34435, -1.11344>, <1, 0, 0>, <0.243001, 5.39027, -1.13547> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.33618, -1.0064>, <1, 0, 0>, <0.243001, 5.34435, -1.11344>, <1, 0, 0>, <0.243001, 5.35688, -1.01599> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.30717, -0.984371>, <1, 0, 0>, <0.243001, 5.34435, -1.11344>, <1, 0, 0>, <0.243001, 5.33618, -1.0064> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.29188, -0.976708>, <1, 0, 0>, <0.243001, 5.34435, -1.11344>, <1, 0, 0>, <0.243001, 5.30717, -0.984371> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.29188, -0.976708>, <1, 0, 0>, <0.243001, 5.28599, -1.07517>, <1, 0, 0>, <0.243001, 5.34435, -1.11344> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.27826, -0.975204>, <1, 0, 0>, <0.243001, 5.28599, -1.07517>, <1, 0, 0>, <0.243001, 5.29188, -0.976708> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.27826, -0.975204>, <1, 0, 0>, <0.243001, 5.25296, -1.04888>, <1, 0, 0>, <0.243001, 5.28599, -1.07517> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.27826, -0.975204>, <1, 0, 0>, <0.243001, 5.19453, -1.05171>, <1, 0, 0>, <0.243001, 5.25296, -1.04888> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.27826, -0.975204>, <1, 0, 0>, <0.243001, 5.14972, -1.05515>, <1, 0, 0>, <0.243001, 5.19453, -1.05171> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.09878, -0.996762>, <1, 0, 0>, <0.243001, 5.14972, -1.05515>, <1, 0, 0>, <0.243001, 5.27826, -0.975204> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.09878, -0.996762>, <1, 0, 0>, <0.243001, 5.09584, -1.06042>, <1, 0, 0>, <0.243001, 5.14972, -1.05515> , <1, 0, 0> }
	smooth_triangle { <0.243001, 5.09878, -0.996762>, <1, 0, 0>, <0.243001, 5.0923, -1.07653>, <1, 0, 0>, <0.243001, 5.09584, -1.06042> , <1, 0, 0> }
	smooth_triangle { <0.241518, 5.09147, -0.985923>, <1, 0, 0>, <0.243001, 5.0923, -1.07653>, <1, 0, 0>, <0.243001, 5.09878, -0.996762> , <1, 0, 0> }
	smooth_triangle { <0.241518, 5.09147, -0.985923>, <1, 0, 0>, <0.243001, 5.08305, -1.09014>, <1, 0, 0>, <0.243001, 5.0923, -1.07653> , <1, 0, 0> }
	smooth_triangle { <0.243243, 5.08048, -0.979061>, <1, 0, 0>, <0.243001, 5.08305, -1.09014>, <1, 0, 0>, <0.241518, 5.09147, -0.985923> , <1, 0, 0> }
	smooth_triangle { <0.241445, 5.06094, -0.975325>, <1, 0, 0>, <0.243001, 5.08305, -1.09014>, <1, 0, 0>, <0.243243, 5.08048, -0.979061> , <1, 0, 0> }
	smooth_triangle { <0.241445, 5.06094, -0.975325>, <1, 0, 0>, <0.242986, 5.03949, -1.09402>, <1, 0, 0>, <0.243001, 5.08305, -1.09014> , <1, 0, 0> }
	smooth_triangle { <0.242986, 5.03949, -1.09402>, <1, 0, 0>, <0.241445, 5.06094, -0.975325>, <1, 0, 0>, <0.243209, 5.03852, -0.979574> , <1, 0, 0> }
	smooth_triangle { <0.258632, 5.73938, -1.06451>, <-0.705501, -0.702242, -0.0955235>, <0.243001, 5.75034, -1.04419>, <-0.708555, -0.648454, -0.278311>, <0.243001, 5.75487, -1.06241> , <-0.705501, -0.702242, -0.0955235> }
	smooth_triangle { <0.243001, 5.75034, -1.04419>, <-0.708555, -0.648454, -0.278311>, <0.258632, 5.73938, -1.06451>, <-0.705501, -0.702242, -0.0955235>, <0.258632, 5.73598, -1.05036> , <-0.708555, -0.648454, -0.278311> }
	smooth_triangle { <0.258632, 5.73598, -1.05036>, <-0.708555, -0.648454, -0.278311>, <0.243001, 5.73767, -1.02443>, <-0.707474, -0.545137, -0.449785>, <0.243001, 5.75034, -1.04419> , <-0.708555, -0.648454, -0.278311> }
	smooth_triangle { <0.243001, 5.73767, -1.02443>, <-0.707474, -0.545137, -0.449785>, <0.258632, 5.73598, -1.05036>, <-0.708555, -0.648454, -0.278311>, <0.258632, 5.72561, -1.03438> , <-0.707474, -0.545137, -0.449785> }
	smooth_triangle { <0.258632, 5.72561, -1.03438>, <-0.707474, -0.545137, -0.449785>, <0.243001, 5.72264, -1.00992>, <-0.706674, -0.43949, -0.554492>, <0.243001, 5.73767, -1.02443> , <-0.707474, -0.545137, -0.449785> }
	smooth_triangle { <0.243001, 5.72264, -1.00992>, <-0.706674, -0.43949, -0.554492>, <0.258632, 5.72561, -1.03438>, <-0.707474, -0.545137, -0.449785>, <0.258632, 5.71293, -1.02217> , <-0.706674, -0.43949, -0.554492> }
	smooth_triangle { <0.258632, 5.71293, -1.02217>, <-0.706674, -0.43949, -0.554492>, <0.243001, 5.70003, -0.995348>, <-0.706882, -0.310373, -0.635599>, <0.243001, 5.72264, -1.00992> , <-0.706674, -0.43949, -0.554492> }
	smooth_triangle { <0.243001, 5.70003, -0.995348>, <-0.706882, -0.310373, -0.635599>, <0.258632, 5.71293, -1.02217>, <-0.706674, -0.43949, -0.554492>, <0.258632, 5.69317, -1.00939> , <-0.706882, -0.310373, -0.635599> }
	smooth_triangle { <0.258632, 5.69317, -1.00939>, <-0.706882, -0.310373, -0.635599>, <0.243001, 5.67526, -0.98676>, <-0.708341, -0.142808, -0.691273>, <0.243001, 5.70003, -0.995348> , <-0.706882, -0.310373, -0.635599> }
	smooth_triangle { <0.243001, 5.67526, -0.98676>, <-0.708341, -0.142808, -0.691273>, <0.258632, 5.69317, -1.00939>, <-0.706882, -0.310373, -0.635599>, <0.258632, 5.67211, -1.00207> , <-0.708341, -0.142808, -0.691273> }
	smooth_triangle { <0.258632, 5.67211, -1.00207>, <-0.708341, -0.142808, -0.691273>, <0.243001, 5.65613, -0.985267>, <-0.707035, -0.00854691, -0.707127>, <0.243001, 5.67526, -0.98676> , <-0.708341, -0.142808, -0.691273> }
	smooth_triangle { <0.243001, 5.65613, -0.985267>, <-0.707035, -0.00854691, -0.707127>, <0.258632, 5.67211, -1.00207>, <-0.708341, -0.142808, -0.691273>, <0.258632, 5.65594, -1.0009> , <-0.707035, -0.00854691, -0.707127> }
	smooth_triangle { <0.243001, 5.62502, -0.986778>, <-0.707449, 0.0827448, -0.701904>, <0.258632, 5.65594, -1.0009>, <-0.707035, -0.00854691, -0.707127>, <0.258632, 5.62685, -1.0023> , <-0.707449, 0.0827448, -0.701904> }
	smooth_triangle { <0.258632, 5.65594, -1.0009>, <-0.707035, -0.00854691, -0.707127>, <0.243001, 5.62502, -0.986778>, <-0.707449, 0.0827448, -0.701904>, <0.243001, 5.65613, -0.985267> , <-0.707035, -0.00854691, -0.707127> }
	smooth_triangle { <0.258632, 5.57761, -1.01159>, <-0.707138, 0.154536, -0.689981>, <0.243001, 5.62502, -0.986778>, <-0.707449, 0.0827448, -0.701904>, <0.258632, 5.62685, -1.0023> , <-0.707449, 0.0827448, -0.701904> }
	smooth_triangle { <0.243001, 5.62502, -0.986778>, <-0.707449, 0.0827448, -0.701904>, <0.258632, 5.57761, -1.01159>, <-0.707138, 0.154536, -0.689981>, <0.243001, 5.57419, -0.996341> , <-0.707138, 0.154536, -0.689981> }
	smooth_triangle { <0.258632, 5.5389, -1.02165>, <-0.707214, 0.156073, -0.689557>, <0.243001, 5.57419, -0.996341>, <-0.707138, 0.154536, -0.689981>, <0.258632, 5.57761, -1.01159> , <-0.707138, 0.154536, -0.689981> }
	smooth_triangle { <0.243001, 5.57419, -0.996341>, <-0.707138, 0.154536, -0.689981>, <0.258632, 5.5389, -1.02165>, <-0.707214, 0.156073, -0.689557>, <0.243001, 5.53545, -1.0064> , <-0.707214, 0.156073, -0.689557> }
	smooth_triangle { <0.258632, 5.49414, -1.0303>, <-0.862731, 0.096098, -0.496447>, <0.243001, 5.53545, -1.0064>, <-0.707214, 0.156073, -0.689557>, <0.258632, 5.5389, -1.02165> , <-0.862932, 0.111551, -0.492854> }
	smooth_triangle { <0.243001, 5.53545, -1.0064>, <-0.707214, 0.156073, -0.689557>, <0.258632, 5.49414, -1.0303>, <-0.862731, 0.096098, -0.496447>, <0.243001, 5.49118, -1.01496> , <-0.706854, 0.134429, -0.694468> }
	smooth_triangle { <0.258632, 5.45706, -1.03749>, <-0.706979, 0.0954919, -0.700759>, <0.243001, 5.49118, -1.01496>, <-0.706854, 0.134429, -0.694468>, <0.258632, 5.49414, -1.0303> , <-0.706854, 0.134429, -0.694468> }
	smooth_triangle { <0.243001, 5.49118, -1.01496>, <-0.706854, 0.134429, -0.694468>, <0.258632, 5.45706, -1.03749>, <-0.706979, 0.0954919, -0.700759>, <0.243001, 5.45495, -1.022> , <-0.706979, 0.0954919, -0.700759> }
	smooth_triangle { <0.258632, 5.41734, -1.04065>, <-0.707227, 0.00657161, -0.706956>, <0.243001, 5.45495, -1.022>, <-0.706979, 0.0954919, -0.700759>, <0.258632, 5.45706, -1.03749> , <-0.706979, 0.0954919, -0.700759> }
	smooth_triangle { <0.243001, 5.45495, -1.022>, <-0.706979, 0.0954919, -0.700759>, <0.258632, 5.41734, -1.04065>, <-0.707227, 0.00657161, -0.706956>, <0.243001, 5.4172, -1.02502> , <-0.707227, 0.00657161, -0.706956> }
	smooth_triangle { <0.243001, 5.39251, -1.02351>, <-0.707422, -0.0868867, -0.70143>, <0.258632, 5.41734, -1.04065>, <-0.707227, 0.00657161, -0.706956>, <0.258632, 5.39059, -1.03902> , <-0.707422, -0.0868867, -0.70143> }
	smooth_triangle { <0.258632, 5.41734, -1.04065>, <-0.707227, 0.00657161, -0.706956>, <0.243001, 5.39251, -1.02351>, <-0.707422, -0.0868867, -0.70143>, <0.243001, 5.4172, -1.02502> , <-0.707227, 0.00657161, -0.706956> }
	smooth_triangle { <0.258632, 5.39059, -1.03902>, <-0.707422, -0.0868867, -0.70143>, <0.243001, 5.37396, -1.02>, <-0.706315, -0.147728, -0.692311>, <0.243001, 5.39251, -1.02351> , <-0.707422, -0.0868867, -0.70143> }
	smooth_triangle { <0.243001, 5.37396, -1.02>, <-0.706315, -0.147728, -0.692311>, <0.258632, 5.39059, -1.03902>, <-0.707422, -0.0868867, -0.70143>, <0.258632, 5.3707, -1.03529> , <-0.706315, -0.147728, -0.692311> }
	smooth_triangle { <0.258632, 5.3707, -1.03529>, <-0.706315, -0.147728, -0.692311>, <0.243001, 5.35688, -1.01599>, <-0.707009, -0.232189, -0.668002>, <0.243001, 5.37396, -1.02> , <-0.706315, -0.147728, -0.692311> }
	smooth_triangle { <0.243001, 5.35688, -1.01599>, <-0.707009, -0.232189, -0.668002>, <0.258632, 5.3707, -1.03529>, <-0.706315, -0.147728, -0.692311>, <0.258632, 5.35174, -1.03075> , <-0.707009, -0.232189, -0.668002> }
	smooth_triangle { <0.258632, 5.35174, -1.03075>, <-0.707009, -0.232189, -0.668002>, <0.243001, 5.33618, -1.0064>, <-0.707505, -0.364177, -0.60565>, <0.243001, 5.35688, -1.01599> , <-0.707009, -0.232189, -0.668002> }
	smooth_triangle { <0.243001, 5.33618, -1.0064>, <-0.707505, -0.364177, -0.60565>, <0.258632, 5.35174, -1.03075>, <-0.707009, -0.232189, -0.668002>, <0.258632, 5.32812, -1.0198> , <-0.707505, -0.364177, -0.60565> }
	smooth_triangle { <0.258632, 5.32812, -1.0198>, <-0.707505, -0.364177, -0.60565>, <0.243001, 5.30717, -0.984371>, <-0.704518, -0.378751, -0.600168>, <0.243001, 5.33618, -1.0064> , <-0.707505, -0.364177, -0.60565> }
	smooth_triangle { <0.243001, 5.30717, -0.984371>, <-0.704518, -0.378751, -0.600168>, <0.258632, 5.32812, -1.0198>, <-0.707505, -0.364177, -0.60565>, <0.258632, 5.29882, -0.997588> , <-0.704518, -0.378751, -0.600168> }
	smooth_triangle { <0.258632, 5.29882, -0.997588>, <-0.704518, -0.378751, -0.600168>, <0.243001, 5.29188, -0.976708>, <-0.709471, -0.199578, -0.675884>, <0.243001, 5.30717, -0.984371> , <-0.704518, -0.378751, -0.600168> }
	smooth_triangle { <0.243001, 5.29188, -0.976708>, <-0.709471, -0.199578, -0.675884>, <0.258632, 5.29882, -0.997588>, <-0.704518, -0.378751, -0.600168>, <0.258632, 5.28746, -0.991703> , <-0.709471, -0.199578, -0.675884> }
	smooth_triangle { <0.243001, 5.27826, -0.975204>, <-0.686048, 0.00748011, -0.727518>, <0.258632, 5.28746, -0.991703>, <-0.709471, -0.199578, -0.675884>, <0.258632, 5.27837, -0.990836> , <-0.686048, 0.00748011, -0.727518> }
	smooth_triangle { <0.258632, 5.28746, -0.991703>, <-0.709471, -0.199578, -0.675884>, <0.243001, 5.27826, -0.975204>, <-0.686048, 0.00748011, -0.727518>, <0.243001, 5.29188, -0.976708> , <-0.709471, -0.199578, -0.675884> }
	smooth_triangle { <0.258632, 5.27837, -0.990836>, <-0.686048, 0.00748011, -0.727518>, <0.243001, 5.09878, -0.996762>, <-0.709369, -0.25798, -0.655928>, <0.243001, 5.27826, -0.975204> , <-0.686048, 0.00748011, -0.727518> }
	smooth_triangle { <0.243001, 5.09878, -0.996762>, <-0.709369, -0.25798, -0.655928>, <0.258632, 5.27837, -0.990836>, <-0.686048, 0.00748011, -0.727518>, <0.258632, 5.09303, -1.0113> , <-0.709369, -0.25798, -0.655928> }
	smooth_triangle { <0.258632, 5.09303, -1.0113>, <-0.709369, -0.25798, -0.655928>, <0.241518, 5.09147, -0.985923>, <-0.675455, -0.505485, -0.536884>, <0.243001, 5.09878, -0.996762> , <-0.709369, -0.25798, -0.655928> }
	smooth_triangle { <0.241518, 5.09147, -0.985923>, <-0.675455, -0.505485, -0.536884>, <0.258632, 5.09303, -1.0113>, <-0.709369, -0.25798, -0.655928>, <0.258632, 5.08112, -0.9974> , <-0.675455, -0.505485, -0.536884> }
	smooth_triangle { <0.258632, 5.08112, -0.9974>, <-0.675455, -0.505485, -0.536884>, <0.243243, 5.08048, -0.979061>, <-0.685049, -0.282646, -0.671431>, <0.241518, 5.09147, -0.985923> , <-0.675455, -0.505485, -0.536884> }
	smooth_triangle { <0.243243, 5.08048, -0.979061>, <-0.685049, -0.282646, -0.671431>, <0.258632, 5.08112, -0.9974>, <-0.675455, -0.505485, -0.536884>, <0.258897, 5.07547, -0.993438> , <-0.685049, -0.282646, -0.671431> }
	smooth_triangle { <0.258719, 5.05957, -0.990811>, <-0.626541, -0.0604252, -0.777043>, <0.243243, 5.08048, -0.979061>, <-0.685049, -0.282646, -0.671431>, <0.258897, 5.07547, -0.993438> , <-0.685049, -0.282646, -0.671431> }
	smooth_triangle { <0.243243, 5.08048, -0.979061>, <-0.685049, -0.282646, -0.671431>, <0.258719, 5.05957, -0.990811>, <-0.626541, -0.0604252, -0.777043>, <0.241445, 5.06094, -0.975325> , <-0.626541, -0.0604252, -0.777043> }
	smooth_triangle { <0.243209, 5.03852, -0.979574>, <-0.580942, -0.00644664, -0.813919>, <0.258719, 5.05957, -0.990811>, <-0.626541, -0.0604252, -0.777043>, <0.25877, 5.04008, -0.990693> , <-0.580942, -0.00644664, -0.813919> }
	smooth_triangle { <0.258719, 5.05957, -0.990811>, <-0.626541, -0.0604252, -0.777043>, <0.243209, 5.03852, -0.979574>, <-0.580942, -0.00644664, -0.813919>, <0.241445, 5.06094, -0.975325> , <-0.626541, -0.0604252, -0.777043> }
	smooth_triangle { <0.258632, 5.04006, -1.08199>, <-0.0362533, 0.999343, -0.000185284>, <0.243209, 5.03852, -0.979574>, <-0.0362533, 0.999343, -0.000185284>, <0.25877, 5.04008, -0.990693> , <-0.0362533, 0.999343, -0.000185284> }
	smooth_triangle { <0.243209, 5.03852, -0.979574>, <-0.0362533, 0.999343, -0.000185284>, <0.258632, 5.04006, -1.08199>, <-0.0362533, 0.999343, -0.000185284>, <0.242986, 5.03949, -1.09402> , <-0.0362533, 0.999343, -0.000185284> }
	smooth_triangle { <0.243001, 5.08305, -1.09014>, <-0.723741, -0.379858, 0.576114>, <0.258632, 5.04006, -1.08199>, <-0.661919, -0.0999694, 0.742879>, <0.258632, 5.07394, -1.07744> , <-0.723741, -0.379858, 0.576114> }
	smooth_triangle { <0.258632, 5.04006, -1.08199>, <-0.661919, -0.0999694, 0.742879>, <0.243001, 5.08305, -1.09014>, <-0.723741, -0.379858, 0.576114>, <0.242986, 5.03949, -1.09402> , <-0.661919, -0.0999694, 0.742879> }
	smooth_triangle { <0.243001, 5.08305, -1.09014>, <-0.723741, -0.379858, 0.576114>, <0.258632, 5.07809, -1.07002>, <-0.680034, -0.667396, 0.303542>, <0.243001, 5.0923, -1.07653> , <-0.680034, -0.667396, 0.303542> }
	smooth_triangle { <0.258632, 5.07809, -1.07002>, <-0.680034, -0.667396, 0.303542>, <0.243001, 5.08305, -1.09014>, <-0.723741, -0.379858, 0.576114>, <0.258632, 5.07394, -1.07744> , <-0.723741, -0.379858, 0.576114> }
	smooth_triangle { <0.243001, 5.0923, -1.07653>, <-0.680034, -0.667396, 0.303542>, <0.258632, 5.086, -1.04827>, <-0.733803, -0.438523, 0.518874>, <0.243001, 5.09584, -1.06042> , <-0.733803, -0.438523, 0.518874> }
	smooth_triangle { <0.258632, 5.086, -1.04827>, <-0.733803, -0.438523, 0.518874>, <0.243001, 5.0923, -1.07653>, <-0.680034, -0.667396, 0.303542>, <0.258632, 5.07809, -1.07002> , <-0.680034, -0.667396, 0.303542> }
	smooth_triangle { <0.243001, 5.09584, -1.06042>, <-0.733803, -0.438523, 0.518874>, <0.258632, 5.14804, -1.0396>, <-0.707178, -0.0760206, 0.702936>, <0.243001, 5.14972, -1.05515> , <-0.707178, -0.0760206, 0.702936> }
	smooth_triangle { <0.258632, 5.14804, -1.0396>, <-0.707178, -0.0760206, 0.702936>, <0.243001, 5.09584, -1.06042>, <-0.733803, -0.438523, 0.518874>, <0.258632, 5.086, -1.04827> , <-0.733803, -0.438523, 0.518874> }
	smooth_triangle { <0.243001, 5.14972, -1.05515>, <-0.707178, -0.0760206, 0.702936>, <0.258632, 5.19368, -1.0361>, <-0.696562, -0.0390856, 0.716431>, <0.243001, 5.19453, -1.05171> , <-0.696562, -0.0390856, 0.716431> }
	smooth_triangle { <0.258632, 5.19368, -1.0361>, <-0.696562, -0.0390856, 0.716431>, <0.243001, 5.14972, -1.05515>, <-0.707178, -0.0760206, 0.702936>, <0.258632, 5.14804, -1.0396> , <-0.707178, -0.0760206, 0.702936> }
	smooth_triangle { <0.243001, 5.19453, -1.05171>, <-0.696562, -0.0390856, 0.716431>, <0.258632, 5.25771, -1.03399>, <-0.717481, 0.208495, 0.664644>, <0.243001, 5.25296, -1.04888> , <-0.717481, 0.208495, 0.664644> }
	smooth_triangle { <0.258632, 5.25771, -1.03399>, <-0.717481, 0.208495, 0.664644>, <0.243001, 5.19453, -1.05171>, <-0.696562, -0.0390856, 0.716431>, <0.258632, 5.19368, -1.0361> , <-0.696562, -0.0390856, 0.716431> }
	smooth_triangle { <0.243001, 5.28599, -1.07517>, <-0.706832, 0.408659, 0.577396>, <0.258632, 5.25771, -1.03399>, <-0.717481, 0.208495, 0.664644>, <0.258632, 5.29502, -1.06242> , <-0.706832, 0.408659, 0.577396> }
	smooth_triangle { <0.258632, 5.25771, -1.03399>, <-0.717481, 0.208495, 0.664644>, <0.243001, 5.28599, -1.07517>, <-0.706832, 0.408659, 0.577396>, <0.243001, 5.25296, -1.04888> , <-0.717481, 0.208495, 0.664644> }
	smooth_triangle { <0.243001, 5.34435, -1.11344>, <-0.707519, 0.347282, 0.615476>, <0.258632, 5.29502, -1.06242>, <-0.706832, 0.408659, 0.577396>, <0.258632, 5.35203, -1.09983> , <-0.707519, 0.347282, 0.615476> }
	smooth_triangle { <0.258632, 5.29502, -1.06242>, <-0.706832, 0.408659, 0.577396>, <0.243001, 5.34435, -1.11344>, <-0.707519, 0.347282, 0.615476>, <0.243001, 5.28599, -1.07517> , <-0.706832, 0.408659, 0.577396> }
	smooth_triangle { <0.243001, 5.39027, -1.13547>, <-0.706911, 0.296549, 0.642134>, <0.258632, 5.35203, -1.09983>, <-0.707519, 0.347282, 0.615476>, <0.258632, 5.39682, -1.12128> , <-0.706911, 0.296549, 0.642134> }
	smooth_triangle { <0.258632, 5.35203, -1.09983>, <-0.707519, 0.347282, 0.615476>, <0.243001, 5.39027, -1.13547>, <-0.706911, 0.296549, 0.642134>, <0.243001, 5.34435, -1.11344> , <-0.707519, 0.347282, 0.615476> }
	smooth_triangle { <0.243001, 5.43058, -1.15339>, <-0.707215, 0.253429, 0.660016>, <0.258632, 5.39682, -1.12128>, <-0.706911, 0.296549, 0.642134>, <0.258632, 5.43618, -1.13879> , <-0.707215, 0.253429, 0.660016> }
	smooth_triangle { <0.258632, 5.39682, -1.12128>, <-0.706911, 0.296549, 0.642134>, <0.243001, 5.43058, -1.15339>, <-0.707215, 0.253429, 0.660016>, <0.243001, 5.39027, -1.13547> , <-0.706911, 0.296549, 0.642134> }
	smooth_triangle { <0.243001, 5.49367, -1.17392>, <-0.706848, 0.191812, 0.680863>, <0.258632, 5.43618, -1.13879>, <-0.707215, 0.253429, 0.660016>, <0.258632, 5.4979, -1.15887> , <-0.706848, 0.191812, 0.680863> }
	smooth_triangle { <0.258632, 5.43618, -1.13879>, <-0.707215, 0.253429, 0.660016>, <0.243001, 5.49367, -1.17392>, <-0.706848, 0.191812, 0.680863>, <0.243001, 5.43058, -1.15339> , <-0.707215, 0.253429, 0.660016> }
	smooth_triangle { <0.243001, 5.51721, -1.17952>, <-0.70748, 0.117134, 0.696958>, <0.258632, 5.4979, -1.15887>, <-0.706848, 0.191812, 0.680863>, <0.258632, 5.5198, -1.16411> , <-0.70748, 0.117134, 0.696958> }
	smooth_triangle { <0.258632, 5.4979, -1.15887>, <-0.706848, 0.191812, 0.680863>, <0.243001, 5.51721, -1.17952>, <-0.70748, 0.117134, 0.696958>, <0.243001, 5.49367, -1.17392> , <-0.706848, 0.191812, 0.680863> }
	smooth_triangle { <0.243001, 5.53963, -1.18176>, <-0.7072, 0.0499654, 0.705246>, <0.258632, 5.5198, -1.16411>, <-0.70748, 0.117134, 0.696958>, <0.258632, 5.54073, -1.16617> , <-0.7072, 0.0499654, 0.705246> }
	smooth_triangle { <0.258632, 5.5198, -1.16411>, <-0.70748, 0.117134, 0.696958>, <0.243001, 5.53963, -1.18176>, <-0.7072, 0.0499654, 0.705246>, <0.243001, 5.51721, -1.17952> , <-0.70748, 0.117134, 0.696958> }
	smooth_triangle { <0.243001, 5.56534, -1.18288>, <-0.706739, 0.0298672, 0.706844>, <0.258632, 5.54073, -1.16617>, <-0.862919, 0.035713, 0.504078>, <0.258632, 5.566, -1.16726> , <-0.862674, 0.0213515, 0.505309> }
	smooth_triangle { <0.258632, 5.54073, -1.16617>, <-0.862919, 0.035713, 0.504078>, <0.243001, 5.56534, -1.18288>, <-0.706739, 0.0298672, 0.706844>, <0.243001, 5.53963, -1.18176> , <-0.7072, 0.0499654, 0.705246> }
	smooth_triangle { <0.243001, 5.59335, -1.184>, <-0.707377, -0.0181236, 0.706604>, <0.258632, 5.566, -1.16726>, <-0.706739, 0.0298672, 0.706844>, <0.258632, 5.59295, -1.16837> , <-0.707377, -0.0181236, 0.706604> }
	smooth_triangle { <0.258632, 5.566, -1.16726>, <-0.706739, 0.0298672, 0.706844>, <0.243001, 5.59335, -1.184>, <-0.707377, -0.0181236, 0.706604>, <0.243001, 5.56534, -1.18288> , <-0.706739, 0.0298672, 0.706844> }
	smooth_triangle { <0.243001, 5.59335, -1.184>, <-0.707377, -0.0181236, 0.706604>, <0.258632, 5.61965, -1.1659>, <-0.70696, -0.0945765, 0.700901>, <0.243001, 5.62174, -1.18139> , <-0.70696, -0.0945765, 0.700901> }
	smooth_triangle { <0.258632, 5.61965, -1.1659>, <-0.70696, -0.0945765, 0.700901>, <0.243001, 5.59335, -1.184>, <-0.707377, -0.0181236, 0.706604>, <0.258632, 5.59295, -1.16837> , <-0.707377, -0.0181236, 0.706604> }
	smooth_triangle { <0.243001, 5.62174, -1.18139>, <-0.70696, -0.0945765, 0.700901>, <0.258632, 5.6453, -1.16134>, <-0.706961, -0.165882, 0.687524>, <0.243001, 5.64897, -1.17654> , <-0.706961, -0.165882, 0.687524> }
	smooth_triangle { <0.258632, 5.6453, -1.16134>, <-0.706961, -0.165882, 0.687524>, <0.243001, 5.62174, -1.18139>, <-0.70696, -0.0945765, 0.700901>, <0.258632, 5.61965, -1.1659> , <-0.70696, -0.0945765, 0.700901> }
	smooth_triangle { <0.243001, 5.64897, -1.17654>, <-0.706961, -0.165882, 0.687524>, <0.258632, 5.66756, -1.15451>, <-0.70725, -0.257318, 0.658472>, <0.243001, 5.67325, -1.16907> , <-0.70725, -0.257318, 0.658472> }
	smooth_triangle { <0.258632, 5.66756, -1.15451>, <-0.70725, -0.257318, 0.658472>, <0.243001, 5.64897, -1.17654>, <-0.706961, -0.165882, 0.687524>, <0.258632, 5.6453, -1.16134> , <-0.706961, -0.165882, 0.687524> }
	smooth_triangle { <0.243001, 5.67325, -1.16907>, <-0.70725, -0.257318, 0.658472>, <0.258632, 5.69279, -1.14241>, <-0.705313, -0.346835, 0.618255>, <0.243001, 5.70044, -1.15604> , <-0.705313, -0.346835, 0.618255> }
	smooth_triangle { <0.258632, 5.69279, -1.14241>, <-0.705313, -0.346835, 0.618255>, <0.243001, 5.67325, -1.16907>, <-0.70725, -0.257318, 0.658472>, <0.258632, 5.66756, -1.15451> , <-0.70725, -0.257318, 0.658472> }
	smooth_triangle { <0.243001, 5.70044, -1.15604>, <-0.705313, -0.346835, 0.618255>, <0.258632, 5.71394, -1.1287>, <-0.708577, -0.471165, 0.525282>, <0.243001, 5.72438, -1.14034> , <-0.708577, -0.471165, 0.525282> }
	smooth_triangle { <0.258632, 5.71394, -1.1287>, <-0.708577, -0.471165, 0.525282>, <0.243001, 5.70044, -1.15604>, <-0.705313, -0.346835, 0.618255>, <0.258632, 5.69279, -1.14241> , <-0.705313, -0.346835, 0.618255> }
	smooth_triangle { <0.243001, 5.72438, -1.14034>, <-0.708577, -0.471165, 0.525282>, <0.258632, 5.73005, -1.1089>, <-0.70507, -0.588432, 0.395758>, <0.243001, 5.74302, -1.11763> , <-0.70507, -0.588432, 0.395758> }
	smooth_triangle { <0.258632, 5.73005, -1.1089>, <-0.70507, -0.588432, 0.395758>, <0.243001, 5.72438, -1.14034>, <-0.708577, -0.471165, 0.525282>, <0.258632, 5.71394, -1.1287> , <-0.708577, -0.471165, 0.525282> }
	smooth_triangle { <0.243001, 5.74302, -1.11763>, <-0.70507, -0.588432, 0.395758>, <0.258632, 5.73683, -1.09655>, <-0.709214, -0.66803, 0.225283>, <0.243001, 5.75164, -1.10154> , <-0.709214, -0.66803, 0.225283> }
	smooth_triangle { <0.258632, 5.73683, -1.09655>, <-0.709214, -0.66803, 0.225283>, <0.243001, 5.74302, -1.11763>, <-0.70507, -0.588432, 0.395758>, <0.258632, 5.73005, -1.1089> , <-0.70507, -0.588432, 0.395758> }
	smooth_triangle { <0.243001, 5.75164, -1.10154>, <-0.709214, -0.66803, 0.225283>, <0.258632, 5.73979, -1.07661>, <-0.70698, -0.706093, 0.0401421>, <0.243001, 5.7554, -1.0775> , <-0.70698, -0.706093, 0.0401421> }
	smooth_triangle { <0.258632, 5.73979, -1.07661>, <-0.70698, -0.706093, 0.0401421>, <0.243001, 5.75164, -1.10154>, <-0.709214, -0.66803, 0.225283>, <0.258632, 5.73683, -1.09655> , <-0.709214, -0.66803, 0.225283> }
	smooth_triangle { <0.243001, 5.75487, -1.06241>, <-0.705501, -0.702242, -0.0955235>, <0.258632, 5.73979, -1.07661>, <-0.70698, -0.706093, 0.0401421>, <0.258632, 5.73938, -1.06451> , <-0.705501, -0.702242, -0.0955235> }
	smooth_triangle { <0.258632, 5.73979, -1.07661>, <-0.70698, -0.706093, 0.0401421>, <0.243001, 5.75487, -1.06241>, <-0.705501, -0.702242, -0.0955235>, <0.243001, 5.7554, -1.0775> , <-0.70698, -0.706093, 0.0401421> }
	smooth_triangle { <0.258632, 5.73683, -1.09655>, <-1, 0, 0>, <0.258632, 5.73938, -1.06451>, <-1, 0, 0>, <0.258632, 5.73979, -1.07661> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.73683, -1.09655>, <-1, 0, 0>, <0.258632, 5.73598, -1.05036>, <-1, 0, 0>, <0.258632, 5.73938, -1.06451> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.73005, -1.1089>, <-1, 0, 0>, <0.258632, 5.73598, -1.05036>, <-1, 0, 0>, <0.258632, 5.73683, -1.09655> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.73005, -1.1089>, <-1, 0, 0>, <0.258632, 5.72561, -1.03438>, <-1, 0, 0>, <0.258632, 5.73598, -1.05036> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.71394, -1.1287>, <-1, 0, 0>, <0.258632, 5.72561, -1.03438>, <-1, 0, 0>, <0.258632, 5.73005, -1.1089> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.71394, -1.1287>, <-1, 0, 0>, <0.258632, 5.71293, -1.02217>, <-1, 0, 0>, <0.258632, 5.72561, -1.03438> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.71394, -1.1287>, <-1, 0, 0>, <0.258632, 5.69317, -1.00939>, <-1, 0, 0>, <0.258632, 5.71293, -1.02217> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.69279, -1.14241>, <-1, 0, 0>, <0.258632, 5.69317, -1.00939>, <-1, 0, 0>, <0.258632, 5.71394, -1.1287> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.69279, -1.14241>, <-1, 0, 0>, <0.258632, 5.67211, -1.00207>, <-1, 0, 0>, <0.258632, 5.69317, -1.00939> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.66756, -1.15451>, <-1, 0, 0>, <0.258632, 5.67211, -1.00207>, <-1, 0, 0>, <0.258632, 5.69279, -1.14241> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.66756, -1.15451>, <-1, 0, 0>, <0.258632, 5.65594, -1.0009>, <-1, 0, 0>, <0.258632, 5.67211, -1.00207> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.6453, -1.16134>, <-1, 0, 0>, <0.258632, 5.65594, -1.0009>, <-1, 0, 0>, <0.258632, 5.66756, -1.15451> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.6453, -1.16134>, <-1, 0, 0>, <0.258632, 5.62685, -1.0023>, <-1, 0, 0>, <0.258632, 5.65594, -1.0009> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.61965, -1.1659>, <-1, 0, 0>, <0.258632, 5.62685, -1.0023>, <-1, 0, 0>, <0.258632, 5.6453, -1.16134> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.59295, -1.16837>, <-1, 0, 0>, <0.258632, 5.62685, -1.0023>, <-1, 0, 0>, <0.258632, 5.61965, -1.1659> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.59295, -1.16837>, <-1, 0, 0>, <0.258632, 5.57761, -1.01159>, <-1, 0, 0>, <0.258632, 5.62685, -1.0023> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.566, -1.16726>, <-0.923887, 0.0165321, 0.382308>, <0.258632, 5.57761, -1.01159>, <-1, 0, 0>, <0.258632, 5.59295, -1.16837> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.54073, -1.16617>, <-0.923887, 0.0165321, 0.382308>, <0.258632, 5.57761, -1.01159>, <-1, 0, 0>, <0.258632, 5.566, -1.16726> , <-0.923887, 0.0165321, 0.382308> }
	smooth_triangle { <0.258632, 5.54073, -1.16617>, <-0.923887, 0.0165321, 0.382308>, <0.258632, 5.5389, -1.02165>, <-0.923885, 0.0726476, -0.375712>, <0.258632, 5.57761, -1.01159> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.5198, -1.16411>, <-1, 0, 0>, <0.258632, 5.5389, -1.02165>, <-0.923885, 0.0726476, -0.375712>, <0.258632, 5.54073, -1.16617> , <-0.923887, 0.0165321, 0.382308> }
	smooth_triangle { <0.258632, 5.4979, -1.15887>, <-1, 0, 0>, <0.258632, 5.5389, -1.02165>, <-0.923885, 0.0726476, -0.375712>, <0.258632, 5.5198, -1.16411> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.4979, -1.15887>, <-1, 0, 0>, <0.258632, 5.49414, -1.0303>, <-0.923885, 0.0726476, -0.375712>, <0.258632, 5.5389, -1.02165> , <-0.923885, 0.0726476, -0.375712> }
	smooth_triangle { <0.258632, 5.4979, -1.15887>, <-1, 0, 0>, <0.258632, 5.45706, -1.03749>, <-1, 0, 0>, <0.258632, 5.49414, -1.0303> , <-0.923885, 0.0726476, -0.375712> }
	smooth_triangle { <0.258632, 5.43618, -1.13879>, <-1, 0, 0>, <0.258632, 5.45706, -1.03749>, <-1, 0, 0>, <0.258632, 5.4979, -1.15887> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.43618, -1.13879>, <-1, 0, 0>, <0.258632, 5.41734, -1.04065>, <-1, 0, 0>, <0.258632, 5.45706, -1.03749> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.39682, -1.12128>, <-1, 0, 0>, <0.258632, 5.41734, -1.04065>, <-1, 0, 0>, <0.258632, 5.43618, -1.13879> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.39682, -1.12128>, <-1, 0, 0>, <0.258632, 5.39059, -1.03902>, <-1, 0, 0>, <0.258632, 5.41734, -1.04065> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.39682, -1.12128>, <-1, 0, 0>, <0.258632, 5.3707, -1.03529>, <-1, 0, 0>, <0.258632, 5.39059, -1.03902> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.35203, -1.09983>, <-1, 0, 0>, <0.258632, 5.3707, -1.03529>, <-1, 0, 0>, <0.258632, 5.39682, -1.12128> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.35203, -1.09983>, <-1, 0, 0>, <0.258632, 5.35174, -1.03075>, <-1, 0, 0>, <0.258632, 5.3707, -1.03529> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.35203, -1.09983>, <-1, 0, 0>, <0.258632, 5.32812, -1.0198>, <-1, 0, 0>, <0.258632, 5.35174, -1.03075> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.35203, -1.09983>, <-1, 0, 0>, <0.258632, 5.29882, -0.997588>, <-1, 0, 0>, <0.258632, 5.32812, -1.0198> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.29502, -1.06242>, <-1, 0, 0>, <0.258632, 5.29882, -0.997588>, <-1, 0, 0>, <0.258632, 5.35203, -1.09983> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.29502, -1.06242>, <-1, 0, 0>, <0.258632, 5.28746, -0.991703>, <-1, 0, 0>, <0.258632, 5.29882, -0.997588> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.29502, -1.06242>, <-1, 0, 0>, <0.258632, 5.27837, -0.990836>, <-1, 0, 0>, <0.258632, 5.28746, -0.991703> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.25771, -1.03399>, <-1, 0, 0>, <0.258632, 5.27837, -0.990836>, <-1, 0, 0>, <0.258632, 5.29502, -1.06242> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.19368, -1.0361>, <-1, 0, 0>, <0.258632, 5.27837, -0.990836>, <-1, 0, 0>, <0.258632, 5.25771, -1.03399> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.14804, -1.0396>, <-1, 0, 0>, <0.258632, 5.27837, -0.990836>, <-1, 0, 0>, <0.258632, 5.19368, -1.0361> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.14804, -1.0396>, <-1, 0, 0>, <0.258632, 5.09303, -1.0113>, <-1, 0, 0>, <0.258632, 5.27837, -0.990836> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.086, -1.04827>, <-1, 0, 0>, <0.258632, 5.09303, -1.0113>, <-1, 0, 0>, <0.258632, 5.14804, -1.0396> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.086, -1.04827>, <-1, 0, 0>, <0.258632, 5.08112, -0.9974>, <-1, 0, 0>, <0.258632, 5.09303, -1.0113> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.07809, -1.07002>, <-1, 0, 0>, <0.258632, 5.08112, -0.9974>, <-1, 0, 0>, <0.258632, 5.086, -1.04827> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.07809, -1.07002>, <-1, 0, 0>, <0.258897, 5.07547, -0.993438>, <-1, 0, 0>, <0.258632, 5.08112, -0.9974> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.07394, -1.07744>, <-1, 0, 0>, <0.258897, 5.07547, -0.993438>, <-1, 0, 0>, <0.258632, 5.07809, -1.07002> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.07394, -1.07744>, <-1, 0, 0>, <0.258719, 5.05957, -0.990811>, <-1, 0, 0>, <0.258897, 5.07547, -0.993438> , <-1, 0, 0> }
	smooth_triangle { <0.258632, 5.07394, -1.07744>, <-1, 0, 0>, <0.25877, 5.04008, -0.990693>, <-1, 0, 0>, <0.258719, 5.05957, -0.990811> , <-1, 0, 0> }
	smooth_triangle { <0.25877, 5.04008, -0.990693>, <-1, 0, 0>, <0.258632, 5.07394, -1.07744>, <-1, 0, 0>, <0.258632, 5.04006, -1.08199> , <-1, 0, 0> }
texture { WhitePlastic }
}

// object ellipse
union {
	smooth_triangle { <-0.0574141, 5.62566, -0.332883>, <0.000852039, -0.98476, 0.173919>, <0.050172, 5.62628, -0.329341>, <0.000852039, -0.98476, 0.173919>, <-0.0043413, 5.6281, -0.319019> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.116968, 5.61903, -0.370455>, <0.000852039, -0.98476, 0.173919>, <0.050172, 5.62628, -0.329341>, <0.000852039, -0.98476, 0.173919>, <-0.0574141, 5.62566, -0.332883> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.116968, 5.61903, -0.370455>, <0.000852039, -0.98476, 0.173919>, <0.109256, 5.61869, -0.372373>, <0.000852039, -0.98476, 0.173919>, <0.050172, 5.62628, -0.329341> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.14509, 5.60844, -0.430507>, <0.000852039, -0.98476, 0.173919>, <0.109256, 5.61869, -0.372373>, <0.000852039, -0.98476, 0.173919>, <-0.116968, 5.61903, -0.370455> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.14509, 5.60844, -0.430507>, <0.000852039, -0.98476, 0.173919>, <0.14029, 5.60828, -0.43147>, <0.000852039, -0.98476, 0.173919>, <0.109256, 5.61869, -0.372373> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.14509, 5.60844, -0.430507>, <0.000852039, -0.98476, 0.173919>, <0.152789, 5.59598, -0.501176>, <0.000852039, -0.98476, 0.173919>, <0.14029, 5.60828, -0.43147> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.155647, 5.59565, -0.503076>, <0.000852039, -0.98476, 0.173919>, <0.152789, 5.59598, -0.501176>, <0.000852039, -0.98476, 0.173919>, <-0.14509, 5.60844, -0.430507> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.138233, 5.58344, -0.572306>, <0.000852039, -0.98476, 0.173919>, <0.152789, 5.59598, -0.501176>, <0.000852039, -0.98476, 0.173919>, <-0.155647, 5.59565, -0.503076> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.138233, 5.58344, -0.572306>, <0.000852039, -0.98476, 0.173919>, <0.13171, 5.58294, -0.575136>, <0.000852039, -0.98476, 0.173919>, <0.152789, 5.59598, -0.501176> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.106008, 5.57302, -0.631386>, <0.000852039, -0.98476, 0.173919>, <0.13171, 5.58294, -0.575136>, <0.000852039, -0.98476, 0.173919>, <-0.138233, 5.58344, -0.572306> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.106008, 5.57302, -0.631386>, <0.000852039, -0.98476, 0.173919>, <0.0994864, 5.57265, -0.633516>, <0.000852039, -0.98476, 0.173919>, <0.13171, 5.58294, -0.575136> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.0588551, 5.56519, -0.675846>, <0.000852039, -0.98476, 0.173919>, <0.0994864, 5.57265, -0.633516>, <0.000852039, -0.98476, 0.173919>, <-0.106008, 5.57302, -0.631386> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <-0.0588551, 5.56519, -0.675846>, <0.000852039, -0.98476, 0.173919>, <0.0559336, 5.56481, -0.677976>, <0.000852039, -0.98476, 0.173919>, <0.0994864, 5.57265, -0.633516> , <0.000852039, -0.98476, 0.173919> }
	smooth_triangle { <0.0559336, 5.56481, -0.677976>, <0.000852039, -0.98476, 0.173919>, <-0.0588551, 5.56519, -0.675846>, <0.000852039, -0.98476, 0.173919>, <-0.0036211, 5.56274, -0.689706> , <0.000852039, -0.98476, 0.173919> }
texture { BluePlastic }
}

// object BlueLiquid
union {
	smooth_triangle { <-0.00218966, 5.53002, -0.326353>, <0.111609, -0.320558, 0.940631>, <0.037444, 5.52143, -0.334036>, <0.190528, -0.374294, 0.907526>, <0.0388533, 5.53149, -0.330373> , <0.200109, -0.3254, 0.92416> }
	smooth_triangle { <0.037444, 5.52143, -0.334036>, <0.190528, -0.374294, 0.907526>, <-0.00218966, 5.53002, -0.326353>, <0.111609, -0.320558, 0.940631>, <-0.00220107, 5.52994, -0.326376> , <0.102123, -0.347586, 0.93207> }
	smooth_triangle { <0.0388533, 5.53149, -0.330373>, <0.200109, -0.3254, 0.92416>, <0.0670031, 5.51712, -0.345361>, <0.401568, -0.412244, 0.8178>, <0.0694549, 5.53462, -0.33899> , <0.415764, -0.311017, 0.854639> }
	smooth_triangle { <0.0670031, 5.51712, -0.345361>, <0.401568, -0.412244, 0.8178>, <0.0388533, 5.53149, -0.330373>, <0.200109, -0.3254, 0.92416>, <0.037444, 5.52143, -0.334036> , <0.190528, -0.374294, 0.907526> }
	smooth_triangle { <0.0694549, 5.53462, -0.33899>, <0.415764, -0.311017, 0.854639>, <0.0913626, 5.51648, -0.362671>, <0.604338, -0.418986, 0.677662>, <0.0946737, 5.54011, -0.354071> , <0.625675, -0.266747, 0.73306> }
	smooth_triangle { <0.0913626, 5.51648, -0.362671>, <0.604338, -0.418986, 0.677662>, <0.0694549, 5.53462, -0.33899>, <0.415764, -0.311017, 0.854639>, <0.0670031, 5.51712, -0.345361> , <0.401568, -0.412244, 0.8178> }
	smooth_triangle { <0.0946737, 5.54011, -0.354071>, <0.625675, -0.266747, 0.73306>, <0.111293, 5.51851, -0.383892>, <0.764929, -0.401458, 0.503701>, <0.115308, 5.54717, -0.373465> , <0.791928, -0.208812, 0.5738> }
	smooth_triangle { <0.111293, 5.51851, -0.383892>, <0.764929, -0.401458, 0.503701>, <0.0946737, 5.54011, -0.354071>, <0.625675, -0.266747, 0.73306>, <0.0913626, 5.51648, -0.362671> , <0.604338, -0.418986, 0.677662> }
	smooth_triangle { <0.115308, 5.54717, -0.373465>, <0.791928, -0.208812, 0.5738>, <0.126794, 5.52402, -0.411164>, <0.864893, -0.370062, 0.339139>, <0.131356, 5.55658, -0.399313> , <0.895392, -0.1523, 0.418422> }
	smooth_triangle { <0.126794, 5.52402, -0.411164>, <0.864893, -0.370062, 0.339139>, <0.115308, 5.54717, -0.373465>, <0.791928, -0.208812, 0.5738>, <0.111293, 5.51851, -0.383892> , <0.764929, -0.401458, 0.503701> }
	smooth_triangle { <0.131356, 5.55658, -0.399313>, <0.895392, -0.1523, 0.418422>, <0.137868, 5.53064, -0.438031>, <0.927011, -0.329527, 0.179058>, <0.14282, 5.56599, -0.425167> , <0.959726, -0.0974791, 0.263485> }
	smooth_triangle { <0.137868, 5.53064, -0.438031>, <0.927011, -0.329527, 0.179058>, <0.131356, 5.55658, -0.399313>, <0.895392, -0.1523, 0.418422>, <0.126794, 5.52402, -0.411164> , <0.864893, -0.370062, 0.339139> }
	smooth_triangle { <0.14282, 5.56599, -0.425167>, <0.959726, -0.0974791, 0.263485>, <0.14451, 5.5423, -0.475264>, <0.954548, -0.29269, 0.0562985>, <0.149697, 5.57932, -0.46179> , <0.987792, -0.0517587, 0.146927> }
	smooth_triangle { <0.14451, 5.5423, -0.475264>, <0.954548, -0.29269, 0.0562985>, <0.14282, 5.56599, -0.425167>, <0.959726, -0.0974791, 0.263485>, <0.137868, 5.53064, -0.438031> , <0.927011, -0.329527, 0.179058> }
	smooth_triangle { <0.149697, 5.57932, -0.46179>, <0.987792, -0.0517587, 0.146927>, <0.148939, 5.55295, -0.507987>, <0.966454, -0.244887, -0.0774423>, <0.154283, 5.59838, -0.495393> , <0.997793, -0.053432, 0.0394129> }
	smooth_triangle { <0.148939, 5.55295, -0.507987>, <0.966454, -0.244887, -0.0774423>, <0.149697, 5.57932, -0.46179>, <0.987792, -0.0517587, 0.146927>, <0.14451, 5.5423, -0.475264> , <0.954548, -0.29269, 0.0562985> }
	smooth_triangle { <0.154283, 5.59838, -0.495393>, <0.997793, -0.053432, 0.0394129>, <0.14451, 5.56817, -0.546359>, <0.9485, -0.166029, -0.269781>, <0.149697, 5.59206, -0.530569> , <0.974417, -0.0444435, -0.220309> }
	smooth_triangle { <0.14451, 5.56817, -0.546359>, <0.9485, -0.166029, -0.269781>, <0.154283, 5.59838, -0.495393>, <0.997793, -0.053432, 0.0394129>, <0.148939, 5.55295, -0.507987> , <0.966454, -0.244887, -0.0774423> }
	smooth_triangle { <0.149697, 5.59206, -0.530569>, <0.974417, -0.0444435, -0.220309>, <0.137868, 5.58499, -0.568581>, <0.906115, -0.146934, -0.396695>, <0.14282, 5.58895, -0.550182> , <0.955416, -0.0124648, -0.295> }
	smooth_triangle { <0.137868, 5.58499, -0.568581>, <0.906115, -0.146934, -0.396695>, <0.149697, 5.59206, -0.530569>, <0.974417, -0.0444435, -0.220309>, <0.14451, 5.56817, -0.546359> , <0.9485, -0.166029, -0.269781> }
	smooth_triangle { <-0.00220107, 5.52994, -0.326376>, <0.102123, -0.347586, 0.93207>, <0.0333119, 5.51205, -0.337451>, <0.162971, -0.436395, 0.884873>, <0.037444, 5.52143, -0.334036> , <0.190528, -0.374294, 0.907526> }
	smooth_triangle { <0.0333119, 5.51205, -0.337451>, <0.162971, -0.436395, 0.884873>, <-0.00220107, 5.52994, -0.326376>, <0.102123, -0.347586, 0.93207>, <-0.00223305, 5.52987, -0.326404> , <0.0758638, -0.406341, 0.910567> }
	smooth_triangle { <0.037444, 5.52143, -0.334036>, <0.190528, -0.374294, 0.907526>, <0.0598137, 5.50081, -0.351295>, <0.360097, -0.506427, 0.783494>, <0.0670031, 5.51712, -0.345361> , <0.401568, -0.412244, 0.8178> }
	smooth_triangle { <0.0598137, 5.50081, -0.351295>, <0.360097, -0.506427, 0.783494>, <0.037444, 5.52143, -0.334036>, <0.190528, -0.374294, 0.907526>, <0.0333119, 5.51205, -0.337451> , <0.162971, -0.436395, 0.884873> }
	smooth_triangle { <0.0670031, 5.51712, -0.345361>, <0.401568, -0.412244, 0.8178>, <0.0816538, 5.49445, -0.370694>, <0.541798, -0.560814, 0.626053>, <0.0913626, 5.51648, -0.362671> , <0.604338, -0.418986, 0.677662> }
	smooth_triangle { <0.0816538, 5.49445, -0.370694>, <0.541798, -0.560814, 0.626053>, <0.0670031, 5.51712, -0.345361>, <0.401568, -0.412244, 0.8178>, <0.0598137, 5.50081, -0.351295> , <0.360097, -0.506427, 0.783494> }
	smooth_triangle { <0.0816538, 5.49445, -0.370694>, <0.541798, -0.560814, 0.626053>, <0.111293, 5.51851, -0.383892>, <0.764929, -0.401458, 0.503701>, <0.0913626, 5.51648, -0.362671> , <0.604338, -0.418986, 0.677662> }
	smooth_triangle { <0.111293, 5.51851, -0.383892>, <0.764929, -0.401458, 0.503701>, <0.0816538, 5.49445, -0.370694>, <0.541798, -0.560814, 0.626053>, <0.0995233, 5.49181, -0.393611> , <0.685797, -0.58095, 0.438383> }
	smooth_triangle { <0.111293, 5.51851, -0.383892>, <0.764929, -0.401458, 0.503701>, <0.11342, 5.49368, -0.422207>, <0.775441, -0.572994, 0.265272>, <0.126794, 5.52402, -0.411164> , <0.864893, -0.370061, 0.339139> }
	smooth_triangle { <0.11342, 5.49368, -0.422207>, <0.775441, -0.572994, 0.265272>, <0.111293, 5.51851, -0.383892>, <0.764929, -0.401458, 0.503701>, <0.0995233, 5.49181, -0.393611> , <0.685797, -0.58095, 0.438383> }
	smooth_triangle { <0.126794, 5.52402, -0.411164>, <0.864893, -0.370061, 0.339139>, <0.123348, 5.49771, -0.45002>, <0.831138, -0.547019, 0.0998981>, <0.137868, 5.53064, -0.438031> , <0.927011, -0.329527, 0.179058> }
	smooth_triangle { <0.123348, 5.49771, -0.45002>, <0.831138, -0.547019, 0.0998981>, <0.126794, 5.52402, -0.411164>, <0.864893, -0.370061, 0.339139>, <0.11342, 5.49368, -0.422207> , <0.775441, -0.572994, 0.265272> }
	smooth_triangle { <0.137868, 5.53064, -0.438031>, <0.927011, -0.329527, 0.179058>, <0.129305, 5.5078, -0.487819>, <0.855826, -0.516649, -0.0252027>, <0.14451, 5.5423, -0.475264> , <0.954548, -0.29269, 0.0562985> }
	smooth_triangle { <0.129305, 5.5078, -0.487819>, <0.855826, -0.516649, -0.0252027>, <0.137868, 5.53064, -0.438031>, <0.927011, -0.329527, 0.179058>, <0.123348, 5.49771, -0.45002> , <0.831138, -0.547019, 0.0998981> }
	smooth_triangle { <0.14451, 5.5423, -0.475264>, <0.954548, -0.29269, 0.0562985>, <0.133277, 5.51741, -0.52092>, <0.86598, -0.473552, -0.16071>, <0.148939, 5.55295, -0.507987> , <0.966454, -0.244887, -0.0774423> }
	smooth_triangle { <0.133277, 5.51741, -0.52092>, <0.86598, -0.473552, -0.16071>, <0.14451, 5.5423, -0.475264>, <0.954548, -0.29269, 0.0562985>, <0.129305, 5.5078, -0.487819> , <0.855826, -0.516649, -0.0252027> }
	smooth_triangle { <0.148939, 5.55295, -0.507987>, <0.966454, -0.244887, -0.0774423>, <0.129305, 5.53368, -0.558914>, <0.848579, -0.392053, -0.355258>, <0.14451, 5.56817, -0.546359> , <0.9485, -0.166029, -0.269781> }
	smooth_triangle { <0.129305, 5.53368, -0.558914>, <0.848579, -0.392053, -0.355258>, <0.148939, 5.55295, -0.507987>, <0.966454, -0.244887, -0.0774423>, <0.133277, 5.51741, -0.52092> , <0.86598, -0.473552, -0.16071> }
	smooth_triangle { <0.14451, 5.56817, -0.546359>, <0.9485, -0.166029, -0.269781>, <0.123348, 5.54475, -0.579282>, <0.816953, -0.323312, -0.477552>, <0.137868, 5.58499, -0.568581> , <0.906115, -0.146934, -0.396695> }
	smooth_triangle { <0.123348, 5.54475, -0.579282>, <0.816953, -0.323312, -0.477552>, <0.14451, 5.56817, -0.546359>, <0.9485, -0.166029, -0.269781>, <0.129305, 5.53368, -0.558914> , <0.848579, -0.392053, -0.355258> }
	smooth_triangle { <0.137868, 5.58499, -0.568581>, <0.906115, -0.146934, -0.396695>, <0.111436, 5.57758, -0.61182>, <0.790672, -0.297538, -0.535079>, <0.12458, 5.58185, -0.596461> , <0.852937, -0.177207, -0.491015> }
	smooth_triangle { <0.111436, 5.57758, -0.61182>, <0.790672, -0.297538, -0.535079>, <0.137868, 5.58499, -0.568581>, <0.906115, -0.146934, -0.396695>, <0.123348, 5.54475, -0.579282> , <0.816953, -0.323312, -0.477552> }
	smooth_triangle { <-0.00223305, 5.52987, -0.326404>, <0.0758638, -0.406341, 0.910567>, <0.0267384, 5.504, -0.340376>, <0.13505, -0.46933, 0.872635>, <0.0333119, 5.51205, -0.337451> , <0.162971, -0.436395, 0.884873> }
	smooth_triangle { <0.0267384, 5.504, -0.340376>, <0.13505, -0.46933, 0.872635>, <-0.00223305, 5.52987, -0.326404>, <0.0758638, -0.406341, 0.910567>, <-0.00228387, 5.52981, -0.326429> , <0.0657427, -0.416282, 0.906856> }
	smooth_triangle { <0.0333119, 5.51205, -0.337451>, <0.162971, -0.436395, 0.884873>, <0.0483768, 5.4868, -0.356399>, <0.294096, -0.587304, 0.754044>, <0.0598137, 5.50081, -0.351295> , <0.360097, -0.506427, 0.783494> }
	smooth_triangle { <0.0483768, 5.4868, -0.356399>, <0.294096, -0.587304, 0.754044>, <0.0333119, 5.51205, -0.337451>, <0.162971, -0.436395, 0.884873>, <0.0267384, 5.504, -0.340376> , <0.13505, -0.46933, 0.872635> }
	smooth_triangle { <0.0598137, 5.50081, -0.351295>, <0.360097, -0.506427, 0.783494>, <0.06621, 5.47553, -0.377578>, <0.442375, -0.682541, 0.581758>, <0.0816538, 5.49445, -0.370694> , <0.541798, -0.560814, 0.626053> }
	smooth_triangle { <0.06621, 5.47553, -0.377578>, <0.442375, -0.682541, 0.581758>, <0.0598137, 5.50081, -0.351295>, <0.360097, -0.506427, 0.783494>, <0.0483768, 5.4868, -0.356399> , <0.294096, -0.587304, 0.754044> }
	smooth_triangle { <0.06621, 5.47553, -0.377578>, <0.442375, -0.682541, 0.581758>, <0.0995233, 5.49181, -0.393611>, <0.685797, -0.58095, 0.438383>, <0.0816538, 5.49445, -0.370694> , <0.541798, -0.560814, 0.626053> }
	smooth_triangle { <0.0995233, 5.49181, -0.393611>, <0.685797, -0.58095, 0.438383>, <0.06621, 5.47553, -0.377578>, <0.442375, -0.682541, 0.581758>, <0.0808001, 5.46888, -0.401955> , <0.559962, -0.735044, 0.382299> }
	smooth_triangle { <0.0808001, 5.46888, -0.401955>, <0.559962, -0.735044, 0.382299>, <0.11342, 5.49368, -0.422207>, <0.775441, -0.572994, 0.265272>, <0.0995233, 5.49181, -0.393611> , <0.685797, -0.58095, 0.438383> }
	smooth_triangle { <0.11342, 5.49368, -0.422207>, <0.775441, -0.572994, 0.265272>, <0.0808001, 5.46888, -0.401955>, <0.559962, -0.735044, 0.382299>, <0.0921478, 5.46763, -0.431689> , <0.63314, -0.747252, 0.201859> }
	smooth_triangle { <0.11342, 5.49368, -0.422207>, <0.775441, -0.572994, 0.265272>, <0.100253, 5.46942, -0.460314>, <0.678631, -0.733786, 0.0319119>, <0.123348, 5.49771, -0.45002> , <0.831138, -0.547019, 0.0998981> }
	smooth_triangle { <0.100253, 5.46942, -0.460314>, <0.678631, -0.733786, 0.0319119>, <0.11342, 5.49368, -0.422207>, <0.775441, -0.572994, 0.265272>, <0.0921478, 5.46763, -0.431689> , <0.63314, -0.747252, 0.201859> }
	smooth_triangle { <0.123348, 5.49771, -0.45002>, <0.831138, -0.547019, 0.0998981>, <0.105117, 5.47818, -0.498601>, <0.69878, -0.708973, -0.095208>, <0.129305, 5.5078, -0.487819> , <0.855826, -0.516649, -0.0252027> }
	smooth_triangle { <0.105117, 5.47818, -0.498601>, <0.69878, -0.708973, -0.095208>, <0.123348, 5.49771, -0.45002>, <0.831138, -0.547019, 0.0998981>, <0.100253, 5.46942, -0.460314> , <0.678631, -0.733786, 0.0319119> }
	smooth_triangle { <0.129305, 5.5078, -0.487819>, <0.855826, -0.516649, -0.0252027>, <0.108359, 5.4869, -0.532027>, <0.707062, -0.668169, -0.231545>, <0.133277, 5.51741, -0.52092> , <0.86598, -0.473552, -0.16071> }
	smooth_triangle { <0.108359, 5.4869, -0.532027>, <0.707062, -0.668169, -0.231545>, <0.129305, 5.5078, -0.487819>, <0.855826, -0.516649, -0.0252027>, <0.105117, 5.47818, -0.498601> , <0.69878, -0.708973, -0.095208> }
	smooth_triangle { <0.133277, 5.51741, -0.52092>, <0.86598, -0.473552, -0.16071>, <0.105117, 5.50406, -0.569696>, <0.692857, -0.582766, -0.424657>, <0.129305, 5.53368, -0.558914> , <0.848579, -0.392053, -0.355258> }
	smooth_triangle { <0.105117, 5.50406, -0.569696>, <0.692857, -0.582766, -0.424657>, <0.133277, 5.51741, -0.52092>, <0.86598, -0.473552, -0.16071>, <0.108359, 5.4869, -0.532027> , <0.707062, -0.668169, -0.231545> }
	smooth_triangle { <0.129305, 5.53368, -0.558914>, <0.848579, -0.392053, -0.355258>, <0.100253, 5.51647, -0.589577>, <0.667569, -0.51454, -0.538146>, <0.123348, 5.54475, -0.579282> , <0.816953, -0.323312, -0.477552> }
	smooth_triangle { <0.100253, 5.51647, -0.589577>, <0.667569, -0.51454, -0.538146>, <0.129305, 5.53368, -0.558914>, <0.848579, -0.392053, -0.355258>, <0.105117, 5.50406, -0.569696> , <0.692857, -0.582766, -0.424657> }
	smooth_triangle { <0.123348, 5.54475, -0.579282>, <0.816953, -0.323312, -0.477552>, <0.0905262, 5.53737, -0.618563>, <0.66648, -0.466086, -0.581866>, <0.111436, 5.57758, -0.61182> , <0.790672, -0.297538, -0.535079> }
	smooth_triangle { <0.0905262, 5.53737, -0.618563>, <0.66648, -0.466086, -0.581866>, <0.123348, 5.54475, -0.579282>, <0.816953, -0.323312, -0.477552>, <0.100253, 5.51647, -0.589577> , <0.667569, -0.51454, -0.538146> }
	smooth_triangle { <0.111436, 5.57758, -0.61182>, <0.790672, -0.297538, -0.535079>, <0.0808001, 5.57068, -0.649741>, <0.66471, -0.438983, -0.604529>, <0.0995233, 5.5739, -0.637921> , <0.767254, -0.304367, -0.564519> }
	smooth_triangle { <0.0808001, 5.57068, -0.649741>, <0.66471, -0.438983, -0.604529>, <0.111436, 5.57758, -0.61182>, <0.790672, -0.297538, -0.535079>, <0.0905262, 5.53737, -0.618563> , <0.66648, -0.466086, -0.581866> }
	smooth_triangle { <-0.00228387, 5.52981, -0.326429>, <0.0657427, -0.416282, 0.906856>, <0.0181721, 5.49783, -0.342623>, <0.102051, -0.493911, 0.863503>, <0.0267384, 5.504, -0.340376> , <0.13505, -0.46933, 0.872635> }
	smooth_triangle { <0.0181721, 5.49783, -0.342623>, <0.102051, -0.493911, 0.863503>, <-0.00228387, 5.52981, -0.326429>, <0.0657427, -0.416282, 0.906856>, <-0.00234934, 5.52976, -0.326447> , <0.0598574, -0.422407, 0.904428> }
	smooth_triangle { <0.0267384, 5.504, -0.340376>, <0.13505, -0.46933, 0.872635>, <0.0334729, 5.47606, -0.36031>, <0.207897, -0.649414, 0.731464>, <0.0483768, 5.4868, -0.356399> , <0.294096, -0.587304, 0.754044> }
	smooth_triangle { <0.0334729, 5.47606, -0.36031>, <0.207897, -0.649414, 0.731464>, <0.0267384, 5.504, -0.340376>, <0.13505, -0.46933, 0.872635>, <0.0181721, 5.49783, -0.342623> , <0.102051, -0.493911, 0.863503> }
	smooth_triangle { <0.0334729, 5.47606, -0.36031>, <0.207897, -0.649414, 0.731464>, <0.06621, 5.47553, -0.377578>, <0.442375, -0.682541, 0.581758>, <0.0483768, 5.4868, -0.356399> , <0.294096, -0.587303, 0.754044> }
	smooth_triangle { <0.06621, 5.47553, -0.377578>, <0.442375, -0.682541, 0.581758>, <0.0334729, 5.47606, -0.36031>, <0.207897, -0.649414, 0.731464>, <0.046082, 5.46102, -0.382857> , <0.312893, -0.775949, 0.547723> }
	smooth_triangle { <0.046082, 5.46102, -0.382857>, <0.312893, -0.775949, 0.547723>, <0.0808001, 5.46888, -0.401955>, <0.559962, -0.735044, 0.382299>, <0.06621, 5.47553, -0.377578> , <0.442375, -0.682541, 0.581758> }
	smooth_triangle { <0.0808001, 5.46888, -0.401955>, <0.559962, -0.735044, 0.382299>, <0.046082, 5.46102, -0.382857>, <0.312893, -0.775949, 0.547723>, <0.056399, 5.45129, -0.408358> , <0.395953, -0.853306, 0.33925> }
	smooth_triangle { <0.056399, 5.45129, -0.408358>, <0.395953, -0.853306, 0.33925>, <0.0921478, 5.46763, -0.431689>, <0.63314, -0.747252, 0.201859>, <0.0808001, 5.46888, -0.401955> , <0.559962, -0.735044, 0.382299> }
	smooth_triangle { <0.0921478, 5.46763, -0.431689>, <0.63314, -0.747252, 0.201859>, <0.056399, 5.45129, -0.408358>, <0.395953, -0.853306, 0.33925>, <0.0644233, 5.44764, -0.438965> , <0.447699, -0.880964, 0.153195> }
	smooth_triangle { <0.0644233, 5.44764, -0.438965>, <0.447699, -0.880964, 0.153195>, <0.100253, 5.46942, -0.460314>, <0.678631, -0.733786, 0.0319119>, <0.0921478, 5.46763, -0.431689> , <0.63314, -0.747252, 0.201859> }
	smooth_triangle { <0.100253, 5.46942, -0.460314>, <0.678631, -0.733786, 0.0319119>, <0.0644233, 5.44764, -0.438965>, <0.447699, -0.880964, 0.153195>, <0.0701553, 5.44772, -0.468213> , <0.479863, -0.87711, -0.0202554> }
	smooth_triangle { <0.0701553, 5.44772, -0.468213>, <0.479863, -0.87711, -0.0202554>, <0.105117, 5.47818, -0.498601>, <0.69878, -0.708973, -0.095208>, <0.100253, 5.46942, -0.460314> , <0.678631, -0.733786, 0.0319119> }
	smooth_triangle { <0.105117, 5.47818, -0.498601>, <0.69878, -0.708973, -0.095208>, <0.0701553, 5.44772, -0.468213>, <0.479863, -0.87711, -0.0202554>, <0.0735938, 5.45545, -0.506874> , <0.494114, -0.856547, -0.148926> }
	smooth_triangle { <0.0735938, 5.45545, -0.506874>, <0.494114, -0.856547, -0.148926>, <0.108359, 5.4869, -0.532027>, <0.707062, -0.668169, -0.231545>, <0.105117, 5.47818, -0.498601> , <0.69878, -0.708973, -0.095208> }
	smooth_triangle { <0.108359, 5.4869, -0.532027>, <0.707062, -0.668169, -0.231545>, <0.0735938, 5.45545, -0.506874>, <0.494114, -0.856547, -0.148926>, <0.0758869, 5.46348, -0.540549> , <0.499967, -0.817496, -0.285891> }
	smooth_triangle { <0.0758869, 5.46348, -0.540549>, <0.499967, -0.817496, -0.285891>, <0.105117, 5.50406, -0.569696>, <0.692856, -0.582766, -0.424657>, <0.108359, 5.4869, -0.532027> , <0.707062, -0.668169, -0.231545> }
	smooth_triangle { <0.105117, 5.50406, -0.569696>, <0.692856, -0.582766, -0.424657>, <0.0758869, 5.46348, -0.540549>, <0.499967, -0.817496, -0.285891>, <0.0735938, 5.48133, -0.577968> , <0.489928, -0.72909, -0.477911> }
	smooth_triangle { <0.0735938, 5.48133, -0.577968>, <0.489928, -0.72909, -0.477911>, <0.100253, 5.51647, -0.589577>, <0.667569, -0.51454, -0.538146>, <0.105117, 5.50406, -0.569696> , <0.692857, -0.582766, -0.424657> }
	smooth_triangle { <0.100253, 5.51647, -0.589577>, <0.667569, -0.51454, -0.538146>, <0.0735938, 5.48133, -0.577968>, <0.489928, -0.72909, -0.477911>, <0.0701553, 5.49477, -0.597476> , <0.472048, -0.655519, -0.589462> }
	smooth_triangle { <0.0701553, 5.49477, -0.597476>, <0.472048, -0.655519, -0.589462>, <0.0905262, 5.53737, -0.618563>, <0.66648, -0.466086, -0.581866>, <0.100253, 5.51647, -0.589577> , <0.667569, -0.51454, -0.538146> }
	smooth_triangle { <0.0905262, 5.53737, -0.618563>, <0.66648, -0.466086, -0.581866>, <0.0701553, 5.49477, -0.597476>, <0.472048, -0.655519, -0.589462>, <0.0632771, 5.51772, -0.625716> , <0.464242, -0.628558, -0.624015> }
	smooth_triangle { <0.0632771, 5.51772, -0.625716>, <0.464242, -0.628558, -0.624015>, <0.0808001, 5.57068, -0.649741>, <0.66471, -0.438983, -0.604529>, <0.0905262, 5.53737, -0.618563> , <0.66648, -0.466086, -0.581866> }
	smooth_triangle { <0.0808001, 5.57068, -0.649741>, <0.66471, -0.438983, -0.604529>, <0.0632771, 5.51772, -0.625716>, <0.464242, -0.628558, -0.624015>, <0.056399, 5.54068, -0.653957> , <0.479178, -0.567362, -0.669693> }
	smooth_triangle { <0.0808001, 5.57068, -0.649741>, <0.66471, -0.438983, -0.604529>, <0.0426434, 5.56483, -0.684423>, <0.491308, -0.502091, -0.711703>, <0.0613462, 5.5692, -0.675716> , <0.641758, -0.433018, -0.632963> }
	smooth_triangle { <0.0426434, 5.56483, -0.684423>, <0.491308, -0.502091, -0.711703>, <0.0808001, 5.57068, -0.649741>, <0.66471, -0.438983, -0.604529>, <0.056399, 5.54068, -0.653957> , <0.479178, -0.567362, -0.669693> }
	smooth_triangle { <-0.00234934, 5.52976, -0.326447>, <0.0598574, -0.422407, 0.904428>, <0.008196, 5.49394, -0.344042>, <0.0590312, -0.512411, 0.856709>, <0.0181721, 5.49783, -0.342623> , <0.102051, -0.493911, 0.863503> }
	smooth_triangle { <0.008196, 5.49394, -0.344042>, <0.0590312, -0.512411, 0.856709>, <-0.00234934, 5.52976, -0.326447>, <0.0598574, -0.422407, 0.904428>, <-0.0024268, 5.52973, -0.326456> , <0.0433403, -0.432285, 0.900695> }
	smooth_triangle { <0.0181721, 5.49783, -0.342623>, <0.102051, -0.493911, 0.863503>, <0.0161163, 5.4693, -0.362762>, <0.107585, -0.688448, 0.717262>, <0.0334729, 5.47606, -0.36031> , <0.207897, -0.649414, 0.731464> }
	smooth_triangle { <0.0161163, 5.4693, -0.362762>, <0.107585, -0.688448, 0.717262>, <0.0181721, 5.49783, -0.342623>, <0.102051, -0.493911, 0.863503>, <0.008196, 5.49394, -0.344042> , <0.0590312, -0.512411, 0.856709> }
	smooth_triangle { <0.0161163, 5.4693, -0.362762>, <0.107585, -0.688448, 0.717262>, <0.046082, 5.46102, -0.382857>, <0.312893, -0.775949, 0.547723>, <0.0334729, 5.47606, -0.36031> , <0.207897, -0.649414, 0.731464> }
	smooth_triangle { <0.046082, 5.46102, -0.382857>, <0.312893, -0.775949, 0.547723>, <0.0161163, 5.4693, -0.362762>, <0.107585, -0.688448, 0.717262>, <0.0226431, 5.4519, -0.386178> , <0.161955, -0.8347, 0.526352> }
	smooth_triangle { <0.0226431, 5.4519, -0.386178>, <0.161955, -0.8347, 0.526352>, <0.056399, 5.45129, -0.408358>, <0.395953, -0.853306, 0.33925>, <0.046082, 5.46102, -0.382857> , <0.312893, -0.775949, 0.547723> }
	smooth_triangle { <0.056399, 5.45129, -0.408358>, <0.395953, -0.853306, 0.33925>, <0.0226431, 5.4519, -0.386178>, <0.161955, -0.8347, 0.526352>, <0.0279839, 5.44023, -0.412385> , <0.204979, -0.927647, 0.312178> }
	smooth_triangle { <0.0279839, 5.44023, -0.412385>, <0.204979, -0.927647, 0.312178>, <0.0644233, 5.44764, -0.438965>, <0.447699, -0.880964, 0.153195>, <0.056399, 5.45129, -0.408358> , <0.395953, -0.853306, 0.33925> }
	smooth_triangle { <0.0644233, 5.44764, -0.438965>, <0.447699, -0.880964, 0.153195>, <0.0279839, 5.44023, -0.412385>, <0.204979, -0.927647, 0.312178>, <0.0321374, 5.43507, -0.443539> , <0.231745, -0.965019, 0.122608> }
	smooth_triangle { <0.0321374, 5.43507, -0.443539>, <0.231745, -0.965019, 0.122608>, <0.0701553, 5.44772, -0.468213>, <0.479863, -0.87711, -0.0202554>, <0.0644233, 5.44764, -0.438965> , <0.447699, -0.880964, 0.153195> }
	smooth_triangle { <0.0701553, 5.44772, -0.468213>, <0.479863, -0.87711, -0.0202554>, <0.0321374, 5.43507, -0.443539>, <0.231745, -0.965019, 0.122608>, <0.0351043, 5.43408, -0.473179> , <0.248397, -0.967205, -0.0530433> }
	smooth_triangle { <0.0351043, 5.43408, -0.473179>, <0.248397, -0.967205, -0.0530433>, <0.0735938, 5.45545, -0.506874>, <0.494114, -0.856547, -0.148926>, <0.0701553, 5.44772, -0.468213> , <0.479863, -0.87711, -0.0202554> }
	smooth_triangle { <0.0735938, 5.45545, -0.506874>, <0.494114, -0.856547, -0.148926>, <0.0351043, 5.43408, -0.473179>, <0.248397, -0.967205, -0.0530433>, <0.0368845, 5.44116, -0.512075> , <0.255776, -0.949317, -0.182691> }
	smooth_triangle { <0.0368845, 5.44116, -0.512075>, <0.255776, -0.949317, -0.182691>, <0.0758869, 5.46348, -0.540549>, <0.499967, -0.817496, -0.285891>, <0.0735938, 5.45545, -0.506874> , <0.494114, -0.856547, -0.148926> }
	smooth_triangle { <0.0758869, 5.46348, -0.540549>, <0.499967, -0.817496, -0.285891>, <0.0368845, 5.44116, -0.512075>, <0.255776, -0.949317, -0.182691>, <0.0380707, 5.44876, -0.545905> , <0.258805, -0.911365, -0.320052> }
	smooth_triangle { <0.0380707, 5.44876, -0.545905>, <0.258805, -0.911365, -0.320052>, <0.0735938, 5.48133, -0.577968>, <0.489928, -0.72909, -0.477911>, <0.0758869, 5.46348, -0.540549> , <0.499967, -0.817496, -0.285891> }
	smooth_triangle { <0.0735938, 5.48133, -0.577968>, <0.489928, -0.72909, -0.477911>, <0.0380707, 5.44876, -0.545905>, <0.258805, -0.911365, -0.320052>, <0.0368845, 5.46704, -0.58317> , <0.253607, -0.821071, -0.511397> }
	smooth_triangle { <0.0368845, 5.46704, -0.58317>, <0.253607, -0.821071, -0.511397>, <0.0701553, 5.49477, -0.597476>, <0.472048, -0.655519, -0.589462>, <0.0735938, 5.48133, -0.577968> , <0.489928, -0.72909, -0.477911> }
	smooth_triangle { <0.0701553, 5.49477, -0.597476>, <0.472048, -0.655519, -0.589462>, <0.0368845, 5.46704, -0.58317>, <0.253607, -0.821071, -0.511397>, <0.0351043, 5.48112, -0.602442> , <0.244346, -0.744148, -0.621722> }
	smooth_triangle { <0.0351043, 5.48112, -0.602442>, <0.244346, -0.744148, -0.621722>, <0.0632771, 5.51772, -0.625716>, <0.464242, -0.628558, -0.624015>, <0.0701553, 5.49477, -0.597476> , <0.472048, -0.655519, -0.589462> }
	smooth_triangle { <0.0632771, 5.51772, -0.625716>, <0.464242, -0.628558, -0.624015>, <0.0351043, 5.48112, -0.602442>, <0.244346, -0.744148, -0.621722>, <0.0315441, 5.50537, -0.630211> , <0.24031, -0.715726, -0.655734> }
	smooth_triangle { <0.0315441, 5.50537, -0.630211>, <0.24031, -0.715726, -0.655734>, <0.056399, 5.54068, -0.653957>, <0.479178, -0.567362, -0.669693>, <0.0632771, 5.51772, -0.625716> , <0.464242, -0.628558, -0.624015> }
	smooth_triangle { <0.056399, 5.54068, -0.653957>, <0.479178, -0.567362, -0.669693>, <0.0315441, 5.50537, -0.630211>, <0.24031, -0.715726, -0.655734>, <0.0279839, 5.52962, -0.657983> , <0.230533, -0.652939, -0.721474> }
	smooth_triangle { <0.0279839, 5.52962, -0.657983>, <0.230533, -0.652939, -0.721474>, <0.0426434, 5.56483, -0.684423>, <0.491308, -0.502091, -0.711703>, <0.056399, 5.54068, -0.653957> , <0.479178, -0.567362, -0.669693> }
	smooth_triangle { <0.0426434, 5.56483, -0.684423>, <0.491308, -0.502091, -0.711703>, <0.0279839, 5.52962, -0.657983>, <0.230533, -0.652939, -0.721474>, <0.0208632, 5.56949, -0.689826> , <0.218837, -0.584784, -0.781113> }
	smooth_triangle { <-0.00250971, 5.52972, -0.326458>, <0.000245134, -0.43567, 0.900106>, <0.008196, 5.49394, -0.344042>, <0.0590312, -0.512411, 0.856709>, <-0.0024268, 5.52973, -0.326456> , <0.0433403, -0.432285, 0.900695> }
	smooth_triangle { <0.008196, 5.49394, -0.344042>, <0.0590312, -0.512411, 0.856709>, <-0.00250971, 5.52972, -0.326458>, <0.000245134, -0.43567, 0.900106>, <-0.00250971, 5.49262, -0.34452> , <0.000132225, -0.518797, 0.854898> }
	smooth_triangle { <0.008196, 5.49394, -0.344042>, <0.0590312, -0.512411, 0.856709>, <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <0.0161163, 5.4693, -0.362762> , <0.107585, -0.688448, 0.717262> }
	smooth_triangle { <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <0.008196, 5.49394, -0.344042>, <0.0590312, -0.512411, 0.856709>, <-0.00250971, 5.49262, -0.34452> , <0.000132225, -0.518797, 0.854898> }
	smooth_triangle { <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <0.0226431, 5.4519, -0.386178>, <0.161955, -0.8347, 0.526352>, <0.0161163, 5.4693, -0.362762> , <0.107585, -0.688448, 0.717262> }
	smooth_triangle { <0.0226431, 5.4519, -0.386178>, <0.161955, -0.8347, 0.526352>, <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <-0.00250971, 5.44879, -0.387308> , <-5.74406e-006, -0.854748, 0.519044> }
	smooth_triangle { <-0.00250971, 5.44879, -0.387308>, <-5.74406e-006, -0.854748, 0.519044>, <0.0279839, 5.44023, -0.412385>, <0.204979, -0.927647, 0.312178>, <0.0226431, 5.4519, -0.386178> , <0.161955, -0.8347, 0.526352> }
	smooth_triangle { <0.0279839, 5.44023, -0.412385>, <0.204979, -0.927647, 0.312178>, <-0.00250971, 5.44879, -0.387308>, <-5.74406e-006, -0.854748, 0.519044>, <-0.00250971, 5.43646, -0.413758> , <2.738e-007, -0.953007, 0.302949> }
	smooth_triangle { <-0.00250971, 5.43646, -0.413758>, <2.738e-007, -0.953007, 0.302949>, <0.0321374, 5.43507, -0.443539>, <0.231745, -0.965019, 0.122608>, <0.0279839, 5.44023, -0.412385> , <0.204979, -0.927647, 0.312178> }
	smooth_triangle { <0.0321374, 5.43507, -0.443539>, <0.231745, -0.965019, 0.122608>, <-0.00250971, 5.43646, -0.413758>, <2.738e-007, -0.953007, 0.302949>, <-0.00250971, 5.43079, -0.445099> , <-1.93606e-007, -0.993689, 0.112173> }
	smooth_triangle { <-0.00250971, 5.43079, -0.445099>, <-1.93606e-007, -0.993689, 0.112173>, <0.0351043, 5.43408, -0.473179>, <0.248397, -0.967205, -0.0530433>, <0.0321374, 5.43507, -0.443539> , <0.231745, -0.965019, 0.122608> }
	smooth_triangle { <0.0351043, 5.43408, -0.473179>, <0.248397, -0.967205, -0.0530433>, <-0.00250971, 5.43079, -0.445099>, <-1.93606e-007, -0.993689, 0.112173>, <-0.00250971, 5.42942, -0.474872> , <-2.53089e-007, -0.997935, -0.0642282> }
	smooth_triangle { <-0.00250971, 5.42942, -0.474872>, <-2.53089e-007, -0.997935, -0.0642282>, <0.0368845, 5.44116, -0.512075>, <0.255776, -0.949317, -0.182691>, <0.0351043, 5.43408, -0.473179> , <0.248397, -0.967205, -0.0530433> }
	smooth_triangle { <0.0368845, 5.44116, -0.512075>, <0.255776, -0.949317, -0.182691>, <-0.00250971, 5.42942, -0.474872>, <-2.53089e-007, -0.997935, -0.0642282>, <-0.00250971, 5.43629, -0.513848> , <-1.46543e-007, -0.98096, -0.194208> }
	smooth_triangle { <-0.00250971, 5.43629, -0.513848>, <-1.46543e-007, -0.98096, -0.194208>, <0.0380707, 5.44876, -0.545905>, <0.258805, -0.911365, -0.320052>, <0.0368845, 5.44116, -0.512075> , <0.255776, -0.949317, -0.182691> }
	smooth_triangle { <0.0380707, 5.44876, -0.545905>, <0.258805, -0.911365, -0.320052>, <-0.00250971, 5.43629, -0.513848>, <-1.46543e-007, -0.98096, -0.194208>, <-0.0025097, 5.44374, -0.547733> , <-7.03993e-007, -0.943383, -0.331705> }
	smooth_triangle { <-0.0025097, 5.44374, -0.547733>, <-7.03993e-007, -0.943383, -0.331705>, <0.0368845, 5.46704, -0.58317>, <0.253607, -0.821071, -0.511397>, <0.0380707, 5.44876, -0.545905> , <0.258805, -0.911366, -0.320052> }
	smooth_triangle { <0.0368845, 5.46704, -0.58317>, <0.253607, -0.821071, -0.511397>, <-0.0025097, 5.44374, -0.547733>, <-7.03993e-007, -0.943383, -0.331705>, <-0.00250971, 5.46217, -0.584943> , <1.84795e-007, -0.852445, -0.522817> }
	smooth_triangle { <-0.00250971, 5.46217, -0.584943>, <1.84795e-007, -0.852445, -0.522817>, <0.0351043, 5.48112, -0.602442>, <0.244346, -0.744148, -0.621722>, <0.0368845, 5.46704, -0.58317> , <0.253607, -0.821071, -0.511397> }
	smooth_triangle { <0.0351043, 5.48112, -0.602442>, <0.244346, -0.744148, -0.621722>, <-0.00250971, 5.46217, -0.584943>, <1.84795e-007, -0.852445, -0.522817>, <-0.0025097, 5.47647, -0.604135> , <9.90133e-007, -0.774377, -0.632724> }
	smooth_triangle { <-0.0025097, 5.47647, -0.604135>, <9.90133e-007, -0.774377, -0.632724>, <0.0315441, 5.50537, -0.630211>, <0.24031, -0.715726, -0.655734>, <0.0351043, 5.48112, -0.602442> , <0.244346, -0.744148, -0.621722> }
	smooth_triangle { <0.0315441, 5.50537, -0.630211>, <0.24031, -0.715726, -0.655734>, <-0.0025097, 5.47647, -0.604135>, <9.90133e-007, -0.774377, -0.632724>, <-0.00250971, 5.50116, -0.631745> , <-3.24637e-007, -0.745454, -0.666557> }
	smooth_triangle { <-0.00250971, 5.50116, -0.631745>, <-3.24637e-007, -0.745454, -0.666557>, <0.0279839, 5.52962, -0.657983>, <0.230533, -0.652939, -0.721474>, <0.0315441, 5.50537, -0.630211> , <0.24031, -0.715726, -0.655734> }
	smooth_triangle { <0.0279839, 5.52962, -0.657983>, <0.230533, -0.652939, -0.721474>, <-0.00250971, 5.50116, -0.631745>, <-3.24637e-007, -0.745454, -0.666557>, <-0.00250971, 5.52585, -0.659356> , <-1.00374e-006, -0.681459, -0.731857> }
	smooth_triangle { <0.0279839, 5.52962, -0.657983>, <0.230533, -0.65294, -0.721474>, <-0.0025097, 5.5666, -0.690879>, <-3.48592e-007, -0.611857, -0.790968>, <0.0208632, 5.56949, -0.689826> , <0.218837, -0.584784, -0.781113> }
	smooth_triangle { <-0.0025097, 5.5666, -0.690879>, <-3.48592e-007, -0.611857, -0.790968>, <0.0279839, 5.52962, -0.657983>, <0.230533, -0.65294, -0.721474>, <-0.00250971, 5.52585, -0.659356> , <-1.00374e-006, -0.681459, -0.731857> }
	smooth_triangle { <-0.0025925, 5.52973, -0.326456>, <-0.0424877, -0.428374, 0.902602>, <-0.00250971, 5.49262, -0.34452>, <0.000132226, -0.518797, 0.854898>, <-0.00250971, 5.52972, -0.326458> , <0.000245134, -0.43567, 0.900106> }
	smooth_triangle { <-0.00250971, 5.49262, -0.34452>, <0.000132226, -0.518797, 0.854898>, <-0.0025925, 5.52973, -0.326456>, <-0.0424877, -0.428374, 0.902602>, <-0.0132154, 5.49394, -0.344042> , <-0.0586405, -0.510563, 0.857838> }
	smooth_triangle { <-0.0132154, 5.49394, -0.344042>, <-0.0586405, -0.510563, 0.857838>, <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <-0.00250971, 5.49262, -0.34452> , <0.000132226, -0.518797, 0.854897> }
	smooth_triangle { <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <-0.0132154, 5.49394, -0.344042>, <-0.0586405, -0.510563, 0.857838>, <-0.021135, 5.4693, -0.362762> , <-0.107603, -0.688467, 0.717241> }
	smooth_triangle { <-0.0276624, 5.4519, -0.386178>, <-0.161944, -0.8347, 0.526355>, <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <-0.021135, 5.4693, -0.362762> , <-0.107603, -0.688467, 0.717241> }
	smooth_triangle { <-0.00250971, 5.467, -0.363606>, <3.42608e-006, -0.701747, 0.712427>, <-0.0276624, 5.4519, -0.386178>, <-0.161944, -0.8347, 0.526355>, <-0.00250971, 5.44879, -0.387308> , <-5.74406e-006, -0.854748, 0.519044> }
	smooth_triangle { <-0.0330032, 5.44023, -0.412385>, <-0.204974, -0.927641, 0.312197>, <-0.00250971, 5.44879, -0.387308>, <-5.74406e-006, -0.854748, 0.519044>, <-0.0276624, 5.4519, -0.386178> , <-0.161944, -0.8347, 0.526355> }
	smooth_triangle { <-0.00250971, 5.44879, -0.387308>, <-5.74406e-006, -0.854748, 0.519044>, <-0.0330032, 5.44023, -0.412385>, <-0.204974, -0.927641, 0.312197>, <-0.00250971, 5.43646, -0.413758> , <2.738e-007, -0.953007, 0.302949> }
	smooth_triangle { <-0.0371568, 5.43507, -0.443539>, <-0.231746, -0.96502, 0.122599>, <-0.00250971, 5.43646, -0.413758>, <2.738e-007, -0.953007, 0.302949>, <-0.0330032, 5.44023, -0.412385> , <-0.204974, -0.927641, 0.312197> }
	smooth_triangle { <-0.00250971, 5.43646, -0.413758>, <2.738e-007, -0.953007, 0.302949>, <-0.0371568, 5.43507, -0.443539>, <-0.231746, -0.96502, 0.122599>, <-0.00250971, 5.43079, -0.445099> , <-1.93606e-007, -0.993689, 0.112173> }
	smooth_triangle { <-0.0401237, 5.43408, -0.473179>, <-0.248399, -0.967204, -0.0530471>, <-0.00250971, 5.43079, -0.445099>, <-1.93606e-007, -0.993689, 0.112173>, <-0.0371568, 5.43507, -0.443539> , <-0.231746, -0.96502, 0.122599> }
	smooth_triangle { <-0.00250971, 5.43079, -0.445099>, <-1.93606e-007, -0.993689, 0.112173>, <-0.0401237, 5.43408, -0.473179>, <-0.248399, -0.967204, -0.0530471>, <-0.00250971, 5.42942, -0.474872> , <-2.53089e-007, -0.997935, -0.0642282> }
	smooth_triangle { <-0.0419038, 5.44116, -0.512075>, <-0.255777, -0.949317, -0.182687>, <-0.00250971, 5.42942, -0.474872>, <-2.54977e-007, -0.997935, -0.0642282>, <-0.0401237, 5.43408, -0.473179> , <-0.248399, -0.967204, -0.0530471> }
	smooth_triangle { <-0.00250971, 5.42942, -0.474872>, <-2.54977e-007, -0.997935, -0.0642282>, <-0.0419038, 5.44116, -0.512075>, <-0.255777, -0.949317, -0.182687>, <-0.00250971, 5.43629, -0.513848> , <-1.42785e-007, -0.98096, -0.194208> }
	smooth_triangle { <-0.04309, 5.44876, -0.545905>, <-0.258803, -0.911364, -0.320056>, <-0.00250971, 5.43629, -0.513848>, <-1.42785e-007, -0.98096, -0.194208>, <-0.0419038, 5.44116, -0.512075> , <-0.255777, -0.949317, -0.182687> }
	smooth_triangle { <-0.00250971, 5.43629, -0.513848>, <-1.42785e-007, -0.98096, -0.194208>, <-0.04309, 5.44876, -0.545905>, <-0.258803, -0.911364, -0.320056>, <-0.0025097, 5.44374, -0.547733> , <-7.00208e-007, -0.943383, -0.331705> }
	smooth_triangle { <-0.0419038, 5.46704, -0.58317>, <-0.253607, -0.821072, -0.511395>, <-0.0025097, 5.44374, -0.547733>, <-7.00208e-007, -0.943383, -0.331705>, <-0.04309, 5.44876, -0.545905> , <-0.258803, -0.911364, -0.320056> }
	smooth_triangle { <-0.0025097, 5.44374, -0.547733>, <-7.00208e-007, -0.943383, -0.331705>, <-0.0419038, 5.46704, -0.58317>, <-0.253607, -0.821072, -0.511395>, <-0.00250971, 5.46217, -0.584943> , <1.81023e-007, -0.852445, -0.522817> }
	smooth_triangle { <-0.0401237, 5.48112, -0.602442>, <-0.244349, -0.744146, -0.621723>, <-0.00250971, 5.46217, -0.584943>, <1.81023e-007, -0.852445, -0.522817>, <-0.0419038, 5.46704, -0.58317> , <-0.253607, -0.821072, -0.511395> }
	smooth_triangle { <-0.00250971, 5.46217, -0.584943>, <1.81023e-007, -0.852445, -0.522817>, <-0.0401237, 5.48112, -0.602442>, <-0.244349, -0.744146, -0.621723>, <-0.0025097, 5.47647, -0.604135> , <9.88254e-007, -0.774377, -0.632724> }
	smooth_triangle { <-0.0365629, 5.50537, -0.630211>, <-0.240311, -0.715723, -0.655737>, <-0.0025097, 5.47647, -0.604135>, <9.88254e-007, -0.774377, -0.632724>, <-0.0401237, 5.48112, -0.602442> , <-0.244349, -0.744146, -0.621723> }
	smooth_triangle { <-0.0025097, 5.47647, -0.604135>, <9.88254e-007, -0.774377, -0.632724>, <-0.0365629, 5.50537, -0.630211>, <-0.240311, -0.715723, -0.655737>, <-0.00250971, 5.50116, -0.631745> , <-3.26513e-007, -0.745454, -0.666557> }
	smooth_triangle { <-0.0330032, 5.52962, -0.657983>, <-0.236488, -0.6767, -0.697244>, <-0.00250971, 5.50116, -0.631745>, <-3.26513e-007, -0.745454, -0.666557>, <-0.0365629, 5.50537, -0.630211> , <-0.240311, -0.715723, -0.655737> }
	smooth_triangle { <-0.00250971, 5.50116, -0.631745>, <-3.26513e-007, -0.745454, -0.666557>, <-0.0330032, 5.52962, -0.657983>, <-0.236488, -0.6767, -0.697244>, <-0.00250971, 5.52585, -0.659356> , <-1.00374e-006, -0.681459, -0.731857> }
	smooth_triangle { <-0.00250971, 5.52585, -0.659356>, <-1.00374e-006, -0.681459, -0.731857>, <-0.0258826, 5.56949, -0.689826>, <-0.231883, -0.635399, -0.736545>, <-0.0025097, 5.5666, -0.690879> , <-3.48592e-007, -0.611857, -0.790968> }
	smooth_triangle { <-0.0258826, 5.56949, -0.689826>, <-0.231883, -0.635399, -0.736545>, <-0.00250971, 5.52585, -0.659356>, <-1.00374e-006, -0.681459, -0.731857>, <-0.0330032, 5.52962, -0.657983> , <-0.236488, -0.6767, -0.697244> }
	smooth_triangle { <-0.00266936, 5.52976, -0.326447>, <-0.059025, -0.42063, 0.90531>, <-0.0132154, 5.49394, -0.344042>, <-0.0586405, -0.510563, 0.857838>, <-0.0025925, 5.52973, -0.326456> , <-0.0424877, -0.428374, 0.902602> }
	smooth_triangle { <-0.0132154, 5.49394, -0.344042>, <-0.0586405, -0.510563, 0.857838>, <-0.00266936, 5.52976, -0.326447>, <-0.059025, -0.42063, 0.90531>, <-0.0231914, 5.49783, -0.342623> , <-0.101674, -0.493137, 0.86399> }
	smooth_triangle { <-0.0231914, 5.49783, -0.342623>, <-0.101674, -0.493137, 0.86399>, <-0.021135, 5.4693, -0.362762>, <-0.107603, -0.688467, 0.717241>, <-0.0132154, 5.49394, -0.344042> , <-0.0586405, -0.510563, 0.857838> }
	smooth_triangle { <-0.021135, 5.4693, -0.362762>, <-0.107603, -0.688467, 0.717241>, <-0.0231914, 5.49783, -0.342623>, <-0.101674, -0.493137, 0.86399>, <-0.0384923, 5.47606, -0.36031> , <-0.207904, -0.649444, 0.731436> }
	smooth_triangle { <-0.0511013, 5.46102, -0.382857>, <-0.312874, -0.775925, 0.547769>, <-0.021135, 5.4693, -0.362762>, <-0.107603, -0.688467, 0.717241>, <-0.0384923, 5.47606, -0.36031> , <-0.207904, -0.649444, 0.731436> }
	smooth_triangle { <-0.021135, 5.4693, -0.362762>, <-0.107603, -0.688467, 0.717241>, <-0.0511013, 5.46102, -0.382857>, <-0.312874, -0.775925, 0.547769>, <-0.0276624, 5.4519, -0.386178> , <-0.161944, -0.8347, 0.526355> }
	smooth_triangle { <-0.0614184, 5.45129, -0.408358>, <-0.395954, -0.853304, 0.339252>, <-0.0276624, 5.4519, -0.386178>, <-0.161944, -0.8347, 0.526355>, <-0.0511013, 5.46102, -0.382857> , <-0.312874, -0.775925, 0.547769> }
	smooth_triangle { <-0.0276624, 5.4519, -0.386178>, <-0.161944, -0.8347, 0.526355>, <-0.0614184, 5.45129, -0.408358>, <-0.395954, -0.853304, 0.339252>, <-0.0330032, 5.44023, -0.412385> , <-0.204974, -0.927641, 0.312197> }
	smooth_triangle { <-0.0694427, 5.44764, -0.438965>, <-0.4477, -0.880964, 0.153191>, <-0.0330032, 5.44023, -0.412385>, <-0.204974, -0.927641, 0.312197>, <-0.0614184, 5.45129, -0.408358> , <-0.395954, -0.853304, 0.339252> }
	smooth_triangle { <-0.0330032, 5.44023, -0.412385>, <-0.204974, -0.927641, 0.312197>, <-0.0694427, 5.44764, -0.438965>, <-0.4477, -0.880964, 0.153191>, <-0.0371568, 5.43507, -0.443539> , <-0.231746, -0.96502, 0.122599> }
	smooth_triangle { <-0.0751739, 5.44772, -0.468213>, <-0.479861, -0.877111, -0.0202546>, <-0.0371568, 5.43507, -0.443539>, <-0.231746, -0.96502, 0.122599>, <-0.0694427, 5.44764, -0.438965> , <-0.4477, -0.880964, 0.153191> }
	smooth_triangle { <-0.0371568, 5.43507, -0.443539>, <-0.231746, -0.96502, 0.122599>, <-0.0751739, 5.44772, -0.468213>, <-0.479861, -0.877111, -0.0202546>, <-0.0401237, 5.43408, -0.473179> , <-0.248399, -0.967204, -0.0530471> }
	smooth_triangle { <-0.0786132, 5.45545, -0.506874>, <-0.494113, -0.856549, -0.148919>, <-0.0401237, 5.43408, -0.473179>, <-0.248399, -0.967204, -0.0530471>, <-0.0751739, 5.44772, -0.468213> , <-0.479861, -0.877111, -0.0202546> }
	smooth_triangle { <-0.0401237, 5.43408, -0.473179>, <-0.248399, -0.967204, -0.0530471>, <-0.0786132, 5.45545, -0.506874>, <-0.494113, -0.856549, -0.148919>, <-0.0419038, 5.44116, -0.512075> , <-0.255777, -0.949317, -0.182687> }
	smooth_triangle { <-0.0809063, 5.46348, -0.540549>, <-0.499967, -0.817494, -0.285896>, <-0.0419038, 5.44116, -0.512075>, <-0.255777, -0.949317, -0.182687>, <-0.0786132, 5.45545, -0.506874> , <-0.494113, -0.856549, -0.148919> }
	smooth_triangle { <-0.0419038, 5.44116, -0.512075>, <-0.255777, -0.949317, -0.182687>, <-0.0809063, 5.46348, -0.540549>, <-0.499967, -0.817494, -0.285896>, <-0.04309, 5.44876, -0.545905> , <-0.258803, -0.911364, -0.320056> }
	smooth_triangle { <-0.0786132, 5.48133, -0.577968>, <-0.489926, -0.729088, -0.477916>, <-0.04309, 5.44876, -0.545905>, <-0.258803, -0.911364, -0.320056>, <-0.0809063, 5.46348, -0.540549> , <-0.499967, -0.817494, -0.285896> }
	smooth_triangle { <-0.04309, 5.44876, -0.545905>, <-0.258803, -0.911364, -0.320056>, <-0.0786132, 5.48133, -0.577968>, <-0.489926, -0.729088, -0.477916>, <-0.0419038, 5.46704, -0.58317> , <-0.253607, -0.821072, -0.511395> }
	smooth_triangle { <-0.0751739, 5.49477, -0.597476>, <-0.472046, -0.655523, -0.589459>, <-0.0419038, 5.46704, -0.58317>, <-0.253607, -0.821072, -0.511395>, <-0.0786132, 5.48133, -0.577968> , <-0.489926, -0.729088, -0.477916> }
	smooth_triangle { <-0.0419038, 5.46704, -0.58317>, <-0.253607, -0.821072, -0.511395>, <-0.0751739, 5.49477, -0.597476>, <-0.472046, -0.655523, -0.589459>, <-0.0401237, 5.48112, -0.602442> , <-0.244349, -0.744146, -0.621723> }
	smooth_triangle { <-0.0682965, 5.51772, -0.625716>, <-0.456747, -0.60981, -0.6477>, <-0.0401237, 5.48112, -0.602442>, <-0.244349, -0.744146, -0.621723>, <-0.0751739, 5.49477, -0.597476> , <-0.472046, -0.655523, -0.589459> }
	smooth_triangle { <-0.0401237, 5.48112, -0.602442>, <-0.244349, -0.744146, -0.621723>, <-0.0682965, 5.51772, -0.625716>, <-0.456747, -0.60981, -0.6477>, <-0.0365629, 5.50537, -0.630211> , <-0.240311, -0.715723, -0.655737> }
	smooth_triangle { <-0.0614184, 5.54068, -0.653957>, <-0.498796, -0.596658, -0.628651>, <-0.0365629, 5.50537, -0.630211>, <-0.240311, -0.715723, -0.655737>, <-0.0682965, 5.51772, -0.625716> , <-0.456747, -0.60981, -0.6477> }
	smooth_triangle { <-0.0365629, 5.50537, -0.630211>, <-0.240311, -0.715723, -0.655737>, <-0.0614184, 5.54068, -0.653957>, <-0.498796, -0.596658, -0.628651>, <-0.0330032, 5.52962, -0.657983> , <-0.236488, -0.6767, -0.697244> }
	smooth_triangle { <-0.0330032, 5.52962, -0.657983>, <-0.236489, -0.6767, -0.697244>, <-0.0476629, 5.56483, -0.684423>, <-0.547411, -0.600335, -0.583043>, <-0.0258826, 5.56949, -0.689826> , <-0.231883, -0.635399, -0.736545> }
	smooth_triangle { <-0.0476629, 5.56483, -0.684423>, <-0.547411, -0.600335, -0.583043>, <-0.0330032, 5.52962, -0.657983>, <-0.236489, -0.6767, -0.697244>, <-0.0614184, 5.54068, -0.653957> , <-0.498796, -0.596658, -0.628651> }
	smooth_triangle { <-0.00273549, 5.52981, -0.326429>, <-0.0678812, -0.417935, 0.905937>, <-0.0231914, 5.49783, -0.342623>, <-0.101674, -0.493137, 0.86399>, <-0.00266936, 5.52976, -0.326447> , <-0.059025, -0.42063, 0.90531> }
	smooth_triangle { <-0.0231914, 5.49783, -0.342623>, <-0.101674, -0.493137, 0.86399>, <-0.00273549, 5.52981, -0.326429>, <-0.0678812, -0.417935, 0.905937>, <-0.0317579, 5.504, -0.340376> , <-0.136036, -0.470048, 0.872095> }
	smooth_triangle { <-0.0317579, 5.504, -0.340376>, <-0.136036, -0.470048, 0.872095>, <-0.0384923, 5.47606, -0.36031>, <-0.207904, -0.649444, 0.731436>, <-0.0231914, 5.49783, -0.342623> , <-0.101674, -0.493137, 0.86399> }
	smooth_triangle { <-0.0384923, 5.47606, -0.36031>, <-0.207904, -0.649444, 0.731436>, <-0.0317579, 5.504, -0.340376>, <-0.136036, -0.470048, 0.872095>, <-0.0533962, 5.4868, -0.356399> , <-0.294062, -0.587279, 0.754076> }
	smooth_triangle { <-0.0712293, 5.47553, -0.377578>, <-0.442391, -0.682545, 0.581741>, <-0.0384923, 5.47606, -0.36031>, <-0.207904, -0.649444, 0.731436>, <-0.0533962, 5.4868, -0.356399> , <-0.294062, -0.587279, 0.754076> }
	smooth_triangle { <-0.0384923, 5.47606, -0.36031>, <-0.207904, -0.649444, 0.731436>, <-0.0712293, 5.47553, -0.377578>, <-0.442391, -0.682545, 0.581741>, <-0.0511013, 5.46102, -0.382857> , <-0.312874, -0.775925, 0.547769> }
	smooth_triangle { <-0.0858195, 5.46888, -0.401955>, <-0.55996, -0.735046, 0.382298>, <-0.0511013, 5.46102, -0.382857>, <-0.312874, -0.775925, 0.547769>, <-0.0712293, 5.47553, -0.377578> , <-0.442391, -0.682545, 0.581741> }
	smooth_triangle { <-0.0511013, 5.46102, -0.382857>, <-0.312874, -0.775925, 0.547769>, <-0.0858195, 5.46888, -0.401955>, <-0.55996, -0.735046, 0.382298>, <-0.0614184, 5.45129, -0.408358> , <-0.395954, -0.853304, 0.339252> }
	smooth_triangle { <-0.0971672, 5.46763, -0.431689>, <-0.633146, -0.747252, 0.201845>, <-0.0614184, 5.45129, -0.408358>, <-0.395954, -0.853304, 0.339252>, <-0.0858195, 5.46888, -0.401955> , <-0.55996, -0.735046, 0.382298> }
	smooth_triangle { <-0.0614184, 5.45129, -0.408358>, <-0.395954, -0.853304, 0.339252>, <-0.0971672, 5.46763, -0.431689>, <-0.633146, -0.747252, 0.201845>, <-0.0694427, 5.44764, -0.438965> , <-0.4477, -0.880964, 0.153191> }
	smooth_triangle { <-0.105273, 5.46942, -0.460314>, <-0.678627, -0.733789, 0.0319196>, <-0.0694427, 5.44764, -0.438965>, <-0.4477, -0.880964, 0.153191>, <-0.0971672, 5.46763, -0.431689> , <-0.633146, -0.747252, 0.201845> }
	smooth_triangle { <-0.0694427, 5.44764, -0.438965>, <-0.4477, -0.880964, 0.153191>, <-0.105273, 5.46942, -0.460314>, <-0.678627, -0.733789, 0.0319196>, <-0.0751739, 5.44772, -0.468213> , <-0.479861, -0.877111, -0.0202546> }
	smooth_triangle { <-0.110137, 5.47818, -0.498601>, <-0.698777, -0.708976, -0.0952048>, <-0.0751739, 5.44772, -0.468213>, <-0.479861, -0.877111, -0.0202546>, <-0.105273, 5.46942, -0.460314> , <-0.678627, -0.733789, 0.0319196> }
	smooth_triangle { <-0.0751739, 5.44772, -0.468213>, <-0.479861, -0.877111, -0.0202546>, <-0.110137, 5.47818, -0.498601>, <-0.698777, -0.708976, -0.0952048>, <-0.0786132, 5.45545, -0.506874> , <-0.494113, -0.856549, -0.148919> }
	smooth_triangle { <-0.113379, 5.4869, -0.532027>, <-0.707062, -0.668169, -0.231545>, <-0.0786132, 5.45545, -0.506874>, <-0.494113, -0.856549, -0.148919>, <-0.110137, 5.47818, -0.498601> , <-0.698777, -0.708976, -0.0952048> }
	smooth_triangle { <-0.0786132, 5.45545, -0.506874>, <-0.494113, -0.856549, -0.148919>, <-0.113379, 5.4869, -0.532027>, <-0.707062, -0.668169, -0.231545>, <-0.0809063, 5.46348, -0.540549> , <-0.499967, -0.817494, -0.285896> }
	smooth_triangle { <-0.110137, 5.50406, -0.569696>, <-0.692855, -0.582761, -0.424667>, <-0.0809063, 5.46348, -0.540549>, <-0.499967, -0.817494, -0.285896>, <-0.113379, 5.4869, -0.532027> , <-0.707062, -0.668169, -0.231545> }
	smooth_triangle { <-0.0809063, 5.46348, -0.540549>, <-0.499967, -0.817494, -0.285896>, <-0.110137, 5.50406, -0.569696>, <-0.692855, -0.582761, -0.424667>, <-0.0786132, 5.48133, -0.577968> , <-0.489926, -0.729088, -0.477916> }
	smooth_triangle { <-0.105273, 5.51647, -0.589577>, <-0.660781, -0.502106, -0.557905>, <-0.0786132, 5.48133, -0.577968>, <-0.489926, -0.729088, -0.477916>, <-0.110137, 5.50406, -0.569696> , <-0.692855, -0.582761, -0.424667> }
	smooth_triangle { <-0.0786132, 5.48133, -0.577968>, <-0.489926, -0.729088, -0.477916>, <-0.105273, 5.51647, -0.589577>, <-0.660781, -0.502106, -0.557905>, <-0.0751739, 5.49477, -0.597476> , <-0.472046, -0.655523, -0.589459> }
	smooth_triangle { <-0.0751739, 5.49477, -0.597476>, <-0.472046, -0.655523, -0.589459>, <-0.0955455, 5.53737, -0.618563>, <-0.679937, -0.459229, -0.571659>, <-0.0682965, 5.51772, -0.625716> , <-0.456747, -0.60981, -0.6477> }
	smooth_triangle { <-0.0955455, 5.53737, -0.618563>, <-0.679937, -0.459229, -0.571659>, <-0.0751739, 5.49477, -0.597476>, <-0.472046, -0.655523, -0.589459>, <-0.105273, 5.51647, -0.589577> , <-0.660781, -0.502106, -0.557905> }
	smooth_triangle { <-0.0682965, 5.51772, -0.625716>, <-0.456747, -0.60981, -0.6477>, <-0.0858195, 5.57068, -0.649741>, <-0.718446, -0.476137, -0.507078>, <-0.0614184, 5.54068, -0.653957> , <-0.498796, -0.596658, -0.628651> }
	smooth_triangle { <-0.0858195, 5.57068, -0.649741>, <-0.718446, -0.476137, -0.507078>, <-0.0682965, 5.51772, -0.625716>, <-0.456747, -0.60981, -0.6477>, <-0.0955455, 5.53737, -0.618563> , <-0.679937, -0.459229, -0.571659> }
	smooth_triangle { <-0.0476629, 5.56483, -0.684423>, <-0.547411, -0.600335, -0.583043>, <-0.0858195, 5.57068, -0.649741>, <-0.718446, -0.476137, -0.507078>, <-0.0663655, 5.56883, -0.677843> , <-0.718361, -0.519205, -0.463016> }
	smooth_triangle { <-0.0858195, 5.57068, -0.649741>, <-0.718446, -0.476137, -0.507078>, <-0.0476629, 5.56483, -0.684423>, <-0.547411, -0.600335, -0.583043>, <-0.0614184, 5.54068, -0.653957> , <-0.498796, -0.596658, -0.62865> }
	smooth_triangle { <-0.00278627, 5.52987, -0.326404>, <-0.0811436, -0.408955, 0.90894>, <-0.0317579, 5.504, -0.340376>, <-0.136036, -0.470048, 0.872095>, <-0.00273549, 5.52981, -0.326429> , <-0.0678812, -0.417935, 0.905937> }
	smooth_triangle { <-0.0317579, 5.504, -0.340376>, <-0.136036, -0.470048, 0.872095>, <-0.00278627, 5.52987, -0.326404>, <-0.0811436, -0.408955, 0.90894>, <-0.0383307, 5.51205, -0.337451> , <-0.165545, -0.437552, 0.883823> }
	smooth_triangle { <-0.0383307, 5.51205, -0.337451>, <-0.165545, -0.437552, 0.883823>, <-0.0533962, 5.4868, -0.356399>, <-0.294062, -0.587279, 0.754076>, <-0.0317579, 5.504, -0.340376> , <-0.136036, -0.470048, 0.872095> }
	smooth_triangle { <-0.0533962, 5.4868, -0.356399>, <-0.294062, -0.587279, 0.754076>, <-0.0383307, 5.51205, -0.337451>, <-0.165545, -0.437552, 0.883823>, <-0.0648331, 5.50081, -0.351295> , <-0.360068, -0.506411, 0.783517> }
	smooth_triangle { <-0.0648331, 5.50081, -0.351295>, <-0.360068, -0.506411, 0.783517>, <-0.0712293, 5.47553, -0.377578>, <-0.442391, -0.682545, 0.581741>, <-0.0533962, 5.4868, -0.356399> , <-0.294062, -0.587279, 0.754076> }
	smooth_triangle { <-0.0712293, 5.47553, -0.377578>, <-0.442391, -0.682545, 0.581741>, <-0.0648331, 5.50081, -0.351295>, <-0.360068, -0.506411, 0.783517>, <-0.0866732, 5.49445, -0.370694> , <-0.541809, -0.560821, 0.626038> }
	smooth_triangle { <-0.104543, 5.49181, -0.393611>, <-0.685811, -0.580946, 0.438366>, <-0.0712293, 5.47553, -0.377578>, <-0.442391, -0.682545, 0.581741>, <-0.0866732, 5.49445, -0.370694> , <-0.541809, -0.560821, 0.626038> }
	smooth_triangle { <-0.0712293, 5.47553, -0.377578>, <-0.442391, -0.682545, 0.581741>, <-0.104543, 5.49181, -0.393611>, <-0.685811, -0.580946, 0.438366>, <-0.0858195, 5.46888, -0.401955> , <-0.55996, -0.735046, 0.382298> }
	smooth_triangle { <-0.11844, 5.49368, -0.422207>, <-0.775442, -0.572995, 0.265268>, <-0.0858195, 5.46888, -0.401955>, <-0.55996, -0.735046, 0.382298>, <-0.104543, 5.49181, -0.393611> , <-0.685811, -0.580946, 0.438366> }
	smooth_triangle { <-0.0858195, 5.46888, -0.401955>, <-0.55996, -0.735046, 0.382298>, <-0.11844, 5.49368, -0.422207>, <-0.775442, -0.572995, 0.265268>, <-0.0971672, 5.46763, -0.431689> , <-0.633146, -0.747252, 0.201845> }
	smooth_triangle { <-0.105273, 5.46942, -0.460314>, <-0.678627, -0.733789, 0.0319196>, <-0.11844, 5.49368, -0.422207>, <-0.775442, -0.572995, 0.265268>, <-0.128368, 5.49771, -0.45002> , <-0.831139, -0.547018, 0.0998958> }
	smooth_triangle { <-0.11844, 5.49368, -0.422207>, <-0.775442, -0.572995, 0.265268>, <-0.105273, 5.46942, -0.460314>, <-0.678627, -0.733789, 0.0319196>, <-0.0971672, 5.46763, -0.431689> , <-0.633146, -0.747252, 0.201845> }
	smooth_triangle { <-0.110137, 5.47818, -0.498601>, <-0.698777, -0.708976, -0.0952048>, <-0.128368, 5.49771, -0.45002>, <-0.831139, -0.547018, 0.0998958>, <-0.134325, 5.5078, -0.487819> , <-0.855828, -0.516645, -0.0252155> }
	smooth_triangle { <-0.128368, 5.49771, -0.45002>, <-0.831139, -0.547018, 0.0998958>, <-0.110137, 5.47818, -0.498601>, <-0.698777, -0.708976, -0.0952048>, <-0.105273, 5.46942, -0.460314> , <-0.678627, -0.733789, 0.0319196> }
	smooth_triangle { <-0.113379, 5.4869, -0.532027>, <-0.707062, -0.668169, -0.231545>, <-0.134325, 5.5078, -0.487819>, <-0.855828, -0.516645, -0.0252155>, <-0.138297, 5.51741, -0.52092> , <-0.86598, -0.473552, -0.160709> }
	smooth_triangle { <-0.134325, 5.5078, -0.487819>, <-0.855828, -0.516645, -0.0252155>, <-0.113379, 5.4869, -0.532027>, <-0.707062, -0.668169, -0.231545>, <-0.110137, 5.47818, -0.498601> , <-0.698777, -0.708976, -0.0952048> }
	smooth_triangle { <-0.110137, 5.50406, -0.569696>, <-0.692855, -0.582761, -0.424667>, <-0.138297, 5.51741, -0.52092>, <-0.86598, -0.473552, -0.160709>, <-0.134325, 5.53368, -0.558914> , <-0.846287, -0.387443, -0.365632> }
	smooth_triangle { <-0.138297, 5.51741, -0.52092>, <-0.86598, -0.473552, -0.160709>, <-0.110137, 5.50406, -0.569696>, <-0.692855, -0.582761, -0.424667>, <-0.113379, 5.4869, -0.532027> , <-0.707062, -0.668169, -0.231545> }
	smooth_triangle { <-0.105273, 5.51647, -0.589577>, <-0.660781, -0.502106, -0.557905>, <-0.134325, 5.53368, -0.558914>, <-0.846287, -0.387443, -0.365632>, <-0.128368, 5.54475, -0.579282> , <-0.816422, -0.314901, -0.484037> }
	smooth_triangle { <-0.134325, 5.53368, -0.558914>, <-0.846287, -0.387443, -0.365632>, <-0.105273, 5.51647, -0.589577>, <-0.660781, -0.502106, -0.557905>, <-0.110137, 5.50406, -0.569696> , <-0.692855, -0.582761, -0.424667> }
	smooth_triangle { <-0.0955455, 5.53737, -0.618563>, <-0.679937, -0.459229, -0.571659>, <-0.128368, 5.54475, -0.579282>, <-0.816422, -0.314901, -0.484037>, <-0.116456, 5.57758, -0.61182> , <-0.828944, -0.323347, -0.456398> }
	smooth_triangle { <-0.128368, 5.54475, -0.579282>, <-0.816422, -0.314901, -0.484037>, <-0.0955455, 5.53737, -0.618563>, <-0.679937, -0.459229, -0.571659>, <-0.105273, 5.51647, -0.589577> , <-0.660781, -0.502106, -0.557905> }
	smooth_triangle { <-0.0858195, 5.57068, -0.649741>, <-0.718446, -0.476137, -0.507078>, <-0.116456, 5.57758, -0.61182>, <-0.828944, -0.323347, -0.456398>, <-0.104543, 5.5739, -0.637921> , <-0.857363, -0.389477, -0.336508> }
	smooth_triangle { <-0.116456, 5.57758, -0.61182>, <-0.828944, -0.323347, -0.456398>, <-0.0858195, 5.57068, -0.649741>, <-0.718446, -0.476137, -0.507078>, <-0.0955455, 5.53737, -0.618563> , <-0.679937, -0.459229, -0.571659> }
	smooth_triangle { <-0.00281834, 5.52994, -0.326376>, <-0.097083, -0.34743, 0.932667>, <-0.0383307, 5.51205, -0.337451>, <-0.165545, -0.437552, 0.883823>, <-0.00278627, 5.52987, -0.326404> , <-0.0811436, -0.408955, 0.90894> }
	smooth_triangle { <-0.0383307, 5.51205, -0.337451>, <-0.165545, -0.437552, 0.883823>, <-0.00281834, 5.52994, -0.326376>, <-0.097083, -0.34743, 0.932667>, <-0.0424634, 5.52143, -0.334036> , <-0.188095, -0.37432, 0.908022> }
	smooth_triangle { <-0.0424634, 5.52143, -0.334036>, <-0.188095, -0.37432, 0.908022>, <-0.0648331, 5.50081, -0.351295>, <-0.360068, -0.506411, 0.783517>, <-0.0383307, 5.51205, -0.337451> , <-0.165545, -0.437552, 0.883823> }
	smooth_triangle { <-0.0648331, 5.50081, -0.351295>, <-0.360068, -0.506411, 0.783517>, <-0.0424634, 5.52143, -0.334036>, <-0.188095, -0.37432, 0.908022>, <-0.0720224, 5.51712, -0.345361> , <-0.401594, -0.412246, 0.817787> }
	smooth_triangle { <-0.0720224, 5.51712, -0.345361>, <-0.401594, -0.412246, 0.817787>, <-0.0866732, 5.49445, -0.370694>, <-0.541809, -0.560821, 0.626038>, <-0.0648331, 5.50081, -0.351295> , <-0.360068, -0.506411, 0.783517> }
	smooth_triangle { <-0.0866732, 5.49445, -0.370694>, <-0.541809, -0.560821, 0.626038>, <-0.0720224, 5.51712, -0.345361>, <-0.401594, -0.412246, 0.817787>, <-0.0963819, 5.51648, -0.362671> , <-0.604341, -0.418982, 0.677662> }
	smooth_triangle { <-0.116313, 5.51851, -0.383892>, <-0.764934, -0.40146, 0.503691>, <-0.0866732, 5.49445, -0.370694>, <-0.541809, -0.560821, 0.626038>, <-0.0963819, 5.51648, -0.362671> , <-0.604341, -0.418982, 0.677662> }
	smooth_triangle { <-0.0866732, 5.49445, -0.370694>, <-0.541809, -0.560821, 0.626038>, <-0.116313, 5.51851, -0.383892>, <-0.764934, -0.40146, 0.503691>, <-0.104543, 5.49181, -0.393611> , <-0.685811, -0.580946, 0.438365> }
	smooth_triangle { <-0.11844, 5.49368, -0.422207>, <-0.775442, -0.572995, 0.265268>, <-0.116313, 5.51851, -0.383892>, <-0.764934, -0.40146, 0.503691>, <-0.131814, 5.52402, -0.411164> , <-0.864884, -0.370065, 0.339156> }
	smooth_triangle { <-0.116313, 5.51851, -0.383892>, <-0.764934, -0.40146, 0.503691>, <-0.11844, 5.49368, -0.422207>, <-0.775442, -0.572995, 0.265268>, <-0.104543, 5.49181, -0.393611> , <-0.685811, -0.580946, 0.438366> }
	smooth_triangle { <-0.128368, 5.49771, -0.45002>, <-0.831139, -0.547018, 0.0998958>, <-0.131814, 5.52402, -0.411164>, <-0.864884, -0.370065, 0.339156>, <-0.142888, 5.53064, -0.438031> , <-0.927013, -0.329525, 0.179052> }
	smooth_triangle { <-0.131814, 5.52402, -0.411164>, <-0.864884, -0.370065, 0.339156>, <-0.128368, 5.49771, -0.45002>, <-0.831139, -0.547018, 0.0998958>, <-0.11844, 5.49368, -0.422207> , <-0.775442, -0.572995, 0.265268> }
	smooth_triangle { <-0.134325, 5.5078, -0.487819>, <-0.855828, -0.516645, -0.0252155>, <-0.142888, 5.53064, -0.438031>, <-0.927013, -0.329525, 0.179052>, <-0.14953, 5.5423, -0.475264> , <-0.955828, -0.289952, 0.0481623> }
	smooth_triangle { <-0.142888, 5.53064, -0.438031>, <-0.927013, -0.329525, 0.179052>, <-0.134325, 5.5078, -0.487819>, <-0.855828, -0.516645, -0.0252155>, <-0.128368, 5.49771, -0.45002> , <-0.831139, -0.547018, 0.0998958> }
	smooth_triangle { <-0.138297, 5.51741, -0.52092>, <-0.86598, -0.473552, -0.160709>, <-0.14953, 5.5423, -0.475264>, <-0.955828, -0.289952, 0.0481623>, <-0.153959, 5.55295, -0.507987> , <-0.96668, -0.243872, -0.0778183> }
	smooth_triangle { <-0.14953, 5.5423, -0.475264>, <-0.955828, -0.289952, 0.0481623>, <-0.138297, 5.51741, -0.52092>, <-0.86598, -0.473552, -0.160709>, <-0.134325, 5.5078, -0.487819> , <-0.855828, -0.516645, -0.0252155> }
	smooth_triangle { <-0.134325, 5.53368, -0.558914>, <-0.846287, -0.387443, -0.365632>, <-0.153959, 5.55295, -0.507987>, <-0.96668, -0.243872, -0.0778183>, <-0.14953, 5.56817, -0.546359> , <-0.946316, -0.156697, -0.282721> }
	smooth_triangle { <-0.153959, 5.55295, -0.507987>, <-0.96668, -0.243872, -0.0778183>, <-0.134325, 5.53368, -0.558914>, <-0.846287, -0.387443, -0.365632>, <-0.138297, 5.51741, -0.52092> , <-0.86598, -0.473552, -0.160709> }
	smooth_triangle { <-0.128368, 5.54475, -0.579282>, <-0.816422, -0.314901, -0.484037>, <-0.14953, 5.56817, -0.546359>, <-0.946316, -0.156697, -0.282721>, <-0.142888, 5.58499, -0.568581> , <-0.908895, -0.143312, -0.391626> }
	smooth_triangle { <-0.14953, 5.56817, -0.546359>, <-0.946316, -0.156697, -0.282721>, <-0.128368, 5.54475, -0.579282>, <-0.816422, -0.314901, -0.484037>, <-0.134325, 5.53368, -0.558914> , <-0.846287, -0.387443, -0.365632> }
	smooth_triangle { <-0.116456, 5.57758, -0.61182>, <-0.828944, -0.323347, -0.456398>, <-0.142888, 5.58499, -0.568581>, <-0.908895, -0.143312, -0.391626>, <-0.1296, 5.58185, -0.596461> , <-0.890793, -0.214984, -0.400337> }
	smooth_triangle { <-0.142888, 5.58499, -0.568581>, <-0.908895, -0.143312, -0.391626>, <-0.116456, 5.57758, -0.61182>, <-0.828944, -0.323347, -0.456398>, <-0.128368, 5.54475, -0.579282> , <-0.816422, -0.314901, -0.484037> }
	smooth_triangle { <-0.00282904, 5.53002, -0.326353>, <-0.106174, -0.319339, 0.941674>, <-0.0424634, 5.52143, -0.334036>, <-0.188095, -0.37432, 0.908022>, <-0.00281834, 5.52994, -0.326376> , <-0.097083, -0.34743, 0.932667> }
	smooth_triangle { <-0.0424634, 5.52143, -0.334036>, <-0.188095, -0.37432, 0.908022>, <-0.00282904, 5.53002, -0.326353>, <-0.106174, -0.319339, 0.941674>, <-0.0438727, 5.53149, -0.330373> , <-0.197438, -0.324875, 0.924919> }
	smooth_triangle { <-0.0438727, 5.53149, -0.330373>, <-0.197438, -0.324875, 0.924919>, <-0.0720224, 5.51712, -0.345361>, <-0.401594, -0.412246, 0.817787>, <-0.0424634, 5.52143, -0.334036> , <-0.188095, -0.37432, 0.908022> }
	smooth_triangle { <-0.0720224, 5.51712, -0.345361>, <-0.401594, -0.412246, 0.817787>, <-0.0438727, 5.53149, -0.330373>, <-0.197438, -0.324875, 0.924919>, <-0.0744743, 5.53462, -0.33899> , <-0.415784, -0.31102, 0.854629> }
	smooth_triangle { <-0.0744743, 5.53462, -0.33899>, <-0.415784, -0.31102, 0.854629>, <-0.0963819, 5.51648, -0.362671>, <-0.604341, -0.418983, 0.677662>, <-0.0720224, 5.51712, -0.345361> , <-0.401594, -0.412246, 0.817787> }
	smooth_triangle { <-0.0963819, 5.51648, -0.362671>, <-0.604341, -0.418983, 0.677662>, <-0.0744743, 5.53462, -0.33899>, <-0.415784, -0.31102, 0.854629>, <-0.099693, 5.54011, -0.354071> , <-0.625657, -0.266756, 0.733072> }
	smooth_triangle { <-0.116313, 5.51851, -0.383892>, <-0.764934, -0.401461, 0.503691>, <-0.099693, 5.54011, -0.354071>, <-0.625657, -0.266756, 0.733072>, <-0.120328, 5.54717, -0.373465> , <-0.791901, -0.208824, 0.573833> }
	smooth_triangle { <-0.099693, 5.54011, -0.354071>, <-0.625657, -0.266756, 0.733072>, <-0.116313, 5.51851, -0.383892>, <-0.764934, -0.401461, 0.503691>, <-0.0963819, 5.51648, -0.362671> , <-0.604341, -0.418982, 0.677662> }
	smooth_triangle { <-0.131814, 5.52402, -0.411164>, <-0.864884, -0.370065, 0.339156>, <-0.120328, 5.54717, -0.373465>, <-0.791901, -0.208824, 0.573833>, <-0.136376, 5.55658, -0.399313> , <-0.898409, -0.149896, 0.412787> }
	smooth_triangle { <-0.120328, 5.54717, -0.373465>, <-0.791901, -0.208824, 0.573833>, <-0.131814, 5.52402, -0.411164>, <-0.864884, -0.370065, 0.339156>, <-0.116313, 5.51851, -0.383892> , <-0.764934, -0.401461, 0.503691> }
	smooth_triangle { <-0.142888, 5.53064, -0.438031>, <-0.927013, -0.329525, 0.179052>, <-0.136376, 5.55658, -0.399313>, <-0.898409, -0.149896, 0.412787>, <-0.14784, 5.56599, -0.425167> , <-0.962577, -0.09409, 0.254149> }
	smooth_triangle { <-0.136376, 5.55658, -0.399313>, <-0.898409, -0.149896, 0.412787>, <-0.142888, 5.53064, -0.438031>, <-0.927013, -0.329525, 0.179052>, <-0.131814, 5.52402, -0.411164> , <-0.864884, -0.370065, 0.339156> }
	smooth_triangle { <-0.14953, 5.5423, -0.475264>, <-0.955828, -0.289952, 0.0481623>, <-0.14784, 5.56599, -0.425167>, <-0.962577, -0.09409, 0.254149>, <-0.154717, 5.57932, -0.46179> , <-0.991603, -0.0407995, 0.122711> }
	smooth_triangle { <-0.14784, 5.56599, -0.425167>, <-0.962577, -0.09409, 0.254149>, <-0.14953, 5.5423, -0.475264>, <-0.955828, -0.289952, 0.0481623>, <-0.142888, 5.53064, -0.438031> , <-0.927013, -0.329525, 0.179052> }
	smooth_triangle { <-0.153959, 5.55295, -0.507987>, <-0.96668, -0.243872, -0.0778183>, <-0.154717, 5.57932, -0.46179>, <-0.991603, -0.0407995, 0.122711>, <-0.159303, 5.59838, -0.495393> , <-0.998859, -0.0426651, 0.0214388> }
	smooth_triangle { <-0.154717, 5.57932, -0.46179>, <-0.991603, -0.0407995, 0.122711>, <-0.153959, 5.55295, -0.507987>, <-0.96668, -0.243872, -0.0778183>, <-0.14953, 5.5423, -0.475264> , <-0.955828, -0.289952, 0.0481623> }
	smooth_triangle { <-0.14953, 5.56817, -0.546359>, <-0.946316, -0.156697, -0.282721>, <-0.159303, 5.59838, -0.495393>, <-0.998859, -0.0426651, 0.0214388>, <-0.154717, 5.59206, -0.530569> , <-0.973704, -0.0350028, -0.225112> }
	smooth_triangle { <-0.159303, 5.59838, -0.495393>, <-0.998859, -0.0426651, 0.0214388>, <-0.14953, 5.56817, -0.546359>, <-0.946316, -0.156697, -0.282721>, <-0.153959, 5.55295, -0.507987> , <-0.96668, -0.243872, -0.0778183> }
	smooth_triangle { <-0.142888, 5.58499, -0.568581>, <-0.908895, -0.143312, -0.391626>, <-0.154717, 5.59206, -0.530569>, <-0.973704, -0.0350028, -0.225112>, <-0.14784, 5.58895, -0.550182> , <-0.942794, 0.0154148, -0.33302> }
	smooth_triangle { <-0.154717, 5.59206, -0.530569>, <-0.973704, -0.0350028, -0.225112>, <-0.142888, 5.58499, -0.568581>, <-0.908895, -0.143312, -0.391626>, <-0.14953, 5.56817, -0.546359> , <-0.946316, -0.156697, -0.282721> }
	smooth_triangle { <-0.0424634, 5.54155, -0.326714>, <-0.192875, -0.295336, 0.935722>, <-0.00282904, 5.53002, -0.326353>, <-0.106174, -0.319339, 0.941674>, <-0.00281834, 5.5301, -0.326323> , <-0.106863, -0.330352, 0.937789> }
	smooth_triangle { <-0.00282904, 5.53002, -0.326353>, <-0.106174, -0.319339, 0.941674>, <-0.0424634, 5.54155, -0.326714>, <-0.192875, -0.295336, 0.935722>, <-0.0438727, 5.53149, -0.330373> , <-0.197438, -0.324875, 0.924919> }
	smooth_triangle { <-0.0720224, 5.55213, -0.332622>, <-0.401617, -0.209872, 0.891435>, <-0.0438727, 5.53149, -0.330373>, <-0.197438, -0.324875, 0.924919>, <-0.0424634, 5.54155, -0.326714> , <-0.192875, -0.295336, 0.935722> }
	smooth_triangle { <-0.0438727, 5.53149, -0.330373>, <-0.197438, -0.324875, 0.924919>, <-0.0720224, 5.55213, -0.332622>, <-0.401617, -0.209872, 0.891435>, <-0.0744743, 5.53462, -0.33899> , <-0.415784, -0.31102, 0.854629> }
	smooth_triangle { <-0.0963819, 5.56375, -0.345471>, <-0.604329, -0.114614, 0.788448>, <-0.0744743, 5.53462, -0.33899>, <-0.415784, -0.31102, 0.854629>, <-0.0720224, 5.55213, -0.332622> , <-0.401617, -0.209872, 0.891435> }
	smooth_triangle { <-0.0744743, 5.53462, -0.33899>, <-0.415784, -0.31102, 0.854629>, <-0.0963819, 5.56375, -0.345471>, <-0.604329, -0.114614, 0.788448>, <-0.099693, 5.54011, -0.354071> , <-0.625657, -0.266756, 0.733072> }
	smooth_triangle { <-0.120328, 5.54717, -0.373465>, <-0.791901, -0.208824, 0.573833>, <-0.0963819, 5.56375, -0.345471>, <-0.604329, -0.114614, 0.788448>, <-0.116313, 5.57582, -0.363033> , <-0.764922, -0.0162429, 0.643918> }
	smooth_triangle { <-0.0963819, 5.56375, -0.345471>, <-0.604329, -0.114614, 0.788448>, <-0.120328, 5.54717, -0.373465>, <-0.791901, -0.208824, 0.573833>, <-0.099693, 5.54011, -0.354071> , <-0.625657, -0.266756, 0.733072> }
	smooth_triangle { <-0.136376, 5.55658, -0.399313>, <-0.898409, -0.149896, 0.412787>, <-0.116313, 5.57582, -0.363033>, <-0.764922, -0.0162429, 0.643918>, <-0.131814, 5.58914, -0.387462> , <-0.879938, 0.0816455, 0.468021> }
	smooth_triangle { <-0.116313, 5.57582, -0.363033>, <-0.764922, -0.0162429, 0.643918>, <-0.136376, 5.55658, -0.399313>, <-0.898409, -0.149896, 0.412787>, <-0.120328, 5.54717, -0.373465> , <-0.791902, -0.208824, 0.573833> }
	smooth_triangle { <-0.14784, 5.56599, -0.425167>, <-0.962577, -0.09409, 0.254149>, <-0.131814, 5.58914, -0.387462>, <-0.879938, 0.0816455, 0.468021>, <-0.142888, 5.61228, -0.414234> , <-0.942188, 0.103484, 0.318704> }
	smooth_triangle { <-0.131814, 5.58914, -0.387462>, <-0.879938, 0.0816455, 0.468021>, <-0.14784, 5.56599, -0.425167>, <-0.962577, -0.09409, 0.254149>, <-0.136376, 5.55658, -0.399313> , <-0.898409, -0.149896, 0.412787> }
	smooth_triangle { <-0.154717, 5.57932, -0.46179>, <-0.991603, -0.0407995, 0.122711>, <-0.142888, 5.61228, -0.414234>, <-0.942188, 0.103484, 0.318704>, <-0.14953, 5.60685, -0.446643> , <-0.98315, 0.0867586, 0.160898> }
	smooth_triangle { <-0.142888, 5.61228, -0.414234>, <-0.942188, 0.103484, 0.318704>, <-0.154717, 5.57932, -0.46179>, <-0.991603, -0.0407995, 0.122711>, <-0.14784, 5.56599, -0.425167> , <-0.962577, -0.09409, 0.254149> }
	smooth_triangle { <-0.153959, 5.60148, -0.475337>, <-0.984883, 0.113625, 0.130747>, <-0.154717, 5.57932, -0.46179>, <-0.991603, -0.0407995, 0.122711>, <-0.14953, 5.60685, -0.446643> , <-0.98315, 0.0867586, 0.160898> }
	smooth_triangle { <-0.154717, 5.57932, -0.46179>, <-0.991603, -0.0407995, 0.122711>, <-0.153959, 5.60148, -0.475337>, <-0.984883, 0.113625, 0.130747>, <-0.159303, 5.59838, -0.495393> , <-0.998859, -0.0426651, 0.0214388> }
	smooth_triangle { <-0.0383307, 5.55092, -0.323301>, <-0.171427, -0.245954, 0.954002>, <-0.00281834, 5.5301, -0.326323>, <-0.106863, -0.330352, 0.937789>, <-0.00278627, 5.53017, -0.326295> , <-0.0928038, -0.297, 0.950357> }
	smooth_triangle { <-0.00281834, 5.5301, -0.326323>, <-0.106863, -0.330352, 0.937789>, <-0.0383307, 5.55092, -0.323301>, <-0.171427, -0.245954, 0.954002>, <-0.0424634, 5.54155, -0.326714> , <-0.192875, -0.295336, 0.935722> }
	smooth_triangle { <-0.0648331, 5.56843, -0.326686>, <-0.360038, -0.115682, 0.925738>, <-0.0424634, 5.54155, -0.326714>, <-0.192875, -0.295336, 0.935722>, <-0.0383307, 5.55092, -0.323301> , <-0.171427, -0.245954, 0.954002> }
	smooth_triangle { <-0.0424634, 5.54155, -0.326714>, <-0.192875, -0.295336, 0.935722>, <-0.0648331, 5.56843, -0.326686>, <-0.360038, -0.115682, 0.925738>, <-0.0720224, 5.55213, -0.332622> , <-0.401617, -0.209872, 0.891435> }
	smooth_triangle { <-0.0866732, 5.58577, -0.337453>, <-0.541829, 0.0271461, 0.840051>, <-0.0720224, 5.55213, -0.332622>, <-0.401617, -0.209872, 0.891435>, <-0.0648331, 5.56843, -0.326686> , <-0.360038, -0.115682, 0.925738> }
	smooth_triangle { <-0.0720224, 5.55213, -0.332622>, <-0.401617, -0.209872, 0.891435>, <-0.0866732, 5.58577, -0.337453>, <-0.541829, 0.0271461, 0.840051>, <-0.0963819, 5.56375, -0.345471> , <-0.604329, -0.114614, 0.788448> }
	smooth_triangle { <-0.104543, 5.60252, -0.353316>, <-0.724489, 0.211065, 0.656176>, <-0.0963819, 5.56375, -0.345471>, <-0.604329, -0.114614, 0.788448>, <-0.0866732, 5.58577, -0.337453> , <-0.541829, 0.0271461, 0.840051> }
	smooth_triangle { <-0.0963819, 5.56375, -0.345471>, <-0.604329, -0.114614, 0.788448>, <-0.104543, 5.60252, -0.353316>, <-0.724489, 0.211065, 0.656176>, <-0.116313, 5.57582, -0.363033> , <-0.764922, -0.0162429, 0.643918> }
	smooth_triangle { <-0.131814, 5.58914, -0.387462>, <-0.879938, 0.0816455, 0.468021>, <-0.104543, 5.60252, -0.353316>, <-0.724489, 0.211065, 0.656176>, <-0.11844, 5.61947, -0.376423> , <-0.836718, 0.30164, 0.457074> }
	smooth_triangle { <-0.104543, 5.60252, -0.353316>, <-0.724489, 0.211065, 0.656176>, <-0.131814, 5.58914, -0.387462>, <-0.879938, 0.0816455, 0.468021>, <-0.116313, 5.57582, -0.363033> , <-0.764922, -0.0162429, 0.643918> }
	smooth_triangle { <-0.128368, 5.61529, -0.396968>, <-0.889981, 0.25471, 0.378228>, <-0.131814, 5.58914, -0.387462>, <-0.879938, 0.0816455, 0.468021>, <-0.11844, 5.61947, -0.376423> , <-0.836718, 0.30164, 0.457074> }
	smooth_triangle { <-0.131814, 5.58914, -0.387462>, <-0.879938, 0.0816455, 0.468021>, <-0.128368, 5.61529, -0.396968>, <-0.889981, 0.25471, 0.378228>, <-0.142888, 5.61228, -0.414234> , <-0.942188, 0.103484, 0.318704> }
	smooth_triangle { <-0.0317579, 5.55897, -0.320373>, <-0.134417, -0.202383, 0.970038>, <-0.00278627, 5.53017, -0.326295>, <-0.0928038, -0.297, 0.950357>, <-0.00273549, 5.53023, -0.326273> , <-0.0646716, -0.266031, 0.961793> }
	smooth_triangle { <-0.00278627, 5.53017, -0.326295>, <-0.0928038, -0.297, 0.950357>, <-0.0317579, 5.55897, -0.320373>, <-0.134417, -0.202383, 0.970038>, <-0.0383307, 5.55092, -0.323301> , <-0.171427, -0.245954, 0.954002> }
	smooth_triangle { <-0.0533962, 5.58244, -0.32159>, <-0.295759, -0.0322651, 0.954718>, <-0.0383307, 5.55092, -0.323301>, <-0.171427, -0.245954, 0.954002>, <-0.0317579, 5.55897, -0.320373> , <-0.134417, -0.202383, 0.970038> }
	smooth_triangle { <-0.0383307, 5.55092, -0.323301>, <-0.171427, -0.245954, 0.954002>, <-0.0533962, 5.58244, -0.32159>, <-0.295759, -0.0322651, 0.954718>, <-0.0648331, 5.56843, -0.326686> , <-0.360038, -0.115682, 0.925738> }
	smooth_triangle { <-0.0712293, 5.60469, -0.330568>, <-0.502653, 0.191981, 0.842901>, <-0.0648331, 5.56843, -0.326686>, <-0.360038, -0.115682, 0.925738>, <-0.0533962, 5.58244, -0.32159> , <-0.295759, -0.0322651, 0.954718> }
	smooth_triangle { <-0.0648331, 5.56843, -0.326686>, <-0.360038, -0.115682, 0.925738>, <-0.0712293, 5.60469, -0.330568>, <-0.502653, 0.191981, 0.842901>, <-0.0866732, 5.58577, -0.337453> , <-0.541829, 0.0271461, 0.840051> }
	smooth_triangle { <-0.0858195, 5.62545, -0.34497>, <-0.678362, 0.377069, 0.630591>, <-0.0866732, 5.58577, -0.337453>, <-0.541829, 0.0271461, 0.840051>, <-0.0712293, 5.60469, -0.330568> , <-0.502653, 0.191981, 0.842901> }
	smooth_triangle { <-0.0866732, 5.58577, -0.337453>, <-0.541829, 0.0271461, 0.840051>, <-0.0858195, 5.62545, -0.34497>, <-0.678362, 0.377069, 0.630591>, <-0.104543, 5.60252, -0.353316> , <-0.724489, 0.211065, 0.656176> }
	smooth_triangle { <-0.0971672, 5.62144, -0.362693>, <-0.778355, 0.494944, 0.386255>, <-0.104543, 5.60252, -0.353316>, <-0.724489, 0.211065, 0.656176>, <-0.0858195, 5.62545, -0.34497> , <-0.678362, 0.377069, 0.630591> }
	smooth_triangle { <-0.104543, 5.60252, -0.353316>, <-0.724489, 0.211065, 0.656176>, <-0.0971672, 5.62144, -0.362693>, <-0.778355, 0.494944, 0.386255>, <-0.11844, 5.61947, -0.376423> , <-0.836718, 0.30164, 0.457074> }
	smooth_triangle { <-0.0231914, 5.56515, -0.318123>, <-0.0953021, -0.173874, 0.980146>, <-0.00273549, 5.53023, -0.326273>, <-0.0646716, -0.266031, 0.961793>, <-0.00266935, 5.53028, -0.326257> , <-0.0462254, -0.252126, 0.96659> }
	smooth_triangle { <-0.00273549, 5.53023, -0.326273>, <-0.0646716, -0.266031, 0.961793>, <-0.0231914, 5.56515, -0.318123>, <-0.0953021, -0.173874, 0.980146>, <-0.0317579, 5.55897, -0.320373> , <-0.134417, -0.202383, 0.970038> }
	smooth_triangle { <-0.0384923, 5.59319, -0.317675>, <-0.209622, 0.0298461, 0.977327>, <-0.0317579, 5.55897, -0.320373>, <-0.134417, -0.202383, 0.970038>, <-0.0231914, 5.56515, -0.318123> , <-0.0953021, -0.173874, 0.980146> }
	smooth_triangle { <-0.0317579, 5.55897, -0.320373>, <-0.134417, -0.202383, 0.970038>, <-0.0384923, 5.59319, -0.317675>, <-0.209622, 0.0298461, 0.977327>, <-0.0533962, 5.58244, -0.32159> , <-0.295759, -0.0322651, 0.954718> }
	smooth_triangle { <-0.0511013, 5.62848, -0.326922>, <-0.406219, 0.257012, 0.876887>, <-0.0533962, 5.58244, -0.32159>, <-0.295759, -0.0322651, 0.954718>, <-0.0384923, 5.59319, -0.317675> , <-0.209622, 0.0298461, 0.977327> }
	smooth_triangle { <-0.0533962, 5.58244, -0.32159>, <-0.295759, -0.0322651, 0.954718>, <-0.0511013, 5.62848, -0.326922>, <-0.406219, 0.257012, 0.876887>, <-0.0712293, 5.60469, -0.330568> , <-0.502653, 0.191981, 0.842901> }
	smooth_triangle { <-0.0614184, 5.62626, -0.335606>, <-0.632435, 0.436997, 0.639577>, <-0.0712293, 5.60469, -0.330568>, <-0.502653, 0.191981, 0.842901>, <-0.0511013, 5.62848, -0.326922> , <-0.406219, 0.257012, 0.876887> }
	smooth_triangle { <-0.0712293, 5.60469, -0.330568>, <-0.502653, 0.191981, 0.842901>, <-0.0614184, 5.62626, -0.335606>, <-0.632435, 0.436997, 0.639577>, <-0.0858195, 5.62545, -0.34497> , <-0.678362, 0.377069, 0.630591> }
	smooth_triangle { <-0.0132154, 5.56903, -0.31671>, <-0.0549106, -0.157399, 0.986007>, <-0.00266935, 5.53028, -0.326257>, <-0.0462254, -0.252126, 0.96659>, <-0.0025925, 5.53031, -0.326246> , <-0.0351112, -0.246381, 0.968537> }
	smooth_triangle { <-0.00266935, 5.53028, -0.326257>, <-0.0462254, -0.252126, 0.96659>, <-0.0132154, 5.56903, -0.31671>, <-0.0549106, -0.157399, 0.986007>, <-0.0231914, 5.56515, -0.318123> , <-0.0953021, -0.173874, 0.980146> }
	smooth_triangle { <-0.021135, 5.59994, -0.315219>, <-0.107514, 0.0663485, 0.991987>, <-0.0231914, 5.56515, -0.318123>, <-0.0953021, -0.173874, 0.980146>, <-0.0132154, 5.56903, -0.31671> , <-0.0549106, -0.157399, 0.986007> }
	smooth_triangle { <-0.0231914, 5.56515, -0.318123>, <-0.0953021, -0.173874, 0.980146>, <-0.021135, 5.59994, -0.315219>, <-0.107514, 0.0663485, 0.991987>, <-0.0384923, 5.59319, -0.317675> , <-0.209622, 0.0298461, 0.977327> }
	smooth_triangle { <-0.0276624, 5.62832, -0.321967>, <-0.138801, 0.198677, 0.970186>, <-0.0384923, 5.59319, -0.317675>, <-0.209622, 0.0298461, 0.977327>, <-0.021135, 5.59994, -0.315219> , <-0.107514, 0.0663485, 0.991987> }
	smooth_triangle { <-0.0384923, 5.59319, -0.317675>, <-0.209622, 0.0298461, 0.977327>, <-0.0276624, 5.62832, -0.321967>, <-0.138801, 0.198677, 0.970186>, <-0.0511013, 5.62848, -0.326922> , <-0.406219, 0.257012, 0.876887> }
	smooth_triangle { <-0.0330032, 5.6271, -0.329776>, <-0.0210151, 0.942526, -0.333471>, <-0.0511013, 5.62848, -0.326922>, <0.0457523, 0.981697, -0.18487>, <-0.0276624, 5.62832, -0.321967> , <-0.0210151, 0.942526, -0.333471> }
	smooth_triangle { <-0.0511013, 5.62848, -0.326922>, <0.0457523, 0.981697, -0.18487>, <-0.0330032, 5.6271, -0.329776>, <-0.0210151, 0.942526, -0.333471>, <-0.0614184, 5.62626, -0.335606> , <0.0457523, 0.981697, -0.18487> }
	smooth_triangle { <-0.00250971, 5.57035, -0.316229>, <-0.000130046, -0.151714, 0.988424>, <-0.0025925, 5.53031, -0.326246>, <-0.0351112, -0.246381, 0.968537>, <-0.0025097, 5.53032, -0.326241> , <-0.000256991, -0.244244, 0.969714> }
	smooth_triangle { <-0.0025925, 5.53031, -0.326246>, <-0.0351112, -0.246381, 0.968537>, <-0.00250971, 5.57035, -0.316229>, <-0.000130046, -0.151714, 0.988424>, <-0.0132154, 5.56903, -0.31671> , <-0.0549106, -0.157399, 0.986007> }
	smooth_triangle { <-0.00250971, 5.60225, -0.314383>, <2.4918e-006, 0.0796621, 0.996822>, <-0.0132154, 5.56903, -0.31671>, <-0.0549106, -0.157399, 0.986007>, <-0.00250971, 5.57035, -0.316229> , <-0.000130046, -0.151714, 0.988424> }
	smooth_triangle { <-0.0132154, 5.56903, -0.31671>, <-0.0549106, -0.157399, 0.986007>, <-0.00250971, 5.60225, -0.314383>, <2.4918e-006, 0.0796621, 0.996822>, <-0.021135, 5.59994, -0.315219> , <-0.107514, 0.0663485, 0.991987> }
	smooth_triangle { <-0.00250971, 5.63143, -0.320833>, <6.8417e-006, 0.215857, 0.976425>, <-0.021135, 5.59994, -0.315219>, <-0.107514, 0.0663485, 0.991987>, <-0.00250971, 5.60225, -0.314383> , <2.4918e-006, 0.0796621, 0.996822> }
	smooth_triangle { <-0.021135, 5.59994, -0.315219>, <-0.107514, 0.0663485, 0.991987>, <-0.00250971, 5.63143, -0.320833>, <6.8417e-006, 0.215857, 0.976425>, <-0.0276624, 5.62832, -0.321967> , <-0.138801, 0.198677, 0.970186> }
	smooth_triangle { <-0.0025097, 5.62766, -0.327836>, <0.016457, 0.959659, -0.280684>, <-0.0276624, 5.62832, -0.321967>, <-0.0210151, 0.942526, -0.333471>, <-0.00250971, 5.63143, -0.320833> , <0.016457, 0.959659, -0.280684> }
	smooth_triangle { <-0.0276624, 5.62832, -0.321967>, <-0.0210151, 0.942526, -0.333471>, <-0.0025097, 5.62766, -0.327836>, <0.016457, 0.959659, -0.280684>, <-0.0330032, 5.6271, -0.329776> , <-0.0210151, 0.942526, -0.333471> }
	smooth_triangle { <0.008196, 5.56903, -0.31671>, <0.054617, -0.158442, 0.985856>, <-0.0025097, 5.53032, -0.326241>, <-0.000256991, -0.244244, 0.969714>, <-0.0024268, 5.53031, -0.326246> , <0.034533, -0.248376, 0.968048> }
	smooth_triangle { <-0.0025097, 5.53032, -0.326241>, <-0.000256991, -0.244244, 0.969714>, <0.008196, 5.56903, -0.31671>, <0.054617, -0.158442, 0.985856>, <-0.00250971, 5.57035, -0.316229> , <-0.000130046, -0.151714, 0.988424> }
	smooth_triangle { <-0.00250971, 5.60225, -0.314383>, <2.49369e-006, 0.0796621, 0.996822>, <0.008196, 5.56903, -0.31671>, <0.054617, -0.158442, 0.985856>, <0.0161163, 5.59994, -0.315219> , <0.10752, 0.06638, 0.991984> }
	smooth_triangle { <0.008196, 5.56903, -0.31671>, <0.054617, -0.158442, 0.985856>, <-0.00250971, 5.60225, -0.314383>, <2.49369e-006, 0.0796621, 0.996822>, <-0.00250971, 5.57035, -0.316229> , <-0.000130046, -0.151714, 0.988424> }
	smooth_triangle { <0.0226431, 5.62832, -0.321967>, <0.209595, 0.338361, 0.917378>, <-0.00250971, 5.60225, -0.314383>, <2.49274e-006, 0.0796621, 0.996822>, <0.0161163, 5.59994, -0.315219> , <0.10752, 0.06638, 0.991984> }
	smooth_triangle { <-0.00250971, 5.60225, -0.314383>, <2.49274e-006, 0.0796621, 0.996822>, <0.0226431, 5.62832, -0.321967>, <0.209595, 0.338361, 0.917378>, <-0.00250971, 5.63143, -0.320833> , <6.8417e-006, 0.215857, 0.976425> }
	smooth_triangle { <0.0226431, 5.62832, -0.321967>, <0.11921, 0.990154, -0.0733704>, <-0.0025097, 5.62766, -0.327836>, <0.016457, 0.959659, -0.280684>, <-0.00250971, 5.63143, -0.320833> , <0.016457, 0.959659, -0.280684> }
	smooth_triangle { <-0.0025097, 5.62766, -0.327836>, <0.016457, 0.959659, -0.280684>, <0.0226431, 5.62832, -0.321967>, <0.11921, 0.990154, -0.0733704>, <0.0279839, 5.6271, -0.329776> , <0.11921, 0.990154, -0.0733704> }
	smooth_triangle { <0.008196, 5.56903, -0.31671>, <0.054617, -0.158442, 0.985856>, <-0.00234934, 5.53028, -0.326257>, <0.047432, -0.250872, 0.966858>, <0.0181721, 5.56515, -0.318123> , <0.0958962, -0.173245, 0.980199> }
	smooth_triangle { <-0.00234934, 5.53028, -0.326257>, <0.047432, -0.250872, 0.966858>, <0.008196, 5.56903, -0.31671>, <0.054617, -0.158442, 0.985856>, <-0.0024268, 5.53031, -0.326246> , <0.034533, -0.248376, 0.968048> }
	smooth_triangle { <0.0161163, 5.59994, -0.315219>, <0.10752, 0.06638, 0.991984>, <0.0181721, 5.56515, -0.318123>, <0.0958962, -0.173245, 0.980199>, <0.0334729, 5.59319, -0.317675> , <0.207904, 0.0272545, 0.977769> }
	smooth_triangle { <0.0181721, 5.56515, -0.318123>, <0.0958962, -0.173245, 0.980199>, <0.0161163, 5.59994, -0.315219>, <0.10752, 0.06638, 0.991984>, <0.008196, 5.56903, -0.31671> , <0.054617, -0.158442, 0.985856> }
	smooth_triangle { <0.0226431, 5.62832, -0.321967>, <0.209595, 0.338361, 0.917378>, <0.0334729, 5.59319, -0.317675>, <0.207904, 0.0272545, 0.977769>, <0.046082, 5.6192, -0.325286> , <0.333259, 0.300515, 0.89366> }
	smooth_triangle { <0.0334729, 5.59319, -0.317675>, <0.207904, 0.0272545, 0.977769>, <0.0226431, 5.62832, -0.321967>, <0.209595, 0.338361, 0.917378>, <0.0161163, 5.59994, -0.315219> , <0.10752, 0.06638, 0.991984> }
	smooth_triangle { <0.0279839, 5.6271, -0.329776>, <0.333457, 0.588845, 0.736253>, <0.046082, 5.6192, -0.325286>, <0.333259, 0.300515, 0.89366>, <0.056399, 5.62626, -0.335606> , <0.388452, 0.445156, 0.806809> }
	smooth_triangle { <0.046082, 5.6192, -0.325286>, <0.333259, 0.300515, 0.89366>, <0.0279839, 5.6271, -0.329776>, <0.333457, 0.588845, 0.736253>, <0.0226431, 5.62832, -0.321967> , <0.209595, 0.338361, 0.917378> }
	smooth_triangle { <0.0181721, 5.56515, -0.318123>, <0.0958962, -0.173245, 0.980199>, <-0.00228386, 5.53023, -0.326273>, <0.0665393, -0.264117, 0.962193>, <0.0267384, 5.55897, -0.320373> , <0.135347, -0.201383, 0.970116> }
	smooth_triangle { <-0.00228386, 5.53023, -0.326273>, <0.0665393, -0.264117, 0.962193>, <0.0181721, 5.56515, -0.318123>, <0.0958962, -0.173245, 0.980199>, <-0.00234934, 5.53028, -0.326257> , <0.047432, -0.250872, 0.966858> }
	smooth_triangle { <0.0334729, 5.59319, -0.317675>, <0.207904, 0.0272545, 0.977769>, <0.0267384, 5.55897, -0.320373>, <0.135347, -0.201383, 0.970116>, <0.0483768, 5.58244, -0.32159> , <0.294018, -0.0348055, 0.955166> }
	smooth_triangle { <0.0267384, 5.55897, -0.320373>, <0.135347, -0.201383, 0.970116>, <0.0334729, 5.59319, -0.317675>, <0.207904, 0.0272545, 0.977769>, <0.0181721, 5.56515, -0.318123> , <0.0958962, -0.173245, 0.980199> }
	smooth_triangle { <0.046082, 5.6192, -0.325286>, <0.333259, 0.300515, 0.89366>, <0.0483768, 5.58244, -0.32159>, <0.294018, -0.0348055, 0.955166>, <0.06621, 5.60469, -0.330568> , <0.442421, 0.1489, 0.88436> }
	smooth_triangle { <0.0483768, 5.58244, -0.32159>, <0.294018, -0.0348055, 0.955166>, <0.046082, 5.6192, -0.325286>, <0.333259, 0.300515, 0.89366>, <0.0334729, 5.59319, -0.317675> , <0.207904, 0.0272545, 0.977769> }
	smooth_triangle { <0.056399, 5.62626, -0.335606>, <0.388452, 0.445156, 0.806809>, <0.06621, 5.60469, -0.330568>, <0.442421, 0.1489, 0.88436>, <0.0808001, 5.62545, -0.34497> , <0.567428, 0.262416, 0.780489> }
	smooth_triangle { <0.06621, 5.60469, -0.330568>, <0.442421, 0.1489, 0.88436>, <0.056399, 5.62626, -0.335606>, <0.388452, 0.445156, 0.806809>, <0.046082, 5.6192, -0.325286> , <0.333259, 0.300515, 0.89366> }
	smooth_triangle { <0.0267384, 5.55897, -0.320373>, <0.135347, -0.201383, 0.970116>, <-0.00223305, 5.53017, -0.326295>, <0.0911647, -0.297618, 0.950322>, <0.0333119, 5.55092, -0.323301> , <0.170617, -0.246282, 0.954062> }
	smooth_triangle { <-0.00223305, 5.53017, -0.326295>, <0.0911647, -0.297618, 0.950322>, <0.0267384, 5.55897, -0.320373>, <0.135347, -0.201383, 0.970116>, <-0.00228386, 5.53023, -0.326273> , <0.0665393, -0.264117, 0.962193> }
	smooth_triangle { <0.0483768, 5.58244, -0.32159>, <0.294018, -0.0348055, 0.955166>, <0.0333119, 5.55092, -0.323301>, <0.170617, -0.246282, 0.954062>, <0.0598137, 5.56843, -0.326686> , <0.36006, -0.11566, 0.925732> }
	smooth_triangle { <0.0333119, 5.55092, -0.323301>, <0.170617, -0.246282, 0.954062>, <0.0483768, 5.58244, -0.32159>, <0.294018, -0.0348055, 0.955166>, <0.0267384, 5.55897, -0.320373> , <0.135347, -0.201383, 0.970116> }
	smooth_triangle { <0.06621, 5.60469, -0.330568>, <0.442421, 0.1489, 0.88436>, <0.0598137, 5.56843, -0.326686>, <0.36006, -0.11566, 0.925732>, <0.0816538, 5.58577, -0.337452> , <0.541833, 0.0271532, 0.840048> }
	smooth_triangle { <0.0598137, 5.56843, -0.326686>, <0.36006, -0.11566, 0.925732>, <0.06621, 5.60469, -0.330568>, <0.442421, 0.1489, 0.88436>, <0.0483768, 5.58244, -0.32159> , <0.294018, -0.0348055, 0.955166> }
	smooth_triangle { <0.0808001, 5.62545, -0.34497>, <0.567428, 0.262416, 0.780489>, <0.0816538, 5.58577, -0.337452>, <0.541833, 0.0271532, 0.840048>, <0.0995233, 5.60252, -0.353316> , <0.685823, 0.16321, 0.709232> }
	smooth_triangle { <0.0816538, 5.58577, -0.337452>, <0.541833, 0.0271532, 0.840048>, <0.0808001, 5.62545, -0.34497>, <0.567428, 0.262416, 0.780489>, <0.06621, 5.60469, -0.330568> , <0.442421, 0.1489, 0.88436> }
	smooth_triangle { <0.0921478, 5.62144, -0.362693>, <0.686786, 0.323937, 0.650684>, <0.0995233, 5.60252, -0.353316>, <0.685823, 0.16321, 0.709232>, <0.11342, 5.61947, -0.376423> , <0.781178, 0.218076, 0.584981> }
	smooth_triangle { <0.0995233, 5.60252, -0.353316>, <0.685823, 0.16321, 0.709232>, <0.0921478, 5.62144, -0.362693>, <0.686786, 0.323937, 0.650684>, <0.0808001, 5.62545, -0.34497> , <0.567428, 0.262416, 0.780489> }
	smooth_triangle { <0.0333119, 5.55092, -0.323301>, <0.170617, -0.246282, 0.954062>, <-0.00220107, 5.5301, -0.326323>, <0.102368, -0.331234, 0.937979>, <0.037444, 5.54155, -0.326714> , <0.190659, -0.295848, 0.936015> }
	smooth_triangle { <-0.00220107, 5.5301, -0.326323>, <0.102368, -0.331234, 0.937979>, <0.0333119, 5.55092, -0.323301>, <0.170617, -0.246282, 0.954062>, <-0.00223305, 5.53017, -0.326295> , <0.0911647, -0.297618, 0.950322> }
	smooth_triangle { <0.0598137, 5.56843, -0.326686>, <0.36006, -0.11566, 0.925732>, <0.037444, 5.54155, -0.326714>, <0.190659, -0.295848, 0.936015>, <0.0670031, 5.55213, -0.332622> , <0.401633, -0.209872, 0.891429> }
	smooth_triangle { <0.037444, 5.54155, -0.326714>, <0.190659, -0.295848, 0.936015>, <0.0598137, 5.56843, -0.326686>, <0.36006, -0.11566, 0.925732>, <0.0333119, 5.55092, -0.323301> , <0.170617, -0.246282, 0.954062> }
	smooth_triangle { <0.0816538, 5.58577, -0.337452>, <0.541833, 0.0271532, 0.840048>, <0.0670031, 5.55213, -0.332622>, <0.401633, -0.209872, 0.891429>, <0.0913626, 5.56375, -0.345471> , <0.604349, -0.114614, 0.788432> }
	smooth_triangle { <0.0670031, 5.55213, -0.332622>, <0.401633, -0.209872, 0.891429>, <0.0816538, 5.58577, -0.337452>, <0.541833, 0.0271532, 0.840048>, <0.0598137, 5.56843, -0.326686> , <0.36006, -0.11566, 0.925732> }
	smooth_triangle { <0.0995233, 5.60252, -0.353316>, <0.685823, 0.16321, 0.709232>, <0.0913626, 5.56375, -0.345471>, <0.604349, -0.114614, 0.788432>, <0.111293, 5.57582, -0.363033> , <0.764918, -0.0162585, 0.643922> }
	smooth_triangle { <0.0913626, 5.56375, -0.345471>, <0.604349, -0.114614, 0.788432>, <0.0995233, 5.60252, -0.353316>, <0.685823, 0.16321, 0.709232>, <0.0816538, 5.58577, -0.337452> , <0.541833, 0.0271532, 0.840048> }
	smooth_triangle { <0.0995233, 5.60252, -0.353316>, <0.685823, 0.16321, 0.709232>, <0.126794, 5.58914, -0.387462>, <0.861141, 0.0613891, 0.504645>, <0.11342, 5.61947, -0.376423> , <0.781178, 0.218076, 0.584981> }
	smooth_triangle { <0.126794, 5.58914, -0.387462>, <0.861141, 0.0613891, 0.504645>, <0.0995233, 5.60252, -0.353316>, <0.685823, 0.16321, 0.709232>, <0.111293, 5.57582, -0.363033> , <0.764918, -0.0162585, 0.643922> }
	smooth_triangle { <0.123348, 5.61529, -0.396968>, <0.840874, 0.185706, 0.508375>, <0.126794, 5.58914, -0.387462>, <0.861141, 0.0613891, 0.504645>, <0.137868, 5.61228, -0.414234> , <0.923609, 0.0759416, 0.375739> }
	smooth_triangle { <0.126794, 5.58914, -0.387462>, <0.861141, 0.0613891, 0.504645>, <0.123348, 5.61529, -0.396968>, <0.840874, 0.185706, 0.508375>, <0.11342, 5.61947, -0.376423> , <0.781178, 0.218076, 0.584981> }
	smooth_triangle { <0.037444, 5.54155, -0.326714>, <0.190659, -0.295848, 0.936015>, <-0.00218966, 5.53002, -0.326353>, <0.111609, -0.320558, 0.940631>, <0.0388533, 5.53149, -0.330373> , <0.200109, -0.3254, 0.92416> }
	smooth_triangle { <-0.00218966, 5.53002, -0.326353>, <0.111609, -0.320558, 0.940631>, <0.037444, 5.54155, -0.326714>, <0.190659, -0.295848, 0.936015>, <-0.00220107, 5.5301, -0.326323> , <0.102368, -0.331234, 0.937979> }
	smooth_triangle { <0.0670031, 5.55213, -0.332622>, <0.401633, -0.209872, 0.891429>, <0.0388533, 5.53149, -0.330373>, <0.200109, -0.3254, 0.92416>, <0.0694549, 5.53462, -0.33899> , <0.415764, -0.311017, 0.854639> }
	smooth_triangle { <0.0388533, 5.53149, -0.330373>, <0.200109, -0.3254, 0.92416>, <0.0670031, 5.55213, -0.332622>, <0.401633, -0.209872, 0.891429>, <0.037444, 5.54155, -0.326714> , <0.190659, -0.295848, 0.936015> }
	smooth_triangle { <0.0913626, 5.56375, -0.345471>, <0.604349, -0.114614, 0.788432>, <0.0694549, 5.53462, -0.33899>, <0.415764, -0.311017, 0.854639>, <0.0946737, 5.54011, -0.354071> , <0.625675, -0.266747, 0.73306> }
	smooth_triangle { <0.0694549, 5.53462, -0.33899>, <0.415764, -0.311017, 0.854639>, <0.0913626, 5.56375, -0.345471>, <0.604349, -0.114614, 0.788432>, <0.0670031, 5.55213, -0.332622> , <0.401633, -0.209872, 0.891429> }
	smooth_triangle { <0.0913626, 5.56375, -0.345471>, <0.604349, -0.114614, 0.788432>, <0.115308, 5.54717, -0.373465>, <0.791928, -0.208812, 0.5738>, <0.111293, 5.57582, -0.363033> , <0.764918, -0.0162585, 0.643922> }
	smooth_triangle { <0.115308, 5.54717, -0.373465>, <0.791928, -0.208812, 0.5738>, <0.0913626, 5.56375, -0.345471>, <0.604349, -0.114614, 0.788432>, <0.0946737, 5.54011, -0.354071> , <0.625675, -0.266747, 0.73306> }
	smooth_triangle { <0.111293, 5.57582, -0.363033>, <0.764918, -0.0162585, 0.643922>, <0.131356, 5.55658, -0.399313>, <0.895392, -0.1523, 0.418422>, <0.126794, 5.58914, -0.387462> , <0.861141, 0.0613891, 0.504645> }
	smooth_triangle { <0.131356, 5.55658, -0.399313>, <0.895392, -0.1523, 0.418422>, <0.111293, 5.57582, -0.363033>, <0.764918, -0.0162585, 0.643922>, <0.115308, 5.54717, -0.373465> , <0.791928, -0.208812, 0.5738> }
	smooth_triangle { <0.126794, 5.58914, -0.387462>, <0.861141, 0.0613891, 0.504645>, <0.14282, 5.56599, -0.425167>, <0.959726, -0.0974791, 0.263485>, <0.137868, 5.61228, -0.414234> , <0.923609, 0.0759416, 0.375739> }
	smooth_triangle { <0.14282, 5.56599, -0.425167>, <0.959726, -0.0974791, 0.263485>, <0.126794, 5.58914, -0.387462>, <0.861141, 0.0613891, 0.504645>, <0.131356, 5.55658, -0.399313> , <0.895392, -0.1523, 0.418422> }
	smooth_triangle { <0.137868, 5.61228, -0.414234>, <0.923609, 0.0759416, 0.375739>, <0.149697, 5.57932, -0.46179>, <0.987792, -0.0517587, 0.146927>, <0.14451, 5.60685, -0.446643> , <0.978682, 0.0704966, 0.192902> }
	smooth_triangle { <0.149697, 5.57932, -0.46179>, <0.987792, -0.0517587, 0.146927>, <0.137868, 5.61228, -0.414234>, <0.923609, 0.0759416, 0.375739>, <0.14282, 5.56599, -0.425167> , <0.959726, -0.0974791, 0.263485> }
	smooth_triangle { <0.148939, 5.60148, -0.475337>, <0.979706, 0.0846131, 0.181705>, <0.149697, 5.57932, -0.46179>, <0.987792, -0.0517587, 0.146927>, <0.154283, 5.59838, -0.495393> , <0.997793, -0.053432, 0.0394129> }
	smooth_triangle { <0.149697, 5.57932, -0.46179>, <0.987792, -0.0517587, 0.146927>, <0.148939, 5.60148, -0.475337>, <0.979706, 0.0846131, 0.181705>, <0.14451, 5.60685, -0.446643> , <0.978682, 0.0704966, 0.192902> }
material { BlueLiquid }
#if (use_photons)
 photons{
  target
  refraction on
  reflection on
  collect off
 }
#end
}

// object Tail
union {
	smooth_triangle { <-0.0359513, 5.70788, -0.3793>, <0.850236, -0.453659, -0.267006>, <0.0313175, 5.70788, -0.3793>, <0.850236, -0.453659, -0.267006>, <-0.00231685, 5.70527, -0.372141> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0640093, 5.7158, -0.401051>, <0.850236, -0.453659, -0.267006>, <0.0313175, 5.70788, -0.3793>, <0.850236, -0.453659, -0.267006>, <-0.0359513, 5.70788, -0.3793> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0640093, 5.7158, -0.401051>, <0.850236, -0.453659, -0.267006>, <0.0602855, 5.7158, -0.401051>, <0.850236, -0.453659, -0.267006>, <0.0313175, 5.70788, -0.3793> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0812394, 5.72855, -0.436087>, <0.850236, -0.453659, -0.267006>, <0.0602855, 5.7158, -0.401051>, <0.850236, -0.453659, -0.267006>, <-0.0640093, 5.7158, -0.401051> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0812394, 5.72855, -0.436087>, <0.850236, -0.453659, -0.267006>, <0.0811607, 5.72855, -0.436087>, <0.962801, -0.255349, -0.0883757>, <0.0602855, 5.7158, -0.401051> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0874743, 5.7568, -0.49854>, <0.850236, -0.453659, -0.267006>, <0.0811607, 5.72855, -0.436087>, <0.962801, -0.255349, -0.0883757>, <-0.0812394, 5.72855, -0.436087> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0874743, 5.7568, -0.49854>, <0.850236, -0.453659, -0.267006>, <0.0883049, 5.7568, -0.49854>, <0.983625, -0.16155, -0.0798921>, <0.0811607, 5.72855, -0.436087> , <0.962801, -0.255349, -0.0883757> }
	smooth_triangle { <-0.0807842, 5.81971, -0.584121>, <0.850236, -0.453659, -0.267006>, <0.0883049, 5.7568, -0.49854>, <0.983625, -0.16155, -0.0798921>, <-0.0874743, 5.7568, -0.49854> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0807842, 5.81971, -0.584121>, <0.850236, -0.453659, -0.267006>, <0.0816149, 5.81971, -0.584121>, <0.975312, -0.123615, -0.18299>, <0.0883049, 5.7568, -0.49854> , <0.983625, -0.16155, -0.0798921> }
	smooth_triangle { <-0.0617321, 5.89391, -0.649523>, <0.850236, -0.453659, -0.267006>, <0.0816149, 5.81971, -0.584121>, <0.975312, -0.123615, -0.18299>, <-0.0807842, 5.81971, -0.584121> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0617321, 5.89391, -0.649523>, <0.850236, -0.453659, -0.267006>, <0.0625627, 5.89391, -0.649523>, <0.947769, -0.0794091, -0.308915>, <0.0816149, 5.81971, -0.584121> , <0.975312, -0.123615, -0.18299> }
	smooth_triangle { <-0.0332184, 5.95129, -0.689595>, <0.850236, -0.453659, -0.267006>, <0.0625627, 5.89391, -0.649523>, <0.947769, -0.0794091, -0.308915>, <-0.0617321, 5.89391, -0.649523> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0332184, 5.95129, -0.689595>, <0.850236, -0.453659, -0.267006>, <0.0340492, 5.95129, -0.689595>, <0.918945, -0.158636, -0.361075>, <0.0625627, 5.89391, -0.649523> , <0.947769, -0.0794091, -0.308915> }
	smooth_triangle { <0.0340492, 5.95129, -0.689595>, <0.918945, -0.158636, -0.361075>, <-0.0332184, 5.95129, -0.689595>, <0.850236, -0.453659, -0.267006>, <0.00041534, 5.98453, -0.695564> , <0.850236, -0.453659, -0.267006> }
	smooth_triangle { <-0.0807842, 5.81971, -0.584121>, <-0.990108, 0.0479707, -0.131848>, <-0.0874743, 5.76655, -0.494991>, <-0.999919, -0.00435992, 0.0119409>, <-0.0807842, 5.82946, -0.580572> , <-0.990108, 0.0479707, -0.131848> }
	smooth_triangle { <-0.0874743, 5.76655, -0.494991>, <-0.999919, -0.00435992, 0.0119409>, <-0.0807842, 5.81971, -0.584121>, <-0.990108, 0.0479707, -0.131848>, <-0.0874743, 5.7568, -0.49854> , <-0.999919, -0.00435992, 0.0119409> }
	smooth_triangle { <-0.0617321, 5.89391, -0.649523>, <-0.943109, 0.113697, -0.31244>, <-0.0807842, 5.82946, -0.580572>, <-0.990108, 0.0479707, -0.131848>, <-0.0617321, 5.90366, -0.645973> , <-0.943109, 0.113697, -0.31244> }
	smooth_triangle { <-0.0807842, 5.82946, -0.580572>, <-0.990108, 0.0479707, -0.131848>, <-0.0617321, 5.89391, -0.649523>, <-0.943109, 0.113697, -0.31244>, <-0.0807842, 5.81971, -0.584121> , <-0.990108, 0.0479707, -0.131848> }
	smooth_triangle { <-0.0332184, 5.95129, -0.689595>, <-0.709051, 0.241146, -0.662642>, <-0.0617321, 5.90366, -0.645973>, <-0.943109, 0.113697, -0.31244>, <-0.0332184, 5.96105, -0.686045> , <-0.709051, 0.241146, -0.662642> }
	smooth_triangle { <-0.0617321, 5.90366, -0.645973>, <-0.943109, 0.113697, -0.31244>, <-0.0332184, 5.95129, -0.689595>, <-0.709051, 0.241146, -0.662642>, <-0.0617321, 5.89391, -0.649523> , <-0.943109, 0.113697, -0.31244> }
	smooth_triangle { <-0.0332184, 5.95129, -0.689595>, <-0.709051, 0.241146, -0.662642>, <0.00041534, 5.99428, -0.692013>, <-0.450552, 0.305294, -0.838927>, <0.00041534, 5.98453, -0.695564> , <-0.450552, 0.305294, -0.838927> }
	smooth_triangle { <0.00041534, 5.99428, -0.692013>, <-0.450552, 0.305294, -0.838927>, <-0.0332184, 5.95129, -0.689595>, <-0.709051, 0.241146, -0.662642>, <-0.0332184, 5.96105, -0.686045> , <-0.709051, 0.241146, -0.662642> }
	smooth_triangle { <0.00041534, 5.98453, -0.695564>, <0.450658, 0.305432, -0.83882>, <0.0340499, 5.96105, -0.686045>, <0.709079, 0.241186, -0.662599>, <0.0340492, 5.95129, -0.689595> , <0.709079, 0.241186, -0.662599> }
	smooth_triangle { <0.0340499, 5.96105, -0.686045>, <0.709079, 0.241186, -0.662599>, <0.00041534, 5.98453, -0.695564>, <0.450658, 0.305432, -0.83882>, <0.00041534, 5.99428, -0.692013> , <0.450658, 0.305432, -0.83882> }
	smooth_triangle { <0.0625635, 5.90366, -0.645973>, <0.943098, 0.113647, -0.312491>, <0.0340492, 5.95129, -0.689595>, <0.821443, 0.00154133, -0.570289>, <0.0340499, 5.96105, -0.686045> , <0.709079, 0.241186, -0.662599> }
	smooth_triangle { <0.0340492, 5.95129, -0.689595>, <0.821443, 0.00154133, -0.570289>, <0.0625635, 5.90366, -0.645973>, <0.943098, 0.113647, -0.312491>, <0.0625627, 5.89391, -0.649523> , <0.947769, -0.0794091, -0.308915> }
	smooth_triangle { <0.0816149, 5.82946, -0.580572>, <0.990106, 0.0479488, -0.131872>, <0.0625627, 5.89391, -0.649523>, <0.947769, -0.0794091, -0.308915>, <0.0625635, 5.90366, -0.645973> , <0.943098, 0.113647, -0.312491> }
	smooth_triangle { <0.0625627, 5.89391, -0.649523>, <0.947769, -0.0794091, -0.308915>, <0.0816149, 5.82946, -0.580572>, <0.990106, 0.0479488, -0.131872>, <0.0816149, 5.81971, -0.584121> , <0.975312, -0.123615, -0.18299> }
	smooth_triangle { <0.0883057, 5.76655, -0.494991>, <0.999814, -0.00663355, 0.0181247>, <0.0816149, 5.81971, -0.584121>, <0.975312, -0.123615, -0.18299>, <0.0816149, 5.82946, -0.580572> , <0.990106, 0.0479488, -0.131872> }
	smooth_triangle { <0.0816149, 5.81971, -0.584121>, <0.975312, -0.123615, -0.18299>, <0.0883057, 5.76655, -0.494991>, <0.999814, -0.00663355, 0.0181247>, <0.0883049, 5.7568, -0.49854> , <0.983625, -0.16155, -0.0798921> }
	smooth_triangle { <0.0811607, 5.7383, -0.432536>, <0.953158, -0.103524, 0.284207>, <0.0883049, 5.7568, -0.49854>, <0.983625, -0.16155, -0.0798921>, <0.0883057, 5.76655, -0.494991> , <0.999814, -0.00663355, 0.0181247> }
	smooth_triangle { <0.0883049, 5.7568, -0.49854>, <0.983625, -0.16155, -0.0798921>, <0.0811607, 5.7383, -0.432536>, <0.953158, -0.103524, 0.284207>, <0.0811607, 5.72855, -0.436087> , <0.96686, -0.233571, 0.103085> }
	smooth_triangle { <0.0602855, 5.72555, -0.397501>, <0.762575, -0.221305, 0.607868>, <0.0811607, 5.72855, -0.436087>, <0.953158, -0.103524, 0.284207>, <0.0811607, 5.7383, -0.432536> , <0.953158, -0.103524, 0.284207> }
	smooth_triangle { <0.0811607, 5.72855, -0.436087>, <0.953158, -0.103524, 0.284207>, <0.0602855, 5.72555, -0.397501>, <0.762575, -0.221305, 0.607868>, <0.0602855, 5.7158, -0.401051> , <0.762575, -0.221305, 0.607868> }
	smooth_triangle { <0.0313175, 5.71763, -0.375749>, <0.433571, -0.308281, 0.846746>, <0.0602855, 5.7158, -0.401051>, <0.762575, -0.221305, 0.607868>, <0.0602855, 5.72555, -0.397501> , <0.762575, -0.221305, 0.607868> }
	smooth_triangle { <0.0602855, 5.7158, -0.401051>, <0.762575, -0.221305, 0.607868>, <0.0313175, 5.71763, -0.375749>, <0.433571, -0.308281, 0.846746>, <0.0313175, 5.70788, -0.3793> , <0.433571, -0.308281, 0.846746> }
	smooth_triangle { <-0.00231685, 5.71503, -0.368591>, <3.20848e-007, -0.342087, 0.939668>, <0.0313175, 5.70788, -0.3793>, <0.433571, -0.308281, 0.846746>, <0.0313175, 5.71763, -0.375749> , <0.433571, -0.308281, 0.846746> }
	smooth_triangle { <0.0313175, 5.70788, -0.3793>, <0.433571, -0.308281, 0.846746>, <-0.00231685, 5.71503, -0.368591>, <3.20848e-007, -0.342087, 0.939668>, <-0.00231685, 5.70527, -0.372141> , <3.20848e-007, -0.342087, 0.939668> }
	smooth_triangle { <-0.0359513, 5.71763, -0.375749>, <-0.440594, -0.307086, 0.843549>, <-0.00231685, 5.70527, -0.372141>, <3.20848e-007, -0.342087, 0.939668>, <-0.00231685, 5.71503, -0.368591> , <3.20848e-007, -0.342087, 0.939668> }
	smooth_triangle { <-0.00231685, 5.70527, -0.372141>, <3.20848e-007, -0.342087, 0.939668>, <-0.0359513, 5.71763, -0.375749>, <-0.440594, -0.307086, 0.843549>, <-0.0359513, 5.70788, -0.3793> , <-0.440594, -0.307086, 0.843549> }
	smooth_triangle { <-0.0640093, 5.72555, -0.397501>, <-0.791861, -0.208932, 0.573849>, <-0.0359513, 5.70788, -0.3793>, <-0.440594, -0.307086, 0.843549>, <-0.0359513, 5.71763, -0.375749> , <-0.440594, -0.307086, 0.843549> }
	smooth_triangle { <-0.0359513, 5.70788, -0.3793>, <-0.440594, -0.307086, 0.843549>, <-0.0640093, 5.72555, -0.397501>, <-0.791861, -0.208932, 0.573849>, <-0.0640093, 5.7158, -0.401051> , <-0.791861, -0.208932, 0.573849> }
	smooth_triangle { <-0.0812394, 5.72855, -0.436087>, <-0.96589, -0.0885798, 0.243331>, <-0.0640093, 5.72555, -0.397501>, <-0.791861, -0.208932, 0.573849>, <-0.0812394, 5.7383, -0.432536> , <-0.96589, -0.0885798, 0.243331> }
	smooth_triangle { <-0.0640093, 5.72555, -0.397501>, <-0.791861, -0.208932, 0.573849>, <-0.0812394, 5.72855, -0.436087>, <-0.96589, -0.0885798, 0.243331>, <-0.0640093, 5.7158, -0.401051> , <-0.791861, -0.208932, 0.573849> }
	smooth_triangle { <-0.0874743, 5.7568, -0.49854>, <-0.999919, -0.00435992, 0.0119409>, <-0.0812394, 5.7383, -0.432536>, <-0.96589, -0.0885798, 0.243331>, <-0.0874743, 5.76655, -0.494991> , <-0.999919, -0.00435992, 0.0119409> }
	smooth_triangle { <-0.0812394, 5.7383, -0.432536>, <-0.96589, -0.0885798, 0.243331>, <-0.0874743, 5.7568, -0.49854>, <-0.999919, -0.00435992, 0.0119409>, <-0.0812394, 5.72855, -0.436087> , <-0.96589, -0.0885798, 0.243331> }
	smooth_triangle { <0.0313175, 5.71763, -0.375749>, <0.00017922, 0.939743, 0.341883>, <-0.0359513, 5.71763, -0.375749>, <0.00017922, 0.939743, 0.341883>, <-0.00231685, 5.71503, -0.368591> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0602855, 5.72555, -0.397501>, <0.00017922, 0.939743, 0.341883>, <-0.0359513, 5.71763, -0.375749>, <0.00017922, 0.939743, 0.341883>, <0.0313175, 5.71763, -0.375749> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0602855, 5.72555, -0.397501>, <0.00017922, 0.939743, 0.341883>, <-0.0640093, 5.72555, -0.397501>, <0.00017922, 0.939743, 0.341883>, <-0.0359513, 5.71763, -0.375749> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0811607, 5.7383, -0.432536>, <0.00017922, 0.939743, 0.341883>, <-0.0640093, 5.72555, -0.397501>, <0.00017922, 0.939743, 0.341883>, <0.0602855, 5.72555, -0.397501> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0811607, 5.7383, -0.432536>, <0.00017922, 0.939743, 0.341883>, <-0.0812394, 5.7383, -0.432536>, <0.00017922, 0.939743, 0.341883>, <-0.0640093, 5.72555, -0.397501> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0883057, 5.76655, -0.494991>, <0.00017922, 0.939743, 0.341883>, <-0.0812394, 5.7383, -0.432536>, <0.00017922, 0.939743, 0.341883>, <0.0811607, 5.7383, -0.432536> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0883057, 5.76655, -0.494991>, <0.00017922, 0.939743, 0.341883>, <-0.0874743, 5.76655, -0.494991>, <0.00017922, 0.939743, 0.341883>, <-0.0812394, 5.7383, -0.432536> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0816149, 5.82946, -0.580572>, <0.00017922, 0.939743, 0.341883>, <-0.0874743, 5.76655, -0.494991>, <0.00017922, 0.939743, 0.341883>, <0.0883057, 5.76655, -0.494991> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0816149, 5.82946, -0.580572>, <0.00017922, 0.939743, 0.341883>, <-0.0807842, 5.82946, -0.580572>, <0.00017922, 0.939743, 0.341883>, <-0.0874743, 5.76655, -0.494991> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0625635, 5.90366, -0.645973>, <0.00017922, 0.939743, 0.341883>, <-0.0807842, 5.82946, -0.580572>, <0.00017922, 0.939743, 0.341883>, <0.0816149, 5.82946, -0.580572> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0625635, 5.90366, -0.645973>, <0.00017922, 0.939743, 0.341883>, <-0.0617321, 5.90366, -0.645973>, <0.00017922, 0.939743, 0.341883>, <-0.0807842, 5.82946, -0.580572> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0340499, 5.96105, -0.686045>, <0.00017922, 0.939743, 0.341883>, <-0.0617321, 5.90366, -0.645973>, <0.00017922, 0.939743, 0.341883>, <0.0625635, 5.90366, -0.645973> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <0.0340499, 5.96105, -0.686045>, <0.00017922, 0.939743, 0.341883>, <-0.0332184, 5.96105, -0.686045>, <0.00017922, 0.939743, 0.341883>, <-0.0617321, 5.90366, -0.645973> , <0.00017922, 0.939743, 0.341883> }
	smooth_triangle { <-0.0332184, 5.96105, -0.686045>, <0.00017922, 0.939743, 0.341883>, <0.0340499, 5.96105, -0.686045>, <0.00017922, 0.939743, 0.341883>, <0.00041534, 5.99428, -0.692013> , <0.00017922, 0.939743, 0.341883> }
texture { tail }
}

// object Hinge
union {
	smooth_triangle { <0.0362144, 5.68497, -1.06842>, <-1.55471e-006, -0.984814, -0.173615>, <0.23829, 5.68564, -1.07219>, <-1.55471e-006, -0.984814, -0.173615>, <0.158105, 5.68517, -1.06953> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.0362144, 5.68497, -1.06842>, <-1.55471e-006, -0.984814, -0.173615>, <0.245896, 5.68854, -1.08867>, <-1.55471e-006, -0.984814, -0.173615>, <0.23829, 5.68564, -1.07219> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.245896, 5.68854, -1.08867>, <-1.55471e-006, -0.984814, -0.173615>, <0.0362144, 5.68497, -1.06842>, <-1.55471e-006, -0.984814, -0.173615>, <0.0363115, 5.69039, -1.09916> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.179549, 5.68125, -1.0473>, <-1.55471e-006, -0.984814, -0.173615>, <0.21395, 5.68141, -1.04822>, <-1.55471e-006, -0.984814, -0.173615>, <0.195349, 5.68066, -1.04397> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.171648, 5.68262, -1.05508>, <-1.55471e-006, -0.984814, -0.173615>, <0.21395, 5.68141, -1.04822>, <-1.55471e-006, -0.984814, -0.173615>, <0.179549, 5.68125, -1.0473> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.171648, 5.68262, -1.05508>, <-1.55471e-006, -0.984814, -0.173615>, <0.227641, 5.68326, -1.05871>, <-1.55471e-006, -0.984814, -0.173615>, <0.21395, 5.68141, -1.04822> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.162619, 5.68419, -1.06398>, <-1.55471e-006, -0.984814, -0.173615>, <0.227641, 5.68326, -1.05871>, <-1.55471e-006, -0.984814, -0.173615>, <0.171648, 5.68262, -1.05508> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.158105, 5.68517, -1.06953>, <-1.55471e-006, -0.984814, -0.173615>, <0.227641, 5.68326, -1.05871>, <-1.55471e-006, -0.984814, -0.173615>, <0.162619, 5.68419, -1.06398> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.227641, 5.68326, -1.05871>, <-1.55471e-006, -0.984814, -0.173615>, <0.158105, 5.68517, -1.06953>, <-1.55471e-006, -0.984814, -0.173615>, <0.23829, 5.68564, -1.07219> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.274798, 5.68511, -1.0692>, <-1.55471e-006, -0.984814, -0.173615>, <0.291532, 5.68511, -1.0692>, <-1.55471e-006, -0.984814, -0.173615>, <0.283926, 5.68432, -1.0647> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.273278, 5.68696, -1.07968>, <-1.55471e-006, -0.984814, -0.173615>, <0.291532, 5.68511, -1.0692>, <-1.55471e-006, -0.984814, -0.173615>, <0.274798, 5.68511, -1.0692> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.273278, 5.68696, -1.07968>, <-1.55471e-006, -0.984814, -0.173615>, <0.296096, 5.68749, -1.08268>, <-1.55471e-006, -0.984814, -0.173615>, <0.291532, 5.68511, -1.0692> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.271756, 5.68828, -1.08717>, <-1.55471e-006, -0.984814, -0.173615>, <0.296096, 5.68749, -1.08268>, <-1.55471e-006, -0.984814, -0.173615>, <0.273278, 5.68696, -1.07968> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.271756, 5.68828, -1.08717>, <-1.55471e-006, -0.984814, -0.173615>, <0.293053, 5.69171, -1.10665>, <-1.55471e-006, -0.984814, -0.173615>, <0.296096, 5.68749, -1.08268> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.245896, 5.68854, -1.08867>, <-1.55471e-006, -0.984814, -0.173615>, <0.293053, 5.69171, -1.10665>, <-1.55471e-006, -0.984814, -0.173615>, <0.271756, 5.68828, -1.08717> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.293053, 5.69171, -1.10665>, <-1.55471e-006, -0.984814, -0.173615>, <0.245896, 5.68854, -1.08867>, <-1.55471e-006, -0.984814, -0.173615>, <0.0363115, 5.69039, -1.09916> , <-1.55471e-006, -0.984814, -0.173615> }
	smooth_triangle { <0.0363115, 5.69039, -1.09916>, <-0.0296086, 0.173624, -0.984367>, <0.293053, 5.69595, -1.1059>, <-0.0296086, 0.173624, -0.984367>, <0.293053, 5.69171, -1.10665> , <-0.0296086, 0.173624, -0.984367> }
	smooth_triangle { <0.293053, 5.69595, -1.1059>, <-0.0296086, 0.173624, -0.984367>, <0.0363115, 5.69039, -1.09916>, <-0.0296086, 0.173624, -0.984367>, <0.0363115, 5.69463, -1.09841> , <-0.0296086, 0.173624, -0.984367> }
	smooth_triangle { <0.296096, 5.69173, -1.08193>, <0.995134, -0.0171212, 0.0970292>, <0.293053, 5.69171, -1.10665>, <0.992274, 0.0215373, -0.122184>, <0.293053, 5.69595, -1.1059> , <0.992274, 0.0215373, -0.122184> }
	smooth_triangle { <0.293053, 5.69171, -1.10665>, <0.992274, 0.0215373, -0.122184>, <0.296096, 5.69173, -1.08193>, <0.995134, -0.0171212, 0.0970292>, <0.296096, 5.68749, -1.08268> , <0.995134, -0.0171212, 0.0970292> }
	smooth_triangle { <0.291532, 5.68935, -1.06845>, <0.780056, -0.108702, 0.616195>, <0.296096, 5.68749, -1.08268>, <0.995134, -0.0171212, 0.0970292>, <0.296096, 5.69173, -1.08193> , <0.995134, -0.0171212, 0.0970292> }
	smooth_triangle { <0.296096, 5.68749, -1.08268>, <0.995134, -0.0171212, 0.0970292>, <0.291532, 5.68935, -1.06845>, <0.780056, -0.108702, 0.616195>, <0.291532, 5.68511, -1.0692> , <0.780056, -0.108702, 0.616195> }
	smooth_triangle { <0.283926, 5.68856, -1.06395>, <0.514548, -0.148971, 0.844422>, <0.291532, 5.68511, -1.0692>, <0.780056, -0.108702, 0.616195>, <0.291532, 5.68935, -1.06845> , <0.780056, -0.108702, 0.616195> }
	smooth_triangle { <0.291532, 5.68511, -1.0692>, <0.780056, -0.108702, 0.616195>, <0.283926, 5.68856, -1.06395>, <0.514548, -0.148971, 0.844422>, <0.283926, 5.68432, -1.0647> , <0.514548, -0.148971, 0.844422> }
	smooth_triangle { <0.274798, 5.68935, -1.06845>, <-0.447232, -0.155312, 0.88083>, <0.283926, 5.68432, -1.0647>, <-0.447232, -0.155312, 0.88083>, <0.283926, 5.68856, -1.06395> , <-0.447232, -0.155312, 0.88083> }
	smooth_triangle { <0.283926, 5.68432, -1.0647>, <-0.447232, -0.155312, 0.88083>, <0.274798, 5.68935, -1.06845>, <-0.447232, -0.155312, 0.88083>, <0.274798, 5.68511, -1.0692> , <-0.447232, -0.155312, 0.88083> }
	smooth_triangle { <0.273278, 5.68696, -1.07968>, <-0.985645, -0.0293196, 0.166265>, <0.274798, 5.68935, -1.06845>, <-0.989966, -0.0245503, 0.13916>, <0.273278, 5.6912, -1.07894> , <-0.985645, -0.0293196, 0.166265> }
	smooth_triangle { <0.274798, 5.68935, -1.06845>, <-0.989966, -0.0245503, 0.13916>, <0.273278, 5.68696, -1.07968>, <-0.985645, -0.0293196, 0.166265>, <0.274798, 5.68511, -1.0692> , <-0.989966, -0.0245503, 0.13916> }
	smooth_triangle { <0.271756, 5.68828, -1.08717>, <-0.98056, -0.0340662, 0.193241>, <0.273278, 5.6912, -1.07894>, <-0.985645, -0.0293196, 0.166265>, <0.271756, 5.69252, -1.08643> , <-0.98056, -0.0340662, 0.193241> }
	smooth_triangle { <0.273278, 5.6912, -1.07894>, <-0.985645, -0.0293196, 0.166265>, <0.271756, 5.68828, -1.08717>, <-0.98056, -0.0340662, 0.193241>, <0.273278, 5.68696, -1.07968> , <-0.985645, -0.0293196, 0.166265> }
	smooth_triangle { <0.245896, 5.69278, -1.08792>, <-0.0587158, -0.1734, 0.9831>, <0.271756, 5.68828, -1.08717>, <-0.0587158, -0.1734, 0.9831>, <0.271756, 5.69252, -1.08643> , <-0.0587158, -0.1734, 0.9831> }
	smooth_triangle { <0.271756, 5.68828, -1.08717>, <-0.0587158, -0.1734, 0.9831>, <0.245896, 5.69278, -1.08792>, <-0.0587158, -0.1734, 0.9831>, <0.245896, 5.68854, -1.08867> , <-0.0587158, -0.1734, 0.9831> }
	smooth_triangle { <0.23829, 5.68988, -1.07145>, <0.85572, -0.0898216, 0.509583>, <0.245896, 5.68854, -1.08867>, <0.910361, -0.071843, 0.407531>, <0.245896, 5.69278, -1.08792> , <0.910361, -0.071843, 0.407531> }
	smooth_triangle { <0.245896, 5.68854, -1.08867>, <0.910361, -0.071843, 0.407531>, <0.23829, 5.68988, -1.07145>, <0.85572, -0.0898216, 0.509583>, <0.23829, 5.68564, -1.07219> , <0.85572, -0.0898216, 0.509583> }
	smooth_triangle { <0.227641, 5.6875, -1.05796>, <0.707109, -0.122764, 0.696366>, <0.23829, 5.68564, -1.07219>, <0.85572, -0.0898216, 0.509583>, <0.23829, 5.68988, -1.07145> , <0.85572, -0.0898216, 0.509583> }
	smooth_triangle { <0.23829, 5.68564, -1.07219>, <0.85572, -0.0898216, 0.509583>, <0.227641, 5.6875, -1.05796>, <0.707109, -0.122764, 0.696366>, <0.227641, 5.68326, -1.05871> , <0.707109, -0.122764, 0.696366> }
	smooth_triangle { <0.21395, 5.68565, -1.04748>, <0.430097, -0.156847, 0.889053>, <0.227641, 5.68326, -1.05871>, <0.707109, -0.122764, 0.696366>, <0.227641, 5.6875, -1.05796> , <0.707109, -0.122764, 0.696366> }
	smooth_triangle { <0.227641, 5.68326, -1.05871>, <0.707109, -0.122764, 0.696366>, <0.21395, 5.68565, -1.04748>, <0.430097, -0.156847, 0.889053>, <0.21395, 5.68141, -1.04822> , <0.430097, -0.156847, 0.889053> }
	smooth_triangle { <0.195349, 5.6849, -1.04322>, <0.00853015, -0.173722, 0.984758>, <0.21395, 5.68141, -1.04822>, <0.430097, -0.156847, 0.889053>, <0.21395, 5.68565, -1.04748> , <0.430097, -0.156847, 0.889053> }
	smooth_triangle { <0.21395, 5.68141, -1.04822>, <0.430097, -0.156847, 0.889053>, <0.195349, 5.6849, -1.04322>, <0.00853015, -0.173722, 0.984758>, <0.195349, 5.68066, -1.04397> , <0.00853015, -0.173722, 0.984758> }
	smooth_triangle { <0.179549, 5.68549, -1.04656>, <-0.477867, -0.152517, 0.865091>, <0.195349, 5.68066, -1.04397>, <0.00853015, -0.173722, 0.984758>, <0.195349, 5.6849, -1.04322> , <0.00853015, -0.173722, 0.984758> }
	smooth_triangle { <0.195349, 5.68066, -1.04397>, <0.00853015, -0.173722, 0.984758>, <0.179549, 5.68549, -1.04656>, <-0.477867, -0.152517, 0.865091>, <0.179549, 5.68125, -1.0473> , <-0.477867, -0.152517, 0.865091> }
	smooth_triangle { <0.171648, 5.68262, -1.05508>, <-0.707102, -0.122778, 0.696371>, <0.179549, 5.68549, -1.04656>, <-0.477867, -0.152517, 0.865091>, <0.171648, 5.68686, -1.05434> , <-0.707102, -0.122778, 0.696371> }
	smooth_triangle { <0.179549, 5.68549, -1.04656>, <-0.477867, -0.152517, 0.865091>, <0.171648, 5.68262, -1.05508>, <-0.707102, -0.122778, 0.696371>, <0.179549, 5.68125, -1.0473> , <-0.477867, -0.152517, 0.865091> }
	smooth_triangle { <0.162619, 5.68419, -1.06398>, <-0.745165, -0.115862, 0.656739>, <0.171648, 5.68686, -1.05434>, <-0.707102, -0.122778, 0.696371>, <0.162619, 5.68843, -1.06323> , <-0.745165, -0.115862, 0.656739> }
	smooth_triangle { <0.171648, 5.68686, -1.05434>, <-0.707102, -0.122778, 0.696371>, <0.162619, 5.68419, -1.06398>, <-0.745165, -0.115862, 0.656739>, <0.171648, 5.68262, -1.05508> , <-0.707102, -0.122778, 0.696371> }
	smooth_triangle { <0.158105, 5.68517, -1.06953>, <-0.780937, -0.108564, 0.615103>, <0.162619, 5.68843, -1.06323>, <-0.745165, -0.115862, 0.656739>, <0.158105, 5.68941, -1.06879> , <-0.780937, -0.108564, 0.615103> }
	smooth_triangle { <0.162619, 5.68843, -1.06323>, <-0.745165, -0.115862, 0.656739>, <0.158105, 5.68517, -1.06953>, <-0.780937, -0.108564, 0.615103>, <0.162619, 5.68419, -1.06398> , <-0.745165, -0.115862, 0.656739> }
	smooth_triangle { <0.0362144, 5.68921, -1.06767>, <0.00926893, -0.173585, 0.984775>, <0.158105, 5.68517, -1.06953>, <0.00926893, -0.173585, 0.984775>, <0.158105, 5.68941, -1.06879> , <0.00926893, -0.173585, 0.984775> }
	smooth_triangle { <0.158105, 5.68517, -1.06953>, <0.00926893, -0.173585, 0.984775>, <0.0362144, 5.68921, -1.06767>, <0.00926893, -0.173585, 0.984775>, <0.0362144, 5.68497, -1.06842> , <0.00926893, -0.173585, 0.984775> }
	smooth_triangle { <0.0363115, 5.69039, -1.09916>, <-0.999995, 0.000540911, -0.00306373>, <0.0362144, 5.68921, -1.06767>, <-0.999995, 0.000540911, -0.00306373>, <0.0363115, 5.69463, -1.09841> , <-0.999995, 0.000540911, -0.00306373> }
	smooth_triangle { <0.0362144, 5.68921, -1.06767>, <-0.999995, 0.000540911, -0.00306373>, <0.0363115, 5.69039, -1.09916>, <-0.999995, 0.000540911, -0.00306373>, <0.0362144, 5.68497, -1.06842> , <-0.999995, 0.000540911, -0.00306373> }
	smooth_triangle { <0.21395, 5.68565, -1.04748>, <7.89488e-006, -0.984766, -0.173886>, <0.179549, 5.68549, -1.04656>, <7.89488e-006, -0.984766, -0.173886>, <0.195349, 5.6849, -1.04322> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.21395, 5.68565, -1.04748>, <7.89488e-006, -0.984766, -0.173886>, <0.171648, 5.68686, -1.05434>, <7.89488e-006, -0.984766, -0.173886>, <0.179549, 5.68549, -1.04656> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.227641, 5.6875, -1.05796>, <7.89488e-006, -0.984766, -0.173886>, <0.171648, 5.68686, -1.05434>, <7.89488e-006, -0.984766, -0.173886>, <0.21395, 5.68565, -1.04748> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.227641, 5.6875, -1.05796>, <7.89488e-006, -0.984766, -0.173886>, <0.162619, 5.68843, -1.06323>, <7.89488e-006, -0.984766, -0.173886>, <0.171648, 5.68686, -1.05434> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.227641, 5.6875, -1.05796>, <7.89488e-006, -0.984766, -0.173886>, <0.158105, 5.68941, -1.06879>, <7.89488e-006, -0.984766, -0.173886>, <0.162619, 5.68843, -1.06323> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.158105, 5.68941, -1.06879>, <7.89488e-006, -0.984766, -0.173886>, <0.227641, 5.6875, -1.05796>, <7.89488e-006, -0.984766, -0.173886>, <0.23829, 5.68988, -1.07145> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.23829, 5.68988, -1.07145>, <7.89488e-006, -0.984766, -0.173886>, <0.0362144, 5.68921, -1.06767>, <7.89488e-006, -0.984766, -0.173886>, <0.158105, 5.68941, -1.06879> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.245896, 5.69278, -1.08792>, <7.89488e-006, -0.984766, -0.173886>, <0.0362144, 5.68921, -1.06767>, <7.89488e-006, -0.984766, -0.173886>, <0.23829, 5.68988, -1.07145> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.0362144, 5.68921, -1.06767>, <7.89488e-006, -0.984766, -0.173886>, <0.245896, 5.69278, -1.08792>, <7.89488e-006, -0.984766, -0.173886>, <0.0363115, 5.69463, -1.09841> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.291532, 5.68935, -1.06845>, <7.89488e-006, -0.984766, -0.173886>, <0.274798, 5.68935, -1.06845>, <7.89488e-006, -0.984766, -0.173886>, <0.283926, 5.68856, -1.06395> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.291532, 5.68935, -1.06845>, <7.89488e-006, -0.984766, -0.173886>, <0.273278, 5.6912, -1.07894>, <7.89488e-006, -0.984766, -0.173886>, <0.274798, 5.68935, -1.06845> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.296096, 5.69173, -1.08193>, <7.89488e-006, -0.984766, -0.173886>, <0.273278, 5.6912, -1.07894>, <7.89488e-006, -0.984766, -0.173886>, <0.291532, 5.68935, -1.06845> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.296096, 5.69173, -1.08193>, <7.89488e-006, -0.984766, -0.173886>, <0.271756, 5.69252, -1.08643>, <7.89488e-006, -0.984766, -0.173886>, <0.273278, 5.6912, -1.07894> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.245896, 5.69278, -1.08792>, <7.89488e-006, -0.984766, -0.173886>, <0.293053, 5.69595, -1.1059>, <7.89488e-006, -0.984766, -0.173886>, <0.0363115, 5.69463, -1.09841> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.271756, 5.69252, -1.08643>, <7.89488e-006, -0.984766, -0.173886>, <0.293053, 5.69595, -1.1059>, <7.89488e-006, -0.984766, -0.173886>, <0.245896, 5.69278, -1.08792> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <0.293053, 5.69595, -1.1059>, <7.89488e-006, -0.984766, -0.173886>, <0.271756, 5.69252, -1.08643>, <7.89488e-006, -0.984766, -0.173886>, <0.296096, 5.69173, -1.08193> , <7.89488e-006, -0.984766, -0.173886> }
	smooth_triangle { <-0.0357138, 5.68024, -1.14021>, <-0.868318, -0.488474, -0.0861254>, <-0.0395551, 5.67017, -1.02911>, <-0.966613, -0.252349, -0.0444945>, <-0.0395551, 5.68947, -1.13859> , <-0.966613, -0.252349, -0.0444945> }
	smooth_triangle { <-0.0395551, 5.67017, -1.02911>, <-0.966613, -0.252349, -0.0444945>, <-0.0357138, 5.68024, -1.14021>, <-0.868318, -0.488474, -0.0861254>, <-0.0357138, 5.66093, -1.03074> , <-0.868318, -0.488474, -0.0861254> }
	smooth_triangle { <-0.0296029, 5.67231, -1.14161>, <-0.710862, -0.692647, -0.122131>, <-0.0357138, 5.66093, -1.03074>, <-0.868318, -0.488474, -0.0861254>, <-0.0357138, 5.68024, -1.14021> , <-0.868318, -0.488474, -0.0861254> }
	smooth_triangle { <-0.0357138, 5.66093, -1.03074>, <-0.868318, -0.488474, -0.0861254>, <-0.0296029, 5.67231, -1.14161>, <-0.710862, -0.692647, -0.122131>, <-0.0296029, 5.653, -1.03213> , <-0.710862, -0.692647, -0.122131> }
	smooth_triangle { <-0.0296029, 5.67231, -1.14161>, <-0.710862, -0.692647, -0.122131>, <-0.0216377, 5.64692, -1.03321>, <-0.50403, -0.850564, -0.149982>, <-0.0296029, 5.653, -1.03213> , <-0.710862, -0.692647, -0.122131> }
	smooth_triangle { <-0.0216377, 5.64692, -1.03321>, <-0.50403, -0.850564, -0.149982>, <-0.0296029, 5.67231, -1.14161>, <-0.710862, -0.692647, -0.122131>, <-0.0216377, 5.66622, -1.14269> , <-0.50403, -0.850564, -0.149982> }
	smooth_triangle { <-0.0216377, 5.66622, -1.14269>, <-0.50403, -0.850564, -0.149982>, <-0.0123636, 5.64309, -1.03388>, <-0.26136, -0.950577, -0.167611>, <-0.0216377, 5.64692, -1.03321> , <-0.50403, -0.850564, -0.149982> }
	smooth_triangle { <-0.0123636, 5.64309, -1.03388>, <-0.26136, -0.950577, -0.167611>, <-0.0216377, 5.66622, -1.14269>, <-0.50403, -0.850564, -0.149982>, <-0.0123636, 5.6624, -1.14336> , <-0.26136, -0.950577, -0.167611> }
	smooth_triangle { <-0.0123636, 5.6624, -1.14336>, <-0.26136, -0.950577, -0.167611>, <-0.00241063, 5.64179, -1.03411>, <-6.53905e-007, -0.984808, -0.173647>, <-0.0123636, 5.64309, -1.03388> , <-0.26136, -0.950577, -0.167611> }
	smooth_triangle { <-0.00241063, 5.64179, -1.03411>, <-6.53905e-007, -0.984808, -0.173647>, <-0.0123636, 5.6624, -1.14336>, <-0.26136, -0.950577, -0.167611>, <-0.00241063, 5.66109, -1.14359> , <-6.53905e-007, -0.984808, -0.173647> }
	smooth_triangle { <-0.00241063, 5.64179, -1.03411>, <-6.53905e-007, -0.984808, -0.173647>, <0.00754245, 5.6624, -1.14336>, <0.261359, -0.950577, -0.167618>, <0.00754245, 5.64309, -1.03388> , <0.261359, -0.950577, -0.167618> }
	smooth_triangle { <0.00754245, 5.6624, -1.14336>, <0.261359, -0.950577, -0.167618>, <-0.00241063, 5.64179, -1.03411>, <-6.53905e-007, -0.984808, -0.173647>, <-0.00241063, 5.66109, -1.14359> , <-6.53905e-007, -0.984808, -0.173647> }
	smooth_triangle { <0.00754245, 5.64309, -1.03388>, <0.261359, -0.950577, -0.167618>, <0.0168166, 5.66622, -1.14269>, <0.504029, -0.850566, -0.149975>, <0.0168166, 5.64692, -1.03321> , <0.504029, -0.850566, -0.149975> }
	smooth_triangle { <0.0168166, 5.66622, -1.14269>, <0.504029, -0.850566, -0.149975>, <0.00754245, 5.64309, -1.03388>, <0.261359, -0.950577, -0.167618>, <0.00754245, 5.6624, -1.14336> , <0.261359, -0.950577, -0.167618> }
	smooth_triangle { <0.0168166, 5.64692, -1.03321>, <0.504029, -0.850566, -0.149975>, <0.0247818, 5.67231, -1.14161>, <0.710862, -0.692648, -0.122125>, <0.0247818, 5.653, -1.03213> , <0.710862, -0.692648, -0.122125> }
	smooth_triangle { <0.0247818, 5.67231, -1.14161>, <0.710862, -0.692648, -0.122125>, <0.0168166, 5.64692, -1.03321>, <0.504029, -0.850566, -0.149975>, <0.0168166, 5.66622, -1.14269> , <0.504029, -0.850566, -0.149975> }
	smooth_triangle { <0.0308927, 5.66093, -1.03074>, <0.868318, -0.488473, -0.0861282>, <0.0247818, 5.67231, -1.14161>, <0.710862, -0.692648, -0.122125>, <0.0308927, 5.68024, -1.14021> , <0.868318, -0.488473, -0.0861282> }
	smooth_triangle { <0.0247818, 5.67231, -1.14161>, <0.710862, -0.692648, -0.122125>, <0.0308927, 5.66093, -1.03074>, <0.868318, -0.488473, -0.0861282>, <0.0247818, 5.653, -1.03213> , <0.710862, -0.692648, -0.122125> }
	smooth_triangle { <0.034734, 5.67017, -1.02911>, <0.966604, -0.252382, -0.0444991>, <0.0308927, 5.68024, -1.14021>, <0.868318, -0.488473, -0.0861282>, <0.034734, 5.68947, -1.13859> , <0.966604, -0.252382, -0.0444991> }
	smooth_triangle { <0.0308927, 5.68024, -1.14021>, <0.868318, -0.488473, -0.0861282>, <0.034734, 5.67017, -1.02911>, <0.966604, -0.252382, -0.0444991>, <0.0308927, 5.66093, -1.03074> , <0.868318, -0.488473, -0.0861282> }
	smooth_triangle { <0.0360451, 5.68008, -1.02736>, <1, 1.7191e-005, 4.25924e-006>, <0.034734, 5.68947, -1.13859>, <0.966604, -0.252382, -0.0444991>, <0.0360451, 5.69938, -1.13684> , <1, 1.7191e-005, 4.25924e-006> }
	smooth_triangle { <0.034734, 5.68947, -1.13859>, <0.966604, -0.252382, -0.0444991>, <0.0360451, 5.68008, -1.02736>, <1, 1.7191e-005, 4.25924e-006>, <0.034734, 5.67017, -1.02911> , <0.966604, -0.252382, -0.0444991> }
	smooth_triangle { <0.034734, 5.68999, -1.02561>, <0.966602, 0.252389, 0.044501>, <0.0360451, 5.69938, -1.13684>, <1, 1.7191e-005, 4.25924e-006>, <0.034734, 5.70929, -1.13509> , <0.966602, 0.252389, 0.044501> }
	smooth_triangle { <0.0360451, 5.69938, -1.13684>, <1, 1.7191e-005, 4.25924e-006>, <0.034734, 5.68999, -1.02561>, <0.966602, 0.252389, 0.044501>, <0.0360451, 5.68008, -1.02736> , <1, 1.7191e-005, 4.25924e-006> }
	smooth_triangle { <0.0308927, 5.69922, -1.02398>, <0.868323, 0.488464, 0.0861301>, <0.034734, 5.70929, -1.13509>, <0.966602, 0.252389, 0.044501>, <0.0308927, 5.71853, -1.13346> , <0.868323, 0.488464, 0.0861301> }
	smooth_triangle { <0.034734, 5.70929, -1.13509>, <0.966602, 0.252389, 0.044501>, <0.0308927, 5.69922, -1.02398>, <0.868323, 0.488464, 0.0861301>, <0.034734, 5.68999, -1.02561> , <0.966602, 0.252389, 0.044501> }
	smooth_triangle { <0.0247818, 5.70715, -1.02259>, <0.710847, 0.692661, 0.122135>, <0.0308927, 5.71853, -1.13346>, <0.868323, 0.488464, 0.0861301>, <0.0247818, 5.72646, -1.13206> , <0.710847, 0.692661, 0.122135> }
	smooth_triangle { <0.0308927, 5.71853, -1.13346>, <0.868323, 0.488464, 0.0861301>, <0.0247818, 5.70715, -1.02259>, <0.710847, 0.692661, 0.122135>, <0.0308927, 5.69922, -1.02398> , <0.868323, 0.488464, 0.0861301> }
	smooth_triangle { <0.0247818, 5.70715, -1.02259>, <0.710847, 0.692661, 0.122135>, <0.0168166, 5.73254, -1.13099>, <0.504005, 0.85058, 0.149976>, <0.0168166, 5.71324, -1.02151> , <0.504005, 0.85058, 0.149976> }
	smooth_triangle { <0.0168166, 5.73254, -1.13099>, <0.504005, 0.85058, 0.149976>, <0.0247818, 5.70715, -1.02259>, <0.710847, 0.692661, 0.122135>, <0.0247818, 5.72646, -1.13206> , <0.710847, 0.692661, 0.122135> }
	smooth_triangle { <0.0168166, 5.71324, -1.02151>, <0.504005, 0.85058, 0.149976>, <0.00754245, 5.73637, -1.13032>, <0.261388, 0.95057, 0.16761>, <0.00754245, 5.71706, -1.02084> , <0.261388, 0.95057, 0.16761> }
	smooth_triangle { <0.00754245, 5.73637, -1.13032>, <0.261388, 0.95057, 0.16761>, <0.0168166, 5.71324, -1.02151>, <0.504005, 0.85058, 0.149976>, <0.0168166, 5.73254, -1.13099> , <0.504005, 0.85058, 0.149976> }
	smooth_triangle { <0.00754245, 5.71706, -1.02084>, <0.261388, 0.95057, 0.16761>, <-0.00241063, 5.73767, -1.13009>, <-4.5849e-006, 0.984808, 0.173647>, <-0.00241063, 5.71837, -1.02061> , <-4.5849e-006, 0.984808, 0.173647> }
	smooth_triangle { <-0.00241063, 5.73767, -1.13009>, <-4.5849e-006, 0.984808, 0.173647>, <0.00754245, 5.71706, -1.02084>, <0.261388, 0.95057, 0.16761>, <0.00754245, 5.73637, -1.13032> , <0.261388, 0.95057, 0.16761> }
	smooth_triangle { <-0.00241063, 5.73767, -1.13009>, <-4.5849e-006, 0.984808, 0.173647>, <-0.012363, 5.71706, -1.02084>, <-0.261382, 0.950572, 0.167607>, <-0.00241063, 5.71837, -1.02061> , <-4.5849e-006, 0.984808, 0.173647> }
	smooth_triangle { <-0.012363, 5.71706, -1.02084>, <-0.261382, 0.950572, 0.167607>, <-0.00241063, 5.73767, -1.13009>, <-4.5849e-006, 0.984808, 0.173647>, <-0.012363, 5.73637, -1.13032> , <-0.261382, 0.950572, 0.167607> }
	smooth_triangle { <-0.012363, 5.73637, -1.13032>, <-0.261382, 0.950572, 0.167607>, <-0.0216377, 5.71324, -1.02151>, <-0.503995, 0.850585, 0.149982>, <-0.012363, 5.71706, -1.02084> , <-0.261382, 0.950572, 0.167607> }
	smooth_triangle { <-0.0216377, 5.71324, -1.02151>, <-0.503995, 0.850585, 0.149982>, <-0.012363, 5.73637, -1.13032>, <-0.261382, 0.950572, 0.167607>, <-0.0216377, 5.73254, -1.13099> , <-0.503995, 0.850585, 0.149982> }
	smooth_triangle { <-0.0216377, 5.73254, -1.13099>, <-0.503995, 0.850585, 0.149982>, <-0.0296029, 5.70715, -1.02259>, <-0.710847, 0.692661, 0.122135>, <-0.0216377, 5.71324, -1.02151> , <-0.503995, 0.850585, 0.149982> }
	smooth_triangle { <-0.0296029, 5.70715, -1.02259>, <-0.710847, 0.692661, 0.122135>, <-0.0216377, 5.73254, -1.13099>, <-0.503995, 0.850585, 0.149982>, <-0.0296029, 5.72646, -1.13206> , <-0.710847, 0.692661, 0.122135> }
	smooth_triangle { <-0.0357138, 5.71853, -1.13346>, <-0.868323, 0.488465, 0.0861258>, <-0.0296029, 5.70715, -1.02259>, <-0.710847, 0.692661, 0.122135>, <-0.0296029, 5.72646, -1.13206> , <-0.710847, 0.692661, 0.122135> }
	smooth_triangle { <-0.0296029, 5.70715, -1.02259>, <-0.710847, 0.692661, 0.122135>, <-0.0357138, 5.71853, -1.13346>, <-0.868323, 0.488465, 0.0861258>, <-0.0357138, 5.69922, -1.02398> , <-0.868323, 0.488465, 0.0861258> }
	smooth_triangle { <-0.0395551, 5.70929, -1.13509>, <-0.966611, 0.252357, 0.0444949>, <-0.0357138, 5.69922, -1.02398>, <-0.868323, 0.488465, 0.0861258>, <-0.0357138, 5.71853, -1.13346> , <-0.868323, 0.488465, 0.0861258> }
	smooth_triangle { <-0.0357138, 5.69922, -1.02398>, <-0.868323, 0.488465, 0.0861258>, <-0.0395551, 5.70929, -1.13509>, <-0.966611, 0.252357, 0.0444949>, <-0.0395551, 5.68999, -1.02561> , <-0.966611, 0.252357, 0.0444949> }
	smooth_triangle { <-0.0408655, 5.69938, -1.13684>, <-1, 1.7589e-005, 1.92345e-006>, <-0.0395551, 5.68999, -1.02561>, <-0.966611, 0.252357, 0.0444949>, <-0.0395551, 5.70929, -1.13509> , <-0.966611, 0.252357, 0.0444949> }
	smooth_triangle { <-0.0395551, 5.68999, -1.02561>, <-0.966611, 0.252357, 0.0444949>, <-0.0408655, 5.69938, -1.13684>, <-1, 1.7589e-005, 1.92345e-006>, <-0.0408655, 5.68008, -1.02736> , <-1, 1.7589e-005, 1.92345e-006> }
	smooth_triangle { <-0.0395551, 5.68947, -1.13859>, <-0.966613, -0.252349, -0.0444945>, <-0.0408655, 5.68008, -1.02736>, <-1, 1.7589e-005, 1.92345e-006>, <-0.0408655, 5.69938, -1.13684> , <-1, 1.7589e-005, 1.92345e-006> }
	smooth_triangle { <-0.0408655, 5.68008, -1.02736>, <-1, 1.7589e-005, 1.92345e-006>, <-0.0395551, 5.68947, -1.13859>, <-0.966613, -0.252349, -0.0444945>, <-0.0395551, 5.67017, -1.02911> , <-0.966613, -0.252349, -0.0444945> }
	smooth_triangle { <-0.21863, 5.68205, -1.04811>, <7.22091e-006, 0.984787, 0.173765>, <-0.184228, 5.68189, -1.04719>, <7.22091e-006, 0.984787, 0.173765>, <-0.200029, 5.6813, -1.04386> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.21863, 5.68205, -1.04811>, <7.22091e-006, 0.984787, 0.173765>, <-0.176328, 5.68326, -1.05497>, <7.22091e-006, 0.984787, 0.173765>, <-0.184228, 5.68189, -1.04719> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.232321, 5.6839, -1.0586>, <7.22091e-006, 0.984787, 0.173765>, <-0.176328, 5.68326, -1.05497>, <7.22091e-006, 0.984787, 0.173765>, <-0.21863, 5.68205, -1.04811> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.232321, 5.6839, -1.0586>, <7.22091e-006, 0.984787, 0.173765>, <-0.167299, 5.68483, -1.06386>, <7.22091e-006, 0.984787, 0.173765>, <-0.176328, 5.68326, -1.05497> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.232321, 5.6839, -1.0586>, <7.22091e-006, 0.984787, 0.173765>, <-0.162785, 5.68581, -1.06942>, <7.22091e-006, 0.984787, 0.173765>, <-0.167299, 5.68483, -1.06386> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.162785, 5.68581, -1.06942>, <7.22091e-006, 0.984787, 0.173765>, <-0.232321, 5.6839, -1.0586>, <7.22091e-006, 0.984787, 0.173765>, <-0.24297, 5.68628, -1.07208> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.24297, 5.68628, -1.07208>, <7.22091e-006, 0.984787, 0.173765>, <-0.0408951, 5.68562, -1.06831>, <7.22091e-006, 0.984787, 0.173765>, <-0.162785, 5.68581, -1.06942> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.250576, 5.68919, -1.08856>, <7.22091e-006, 0.984787, 0.173765>, <-0.0408951, 5.68562, -1.06831>, <7.22091e-006, 0.984787, 0.173765>, <-0.24297, 5.68628, -1.07208> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.0408951, 5.68562, -1.06831>, <7.22091e-006, 0.984787, 0.173765>, <-0.250576, 5.68919, -1.08856>, <7.22091e-006, 0.984787, 0.173765>, <-0.0409915, 5.69104, -1.09905> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.296212, 5.68575, -1.06908>, <7.22091e-006, 0.984787, 0.173765>, <-0.279478, 5.68575, -1.06908>, <7.22091e-006, 0.984787, 0.173765>, <-0.288606, 5.68496, -1.06459> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.296212, 5.68575, -1.06908>, <7.22091e-006, 0.984787, 0.173765>, <-0.277958, 5.6876, -1.07957>, <7.22091e-006, 0.984787, 0.173765>, <-0.279478, 5.68575, -1.06908> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.300775, 5.68813, -1.08257>, <7.22091e-006, 0.984787, 0.173765>, <-0.277958, 5.6876, -1.07957>, <7.22091e-006, 0.984787, 0.173765>, <-0.296212, 5.68575, -1.06908> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.300775, 5.68813, -1.08257>, <7.22091e-006, 0.984787, 0.173765>, <-0.276436, 5.68892, -1.08706>, <7.22091e-006, 0.984787, 0.173765>, <-0.277958, 5.6876, -1.07957> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.250576, 5.68919, -1.08856>, <7.22091e-006, 0.984787, 0.173765>, <-0.297733, 5.69236, -1.10654>, <7.22091e-006, 0.984787, 0.173765>, <-0.0409915, 5.69104, -1.09905> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.276436, 5.68892, -1.08706>, <7.22091e-006, 0.984787, 0.173765>, <-0.297733, 5.69236, -1.10654>, <7.22091e-006, 0.984787, 0.173765>, <-0.250576, 5.68919, -1.08856> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.297733, 5.69236, -1.10654>, <7.22091e-006, 0.984787, 0.173765>, <-0.276436, 5.68892, -1.08706>, <7.22091e-006, 0.984787, 0.173765>, <-0.300775, 5.68813, -1.08257> , <7.22091e-006, 0.984787, 0.173765> }
	smooth_triangle { <-0.0408951, 5.68985, -1.06756>, <0.999995, 0.000536143, -0.00304197>, <-0.0409915, 5.69104, -1.09905>, <0.999995, 0.000536143, -0.00304197>, <-0.0409915, 5.69527, -1.0983> , <0.999995, 0.000536143, -0.00304197> }
	smooth_triangle { <-0.0409915, 5.69104, -1.09905>, <0.999995, 0.000536143, -0.00304197>, <-0.0408951, 5.68985, -1.06756>, <0.999995, 0.000536143, -0.00304197>, <-0.0408951, 5.68562, -1.06831> , <0.999995, 0.000536143, -0.00304197> }
	smooth_triangle { <-0.162785, 5.69005, -1.06867>, <-0.00925669, -0.173693, 0.984756>, <-0.0408951, 5.68562, -1.06831>, <-0.00925669, -0.173693, 0.984756>, <-0.0408951, 5.68985, -1.06756> , <-0.00925669, -0.173693, 0.984756> }
	smooth_triangle { <-0.0408951, 5.68562, -1.06831>, <-0.00925669, -0.173693, 0.984756>, <-0.162785, 5.69005, -1.06867>, <-0.00925669, -0.173693, 0.984756>, <-0.162785, 5.68581, -1.06942> , <-0.00925669, -0.173693, 0.984756> }
	smooth_triangle { <-0.167299, 5.68907, -1.06312>, <0.745143, -0.115796, 0.656775>, <-0.162785, 5.68581, -1.06942>, <0.780852, -0.10848, 0.615226>, <-0.162785, 5.69005, -1.06867> , <0.780852, -0.10848, 0.615226> }
	smooth_triangle { <-0.162785, 5.68581, -1.06942>, <0.780852, -0.10848, 0.615226>, <-0.167299, 5.68907, -1.06312>, <0.745143, -0.115796, 0.656775>, <-0.167299, 5.68483, -1.06386> , <0.745143, -0.115796, 0.656775> }
	smooth_triangle { <-0.176328, 5.6875, -1.05422>, <0.707123, -0.122774, 0.696351>, <-0.167299, 5.68483, -1.06386>, <0.745143, -0.115796, 0.656775>, <-0.167299, 5.68907, -1.06312> , <0.745143, -0.115796, 0.656775> }
	smooth_triangle { <-0.167299, 5.68483, -1.06386>, <0.745143, -0.115796, 0.656775>, <-0.176328, 5.6875, -1.05422>, <0.707123, -0.122774, 0.696351>, <-0.176328, 5.68326, -1.05497> , <0.707123, -0.122774, 0.696351> }
	smooth_triangle { <-0.184228, 5.68613, -1.04644>, <0.477889, -0.152562, 0.865071>, <-0.176328, 5.68326, -1.05497>, <0.707123, -0.122774, 0.696351>, <-0.176328, 5.6875, -1.05422> , <0.707123, -0.122774, 0.696351> }
	smooth_triangle { <-0.176328, 5.68326, -1.05497>, <0.707123, -0.122774, 0.696351>, <-0.184228, 5.68613, -1.04644>, <0.477889, -0.152562, 0.865071>, <-0.184228, 5.68189, -1.04719> , <0.477889, -0.152562, 0.865071> }
	smooth_triangle { <-0.200029, 5.68554, -1.04311>, <-0.00853275, -0.17364, 0.984772>, <-0.184228, 5.68189, -1.04719>, <0.477889, -0.152562, 0.865071>, <-0.184228, 5.68613, -1.04644> , <0.477889, -0.152562, 0.865071> }
	smooth_triangle { <-0.184228, 5.68189, -1.04719>, <0.477889, -0.152562, 0.865071>, <-0.200029, 5.68554, -1.04311>, <-0.00853275, -0.17364, 0.984772>, <-0.200029, 5.6813, -1.04386> , <-0.00853275, -0.17364, 0.984772> }
	smooth_triangle { <-0.21863, 5.68629, -1.04736>, <-0.430094, -0.156738, 0.889074>, <-0.200029, 5.6813, -1.04386>, <-0.00853275, -0.17364, 0.984772>, <-0.200029, 5.68554, -1.04311> , <-0.00853275, -0.17364, 0.984772> }
	smooth_triangle { <-0.200029, 5.6813, -1.04386>, <-0.00853275, -0.17364, 0.984772>, <-0.21863, 5.68629, -1.04736>, <-0.430094, -0.156738, 0.889074>, <-0.21863, 5.68205, -1.04811> , <-0.430094, -0.156738, 0.889074> }
	smooth_triangle { <-0.232321, 5.68814, -1.05785>, <-0.70708, -0.122791, 0.696391>, <-0.21863, 5.68205, -1.04811>, <-0.430094, -0.156738, 0.889074>, <-0.21863, 5.68629, -1.04736> , <-0.430094, -0.156738, 0.889074> }
	smooth_triangle { <-0.21863, 5.68205, -1.04811>, <-0.430094, -0.156738, 0.889074>, <-0.232321, 5.68814, -1.05785>, <-0.70708, -0.122791, 0.696391>, <-0.232321, 5.6839, -1.0586> , <-0.70708, -0.122791, 0.696391> }
	smooth_triangle { <-0.24297, 5.68628, -1.07208>, <-0.855721, -0.0898585, 0.509576>, <-0.232321, 5.68814, -1.05785>, <-0.70708, -0.122791, 0.696391>, <-0.24297, 5.69052, -1.07133> , <-0.855721, -0.0898585, 0.509576> }
	smooth_triangle { <-0.232321, 5.68814, -1.05785>, <-0.70708, -0.122791, 0.696391>, <-0.24297, 5.68628, -1.07208>, <-0.855721, -0.0898585, 0.509576>, <-0.232321, 5.6839, -1.0586> , <-0.70708, -0.122791, 0.696391> }
	smooth_triangle { <-0.250576, 5.68919, -1.08856>, <-0.910364, -0.0718708, 0.40752>, <-0.24297, 5.69052, -1.07133>, <-0.855721, -0.0898585, 0.509576>, <-0.250576, 5.69342, -1.08781> , <-0.910364, -0.0718708, 0.40752> }
	smooth_triangle { <-0.24297, 5.69052, -1.07133>, <-0.855721, -0.0898585, 0.509576>, <-0.250576, 5.68919, -1.08856>, <-0.910364, -0.0718708, 0.40752>, <-0.24297, 5.68628, -1.07208> , <-0.855721, -0.0898585, 0.509576> }
	smooth_triangle { <-0.276436, 5.69316, -1.08631>, <0.05871, -0.173296, 0.983118>, <-0.250576, 5.68919, -1.08856>, <0.05871, -0.173296, 0.983118>, <-0.250576, 5.69342, -1.08781> , <0.05871, -0.173296, 0.983118> }
	smooth_triangle { <-0.250576, 5.68919, -1.08856>, <0.05871, -0.173296, 0.983118>, <-0.276436, 5.69316, -1.08631>, <0.05871, -0.173296, 0.983118>, <-0.276436, 5.68892, -1.08706> , <0.05871, -0.173296, 0.983118> }
	smooth_triangle { <-0.277958, 5.69184, -1.07882>, <0.985645, -0.0293277, 0.166266>, <-0.276436, 5.68892, -1.08706>, <0.980561, -0.0340934, 0.193232>, <-0.276436, 5.69316, -1.08631> , <0.980561, -0.0340934, 0.193232> }
	smooth_triangle { <-0.276436, 5.68892, -1.08706>, <0.980561, -0.0340934, 0.193232>, <-0.277958, 5.69184, -1.07882>, <0.985645, -0.0293277, 0.166266>, <-0.277958, 5.6876, -1.07957> , <0.985645, -0.0293277, 0.166266> }
	smooth_triangle { <-0.279478, 5.68999, -1.06834>, <0.989964, -0.0245392, 0.13917>, <-0.277958, 5.6876, -1.07957>, <0.985645, -0.0293277, 0.166266>, <-0.277958, 5.69184, -1.07882> , <0.985645, -0.0293277, 0.166266> }
	smooth_triangle { <-0.277958, 5.6876, -1.07957>, <0.985645, -0.0293277, 0.166266>, <-0.279478, 5.68999, -1.06834>, <0.989964, -0.0245392, 0.13917>, <-0.279478, 5.68575, -1.06908> , <0.989964, -0.0245392, 0.13917> }
	smooth_triangle { <-0.288606, 5.6892, -1.06384>, <0.447233, -0.155295, 0.880833>, <-0.279478, 5.68575, -1.06908>, <0.447233, -0.155295, 0.880833>, <-0.279478, 5.68999, -1.06834> , <0.447233, -0.155295, 0.880833> }
	smooth_triangle { <-0.279478, 5.68575, -1.06908>, <0.447233, -0.155295, 0.880833>, <-0.288606, 5.6892, -1.06384>, <0.447233, -0.155295, 0.880833>, <-0.288606, 5.68496, -1.06459> , <0.447233, -0.155295, 0.880833> }
	smooth_triangle { <-0.296212, 5.68999, -1.06834>, <-0.780071, -0.108668, 0.616182>, <-0.288606, 5.68496, -1.06459>, <-0.514549, -0.148895, 0.844434>, <-0.288606, 5.6892, -1.06384> , <-0.514549, -0.148895, 0.844434> }
	smooth_triangle { <-0.288606, 5.68496, -1.06459>, <-0.514549, -0.148895, 0.844434>, <-0.296212, 5.68999, -1.06834>, <-0.780071, -0.108668, 0.616182>, <-0.296212, 5.68575, -1.06908> , <-0.780071, -0.108668, 0.616182> }
	smooth_triangle { <-0.300775, 5.68813, -1.08257>, <-0.995134, -0.017124, 0.097031>, <-0.296212, 5.68999, -1.06834>, <-0.780071, -0.108668, 0.616182>, <-0.300775, 5.69237, -1.08182> , <-0.995134, -0.017124, 0.097031> }
	smooth_triangle { <-0.296212, 5.68999, -1.06834>, <-0.780071, -0.108668, 0.616182>, <-0.300775, 5.68813, -1.08257>, <-0.995134, -0.017124, 0.097031>, <-0.296212, 5.68575, -1.06908> , <-0.780071, -0.108668, 0.616182> }
	smooth_triangle { <-0.297733, 5.69236, -1.10654>, <-0.99228, 0.021542, -0.122133>, <-0.300775, 5.69237, -1.08182>, <-0.995134, -0.017124, 0.097031>, <-0.297733, 5.69659, -1.10579> , <-0.99228, 0.021542, -0.122133> }
	smooth_triangle { <-0.300775, 5.69237, -1.08182>, <-0.995134, -0.017124, 0.097031>, <-0.297733, 5.69236, -1.10654>, <-0.99228, 0.021542, -0.122133>, <-0.300775, 5.68813, -1.08257> , <-0.995134, -0.017124, 0.097031> }
	smooth_triangle { <-0.297733, 5.69236, -1.10654>, <0.0296122, 0.173643, -0.984363>, <-0.0409915, 5.69527, -1.0983>, <0.0296122, 0.173643, -0.984363>, <-0.0409915, 5.69104, -1.09905> , <0.0296122, 0.173643, -0.984363> }
	smooth_triangle { <-0.0409915, 5.69527, -1.0983>, <0.0296122, 0.173643, -0.984363>, <-0.297733, 5.69236, -1.10654>, <0.0296122, 0.173643, -0.984363>, <-0.297733, 5.69659, -1.10579> , <0.0296122, 0.173643, -0.984363> }
	smooth_triangle { <-0.0408951, 5.68985, -1.06756>, <-3.04156e-006, 0.9848, 0.173693>, <-0.24297, 5.69052, -1.07133>, <-3.04156e-006, 0.9848, 0.173693>, <-0.162785, 5.69005, -1.06867> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.0408951, 5.68985, -1.06756>, <-3.04156e-006, 0.9848, 0.173693>, <-0.250576, 5.69342, -1.08781>, <-3.04156e-006, 0.9848, 0.173693>, <-0.24297, 5.69052, -1.07133> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.250576, 5.69342, -1.08781>, <-3.04156e-006, 0.9848, 0.173693>, <-0.0408951, 5.68985, -1.06756>, <-3.04156e-006, 0.9848, 0.173693>, <-0.0409915, 5.69527, -1.0983> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.184228, 5.68613, -1.04644>, <-3.04156e-006, 0.9848, 0.173693>, <-0.21863, 5.68629, -1.04736>, <-3.04156e-006, 0.9848, 0.173693>, <-0.200029, 5.68554, -1.04311> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.176328, 5.6875, -1.05422>, <-3.04156e-006, 0.9848, 0.173693>, <-0.21863, 5.68629, -1.04736>, <-3.04156e-006, 0.9848, 0.173693>, <-0.184228, 5.68613, -1.04644> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.176328, 5.6875, -1.05422>, <-3.04156e-006, 0.9848, 0.173693>, <-0.232321, 5.68814, -1.05785>, <-3.04156e-006, 0.9848, 0.173693>, <-0.21863, 5.68629, -1.04736> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.167299, 5.68907, -1.06312>, <-3.04156e-006, 0.9848, 0.173693>, <-0.232321, 5.68814, -1.05785>, <-3.04156e-006, 0.9848, 0.173693>, <-0.176328, 5.6875, -1.05422> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.162785, 5.69005, -1.06867>, <-3.04156e-006, 0.9848, 0.173693>, <-0.232321, 5.68814, -1.05785>, <-3.04156e-006, 0.9848, 0.173693>, <-0.167299, 5.68907, -1.06312> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.232321, 5.68814, -1.05785>, <-3.04156e-006, 0.9848, 0.173693>, <-0.162785, 5.69005, -1.06867>, <-3.04156e-006, 0.9848, 0.173693>, <-0.24297, 5.69052, -1.07133> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.279478, 5.68999, -1.06834>, <-3.04156e-006, 0.9848, 0.173693>, <-0.296212, 5.68999, -1.06834>, <-3.04156e-006, 0.9848, 0.173693>, <-0.288606, 5.6892, -1.06384> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.277958, 5.69184, -1.07882>, <-3.04156e-006, 0.9848, 0.173693>, <-0.296212, 5.68999, -1.06834>, <-3.04156e-006, 0.9848, 0.173693>, <-0.279478, 5.68999, -1.06834> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.277958, 5.69184, -1.07882>, <-3.04156e-006, 0.9848, 0.173693>, <-0.300775, 5.69237, -1.08182>, <-3.04156e-006, 0.9848, 0.173693>, <-0.296212, 5.68999, -1.06834> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.276436, 5.69316, -1.08631>, <-3.04156e-006, 0.9848, 0.173693>, <-0.300775, 5.69237, -1.08182>, <-3.04156e-006, 0.9848, 0.173693>, <-0.277958, 5.69184, -1.07882> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.276436, 5.69316, -1.08631>, <-3.04156e-006, 0.9848, 0.173693>, <-0.297733, 5.69659, -1.10579>, <-3.04156e-006, 0.9848, 0.173693>, <-0.300775, 5.69237, -1.08182> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.250576, 5.69342, -1.08781>, <-3.04156e-006, 0.9848, 0.173693>, <-0.297733, 5.69659, -1.10579>, <-3.04156e-006, 0.9848, 0.173693>, <-0.276436, 5.69316, -1.08631> , <-3.04156e-006, 0.9848, 0.173693> }
	smooth_triangle { <-0.297733, 5.69659, -1.10579>, <-3.04156e-006, 0.9848, 0.173693>, <-0.250576, 5.69342, -1.08781>, <-3.04156e-006, 0.9848, 0.173693>, <-0.0409915, 5.69527, -1.0983> , <-3.04156e-006, 0.9848, 0.173693> }
texture {  T_Chrome_3D }
}

// object ellipse
union {
	smooth_triangle { <-0.0414742, 5.64204, -1.58211>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0261985, 5.64204, -1.58211>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0338362, 5.64181, -1.58084> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0485909, 5.64269, -1.58584>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0261985, 5.64204, -1.58211>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0414742, 5.64204, -1.58211> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0485909, 5.64269, -1.58584>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0190817, 5.64269, -1.58584>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0261985, 5.64204, -1.58211> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0547019, 5.64374, -1.59177>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0190817, 5.64269, -1.58584>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0485909, 5.64269, -1.58584> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0547019, 5.64374, -1.59177>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0129701, 5.64374, -1.59177>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0190817, 5.64269, -1.58584> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0593924, 5.6451, -1.5995>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0129701, 5.64374, -1.59177>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0547019, 5.64374, -1.59177> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0593924, 5.6451, -1.5995>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0082811, 5.6451, -1.5995>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0129701, 5.64374, -1.59177> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.06234, 5.64669, -1.6085>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0082811, 5.6451, -1.5995>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0593924, 5.6451, -1.5995> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.06234, 5.64669, -1.6085>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0053327, 5.64669, -1.6085>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0082811, 5.6451, -1.5995> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0633461, 5.64839, -1.61816>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0053327, 5.64669, -1.6085>, <-6.30904e-005, -0.98479, -0.173747>, <-0.06234, 5.64669, -1.6085> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0633461, 5.64839, -1.61816>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0043274, 5.64839, -1.61816>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0053327, 5.64669, -1.6085> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.06234, 5.6501, -1.62782>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0043274, 5.64839, -1.61816>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0633461, 5.64839, -1.61816> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.06234, 5.6501, -1.62782>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0053327, 5.6501, -1.62782>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0043274, 5.64839, -1.61816> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0593924, 5.65168, -1.63682>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0053327, 5.6501, -1.62782>, <-6.30904e-005, -0.98479, -0.173747>, <-0.06234, 5.6501, -1.62782> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0593924, 5.65168, -1.63682>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0082811, 5.65168, -1.63682>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0053327, 5.6501, -1.62782> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0547019, 5.65305, -1.64455>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0082811, 5.65168, -1.63682>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0593924, 5.65168, -1.63682> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0547019, 5.65305, -1.64455>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0129701, 5.65305, -1.64455>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0082811, 5.65168, -1.63682> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0485909, 5.65409, -1.65048>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0129701, 5.65305, -1.64455>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0547019, 5.65305, -1.64455> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0485909, 5.65409, -1.65048>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0190817, 5.65409, -1.65048>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0129701, 5.65305, -1.64455> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0414742, 5.65475, -1.65421>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0190817, 5.65409, -1.65048>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0485909, 5.65409, -1.65048> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0414742, 5.65475, -1.65421>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0261985, 5.65475, -1.65421>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0190817, 5.65409, -1.65048> , <-6.30904e-005, -0.98479, -0.173747> }
	smooth_triangle { <-0.0261985, 5.65475, -1.65421>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0414742, 5.65475, -1.65421>, <-6.30904e-005, -0.98479, -0.173747>, <-0.0338362, 5.65497, -1.65548> , <-6.30904e-005, -0.98479, -0.173747> }
texture { WhitePlastic }
}

// object ellipse
union {
	smooth_triangle { <-0.038729, 5.64088, -1.58164>, <8.39286e-005, -0.98481, -0.173638>, <-0.02688, 5.64115, -1.58317>, <8.39286e-005, -0.98481, -0.173638>, <-0.032672, 5.64075, -1.58086> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.044002, 5.64154, -1.58538>, <8.39286e-005, -0.98481, -0.173638>, <-0.02688, 5.64115, -1.58317>, <8.39286e-005, -0.98481, -0.173638>, <-0.038729, 5.64088, -1.58164> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.044002, 5.64154, -1.58538>, <8.39286e-005, -0.98481, -0.173638>, <-0.022356, 5.64204, -1.58817>, <8.39286e-005, -0.98481, -0.173638>, <-0.02688, 5.64115, -1.58317> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.047581, 5.64261, -1.59143>, <8.39286e-005, -0.98481, -0.173638>, <-0.022356, 5.64204, -1.58817>, <8.39286e-005, -0.98481, -0.173638>, <-0.044002, 5.64154, -1.58538> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.047581, 5.64261, -1.59143>, <8.39286e-005, -0.98481, -0.173638>, <-0.019879, 5.64324, -1.59501>, <8.39286e-005, -0.98481, -0.173638>, <-0.022356, 5.64204, -1.58817> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.048847, 5.6439, -1.59875>, <8.39286e-005, -0.98481, -0.173638>, <-0.019879, 5.64324, -1.59501>, <8.39286e-005, -0.98481, -0.173638>, <-0.047581, 5.64261, -1.59143> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.048847, 5.6439, -1.59875>, <8.39286e-005, -0.98481, -0.173638>, <-0.019879, 5.64456, -1.60249>, <8.39286e-005, -0.98481, -0.173638>, <-0.019879, 5.64324, -1.59501> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.047581, 5.64519, -1.60606>, <8.39286e-005, -0.98481, -0.173638>, <-0.019879, 5.64456, -1.60249>, <8.39286e-005, -0.98481, -0.173638>, <-0.048847, 5.6439, -1.59875> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.047581, 5.64519, -1.60606>, <8.39286e-005, -0.98481, -0.173638>, <-0.022356, 5.64577, -1.60932>, <8.39286e-005, -0.98481, -0.173638>, <-0.019879, 5.64456, -1.60249> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.044002, 5.64626, -1.61211>, <8.39286e-005, -0.98481, -0.173638>, <-0.022356, 5.64577, -1.60932>, <8.39286e-005, -0.98481, -0.173638>, <-0.047581, 5.64519, -1.60606> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.044002, 5.64626, -1.61211>, <8.39286e-005, -0.98481, -0.173638>, <-0.02688, 5.64665, -1.61432>, <8.39286e-005, -0.98481, -0.173638>, <-0.022356, 5.64577, -1.60932> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.038729, 5.64692, -1.61585>, <8.39286e-005, -0.98481, -0.173638>, <-0.02688, 5.64665, -1.61432>, <8.39286e-005, -0.98481, -0.173638>, <-0.044002, 5.64626, -1.61211> , <8.39286e-005, -0.98481, -0.173638> }
	smooth_triangle { <-0.02688, 5.64665, -1.61432>, <8.39286e-005, -0.98481, -0.173638>, <-0.038729, 5.64692, -1.61585>, <8.39286e-005, -0.98481, -0.173638>, <-0.032672, 5.64705, -1.61663> , <8.39286e-005, -0.98481, -0.173638> }
texture { Black }
}

// object ellipse
union {
	smooth_triangle { <0.0241375, 5.64088, -1.58164>, <8.38912e-005, -0.98481, -0.173638>, <0.0359841, 5.64115, -1.58317>, <8.38912e-005, -0.98481, -0.173638>, <0.0301926, 5.64075, -1.58086> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.0188633, 5.64154, -1.58538>, <8.38912e-005, -0.98481, -0.173638>, <0.0359841, 5.64115, -1.58317>, <8.38912e-005, -0.98481, -0.173638>, <0.0241375, 5.64088, -1.58164> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.0188633, 5.64154, -1.58538>, <8.38912e-005, -0.98481, -0.173638>, <0.0405092, 5.64204, -1.58817>, <8.38912e-005, -0.98481, -0.173638>, <0.0359841, 5.64115, -1.58317> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.015284, 5.64261, -1.59143>, <8.38912e-005, -0.98481, -0.173638>, <0.0405092, 5.64204, -1.58817>, <8.38912e-005, -0.98481, -0.173638>, <0.0188633, 5.64154, -1.58538> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.015284, 5.64261, -1.59143>, <8.38912e-005, -0.98481, -0.173638>, <0.042986, 5.64324, -1.59501>, <8.38912e-005, -0.98481, -0.173638>, <0.0405092, 5.64204, -1.58817> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.014019, 5.6439, -1.59875>, <8.38912e-005, -0.98481, -0.173638>, <0.042986, 5.64324, -1.59501>, <8.38912e-005, -0.98481, -0.173638>, <0.015284, 5.64261, -1.59143> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.014019, 5.6439, -1.59875>, <8.38912e-005, -0.98481, -0.173638>, <0.042986, 5.64456, -1.60249>, <8.38912e-005, -0.98481, -0.173638>, <0.042986, 5.64324, -1.59501> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.015284, 5.64519, -1.60606>, <8.38912e-005, -0.98481, -0.173638>, <0.042986, 5.64456, -1.60249>, <8.38912e-005, -0.98481, -0.173638>, <0.014019, 5.6439, -1.59875> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.015284, 5.64519, -1.60606>, <8.38912e-005, -0.98481, -0.173638>, <0.0405092, 5.64577, -1.60932>, <8.38912e-005, -0.98481, -0.173638>, <0.042986, 5.64456, -1.60249> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.0188633, 5.64626, -1.61211>, <8.38912e-005, -0.98481, -0.173638>, <0.0405092, 5.64577, -1.60932>, <8.38912e-005, -0.98481, -0.173638>, <0.015284, 5.64519, -1.60606> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.0188633, 5.64626, -1.61211>, <8.38912e-005, -0.98481, -0.173638>, <0.0359841, 5.64665, -1.61432>, <8.38912e-005, -0.98481, -0.173638>, <0.0405092, 5.64577, -1.60932> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.0241375, 5.64692, -1.61585>, <8.38912e-005, -0.98481, -0.173638>, <0.0359841, 5.64665, -1.61432>, <8.38912e-005, -0.98481, -0.173638>, <0.0188633, 5.64626, -1.61211> , <8.38912e-005, -0.98481, -0.173638> }
	smooth_triangle { <0.0359841, 5.64665, -1.61432>, <8.38912e-005, -0.98481, -0.173638>, <0.0241375, 5.64692, -1.61585>, <8.38912e-005, -0.98481, -0.173638>, <0.0301926, 5.64705, -1.61663> , <8.38912e-005, -0.98481, -0.173638> }
texture { Black }
}

// object ellipse
union {
	smooth_triangle { <0.0213913, 5.64204, -1.58211>, <-6.30901e-005, -0.98479, -0.173747>, <0.0366661, 5.64204, -1.58211>, <-6.30901e-005, -0.98479, -0.173747>, <0.0290287, 5.64181, -1.58084> , <-6.30901e-005, -0.98479, -0.173747> }
	smooth_triangle { <0.0142744, 5.64269, -1.58584>, <-6.30901e-005, -0.98479, -0.173747>, <0.0366661, 5.64204, -1.58211>, <-6.30901e-005, -0.98479, -0.173747>, <0.0213913, 5.64204, -1.58211> , <-6.30901e-005, -0.98479, -0.173747> }
	smooth_triangle { <0.0142744, 5.64269, -1.58584>, <-6.30901e-005, -0.98479, -0.173747>, <0.0437829, 5.64269, -1.58584>, <-6.30901e-005, -0.98479, -0.173747>, <0.0366661, 5.64204, -1.58211> , <-6.30901e-005, -0.98479, -0.173747> }
	smooth_triangle { <0.00816276, 5.64374, -1.59177>, <-6.30901e-005, -0.98479, -0.173747>, <0.0437829, 5.64269, -1.58584>, <-6.30901e-005, -0.98479, -0.173747>, <0.0142744, 5.64269, -1.58584> , <-6.30901e-005, -0.98479, -0.173747> }
	smooth_triangle { <0.00816276, 5.64374, -1.59177>, <-6.30901e-005, -0.98479, -0.173747>, <0.0498945, 5.64374, -1.59177>, <-6.30901e-005, -0.98479, -0.173747>, <0.0437829, 5.64269, -1.58584> , <-6.30901e-005, -0.98479, -0.173747> }
	smooth_triangle { <0.00347301, 5.6451, -1.5995>, <-6.30901e-005, -0.98479, -0.173747>, <0.0498945, 5.64374, -1.59177>, <-6.30901e-005, -0.98479, -0.173747>, <0.00816276, 5.64374, -1.59177> , <-6.30901e-005, -0.98479, -0.173747> }
	smooth_triangle { <0.00347301, 5.6451, -1.5995>, <-6.30901e-005, -0.98479, -0.173747>, <0.0545851, 5.6451, -1.5995>, <-6.30901e-005, -0.98479, -0.17374