//switches
#declare RAD = true;
#declare ORTO = true;
#declare BLUR = false;

#declare BACK = true;
#declare TRACK = true;
#declare MILL = true;
#declare BOARD = true;
#declare TELE = true;
#declare DESERT = true;
#declare BUSH = true;
#declare CLOUD = true;

//-------------------------------------------------------------------------------
// G L O B A L     S E T T I N G S 
//-------------------------------------------------------------------------------

global_settings {
  assumed_gamma 2.2
   #if (RAD)
    radiosity {
        brightness 2.9
        count 40
        error_bound 0.15
        gray_threshold 1
        low_error_factor 0.2
        minimum_reuse 0.015
        nearest_count 10
        recursion_limit 5
        adc_bailout 0.01
        max_sample -1.0
        media on
        normal off
        always_sample 1
        pretrace_start 0.08
        pretrace_end 0.01
        }
   #end  
} 


#default {
  texture {
    pigment {rgb 1}
      finish {
        ambient 0.0
        diffuse 0.6
        specular 0.3
      }
     }
   }

//-------------------------------------------------------------------------------
// T E X T U R E S
//-------------------------------------------------------------------------------

//---pigments
#declare p_wood1 =<0.392157, 0.203922, 0.176471>*.7;                                                  
#declare p_wood2 =<0.337255, 0.254902, 0.227451>;
#declare p_sand = <0.843137, 0.745098, 0.650980>;
#declare p_cloud = 1;
#declare p_bush =<0.800000, 0.721569, 0.533333>;
#declare p_bush_red =<0.800000, 0.572549, 0.458824>;

//---rail
#declare t_rail_base = texture{
                        pigment{
                                 rgb <0.490196, 0.321569, 0.133333>                                           
                                }
                        }

#declare t_rail_top = texture {
                        pigment {rgb .1}
                        finish {
                            ambient .8
                            brilliance 4
                            diffuse 0.5
                            metallic
                            specular 0.5
                            roughness 0.1
                            reflection 0.5
                         }                         
                        }

#declare t_rail = texture {
                        gradient y
                        texture_map {                                
                                [0.0 t_rail_base]
                                [0.9 t_rail_base]
                                [0.93 t_rail_top]
                                [1.0 t_rail_top]
                                }
                         scale .159
                         //rotate y*45
                        }
                                                
//---wood
#declare t_wood1 = texture {
                        pigment {
                                //wood
                                leopard
                                color_map {
                                [0.0 rgb p_wood2*1.1]
                                [0.8 rgb p_wood2*1.1]
                                [0.8 rgb p_wood1]
                                [1.0 rgb p_wood1]
                                }
                        warp{turbulence 1}
                        lambda 1
                        frequency 20
                        }  
                   }              
#declare t_wood2 = texture {
                        pigment {
                                wood
                                color_map {
                                [0.0 rgb p_wood1]
                                [0.2 rgb p_wood1]
                                [0.5 rgb p_wood2]
                                [0.7 rgbt 1]
                                [1.0 rgbt 1]
                                }
                        warp{turbulence .7}
                        //frequency 2                        
                        }
                }

#declare t_tie = texture {t_wood1                          
                          scale <2,.005,.005>}
                texture {t_wood2
                        rotate y*85
                        scale <2,.1,.1>                                
                        }

#declare t_mill = texture {t_wood1
                          scale <.1,3,.1>}
                texture {t_wood2
                        rotate x*95                        
                        rotate y*85
                        scale <.1,3,.1>}
                                                  

//---ground
#declare t_desert1 = texture {
                        pigment{ 
                                image_map{png "t_desert.png"}
                                rotate x*90
                                }
                        finish {diffuse .8}
                        }
#declare t_desert2 = texture {
                         pigment{
                                rgb p_sand*.2
                                }
                         }

#declare t_ballast = texture {
                        pigment{
                                image_map{png "ballast.png"}                                
                                }
                        normal {                              
                                bump_map {png "bm_ballast.png"}
                                turbulence 2                                                                
                                scale <1,2,1>
                                }
                        rotate x*90                                                                
                        }

#declare t_desert3 =  texture {
                            crackle
                            texture_map {
                                [0 t_desert2]
                                [0.02 t_desert2]
                                [0.02 t_desert1]
                                [1 t_desert1]
                                        }
                            turbulence 1.1                            
                            }      

#declare t_desert = texture{
                        gradient y
                        texture_map{
                                [0.0 t_ballast]
                                [0.3 t_ballast]
                                [0.4 t_desert3]                                
                                [1.0 t_desert3]
                                }
                        translate y*-1.15 
                        turbulence 0.05                                               
                        }


//---board                          
#declare t_white_wood = texture{
                        pigment{ 
                                image_map {
                                        png "wood2.png"
                                        map_type 1
                                        }
                                }
                         }
                         
#declare t_board = texture{
                        pigment{ 
                                image_map {
                                        png "wood2.png"
                                        once
                                        }
                                }
                        rotate z*90                                
                        scale <1.8,1.3,1>
                        translate <.9,-.65,0>                        
                        }
                    texture {
                        pigment {
                                image_map {
                                        png "board.png"
                                        once
                                        transmit 0,1
                                        transmit 15, .12
                                        }                                        
                                }
                        scale <1.8,1.3,1>
                        translate <-.9,-.65,0>
                    }


#declare t_blade_coat = texture {
                        
                        pigment{
                                gradient x
                                color_map {
                                [0.0 rgb <1,0,0>]
                                [0.2 rgb <1,0,0>]
                                [0.2 rgb 1]
                                [1 rgb 1]        
                                }
                              }
                        finish { 
                                ambient 0
                                diffuse .5
                                specular .2
                                }                              
                        } 
#declare t_blade_metal = texture {
                        pigment{                               
                                spotted
                                color_map{
                                [0.0 rgbt 1]
                                [0.7 rgbt 1]
                                [0.7 rgb .3]
                                [1.0 rgb .3]
                                }
                                frequency 1                                
                                turbulence 5
                              }
                        finish{ 
                                ambient 0
                                diffuse .3
                                specular .2
                                reflection .1
                                specular .1
                                roughness .01
                                }
                        }
                        
#declare t_blade_pole = texture {
                        pigment {
                                rgb 1
                                }
                        finish { 
                                ambient 0
                                diffuse .5
                                specular .2
                                }                              
                        }
                texture {t_blade_metal}
                
#declare p_wood = <0.325490, 0.160784, 0.000000>;
#declare t_tele = texture{
                        pigment {
                                wood
                                color_map{
                                [0.0 rgb p_wood*.3]
                                [0.3 rgb p_wood*.3]
                                [0.3 rgb p_wood*.1]
                                [1.0 rgb p_wood*.1]
                                }
                                scale <.05,.1,.05>
                                warp {turbulence .09}
                                //lambda 2
                                //frequency 2.5                                
                                rotate x*91                                
                          }
                        finish  {
                                ambient 0
                                diffuse .5
                                specular .01
                                }                        
                        }
                texture {
                        pigment {
                                gradient y
                                color_map{
                                [0.0 rgb 0]
                                [0.1 rgb 0]
                                [0.6 rgbt 1]
                                [1.0 rgbt 1]
                                }
                                warp{ turbulence .3}
                             }
                        finish { 
                                ambient 0
                                diffuse 0
                                specular .01
                                }
                        scale <1,5,1>
                        }                       

//---bushes
#declare t_bush2 = texture {
                            pigment {
                                     wood
                                     color_map {
                                     [0.0 rgb p_bush*.5]
                                     [1.0 rgbf 1]
                                     }
                                warp {turbulence 2}
                                }
                           rotate z*90                           
                           scale .01
                           }
#declare t_bush1 = texture {
                            pigment{
                                    gradient y
                                    color_map {
                                    [0.0 rgb p_bush]
                                    [1.0 rgb p_bush*.6]
                                    }                            
                            }
                     }

#declare t_bush = texture {t_bush1}          
                  texture {t_bush2}

#declare t_bush_red2 = texture {
                            pigment {
                                     wood
                                     color_map {
                                     [0.0 rgb p_bush_red*.5]
                                     [1.0 rgbf 1]
                                     }
                                warp {turbulence 2}
                                }
                           rotate z*90                           
                           scale .01
                           }
#declare t_bush_red1 = texture {
                            pigment{
                                    gradient y
                                    color_map {
                                    [0.0 rgb p_bush_red]
                                    [1.0 rgb p_bush_red*.6]
                                    }                            
                            }
                     }

#declare t_bush_red = texture {t_bush_red1}          
                  texture {t_bush_red2}

//-----------------------------------------
//    M A C R O S
//-----------------------------------------

#macro make_cable(startP,endP,pole_distance,r)
                      
        #local RADIUS = r;
        #local INCREMENT = RADIUS/8;        
        #local Y = pole_distance /40;
        
        #local MySpline = spline{
                                cubic_spline
                                0, startP
                                0.1, startP
                                0.5,<(startP.x+endP.x)/2,-Y,(startP.z+endP.z)/2>
                                .99, endP
                                1, endP
                                }
        
        union {
        #local j = 0;
        #while (j<=1)
                  sphere {
                    MySpline(j),RADIUS
                  }
                  #local j = j + INCREMENT;
        #end   
        } 
#end

//-------------------------------------------------------------------------------
// O B J E C T S
//-------------------------------------------------------------------------------
#declare sfondo = box {<0,0,-.1>,<1,1,0>
                       texture {
                               pigment {
                                        image_map {sys "sfondo5.bmp"
                                                   //png "sfondo4.png"
                                                   //transmit 0,1
                                                   //filter 0,1
                                                   once}
                                        } 
                                finish{ambient .1
                                        diffuse .4}
                                        //diffuse .7}
                                }
                      clipped_by {
                                  height_field {png "hf_sfondo5.png"
                                  smooth
                                  scale <1.01,10,1.01>
                                  rotate x*-90
                                  translate <0,-.01,1>
                                  scale 1.01
                                  }
                              }
                      translate x*-0.5
                      scale <3000,1000,1>
                      }
                      
  

                       
                        
//---------------------
//object railway tracks
//
#declare bolt = cylinder {<0,0,-.01>,<0,0,.01>,.02}

#declare joiner = union {
                          box{<-.25,-.045,-.03>,<.25,.045,.03>}
                          object{bolt translate <-.1,0,-.035>}
                          object{bolt translate <-.035,0,-.035>}
                          object{bolt translate <.035,0,-.035>}
                          object{bolt translate <.1,0,-.035>}
                          rotate y*90
                          pigment {rgb .1}
                         } 


#declare rail_lenght = 8;
#declare track_lenght = 1000;
                      
#declare rail = union {
                        prism { 
                                linear_sweep
                                linear_spline
                                -rail_lenght/2, rail_lenght/2
                                21
                                <-.07,0>                        
                                <-.07,.01>
                                <-.06,.015>
                                <-.015,.03>
                                <-.01,.07>
                                <-.015,.12>
                                <-.017,.13>
                                <-.035,.14>
                                <-.035,.15>
                                <-.03,.16>                        
                                <.03,.16>
                                <.035,.15>
                                <.035,.14>
                                <.017,.13>
                                <.015,.12>
                                <.01,.07> 
                                <.015,.03>
                                <.06,.015>
                                <.07,.01>                        
                                <.07,0>
                                <-.07,0>
                                //scale .9
                                rotate x*-90
                               }                      
                        object {joiner translate <-.015,.08,rail_lenght/2>}
                        object {joiner rotate y*180 translate <.015,.08,rail_lenght/2>}
                        }

#declare spike = union { 
                        cylinder{<0,0,0>,<0,.06,0>,.03}
                        difference {sphere {0,.06 translate <-.03,.06,0>}
                                    box{<-1,-1,-1>,<1,.06,1>}}
                        scale .5
                        texture {t_rail}
                        }
                         
#declare tie = box {<-1.2,-.09,-.1>,<1.2,.09,.1>}

#declare j = 0;
#declare ties = union { #while (j < track_lenght)
                                object {tie translate <0,-.09,j>}
                                object {spike translate <.8,0,j>}
                                object {spike translate <-.6,0,j>}
                                #declare j = j + .21 + .40;
                        #end
                       } 

#declare j = 0;
#declare rails = union { #while (j < track_lenght)
                                object{rail translate <-.7,0,j>}
                                object{rail translate <.7,0,j-(rail_lenght/2)>}
                                #declare j = j + rail_lenght+.01;
                         #end
                        }

#declare track = union {
                        object{ties texture{t_tie}}
                        object{rails texture{t_rail}}
                        }
                        
//--------------------
//object windmill                        
//
#declare pole_radius = .055;

#declare side = union {
                        cylinder {
                                <0,0,0>,<0,3.5,0>,pole_radius                                
                                rotate z*5
                                translate x*.5
                                }
                        cylinder{
                                <0,-.45,0>,<0,.45,0>,pole_radius   
                                rotate z*90
                                translate <0,1.5,-2*pole_radius>
                                }                                
                        cylinder{
                                <0,-.38,0>,<0,.38,0>,pole_radius   
                                rotate z*90
                                translate <0,2.5,-2*pole_radius>
                                }                                
                        cylinder{
                                <0,-.30,0>,<0,.30,0>,pole_radius   
                                rotate z*90
                                translate <0,3.48,-2*pole_radius>
                                }                                
                        cylinder{<0,-.865,0>,<0,.865,0>,pole_radius/2
                                 rotate z*35
                                 translate <0,.75,pole_radius>
                                 }
                        cylinder{<0,-.625,0,>,<0,.625,0,>,pole_radius/2
                                 rotate z*-39
                                 translate <0,2,pole_radius>
                                 }
                        cylinder{<0,-.595,0,>,<0,.595,0,>,pole_radius/2
                                 rotate z*34
                                 translate <0,2.99,pole_radius>
                                 }
                        texture{t_mill}                                 
                        rotate x*5
                       }

#declare ladder = union {
                        cylinder {<0,0,0>,<0,3.6,0>,.6*pole_radius
                                  translate x*-.15}
                        cylinder {<0,0,0>,<0,3.7,0>,.6*pole_radius
                                  translate x*.15}
                        #declare j = .25;
                        #while (j <= 3.3)
                                box{<-.2,-.03,-.01>,<.2,.03,.01> translate <0,j,-1.2*pole_radius + .02>}
                                #declare j = j + .25;
                        #end
                        texture{t_mill}
                        rotate x*5                             
                        }

#declare blade = bicubic_patch {
   type 1 flatness 0.001
   u_steps 4 v_steps 4
   uv_vectors
   <0,0> <1,0> <1,1> <0,1>
   <0,.2,2.5>,<2,0,3>,<5,0,3>,<7,.5,3>
   <0,0,2>,<2,0,2>,<5,0,2>,<7,0,2>
   <0,0,1>,<2,0,1>,<5,0,1>,<7,0,1>
   <0,.5,.5>,<2,0,0>,<5,0,0>,<7,.1,0>
   translate <-3.5,0,-1.5>
   rotate z*90
   rotate y*-30
   scale .1   
}

#declare R1 = seed(123);
#declare j = 0;
#declare blades = union {#while (j <= 360)                                
                                object {blade  
                                        texture {t_blade_coat}
                                        texture {t_blade_metal translate <rand(R1),2*rand(R1),rand(R1)> rotate x*90*rand(R1)}
                                        translate <0,.68,-.1> rotate z*j}
                                #declare j = j + 20;
                        #end}

#declare mill = union { 
                        union {
                                torus {.35,.01 rotate x*90}
                                torus {1,.01 rotate x*90}
                                cylinder {<0,0,-.1>,<0,0,.1>.1}               
                                #declare j = 0;
                                #while (j < 360)                                
                                        cylinder {<0,0,0>,<.35,0,0>,.05 translate z*.02 rotate z*j}
                                        #declare j = j + 45;
                                #end
                                cylinder {<0,0,0>,<0,0,1.5>.03}                                
                                texture {t_blade_pole scale .5}
                        }
                        object {blades}
                        rotate y*15
                       }
                        
#declare windmill = union {
                        object{side}
                        object{side rotate y*90 translate <-.5,0,.5>}
                        object{side rotate y*180 translate <0,0,1>}
                        object{side rotate y*270 translate <.5,0,.5>}                        
                        object{ladder translate z*-3.2*pole_radius}
                        cylinder{<0,0,0>,<0,1.4,0>,pole_radius*.7 rotate <7,0,10> translate <.3,3.48,.3>}
                        cylinder{<0,0,0>,<0,1.4,0>,pole_radius*.7 rotate <7,0,-10> translate <-.3,3.48,.3>}
                        cylinder{<0,0,0>,<0,1.4,0>,pole_radius*.7 rotate <-7,0,0> translate <0,3.48,.6>}
                        object{mill translate y*4.8}                        
                        //texture{t_wood}
                        //texture{t_tie}
                        scale 1.5
                        }                       


//--------------------
//object sign
//
#declare bullet_hole = cylinder {<0,0,-.5>,<0,0,.5>,.02
                                 pigment {rgb 0}  
                                 }
#declare space = box {-1,1 scale <1,.004,1>}

#declare board = light_group {
  light_source {<0,5,-5> rgb .5}
  union {        
   difference {
        box {<-1,-1,-1>,<1,1,1>    
                scale <.9,.01,.65>
                rotate x*90     
                texture {t_board
                      finish {ambient 0          
                              diffuse .3
                              specular 0}
                        }              
             }
        object {bullet_hole translate <.5,.3,0>}
        object {bullet_hole translate <.6,.5,0>}
        object {bullet_hole translate <.65,.62,0>}
        object {bullet_hole translate <.5,.52,0>}
        object {bullet_hole translate <.6,.68,0>}
        object {bullet_hole translate <.2,.5,0>}
        object {bullet_hole translate <-.4,.1,0>}
        object {bullet_hole translate <-.2,-.3,0>}
        object {space}
        object {space translate y*.22}
        object {space translate y*.44}
        object {space translate y*-.44}
        object {space translate y*-.22}
        rotate z*5
        translate y*.8
        }
   box {<-1,-1,-1>,<1,1,1>   //pole
        scale <.1,1,.1>       
        texture {t_white_wood
                //scale y*1
                }
        rotate y*90
        translate z*.105
        }
  }
}

//--------------------
//object ground
//
#declare desertX = 600;
#declare desertZ = 600;
#declare desert = height_field { 
                                png "hf_desert.png"
                                scale <desertX,2.5,desertZ>
                                translate <-302.4,-2.15,0>
                                }


//--------------------
//object telegraph
//
#if (TELE)
        #declare telegraph_pole = union {
                                   cylinder {0,<0,5,0>,.1}
                                   box {-1,1 scale <1,.04,.04> translate <0,4.5,-.1>}
                                   box {-1,1 scale <.3,.02,.02> rotate z*45 translate <.2,4.3,-.1>}
                                   box {-1,1 scale <.3,.02,.02> rotate z*-45 translate <-.2,4.3,-.1>}
                                   }
        
        #declare isolator = union {
                                cone {0,.08,<0,.1,0>,.05}
                                sphere {<0,.18,0>,.05}
                                pigment {rgb 1}
                                }

        #declare pole_distance = 35;                                    

        #declare cable = make_cable(<0,0,0>,<0,0,pole_distance>,pole_distance,.02)

        #declare telegraph = union {object {telegraph_pole}
                                    object {isolator translate <-.77,4.5,0>}
                                    object {isolator translate <-.55,4.5,0>}
                                    object {isolator translate <-.32,4.5,0>}
                                    object {isolator translate <.77,4.5,0>}
                                    object {isolator translate <.55,4.5,0>}
                                    object {isolator translate <.32,4.5,0>}
                                    object {cable translate <-.77,4.5,0>}
                                    object {cable translate <-.32,4.5,0>}                                    
                                    object {cable translate <.55,4.5,0>}  
                                    }
        
        #declare j = -(pole_distance*.3);
        #declare telegraphs = union {
                                #while (j < track_lenght)
                                        object{telegraph translate <-15,0,j>}                                        
                                        #declare j = j + pole_distance;
                                #end
                                }
#end

//--------------------
//object bush
//
#if (BUSH)
        #include "bush.inc"
        #declare bush = object{WOOD}
        //#declare bush = cylinder {0,<0,1,0>,.01}
        
        //#declare NUMBUSH = 5000;
        #declare NUMBUSH = 9500;          
        #declare j = 0;
        #declare Rx = seed(123);
        #declare Rz = seed(471);
        
        #declare bushes = union {
                #while (j < NUMBUSH)  //regular yello bush 
                        #declare X = (desertX * rand(Rx))-(desertX/2);
                        #declare Z = desertZ * rand(Rz);
                        #if ((X > -4) & (X < -2)) 
                                #declare X = X - 3 - 5*rand(Rx);
                        #end
                        #if ((X >= -2) & (X < 0)) 
                                #declare X = X + 3 + 5*rand(Rx);
                        #end
                        #if (Z < 3) #declare Z = Z + 10; #end
                        
                        object {bush         
                                scale <4.5-rand(Rx),2+rand(Rx),4.5-rand(Rz)>
                                translate <X,-.4,Z>
                                texture {t_bush}
                                }
                        #declare j = j+1;
                #end

        #declare NUMBUSH = 47500;          
        #declare Rx = seed(231);
        #declare Rz = seed(147);
        #declare j = 0;
        #while (j < NUMBUSH) //big gray bush
                #declare X = (desertX * rand(Rx))-(desertX/2);
                #declare Z = desertZ * rand(Rz);
                #if ((X > -4) & (X < -2)) 
                        #declare X = X - 3 - 5*rand(Rx);
                #end
                #if ((X >= -2) & (X < 0)) 
                                #declare X = X + 3 + 5*rand(Rx);
                #end
                #if (Z < 2.5) #declare Z = Z + 10; #end
                        
                object {bush         
                        scale <2.5-rand(Rx),1+rand(Rx),2.5-rand(Rz)>
                        rotate y*360*rand(Rx)
                        translate <X,-.4,Z>
                        texture {t_bush_red}
                        }
                #declare j = j+1;
        #end

                                

        #declare NUMBUSH = 1000;          
        #declare Rx = seed(321);
        #declare Rz = seed(714);
        #declare j = 0;
        #while (j < NUMBUSH)  //very small (almost grass dry bush
                #declare X = ((desertX * rand(Rx))-(desertX/2))/5;
                #declare Z = ((desertZ * rand(Rz))-desertZ/2)/5;
                object {bush         
                        #if ((X > -2.5) & (X < -2)) 
                                #declare X = X - 3 - 5*rand(Rx);
                        #end
                        #if ((X >= -2) & (X < -1.5)) 
                                        #declare X = X + 3 + 5*rand(Rx);
                        #end
                        
                        rotate y*360*rand(Rx)
                        translate <X,-.5,Z>
                        texture {t_bush_red}
                        }
                #declare j = j+1;
        #end

        }                        

#end


//-----------------
//  stormy sky
//
#declare clouds = union {
        plane {y,360
                hollow
                texture{
                        pigment {
                            leopard
                                color_map {
                                        //[0.0 rgb p_cloud*.9 filter .1]
                                        //[0.2 rgb p_cloud*2.5 filter .5 ]
                                        [0.0 rgb p_cloud*.4 filter .1]
                                        [0.2 rgb p_cloud*.99 filter .5 ]
                                        [0.6 rgbt 1]
                                        [1.0 rgbt 1]                                                               
                                        }                    
                            turbulence 1
                            lambda 4
                            scale 550
                            rotate y*79
                         }
                 }
                 
             }        
        plane {y,350
                hollow
                texture{
                        pigment {
                            bozo
                                color_map {
                                        [0.0 rgb p_cloud*.4 filter .1]
                                        [0.5 rgb p_cloud*.99 filter .5 ]
                                        [0.8 rgbt 1]
                                        [1.0 rgbt 1]                                                               
                                        }
                            turbulence 1
                            lambda 4
                            scale 550
                            rotate y*79
                         }
                 }
                 
             }
        
        plane {y,340
                hollow  
                texture{
                        pigment {
                            bozo
                                color_map {                                
                                        [0.0 rgb p_cloud*.5 filter .5 ]                               
                                        [1.0 rgbt 1]                                                               
                                        }
                            turbulence 1
                            lambda 6
                            scale <350,350,450>
                            rotate y*90
                         }
                 }
                 
             }
        }

//-------------------------------------------------------------------------------
// C O M M O N    O B J E C T S
//-------------------------------------------------------------------------------                

camera {
    #if (ORTO)
            location  <0, 50, 0>
            look_at   <0, 0, 0>
            angle 70   
            up z
    #else
            location  <-.5, 1.8, -.5>
            //location  <0, 400, -2>
            look_at   <-1.22, 1, 5>
            //look_at   <0, 400, 5>
            angle 70
            //angle 40      
            right     x*image_width/image_height
    #end
    #if (BLUR)            
            aperture 1.0           // [0...N] larger is narrower depth of field (blurrier)
            blur_samples 10        // number of rays per pixel for sampling
            focal_point <0,0,0>    // point that is in focus <X,Y,Z>
            confidence 0.95           // [0...<1] when to move on while sampling (smaller is less accurate)
            variance 1/200            // [0...1] how precise to calculate (smaller is more accurate)*/
   #end
}


        light_source {//<--------------------------          
          #if (CLOUD)   
                <0, 450, 2100>                  
                rgb <0.984314, 0.941176, 0.858824>*1.5
          #else
                <-500,500,-30>
                rgb <0.984314, 0.941176, 0.858824>*1.5
          #end 
          area_light  <10, 0, 0> <0, 0, 10>   8, 8                
          adaptive 1          
          jitter              
          circular            
          orient              
        } 


sky_sphere {
  pigment {
    gradient y
    color_map { [0.0 rgb <0.545098, 0.623529, 0.745098>*1] 
                [1.0 rgb <0.545098, 0.623529, 0.745098>*2] 
              }
  }
}


/********************************************************************************
                M A I N
********************************************************************************/
#if (BACK)
        object {sfondo 
                translate <-450,-6,2000>
                } 
        object {sfondo
                rotate y*180 
                translate <-200,0,2500>
                finish {diffuse .5}
                } 
        object {sfondo
                rotate y*180 
                translate <150,10,2600>
                finish {diffuse .55}
                } 
#end

//plane {y,0}

#if (TRACK)
        object {track        
                translate <-2,.12,0>
                } 
        object {rail 
                translate <-1.41,.12,-.86>
                texture {t_rail}}                
        object {rail 
                translate <-2.55,.12,-.85>
                texture {t_rail}} 
#end                

#if (MILL)
        object {windmill
                //rotate y*90
                translate <3.5 ,-.5,20>
                //translate <1.5,0,10>
                }
#end        

#if (BOARD)
        object {board
                scale .8
                rotate y*25
                translate <.6,.5,3>
                }
#end             

#if (TELE)
        object {telegraphs
                texture {t_tele}
                }
#end

#if (DESERT)
        object{desert
                texture {t_desert}                
                }
        height_field {png "hf_road.png" //road
                      smooth
                      rotate y*1.2
                      scale <16.5,.8,10>
                      translate <-9.85,-.5,-1>
                      texture {t_desert
                               translate z*-.5}
                      }                         
  
        
#end                

#if (BUSH)
        object {bushes}
#end                   

#if (CLOUD)
        object {clouds}
#end                    

//background {rgb 1}
background {color .9}
        

/*cylinder {<0,-10,0>,<0,10,0>,.012 pigment {color rgb <1,0,0>}} //y axis
cylinder {<0,-10,0>,<0,10,0>,.012 pigment {color rgb <0,1,0>} rotate z*-90} //x axis
cylinder {<0,-10,0>,<0,10,0>,.012 pigment {color rgb <0,0,1>} rotate x*90} //z axis*/