#version 3.6 ;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"
#include "metals.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------

#declare tclock=clock-1000;
#declare pi2=2*pi/360;

#declare place = <0,.75,-5>; //-5

/*
light_source { place + <-2,2,0> color <1,1,1>*.2 shadowless}
light_source { place + <2,2,0> color <1,1,1>*.2 shadowless}
light_source{place color<1,1,1>*.6}
*/

light_source{ <1000,800,-50> color<1,1,1>}

camera {location place//-4 
right 16/9*x
look_at <-1.5,.5,0> //-2
//angle 20
}

background { color SkyBlue }

//plane {y,0 pigment{White} finish{ambient .6}}

#declare dune = object{
height_field{png "hills1L.png" smooth  
translate <-.5,0,-.5>
}
} /// dune

object{dune pigment{Wheat} finish{ambient .6} rotate 45*y scale <600,12,600> 
translate <40,.1,0>
normal {dents -1}
normal {dents -1 scale .01}
}
object{dune pigment{Tan} finish{ambient .6} rotate 90*y scale <400,6,400>
normal {dents -1}
normal {dents -1 scale .01}
}
object{dune pigment{Sienna} finish{ambient .6} rotate 180*y scale <200,2,200>
normal {dents -1}
normal {dents -1 scale .01}
}
object{dune pigment{DarkTan} finish{ambient .6} rotate 270*y scale <100,1,100>
normal {dents -1}
normal {dents -1 scale .01}
}



#include "lb8a.inc"

#declare balls = union{
object{b8f finish {ambient .6} 
rotate 0*y
translate 3.4*y scale .1 //2.4*y
translate -.5*x
}

object{b8f finish {ambient .6} 
rotate 0*y
translate 3.4*y scale .1
translate -1*x
}

object{b8f finish {ambient .6} 
rotate 0*y
translate 3.4*y scale .1
translate -1.5*x
}
object{b8f finish {ambient .6} 
rotate 0*y
translate 3.4*y scale .1
translate -2*x
}
object{b8f finish {ambient .6} 
rotate 0*y
translate 3.4*y scale .1
translate -2.5*x
}
object{b8f finish {ambient .6} 
rotate 0*y
translate 3.4*y scale .1
translate -3*x
}
}//balls

#include "palm.inc"

#declare group1 = union {
object{TREE translate -y*0.1 scale <.1,.09,.1> finish {ambient .6 roughness .01}  }

object{balls rotate 15*x}

object{balls translate -.25*x}
} // group1

#declare group2 = union {
object{TREE rotate 90*y translate -y*0.1 scale <.1,.09,.1> finish {ambient .6 roughness .01} }

object{balls rotate 15*x}

object{balls translate -.25*x}
} // group2

object{group1}

object{group2 translate <20,0,60>}

