#declare StandTex=
     texture{ 
              pigment {color Black}
              finish{
                      ambient 0
                      diffuse 0 
                      reflection .1
                      specular  .5
                      roughness .05 
              }  
     }
     
#declare WhiteMedia4 =          
media {  
	emission 1 //.8   
	scattering {1, White extinction .95 }
	absorption <.5,.5,.5>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end  
        density {gradient -y  scale .8  //.3
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [0.5 rgb <0,0,0>] 
                             [1.0 rgb <4,4,4>]
                           } turbulence 2
          } 
                               
      }                                
#declare WhiteMedia3 =          
media {  
	emission .05 //.8   
	scattering {1, White extinction .95 }
	absorption <.5,.5,.5>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end  
        density {gradient -y  scale 1  //.3
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [0.5 rgb <0,0,0>] 
                             [1.0 rgb <10,10,10>]   //6
                           } turbulence .7
          } 
                               
      }                                
#declare WhiteMedia2 =          
media {
	emission .1 //.8   
	scattering {1, White extinction .95 }
	absorption <.5,.5,.5>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end  
        density {gradient y  scale 1  //.3
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [1.0 rgb <7,7,7>] //7
                           } turbulence 1
          } 
                              
      }  
        
#declare WhiteMedia =
media {
	emission White * .2
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end  
        density {gradient -y  scale .3
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [0.5 rgb <0,0,0>] 
                             [0.9 rgb <3,3,3>]
                             [1.0 rgb <10,10,10>]
                           } 
          } 
        density {granite  scale .2
                 color_map {
                             [0.0 rgb <10,10,10>]
                             [0.3 rgb <10,10,10>]
                             [0.3 rgb <0,0,0>]
                             [1.0 rgb <0,0,0>]
                           }
        }        
                                
      }  
#declare RedMedia =
media {
	absorption <0,.6,.4>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end  
        density {gradient y  scale .1 translate <0,-.03,0>
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [0.3 rgb <0,0,0>] 
                             [0.5 rgb <10,10,10>]
                             [1.0 rgb <10,10,10>]
                           } 
          } 
}         
#declare RedMedia2 =
media {
	//emission Red * .5
	//scattering {1, Red extinction 1 }
	absorption <0,.6,.4> 
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density {granite scale .08 translate <0,-.19,0>
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [0.5 rgb <0,0,0>] 
                             [0.5 rgb <30,30,30>]
                             [1.0 rgb <30,30,30>]
                           } 
          } 
} 
        
#declare BrownMedia =
media {
	emission DarkTan * 0.03
	//scattering {1, <1,0,0> extinction 1 }
	absorption <.1,.6,.1>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density {gradient y   scale .7
                 color_map {
                             [0.0 rgb <20,20,20>]
                             [0.2 rgb <20,20,20>]
                             [0.5 rgb <0,0,0>]
                             [1.0 rgb <0,0,0>]
                           }
        }
}         

#declare BrownMedia2 =
media {
	emission NeonPink  *.05
	//scattering {1, <1,0,0> extinction 1 }
	absorption <.5,.6,.4>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density {granite    scale .1
                 color_map {
                             [0.0 rgb <10,10,10>]
                             [1.0 rgb <1,1,1>]
                           }
        }
}         
#declare GreenMedia =
media {
	emission Copper * .3  
	//scattering {1, Copper extinction 1 }  
	absorption <.5,.5,1>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density {gradient y scale .01 translate <0,-.05,0>
                 color_map {
                             [0.0 rgb <20,20,20>]
                             [0.5 rgb <20,20,20>] 
                             [0.5 rgb <0,0,0>]
                             [1.0 rgb <0,0,0>]
                           }
        }
      }  
  
#declare BlueMedia =
media {
	absorption <.9,.9,0> 
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density {gradient y scale .1 translate <0,-.04,0>
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [0.5 rgb <0,0,0>] 
                             [0.5 rgb <30,30,30>]
                             [1.0 rgb <30,30,30>]
                           } 
          } 
      }  
#declare BlueMedia2 =
media {
	absorption <.8,.1,0> 
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density {gradient y scale .1  translate <0,-.04,0>
                 color_map {
                             [0.0 rgb <0,0,0>]
                             [0.5 rgb <0,0,0>] 
                             [0.5 rgb <10,10,10>]
                             [1.0 rgb <10,10,10>]
                           } 
          } 
     }  
#declare BlueMedia3 =
media {
	emission MidnightBlue * .5  
	//scattering {1, MidnightBlue extinction .2 }
	absorption <.8,.1,0>
	method 3
        #if (High_MSamples) samples 35,250 #else samples 5,10 #end 
        density {granite  scale .08 
                 color_map {
                             [0.0 rgb <5,5,5>]
                             [0.4 rgb <5,5,5>]
                             [0.4 rgb <0,0,0>]
                             [1.0 rgb <0,0,0>]
                           }
        }        
      }  

#declare Funnel= //funnel
lathe {
  linear_spline // linear_spline | quadratic_spline | cubic_spline
    7, // # of points 
    <.10,  .00>,
    <.10,  .60>,
    <.10,  .60>,
    <.20,  .70>,
    <.30,  .80>,
    <.40,  .90>,
    <.50,  1.0>

    pigment{color rgbt<1,1,1,.8>}
    finish{  ambient 0
             diffuse 0    
             reflection .3
          }  
    interior {
              ior 1.7   
             }
     hollow                      
     scale .8 * Feet
}

#declare Flask= //flask
union{                      
lathe {
  linear_spline // linear_spline | quadratic_spline | cubic_spline
    9, // # of points 
    <0.0,  -.01>,
    <1.0,  .00>,
    <.90,  .20>,
    <.80,  .40>,
    <.70,  .60>,
    <.60,  .80>,
    <.50,  1.0>,
    <.40,  1.2>,
    <.40,  1.8>

}

torus {
  0.35,
  0.1
  translate <0,1.8,0>
}

    pigment{color rgbt<1,1,1,.9>}
    finish{  ambient 0
             diffuse 0    
             reflection .1
             specular .7
             roughness .0005
          }  
     hollow                        
     scale <.4 * Feet, .5 * Feet, .4 * Feet>
}

#declare WideMouthBottle = //widemouth bottle
union{
lathe {
  linear_spline // linear_spline | quadratic_spline | cubic_spline
    4, // # of points 
    <0.5,  .00>,
    <0.5,  .80>,
    <.30,  .82>,
    <.30,  1.0>
}

torus {
  0.22,
  0.1
  translate <0,1.25,0>
} 

cylinder {
  0*y,  .3*y,  .17
  translate<0,1,0>
}
    pigment{color rgbt<1,1,1,.9>}
    finish{  ambient 0
             diffuse 0
             //reflection .1 
          }  
    hollow                     
    scale <.5 * Feet, .5 * Feet, .5 * Feet>
}

#declare Mug = 
union{
lathe {
  linear_spline // linear_spline | quadratic_spline | cubic_spline
    4, // # of points 
    <0.5,  .00>,
    <0.5,  .80>,
    <.5,  .82>,
    <.5,  1.0>
}

torus {
  0.22,
  0.06
  scale <1.8,1,1>
  rotate<90,90,0>
  translate <0,.6,-.40>
} 

sphere    {<0, 1.0, 0> , 0.49          
           pigment{color rgbt<1,1,1,1>}
           hollow
           interior{media{WhiteMedia4} } 
         }


    pigment{color Gray}
    finish{   
            reflection .2
            specular .7
            roughness .0005 
          }  
    hollow
    scale <.4 * Feet, .5 * Feet, .4 * Feet>
    normal{crackle .01 scale .015 no_bump_scale}
    rotate <0,-20,0>
}

#declare WashBottle= //washbottle
union{
lathe {
  quadratic_spline 
    7, // # of points 
    <0.0, -.01>,
    <0.4,  .00>,
    <0.4,  .00>,
    <0.4,  .60>,
    <0.2,  .90>,
    <0.2,  1.00>,
    <0.2,  1.00>
}

torus {
  0.12,
  0.08
  translate <0,1.2,0>
} 

cylinder {
  0*y,  .3*y,  .17
  translate<0,1,0>
} 
    pigment{color rgbt<1,1,1,.98>}
    finish{  ambient 0
             diffuse 0    
             //reflection .1
             //specular .9
             roughness .0005
          }  
    hollow                     
    scale <.4 * Feet, .5 * Feet, .4 * Feet>
}

#declare LongNeckBottle= 
union{
lathe {
  quadratic_spline 
    8, // # of points 
    <0.0, -.01>,
    <0.4,  .00>,
    <0.4,  .00>,
    <0.4,  .60>,
    <0.2,  .90>,
    <0.2,  1.00>,
    <0.2,  4.00>
    <0.2,  1.00>
}

torus {
  0.12,
  0.08
  translate <0,3.2,0>
} 

    pigment{color rgbt<1,1,1,.98>}
    finish{  ambient 0
             diffuse 0    
             //reflection .1
             //specular .9
             roughness .0005
          }  
    hollow                     
    scale <.4 * Feet, .5 * Feet, .4 * Feet>
}

#declare Vial =  //vial 
union{
cylinder {
  0*y,  3*y,  1
    pigment{color rgbt<1,1,1,.9>}
    finish{  ambient 0
             diffuse 0 
             reflection .1
             specular .7
             roughness .0005 
             caustics 7  
          }
    hollow 

}

cylinder {
  2.5*y,  3.1*y,  1.2
  pigment {color Black}
}
     scale <.05 * Feet, .07 * Feet, .05 * Feet>
}

#declare GraduatedCylinder = //graduated cylinder
union{
       prism {
               //linear_sweep
               linear_spline
               0, // sweep the following shape from here ...
               1.5, // ... up through here
               7, // the number of points making up the shape ...
              <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
              pigment { DarkBrown }
       }

       cylinder {
                  1.5*y,  4*y,  1.6
                  pigment {color VeryDarkBrown}
       }

       cylinder {
                  3*y,  20*y,  1.5    
  
                  pigment{color rgbt<1,1,1,.9>}
                  finish{  ambient 0
                           diffuse 0
                           reflection .1
                           specular .7
                           roughness .0005 
                  }                                             
                  interior {
                             ior 1.7
                             //caustics 1.0 
                  } 
                  pigment{ gradient y  scale 2
                           color_map{
                                      [0.00 rgbt<1,1,1,.9>]
                                      [0.30 rgbt<1,1,1,.9>]
                                      [0.30 rgbt<1,1,1,.7>]
                                      [0.60 rgbt<1,1,1,.7>]
                                      [0.60 rgbt<1,1,1,.9>]
                                      [0.90 rgbt<1,1,1,.9>]
                                      [0.90 rgbt<1,1,1,.7>]
                                      [1.0 rgbt<1,1,1,.7>]
                                    } 
                         }  
       }

       torus {
               1.6,
               0.2
                  pigment{color rgbt<1,1,1,.9>}
                  finish{  ambient 0
                           diffuse 0
                           reflection .1
                           specular .7
                           roughness .0005 
                  }                                             
               translate <0,19.9,0>
             }
 
       hollow
       scale .013

}

#declare BubbleBottle=
union{
       torus {
               0.8,
               0.2
               translate <0,-2,0>
       }   
       
       sphere{<0,2.7,0>,2.2}
       
       cylinder{-2*y,  2*y,  .8  }


       pigment{color rgbt<1,1,1,.9>}
       finish{  ambient 0
                diffuse 0
                reflection .1 
              }
       rotate<0,0,180>
       hollow

       scale .05
}


#declare Barrel =                                 
union {
   union{
        torus {
                2,
                3.2                
                texture{T_Chrome_2A}
                scale <.4,.08,.4>
                translate <0,2.5,0>
        } 
        cylinder{ 0*y, 5*y, 3
                  texture{T_Chrome_2A}     
                  scale .5 
        }
        torus {
                2.0,
                3.2 
                texture{T_Chrome_2A}
                scale<.4,.08,.4>
                translate <0,.1,0>
        } 
             
        } //first union 
         
    merge{    
        cylinder{ 0*y, 5*y, 3.3  //3.2
                  scale <.51,.49,.51 >
                  hollow
                  interior {media{WhiteMedia2} }
        }

       prism { conic_sweep
               cubic_spline
               0, // sweep the following shape from here ...
               0.6, // ... up through here 
               15, // the number of points making up the shape ...
              <  0.499,  0.856>, //control

              <  0.500,  0.855>, //30
              <  0.855,  0.500>, //60
              <  1.000,  0.000>, //90
              <  0.866, -0.500>, //120
              <  0.500, -0.866>, //150
              <  0.000, -0.900>, //180
              < -0.500, -0.866>, //210
              < -0.866, -0.500>, //240
              < -0.800,  0.000>, //270
              < -0.866,  0.500>, //300
              < -0.500,  0.866>, //330
              <  0.000,  0.900>, //360
              <  0.500,  0.855>, //30

              <  0.499,  0.8565> //control
              rotate <180, 0, 0>
              translate <0, 0.6, 0>  
              hollow
              scale <15,.75,15>  //10
              interior {media{WhiteMedia3} }
       }               
               
       pigment{color rgbt<1,1,1,1>}
       finish{  ambient 0
                diffuse 0
             }                     
       
    } //end inner union
        
} //end outer union                     

#declare Stand=
union{
        cylinder{ 0*y*Feet, 6.8*y*Feet, .03
        }
        torus {
                2,
                3.2 
                scale <.03,.015,.03>
                translate <0,.0 * Feet, 0>
        }
        torus {
                2,
                3.2 
                scale <.03,.015,.03>
                translate <0,6.8 * Feet, 0>
        }
        texture{StandTex}              

}

#declare Valve=
union{
    cylinder {
    -2*y,  2*y,  1}
     
    cylinder {
    -3*z,  3*z,  1.2
    translate <0,2.2,0>}
    
    scale .02
    pigment{color rgbt<1,1,1,.9>}
    finish{  ambient 0
             diffuse 0
             reflection .3
             specular  .7
             roughness .005 
          }
    interior {
              ior 1.7  
             } 
}

#declare ChemStand=
union{ 
      cylinder {
                 0*y*Feet,  1*y*Feet,  .09 * Feet
                 Rotate_Around_Trans(<10,0,10>, <0,0,0>) 
                 translate <1*Feet,0*Feet,0*Feet>
               }
      cylinder {
                 0*y*Feet,  1*y*Feet,  .09 * Feet
                 Rotate_Around_Trans(<-10,0,-10>, <0,0,0>) 
                 translate <0*Feet,0*Feet,1*Feet>
               }
      cylinder {
                 0*y*Feet,  1*y*Feet,  .09 * Feet
                 Rotate_Around_Trans(<10,0,-10>, <0,0,0>) 
                 translate <0*Feet,0*Feet,0*Feet>
               }
      torus {
              .6 * Feet,
              .08 * Feet 
              scale <1,1,1>
              translate <.5*Feet,.9*Feet,.5*Feet>
            }
      torus {
              .7 * Feet,
              .06 * Feet 
              scale <1,1,1>
              translate <.5*Feet,.5*Feet,.5*Feet>
            }
 
      scale .5 
      Rotate_Around_Trans(<0,20,0>, <0,0,0>)   
      texture{StandTex}              

}      

#declare Burner = //graduated cylinder
difference{
   union{
       prism {
               //linear_sweep
               linear_spline
               0, // sweep the following shape from here ...
               1.5, // ... up through here
               7, // the number of points making up the shape ...
              <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
               //texture{T_Silver_2A} 
               pigment{color DarkBrown}
       }
       
       torus {
               2.1,
               0.2
               texture{T_Silver_1B}
               scale <1,1.2,1>
               translate <0,10,0>
       }
        
       cylinder {
                  1.5*y,  10*y,  2    
                  texture{T_Silver_1B}
       }  
   }
   union{ 
          sphere{<0,8,0>, 2.5 
                 scale <1.5,.5,.5>
          }
          sphere{<0,8,0>, 2.5 
                 scale <.5,.5,1.5>
          }
   }
   cutaway_textures
   scale .02

}

#declare Gas=
#union{
       #object{WashBottle
               texture{T_Chrome_1D} 
               scale <10 * Feet, 15 * Feet, 10 * Feet>
               translate <29.5 * Feet, 2.0 * Feet, 29.0 * Feet>
       }
       cylinder{ 
                0*x*Feet, -.35*x*Feet, .09 * Feet
                texture{T_Silver_1B} 
                rotate<0,0,0>
                translate <29.5 * Feet, 4.8 * Feet, 29.0 * Feet>
       }
       prism {
               //linear_sweep
               linear_spline
               0, // sweep the following shape from here ...
               1.5, // ... up through here
               7, // the number of points making up the shape ...
              <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5>
               texture{T_Silver_1B} 
               scale .015
               translate <29.5 * Feet, 5.0 * Feet, 29.0 * Feet>
       }
       sphere_sweep{  cubic_spline
                   9,
                   <29.5 * Feet,  4.8 * Feet, 29.0 * Feet>, .06 * Feet
                   <29.2 * Feet,  4.8 * Feet, 29.0 * Feet>, .06 * Feet
                   <28.8 * Feet,  4.7 * Feet, 29.0 * Feet>, .06 * Feet
                   <28.5 * Feet,  4.5 * Feet, 29.0 * Feet>, .06 * Feet
                   <28.0 * Feet,  4.4 * Feet, 29.0 * Feet>, .06 * Feet
                   <27.5 * Feet,  4.4 * Feet, 29.0 * Feet>, .06 * Feet
                   <26.0 * Feet,  4.4 * Feet, 29.0 * Feet>, .06 * Feet
                   <25.5 * Feet,  4.45 * Feet, 27.76 * Feet>, .06 * Feet
                   <25.5 * Feet,  4.45 * Feet, 27.76 * Feet>, .06 * Feet
                 
                   pigment {spiral1 2 scale .02 //rotate <90,0,90>
                            color_map{ 
                                       [0.0 DarkBrown]
                                       [1.0 Pink]
                                      }
                            }
                 } 
} 

#declare TieDown=
union{
       torus {
               2.1,
               0.2
               scale <1,1,1>
               rotate<60,0,0>
               scale .03  //.05
       }
       torus {
               2.1,
               0.2
               scale <1,1,1>
               rotate<-60,0,0>
               scale <.035,.03,.035>
       } 
       pigment{color DarkBrown }
       normal{dents 1.5 scale .01 no_bump_scale}
}

#declare Pencil=
union{ 
 
       cylinder{ 60.0*y, 50*y, 1.5 
                 pigment{color Black}
               }  

       cone {
              60*y,  0.0,
              50*y,  5.0 
              texture{T_Wood10 }
       }

       prism {
               //linear_sweep
               linear_spline
               0, // sweep the following shape from here ...
               50, // ... up through here
               7, // the number of points making up the shape ...
              <3,5>, <-3,5>, <-5,0>, <-3,-5>, <3, -5>, <5,0>, <3,5> 
              pigment{color Yellow} 
              normal{crackle .09 scale 20 no_bump_scale}
             } 
             
       cylinder{ -10*y, -5*y, 5 
                 pigment{color NeonPink * .9}
                 normal{crackle .15 scale 10 no_bump_scale}
               }  
       cylinder{ -5*y, -0*y, 5 
                 texture{T_Silver_1D}
               }  
              scale <.002,.004,.002>
              rotate <0,0,90> rotate<0,180,5>      
}      

#declare Pad=

      box {
             <-1, -1, -1>  // one corner position <X1 Y1 Z1>
             < 1,  1,  1>  // other corner position <X2 Y2 Z2>
             pigment{ color White}  
             scale <.1, .005, .161803> * 1.5
             rotate<0,-10,0>
             normal{crackle .015 scale .03 no_bump_scale}
             }

#declare Pages=
union{
     #declare B11=<-1,0,-1>; #declare B12=<-.5,0,-1>; #declare B13=<.5,1,-1>; #declare B14=<1,4,-1>; // row 1

     #declare B21=<-1,0,-.5>; #declare B22=<-.5,0,-.5>; #declare B23=<.5,1,-.5>; #declare B24=<1,1,-.5>; // row 2

     #declare B31=<-1,0,.5>; #declare B32=<-.5,0,.5>; #declare B33=<.5,0,.5>; #declare B34=<1,0,.5>; // row 3

     #declare B41=<-1,0,1>; #declare B42=<-.5,0,1>; #declare B43=<.5,0,1>; #declare B44=<1,0,1>; // row 4

     bicubic_patch {
        type 1 flatness 0.001
        B11, B12, B13, B14
        B21, B22, B23, B24
        B31, B32, B33, B34
        B41, B42, B43, B44
        pigment{color White}
        scale <.1, .005, .161803> * 1.5
        rotate<0,-10,0>
        normal{crackle .015 scale .03 no_bump_scale}
        translate <0,.03,0>
    }

    #declare B13 = <.5,0,-1>;
    #declare B23 = <.5,0,-.5>;
    #declare B14 = <1,2,-1>;
    #declare B24 = <1,0,-.5>;
    
     bicubic_patch {
        type 1 flatness 0.001
        B11, B12, B13, B14
        B21, B22, B23, B24
        B31, B32, B33, B34
        B41, B42, B43, B44
        pigment{color White}
        scale <.1, .005, .161803> * 1.5
        rotate<0,-10,0>
        normal{crackle .015 scale .03 no_bump_scale}
        translate <0,.03,0>
    }
}


#declare StirRod=
    sphere_sweep {
                   linear_spline 
                   2,            
                   <-0.7 * Feet,  0 * Feet, 0 * Feet>, .04 * Feet                
                   < 0.7 * Feet,  0 * Feet, 0 * Feet>, .04 * Feet  
                   Rotate_Around_Trans(<0,0,75>, <0,0,0>) 
                   
                   pigment{color rgbt<1,1,1,.9>}
                   finish{  ambient 0
                            diffuse 0
                            reflection .1 //.2
                            specular  .7    //.9
                            roughness .0005 
                  }  
                  //hollow
                  interior {
                             ior 1.7
                             caustics 1.0 
                           } 
    }

#declare Pipes=
union{

    sphere_sweep {
                   linear_spline 
                   2,            
                   <29.0 * Feet,  6.0 * Feet, 25.0 * Feet>, .1 * Feet                
                   <29.0 * Feet,  5.0 * Feet, 25.0 * Feet>, .1 * Feet  
                   hollow
                 }
    sphere_sweep {
                   linear_spline 
                   4,            
                   <29.0 * Feet,  4.0 * Feet, 24.0 * Feet>, .1 * Feet                
                   <29.0 * Feet,  5.0 * Feet, 24.0 * Feet>, .1 * Feet  
                   <29.0 * Feet,  5.0 * Feet, 23.0 * Feet>, .1 * Feet  
                   <29.0 * Feet,  3.0 * Feet, 23.0 * Feet>, .05 * Feet  
                   hollow
                 }
    sphere_sweep {
                   linear_spline 
                   3,            
                   <29.0 * Feet,  5.5 * Feet, 25.0 * Feet>, .1 * Feet                
                   <29.0 * Feet,  5.5 * Feet, 23.5 * Feet>, .1 * Feet  
                   <29.0 * Feet,  5.0 * Feet, 23.5 * Feet>, .1 * Feet    
                 }
    sphere_sweep {
                   linear_spline 
                   4,            
                   <29.0 * Feet,  3.0 * Feet, 22.8 * Feet>, .05 * Feet                
                   <29.0 * Feet,  5.5 * Feet, 22.8 * Feet>, .1 * Feet  
                   <29.0 * Feet,  5.5 * Feet, 22.0 * Feet>, .1 * Feet    
                   <29.0 * Feet,  4.0 * Feet, 22.0 * Feet>, .1 * Feet    
                 }
    sphere_sweep {
                   linear_spline 
                   4,            
                   <29.0 * Feet,  4.0 * Feet, 21.7 * Feet>, .1 * Feet                
                   <29.0 * Feet,  6.0 * Feet, 21.7 * Feet>, .1 * Feet  
                   <29.0 * Feet,  6.0 * Feet, 21.0 * Feet>, .1 * Feet    
                   <29.0 * Feet,  5.0 * Feet, 21.0 * Feet>, .05 * Feet    
                   hollow
                 }
    
    sphere{<29.0 * Feet, 7.5 * Feet, 21.0 * Feet >,.35 * Feet 
           hollow 
           } 
    
    sphere_sweep {
                   linear_spline  
                   5,            
                   <29.0 * Feet,  6.0 * Feet, 21.0 * Feet>, .1 * Feet                
                   <29.0 * Feet,  6.0 * Feet, 20.0 * Feet>, .1 * Feet  
                   <29.0 * Feet,  6.0 * Feet, 20.0 * Feet>, .1 * Feet    
                   <29.0 * Feet,  7.5 * Feet, 20.0 * Feet>, .1 * Feet                   
                   <29.0 * Feet,  7.5 * Feet, 20.8* Feet>, .1 * Feet    //sphere here
                   hollow
                 }
    sphere_sweep{  linear_spline
                   20,
                   <29.0 * Feet,  7.5 * Feet, 21.2 * Feet>, .1 * Feet
                   <29.0 * Feet,  7.5 * Feet, 23.0 * Feet>, .1 * Feet
                   <29.0 * Feet,  7.0 * Feet, 23.0 * Feet>, .1 * Feet    
                   <29.0 * Feet,  7.0 * Feet, 21.0 * Feet>, .1 * Feet    
                   <29.0 * Feet,  6.5 * Feet, 21.0 * Feet>, .1 * Feet    
                   <29.0 * Feet,  6.5 * Feet, 23.5 * Feet>, .1 * Feet    
                   <29.0 * Feet,  6.5 * Feet, 23.5 * Feet>, .1 * Feet    
                   <30.0 * Feet,  6.5 * Feet, 23.5 * Feet>, .1 * Feet    
                   <30.0 * Feet,  8.0 * Feet, 23.5 * Feet>, .1 * Feet    
                   <30.0 * Feet,  8.0 * Feet, 24.0 * Feet>, .1 * Feet    
                   <30.0 * Feet,  4.0 * Feet, 24.0 * Feet>, .1 * Feet    
                   <30.0 * Feet,  4.0 * Feet, 24.5 * Feet>, .1 * Feet    
                   <30.0 * Feet,  8.0 * Feet, 24.5 * Feet>, .1 * Feet    
                   <30.0 * Feet,  8.0 * Feet, 25.0 * Feet>, .1 * Feet    
                   <30.0 * Feet,  4.0 * Feet, 25.0 * Feet>, .1 * Feet    
                   <30.0 * Feet,  4.0 * Feet, 25.5 * Feet>, .1 * Feet    
                   <30.0 * Feet,  8.0 * Feet, 25.5 * Feet>, .1 * Feet    
                   <30.0 * Feet,  8.0 * Feet, 26.0 * Feet>, .1 * Feet    
                   <30.0 * Feet,  6.5 * Feet, 26.0 * Feet>, .1 * Feet    
                   <30.0 * Feet,  6.5 * Feet, 27.2 * Feet>, .1 * Feet    
                   hollow
                 } 
    sphere_sweep {
                   linear_spline 
                   2,            
                   <29.5 * Feet,  6.0 * Feet, 27.0 * Feet>, .1 * Feet                
                   <29.5 * Feet,  7.0 * Feet, 27.0 * Feet>, .1 * Feet 
                   hollow
                   interior{media{RedMedia2}} 
    }

    #object{Funnel
            translate <29.35 * Feet, 6.8 * Feet, 26.94 * Feet>
           }

    torus {
            0.07,
            0.09   
            scale .3
            pigment{color Black}
    translate <29 * Feet, 5.1 * Feet, 25.0 * Feet>
    }

    #object{Flask //pipes
            interior {
                      ior 1.7   
                      media{GreenMedia}
            }
     
            translate <29 * Feet, 4.3 * Feet, 25.0 * Feet>
    }

    torus {
            0.07,
            0.09   
            scale .25
            pigment{color Black}
    translate <29 * Feet, 4.1 * Feet, 24.0 * Feet>
    }

    #object{WashBottle //pipes
            scale 2
            interior {
                      ior 1.7   
                      media{BlueMedia2 scale 2.5}
            }
            translate <29 * Feet, 3.0 * Feet, 24.0 * Feet>
    } 

    torus {
            0.07,
            0.09   
            scale .25
            pigment{color Black}
    translate <29.4 * Feet, 6.0 * Feet, 26.93 * Feet>
    }
 
    #object{BubbleBottle //pipes
            interior {
                      ior 1.7   
                      media{RedMedia2}
            }
            translate <29.4 * Feet, 5.8 * Feet, 26.93 * Feet>
    }

    torus {
            0.07,
            0.09   
            scale .2
            pigment{color Black}
    translate <29.0 * Feet, 4.8 * Feet, 21.0 * Feet>
    }

    #object{LongNeckBottle //pipes
            scale 1
            hollow
            interior {
                      ior 1.7   
                      media{BrownMedia scale 1}
            }
            translate <29.0 * Feet, 3. * Feet, 21.0 * Feet>
    } 
 
     torus {
            0.07,
            0.09   
            scale .4
            pigment{color Black}
    translate <29.1 * Feet, 3.3 * Feet, 22.96 * Feet>
    }
 
    #object{BubbleBottle //pipes 
            scale <1.4,.8,1.4>
            interior {
                      ior 1.7   
                      media{BrownMedia}
            }
            translate <29.1 * Feet, 3.2 * Feet, 22.96 * Feet>
    }
   
  
    #object{Barrel
            scale <.1,.3,.1>
            translate < 29.3 * Feet, 2.0 * Feet, 21.85 * Feet>

    }
 
     #object{Valve rotate<0,90,0> translate <29.0 * Feet, 5.6 * Feet, 24.0 * Feet>}
     #object{Valve                translate <29.0 * Feet, 5.6 * Feet, 22.4 * Feet>}
     #object{Valve                translate <29.0 * Feet, 6.09 * Feet,21.0 * Feet>}
     #object{Valve                translate <30.0 * Feet, 6.6 * Feet,26.6 * Feet>}
     #object{Valve                translate <29.0 * Feet, 7.61 * Feet,22.0 * Feet>}
  
     #object{Stand translate <30.5 * Feet, 2.2 * Feet, 25.94 * Feet>}
     #object{Stand translate <30.5 * Feet, 2.2 * Feet, 23.85 * Feet>}
     #object{Stand translate <29.5 * Feet, 2.2 * Feet, 20.35* Feet>}
     
     #object{Stand scale<1,.32,1> translate <29.0 * Feet, 2.1 * Feet, 25.0* Feet>}
     #object{Stand scale<.8,.13,.8> translate <29.0 * Feet, 2.1 * Feet, 24.0* Feet>}
     
     #object{TieDown translate <30.1 * Feet, 8.0 * Feet, 25.795 * Feet>}
     #object{TieDown translate <30.1 * Feet, 8.0 * Feet, 23.75 * Feet>}
     #object{TieDown translate <29.1 * Feet, 7.5 * Feet, 20.36 * Feet>}
     #object{TieDown translate <29.1 * Feet, 6.0 * Feet, 20.36 * Feet>}
     
    pigment{color rgbt<1,1,1,.9>}
    finish{  ambient 0
             diffuse 0
             reflection .1 //.2
             specular  .7    //.9
             roughness .0005 
          }

    hollow

    interior {
              ior 1.7 
              caustics 1.3  //5
             }                      
    translate<0 * Feet,0 * Feet,.5 * Feet>

}
                                            