// Persistence of Vision Ray Tracer Scene Description File
// File: cards.inc, cards.png
// Vers: 3.5
// Desc: macro to create card house mesh include file
// Date: 04/06/03
// Auth: James Moore
//
// textures for jack, queen, king and back of card adapted from Pysol 4.80
// original copyright below
//   Copyright (C) 1997 John Fitzgibbon
//   Copyright (C) 1997 Jochen Tuchbreiter <whynot@mabi.de>
//   Copyright (C) 1998 Markus F.X.J. Oberhumer <markus.oberhumer@jk.uni-linz.ac.at>
//
// This cardset is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the license, or (at your option) any later version.

#include "transforms.inc"
#include "rand.inc"
#declare rto=0.55;
#declare sd=seed(12345);
#declare cc=","
//------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------

#macro corner(tr1, tr2)
	
	#local t_cardface=
	texture {
		uv_mapping pigment {image_map {png "cardtext.png" interpolate 2}}
		finish {specular 0.4 roughness 0.05}
		scale <13*sc, 5*sc*1.5, 1>
	}

	#local t_cardside=
	texture {
		pigment {rgb 1}
		finish {specular 0.4 roughness 0.05}
	}
	
	#local tr=transform {tr1 tr2}
	#local p00=<0, 0, -0.01*sc>;
	#local p10=<0.05*sc, 0, -0.01*sc>;
	#local p20=vtransform (<0.05*sc, 0, -0.01*sc>, transform {rotate z*30});
	#local p30=vtransform (<0.05*sc, 0, -0.01*sc>, transform {rotate z*60});
	#local p40=<0, 0.05*sc, -0.01*sc>;
	
	#local p01=<0, 0, 0.01*sc>;
	#local p11=<0.05*sc, 0, 0.01*sc>;
	#local p21=vtransform (<0.05*sc, 0, 0.01*sc>, transform {rotate z*30});
	#local p31=vtransform (<0.05*sc, 0, 0.01*sc>, transform {rotate z*60});
	#local p41=<0, 0.05*sc, 0.01*sc>;
	
	//front
#write (file,	"triangle {")
#write (file,		vtransform (p00, tr),cc)
#write (file,		vtransform (p10, tr),cc)
#write (file,		vtransform (p20, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (p00, tr),cc)
#write (file,		vtransform (p20, tr),cc)
#write (file,		vtransform (p30, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (p00, tr),cc,)
#write (file,		vtransform (p30, tr),cc,)
#write (file,		vtransform (p40, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//back
#write (file,	"triangle {")
#write (file,		vtransform (p01, tr),cc)
#write (file,		vtransform (p11, tr),cc)
#write (file,		vtransform (p21, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+vtransform (p01, tr1).x, 4*sy+vtransform (p01, tr1).y>,cc)
#write (file,		<bk*sx+vtransform (p11, tr1).x, 4*sy+vtransform (p11, tr1).y>,cc)
#write (file,		<bk*sx+vtransform (p21, tr1).x, 4*sy+vtransform (p21, tr1).y>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (p01, tr),cc)
#write (file,		vtransform (p21, tr),cc)
#write (file,		vtransform (p31, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+vtransform (p01, tr1).x, 4*sy+vtransform (p01, tr1).y>,cc)
#write (file,		<bk*sx+vtransform (p21, tr1).x, 4*sy+vtransform (p21, tr1).y>,cc)
#write (file,		<bk*sx+vtransform (p31, tr1).x, 4*sy+vtransform (p31, tr1).y>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (p01, tr),cc)
#write (file,		vtransform (p31, tr),cc)
#write (file,		vtransform (p41, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+vtransform (p01, tr1).x, 4*sy+vtransform (p01, tr1).y>,cc)
#write (file,		<bk*sx+vtransform (p31, tr1).x, 4*sy+vtransform (p31, tr1).y>,cc)
#write (file,		<bk*sx+vtransform (p41, tr1).x, 4*sy+vtransform (p41, tr1).y>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
	
	//1st z block
#write (file,	"triangle {")
#write (file,		vtransform (p10, tr),cc)
#write (file,		vtransform (p20, tr),cc)
#write (file,		vtransform (p11, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (p20, tr),cc)
#write (file,		vtransform (p21, tr),cc)
#write (file,		vtransform  (p11, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//2nd z block
#write (file,	"triangle {")
#write (file,		vtransform (p20, tr),cc)
#write (file,		vtransform (p30, tr),cc)
#write (file,		vtransform (p21, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (p30, tr),cc)
#write (file,		vtransform (p31, tr),cc)
#write (file,		vtransform (p21, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//3nd z block
#write (file,	"triangle {")
#write (file,		vtransform (p30, tr),cc)
#write (file,		vtransform (p40, tr),cc)
#write (file,		vtransform (p31, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (p40, tr),cc)
#write (file,		vtransform (p41, tr),cc)
#write (file,		vtransform (p31, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
#end

//------------------------------------------------------------------------------------

#macro card(st, cd, bk, sc, tr)

	#local sx=sc;
	#local sy=sc*1.5;
	#local sz=sc*0.01;
	
	#local t_cardface=
	texture {
		uv_mapping pigment {image_map {png "cardtext.png" interpolate 2}}
		finish {specular 0.4 roughness 0.05}
		scale <13*sc, 5*sc*1.5, 1>
	}

	#local t_cardside=
	texture {
		pigment {rgb 1}
		finish {specular 0.4 roughness 0.05}
	}
	
#debug "writing card\n"
	
	//top left corner
	corner (transform {rotate z*90 translate <sx*0.05, sy-sx*0.05, 0>}, tr)
	
	//top right corner
	corner (transform {translate <sx*0.95, sy-sx*0.05, 0>} tr)
	
	//bottom left corner
	corner (transform {rotate z*180 translate <sx*0.05, sx*0.05, 0>}, tr)
	
	//bottom right corner
	corner (transform {rotate z*270 translate <sx*0.95, sx*0.05, 0>}, tr)
	
	//back
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0+sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx*0.05, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx*0.05, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
	
	//left back
#write (file,	"triangle {")
#write (file,		vtransform (<0, 0+sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.05, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<0, 0+sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<0, sy-sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx, 4*sy+sy-sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
	
	//right back
#write (file,	"triangle {")
#write (file,		vtransform (<sx, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx, sy-sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx, 4*sy+sy-sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
	
	//top back
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sy-sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sy>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx*0.05, 4*sy+sy-sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.05, 4*sy+sy>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sy>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
	
	//bottom back
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx*0.05, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, 0, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0, sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<bk*sx+sx*0.05, 4*sy+sx*0.05>,cc)
#write (file,		<bk*sx+sx*0.05, 4*sy>,cc)
#write (file,		<bk*sx+sx*0.95, 4*sy>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
	
	//face
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<cd*sx, st*sy>,cc)
#write (file,		<cd*sx+sx, st*sy>,cc)
#write (file,		<cd*sx+sx, st*sy+sy>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr))
#write (file,		" uv_vectors ")
#write (file,		<cd*sx, st*sy>,cc)
#write (file,		<cd*sx, st*sy+sy>,cc)
#write (file,		<cd*sx+sx, st*sy+sy>)
#write (file,		"texture {t_cardface}")
#write (file,	"}\n")
	
	//left front
#write (file,	"triangle {")
#write (file,		vtransform (<0, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<0, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<0, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//right front
#write (file,	"triangle {")
#write (file,		vtransform (<sx, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//top front
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//bottom front
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0+sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, 0, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0, -sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//left
#write (file,	"triangle {")
#write (file,		vtransform (<0, sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<0, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<0, sy-sx*0.05, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<0, sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<0, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<0, sy-sx*0.05, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")

	//right
#write (file,	"triangle {")
#write (file,		vtransform (<sx, sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx, sx*0.05, sz>, tr),cc)
#write (file,		vtransform (<sx, sy-sx*0.05, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx, sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx, sy-sx*0.05, -sz>, tr),cc)
#write (file,		vtransform (<sx, sy-sx*0.05, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//top
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sy, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, sy, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, sy, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, sy, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
	
	//bottom
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")
#write (file,	"triangle {")
#write (file,		vtransform (<sx*0.05, 0, -sz>, tr),cc)
#write (file,		vtransform (<sx*0.05, 0, sz>, tr),cc)
#write (file,		vtransform (<sx*0.95, 0, sz>, tr))
#write (file,		"texture {t_cardside}")
#write (file,	"}\n")

#end

//------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------

#macro chsec (bk, top, sc, tr)
	#local cardheight=sc*1.5;
	#local cardwidth=sc;
	#local mid=rto*sc;
	#local yy=sqrt(pow(cardheight,2)-pow(mid,2));
	card (int(RRand(0, 3, sd)), int(RRand(0, 12, sd)), bk, sc,
		transform {
			translate <-sc/2, 0, 0>
			rotate y*(90+int(RRand(0.5, 1.5, sd))*180)
			rotate z*-asind(mid/cardheight)
			transform {tr}
		}
	)
	card (int(RRand(0, 3, sd)), int(RRand(0, 12, sd)), bk, sc,
		transform {
			translate <-sc/2, 0, 0>
			rotate y*(90+int(RRand(0.5, 1.5, sd))*180)
			rotate z*asind(mid/cardheight)
			translate x*mid*2
			transform {tr}
		}
	)
	#if (top)
		card (int(RRand(0, 3, sd)), int(RRand(0, 12, sd)), bk, sc,
			transform {
				translate <-sc/2, -sc*1.5/2, 0>
				rotate x*(88+int(RRand(0.5, 1.5, sd))*180)
				rotate y*90
				translate <mid*2, yy+(0.01*sc), 0>
				transform {tr}
			}
		)
	#end
#end

//------------------------------------------------------------------------------------

#macro cardhouse(bk, length, height, sc, tr)
	#local mid=sc*rto;
	#local ch=sc*1.5;
	#local yy=sqrt(pow(ch,2)-pow(mid,2));
	#local h=0;
	#while (h<height)
		#local l=h;
		#while (l<length-1)
			chsec(bk, yes, sc,
				transform {
					translate <l*mid*2-h*mid-length*sc*rto, h*yy, 0>
					transform {tr}
				}
			)
			#local l=l+1;
		#end
		chsec(bk, no, sc,
			transform {
				translate <l*mid*2-h*mid-length*sc*rto, h*yy, 0>
				transform {tr}
			}
		)
		#local h=h+1;
	#end
#end

//------------------------------------------------------------------------------------

#macro cardring(bk, rad, ang, sc, tr)
	#local c=0;
	#while (c<360)
		chsec (bk, yes, sc, transform {translate z*rad rotate y*c transform {tr}})
		#local c=c+ang;
	#end
#end

//------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------

#debug "opening file\n"
#fopen file "cardmesh1.inc" write	//change filename here with full path

// card house objects go here

	//cardhouse(0, 7, 7, 0.08, transform{})
	cardhouse(0, 12, 12, 0.08, transform{})
	cardhouse(0, 9, 9, 0.08, transform{translate z*-0.15})
	cardhouse(0, 9, 9, 0.08, transform{translate z*0.15})
	cardhouse(0, 6, 6, 0.08, transform{translate z*-0.3})
	cardhouse(0, 6, 6, 0.08, transform{translate z*0.3})
	cardhouse(0, 3, 3, 0.08, transform{translate z*-0.45})
	cardhouse(0, 3, 3, 0.08, transform{translate z*0.45})
	cardring(0, 0.8, 8, 0.08, transform{})
	cardring(0, 0.8, 8, 0.08, transform{translate y*sqrt(pow(0.12,2)-pow(0.05,2)) rotate y*45})
	cardring(0, 0.8, 8, 0.08, transform{translate y*sqrt(pow(0.12,2)-pow(0.05,2))*2 rotate y*22.5})
	cardring(0, 1, 6, 0.08, transform{})
	cardring(0, 1, 6, 0.08, transform{translate y*sqrt(pow(0.12,2)-pow(0.05,2))})
	cardhouse(0, 3, 3, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*2, 1>})
	cardhouse(0, 3, 3, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*2, 1> rotate y*90})
	cardhouse(0, 3, 3, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*2, 1> rotate y*180})
	cardhouse(0, 3, 3, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*2, 1> rotate y*270})
	chsec (0, no, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*3, 0.8> rotate y*45})
	chsec (0, no, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*3, 0.8> rotate y*135})
	chsec (0, no, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*3, 0.8> rotate y*-45})
	chsec (0, no, 0.08, transform{translate <0, sqrt(pow(0.12,2)-pow(0.05,2))*3, 0.8> rotate y*-135})

#debug "closing file\n"
#fclose file
